/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var a={};return a.typeOf={},a.defined=function(n,a){if(!e(a))throw new t(r(n))},a.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},a.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},a.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},a.typeOf.number.lessThan=function(e,r,n){if(a.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},a.typeOf.number.lessThanOrEquals=function(e,r,n){if(a.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},a.typeOf.number.greaterThan=function(e,r,n){if(a.typeOf.number(e,r),r<=n)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},a.typeOf.number.greaterThanOrEquals=function(e,r,n){if(a.typeOf.number(e,r),r<n)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},a.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},a.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},a}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:e<0?-1:0},a.signNotZero=function(e){return e<0?-1:1},a.toSNorm=function(e,r){return r=t(r,255),Math.round((.5*a.clamp(e,-1,1)+.5)*r)},a.fromSNorm=function(e,r){return r=t(r,255),a.clamp(e,0,r)/r*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},a.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){if(!r(e))throw new n("degrees is required.");return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){if(!r(e))throw new n("radians is required.");return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){if(!r(e))throw new n("angle is required.");var t=a.TWO_PI,i=e-Math.floor(e/t)*t;return i<-Math.PI?i+t:i>=Math.PI?i-t:i},a.clampToLatitudeRange=function(e){if(!r(e))throw new n("angle is required.");return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){if(!r(e))throw new n("angle is required.");return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){if(!r(e))throw new n("angle is required.");var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){if(!r(e))throw new n("m is required.");if(!r(t))throw new n("n is required.");return(e%t+t)%t},a.equalsEpsilon=function(e,a,i,o){if(!r(e))throw new n("left is required.");if(!r(a))throw new n("right is required.");if(!r(i))throw new n("relativeEpsilon is required.");o=t(o,i);var u=Math.abs(e-a);return u<=o||u<=i*Math.max(Math.abs(e),Math.abs(a))};var i=[1];a.factorial=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");var t=i.length;if(e>=t)for(var r=i[t-1],a=t;a<=e;a++)i.push(r*a);return i[e]},a.incrementWrap=function(e,a,i){if(i=t(i,0),!r(e))throw new n("n is required.");if(a<=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>a&&(e=i),e},a.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,a){if(!r(e))throw new n("value is required");if(!r(t))throw new n("min is required.");if(!r(a))throw new n("max is required.");return e<t?t:e>a?a:e};var o=new e;return a.setRandomNumberSeed=function(t){if(!r(t))throw new n("seed is required.");o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){if(!r(e))throw new n("value is required.");return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){if(!r(e))throw new n("value is required.");return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){if(!r(e))throw new n("angle is required.");if(!r(t))throw new n("radius is required.");return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){if(!r(e))throw new n("number is required.");if(!r(t))throw new n("base is required.");return Math.log(e)/Math.log(t)},a.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,a){e.typeOf.object("spherical",n),r(a)||(a=new o);var i=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return a.x=c*Math.cos(i),a.y=c*Math.sin(i),a.z=s*Math.cos(u),a},o.fromElements=function(e,t,n,a){return r(a)?(a.x=e,a.y=t,a.z=n,a):new o(e,t,n)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,a){return e.typeOf.object("value",r),e.defined("array",n),a=t(a,0),n[a++]=r.x,n[a++]=r.y,n[a]=r.z,n},o.unpack=function(n,a,i){return e.defined("array",n),a=t(a,0),r(i)||(i=new o),i.x=n[a++],i.y=n[a++],i.z=n[a],i},o.packArray=function(t,n){e.defined("array",t);var a=t.length;r(n)?n.length=3*a:n=new Array(3*a);for(var i=0;i<a;++i)o.pack(t[i],n,3*i);return n},o.unpackArray=function(t,a){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var i=t.length;r(a)?a.length=i/3:a=new Array(i/3);for(var u=0;u<i;u+=3){var s=u/3;a[s]=o.unpack(t,u,a[s])}return a},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var a=o.magnitude(t);if(r.x=t.x/a,r.y=t.y/a,r.z=t.z/a,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(e,t,a){if(!r(e))throw new n("left is required");if(!r(t))throw new n("right is required");if(!r(a))throw new n("result is required");return a.x=e.x/t.x,a.y=e.y/t.y,a.z=e.z/t.z,a},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,a){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",a),o.multiplyByScalar(r,n,s),a=o.multiplyByScalar(t,1-n,a),o.add(s,a,a)};var c=new o,E=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,E);var n=o.dot(c,E),a=o.magnitude(o.cross(c,E,c));return Math.atan2(a,n)};var f=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var a=t.x,i=t.y,o=t.z,u=r.x,s=r.y,c=r.z,E=i*c-o*s,f=o*u-a*c,l=a*s-i*u;return n.x=E,n.y=f,n.z=l,n},o.fromDegrees=function(t,r,n,a,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=i.toRadians(t),r=i.toRadians(r),o.fromRadians(t,r,n,a,u)};var l=new o,_=new o,O=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,a,i,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",a),i=t(i,0);var c=r(u)?u.radiiSquared:O,E=Math.cos(a);l.x=E*Math.cos(n),l.y=E*Math.sin(n),l.z=Math.sin(a),l=o.normalize(l,l),o.multiplyComponents(c,l,_);var f=Math.sqrt(o.dot(l,_));return _=o.divideByScalar(_,f,_),l=o.multiplyByScalar(l,i,l),r(s)||(s=new o),o.add(_,l,s)},o.fromDegreesArray=function(t,a,i){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(i)?i.length=u/2:i=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],E=t[s+1],f=s/2;i[f]=o.fromDegrees(c,E,0,a,i[f])}return i},o.fromRadiansArray=function(t,a,i){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(i)?i.length=u/2:i=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],E=t[s+1],f=s/2;i[f]=o.fromRadians(c,E,0,a,i[f])}return i},o.fromDegreesArrayHeights=function(t,a,i){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(i)?i.length=u/3:i=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],E=t[s+1],f=t[s+2],l=s/3;i[l]=o.fromDegrees(c,E,f,a,i[l])}return i},o.fromRadiansArrayHeights=function(t,a,i){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(i)?i.length=u/3:i=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],E=t[s+1],f=t[s+2],l=s/3;i[l]=o.fromRadians(c,E,f,a,i[l])}return i},o.ZERO=a(new o(0,0,0)),o.UNIT_X=a(new o(1,0,0)),o.UNIT_Y=a(new o(0,1,0)),o.UNIT_Z=a(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function a(a,u,s,c,E){if(!t(a))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var f=a.x,l=a.y,_=a.z,O=u.x,y=u.y,T=u.z,p=f*f*O*O,h=l*l*y*y,R=_*_*T*T,d=p+h+R,A=Math.sqrt(1/d),m=e.multiplyByScalar(a,A,i);if(d<c)return isFinite(A)?e.clone(m,E):void 0;var N=s.x,I=s.y,S=s.z,b=o;b.x=m.x*N*2,b.y=m.y*I*2,b.z=m.z*S*2;var M,w,g,C,U,x,L,P,v,F,D,B=(1-A)*e.magnitude(a)/(.5*e.magnitude(b)),j=0;do{B-=j,g=1/(1+B*N),C=1/(1+B*I),U=1/(1+B*S),x=g*g,L=C*C,P=U*U,v=x*g,F=L*C,D=P*U,M=p*x+h*L+R*P-1,w=p*v*N+h*F*I+R*D*S;var z=-2*w;j=M/z}while(Math.abs(M)>n.EPSILON12);return t(E)?(E.x=f*g,E.y=l*C,E.z=_*U,E):new e(f*g,l*C,_*U)}var i=new e,o=new e;return a}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o){"use strict";function u(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)}u.fromRadians=function(e,a,i,o){if(!r(e))throw new n("longitude is required.");if(!r(a))throw new n("latitude is required.");return i=t(i,0),r(o)?(o.longitude=e,o.latitude=a,o.height=i,o):new u(e,a,i)},u.fromDegrees=function(e,t,a,o){if(!r(e))throw new n("longitude is required.");if(!r(t))throw new n("latitude is required.");return e=i.toRadians(e),t=i.toRadians(t),u.fromRadians(e,t,a,o)};var s=new e,c=new e,E=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),l=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),_=i.EPSILON1;return u.fromCartesian=function(t,n,a){var O=r(n)?n.oneOverRadii:f,y=r(n)?n.oneOverRadiiSquared:l,T=r(n)?n._centerToleranceSquared:_,p=o(t,O,y,T,c);if(r(p)){var h=e.multiplyComponents(p,y,s);h=e.normalize(h,h);var R=e.subtract(t,p,E),d=Math.atan2(h.y,h.x),A=Math.asin(h.z),m=i.sign(e.dot(R,t))*e.magnitude(R);return r(a)?(a.longitude=d,a.latitude=A,a.height=m,a):new u(d,A,m)}},u.clone=function(e,t){if(r(e))return r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,a){if("number"!=typeof a)throw new n("epsilon is required and must be a number.");return e===t||r(e)&&r(t)&&Math.abs(e.longitude-t.longitude)<=a&&Math.abs(e.latitude-t.latitude)<=a&&Math.abs(e.height-t.height)<=a},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o,u,s){"use strict";function c(t,n,a,o){if(n=r(n,0),a=r(a,0),o=r(o,0),n<0||a<0||o<0)throw new i("All radii components must be greater than or equal to zero.");t._radii=new e(n,a,o),t._radiiSquared=new e(n*n,a*a,o*o),t._radiiToTheFourth=new e(n*n*n*n,a*a*a*a,o*o*o*o),t._oneOverRadii=new e(0===n?0:1/n,0===a?0:1/a,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===a?0:1/(a*a),0===o?0:1/(o*o)),t._minimumRadius=Math.min(n,a,o),t._maximumRadius=Math.max(n,a,o),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._sqauredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function E(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._sqauredXOverSquaredZ=void 0,c(this,e,t,r)}a(E.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),E.clone=function(t,r){if(n(t)){var a=t._radii;return n(r)?(e.clone(a,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new E(a.x,a.y,a.z)}},E.fromCartesian3=function(e,t){return n(t)||(t=new E),n(e)?(c(t,e.x,e.y,e.z),t):t},E.WGS84=o(new E(6378137,6378137,6356752.314245179)),E.UNIT_SPHERE=o(new E(1,1,1)),E.MOON=o(new E(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),E.prototype.clone=function(e){return E.clone(this,e)},E.packedLength=e.packedLength,E.pack=function(t,a,o){if(!n(t))throw new i("value is required");if(!n(a))throw new i("array is required");return o=r(o,0),e.pack(t._radii,a,o),a},E.unpack=function(t,a,o){if(!n(t))throw new i("array is required");a=r(a,0);var u=e.unpack(t,a);return E.fromCartesian3(u,o)},E.prototype.geocentricSurfaceNormal=e.normalize,E.prototype.geodeticSurfaceNormalCartographic=function(t,r){if(!n(t))throw new i("cartographic is required.");var a=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(a),c=u*Math.sin(a),E=Math.sin(o);return n(r)||(r=new e),r.x=s,r.y=c,r.z=E,e.normalize(r,r)},E.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var f=new e,l=new e;E.prototype.cartographicToCartesian=function(t,r){var a=f,i=l;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),n(r)||(r=new e),e.add(i,a,r)},E.prototype.cartographicArrayToCartesianArray=function(e,t){if(!n(e))throw new i("cartographics is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;a<r;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var _=new e,O=new e,y=new e;return E.prototype.cartesianToCartographic=function(r,a){var i=this.scaleToGeodeticSurface(r,O);if(n(i)){var o=this.geodeticSurfaceNormal(i,_),s=e.subtract(r,i,y),c=Math.atan2(o.y,o.x),E=Math.asin(o.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return n(a)?(a.longitude=c,a.latitude=E,a.height=f,a):new t(c,E,f)}},E.prototype.cartesianArrayToCartographicArray=function(e,t){if(!n(e))throw new i("cartesians is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;a<r;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},E.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},E.prototype.scaleToGeocentricSurface=function(t,r){if(!n(t))throw new i("cartesian is required.");n(r)||(r=new e);var a=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(a*a*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,r)},E.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},E.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},E.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},E.prototype.toString=function(){return this._radii.toString()},E.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,o){if(!n(t))throw new i("position is required.");if(!u.equalsEpsilon(this._radii.x,this._radii.y,u.EPSILON15))throw new i("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");if(0===this._radii.z)throw new i("Ellipsoid.radii.z must be greater than 0");a=r(a,0);var s=this._sqauredXOverSquaredZ;if(n(o)||(o=new e),o.x=0,o.y=0,o.z=t.z*(1-s),!(Math.abs(o.z)>=this._radii.z-a))return o},E}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,a,i,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new i("cartesian is required");var a=this._oneOverSemimajorAxis,o=e.x*a,u=e.y*a,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,t,n,a,i,o,u,s,c){this[0]=r(e,0),this[1]=r(a,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(i,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function E(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(y[r],O[r])];t+=2*n*n}return Math.sqrt(t)}function f(e,t){for(var r=u.EPSILON15,n=0,a=1,i=0;i<3;++i){var o=Math.abs(e[s.getElementIndex(y[i],O[i])]);o>n&&(a=i,n=o)}var c=1,E=0,f=O[a],l=y[a];if(Math.abs(e[s.getElementIndex(l,f)])>r){var _,T=e[s.getElementIndex(l,l)],p=e[s.getElementIndex(f,f)],h=e[s.getElementIndex(l,f)],R=(T-p)/2/h;_=R<0?-1/(-R+Math.sqrt(1+R*R)):1/(R+Math.sqrt(1+R*R)),c=1/Math.sqrt(1+_*_),E=_*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(f,f)]=t[s.getElementIndex(l,l)]=c,t[s.getElementIndex(l,f)]=E,t[s.getElementIndex(f,l)]=-E,t}s.packedLength=9,s.pack=function(e,n,a){return t.typeOf.object("value",e),t.defined("array",n),a=r(a,0),n[a++]=e[0],n[a++]=e[1],n[a++]=e[2],n[a++]=e[3],n[a++]=e[4],n[a++]=e[5],n[a++]=e[6],n[a++]=e[7],n[a++]=e[8],n},s.unpack=function(e,a,i){return t.defined("array",e),a=r(a,0),n(i)||(i=new s),i[0]=e[a++],i[1]=e[a++],i[2]=e[a++],i[3]=e[a++],i[4]=e[a++],i[5]=e[a++],i[6]=e[a++],i[7]=e[a++],i[8]=e[a++],i},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,a,i){return t.defined("array",e),a=r(a,0),n(i)||(i=new s),i[0]=e[a],i[1]=e[a+1],i[2]=e[a+2],i[3]=e[a+3],i[4]=e[a+4],i[5]=e[a+5],i[6]=e[a+6],i[7]=e[a+7],i[8]=e[a+8],i},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var a=e.x*e.x,i=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,E=e.y*e.z,f=e.y*e.w,l=e.z*e.z,_=e.z*e.w,O=e.w*e.w,y=a-c-l+O,T=2*(i-_),p=2*(o+f),h=2*(i+_),R=-a+c-l+O,d=2*(E-u),A=2*(o-f),m=2*(E+u),N=-a-c+l+O;return n(r)?(r[0]=y,r[1]=h,r[2]=A,r[3]=T,r[4]=R,r[5]=m,r[6]=p,r[7]=d,r[8]=N,r):new s(y,T,p,h,R,d,A,m,N)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var a=Math.cos(-e.pitch),i=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),E=Math.sin(e.roll),f=a*i,l=-o*c+E*u*i,_=E*c+o*u*i,O=a*c,y=o*i+E*u*c,T=-u*o+o*u*c,p=-u,h=E*a,R=o*a;return n(r)?(r[0]=f,r[1]=O,r[2]=p,r[3]=l,r[4]=y,r[5]=h,r[6]=_,r[7]=T,r[8]=R,r):new s(f,l,_,O,y,T,p,h,R)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var a=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=a,r[5]=i,r[6]=0,r[7]=-i,r[8]=a,r):new s(1,0,0,0,a,-i,0,i,a)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var a=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=a,r[1]=0,r[2]=-i,r[3]=0,r[4]=1,r[5]=0,r[6]=i,r[7]=0,r[8]=a,r):new s(a,0,i,0,1,0,-i,0,a)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var a=Math.cos(e),i=Math.sin(e);return n(r)?(r[0]=a,r[1]=i,r[2]=0,r[3]=-i,r[4]=a,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(a,-i,0,i,a,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var a=3*r,i=e[a],o=e[a+1],u=e[a+2];return n.x=i,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,a){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",a),a=s.clone(e,a);var i=3*r;return a[i]=n.x,a[i+1]=n.y,a[i+2]=n.z,a},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var a=e[r],i=e[r+3],o=e[r+6];return n.x=a,n.y=i,n.z=o,n},s.setRow=function(e,r,n,a){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",a),a=s.clone(e,a),a[r]=n.x,a[r+3]=n.y,a[r+6]=n.z,a};var l=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),n};var _=new e;s.getMaximumScale=function(t){return s.getScale(t,_),e.maximumComponent(_)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],i=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],E=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],f=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],l=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=a,n[1]=i,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=E,n[7]=f,n[8]=l,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var a=r.x,i=r.y,o=r.z,u=e[0]*a+e[3]*i+e[6]*o,s=e[1]*a+e[4]*i+e[7]*o,c=e[2]*a+e[5]*i+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),
r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],a=e[3],i=e[6],o=e[1],u=e[4],s=e[7],c=e[2],E=e[5],f=e[8];return r[0]=n,r[1]=a,r[2]=i,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=E,r[8]=f,r};var O=[1,0,0],y=[2,2,1],T=new s,p=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var a=u.EPSILON20,i=10,o=0,l=0;n(r)||(r={});for(var _=r.unitary=s.clone(s.IDENTITY,r.unitary),O=r.diagonal=s.clone(e,r.diagonal),y=a*c(O);l<i&&E(O)>y;)f(O,T),s.transpose(T,p),s.multiply(O,T,O),s.multiply(p,O,O),s.multiply(_,T,_),++o>2&&(++l,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],E=e[8];return r*(o*E-c*u)+i*(c*a-n*E)+s*(n*u-o*a)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],a=e[1],o=e[2],c=e[3],E=e[4],f=e[5],l=e[6],_=e[7],O=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new i("matrix is not invertible");r[0]=E*O-_*f,r[1]=_*o-a*O,r[2]=a*f-E*o,r[3]=l*f-c*O,r[4]=n*O-l*o,r[5]=c*o-n*f,r[6]=c*_-l*E,r[7]=l*a-n*_,r[8]=n*E-c*a;var T=1/y;return s.multiplyByScalar(r,T,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,a){return t.typeOf.number("epsilon",a),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=a&&Math.abs(e[1]-r[1])<=a&&Math.abs(e[2]-r[2])<=a&&Math.abs(e[3]-r[3])<=a&&Math.abs(e[4]-r[4])<=a&&Math.abs(e[5]-r[5])<=a&&Math.abs(e[6]-r[6])<=a&&Math.abs(e[7]-r[7])<=a&&Math.abs(e[8]-r[8])<=a},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,a(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r,n,a){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(a,0)}o.fromElements=function(e,t,n,a,i){return r(i)?(i.x=e,i.y=t,i.z=n,i.w=a,i):new o(e,t,n,a)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(r,n,a){return e.typeOf.object("value",r),e.defined("array",n),a=t(a,0),n[a++]=r.x,n[a++]=r.y,n[a++]=r.z,n[a]=r.w,n},o.unpack=function(n,a,i){return e.defined("array",n),a=t(a,0),r(i)||(i=new o),i.x=n[a++],i.y=n[a++],i.z=n[a++],i.w=n[a],i},o.packArray=function(t,n){e.defined("array",t);var a=t.length;r(n)?n.length=4*a:n=new Array(4*a);for(var i=0;i<a;++i)o.pack(t[i],n,4*i);return n},o.unpackArray=function(t,n){e.defined("array",t);var a=t.length;r(n)?n.length=a/4:n=new Array(a/4);for(var i=0;i<a;i+=4){var u=i/4;n[u]=o.unpack(t,i,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var a=o.magnitude(t);if(r.x=t.x/a,r.y=t.y/a,r.z=t.z/a,r.w=t.w/a,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,a){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",a),o.multiplyByScalar(r,n,s),a=o.multiplyByScalar(t,1-n,a),o.add(s,a,a)};var c=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)&&i.equalsEpsilon(e.w,t.w,n,a)},o.ZERO=a(new o(0,0,0,0)),o.UNIT_X=a(new o(1,0,0,0)),o.UNIT_Y=a(new o(0,1,0,0)),o.UNIT_Z=a(new o(0,0,1,0)),o.UNIT_W=a(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,a,i,o,u,s,c){"use strict";function E(e,t,r,a,i,o,u,s,c,E,f,l,_,O,y,T){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(_,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(E,0),this[7]=n(O,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(y,0),this[12]=n(a,0),this[13]=n(s,0),this[14]=n(l,0),this[15]=n(T,0)}E.packedLength=16,E.pack=function(e,t,a){return r.typeOf.object("value",e),r.defined("array",t),a=n(a,0),t[a++]=e[0],t[a++]=e[1],t[a++]=e[2],t[a++]=e[3],t[a++]=e[4],t[a++]=e[5],t[a++]=e[6],t[a++]=e[7],t[a++]=e[8],t[a++]=e[9],t[a++]=e[10],t[a++]=e[11],t[a++]=e[12],t[a++]=e[13],t[a++]=e[14],t[a]=e[15],t},E.unpack=function(e,t,i){return r.defined("array",e),t=n(t,0),a(i)||(i=new E),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i[9]=e[t++],i[10]=e[t++],i[11]=e[t++],i[12]=e[t++],i[13]=e[t++],i[14]=e[t++],i[15]=e[t],i},E.clone=function(e,t){if(a(e))return a(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new E(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},E.fromArray=E.unpack,E.fromColumnMajorArray=function(e,t){return r.defined("values",e),E.clone(e,t)},E.fromRowMajorArray=function(e,t){return r.defined("values",e),a(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new E(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},E.fromRotationTranslation=function(t,i,o){return r.typeOf.object("rotation",t),i=n(i,e.ZERO),a(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=i.x,o[13]=i.y,o[14]=i.z,o[15]=1,o):new E(t[0],t[3],t[6],i.x,t[1],t[4],t[7],i.y,t[2],t[5],t[8],i.z,0,0,0,1)},E.fromTranslationQuaternionRotationScale=function(e,t,n,i){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),a(i)||(i=new E);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,f=t.x*t.y,l=t.x*t.z,_=t.x*t.w,O=t.y*t.y,y=t.y*t.z,T=t.y*t.w,p=t.z*t.z,h=t.z*t.w,R=t.w*t.w,d=c-O-p+R,A=2*(f-h),m=2*(l+T),N=2*(f+h),I=-c+O-p+R,S=2*(y-_),b=2*(l-T),M=2*(y+_),w=-c-O+p+R;return i[0]=d*o,i[1]=N*o,i[2]=b*o,i[3]=0,i[4]=A*u,i[5]=I*u,i[6]=M*u,i[7]=0,i[8]=m*s,i[9]=S*s,i[10]=w*s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i},E.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),E.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},E.fromTranslation=function(e,t){return r.typeOf.object("translation",e),E.fromRotationTranslation(s.IDENTITY,e,t)},E.fromScale=function(e,t){return r.typeOf.object("scale",e),a(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new E(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},E.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),a(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new E(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,l=new e,_=new e;E.fromCamera=function(t,n){r.typeOf.object("camera",t);var i=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",i),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,f),e.normalize(e.cross(f,u,l),l),e.normalize(e.cross(l,f,_),_);var s=l.x,c=l.y,O=l.z,y=f.x,T=f.y,p=f.z,h=_.x,R=_.y,d=_.z,A=i.x,m=i.y,N=i.z,I=s*-A+c*-m+O*-N,S=h*-A+R*-m+d*-N,b=y*A+T*m+p*N;return a(n)?(n[0]=s,n[1]=h,n[2]=-y,n[3]=0,n[4]=c,n[5]=R,n[6]=-T,n[7]=0,n[8]=O,n[9]=d,n[10]=-p,n[11]=0,n[12]=I,n[13]=S,n[14]=b,n[15]=1,n):new E(s,c,O,I,h,R,d,S,-y,-T,-p,b,0,0,0,1)},E.computePerspectiveFieldOfView=function(e,t,n,a,i){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",a,0),r.typeOf.object("result",i);var o=Math.tan(.5*e),u=1/o,s=u/t,c=(a+n)/(n-a),E=2*a*n/(n-a);return i[0]=s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=c,i[11]=-1,i[12]=0,i[13]=0,i[14]=E,i[15]=0,i},E.computeOrthographicOffCenter=function(e,t,n,a,i,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",a),r.typeOf.number("near",i),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(a-n),E=1/(o-i),f=-(t+e)*s,l=-(a+n)*c,_=-(o+i)*E;return s*=2,c*=2,E*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=E,u[11]=0,u[12]=f,u[13]=l,u[14]=_,u[15]=1,u},E.computePerspectiveOffCenter=function(e,t,n,a,i,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",a),r.typeOf.number("near",i),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*i/(t-e),c=2*i/(a-n),E=(t+e)/(t-e),f=(a+n)/(a-n),l=-(o+i)/(o-i),_=-1,O=-2*o*i/(o-i);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=E,u[9]=f,u[10]=l,u[11]=_,u[12]=0,u[13]=0,u[14]=O,u[15]=0,u},E.computeInfinitePerspectiveOffCenter=function(e,t,n,a,i,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",a),r.typeOf.number("near",i),r.typeOf.object("result",o);var u=2*i/(t-e),s=2*i/(a-n),c=(t+e)/(t-e),E=(a+n)/(a-n),f=-1,l=-1,_=-2*i;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=E,o[10]=f,o[11]=l,o[12]=0,o[13]=0,o[14]=_,o[15]=0,o},E.computeViewportTransformation=function(e,t,a,i){r.typeOf.object("result",i),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),a=n(a,1);var E=.5*s,f=.5*c,l=.5*(a-t),_=E,O=f,y=l,T=o+E,p=u+f,h=t+l,R=1;return i[0]=_,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=O,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=y,i[11]=0,i[12]=T,i[13]=p,i[14]=h,i[15]=R,i},E.computeView=function(t,n,a,i,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",a),r.typeOf.object("right",i),r.typeOf.object("result",o),o[0]=i.x,o[1]=a.x,o[2]=-n.x,o[3]=0,o[4]=i.y,o[5]=a.y,o[6]=-n.y,o[7]=0,o[8]=i.z,o[9]=a.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(i,t),o[13]=-e.dot(a,t),o[14]=e.dot(n,t),o[15]=1,o},E.toArray=function(e,t){return r.typeOf.object("matrix",e),a(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},E.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},E.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var a=4*t,i=e[a],o=e[a+1],u=e[a+2],s=e[a+3];return n.x=i,n.y=o,n.z=u,n.w=s,n},E.setColumn=function(e,t,n,a){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",a),a=E.clone(e,a);var i=4*t;return a[i]=n.x,a[i+1]=n.y,a[i+2]=n.z,a[i+3]=n.w,a},E.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},E.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var a=e[t],i=e[t+4],o=e[t+8],u=e[t+12];return n.x=a,n.y=i,n.z=o,n.w=u,n},E.setRow=function(e,t,n,a){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",a),a=E.clone(e,a),a[t]=n.x,a[t+4]=n.y,a[t+8]=n.z,a[t+12]=n.w,a};var O=new e;E.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],O)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],O)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],O)),n};var y=new e;E.getMaximumScale=function(t){return E.getScale(t,y),e.maximumComponent(y)},E.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var a=e[0],i=e[1],o=e[2],u=e[3],s=e[4],c=e[5],E=e[6],f=e[7],l=e[8],_=e[9],O=e[10],y=e[11],T=e[12],p=e[13],h=e[14],R=e[15],d=t[0],A=t[1],m=t[2],N=t[3],I=t[4],S=t[5],b=t[6],M=t[7],w=t[8],g=t[9],C=t[10],U=t[11],x=t[12],L=t[13],P=t[14],v=t[15],F=a*d+s*A+l*m+T*N,D=i*d+c*A+_*m+p*N,B=o*d+E*A+O*m+h*N,j=u*d+f*A+y*m+R*N,z=a*I+s*S+l*b+T*M,G=i*I+c*S+_*b+p*M,q=o*I+E*S+O*b+h*M,X=u*I+f*S+y*b+R*M,V=a*w+s*g+l*C+T*U,W=i*w+c*g+_*C+p*U,H=o*w+E*g+O*C+h*U,Y=u*w+f*g+y*C+R*U,k=a*x+s*L+l*P+T*v,K=i*x+c*L+_*P+p*v,Z=o*x+E*L+O*P+h*v,Q=u*x+f*L+y*P+R*v;return n[0]=F,n[1]=D,n[2]=B,n[3]=j,n[4]=z,n[5]=G,n[6]=q,n[7]=X,n[8]=V,n[9]=W,n[10]=H,n[11]=Y,n[12]=k,n[13]=K,n[14]=Z,n[15]=Q,n},E.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},E.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},E.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var a=e[0],i=e[1],o=e[2],u=e[4],s=e[5],c=e[6],E=e[8],f=e[9],l=e[10],_=e[12],O=e[13],y=e[14],T=t[0],p=t[1],h=t[2],R=t[4],d=t[5],A=t[6],m=t[8],N=t[9],I=t[10],S=t[12],b=t[13],M=t[14],w=a*T+u*p+E*h,g=i*T+s*p+f*h,C=o*T+c*p+l*h,U=a*R+u*d+E*A,x=i*R+s*d+f*A,L=o*R+c*d+l*A,P=a*m+u*N+E*I,v=i*m+s*N+f*I,F=o*m+c*N+l*I,D=a*S+u*b+E*M+_,B=i*S+s*b+f*M+O,j=o*S+c*b+l*M+y;return n[0]=w,n[1]=g,n[2]=C,n[3]=0,n[4]=U,n[5]=x,n[6]=L,n[7]=0,n[8]=P,n[9]=v,n[10]=F,n[11]=0,n[12]=D,n[13]=B,n[14]=j,n[15]=1,n},E.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var a=e[0],i=e[1],o=e[2],u=e[4],s=e[5],c=e[6],E=e[8],f=e[9],l=e[10],_=t[0],O=t[1],y=t[2],T=t[3],p=t[4],h=t[5],R=t[6],d=t[7],A=t[8],m=a*_+u*O+E*y,N=i*_+s*O+f*y,I=o*_+c*O+l*y,S=a*T+u*p+E*h,b=i*T+s*p+f*h,M=o*T+c*p+l*h,w=a*R+u*d+E*A,g=i*R+s*d+f*A,C=o*R+c*d+l*A;return n[0]=m,n[1]=N,n[2]=I,n[3]=0,n[4]=S,n[5]=b,n[6]=M,n[7]=0,n[8]=w,n[9]=g,n[10]=C,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},E.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var a=t.x,i=t.y,o=t.z,u=a*e[0]+i*e[4]+o*e[8]+e[12],s=a*e[1]+i*e[5]+o*e[9]+e[13],c=a*e[2]+i*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var T=new e;E.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),T.x=t,T.y=t,T.z=t,E.multiplyByScale(e,T,n)},E.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var a=t.x,i=t.y,o=t.z;return 1===a&&1===i&&1===o?E.clone(e,n):(n[0]=a*e[0],n[1]=a*e[1],n[2]=a*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},E.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var a=t.x,i=t.y,o=t.z,u=t.w,s=e[0]*a+e[4]*i+e[8]*o+e[12]*u,c=e[1]*a+e[5]*i+e[9]*o+e[13]*u,E=e[2]*a+e[6]*i+e[10]*o+e[14]*u,f=e[3]*a+e[7]*i+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=E,n.w=f,n},E.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var a=t.x,i=t.y,o=t.z,u=e[0]*a+e[4]*i+e[8]*o,s=e[1]*a+e[5]*i+e[9]*o,c=e[2]*a+e[6]*i+e[10]*o;return n.x=u,n.y=s,n.z=c,n},E.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var a=t.x,i=t.y,o=t.z,u=e[0]*a+e[4]*i+e[8]*o+e[12],s=e[1]*a+e[5]*i+e[9]*o+e[13],c=e[2]*a+e[6]*i+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},E.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},E.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},E.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],a=e[2],i=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=a,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=u,t[14]=s,t[15]=e[15],t},E.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},E.equals=function(e,t){return e===t||a(e)&&a(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},E.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||a(e)&&a(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},E.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},E.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var p=new s,h=new s,R=new t,d=new t(0,0,0,1);return E.inverse=function(e,n){if(r.typeOf.object("matrix",e),r.typeOf.object("result",n),s.equalsEpsilon(E.getRotation(e,p),h,u.EPSILON7)&&t.equals(E.getRow(e,3,R),d))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var a=e[0],i=e[4],o=e[8],f=e[12],l=e[1],_=e[5],O=e[9],y=e[13],T=e[2],A=e[6],m=e[10],N=e[14],I=e[3],S=e[7],b=e[11],M=e[15],w=m*M,g=N*b,C=A*M,U=N*S,x=A*b,L=m*S,P=T*M,v=N*I,F=T*b,D=m*I,B=T*S,j=A*I,z=w*_+U*O+x*y-(g*_+C*O+L*y),G=g*l+P*O+D*y-(w*l+v*O+F*y),q=C*l+v*_+B*y-(U*l+P*_+j*y),X=L*l+F*_+j*O-(x*l+D*_+B*O),V=g*i+C*o+L*f-(w*i+U*o+x*f),W=w*a+v*o+F*f-(g*a+P*o+D*f),H=U*a+P*i+j*f-(C*a+v*i+B*f),Y=x*a+D*i+B*o-(L*a+F*i+j*o);w=o*y,g=f*O,C=i*y,U=f*_,x=i*O,L=o*_,P=a*y,v=f*l,F=a*O,D=o*l,B=a*_,j=i*l;var k=w*S+U*b+x*M-(g*S+C*b+L*M),K=g*I+P*b+D*M-(w*I+v*b+F*M),Z=C*I+v*S+B*M-(U*I+P*S+j*M),Q=L*I+F*S+j*b-(x*I+D*S+B*b),J=C*m+L*N+g*A-(x*N+w*A+U*m),$=F*N+w*T+v*m-(P*m+D*N+g*T),ee=P*A+j*N+U*T-(B*N+C*T+v*A),te=B*m+x*T+D*A-(F*A+j*m+L*T),re=a*z+i*G+o*q+f*X;if(Math.abs(re)<u.EPSILON20)throw new c("matrix is not invertible because its determinate is zero.");return re=1/re,n[0]=z*re,n[1]=G*re,n[2]=q*re,n[3]=X*re,n[4]=V*re,n[5]=W*re,n[6]=H*re,n[7]=Y*re,n[8]=k*re,n[9]=K*re,n[10]=Z*re,n[11]=Q*re,n[12]=J*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},E.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],E=e[9],f=e[10],l=e[12],_=e[13],O=e[14],y=-n*l-a*_-i*O,T=-o*l-u*_-s*O,p=-c*l-E*_-f*O;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=a,t[5]=u,t[6]=E,t[7]=0,t[8]=i,t[9]=s,t[10]=f,t[11]=0,t[12]=y,t[13]=T,t[14]=p,t[15]=1,t},E.IDENTITY=o(new E(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),E.ZERO=o(new E(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN0ROW3=3,E.COLUMN1ROW0=4,E.COLUMN1ROW1=5,E.COLUMN1ROW2=6,E.COLUMN1ROW3=7,E.COLUMN2ROW0=8,E.COLUMN2ROW1=9,E.COLUMN2ROW2=10,E.COLUMN2ROW3=11,E.COLUMN3ROW0=12,E.COLUMN3ROW1=13,E.COLUMN3ROW2=14,E.COLUMN3ROW3=15,i(E.prototype,{length:{get:function(){return E.packedLength}}}),E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},E.prototype.equalsEpsilon=function(e,t){return E.equalsEpsilon(this,e,t)},E.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},E}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,t,n,a){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(a,0)}a(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,a){return t.typeOf.object("value",e),t.defined("array",n),a=r(a,0),n[a++]=e.west,n[a++]=e.south,n[a++]=e.east,n[a]=e.north,n},s.unpack=function(e,a,i){return t.defined("array",e),a=r(a,0),n(i)||(i=new s),i.west=e[a++],i.south=e[a++],i.east=e[a++],i.north=e[a],i},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,a,i,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),a=u.toRadians(r(a,0)),i=u.toRadians(r(i,0)),n(o)?(o.west=e,o.south=t,o.east=a,o.north=i,o):new s(e,t,a,i)},s.fromRadians=function(e,t,a,i,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(a,0),o.north=r(i,0),o):new s(e,t,a,i)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var a=Number.MAX_VALUE,i=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,E=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=0,_=e.length;l<_;l++){var O=e[l];a=Math.min(a,O.longitude),i=Math.max(i,O.longitude),E=Math.min(E,O.latitude),f=Math.max(f,O.latitude);var y=O.longitude>=0?O.longitude:O.longitude+u.TWO_PI;o=Math.min(o,y),c=Math.max(c,y)}return i-a>c-o&&(a=o,i=c,i>u.PI&&(i-=u.TWO_PI),a>u.PI&&(a-=u.TWO_PI)),n(r)?(r.west=a,r.south=E,r.east=i,r.north=f,r):new s(a,E,i,f)},s.fromCartesianArray=function(e,r,a){t.defined("cartesians",e);for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,E=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,_=0,O=e.length;_<O;_++){var y=r.cartesianToCartographic(e[_]);i=Math.min(i,y.longitude),o=Math.max(o,y.longitude),f=Math.min(f,y.latitude),l=Math.max(l,y.latitude);var T=y.longitude>=0?y.longitude:y.longitude+u.TWO_PI;c=Math.min(c,T),E=Math.max(E,T)}return o-i>E-c&&(i=c,o=E,o>u.PI&&(o-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(a)?(a.west=i,a.south=f,a.east=o,a.north=l,a):new s(i,f,o,l)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),n(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var a=e.west;t.typeOf.number.greaterThanOrEquals("west",a,-Math.PI),t.typeOf.number.lessThanOrEquals("west",a,Math.PI);var i=e.east;t.typeOf.number.greaterThanOrEquals("east",i,-Math.PI),t.typeOf.number.lessThanOrEquals("east",i,Math.PI)},s.southwest=function(r,a){return t.typeOf.object("rectangle",r),n(a)?(a.longitude=r.west,a.latitude=r.south,a.height=0,a):new e(r.west,r.south)},s.northwest=function(r,a){return t.typeOf.object("rectangle",r),n(a)?(a.longitude=r.west,a.latitude=r.north,a.height=0,a):new e(r.west,r.north)},s.northeast=function(r,a){return t.typeOf.object("rectangle",r),n(a)?(a.longitude=r.east,a.latitude=r.north,a.height=0,a):new e(r.east,r.north)},s.southeast=function(r,a){return t.typeOf.object("rectangle",r),n(a)?(a.longitude=r.east,a.latitude=r.south,a.height=0,a):new e(r.east,r.south)},s.center=function(r,a){t.typeOf.object("rectangle",r);var i=r.east,o=r.west;i<o&&(i+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+i)),c=.5*(r.south+r.north);return n(a)?(a.longitude=s,a.latitude=c,a.height=0,a):new e(s,c)},s.intersection=function(e,r,a){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=e.east,o=e.west,c=r.east,E=r.west;i<o&&c>0?i+=u.TWO_PI:c<E&&i>0&&(c+=u.TWO_PI),i<o&&E<0?E+=u.TWO_PI:c<E&&o<0&&(o+=u.TWO_PI);var f=u.negativePiToPi(Math.max(o,E)),l=u.negativePiToPi(Math.min(i,c));if(!((e.west<e.east||r.west<r.east)&&l<=f)){var _=Math.max(e.south,r.south),O=Math.min(e.north,r.north);if(!(_>=O))return n(a)?(a.west=f,a.south=_,a.east=l,a.north=O,a):new s(f,_,l,O)}},s.simpleIntersection=function(e,r,a){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var i=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(o>=c||i>=u))return n(a)?(a.west=i,
a.south=o,a.east=u,a.north=c,a):new s(i,o,u,c)},s.union=function(e,r,a){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(a)||(a=new s);var i=e.east,o=e.west,c=r.east,E=r.west;i<o&&c>0?i+=u.TWO_PI:c<E&&i>0&&(c+=u.TWO_PI),i<o&&E<0?E+=u.TWO_PI:c<E&&o<0&&(o+=u.TWO_PI);var f=u.convertLongitudeRange(Math.min(o,E)),l=u.convertLongitudeRange(Math.max(i,c));return a.west=f,a.south=Math.min(e.south,r.south),a.east=l,a.north=Math.max(e.north,r.north),a},s.expand=function(e,r,a){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(a)||(a=new s),a.west=Math.min(e.west,r.longitude),a.south=Math.min(e.south,r.latitude),a.east=Math.max(e.east,r.longitude),a.north=Math.max(e.north,r.latitude),a},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,a=r.latitude,i=e.west,o=e.east;return o<i&&(o+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>i||u.equalsEpsilon(n,i,u.EPSILON14))&&(n<o||u.equalsEpsilon(n,o,u.EPSILON14))&&a>=e.south&&a<=e.north};var c=new e;return s.subsample=function(e,a,o,E){t.typeOf.object("rectangle",e),a=r(a,i.WGS84),o=r(o,0),n(E)||(E=[]);var f=0,l=e.north,_=e.south,O=e.east,y=e.west,T=c;T.height=o,T.longitude=y,T.latitude=l,E[f]=a.cartographicToCartesian(T,E[f]),f++,T.longitude=O,E[f]=a.cartographicToCartesian(T,E[f]),f++,T.latitude=_,E[f]=a.cartographicToCartesian(T,E[f]),f++,T.longitude=y,E[f]=a.cartographicToCartesian(T,E[f]),f++,l<0?T.latitude=l:_>0?T.latitude=_:T.latitude=0;for(var p=1;p<8;++p)T.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,T)&&(E[f]=a.cartographicToCartesian(T,E[f]),f++);return 0===T.latitude&&(T.longitude=y,E[f]=a.cartographicToCartesian(T,E[f]),f++,T.longitude=O,E[f]=a.cartographicToCartesian(T,E[f]),f++),E.length=f,E},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,a,i,o,u,s,c,E,f){"use strict";function l(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var _=new e,O=new e,y=new e,T=new e,p=new e,h=new e,R=new e,d=new e,A=new e,m=new e,N=new e,I=new e;l.fromPoints=function(t,r){if(a(r)||(r=new l),!a(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var n=e.clone(t[0],R),i=e.clone(n,_),o=e.clone(n,O),u=e.clone(n,y),s=e.clone(n,T),c=e.clone(n,p),E=e.clone(n,h),f=t.length,S=1;S<f;S++){e.clone(t[S],n);var b=n.x,M=n.y,w=n.z;b<i.x&&e.clone(n,i),b>s.x&&e.clone(n,s),M<o.y&&e.clone(n,o),M>c.y&&e.clone(n,c),w<u.z&&e.clone(n,u),w>E.z&&e.clone(n,E)}var g=e.magnitudeSquared(e.subtract(s,i,d)),C=e.magnitudeSquared(e.subtract(c,o,d)),U=e.magnitudeSquared(e.subtract(E,u,d)),x=i,L=s,P=g;C>P&&(P=C,x=o,L=c),U>P&&(P=U,x=u,L=E);var v=A;v.x=.5*(x.x+L.x),v.y=.5*(x.y+L.y),v.z=.5*(x.z+L.z);var F=e.magnitudeSquared(e.subtract(L,v,d)),D=Math.sqrt(F),B=m;B.x=i.x,B.y=o.y,B.z=u.z;var j=N;j.x=s.x,j.y=c.y,j.z=E.z;var z=e.multiplyByScalar(e.add(B,j,d),.5,I),G=0;for(S=0;S<f;S++){e.clone(t[S],n);var q=e.magnitude(e.subtract(n,z,d));q>G&&(G=q);var X=e.magnitudeSquared(e.subtract(n,v,d));if(X>F){var V=Math.sqrt(X);D=.5*(D+V),F=D*D;var W=V-D;v.x=(D*v.x+W*n.x)/V,v.y=(D*v.y+W*n.y)/V,v.z=(D*v.z+W*n.z)/V}}return D<G?(e.clone(v,r.center),r.radius=D):(e.clone(z,r.center),r.radius=G),r};var S=new o,b=new e,M=new e,w=new t,g=new t;l.fromRectangle2D=function(e,t,r){return l.fromRectangleWithHeights2D(e,t,0,0,r)},l.fromRectangleWithHeights2D=function(t,r,i,o,u){if(a(u)||(u=new l),!a(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,S),f.southwest(t,w),w.height=i,f.northeast(t,g),g.height=o;var s=r.project(w,b),c=r.project(g,M),E=c.x-s.x,_=c.y-s.y,O=c.z-s.z;u.radius=.5*Math.sqrt(E*E+_*_+O*O);var y=u.center;return y.x=s.x+.5*E,y.y=s.y+.5*_,y.z=s.z+.5*O,u};var C=[];l.fromRectangle3D=function(e,t,r,o){t=n(t,i.WGS84),r=n(r,0);var u;return a(e)&&(u=f.subsample(e,t,r,C)),l.fromPoints(u,o)},l.fromVertices=function(t,i,o,u){if(a(u)||(u=new l),!a(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=n(i,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=R;s.x=t[0]+i.x,s.y=t[1]+i.y,s.z=t[2]+i.z;for(var c=e.clone(s,_),E=e.clone(s,O),f=e.clone(s,y),S=e.clone(s,T),b=e.clone(s,p),M=e.clone(s,h),w=t.length,g=0;g<w;g+=o){var C=t[g]+i.x,U=t[g+1]+i.y,x=t[g+2]+i.z;s.x=C,s.y=U,s.z=x,C<c.x&&e.clone(s,c),C>S.x&&e.clone(s,S),U<E.y&&e.clone(s,E),U>b.y&&e.clone(s,b),x<f.z&&e.clone(s,f),x>M.z&&e.clone(s,M)}var L=e.magnitudeSquared(e.subtract(S,c,d)),P=e.magnitudeSquared(e.subtract(b,E,d)),v=e.magnitudeSquared(e.subtract(M,f,d)),F=c,D=S,B=L;P>B&&(B=P,F=E,D=b),v>B&&(B=v,F=f,D=M);var j=A;j.x=.5*(F.x+D.x),j.y=.5*(F.y+D.y),j.z=.5*(F.z+D.z);var z=e.magnitudeSquared(e.subtract(D,j,d)),G=Math.sqrt(z),q=m;q.x=c.x,q.y=E.y,q.z=f.z;var X=N;X.x=S.x,X.y=b.y,X.z=M.z;var V=e.multiplyByScalar(e.add(q,X,d),.5,I),W=0;for(g=0;g<w;g+=o){s.x=t[g]+i.x,s.y=t[g+1]+i.y,s.z=t[g+2]+i.z;var H=e.magnitude(e.subtract(s,V,d));H>W&&(W=H);var Y=e.magnitudeSquared(e.subtract(s,j,d));if(Y>z){var k=Math.sqrt(Y);G=.5*(G+k),z=G*G;var K=k-G;j.x=(G*j.x+K*s.x)/k,j.y=(G*j.y+K*s.y)/k,j.z=(G*j.z+K*s.z)/k}}return G<W?(e.clone(j,u.center),u.radius=G):(e.clone(V,u.center),u.radius=W),u},l.fromEncodedCartesianVertices=function(t,r,n){if(a(n)||(n=new l),!a(t)||!a(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=R;i.x=t[0]+r[0],i.y=t[1]+r[1],i.z=t[2]+r[2];for(var o=e.clone(i,_),u=e.clone(i,O),s=e.clone(i,y),c=e.clone(i,T),E=e.clone(i,p),f=e.clone(i,h),S=t.length,b=0;b<S;b+=3){var M=t[b]+r[b],w=t[b+1]+r[b+1],g=t[b+2]+r[b+2];i.x=M,i.y=w,i.z=g,M<o.x&&e.clone(i,o),M>c.x&&e.clone(i,c),w<u.y&&e.clone(i,u),w>E.y&&e.clone(i,E),g<s.z&&e.clone(i,s),g>f.z&&e.clone(i,f)}var C=e.magnitudeSquared(e.subtract(c,o,d)),U=e.magnitudeSquared(e.subtract(E,u,d)),x=e.magnitudeSquared(e.subtract(f,s,d)),L=o,P=c,v=C;U>v&&(v=U,L=u,P=E),x>v&&(v=x,L=s,P=f);var F=A;F.x=.5*(L.x+P.x),F.y=.5*(L.y+P.y),F.z=.5*(L.z+P.z);var D=e.magnitudeSquared(e.subtract(P,F,d)),B=Math.sqrt(D),j=m;j.x=o.x,j.y=u.y,j.z=s.z;var z=N;z.x=c.x,z.y=E.y,z.z=f.z;var G=e.multiplyByScalar(e.add(j,z,d),.5,I),q=0;for(b=0;b<S;b+=3){i.x=t[b]+r[b],i.y=t[b+1]+r[b+1],i.z=t[b+2]+r[b+2];var X=e.magnitude(e.subtract(i,G,d));X>q&&(q=X);var V=e.magnitudeSquared(e.subtract(i,F,d));if(V>D){var W=Math.sqrt(V);B=.5*(B+W),D=B*B;var H=W-B;F.x=(B*F.x+H*i.x)/W,F.y=(B*F.y+H*i.y)/W,F.z=(B*F.z+H*i.z)/W}}return B<q?(e.clone(F,n.center),n.radius=B):(e.clone(G,n.center),n.radius=q),n},l.fromCornerPoints=function(t,n,i){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),a(i)||(i=new l);var o=i.center;return e.add(t,n,o),e.multiplyByScalar(o,.5,o),i.radius=e.distance(o,n),i},l.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),a(n)||(n=new l),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var U=new e;l.fromBoundingSpheres=function(t,r){if(a(r)||(r=new l),!a(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return l.clone(t[0],r);if(2===n)return l.union(t[0],t[1],r);for(var i=[],o=0;o<n;o++)i.push(t[o].center);r=l.fromPoints(i,r);var u=r.center,s=r.radius;for(o=0;o<n;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,U)+c.radius)}return r.radius=s,r};var x=new e,L=new e,P=new e;l.fromOrientedBoundingBox=function(t,r){a(r)||(r=new l);var n=t.halfAxes,i=c.getColumn(n,0,x),o=c.getColumn(n,1,L),u=c.getColumn(n,2,P),s=e.magnitude(i),E=e.magnitude(o),f=e.magnitude(u);return r.center=e.clone(t.center,r.center),r.radius=Math.max(s,E,f),r},l.clone=function(t,r){if(a(t))return a(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new l(t.center,t.radius)},l.packedLength=4,l.pack=function(e,t,a){r.typeOf.object("value",e),r.defined("array",t),a=n(a,0);var i=e.center;return t[a++]=i.x,t[a++]=i.y,t[a++]=i.z,t[a]=e.radius,t},l.unpack=function(e,t,i){r.defined("array",e),t=n(t,0),a(i)||(i=new l);var o=i.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],i.radius=e[t],i};var v=new e,F=new e;l.union=function(t,n,i){r.typeOf.object("left",t),r.typeOf.object("right",n),a(i)||(i=new l);var o=t.center,u=t.radius,s=n.center,c=n.radius,E=e.subtract(s,o,v),f=e.magnitude(E);if(u>=f+c)return t.clone(i),i;if(c>=f+u)return n.clone(i),i;var _=.5*(u+f+c),O=e.multiplyByScalar(E,(-u+_)/f,F);return e.add(O,o,O),e.clone(O,i.center),i.radius=_,i};var D=new e;l.expand=function(t,n,a){r.typeOf.object("sphere",t),r.typeOf.object("point",n),a=l.clone(t,a);var i=e.magnitude(e.subtract(n,a.center,D));return i>a.radius&&(a.radius=i),a},l.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var a=t.center,i=t.radius,o=n.normal,s=e.dot(o,a)+n.distance;return s<-i?u.OUTSIDE:s<i?u.INTERSECTING:u.INSIDE},l.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),a(n)||(n=new l),n.center=E.multiplyByPoint(t,e.center,n.center),n.radius=E.getMaximumScale(t)*e.radius,n};var B=new e;l.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var a=e.subtract(t.center,n,B);return e.magnitudeSquared(a)-t.radius*t.radius},l.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),a(n)||(n=new l),n.center=E.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var j=new e;l.computePlaneDistances=function(t,n,i,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",i),a(o)||(o=new s);var u=e.subtract(t.center,n,j),c=e.dot(i,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var z=new e,G=new e,q=new e,X=new e,V=new e,W=new t,H=new Array(8),Y=0;Y<8;++Y)H[Y]=new e;var k=new o;return l.projectTo2D=function(t,a,i){r.typeOf.object("sphere",t),a=n(a,k);var o=a.ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,z),E=e.cross(e.UNIT_Z,c,G);e.normalize(E,E);var f=e.cross(c,E,q);e.normalize(f,f),e.multiplyByScalar(c,s,c),e.multiplyByScalar(f,s,f),e.multiplyByScalar(E,s,E);var _=e.negate(f,V),O=e.negate(E,X),y=H,T=y[0];e.add(c,f,T),e.add(T,E,T),T=y[1],e.add(c,f,T),e.add(T,O,T),T=y[2],e.add(c,_,T),e.add(T,O,T),T=y[3],e.add(c,_,T),e.add(T,E,T),e.negate(c,c),T=y[4],e.add(c,f,T),e.add(T,E,T),T=y[5],e.add(c,f,T),e.add(T,O,T),T=y[6],e.add(c,_,T),e.add(T,O,T),T=y[7],e.add(c,_,T),e.add(T,E,T);for(var p=y.length,h=0;h<p;++h){var R=y[h];e.add(u,R,R);var d=o.cartesianToCartographic(R,W);a.project(d,R)}i=l.fromPoints(y,i),u=i.center;var A=u.x,m=u.y,N=u.z;return u.x=N,u.y=A,u.z=m,i},l.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},l.equals=function(t,r){return t===r||a(t)&&a(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},l.prototype.intersectPlane=function(e){return l.intersectPlane(this,e)},l.prototype.distanceSquaredTo=function(e){return l.distanceSquaredTo(this,e)},l.prototype.computePlaneDistances=function(e,t,r){return l.computePlaneDistances(this,e,t,r)},l.prototype.isOccluded=function(e){return l.isOccluded(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.clone=function(e){return l.clone(this,e)},l}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,a){return e.typeOf.object("value",r),e.defined("array",n),a=t(a,0),n[a++]=r.x,n[a]=r.y,n},o.unpack=function(n,a,i){return e.defined("array",n),a=t(a,0),r(i)||(i=new o),i.x=n[a++],i.y=n[a],i},o.packArray=function(t,n){e.defined("array",t);var a=t.length;r(n)?n.length=2*a:n=new Array(2*a);for(var i=0;i<a;++i)o.pack(t[i],n,2*i);return n},o.unpackArray=function(t,n){e.defined("array",t);var a=t.length;r(n)?n.length=a/2:n=new Array(a/2);for(var i=0;i<a;i+=2){var u=i/2;n[u]=o.unpack(t,i,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){if(!r(e)||!r(t))throw new n("left and right are required.");return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){if(!r(e)||!r(t))throw new n("left and right are required.");return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var a=o.magnitude(t);if(r.x=t.x/a,r.y=t.y/a,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,a){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",a),o.multiplyByScalar(r,n,s),a=o.multiplyByScalar(t,1-n,a),o.add(s,a,a)};var c=new o,E=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,E),i.acosClamped(o.dot(c,E))};var f=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)},o.ZERO=a(new o(0,0)),o.UNIT_X=a(new o(1,0)),o.UNIT_Y=a(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){if(a.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(a.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(a.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(a.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(a.supportsFullscreen())return null!==a.element}}}),a.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;o<u;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(n.requestFullscreen=a,r=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(n.requestFullscreen=a,r=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?n.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(n.exitFullscreen=a)),a=s+"FullscreenEnabled",void 0!==document[a]?n.fullscreenEnabled=a:(a=s+"FullScreenEnabled",void 0!==document[a]&&(n.fullscreenEnabled=a)),a=s+"FullscreenElement",void 0!==document[a]?n.fullscreenElement=a:(a=s+"FullScreenElement",void 0!==document[a]&&(n.fullscreenElement=a)),a=s+"fullscreenchange",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenChange"),n.fullscreenchange=a),a=s+"fullscreenerror",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenError"),n.fullscreenerror=a)}return r},a.requestFullscreen=function(e,t){a.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},a.exitFullscreen=function(){a.supportsFullscreen()&&document[n.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(A)&&(A=!1,!l())){var e=/ Chrome\/([\.0-9]+)/.exec(d.userAgent);null!==e&&(A=!0,m=n(e[1]))}return A}function i(){return a()&&m}function o(){if(!t(N)&&(N=!1,!a()&&!l()&&/ Safari\/[\.0-9]+/.test(d.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(d.userAgent);null!==e&&(N=!0,I=n(e[1]))}return N}function u(){return o()&&I}function s(){if(!t(S)){S=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(d.userAgent);null!==e&&(S=!0,b=n(e[1]),b.isNightly=!!e[2])}return S}function c(){return s()&&b}function E(){if(!t(M)){M=!1;var e;"Microsoft Internet Explorer"===d.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(d.userAgent),null!==e&&(M=!0,w=n(e[1]))):"Netscape"===d.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(d.userAgent),null!==e&&(M=!0,w=n(e[1])))}return M}function f(){return E()&&w}function l(){if(!t(g)){g=!1;var e=/ Edge\/([\.0-9]+)/.exec(d.userAgent);null!==e&&(g=!0,C=n(e[1]))}return g}function _(){return l()&&C}function O(){if(!t(U)){U=!1;var e=/Firefox\/([\.0-9]+)/.exec(d.userAgent);null!==e&&(U=!0,x=n(e[1]))}return U}function y(){return t(L)||(L=/Windows/i.test(d.appVersion)),L}function T(){return O()&&x}function p(){return t(P)||(P="undefined"!=typeof PointerEvent&&(!t(d.pointerEnabled)||d.pointerEnabled)),P}function h(){if(!t(F)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;F=t(r)&&""!==r,F&&(v=r)}return F}function R(){return h()?v:void 0}var d;d="undefined"!=typeof navigator?navigator:{};var A,m,N,I,S,b,M,w,g,C,U,x,L,P,v,F,D={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:E,internetExplorerVersion:f,isEdge:l,edgeVersion:_,isFirefox:O,firefoxVersion:T,isWindows:y,hardwareConcurrency:e(d.hardwareConcurrency,3),supportsPointerEvents:p,supportsImageRenderingPixelated:h,imageRenderingValue:R};return D.supportsFullscreen=function(){return r.supportsFullscreen()},D.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},D.supportsWebWorkers=function(){return"undefined"!=typeof Worker},D}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,
UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,a,i){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:i.BYTE,UNSIGNED_BYTE:i.UNSIGNED_BYTE,SHORT:i.SHORT,UNSIGNED_SHORT:i.UNSIGNED_SHORT,INT:i.INT,UNSIGNED_INT:i.UNSIGNED_INT,FLOAT:i.FLOAT,DOUBLE:i.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(n,a,i,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(a))throw new r("buffer is required.");switch(i=e(i,0),u=e(u,(a.byteLength-i)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(a,i,u);case o.UNSIGNED_BYTE:return new Uint8Array(a,i,u);case o.SHORT:return new Int16Array(a,i,u);case o.UNSIGNED_SHORT:return new Uint16Array(a,i,u);case o.INT:return new Int32Array(a,i,u);case o.UNSIGNED_INT:return new Uint32Array(a,i,u);case o.FLOAT:return new Float32Array(a,i,u);case o.DOUBLE:return new Float64Array(a,i,u);default:throw new r("componentDatatype is not a valid value.")}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}},a(o)}),define("Core/CylinderGeometryLibrary",["./Math"],function(e){"use strict";var t={};return t.computePositions=function(t,r,n,a,i){var o,u=.5*t,s=-u,c=a+a,E=i?2*c:c,f=new Float64Array(3*E),l=0,_=0,O=i?3*c:0,y=i?3*(c+a):3*a;for(o=0;o<a;o++){var T=o/a*e.TWO_PI,p=Math.cos(T),h=Math.sin(T),R=p*n,d=h*n,A=p*r,m=h*r;f[_+O]=R,f[_+O+1]=d,f[_+O+2]=s,f[_+y]=A,f[_+y+1]=m,f[_+y+2]=u,_+=3,i&&(f[l++]=R,f[l++]=d,f[l++]=s,f[l++]=A,f[l++]=m,f[l++]=u)}return f},t}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,a){"use strict";function i(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.attributes))throw new r("options.attributes is required.");this.attributes=i.attributes,this.indices=i.indices,this.primitiveType=e(i.primitiveType,a.TRIANGLES),this.boundingSphere=i.boundingSphere,this.geometryType=e(i.geometryType,n.NONE),this.boundingSphereCV=i.boundingSphereCV}return i.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var a in e.attributes)if(e.attributes.hasOwnProperty(a)&&t(e.attributes[a])&&t(e.attributes[a].values)){var i=e.attributes[a],o=i.values.length/i.componentsPerAttribute;if(n!==o&&n!==-1)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,a){"use strict";var i={UNSIGNED_BYTE:a.UNSIGNED_BYTE,UNSIGNED_SHORT:a.UNSIGNED_SHORT,UNSIGNED_INT:a.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(r,a){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(a):new Uint16Array(a)},i.createTypedArrayFromArrayBuffer=function(r,a,i,o){if(!e(r))throw new t("numberOfVertices is required.");if(!e(a))throw new t("sourceArray is required.");if(!e(i))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(a,i,o):new Uint16Array(a,i,o)},r(i)}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return a.POSITION_ONLY=n(new a({position:!0})),a.POSITION_AND_NORMAL=n(new a({position:!0,normal:!0})),a.POSITION_NORMAL_AND_ST=n(new a({position:!0,normal:!0,st:!0})),a.POSITION_AND_ST=n(new a({position:!0,st:!0})),a.POSITION_AND_COLOR=n(new a({position:!0,color:!0})),a.ALL=n(new a({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),a.DEFAULT=a.POSITION_NORMAL_AND_ST,a.packedLength=6,a.pack=function(n,a,i){if(!t(n))throw new r("value is required");if(!t(a))throw new r("array is required");return i=e(i,0),a[i++]=n.position?1:0,a[i++]=n.normal?1:0,a[i++]=n.st?1:0,a[i++]=n.tangent?1:0,a[i++]=n.bitangent?1:0,a[i++]=n.color?1:0,a},a.unpack=function(n,i,o){if(!t(n))throw new r("array is required");return i=e(i,0),t(o)||(o=new a),o.position=1===n[i++],o.normal=1===n[i++],o.st=1===n[i++],o.tangent=1===n[i++],o.bitangent=1===n[i++],o.color=1===n[i++],o},a.clone=function(e,r){if(t(e))return t(r)||(r=new a),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},a}),define("Core/CylinderGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,n,a,i,o,u,s,c,E,f,l,_,O){"use strict";function y(e){e=i(e,i.EMPTY_OBJECT);var t=e.length,r=e.topRadius,n=e.bottomRadius,a=i(e.vertexFormat,O.DEFAULT),s=i(e.slices,128);if(!o(t))throw new u("options.length must be defined.");if(!o(r))throw new u("options.topRadius must be defined.");if(!o(n))throw new u("options.bottomRadius must be defined.");if(s<3)throw new u("options.slices must be greater than or equal to 3.");this._length=t,this._topRadius=r,this._bottomRadius=n,this._vertexFormat=O.clone(a),this._slices=s,this._workerName="createCylinderGeometry"}var T=new t,p=new r,h=new r,R=new r,d=new r;y.packedLength=O.packedLength+4,y.pack=function(e,t,r){if(!o(e))throw new u("value is required");if(!o(t))throw new u("array is required");return r=i(r,0),O.pack(e._vertexFormat,t,r),r+=O.packedLength,t[r++]=e._length,t[r++]=e._topRadius,t[r++]=e._bottomRadius,t[r]=e._slices,t};var A=new O,m={vertexFormat:A,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0};return y.unpack=function(e,t,r){if(!o(e))throw new u("array is required");t=i(t,0);var n=O.unpack(e,t,A);t+=O.packedLength;var a=e[t++],s=e[t++],c=e[t++],E=e[t];return o(r)?(r._vertexFormat=O.clone(n,r._vertexFormat),r._length=a,r._topRadius=s,r._bottomRadius=c,r._slices=E,r):(m.length=a,m.topRadius=s,m.bottomRadius=c,m.slices=E,new y(m))},y.createGeometry=function(i){var o=i._length,u=i._topRadius,O=i._bottomRadius,y=i._vertexFormat,A=i._slices;if(!(o<=0||u<0||O<0||0===u&&0===O)){var m,N=A+A,I=A+N,S=N+N,b=a.computePositions(o,u,O,A,!0),M=y.st?new Float32Array(2*S):void 0,w=y.normal?new Float32Array(3*S):void 0,g=y.tangent?new Float32Array(3*S):void 0,C=y.bitangent?new Float32Array(3*S):void 0,U=y.normal||y.tangent||y.bitangent;if(U){var x=y.tangent||y.bitangent,L=0,P=0,v=0,F=p;F.z=0;var D=R,B=h;for(m=0;m<A;m++){var j=m/A*l.TWO_PI,z=Math.cos(j),G=Math.sin(j);U&&(F.x=z,F.y=G,x&&(D=r.normalize(r.cross(r.UNIT_Z,F,D),D)),y.normal&&(w[L++]=z,w[L++]=G,w[L++]=0,w[L++]=z,w[L++]=G,w[L++]=0),y.tangent&&(g[P++]=D.x,g[P++]=D.y,g[P++]=D.z,g[P++]=D.x,g[P++]=D.y,g[P++]=D.z),y.bitangent&&(B=r.normalize(r.cross(F,D,B),B),C[v++]=B.x,C[v++]=B.y,C[v++]=B.z,C[v++]=B.x,C[v++]=B.y,C[v++]=B.z))}for(m=0;m<A;m++)y.normal&&(w[L++]=0,w[L++]=0,w[L++]=-1),y.tangent&&(g[P++]=1,g[P++]=0,g[P++]=0),y.bitangent&&(C[v++]=0,C[v++]=-1,C[v++]=0);for(m=0;m<A;m++)y.normal&&(w[L++]=0,w[L++]=0,w[L++]=1),y.tangent&&(g[P++]=1,g[P++]=0,g[P++]=0),y.bitangent&&(C[v++]=0,C[v++]=1,C[v++]=0)}var q=12*A-12,X=f.createTypedArray(S,q),V=0,W=0;for(m=0;m<A-1;m++)X[V++]=W,X[V++]=W+2,X[V++]=W+3,X[V++]=W,X[V++]=W+3,X[V++]=W+1,W+=2;for(X[V++]=N-2,X[V++]=0,X[V++]=1,X[V++]=N-2,X[V++]=1,X[V++]=N-1,m=1;m<A-1;m++)X[V++]=N+m+1,X[V++]=N+m,X[V++]=N;for(m=1;m<A-1;m++)X[V++]=I,X[V++]=I+m,X[V++]=I+m+1;var H=0;if(y.st){var Y=Math.max(u,O);for(m=0;m<S;m++){var k=r.fromArray(b,3*m,d);M[H++]=(k.x+Y)/(2*Y),M[H++]=(k.y+Y)/(2*Y)}}var K=new E;y.position&&(K.position=new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:b})),y.normal&&(K.normal=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:w})),y.tangent&&(K.tangent=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:g})),y.bitangent&&(K.bitangent=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:C})),y.st&&(K.st=new c({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:M})),T.x=.5*o,T.y=Math.max(O,u);var Z=new e(r.ZERO,t.magnitude(T));return new s({attributes:K,indices:X,primitiveType:_.TRIANGLES,boundingSphere:Z})}},y}),define("Workers/createCylinderGeometry",["../Core/CylinderGeometry","../Core/defined"],function(e,t){"use strict";return function(r,n){return t(n)&&(r=e.unpack(r,n)),e.createGeometry(r)}})}();