/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(n,i){if(!e(i))throw new t(r(n))},i.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},i.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},i.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},i.typeOf.number.lessThan=function(e,r,n){if(i.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},i.typeOf.number.lessThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},i.typeOf.number.greaterThan=function(e,r,n){if(i.typeOf.number(e,r),r<=n)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},i.typeOf.number.greaterThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r<n)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},i.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},i.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:e<0?-1:0},i.signNotZero=function(e){return e<0?-1:1},i.toSNorm=function(e,r){return r=t(r,255),Math.round((.5*i.clamp(e,-1,1)+.5)*r)},i.fromSNorm=function(e,r){return r=t(r,255),i.clamp(e,0,r)/r*2-1},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!r(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!r(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!r(e))throw new n("angle is required.");var t=i.TWO_PI,a=e-Math.floor(e/t)*t;return a<-Math.PI?a+t:a>=Math.PI?a-t:a},i.clampToLatitudeRange=function(e){if(!r(e))throw new n("angle is required.");return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){if(!r(e))throw new n("angle is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!r(e))throw new n("angle is required.");var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){if(!r(e))throw new n("m is required.");if(!r(t))throw new n("n is required.");return(e%t+t)%t},i.equalsEpsilon=function(e,i,a,o){if(!r(e))throw new n("left is required.");if(!r(i))throw new n("right is required.");if(!r(a))throw new n("relativeEpsilon is required.");o=t(o,a);var u=Math.abs(e-i);return u<=o||u<=a*Math.max(Math.abs(e),Math.abs(i))};var a=[1];i.factorial=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],i=t;i<=e;i++)a.push(r*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=t(a,0),!r(e))throw new n("n is required.");if(i<=a)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,i){if(!r(e))throw new n("value is required");if(!r(t))throw new n("min is required.");if(!r(i))throw new n("max is required.");return e<t?t:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(t){if(!r(t))throw new n("seed is required.");o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){if(!r(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!r(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){if(!r(e))throw new n("angle is required.");if(!r(t))throw new n("radius is required.");return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){if(!r(e))throw new n("number is required.");if(!r(t))throw new n("base is required.");return Math.log(e)/Math.log(t)},i.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},i}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new o);var a=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var a=0;a<i;++a)o.pack(t[a],n,3*a);return n},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var a=t.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;u<a;u+=3){var s=u/3;i[s]=o.unpack(t,u,i[s])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(e,t,i){if(!r(e))throw new n("left is required");if(!r(t))throw new n("right is required");if(!r(i))throw new n("result is required");return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,l=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,l);var n=o.dot(c,l),i=o.magnitude(o.cross(c,l,c));return Math.atan2(i,n)};var f=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=r.x,s=r.y,c=r.z,l=a*c-o*s,f=o*u-i*c,p=i*s-a*u;return n.x=l,n.y=f,n.z=p,n},o.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=a.toRadians(t),r=a.toRadians(r),o.fromRadians(t,r,n,i,u)};var p=new o,y=new o,h=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),a=t(a,0);var c=r(u)?u.radiiSquared:h,l=Math.cos(i);p.x=l*Math.cos(n),p.y=l*Math.sin(n),p.z=Math.sin(i),p=o.normalize(p,p),o.multiplyComponents(c,p,y);var f=Math.sqrt(o.dot(p,y));return y=o.divideByScalar(y,f,y),p=o.multiplyByScalar(p,a,p),r(s)||(s=new o),o.add(y,p,s)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],l=t[s+1],f=s/2;a[f]=o.fromDegrees(c,l,0,i,a[f])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],l=t[s+1],f=s/2;a[f]=o.fromRadians(c,l,0,i,a[f])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],l=t[s+1],f=t[s+2],p=s/3;a[p]=o.fromDegrees(c,l,f,i,a[p])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],l=t[s+1],f=t[s+2],p=s/3;a[p]=o.fromRadians(c,l,f,i,a[p])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(i,u,s,c,l){if(!t(i))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var f=i.x,p=i.y,y=i.z,h=u.x,d=u.y,E=u.z,m=f*f*h*h,O=p*p*d*d,_=y*y*E*E,w=m+O+_,T=Math.sqrt(1/w),v=e.multiplyByScalar(i,T,a);if(w<c)return isFinite(T)?e.clone(v,l):void 0;var b=s.x,R=s.y,g=s.z,A=o;A.x=v.x*b*2,A.y=v.y*R*2,A.z=v.z*g*2;var N,S,x,I,M,C,P,L,U,D,F,q=(1-T)*e.magnitude(i)/(.5*e.magnitude(A)),z=0;do{q-=z,x=1/(1+q*b),I=1/(1+q*R),M=1/(1+q*g),C=x*x,P=I*I,L=M*M,U=C*x,D=P*I,F=L*M,N=m*C+O*P+_*L-1,S=m*U*b+O*D*R+_*F*g;var B=-2*S;z=N/B}while(Math.abs(N)>n.EPSILON12);return t(l)?(l.x=f*x,l.y=p*I,l.z=y*M,l):new e(f*x,p*I,y*M)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o){"use strict";function u(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)}u.fromRadians=function(e,i,a,o){if(!r(e))throw new n("longitude is required.");if(!r(i))throw new n("latitude is required.");return a=t(a,0),r(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new u(e,i,a)},u.fromDegrees=function(e,t,i,o){if(!r(e))throw new n("longitude is required.");if(!r(t))throw new n("latitude is required.");return e=a.toRadians(e),t=a.toRadians(t),u.fromRadians(e,t,i,o)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),p=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),y=a.EPSILON1;return u.fromCartesian=function(t,n,i){var h=r(n)?n.oneOverRadii:f,d=r(n)?n.oneOverRadiiSquared:p,E=r(n)?n._centerToleranceSquared:y,m=o(t,h,d,E,c);if(r(m)){var O=e.multiplyComponents(m,d,s);O=e.normalize(O,O);var _=e.subtract(t,m,l),w=Math.atan2(O.y,O.x),T=Math.asin(O.z),v=a.sign(e.dot(_,t))*e.magnitude(_);return r(i)?(i.longitude=w,i.latitude=T,i.height=v,i):new u(w,T,v)}},u.clone=function(e,t){if(r(e))return r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===t||r(e)&&r(t)&&Math.abs(e.longitude-t.longitude)<=i&&Math.abs(e.latitude-t.latitude)<=i&&Math.abs(e.height-t.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o,u,s){"use strict";function c(t,n,i,o){if(n=r(n,0),i=r(i,0),o=r(o,0),n<0||i<0||o<0)throw new a("All radii components must be greater than or equal to zero.");t._radii=new e(n,i,o),t._radiiSquared=new e(n*n,i*i,o*o),t._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,o*o*o*o),t._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===o?0:1/(o*o)),t._minimumRadius=Math.min(n,i,o),t._maximumRadius=Math.max(n,i,o),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._sqauredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._sqauredXOverSquaredZ=void 0,c(this,e,t,r)}i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(n(t)){var i=t._radii;return n(r)?(e.clone(i,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(i.x,i.y,i.z)}},l.fromCartesian3=function(e,t){return n(t)||(t=new l),n(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,i,o){if(!n(t))throw new a("value is required");if(!n(i))throw new a("array is required");return o=r(o,0),e.pack(t._radii,i,o),i},l.unpack=function(t,i,o){if(!n(t))throw new a("array is required");i=r(i,0);var u=e.unpack(t,i);return l.fromCartesian3(u,o)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,r){if(!n(t))throw new a("cartographic is required.");var i=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(i),c=u*Math.sin(i),l=Math.sin(o);return n(r)||(r=new e),r.x=s,r.y=c,r.z=l,e.normalize(r,r)},l.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var f=new e,p=new e;l.prototype.cartographicToCartesian=function(t,r){var i=f,a=p;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),n(r)||(r=new e),e.add(a,i,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){if(!n(e))throw new a("cartographics is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;i<r;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var y=new e,h=new e,d=new e;return l.prototype.cartesianToCartographic=function(r,i){var a=this.scaleToGeodeticSurface(r,h);if(n(a)){var o=this.geodeticSurfaceNormal(a,y),s=e.subtract(r,a,d),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return n(i)?(i.longitude=c,i.latitude=l,i.height=f,i):new t(c,l,f)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){if(!n(e))throw new a("cartesians is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;i<r;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,r){if(!n(t))throw new a("cartesian is required.");n(r)||(r=new e);var i=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,r)},l.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,i,o){if(!n(t))throw new a("position is required.");if(!u.equalsEpsilon(this._radii.x,this._radii.y,u.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");if(0===this._radii.z)throw new a("Ellipsoid.radii.z must be greater than 0");i=r(i,0);var s=this._sqauredXOverSquaredZ;if(n(o)||(o=new e),o.x=0,o.y=0,o.z=t.z*(1-s),!(Math.abs(o.z)>=this._radii.z-i))return o},l}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,a,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),n(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new s(e,t,i,a)},s.fromRadians=function(e,t,i,a,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(i,0),o.north=r(a,0),o):new s(e,t,i,a)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,p=0,y=e.length;p<y;p++){var h=e[p];i=Math.min(i,h.longitude),a=Math.max(a,h.longitude),l=Math.min(l,h.latitude),f=Math.max(f,h.latitude);var d=h.longitude>=0?h.longitude:h.longitude+u.TWO_PI;o=Math.min(o,d),c=Math.max(c,d)}return a-i>c-o&&(i=o,a=c,a>u.PI&&(a-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=l,r.east=a,r.north=f,r):new s(i,l,a,f)},s.fromCartesianArray=function(e,r,i){t.defined("cartesians",e);for(var a=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=Number.MAX_VALUE,p=-Number.MAX_VALUE,y=0,h=e.length;y<h;y++){var d=r.cartesianToCartographic(e[y]);a=Math.min(a,d.longitude),o=Math.max(o,d.longitude),f=Math.min(f,d.latitude),p=Math.max(p,d.latitude);var E=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;c=Math.min(c,E),l=Math.max(l,E)}return o-a>l-c&&(a=c,o=l,o>u.PI&&(o-=u.TWO_PI),a>u.PI&&(a-=u.TWO_PI)),n(i)?(i.west=a,i.south=f,i.east=o,i.north=p,i):new s(a,f,o,p)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),n(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var a=r.east,o=r.west;a<o&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=e.east,o=e.west,c=r.east,l=r.west;a<o&&c>0?a+=u.TWO_PI:c<l&&a>0&&(c+=u.TWO_PI),a<o&&l<0?l+=u.TWO_PI:c<l&&o<0&&(o+=u.TWO_PI);var f=u.negativePiToPi(Math.max(o,l)),p=u.negativePiToPi(Math.min(a,c));if(!((e.west<e.east||r.west<r.east)&&p<=f)){var y=Math.max(e.south,r.south),h=Math.min(e.north,r.north);if(!(y>=h))return n(i)?(i.west=f,i.south=y,i.east=p,i.north=h,i):new s(f,y,p,h)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(o>=c||a>=u))return n(i)?(i.west=a,i.south=o,i.east=u,i.north=c,i):new s(a,o,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var a=e.east,o=e.west,c=r.east,l=r.west;a<o&&c>0?a+=u.TWO_PI:c<l&&a>0&&(c+=u.TWO_PI),a<o&&l<0?l+=u.TWO_PI:c<l&&o<0&&(o+=u.TWO_PI);var f=u.convertLongitudeRange(Math.min(o,l)),p=u.convertLongitudeRange(Math.max(a,c));return i.west=f,i.south=Math.min(e.south,r.south),i.east=p,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,a=e.west,o=e.east;return o<a&&(o+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(n<o||u.equalsEpsilon(n,o,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,o,l){t.typeOf.object("rectangle",e),i=r(i,a.WGS84),o=r(o,0),n(l)||(l=[]);var f=0,p=e.north,y=e.south,h=e.east,d=e.west,E=c;E.height=o,E.longitude=d,E.latitude=p,l[f]=i.cartographicToCartesian(E,l[f]),f++,E.longitude=h,l[f]=i.cartographicToCartesian(E,l[f]),f++,E.latitude=y,l[f]=i.cartographicToCartesian(E,l[f]),f++,E.longitude=d,l[f]=i.cartographicToCartesian(E,l[f]),f++,p<0?E.latitude=p:y>0?E.latitude=y:E.latitude=0;for(var m=1;m<8;++m)E.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,E)&&(l[f]=i.cartographicToCartesian(E,l[f]),f++);return 0===E.latitude&&(E.longitude=d,l[f]=i.cartographicToCartesian(E,l[f]),f++,E.longitude=h,l[f]=i.cartographicToCartesian(E,l[f]),f++),l.length=f,l},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,a,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i,a,o,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function l(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(d[r],h[r])];t+=2*n*n}return Math.sqrt(t)}function f(e,t){for(var r=u.EPSILON15,n=0,i=1,a=0;a<3;++a){var o=Math.abs(e[s.getElementIndex(d[a],h[a])]);o>n&&(i=a,n=o)}var c=1,l=0,f=h[i],p=d[i];if(Math.abs(e[s.getElementIndex(p,f)])>r){var y,E=e[s.getElementIndex(p,p)],m=e[s.getElementIndex(f,f)],O=e[s.getElementIndex(p,f)],_=(E-m)/2/O;
y=_<0?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),c=1/Math.sqrt(1+y*y),l=y*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(f,f)]=t[s.getElementIndex(p,p)]=c,t[s.getElementIndex(p,f)]=l,t[s.getElementIndex(f,p)]=-l,t}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,l=e.y*e.z,f=e.y*e.w,p=e.z*e.z,y=e.z*e.w,h=e.w*e.w,d=i-c-p+h,E=2*(a-y),m=2*(o+f),O=2*(a+y),_=-i+c-p+h,w=2*(l-u),T=2*(o-f),v=2*(l+u),b=-i-c+p+h;return n(r)?(r[0]=d,r[1]=O,r[2]=T,r[3]=E,r[4]=_,r[5]=v,r[6]=m,r[7]=w,r[8]=b,r):new s(d,E,m,O,_,w,T,v,b)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),a=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),l=Math.sin(e.roll),f=i*a,p=-o*c+l*u*a,y=l*c+o*u*a,h=i*c,d=o*a+l*u*c,E=-u*o+o*u*c,m=-u,O=l*i,_=o*i;return n(r)?(r[0]=f,r[1]=h,r[2]=m,r[3]=p,r[4]=d,r[5]=O,r[6]=y,r[7]=E,r[8]=_,r):new s(f,p,y,h,d,E,m,O,_)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new s(1,0,0,0,i,-a,0,a,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new s(i,0,a,0,1,0,-a,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-a,0,a,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,a=e[i],o=e[i+1],u=e[i+2];return n.x=a,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i);var a=3*r;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],a=e[r+3],o=e[r+6];return n.x=i,n.y=a,n.z=o,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i),i[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var p=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],p)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],p)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],p)),n};var y=new e;s.getMaximumScale=function(t){return s.getScale(t,y),e.maximumComponent(y)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],l=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],f=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],p=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=l,n[7]=f,n[8]=p,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,a=r.y,o=r.z,u=e[0]*i+e[3]*a+e[6]*o,s=e[1]*i+e[4]*a+e[7]*o,c=e[2]*i+e[5]*a+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],c=e[2],l=e[5],f=e[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r};var h=[1,0,0],d=[2,2,1],E=new s,m=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,a=10,o=0,p=0;n(r)||(r={});for(var y=r.unitary=s.clone(s.IDENTITY,r.unitary),h=r.diagonal=s.clone(e,r.diagonal),d=i*c(h);p<a&&l(h)>d;)f(h,E),s.transpose(E,m),s.multiply(h,E,h),s.multiply(m,h,h),s.multiply(y,E,y),++o>2&&(++p,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return r*(o*l-c*u)+a*(c*i-n*l)+s*(n*u-o*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],o=e[2],c=e[3],l=e[4],f=e[5],p=e[6],y=e[7],h=e[8],d=s.determinant(e);if(Math.abs(d)<=u.EPSILON15)throw new a("matrix is not invertible");r[0]=l*h-y*f,r[1]=y*o-i*h,r[2]=i*f-l*o,r[3]=p*f-c*h,r[4]=n*h-p*o,r[5]=c*o-n*f,r[6]=c*y-p*l,r[7]=p*i-n*y,r[8]=n*l-c*i;var E=1/d;return s.multiplyByScalar(r,E,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var a=0;a<i;++a)o.pack(t[a],n,4*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var a=0;a<i;a+=4){var u=a/4;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)&&a.equalsEpsilon(e.w,t.w,n,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(e,t,r,i,a,o,u,s,c,l,f,p,y,h,d,E){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(y,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(h,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(d,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(p,0),this[15]=n(E,0)}l.packedLength=16,l.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},l.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new l),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},l.clone=function(e,t){if(i(e))return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){return r.defined("values",e),l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,a,o){return r.typeOf.object("rotation",t),a=n(a,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new l(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,n,a){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(a)||(a=new l);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,f=t.x*t.y,p=t.x*t.z,y=t.x*t.w,h=t.y*t.y,d=t.y*t.z,E=t.y*t.w,m=t.z*t.z,O=t.z*t.w,_=t.w*t.w,w=c-h-m+_,T=2*(f-O),v=2*(p+E),b=2*(f+O),R=-c+h-m+_,g=2*(d-y),A=2*(p-E),N=2*(d+y),S=-c-h+m+_;return a[0]=w*o,a[1]=b*o,a[2]=A*o,a[3]=0,a[4]=T*u,a[5]=R*u,a[6]=N*u,a[7]=0,a[8]=v*s,a[9]=g*s,a[10]=S*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},l.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),l.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},l.fromTranslation=function(e,t){return r.typeOf.object("translation",e),l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,p=new e,y=new e;l.fromCamera=function(t,n){r.typeOf.object("camera",t);var a=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",a),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,f),e.normalize(e.cross(f,u,p),p),e.normalize(e.cross(p,f,y),y);var s=p.x,c=p.y,h=p.z,d=f.x,E=f.y,m=f.z,O=y.x,_=y.y,w=y.z,T=a.x,v=a.y,b=a.z,R=s*-T+c*-v+h*-b,g=O*-T+_*-v+w*-b,A=d*T+E*v+m*b;return i(n)?(n[0]=s,n[1]=O,n[2]=-d,n[3]=0,n[4]=c,n[5]=_,n[6]=-E,n[7]=0,n[8]=h,n[9]=w,n[10]=-m,n[11]=0,n[12]=R,n[13]=g,n[14]=A,n[15]=1,n):new l(s,c,h,R,O,_,w,g,-d,-E,-m,A,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,n,i,a){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",a);var o=Math.tan(.5*e),u=1/o,s=u/t,c=(i+n)/(n-i),l=2*i*n/(n-i);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},l.computeOrthographicOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),l=1/(o-a),f=-(t+e)*s,p=-(i+n)*c,y=-(o+a)*l;return s*=2,c*=2,l*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=l,u[11]=0,u[12]=f,u[13]=p,u[14]=y,u[15]=1,u},l.computePerspectiveOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*a/(t-e),c=2*a/(i-n),l=(t+e)/(t-e),f=(i+n)/(i-n),p=-(o+a)/(o-a),y=-1,h=-2*o*a/(o-a);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=f,u[10]=p,u[11]=y,u[12]=0,u[13]=0,u[14]=h,u[15]=0,u},l.computeInfinitePerspectiveOffCenter=function(e,t,n,i,a,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.object("result",o);var u=2*a/(t-e),s=2*a/(i-n),c=(t+e)/(t-e),l=(i+n)/(i-n),f=-1,p=-1,y=-2*a;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=p,o[12]=0,o[13]=0,o[14]=y,o[15]=0,o},l.computeViewportTransformation=function(e,t,i,a){r.typeOf.object("result",a),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),i=n(i,1);var l=.5*s,f=.5*c,p=.5*(i-t),y=l,h=f,d=p,E=o+l,m=u+f,O=t+p,_=1;return a[0]=y,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=d,a[11]=0,a[12]=E,a[13]=m,a[14]=O,a[15]=_,a},l.computeView=function(t,n,i,a,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",a),r.typeOf.object("result",o),o[0]=a.x,o[1]=i.x,o[2]=-n.x,o[3]=0,o[4]=a.y,o[5]=i.y,o[6]=-n.y,o[7]=0,o[8]=a.z,o[9]=i.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(a,t),o[13]=-e.dot(i,t),o[14]=e.dot(n,t),o[15]=1,o},l.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},l.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,a=e[i],o=e[i+1],u=e[i+2],s=e[i+3];return n.x=a,n.y=o,n.z=u,n.w=s,n},l.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=l.clone(e,i);var a=4*t;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i[a+3]=n.w,i},l.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},l.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],a=e[t+4],o=e[t+8],u=e[t+12];return n.x=i,n.y=a,n.z=o,n.w=u,n},l.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=l.clone(e,i),i[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var h=new e;l.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],h)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],h)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],h)),n};var d=new e;l.getMaximumScale=function(t){return l.getScale(t,d),e.maximumComponent(d)},l.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[3],s=e[4],c=e[5],l=e[6],f=e[7],p=e[8],y=e[9],h=e[10],d=e[11],E=e[12],m=e[13],O=e[14],_=e[15],w=t[0],T=t[1],v=t[2],b=t[3],R=t[4],g=t[5],A=t[6],N=t[7],S=t[8],x=t[9],I=t[10],M=t[11],C=t[12],P=t[13],L=t[14],U=t[15],D=i*w+s*T+p*v+E*b,F=a*w+c*T+y*v+m*b,q=o*w+l*T+h*v+O*b,z=u*w+f*T+d*v+_*b,B=i*R+s*g+p*A+E*N,j=a*R+c*g+y*A+m*N,G=o*R+l*g+h*A+O*N,V=u*R+f*g+d*A+_*N,X=i*S+s*x+p*I+E*M,W=a*S+c*x+y*I+m*M,H=o*S+l*x+h*I+O*M,Y=u*S+f*x+d*I+_*M,k=i*C+s*P+p*L+E*U,Z=a*C+c*P+y*L+m*U,K=o*C+l*P+h*L+O*U,Q=u*C+f*P+d*L+_*U;return n[0]=D,n[1]=F,n[2]=q,n[3]=z,n[4]=B,n[5]=j,n[6]=G,n[7]=V,n[8]=X,n[9]=W,n[10]=H,n[11]=Y,n[12]=k,n[13]=Z,n[14]=K,n[15]=Q,n},l.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},l.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},l.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],p=e[10],y=e[12],h=e[13],d=e[14],E=t[0],m=t[1],O=t[2],_=t[4],w=t[5],T=t[6],v=t[8],b=t[9],R=t[10],g=t[12],A=t[13],N=t[14],S=i*E+u*m+l*O,x=a*E+s*m+f*O,I=o*E+c*m+p*O,M=i*_+u*w+l*T,C=a*_+s*w+f*T,P=o*_+c*w+p*T,L=i*v+u*b+l*R,U=a*v+s*b+f*R,D=o*v+c*b+p*R,F=i*g+u*A+l*N+y,q=a*g+s*A+f*N+h,z=o*g+c*A+p*N+d;return n[0]=S,n[1]=x,n[2]=I,n[3]=0,n[4]=M,n[5]=C,n[6]=P,n[7]=0,n[8]=L,n[9]=U,n[10]=D,n[11]=0,n[12]=F,n[13]=q,n[14]=z,n[15]=1,n},l.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],p=e[10],y=t[0],h=t[1],d=t[2],E=t[3],m=t[4],O=t[5],_=t[6],w=t[7],T=t[8],v=i*y+u*h+l*d,b=a*y+s*h+f*d,R=o*y+c*h+p*d,g=i*E+u*m+l*O,A=a*E+s*m+f*O,N=o*E+c*m+p*O,S=i*_+u*w+l*T,x=a*_+s*w+f*T,I=o*_+c*w+p*T;return n[0]=v,n[1]=b,n[2]=R,n[3]=0,n[4]=g,n[5]=A,n[6]=N,n[7]=0,n[8]=S,n[9]=x,n[10]=I,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},l.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=i*e[0]+a*e[4]+o*e[8]+e[12],s=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;l.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,l.multiplyByScale(e,E,n)},l.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?l.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},l.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=t.w,s=e[0]*i+e[4]*a+e[8]*o+e[12]*u,c=e[1]*i+e[5]*a+e[9]*o+e[13]*u,l=e[2]*i+e[6]*a+e[10]*o+e[14]*u,f=e[3]*i+e[7]*a+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=l,n.w=f,n},l.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o,s=e[1]*i+e[5]*a+e[9]*o,c=e[2]*i+e[6]*a+e[10]*o;return n.x=u,n.y=s,n.z=c,n},l.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o+e[12],s=e[1]*i+e[5]*a+e[9]*o+e[13],c=e[2]*i+e[6]*a+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},l.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},l.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],a=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=s,t[15]=e[15],t},l.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},l.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var m=new s,O=new s,_=new t,w=new t(0,0,0,1);return l.inverse=function(e,n){if(r.typeOf.object("matrix",e),r.typeOf.object("result",n),s.equalsEpsilon(l.getRotation(e,m),O,u.EPSILON7)&&t.equals(l.getRow(e,3,_),w))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var i=e[0],a=e[4],o=e[8],f=e[12],p=e[1],y=e[5],h=e[9],d=e[13],E=e[2],T=e[6],v=e[10],b=e[14],R=e[3],g=e[7],A=e[11],N=e[15],S=v*N,x=b*A,I=T*N,M=b*g,C=T*A,P=v*g,L=E*N,U=b*R,D=E*A,F=v*R,q=E*g,z=T*R,B=S*y+M*h+C*d-(x*y+I*h+P*d),j=x*p+L*h+F*d-(S*p+U*h+D*d),G=I*p+U*y+q*d-(M*p+L*y+z*d),V=P*p+D*y+z*h-(C*p+F*y+q*h),X=x*a+I*o+P*f-(S*a+M*o+C*f),W=S*i+U*o+D*f-(x*i+L*o+F*f),H=M*i+L*a+z*f-(I*i+U*a+q*f),Y=C*i+F*a+q*o-(P*i+D*a+z*o);S=o*d,x=f*h,I=a*d,M=f*y,C=a*h,P=o*y,L=i*d,U=f*p,D=i*h,F=o*p,q=i*y,z=a*p;var k=S*g+M*A+C*N-(x*g+I*A+P*N),Z=x*R+L*A+F*N-(S*R+U*A+D*N),K=I*R+U*g+q*N-(M*R+L*g+z*N),Q=P*R+D*g+z*A-(C*R+F*g+q*A),J=I*v+P*b+x*T-(C*b+S*T+M*v),$=D*b+S*E+U*v-(L*v+F*b+x*E),ee=L*T+z*b+M*E-(q*b+I*E+U*T),te=q*v+C*E+F*T-(D*T+z*v+P*E),re=i*B+a*j+o*G+f*V;if(Math.abs(re)<u.EPSILON20)throw new c("matrix is not invertible because its determinate is zero.");
return re=1/re,n[0]=B*re,n[1]=j*re,n[2]=G*re,n[3]=V*re,n[4]=X*re,n[5]=W*re,n[6]=H*re,n[7]=Y*re,n[8]=k*re,n[9]=Z*re,n[10]=K*re,n[11]=Q*re,n[12]=J*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},l.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],p=e[12],y=e[13],h=e[14],d=-n*p-i*y-a*h,E=-o*p-u*y-s*h,m=-c*p-l*y-f*h;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=l,t[7]=0,t[8]=a,t[9]=s,t[10]=f,t[11]=0,t[12]=d,t[13]=E,t[14]=m,t[15]=1,t},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=o(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,a(l.prototype,{length:{get:function(){return l.packedLength}}}),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,i,a,o,u,s,c,l,f){"use strict";function p(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var y=new e,h=new e,d=new e,E=new e,m=new e,O=new e,_=new e,w=new e,T=new e,v=new e,b=new e,R=new e;p.fromPoints=function(t,r){if(i(r)||(r=new p),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var n=e.clone(t[0],_),a=e.clone(n,y),o=e.clone(n,h),u=e.clone(n,d),s=e.clone(n,E),c=e.clone(n,m),l=e.clone(n,O),f=t.length,g=1;g<f;g++){e.clone(t[g],n);var A=n.x,N=n.y,S=n.z;A<a.x&&e.clone(n,a),A>s.x&&e.clone(n,s),N<o.y&&e.clone(n,o),N>c.y&&e.clone(n,c),S<u.z&&e.clone(n,u),S>l.z&&e.clone(n,l)}var x=e.magnitudeSquared(e.subtract(s,a,w)),I=e.magnitudeSquared(e.subtract(c,o,w)),M=e.magnitudeSquared(e.subtract(l,u,w)),C=a,P=s,L=x;I>L&&(L=I,C=o,P=c),M>L&&(L=M,C=u,P=l);var U=T;U.x=.5*(C.x+P.x),U.y=.5*(C.y+P.y),U.z=.5*(C.z+P.z);var D=e.magnitudeSquared(e.subtract(P,U,w)),F=Math.sqrt(D),q=v;q.x=a.x,q.y=o.y,q.z=u.z;var z=b;z.x=s.x,z.y=c.y,z.z=l.z;var B=e.multiplyByScalar(e.add(q,z,w),.5,R),j=0;for(g=0;g<f;g++){e.clone(t[g],n);var G=e.magnitude(e.subtract(n,B,w));G>j&&(j=G);var V=e.magnitudeSquared(e.subtract(n,U,w));if(V>D){var X=Math.sqrt(V);F=.5*(F+X),D=F*F;var W=X-F;U.x=(F*U.x+W*n.x)/X,U.y=(F*U.y+W*n.y)/X,U.z=(F*U.z+W*n.z)/X}}return F<j?(e.clone(U,r.center),r.radius=F):(e.clone(B,r.center),r.radius=j),r};var g=new o,A=new e,N=new e,S=new t,x=new t;p.fromRectangle2D=function(e,t,r){return p.fromRectangleWithHeights2D(e,t,0,0,r)},p.fromRectangleWithHeights2D=function(t,r,a,o,u){if(i(u)||(u=new p),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,g),f.southwest(t,S),S.height=a,f.northeast(t,x),x.height=o;var s=r.project(S,A),c=r.project(x,N),l=c.x-s.x,y=c.y-s.y,h=c.z-s.z;u.radius=.5*Math.sqrt(l*l+y*y+h*h);var d=u.center;return d.x=s.x+.5*l,d.y=s.y+.5*y,d.z=s.z+.5*h,u};var I=[];p.fromRectangle3D=function(e,t,r,o){t=n(t,a.WGS84),r=n(r,0);var u;return i(e)&&(u=f.subsample(e,t,r,I)),p.fromPoints(u,o)},p.fromVertices=function(t,a,o,u){if(i(u)||(u=new p),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=_;s.x=t[0]+a.x,s.y=t[1]+a.y,s.z=t[2]+a.z;for(var c=e.clone(s,y),l=e.clone(s,h),f=e.clone(s,d),g=e.clone(s,E),A=e.clone(s,m),N=e.clone(s,O),S=t.length,x=0;x<S;x+=o){var I=t[x]+a.x,M=t[x+1]+a.y,C=t[x+2]+a.z;s.x=I,s.y=M,s.z=C,I<c.x&&e.clone(s,c),I>g.x&&e.clone(s,g),M<l.y&&e.clone(s,l),M>A.y&&e.clone(s,A),C<f.z&&e.clone(s,f),C>N.z&&e.clone(s,N)}var P=e.magnitudeSquared(e.subtract(g,c,w)),L=e.magnitudeSquared(e.subtract(A,l,w)),U=e.magnitudeSquared(e.subtract(N,f,w)),D=c,F=g,q=P;L>q&&(q=L,D=l,F=A),U>q&&(q=U,D=f,F=N);var z=T;z.x=.5*(D.x+F.x),z.y=.5*(D.y+F.y),z.z=.5*(D.z+F.z);var B=e.magnitudeSquared(e.subtract(F,z,w)),j=Math.sqrt(B),G=v;G.x=c.x,G.y=l.y,G.z=f.z;var V=b;V.x=g.x,V.y=A.y,V.z=N.z;var X=e.multiplyByScalar(e.add(G,V,w),.5,R),W=0;for(x=0;x<S;x+=o){s.x=t[x]+a.x,s.y=t[x+1]+a.y,s.z=t[x+2]+a.z;var H=e.magnitude(e.subtract(s,X,w));H>W&&(W=H);var Y=e.magnitudeSquared(e.subtract(s,z,w));if(Y>B){var k=Math.sqrt(Y);j=.5*(j+k),B=j*j;var Z=k-j;z.x=(j*z.x+Z*s.x)/k,z.y=(j*z.y+Z*s.y)/k,z.z=(j*z.z+Z*s.z)/k}}return j<W?(e.clone(z,u.center),u.radius=j):(e.clone(X,u.center),u.radius=W),u},p.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new p),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=_;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];for(var o=e.clone(a,y),u=e.clone(a,h),s=e.clone(a,d),c=e.clone(a,E),l=e.clone(a,m),f=e.clone(a,O),g=t.length,A=0;A<g;A+=3){var N=t[A]+r[A],S=t[A+1]+r[A+1],x=t[A+2]+r[A+2];a.x=N,a.y=S,a.z=x,N<o.x&&e.clone(a,o),N>c.x&&e.clone(a,c),S<u.y&&e.clone(a,u),S>l.y&&e.clone(a,l),x<s.z&&e.clone(a,s),x>f.z&&e.clone(a,f)}var I=e.magnitudeSquared(e.subtract(c,o,w)),M=e.magnitudeSquared(e.subtract(l,u,w)),C=e.magnitudeSquared(e.subtract(f,s,w)),P=o,L=c,U=I;M>U&&(U=M,P=u,L=l),C>U&&(U=C,P=s,L=f);var D=T;D.x=.5*(P.x+L.x),D.y=.5*(P.y+L.y),D.z=.5*(P.z+L.z);var F=e.magnitudeSquared(e.subtract(L,D,w)),q=Math.sqrt(F),z=v;z.x=o.x,z.y=u.y,z.z=s.z;var B=b;B.x=c.x,B.y=l.y,B.z=f.z;var j=e.multiplyByScalar(e.add(z,B,w),.5,R),G=0;for(A=0;A<g;A+=3){a.x=t[A]+r[A],a.y=t[A+1]+r[A+1],a.z=t[A+2]+r[A+2];var V=e.magnitude(e.subtract(a,j,w));V>G&&(G=V);var X=e.magnitudeSquared(e.subtract(a,D,w));if(X>F){var W=Math.sqrt(X);q=.5*(q+W),F=q*q;var H=W-q;D.x=(q*D.x+H*a.x)/W,D.y=(q*D.y+H*a.y)/W,D.z=(q*D.z+H*a.z)/W}}return q<G?(e.clone(D,n.center),n.radius=q):(e.clone(j,n.center),n.radius=G),n},p.fromCornerPoints=function(t,n,a){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(a)||(a=new p);var o=a.center;return e.add(t,n,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,n),a},p.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new p),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var M=new e;p.fromBoundingSpheres=function(t,r){if(i(r)||(r=new p),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return p.clone(t[0],r);if(2===n)return p.union(t[0],t[1],r);for(var a=[],o=0;o<n;o++)a.push(t[o].center);r=p.fromPoints(a,r);var u=r.center,s=r.radius;for(o=0;o<n;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,M)+c.radius)}return r.radius=s,r};var C=new e,P=new e,L=new e;p.fromOrientedBoundingBox=function(t,r){i(r)||(r=new p);var n=t.halfAxes,a=c.getColumn(n,0,C),o=c.getColumn(n,1,P),u=c.getColumn(n,2,L),s=e.magnitude(a),l=e.magnitude(o),f=e.magnitude(u);return r.center=e.clone(t.center,r.center),r.radius=Math.max(s,l,f),r},p.clone=function(t,r){if(i(t))return i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new p(t.center,t.radius)},p.packedLength=4,p.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var a=e.center;return t[i++]=a.x,t[i++]=a.y,t[i++]=a.z,t[i]=e.radius,t},p.unpack=function(e,t,a){r.defined("array",e),t=n(t,0),i(a)||(a=new p);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var U=new e,D=new e;p.union=function(t,n,a){r.typeOf.object("left",t),r.typeOf.object("right",n),i(a)||(a=new p);var o=t.center,u=t.radius,s=n.center,c=n.radius,l=e.subtract(s,o,U),f=e.magnitude(l);if(u>=f+c)return t.clone(a),a;if(c>=f+u)return n.clone(a),a;var y=.5*(u+f+c),h=e.multiplyByScalar(l,(-u+y)/f,D);return e.add(h,o,h),e.clone(h,a.center),a.radius=y,a};var F=new e;p.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=p.clone(t,i);var a=e.magnitude(e.subtract(n,i.center,F));return a>i.radius&&(i.radius=a),i},p.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,a=t.radius,o=n.normal,s=e.dot(o,i)+n.distance;return s<-a?u.OUTSIDE:s<a?u.INTERSECTING:u.INSIDE},p.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new p),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var q=new e;p.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,q);return e.magnitudeSquared(i)-t.radius*t.radius},p.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new p),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;p.computePlaneDistances=function(t,n,a,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",a),i(o)||(o=new s);var u=e.subtract(t.center,n,z),c=e.dot(a,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var B=new e,j=new e,G=new e,V=new e,X=new e,W=new t,H=new Array(8),Y=0;Y<8;++Y)H[Y]=new e;var k=new o;return p.projectTo2D=function(t,i,a){r.typeOf.object("sphere",t),i=n(i,k);var o=i.ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,B),l=e.cross(e.UNIT_Z,c,j);e.normalize(l,l);var f=e.cross(c,l,G);e.normalize(f,f),e.multiplyByScalar(c,s,c),e.multiplyByScalar(f,s,f),e.multiplyByScalar(l,s,l);var y=e.negate(f,X),h=e.negate(l,V),d=H,E=d[0];e.add(c,f,E),e.add(E,l,E),E=d[1],e.add(c,f,E),e.add(E,h,E),E=d[2],e.add(c,y,E),e.add(E,h,E),E=d[3],e.add(c,y,E),e.add(E,l,E),e.negate(c,c),E=d[4],e.add(c,f,E),e.add(E,l,E),E=d[5],e.add(c,f,E),e.add(E,h,E),E=d[6],e.add(c,y,E),e.add(E,h,E),E=d[7],e.add(c,y,E),e.add(E,l,E);for(var m=d.length,O=0;O<m;++O){var _=d[O];e.add(u,_,_);var w=o.cartesianToCartographic(_,W);i.project(w,_)}a=p.fromPoints(d,a),u=a.center;var T=u.x,v=u.y,b=u.z;return u.x=b,u.y=T,u.z=v,a},p.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},p.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},p.prototype.intersectPlane=function(e){return p.intersectPlane(this,e)},p.prototype.distanceSquaredTo=function(e){return p.distanceSquaredTo(this,e)},p.prototype.computePlaneDistances=function(e,t,r){return p.computePlaneDistances(this,e,t,r)},p.prototype.isOccluded=function(e){return p.isOccluded(this,e)},p.prototype.equals=function(e){return p.equals(this,e)},p.prototype.clone=function(e){return p.clone(this,e)},p}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var a=0;a<i;++a)o.pack(t[a],n,2*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var a=0;a<i;a+=2){var u=a/2;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){if(!r(e)||!r(t))throw new n("left and right are required.");return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){if(!r(e)||!r(t))throw new n("left and right are required.");return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,l=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,l),a.acosClamped(o.dot(c,l))};var f=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(i.supportsFullscreen())return null!==i.element}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;o<u;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function i(){if(!t(T)&&(T=!1,!p())){var e=/ Chrome\/([\.0-9]+)/.exec(w.userAgent);null!==e&&(T=!0,v=n(e[1]))}return T}function a(){return i()&&v}function o(){if(!t(b)&&(b=!1,!i()&&!p()&&/ Safari\/[\.0-9]+/.test(w.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(w.userAgent);null!==e&&(b=!0,R=n(e[1]))}return b}function u(){return o()&&R}function s(){if(!t(g)){g=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(w.userAgent);null!==e&&(g=!0,A=n(e[1]),A.isNightly=!!e[2])}return g}function c(){return s()&&A}function l(){if(!t(N)){N=!1;var e;"Microsoft Internet Explorer"===w.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(w.userAgent),null!==e&&(N=!0,S=n(e[1]))):"Netscape"===w.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(w.userAgent),null!==e&&(N=!0,S=n(e[1])))}return N}function f(){return l()&&S}function p(){if(!t(x)){x=!1;var e=/ Edge\/([\.0-9]+)/.exec(w.userAgent);null!==e&&(x=!0,I=n(e[1]))}return x}function y(){return p()&&I}function h(){if(!t(M)){M=!1;var e=/Firefox\/([\.0-9]+)/.exec(w.userAgent);null!==e&&(M=!0,C=n(e[1]))}return M}function d(){return t(P)||(P=/Windows/i.test(w.appVersion)),P}function E(){return h()&&C}function m(){return t(L)||(L="undefined"!=typeof PointerEvent&&(!t(w.pointerEnabled)||w.pointerEnabled)),L}function O(){if(!t(D)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;D=t(r)&&""!==r,D&&(U=r)}return D}function _(){return O()?U:void 0}var w;w="undefined"!=typeof navigator?navigator:{};var T,v,b,R,g,A,N,S,x,I,M,C,P,L,U,D,F={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isEdge:p,edgeVersion:y,isFirefox:h,firefoxVersion:E,isWindows:d,hardwareConcurrency:e(w.hardwareConcurrency,3),supportsPointerEvents:m,supportsImageRenderingPixelated:O,imageRenderingValue:_};return F.supportsFullscreen=function(){return r.supportsFullscreen()},F.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},F.supportsWebWorkers=function(){return"undefined"!=typeof Worker},F}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,
UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,i,a){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(n,i,a,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.INT:return new Int32Array(i,a,u);case o.UNSIGNED_INT:return new Uint32Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new r("componentDatatype is not a valid value.")}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}},i(o)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,i){"use strict";function a(a){if(a=e(a,e.EMPTY_OBJECT),!t(a.attributes))throw new r("options.attributes is required.");this.attributes=a.attributes,this.indices=a.indices,this.primitiveType=e(a.primitiveType,i.TRIANGLES),this.boundingSphere=a.boundingSphere,this.geometryType=e(a.geometryType,n.NONE),this.boundingSphereCV=a.boundingSphereCV}return a.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&n!==-1)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";function i(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.geometry))throw new r("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}return i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,i){"use strict";var a={};a.octEncodeInRange=function(e,a,o){if(!r(e))throw new n("vector is required.");if(!r(o))throw new n("result is required.");var u=t.magnitudeSquared(e);if(Math.abs(u-1)>i.EPSILON6)throw new n("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=o.x,c=o.y;o.x=(1-Math.abs(c))*i.signNotZero(s),o.y=(1-Math.abs(s))*i.signNotZero(c)}return o.x=i.toSNorm(o.x,a),o.y=i.toSNorm(o.y,a),o},a.octEncode=function(e,t){return a.octEncodeInRange(e,255,t)},a.octDecodeInRange=function(e,a,o,u){if(!r(u))throw new n("result is required.");if(e<0||e>o||a<0||a>o)throw new n("x and y must be a signed normalized integer between 0 and "+o);if(u.x=i.fromSNorm(e,o),u.y=i.fromSNorm(a,o),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*i.signNotZero(s),u.y=(1-Math.abs(s))*i.signNotZero(u.y)}return t.normalize(u,u)},a.octDecode=function(e,t,r){return a.octDecodeInRange(e,t,255,r)},a.octPackFloat=function(e){if(!r(e))throw new n("encoded is required.");return 256*e.x+e.y};var o=new e;return a.octEncodeFloat=function(e){return a.octEncode(e,o),a.octPackFloat(o)},a.octDecodeFloat=function(e,t){if(!r(e))throw new n("value is required.");var i=e/256,o=Math.floor(i),u=256*(i-o);return a.octDecode(o,u,t)},a.octPack=function(e,t,i,u){if(!r(e))throw new n("v1 is required.");if(!r(t))throw new n("v2 is required.");if(!r(i))throw new n("v3 is required.");if(!r(u))throw new n("result is required.");var s=a.octEncodeFloat(e),c=a.octEncodeFloat(t),l=a.octEncode(i,o);return u.x=65536*l.x+s,u.y=65536*l.y+c,u},a.octUnpack=function(e,t,i,o){if(!r(e))throw new n("packed is required.");if(!r(t))throw new n("v1 is required.");if(!r(i))throw new n("v2 is required.");if(!r(o))throw new n("v3 is required.");var u=e.x/65536,s=Math.floor(u),c=65536*(u-s);u=e.y/65536;var l=Math.floor(u),f=65536*(u-l);a.octDecodeFloat(c,t),a.octDecodeFloat(f,i),a.octDecode(s,l,o)},a.compressTextureCoordinates=function(e){if(!r(e))throw new n("textureCoordinates is required.");var t=4095*e.x|0,i=4095*e.y|0;return 4096*t+i},a.decompressTextureCoordinates=function(e,t){if(!r(e))throw new n("compressed is required.");if(!r(t))throw new n("result is required.");var i=e/4096,a=Math.floor(i);return t.x=a/4095,t.y=(e-4096*a)/4095,t},a}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(i,s,c,l,f){if(!(r(i)&&r(s)&&r(c)&&r(l)))throw new n("point, p0, p1, and p2 are required.");r(f)||(f=new t);var p,y,h,d,E,m,O,_;r(s.z)?(p=t.subtract(c,s,a),y=t.subtract(l,s,o),h=t.subtract(i,s,u),d=t.dot(p,p),E=t.dot(p,y),m=t.dot(p,h),O=t.dot(y,y),_=t.dot(y,h)):(p=e.subtract(c,s,a),y=e.subtract(l,s,o),h=e.subtract(i,s,u),d=e.dot(p,p),E=e.dot(p,y),m=e.dot(p,h),O=e.dot(y,y),_=e.dot(y,h));var w=1/(d*O-E*E);return f.y=(O*m-E*_)*w,f.z=(d*_-E*m)*w,f.x=1-f.y-f.z,f}var a=new t,o=new t,u=new t;return i}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,n){if(!t(e))throw new r("value is required");t(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){if(!t(e))throw new r("cartesian is required");t(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,i,o){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("cartesianArray is required");if("number"!=typeof o||o<0)throw new r("index must be a number greater than or equal to 0.");n.fromCartesian(e,a);var u=a.high,s=a.low;i[o]=u.x,i[o+1]=u.y,i[o+2]=u.z,i[o+3]=s.x,i[o+4]=s.y,i[o+5]=s.z},n}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(r,i){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},a.createTypedArrayFromArrayBuffer=function(r,i,a,o){if(!e(r))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(a))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,a,o):new Uint16Array(i,a,o)},r(a)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.computeRealRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(u<s&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if(o=-a/n,o<0)return[];var c=Math.sqrt(o);return[-c,c]}if(0===a)return o=-i/n,o<0?[o,0]:[0,o];var l=i*i,f=4*n*a,p=r(l,-f,t.EPSILON14);if(p<0)return[];var y=-.5*r(i,t.sign(i)*Math.sqrt(p),t.EPSILON14);return i>0?[y/n,a/y]:[a/y,y/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,a,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,p=u*u,y=s*s,h=o*s-p,d=o*c-u*s,E=u*c-y,m=4*h*E-d*d;if(m<0){var O,_,w;p*f>=l*y?(O=o,_=h,w=-2*u*h+o*d):(O=c,_=E,w=-c*d+2*s*E);var T=w<0?-1:1,v=-T*Math.abs(O)*Math.sqrt(-m);a=-w+v;var b=a/2,R=b<0?-Math.pow(-b,1/3):Math.pow(b,1/3),g=a===v?-R:-_/R;return i=_<=0?R+g:-w/(R*R+g*g+_),p*f>=l*y?[(i-u)/o]:[-c/(i+s)]}var A=h,N=-2*u*h+o*d,S=E,x=-c*d+2*s*E,I=Math.sqrt(m),M=Math.sqrt(3)/2,C=Math.abs(Math.atan2(o*I,-N)/3);i=2*Math.sqrt(-A);var P=Math.cos(C);a=i*P;var L=i*(-P/2-M*Math.sin(C)),U=a+L>2*u?a-u:L-u,D=o,F=U/D;C=Math.abs(Math.atan2(c*I,-x)/3),i=2*Math.sqrt(-S),P=Math.cos(C),a=i*P,L=i*(-P/2-M*Math.sin(C));var q=-c,z=a+L<2*s?a+s:L+s,B=q/z,j=D*z,G=-U*z-D*q,V=U*q,X=(s*G-u*V)/(-u*G+s*j);return F<=X?F<=B?X<=B?[F,X,B]:[F,B,X]:[B,F,X]:F<=B?[X,F,B]:X<=B?[X,B,F]:[B,X,F]}var n={};return n.computeDiscriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=t*t,o=r*r,u=n*n,s=i*i,c=18*t*r*n*i+o*u-27*a*s-4*(t*u*n+o*r*i);return c},n.computeRealRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return t.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var c=s<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===o?(u=t.computeRealRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):r(n,0,a,o)}return 0===a?0===o?(s=-i/n,s<0?[s,0,0]:[0,0,s]):r(n,i,0,o):0===o?(u=t.computeRealRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):r(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,l=o-a*t/4+i*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var p=-t/4,y=f[f.length-1];if(Math.abs(y)<r.EPSILON14){var h=n.computeRealRoots(1,s,l);if(2===h.length){var d,E=h[0],m=h[1];if(E>=0&&m>=0){var O=Math.sqrt(E),_=Math.sqrt(m);return[p-_,p-O,p+O,p+_]}if(E>=0&&m<0)return d=Math.sqrt(E),[p-d,p+d];if(E<0&&m>=0)return d=Math.sqrt(m),[p-d,p+d]}return[]}if(y>0){var w=Math.sqrt(y),T=(s+y-c/w)/2,v=(s+y+c/w)/2,b=n.computeRealRoots(1,w,T),R=n.computeRealRoots(1,-w,v);return 0!==b.length?(b[0]+=p,b[1]+=p,0!==R.length?(R[0]+=p,R[1]+=p,b[1]<=R[0]?[b[0],b[1],R[0],R[1]]:R[1]<=b[0]?[R[0],R[1],b[0],b[1]]:b[0]>=R[0]&&b[1]<=R[1]?[R[0],b[0],b[1],R[1]]:R[0]>=b[0]&&R[1]<=b[1]?[b[0],R[0],R[1],b[1]]:b[0]>R[0]&&b[0]<R[1]?[R[0],b[0],R[1],b[1]]:[b[0],R[0],b[1],R[1]]):b):0!==R.length?(R[0]+=p,R[1]+=p,R):[]}}return[]}function a(t,i,a,o){var u=a*a,s=i*i,c=t*t,l=-2*i,f=a*t+s-4*o,p=c*o-a*i*t+u,y=e.computeRealRoots(1,l,f,p);if(y.length>0){var h,d,E=y[0],m=i-E,O=m*m,_=t/2,w=m/2,T=O-4*o,v=O+4*Math.abs(o),b=c-4*E,R=c+4*Math.abs(E);if(E<0||T*R<b*v){var g=Math.sqrt(b);h=g/2,d=0===g?0:(t*w-a)/g}else{var A=Math.sqrt(T);h=0===A?0:(t*w-a)/A,d=A/2}var N,S;0===_&&0===h?(N=0,S=0):r.sign(_)===r.sign(h)?(N=_+h,S=E/N):(S=_-h,N=E/S);var x,I;0===w&&0===d?(x=0,I=0):r.sign(w)===r.sign(d)?(x=w+d,I=o/x):(I=w-d,x=o/I);var M=n.computeRealRoots(1,N,x),C=n.computeRealRoots(1,S,I);if(0!==M.length)return 0!==C.length?M[1]<=C[0]?[M[0],M[1],C[0],C[1]]:C[1]<=M[0]?[C[0],C[1],M[0],M[1]]:M[0]>=C[0]&&M[1]<=C[1]?[C[0],M[0],M[1],C[1]]:C[0]>=M[0]&&C[1]<=M[1]?[M[0],C[0],C[1],M[1]]:M[0]>C[0]&&M[0]<C[1]?[C[0],M[0],C[1],M[1]]:[M[0],C[0],M[1],C[1]]:M;if(0!==C.length)return C}return[]}var o={};return o.computeDiscriminant=function(e,r,n,i,a){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof a)throw new t("e is a required number.");var o=e*e,u=o*e,s=r*r,c=s*r,l=n*n,f=l*n,p=i*i,y=p*i,h=a*a,d=h*a,E=s*l*p-4*c*y-4*e*f*p+18*e*r*n*y-27*o*p*p+256*u*d+a*(18*c*n*i-4*s*f+16*e*l*l-80*e*r*l*i-6*e*s*p+144*o*n*p)+h*(144*e*s*n-27*s*s-128*o*l-192*o*r*i);return E},o.computeRealRoots=function(n,o,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof o)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(o,u,s,c);var l=o/n,f=u/n,p=s/n,y=c/n,h=l<0?1:0;switch(h+=f<0?h+1:h,h+=p<0?h+1:h,h+=y<0?h+1:h){case 0:return i(l,f,p,y);case 1:return a(l,f,p,y);case 2:return a(l,f,p,y);case 3:return i(l,f,p,y);case 4:return i(l,f,p,y);case 5:return a(l,f,p,y);case 6:return i(l,f,p,y);case 7:return i(l,f,p,y);case 8:return a(l,f,p,y);case 9:return i(l,f,p,y);case 10:return i(l,f,p,y);case 11:return a(l,f,p,y);case 12:return i(l,f,p,y);case 13:return i(l,f,p,y);case 14:return i(l,f,p,y);case 15:return i(l,f,p,y);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n}return i.getPoint=function(t,i,a){if(!r(t))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,i,a),e.add(t.origin,a,a)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,i,a,o,u,s,c,l){"use strict";function f(e,t,r,n){var i=t*t-4*e*r;if(!(i<0)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function p(t,r,i){n(i)||(i=new a);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,l=e.subtract(o,s,O),p=e.dot(u,u),y=2*e.dot(u,l),h=e.magnitudeSquared(l)-c,d=f(p,y,h,v);if(n(d))return i.start=d.root0,i.stop=d.root1,i}function y(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function h(t,r,n,i,a){var l,f=i*i,p=a*a,h=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*p,d=a*(i*y(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),E=t[u.COLUMN0ROW0]*f+t[u.COLUMN2ROW2]*p+i*r.x+n,m=p*y(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),O=a*(i*y(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),_=[];if(0===O&&0===m){if(l=s.computeRealRoots(h,d,E),0===l.length)return _;var w=l[0],T=Math.sqrt(Math.max(1-w*w,0));if(_.push(new e(i,a*w,a*-T)),_.push(new e(i,a*w,a*T)),2===l.length){var v=l[1],b=Math.sqrt(Math.max(1-v*v,0));_.push(new e(i,a*v,a*-b)),_.push(new e(i,a*v,a*b))}return _}var R=O*O,g=m*m,A=h*h,N=O*m,S=A+g,x=2*(d*h+N),I=2*E*h+d*d-g+R,M=2*(E*d-N),C=E*E-R;if(0===S&&0===x&&0===I&&0===M)return _;l=c.computeRealRoots(S,x,I,M,C);var P=l.length;if(0===P)return _;for(var L=0;L<P;++L){var U,D=l[L],F=D*D,q=Math.max(1-F,0),z=Math.sqrt(q);U=o.sign(h)===o.sign(E)?y(h*F+E,d*D,o.EPSILON12):o.sign(E)===o.sign(d*D)?y(h*F,d*D+E,o.EPSILON12):y(h*F+d*D,E,o.EPSILON12);var B=y(m*D,O,o.EPSILON15),j=U*B;j<0?_.push(new e(i,a*D,a*z)):j>0?_.push(new e(i,a*D,a*-z)):0!==z?(_.push(new e(i,a*D,a*-z)),_.push(new e(i,a*D,a*z)),++L):_.push(new e(i,a*D,a*z))}return _}var d={};d.rayPlane=function(t,r,a){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("plane is required.");n(a)||(a=new e);var u=t.origin,s=t.direction,c=r.normal,l=e.dot(c,s);if(!(Math.abs(l)<o.EPSILON15)){var f=(-r.distance-e.dot(c,u))/l;if(!(f<0))return a=e.multiplyByScalar(s,f,a),e.add(u,a,a)}};var E=new e,m=new e,O=new e,_=new e,w=new e;d.rayTriangleParametric=function(t,a,u,s,c){if(!n(t))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=r(c,!1);var l,f,p,y,h,d=t.origin,T=t.direction,v=e.subtract(u,a,E),b=e.subtract(s,a,m),R=e.cross(T,b,O),g=e.dot(v,R);if(c){if(g<o.EPSILON6)return;if(l=e.subtract(d,a,_),p=e.dot(l,R),p<0||p>g)return;if(f=e.cross(l,v,w),y=e.dot(T,f),y<0||p+y>g)return;h=e.dot(b,f)/g}else{if(Math.abs(g)<o.EPSILON6)return;var A=1/g;if(l=e.subtract(d,a,_),p=e.dot(l,R)*A,p<0||p>1)return;if(f=e.cross(l,v,w),y=e.dot(T,f)*A,y<0||p+y>1)return;h=e.dot(b,f)*A}return h},d.rayTriangle=function(t,r,i,a,o,u){var s=d.rayTriangleParametric(t,r,i,a,o);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var T=new l;d.lineSegmentTriangle=function(t,r,a,o,u,s,c){if(!n(t))throw new i("v0 is required.");if(!n(r))throw new i("v1 is required.");if(!n(a))throw new i("p0 is required.");if(!n(o))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");var l=T;e.clone(t,l.origin),e.subtract(r,t,l.direction),e.normalize(l.direction,l.direction);var f=d.rayTriangleParametric(l,a,o,u,s);if(!(!n(f)||f<0||f>e.distance(t,r)))return n(c)||(c=new e),e.multiplyByScalar(l.direction,f,c),e.add(l.origin,c,c)};var v={root0:0,root1:0};d.raySphere=function(e,t,r){if(!n(e))throw new i("ray is required.");if(!n(t))throw new i("sphere is required.");if(r=p(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var b=new l;d.lineSegmentSphere=function(t,r,a,o){if(!n(t))throw new i("p0 is required.");if(!n(r))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=b;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);if(e.normalize(s,s),o=p(u,a,o),!(!n(o)||o.stop<0||o.start>c))return o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,c),o};var R=new e,g=new e;d.rayEllipsoid=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var o,u,s,c,l,f=r.oneOverRadii,p=e.multiplyComponents(f,t.origin,R),y=e.multiplyComponents(f,t.direction,g),h=e.magnitudeSquared(p),d=e.dot(p,y);if(h>1){if(d>=0)return;var E=d*d;if(o=h-1,u=e.magnitudeSquared(y),s=u*o,E<s)return;if(E>s){c=d*d-s,l=-d+Math.sqrt(c);var m=l/u,O=o/l;return m<O?new a(m,O):{start:O,stop:m}}var _=Math.sqrt(o/u);return new a(_,_)}return h<1?(o=h-1,u=e.magnitudeSquared(y),s=u*o,c=d*d-s,l=-d+Math.sqrt(c),new a(0,l/u)):d<0?(u=e.magnitudeSquared(y),new a(0,-d/u)):void 0};var A=new e,N=new e,S=new e,x=new e,I=new e,M=new u,C=new u,P=new u,L=new u,U=new u,D=new u,F=new u,q=new e,z=new e,B=new t;d.grazingAltitudeLocation=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var a=t.origin,s=t.direction;if(!e.equals(a,e.ZERO)){var c=r.geodeticSurfaceNormal(a,A);if(e.dot(s,c)>=0)return a}var l=n(this.rayEllipsoid(t,r)),f=r.transformPositionToScaledSpace(s,A),p=e.normalize(f,f),y=e.mostOrthogonalAxis(f,x),d=e.normalize(e.cross(y,p,N),N),E=e.normalize(e.cross(p,d,S),S),m=M;m[0]=p.x,m[1]=p.y,m[2]=p.z,m[3]=d.x,m[4]=d.y,m[5]=d.z,m[6]=E.x,m[7]=E.y,m[8]=E.z;var O=u.transpose(m,C),_=u.fromScale(r.radii,P),w=u.fromScale(r.oneOverRadii,L),T=U;T[0]=0,T[1]=-s.z,T[2]=s.y,T[3]=s.z,T[4]=0,T[5]=-s.x,T[6]=-s.y,T[7]=s.x,T[8]=0;var v,b,R=u.multiply(u.multiply(O,w,D),T,D),g=u.multiply(u.multiply(R,_,F),m,F),j=u.multiplyByVector(R,a,I),G=h(g,e.negate(j,A),0,0,1),V=G.length;if(V>0){for(var X=e.clone(e.ZERO,z),W=Number.NEGATIVE_INFINITY,H=0;H<V;++H){v=u.multiplyByVector(_,u.multiplyByVector(m,G[H],q),q);var Y=e.normalize(e.subtract(v,a,x),x),k=e.dot(Y,s);k>W&&(W=k,X=e.clone(v,X))}var Z=r.cartesianToCartographic(X,B);return W=o.clamp(W,0,1),b=e.magnitude(e.subtract(X,a,x))*Math.sqrt(1-W*W),b=l?-b:b,Z.height=b,r.cartographicToCartesian(Z,new e)}};var j=new e;return d.lineSegmentPlane=function(t,r,a,u){if(!n(t))throw new i("endPoint0 is required.");if(!n(r))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,j),c=a.normal,l=e.dot(c,s);if(!(Math.abs(l)<o.EPSILON6)){var f=e.dot(c,t),p=-(a.distance+f)/l;if(!(p<0||p>1))return e.multiplyByScalar(s,p,u),e.add(t,u,u),u}},d.trianglePlaneIntersection=function(t,r,a,o){if(!(n(t)&&n(r)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,c=e.dot(u,t)+s<0,l=e.dot(u,r)+s<0,f=e.dot(u,a)+s<0,p=0;p+=c?1:0,p+=l?1:0,p+=f?1:0;var y,h;if(1!==p&&2!==p||(y=new e,h=new e),1===p){if(c)return d.lineSegmentPlane(t,r,o,y),d.lineSegmentPlane(t,a,o,h),{positions:[t,r,a,y,h],indices:[0,3,4,1,2,4,1,4,3]};if(l)return d.lineSegmentPlane(r,a,o,y),d.lineSegmentPlane(r,t,o,h),{positions:[t,r,a,y,h],indices:[1,3,4,2,0,4,2,4,3]};if(f)return d.lineSegmentPlane(a,t,o,y),d.lineSegmentPlane(a,r,o,h),{positions:[t,r,a,y,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===p){if(!c)return d.lineSegmentPlane(r,t,o,y),d.lineSegmentPlane(a,t,o,h),{positions:[t,r,a,y,h],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return d.lineSegmentPlane(a,r,o,y),d.lineSegmentPlane(t,r,o,h),{positions:[t,r,a,y,h],indices:[2,0,4,2,4,3,1,3,4]};if(!f)return d.lineSegmentPlane(t,a,o,y),d.lineSegmentPlane(r,a,o,h),{positions:[t,r,a,y,h],indices:[0,1,4,0,4,3,2,3,4]}}},d}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function i(n,i){if(!t(n))throw new r("normal is required.");if(!t(i))throw new r("distance is required.");this.normal=e.clone(n),this.distance=i}i.fromPointNormal=function(n,a,o){if(!t(n))throw new r("point is required.");if(!t(a))throw new r("normal is required.");var u=-e.dot(a,n);return t(o)?(e.clone(a,o.normal),o.distance=u,o):new i(a,u)};var a=new e;return i.fromCartesian4=function(n,o){if(!t(n))throw new r("coefficients is required.");var u=e.fromCartesian4(n,a),s=n.w;return t(o)?(e.clone(u,o.normal),o.distance=s,o):new i(u,s)},i.getPointDistance=function(n,i){if(!t(n))throw new r("plane is required.");if(!t(i))throw new r("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var u=i.length;if(u<3||u%3!==0)throw new r("indices length must be a multiple of three.");if(a<=0)throw new r("maximumIndex must be greater than zero.");if(o<3)throw new r("cacheSize must be greater than two.");if(!t(a)){a=0;for(var s=0,c=i[s];s<u;)c>a&&(a=c),++s,c=i[s]}for(var l=[],f=0;f<a+1;f++)l[f]=0;for(var p=o+1,y=0;y<u;++y)p-l[i[y]]>o&&(l[i[y]]=p,++p);return(p-o+1)/(u/3)},n.tipsify=function(n){function i(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;o<n;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function a(e,t,r,n,a,o,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var p=r[f];n[p].numLiveTriangles&&(s=0,a-n[p].timeStamp+2*n[p].numLiveTriangles<=t&&(s=a-n[p].timeStamp),(s>l||l===-1)&&(l=s,c=p)),++f}return c===-1?i(n,o,e,u):c}n=e(n,e.EMPTY_OBJECT);var o,u=n.indices,s=n.maximumIndex,c=e(n.cacheSize,24);if(!t(u))throw new r("indices is required.");var l=u.length;if(l<3||l%3!==0)throw new r("indices length must be a multiple of three.");if(s<=0)throw new r("maximumIndex must be greater than zero.");if(c<3)throw new r("cacheSize must be greater than two.");var f=0,p=0,y=u[p],h=l;if(t(s))f=s+1;else{for(;p<h;)y>f&&(f=y),++p,y=u[p];if(f===-1)return 0;++f}for(var d=[],E=0;E<f;E++)d[E]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};p=0;for(var m=0;p<h;)d[u[p]].vertexTriangles.push(m),++d[u[p]].numLiveTriangles,d[u[p+1]].vertexTriangles.push(m),++d[u[p+1]].numLiveTriangles,d[u[p+2]].vertexTriangles.push(m),++d[u[p+2]].numLiveTriangles,++m,p+=3;var O=0,_=c+1;o=1;var w,T,v=[],b=[],R=0,g=[],A=l/3,N=[];for(E=0;E<A;E++)N[E]=!1;for(var S,x;O!==-1;){v=[],T=d[O],x=T.vertexTriangles.length;for(var I=0;I<x;++I)if(m=T.vertexTriangles[I],!N[m]){N[m]=!0,p=m+m+m;for(var M=0;M<3;++M)S=u[p],v.push(S),b.push(S),g[R]=S,++R,w=d[S],--w.numLiveTriangles,_-w.timeStamp>c&&(w.timeStamp=_,++_),++p}O=a(u,c,v,d,_,b,f)}return g},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,i,a,o,u,s,c,l,f,p,y,h,d,E,m,O,_,w,T,v,b,R){"use strict";function g(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function A(e){for(var t=e.length,r=t/3*6,n=E.createTypedArray(t,r),i=0,a=0;a<t;a+=3,i+=6)g(n,i,e[a],e[a+1],e[a+2]);return n}function N(e){var t=e.length;if(t>=3){var r=6*(t-2),n=E.createTypedArray(t,r);g(n,0,e[0],e[1],e[2]);for(var i=6,a=3;a<t;++a,i+=6)g(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function S(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=E.createTypedArray(t,r),i=e[0],a=0,o=1;o<t;++o,a+=6)g(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function x(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new h({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function I(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var i=t[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[r*i.componentsPerAttribute+a])}function M(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;a<n;a+=3)i.unpack(r,a,ae),T.multiplyByPoint(e,ae,ae),i.pack(ae,r,a)}function C(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;a<n;a+=3)i.unpack(r,a,ae),w.multiplyByVector(e,ae,ae),ae=i.normalize(ae,ae),i.pack(ae,r,a)}function P(e,t){var r,n=e.length,i={},a=e[0][t].attributes;for(r in a)if(a.hasOwnProperty(r)&&c(a[r])&&c(a[r].values)){for(var o=a[r],s=o.values.length,l=!0,f=1;f<n;++f){var p=e[f][t].attributes[r];if(!c(p)||o.componentDatatype!==p.componentDatatype||o.componentsPerAttribute!==p.componentsPerAttribute||o.normalize!==p.normalize){
l=!1;break}s+=p.values.length}l&&(i[r]=new h({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return i}function L(e,t){var n,a,o,u,s=e.length,f=e[0].modelMatrix,p=c(e[0][t].indices),h=e[0][t].primitiveType;for(a=1;a<s;++a){if(!T.equals(e[a].modelMatrix,f))throw new l("All instances must have the same modelMatrix.");if(c(e[a][t].indices)!==p)throw new l("All instance geometries must have an indices or not have one.");if(e[a][t].primitiveType!==h)throw new l("All instance geometries must have the same primitiveType.")}var d,m,O,_=P(e,t);for(n in _)if(_.hasOwnProperty(n))for(d=_[n].values,u=0,a=0;a<s;++a)for(m=e[a][t].attributes[n].values,O=m.length,o=0;o<O;++o)d[u++]=m[o];var w;if(p){var v=0;for(a=0;a<s;++a)v+=e[a][t].indices.length;var R=y.computeNumberOfVertices(new y({attributes:_,primitiveType:b.POINTS})),g=E.createTypedArray(R,v),A=0,N=0;for(a=0;a<s;++a){var S=e[a][t].indices,x=S.length;for(u=0;u<x;++u)g[A++]=N+S[u];N+=y.computeNumberOfVertices(e[a][t])}w=g}var I,M=new i,C=0;for(a=0;a<s;++a){if(I=e[a][t].boundingSphere,!c(I)){M=void 0;break}i.add(I.center,M,M)}if(c(M))for(i.divideByScalar(M,s,M),a=0;a<s;++a){I=e[a][t].boundingSphere;var L=i.magnitude(i.subtract(I.center,M,se))+I.radius;L>C&&(C=L)}return new y({attributes:_,indices:w,primitiveType:h,boundingSphere:c(M)?new r(M,C):void 0})}function U(e){if(c(e.indices))return e;var t=y.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least three.");if(t%3!==0)throw new l("The number of vertices must be a multiple of three.");for(var r=E.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}function D(e){var t=y.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least three.");var r=E.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,i=3;i<t;++i)r[n++]=i-1,r[n++]=0,r[n++]=i;return e.indices=r,e.primitiveType=b.TRIANGLES,e}function F(e){var t=y.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least 3.");var r=E.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,i=3;i<t-1;i+=2)r[n++]=i,r[n++]=i-1,r[n++]=i+1,i+2<t&&(r[n++]=i,r[n++]=i+1,r[n++]=i+2);return e.indices=r,e.primitiveType=b.TRIANGLES,e}function q(e){if(c(e.indices))return e;var t=y.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");if(t%2!==0)throw new l("The number of vertices must be a multiple of 2.");for(var r=E.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}function z(e){var t=y.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");var r=E.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return e.indices=r,e.primitiveType=b.LINES,e}function B(e){var t=y.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");var r=E.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=b.LINES,e}function j(e){switch(e.primitiveType){case b.TRIANGLE_FAN:return D(e);case b.TRIANGLE_STRIP:return F(e);case b.TRIANGLES:return U(e);case b.LINE_STRIP:return z(e);case b.LINE_LOOP:return B(e);case b.LINES:return q(e)}return e}function G(e,t){Math.abs(e.y)<_.EPSILON6&&(t?e.y=-_.EPSILON6:e.y=_.EPSILON6)}function V(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return G(e,e.y<0),G(t,t.y<0),void G(r,r.y<0);var n,i=Math.abs(e.y),a=Math.abs(t.y),o=Math.abs(r.y);n=i>a?i>o?_.sign(e.y):_.sign(r.y):a>o?_.sign(t.y):_.sign(r.y);var u=n<0;G(e,u),G(t,u),G(r,u)}function X(e,t,r,n){i.add(e,i.multiplyByScalar(i.subtract(t,e,Te),e.y/(e.y-t.y),Te),r),i.clone(r,n),G(r,!0),G(n,!1)}function W(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){V(e,t,r);var n=e.y<0,i=t.y<0,a=r.y<0,o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var u=Ae.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(X(e,t,ve,Re),X(e,r,be,ge),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(X(t,r,ve,Re),X(t,e,be,ge),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(X(r,e,ve,Re),X(r,t,be,ge),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(X(r,e,ve,Re),X(r,t,be,ge),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(X(t,r,ve,Re),X(t,e,be,ge),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(X(e,t,ve,Re),X(e,r,be,ge),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ae.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,1!==o&&2!==o||(s[3]=ve,s[4]=be,s[5]=Re,s[6]=ge,s.length=7),Ae}}function H(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var i in n)if(n.hasOwnProperty(i)&&c(n[i])&&c(n[i].values)){var a=n[i];a.values=u.createTypedArray(a.componentDatatype,a.values)}var o=y.computeNumberOfVertices(e);return e.indices=E.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function Y(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var i=t[n];r[n]=new h({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new y({attributes:r,indices:[],primitiveType:e.primitiveType})}function k(e,t,r){var n=c(e.geometry.boundingSphere);t=H(t,n),r=H(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function Z(e,r,a,o,u,s,l,f,p,y,h,d){if(c(s)||c(l)||c(f)||c(p)||c(y)){var E=i.fromArray(u,3*e,Ne),m=i.fromArray(u,3*r,Se),O=i.fromArray(u,3*a,xe),_=t(o,E,m,O,Ie);if(c(s)){var w=i.fromArray(s,3*e,Ne),T=i.fromArray(s,3*r,Se),v=i.fromArray(s,3*a,xe);i.multiplyByScalar(w,_.x,w),i.multiplyByScalar(T,_.y,T),i.multiplyByScalar(v,_.z,v);var b=i.add(w,T,w);i.add(b,v,b),i.normalize(b,b),i.pack(b,h.normal.values,3*d)}if(c(y)){var R=i.fromArray(y,3*e,Ne),g=i.fromArray(y,3*r,Se),A=i.fromArray(y,3*a,xe);i.multiplyByScalar(R,_.x,R),i.multiplyByScalar(g,_.y,g),i.multiplyByScalar(A,_.z,A);var N;i.equals(R,i.ZERO)&&i.equals(g,i.ZERO)&&i.equals(A,i.ZERO)?(N=Ne,N.x=0,N.y=0,N.z=0):(N=i.add(R,g,R),i.add(N,A,N),i.normalize(N,N)),i.pack(N,h.extrudeDirection.values,3*d)}if(c(l)){var S=i.fromArray(l,3*e,Ne),x=i.fromArray(l,3*r,Se),I=i.fromArray(l,3*a,xe);i.multiplyByScalar(S,_.x,S),i.multiplyByScalar(x,_.y,x),i.multiplyByScalar(I,_.z,I);var M=i.add(S,x,S);i.add(M,I,M),i.normalize(M,M),i.pack(M,h.tangent.values,3*d)}if(c(f)){var C=i.fromArray(f,3*e,Ne),P=i.fromArray(f,3*r,Se),L=i.fromArray(f,3*a,xe);i.multiplyByScalar(C,_.x,C),i.multiplyByScalar(P,_.y,P),i.multiplyByScalar(L,_.z,L);var U=i.add(C,P,C);i.add(U,L,U),i.normalize(U,U),i.pack(U,h.bitangent.values,3*d)}if(c(p)){var D=n.fromArray(p,2*e,Me),F=n.fromArray(p,2*r,Ce),q=n.fromArray(p,2*a,Pe);n.multiplyByScalar(D,_.x,D),n.multiplyByScalar(F,_.y,F),n.multiplyByScalar(q,_.z,q);var z=n.add(D,F,D);n.add(z,q,z),n.pack(z,h.st.values,2*d)}}}function K(e,t,r,n,i,a){var o=e.position.values.length/3;if(i!==-1){var u=n[i],s=r[u];return s===-1?(r[u]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(a.x,a.y,a.z),t.push(o),o}function Q(e){var t,r,n,a,o,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,p=c(s.bitangent)?s.bitangent.values:void 0,y=c(s.tangent)?s.tangent.values:void 0,h=c(s.st)?s.st.values:void 0,d=c(s.extrudeDirection)?s.extrudeDirection.values:void 0,E=u.indices,m=Y(u),O=Y(u),_=[];_.length=l.length/3;var w=[];for(w.length=l.length/3,o=0;o<_.length;++o)_[o]=-1,w[o]=-1;var T=E.length;for(o=0;o<T;o+=3){var v=E[o],b=E[o+1],R=E[o+2],g=i.fromArray(l,3*v),A=i.fromArray(l,3*b),N=i.fromArray(l,3*R),S=W(g,A,N);if(c(S)&&S.positions.length>3)for(var x=S.positions,I=S.indices,M=I.length,C=0;C<M;++C){var P=I[C],L=x[P];L.y<0?(t=O.attributes,r=O.indices,n=_):(t=m.attributes,r=m.indices,n=w),a=K(t,r,n,E,P<3?o+P:-1,L),Z(v,b,R,L,l,f,y,p,h,d,t,a)}else c(S)&&(g=S.positions[0],A=S.positions[1],N=S.positions[2]),g.y<0?(t=O.attributes,r=O.indices,n=_):(t=m.attributes,r=m.indices,n=w),a=K(t,r,n,E,o,g),Z(v,b,R,g,l,f,y,p,h,d,t,a),a=K(t,r,n,E,o+1,A),Z(v,b,R,A,l,f,y,p,h,d,t,a),a=K(t,r,n,E,o+2,N),Z(v,b,R,N,l,f,y,p,h,d,t,a)}k(e,O,m)}function J(e){var t,r=e.geometry,n=r.attributes,a=n.position.values,o=r.indices,u=Y(r),s=Y(r),l=o.length,f=[];f.length=a.length/3;var p=[];for(p.length=a.length/3,t=0;t<f.length;++t)f[t]=-1,p[t]=-1;for(t=0;t<l;t+=2){var y=o[t],h=o[t+1],d=i.fromArray(a,3*y,Ne),E=i.fromArray(a,3*h,Se);Math.abs(d.y)<_.EPSILON6&&(d.y<0?d.y=-_.EPSILON6:d.y=_.EPSILON6),Math.abs(E.y)<_.EPSILON6&&(E.y<0?E.y=-_.EPSILON6:E.y=_.EPSILON6);var m=u.attributes,w=u.indices,T=p,v=s.attributes,b=s.indices,R=f,g=O.lineSegmentPlane(d,E,Le,xe);if(c(g)){var A=i.multiplyByScalar(i.UNIT_Y,5*_.EPSILON9,Ue);d.y<0&&(i.negate(A,A),m=s.attributes,w=s.indices,T=f,v=u.attributes,b=u.indices,R=p);var N=i.add(g,A,De);K(m,w,T,o,t,d),K(m,w,T,o,-1,N),i.negate(A,A),i.add(g,A,N),K(v,b,R,o,-1,N),K(v,b,R,o,t+1,E)}else{var S,x,I;d.y<0?(S=s.attributes,x=s.indices,I=f):(S=u.attributes,x=u.indices,I=p),K(S,x,I,o,t,d),K(S,x,I,o,t+1,E)}}k(e,s,u)}function $(e){for(var t=e.attributes,r=t.position.values,n=t.prevPosition.values,a=t.nextPosition.values,o=r.length,u=0;u<o;u+=3){var s=i.unpack(r,u,ze);if(!(s.x>0)){var c=i.unpack(n,u,Be);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(u-3>0?(n[u]=r[u-3],n[u+1]=r[u-2],n[u+2]=r[u-1]):i.pack(s,n,u));var l=i.unpack(a,u,je);(s.y<0&&l.y>0||s.y>0&&l.y<0)&&(u+3<o?(a[u]=r[u+3],a[u+1]=r[u+4],a[u+2]=r[u+5]):i.pack(s,a,u))}}}function ee(e){var t,r,o,u=e.geometry,s=u.attributes,l=s.position.values,f=s.prevPosition.values,p=s.nextPosition.values,y=s.expandAndWidth.values,h=c(s.st)?s.st.values:void 0,d=c(s.color)?s.color.values:void 0,E=Y(u),m=Y(u),w=!1,T=l.length/3;for(t=0;t<T;t+=4){var v=t,b=t+2,R=i.fromArray(l,3*v,ze),g=i.fromArray(l,3*b,Be);if(Math.abs(R.y)<Ye)for(R.y=Ye*(g.y<0?-1:1),l[3*t+1]=R.y,l[3*(t+1)+1]=R.y,r=3*v;r<3*v+12;r+=3)f[r]=l[3*t],f[r+1]=l[3*t+1],f[r+2]=l[3*t+2];if(Math.abs(g.y)<Ye)for(g.y=Ye*(R.y<0?-1:1),l[3*(t+2)+1]=g.y,l[3*(t+3)+1]=g.y,r=3*v;r<3*v+12;r+=3)p[r]=l[3*(t+2)],p[r+1]=l[3*(t+2)+1],p[r+2]=l[3*(t+2)+2];var A=E.attributes,N=E.indices,S=m.attributes,x=m.indices,I=O.lineSegmentPlane(R,g,Le,Ge);if(c(I)){w=!0;var M=i.multiplyByScalar(i.UNIT_Y,He,Ve);R.y<0&&(i.negate(M,M),A=m.attributes,N=m.indices,S=E.attributes,x=E.indices);var C=i.add(I,M,Xe);A.position.values.push(R.x,R.y,R.z,R.x,R.y,R.z),A.position.values.push(C.x,C.y,C.z),A.position.values.push(C.x,C.y,C.z),A.prevPosition.values.push(f[3*v],f[3*v+1],f[3*v+2]),A.prevPosition.values.push(f[3*v+3],f[3*v+4],f[3*v+5]),A.prevPosition.values.push(R.x,R.y,R.z,R.x,R.y,R.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),A.nextPosition.values.push(C.x,C.y,C.z),i.negate(M,M),i.add(I,M,C),S.position.values.push(C.x,C.y,C.z),S.position.values.push(C.x,C.y,C.z),S.position.values.push(g.x,g.y,g.z,g.x,g.y,g.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.nextPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),S.nextPosition.values.push(p[3*b],p[3*b+1],p[3*b+2]),S.nextPosition.values.push(p[3*b+3],p[3*b+4],p[3*b+5]);var P=n.fromArray(y,2*v,Fe),L=Math.abs(P.y);A.expandAndWidth.values.push(-1,L,1,L),A.expandAndWidth.values.push(-1,-L,1,-L),S.expandAndWidth.values.push(-1,L,1,L),S.expandAndWidth.values.push(-1,-L,1,-L);var U=i.magnitudeSquared(i.subtract(I,R,je));if(U/=i.magnitudeSquared(i.subtract(g,R,je)),c(d)){var D=a.fromArray(d,4*v,We),F=a.fromArray(d,4*b,We),q=_.lerp(D.x,F.x,U),z=_.lerp(D.y,F.y,U),B=_.lerp(D.z,F.z,U),j=_.lerp(D.w,F.w,U);for(r=4*v;r<4*v+8;++r)A.color.values.push(d[r]);for(A.color.values.push(q,z,B,j),A.color.values.push(q,z,B,j),S.color.values.push(q,z,B,j),S.color.values.push(q,z,B,j),r=4*b;r<4*b+8;++r)S.color.values.push(d[r])}if(c(h)){var G=n.fromArray(h,2*v,Fe),V=n.fromArray(h,2*(t+3),qe),X=_.lerp(G.x,V.x,U);for(r=2*v;r<2*v+4;++r)A.st.values.push(h[r]);for(A.st.values.push(X,G.y),A.st.values.push(X,V.y),S.st.values.push(X,G.y),S.st.values.push(X,V.y),r=2*b;r<2*b+4;++r)S.st.values.push(h[r])}o=A.position.values.length/3-4,N.push(o,o+2,o+1),N.push(o+1,o+2,o+3),o=S.position.values.length/3-4,x.push(o,o+2,o+1),x.push(o+1,o+2,o+3)}else{var W,H;for(R.y<0?(W=m.attributes,H=m.indices):(W=E.attributes,H=E.indices),W.position.values.push(R.x,R.y,R.z),W.position.values.push(R.x,R.y,R.z),W.position.values.push(g.x,g.y,g.z),W.position.values.push(g.x,g.y,g.z),r=3*t;r<3*t+12;++r)W.prevPosition.values.push(f[r]),W.nextPosition.values.push(p[r]);for(r=2*t;r<2*t+8;++r)W.expandAndWidth.values.push(y[r]),c(h)&&W.st.values.push(h[r]);if(c(d))for(r=4*t;r<4*t+16;++r)W.color.values.push(d[r]);o=W.position.values.length/3-4,H.push(o,o+2,o+1),H.push(o+1,o+2,o+3)}}w&&($(m),$(E)),k(e,m,E)}var te={};te.toWireframe=function(e){if(!c(e))throw new l("geometry is required.");var t=e.indices;if(c(t)){switch(e.primitiveType){case b.TRIANGLES:e.indices=A(t);break;case b.TRIANGLE_STRIP:e.indices=N(t);break;case b.TRIANGLE_FAN:e.indices=S(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=b.LINES}return e},te.createLineSegmentsForVectors=function(e,t,n){if(t=s(t,"normal"),!c(e))throw new l("geometry is required.");if(!c(e.attributes.position))throw new l("geometry.attributes.position is required.");if(!c(e.attributes[t]))throw new l("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=s(n,1e4);for(var i=e.attributes.position.values,a=e.attributes[t].values,o=i.length,f=new Float64Array(2*o),p=0,d=0;d<o;d+=3)f[p++]=i[d],f[p++]=i[d+1],f[p++]=i[d+2],f[p++]=i[d]+a[d]*n,f[p++]=i[d+1]+a[d+1]*n,f[p++]=i[d+2]+a[d+2]*n;var E,m=e.boundingSphere;return c(m)&&(E=new r(m.center,m.radius+n)),new y({attributes:{position:new h({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:f})},primitiveType:b.LINES,boundingSphere:E})},te.createAttributeLocations=function(e){if(!c(e))throw new l("geometry is required.");var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,i={},a=0,o=r.length;for(t=0;t<o;++t){var u=r[t];c(n[u])&&(i[u]=a++)}for(var s in n)n.hasOwnProperty(s)&&!c(i[s])&&(i[s]=a++);return i},te.reorderForPreVertexCache=function(e){if(!c(e))throw new l("geometry is required.");var t=y.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),i=0;i<t;i++)n[i]=-1;for(var a,o=r,s=o.length,f=E.createTypedArray(t,s),p=0,h=0,d=0;p<s;)a=n[o[p]],a!==-1?f[h]=a:(a=o[p],n[a]=d,f[h]=d,++d),++p,++h;e.indices=f;var m=e.attributes;for(var O in m)if(m.hasOwnProperty(O)&&c(m[O])&&c(m[O].values)){for(var _=m[O],w=_.values,T=0,v=_.componentsPerAttribute,b=u.createTypedArray(_.componentDatatype,d*v);T<t;){var R=n[T];if(R!==-1)for(i=0;i<v;i++)b[v*R+i]=w[v*T+i];++T}_.values=b}}return e},te.reorderForPostVertexCache=function(e,t){if(!c(e))throw new l("geometry is required.");var r=e.indices;if(e.primitiveType===b.TRIANGLES&&c(r)){for(var n=r.length,i=0,a=0;a<n;a++)r[a]>i&&(i=r[a]);e.indices=R.tipsify({indices:r,maximumIndex:i,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){if(!c(e))throw new l("geometry is required.");if(c(e.indices)&&e.primitiveType!==b.TRIANGLES&&e.primitiveType!==b.LINES&&e.primitiveType!==b.POINTS)throw new l("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],r=y.computeNumberOfVertices(e);if(c(e.indices)&&r>=_.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=x(e.attributes),s=e.indices,f=s.length;e.primitiveType===b.TRIANGLES?n=3:e.primitiveType===b.LINES?n=2:e.primitiveType===b.POINTS&&(n=1);for(var p=0;p<f;p+=n){for(var h=0;h<n;++h){var d=s[p+h],E=i[d];c(E)||(E=o++,i[d]=E,I(u,e.attributes,d)),a.push(E)}o+n>=_.SIXTY_FOUR_KILOBYTES&&(t.push(new y({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],a=[],o=0,u=x(e.attributes))}0!==a.length&&t.push(new y({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new i,ne=new o;te.projectTo2D=function(e,t,r,n,a){if(!c(e))throw new l("geometry is required.");if(!c(t))throw new l("attributeName is required.");if(!c(r))throw new l("attributeName3D is required.");if(!c(n))throw new l("attributeName2D is required.");if(!c(e.attributes[t]))throw new l("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var o=e.attributes[t];a=c(a)?a:new p;for(var s=a.ellipsoid,f=o.values,y=new Float64Array(f.length),d=0,E=0;E<f.length;E+=3){var m=i.fromArray(f,E,re),O=s.cartesianToCartographic(m,ne);if(!c(O))throw new l("Could not project point ("+m.x+", "+m.y+", "+m.z+") to 2D.");var _=a.project(O,re);y[d++]=_.x,y[d++]=_.y,y[d++]=_.z}return e.attributes[r]=o,e.attributes[n]=new h({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:y}),delete e.attributes[t],e};var ie={high:0,low:0};te.encodeAttribute=function(e,t,r,n){if(!c(e))throw new l("geometry is required.");if(!c(t))throw new l("attributeName is required.");if(!c(r))throw new l("attributeHighName is required.");if(!c(n))throw new l("attributeLowName is required.");if(!c(e.attributes[t]))throw new l("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[t],a=i.values,o=a.length,s=new Float32Array(o),p=new Float32Array(o),y=0;y<o;++y)f.encode(a[y],ie),s[y]=ie.high,p[y]=ie.low;var d=i.componentsPerAttribute;return e.attributes[r]=new h({componentDatatype:u.FLOAT,componentsPerAttribute:d,values:s}),e.attributes[n]=new h({componentDatatype:u.FLOAT,componentsPerAttribute:d,values:p}),delete e.attributes[t],e};var ae=new i,oe=new T,ue=new w;te.transformToWorldCoordinates=function(e){if(!c(e))throw new l("instance is required.");var t=e.modelMatrix;if(T.equals(t,T.IDENTITY))return e;var n=e.geometry.attributes;M(t,n.position),M(t,n.prevPosition),M(t,n.nextPosition),(c(n.normal)||c(n.tangent)||c(n.bitangent))&&(T.inverse(t,oe),T.transpose(oe,oe),T.getRotation(oe,ue),C(ue,n.normal),C(ue,n.tangent),C(ue,n.bitangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=T.clone(T.IDENTITY),e};var se=new i;te.combineInstances=function(e){if(!c(e)||e.length<1)throw new l("instances is required and must have length greater than zero.");for(var t=[],r=[],n=e.length,i=0;i<n;++i){var a=e[i];c(a.geometry)?t.push(a):c(a.westHemisphereGeometry)&&c(a.eastHemisphereGeometry)&&r.push(a)}var o=[];return t.length>0&&o.push(L(t,"geometry")),r.length>0&&(o.push(L(r,"westHemisphereGeometry")),o.push(L(r,"eastHemisphereGeometry"))),o};var ce=new i,le=new i,fe=new i,pe=new i;te.computeNormal=function(e){if(!c(e))throw new l("geometry is required.");if(!c(e.attributes.position)||!c(e.attributes.position.values))throw new l("geometry.attributes.position.values is required.");if(!c(e.indices))throw new l("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var t=e.indices,r=e.attributes,n=r.position.values,a=r.position.values.length/3,o=t.length,s=new Array(a),f=new Array(o/3),p=new Array(o),y=0;y<a;y++)s[y]={indexOffset:0,count:0,currentCount:0};var d=0;for(y=0;y<o;y+=3){var E=t[y],m=t[y+1],O=t[y+2],w=3*E,T=3*m,v=3*O;le.x=n[w],le.y=n[w+1],le.z=n[w+2],fe.x=n[T],fe.y=n[T+1],fe.z=n[T+2],pe.x=n[v],pe.y=n[v+1],pe.z=n[v+2],s[E].count++,s[m].count++,s[O].count++,i.subtract(fe,le,fe),i.subtract(pe,le,pe),f[d]=i.cross(fe,pe,new i),d++}var R=0;for(y=0;y<a;y++)s[y].indexOffset+=R,R+=s[y].count;d=0;var g;for(y=0;y<o;y+=3){g=s[t[y]];var A=g.indexOffset+g.currentCount;p[A]=d,g.currentCount++,g=s[t[y+1]],A=g.indexOffset+g.currentCount,p[A]=d,g.currentCount++,g=s[t[y+2]],A=g.indexOffset+g.currentCount,p[A]=d,g.currentCount++,d++}var N=new Float32Array(3*a);for(y=0;y<a;y++){var S=3*y;if(g=s[y],i.clone(i.ZERO,ce),g.count>0){for(d=0;d<g.count;d++)i.add(ce,f[p[g.indexOffset+d]],ce);i.equalsEpsilon(i.ZERO,ce,_.EPSILON10)&&i.clone(f[p[g.indexOffset]],ce)}i.equalsEpsilon(i.ZERO,ce,_.EPSILON10)&&(ce.z=1),i.normalize(ce,ce),N[S]=ce.x,N[S+1]=ce.y,N[S+2]=ce.z}return e.attributes.normal=new h({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:N}),e};var ye=new i,he=new i,de=new i;te.computeTangentAndBitangent=function(e){if(!c(e))throw new l("geometry is required.");var t=e.attributes,r=e.indices;if(!c(t.position)||!c(t.position.values))throw new l("geometry.attributes.position.values is required.");if(!c(t.normal)||!c(t.normal.values))throw new l("geometry.attributes.normal.values is required.");if(!c(t.st)||!c(t.st.values))throw new l("geometry.attributes.st.values is required.");if(!c(r))throw new l("geometry.indices is required.");if(r.length<2||r.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var n=e.attributes.position.values,a=e.attributes.normal.values,o=e.attributes.st.values,s=e.attributes.position.values.length/3,f=r.length,p=new Array(3*s),y=0;y<p.length;y++)p[y]=0;var d,E,m;for(y=0;y<f;y+=3){var O=r[y],_=r[y+1],w=r[y+2];d=3*O,E=3*_,m=3*w;var T=2*O,v=2*_,R=2*w,g=n[d],A=n[d+1],N=n[d+2],S=o[T],x=o[T+1],I=o[v+1]-x,M=o[R+1]-x,C=1/((o[v]-S)*M-(o[R]-S)*I),P=(M*(n[E]-g)-I*(n[m]-g))*C,L=(M*(n[E+1]-A)-I*(n[m+1]-A))*C,U=(M*(n[E+2]-N)-I*(n[m+2]-N))*C;p[d]+=P,p[d+1]+=L,p[d+2]+=U,p[E]+=P,p[E+1]+=L,p[E+2]+=U,p[m]+=P,p[m+1]+=L,p[m+2]+=U}var D=new Float32Array(3*s),F=new Float32Array(3*s);for(y=0;y<s;y++){d=3*y,E=d+1,m=d+2;var q=i.fromArray(a,d,ye),z=i.fromArray(p,d,de),B=i.dot(q,z);i.multiplyByScalar(q,B,he),i.normalize(i.subtract(z,he,z),z),D[d]=z.x,D[E]=z.y,D[m]=z.z,i.normalize(i.cross(q,z,z),z),F[d]=z.x,F[E]=z.y,F[m]=z.z}return e.attributes.tangent=new h({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:D}),e.attributes.bitangent=new h({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:F}),e};var Ee=new n,me=new i,Oe=new i,_e=new i,we=new n;te.compressVertices=function(t){if(!c(t))throw new l("geometry is required.");var r,a,o=t.attributes.extrudeDirection;if(c(o)){var s=o.values;a=s.length/3;var f=new Float32Array(2*a),p=0;for(r=0;r<a;++r)i.fromArray(s,3*r,me),i.equals(me,i.ZERO)?p+=2:(we=e.octEncodeInRange(me,65535,we),f[p++]=we.x,f[p++]=we.y);return t.attributes.compressedAttributes=new h({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:f}),delete t.attributes.extrudeDirection,t}var y=t.attributes.normal,d=t.attributes.st,E=c(y),m=c(d);if(!E&&!m)return t;var O,_,w,T,v=t.attributes.tangent,b=t.attributes.bitangent,R=c(v),g=c(b);E&&(O=y.values),m&&(_=d.values),R&&(w=v.values),g&&(T=b.values);var A=E?O.length:_.length,N=E?3:2;a=A/N;var S=a,x=m&&E?2:1;x+=R||g?1:0,S*=x;var I=new Float32Array(S),M=0;for(r=0;r<a;++r){m&&(n.fromArray(_,2*r,Ee),I[M++]=e.compressTextureCoordinates(Ee));var C=3*r;E&&c(w)&&c(T)?(i.fromArray(O,C,me),i.fromArray(w,C,Oe),i.fromArray(T,C,_e),e.octPack(me,Oe,_e,Ee),I[M++]=Ee.x,I[M++]=Ee.y):(E&&(i.fromArray(O,C,me),I[M++]=e.octEncodeFloat(me)),R&&(i.fromArray(w,C,me),I[M++]=e.octEncodeFloat(me)),g&&(i.fromArray(T,C,me),I[M++]=e.octEncodeFloat(me)))}return t.attributes.compressedAttributes=new h({componentDatatype:u.FLOAT,componentsPerAttribute:x,values:I}),E&&delete t.attributes.normal,m&&delete t.attributes.st,g&&delete t.attributes.bitangent,R&&delete t.attributes.tangent,t};var Te=new i,ve=new i,be=new i,Re=new i,ge=new i,Ae={positions:new Array(7),indices:new Array(9)},Ne=new i,Se=new i,xe=new i,Ie=new i,Me=new n,Ce=new n,Pe=new n,Le=v.fromPointNormal(i.ZERO,i.UNIT_Y),Ue=new i,De=new i,Fe=new n,qe=new n,ze=new i,Be=new i,je=new i,Ge=new i,Ve=new i,Xe=new i,We=new a,He=5*_.EPSILON9,Ye=_.EPSILON6;return te.splitLongitude=function(e){if(!c(e))throw new l("instance is required.");var t=e.geometry,n=t.boundingSphere;if(c(n)){var i=n.center.x-n.radius;if(i>0||r.intersectPlane(n,v.ORIGIN_ZX_PLANE)!==m.INTERSECTING)return e}if(t.geometryType!==d.NONE)switch(t.geometryType){case d.POLYLINES:ee(e);break;case d.TRIANGLES:Q(e);break;case d.LINES:J(e)}else j(t),t.primitiveType===b.TRIANGLES?Q(e):t.primitiveType===b.LINES&&J(e);return e},te}),define("ThirdParty/earcut-2.1.1",[],function(){"use strict";function e(e,r,i){i=i||2;var a=r&&r.length,o=a?r[0]*i:e.length,u=t(e,0,o,i,!0),c=[];if(!u)return c;var l,f,p,y,h,d,E;if(a&&(u=s(e,r,u,i)),e.length>80*i){l=p=e[0],f=y=e[1];for(var m=i;m<o;m+=i)h=e[m],d=e[m+1],h<l&&(l=h),d<f&&(f=d),h>p&&(p=h),d>y&&(y=d);E=Math.max(p-l,y-f)}return n(u,c,i,l,f,E),c}function t(e,t,r,n,i){var a,o;if(i===S(e,t,r,n)>0)for(a=t;a<r;a+=n)o=g(a,e[a],e[a+1],o);else for(a=r-n;a>=t;a-=n)o=g(a,e[a],e[a+1],o);return o&&_(o,o.next)&&(A(o),o=o.next),o}function r(e,t){if(!e)return e;t||(t=e);var r,n=e;do if(r=!1,n.steiner||!_(n,n.next)&&0!==O(n.prev,n,n.next))n=n.next;else{if(A(n),n=t=n.prev,n===n.next)return null;r=!0}while(r||n!==t);return t}function n(e,t,s,c,l,f,y){if(e){!y&&f&&p(e,c,l,f);for(var h,d,E=e;e.prev!==e.next;)if(h=e.prev,d=e.next,f?a(e,c,l,f):i(e))t.push(h.i/s),t.push(e.i/s),t.push(d.i/s),A(e),e=d.next,E=d.next;else if(e=d,e===E){y?1===y?(e=o(e,t,s),n(e,t,s,c,l,f,2)):2===y&&u(e,t,s,c,l,f):n(r(e),t,s,c,l,f,1);break}}}function i(e){var t=e.prev,r=e,n=e.next;if(O(t,r,n)>=0)return!1;for(var i=e.next.next;i!==e.prev;){if(E(t.x,t.y,r.x,r.y,n.x,n.y,i.x,i.y)&&O(i.prev,i,i.next)>=0)return!1;i=i.next}return!0}function a(e,t,r,n){var i=e.prev,a=e,o=e.next;if(O(i,a,o)>=0)return!1;for(var u=i.x<a.x?i.x<o.x?i.x:o.x:a.x<o.x?a.x:o.x,s=i.y<a.y?i.y<o.y?i.y:o.y:a.y<o.y?a.y:o.y,c=i.x>a.x?i.x>o.x?i.x:o.x:a.x>o.x?a.x:o.x,l=i.y>a.y?i.y>o.y?i.y:o.y:a.y>o.y?a.y:o.y,f=h(u,s,t,r,n),p=h(c,l,t,r,n),y=e.nextZ;y&&y.z<=p;){if(y!==e.prev&&y!==e.next&&E(i.x,i.y,a.x,a.y,o.x,o.y,y.x,y.y)&&O(y.prev,y,y.next)>=0)return!1;y=y.nextZ}for(y=e.prevZ;y&&y.z>=f;){if(y!==e.prev&&y!==e.next&&E(i.x,i.y,a.x,a.y,o.x,o.y,y.x,y.y)&&O(y.prev,y,y.next)>=0)return!1;y=y.prevZ}return!0}function o(e,t,r){var n=e;do{var i=n.prev,a=n.next.next;!_(i,a)&&w(i,n,n.next,a)&&v(i,a)&&v(a,i)&&(t.push(i.i/r),t.push(n.i/r),t.push(a.i/r),A(n),A(n.next),n=e=a),n=n.next}while(n!==e);return n}function u(e,t,i,a,o,u){var s=e;do{for(var c=s.next.next;c!==s.prev;){if(s.i!==c.i&&m(s,c)){var l=R(s,c);return s=r(s,s.next),l=r(l,l.next),n(s,t,i,a,o,u),void n(l,t,i,a,o,u)}c=c.next}s=s.next}while(s!==e)}function s(e,n,i,a){var o,u,s,f,p,y=[];for(o=0,u=n.length;o<u;o++)s=n[o]*a,f=o<u-1?n[o+1]*a:e.length,p=t(e,s,f,a,!1),p===p.next&&(p.steiner=!0),y.push(d(p));for(y.sort(c),o=0;o<y.length;o++)l(y[o],i),i=r(i,i.next);return i}function c(e,t){return e.x-t.x}function l(e,t){if(t=f(e,t)){var n=R(t,e);r(n,n.next)}}function f(e,t){var r,n=t,i=e.x,a=e.y,o=-(1/0);do{if(a<=n.y&&a>=n.next.y){var u=n.x+(a-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(u<=i&&u>o){if(o=u,u===i){if(a===n.y)return n;if(a===n.next.y)return n.next}r=n.x<n.next.x?n:n.next}}n=n.next}while(n!==t);if(!r)return null;if(i===o)return r.prev;var s,c=r,l=r.x,f=r.y,p=1/0;for(n=r.next;n!==c;)i>=n.x&&n.x>=l&&E(a<f?i:o,a,l,f,a<f?o:i,a,n.x,n.y)&&(s=Math.abs(a-n.y)/(i-n.x),(s<p||s===p&&n.x>r.x)&&v(n,e)&&(r=n,p=s)),n=n.next;return r}function p(e,t,r,n){var i=e;do null===i.z&&(i.z=h(i.x,i.y,t,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,y(i)}function y(e){var t,r,n,i,a,o,u,s,c=1;do{for(r=e,e=null,a=null,o=0;r;){for(o++,n=r,u=0,t=0;t<c&&(u++,n=n.nextZ,n);t++);for(s=c;u>0||s>0&&n;)0===u?(i=n,n=n.nextZ,s--):0!==s&&n?r.z<=n.z?(i=r,r=r.nextZ,u--):(i=n,n=n.nextZ,s--):(i=r,r=r.nextZ,u--),a?a.nextZ=i:e=i,i.prevZ=a,a=i;r=n}a.nextZ=null,c*=2}while(o>1);return e}function h(e,t,r,n,i){return e=32767*(e-r)/i,t=32767*(t-n)/i,e=16711935&(e|e<<8),e=252645135&(e|e<<4),e=858993459&(e|e<<2),e=1431655765&(e|e<<1),t=16711935&(t|t<<8),t=252645135&(t|t<<4),t=858993459&(t|t<<2),t=1431655765&(t|t<<1),e|t<<1}function d(e){var t=e,r=e;do t.x<r.x&&(r=t),t=t.next;while(t!==e);return r}function E(e,t,r,n,i,a,o,u){return(i-o)*(t-u)-(e-o)*(a-u)>=0&&(e-o)*(n-u)-(r-o)*(t-u)>=0&&(r-o)*(a-u)-(i-o)*(n-u)>=0}function m(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!T(e,t)&&v(e,t)&&v(t,e)&&b(e,t)}function O(e,t,r){return(t.y-e.y)*(r.x-t.x)-(t.x-e.x)*(r.y-t.y)}function _(e,t){return e.x===t.x&&e.y===t.y}function w(e,t,r,n){return!!(_(e,t)&&_(r,n)||_(e,n)&&_(r,t))||O(e,t,r)>0!=O(e,t,n)>0&&O(r,n,e)>0!=O(r,n,t)>0}function T(e,t){var r=e;do{if(r.i!==e.i&&r.next.i!==e.i&&r.i!==t.i&&r.next.i!==t.i&&w(r,r.next,e,t))return!0;r=r.next}while(r!==e);return!1}function v(e,t){return O(e.prev,e,e.next)<0?O(e,t,e.next)>=0&&O(e,e.prev,t)>=0:O(e,t,e.prev)<0||O(e,e.next,t)<0}function b(e,t){var r=e,n=!1,i=(e.x+t.x)/2,a=(e.y+t.y)/2;do r.y>a!=r.next.y>a&&i<(r.next.x-r.x)*(a-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;while(r!==e);return n}function R(e,t){var r=new N(e.i,e.x,e.y),n=new N(t.i,t.x,t.y),i=e.next,a=t.prev;return e.next=t,t.prev=e,r.next=i,i.prev=r,n.next=r,r.prev=n,a.next=n,n.prev=a,n}function g(e,t,r,n){var i=new N(e,t,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function A(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function N(e,t,r){this.i=e,this.x=t,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function S(e,t,r,n){for(var i=0,a=t,o=r-n;a<r;a+=n)i+=(e[o]-e[a])*(e[a+1]+e[o+1]),o=a;return i}return e.deviation=function(e,t,r,n){var i=t&&t.length,a=i?t[0]*r:e.length,o=Math.abs(S(e,0,a,r));if(i)for(var u=0,s=t.length;u<s;u++){var c=t[u]*r,l=u<s-1?t[u+1]*r:e.length;o-=Math.abs(S(e,c,l,r))}var f=0;for(u=0;u<n.length;u+=3){var p=n[u]*r,y=n[u+1]*r,h=n[u+2]*r;f+=Math.abs((e[p]-e[h])*(e[y+1]-e[p+1])-(e[p]-e[y])*(e[h+1]-e[p+1]))}return 0===o&&0===f?0:Math.abs((f-o)/o)},e.flatten=function(e){for(var t=e[0][0].length,r={vertices:[],holes:[],dimensions:t},n=0,i=0;i<e.length;i++){for(var a=0;a<e[i].length;a++)for(var o=0;o<t;o++)r.vertices.push(e[i][a][o]);i>0&&(n+=e[i-1].length,r.holes.push(n))}return r},e}),define("Core/WindingOrder",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={CLOCKWISE:t.CW,COUNTER_CLOCKWISE:t.CCW,validate:function(e){return e===r.CLOCKWISE||e===r.COUNTER_CLOCKWISE}};return e(r)}),define("Core/PolygonPipeline",["../ThirdParty/earcut-2.1.1","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./Math","./PrimitiveType","./WindingOrder"],function(e,t,r,n,i,a,o,u,s,c,l,f,p){"use strict";var y=new r,h=new r,d={};d.computeArea2D=function(e){if(!a(e))throw new o("positions is required.");if(e.length<3)throw new o("At least three positions are required.");for(var t=e.length,r=0,n=t-1,i=0;i<t;n=i++){var u=e[n],s=e[i];r+=u.x*s.y-s.x*u.y}return.5*r},d.computeWindingOrder2D=function(e){var t=d.computeArea2D(e);return t>0?p.COUNTER_CLOCKWISE:p.CLOCKWISE},d.triangulate=function(r,n){if(!a(r))throw new o("positions is required.");var i=t.packArray(r);return e(i,n,2)};var E=new r,m=new r,O=new r,_=new r,w=new r,T=new r,v=new r;return d.computeSubdivision=function(e,t,u,p){if(p=i(p,l.RADIANS_PER_DEGREE),!a(e))throw new o("ellipsoid is required.");if(!a(t))throw new o("positions is required.");if(!a(u))throw new o("indices is required.");if(u.length<3)throw new o("At least three indices are required.");if(u.length%3!==0)throw new o("The number of indices must be divisable by three.");
if(p<=0)throw new o("granularity must be greater than zero.");var y,h=u.slice(0),d=t.length,b=new Array(3*d),R=0;for(y=0;y<d;y++){var g=t[y];b[R++]=g.x,b[R++]=g.y,b[R++]=g.z}for(var A=[],N={},S=e.maximumRadius,x=l.chordLength(p,S),I=x*x;h.length>0;){var M,C,P=h.pop(),L=h.pop(),U=h.pop(),D=r.fromArray(b,3*U,E),F=r.fromArray(b,3*L,m),q=r.fromArray(b,3*P,O),z=r.multiplyByScalar(r.normalize(D,_),S,_),B=r.multiplyByScalar(r.normalize(F,w),S,w),j=r.multiplyByScalar(r.normalize(q,T),S,T),G=r.magnitudeSquared(r.subtract(z,B,v)),V=r.magnitudeSquared(r.subtract(B,j,v)),X=r.magnitudeSquared(r.subtract(j,z,v)),W=Math.max(G,V,X);W>I?G===W?(M=Math.min(U,L)+" "+Math.max(U,L),y=N[M],a(y)||(C=r.add(D,F,v),r.multiplyByScalar(C,.5,C),b.push(C.x,C.y,C.z),y=b.length/3-1,N[M]=y),h.push(U,y,P),h.push(y,L,P)):V===W?(M=Math.min(L,P)+" "+Math.max(L,P),y=N[M],a(y)||(C=r.add(F,q,v),r.multiplyByScalar(C,.5,C),b.push(C.x,C.y,C.z),y=b.length/3-1,N[M]=y),h.push(L,y,U),h.push(y,P,U)):X===W&&(M=Math.min(P,U)+" "+Math.max(P,U),y=N[M],a(y)||(C=r.add(q,D,v),r.multiplyByScalar(C,.5,C),b.push(C.x,C.y,C.z),y=b.length/3-1,N[M]=y),h.push(P,y,L),h.push(y,U,L)):(A.push(U),A.push(L),A.push(P))}return new s({attributes:{position:new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:b})},indices:A,primitiveType:f.TRIANGLES})},d.scaleToGeodeticHeight=function(e,t,n,o){n=i(n,u.WGS84);var s=y,c=h;if(t=i(t,0),o=i(o,!0),a(e))for(var l=e.length,f=0;f<l;f+=3)r.fromArray(e,f,c),o&&(c=n.scaleToGeodeticSurface(c,c)),0!==t&&(s=n.geodeticSurfaceNormal(c,s),r.multiplyByScalar(s,t,s),r.add(c,s,c)),e[f]=c.x,e[f+1]=c.y,e[f+2]=c.z;return e},d}),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,a){if(!t(n))throw new r("identifier is required.");t(i[n])||(i[n]=!0,console.warn(e(a,n)))}var i={};return n.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",n}),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],function(e,t,r){"use strict";function n(n,i){if(!e(n)||!e(i))throw new t("identifier and message are required.");r(n,i)}return n}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var a=2*(e.w*e.y-e.z*e.x),o=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,o),n.pitch=-Math.asin(a),n},i.fromDegrees=function(e,a,o,u){if(!t(e))throw new r("heading is required");if(!t(a))throw new r("pitch is required");if(!t(o))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=a*n.RADIANS_PER_DEGREE,u.roll=o*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){if(t(e))return t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,a){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,a)&&n.equalsEpsilon(e.pitch,r.pitch,i,a)&&n.equalsEpsilon(e.roll,r.roll,i,a)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./deprecationWarning","./FeatureDetection","./freezeObject","./HeadingPitchRoll","./Math","./Matrix3"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var f=new e;l.fromAxisAngle=function(r,i,a){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var o=i/2,u=Math.sin(o);f=e.normalize(r,f);var s=f.x*u,c=f.y*u,p=f.z*u,y=Math.cos(o);return n(a)?(a.x=s,a.y=c,a.z=p,a.w=y,a):new l(s,c,p,y)};var p=[1,2,0],y=new Array(3);l.fromRotationMatrix=function(e,r){t.typeOf.object("matrix",e);var i,a,o,u,s,f=e[c.COLUMN0ROW0],h=e[c.COLUMN1ROW1],d=e[c.COLUMN2ROW2],E=f+h+d;if(E>0)i=Math.sqrt(E+1),s=.5*i,i=.5/i,a=(e[c.COLUMN1ROW2]-e[c.COLUMN2ROW1])*i,o=(e[c.COLUMN2ROW0]-e[c.COLUMN0ROW2])*i,u=(e[c.COLUMN0ROW1]-e[c.COLUMN1ROW0])*i;else{var m=p,O=0;h>f&&(O=1),d>f&&d>h&&(O=2);var _=m[O],w=m[_];i=Math.sqrt(e[c.getElementIndex(O,O)]-e[c.getElementIndex(_,_)]-e[c.getElementIndex(w,w)]+1);var T=y;T[O]=.5*i,i=.5/i,s=(e[c.getElementIndex(w,_)]-e[c.getElementIndex(_,w)])*i,T[_]=(e[c.getElementIndex(_,O)]+e[c.getElementIndex(O,_)])*i,T[w]=(e[c.getElementIndex(w,O)]+e[c.getElementIndex(O,w)])*i,a=-T[0],o=-T[1],u=-T[2]}return n(r)?(r.x=a,r.y=o,r.z=u,r.w=s,r):new l(a,o,u,s)};var h=new l,d=new l,E=new l,m=new l;l.fromHeadingPitchRoll=function(r,n,a,o){r instanceof u?t.typeOf.object("headingPitchRoll",r):(t.typeOf.number(r,"heading"),t.typeOf.number(n,"pitch"),t.typeOf.number(a,"roll"));var s;return r instanceof u?(s=r,o=n):(i("Quaternion.fromHeadingPitchRoll(heading, pitch, roll,result)","The method was deprecated in Cesium 1.32 and will be removed in version 1.33. Use Quaternion.fromHeadingPitchRoll(hpr,result) where hpr is a HeadingPitchRoll"),s=new u(r,n,a)),m=l.fromAxisAngle(e.UNIT_X,s.roll,h),E=l.fromAxisAngle(e.UNIT_Y,-s.pitch,o),o=l.multiply(E,m,E),d=l.fromAxisAngle(e.UNIT_Z,-s.heading,h),l.multiply(d,o,o)};var O=new e,_=new e,w=new l,T=new l,v=new l;l.packedLength=4,l.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},l.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new l),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},l.packedInterpolationLength=3,l.convertPackedArrayForInterpolation=function(e,t,r,n){l.unpack(e,4*r,v),l.conjugate(v,v);for(var i=0,a=r-t+1;i<a;i++){var o=3*i;l.unpack(e,4*(t+i),w),l.multiply(w,v,w),w.w<0&&l.negate(w,w),l.computeAxis(w,O);var u=l.computeAngle(w);n[o]=O.x*u,n[o+1]=O.y*u,n[o+2]=O.z*u}},l.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new l),e.fromArray(t,0,_);var u=e.magnitude(_);return l.unpack(r,4*a,T),0===u?l.clone(l.IDENTITY,w):l.fromAxisAngle(_,u,w),l.multiply(w,T,o)},l.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new l(e.x,e.y,e.z,e.w)},l.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},l.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},l.magnitude=function(e){return Math.sqrt(l.magnitudeSquared(e))},l.normalize=function(e,r){t.typeOf.object("result",r);var n=1/l.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return r.x=i,r.y=a,r.z=o,r.w=u,r},l.inverse=function(e,r){t.typeOf.object("result",r);var n=l.magnitudeSquared(e);return r=l.conjugate(e,r),l.multiplyByScalar(r,1/n,r)},l.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},l.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},l.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},l.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},l.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,a=e.y,o=e.z,u=e.w,s=r.x,c=r.y,l=r.z,f=r.w,p=u*s+i*f+a*l-o*c,y=u*c-i*l+a*f+o*s,h=u*l+i*c-a*s+o*f,d=u*f-i*s-a*c-o*l;return n.x=p,n.y=y,n.z=h,n.w=d,n},l.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},l.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},l.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<s.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},l.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<s.EPSILON6?0:2*Math.acos(e.w)};var b=new l;l.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),b=l.multiplyByScalar(r,n,b),i=l.multiplyByScalar(e,1-n,i),l.add(b,i,i)};var R=new l,g=new l,A=new l;l.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a=l.dot(e,r),o=r;if(a<0&&(a=-a,o=R=l.negate(r,R)),1-a<s.EPSILON6)return l.lerp(e,o,n,i);var u=Math.acos(a);return g=l.multiplyByScalar(e,Math.sin((1-n)*u),g),A=l.multiplyByScalar(o,Math.sin(n*u),A),i=l.add(g,A,i),l.multiplyByScalar(i,1/Math.sin(u),i)},l.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=s.acosClamped(r.w),a=0;return 0!==i&&(a=i/Math.sin(i)),e.multiplyByScalar(r,a,n)},l.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),a=0;return 0!==i&&(a=Math.sin(i)/i),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(i),n};var N=new e,S=new e,x=new l,I=new l;l.computeInnerQuadrangle=function(r,n,i,a){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",a);var o=l.conjugate(n,x);l.multiply(o,i,I);var u=l.log(I,N);l.multiply(o,r,I);var s=l.log(I,S);return e.add(u,s,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),l.exp(u,x),l.multiply(n,x,a)},l.squad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=l.slerp(e,r,a,x),s=l.slerp(n,i,a,I);return l.slerp(u,s,2*a*(1-a),o)};for(var M=new l,C=1.9011074535173003,P=a.supportsTypedArrays()?new Float32Array(8):[],L=a.supportsTypedArrays()?new Float32Array(8):[],U=a.supportsTypedArrays()?new Float32Array(8):[],D=a.supportsTypedArrays()?new Float32Array(8):[],F=0;F<7;++F){var q=F+1,z=2*q+1;P[F]=1/(q*z),L[F]=q/z}return P[7]=C/136,L[7]=8*C/17,l.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a,o=l.dot(e,r);o>=0?a=1:(a=-1,o=-o);for(var u=o-1,s=1-n,c=n*n,f=s*s,p=7;p>=0;--p)U[p]=(P[p]*c-L[p])*u,D[p]=(P[p]*f-L[p])*u;var y=a*n*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),h=s*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),d=l.multiplyByScalar(e,h,M);return l.multiplyByScalar(r,y,i),l.add(d,i,i)},l.fastSquad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=l.fastSlerp(e,r,a,x),s=l.fastSlerp(n,i,a,I);return l.fastSlerp(u,s,2*a*(1-a),o)},l.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},l.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},l.ZERO=o(new l(0,0,0,0)),l.IDENTITY=o(new l(0,0,0,1)),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},l}),define("Core/Matrix2",["./Cartesian2","./Check","./defaultValue","./defined","./defineProperties","./freezeObject"],function(e,t,r,n,i,a){"use strict";function o(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)}o.packedLength=4,o.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n},o.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a},o.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3])},o.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new o),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a},o.fromColumnMajorArray=function(e,r){return t.defined("values",e),o.clone(e,r)},o.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new o(e,0,0,e)},o.fromRotation=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=-a,r[3]=i,r):new o(i,-a,a,i)},o.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,1),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,1),2*e+r},o.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=2*r,a=e[i],o=e[i+1];return n.x=a,n.y=o,n},o.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=o.clone(e,i);var a=2*r;return i[a]=n.x,i[a+1]=n.y,i},o.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("result",n);var i=e[r],a=e[r+2];return n.x=i,n.y=a,n},o.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,1),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=o.clone(e,i),i[r]=n.x,i[r+2]=n.y,i};var u=new e;o.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],u)),n.y=e.magnitude(e.fromElements(r[2],r[3],u)),n};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[2]*r[1],a=e[0]*r[2]+e[2]*r[3],o=e[1]*r[0]+e[3]*r[1],u=e[1]*r[2]+e[3]*r[3];return n[0]=i,n[1]=o,n[2]=a,n[3]=u,n},o.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n},o.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n},o.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e[0]*r.x+e[2]*r.y,a=e[1]*r.x+e[3]*r.y;return n.x=i,n.y=a,n},o.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n},o.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n},o.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},o.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[2],a=e[1],o=e[3];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r},o.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},o.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},o.IDENTITY=a(new o(1,0,0,1)),o.ZERO=a(new o(0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,i(o.prototype,{length:{get:function(){return o.packedLength}}}),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},o}),define("Core/RectangleGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./GeographicProjection","./Math","./Matrix2","./Rectangle"],function(e,t,r,n,i,a,o,u){"use strict";function s(t,r,n,i,a,u,s){var c=Math.cos(r),l=i*c,f=n*c,p=Math.sin(r),d=i*p,O=n*p;h=m.project(t,h),h=e.subtract(h,E,h);var _=o.fromRotation(r,y);h=o.multiplyByVector(_,h,h),h=e.add(h,E,h),t=m.unproject(h,t),u-=1,s-=1;var w=t.latitude,T=w+u*O,v=w-l*s,b=w-l*s+u*O,R=Math.max(w,T,v,b),g=Math.min(w,T,v,b),A=t.longitude,N=A+u*f,S=A+s*d,x=A+s*d+u*f,I=Math.max(A,N,S,x),M=Math.min(A,N,S,x);return{north:R,south:g,east:I,west:M,granYCos:l,granYSin:d,granXCos:f,granXSin:O,nwCorner:t}}var c=Math.cos,l=Math.sin,f=Math.sqrt,p={};p.computePosition=function(e,t,n,i,a){var o=e.ellipsoid.radiiSquared,u=e.nwCorner,s=e.rectangle,p=u.latitude-e.granYCos*t+n*e.granXSin,y=c(p),h=l(p),d=o.z*h,E=u.longitude+t*e.granYSin+n*e.granXCos,m=y*c(E),O=y*l(E),_=o.x*m,w=o.y*O,T=f(_*m+w*O+d*h);if(i.x=_/T,i.y=w/T,i.z=d/T,r(e.vertexFormat)&&e.vertexFormat.st){var v=e.stNwCorner;r(v)?(p=v.latitude-e.stGranYCos*t+n*e.stGranXSin,E=v.longitude+t*e.stGranYSin+n*e.stGranXCos,a.x=(E-e.stWest)*e.lonScalar,a.y=(p-e.stSouth)*e.latScalar):(a.x=(E-s.west)*e.lonScalar,a.y=(p-s.south)*e.latScalar)}};var y=new o,h=new e,d=new t,E=new e,m=new i;return p.computeOptions=function(e,t,r,i){var o,c,l,f,p,y=e._granularity,h=e._ellipsoid,O=e._surfaceHeight,_=e._rotation,w=e._stRotation,T=e._extrudedHeight,v=t.east,b=t.west,R=t.north,g=t.south,A=R-g;b>v?(p=a.TWO_PI-b+v,o=Math.ceil(p/y)+1,c=Math.ceil(A/y)+1,l=p/(o-1),f=A/(c-1)):(p=v-b,o=Math.ceil(p/y)+1,c=Math.ceil(A/y)+1,l=p/(o-1),f=A/(c-1)),r=u.northwest(t,r);var N=u.center(t,d);0===_&&0===w||(N.longitude<r.longitude&&(N.longitude+=a.TWO_PI),E=m.project(N,E));var S=f,x=l,I=0,M=0,C={granYCos:S,granYSin:I,granXCos:x,granXSin:M,ellipsoid:h,surfaceHeight:O,extrudedHeight:T,nwCorner:r,rectangle:t,width:o,height:c};if(0!==_){var P=s(r,_,l,f,N,o,c);if(R=P.north,g=P.south,v=P.east,b=P.west,R<-a.PI_OVER_TWO||R>a.PI_OVER_TWO||g<-a.PI_OVER_TWO||g>a.PI_OVER_TWO)throw new n("Rotated rectangle is invalid.  It crosses over either the north or south pole.");C.granYCos=P.granYCos,C.granYSin=P.granYSin,C.granXCos=P.granXCos,C.granXSin=P.granXSin,t.north=R,t.south=g,t.east=v,t.west=b}if(0!==w){_-=w,i=u.northwest(t,i);var L=s(i,_,l,f,N,o,c);C.stGranYCos=L.granYCos,C.stGranXCos=L.granXCos,C.stGranYSin=L.granYSin,C.stGranXSin=L.granXSin,C.stNwCorner=i,C.stWest=L.west,C.stSouth=L.south}return C},p}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,a){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");return a=e(a,0),i[a++]=n.position?1:0,i[a++]=n.normal?1:0,i[a++]=n.st?1:0,i[a++]=n.tangent?1:0,i[a++]=n.bitangent?1:0,i[a++]=n.color?1:0,i},i.unpack=function(n,a,o){if(!t(n))throw new r("array is required");return a=e(a,0),t(o)||(o=new i),o.position=1===n[a++],o.normal=1===n[a++],o.st=1===n[a++],o.tangent=1===n[a++],o.bitangent=1===n[a++],o.color=1===n[a++],o},i.clone=function(e,r){if(t(e))return t(r)||(r=new i),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},i}),define("Core/RectangleGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./Check","./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonPipeline","./PrimitiveType","./Quaternion","./Rectangle","./RectangleGeometryLibrary","./VertexFormat"],function(e,t,r,n,i,a,o,u,s,c,l,f,p,y,h,d,E,m,O,_,w,T,v,b,R){"use strict";function g(e,t){var r=new f({attributes:new y,primitiveType:w.TRIANGLES});return r.attributes.position=new p({componentDatatype:a.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(r.attributes.normal=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(r.attributes.tangent=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.bitangent&&(r.attributes.bitangent=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:t.bitangents})),r}function A(e,t,n,i){var a=e.length,o=t.normal?new Float32Array(a):void 0,u=t.tangent?new Float32Array(a):void 0,s=t.bitangent?new Float32Array(a):void 0,c=0,l=F,f=D,p=U;if(t.normal||t.tangent||t.bitangent)for(var y=0;y<a;y+=3){var h=r.fromArray(e,y,L),d=c+1,E=c+2;p=n.geodeticSurfaceNormal(h,p),(t.tangent||t.bitangent)&&(r.cross(r.UNIT_Z,p,f),O.multiplyByVector(i,f,f),r.normalize(f,f),t.bitangent&&r.normalize(r.cross(p,f,l),l)),t.normal&&(o[c]=p.x,o[d]=p.y,o[E]=p.z),t.tangent&&(u[c]=f.x,u[d]=f.y,u[E]=f.z),t.bitangent&&(s[c]=l.x,s[d]=l.y,s[E]=l.z),c+=3}return g(t,{positions:e,normals:o,tangents:u,bitangents:s})}function N(e,t,n){var i=e.length,a=t.normal?new Float32Array(i):void 0,o=t.tangent?new Float32Array(i):void 0,u=t.bitangent?new Float32Array(i):void 0,s=0,c=0,l=0,f=!0,p=F,y=D,h=U;if(t.normal||t.tangent||t.bitangent)for(var d=0;d<i;d+=6){var E=r.fromArray(e,d,L),O=r.fromArray(e,(d+6)%i,G);if(f){var _=r.fromArray(e,(d+3)%i,V);r.subtract(O,E,O),r.subtract(_,E,_),h=r.normalize(r.cross(_,O,h),h),f=!1}r.equalsEpsilon(O,E,m.EPSILON10)&&(f=!0),(t.tangent||t.bitangent)&&(p=n.geodeticSurfaceNormal(E,p),t.tangent&&(y=r.normalize(r.cross(p,h,y),y))),t.normal&&(a[s++]=h.x,a[s++]=h.y,a[s++]=h.z,a[s++]=h.x,a[s++]=h.y,a[s++]=h.z),t.tangent&&(o[c++]=y.x,o[c++]=y.y,o[c++]=y.z,o[c++]=y.x,o[c++]=y.y,o[c++]=y.z),t.bitangent&&(u[l++]=p.x,u[l++]=p.y,u[l++]=p.z,u[l++]=p.x,u[l++]=p.y,u[l++]=p.z)}return g(t,{positions:e,normals:a,tangents:o,bitangents:u})}function S(e){for(var t=e.vertexFormat,r=e.ellipsoid,n=e.size,i=e.height,o=e.width,u=t.position?new Float64Array(3*n):void 0,s=t.st?new Float32Array(2*n):void 0,c=0,l=0,f=L,y=z,h=Number.MAX_VALUE,d=Number.MAX_VALUE,m=-Number.MAX_VALUE,O=-Number.MAX_VALUE,_=0;_<i;++_)for(var w=0;w<o;++w)b.computePosition(e,_,w,f,y),u[c++]=f.x,u[c++]=f.y,u[c++]=f.z,t.st&&(s[l++]=y.x,s[l++]=y.y,h=Math.min(h,y.x),d=Math.min(d,y.y),m=Math.max(m,y.x),O=Math.max(O,y.y));if(t.st&&(h<0||d<0||m>1||O>1))for(var T=0;T<s.length;T+=2)s[T]=(s[T]-h)/(m-h),s[T+1]=(s[T+1]-d)/(O-d);for(var v=A(u,t,r,e.tangentRotationMatrix),R=6*(o-1)*(i-1),g=E.createTypedArray(n,R),N=0,S=0,x=0;x<i-1;++x){for(var I=0;I<o-1;++I){var M=N,C=M+o,P=C+1,U=M+1;g[S++]=M,g[S++]=C,g[S++]=U,g[S++]=U,g[S++]=C,g[S++]=P,++N}++N}return v.indices=g,t.st&&(v.attributes.st=new p({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:s})),v}function x(e,t,r,n,i){return e[t++]=n[r],e[t++]=n[r+1],e[t++]=n[r+2],e[t++]=i[r],e[t++]=i[r+1],e[t++]=i[r+2],e}function I(e,t,r,n){return e[t++]=n[r],e[t++]=n[r+1],e[t++]=n[r],e[t++]=n[r+1],e}function M(e){var t,n=e.shadowVolume,i=e.vertexFormat,o=e.surfaceHeight,u=e.extrudedHeight,s=Math.min(u,o),c=Math.max(u,o),l=e.height,f=e.width,y=e.ellipsoid;n&&(e.vertexFormat=R.clone(i,X),e.vertexFormat.normal=!0);var O=S(e);if(m.equalsEpsilon(s,c,m.EPSILON10))return O;var w=_.scaleToGeodeticHeight(O.attributes.position.values,c,y,!1);w=new Float64Array(w);var T=w.length,v=2*T,b=new Float64Array(v);b.set(w);var g=_.scaleToGeodeticHeight(O.attributes.position.values,s,y);b.set(g,T),O.attributes.position.values=b;var A,M,C=i.normal?new Float32Array(v):void 0,P=i.tangent?new Float32Array(v):void 0,L=i.bitangent?new Float32Array(v):void 0,U=i.st?new Float32Array(v/3*2):void 0;if(i.normal){for(M=O.attributes.normal.values,C.set(M),t=0;t<T;t++)M[t]=-M[t];C.set(M,T),O.attributes.normal.values=C}if(n){M=O.attributes.normal.values,i.normal||(O.attributes.normal=void 0);var D=new Float32Array(v);for(t=0;t<T;t++)M[t]=-M[t];D.set(M,T),O.attributes.extrudeDirection=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:D})}if(i.tangent){var F=O.attributes.tangent.values;for(P.set(F),t=0;t<T;t++)F[t]=-F[t];P.set(F,T),O.attributes.tangent.values=P}if(i.bitangent){var q=O.attributes.bitangent.values;L.set(q),L.set(q,T),O.attributes.bitangent.values=L}i.st&&(A=O.attributes.st.values,U.set(A),U.set(A,T/3*2),O.attributes.st.values=U);var z=O.indices,B=z.length,j=T/3,W=E.createTypedArray(v/3,2*B);for(W.set(z),t=0;t<B;t+=3)W[t+B]=z[t+2]+j,W[t+1+B]=z[t+1]+j,W[t+2+B]=z[t]+j;O.indices=W;var H,Y=2*f+2*l-4,k=2*(Y+4),Z=new Float64Array(3*k),K=n?new Float32Array(3*k):void 0,Q=i.st?new Float32Array(2*k):void 0,J=0,$=0,ee=0,te=f*l;for(t=0;t<te;t+=f)H=3*t,Z=x(Z,J,H,w,g),J+=6,i.st&&(Q=I(Q,$,2*t,A),$+=4),n&&(ee+=3,K[ee++]=M[H],K[ee++]=M[H+1],K[ee++]=M[H+2]);for(t=te-f;t<te;t++)H=3*t,Z=x(Z,J,H,w,g),J+=6,i.st&&(Q=I(Q,$,2*t,A),$+=4),n&&(ee+=3,K[ee++]=M[H],K[ee++]=M[H+1],K[ee++]=M[H+2]);for(t=te-1;t>0;t-=f)H=3*t,Z=x(Z,J,H,w,g),J+=6,i.st&&(Q=I(Q,$,2*t,A),$+=4),n&&(ee+=3,K[ee++]=M[H],K[ee++]=M[H+1],K[ee++]=M[H+2]);for(t=f-1;t>=0;t--)H=3*t,Z=x(Z,J,H,w,g),J+=6,i.st&&(Q=I(Q,$,2*t,A),$+=4),n&&(ee+=3,K[ee++]=M[H],K[ee++]=M[H+1],K[ee++]=M[H+2]);var re=N(Z,i,y);i.st&&(re.attributes.st=new p({componentDatatype:a.FLOAT,componentsPerAttribute:2,values:Q})),n&&(re.attributes.extrudeDirection=new p({componentDatatype:a.FLOAT,componentsPerAttribute:3,values:K}));var ne,ie,ae,oe,ue=E.createTypedArray(k,6*Y);T=Z.length/3;var se=0;for(t=0;t<T-1;t+=2){ne=t,oe=(ne+2)%T;var ce=r.fromArray(Z,3*ne,G),le=r.fromArray(Z,3*oe,V);r.equalsEpsilon(ce,le,m.EPSILON10)||(ie=(ne+1)%T,ae=(ie+2)%T,ue[se++]=ne,ue[se++]=ie,ue[se++]=oe,ue[se++]=oe,ue[se++]=ie,ue[se++]=ae)}return re.indices=ue,re=d.combineInstances([new h({geometry:O}),new h({geometry:re})]),re[0]}function C(e,t,r){if(0===r)return v.clone(e);v.northeast(e,Z[0]),v.northwest(e,Z[1]),v.southeast(e,Z[2]),v.southwest(e,Z[3]),t.cartographicArrayToCartesianArray(Z,k);var n=t.geodeticSurfaceNormalCartographic(v.center(e,H));T.fromAxisAngle(n,r,Y),O.fromQuaternion(Y,W);for(var i=0;i<4;++i)O.multiplyByVector(W,k[i],k[i]);return t.cartesianArrayToCartographicArray(k,Z),v.fromCartographicArray(Z)}function P(e){e=o(e,o.EMPTY_OBJECT);var t=e.rectangle;if(i.typeOf.object("rectangle",t),v.validate(t),t.north<t.south)throw new c("options.rectangle.north must be greater than or equal to options.rectangle.south");var r=o(e.rotation,0);this._rectangle=t,this._granularity=o(e.granularity,m.RADIANS_PER_DEGREE),this._ellipsoid=l.clone(o(e.ellipsoid,l.WGS84)),this._surfaceHeight=o(e.height,0),this._rotation=r,this._stRotation=o(e.stRotation,0),this._vertexFormat=R.clone(o(e.vertexFormat,R.DEFAULT)),this._extrudedHeight=o(e.extrudedHeight,0),this._extrude=u(e.extrudedHeight),this._closeTop=o(e.closeTop,!0),this._closeBottom=o(e.closeBottom,!0),this._shadowVolume=o(e.shadowVolume,!1),this._workerName="createRectangleGeometry",this._rotatedRectangle=C(this._rectangle,this._ellipsoid,r)}var L=new r,U=new r,D=new r,F=new r,q=new v,z=new t,B=new e,j=new e,G=new r,V=new r,X=new R,W=new O,H=new r,Y=new T,k=[new r,new r,new r,new r],Z=[new n,new n,new n,new n];P.packedLength=v.packedLength+l.packedLength+R.packedLength+v.packedLength+9,P.pack=function(e,t,r){return i.typeOf.object("value",e),i.defined("array",t),r=o(r,0),v.pack(e._rectangle,t,r),r+=v.packedLength,l.pack(e._ellipsoid,t,r),r+=l.packedLength,R.pack(e._vertexFormat,t,r),r+=R.packedLength,v.pack(e._rotatedRectangle,t,r),r+=v.packedLength,t[r++]=e._granularity,t[r++]=e._surfaceHeight,t[r++]=e._rotation,t[r++]=e._stRotation,t[r++]=e._extrudedHeight,t[r++]=e._extrude?1:0,t[r++]=e._closeTop?1:0,t[r++]=e._closeBottom?1:0,t[r]=e._shadowVolume?1:0,t};var K=new v,Q=new v,J=l.clone(l.UNIT_SPHERE),$={rectangle:K,ellipsoid:J,vertexFormat:X,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,closeTop:void 0,closeBottom:void 0,shadowVolume:void 0};P.unpack=function(e,t,r){i.defined("array",e),t=o(t,0);var n=v.unpack(e,t,K);t+=v.packedLength;var a=l.unpack(e,t,J);t+=l.packedLength;var s=R.unpack(e,t,X);t+=R.packedLength;var c=v.unpack(e,t,Q);t+=v.packedLength;var f=e[t++],p=e[t++],y=e[t++],h=e[t++],d=e[t++],E=1===e[t++],m=1===e[t++],O=1===e[t++],_=1===e[t];return u(r)?(r._rectangle=v.clone(n,r._rectangle),r._ellipsoid=l.clone(a,r._ellipsoid),r._vertexFormat=R.clone(s,r._vertexFormat),r._granularity=f,r._surfaceHeight=p,r._rotation=y,r._stRotation=h,r._extrudedHeight=E?d:void 0,r._extrude=E,r._closeTop=m,r._closeBottom=O,r._rotatedRectangle=c,r._shadowVolume=_,r):($.granularity=f,$.height=p,$.rotation=y,$.stRotation=h,$.extrudedHeight=E?d:void 0,$.closeTop=m,$.closeBottom=O,$.shadowVolume=_,new P($))};var ee=new O,te=new n,re=new n,ne=new T,ie=new n;return P.createGeometry=function(t){if(!m.equalsEpsilon(t._rectangle.north,t._rectangle.south,m.EPSILON10)&&!m.equalsEpsilon(t._rectangle.east,t._rectangle.west,m.EPSILON10)){var r=v.clone(t._rectangle,q),n=t._ellipsoid,i=t._surfaceHeight,a=t._extrude,o=t._extrudedHeight,u=t._rotation,s=t._stRotation,c=t._vertexFormat,l=b.computeOptions(t,r,te,re),p=ee;if(0!==s||0!==u){var y=v.center(r,ie),h=n.geodeticSurfaceNormalCartographic(y,G);T.fromAxisAngle(h,-s,ne),O.fromQuaternion(ne,p)}else O.clone(O.IDENTITY,p);l.lonScalar=1/t._rectangle.width,l.latScalar=1/t._rectangle.height,l.vertexFormat=c,l.rotation=u,l.stRotation=s,l.tangentRotationMatrix=p,l.size=l.width*l.height;var d,E;if(r=t._rectangle,a){l.shadowVolume=t._shadowVolume,d=M(l);var w=e.fromRectangle3D(r,n,i,j),R=e.fromRectangle3D(r,n,o,B);E=e.union(w,R)}else d=S(l),d.attributes.position.values=_.scaleToGeodeticHeight(d.attributes.position.values,i,n,!1),E=e.fromRectangle3D(r,n,i);return c.position||delete d.attributes.position,new f({attributes:d.attributes,indices:d.indices,primitiveType:d.primitiveType,boundingSphere:E})}},P.createShadowVolume=function(e,t,r){var n=e._granularity,i=e._ellipsoid,a=t(n,i),o=r(n,i);return new P({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:i,stRotation:e._stRotation,granularity:n,extrudedHeight:o,height:a,closeTop:!0,closeBottom:!0,vertexFormat:R.POSITION_ONLY,shadowVolume:!0})},s(P.prototype,{rectangle:{get:function(){
return this._rotatedRectangle}}}),P}),define("Workers/createRectangleGeometry",["../Core/defined","../Core/Ellipsoid","../Core/Rectangle","../Core/RectangleGeometry"],function(e,t,r,n){"use strict";function i(i,a){return e(a)&&(i=n.unpack(i,a)),i._ellipsoid=t.clone(i._ellipsoid),i._rectangle=r.clone(i._rectangle),n.createGeometry(i)}return i})}();