/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(n,i){if(!e(i))throw new t(r(n))},i.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},i.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},i.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},i.typeOf.number.lessThan=function(e,r,n){if(i.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},i.typeOf.number.lessThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},i.typeOf.number.greaterThan=function(e,r,n){if(i.typeOf.number(e,r),r<=n)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},i.typeOf.number.greaterThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r<n)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},i.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},i.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:e<0?-1:0},i.signNotZero=function(e){return e<0?-1:1},i.toSNorm=function(e,r){return r=t(r,255),Math.round((.5*i.clamp(e,-1,1)+.5)*r)},i.fromSNorm=function(e,r){return r=t(r,255),i.clamp(e,0,r)/r*2-1},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!r(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!r(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!r(e))throw new n("angle is required.");var t=i.TWO_PI,a=e-Math.floor(e/t)*t;return a<-Math.PI?a+t:a>=Math.PI?a-t:a},i.clampToLatitudeRange=function(e){if(!r(e))throw new n("angle is required.");return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){if(!r(e))throw new n("angle is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!r(e))throw new n("angle is required.");var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){if(!r(e))throw new n("m is required.");if(!r(t))throw new n("n is required.");return(e%t+t)%t},i.equalsEpsilon=function(e,i,a,o){if(!r(e))throw new n("left is required.");if(!r(i))throw new n("right is required.");if(!r(a))throw new n("relativeEpsilon is required.");o=t(o,a);var u=Math.abs(e-i);return u<=o||u<=a*Math.max(Math.abs(e),Math.abs(i))};var a=[1];i.factorial=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],i=t;i<=e;i++)a.push(r*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=t(a,0),!r(e))throw new n("n is required.");if(i<=a)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,i){if(!r(e))throw new n("value is required");if(!r(t))throw new n("min is required.");if(!r(i))throw new n("max is required.");return e<t?t:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(t){if(!r(t))throw new n("seed is required.");o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){if(!r(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!r(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){if(!r(e))throw new n("angle is required.");if(!r(t))throw new n("radius is required.");return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){if(!r(e))throw new n("number is required.");if(!r(t))throw new n("base is required.");return Math.log(e)/Math.log(t)},i.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},i}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new o);var a=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var a=0;a<i;++a)o.pack(t[a],n,3*a);return n},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var a=t.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;u<a;u+=3){var s=u/3;i[s]=o.unpack(t,u,i[s])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(e,t,i){if(!r(e))throw new n("left is required");if(!r(t))throw new n("right is required");if(!r(i))throw new n("result is required");return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,f=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,f);var n=o.dot(c,f),i=o.magnitude(o.cross(c,f,c));return Math.atan2(i,n)};var l=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,l);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=r.x,s=r.y,c=r.z,f=a*c-o*s,l=o*u-i*c,p=i*s-a*u;return n.x=f,n.y=l,n.z=p,n},o.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=a.toRadians(t),r=a.toRadians(r),o.fromRadians(t,r,n,i,u)};var p=new o,h=new o,d=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),a=t(a,0);var c=r(u)?u.radiiSquared:d,f=Math.cos(i);p.x=f*Math.cos(n),p.y=f*Math.sin(n),p.z=Math.sin(i),p=o.normalize(p,p),o.multiplyComponents(c,p,h);var l=Math.sqrt(o.dot(p,h));return h=o.divideByScalar(h,l,h),p=o.multiplyByScalar(p,a,p),r(s)||(s=new o),o.add(h,p,s)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],f=t[s+1],l=s/2;a[l]=o.fromDegrees(c,f,0,i,a[l])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],f=t[s+1],l=s/2;a[l]=o.fromRadians(c,f,0,i,a[l])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;a[p]=o.fromDegrees(c,f,l,i,a[p])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],f=t[s+1],l=t[s+2],p=s/3;a[p]=o.fromRadians(c,f,l,i,a[p])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(i,u,s,c,f){if(!t(i))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var l=i.x,p=i.y,h=i.z,d=u.x,y=u.y,E=u.z,m=l*l*d*d,T=p*p*y*y,O=h*h*E*E,_=m+T+O,R=Math.sqrt(1/_),w=e.multiplyByScalar(i,R,a);if(_<c)return isFinite(R)?e.clone(w,f):void 0;var b=s.x,v=s.y,A=s.z,g=o;g.x=w.x*b*2,g.y=w.y*v*2,g.z=w.z*A*2;var N,S,I,M,x,C,P,L,U,D,F,B=(1-R)*e.magnitude(i)/(.5*e.magnitude(g)),q=0;do{B-=q,I=1/(1+B*b),M=1/(1+B*v),x=1/(1+B*A),C=I*I,P=M*M,L=x*x,U=C*I,D=P*M,F=L*x,N=m*C+T*P+O*L-1,S=m*U*b+T*D*v+O*F*A;var z=-2*S;q=N/z}while(Math.abs(N)>n.EPSILON12);return t(f)?(f.x=l*I,f.y=p*M,f.z=h*x,f):new e(l*I,p*M,h*x)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o){"use strict";function u(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)}u.fromRadians=function(e,i,a,o){if(!r(e))throw new n("longitude is required.");if(!r(i))throw new n("latitude is required.");return a=t(a,0),r(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new u(e,i,a)},u.fromDegrees=function(e,t,i,o){if(!r(e))throw new n("longitude is required.");if(!r(t))throw new n("latitude is required.");return e=a.toRadians(e),t=a.toRadians(t),u.fromRadians(e,t,i,o)};var s=new e,c=new e,f=new e,l=new e(1/6378137,1/6378137,1/6356752.314245179),p=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=a.EPSILON1;return u.fromCartesian=function(t,n,i){var d=r(n)?n.oneOverRadii:l,y=r(n)?n.oneOverRadiiSquared:p,E=r(n)?n._centerToleranceSquared:h,m=o(t,d,y,E,c);if(r(m)){var T=e.multiplyComponents(m,y,s);T=e.normalize(T,T);var O=e.subtract(t,m,f),_=Math.atan2(T.y,T.x),R=Math.asin(T.z),w=a.sign(e.dot(O,t))*e.magnitude(O);return r(i)?(i.longitude=_,i.latitude=R,i.height=w,i):new u(_,R,w)}},u.clone=function(e,t){if(r(e))return r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===t||r(e)&&r(t)&&Math.abs(e.longitude-t.longitude)<=i&&Math.abs(e.latitude-t.latitude)<=i&&Math.abs(e.height-t.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o,u,s){"use strict";function c(t,n,i,o){if(n=r(n,0),i=r(i,0),o=r(o,0),n<0||i<0||o<0)throw new a("All radii components must be greater than or equal to zero.");t._radii=new e(n,i,o),t._radiiSquared=new e(n*n,i*i,o*o),t._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,o*o*o*o),t._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===o?0:1/(o*o)),t._minimumRadius=Math.min(n,i,o),t._maximumRadius=Math.max(n,i,o),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._sqauredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function f(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._sqauredXOverSquaredZ=void 0,c(this,e,t,r)}i(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(t,r){if(n(t)){var i=t._radii;return n(r)?(e.clone(i,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new f(i.x,i.y,i.z)}},f.fromCartesian3=function(e,t){return n(t)||(t=new f),n(e)?(c(t,e.x,e.y,e.z),t):t},f.WGS84=o(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=o(new f(1,1,1)),f.MOON=o(new f(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(t,i,o){if(!n(t))throw new a("value is required");if(!n(i))throw new a("array is required");return o=r(o,0),e.pack(t._radii,i,o),i},f.unpack=function(t,i,o){if(!n(t))throw new a("array is required");i=r(i,0);var u=e.unpack(t,i);return f.fromCartesian3(u,o)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(t,r){if(!n(t))throw new a("cartographic is required.");var i=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(i),c=u*Math.sin(i),f=Math.sin(o);return n(r)||(r=new e),r.x=s,r.y=c,r.z=f,e.normalize(r,r)},f.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var l=new e,p=new e;f.prototype.cartographicToCartesian=function(t,r){var i=l,a=p;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),n(r)||(r=new e),e.add(a,i,r)},f.prototype.cartographicArrayToCartesianArray=function(e,t){if(!n(e))throw new a("cartographics is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;i<r;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var h=new e,d=new e,y=new e;return f.prototype.cartesianToCartographic=function(r,i){var a=this.scaleToGeodeticSurface(r,d);if(n(a)){var o=this.geodeticSurfaceNormal(a,h),s=e.subtract(r,a,y),c=Math.atan2(o.y,o.x),f=Math.asin(o.z),l=u.sign(e.dot(s,r))*e.magnitude(s);return n(i)?(i.longitude=c,i.latitude=f,i.height=l,i):new t(c,f,l)}},f.prototype.cartesianArrayToCartographicArray=function(e,t){if(!n(e))throw new a("cartesians is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;i<r;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},f.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},f.prototype.scaleToGeocentricSurface=function(t,r){if(!n(t))throw new a("cartesian is required.");n(r)||(r=new e);var i=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,r)},f.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},f.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},f.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},f.prototype.toString=function(){return this._radii.toString()},f.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,i,o){if(!n(t))throw new a("position is required.");if(!u.equalsEpsilon(this._radii.x,this._radii.y,u.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");if(0===this._radii.z)throw new a("Ellipsoid.radii.z must be greater than 0");i=r(i,0);var s=this._sqauredXOverSquaredZ;if(n(o)||(o=new e),o.x=0,o.y=0,o.z=t.z*(1-s),!(Math.abs(o.z)>=this._radii.z-i))return o},f}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,a,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i,a,o,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function f(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(y[r],d[r])];t+=2*n*n}return Math.sqrt(t)}function l(e,t){for(var r=u.EPSILON15,n=0,i=1,a=0;a<3;++a){var o=Math.abs(e[s.getElementIndex(y[a],d[a])]);o>n&&(i=a,n=o)}var c=1,f=0,l=d[i],p=y[i];if(Math.abs(e[s.getElementIndex(p,l)])>r){var h,E=e[s.getElementIndex(p,p)],m=e[s.getElementIndex(l,l)],T=e[s.getElementIndex(p,l)],O=(E-m)/2/T;h=O<0?-1/(-O+Math.sqrt(1+O*O)):1/(O+Math.sqrt(1+O*O)),c=1/Math.sqrt(1+h*h),f=h*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(l,l)]=t[s.getElementIndex(p,p)]=c,t[s.getElementIndex(p,l)]=f,t[s.getElementIndex(l,p)]=-f,t}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,f=e.y*e.z,l=e.y*e.w,p=e.z*e.z,h=e.z*e.w,d=e.w*e.w,y=i-c-p+d,E=2*(a-h),m=2*(o+l),T=2*(a+h),O=-i+c-p+d,_=2*(f-u),R=2*(o-l),w=2*(f+u),b=-i-c+p+d;return n(r)?(r[0]=y,r[1]=T,r[2]=R,r[3]=E,r[4]=O,r[5]=w,r[6]=m,r[7]=_,r[8]=b,r):new s(y,E,m,T,O,_,R,w,b)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),a=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),f=Math.sin(e.roll),l=i*a,p=-o*c+f*u*a,h=f*c+o*u*a,d=i*c,y=o*a+f*u*c,E=-u*o+o*u*c,m=-u,T=f*i,O=o*i;return n(r)?(r[0]=l,r[1]=d,r[2]=m,r[3]=p,r[4]=y,r[5]=T,r[6]=h,r[7]=E,r[8]=O,r):new s(l,p,h,d,y,E,m,T,O)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new s(1,0,0,0,i,-a,0,a,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new s(i,0,a,0,1,0,-a,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-a,0,a,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,a=e[i],o=e[i+1],u=e[i+2];return n.x=a,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i);var a=3*r;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],a=e[r+3],o=e[r+6];return n.x=i,n.y=a,n.z=o,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i),i[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var p=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],p)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],p)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],p)),n};var h=new e;s.getMaximumScale=function(t){return s.getScale(t,h),e.maximumComponent(h)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],l=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],p=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=f,n[7]=l,n[8]=p,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,a=r.y,o=r.z,u=e[0]*i+e[3]*a+e[6]*o,s=e[1]*i+e[4]*a+e[7]*o,c=e[2]*i+e[5]*a+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),
r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=f,r[8]=l,r};var d=[1,0,0],y=[2,2,1],E=new s,m=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,a=10,o=0,p=0;n(r)||(r={});for(var h=r.unitary=s.clone(s.IDENTITY,r.unitary),d=r.diagonal=s.clone(e,r.diagonal),y=i*c(d);p<a&&f(d)>y;)l(d,E),s.transpose(E,m),s.multiply(d,E,d),s.multiply(m,d,d),s.multiply(h,E,h),++o>2&&(++p,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],f=e[8];return r*(o*f-c*u)+a*(c*i-n*f)+s*(n*u-o*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],o=e[2],c=e[3],f=e[4],l=e[5],p=e[6],h=e[7],d=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new a("matrix is not invertible");r[0]=f*d-h*l,r[1]=h*o-i*d,r[2]=i*l-f*o,r[3]=p*l-c*d,r[4]=n*d-p*o,r[5]=c*o-n*l,r[6]=c*h-p*f,r[7]=p*i-n*h,r[8]=n*f-c*i;var E=1/y;return s.multiplyByScalar(r,E,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var a=0;a<i;++a)o.pack(t[a],n,4*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var a=0;a<i;a+=4){var u=a/4;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)&&a.equalsEpsilon(e.w,t.w,n,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function f(e,t,r,i,a,o,u,s,c,f,l,p,h,d,y,E){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(f,0),this[7]=n(d,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(l,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(p,0),this[15]=n(E,0)}f.packedLength=16,f.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},f.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new f),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},f.clone=function(e,t){if(i(e))return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return r.defined("values",e),f.clone(e,t)},f.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,a,o){return r.typeOf.object("rotation",t),a=n(a,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new f(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,a){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(a)||(a=new f);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,l=t.x*t.y,p=t.x*t.z,h=t.x*t.w,d=t.y*t.y,y=t.y*t.z,E=t.y*t.w,m=t.z*t.z,T=t.z*t.w,O=t.w*t.w,_=c-d-m+O,R=2*(l-T),w=2*(p+E),b=2*(l+T),v=-c+d-m+O,A=2*(y-h),g=2*(p-E),N=2*(y+h),S=-c-d+m+O;return a[0]=_*o,a[1]=b*o,a[2]=g*o,a[3]=0,a[4]=R*u,a[5]=v*u,a[6]=N*u,a[7]=0,a[8]=w*s,a[9]=A*s,a[10]=S*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return r.typeOf.object("translation",e),f.fromRotationTranslation(s.IDENTITY,e,t)},f.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,p=new e,h=new e;f.fromCamera=function(t,n){r.typeOf.object("camera",t);var a=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",a),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,l),e.normalize(e.cross(l,u,p),p),e.normalize(e.cross(p,l,h),h);var s=p.x,c=p.y,d=p.z,y=l.x,E=l.y,m=l.z,T=h.x,O=h.y,_=h.z,R=a.x,w=a.y,b=a.z,v=s*-R+c*-w+d*-b,A=T*-R+O*-w+_*-b,g=y*R+E*w+m*b;return i(n)?(n[0]=s,n[1]=T,n[2]=-y,n[3]=0,n[4]=c,n[5]=O,n[6]=-E,n[7]=0,n[8]=d,n[9]=_,n[10]=-m,n[11]=0,n[12]=v,n[13]=A,n[14]=g,n[15]=1,n):new f(s,c,d,v,T,O,_,A,-y,-E,-m,g,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,i,a){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",a);var o=Math.tan(.5*e),u=1/o,s=u/t,c=(i+n)/(n-i),f=2*i*n/(n-i);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},f.computeOrthographicOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),f=1/(o-a),l=-(t+e)*s,p=-(i+n)*c,h=-(o+a)*f;return s*=2,c*=2,f*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=f,u[11]=0,u[12]=l,u[13]=p,u[14]=h,u[15]=1,u},f.computePerspectiveOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*a/(t-e),c=2*a/(i-n),f=(t+e)/(t-e),l=(i+n)/(i-n),p=-(o+a)/(o-a),h=-1,d=-2*o*a/(o-a);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=p,u[11]=h,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,t,n,i,a,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.object("result",o);var u=2*a/(t-e),s=2*a/(i-n),c=(t+e)/(t-e),f=(i+n)/(i-n),l=-1,p=-1,h=-2*a;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=f,o[10]=l,o[11]=p,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},f.computeViewportTransformation=function(e,t,i,a){r.typeOf.object("result",a),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),i=n(i,1);var f=.5*s,l=.5*c,p=.5*(i-t),h=f,d=l,y=p,E=o+f,m=u+l,T=t+p,O=1;return a[0]=h,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=E,a[13]=m,a[14]=T,a[15]=O,a},f.computeView=function(t,n,i,a,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",a),r.typeOf.object("result",o),o[0]=a.x,o[1]=i.x,o[2]=-n.x,o[3]=0,o[4]=a.y,o[5]=i.y,o[6]=-n.y,o[7]=0,o[8]=a.z,o[9]=i.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(a,t),o[13]=-e.dot(i,t),o[14]=e.dot(n,t),o[15]=1,o},f.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},f.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,a=e[i],o=e[i+1],u=e[i+2],s=e[i+3];return n.x=a,n.y=o,n.z=u,n.w=s,n},f.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=f.clone(e,i);var a=4*t;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i[a+3]=n.w,i},f.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},f.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],a=e[t+4],o=e[t+8],u=e[t+12];return n.x=i,n.y=a,n.z=o,n.w=u,n},f.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=f.clone(e,i),i[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var d=new e;f.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],d)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],d)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],d)),n};var y=new e;f.getMaximumScale=function(t){return f.getScale(t,y),e.maximumComponent(y)},f.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[3],s=e[4],c=e[5],f=e[6],l=e[7],p=e[8],h=e[9],d=e[10],y=e[11],E=e[12],m=e[13],T=e[14],O=e[15],_=t[0],R=t[1],w=t[2],b=t[3],v=t[4],A=t[5],g=t[6],N=t[7],S=t[8],I=t[9],M=t[10],x=t[11],C=t[12],P=t[13],L=t[14],U=t[15],D=i*_+s*R+p*w+E*b,F=a*_+c*R+h*w+m*b,B=o*_+f*R+d*w+T*b,q=u*_+l*R+y*w+O*b,z=i*v+s*A+p*g+E*N,j=a*v+c*A+h*g+m*N,G=o*v+f*A+d*g+T*N,V=u*v+l*A+y*g+O*N,X=i*S+s*I+p*M+E*x,H=a*S+c*I+h*M+m*x,W=o*S+f*I+d*M+T*x,k=u*S+l*I+y*M+O*x,Y=i*C+s*P+p*L+E*U,Z=a*C+c*P+h*L+m*U,K=o*C+f*P+d*L+T*U,Q=u*C+l*P+y*L+O*U;return n[0]=D,n[1]=F,n[2]=B,n[3]=q,n[4]=z,n[5]=j,n[6]=G,n[7]=V,n[8]=X,n[9]=H,n[10]=W,n[11]=k,n[12]=Y,n[13]=Z,n[14]=K,n[15]=Q,n},f.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],h=e[12],d=e[13],y=e[14],E=t[0],m=t[1],T=t[2],O=t[4],_=t[5],R=t[6],w=t[8],b=t[9],v=t[10],A=t[12],g=t[13],N=t[14],S=i*E+u*m+f*T,I=a*E+s*m+l*T,M=o*E+c*m+p*T,x=i*O+u*_+f*R,C=a*O+s*_+l*R,P=o*O+c*_+p*R,L=i*w+u*b+f*v,U=a*w+s*b+l*v,D=o*w+c*b+p*v,F=i*A+u*g+f*N+h,B=a*A+s*g+l*N+d,q=o*A+c*g+p*N+y;return n[0]=S,n[1]=I,n[2]=M,n[3]=0,n[4]=x,n[5]=C,n[6]=P,n[7]=0,n[8]=L,n[9]=U,n[10]=D,n[11]=0,n[12]=F,n[13]=B,n[14]=q,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],p=e[10],h=t[0],d=t[1],y=t[2],E=t[3],m=t[4],T=t[5],O=t[6],_=t[7],R=t[8],w=i*h+u*d+f*y,b=a*h+s*d+l*y,v=o*h+c*d+p*y,A=i*E+u*m+f*T,g=a*E+s*m+l*T,N=o*E+c*m+p*T,S=i*O+u*_+f*R,I=a*O+s*_+l*R,M=o*O+c*_+p*R;return n[0]=w,n[1]=b,n[2]=v,n[3]=0,n[4]=A,n[5]=g,n[6]=N,n[7]=0,n[8]=S,n[9]=I,n[10]=M,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=i*e[0]+a*e[4]+o*e[8]+e[12],s=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var E=new e;f.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),E.x=t,E.y=t,E.z=t,f.multiplyByScale(e,E,n)},f.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?f.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=t.w,s=e[0]*i+e[4]*a+e[8]*o+e[12]*u,c=e[1]*i+e[5]*a+e[9]*o+e[13]*u,f=e[2]*i+e[6]*a+e[10]*o+e[14]*u,l=e[3]*i+e[7]*a+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=f,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o,s=e[1]*i+e[5]*a+e[9]*o,c=e[2]*i+e[6]*a+e[10]*o;return n.x=u,n.y=s,n.z=c,n},f.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o+e[12],s=e[1]*i+e[5]*a+e[9]*o+e[13],c=e[2]*i+e[6]*a+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},f.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],a=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=s,t[15]=e[15],t},f.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var m=new s,T=new s,O=new t,_=new t(0,0,0,1);return f.inverse=function(e,n){if(r.typeOf.object("matrix",e),r.typeOf.object("result",n),s.equalsEpsilon(f.getRotation(e,m),T,u.EPSILON7)&&t.equals(f.getRow(e,3,O),_))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var i=e[0],a=e[4],o=e[8],l=e[12],p=e[1],h=e[5],d=e[9],y=e[13],E=e[2],R=e[6],w=e[10],b=e[14],v=e[3],A=e[7],g=e[11],N=e[15],S=w*N,I=b*g,M=R*N,x=b*A,C=R*g,P=w*A,L=E*N,U=b*v,D=E*g,F=w*v,B=E*A,q=R*v,z=S*h+x*d+C*y-(I*h+M*d+P*y),j=I*p+L*d+F*y-(S*p+U*d+D*y),G=M*p+U*h+B*y-(x*p+L*h+q*y),V=P*p+D*h+q*d-(C*p+F*h+B*d),X=I*a+M*o+P*l-(S*a+x*o+C*l),H=S*i+U*o+D*l-(I*i+L*o+F*l),W=x*i+L*a+q*l-(M*i+U*a+B*l),k=C*i+F*a+B*o-(P*i+D*a+q*o);S=o*y,I=l*d,M=a*y,x=l*h,C=a*d,P=o*h,L=i*y,U=l*p,D=i*d,F=o*p,B=i*h,q=a*p;var Y=S*A+x*g+C*N-(I*A+M*g+P*N),Z=I*v+L*g+F*N-(S*v+U*g+D*N),K=M*v+U*A+B*N-(x*v+L*A+q*N),Q=P*v+D*A+q*g-(C*v+F*A+B*g),J=M*w+P*b+I*R-(C*b+S*R+x*w),$=D*b+S*E+U*w-(L*w+F*b+I*E),ee=L*R+q*b+x*E-(B*b+M*E+U*R),te=B*w+C*E+F*R-(D*R+q*w+P*E),re=i*z+a*j+o*G+l*V;if(Math.abs(re)<u.EPSILON20)throw new c("matrix is not invertible because its determinate is zero.");return re=1/re,n[0]=z*re,n[1]=j*re,n[2]=G*re,n[3]=V*re,n[4]=X*re,n[5]=H*re,n[6]=W*re,n[7]=k*re,n[8]=Y*re,n[9]=Z*re,n[10]=K*re,n[11]=Q*re,n[12]=J*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},f.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],f=e[9],l=e[10],p=e[12],h=e[13],d=e[14],y=-n*p-i*h-a*d,E=-o*p-u*h-s*d,m=-c*p-f*h-l*d;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=f,t[7]=0,t[8]=a,t[9]=s,t[10]=l,t[11]=0,t[12]=y,t[13]=E,t[14]=m,t[15]=1,t},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=o(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,a(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,a,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),n(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new s(e,t,i,a)},s.fromRadians=function(e,t,i,a,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(i,0),o.north=r(a,0),o):new s(e,t,i,a)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,f=Number.MAX_VALUE,l=-Number.MAX_VALUE,p=0,h=e.length;p<h;p++){var d=e[p];i=Math.min(i,d.longitude),a=Math.max(a,d.longitude),f=Math.min(f,d.latitude),l=Math.max(l,d.latitude);var y=d.longitude>=0?d.longitude:d.longitude+u.TWO_PI;o=Math.min(o,y),c=Math.max(c,y)}return a-i>c-o&&(i=o,a=c,a>u.PI&&(a-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=f,r.east=a,r.north=l,r):new s(i,f,a,l)},s.fromCartesianArray=function(e,r,i){t.defined("cartesians",e);for(var a=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,f=-Number.MAX_VALUE,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,h=0,d=e.length;h<d;h++){var y=r.cartesianToCartographic(e[h]);a=Math.min(a,y.longitude),o=Math.max(o,y.longitude),l=Math.min(l,y.latitude),p=Math.max(p,y.latitude);var E=y.longitude>=0?y.longitude:y.longitude+u.TWO_PI;c=Math.min(c,E),f=Math.max(f,E)}return o-a>f-c&&(a=c,o=f,o>u.PI&&(o-=u.TWO_PI),a>u.PI&&(a-=u.TWO_PI)),n(i)?(i.west=a,i.south=l,i.east=o,i.north=p,i):new s(a,l,o,p)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),n(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var a=r.east,o=r.west;a<o&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=e.east,o=e.west,c=r.east,f=r.west;a<o&&c>0?a+=u.TWO_PI:c<f&&a>0&&(c+=u.TWO_PI),a<o&&f<0?f+=u.TWO_PI:c<f&&o<0&&(o+=u.TWO_PI);var l=u.negativePiToPi(Math.max(o,f)),p=u.negativePiToPi(Math.min(a,c));if(!((e.west<e.east||r.west<r.east)&&p<=l)){var h=Math.max(e.south,r.south),d=Math.min(e.north,r.north);if(!(h>=d))return n(i)?(i.west=l,i.south=h,i.east=p,i.north=d,i):new s(l,h,p,d)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(o>=c||a>=u))return n(i)?(i.west=a,
i.south=o,i.east=u,i.north=c,i):new s(a,o,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var a=e.east,o=e.west,c=r.east,f=r.west;a<o&&c>0?a+=u.TWO_PI:c<f&&a>0&&(c+=u.TWO_PI),a<o&&f<0?f+=u.TWO_PI:c<f&&o<0&&(o+=u.TWO_PI);var l=u.convertLongitudeRange(Math.min(o,f)),p=u.convertLongitudeRange(Math.max(a,c));return i.west=l,i.south=Math.min(e.south,r.south),i.east=p,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,a=e.west,o=e.east;return o<a&&(o+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(n<o||u.equalsEpsilon(n,o,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,o,f){t.typeOf.object("rectangle",e),i=r(i,a.WGS84),o=r(o,0),n(f)||(f=[]);var l=0,p=e.north,h=e.south,d=e.east,y=e.west,E=c;E.height=o,E.longitude=y,E.latitude=p,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=d,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.latitude=h,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=y,f[l]=i.cartographicToCartesian(E,f[l]),l++,p<0?E.latitude=p:h>0?E.latitude=h:E.latitude=0;for(var m=1;m<8;++m)E.longitude=-Math.PI+m*u.PI_OVER_TWO,s.contains(e,E)&&(f[l]=i.cartographicToCartesian(E,f[l]),l++);return 0===E.latitude&&(E.longitude=y,f[l]=i.cartographicToCartesian(E,f[l]),l++,E.longitude=d,f[l]=i.cartographicToCartesian(E,f[l]),l++),f.length=l,f},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,i,a,o,u,s,c,f,l){"use strict";function p(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var h=new e,d=new e,y=new e,E=new e,m=new e,T=new e,O=new e,_=new e,R=new e,w=new e,b=new e,v=new e;p.fromPoints=function(t,r){if(i(r)||(r=new p),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var n=e.clone(t[0],O),a=e.clone(n,h),o=e.clone(n,d),u=e.clone(n,y),s=e.clone(n,E),c=e.clone(n,m),f=e.clone(n,T),l=t.length,A=1;A<l;A++){e.clone(t[A],n);var g=n.x,N=n.y,S=n.z;g<a.x&&e.clone(n,a),g>s.x&&e.clone(n,s),N<o.y&&e.clone(n,o),N>c.y&&e.clone(n,c),S<u.z&&e.clone(n,u),S>f.z&&e.clone(n,f)}var I=e.magnitudeSquared(e.subtract(s,a,_)),M=e.magnitudeSquared(e.subtract(c,o,_)),x=e.magnitudeSquared(e.subtract(f,u,_)),C=a,P=s,L=I;M>L&&(L=M,C=o,P=c),x>L&&(L=x,C=u,P=f);var U=R;U.x=.5*(C.x+P.x),U.y=.5*(C.y+P.y),U.z=.5*(C.z+P.z);var D=e.magnitudeSquared(e.subtract(P,U,_)),F=Math.sqrt(D),B=w;B.x=a.x,B.y=o.y,B.z=u.z;var q=b;q.x=s.x,q.y=c.y,q.z=f.z;var z=e.multiplyByScalar(e.add(B,q,_),.5,v),j=0;for(A=0;A<l;A++){e.clone(t[A],n);var G=e.magnitude(e.subtract(n,z,_));G>j&&(j=G);var V=e.magnitudeSquared(e.subtract(n,U,_));if(V>D){var X=Math.sqrt(V);F=.5*(F+X),D=F*F;var H=X-F;U.x=(F*U.x+H*n.x)/X,U.y=(F*U.y+H*n.y)/X,U.z=(F*U.z+H*n.z)/X}}return F<j?(e.clone(U,r.center),r.radius=F):(e.clone(z,r.center),r.radius=j),r};var A=new o,g=new e,N=new e,S=new t,I=new t;p.fromRectangle2D=function(e,t,r){return p.fromRectangleWithHeights2D(e,t,0,0,r)},p.fromRectangleWithHeights2D=function(t,r,a,o,u){if(i(u)||(u=new p),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,A),l.southwest(t,S),S.height=a,l.northeast(t,I),I.height=o;var s=r.project(S,g),c=r.project(I,N),f=c.x-s.x,h=c.y-s.y,d=c.z-s.z;u.radius=.5*Math.sqrt(f*f+h*h+d*d);var y=u.center;return y.x=s.x+.5*f,y.y=s.y+.5*h,y.z=s.z+.5*d,u};var M=[];p.fromRectangle3D=function(e,t,r,o){t=n(t,a.WGS84),r=n(r,0);var u;return i(e)&&(u=l.subsample(e,t,r,M)),p.fromPoints(u,o)},p.fromVertices=function(t,a,o,u){if(i(u)||(u=new p),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=O;s.x=t[0]+a.x,s.y=t[1]+a.y,s.z=t[2]+a.z;for(var c=e.clone(s,h),f=e.clone(s,d),l=e.clone(s,y),A=e.clone(s,E),g=e.clone(s,m),N=e.clone(s,T),S=t.length,I=0;I<S;I+=o){var M=t[I]+a.x,x=t[I+1]+a.y,C=t[I+2]+a.z;s.x=M,s.y=x,s.z=C,M<c.x&&e.clone(s,c),M>A.x&&e.clone(s,A),x<f.y&&e.clone(s,f),x>g.y&&e.clone(s,g),C<l.z&&e.clone(s,l),C>N.z&&e.clone(s,N)}var P=e.magnitudeSquared(e.subtract(A,c,_)),L=e.magnitudeSquared(e.subtract(g,f,_)),U=e.magnitudeSquared(e.subtract(N,l,_)),D=c,F=A,B=P;L>B&&(B=L,D=f,F=g),U>B&&(B=U,D=l,F=N);var q=R;q.x=.5*(D.x+F.x),q.y=.5*(D.y+F.y),q.z=.5*(D.z+F.z);var z=e.magnitudeSquared(e.subtract(F,q,_)),j=Math.sqrt(z),G=w;G.x=c.x,G.y=f.y,G.z=l.z;var V=b;V.x=A.x,V.y=g.y,V.z=N.z;var X=e.multiplyByScalar(e.add(G,V,_),.5,v),H=0;for(I=0;I<S;I+=o){s.x=t[I]+a.x,s.y=t[I+1]+a.y,s.z=t[I+2]+a.z;var W=e.magnitude(e.subtract(s,X,_));W>H&&(H=W);var k=e.magnitudeSquared(e.subtract(s,q,_));if(k>z){var Y=Math.sqrt(k);j=.5*(j+Y),z=j*j;var Z=Y-j;q.x=(j*q.x+Z*s.x)/Y,q.y=(j*q.y+Z*s.y)/Y,q.z=(j*q.z+Z*s.z)/Y}}return j<H?(e.clone(q,u.center),u.radius=j):(e.clone(X,u.center),u.radius=H),u},p.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new p),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=O;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];for(var o=e.clone(a,h),u=e.clone(a,d),s=e.clone(a,y),c=e.clone(a,E),f=e.clone(a,m),l=e.clone(a,T),A=t.length,g=0;g<A;g+=3){var N=t[g]+r[g],S=t[g+1]+r[g+1],I=t[g+2]+r[g+2];a.x=N,a.y=S,a.z=I,N<o.x&&e.clone(a,o),N>c.x&&e.clone(a,c),S<u.y&&e.clone(a,u),S>f.y&&e.clone(a,f),I<s.z&&e.clone(a,s),I>l.z&&e.clone(a,l)}var M=e.magnitudeSquared(e.subtract(c,o,_)),x=e.magnitudeSquared(e.subtract(f,u,_)),C=e.magnitudeSquared(e.subtract(l,s,_)),P=o,L=c,U=M;x>U&&(U=x,P=u,L=f),C>U&&(U=C,P=s,L=l);var D=R;D.x=.5*(P.x+L.x),D.y=.5*(P.y+L.y),D.z=.5*(P.z+L.z);var F=e.magnitudeSquared(e.subtract(L,D,_)),B=Math.sqrt(F),q=w;q.x=o.x,q.y=u.y,q.z=s.z;var z=b;z.x=c.x,z.y=f.y,z.z=l.z;var j=e.multiplyByScalar(e.add(q,z,_),.5,v),G=0;for(g=0;g<A;g+=3){a.x=t[g]+r[g],a.y=t[g+1]+r[g+1],a.z=t[g+2]+r[g+2];var V=e.magnitude(e.subtract(a,j,_));V>G&&(G=V);var X=e.magnitudeSquared(e.subtract(a,D,_));if(X>F){var H=Math.sqrt(X);B=.5*(B+H),F=B*B;var W=H-B;D.x=(B*D.x+W*a.x)/H,D.y=(B*D.y+W*a.y)/H,D.z=(B*D.z+W*a.z)/H}}return B<G?(e.clone(D,n.center),n.radius=B):(e.clone(j,n.center),n.radius=G),n},p.fromCornerPoints=function(t,n,a){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(a)||(a=new p);var o=a.center;return e.add(t,n,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,n),a},p.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new p),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var x=new e;p.fromBoundingSpheres=function(t,r){if(i(r)||(r=new p),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return p.clone(t[0],r);if(2===n)return p.union(t[0],t[1],r);for(var a=[],o=0;o<n;o++)a.push(t[o].center);r=p.fromPoints(a,r);var u=r.center,s=r.radius;for(o=0;o<n;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,x)+c.radius)}return r.radius=s,r};var C=new e,P=new e,L=new e;p.fromOrientedBoundingBox=function(t,r){i(r)||(r=new p);var n=t.halfAxes,a=c.getColumn(n,0,C),o=c.getColumn(n,1,P),u=c.getColumn(n,2,L),s=e.magnitude(a),f=e.magnitude(o),l=e.magnitude(u);return r.center=e.clone(t.center,r.center),r.radius=Math.max(s,f,l),r},p.clone=function(t,r){if(i(t))return i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new p(t.center,t.radius)},p.packedLength=4,p.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var a=e.center;return t[i++]=a.x,t[i++]=a.y,t[i++]=a.z,t[i]=e.radius,t},p.unpack=function(e,t,a){r.defined("array",e),t=n(t,0),i(a)||(a=new p);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var U=new e,D=new e;p.union=function(t,n,a){r.typeOf.object("left",t),r.typeOf.object("right",n),i(a)||(a=new p);var o=t.center,u=t.radius,s=n.center,c=n.radius,f=e.subtract(s,o,U),l=e.magnitude(f);if(u>=l+c)return t.clone(a),a;if(c>=l+u)return n.clone(a),a;var h=.5*(u+l+c),d=e.multiplyByScalar(f,(-u+h)/l,D);return e.add(d,o,d),e.clone(d,a.center),a.radius=h,a};var F=new e;p.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=p.clone(t,i);var a=e.magnitude(e.subtract(n,i.center,F));return a>i.radius&&(i.radius=a),i},p.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,a=t.radius,o=n.normal,s=e.dot(o,i)+n.distance;return s<-a?u.OUTSIDE:s<a?u.INTERSECTING:u.INSIDE},p.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new p),n.center=f.multiplyByPoint(t,e.center,n.center),n.radius=f.getMaximumScale(t)*e.radius,n};var B=new e;p.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,B);return e.magnitudeSquared(i)-t.radius*t.radius},p.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new p),n.center=f.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var q=new e;p.computePlaneDistances=function(t,n,a,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",a),i(o)||(o=new s);var u=e.subtract(t.center,n,q),c=e.dot(a,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var z=new e,j=new e,G=new e,V=new e,X=new e,H=new t,W=new Array(8),k=0;k<8;++k)W[k]=new e;var Y=new o;return p.projectTo2D=function(t,i,a){r.typeOf.object("sphere",t),i=n(i,Y);var o=i.ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,z),f=e.cross(e.UNIT_Z,c,j);e.normalize(f,f);var l=e.cross(c,f,G);e.normalize(l,l),e.multiplyByScalar(c,s,c),e.multiplyByScalar(l,s,l),e.multiplyByScalar(f,s,f);var h=e.negate(l,X),d=e.negate(f,V),y=W,E=y[0];e.add(c,l,E),e.add(E,f,E),E=y[1],e.add(c,l,E),e.add(E,d,E),E=y[2],e.add(c,h,E),e.add(E,d,E),E=y[3],e.add(c,h,E),e.add(E,f,E),e.negate(c,c),E=y[4],e.add(c,l,E),e.add(E,f,E),E=y[5],e.add(c,l,E),e.add(E,d,E),E=y[6],e.add(c,h,E),e.add(E,d,E),E=y[7],e.add(c,h,E),e.add(E,f,E);for(var m=y.length,T=0;T<m;++T){var O=y[T];e.add(u,O,O);var _=o.cartesianToCartographic(O,H);i.project(_,O)}a=p.fromPoints(y,a),u=a.center;var R=u.x,w=u.y,b=u.z;return u.x=b,u.y=R,u.z=w,a},p.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},p.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},p.prototype.intersectPlane=function(e){return p.intersectPlane(this,e)},p.prototype.distanceSquaredTo=function(e){return p.distanceSquaredTo(this,e)},p.prototype.computePlaneDistances=function(e,t,r){return p.computePlaneDistances(this,e,t,r)},p.prototype.isOccluded=function(e){return p.isOccluded(this,e)},p.prototype.equals=function(e){return p.equals(this,e)},p.prototype.clone=function(e){return p.clone(this,e)},p}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(i.supportsFullscreen())return null!==i.element}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;o<u;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function i(){if(!t(R)&&(R=!1,!p())){var e=/ Chrome\/([\.0-9]+)/.exec(_.userAgent);null!==e&&(R=!0,w=n(e[1]))}return R}function a(){return i()&&w}function o(){if(!t(b)&&(b=!1,!i()&&!p()&&/ Safari\/[\.0-9]+/.test(_.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(_.userAgent);null!==e&&(b=!0,v=n(e[1]))}return b}function u(){return o()&&v}function s(){if(!t(A)){A=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(_.userAgent);null!==e&&(A=!0,g=n(e[1]),g.isNightly=!!e[2])}return A}function c(){return s()&&g}function f(){if(!t(N)){N=!1;var e;"Microsoft Internet Explorer"===_.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(_.userAgent),null!==e&&(N=!0,S=n(e[1]))):"Netscape"===_.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(_.userAgent),null!==e&&(N=!0,S=n(e[1])))}return N}function l(){return f()&&S}function p(){if(!t(I)){I=!1;var e=/ Edge\/([\.0-9]+)/.exec(_.userAgent);null!==e&&(I=!0,M=n(e[1]))}return I}function h(){return p()&&M}function d(){if(!t(x)){x=!1;var e=/Firefox\/([\.0-9]+)/.exec(_.userAgent);null!==e&&(x=!0,C=n(e[1]))}return x}function y(){return t(P)||(P=/Windows/i.test(_.appVersion)),P}function E(){return d()&&C}function m(){return t(L)||(L="undefined"!=typeof PointerEvent&&(!t(_.pointerEnabled)||_.pointerEnabled)),L}function T(){if(!t(D)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;D=t(r)&&""!==r,D&&(U=r)}return D}function O(){return T()?U:void 0}var _;_="undefined"!=typeof navigator?navigator:{};var R,w,b,v,A,g,N,S,I,M,x,C,P,L,U,D,F={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:f,internetExplorerVersion:l,isEdge:p,edgeVersion:h,isFirefox:d,firefoxVersion:E,isWindows:y,hardwareConcurrency:e(_.hardwareConcurrency,3),supportsPointerEvents:m,supportsImageRenderingPixelated:T,imageRenderingValue:O};return F.supportsFullscreen=function(){return r.supportsFullscreen()},F.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},F.supportsWebWorkers=function(){return"undefined"!=typeof Worker},F}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,i,a){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(n,i,a,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.INT:return new Int32Array(i,a,u);case o.UNSIGNED_INT:return new Uint32Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new r("componentDatatype is not a valid value.")}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}},i(o)}),define("Core/GeometryType",["./freezeObject"],function(e){
"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,i){"use strict";function a(a){if(a=e(a,e.EMPTY_OBJECT),!t(a.attributes))throw new r("options.attributes is required.");this.attributes=a.attributes,this.indices=a.indices,this.primitiveType=e(a.primitiveType,i.TRIANGLES),this.boundingSphere=a.boundingSphere,this.geometryType=e(a.geometryType,n.NONE),this.boundingSphereCV=a.boundingSphereCV}return a.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&n!==-1)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var a=0;a<i;++a)o.pack(t[a],n,2*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var a=0;a<i;a+=2){var u=a/2;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){if(!r(e)||!r(t))throw new n("left and right are required.");return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){if(!r(e)||!r(t))throw new n("left and right are required.");return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,f=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,f),a.acosClamped(o.dot(c,f))};var l=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,l);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,i){"use strict";var a={};a.octEncodeInRange=function(e,a,o){if(!r(e))throw new n("vector is required.");if(!r(o))throw new n("result is required.");var u=t.magnitudeSquared(e);if(Math.abs(u-1)>i.EPSILON6)throw new n("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=o.x,c=o.y;o.x=(1-Math.abs(c))*i.signNotZero(s),o.y=(1-Math.abs(s))*i.signNotZero(c)}return o.x=i.toSNorm(o.x,a),o.y=i.toSNorm(o.y,a),o},a.octEncode=function(e,t){return a.octEncodeInRange(e,255,t)},a.octDecodeInRange=function(e,a,o,u){if(!r(u))throw new n("result is required.");if(e<0||e>o||a<0||a>o)throw new n("x and y must be a signed normalized integer between 0 and "+o);if(u.x=i.fromSNorm(e,o),u.y=i.fromSNorm(a,o),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*i.signNotZero(s),u.y=(1-Math.abs(s))*i.signNotZero(u.y)}return t.normalize(u,u)},a.octDecode=function(e,t,r){return a.octDecodeInRange(e,t,255,r)},a.octPackFloat=function(e){if(!r(e))throw new n("encoded is required.");return 256*e.x+e.y};var o=new e;return a.octEncodeFloat=function(e){return a.octEncode(e,o),a.octPackFloat(o)},a.octDecodeFloat=function(e,t){if(!r(e))throw new n("value is required.");var i=e/256,o=Math.floor(i),u=256*(i-o);return a.octDecode(o,u,t)},a.octPack=function(e,t,i,u){if(!r(e))throw new n("v1 is required.");if(!r(t))throw new n("v2 is required.");if(!r(i))throw new n("v3 is required.");if(!r(u))throw new n("result is required.");var s=a.octEncodeFloat(e),c=a.octEncodeFloat(t),f=a.octEncode(i,o);return u.x=65536*f.x+s,u.y=65536*f.y+c,u},a.octUnpack=function(e,t,i,o){if(!r(e))throw new n("packed is required.");if(!r(t))throw new n("v1 is required.");if(!r(i))throw new n("v2 is required.");if(!r(o))throw new n("v3 is required.");var u=e.x/65536,s=Math.floor(u),c=65536*(u-s);u=e.y/65536;var f=Math.floor(u),l=65536*(u-f);a.octDecodeFloat(c,t),a.octDecodeFloat(l,i),a.octDecode(s,f,o)},a.compressTextureCoordinates=function(e){if(!r(e))throw new n("textureCoordinates is required.");var t=4095*e.x|0,i=4095*e.y|0;return 4096*t+i},a.decompressTextureCoordinates=function(e,t){if(!r(e))throw new n("compressed is required.");if(!r(t))throw new n("result is required.");var i=e/4096,a=Math.floor(i);return t.x=a/4095,t.y=(e-4096*a)/4095,t},a}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(i,s,c,f,l){if(!(r(i)&&r(s)&&r(c)&&r(f)))throw new n("point, p0, p1, and p2 are required.");r(l)||(l=new t);var p,h,d,y,E,m,T,O;r(s.z)?(p=t.subtract(c,s,a),h=t.subtract(f,s,o),d=t.subtract(i,s,u),y=t.dot(p,p),E=t.dot(p,h),m=t.dot(p,d),T=t.dot(h,h),O=t.dot(h,d)):(p=e.subtract(c,s,a),h=e.subtract(f,s,o),d=e.subtract(i,s,u),y=e.dot(p,p),E=e.dot(p,h),m=e.dot(p,d),T=e.dot(h,h),O=e.dot(h,d));var _=1/(y*T-E*E);return l.y=(T*m-E*O)*_,l.z=(y*O-E*m)*_,l.x=1-l.y-l.z,l}var a=new t,o=new t,u=new t;return i}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,n){if(!t(e))throw new r("value is required");t(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){if(!t(e))throw new r("cartesian is required");t(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,i,o){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("cartesianArray is required");if("number"!=typeof o||o<0)throw new r("index must be a number greater than or equal to 0.");n.fromCartesian(e,a);var u=a.high,s=a.low;i[o]=u.x,i[o+1]=u.y,i[o+2]=u.z,i[o+3]=s.x,i[o+4]=s.y,i[o+5]=s.z},n}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(r,i){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},a.createTypedArrayFromArrayBuffer=function(r,i,a,o){if(!e(r))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(a))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,a,o):new Uint16Array(i,a,o)},r(a)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.computeRealRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(u<s&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if(o=-a/n,o<0)return[];var c=Math.sqrt(o);return[-c,c]}if(0===a)return o=-i/n,o<0?[o,0]:[0,o];var f=i*i,l=4*n*a,p=r(f,-l,t.EPSILON14);if(p<0)return[];var h=-.5*r(i,t.sign(i)*Math.sqrt(p),t.EPSILON14);return i>0?[h/n,a/h]:[a/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,a,o=e,u=t/3,s=r/3,c=n,f=o*s,l=u*c,p=u*u,h=s*s,d=o*s-p,y=o*c-u*s,E=u*c-h,m=4*d*E-y*y;if(m<0){var T,O,_;p*l>=f*h?(T=o,O=d,_=-2*u*d+o*y):(T=c,O=E,_=-c*y+2*s*E);var R=_<0?-1:1,w=-R*Math.abs(T)*Math.sqrt(-m);a=-_+w;var b=a/2,v=b<0?-Math.pow(-b,1/3):Math.pow(b,1/3),A=a===w?-v:-O/v;return i=O<=0?v+A:-_/(v*v+A*A+O),p*l>=f*h?[(i-u)/o]:[-c/(i+s)]}var g=d,N=-2*u*d+o*y,S=E,I=-c*y+2*s*E,M=Math.sqrt(m),x=Math.sqrt(3)/2,C=Math.abs(Math.atan2(o*M,-N)/3);i=2*Math.sqrt(-g);var P=Math.cos(C);a=i*P;var L=i*(-P/2-x*Math.sin(C)),U=a+L>2*u?a-u:L-u,D=o,F=U/D;C=Math.abs(Math.atan2(c*M,-I)/3),i=2*Math.sqrt(-S),P=Math.cos(C),a=i*P,L=i*(-P/2-x*Math.sin(C));var B=-c,q=a+L<2*s?a+s:L+s,z=B/q,j=D*q,G=-U*q-D*B,V=U*B,X=(s*G-u*V)/(-u*G+s*j);return F<=X?F<=z?X<=z?[F,X,z]:[F,z,X]:[z,F,X]:F<=z?[X,F,z]:X<=z?[X,z,F]:[z,X,F]}var n={};return n.computeDiscriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=t*t,o=r*r,u=n*n,s=i*i,c=18*t*r*n*i+o*u-27*a*s-4*(t*u*n+o*r*i);return c},n.computeRealRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return t.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var c=s<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===o?(u=t.computeRealRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):r(n,0,a,o)}return 0===a?0===o?(s=-i/n,s<0?[s,0,0]:[0,0,s]):r(n,i,0,o):0===o?(u=t.computeRealRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):r(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,f=o-a*t/4+i*u/16-3*u*u/256,l=e.computeRealRoots(1,2*s,s*s-4*f,-c*c);if(l.length>0){var p=-t/4,h=l[l.length-1];if(Math.abs(h)<r.EPSILON14){var d=n.computeRealRoots(1,s,f);if(2===d.length){var y,E=d[0],m=d[1];if(E>=0&&m>=0){var T=Math.sqrt(E),O=Math.sqrt(m);return[p-O,p-T,p+T,p+O]}if(E>=0&&m<0)return y=Math.sqrt(E),[p-y,p+y];if(E<0&&m>=0)return y=Math.sqrt(m),[p-y,p+y]}return[]}if(h>0){var _=Math.sqrt(h),R=(s+h-c/_)/2,w=(s+h+c/_)/2,b=n.computeRealRoots(1,_,R),v=n.computeRealRoots(1,-_,w);return 0!==b.length?(b[0]+=p,b[1]+=p,0!==v.length?(v[0]+=p,v[1]+=p,b[1]<=v[0]?[b[0],b[1],v[0],v[1]]:v[1]<=b[0]?[v[0],v[1],b[0],b[1]]:b[0]>=v[0]&&b[1]<=v[1]?[v[0],b[0],b[1],v[1]]:v[0]>=b[0]&&v[1]<=b[1]?[b[0],v[0],v[1],b[1]]:b[0]>v[0]&&b[0]<v[1]?[v[0],b[0],v[1],b[1]]:[b[0],v[0],b[1],v[1]]):b):0!==v.length?(v[0]+=p,v[1]+=p,v):[]}}return[]}function a(t,i,a,o){var u=a*a,s=i*i,c=t*t,f=-2*i,l=a*t+s-4*o,p=c*o-a*i*t+u,h=e.computeRealRoots(1,f,l,p);if(h.length>0){var d,y,E=h[0],m=i-E,T=m*m,O=t/2,_=m/2,R=T-4*o,w=T+4*Math.abs(o),b=c-4*E,v=c+4*Math.abs(E);if(E<0||R*v<b*w){var A=Math.sqrt(b);d=A/2,y=0===A?0:(t*_-a)/A}else{var g=Math.sqrt(R);d=0===g?0:(t*_-a)/g,y=g/2}var N,S;0===O&&0===d?(N=0,S=0):r.sign(O)===r.sign(d)?(N=O+d,S=E/N):(S=O-d,N=E/S);var I,M;0===_&&0===y?(I=0,M=0):r.sign(_)===r.sign(y)?(I=_+y,M=o/I):(M=_-y,I=o/M);var x=n.computeRealRoots(1,N,I),C=n.computeRealRoots(1,S,M);if(0!==x.length)return 0!==C.length?x[1]<=C[0]?[x[0],x[1],C[0],C[1]]:C[1]<=x[0]?[C[0],C[1],x[0],x[1]]:x[0]>=C[0]&&x[1]<=C[1]?[C[0],x[0],x[1],C[1]]:C[0]>=x[0]&&C[1]<=x[1]?[x[0],C[0],C[1],x[1]]:x[0]>C[0]&&x[0]<C[1]?[C[0],x[0],C[1],x[1]]:[x[0],C[0],x[1],C[1]]:x;if(0!==C.length)return C}return[]}var o={};return o.computeDiscriminant=function(e,r,n,i,a){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof a)throw new t("e is a required number.");var o=e*e,u=o*e,s=r*r,c=s*r,f=n*n,l=f*n,p=i*i,h=p*i,d=a*a,y=d*a,E=s*f*p-4*c*h-4*e*l*p+18*e*r*n*h-27*o*p*p+256*u*y+a*(18*c*n*i-4*s*l+16*e*f*f-80*e*r*f*i-6*e*s*p+144*o*n*p)+d*(144*e*s*n-27*s*s-128*o*f-192*o*r*i);return E},o.computeRealRoots=function(n,o,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof o)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(o,u,s,c);var f=o/n,l=u/n,p=s/n,h=c/n,d=f<0?1:0;switch(d+=l<0?d+1:d,d+=p<0?d+1:d,d+=h<0?d+1:d){case 0:return i(f,l,p,h);case 1:return a(f,l,p,h);case 2:return a(f,l,p,h);case 3:return i(f,l,p,h);case 4:return i(f,l,p,h);case 5:return a(f,l,p,h);case 6:return i(f,l,p,h);case 7:return i(f,l,p,h);case 8:return a(f,l,p,h);case 9:return i(f,l,p,h);case 10:return i(f,l,p,h);case 11:return a(f,l,p,h);case 12:return i(f,l,p,h);case 13:return i(f,l,p,h);case 14:return i(f,l,p,h);case 15:return i(f,l,p,h);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n}return i.getPoint=function(t,i,a){if(!r(t))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,i,a),e.add(t.origin,a,a)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,i,a,o,u,s,c,f){"use strict";function l(e,t,r,n){var i=t*t-4*e*r;if(!(i<0)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function p(t,r,i){n(i)||(i=new a);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,f=e.subtract(o,s,T),p=e.dot(u,u),h=2*e.dot(u,f),d=e.magnitudeSquared(f)-c,y=l(p,h,d,w);if(n(y))return i.start=y.root0,i.stop=y.root1,i}function h(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function d(t,r,n,i,a){var f,l=i*i,p=a*a,d=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*p,y=a*(i*h(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),E=t[u.COLUMN0ROW0]*l+t[u.COLUMN2ROW2]*p+i*r.x+n,m=p*h(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),T=a*(i*h(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),O=[];if(0===T&&0===m){if(f=s.computeRealRoots(d,y,E),0===f.length)return O;var _=f[0],R=Math.sqrt(Math.max(1-_*_,0));if(O.push(new e(i,a*_,a*-R)),O.push(new e(i,a*_,a*R)),2===f.length){var w=f[1],b=Math.sqrt(Math.max(1-w*w,0));O.push(new e(i,a*w,a*-b)),O.push(new e(i,a*w,a*b))}return O}var v=T*T,A=m*m,g=d*d,N=T*m,S=g+A,I=2*(y*d+N),M=2*E*d+y*y-A+v,x=2*(E*y-N),C=E*E-v;if(0===S&&0===I&&0===M&&0===x)return O;f=c.computeRealRoots(S,I,M,x,C);var P=f.length;if(0===P)return O;for(var L=0;L<P;++L){var U,D=f[L],F=D*D,B=Math.max(1-F,0),q=Math.sqrt(B);U=o.sign(d)===o.sign(E)?h(d*F+E,y*D,o.EPSILON12):o.sign(E)===o.sign(y*D)?h(d*F,y*D+E,o.EPSILON12):h(d*F+y*D,E,o.EPSILON12);var z=h(m*D,T,o.EPSILON15),j=U*z;j<0?O.push(new e(i,a*D,a*q)):j>0?O.push(new e(i,a*D,a*-q)):0!==q?(O.push(new e(i,a*D,a*-q)),O.push(new e(i,a*D,a*q)),++L):O.push(new e(i,a*D,a*q))}return O}var y={};y.rayPlane=function(t,r,a){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("plane is required.");n(a)||(a=new e);var u=t.origin,s=t.direction,c=r.normal,f=e.dot(c,s);if(!(Math.abs(f)<o.EPSILON15)){var l=(-r.distance-e.dot(c,u))/f;if(!(l<0))return a=e.multiplyByScalar(s,l,a),e.add(u,a,a)}};var E=new e,m=new e,T=new e,O=new e,_=new e;y.rayTriangleParametric=function(t,a,u,s,c){if(!n(t))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=r(c,!1);var f,l,p,h,d,y=t.origin,R=t.direction,w=e.subtract(u,a,E),b=e.subtract(s,a,m),v=e.cross(R,b,T),A=e.dot(w,v);if(c){if(A<o.EPSILON6)return;if(f=e.subtract(y,a,O),p=e.dot(f,v),p<0||p>A)return;if(l=e.cross(f,w,_),h=e.dot(R,l),h<0||p+h>A)return;d=e.dot(b,l)/A}else{if(Math.abs(A)<o.EPSILON6)return;var g=1/A;if(f=e.subtract(y,a,O),p=e.dot(f,v)*g,p<0||p>1)return;if(l=e.cross(f,w,_),h=e.dot(R,l)*g,h<0||p+h>1)return;d=e.dot(b,l)*g}return d},y.rayTriangle=function(t,r,i,a,o,u){var s=y.rayTriangleParametric(t,r,i,a,o);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var R=new f;y.lineSegmentTriangle=function(t,r,a,o,u,s,c){if(!n(t))throw new i("v0 is required.");if(!n(r))throw new i("v1 is required.");if(!n(a))throw new i("p0 is required.");if(!n(o))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");var f=R;e.clone(t,f.origin),e.subtract(r,t,f.direction),e.normalize(f.direction,f.direction);var l=y.rayTriangleParametric(f,a,o,u,s);if(!(!n(l)||l<0||l>e.distance(t,r)))return n(c)||(c=new e),e.multiplyByScalar(f.direction,l,c),e.add(f.origin,c,c)};var w={root0:0,root1:0};y.raySphere=function(e,t,r){if(!n(e))throw new i("ray is required.");if(!n(t))throw new i("sphere is required.");if(r=p(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var b=new f;y.lineSegmentSphere=function(t,r,a,o){if(!n(t))throw new i("p0 is required.");if(!n(r))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=b;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);if(e.normalize(s,s),o=p(u,a,o),!(!n(o)||o.stop<0||o.start>c))return o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,c),o};var v=new e,A=new e;y.rayEllipsoid=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var o,u,s,c,f,l=r.oneOverRadii,p=e.multiplyComponents(l,t.origin,v),h=e.multiplyComponents(l,t.direction,A),d=e.magnitudeSquared(p),y=e.dot(p,h);if(d>1){if(y>=0)return;var E=y*y;if(o=d-1,u=e.magnitudeSquared(h),s=u*o,E<s)return;if(E>s){c=y*y-s,f=-y+Math.sqrt(c);var m=f/u,T=o/f;return m<T?new a(m,T):{start:T,stop:m}}var O=Math.sqrt(o/u);return new a(O,O)}return d<1?(o=d-1,u=e.magnitudeSquared(h),s=u*o,c=y*y-s,f=-y+Math.sqrt(c),new a(0,f/u)):y<0?(u=e.magnitudeSquared(h),new a(0,-y/u)):void 0};var g=new e,N=new e,S=new e,I=new e,M=new e,x=new u,C=new u,P=new u,L=new u,U=new u,D=new u,F=new u,B=new e,q=new e,z=new t;y.grazingAltitudeLocation=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var a=t.origin,s=t.direction;if(!e.equals(a,e.ZERO)){var c=r.geodeticSurfaceNormal(a,g);if(e.dot(s,c)>=0)return a}var f=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(s,g),p=e.normalize(l,l),h=e.mostOrthogonalAxis(l,I),y=e.normalize(e.cross(h,p,N),N),E=e.normalize(e.cross(p,y,S),S),m=x;m[0]=p.x,m[1]=p.y,m[2]=p.z,m[3]=y.x,m[4]=y.y,m[5]=y.z,m[6]=E.x,m[7]=E.y,m[8]=E.z;var T=u.transpose(m,C),O=u.fromScale(r.radii,P),_=u.fromScale(r.oneOverRadii,L),R=U;R[0]=0,R[1]=-s.z,R[2]=s.y,R[3]=s.z,R[4]=0,R[5]=-s.x,R[6]=-s.y,R[7]=s.x,R[8]=0;var w,b,v=u.multiply(u.multiply(T,_,D),R,D),A=u.multiply(u.multiply(v,O,F),m,F),j=u.multiplyByVector(v,a,M),G=d(A,e.negate(j,g),0,0,1),V=G.length;if(V>0){for(var X=e.clone(e.ZERO,q),H=Number.NEGATIVE_INFINITY,W=0;W<V;++W){w=u.multiplyByVector(O,u.multiplyByVector(m,G[W],B),B);var k=e.normalize(e.subtract(w,a,I),I),Y=e.dot(k,s);Y>H&&(H=Y,X=e.clone(w,X))}var Z=r.cartesianToCartographic(X,z);return H=o.clamp(H,0,1),b=e.magnitude(e.subtract(X,a,I))*Math.sqrt(1-H*H),b=f?-b:b,Z.height=b,r.cartographicToCartesian(Z,new e)}};var j=new e;return y.lineSegmentPlane=function(t,r,a,u){if(!n(t))throw new i("endPoint0 is required.");if(!n(r))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,j),c=a.normal,f=e.dot(c,s);if(!(Math.abs(f)<o.EPSILON6)){var l=e.dot(c,t),p=-(a.distance+l)/f;if(!(p<0||p>1))return e.multiplyByScalar(s,p,u),e.add(t,u,u),u}},y.trianglePlaneIntersection=function(t,r,a,o){if(!(n(t)&&n(r)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,c=e.dot(u,t)+s<0,f=e.dot(u,r)+s<0,l=e.dot(u,a)+s<0,p=0;p+=c?1:0,p+=f?1:0,p+=l?1:0;var h,d;if(1!==p&&2!==p||(h=new e,d=new e),1===p){if(c)return y.lineSegmentPlane(t,r,o,h),y.lineSegmentPlane(t,a,o,d),{positions:[t,r,a,h,d],indices:[0,3,4,1,2,4,1,4,3]};if(f)return y.lineSegmentPlane(r,a,o,h),y.lineSegmentPlane(r,t,o,d),{positions:[t,r,a,h,d],indices:[1,3,4,2,0,4,2,4,3]};if(l)return y.lineSegmentPlane(a,t,o,h),y.lineSegmentPlane(a,r,o,d),{positions:[t,r,a,h,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===p){if(!c)return y.lineSegmentPlane(r,t,o,h),y.lineSegmentPlane(a,t,o,d),{positions:[t,r,a,h,d],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return y.lineSegmentPlane(a,r,o,h),y.lineSegmentPlane(t,r,o,d),{positions:[t,r,a,h,d],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return y.lineSegmentPlane(t,a,o,h),y.lineSegmentPlane(r,a,o,d),{positions:[t,r,a,h,d],indices:[0,1,4,0,4,3,2,3,4]}}},y}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function i(n,i){if(!t(n))throw new r("normal is required.");if(!t(i))throw new r("distance is required.");this.normal=e.clone(n),this.distance=i}i.fromPointNormal=function(n,a,o){if(!t(n))throw new r("point is required.");if(!t(a))throw new r("normal is required.");var u=-e.dot(a,n);return t(o)?(e.clone(a,o.normal),o.distance=u,o):new i(a,u)};var a=new e;return i.fromCartesian4=function(n,o){if(!t(n))throw new r("coefficients is required.");var u=e.fromCartesian4(n,a),s=n.w;return t(o)?(e.clone(u,o.normal),o.distance=s,o):new i(u,s)},i.getPointDistance=function(n,i){if(!t(n))throw new r("plane is required.");if(!t(i))throw new r("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var u=i.length;if(u<3||u%3!==0)throw new r("indices length must be a multiple of three.");if(a<=0)throw new r("maximumIndex must be greater than zero.");if(o<3)throw new r("cacheSize must be greater than two.");if(!t(a)){a=0;for(var s=0,c=i[s];s<u;)c>a&&(a=c),++s,c=i[s]}for(var f=[],l=0;l<a+1;l++)f[l]=0;for(var p=o+1,h=0;h<u;++h)p-f[i[h]]>o&&(f[i[h]]=p,++p);return(p-o+1)/(u/3)},n.tipsify=function(n){function i(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;o<n;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function a(e,t,r,n,a,o,u){for(var s,c=-1,f=-1,l=0;l<r.length;){var p=r[l];n[p].numLiveTriangles&&(s=0,a-n[p].timeStamp+2*n[p].numLiveTriangles<=t&&(s=a-n[p].timeStamp),(s>f||f===-1)&&(f=s,c=p)),++l}return c===-1?i(n,o,e,u):c}n=e(n,e.EMPTY_OBJECT);var o,u=n.indices,s=n.maximumIndex,c=e(n.cacheSize,24);if(!t(u))throw new r("indices is required.");var f=u.length;if(f<3||f%3!==0)throw new r("indices length must be a multiple of three.");if(s<=0)throw new r("maximumIndex must be greater than zero.");if(c<3)throw new r("cacheSize must be greater than two.");var l=0,p=0,h=u[p],d=f;if(t(s))l=s+1;else{for(;p<d;)h>l&&(l=h),++p,h=u[p];if(l===-1)return 0;++l}for(var y=[],E=0;E<l;E++)y[E]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};p=0;for(var m=0;p<d;)y[u[p]].vertexTriangles.push(m),++y[u[p]].numLiveTriangles,y[u[p+1]].vertexTriangles.push(m),++y[u[p+1]].numLiveTriangles,y[u[p+2]].vertexTriangles.push(m),++y[u[p+2]].numLiveTriangles,++m,p+=3;var T=0,O=c+1;o=1;var _,R,w=[],b=[],v=0,A=[],g=f/3,N=[];for(E=0;E<g;E++)N[E]=!1;for(var S,I;T!==-1;){w=[],R=y[T],I=R.vertexTriangles.length;for(var M=0;M<I;++M)if(m=R.vertexTriangles[M],!N[m]){N[m]=!0,p=m+m+m;for(var x=0;x<3;++x)S=u[p],w.push(S),b.push(S),A[v]=S,++v,_=y[S],--_.numLiveTriangles,O-_.timeStamp>c&&(_.timeStamp=O,++O),++p}T=a(u,c,w,y,O,b,l)}return A},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,i,a,o,u,s,c,f,l,p,h,d,y,E,m,T,O,_,R,w,b,v){"use strict";function A(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function g(e){for(var t=e.length,r=t/3*6,n=E.createTypedArray(t,r),i=0,a=0;a<t;a+=3,i+=6)A(n,i,e[a],e[a+1],e[a+2]);return n}function N(e){var t=e.length;if(t>=3){var r=6*(t-2),n=E.createTypedArray(t,r);A(n,0,e[0],e[1],e[2]);for(var i=6,a=3;a<t;++a,i+=6)A(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function S(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=E.createTypedArray(t,r),i=e[0],a=0,o=1;o<t;++o,a+=6)A(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function I(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new d({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function M(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var i=t[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[r*i.componentsPerAttribute+a])}function x(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;a<n;a+=3)i.unpack(r,a,ae),R.multiplyByPoint(e,ae,ae),i.pack(ae,r,a)}function C(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;a<n;a+=3)i.unpack(r,a,ae),_.multiplyByVector(e,ae,ae),ae=i.normalize(ae,ae),i.pack(ae,r,a)}function P(e,t){var r,n=e.length,i={},a=e[0][t].attributes;for(r in a)if(a.hasOwnProperty(r)&&c(a[r])&&c(a[r].values)){for(var o=a[r],s=o.values.length,f=!0,l=1;l<n;++l){var p=e[l][t].attributes[r];if(!c(p)||o.componentDatatype!==p.componentDatatype||o.componentsPerAttribute!==p.componentsPerAttribute||o.normalize!==p.normalize){f=!1;break}s+=p.values.length}f&&(i[r]=new d({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return i}function L(e,t){var n,a,o,u,s=e.length,l=e[0].modelMatrix,p=c(e[0][t].indices),d=e[0][t].primitiveType;
for(a=1;a<s;++a){if(!R.equals(e[a].modelMatrix,l))throw new f("All instances must have the same modelMatrix.");if(c(e[a][t].indices)!==p)throw new f("All instance geometries must have an indices or not have one.");if(e[a][t].primitiveType!==d)throw new f("All instance geometries must have the same primitiveType.")}var y,m,T,O=P(e,t);for(n in O)if(O.hasOwnProperty(n))for(y=O[n].values,u=0,a=0;a<s;++a)for(m=e[a][t].attributes[n].values,T=m.length,o=0;o<T;++o)y[u++]=m[o];var _;if(p){var w=0;for(a=0;a<s;++a)w+=e[a][t].indices.length;var v=h.computeNumberOfVertices(new h({attributes:O,primitiveType:b.POINTS})),A=E.createTypedArray(v,w),g=0,N=0;for(a=0;a<s;++a){var S=e[a][t].indices,I=S.length;for(u=0;u<I;++u)A[g++]=N+S[u];N+=h.computeNumberOfVertices(e[a][t])}_=A}var M,x=new i,C=0;for(a=0;a<s;++a){if(M=e[a][t].boundingSphere,!c(M)){x=void 0;break}i.add(M.center,x,x)}if(c(x))for(i.divideByScalar(x,s,x),a=0;a<s;++a){M=e[a][t].boundingSphere;var L=i.magnitude(i.subtract(M.center,x,se))+M.radius;L>C&&(C=L)}return new h({attributes:O,indices:_,primitiveType:d,boundingSphere:c(x)?new r(x,C):void 0})}function U(e){if(c(e.indices))return e;var t=h.computeNumberOfVertices(e);if(t<3)throw new f("The number of vertices must be at least three.");if(t%3!==0)throw new f("The number of vertices must be a multiple of three.");for(var r=E.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}function D(e){var t=h.computeNumberOfVertices(e);if(t<3)throw new f("The number of vertices must be at least three.");var r=E.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,i=3;i<t;++i)r[n++]=i-1,r[n++]=0,r[n++]=i;return e.indices=r,e.primitiveType=b.TRIANGLES,e}function F(e){var t=h.computeNumberOfVertices(e);if(t<3)throw new f("The number of vertices must be at least 3.");var r=E.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,i=3;i<t-1;i+=2)r[n++]=i,r[n++]=i-1,r[n++]=i+1,i+2<t&&(r[n++]=i,r[n++]=i+1,r[n++]=i+2);return e.indices=r,e.primitiveType=b.TRIANGLES,e}function B(e){if(c(e.indices))return e;var t=h.computeNumberOfVertices(e);if(t<2)throw new f("The number of vertices must be at least two.");if(t%2!==0)throw new f("The number of vertices must be a multiple of 2.");for(var r=E.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}function q(e){var t=h.computeNumberOfVertices(e);if(t<2)throw new f("The number of vertices must be at least two.");var r=E.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return e.indices=r,e.primitiveType=b.LINES,e}function z(e){var t=h.computeNumberOfVertices(e);if(t<2)throw new f("The number of vertices must be at least two.");var r=E.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=b.LINES,e}function j(e){switch(e.primitiveType){case b.TRIANGLE_FAN:return D(e);case b.TRIANGLE_STRIP:return F(e);case b.TRIANGLES:return U(e);case b.LINE_STRIP:return q(e);case b.LINE_LOOP:return z(e);case b.LINES:return B(e)}return e}function G(e,t){Math.abs(e.y)<O.EPSILON6&&(t?e.y=-O.EPSILON6:e.y=O.EPSILON6)}function V(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return G(e,e.y<0),G(t,t.y<0),void G(r,r.y<0);var n,i=Math.abs(e.y),a=Math.abs(t.y),o=Math.abs(r.y);n=i>a?i>o?O.sign(e.y):O.sign(r.y):a>o?O.sign(t.y):O.sign(r.y);var u=n<0;G(e,u),G(t,u),G(r,u)}function X(e,t,r,n){i.add(e,i.multiplyByScalar(i.subtract(t,e,Re),e.y/(e.y-t.y),Re),r),i.clone(r,n),G(r,!0),G(n,!1)}function H(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){V(e,t,r);var n=e.y<0,i=t.y<0,a=r.y<0,o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var u=ge.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(X(e,t,we,ve),X(e,r,be,Ae),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(X(t,r,we,ve),X(t,e,be,Ae),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(X(r,e,we,ve),X(r,t,be,Ae),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(X(r,e,we,ve),X(r,t,be,Ae),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(X(t,r,we,ve),X(t,e,be,Ae),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(X(e,t,we,ve),X(e,r,be,Ae),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=ge.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,1!==o&&2!==o||(s[3]=we,s[4]=be,s[5]=ve,s[6]=Ae,s.length=7),ge}}function W(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var i in n)if(n.hasOwnProperty(i)&&c(n[i])&&c(n[i].values)){var a=n[i];a.values=u.createTypedArray(a.componentDatatype,a.values)}var o=h.computeNumberOfVertices(e);return e.indices=E.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function k(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var i=t[n];r[n]=new d({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new h({attributes:r,indices:[],primitiveType:e.primitiveType})}function Y(e,t,r){var n=c(e.geometry.boundingSphere);t=W(t,n),r=W(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function Z(e,r,a,o,u,s,f,l,p,h,d,y){if(c(s)||c(f)||c(l)||c(p)||c(h)){var E=i.fromArray(u,3*e,Ne),m=i.fromArray(u,3*r,Se),T=i.fromArray(u,3*a,Ie),O=t(o,E,m,T,Me);if(c(s)){var _=i.fromArray(s,3*e,Ne),R=i.fromArray(s,3*r,Se),w=i.fromArray(s,3*a,Ie);i.multiplyByScalar(_,O.x,_),i.multiplyByScalar(R,O.y,R),i.multiplyByScalar(w,O.z,w);var b=i.add(_,R,_);i.add(b,w,b),i.normalize(b,b),i.pack(b,d.normal.values,3*y)}if(c(h)){var v=i.fromArray(h,3*e,Ne),A=i.fromArray(h,3*r,Se),g=i.fromArray(h,3*a,Ie);i.multiplyByScalar(v,O.x,v),i.multiplyByScalar(A,O.y,A),i.multiplyByScalar(g,O.z,g);var N;i.equals(v,i.ZERO)&&i.equals(A,i.ZERO)&&i.equals(g,i.ZERO)?(N=Ne,N.x=0,N.y=0,N.z=0):(N=i.add(v,A,v),i.add(N,g,N),i.normalize(N,N)),i.pack(N,d.extrudeDirection.values,3*y)}if(c(f)){var S=i.fromArray(f,3*e,Ne),I=i.fromArray(f,3*r,Se),M=i.fromArray(f,3*a,Ie);i.multiplyByScalar(S,O.x,S),i.multiplyByScalar(I,O.y,I),i.multiplyByScalar(M,O.z,M);var x=i.add(S,I,S);i.add(x,M,x),i.normalize(x,x),i.pack(x,d.tangent.values,3*y)}if(c(l)){var C=i.fromArray(l,3*e,Ne),P=i.fromArray(l,3*r,Se),L=i.fromArray(l,3*a,Ie);i.multiplyByScalar(C,O.x,C),i.multiplyByScalar(P,O.y,P),i.multiplyByScalar(L,O.z,L);var U=i.add(C,P,C);i.add(U,L,U),i.normalize(U,U),i.pack(U,d.bitangent.values,3*y)}if(c(p)){var D=n.fromArray(p,2*e,xe),F=n.fromArray(p,2*r,Ce),B=n.fromArray(p,2*a,Pe);n.multiplyByScalar(D,O.x,D),n.multiplyByScalar(F,O.y,F),n.multiplyByScalar(B,O.z,B);var q=n.add(D,F,D);n.add(q,B,q),n.pack(q,d.st.values,2*y)}}}function K(e,t,r,n,i,a){var o=e.position.values.length/3;if(i!==-1){var u=n[i],s=r[u];return s===-1?(r[u]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(a.x,a.y,a.z),t.push(o),o}function Q(e){var t,r,n,a,o,u=e.geometry,s=u.attributes,f=s.position.values,l=c(s.normal)?s.normal.values:void 0,p=c(s.bitangent)?s.bitangent.values:void 0,h=c(s.tangent)?s.tangent.values:void 0,d=c(s.st)?s.st.values:void 0,y=c(s.extrudeDirection)?s.extrudeDirection.values:void 0,E=u.indices,m=k(u),T=k(u),O=[];O.length=f.length/3;var _=[];for(_.length=f.length/3,o=0;o<O.length;++o)O[o]=-1,_[o]=-1;var R=E.length;for(o=0;o<R;o+=3){var w=E[o],b=E[o+1],v=E[o+2],A=i.fromArray(f,3*w),g=i.fromArray(f,3*b),N=i.fromArray(f,3*v),S=H(A,g,N);if(c(S)&&S.positions.length>3)for(var I=S.positions,M=S.indices,x=M.length,C=0;C<x;++C){var P=M[C],L=I[P];L.y<0?(t=T.attributes,r=T.indices,n=O):(t=m.attributes,r=m.indices,n=_),a=K(t,r,n,E,P<3?o+P:-1,L),Z(w,b,v,L,f,l,h,p,d,y,t,a)}else c(S)&&(A=S.positions[0],g=S.positions[1],N=S.positions[2]),A.y<0?(t=T.attributes,r=T.indices,n=O):(t=m.attributes,r=m.indices,n=_),a=K(t,r,n,E,o,A),Z(w,b,v,A,f,l,h,p,d,y,t,a),a=K(t,r,n,E,o+1,g),Z(w,b,v,g,f,l,h,p,d,y,t,a),a=K(t,r,n,E,o+2,N),Z(w,b,v,N,f,l,h,p,d,y,t,a)}Y(e,T,m)}function J(e){var t,r=e.geometry,n=r.attributes,a=n.position.values,o=r.indices,u=k(r),s=k(r),f=o.length,l=[];l.length=a.length/3;var p=[];for(p.length=a.length/3,t=0;t<l.length;++t)l[t]=-1,p[t]=-1;for(t=0;t<f;t+=2){var h=o[t],d=o[t+1],y=i.fromArray(a,3*h,Ne),E=i.fromArray(a,3*d,Se);Math.abs(y.y)<O.EPSILON6&&(y.y<0?y.y=-O.EPSILON6:y.y=O.EPSILON6),Math.abs(E.y)<O.EPSILON6&&(E.y<0?E.y=-O.EPSILON6:E.y=O.EPSILON6);var m=u.attributes,_=u.indices,R=p,w=s.attributes,b=s.indices,v=l,A=T.lineSegmentPlane(y,E,Le,Ie);if(c(A)){var g=i.multiplyByScalar(i.UNIT_Y,5*O.EPSILON9,Ue);y.y<0&&(i.negate(g,g),m=s.attributes,_=s.indices,R=l,w=u.attributes,b=u.indices,v=p);var N=i.add(A,g,De);K(m,_,R,o,t,y),K(m,_,R,o,-1,N),i.negate(g,g),i.add(A,g,N),K(w,b,v,o,-1,N),K(w,b,v,o,t+1,E)}else{var S,I,M;y.y<0?(S=s.attributes,I=s.indices,M=l):(S=u.attributes,I=u.indices,M=p),K(S,I,M,o,t,y),K(S,I,M,o,t+1,E)}}Y(e,s,u)}function $(e){for(var t=e.attributes,r=t.position.values,n=t.prevPosition.values,a=t.nextPosition.values,o=r.length,u=0;u<o;u+=3){var s=i.unpack(r,u,qe);if(!(s.x>0)){var c=i.unpack(n,u,ze);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(u-3>0?(n[u]=r[u-3],n[u+1]=r[u-2],n[u+2]=r[u-1]):i.pack(s,n,u));var f=i.unpack(a,u,je);(s.y<0&&f.y>0||s.y>0&&f.y<0)&&(u+3<o?(a[u]=r[u+3],a[u+1]=r[u+4],a[u+2]=r[u+5]):i.pack(s,a,u))}}}function ee(e){var t,r,o,u=e.geometry,s=u.attributes,f=s.position.values,l=s.prevPosition.values,p=s.nextPosition.values,h=s.expandAndWidth.values,d=c(s.st)?s.st.values:void 0,y=c(s.color)?s.color.values:void 0,E=k(u),m=k(u),_=!1,R=f.length/3;for(t=0;t<R;t+=4){var w=t,b=t+2,v=i.fromArray(f,3*w,qe),A=i.fromArray(f,3*b,ze);if(Math.abs(v.y)<ke)for(v.y=ke*(A.y<0?-1:1),f[3*t+1]=v.y,f[3*(t+1)+1]=v.y,r=3*w;r<3*w+12;r+=3)l[r]=f[3*t],l[r+1]=f[3*t+1],l[r+2]=f[3*t+2];if(Math.abs(A.y)<ke)for(A.y=ke*(v.y<0?-1:1),f[3*(t+2)+1]=A.y,f[3*(t+3)+1]=A.y,r=3*w;r<3*w+12;r+=3)p[r]=f[3*(t+2)],p[r+1]=f[3*(t+2)+1],p[r+2]=f[3*(t+2)+2];var g=E.attributes,N=E.indices,S=m.attributes,I=m.indices,M=T.lineSegmentPlane(v,A,Le,Ge);if(c(M)){_=!0;var x=i.multiplyByScalar(i.UNIT_Y,We,Ve);v.y<0&&(i.negate(x,x),g=m.attributes,N=m.indices,S=E.attributes,I=E.indices);var C=i.add(M,x,Xe);g.position.values.push(v.x,v.y,v.z,v.x,v.y,v.z),g.position.values.push(C.x,C.y,C.z),g.position.values.push(C.x,C.y,C.z),g.prevPosition.values.push(l[3*w],l[3*w+1],l[3*w+2]),g.prevPosition.values.push(l[3*w+3],l[3*w+4],l[3*w+5]),g.prevPosition.values.push(v.x,v.y,v.z,v.x,v.y,v.z),g.nextPosition.values.push(C.x,C.y,C.z),g.nextPosition.values.push(C.x,C.y,C.z),g.nextPosition.values.push(C.x,C.y,C.z),g.nextPosition.values.push(C.x,C.y,C.z),i.negate(x,x),i.add(M,x,C),S.position.values.push(C.x,C.y,C.z),S.position.values.push(C.x,C.y,C.z),S.position.values.push(A.x,A.y,A.z,A.x,A.y,A.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.prevPosition.values.push(C.x,C.y,C.z),S.nextPosition.values.push(A.x,A.y,A.z,A.x,A.y,A.z),S.nextPosition.values.push(p[3*b],p[3*b+1],p[3*b+2]),S.nextPosition.values.push(p[3*b+3],p[3*b+4],p[3*b+5]);var P=n.fromArray(h,2*w,Fe),L=Math.abs(P.y);g.expandAndWidth.values.push(-1,L,1,L),g.expandAndWidth.values.push(-1,-L,1,-L),S.expandAndWidth.values.push(-1,L,1,L),S.expandAndWidth.values.push(-1,-L,1,-L);var U=i.magnitudeSquared(i.subtract(M,v,je));if(U/=i.magnitudeSquared(i.subtract(A,v,je)),c(y)){var D=a.fromArray(y,4*w,He),F=a.fromArray(y,4*b,He),B=O.lerp(D.x,F.x,U),q=O.lerp(D.y,F.y,U),z=O.lerp(D.z,F.z,U),j=O.lerp(D.w,F.w,U);for(r=4*w;r<4*w+8;++r)g.color.values.push(y[r]);for(g.color.values.push(B,q,z,j),g.color.values.push(B,q,z,j),S.color.values.push(B,q,z,j),S.color.values.push(B,q,z,j),r=4*b;r<4*b+8;++r)S.color.values.push(y[r])}if(c(d)){var G=n.fromArray(d,2*w,Fe),V=n.fromArray(d,2*(t+3),Be),X=O.lerp(G.x,V.x,U);for(r=2*w;r<2*w+4;++r)g.st.values.push(d[r]);for(g.st.values.push(X,G.y),g.st.values.push(X,V.y),S.st.values.push(X,G.y),S.st.values.push(X,V.y),r=2*b;r<2*b+4;++r)S.st.values.push(d[r])}o=g.position.values.length/3-4,N.push(o,o+2,o+1),N.push(o+1,o+2,o+3),o=S.position.values.length/3-4,I.push(o,o+2,o+1),I.push(o+1,o+2,o+3)}else{var H,W;for(v.y<0?(H=m.attributes,W=m.indices):(H=E.attributes,W=E.indices),H.position.values.push(v.x,v.y,v.z),H.position.values.push(v.x,v.y,v.z),H.position.values.push(A.x,A.y,A.z),H.position.values.push(A.x,A.y,A.z),r=3*t;r<3*t+12;++r)H.prevPosition.values.push(l[r]),H.nextPosition.values.push(p[r]);for(r=2*t;r<2*t+8;++r)H.expandAndWidth.values.push(h[r]),c(d)&&H.st.values.push(d[r]);if(c(y))for(r=4*t;r<4*t+16;++r)H.color.values.push(y[r]);o=H.position.values.length/3-4,W.push(o,o+2,o+1),W.push(o+1,o+2,o+3)}}_&&($(m),$(E)),Y(e,m,E)}var te={};te.toWireframe=function(e){if(!c(e))throw new f("geometry is required.");var t=e.indices;if(c(t)){switch(e.primitiveType){case b.TRIANGLES:e.indices=g(t);break;case b.TRIANGLE_STRIP:e.indices=N(t);break;case b.TRIANGLE_FAN:e.indices=S(t);break;default:throw new f("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=b.LINES}return e},te.createLineSegmentsForVectors=function(e,t,n){if(t=s(t,"normal"),!c(e))throw new f("geometry is required.");if(!c(e.attributes.position))throw new f("geometry.attributes.position is required.");if(!c(e.attributes[t]))throw new f("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=s(n,1e4);for(var i=e.attributes.position.values,a=e.attributes[t].values,o=i.length,l=new Float64Array(2*o),p=0,y=0;y<o;y+=3)l[p++]=i[y],l[p++]=i[y+1],l[p++]=i[y+2],l[p++]=i[y]+a[y]*n,l[p++]=i[y+1]+a[y+1]*n,l[p++]=i[y+2]+a[y+2]*n;var E,m=e.boundingSphere;return c(m)&&(E=new r(m.center,m.radius+n)),new h({attributes:{position:new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:b.LINES,boundingSphere:E})},te.createAttributeLocations=function(e){if(!c(e))throw new f("geometry is required.");var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,i={},a=0,o=r.length;for(t=0;t<o;++t){var u=r[t];c(n[u])&&(i[u]=a++)}for(var s in n)n.hasOwnProperty(s)&&!c(i[s])&&(i[s]=a++);return i},te.reorderForPreVertexCache=function(e){if(!c(e))throw new f("geometry is required.");var t=h.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),i=0;i<t;i++)n[i]=-1;for(var a,o=r,s=o.length,l=E.createTypedArray(t,s),p=0,d=0,y=0;p<s;)a=n[o[p]],a!==-1?l[d]=a:(a=o[p],n[a]=y,l[d]=y,++y),++p,++d;e.indices=l;var m=e.attributes;for(var T in m)if(m.hasOwnProperty(T)&&c(m[T])&&c(m[T].values)){for(var O=m[T],_=O.values,R=0,w=O.componentsPerAttribute,b=u.createTypedArray(O.componentDatatype,y*w);R<t;){var v=n[R];if(v!==-1)for(i=0;i<w;i++)b[w*v+i]=_[w*R+i];++R}O.values=b}}return e},te.reorderForPostVertexCache=function(e,t){if(!c(e))throw new f("geometry is required.");var r=e.indices;if(e.primitiveType===b.TRIANGLES&&c(r)){for(var n=r.length,i=0,a=0;a<n;a++)r[a]>i&&(i=r[a]);e.indices=v.tipsify({indices:r,maximumIndex:i,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){if(!c(e))throw new f("geometry is required.");if(c(e.indices)&&e.primitiveType!==b.TRIANGLES&&e.primitiveType!==b.LINES&&e.primitiveType!==b.POINTS)throw new f("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],r=h.computeNumberOfVertices(e);if(c(e.indices)&&r>=O.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=I(e.attributes),s=e.indices,l=s.length;e.primitiveType===b.TRIANGLES?n=3:e.primitiveType===b.LINES?n=2:e.primitiveType===b.POINTS&&(n=1);for(var p=0;p<l;p+=n){for(var d=0;d<n;++d){var y=s[p+d],E=i[y];c(E)||(E=o++,i[y]=E,M(u,e.attributes,y)),a.push(E)}o+n>=O.SIXTY_FOUR_KILOBYTES&&(t.push(new h({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],a=[],o=0,u=I(e.attributes))}0!==a.length&&t.push(new h({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new i,ne=new o;te.projectTo2D=function(e,t,r,n,a){if(!c(e))throw new f("geometry is required.");if(!c(t))throw new f("attributeName is required.");if(!c(r))throw new f("attributeName3D is required.");if(!c(n))throw new f("attributeName2D is required.");if(!c(e.attributes[t]))throw new f("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var o=e.attributes[t];a=c(a)?a:new p;for(var s=a.ellipsoid,l=o.values,h=new Float64Array(l.length),y=0,E=0;E<l.length;E+=3){var m=i.fromArray(l,E,re),T=s.cartesianToCartographic(m,ne);if(!c(T))throw new f("Could not project point ("+m.x+", "+m.y+", "+m.z+") to 2D.");var O=a.project(T,re);h[y++]=O.x,h[y++]=O.y,h[y++]=O.z}return e.attributes[r]=o,e.attributes[n]=new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:h}),delete e.attributes[t],e};var ie={high:0,low:0};te.encodeAttribute=function(e,t,r,n){if(!c(e))throw new f("geometry is required.");if(!c(t))throw new f("attributeName is required.");if(!c(r))throw new f("attributeHighName is required.");if(!c(n))throw new f("attributeLowName is required.");if(!c(e.attributes[t]))throw new f("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[t],a=i.values,o=a.length,s=new Float32Array(o),p=new Float32Array(o),h=0;h<o;++h)l.encode(a[h],ie),s[h]=ie.high,p[h]=ie.low;var y=i.componentsPerAttribute;return e.attributes[r]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:s}),e.attributes[n]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:p}),delete e.attributes[t],e};var ae=new i,oe=new R,ue=new _;te.transformToWorldCoordinates=function(e){if(!c(e))throw new f("instance is required.");var t=e.modelMatrix;if(R.equals(t,R.IDENTITY))return e;var n=e.geometry.attributes;x(t,n.position),x(t,n.prevPosition),x(t,n.nextPosition),(c(n.normal)||c(n.tangent)||c(n.bitangent))&&(R.inverse(t,oe),R.transpose(oe,oe),R.getRotation(oe,ue),C(ue,n.normal),C(ue,n.tangent),C(ue,n.bitangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=R.clone(R.IDENTITY),e};var se=new i;te.combineInstances=function(e){if(!c(e)||e.length<1)throw new f("instances is required and must have length greater than zero.");for(var t=[],r=[],n=e.length,i=0;i<n;++i){var a=e[i];c(a.geometry)?t.push(a):c(a.westHemisphereGeometry)&&c(a.eastHemisphereGeometry)&&r.push(a)}var o=[];return t.length>0&&o.push(L(t,"geometry")),r.length>0&&(o.push(L(r,"westHemisphereGeometry")),o.push(L(r,"eastHemisphereGeometry"))),o};var ce=new i,fe=new i,le=new i,pe=new i;te.computeNormal=function(e){if(!c(e))throw new f("geometry is required.");if(!c(e.attributes.position)||!c(e.attributes.position.values))throw new f("geometry.attributes.position.values is required.");if(!c(e.indices))throw new f("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var t=e.indices,r=e.attributes,n=r.position.values,a=r.position.values.length/3,o=t.length,s=new Array(a),l=new Array(o/3),p=new Array(o),h=0;h<a;h++)s[h]={indexOffset:0,count:0,currentCount:0};var y=0;for(h=0;h<o;h+=3){var E=t[h],m=t[h+1],T=t[h+2],_=3*E,R=3*m,w=3*T;fe.x=n[_],fe.y=n[_+1],fe.z=n[_+2],le.x=n[R],le.y=n[R+1],le.z=n[R+2],pe.x=n[w],pe.y=n[w+1],pe.z=n[w+2],s[E].count++,s[m].count++,s[T].count++,i.subtract(le,fe,le),i.subtract(pe,fe,pe),l[y]=i.cross(le,pe,new i),y++}var v=0;for(h=0;h<a;h++)s[h].indexOffset+=v,v+=s[h].count;y=0;var A;for(h=0;h<o;h+=3){A=s[t[h]];var g=A.indexOffset+A.currentCount;p[g]=y,A.currentCount++,A=s[t[h+1]],g=A.indexOffset+A.currentCount,p[g]=y,A.currentCount++,A=s[t[h+2]],g=A.indexOffset+A.currentCount,p[g]=y,A.currentCount++,y++}var N=new Float32Array(3*a);for(h=0;h<a;h++){var S=3*h;if(A=s[h],i.clone(i.ZERO,ce),A.count>0){for(y=0;y<A.count;y++)i.add(ce,l[p[A.indexOffset+y]],ce);i.equalsEpsilon(i.ZERO,ce,O.EPSILON10)&&i.clone(l[p[A.indexOffset]],ce)}i.equalsEpsilon(i.ZERO,ce,O.EPSILON10)&&(ce.z=1),i.normalize(ce,ce),N[S]=ce.x,N[S+1]=ce.y,N[S+2]=ce.z}return e.attributes.normal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:N}),e};var he=new i,de=new i,ye=new i;te.computeTangentAndBitangent=function(e){if(!c(e))throw new f("geometry is required.");var t=e.attributes,r=e.indices;if(!c(t.position)||!c(t.position.values))throw new f("geometry.attributes.position.values is required.");if(!c(t.normal)||!c(t.normal.values))throw new f("geometry.attributes.normal.values is required.");if(!c(t.st)||!c(t.st.values))throw new f("geometry.attributes.st.values is required.");if(!c(r))throw new f("geometry.indices is required.");if(r.length<2||r.length%3!==0)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var n=e.attributes.position.values,a=e.attributes.normal.values,o=e.attributes.st.values,s=e.attributes.position.values.length/3,l=r.length,p=new Array(3*s),h=0;h<p.length;h++)p[h]=0;var y,E,m;for(h=0;h<l;h+=3){var T=r[h],O=r[h+1],_=r[h+2];y=3*T,E=3*O,m=3*_;var R=2*T,w=2*O,v=2*_,A=n[y],g=n[y+1],N=n[y+2],S=o[R],I=o[R+1],M=o[w+1]-I,x=o[v+1]-I,C=1/((o[w]-S)*x-(o[v]-S)*M),P=(x*(n[E]-A)-M*(n[m]-A))*C,L=(x*(n[E+1]-g)-M*(n[m+1]-g))*C,U=(x*(n[E+2]-N)-M*(n[m+2]-N))*C;p[y]+=P,p[y+1]+=L,p[y+2]+=U,p[E]+=P,p[E+1]+=L,p[E+2]+=U,p[m]+=P,p[m+1]+=L,p[m+2]+=U}var D=new Float32Array(3*s),F=new Float32Array(3*s);for(h=0;h<s;h++){y=3*h,E=y+1,m=y+2;var B=i.fromArray(a,y,he),q=i.fromArray(p,y,ye),z=i.dot(B,q);i.multiplyByScalar(B,z,de),i.normalize(i.subtract(q,de,q),q),D[y]=q.x,D[E]=q.y,D[m]=q.z,i.normalize(i.cross(B,q,q),q),F[y]=q.x,F[E]=q.y,F[m]=q.z}return e.attributes.tangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:D}),e.attributes.bitangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:F}),e};var Ee=new n,me=new i,Te=new i,Oe=new i,_e=new n;te.compressVertices=function(t){if(!c(t))throw new f("geometry is required.");var r,a,o=t.attributes.extrudeDirection;if(c(o)){var s=o.values;a=s.length/3;var l=new Float32Array(2*a),p=0;for(r=0;r<a;++r)i.fromArray(s,3*r,me),i.equals(me,i.ZERO)?p+=2:(_e=e.octEncodeInRange(me,65535,_e),l[p++]=_e.x,l[p++]=_e.y);return t.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:l}),delete t.attributes.extrudeDirection,t}var h=t.attributes.normal,y=t.attributes.st,E=c(h),m=c(y);if(!E&&!m)return t;var T,O,_,R,w=t.attributes.tangent,b=t.attributes.bitangent,v=c(w),A=c(b);E&&(T=h.values),m&&(O=y.values),v&&(_=w.values),A&&(R=b.values);var g=E?T.length:O.length,N=E?3:2;a=g/N;var S=a,I=m&&E?2:1;I+=v||A?1:0,S*=I;var M=new Float32Array(S),x=0;for(r=0;r<a;++r){m&&(n.fromArray(O,2*r,Ee),M[x++]=e.compressTextureCoordinates(Ee));var C=3*r;E&&c(_)&&c(R)?(i.fromArray(T,C,me),i.fromArray(_,C,Te),i.fromArray(R,C,Oe),e.octPack(me,Te,Oe,Ee),M[x++]=Ee.x,M[x++]=Ee.y):(E&&(i.fromArray(T,C,me),M[x++]=e.octEncodeFloat(me)),v&&(i.fromArray(_,C,me),M[x++]=e.octEncodeFloat(me)),A&&(i.fromArray(R,C,me),M[x++]=e.octEncodeFloat(me)))}return t.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:I,values:M}),E&&delete t.attributes.normal,m&&delete t.attributes.st,A&&delete t.attributes.bitangent,v&&delete t.attributes.tangent,t};var Re=new i,we=new i,be=new i,ve=new i,Ae=new i,ge={positions:new Array(7),indices:new Array(9)},Ne=new i,Se=new i,Ie=new i,Me=new i,xe=new n,Ce=new n,Pe=new n,Le=w.fromPointNormal(i.ZERO,i.UNIT_Y),Ue=new i,De=new i,Fe=new n,Be=new n,qe=new i,ze=new i,je=new i,Ge=new i,Ve=new i,Xe=new i,He=new a,We=5*O.EPSILON9,ke=O.EPSILON6;return te.splitLongitude=function(e){if(!c(e))throw new f("instance is required.");var t=e.geometry,n=t.boundingSphere;if(c(n)){var i=n.center.x-n.radius;if(i>0||r.intersectPlane(n,w.ORIGIN_ZX_PLANE)!==m.INTERSECTING)return e}if(t.geometryType!==y.NONE)switch(t.geometryType){case y.POLYLINES:ee(e);break;case y.TRIANGLES:Q(e);break;case y.LINES:J(e)}else j(t),t.primitiveType===b.TRIANGLES?Q(e):t.primitiveType===b.LINES&&J(e);return e},te}),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.mercatorAngleToGeodeticLatitude=function(e){return u.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},s.geodeticLatitudeToMercatorAngle=function(e){e>s.MaximumLatitude?e=s.MaximumLatitude:e<-s.MaximumLatitude&&(e=-s.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},s.MaximumLatitude=s.mercatorAngleToGeodeticLatitude(Math.PI),s.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=s.geodeticLatitudeToMercatorAngle(t.latitude)*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},s.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=s.mercatorAngleToGeodeticLatitude(e.y*i),c=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=c,r):new t(o,u,c)},s}),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/ComponentDatatype","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,t,r,n,i,a,o,u,s,c,f,l,p,h){"use strict";function d(e,t,n){var i,a=!n,o=e.length;if(!a&&o>1){var u=e[0].modelMatrix;for(i=1;i<o;++i)if(!p.equals(u,e[i].modelMatrix)){a=!0;break}}if(a)for(i=0;i<o;++i)r(e[i].geometry)&&f.transformToWorldCoordinates(e[i]);else p.multiplyTransformation(t,e[0].modelMatrix,t)}function y(e,r){var n=e.attributes,i=n.position,a=i.values.length/i.componentsPerAttribute;n.batchId=new s({componentDatatype:t.FLOAT,componentsPerAttribute:1,values:new Float32Array(a)});for(var o=n.batchId.values,u=0;u<a;++u)o[u]=r}function E(e){for(var t=e.length,n=0;n<t;++n){var i=e[n];r(i.geometry)?y(i.geometry,n):r(i.westHemisphereGeometry)&&r(i.eastHemisphereGeometry)&&(y(i.westHemisphereGeometry,n),y(i.eastHemisphereGeometry,n))}}function m(i){var a,o,u,s=i.instances,c=i.projection,l=i.elementIndexUintSupported,p=i.scene3DOnly,h=i.vertexCacheOptimize,y=i.compressVertices,m=i.modelMatrix,T=s.length;for(a=0;a<T;++a)if(r(s[a].geometry)){u=s[a].geometry.primitiveType;break}for(a=1;a<T;++a)if(r(s[a].geometry)&&s[a].geometry.primitiveType!==u)throw new n("All instance geometries must have the same primitiveType.");if(d(s,m,p),!p)for(a=0;a<T;++a)r(s[a].geometry)&&f.splitLongitude(s[a]);if(E(s),h)for(a=0;a<T;++a){var O=s[a];r(O.geometry)?(f.reorderForPostVertexCache(O.geometry),f.reorderForPreVertexCache(O.geometry)):r(O.westHemisphereGeometry)&&r(O.eastHemisphereGeometry)&&(f.reorderForPostVertexCache(O.westHemisphereGeometry),f.reorderForPreVertexCache(O.westHemisphereGeometry),f.reorderForPostVertexCache(O.eastHemisphereGeometry),f.reorderForPreVertexCache(O.eastHemisphereGeometry))}var _=f.combineInstances(s);for(T=_.length,a=0;a<T;++a){o=_[a];var R,w=o.attributes;if(p)for(R in w)w.hasOwnProperty(R)&&w[R].componentDatatype===t.DOUBLE&&f.encodeAttribute(o,R,R+"3DHigh",R+"3DLow");else for(R in w)if(w.hasOwnProperty(R)&&w[R].componentDatatype===t.DOUBLE){var b=R+"3D",v=R+"2D";f.projectTo2D(o,R,b,v,c),r(o.boundingSphere)&&"position"===R&&(o.boundingSphereCV=e.fromVertices(o.attributes.position2D.values)),f.encodeAttribute(o,b,b+"High",b+"Low"),f.encodeAttribute(o,v,v+"High",v+"Low")}y&&f.compressVertices(o)}if(!l){var A=[];for(T=_.length,a=0;a<T;++a)o=_[a],A=A.concat(f.fitToUnsignedShortIndices(o));_=A}return _}function T(e,t,n,i){var a,o,u,s=i.length-1;if(s>=0){var c=i[s];a=c.offset+c.count,u=c.index,o=n[u].indices.length}else a=0,u=0,o=n[u].indices.length;for(var f=e.length,l=0;l<f;++l){var p=e[l],h=p[t];if(r(h)){var d=h.indices.length;a+d>o&&(a=0,o=n[++u].indices.length),i.push({index:u,offset:a,count:d}),a+=d}}}function O(e,t){var r=[];return T(e,"geometry",t,r),T(e,"westHemisphereGeometry",t,r),T(e,"eastHemisphereGeometry",t,r),r}function _(e,t){var n=e.attributes;for(var i in n)if(n.hasOwnProperty(i)){var a=n[i];r(a)&&r(a.values)&&t.push(a.values.buffer)}r(e.indices)&&t.push(e.indices.buffer)}function R(e,t){for(var r=e.length,n=0;n<r;++n)_(e[n],t)}function w(t){for(var n=1,i=t.length,a=0;a<i;a++){var o=t[a];if(++n,r(o)){var u=o.attributes;n+=6+2*e.packedLength+(r(o.indices)?o.indices.length:0);for(var s in u)if(u.hasOwnProperty(s)&&r(u[s])){var c=u[s];n+=5+c.values.length}}}return n}function b(e,t){var r=e.length,n=new Float64Array(1+16*r),i=0;n[i++]=r;for(var a=0;a<r;a++){var o=e[a];p.pack(o.modelMatrix,n,i),i+=p.packedLength}return t.push(n.buffer),n}function v(e){for(var t=e,r=new Array(t[0]),n=0,i=1;i<t.length;){var a=p.unpack(t,i);i+=p.packedLength,r[n++]={modelMatrix:a}}return r}function A(t){var n=t.length,i=1+(e.packedLength+1)*n,a=new Float32Array(i),o=0;a[o++]=n;for(var u=0;u<n;++u){var s=t[u];r(s)?(a[o++]=1,e.pack(t[u],a,o)):a[o++]=0,o+=e.packedLength}return a}function g(t){for(var r=new Array(t[0]),n=0,i=1;i<t.length;)1===t[i++]&&(r[n]=e.unpack(t,i)),++n,i+=e.packedLength;return r}if(!a.supportsTypedArrays())return{};var N={};return N.combineGeometry=function(t){var n,i,a=t.instances,o=a.length;o>0&&(n=m(t),n.length>0&&(i=f.createAttributeLocations(n[0])));var u;t.createPickOffsets&&n.length>0&&(u=O(a,n));for(var s=new Array(o),c=new Array(o),l=0;l<o;++l){var p=a[l],h=p.geometry;r(h)&&(s[l]=h.boundingSphere,c[l]=h.boundingSphereCV);var d=p.eastHemisphereGeometry,y=p.westHemisphereGeometry;r(d)&&r(y)&&(r(d.boundingSphere)&&r(y.boundingSphere)&&(s[l]=e.union(d.boundingSphere,y.boundingSphere)),r(d.boundingSphereCV)&&r(y.boundingSphereCV)&&(c[l]=e.union(d.boundingSphereCV,y.boundingSphereCV)))}return{geometries:n,modelMatrix:t.modelMatrix,attributeLocations:i,pickOffsets:u,boundingSpheres:s,boundingSpheresCV:c}},N.packCreateGeometryResults=function(t,n){var i=new Float64Array(w(t)),a=[],o={},u=t.length,s=0;i[s++]=u;for(var c=0;c<u;c++){var f=t[c],l=r(f);if(i[s++]=l?1:0,l){i[s++]=f.primitiveType,i[s++]=f.geometryType;var p=r(f.boundingSphere)?1:0;i[s++]=p,p&&e.pack(f.boundingSphere,i,s),s+=e.packedLength;var h=r(f.boundingSphereCV)?1:0;i[s++]=h,h&&e.pack(f.boundingSphereCV,i,s),s+=e.packedLength;var d=f.attributes,y=[];for(var E in d)d.hasOwnProperty(E)&&r(d[E])&&(y.push(E),r(o[E])||(o[E]=a.length,a.push(E)));i[s++]=y.length;for(var m=0;m<y.length;m++){var T=y[m],O=d[T];i[s++]=o[T],i[s++]=O.componentDatatype,i[s++]=O.componentsPerAttribute,i[s++]=O.normalize?1:0,i[s++]=O.values.length,i.set(O.values,s),s+=O.values.length}var _=r(f.indices)?f.indices.length:0;i[s++]=_,_>0&&(i.set(f.indices,s),s+=_)}}return n.push(i.buffer),{stringTable:a,packedData:i}},N.unpackCreateGeometryResults=function(r){for(var n,i=r.stringTable,a=r.packedData,o=new Array(a[0]),f=0,p=1;p<a.length;){var h=1===a[p++];if(h){var d,y,E=a[p++],m=a[p++],T=1===a[p++];T&&(d=e.unpack(a,p)),p+=e.packedLength;var O=1===a[p++];O&&(y=e.unpack(a,p)),p+=e.packedLength;var _,R,w,b=new c,v=a[p++];for(n=0;n<v;n++){var A=i[a[p++]],g=a[p++];w=a[p++];var N=0!==a[p++];_=a[p++],R=t.createTypedArray(g,_);for(var S=0;S<_;S++)R[S]=a[p++];b[A]=new s({componentDatatype:g,componentsPerAttribute:w,normalize:N,values:R})}var I;if(_=a[p++],_>0){var M=R.length/w;
for(I=l.createTypedArray(M,_),n=0;n<_;n++)I[n]=a[p++]}o[f++]=new u({primitiveType:E,geometryType:m,boundingSphere:d,boundingSphereCV:y,indices:I,attributes:b})}else o[f++]=void 0}return o},N.packCombineGeometryParameters=function(e,t){for(var r=e.createGeometryResults,n=r.length,i=0;i<n;i++)t.push(r[i].packedData.buffer);return{createGeometryResults:e.createGeometryResults,packedInstances:b(e.instances,t),ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof o,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix,createPickOffsets:e.createPickOffsets}},N.unpackCombineGeometryParameters=function(e){for(var t=v(e.packedInstances),r=e.createGeometryResults,n=r.length,a=0,u=0;u<n;u++)for(var s=N.unpackCreateGeometryResults(r[u]),c=s.length,f=0;f<c;f++){var l=s[f],d=t[a];d.geometry=l,++a}var y=i.clone(e.ellipsoid),E=e.isGeographic?new o(y):new h(y);return{instances:t,ellipsoid:y,projection:E,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:p.clone(e.modelMatrix),createPickOffsets:e.createPickOffsets}},N.packCombineGeometryResults=function(e,t){r(e.geometries)&&R(e.geometries,t);var n=A(e.boundingSpheres),i=A(e.boundingSpheresCV);return t.push(n.buffer,i.buffer),{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,boundingSpheres:n,boundingSpheresCV:i}},N.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,boundingSpheres:g(e.boundingSpheres),boundingSpheresCV:g(e.boundingSpheresCV)}},N}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var r,n=t.name,i=t.message;r=e(n)&&e(i)?n+": "+i:t.toString();var a=t.stack;return e(a)&&(r+="\n"+a),r}return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r){"use strict";function n(n){var i,a=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;a.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=n(s.parameters,a)}catch(e){e instanceof Error?o.error={name:e.name,message:e.message,stack:e.stack}:o.error=e}t(i)||(i=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(a.length=0);try{i(o,a)}catch(e){o.result=void 0,o.error="postMessage failed with error: "+r(e)+"\n  with responseMessage: "+JSON.stringify(o),i(o)}}}return n}),define("Workers/combineGeometry",["../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,t){"use strict";function r(t,r){var n=e.unpackCombineGeometryParameters(t),i=e.combineGeometry(n);return e.packCombineGeometryResults(i,r)}return t(r)})}();