/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(n,i){if(!e(i))throw new t(r(n))},i.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},i.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},i.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},i.typeOf.number.lessThan=function(e,r,n){if(i.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},i.typeOf.number.lessThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},i.typeOf.number.greaterThan=function(e,r,n){if(i.typeOf.number(e,r),r<=n)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},i.typeOf.number.greaterThanOrEquals=function(e,r,n){if(i.typeOf.number(e,r),r<n)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},i.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},i.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:e<0?-1:0},i.signNotZero=function(e){return e<0?-1:1},i.toSNorm=function(e,r){return r=t(r,255),Math.round((.5*i.clamp(e,-1,1)+.5)*r)},i.fromSNorm=function(e,r){return r=t(r,255),i.clamp(e,0,r)/r*2-1},i.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},i.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},i.lerp=function(e,t,r){return(1-r)*e+r*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!r(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!r(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!r(e))throw new n("angle is required.");var t=i.TWO_PI,a=e-Math.floor(e/t)*t;return a<-Math.PI?a+t:a>=Math.PI?a-t:a},i.clampToLatitudeRange=function(e){if(!r(e))throw new n("angle is required.");return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){if(!r(e))throw new n("angle is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!r(e))throw new n("angle is required.");var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){if(!r(e))throw new n("m is required.");if(!r(t))throw new n("n is required.");return(e%t+t)%t},i.equalsEpsilon=function(e,i,a,o){if(!r(e))throw new n("left is required.");if(!r(i))throw new n("right is required.");if(!r(a))throw new n("relativeEpsilon is required.");o=t(o,a);var u=Math.abs(e-i);return u<=o||u<=a*Math.max(Math.abs(e),Math.abs(i))};var a=[1];i.factorial=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");var t=a.length;if(e>=t)for(var r=a[t-1],i=t;i<=e;i++)a.push(r*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=t(a,0),!r(e))throw new n("n is required.");if(i<=a)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||e<0)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,i){if(!r(e))throw new n("value is required");if(!r(t))throw new n("min is required.");if(!r(i))throw new n("max is required.");return e<t?t:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(t){if(!r(t))throw new n("seed is required.");o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){if(!r(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!r(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){if(!r(e))throw new n("angle is required.");if(!r(t))throw new n("radius is required.");return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){if(!r(e))throw new n("number is required.");if(!r(t))throw new n("base is required.");return Math.log(e)/Math.log(t)},i.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},i}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(n,i){e.typeOf.object("spherical",n),r(i)||(i=new o);var a=n.clock,u=n.cone,s=t(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i]=r.z,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=3*i:n=new Array(3*i);for(var a=0;a<i;++a)o.pack(t[a],n,3*a);return n},o.unpackArray=function(t,i){if(e.defined("array",t),e.typeOf.number.greaterThanOrEquals("array.length",t.length,3),t.length%3!==0)throw new n("array length must be a multiple of 3.");var a=t.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;u<a;u+=3){var s=u/3;i[s]=o.unpack(t,u,i[s])}return i},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n},o.divideComponents=function(e,t,i){if(!r(e))throw new n("left is required");if(!r(t))throw new n("right is required");if(!r(i))throw new n("result is required");return i.x=e.x/t.x,i.y=e.y/t.y,i.z=e.z/t.z,i},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,l=new o;o.angleBetween=function(t,r){e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,l);var n=o.dot(c,l),i=o.magnitude(o.cross(c,l,c));return Math.atan2(i,n)};var f=new o;o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Z,r):n.y<=n.z?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_Z,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)},o.cross=function(t,r,n){e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=r.x,s=r.y,c=r.z,l=a*c-o*s,f=o*u-i*c,d=i*s-a*u;return n.x=l,n.y=f,n.z=d,n},o.fromDegrees=function(t,r,n,i,u){return e.typeOf.number("longitude",t),e.typeOf.number("latitude",r),t=a.toRadians(t),r=a.toRadians(r),o.fromRadians(t,r,n,i,u)};var d=new o,h=new o,p=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){e.typeOf.number("longitude",n),e.typeOf.number("latitude",i),a=t(a,0);var c=r(u)?u.radiiSquared:p,l=Math.cos(i);d.x=l*Math.cos(n),d.y=l*Math.sin(n),d.z=Math.sin(i),d=o.normalize(d,d),o.multiplyComponents(c,d,h);var f=Math.sqrt(o.dot(d,h));return h=o.divideByScalar(h,f,h),d=o.multiplyByScalar(d,a,d),r(s)||(s=new o),o.add(h,d,s)},o.fromDegreesArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],l=t[s+1],f=s/2;a[f]=o.fromDegrees(c,l,0,i,a[f])}return a},o.fromRadiansArray=function(t,i,a){if(e.defined("coordinates",t),t.length<2||t.length%2!==0)throw new n("the number of coordinates must be a multiple of 2 and at least 2");var u=t.length;r(a)?a.length=u/2:a=new Array(u/2);for(var s=0;s<u;s+=2){var c=t[s],l=t[s+1],f=s/2;a[f]=o.fromRadians(c,l,0,i,a[f])}return a},o.fromDegreesArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],l=t[s+1],f=t[s+2],d=s/3;a[d]=o.fromDegrees(c,l,f,i,a[d])}return a},o.fromRadiansArrayHeights=function(t,i,a){if(e.defined("coordinates",t),t.length<3||t.length%3!==0)throw new n("the number of coordinates must be a multiple of 3 and at least 3");var u=t.length;r(a)?a.length=u/3:a=new Array(u/3);for(var s=0;s<u;s+=3){var c=t[s],l=t[s+1],f=t[s+2],d=s/3;a[d]=o.fromRadians(c,l,f,i,a[d])}return a},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(i,u,s,c,l){if(!t(i))throw new r("cartesian is required.");if(!t(u))throw new r("oneOverRadii is required.");if(!t(s))throw new r("oneOverRadiiSquared is required.");if(!t(c))throw new r("centerToleranceSquared is required.");var f=i.x,d=i.y,h=i.z,p=u.x,y=u.y,m=u.z,E=f*f*p*p,w=d*d*y*y,_=h*h*m*m,O=E+w+_,T=Math.sqrt(1/O),v=e.multiplyByScalar(i,T,a);if(O<c)return isFinite(T)?e.clone(v,l):void 0;var R=s.x,A=s.y,g=s.z,b=o;b.x=v.x*R*2,b.y=v.y*A*2,b.z=v.z*g*2;var S,N,I,x,M,P,C,D,L,U,F,q=(1-T)*e.magnitude(i)/(.5*e.magnitude(b)),z=0;do{q-=z,I=1/(1+q*R),x=1/(1+q*A),M=1/(1+q*g),P=I*I,C=x*x,D=M*M,L=P*I,U=C*x,F=D*M,S=E*P+w*C+_*D-1,N=E*L*R+w*U*A+_*F*g;var B=-2*N;z=S/B}while(Math.abs(S)>n.EPSILON12);return t(l)?(l.x=f*I,l.y=d*x,l.z=h*M,l):new e(f*I,d*x,h*M)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o){"use strict";function u(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)}u.fromRadians=function(e,i,a,o){if(!r(e))throw new n("longitude is required.");if(!r(i))throw new n("latitude is required.");return a=t(a,0),r(o)?(o.longitude=e,o.latitude=i,o.height=a,o):new u(e,i,a)},u.fromDegrees=function(e,t,i,o){if(!r(e))throw new n("longitude is required.");if(!r(t))throw new n("latitude is required.");return e=a.toRadians(e),t=a.toRadians(t),u.fromRadians(e,t,i,o)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),d=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=a.EPSILON1;return u.fromCartesian=function(t,n,i){var p=r(n)?n.oneOverRadii:f,y=r(n)?n.oneOverRadiiSquared:d,m=r(n)?n._centerToleranceSquared:h,E=o(t,p,y,m,c);if(r(E)){var w=e.multiplyComponents(E,y,s);w=e.normalize(w,w);var _=e.subtract(t,E,l),O=Math.atan2(w.y,w.x),T=Math.asin(w.z),v=a.sign(e.dot(_,t))*e.magnitude(_);return r(i)?(i.longitude=O,i.latitude=T,i.height=v,i):new u(O,T,v)}},u.clone=function(e,t){if(r(e))return r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===t||r(e)&&r(t)&&Math.abs(e.longitude-t.longitude)<=i&&Math.abs(e.latitude-t.latitude)<=i&&Math.abs(e.height-t.height)<=i},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,i,a,o,u,s){"use strict";function c(t,n,i,o){if(n=r(n,0),i=r(i,0),o=r(o,0),n<0||i<0||o<0)throw new a("All radii components must be greater than or equal to zero.");t._radii=new e(n,i,o),t._radiiSquared=new e(n*n,i*i,o*o),t._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,o*o*o*o),t._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===o?0:1/o),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===o?0:1/(o*o)),t._minimumRadius=Math.min(n,i,o),t._maximumRadius=Math.max(n,i,o),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._sqauredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._sqauredXOverSquaredZ=void 0,c(this,e,t,r)}i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(n(t)){var i=t._radii;return n(r)?(e.clone(i,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(i.x,i.y,i.z)}},l.fromCartesian3=function(e,t){return n(t)||(t=new l),n(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,i,o){if(!n(t))throw new a("value is required");if(!n(i))throw new a("array is required");return o=r(o,0),e.pack(t._radii,i,o),i},l.unpack=function(t,i,o){if(!n(t))throw new a("array is required");i=r(i,0);var u=e.unpack(t,i);return l.fromCartesian3(u,o)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,r){if(!n(t))throw new a("cartographic is required.");var i=t.longitude,o=t.latitude,u=Math.cos(o),s=u*Math.cos(i),c=u*Math.sin(i),l=Math.sin(o);return n(r)||(r=new e),r.x=s,r.y=c,r.z=l,e.normalize(r,r)},l.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var f=new e,d=new e;l.prototype.cartographicToCartesian=function(t,r){var i=f,a=d;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),n(r)||(r=new e),e.add(a,i,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){if(!n(e))throw new a("cartographics is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;i<r;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var h=new e,p=new e,y=new e;return l.prototype.cartesianToCartographic=function(r,i){var a=this.scaleToGeodeticSurface(r,p);if(n(a)){var o=this.geodeticSurfaceNormal(a,h),s=e.subtract(r,a,y),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,r))*e.magnitude(s);return n(i)?(i.longitude=c,i.latitude=l,i.height=f,i):new t(c,l,f)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){if(!n(e))throw new a("cartesians is required.");var r=e.length;n(t)?t.length=r:t=new Array(r);for(var i=0;i<r;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,r){if(!n(t))throw new a("cartesian is required.");n(r)||(r=new e);var i=t.x,o=t.y,u=t.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(t,c,r)},l.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,i,o){if(!n(t))throw new a("position is required.");if(!u.equalsEpsilon(this._radii.x,this._radii.y,u.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");if(0===this._radii.z)throw new a("Ellipsoid.radii.z must be greater than 0");i=r(i,0);var s=this._sqauredXOverSquaredZ;if(n(o)||(o=new e),o.x=0,o.y=0,o.z=t.z*(1-s),!(Math.abs(o.z)>=this._radii.z-i))return o},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,i,a,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return n(r)?(r.x=a,r.y=o,r.z=u,r):new e(a,o,u)},u.prototype.unproject=function(e,r){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(r)?(r.longitude=o,r.latitude=u,r.height=s,r):new t(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i,a,o,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function l(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(y[r],p[r])];t+=2*n*n}return Math.sqrt(t)}function f(e,t){for(var r=u.EPSILON15,n=0,i=1,a=0;a<3;++a){var o=Math.abs(e[s.getElementIndex(y[a],p[a])]);o>n&&(i=a,n=o)}var c=1,l=0,f=p[i],d=y[i];if(Math.abs(e[s.getElementIndex(d,f)])>r){var h,m=e[s.getElementIndex(d,d)],E=e[s.getElementIndex(f,f)],w=e[s.getElementIndex(d,f)],_=(m-E)/2/w;h=_<0?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),c=1/Math.sqrt(1+h*h),l=h*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(f,f)]=t[s.getElementIndex(d,d)]=c,t[s.getElementIndex(d,f)]=l,t[s.getElementIndex(f,d)]=-l,t}s.packedLength=9,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e[0],n[i++]=e[1],n[i++]=e[2],n[i++]=e[3],n[i++]=e[4],n[i++]=e[5],n[i++]=e[6],n[i++]=e[7],n[i++]=e[8],n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},s.fromColumnMajorArray=function(e,r){return t.defined("values",e),s.clone(e,r)},s.fromRowMajorArray=function(e,r){return t.defined("values",e),n(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,r){t.typeOf.object("quaternion",e);var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,c=e.y*e.y,l=e.y*e.z,f=e.y*e.w,d=e.z*e.z,h=e.z*e.w,p=e.w*e.w,y=i-c-d+p,m=2*(a-h),E=2*(o+f),w=2*(a+h),_=-i+c-d+p,O=2*(l-u),T=2*(o-f),v=2*(l+u),R=-i-c+d+p;return n(r)?(r[0]=y,r[1]=w,r[2]=T,r[3]=m,r[4]=_,r[5]=v,r[6]=E,r[7]=O,r[8]=R,r):new s(y,m,E,w,_,O,T,v,R)},s.fromHeadingPitchRoll=function(e,r){t.typeOf.object("headingPitchRoll",e);var i=Math.cos(-e.pitch),a=Math.cos(-e.heading),o=Math.cos(e.roll),u=Math.sin(-e.pitch),c=Math.sin(-e.heading),l=Math.sin(e.roll),f=i*a,d=-o*c+l*u*a,h=l*c+o*u*a,p=i*c,y=o*a+l*u*c,m=-u*o+o*u*c,E=-u,w=l*i,_=o*i;return n(r)?(r[0]=f,r[1]=p,r[2]=E,r[3]=d,r[4]=y,r[5]=w,r[6]=h,r[7]=m,r[8]=_,r):new s(f,d,h,p,y,m,E,w,_)},s.fromScale=function(e,r){return t.typeOf.object("scale",e),n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,r){return t.typeOf.number("scale",e),n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,r){return t.typeOf.object("vector",e),n(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new s(1,0,0,0,i,-a,0,a,i)},s.fromRotationY=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new s(i,0,a,0,1,0,-a,0,i)},s.fromRotationZ=function(e,r){t.typeOf.number("angle",e);var i=Math.cos(e),a=Math.sin(e);return n(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new s(i,-a,0,a,i,0,0,0,1)},s.toArray=function(e,r){return t.typeOf.object("matrix",e),n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,r){return t.typeOf.number.greaterThanOrEquals("row",r,0),t.typeOf.number.lessThanOrEquals("row",r,2),t.typeOf.number.greaterThanOrEquals("column",e,0),t.typeOf.number.lessThanOrEquals("column",e,2),3*e+r},s.getColumn=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=3*r,a=e[i],o=e[i+1],u=e[i+2];return n.x=a,n.y=o,n.z=u,n},s.setColumn=function(e,r,n,i){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i);var a=3*r;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i},s.getRow=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("result",n);var i=e[r],a=e[r+3],o=e[r+6];return n.x=i,n.y=a,n.z=o,n},s.setRow=function(e,r,n,i){return t.typeOf.object("matrix",e),t.typeOf.number.greaterThanOrEquals("index",r,0),t.typeOf.number.lessThanOrEquals("index",r,2),t.typeOf.object("cartesian",n),t.typeOf.object("result",i),i=s.clone(e,i),i[r]=n.x,i[r+3]=n.y,i[r+6]=n.z,i};var d=new e;s.getScale=function(r,n){return t.typeOf.object("matrix",r),t.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],d)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],d)),n};var h=new e;s.getMaximumScale=function(t){return s.getScale(t,h),e.maximumComponent(h)},s.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],o=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],s=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],l=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],f=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=i,n[1]=a,n[2]=o,n[3]=u,n[4]=s,n[5]=c,n[6]=l,n[7]=f,n[8]=d,n},s.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},s.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},s.multiplyByVector=function(e,r,n){t.typeOf.object("matrix",e),t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=r.x,a=r.y,o=r.z,u=e[0]*i+e[3]*a+e[6]*o,s=e[1]*i+e[4]*a+e[7]*o,c=e[2]*i+e[5]*a+e[8]*o;return n.x=u,n.y=s,n.z=c,n},s.multiplyByScalar=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},s.multiplyByScale=function(e,r,n){return t.typeOf.object("matrix",e),t.typeOf.object("scale",r),t.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},s.negate=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),
r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},s.transpose=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],c=e[2],l=e[5],f=e[8];return r[0]=n,r[1]=i,r[2]=a,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=f,r};var p=[1,0,0],y=[2,2,1],m=new s,E=new s;return s.computeEigenDecomposition=function(e,r){t.typeOf.object("matrix",e);var i=u.EPSILON20,a=10,o=0,d=0;n(r)||(r={});for(var h=r.unitary=s.clone(s.IDENTITY,r.unitary),p=r.diagonal=s.clone(e,r.diagonal),y=i*c(p);d<a&&l(p)>y;)f(p,m),s.transpose(m,E),s.multiply(p,m,p),s.multiply(E,p,p),s.multiply(h,m,h),++o>2&&(++d,o=0);return r},s.abs=function(e,r){return t.typeOf.object("matrix",e),t.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},s.determinant=function(e){t.typeOf.object("matrix",e);var r=e[0],n=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return r*(o*l-c*u)+a*(c*i-n*l)+s*(n*u-o*i)},s.inverse=function(e,r){t.typeOf.object("matrix",e),t.typeOf.object("result",r);var n=e[0],i=e[1],o=e[2],c=e[3],l=e[4],f=e[5],d=e[6],h=e[7],p=e[8],y=s.determinant(e);if(Math.abs(y)<=u.EPSILON15)throw new a("matrix is not invertible");r[0]=l*p-h*f,r[1]=h*o-i*p,r[2]=i*f-l*o,r[3]=d*f-c*p,r[4]=n*p-d*o,r[5]=c*o-n*f,r[6]=c*h-d*l,r[7]=d*i-n*h,r[8]=n*l-c*i;var m=1/y;return s.multiplyByScalar(r,m,r)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(i,0)}o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(t,n){return e.typeOf.object("color",t),r(n)?(n.x=t.red,n.y=t.green,n.z=t.blue,n.w=t.alpha,n):new o(t.red,t.green,t.blue,t.alpha)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i++]=r.y,n[i++]=r.z,n[i]=r.w,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=4*i:n=new Array(4*i);for(var a=0;a<i;++a)o.pack(t[a],n,4*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/4:n=new Array(i/4);for(var a=0;a<i;a+=4){var u=a/4;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y,t.z,t.w)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y,t.z,t.w)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n.z=Math.min(t.z,r.z),n.w=Math.min(t.w,r.w),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n.z=Math.max(t.z,r.z),n.w=Math.max(t.w,r.w),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y+t.z*t.z+t.w*t.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitude(u)},o.distanceSquared=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.subtract(t,r,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,r.z=t.z/i,r.w=t.w/i,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y+t.z*r.z+t.w*r.w},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n.z=t.z*r.z,n.w=t.w*r.w,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n.z=t.z/r.z,n.w=t.w/r.w,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n.z=t.z+r.z,n.w=t.w+r.w,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n.z=t.z-r.z,n.w=t.w-r.w,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n.z=t.z*r,n.w=t.w*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n.z=t.z/r,n.w=t.w/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r.z=-t.z,r.w=-t.w,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r.z=Math.abs(t.z),r.w=Math.abs(t.w),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,c);return o.abs(n,n),r=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,r):o.clone(o.UNIT_W,r):n.z<=n.w?o.clone(o.UNIT_Z,r):o.clone(o.UNIT_W,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)&&a.equalsEpsilon(e.z,t.z,n,i)&&a.equalsEpsilon(e.w,t.w,n,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(e,t,r,i,a,o,u,s,c,l,f,d,h,p,y,m){this[0]=n(e,0),this[1]=n(a,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(p,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(f,0),this[11]=n(y,0),this[12]=n(i,0),this[13]=n(s,0),this[14]=n(d,0),this[15]=n(m,0)}l.packedLength=16,l.pack=function(e,t,i){return r.typeOf.object("value",e),r.defined("array",t),i=n(i,0),t[i++]=e[0],t[i++]=e[1],t[i++]=e[2],t[i++]=e[3],t[i++]=e[4],t[i++]=e[5],t[i++]=e[6],t[i++]=e[7],t[i++]=e[8],t[i++]=e[9],t[i++]=e[10],t[i++]=e[11],t[i++]=e[12],t[i++]=e[13],t[i++]=e[14],t[i]=e[15],t},l.unpack=function(e,t,a){return r.defined("array",e),t=n(t,0),i(a)||(a=new l),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a[9]=e[t++],a[10]=e[t++],a[11]=e[t++],a[12]=e[t++],a[13]=e[t++],a[14]=e[t++],a[15]=e[t],a},l.clone=function(e,t){if(i(e))return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){return r.defined("values",e),l.clone(e,t)},l.fromRowMajorArray=function(e,t){return r.defined("values",e),i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,a,o){return r.typeOf.object("rotation",t),a=n(a,e.ZERO),i(o)?(o[0]=t[0],o[1]=t[1],o[2]=t[2],o[3]=0,o[4]=t[3],o[5]=t[4],o[6]=t[5],o[7]=0,o[8]=t[6],o[9]=t[7],o[10]=t[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new l(t[0],t[3],t[6],a.x,t[1],t[4],t[7],a.y,t[2],t[5],t[8],a.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,n,a){r.typeOf.object("translation",e),r.typeOf.object("rotation",t),r.typeOf.object("scale",n),i(a)||(a=new l);var o=n.x,u=n.y,s=n.z,c=t.x*t.x,f=t.x*t.y,d=t.x*t.z,h=t.x*t.w,p=t.y*t.y,y=t.y*t.z,m=t.y*t.w,E=t.z*t.z,w=t.z*t.w,_=t.w*t.w,O=c-p-E+_,T=2*(f-w),v=2*(d+m),R=2*(f+w),A=-c+p-E+_,g=2*(y-h),b=2*(d-m),S=2*(y+h),N=-c-p+E+_;return a[0]=O*o,a[1]=R*o,a[2]=b*o,a[3]=0,a[4]=T*u,a[5]=A*u,a[6]=S*u,a[7]=0,a[8]=v*s,a[9]=g*s,a[10]=N*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},l.fromTranslationRotationScale=function(e,t){return r.typeOf.object("translationRotationScale",e),l.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},l.fromTranslation=function(e,t){return r.typeOf.object("translation",e),l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){return r.typeOf.object("scale",e),i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){return r.typeOf.number("scale",e),i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,d=new e,h=new e;l.fromCamera=function(t,n){r.typeOf.object("camera",t);var a=t.position,o=t.direction,u=t.up;r.typeOf.object("camera.position",a),r.typeOf.object("camera.direction",o),r.typeOf.object("camera.up",u),e.normalize(o,f),e.normalize(e.cross(f,u,d),d),e.normalize(e.cross(d,f,h),h);var s=d.x,c=d.y,p=d.z,y=f.x,m=f.y,E=f.z,w=h.x,_=h.y,O=h.z,T=a.x,v=a.y,R=a.z,A=s*-T+c*-v+p*-R,g=w*-T+_*-v+O*-R,b=y*T+m*v+E*R;return i(n)?(n[0]=s,n[1]=w,n[2]=-y,n[3]=0,n[4]=c,n[5]=_,n[6]=-m,n[7]=0,n[8]=p,n[9]=O,n[10]=-E,n[11]=0,n[12]=A,n[13]=g,n[14]=b,n[15]=1,n):new l(s,c,p,A,w,_,O,g,-y,-m,-E,b,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,n,i,a){r.typeOf.number.greaterThan("fovY",e,0),r.typeOf.number.lessThan("fovY",e,Math.PI),r.typeOf.number.greaterThan("near",n,0),r.typeOf.number.greaterThan("far",i,0),r.typeOf.object("result",a);var o=Math.tan(.5*e),u=1/o,s=u/t,c=(i+n)/(n-i),l=2*i*n/(n-i);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},l.computeOrthographicOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=1/(t-e),c=1/(i-n),l=1/(o-a),f=-(t+e)*s,d=-(i+n)*c,h=-(o+a)*l;return s*=2,c*=2,l*=-2,u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=l,u[11]=0,u[12]=f,u[13]=d,u[14]=h,u[15]=1,u},l.computePerspectiveOffCenter=function(e,t,n,i,a,o,u){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.number("far",o),r.typeOf.object("result",u);var s=2*a/(t-e),c=2*a/(i-n),l=(t+e)/(t-e),f=(i+n)/(i-n),d=-(o+a)/(o-a),h=-1,p=-2*o*a/(o-a);return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=l,u[9]=f,u[10]=d,u[11]=h,u[12]=0,u[13]=0,u[14]=p,u[15]=0,u},l.computeInfinitePerspectiveOffCenter=function(e,t,n,i,a,o){r.typeOf.number("left",e),r.typeOf.number("right",t),r.typeOf.number("bottom",n),r.typeOf.number("top",i),r.typeOf.number("near",a),r.typeOf.object("result",o);var u=2*a/(t-e),s=2*a/(i-n),c=(t+e)/(t-e),l=(i+n)/(i-n),f=-1,d=-1,h=-2*a;return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=d,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},l.computeViewportTransformation=function(e,t,i,a){r.typeOf.object("result",a),e=n(e,n.EMPTY_OBJECT);var o=n(e.x,0),u=n(e.y,0),s=n(e.width,0),c=n(e.height,0);t=n(t,0),i=n(i,1);var l=.5*s,f=.5*c,d=.5*(i-t),h=l,p=f,y=d,m=o+l,E=u+f,w=t+d,_=1;return a[0]=h,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=p,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=y,a[11]=0,a[12]=m,a[13]=E,a[14]=w,a[15]=_,a},l.computeView=function(t,n,i,a,o){return r.typeOf.object("position",t),r.typeOf.object("direction",n),r.typeOf.object("up",i),r.typeOf.object("right",a),r.typeOf.object("result",o),o[0]=a.x,o[1]=i.x,o[2]=-n.x,o[3]=0,o[4]=a.y,o[5]=i.y,o[6]=-n.y,o[7]=0,o[8]=a.z,o[9]=i.z,o[10]=-n.z,o[11]=0,o[12]=-e.dot(a,t),o[13]=-e.dot(i,t),o[14]=e.dot(n,t),o[15]=1,o},l.toArray=function(e,t){return r.typeOf.object("matrix",e),i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){return r.typeOf.number.greaterThanOrEquals("row",t,0),r.typeOf.number.lessThanOrEquals("row",t,3),r.typeOf.number.greaterThanOrEquals("column",e,0),r.typeOf.number.lessThanOrEquals("column",e,3),4*e+t},l.getColumn=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=4*t,a=e[i],o=e[i+1],u=e[i+2],s=e[i+3];return n.x=a,n.y=o,n.z=u,n.w=s,n},l.setColumn=function(e,t,n,i){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=l.clone(e,i);var a=4*t;return i[a]=n.x,i[a+1]=n.y,i[a+2]=n.z,i[a+3]=n.w,i},l.setTranslation=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},l.getRow=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("result",n);var i=e[t],a=e[t+4],o=e[t+8],u=e[t+12];return n.x=i,n.y=a,n.z=o,n.w=u,n},l.setRow=function(e,t,n,i){return r.typeOf.object("matrix",e),r.typeOf.number.greaterThanOrEquals("index",t,0),r.typeOf.number.lessThanOrEquals("index",t,3),r.typeOf.object("cartesian",n),r.typeOf.object("result",i),i=l.clone(e,i),i[t]=n.x,i[t+4]=n.y,i[t+8]=n.z,i[t+12]=n.w,i};var p=new e;l.getScale=function(t,n){return r.typeOf.object("matrix",t),r.typeOf.object("result",n),n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],p)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],p)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],p)),n};var y=new e;l.getMaximumScale=function(t){return l.getScale(t,y),e.maximumComponent(y)},l.multiply=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[3],s=e[4],c=e[5],l=e[6],f=e[7],d=e[8],h=e[9],p=e[10],y=e[11],m=e[12],E=e[13],w=e[14],_=e[15],O=t[0],T=t[1],v=t[2],R=t[3],A=t[4],g=t[5],b=t[6],S=t[7],N=t[8],I=t[9],x=t[10],M=t[11],P=t[12],C=t[13],D=t[14],L=t[15],U=i*O+s*T+d*v+m*R,F=a*O+c*T+h*v+E*R,q=o*O+l*T+p*v+w*R,z=u*O+f*T+y*v+_*R,B=i*A+s*g+d*b+m*S,j=a*A+c*g+h*b+E*S,G=o*A+l*g+p*b+w*S,V=u*A+f*g+y*b+_*S,W=i*N+s*I+d*x+m*M,X=a*N+c*I+h*x+E*M,H=o*N+l*I+p*x+w*M,Y=u*N+f*I+y*x+_*M,k=i*P+s*C+d*D+m*L,Z=a*P+c*C+h*D+E*L,K=o*P+l*C+p*D+w*L,J=u*P+f*C+y*D+_*L;return n[0]=U,n[1]=F,n[2]=q,n[3]=z,n[4]=B,n[5]=j,n[6]=G,n[7]=V,n[8]=W,n[9]=X,n[10]=H,n[11]=Y,n[12]=k,n[13]=Z,n[14]=K,n[15]=J,n},l.add=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},l.subtract=function(e,t,n){return r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n),n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},l.multiplyTransformation=function(e,t,n){r.typeOf.object("left",e),r.typeOf.object("right",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],d=e[10],h=e[12],p=e[13],y=e[14],m=t[0],E=t[1],w=t[2],_=t[4],O=t[5],T=t[6],v=t[8],R=t[9],A=t[10],g=t[12],b=t[13],S=t[14],N=i*m+u*E+l*w,I=a*m+s*E+f*w,x=o*m+c*E+d*w,M=i*_+u*O+l*T,P=a*_+s*O+f*T,C=o*_+c*O+d*T,D=i*v+u*R+l*A,L=a*v+s*R+f*A,U=o*v+c*R+d*A,F=i*g+u*b+l*S+h,q=a*g+s*b+f*S+p,z=o*g+c*b+d*S+y;return n[0]=N,n[1]=I,n[2]=x,n[3]=0,n[4]=M,n[5]=P,n[6]=C,n[7]=0,n[8]=D,n[9]=L,n[10]=U,n[11]=0,n[12]=F,n[13]=q,n[14]=z,n[15]=1,n},l.multiplyByMatrix3=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("rotation",t),r.typeOf.object("result",n);var i=e[0],a=e[1],o=e[2],u=e[4],s=e[5],c=e[6],l=e[8],f=e[9],d=e[10],h=t[0],p=t[1],y=t[2],m=t[3],E=t[4],w=t[5],_=t[6],O=t[7],T=t[8],v=i*h+u*p+l*y,R=a*h+s*p+f*y,A=o*h+c*p+d*y,g=i*m+u*E+l*w,b=a*m+s*E+f*w,S=o*m+c*E+d*w,N=i*_+u*O+l*T,I=a*_+s*O+f*T,x=o*_+c*O+d*T;return n[0]=v,n[1]=R,n[2]=A,n[3]=0,n[4]=g,n[5]=b,n[6]=S,n[7]=0,n[8]=N,n[9]=I,n[10]=x,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},l.multiplyByTranslation=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("translation",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=i*e[0]+a*e[4]+o*e[8]+e[12],s=i*e[1]+a*e[5]+o*e[9]+e[13],c=i*e[2]+a*e[6]+o*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=u,n[13]=s,n[14]=c,n[15]=e[15],n};var m=new e;l.multiplyByUniformScale=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scale",t),r.typeOf.object("result",n),m.x=t,m.y=t,m.z=t,l.multiplyByScale(e,m,n)},l.multiplyByScale=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("scale",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z;return 1===i&&1===a&&1===o?l.clone(e,n):(n[0]=i*e[0],n[1]=i*e[1],n[2]=i*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=o*e[8],n[9]=o*e[9],n[10]=o*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},l.multiplyByVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=t.w,s=e[0]*i+e[4]*a+e[8]*o+e[12]*u,c=e[1]*i+e[5]*a+e[9]*o+e[13]*u,l=e[2]*i+e[6]*a+e[10]*o+e[14]*u,f=e[3]*i+e[7]*a+e[11]*o+e[15]*u;return n.x=s,n.y=c,n.z=l,n.w=f,n},l.multiplyByPointAsVector=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o,s=e[1]*i+e[5]*a+e[9]*o,c=e[2]*i+e[6]*a+e[10]*o;return n.x=u,n.y=s,n.z=c,n},l.multiplyByPoint=function(e,t,n){r.typeOf.object("matrix",e),r.typeOf.object("cartesian",t),r.typeOf.object("result",n);var i=t.x,a=t.y,o=t.z,u=e[0]*i+e[4]*a+e[8]*o+e[12],s=e[1]*i+e[5]*a+e[9]*o+e[13],c=e[2]*i+e[6]*a+e[10]*o+e[14];return n.x=u,n.y=s,n.z=c,n},l.multiplyByScalar=function(e,t,n){return r.typeOf.object("matrix",e),r.typeOf.number("scalar",t),r.typeOf.object("result",n),n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},l.negate=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[1],i=e[2],a=e[3],o=e[6],u=e[7],s=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=i,t[9]=o,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=s,t[15]=e[15],t},l.abs=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,n){return r.typeOf.number("epsilon",n),e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},l.getTranslation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){return r.typeOf.object("matrix",e),r.typeOf.object("result",t),t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var E=new s,w=new s,_=new t,O=new t(0,0,0,1);return l.inverse=function(e,n){if(r.typeOf.object("matrix",e),r.typeOf.object("result",n),s.equalsEpsilon(l.getRotation(e,E),w,u.EPSILON7)&&t.equals(l.getRow(e,3,_),O))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var i=e[0],a=e[4],o=e[8],f=e[12],d=e[1],h=e[5],p=e[9],y=e[13],m=e[2],T=e[6],v=e[10],R=e[14],A=e[3],g=e[7],b=e[11],S=e[15],N=v*S,I=R*b,x=T*S,M=R*g,P=T*b,C=v*g,D=m*S,L=R*A,U=m*b,F=v*A,q=m*g,z=T*A,B=N*h+M*p+P*y-(I*h+x*p+C*y),j=I*d+D*p+F*y-(N*d+L*p+U*y),G=x*d+L*h+q*y-(M*d+D*h+z*y),V=C*d+U*h+z*p-(P*d+F*h+q*p),W=I*a+x*o+C*f-(N*a+M*o+P*f),X=N*i+L*o+U*f-(I*i+D*o+F*f),H=M*i+D*a+z*f-(x*i+L*a+q*f),Y=P*i+F*a+q*o-(C*i+U*a+z*o);N=o*y,I=f*p,x=a*y,M=f*h,P=a*p,C=o*h,D=i*y,L=f*d,U=i*p,F=o*d,q=i*h,z=a*d;var k=N*g+M*b+P*S-(I*g+x*b+C*S),Z=I*A+D*b+F*S-(N*A+L*b+U*S),K=x*A+L*g+q*S-(M*A+D*g+z*S),J=C*A+U*g+z*b-(P*A+F*g+q*b),Q=x*v+C*R+I*T-(P*R+N*T+M*v),$=U*R+N*m+L*v-(D*v+F*R+I*m),ee=D*T+z*R+M*m-(q*R+x*m+L*T),te=q*v+P*m+F*T-(U*T+z*v+C*m),re=i*B+a*j+o*G+f*V;if(Math.abs(re)<u.EPSILON20)throw new c("matrix is not invertible because its determinate is zero.");return re=1/re,n[0]=B*re,n[1]=j*re,n[2]=G*re,n[3]=V*re,n[4]=W*re,n[5]=X*re,n[6]=H*re,n[7]=Y*re,n[8]=k*re,n[9]=Z*re,n[10]=K*re,n[11]=J*re,n[12]=Q*re,n[13]=$*re,n[14]=ee*re,n[15]=te*re,n},l.inverseTransformation=function(e,t){r.typeOf.object("matrix",e),r.typeOf.object("result",t);var n=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],d=e[12],h=e[13],p=e[14],y=-n*d-i*h-a*p,m=-o*d-u*h-s*p,E=-c*d-l*h-f*p;return t[0]=n,t[1]=o,t[2]=c,t[3]=0,t[4]=i,t[5]=u,t[6]=l,t[7]=0,t[8]=a,t[9]=s,t[10]=f,t[11]=0,t[12]=y,t[13]=m,t[14]=E,t[15]=1,t},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=o(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,a(l.prototype,{length:{get:function(){return l.packedLength}}}),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,i,a,o,u){"use strict";function s(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)}i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.west,n[i++]=e.south,n[i++]=e.east,n[i]=e.north,n},s.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new s),a.west=e[i++],a.south=e[i++],a.east=e[i++],a.north=e[i],a},s.computeWidth=function(e){t.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){return t.typeOf.object("rectangle",e),e.north-e.south},s.fromDegrees=function(e,t,i,a,o){return e=u.toRadians(r(e,0)),t=u.toRadians(r(t,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),n(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new s(e,t,i,a)},s.fromRadians=function(e,t,i,a,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(i,0),o.north=r(a,0),o):new s(e,t,i,a)},s.fromCartographicArray=function(e,r){t.defined("cartographics",e);for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,c=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,d=0,h=e.length;d<h;d++){var p=e[d];i=Math.min(i,p.longitude),a=Math.max(a,p.longitude),l=Math.min(l,p.latitude),f=Math.max(f,p.latitude);var y=p.longitude>=0?p.longitude:p.longitude+u.TWO_PI;o=Math.min(o,y),c=Math.max(c,y)}return a-i>c-o&&(i=o,a=c,a>u.PI&&(a-=u.TWO_PI),i>u.PI&&(i-=u.TWO_PI)),n(r)?(r.west=i,r.south=l,r.east=a,r.north=f,r):new s(i,l,a,f)},s.fromCartesianArray=function(e,r,i){t.defined("cartesians",e);for(var a=Number.MAX_VALUE,o=-Number.MAX_VALUE,c=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=Number.MAX_VALUE,d=-Number.MAX_VALUE,h=0,p=e.length;h<p;h++){var y=r.cartesianToCartographic(e[h]);a=Math.min(a,y.longitude),o=Math.max(o,y.longitude),f=Math.min(f,y.latitude),d=Math.max(d,y.latitude);var m=y.longitude>=0?y.longitude:y.longitude+u.TWO_PI;c=Math.min(c,m),l=Math.max(l,m)}return o-a>l-c&&(a=c,o=l,o>u.PI&&(o-=u.TWO_PI),a>u.PI&&(a-=u.TWO_PI)),n(i)?(i.west=a,i.south=f,i.east=o,i.north=d,i):new s(a,f,o,d)},s.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new s(e.west,e.south,e.east,e.north)},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},s.prototype.equalsEpsilon=function(e,r){return t.typeOf.number("epsilon",r),n(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){t.typeOf.object("rectangle",e);var r=e.north;t.typeOf.number.greaterThanOrEquals("north",r,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("north",r,u.PI_OVER_TWO);var n=e.south;t.typeOf.number.greaterThanOrEquals("south",n,-u.PI_OVER_TWO),t.typeOf.number.lessThanOrEquals("south",n,u.PI_OVER_TWO);var i=e.west;t.typeOf.number.greaterThanOrEquals("west",i,-Math.PI),t.typeOf.number.lessThanOrEquals("west",i,Math.PI);var a=e.east;t.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),t.typeOf.number.lessThanOrEquals("east",a,Math.PI)},s.southwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){return t.typeOf.object("rectangle",r),n(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){t.typeOf.object("rectangle",r);var a=r.east,o=r.west;a<o&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),c=.5*(r.south+r.north);return n(i)?(i.longitude=s,i.latitude=c,i.height=0,i):new e(s,c)},s.intersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=e.east,o=e.west,c=r.east,l=r.west;a<o&&c>0?a+=u.TWO_PI:c<l&&a>0&&(c+=u.TWO_PI),a<o&&l<0?l+=u.TWO_PI:c<l&&o<0&&(o+=u.TWO_PI);var f=u.negativePiToPi(Math.max(o,l)),d=u.negativePiToPi(Math.min(a,c));if(!((e.west<e.east||r.west<r.east)&&d<=f)){var h=Math.max(e.south,r.south),p=Math.min(e.north,r.north);if(!(h>=p))return n(i)?(i.west=f,i.south=h,i.east=d,i.north=p,i):new s(f,h,d,p)}},s.simpleIntersection=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r);var a=Math.max(e.west,r.west),o=Math.max(e.south,r.south),u=Math.min(e.east,r.east),c=Math.min(e.north,r.north);if(!(o>=c||a>=u))return n(i)?(i.west=a,
i.south=o,i.east=u,i.north=c,i):new s(a,o,u,c)},s.union=function(e,r,i){t.typeOf.object("rectangle",e),t.typeOf.object("otherRectangle",r),n(i)||(i=new s);var a=e.east,o=e.west,c=r.east,l=r.west;a<o&&c>0?a+=u.TWO_PI:c<l&&a>0&&(c+=u.TWO_PI),a<o&&l<0?l+=u.TWO_PI:c<l&&o<0&&(o+=u.TWO_PI);var f=u.convertLongitudeRange(Math.min(o,l)),d=u.convertLongitudeRange(Math.max(a,c));return i.west=f,i.south=Math.min(e.south,r.south),i.east=d,i.north=Math.max(e.north,r.north),i},s.expand=function(e,r,i){return t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r),n(i)||(i=new s),i.west=Math.min(e.west,r.longitude),i.south=Math.min(e.south,r.latitude),i.east=Math.max(e.east,r.longitude),i.north=Math.max(e.north,r.latitude),i},s.contains=function(e,r){t.typeOf.object("rectangle",e),t.typeOf.object("cartographic",r);var n=r.longitude,i=r.latitude,a=e.west,o=e.east;return o<a&&(o+=u.TWO_PI,n<0&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(n<o||u.equalsEpsilon(n,o,u.EPSILON14))&&i>=e.south&&i<=e.north};var c=new e;return s.subsample=function(e,i,o,l){t.typeOf.object("rectangle",e),i=r(i,a.WGS84),o=r(o,0),n(l)||(l=[]);var f=0,d=e.north,h=e.south,p=e.east,y=e.west,m=c;m.height=o,m.longitude=y,m.latitude=d,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=p,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.latitude=h,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=y,l[f]=i.cartographicToCartesian(m,l[f]),f++,d<0?m.latitude=d:h>0?m.latitude=h:m.latitude=0;for(var E=1;E<8;++E)m.longitude=-Math.PI+E*u.PI_OVER_TWO,s.contains(e,m)&&(l[f]=i.cartographicToCartesian(m,l[f]),f++);return 0===m.latitude&&(m.longitude=y,l[f]=i.cartographicToCartesian(m,l[f]),f++,m.longitude=p,l[f]=i.cartographicToCartesian(m,l[f]),f++),l.length=f,l},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,i,a,o,u,s,c,l,f){"use strict";function d(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var h=new e,p=new e,y=new e,m=new e,E=new e,w=new e,_=new e,O=new e,T=new e,v=new e,R=new e,A=new e;d.fromPoints=function(t,r){if(i(r)||(r=new d),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var n=e.clone(t[0],_),a=e.clone(n,h),o=e.clone(n,p),u=e.clone(n,y),s=e.clone(n,m),c=e.clone(n,E),l=e.clone(n,w),f=t.length,g=1;g<f;g++){e.clone(t[g],n);var b=n.x,S=n.y,N=n.z;b<a.x&&e.clone(n,a),b>s.x&&e.clone(n,s),S<o.y&&e.clone(n,o),S>c.y&&e.clone(n,c),N<u.z&&e.clone(n,u),N>l.z&&e.clone(n,l)}var I=e.magnitudeSquared(e.subtract(s,a,O)),x=e.magnitudeSquared(e.subtract(c,o,O)),M=e.magnitudeSquared(e.subtract(l,u,O)),P=a,C=s,D=I;x>D&&(D=x,P=o,C=c),M>D&&(D=M,P=u,C=l);var L=T;L.x=.5*(P.x+C.x),L.y=.5*(P.y+C.y),L.z=.5*(P.z+C.z);var U=e.magnitudeSquared(e.subtract(C,L,O)),F=Math.sqrt(U),q=v;q.x=a.x,q.y=o.y,q.z=u.z;var z=R;z.x=s.x,z.y=c.y,z.z=l.z;var B=e.multiplyByScalar(e.add(q,z,O),.5,A),j=0;for(g=0;g<f;g++){e.clone(t[g],n);var G=e.magnitude(e.subtract(n,B,O));G>j&&(j=G);var V=e.magnitudeSquared(e.subtract(n,L,O));if(V>U){var W=Math.sqrt(V);F=.5*(F+W),U=F*F;var X=W-F;L.x=(F*L.x+X*n.x)/W,L.y=(F*L.y+X*n.y)/W,L.z=(F*L.z+X*n.z)/W}}return F<j?(e.clone(L,r.center),r.radius=F):(e.clone(B,r.center),r.radius=j),r};var g=new o,b=new e,S=new e,N=new t,I=new t;d.fromRectangle2D=function(e,t,r){return d.fromRectangleWithHeights2D(e,t,0,0,r)},d.fromRectangleWithHeights2D=function(t,r,a,o,u){if(i(u)||(u=new d),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,g),f.southwest(t,N),N.height=a,f.northeast(t,I),I.height=o;var s=r.project(N,b),c=r.project(I,S),l=c.x-s.x,h=c.y-s.y,p=c.z-s.z;u.radius=.5*Math.sqrt(l*l+h*h+p*p);var y=u.center;return y.x=s.x+.5*l,y.y=s.y+.5*h,y.z=s.z+.5*p,u};var x=[];d.fromRectangle3D=function(e,t,r,o){t=n(t,a.WGS84),r=n(r,0);var u;return i(e)&&(u=f.subsample(e,t,r,x)),d.fromPoints(u,o)},d.fromVertices=function(t,a,o,u){if(i(u)||(u=new d),!i(t)||0===t.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;a=n(a,e.ZERO),o=n(o,3),r.typeOf.number.greaterThanOrEquals("stride",o,3);var s=_;s.x=t[0]+a.x,s.y=t[1]+a.y,s.z=t[2]+a.z;for(var c=e.clone(s,h),l=e.clone(s,p),f=e.clone(s,y),g=e.clone(s,m),b=e.clone(s,E),S=e.clone(s,w),N=t.length,I=0;I<N;I+=o){var x=t[I]+a.x,M=t[I+1]+a.y,P=t[I+2]+a.z;s.x=x,s.y=M,s.z=P,x<c.x&&e.clone(s,c),x>g.x&&e.clone(s,g),M<l.y&&e.clone(s,l),M>b.y&&e.clone(s,b),P<f.z&&e.clone(s,f),P>S.z&&e.clone(s,S)}var C=e.magnitudeSquared(e.subtract(g,c,O)),D=e.magnitudeSquared(e.subtract(b,l,O)),L=e.magnitudeSquared(e.subtract(S,f,O)),U=c,F=g,q=C;D>q&&(q=D,U=l,F=b),L>q&&(q=L,U=f,F=S);var z=T;z.x=.5*(U.x+F.x),z.y=.5*(U.y+F.y),z.z=.5*(U.z+F.z);var B=e.magnitudeSquared(e.subtract(F,z,O)),j=Math.sqrt(B),G=v;G.x=c.x,G.y=l.y,G.z=f.z;var V=R;V.x=g.x,V.y=b.y,V.z=S.z;var W=e.multiplyByScalar(e.add(G,V,O),.5,A),X=0;for(I=0;I<N;I+=o){s.x=t[I]+a.x,s.y=t[I+1]+a.y,s.z=t[I+2]+a.z;var H=e.magnitude(e.subtract(s,W,O));H>X&&(X=H);var Y=e.magnitudeSquared(e.subtract(s,z,O));if(Y>B){var k=Math.sqrt(Y);j=.5*(j+k),B=j*j;var Z=k-j;z.x=(j*z.x+Z*s.x)/k,z.y=(j*z.y+Z*s.y)/k,z.z=(j*z.z+Z*s.z)/k}}return j<X?(e.clone(z,u.center),u.radius=j):(e.clone(W,u.center),u.radius=X),u},d.fromEncodedCartesianVertices=function(t,r,n){if(i(n)||(n=new d),!i(t)||!i(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var a=_;a.x=t[0]+r[0],a.y=t[1]+r[1],a.z=t[2]+r[2];for(var o=e.clone(a,h),u=e.clone(a,p),s=e.clone(a,y),c=e.clone(a,m),l=e.clone(a,E),f=e.clone(a,w),g=t.length,b=0;b<g;b+=3){var S=t[b]+r[b],N=t[b+1]+r[b+1],I=t[b+2]+r[b+2];a.x=S,a.y=N,a.z=I,S<o.x&&e.clone(a,o),S>c.x&&e.clone(a,c),N<u.y&&e.clone(a,u),N>l.y&&e.clone(a,l),I<s.z&&e.clone(a,s),I>f.z&&e.clone(a,f)}var x=e.magnitudeSquared(e.subtract(c,o,O)),M=e.magnitudeSquared(e.subtract(l,u,O)),P=e.magnitudeSquared(e.subtract(f,s,O)),C=o,D=c,L=x;M>L&&(L=M,C=u,D=l),P>L&&(L=P,C=s,D=f);var U=T;U.x=.5*(C.x+D.x),U.y=.5*(C.y+D.y),U.z=.5*(C.z+D.z);var F=e.magnitudeSquared(e.subtract(D,U,O)),q=Math.sqrt(F),z=v;z.x=o.x,z.y=u.y,z.z=s.z;var B=R;B.x=c.x,B.y=l.y,B.z=f.z;var j=e.multiplyByScalar(e.add(z,B,O),.5,A),G=0;for(b=0;b<g;b+=3){a.x=t[b]+r[b],a.y=t[b+1]+r[b+1],a.z=t[b+2]+r[b+2];var V=e.magnitude(e.subtract(a,j,O));V>G&&(G=V);var W=e.magnitudeSquared(e.subtract(a,U,O));if(W>F){var X=Math.sqrt(W);q=.5*(q+X),F=q*q;var H=X-q;U.x=(q*U.x+H*a.x)/X,U.y=(q*U.y+H*a.y)/X,U.z=(q*U.z+H*a.z)/X}}return q<G?(e.clone(U,n.center),n.radius=q):(e.clone(j,n.center),n.radius=G),n},d.fromCornerPoints=function(t,n,a){r.typeOf.object("corner",t),r.typeOf.object("oppositeCorner",n),i(a)||(a=new d);var o=a.center;return e.add(t,n,o),e.multiplyByScalar(o,.5,o),a.radius=e.distance(o,n),a},d.fromEllipsoid=function(t,n){return r.typeOf.object("ellipsoid",t),i(n)||(n=new d),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var M=new e;d.fromBoundingSpheres=function(t,r){if(i(r)||(r=new d),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return d.clone(t[0],r);if(2===n)return d.union(t[0],t[1],r);for(var a=[],o=0;o<n;o++)a.push(t[o].center);r=d.fromPoints(a,r);var u=r.center,s=r.radius;for(o=0;o<n;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,M)+c.radius)}return r.radius=s,r};var P=new e,C=new e,D=new e;d.fromOrientedBoundingBox=function(t,r){i(r)||(r=new d);var n=t.halfAxes,a=c.getColumn(n,0,P),o=c.getColumn(n,1,C),u=c.getColumn(n,2,D),s=e.magnitude(a),l=e.magnitude(o),f=e.magnitude(u);return r.center=e.clone(t.center,r.center),r.radius=Math.max(s,l,f),r},d.clone=function(t,r){if(i(t))return i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new d(t.center,t.radius)},d.packedLength=4,d.pack=function(e,t,i){r.typeOf.object("value",e),r.defined("array",t),i=n(i,0);var a=e.center;return t[i++]=a.x,t[i++]=a.y,t[i++]=a.z,t[i]=e.radius,t},d.unpack=function(e,t,a){r.defined("array",e),t=n(t,0),i(a)||(a=new d);var o=a.center;return o.x=e[t++],o.y=e[t++],o.z=e[t++],a.radius=e[t],a};var L=new e,U=new e;d.union=function(t,n,a){r.typeOf.object("left",t),r.typeOf.object("right",n),i(a)||(a=new d);var o=t.center,u=t.radius,s=n.center,c=n.radius,l=e.subtract(s,o,L),f=e.magnitude(l);if(u>=f+c)return t.clone(a),a;if(c>=f+u)return n.clone(a),a;var h=.5*(u+f+c),p=e.multiplyByScalar(l,(-u+h)/f,U);return e.add(p,o,p),e.clone(p,a.center),a.radius=h,a};var F=new e;d.expand=function(t,n,i){r.typeOf.object("sphere",t),r.typeOf.object("point",n),i=d.clone(t,i);var a=e.magnitude(e.subtract(n,i.center,F));return a>i.radius&&(i.radius=a),i},d.intersectPlane=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("plane",n);var i=t.center,a=t.radius,o=n.normal,s=e.dot(o,i)+n.distance;return s<-a?u.OUTSIDE:s<a?u.INTERSECTING:u.INSIDE},d.transform=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var q=new e;d.distanceSquaredTo=function(t,n){r.typeOf.object("sphere",t),r.typeOf.object("cartesian",n);var i=e.subtract(t.center,n,q);return e.magnitudeSquared(i)-t.radius*t.radius},d.transformWithoutScale=function(e,t,n){return r.typeOf.object("sphere",e),r.typeOf.object("transform",t),i(n)||(n=new d),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var z=new e;d.computePlaneDistances=function(t,n,a,o){r.typeOf.object("sphere",t),r.typeOf.object("position",n),r.typeOf.object("direction",a),i(o)||(o=new s);var u=e.subtract(t.center,n,z),c=e.dot(a,u);return o.start=c-t.radius,o.stop=c+t.radius,o};for(var B=new e,j=new e,G=new e,V=new e,W=new e,X=new t,H=new Array(8),Y=0;Y<8;++Y)H[Y]=new e;var k=new o;return d.projectTo2D=function(t,i,a){r.typeOf.object("sphere",t),i=n(i,k);var o=i.ellipsoid,u=t.center,s=t.radius,c=o.geodeticSurfaceNormal(u,B),l=e.cross(e.UNIT_Z,c,j);e.normalize(l,l);var f=e.cross(c,l,G);e.normalize(f,f),e.multiplyByScalar(c,s,c),e.multiplyByScalar(f,s,f),e.multiplyByScalar(l,s,l);var h=e.negate(f,W),p=e.negate(l,V),y=H,m=y[0];e.add(c,f,m),e.add(m,l,m),m=y[1],e.add(c,f,m),e.add(m,p,m),m=y[2],e.add(c,h,m),e.add(m,p,m),m=y[3],e.add(c,h,m),e.add(m,l,m),e.negate(c,c),m=y[4],e.add(c,f,m),e.add(m,l,m),m=y[5],e.add(c,f,m),e.add(m,p,m),m=y[6],e.add(c,h,m),e.add(m,p,m),m=y[7],e.add(c,h,m),e.add(m,l,m);for(var E=y.length,w=0;w<E;++w){var _=y[w];e.add(u,_,_);var O=o.cartesianToCartographic(_,X);i.project(O,_)}a=d.fromPoints(y,a),u=a.center;var T=u.x,v=u.y,R=u.z;return u.x=R,u.y=T,u.z=v,a},d.isOccluded=function(e,t){return r.typeOf.object("sphere",e),r.typeOf.object("occluder",t),!t.isBoundingSphereVisible(e)},d.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,t,r){return d.computePlaneDistances(this,e,t,r)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,i,a){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(r,n,i){return e.typeOf.object("value",r),e.defined("array",n),i=t(i,0),n[i++]=r.x,n[i]=r.y,n},o.unpack=function(n,i,a){return e.defined("array",n),i=t(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.packArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=2*i:n=new Array(2*i);for(var a=0;a<i;++a)o.pack(t[a],n,2*a);return n},o.unpackArray=function(t,n){e.defined("array",t);var i=t.length;r(n)?n.length=i/2:n=new Array(i/2);for(var a=0;a<i;a+=2){var u=a/2;n[u]=o.unpack(t,a,n[u])}return n},o.fromArray=o.unpack,o.maximumComponent=function(t){return e.typeOf.object("cartesian",t),Math.max(t.x,t.y)},o.minimumComponent=function(t){return e.typeOf.object("cartesian",t),Math.min(t.x,t.y)},o.minimumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.min(t.x,r.x),n.y=Math.min(t.y,r.y),n},o.maximumByComponent=function(t,r,n){return e.typeOf.object("first",t),e.typeOf.object("second",r),e.typeOf.object("result",n),n.x=Math.max(t.x,r.x),n.y=Math.max(t.y,r.y),n},o.magnitudeSquared=function(t){return e.typeOf.object("cartesian",t),t.x*t.x+t.y*t.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){if(!r(e)||!r(t))throw new n("left and right are required.");return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){if(!r(e)||!r(t))throw new n("left and right are required.");return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var i=o.magnitude(t);if(r.x=t.x/i,r.y=t.y/i,isNaN(r.x)||isNaN(r.y))throw new n("normalized result is not a number");return r},o.dot=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),t.x*r.x+t.y*r.y},o.multiplyComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x*r.x,n.y=t.y*r.y,n},o.divideComponents=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x/r.x,n.y=t.y/r.y,n},o.add=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x+r.x,n.y=t.y+r.y,n},o.subtract=function(t,r,n){return e.typeOf.object("left",t),e.typeOf.object("right",r),e.typeOf.object("result",n),n.x=t.x-r.x,n.y=t.y-r.y,n},o.multiplyByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x*r,n.y=t.y*r,n},o.divideByScalar=function(t,r,n){return e.typeOf.object("cartesian",t),e.typeOf.number("scalar",r),e.typeOf.object("result",n),n.x=t.x/r,n.y=t.y/r,n},o.negate=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=-t.x,r.y=-t.y,r},o.abs=function(t,r){return e.typeOf.object("cartesian",t),e.typeOf.object("result",r),r.x=Math.abs(t.x),r.y=Math.abs(t.y),r};var s=new o;o.lerp=function(t,r,n,i){return e.typeOf.object("start",t),e.typeOf.object("end",r),e.typeOf.number("t",n),e.typeOf.object("result",i),o.multiplyByScalar(r,n,s),i=o.multiplyByScalar(t,1-n,i),o.add(s,i,i)};var c=new o,l=new o;o.angleBetween=function(t,r){return e.typeOf.object("left",t),e.typeOf.object("right",r),o.normalize(t,c),o.normalize(r,l),a.acosClamped(o.dot(c,l))};var f=new o;return o.mostOrthogonalAxis=function(t,r){e.typeOf.object("cartesian",t),e.typeOf.object("result",r);var n=o.normalize(t,f);return o.abs(n,n),r=n.x<=n.y?o.clone(o.UNIT_X,r):o.clone(o.UNIT_Y,r)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,i){return e===t||r(e)&&r(t)&&a.equalsEpsilon(e.x,t.x,n,i)&&a.equalsEpsilon(e.y,t.y,n,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(i.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(i.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(i.supportsFullscreen())return null!==i.element}}}),i.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;o<u;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(n.requestFullscreen=i,r=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(n.requestFullscreen=i,r=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?n.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(n.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return r},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function i(){if(!t(T)&&(T=!1,!d())){var e=/ Chrome\/([\.0-9]+)/.exec(O.userAgent);null!==e&&(T=!0,v=n(e[1]))}return T}function a(){return i()&&v}function o(){if(!t(R)&&(R=!1,!i()&&!d()&&/ Safari\/[\.0-9]+/.test(O.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(O.userAgent);null!==e&&(R=!0,A=n(e[1]))}return R}function u(){return o()&&A}function s(){if(!t(g)){g=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(O.userAgent);null!==e&&(g=!0,b=n(e[1]),b.isNightly=!!e[2])}return g}function c(){return s()&&b}function l(){if(!t(S)){S=!1;var e;"Microsoft Internet Explorer"===O.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(O.userAgent),null!==e&&(S=!0,N=n(e[1]))):"Netscape"===O.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(O.userAgent),null!==e&&(S=!0,N=n(e[1])))}return S}function f(){return l()&&N}function d(){if(!t(I)){I=!1;var e=/ Edge\/([\.0-9]+)/.exec(O.userAgent);null!==e&&(I=!0,x=n(e[1]))}return I}function h(){return d()&&x}function p(){if(!t(M)){M=!1;var e=/Firefox\/([\.0-9]+)/.exec(O.userAgent);null!==e&&(M=!0,P=n(e[1]))}return M}function y(){return t(C)||(C=/Windows/i.test(O.appVersion)),C}function m(){return p()&&P}function E(){return t(D)||(D="undefined"!=typeof PointerEvent&&(!t(O.pointerEnabled)||O.pointerEnabled)),D}function w(){if(!t(U)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;U=t(r)&&""!==r,U&&(L=r)}return U}function _(){return w()?L:void 0}var O;O="undefined"!=typeof navigator?navigator:{};var T,v,R,A,g,b,S,N,I,x,M,P,C,D,L,U,F={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isEdge:d,edgeVersion:h,isFirefox:p,firefoxVersion:m,isWindows:y,hardwareConcurrency:e(O.hardwareConcurrency,3),supportsPointerEvents:E,supportsImageRenderingPixelated:w,imageRenderingValue:_};return F.supportsFullscreen=function(){return r.supportsFullscreen()},F.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},F.supportsWebWorkers=function(){return"undefined"!=typeof Worker},F}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,
UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,i,a){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new r("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new r("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,n){if(!t(e))throw new r("componentDatatype is required.");if(!t(n))throw new r("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(n);case o.UNSIGNED_BYTE:return new Uint8Array(n);case o.SHORT:return new Int16Array(n);case o.UNSIGNED_SHORT:return new Uint16Array(n);case o.INT:return new Int32Array(n);case o.UNSIGNED_INT:return new Uint32Array(n);case o.FLOAT:return new Float32Array(n);case o.DOUBLE:return new Float64Array(n);default:throw new r("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(n,i,a,u){if(!t(n))throw new r("componentDatatype is required.");if(!t(i))throw new r("buffer is required.");switch(a=e(a,0),u=e(u,(i.byteLength-a)/o.getSizeInBytes(n)),n){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.INT:return new Int32Array(i,a,u);case o.UNSIGNED_INT:return new Uint32Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new r("componentDatatype is not a valid value.")}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE;default:throw new r("name is not a valid value.")}},i(o)}),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n,a){if(!t(n))throw new r("identifier is required.");t(i[n])||(i[n]=!0,console.warn(e(a,n)))}var i={};return n.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",n}),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],function(e,t,r){"use strict";function n(n,i){if(!e(n)||!e(i))throw new t("identifier and message are required.");r(n,i)}return n}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function i(t,r,n){this.heading=e(t,0),this.pitch=e(r,0),this.roll=e(n,0)}return i.fromQuaternion=function(e,n){if(!t(e))throw new r("quaternion is required");t(n)||(n=new i);var a=2*(e.w*e.y-e.z*e.x),o=1-2*(e.x*e.x+e.y*e.y),u=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),c=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(c,s),n.roll=Math.atan2(u,o),n.pitch=-Math.asin(a),n},i.fromDegrees=function(e,a,o,u){if(!t(e))throw new r("heading is required");if(!t(a))throw new r("pitch is required");if(!t(o))throw new r("roll is required");return t(u)||(u=new i),u.heading=e*n.RADIANS_PER_DEGREE,u.pitch=a*n.RADIANS_PER_DEGREE,u.roll=o*n.RADIANS_PER_DEGREE,u},i.clone=function(e,r){if(t(e))return t(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new i(e.heading,e.pitch,e.roll)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll},i.equalsEpsilon=function(e,r,i,a){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.heading,r.heading,i,a)&&n.equalsEpsilon(e.pitch,r.pitch,i,a)&&n.equalsEpsilon(e.roll,r.roll,i,a)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,r){return i.equalsEpsilon(this,e,t,r)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./deprecationWarning","./FeatureDetection","./freezeObject","./HeadingPitchRoll","./Math","./Matrix3"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)}var f=new e;l.fromAxisAngle=function(r,i,a){t.typeOf.object("axis",r),t.typeOf.number("angle",i);var o=i/2,u=Math.sin(o);f=e.normalize(r,f);var s=f.x*u,c=f.y*u,d=f.z*u,h=Math.cos(o);return n(a)?(a.x=s,a.y=c,a.z=d,a.w=h,a):new l(s,c,d,h)};var d=[1,2,0],h=new Array(3);l.fromRotationMatrix=function(e,r){t.typeOf.object("matrix",e);var i,a,o,u,s,f=e[c.COLUMN0ROW0],p=e[c.COLUMN1ROW1],y=e[c.COLUMN2ROW2],m=f+p+y;if(m>0)i=Math.sqrt(m+1),s=.5*i,i=.5/i,a=(e[c.COLUMN1ROW2]-e[c.COLUMN2ROW1])*i,o=(e[c.COLUMN2ROW0]-e[c.COLUMN0ROW2])*i,u=(e[c.COLUMN0ROW1]-e[c.COLUMN1ROW0])*i;else{var E=d,w=0;p>f&&(w=1),y>f&&y>p&&(w=2);var _=E[w],O=E[_];i=Math.sqrt(e[c.getElementIndex(w,w)]-e[c.getElementIndex(_,_)]-e[c.getElementIndex(O,O)]+1);var T=h;T[w]=.5*i,i=.5/i,s=(e[c.getElementIndex(O,_)]-e[c.getElementIndex(_,O)])*i,T[_]=(e[c.getElementIndex(_,w)]+e[c.getElementIndex(w,_)])*i,T[O]=(e[c.getElementIndex(O,w)]+e[c.getElementIndex(w,O)])*i,a=-T[0],o=-T[1],u=-T[2]}return n(r)?(r.x=a,r.y=o,r.z=u,r.w=s,r):new l(a,o,u,s)};var p=new l,y=new l,m=new l,E=new l;l.fromHeadingPitchRoll=function(r,n,a,o){r instanceof u?t.typeOf.object("headingPitchRoll",r):(t.typeOf.number(r,"heading"),t.typeOf.number(n,"pitch"),t.typeOf.number(a,"roll"));var s;return r instanceof u?(s=r,o=n):(i("Quaternion.fromHeadingPitchRoll(heading, pitch, roll,result)","The method was deprecated in Cesium 1.32 and will be removed in version 1.33. Use Quaternion.fromHeadingPitchRoll(hpr,result) where hpr is a HeadingPitchRoll"),s=new u(r,n,a)),E=l.fromAxisAngle(e.UNIT_X,s.roll,p),m=l.fromAxisAngle(e.UNIT_Y,-s.pitch,o),o=l.multiply(m,E,m),y=l.fromAxisAngle(e.UNIT_Z,-s.heading,p),l.multiply(y,o,o)};var w=new e,_=new e,O=new l,T=new l,v=new l;l.packedLength=4,l.pack=function(e,n,i){return t.typeOf.object("value",e),t.defined("array",n),i=r(i,0),n[i++]=e.x,n[i++]=e.y,n[i++]=e.z,n[i]=e.w,n},l.unpack=function(e,i,a){return t.defined("array",e),i=r(i,0),n(a)||(a=new l),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},l.packedInterpolationLength=3,l.convertPackedArrayForInterpolation=function(e,t,r,n){l.unpack(e,4*r,v),l.conjugate(v,v);for(var i=0,a=r-t+1;i<a;i++){var o=3*i;l.unpack(e,4*(t+i),O),l.multiply(O,v,O),O.w<0&&l.negate(O,O),l.computeAxis(O,w);var u=l.computeAngle(O);n[o]=w.x*u,n[o+1]=w.y*u,n[o+2]=w.z*u}},l.unpackInterpolationResult=function(t,r,i,a,o){n(o)||(o=new l),e.fromArray(t,0,_);var u=e.magnitude(_);return l.unpack(r,4*a,T),0===u?l.clone(l.IDENTITY,O):l.fromAxisAngle(_,u,O),l.multiply(O,T,o)},l.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new l(e.x,e.y,e.z,e.w)},l.conjugate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},l.magnitudeSquared=function(e){return t.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},l.magnitude=function(e){return Math.sqrt(l.magnitudeSquared(e))},l.normalize=function(e,r){t.typeOf.object("result",r);var n=1/l.magnitude(e),i=e.x*n,a=e.y*n,o=e.z*n,u=e.w*n;return r.x=i,r.y=a,r.z=o,r.w=u,r},l.inverse=function(e,r){t.typeOf.object("result",r);var n=l.magnitudeSquared(e);return r=l.conjugate(e,r),l.multiplyByScalar(r,1/n,r)},l.add=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},l.subtract=function(e,r,n){return t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},l.negate=function(e,r){return t.typeOf.object("quaternion",e),t.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},l.dot=function(e,r){return t.typeOf.object("left",e),t.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},l.multiply=function(e,r,n){t.typeOf.object("left",e),t.typeOf.object("right",r),t.typeOf.object("result",n);var i=e.x,a=e.y,o=e.z,u=e.w,s=r.x,c=r.y,l=r.z,f=r.w,d=u*s+i*f+a*l-o*c,h=u*c-i*l+a*f+o*s,p=u*l+i*c-a*s+o*f,y=u*f-i*s-a*c-o*l;return n.x=d,n.y=h,n.z=p,n.w=y,n},l.multiplyByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},l.divideByScalar=function(e,r,n){return t.typeOf.object("quaternion",e),t.typeOf.number("scalar",r),t.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},l.computeAxis=function(e,r){t.typeOf.object("quaternion",e),t.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<s.EPSILON6)return r.x=r.y=r.z=0,r;var i=1/Math.sqrt(1-n*n);return r.x=e.x*i,r.y=e.y*i,r.z=e.z*i,r},l.computeAngle=function(e){return t.typeOf.object("quaternion",e),Math.abs(e.w-1)<s.EPSILON6?0:2*Math.acos(e.w)};var R=new l;l.lerp=function(e,r,n,i){return t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i),R=l.multiplyByScalar(r,n,R),i=l.multiplyByScalar(e,1-n,i),l.add(R,i,i)};var A=new l,g=new l,b=new l;l.slerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a=l.dot(e,r),o=r;if(a<0&&(a=-a,o=A=l.negate(r,A)),1-a<s.EPSILON6)return l.lerp(e,o,n,i);var u=Math.acos(a);return g=l.multiplyByScalar(e,Math.sin((1-n)*u),g),b=l.multiplyByScalar(o,Math.sin(n*u),b),i=l.add(g,b,i),l.multiplyByScalar(i,1/Math.sin(u),i)},l.log=function(r,n){t.typeOf.object("quaternion",r),t.typeOf.object("result",n);var i=s.acosClamped(r.w),a=0;return 0!==i&&(a=i/Math.sin(i)),e.multiplyByScalar(r,a,n)},l.exp=function(r,n){t.typeOf.object("cartesian",r),t.typeOf.object("result",n);var i=e.magnitude(r),a=0;return 0!==i&&(a=Math.sin(i)/i),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(i),n};var S=new e,N=new e,I=new l,x=new l;l.computeInnerQuadrangle=function(r,n,i,a){t.typeOf.object("q0",r),t.typeOf.object("q1",n),t.typeOf.object("q2",i),t.typeOf.object("result",a);var o=l.conjugate(n,I);l.multiply(o,i,x);var u=l.log(x,S);l.multiply(o,r,x);var s=l.log(x,N);return e.add(u,s,u),e.multiplyByScalar(u,.25,u),e.negate(u,u),l.exp(u,I),l.multiply(n,I,a)},l.squad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=l.slerp(e,r,a,I),s=l.slerp(n,i,a,x);return l.slerp(u,s,2*a*(1-a),o)};for(var M=new l,P=1.9011074535173003,C=a.supportsTypedArrays()?new Float32Array(8):[],D=a.supportsTypedArrays()?new Float32Array(8):[],L=a.supportsTypedArrays()?new Float32Array(8):[],U=a.supportsTypedArrays()?new Float32Array(8):[],F=0;F<7;++F){var q=F+1,z=2*q+1;C[F]=1/(q*z),D[F]=q/z}return C[7]=P/136,D[7]=8*P/17,l.fastSlerp=function(e,r,n,i){t.typeOf.object("start",e),t.typeOf.object("end",r),t.typeOf.number("t",n),t.typeOf.object("result",i);var a,o=l.dot(e,r);o>=0?a=1:(a=-1,o=-o);for(var u=o-1,s=1-n,c=n*n,f=s*s,d=7;d>=0;--d)L[d]=(C[d]*c-D[d])*u,U[d]=(C[d]*f-D[d])*u;var h=a*n*(1+L[0]*(1+L[1]*(1+L[2]*(1+L[3]*(1+L[4]*(1+L[5]*(1+L[6]*(1+L[7])))))))),p=s*(1+U[0]*(1+U[1]*(1+U[2]*(1+U[3]*(1+U[4]*(1+U[5]*(1+U[6]*(1+U[7])))))))),y=l.multiplyByScalar(e,p,M);return l.multiplyByScalar(r,h,i),l.add(y,i,i)},l.fastSquad=function(e,r,n,i,a,o){t.typeOf.object("q0",e),t.typeOf.object("q1",r),t.typeOf.object("s0",n),t.typeOf.object("s1",i),t.typeOf.number("t",a),t.typeOf.object("result",o);var u=l.fastSlerp(e,r,a,I),s=l.fastSlerp(n,i,a,x);return l.fastSlerp(u,s,2*a*(1-a),o)},l.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},l.equalsEpsilon=function(e,r,i){return t.typeOf.number("epsilon",i),e===r||n(e)&&n(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},l.ZERO=o(new l(0,0,0,0)),l.IDENTITY=o(new l(0,0,0,1)),l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},l}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,r,n){"use strict";function i(t,i,a,l,f,d,h,p,y,m){var E=t+i;e.multiplyByScalar(l,Math.cos(E),o),e.multiplyByScalar(a,Math.sin(E),u),e.add(o,u,o);var w=Math.cos(t);w*=w;var _=Math.sin(t);_*=_;var O=d/Math.sqrt(h*w+f*_),T=O/p;return n.fromAxisAngle(o,T,s),r.fromQuaternion(s,c),r.multiplyByVector(c,y,m),e.normalize(m,m),e.multiplyByScalar(m,p,m),m}var a={},o=new e,u=new e,s=new n,c=new r,l=new e,f=new e,d=new e,h=new e;a.raisePositionsToHeight=function(t,r,n){for(var i=r.ellipsoid,a=r.height,o=r.extrudedHeight,u=n?t.length/3*2:t.length/3,s=new Float64Array(3*u),c=t.length,p=n?c:0,y=0;y<c;y+=3){var m=y+1,E=y+2,w=e.fromArray(t,y,l);i.scaleToGeodeticSurface(w,w);var _=e.clone(w,f),O=i.geodeticSurfaceNormal(w,h),T=e.multiplyByScalar(O,a,d);e.add(w,T,w),n&&(e.multiplyByScalar(O,o,T),e.add(_,T,_),s[y+p]=_.x,s[m+p]=_.y,s[E+p]=_.z),s[y]=w.x,s[m]=w.y,s[E]=w.z}return s};var p=new e,y=new e,m=new e;return a.computeEllipsePositions=function(r,n,a){var o=r.semiMinorAxis,u=r.semiMajorAxis,s=r.rotation,c=r.center,h=8*r.granularity,E=o*o,w=u*u,_=u*o,O=e.magnitude(c),T=e.normalize(c,p),v=e.cross(e.UNIT_Z,c,y);v=e.normalize(v,v);var R=e.cross(T,v,m),A=1+Math.ceil(t.PI_OVER_TWO/h),g=t.PI_OVER_TWO/(A-1),b=t.PI_OVER_TWO-A*g;b<0&&(A-=Math.ceil(Math.abs(b)/g));var S,N,I,x,M,P=2*(A*(A+2)),C=n?new Array(3*P):void 0,D=0,L=l,U=f,F=4*A*3,q=F-1,z=0,B=a?new Array(F):void 0;for(b=t.PI_OVER_TWO,L=i(b,s,R,v,E,_,w,O,T,L),n&&(C[D++]=L.x,C[D++]=L.y,C[D++]=L.z),a&&(B[q--]=L.z,B[q--]=L.y,B[q--]=L.x),b=t.PI_OVER_TWO-g,S=1;S<A+1;++S){if(L=i(b,s,R,v,E,_,w,O,T,L),U=i(Math.PI-b,s,R,v,E,_,w,O,T,U),n){for(C[D++]=L.x,C[D++]=L.y,C[D++]=L.z,I=2*S+2,N=1;N<I-1;++N)x=N/(I-1),M=e.lerp(L,U,x,d),C[D++]=M.x,C[D++]=M.y,C[D++]=M.z;C[D++]=U.x,C[D++]=U.y,C[D++]=U.z}a&&(B[q--]=L.z,B[q--]=L.y,B[q--]=L.x,B[z++]=U.x,B[z++]=U.y,B[z++]=U.z),b=t.PI_OVER_TWO-(S+1)*g}for(S=A;S>1;--S){if(b=t.PI_OVER_TWO-(S-1)*g,L=i(-b,s,R,v,E,_,w,O,T,L),U=i(b+Math.PI,s,R,v,E,_,w,O,T,U),n){for(C[D++]=L.x,C[D++]=L.y,C[D++]=L.z,I=2*(S-1)+2,N=1;N<I-1;++N)x=N/(I-1),M=e.lerp(L,U,x,d),C[D++]=M.x,C[D++]=M.y,C[D++]=M.z;C[D++]=U.x,C[D++]=U.y,C[D++]=U.z}a&&(B[q--]=L.z,B[q--]=L.y,B[q--]=L.x,B[z++]=U.x,B[z++]=U.y,B[z++]=U.z)}b=t.PI_OVER_TWO,L=i(-b,s,R,v,E,_,w,O,T,L);var j={};return n&&(C[D++]=L.x,C[D++]=L.y,C[D++]=L.z,j.positions=C,j.numPts=A),a&&(B[q--]=L.z,B[q--]=L.y,B[q--]=L.x,j.outerPositions=B),j},a}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,i){"use strict";function a(a){if(a=e(a,e.EMPTY_OBJECT),!t(a.attributes))throw new r("options.attributes is required.");this.attributes=a.attributes,this.indices=a.indices,this.primitiveType=e(a.primitiveType,i.TRIANGLES),this.boundingSphere=a.boundingSphere,this.geometryType=e(a.geometryType,n.NONE),this.boundingSphereCV=a.boundingSphereCV}return a.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&t(e.attributes[i])&&t(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&n!==-1)throw new r("All attribute lists must have the same number of attributes.");n=o}return n},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(n.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(n.values))throw new r("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,n){"use strict";function i(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.geometry))throw new r("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}return i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,i){"use strict";var a={};a.octEncodeInRange=function(e,a,o){if(!r(e))throw new n("vector is required.");if(!r(o))throw new n("result is required.");var u=t.magnitudeSquared(e);if(Math.abs(u-1)>i.EPSILON6)throw new n("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=o.x,c=o.y;o.x=(1-Math.abs(c))*i.signNotZero(s),o.y=(1-Math.abs(s))*i.signNotZero(c)}return o.x=i.toSNorm(o.x,a),o.y=i.toSNorm(o.y,a),o},a.octEncode=function(e,t){return a.octEncodeInRange(e,255,t)},a.octDecodeInRange=function(e,a,o,u){if(!r(u))throw new n("result is required.");if(e<0||e>o||a<0||a>o)throw new n("x and y must be a signed normalized integer between 0 and "+o);if(u.x=i.fromSNorm(e,o),u.y=i.fromSNorm(a,o),u.z=1-(Math.abs(u.x)+Math.abs(u.y)),u.z<0){var s=u.x;u.x=(1-Math.abs(u.y))*i.signNotZero(s),u.y=(1-Math.abs(s))*i.signNotZero(u.y)}return t.normalize(u,u)},a.octDecode=function(e,t,r){return a.octDecodeInRange(e,t,255,r)},a.octPackFloat=function(e){if(!r(e))throw new n("encoded is required.");return 256*e.x+e.y};var o=new e;return a.octEncodeFloat=function(e){return a.octEncode(e,o),a.octPackFloat(o)},a.octDecodeFloat=function(e,t){if(!r(e))throw new n("value is required.");var i=e/256,o=Math.floor(i),u=256*(i-o);return a.octDecode(o,u,t)},a.octPack=function(e,t,i,u){if(!r(e))throw new n("v1 is required.");if(!r(t))throw new n("v2 is required.");if(!r(i))throw new n("v3 is required.");if(!r(u))throw new n("result is required.");var s=a.octEncodeFloat(e),c=a.octEncodeFloat(t),l=a.octEncode(i,o);return u.x=65536*l.x+s,u.y=65536*l.y+c,u},a.octUnpack=function(e,t,i,o){if(!r(e))throw new n("packed is required.");if(!r(t))throw new n("v1 is required.");if(!r(i))throw new n("v2 is required.");if(!r(o))throw new n("v3 is required.");var u=e.x/65536,s=Math.floor(u),c=65536*(u-s);u=e.y/65536;var l=Math.floor(u),f=65536*(u-l);a.octDecodeFloat(c,t),a.octDecodeFloat(f,i),a.octDecode(s,l,o)},a.compressTextureCoordinates=function(e){if(!r(e))throw new n("textureCoordinates is required.");var t=4095*e.x|0,i=4095*e.y|0;return 4096*t+i},a.decompressTextureCoordinates=function(e,t){if(!r(e))throw new n("compressed is required.");if(!r(t))throw new n("result is required.");var i=e/4096,a=Math.floor(i);return t.x=a/4095,t.y=(e-4096*a)/4095,t},a}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(i,s,c,l,f){if(!(r(i)&&r(s)&&r(c)&&r(l)))throw new n("point, p0, p1, and p2 are required.");r(f)||(f=new t);var d,h,p,y,m,E,w,_;r(s.z)?(d=t.subtract(c,s,a),h=t.subtract(l,s,o),p=t.subtract(i,s,u),y=t.dot(d,d),m=t.dot(d,h),E=t.dot(d,p),w=t.dot(h,h),_=t.dot(h,p)):(d=e.subtract(c,s,a),h=e.subtract(l,s,o),p=e.subtract(i,s,u),y=e.dot(d,d),m=e.dot(d,h),E=e.dot(d,p),w=e.dot(h,h),_=e.dot(h,p));var O=1/(y*w-m*m);return f.y=(w*E-m*_)*O,f.z=(y*_-m*E)*O,f.x=1-f.y-f.z,f}var a=new t,o=new t,u=new t;return i}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,n){if(!t(e))throw new r("value is required");t(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){if(!t(e))throw new r("cartesian is required");t(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,i,o){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("cartesianArray is required");if("number"!=typeof o||o<0)throw new r("index must be a number greater than or equal to 0.");n.fromCartesian(e,a);var u=a.high,s=a.low;i[o]=u.x,i[o+1]=u.y,i[o+2]=u.z,i[o+3]=s.x,i[o+4]=s.y,i[o+5]=s.z},n}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(r,i){if(!e(r))throw new t("numberOfVertices is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},a.createTypedArrayFromArrayBuffer=function(r,i,a,o){if(!e(r))throw new t("numberOfVertices is required.");if(!e(i))throw new t("sourceArray is required.");if(!e(a))throw new t("byteOffset is required.");return r>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,a,o):new Uint16Array(i,a,o)},r(a)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var i=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<n?0:i}var n={};return n.computeDiscriminant=function(t,r,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=r*r-4*t*n;return i},n.computeRealRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(u<s&&u/s<t.EPSILON14)return[0,0];if(u>s&&s/u<t.EPSILON14)return[];if(o=-a/n,o<0)return[];var c=Math.sqrt(o);return[-c,c]}if(0===a)return o=-i/n,o<0?[o,0]:[0,o];var l=i*i,f=4*n*a,d=r(l,-f,t.EPSILON14);if(d<0)return[];var h=-.5*r(i,t.sign(i)*Math.sqrt(d),t.EPSILON14);return i>0?[h/n,a/h]:[a/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var i,a,o=e,u=t/3,s=r/3,c=n,l=o*s,f=u*c,d=u*u,h=s*s,p=o*s-d,y=o*c-u*s,m=u*c-h,E=4*p*m-y*y;if(E<0){var w,_,O;d*f>=l*h?(w=o,_=p,O=-2*u*p+o*y):(w=c,_=m,O=-c*y+2*s*m);var T=O<0?-1:1,v=-T*Math.abs(w)*Math.sqrt(-E);a=-O+v;var R=a/2,A=R<0?-Math.pow(-R,1/3):Math.pow(R,1/3),g=a===v?-A:-_/A;return i=_<=0?A+g:-O/(A*A+g*g+_),d*f>=l*h?[(i-u)/o]:[-c/(i+s)]}var b=p,S=-2*u*p+o*y,N=m,I=-c*y+2*s*m,x=Math.sqrt(E),M=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*x,-S)/3);i=2*Math.sqrt(-b);var C=Math.cos(P);a=i*C;var D=i*(-C/2-M*Math.sin(P)),L=a+D>2*u?a-u:D-u,U=o,F=L/U;P=Math.abs(Math.atan2(c*x,-I)/3),i=2*Math.sqrt(-N),C=Math.cos(P),a=i*C,D=i*(-C/2-M*Math.sin(P));var q=-c,z=a+D<2*s?a+s:D+s,B=q/z,j=U*z,G=-L*z-U*q,V=L*q,W=(s*G-u*V)/(-u*G+s*j);return F<=W?F<=B?W<=B?[F,W,B]:[F,B,W]:[B,F,W]:F<=B?[W,F,B]:W<=B?[W,B,F]:[B,W,F]}var n={};return n.computeDiscriminant=function(t,r,n,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=t*t,o=r*r,u=n*n,s=i*i,c=18*t*r*n*i+o*u-27*a*s-4*(t*u*n+o*r*i);return c},n.computeRealRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return t.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var c=s<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===o?(u=t.computeRealRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):r(n,0,a,o)}return 0===a?0===o?(s=-i/n,s<0?[s,0,0]:[0,0,s]):r(n,i,0,o):0===o?(u=t.computeRealRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):r(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function i(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,l=o-a*t/4+i*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var d=-t/4,h=f[f.length-1];if(Math.abs(h)<r.EPSILON14){var p=n.computeRealRoots(1,s,l);if(2===p.length){var y,m=p[0],E=p[1];if(m>=0&&E>=0){var w=Math.sqrt(m),_=Math.sqrt(E);return[d-_,d-w,d+w,d+_]}if(m>=0&&E<0)return y=Math.sqrt(m),[d-y,d+y];if(m<0&&E>=0)return y=Math.sqrt(E),[d-y,d+y]}return[]}if(h>0){var O=Math.sqrt(h),T=(s+h-c/O)/2,v=(s+h+c/O)/2,R=n.computeRealRoots(1,O,T),A=n.computeRealRoots(1,-O,v);return 0!==R.length?(R[0]+=d,R[1]+=d,0!==A.length?(A[0]+=d,A[1]+=d,R[1]<=A[0]?[R[0],R[1],A[0],A[1]]:A[1]<=R[0]?[A[0],A[1],R[0],R[1]]:R[0]>=A[0]&&R[1]<=A[1]?[A[0],R[0],R[1],A[1]]:A[0]>=R[0]&&A[1]<=R[1]?[R[0],A[0],A[1],R[1]]:R[0]>A[0]&&R[0]<A[1]?[A[0],R[0],A[1],R[1]]:[R[0],A[0],R[1],A[1]]):R):0!==A.length?(A[0]+=d,A[1]+=d,A):[]}}return[]}function a(t,i,a,o){var u=a*a,s=i*i,c=t*t,l=-2*i,f=a*t+s-4*o,d=c*o-a*i*t+u,h=e.computeRealRoots(1,l,f,d);if(h.length>0){var p,y,m=h[0],E=i-m,w=E*E,_=t/2,O=E/2,T=w-4*o,v=w+4*Math.abs(o),R=c-4*m,A=c+4*Math.abs(m);if(m<0||T*A<R*v){var g=Math.sqrt(R);p=g/2,y=0===g?0:(t*O-a)/g}else{var b=Math.sqrt(T);p=0===b?0:(t*O-a)/b,y=b/2}var S,N;0===_&&0===p?(S=0,N=0):r.sign(_)===r.sign(p)?(S=_+p,N=m/S):(N=_-p,S=m/N);var I,x;0===O&&0===y?(I=0,x=0):r.sign(O)===r.sign(y)?(I=O+y,x=o/I):(x=O-y,I=o/x);var M=n.computeRealRoots(1,S,I),P=n.computeRealRoots(1,N,x);if(0!==M.length)return 0!==P.length?M[1]<=P[0]?[M[0],M[1],P[0],P[1]]:P[1]<=M[0]?[P[0],P[1],M[0],M[1]]:M[0]>=P[0]&&M[1]<=P[1]?[P[0],M[0],M[1],P[1]]:P[0]>=M[0]&&P[1]<=M[1]?[M[0],P[0],P[1],M[1]]:M[0]>P[0]&&M[0]<P[1]?[P[0],M[0],P[1],M[1]]:[M[0],P[0],M[1],P[1]]:M;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,r,n,i,a){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof n)throw new t("c is a required number.");if("number"!=typeof i)throw new t("d is a required number.");if("number"!=typeof a)throw new t("e is a required number.");var o=e*e,u=o*e,s=r*r,c=s*r,l=n*n,f=l*n,d=i*i,h=d*i,p=a*a,y=p*a,m=s*l*d-4*c*h-4*e*f*d+18*e*r*n*h-27*o*d*d+256*u*y+a*(18*c*n*i-4*s*f+16*e*l*l-80*e*r*l*i-6*e*s*d+144*o*n*d)+p*(144*e*s*n-27*s*s-128*o*l-192*o*r*i);return m},o.computeRealRoots=function(n,o,u,s,c){if("number"!=typeof n)throw new t("a is a required number.");if("number"!=typeof o)throw new t("b is a required number.");if("number"!=typeof u)throw new t("c is a required number.");if("number"!=typeof s)throw new t("d is a required number.");if("number"!=typeof c)throw new t("e is a required number.");if(Math.abs(n)<r.EPSILON15)return e.computeRealRoots(o,u,s,c);var l=o/n,f=u/n,d=s/n,h=c/n,p=l<0?1:0;switch(p+=f<0?p+1:p,p+=d<0?p+1:p,p+=h<0?p+1:p){case 0:return i(l,f,d,h);case 1:return a(l,f,d,h);case 2:return a(l,f,d,h);case 3:return i(l,f,d,h);case 4:return i(l,f,d,h);case 5:return a(l,f,d,h);case 6:return i(l,f,d,h);case 7:return i(l,f,d,h);case 8:return a(l,f,d,h);case 9:return i(l,f,d,h);case 10:return i(l,f,d,h);case 11:return a(l,f,d,h);case 12:return i(l,f,d,h);case 13:return i(l,f,d,h);case 14:return i(l,f,d,h);case 15:return i(l,f,d,h);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n}return i.getPoint=function(t,i,a){if(!r(t))throw new n("ray is requred");
if("number"!=typeof i)throw new n("t is a required number");return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,i,a),e.add(t.origin,a,a)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,i,a,o,u,s,c,l){"use strict";function f(e,t,r,n){var i=t*t-4*e*r;if(!(i<0)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function d(t,r,i){n(i)||(i=new a);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,l=e.subtract(o,s,w),d=e.dot(u,u),h=2*e.dot(u,l),p=e.magnitudeSquared(l)-c,y=f(d,h,p,v);if(n(y))return i.start=y.root0,i.stop=y.root1,i}function h(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function p(t,r,n,i,a){var l,f=i*i,d=a*a,p=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*d,y=a*(i*h(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),m=t[u.COLUMN0ROW0]*f+t[u.COLUMN2ROW2]*d+i*r.x+n,E=d*h(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),w=a*(i*h(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),_=[];if(0===w&&0===E){if(l=s.computeRealRoots(p,y,m),0===l.length)return _;var O=l[0],T=Math.sqrt(Math.max(1-O*O,0));if(_.push(new e(i,a*O,a*-T)),_.push(new e(i,a*O,a*T)),2===l.length){var v=l[1],R=Math.sqrt(Math.max(1-v*v,0));_.push(new e(i,a*v,a*-R)),_.push(new e(i,a*v,a*R))}return _}var A=w*w,g=E*E,b=p*p,S=w*E,N=b+g,I=2*(y*p+S),x=2*m*p+y*y-g+A,M=2*(m*y-S),P=m*m-A;if(0===N&&0===I&&0===x&&0===M)return _;l=c.computeRealRoots(N,I,x,M,P);var C=l.length;if(0===C)return _;for(var D=0;D<C;++D){var L,U=l[D],F=U*U,q=Math.max(1-F,0),z=Math.sqrt(q);L=o.sign(p)===o.sign(m)?h(p*F+m,y*U,o.EPSILON12):o.sign(m)===o.sign(y*U)?h(p*F,y*U+m,o.EPSILON12):h(p*F+y*U,m,o.EPSILON12);var B=h(E*U,w,o.EPSILON15),j=L*B;j<0?_.push(new e(i,a*U,a*z)):j>0?_.push(new e(i,a*U,a*-z)):0!==z?(_.push(new e(i,a*U,a*-z)),_.push(new e(i,a*U,a*z)),++D):_.push(new e(i,a*U,a*z))}return _}var y={};y.rayPlane=function(t,r,a){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("plane is required.");n(a)||(a=new e);var u=t.origin,s=t.direction,c=r.normal,l=e.dot(c,s);if(!(Math.abs(l)<o.EPSILON15)){var f=(-r.distance-e.dot(c,u))/l;if(!(f<0))return a=e.multiplyByScalar(s,f,a),e.add(u,a,a)}};var m=new e,E=new e,w=new e,_=new e,O=new e;y.rayTriangleParametric=function(t,a,u,s,c){if(!n(t))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=r(c,!1);var l,f,d,h,p,y=t.origin,T=t.direction,v=e.subtract(u,a,m),R=e.subtract(s,a,E),A=e.cross(T,R,w),g=e.dot(v,A);if(c){if(g<o.EPSILON6)return;if(l=e.subtract(y,a,_),d=e.dot(l,A),d<0||d>g)return;if(f=e.cross(l,v,O),h=e.dot(T,f),h<0||d+h>g)return;p=e.dot(R,f)/g}else{if(Math.abs(g)<o.EPSILON6)return;var b=1/g;if(l=e.subtract(y,a,_),d=e.dot(l,A)*b,d<0||d>1)return;if(f=e.cross(l,v,O),h=e.dot(T,f)*b,h<0||d+h>1)return;p=e.dot(R,f)*b}return p},y.rayTriangle=function(t,r,i,a,o,u){var s=y.rayTriangleParametric(t,r,i,a,o);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var T=new l;y.lineSegmentTriangle=function(t,r,a,o,u,s,c){if(!n(t))throw new i("v0 is required.");if(!n(r))throw new i("v1 is required.");if(!n(a))throw new i("p0 is required.");if(!n(o))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");var l=T;e.clone(t,l.origin),e.subtract(r,t,l.direction),e.normalize(l.direction,l.direction);var f=y.rayTriangleParametric(l,a,o,u,s);if(!(!n(f)||f<0||f>e.distance(t,r)))return n(c)||(c=new e),e.multiplyByScalar(l.direction,f,c),e.add(l.origin,c,c)};var v={root0:0,root1:0};y.raySphere=function(e,t,r){if(!n(e))throw new i("ray is required.");if(!n(t))throw new i("sphere is required.");if(r=d(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var R=new l;y.lineSegmentSphere=function(t,r,a,o){if(!n(t))throw new i("p0 is required.");if(!n(r))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=R;e.clone(t,u.origin);var s=e.subtract(r,t,u.direction),c=e.magnitude(s);if(e.normalize(s,s),o=d(u,a,o),!(!n(o)||o.stop<0||o.start>c))return o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,c),o};var A=new e,g=new e;y.rayEllipsoid=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var o,u,s,c,l,f=r.oneOverRadii,d=e.multiplyComponents(f,t.origin,A),h=e.multiplyComponents(f,t.direction,g),p=e.magnitudeSquared(d),y=e.dot(d,h);if(p>1){if(y>=0)return;var m=y*y;if(o=p-1,u=e.magnitudeSquared(h),s=u*o,m<s)return;if(m>s){c=y*y-s,l=-y+Math.sqrt(c);var E=l/u,w=o/l;return E<w?new a(E,w):{start:w,stop:E}}var _=Math.sqrt(o/u);return new a(_,_)}return p<1?(o=p-1,u=e.magnitudeSquared(h),s=u*o,c=y*y-s,l=-y+Math.sqrt(c),new a(0,l/u)):y<0?(u=e.magnitudeSquared(h),new a(0,-y/u)):void 0};var b=new e,S=new e,N=new e,I=new e,x=new e,M=new u,P=new u,C=new u,D=new u,L=new u,U=new u,F=new u,q=new e,z=new e,B=new t;y.grazingAltitudeLocation=function(t,r){if(!n(t))throw new i("ray is required.");if(!n(r))throw new i("ellipsoid is required.");var a=t.origin,s=t.direction;if(!e.equals(a,e.ZERO)){var c=r.geodeticSurfaceNormal(a,b);if(e.dot(s,c)>=0)return a}var l=n(this.rayEllipsoid(t,r)),f=r.transformPositionToScaledSpace(s,b),d=e.normalize(f,f),h=e.mostOrthogonalAxis(f,I),y=e.normalize(e.cross(h,d,S),S),m=e.normalize(e.cross(d,y,N),N),E=M;E[0]=d.x,E[1]=d.y,E[2]=d.z,E[3]=y.x,E[4]=y.y,E[5]=y.z,E[6]=m.x,E[7]=m.y,E[8]=m.z;var w=u.transpose(E,P),_=u.fromScale(r.radii,C),O=u.fromScale(r.oneOverRadii,D),T=L;T[0]=0,T[1]=-s.z,T[2]=s.y,T[3]=s.z,T[4]=0,T[5]=-s.x,T[6]=-s.y,T[7]=s.x,T[8]=0;var v,R,A=u.multiply(u.multiply(w,O,U),T,U),g=u.multiply(u.multiply(A,_,F),E,F),j=u.multiplyByVector(A,a,x),G=p(g,e.negate(j,b),0,0,1),V=G.length;if(V>0){for(var W=e.clone(e.ZERO,z),X=Number.NEGATIVE_INFINITY,H=0;H<V;++H){v=u.multiplyByVector(_,u.multiplyByVector(E,G[H],q),q);var Y=e.normalize(e.subtract(v,a,I),I),k=e.dot(Y,s);k>X&&(X=k,W=e.clone(v,W))}var Z=r.cartesianToCartographic(W,B);return X=o.clamp(X,0,1),R=e.magnitude(e.subtract(W,a,I))*Math.sqrt(1-X*X),R=l?-R:R,Z.height=R,r.cartographicToCartesian(Z,new e)}};var j=new e;return y.lineSegmentPlane=function(t,r,a,u){if(!n(t))throw new i("endPoint0 is required.");if(!n(r))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(r,t,j),c=a.normal,l=e.dot(c,s);if(!(Math.abs(l)<o.EPSILON6)){var f=e.dot(c,t),d=-(a.distance+f)/l;if(!(d<0||d>1))return e.multiplyByScalar(s,d,u),e.add(t,u,u),u}},y.trianglePlaneIntersection=function(t,r,a,o){if(!(n(t)&&n(r)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,c=e.dot(u,t)+s<0,l=e.dot(u,r)+s<0,f=e.dot(u,a)+s<0,d=0;d+=c?1:0,d+=l?1:0,d+=f?1:0;var h,p;if(1!==d&&2!==d||(h=new e,p=new e),1===d){if(c)return y.lineSegmentPlane(t,r,o,h),y.lineSegmentPlane(t,a,o,p),{positions:[t,r,a,h,p],indices:[0,3,4,1,2,4,1,4,3]};if(l)return y.lineSegmentPlane(r,a,o,h),y.lineSegmentPlane(r,t,o,p),{positions:[t,r,a,h,p],indices:[1,3,4,2,0,4,2,4,3]};if(f)return y.lineSegmentPlane(a,t,o,h),y.lineSegmentPlane(a,r,o,p),{positions:[t,r,a,h,p],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!c)return y.lineSegmentPlane(r,t,o,h),y.lineSegmentPlane(a,t,o,p),{positions:[t,r,a,h,p],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return y.lineSegmentPlane(a,r,o,h),y.lineSegmentPlane(t,r,o,p),{positions:[t,r,a,h,p],indices:[2,0,4,2,4,3,1,3,4]};if(!f)return y.lineSegmentPlane(t,a,o,h),y.lineSegmentPlane(r,a,o,p),{positions:[t,r,a,h,p],indices:[0,1,4,0,4,3,2,3,4]}}},y}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function i(n,i){if(!t(n))throw new r("normal is required.");if(!t(i))throw new r("distance is required.");this.normal=e.clone(n),this.distance=i}i.fromPointNormal=function(n,a,o){if(!t(n))throw new r("point is required.");if(!t(a))throw new r("normal is required.");var u=-e.dot(a,n);return t(o)?(e.clone(a,o.normal),o.distance=u,o):new i(a,u)};var a=new e;return i.fromCartesian4=function(n,o){if(!t(n))throw new r("coefficients is required.");var u=e.fromCartesian4(n,a),s=n.w;return t(o)?(e.clone(u,o.normal),o.distance=s,o):new i(u,s)},i.getPointDistance=function(n,i){if(!t(n))throw new r("plane is required.");if(!t(i))throw new r("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!t(i))throw new r("indices is required.");var u=i.length;if(u<3||u%3!==0)throw new r("indices length must be a multiple of three.");if(a<=0)throw new r("maximumIndex must be greater than zero.");if(o<3)throw new r("cacheSize must be greater than two.");if(!t(a)){a=0;for(var s=0,c=i[s];s<u;)c>a&&(a=c),++s,c=i[s]}for(var l=[],f=0;f<a+1;f++)l[f]=0;for(var d=o+1,h=0;h<u;++h)d-l[i[h]]>o&&(l[i[h]]=d,++d);return(d-o+1)/(u/3)},n.tipsify=function(n){function i(e,t,r,n){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;o<n;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function a(e,t,r,n,a,o,u){for(var s,c=-1,l=-1,f=0;f<r.length;){var d=r[f];n[d].numLiveTriangles&&(s=0,a-n[d].timeStamp+2*n[d].numLiveTriangles<=t&&(s=a-n[d].timeStamp),(s>l||l===-1)&&(l=s,c=d)),++f}return c===-1?i(n,o,e,u):c}n=e(n,e.EMPTY_OBJECT);var o,u=n.indices,s=n.maximumIndex,c=e(n.cacheSize,24);if(!t(u))throw new r("indices is required.");var l=u.length;if(l<3||l%3!==0)throw new r("indices length must be a multiple of three.");if(s<=0)throw new r("maximumIndex must be greater than zero.");if(c<3)throw new r("cacheSize must be greater than two.");var f=0,d=0,h=u[d],p=l;if(t(s))f=s+1;else{for(;d<p;)h>f&&(f=h),++d,h=u[d];if(f===-1)return 0;++f}for(var y=[],m=0;m<f;m++)y[m]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};d=0;for(var E=0;d<p;)y[u[d]].vertexTriangles.push(E),++y[u[d]].numLiveTriangles,y[u[d+1]].vertexTriangles.push(E),++y[u[d+1]].numLiveTriangles,y[u[d+2]].vertexTriangles.push(E),++y[u[d+2]].numLiveTriangles,++E,d+=3;var w=0,_=c+1;o=1;var O,T,v=[],R=[],A=0,g=[],b=l/3,S=[];for(m=0;m<b;m++)S[m]=!1;for(var N,I;w!==-1;){v=[],T=y[w],I=T.vertexTriangles.length;for(var x=0;x<I;++x)if(E=T.vertexTriangles[x],!S[E]){S[E]=!0,d=E+E+E;for(var M=0;M<3;++M)N=u[d],v.push(N),R.push(N),g[A]=N,++A,O=y[N],--O.numLiveTriangles,_-O.timeStamp>c&&(O.timeStamp=_,++_),++d}w=a(u,c,v,y,_,R,f)}return g},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,i,a,o,u,s,c,l,f,d,h,p,y,m,E,w,_,O,T,v,R,A){"use strict";function g(e,t,r,n,i){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=i,e[t++]=i,e[t]=r}function b(e){for(var t=e.length,r=t/3*6,n=m.createTypedArray(t,r),i=0,a=0;a<t;a+=3,i+=6)g(n,i,e[a],e[a+1],e[a+2]);return n}function S(e){var t=e.length;if(t>=3){var r=6*(t-2),n=m.createTypedArray(t,r);g(n,0,e[0],e[1],e[2]);for(var i=6,a=3;a<t;++a,i+=6)g(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function N(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=m.createTypedArray(t,r),i=e[0],a=0,o=1;o<t;++o,a+=6)g(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function I(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new p({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function x(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var i=t[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[r*i.componentsPerAttribute+a])}function M(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;a<n;a+=3)i.unpack(r,a,ae),T.multiplyByPoint(e,ae,ae),i.pack(ae,r,a)}function P(e,t){if(c(t))for(var r=t.values,n=r.length,a=0;a<n;a+=3)i.unpack(r,a,ae),O.multiplyByVector(e,ae,ae),ae=i.normalize(ae,ae),i.pack(ae,r,a)}function C(e,t){var r,n=e.length,i={},a=e[0][t].attributes;for(r in a)if(a.hasOwnProperty(r)&&c(a[r])&&c(a[r].values)){for(var o=a[r],s=o.values.length,l=!0,f=1;f<n;++f){var d=e[f][t].attributes[r];if(!c(d)||o.componentDatatype!==d.componentDatatype||o.componentsPerAttribute!==d.componentsPerAttribute||o.normalize!==d.normalize){l=!1;break}s+=d.values.length}l&&(i[r]=new p({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return i}function D(e,t){var n,a,o,u,s=e.length,f=e[0].modelMatrix,d=c(e[0][t].indices),p=e[0][t].primitiveType;for(a=1;a<s;++a){if(!T.equals(e[a].modelMatrix,f))throw new l("All instances must have the same modelMatrix.");if(c(e[a][t].indices)!==d)throw new l("All instance geometries must have an indices or not have one.");if(e[a][t].primitiveType!==p)throw new l("All instance geometries must have the same primitiveType.")}var y,E,w,_=C(e,t);for(n in _)if(_.hasOwnProperty(n))for(y=_[n].values,u=0,a=0;a<s;++a)for(E=e[a][t].attributes[n].values,w=E.length,o=0;o<w;++o)y[u++]=E[o];var O;if(d){var v=0;for(a=0;a<s;++a)v+=e[a][t].indices.length;var A=h.computeNumberOfVertices(new h({attributes:_,primitiveType:R.POINTS})),g=m.createTypedArray(A,v),b=0,S=0;for(a=0;a<s;++a){var N=e[a][t].indices,I=N.length;for(u=0;u<I;++u)g[b++]=S+N[u];S+=h.computeNumberOfVertices(e[a][t])}O=g}var x,M=new i,P=0;for(a=0;a<s;++a){if(x=e[a][t].boundingSphere,!c(x)){M=void 0;break}i.add(x.center,M,M)}if(c(M))for(i.divideByScalar(M,s,M),a=0;a<s;++a){x=e[a][t].boundingSphere;var D=i.magnitude(i.subtract(x.center,M,se))+x.radius;D>P&&(P=D)}return new h({attributes:_,indices:O,primitiveType:p,boundingSphere:c(M)?new r(M,P):void 0})}function L(e){if(c(e.indices))return e;var t=h.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least three.");if(t%3!==0)throw new l("The number of vertices must be a multiple of three.");for(var r=m.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}function U(e){var t=h.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least three.");var r=m.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,i=3;i<t;++i)r[n++]=i-1,r[n++]=0,r[n++]=i;return e.indices=r,e.primitiveType=R.TRIANGLES,e}function F(e){var t=h.computeNumberOfVertices(e);if(t<3)throw new l("The number of vertices must be at least 3.");var r=m.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,i=3;i<t-1;i+=2)r[n++]=i,r[n++]=i-1,r[n++]=i+1,i+2<t&&(r[n++]=i,r[n++]=i+1,r[n++]=i+2);return e.indices=r,e.primitiveType=R.TRIANGLES,e}function q(e){if(c(e.indices))return e;var t=h.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");if(t%2!==0)throw new l("The number of vertices must be a multiple of 2.");for(var r=m.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}function z(e){var t=h.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");var r=m.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return e.indices=r,e.primitiveType=R.LINES,e}function B(e){var t=h.computeNumberOfVertices(e);if(t<2)throw new l("The number of vertices must be at least two.");var r=m.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,i=2;i<t;++i)r[n++]=i-1,r[n++]=i;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=R.LINES,e}function j(e){switch(e.primitiveType){case R.TRIANGLE_FAN:return U(e);case R.TRIANGLE_STRIP:return F(e);case R.TRIANGLES:return L(e);case R.LINE_STRIP:return z(e);case R.LINE_LOOP:return B(e);case R.LINES:return q(e)}return e}function G(e,t){Math.abs(e.y)<_.EPSILON6&&(t?e.y=-_.EPSILON6:e.y=_.EPSILON6)}function V(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return G(e,e.y<0),G(t,t.y<0),void G(r,r.y<0);var n,i=Math.abs(e.y),a=Math.abs(t.y),o=Math.abs(r.y);n=i>a?i>o?_.sign(e.y):_.sign(r.y):a>o?_.sign(t.y):_.sign(r.y);var u=n<0;G(e,u),G(t,u),G(r,u)}function W(e,t,r,n){i.add(e,i.multiplyByScalar(i.subtract(t,e,Te),e.y/(e.y-t.y),Te),r),i.clone(r,n),G(r,!0),G(n,!1)}function X(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){V(e,t,r);var n=e.y<0,i=t.y<0,a=r.y<0,o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var u=be.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(W(e,t,ve,Ae),W(e,r,Re,ge),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(W(t,r,ve,Ae),W(t,e,Re,ge),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(W(r,e,ve,Ae),W(r,t,Re,ge),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(W(r,e,ve,Ae),W(r,t,Re,ge),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(W(t,r,ve,Ae),W(t,e,Re,ge),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(W(e,t,ve,Ae),W(e,r,Re,ge),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=be.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,1!==o&&2!==o||(s[3]=ve,s[4]=Re,s[5]=Ae,s[6]=ge,s.length=7),be}}function H(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var i in n)if(n.hasOwnProperty(i)&&c(n[i])&&c(n[i].values)){var a=n[i];a.values=u.createTypedArray(a.componentDatatype,a.values)}var o=h.computeNumberOfVertices(e);return e.indices=m.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function Y(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var i=t[n];r[n]=new p({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new h({attributes:r,indices:[],primitiveType:e.primitiveType})}function k(e,t,r){var n=c(e.geometry.boundingSphere);t=H(t,n),r=H(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function Z(e,r,a,o,u,s,l,f,d,h,p,y){if(c(s)||c(l)||c(f)||c(d)||c(h)){var m=i.fromArray(u,3*e,Se),E=i.fromArray(u,3*r,Ne),w=i.fromArray(u,3*a,Ie),_=t(o,m,E,w,xe);if(c(s)){var O=i.fromArray(s,3*e,Se),T=i.fromArray(s,3*r,Ne),v=i.fromArray(s,3*a,Ie);i.multiplyByScalar(O,_.x,O),i.multiplyByScalar(T,_.y,T),i.multiplyByScalar(v,_.z,v);var R=i.add(O,T,O);i.add(R,v,R),i.normalize(R,R),i.pack(R,p.normal.values,3*y)}if(c(h)){var A=i.fromArray(h,3*e,Se),g=i.fromArray(h,3*r,Ne),b=i.fromArray(h,3*a,Ie);i.multiplyByScalar(A,_.x,A),i.multiplyByScalar(g,_.y,g),i.multiplyByScalar(b,_.z,b);var S;i.equals(A,i.ZERO)&&i.equals(g,i.ZERO)&&i.equals(b,i.ZERO)?(S=Se,S.x=0,S.y=0,S.z=0):(S=i.add(A,g,A),i.add(S,b,S),i.normalize(S,S)),i.pack(S,p.extrudeDirection.values,3*y)}if(c(l)){var N=i.fromArray(l,3*e,Se),I=i.fromArray(l,3*r,Ne),x=i.fromArray(l,3*a,Ie);i.multiplyByScalar(N,_.x,N),i.multiplyByScalar(I,_.y,I),i.multiplyByScalar(x,_.z,x);var M=i.add(N,I,N);i.add(M,x,M),i.normalize(M,M),i.pack(M,p.tangent.values,3*y)}if(c(f)){var P=i.fromArray(f,3*e,Se),C=i.fromArray(f,3*r,Ne),D=i.fromArray(f,3*a,Ie);i.multiplyByScalar(P,_.x,P),i.multiplyByScalar(C,_.y,C),i.multiplyByScalar(D,_.z,D);var L=i.add(P,C,P);i.add(L,D,L),i.normalize(L,L),i.pack(L,p.bitangent.values,3*y)}if(c(d)){var U=n.fromArray(d,2*e,Me),F=n.fromArray(d,2*r,Pe),q=n.fromArray(d,2*a,Ce);n.multiplyByScalar(U,_.x,U),n.multiplyByScalar(F,_.y,F),n.multiplyByScalar(q,_.z,q);var z=n.add(U,F,U);n.add(z,q,z),n.pack(z,p.st.values,2*y)}}}function K(e,t,r,n,i,a){var o=e.position.values.length/3;if(i!==-1){var u=n[i],s=r[u];return s===-1?(r[u]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(a.x,a.y,a.z),t.push(o),o}function J(e){var t,r,n,a,o,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,d=c(s.bitangent)?s.bitangent.values:void 0,h=c(s.tangent)?s.tangent.values:void 0,p=c(s.st)?s.st.values:void 0,y=c(s.extrudeDirection)?s.extrudeDirection.values:void 0,m=u.indices,E=Y(u),w=Y(u),_=[];_.length=l.length/3;var O=[];for(O.length=l.length/3,o=0;o<_.length;++o)_[o]=-1,O[o]=-1;var T=m.length;for(o=0;o<T;o+=3){var v=m[o],R=m[o+1],A=m[o+2],g=i.fromArray(l,3*v),b=i.fromArray(l,3*R),S=i.fromArray(l,3*A),N=X(g,b,S);if(c(N)&&N.positions.length>3)for(var I=N.positions,x=N.indices,M=x.length,P=0;P<M;++P){var C=x[P],D=I[C];D.y<0?(t=w.attributes,r=w.indices,n=_):(t=E.attributes,r=E.indices,n=O),a=K(t,r,n,m,C<3?o+C:-1,D),Z(v,R,A,D,l,f,h,d,p,y,t,a)}else c(N)&&(g=N.positions[0],b=N.positions[1],S=N.positions[2]),g.y<0?(t=w.attributes,r=w.indices,n=_):(t=E.attributes,r=E.indices,n=O),a=K(t,r,n,m,o,g),Z(v,R,A,g,l,f,h,d,p,y,t,a),a=K(t,r,n,m,o+1,b),Z(v,R,A,b,l,f,h,d,p,y,t,a),a=K(t,r,n,m,o+2,S),Z(v,R,A,S,l,f,h,d,p,y,t,a)}k(e,w,E)}function Q(e){var t,r=e.geometry,n=r.attributes,a=n.position.values,o=r.indices,u=Y(r),s=Y(r),l=o.length,f=[];f.length=a.length/3;var d=[];for(d.length=a.length/3,t=0;t<f.length;++t)f[t]=-1,d[t]=-1;for(t=0;t<l;t+=2){var h=o[t],p=o[t+1],y=i.fromArray(a,3*h,Se),m=i.fromArray(a,3*p,Ne);Math.abs(y.y)<_.EPSILON6&&(y.y<0?y.y=-_.EPSILON6:y.y=_.EPSILON6),Math.abs(m.y)<_.EPSILON6&&(m.y<0?m.y=-_.EPSILON6:m.y=_.EPSILON6);var E=u.attributes,O=u.indices,T=d,v=s.attributes,R=s.indices,A=f,g=w.lineSegmentPlane(y,m,De,Ie);if(c(g)){var b=i.multiplyByScalar(i.UNIT_Y,5*_.EPSILON9,Le);y.y<0&&(i.negate(b,b),E=s.attributes,O=s.indices,T=f,v=u.attributes,R=u.indices,A=d);var S=i.add(g,b,Ue);K(E,O,T,o,t,y),K(E,O,T,o,-1,S),i.negate(b,b),i.add(g,b,S),K(v,R,A,o,-1,S),K(v,R,A,o,t+1,m)}else{var N,I,x;y.y<0?(N=s.attributes,I=s.indices,x=f):(N=u.attributes,I=u.indices,x=d),K(N,I,x,o,t,y),K(N,I,x,o,t+1,m)}}k(e,s,u)}function $(e){for(var t=e.attributes,r=t.position.values,n=t.prevPosition.values,a=t.nextPosition.values,o=r.length,u=0;u<o;u+=3){var s=i.unpack(r,u,ze);if(!(s.x>0)){var c=i.unpack(n,u,Be);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(u-3>0?(n[u]=r[u-3],n[u+1]=r[u-2],n[u+2]=r[u-1]):i.pack(s,n,u));var l=i.unpack(a,u,je);(s.y<0&&l.y>0||s.y>0&&l.y<0)&&(u+3<o?(a[u]=r[u+3],a[u+1]=r[u+4],a[u+2]=r[u+5]):i.pack(s,a,u))}}}function ee(e){var t,r,o,u=e.geometry,s=u.attributes,l=s.position.values,f=s.prevPosition.values,d=s.nextPosition.values,h=s.expandAndWidth.values,p=c(s.st)?s.st.values:void 0,y=c(s.color)?s.color.values:void 0,m=Y(u),E=Y(u),O=!1,T=l.length/3;for(t=0;t<T;t+=4){var v=t,R=t+2,A=i.fromArray(l,3*v,ze),g=i.fromArray(l,3*R,Be);if(Math.abs(A.y)<Ye)for(A.y=Ye*(g.y<0?-1:1),l[3*t+1]=A.y,l[3*(t+1)+1]=A.y,r=3*v;r<3*v+12;r+=3)f[r]=l[3*t],f[r+1]=l[3*t+1],f[r+2]=l[3*t+2];if(Math.abs(g.y)<Ye)for(g.y=Ye*(A.y<0?-1:1),l[3*(t+2)+1]=g.y,l[3*(t+3)+1]=g.y,r=3*v;r<3*v+12;r+=3)d[r]=l[3*(t+2)],d[r+1]=l[3*(t+2)+1],d[r+2]=l[3*(t+2)+2];var b=m.attributes,S=m.indices,N=E.attributes,I=E.indices,x=w.lineSegmentPlane(A,g,De,Ge);if(c(x)){O=!0;var M=i.multiplyByScalar(i.UNIT_Y,He,Ve);A.y<0&&(i.negate(M,M),b=E.attributes,S=E.indices,N=m.attributes,I=m.indices);var P=i.add(x,M,We);b.position.values.push(A.x,A.y,A.z,A.x,A.y,A.z),b.position.values.push(P.x,P.y,P.z),b.position.values.push(P.x,P.y,P.z),b.prevPosition.values.push(f[3*v],f[3*v+1],f[3*v+2]),b.prevPosition.values.push(f[3*v+3],f[3*v+4],f[3*v+5]),b.prevPosition.values.push(A.x,A.y,A.z,A.x,A.y,A.z),b.nextPosition.values.push(P.x,P.y,P.z),b.nextPosition.values.push(P.x,P.y,P.z),b.nextPosition.values.push(P.x,P.y,P.z),b.nextPosition.values.push(P.x,P.y,P.z),i.negate(M,M),i.add(x,M,P),N.position.values.push(P.x,P.y,P.z),N.position.values.push(P.x,P.y,P.z),N.position.values.push(g.x,g.y,g.z,g.x,g.y,g.z),N.prevPosition.values.push(P.x,P.y,P.z),N.prevPosition.values.push(P.x,P.y,P.z),N.prevPosition.values.push(P.x,P.y,P.z),N.prevPosition.values.push(P.x,P.y,P.z),N.nextPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),N.nextPosition.values.push(d[3*R],d[3*R+1],d[3*R+2]),N.nextPosition.values.push(d[3*R+3],d[3*R+4],d[3*R+5]);var C=n.fromArray(h,2*v,Fe),D=Math.abs(C.y);b.expandAndWidth.values.push(-1,D,1,D),b.expandAndWidth.values.push(-1,-D,1,-D),N.expandAndWidth.values.push(-1,D,1,D),N.expandAndWidth.values.push(-1,-D,1,-D);var L=i.magnitudeSquared(i.subtract(x,A,je));if(L/=i.magnitudeSquared(i.subtract(g,A,je)),c(y)){var U=a.fromArray(y,4*v,Xe),F=a.fromArray(y,4*R,Xe),q=_.lerp(U.x,F.x,L),z=_.lerp(U.y,F.y,L),B=_.lerp(U.z,F.z,L),j=_.lerp(U.w,F.w,L);for(r=4*v;r<4*v+8;++r)b.color.values.push(y[r]);for(b.color.values.push(q,z,B,j),b.color.values.push(q,z,B,j),N.color.values.push(q,z,B,j),N.color.values.push(q,z,B,j),r=4*R;r<4*R+8;++r)N.color.values.push(y[r])}if(c(p)){var G=n.fromArray(p,2*v,Fe),V=n.fromArray(p,2*(t+3),qe),W=_.lerp(G.x,V.x,L);for(r=2*v;r<2*v+4;++r)b.st.values.push(p[r]);for(b.st.values.push(W,G.y),b.st.values.push(W,V.y),N.st.values.push(W,G.y),N.st.values.push(W,V.y),r=2*R;r<2*R+4;++r)N.st.values.push(p[r])}o=b.position.values.length/3-4,S.push(o,o+2,o+1),S.push(o+1,o+2,o+3),o=N.position.values.length/3-4,I.push(o,o+2,o+1),I.push(o+1,o+2,o+3)}else{var X,H;for(A.y<0?(X=E.attributes,H=E.indices):(X=m.attributes,H=m.indices),X.position.values.push(A.x,A.y,A.z),X.position.values.push(A.x,A.y,A.z),X.position.values.push(g.x,g.y,g.z),X.position.values.push(g.x,g.y,g.z),r=3*t;r<3*t+12;++r)X.prevPosition.values.push(f[r]),X.nextPosition.values.push(d[r]);for(r=2*t;r<2*t+8;++r)X.expandAndWidth.values.push(h[r]),c(p)&&X.st.values.push(p[r]);if(c(y))for(r=4*t;r<4*t+16;++r)X.color.values.push(y[r]);o=X.position.values.length/3-4,H.push(o,o+2,o+1),H.push(o+1,o+2,o+3)}}O&&($(E),$(m)),k(e,E,m)}var te={};te.toWireframe=function(e){if(!c(e))throw new l("geometry is required.");var t=e.indices;if(c(t)){switch(e.primitiveType){case R.TRIANGLES:e.indices=b(t);break;case R.TRIANGLE_STRIP:e.indices=S(t);break;case R.TRIANGLE_FAN:e.indices=N(t);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=R.LINES}return e},te.createLineSegmentsForVectors=function(e,t,n){if(t=s(t,"normal"),!c(e))throw new l("geometry is required.");if(!c(e.attributes.position))throw new l("geometry.attributes.position is required.");if(!c(e.attributes[t]))throw new l("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");n=s(n,1e4);for(var i=e.attributes.position.values,a=e.attributes[t].values,o=i.length,f=new Float64Array(2*o),d=0,y=0;y<o;y+=3)f[d++]=i[y],f[d++]=i[y+1],f[d++]=i[y+2],f[d++]=i[y]+a[y]*n,f[d++]=i[y+1]+a[y+1]*n,f[d++]=i[y+2]+a[y+2]*n;var m,E=e.boundingSphere;return c(E)&&(m=new r(E.center,E.radius+n)),new h({attributes:{position:new p({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:f})},primitiveType:R.LINES,boundingSphere:m})},te.createAttributeLocations=function(e){if(!c(e))throw new l("geometry is required.");var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,i={},a=0,o=r.length;for(t=0;t<o;++t){var u=r[t];c(n[u])&&(i[u]=a++)}for(var s in n)n.hasOwnProperty(s)&&!c(i[s])&&(i[s]=a++);return i},te.reorderForPreVertexCache=function(e){if(!c(e))throw new l("geometry is required.");var t=h.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),i=0;i<t;i++)n[i]=-1;for(var a,o=r,s=o.length,f=m.createTypedArray(t,s),d=0,p=0,y=0;d<s;)a=n[o[d]],a!==-1?f[p]=a:(a=o[d],n[a]=y,f[p]=y,++y),++d,++p;e.indices=f;var E=e.attributes;for(var w in E)if(E.hasOwnProperty(w)&&c(E[w])&&c(E[w].values)){for(var _=E[w],O=_.values,T=0,v=_.componentsPerAttribute,R=u.createTypedArray(_.componentDatatype,y*v);T<t;){var A=n[T];if(A!==-1)for(i=0;i<v;i++)R[v*A+i]=O[v*T+i];++T}_.values=R}}return e},te.reorderForPostVertexCache=function(e,t){if(!c(e))throw new l("geometry is required.");var r=e.indices;if(e.primitiveType===R.TRIANGLES&&c(r)){for(var n=r.length,i=0,a=0;a<n;a++)r[a]>i&&(i=r[a]);e.indices=A.tipsify({indices:r,maximumIndex:i,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){if(!c(e))throw new l("geometry is required.");if(c(e.indices)&&e.primitiveType!==R.TRIANGLES&&e.primitiveType!==R.LINES&&e.primitiveType!==R.POINTS)throw new l("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],r=h.computeNumberOfVertices(e);if(c(e.indices)&&r>=_.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=I(e.attributes),s=e.indices,f=s.length;e.primitiveType===R.TRIANGLES?n=3:e.primitiveType===R.LINES?n=2:e.primitiveType===R.POINTS&&(n=1);for(var d=0;d<f;d+=n){for(var p=0;p<n;++p){var y=s[d+p],m=i[y];c(m)||(m=o++,i[y]=m,x(u,e.attributes,y)),a.push(m)}o+n>=_.SIXTY_FOUR_KILOBYTES&&(t.push(new h({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],a=[],o=0,u=I(e.attributes))}0!==a.length&&t.push(new h({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new i,ne=new o;te.projectTo2D=function(e,t,r,n,a){if(!c(e))throw new l("geometry is required.");if(!c(t))throw new l("attributeName is required.");if(!c(r))throw new l("attributeName3D is required.");if(!c(n))throw new l("attributeName2D is required.");if(!c(e.attributes[t]))throw new l("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var o=e.attributes[t];a=c(a)?a:new d;for(var s=a.ellipsoid,f=o.values,h=new Float64Array(f.length),y=0,m=0;m<f.length;m+=3){var E=i.fromArray(f,m,re),w=s.cartesianToCartographic(E,ne);if(!c(w))throw new l("Could not project point ("+E.x+", "+E.y+", "+E.z+") to 2D.");var _=a.project(w,re);h[y++]=_.x,h[y++]=_.y,h[y++]=_.z}return e.attributes[r]=o,e.attributes[n]=new p({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:h}),delete e.attributes[t],e};var ie={high:0,low:0};te.encodeAttribute=function(e,t,r,n){if(!c(e))throw new l("geometry is required.");if(!c(t))throw new l("attributeName is required.");if(!c(r))throw new l("attributeHighName is required.");if(!c(n))throw new l("attributeLowName is required.");if(!c(e.attributes[t]))throw new l("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[t],a=i.values,o=a.length,s=new Float32Array(o),d=new Float32Array(o),h=0;h<o;++h)f.encode(a[h],ie),s[h]=ie.high,d[h]=ie.low;var y=i.componentsPerAttribute;return e.attributes[r]=new p({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:s}),e.attributes[n]=new p({componentDatatype:u.FLOAT,componentsPerAttribute:y,values:d}),delete e.attributes[t],e};var ae=new i,oe=new T,ue=new O;te.transformToWorldCoordinates=function(e){if(!c(e))throw new l("instance is required.");var t=e.modelMatrix;if(T.equals(t,T.IDENTITY))return e;var n=e.geometry.attributes;M(t,n.position),M(t,n.prevPosition),M(t,n.nextPosition),(c(n.normal)||c(n.tangent)||c(n.bitangent))&&(T.inverse(t,oe),T.transpose(oe,oe),T.getRotation(oe,ue),P(ue,n.normal),P(ue,n.tangent),P(ue,n.bitangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=r.transform(i,t,i)),e.modelMatrix=T.clone(T.IDENTITY),e};var se=new i;te.combineInstances=function(e){if(!c(e)||e.length<1)throw new l("instances is required and must have length greater than zero.");for(var t=[],r=[],n=e.length,i=0;i<n;++i){var a=e[i];c(a.geometry)?t.push(a):c(a.westHemisphereGeometry)&&c(a.eastHemisphereGeometry)&&r.push(a)}var o=[];return t.length>0&&o.push(D(t,"geometry")),r.length>0&&(o.push(D(r,"westHemisphereGeometry")),
o.push(D(r,"eastHemisphereGeometry"))),o};var ce=new i,le=new i,fe=new i,de=new i;te.computeNormal=function(e){if(!c(e))throw new l("geometry is required.");if(!c(e.attributes.position)||!c(e.attributes.position.values))throw new l("geometry.attributes.position.values is required.");if(!c(e.indices))throw new l("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==R.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var t=e.indices,r=e.attributes,n=r.position.values,a=r.position.values.length/3,o=t.length,s=new Array(a),f=new Array(o/3),d=new Array(o),h=0;h<a;h++)s[h]={indexOffset:0,count:0,currentCount:0};var y=0;for(h=0;h<o;h+=3){var m=t[h],E=t[h+1],w=t[h+2],O=3*m,T=3*E,v=3*w;le.x=n[O],le.y=n[O+1],le.z=n[O+2],fe.x=n[T],fe.y=n[T+1],fe.z=n[T+2],de.x=n[v],de.y=n[v+1],de.z=n[v+2],s[m].count++,s[E].count++,s[w].count++,i.subtract(fe,le,fe),i.subtract(de,le,de),f[y]=i.cross(fe,de,new i),y++}var A=0;for(h=0;h<a;h++)s[h].indexOffset+=A,A+=s[h].count;y=0;var g;for(h=0;h<o;h+=3){g=s[t[h]];var b=g.indexOffset+g.currentCount;d[b]=y,g.currentCount++,g=s[t[h+1]],b=g.indexOffset+g.currentCount,d[b]=y,g.currentCount++,g=s[t[h+2]],b=g.indexOffset+g.currentCount,d[b]=y,g.currentCount++,y++}var S=new Float32Array(3*a);for(h=0;h<a;h++){var N=3*h;if(g=s[h],i.clone(i.ZERO,ce),g.count>0){for(y=0;y<g.count;y++)i.add(ce,f[d[g.indexOffset+y]],ce);i.equalsEpsilon(i.ZERO,ce,_.EPSILON10)&&i.clone(f[d[g.indexOffset]],ce)}i.equalsEpsilon(i.ZERO,ce,_.EPSILON10)&&(ce.z=1),i.normalize(ce,ce),S[N]=ce.x,S[N+1]=ce.y,S[N+2]=ce.z}return e.attributes.normal=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var he=new i,pe=new i,ye=new i;te.computeTangentAndBitangent=function(e){if(!c(e))throw new l("geometry is required.");var t=e.attributes,r=e.indices;if(!c(t.position)||!c(t.position.values))throw new l("geometry.attributes.position.values is required.");if(!c(t.normal)||!c(t.normal.values))throw new l("geometry.attributes.normal.values is required.");if(!c(t.st)||!c(t.st.values))throw new l("geometry.attributes.st.values is required.");if(!c(r))throw new l("geometry.indices is required.");if(r.length<2||r.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==R.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var n=e.attributes.position.values,a=e.attributes.normal.values,o=e.attributes.st.values,s=e.attributes.position.values.length/3,f=r.length,d=new Array(3*s),h=0;h<d.length;h++)d[h]=0;var y,m,E;for(h=0;h<f;h+=3){var w=r[h],_=r[h+1],O=r[h+2];y=3*w,m=3*_,E=3*O;var T=2*w,v=2*_,A=2*O,g=n[y],b=n[y+1],S=n[y+2],N=o[T],I=o[T+1],x=o[v+1]-I,M=o[A+1]-I,P=1/((o[v]-N)*M-(o[A]-N)*x),C=(M*(n[m]-g)-x*(n[E]-g))*P,D=(M*(n[m+1]-b)-x*(n[E+1]-b))*P,L=(M*(n[m+2]-S)-x*(n[E+2]-S))*P;d[y]+=C,d[y+1]+=D,d[y+2]+=L,d[m]+=C,d[m+1]+=D,d[m+2]+=L,d[E]+=C,d[E+1]+=D,d[E+2]+=L}var U=new Float32Array(3*s),F=new Float32Array(3*s);for(h=0;h<s;h++){y=3*h,m=y+1,E=y+2;var q=i.fromArray(a,y,he),z=i.fromArray(d,y,ye),B=i.dot(q,z);i.multiplyByScalar(q,B,pe),i.normalize(i.subtract(z,pe,z),z),U[y]=z.x,U[m]=z.y,U[E]=z.z,i.normalize(i.cross(q,z,z),z),F[y]=z.x,F[m]=z.y,F[E]=z.z}return e.attributes.tangent=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:U}),e.attributes.bitangent=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:F}),e};var me=new n,Ee=new i,we=new i,_e=new i,Oe=new n;te.compressVertices=function(t){if(!c(t))throw new l("geometry is required.");var r,a,o=t.attributes.extrudeDirection;if(c(o)){var s=o.values;a=s.length/3;var f=new Float32Array(2*a),d=0;for(r=0;r<a;++r)i.fromArray(s,3*r,Ee),i.equals(Ee,i.ZERO)?d+=2:(Oe=e.octEncodeInRange(Ee,65535,Oe),f[d++]=Oe.x,f[d++]=Oe.y);return t.attributes.compressedAttributes=new p({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:f}),delete t.attributes.extrudeDirection,t}var h=t.attributes.normal,y=t.attributes.st,m=c(h),E=c(y);if(!m&&!E)return t;var w,_,O,T,v=t.attributes.tangent,R=t.attributes.bitangent,A=c(v),g=c(R);m&&(w=h.values),E&&(_=y.values),A&&(O=v.values),g&&(T=R.values);var b=m?w.length:_.length,S=m?3:2;a=b/S;var N=a,I=E&&m?2:1;I+=A||g?1:0,N*=I;var x=new Float32Array(N),M=0;for(r=0;r<a;++r){E&&(n.fromArray(_,2*r,me),x[M++]=e.compressTextureCoordinates(me));var P=3*r;m&&c(O)&&c(T)?(i.fromArray(w,P,Ee),i.fromArray(O,P,we),i.fromArray(T,P,_e),e.octPack(Ee,we,_e,me),x[M++]=me.x,x[M++]=me.y):(m&&(i.fromArray(w,P,Ee),x[M++]=e.octEncodeFloat(Ee)),A&&(i.fromArray(O,P,Ee),x[M++]=e.octEncodeFloat(Ee)),g&&(i.fromArray(T,P,Ee),x[M++]=e.octEncodeFloat(Ee)))}return t.attributes.compressedAttributes=new p({componentDatatype:u.FLOAT,componentsPerAttribute:I,values:x}),m&&delete t.attributes.normal,E&&delete t.attributes.st,g&&delete t.attributes.bitangent,A&&delete t.attributes.tangent,t};var Te=new i,ve=new i,Re=new i,Ae=new i,ge=new i,be={positions:new Array(7),indices:new Array(9)},Se=new i,Ne=new i,Ie=new i,xe=new i,Me=new n,Pe=new n,Ce=new n,De=v.fromPointNormal(i.ZERO,i.UNIT_Y),Le=new i,Ue=new i,Fe=new n,qe=new n,ze=new i,Be=new i,je=new i,Ge=new i,Ve=new i,We=new i,Xe=new a,He=5*_.EPSILON9,Ye=_.EPSILON6;return te.splitLongitude=function(e){if(!c(e))throw new l("instance is required.");var t=e.geometry,n=t.boundingSphere;if(c(n)){var i=n.center.x-n.radius;if(i>0||r.intersectPlane(n,v.ORIGIN_ZX_PLANE)!==E.INTERSECTING)return e}if(t.geometryType!==y.NONE)switch(t.geometryType){case y.POLYLINES:ee(e);break;case y.TRIANGLES:J(e);break;case y.LINES:Q(e)}else j(t),t.primitiveType===R.TRIANGLES?J(e):t.primitiveType===R.LINES&&Q(e);return e},te}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,n,i){return t(e).then(r,n,i)}function t(e){var t,r;return e instanceof n?t=e:u(e)?(r=o(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=i(e),t}function r(t){return e(t,a)}function n(e){this.then=e}function i(e){var r=new n(function(r){try{return t(r?r(e):e)}catch(e){return a(e)}});return r}function a(e){var r=new n(function(r,n){try{return n?t(n(e)):a(e)}catch(e){return a(e)}});return r}function o(){function e(e,t,r){return d(e,t,r)}function r(e){return p(e)}function i(e){return p(a(e))}function u(e){return h(e)}var s,c,l,f,d,h,p;return c=new n(e),s={then:e,resolve:r,reject:i,progress:u,promise:c,resolver:{resolve:r,reject:i,progress:u}},l=[],f=[],d=function(e,t,r){var n,i;return n=o(),i="function"==typeof r?function(e){try{n.progress(r(e))}catch(e){n.progress(e)}}:function(e){n.progress(e)},l.push(function(r){r.then(e,t).then(n.resolve,n.reject,i)}),f.push(i),n.promise},h=function(e){return y(f,e),e},p=function(e){return e=t(e),d=e.then,p=t,h=E,y(l,e),f=l=T,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,r,n,i,a){return m(2,arguments),e(t,function(t){function u(e){y(e)}function s(e){p(e)}var c,l,f,d,h,p,y,m,w,_;if(w=t.length>>>0,c=Math.max(0,Math.min(r,w)),f=[],l=w-c+1,d=[],h=o(),c)for(m=h.progress,y=function(e){d.push(e),--l||(p=y=E,h.reject(d))},p=function(e){f.push(e),--c||(p=y=E,h.resolve(f))},_=0;_<w;++_)_ in t&&e(t[_],s,u,m);else h.resolve(f);return h.then(n,i,a)})}function c(e,t,r,n){function i(e){return t?t(e[0]):e[0]}return s(e,1,i,r,n)}function l(e,t,r,n){return m(1,arguments),d(e,w).then(t,r,n)}function f(){return d(arguments,w)}function d(t,r){return e(t,function(t){var n,i,a,u,s,c;if(a=i=t.length>>>0,n=[],c=o(),a)for(u=function(t,i){e(t,r).then(function(e){n[i]=e,--a||c.resolve(n)},c.reject)},s=0;s<i;s++)s in t?u(t[s],s):--a;else c.resolve(n);return c.promise})}function h(t,r){var n=O.call(arguments,1);return e(t,function(t){var i;return i=t.length,n[0]=function(t,n,a){return e(t,function(t){return e(n,function(e){return r(t,e,a,i)})})},_.apply(t,n)})}function p(t,r,n){var i=arguments.length>2;return e(t,function(e){return e=i?n:e,r.resolve(e),e},function(e){return r.reject(e),a(e)},r.progress)}function y(e,t){for(var r,n=0;r=e[n++];)r(t)}function m(e,t){for(var r,n=t.length;n>e;)if(r=t[--n],null!=r&&"function"!=typeof r)throw new Error("arg "+n+" must be a function")}function E(){}function w(e){return e}var _,O,T;return e.defer=o,e.resolve=t,e.reject=r,e.join=f,e.all=l,e.map=d,e.reduce=h,e.any=c,e.some=s,e.chain=p,e.isPromise=u,n.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(T,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(T,t)})})}},O=[].slice,_=[].reduce||function(e){var t,r,n,i,a;if(a=0,t=Object(this),i=t.length>>>0,r=arguments,r.length<=1)for(;;){if(a in t){n=t[a++];break}if(++a>=i)throw new TypeError}else n=r[1];for(;a<i;++a)a in t&&(n=e(n,t[a],a,t));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";function r(r,n,i){if(!e(r))throw new t("array is required.");if(!e(n))throw new t("itemToFind is required.");if(!e(i))throw new t("comparator is required.");for(var a,o,u=0,s=r.length-1;u<=s;)if(a=~~((u+s)/2),o=i(r[a],n),o<0)u=a+1;else{if(!(o>0))return a;s=a-1}return~(s+1)}return r}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,r,n,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=n,this.ut1MinusUtc=i}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,n=t[r++],i=function(e,t,r,n){r||(r=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return n?e+i:i+e},a=function(e,t,r,n,a,o){var u=n-e.length;return u>0&&(e=r||!a?i(e,n,o,r):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,r,n,o,u,s){var c=e>>>0;return r=r&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+i(c.toString(t),u||0,"0",!1),a(e,r,n,o,s)},u=function(e,t,r,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",t,r,i,o)},s=function(e,n,s,c,l,f,d){var h,p,y,m,E;if("%%"==e)return"%";for(var w=!1,_="",O=!1,T=!1,v=" ",R=s.length,A=0;s&&A<R;A++)switch(s.charAt(A)){case" ":_=" ";break;case"+":_="+";break;case"-":w=!0;break;case"'":v=s.charAt(A+1);break;case"0":O=!0;break;case"#":T=!0}if(c=c?"*"==c?+t[r++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,c<0&&(c=-c,w=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[r++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,E=n?t[n.slice(0,-1)]:t[r++],d){case"s":return u(String(E),w,c,f,O,v);case"c":return u(String.fromCharCode(+E),w,c,f,O);case"b":return o(E,2,T,w,c,f,O);case"o":return o(E,8,T,w,c,f,O);case"x":return o(E,16,T,w,c,f,O);case"X":return o(E,16,T,w,c,f,O).toUpperCase();case"u":return o(E,10,T,w,c,f,O);case"i":case"d":return h=+E||0,h=Math.round(h-h%1),p=h<0?"-":_,E=p+i(String(Math.abs(h)),f,"0",!1),a(E,p,w,c,O);case"e":case"E":case"f":case"F":case"g":case"G":return h=+E,p=h<0?"-":_,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],E=p+Math.abs(h)[y](f),a(E,p,w,c,O)[m]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,r,n,i,a,o,u){this.year=e,this.month=t,this.day=r,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4===0&&t%100!==0||t%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,u,s,c){"use strict";function l(e,t){return y.compare(e.julianDate,t.julianDate)}function f(e){_.julianDate=e;var r=y.leapSeconds,n=t(r,_,l);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var i=r[n].offset;if(n>0){var a=y.secondsDifference(r[n].julianDate,e);a>i&&(n--,i=r[n].offset)}y.addSeconds(e,i,e)}function d(e,r){_.julianDate=e;var n=y.leapSeconds,i=t(n,_,l);if(i<0&&(i=~i),0===i)return y.addSeconds(e,-n[0].offset,r);if(i>=n.length)return y.addSeconds(e,-n[i-1].offset,r);var a=y.secondsDifference(n[i].julianDate,e);return 0===a?y.addSeconds(e,-n[i].offset,r):a<=1?void 0:y.addSeconds(e,-n[--i].offset,r)}function h(e,t,r){var n=t/s.SECONDS_PER_DAY|0;return e+=n,t-=s.SECONDS_PER_DAY*n,t<0&&(e--,t+=s.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function p(e,t,r,n,i,a,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+r-32075;n-=12,n<0&&(n+=24);var f=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function y(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),n=r(n,c.UTC);var i=0|e;t+=(e-i)*s.SECONDS_PER_DAY,h(i,t,this),n===c.UTC&&f(this)}var m=new a,E=[31,28,31,30,31,30,31,31,30,31,30,31],w=29,_=new u,O=/^(\d{4})$/,T=/^(\d{4})-(\d{2})$/,v=/^(\d{4})-?(\d{3})$/,R=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,A=/^(\d{4})-?(\d{2})-?(\d{2})$/,g=/([Z+\-])?(\d{2})?:?(\d{2})?$/,b=/^(\d{2})(\.\d+)?/.source+g.source,S=/^(\d{2}):?(\d{2})(\.\d+)?/.source+g.source,N=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+g.source,I="Invalid ISO 8601 date.";y.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var r=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(t)?(h(r[0],r[1],t),f(t),t):new y(r[0],r[1],c.UTC)},y.fromIso8601=function(e,t){if("string"!=typeof e)throw new i(I);e=e.replace(",",".");var r,a,u,s=e.split("T"),l=1,d=1,m=0,_=0,g=0,x=0,M=s[0],P=s[1];if(!n(M))throw new i(I);var C;if(s=M.match(A),null!==s){if(C=M.split("-").length-1,C>0&&2!==C)throw new i(I);r=+s[1],l=+s[2],d=+s[3]}else if(s=M.match(T),null!==s)r=+s[1],l=+s[2];else if(s=M.match(O),null!==s)r=+s[1];else{var D;if(s=M.match(v),null!==s){if(r=+s[1],D=+s[2],u=o(r),D<1||u&&D>366||!u&&D>365)throw new i(I)}else{if(s=M.match(R),null===s)throw new i(I);r=+s[1];var L=+s[2],U=+s[3]||0;if(C=M.split("-").length-1,C>0&&(!n(s[3])&&1!==C||n(s[3])&&2!==C))throw new i(I);var F=new Date(Date.UTC(r,0,4));D=7*L+U-F.getUTCDay()-3}a=new Date(Date.UTC(r,0,1)),a.setUTCDate(D),l=a.getUTCMonth()+1,d=a.getUTCDate()}if(u=o(r),l<1||l>12||d<1||(2!==l||!u)&&d>E[l-1]||u&&2===l&&d>w)throw new i(I);var q;if(n(P)){if(s=P.match(N),null!==s){if(C=P.split(":").length-1,C>0&&2!==C&&3!==C)throw new i(I);m=+s[1],_=+s[2],g=+s[3],x=1e3*+(s[4]||0),q=5}else if(s=P.match(S),null!==s){if(C=P.split(":").length-1,C>2)throw new i(I);m=+s[1],_=+s[2],g=60*+(s[3]||0),q=4}else{if(s=P.match(b),null===s)throw new i(I);m=+s[1],_=60*+(s[2]||0),q=3}if(_>=60||g>=61||m>24||24===m&&(_>0||g>0||x>0))throw new i(I);var z=s[q],B=+s[q+1],j=+(s[q+2]||0);switch(z){case"+":m-=B,_-=j;break;case"-":m+=B,_+=j;break;case"Z":break;default:_+=new Date(Date.UTC(r,l-1,d,m,_)).getTimezoneOffset()}}else _+=new Date(r,l-1,d).getTimezoneOffset();var G=60===g;for(G&&g--;_>=60;)_-=60,m++;for(;m>=24;)m-=24,d++;for(a=u&&2===l?w:E[l-1];d>a;)d-=a,l++,l>12&&(l-=12,r++),a=u&&2===l?w:E[l-1];for(;_<0;)_+=60,m--;for(;m<0;)m+=24,d--;for(;d<1;)l--,l<1&&(l+=12,r--),a=u&&2===l?w:E[l-1],d+=a;var V=p(r,l,d,m,_,g,x);return n(t)?(h(V[0],V[1],t),f(t)):t=new y(V[0],V[1],c.UTC),G&&y.addSeconds(t,1,t),t},y.now=function(e){return y.fromDate(new Date,e)};var x=new y(0,0,c.TAI);return y.toGregorianDate=function(e,t){if(!n(e))throw new i("julianDate is required.");var r=!1,o=d(e,x);n(o)||(y.addSeconds(e,-1,x),o=d(x,x),r=!0);var u=o.dayNumber,c=o.secondsOfDay;c>=43200&&(u+=1);var l=u+68569|0,f=4*l/146097|0;l=l-((146097*f+3)/4|0)|0;var h=4e3*(l+1)/1461001|0;l=l-(1461*h/4|0)+31|0;var p=80*l/2447|0,m=l-(2447*p/80|0)|0;l=p/11|0;var E=p+2-12*l|0,w=100*(f-49)+h+l|0,_=c/s.SECONDS_PER_HOUR|0,O=c-_*s.SECONDS_PER_HOUR,T=O/s.SECONDS_PER_MINUTE|0;O-=T*s.SECONDS_PER_MINUTE;var v=0|O,R=(O-v)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(v+=1),n(t)?(t.year=w,t.month=E,t.day=m,t.hour=_,t.minute=T,t.second=v,t.millisecond=R,t.isLeapSecond=r,t):new a(w,E,m,_,T,v,R,r)},y.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var t=y.toGregorianDate(e,m),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},y.toIso8601=function(t,r){if(!n(t))throw new i("julianDate is required.");var a,o=y.toGregorianDate(t,o);return n(r)||0===o.millisecond?n(r)&&0!==r?(a=(.01*o.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(a=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,a))},y.clone=function(e,t){if(n(e))return n(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new y(e.dayNumber,e.secondsOfDay,c.TAI)},y.compare=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},y.equals=function(e,t){return e===t||n(e)&&n(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},y.equalsEpsilon=function(e,t,r){if(!n(r))throw new i("epsilon is required.");return e===t||n(e)&&n(t)&&Math.abs(y.secondsDifference(e,t))<=r},y.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},y.secondsDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},y.daysDifference=function(e,t){if(!n(e))throw new i("left is required.");if(!n(t))throw new i("right is required.");var r=e.dayNumber-t.dayNumber,a=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return r+a},y.computeTaiMinusUtc=function(e){_.julianDate=e;var r=y.leapSeconds,n=t(r,_,l);return n<0&&(n=~n,--n,n<0&&(n=0)),r[n].offset},y.addSeconds=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("seconds is required.");if(!n(r))throw new i("result is required.");return h(e.dayNumber,e.secondsOfDay+t,r)},y.addMinutes=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("minutes is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return h(e.dayNumber,a,r)},y.addHours=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("hours is required.");if(!n(r))throw new i("result is required.");var a=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return h(e.dayNumber,a,r)},y.addDays=function(e,t,r){if(!n(e))throw new i("julianDate is required.");if(!n(t))throw new i("days is required.");if(!n(r))throw new i("result is required.");var a=e.dayNumber+t;return h(a,e.secondsOfDay,r)},y.lessThan=function(e,t){return y.compare(e,t)<0},y.lessThanOrEquals=function(e,t){return y.compare(e,t)<=0},y.greaterThan=function(e,t){return y.compare(e,t)>0},y.greaterThanOrEquals=function(e,t){return y.compare(e,t)>=0},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y.prototype.equalsEpsilon=function(e,t){return y.equalsEpsilon(this,e,t)},y.prototype.toString=function(){return y.toIso8601(this)},y.leapSeconds=[new u(new y(2441317,43210,c.TAI),10),new u(new y(2441499,43211,c.TAI),11),new u(new y(2441683,43212,c.TAI),12),new u(new y(2442048,43213,c.TAI),13),new u(new y(2442413,43214,c.TAI),14),new u(new y(2442778,43215,c.TAI),15),new u(new y(2443144,43216,c.TAI),16),new u(new y(2443509,43217,c.TAI),17),new u(new y(2443874,43218,c.TAI),18),new u(new y(2444239,43219,c.TAI),19),new u(new y(2444786,43220,c.TAI),20),new u(new y(2445151,43221,c.TAI),21),new u(new y(2445516,43222,c.TAI),22),new u(new y(2446247,43223,c.TAI),23),new u(new y(2447161,43224,c.TAI),24),new u(new y(2447892,43225,c.TAI),25),new u(new y(2448257,43226,c.TAI),26),new u(new y(2448804,43227,c.TAI),27),new u(new y(2449169,43228,c.TAI),28),new u(new y(2449534,43229,c.TAI),29),new u(new y(2450083,43230,c.TAI),30),new u(new y(2450630,43231,c.TAI),31),new u(new y(2451179,43232,c.TAI),32),new u(new y(2453736,43233,c.TAI),33),new u(new y(2454832,43234,c.TAI),34),new u(new y(2456109,43235,c.TAI),35),new u(new y(2457204,43236,c.TAI),36),new u(new y(2457754,43237,c.TAI),37)],y}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(r,n){if(null===r||"object"!=typeof r)return r;n=e(n,!1);var i=new r.constructor;for(var a in r)if(r.hasOwnProperty(a)){var o=r[a];n&&(o=t(o,n)),i[a]=o}return i}return t}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),n=0;n<r.length;++n){var i=r[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function r(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=n.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function r(e,t,r,n){return(t||"")+r.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,r).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],n=""==t[0];n&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);"."!=e&&".."!=e||r.push(""),n&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r){var n=new e(r);n.normalize();var i=n.getAuthority();if(t(i)){if(i.indexOf("@")!==-1){var a=i.split("@");i=a[1]}if(i.indexOf(":")===-1){var o=n.getScheme();if(t(o)||(o=window.location.protocol,o=o.substring(0,o.length-1)),"http"===o)i+=":80";else{if("https"!==o)return;i+=":443"}}return i}}var i={},a={};return i.add=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(a[i])||(a[i]=!0)},i.remove=function(e,n){if(!t(e))throw new r("host is required.");if(!t(n)||n<=0)throw new r("port is required to be greater than 0.");var i=e.toLowerCase()+":"+n;t(a[i])&&delete a[i]},i.contains=function(e){if(!t(e))throw new r("url is required.");var i=n(e);return!(!t(i)||!t(a[i]))},i.clear=function(){a={}},i}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError","./TrustedServers"],function(e,t,r,n,i,a,o){"use strict";function u(i){if(i=t(i,t.EMPTY_OBJECT),!r(i.url))throw new n("options.url is required.");var a=i.responseType,o=t(i.method,"GET"),s=i.data,c=i.headers,l=i.overrideMimeType;return e(i.url,function(t){var r=e.defer();return u.load(t,a,o,s,c,r,l),r.promise})}function s(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function c(e,t){for(var r=s(e,t),n=new ArrayBuffer(r.length),i=new Uint8Array(n),a=0;a<r.length;a++)i[a]=r.charCodeAt(a);return n}function l(e,r){r=t(r,"");var i=e[1],a=!!e[2],o=e[3];switch(r){case"":case"text":return s(a,o);case"arraybuffer":return c(a,o);case"blob":var u=c(a,o);return new Blob([u],{type:i});case"document":var l=new DOMParser;return l.parseFromString(s(a,o),i);case"json":return JSON.parse(s(a,o));default:throw new n("Unhandled responseType: "+r)}}var f=/^data:(.*?)(;base64)?,(.*)$/;return u.load=function(e,t,n,u,s,c,d){var h=f.exec(e);if(null!==h)return void c.resolve(l(h,t));var p=new XMLHttpRequest;if(o.contains(e)&&(p.withCredentials=!0),r(d)&&r(p.overrideMimeType)&&p.overrideMimeType(d),p.open(n,e,!0),r(s))for(var y in s)s.hasOwnProperty(y)&&p.setRequestHeader(y,s[y]);r(t)&&(p.responseType=t),p.onload=function(){if(p.status<200||p.status>=300)return void c.reject(new i(p.status,p.response,p.getAllResponseHeaders()));var e=p.response,n=p.responseType;if(!r(e)||r(t)&&n!==t)if("json"===t&&"string"==typeof e)try{c.resolve(JSON.parse(e))}catch(e){c.reject(e)}else(""===n||"document"===n)&&r(p.responseXML)&&p.responseXML.hasChildNodes()?c.resolve(p.responseXML):""!==n&&"text"!==n||!r(p.responseText)?c.reject(new a("Invalid XMLHttpRequest response type.")):c.resolve(p.responseText);else c.resolve(e)},p.onerror=function(e){c.reject(new i)},p.send(u)},u.defaultLoad=u.load,u}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";function t(t,r){return e({url:t,headers:r})}return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,r,n){"use strict";function i(i,o){if(!t(i))throw new r("url is required.");return t(o)?t(o.Accept)||(o=e(o),o.Accept=a.Accept):o=a,n(i,o).then(function(e){return JSON.parse(e)})}var a={Accept:"application/json,*/*;q=0.01"};return i}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,n,i,a,o,u,s,c,l,f){"use strict";function d(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),n(t.data))p(this,t.data);else if(n(t.url)){var i=this;this._downloadPromise=e(s(t.url),function(e){p(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else p(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function h(e,t){return o.compare(e.julianDate,t)}function p(e,r){if(!n(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=r.columnNames.indexOf("modifiedJulianDateUtc"),a=r.columnNames.indexOf("xPoleWanderRadians"),s=r.columnNames.indexOf("yPoleWanderRadians"),c=r.columnNames.indexOf("ut1MinusUtcSeconds"),d=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=r.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||a<0||s<0||c<0||d<0||p<0||y<0)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var m=e._samples=r.samples,E=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=y,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var w,_=e._addNewLeapSeconds,O=0,T=m.length;O<T;O+=e._columnCount){var v=m[O+i],R=m[O+y],A=v+l.MODIFIED_JULIAN_DATE_DIFFERENCE,g=new o(A,R,f.TAI);if(E.push(g),_){if(R!==w&&n(w)){var b=o.leapSeconds,S=t(b,g,h);if(S<0){var N=new u(g,R);b.splice(~S,0,N)}}w=R}}}function y(e,t,r,n,i){var a=r*n;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function m(e,t,r){return t+e*(r-t)}function E(e,t,r,n,i,a,u){var s=e._columnCount;if(a>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],l=t[a];if(c.equals(l)||n.equals(c))return y(e,r,i,s,u),u;if(n.equals(l))return y(e,r,a,s,u),u;var f=o.secondsDifference(n,c)/o.secondsDifference(l,c),d=i*s,h=a*s,p=r[d+e._ut1MinusUtcSecondsColumn],E=r[h+e._ut1MinusUtcSecondsColumn],w=E-p;if(w>.5||w<-.5){var _=r[d+e._taiMinusUtcSecondsColumn],O=r[h+e._taiMinusUtcSecondsColumn];_!==O&&(l.equals(n)?p=E:E-=O-_)}return u.xPoleWander=m(f,r[d+e._xPoleWanderRadiansColumn],r[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,r[d+e._yPoleWanderRadiansColumn],r[h+e._yPoleWanderRadiansColumn]),
u.xPoleOffset=m(f,r[d+e._xCelestialPoleOffsetRadiansColumn],r[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,r[d+e._yCelestialPoleOffsetRadiansColumn],r[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,p,E),u}return d.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return n(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),d.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},d.prototype.compute=function(e,r){if(n(this._samples)){if(n(r)||(r=new i(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var a=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var f=a[u],d=a[u+1],h=o.lessThanOrEquals(f,e),p=!n(d),y=p||o.greaterThanOrEquals(d,e);if(h&&y)return s=u,!p&&d.equals(e)&&++s,l=s+1,E(this,a,this._samples,e,s,l,r),r}var m=t(a,e,o.compare,this._dateColumn);return m>=0?(m<a.length-1&&a[m+1].equals(e)&&++m,s=m,l=m):(l=~m,s=l-1,s<0&&(s=0)),this._lastIndex=s,E(this,a,this._samples,e,s,l,r),r}if(n(this._dataError))throw new c(this._dataError)},d}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(i,a){if(!r(i))throw new n("relative uri is required.");a=t(a,document.location.href);var o=new e(a),u=new e(i);return u.resolve(o).toString()}return i}),define("Core/joinUrls",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function i(i,a,o){if(!r(i))throw new n("first is required");if(!r(a))throw new n("second is required");o=t(o,!0),i instanceof e||(i=new e(i)),a instanceof e||(a=new e(a)),r(a.authority)&&!r(a.scheme)&&("undefined"!=typeof document&&r(document.location)&&r(document.location.href)?a.scheme=new e(document.location.href).scheme:a.scheme=i.scheme);var u=i;a.isAbsolute()&&(u=a);var s="";r(u.scheme)&&(s+=u.scheme+":"),r(u.authority)&&(s+="//"+u.authority,""!==u.path&&"/"!==u.path&&(s=s.replace(/\/?$/,"/"),u.path=u.path.replace(/^\/?/g,""))),s+=u===i?o?i.path.replace(/\/?$/,"/")+a.path.replace(/^\/?/g,""):i.path+a.path:a.path;var c=r(i.query),l=r(a.query);c&&l?s+="?"+i.query+"&"+a.query:c&&!l?s+="?"+i.query:!c&&l&&(s+="?"+a.query);var f=r(a.fragment);return r(i.fragment)&&!f?s+="#"+i.fragment:f&&(s+="#"+a.fragment),s}return i}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","./getAbsoluteUri","./joinUrls","require"],function(e,t,r,n,i,a){"use strict";function o(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;t<r;++t){var n=e[t].getAttribute("src"),i=p.exec(n);if(null!==i)return i[1]}}function u(){if(t(f))return f;var i;if(i="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:o(),!t(i))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return f=new e(n(i))}function s(e){return a.toUrl("../"+e)}function c(e){return i(u(),e)}function l(e){t(d)||(d=t(a.toUrl)?s:c),t(h)||(h=document.createElement("a"));var r=d(e);return h.href=r,h.href=h.href,h.href}var f,d,h,p=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return l._cesiumScriptRegex=p,l.setBaseUrl=function(t){f=new e(t).resolve(new e(document.location.href))},l}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,r){this.x=e,this.y=t,this.s=r}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,r,n,i,a,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;s<=t;++s){n[s]=o,i[s]=s*this._stepSizeDays;for(var c=0;c<=t;++c)c!==s&&(n[s]*=s-c);n[s]=1/n[s]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,r){var n=f;return n.dayNumber=t,n.secondsOfDay=r,a.daysDifference(n,e._sampleZeroDateTT)}function l(r,i){if(r._chunkDownloadsInProgress[i])return r._chunkDownloadsInProgress[i];var a=e.defer();r._chunkDownloadsInProgress[i]=a;var u,s=r._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",i):t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(u),function(e){r._chunkDownloadsInProgress[i]=!1;for(var t=r._samples,n=e.samples,o=i*r._samplesPerXysFile*3,u=0,s=n.length;u<s;++u)t[o+u]=n[u];a.resolve()}),a.promise}var f=new a(0,0,u.TAI);return s.prototype.preload=function(t,r,n,i){var a=c(this,t,r),o=c(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,d=s/this._samplesPerXysFile|0,h=[],p=f;p<=d;++p)h.push(l(this,p));return e.all(h)},s.prototype.computeXysRadians=function(e,t,r){var a=c(this,e,t);if(!(a<0)){var o=a/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);s<0&&(s=0);var f=s+u;f>=this._totalSamples&&(f=this._totalSamples-1,s=f-u,s<0&&(s=0));var d=!1,h=this._samples;if(n(h[3*s])||(l(this,s/this._samplesPerXysFile|0),d=!0),n(h[3*f])||(l(this,f/this._samplesPerXysFile|0),d=!0),!d){n(r)?(r.x=0,r.y=0,r.s=0):r=new i(0,0,0);var p,y,m=a-s*this._stepSizeDays,E=this._work,w=this._denominators,_=this._coef,O=this._xTable;for(p=0;p<=u;++p)E[p]=m-O[p];for(p=0;p<=u;++p){for(_[p]=1,y=0;y<=u;++y)y!==p&&(_[p]*=E[y]);_[p]*=w[p];var T=3*(s+p);r.x+=_[p]*h[T++],r.y+=_[p]*h[T++],r.s+=_[p]*h[T]}return r}}}},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,n,i,a,o,u,s,c,l,f,d,h,p,y,m,E,w,_,O){"use strict";var T={},v={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},R={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},A={},g={east:new r,north:new r,up:new r,west:new r,south:new r,down:new r},b=new r,S=new r,N=new r;T.localFrameToFixedFrameGenerator=function(e,t){if(!v.hasOwnProperty(e)||!v[e].hasOwnProperty(t))throw new c("firstAxis and secondAxis must be east, north, up, west, south or down.");var n,i=v[e][t],a=e+t;return u(A[a])?n=A[a]:(n=function(n,a,s){if(!u(n))throw new c("origin is required.");if(u(s)||(s=new w),m.equalsEpsilon(n.x,0,m.EPSILON14)&&m.equalsEpsilon(n.y,0,m.EPSILON14)){var l=m.sign(n.z);r.unpack(R[e],0,b),"east"!==e&&"west"!==e&&r.multiplyByScalar(b,l,b),r.unpack(R[t],0,S),"east"!==t&&"west"!==t&&r.multiplyByScalar(S,l,S),r.unpack(R[i],0,N),"east"!==i&&"west"!==i&&r.multiplyByScalar(N,l,N)}else{a=o(a,d.WGS84),a.geodeticSurfaceNormal(n,g.up);var f=g.up,h=g.east;h.x=-n.y,h.y=n.x,h.z=0,r.normalize(h,g.east),r.cross(f,h,g.north),r.multiplyByScalar(g.up,-1,g.down),r.multiplyByScalar(g.east,-1,g.west),r.multiplyByScalar(g.north,-1,g.south),b=g[e],S=g[t],N=g[i]}return s[0]=b.x,s[1]=b.y,s[2]=b.z,s[3]=0,s[4]=S.x,s[5]=S.y,s[6]=S.z,s[7]=0,s[8]=N.x,s[9]=N.y,s[10]=N.z,s[11]=0,s[12]=n.x,s[13]=n.y,s[14]=n.z,s[15]=1,s},A[a]=n),n},T.eastNorthUpToFixedFrame=T.localFrameToFixedFrameGenerator("east","north"),T.northEastDownToFixedFrame=T.localFrameToFixedFrameGenerator("north","east"),T.northUpEastToFixedFrame=T.localFrameToFixedFrameGenerator("north","up"),T.northWestUpToFixedFrame=T.localFrameToFixedFrameGenerator("north","west");var I=new _,x=new r(1,1,1),M=new w;T.headingPitchRollToFixedFrame=function(e,t,n,i,u){a.typeOf.object("HeadingPitchRoll",t),i instanceof w&&(u=i,i=void 0,s("Transforms.headingPitchRollToFixedFrame(origin, headingPitchRoll, ellipsoid, result)","The method was deprecated in Cesium 1.31 and will be removed in version 1.33. Transforms.headingPitchRollToFixedFrame(origin, headingPitchRoll, ellipsoid, fixedFrameTransform, result) where fixedFrameTransform is a a 4x4 transformation matrix (see Transforms.localFrameToFixedFrameGenerator)")),i=o(i,T.eastNorthUpToFixedFrame);var c=_.fromHeadingPitchRoll(t,I),l=w.fromTranslationQuaternionRotationScale(r.ZERO,c,x,M);return u=i(e,n,u),w.multiply(u,l,u)};var P=new w,C=new E;T.headingPitchRollQuaternion=function(e,t,r,n,i){a.typeOf.object("HeadingPitchRoll",t),n instanceof _&&(i=n,n=void 0,s("Transforms.headingPitchRollQuaternion(origin, headingPitchRoll, ellipsoid, result)","The method was deprecated in Cesium 1.31 and will be removed in version 1.33. Transforms.headingPitchRollQuaternion(origin, headingPitchRoll, ellipsoid, fixedFrameTransform, result) where fixedFrameTransform is a a 4x4 transformation matrix (see Transforms.localFrameToFixedFrameGenerator)"));var o=T.headingPitchRollToFixedFrame(e,t,r,n,P),u=w.getRotation(o,C);return _.fromRotationMatrix(u,i)};var D=24110.54841,L=8640184.812866,U=.093104,F=-62e-7,q=1.1772758384668e-19,z=72921158553e-15,B=m.TWO_PI/86400,j=new y;T.computeTemeToPseudoFixedMatrix=function(e,t){if(!u(e))throw new c("date is required.");j=y.addSeconds(e,-y.computeTaiMinusUtc(e),j);var r,n=j.dayNumber,i=j.secondsOfDay,a=n-2451545;r=i>=43200?(a+.5)/O.DAYS_PER_JULIAN_CENTURY:(a-.5)/O.DAYS_PER_JULIAN_CENTURY;var o=D+r*(L+r*(U+r*F)),s=o*B%m.TWO_PI,l=z+q*(n-2451545.5),f=(i+.5*O.SECONDS_PER_DAY)%O.SECONDS_PER_DAY,d=s+l*f,h=Math.cos(d),p=Math.sin(d);return u(t)?(t[0]=h,t[1]=-p,t[2]=0,t[3]=p,t[4]=h,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new E(h,p,0,-p,h,0,0,0,1)},T.iau2006XysData=new h,T.earthOrientationParameters=l.NONE;var G=32.184,V=2451545;T.preloadIcrfFixed=function(t){var r=t.start.dayNumber,n=t.start.secondsOfDay+G,i=t.stop.dayNumber,a=t.stop.secondsOfDay+G,o=T.iau2006XysData.preload(r,n,i,a),u=T.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},T.computeIcrfToFixedMatrix=function(e,t){if(!u(e))throw new c("date is required.");u(t)||(t=new E);var r=T.computeFixedToIcrfMatrix(e,t);if(u(r))return E.transpose(r,t)};var W=new p(0,0,0),X=new f(0,0,0,0,0,0),H=new E,Y=new E;T.computeFixedToIcrfMatrix=function(e,t){if(!u(e))throw new c("date is required.");u(t)||(t=new E);var r=T.earthOrientationParameters.compute(e,X);if(u(r)){var n=e.dayNumber,i=e.secondsOfDay+G,a=T.iau2006XysData.computeXysRadians(n,i,W);if(u(a)){var o=a.x+r.xPoleOffset,s=a.y+r.yPoleOffset,l=1/(1+Math.sqrt(1-o*o-s*s)),f=H;f[0]=1-l*o*o,f[3]=-l*o*s,f[6]=o,f[1]=-l*o*s,f[4]=1-l*s*s,f[7]=s,f[2]=-o,f[5]=-s,f[8]=1-l*(o*o+s*s);var d=E.fromRotationZ(-a.s,Y),h=E.multiply(f,d,H),p=e.dayNumber,w=e.secondsOfDay-y.computeTaiMinusUtc(e)+r.ut1MinusUtc,_=p-2451545,v=w/O.SECONDS_PER_DAY,R=.779057273264+v+.00273781191135448*(_+v);R=R%1*m.TWO_PI;var A=E.fromRotationZ(R,Y),g=E.multiply(h,A,H),b=Math.cos(r.xPoleWander),S=Math.cos(r.yPoleWander),N=Math.sin(r.xPoleWander),I=Math.sin(r.yPoleWander),x=n-V+i/O.SECONDS_PER_DAY;x/=36525;var M=-47e-6*x*m.RADIANS_PER_DEGREE/3600,P=Math.cos(M),C=Math.sin(M),D=Y;return D[0]=b*P,D[1]=b*C,D[2]=N,D[3]=-S*C+I*N*P,D[4]=S*P+I*N*C,D[5]=-I*b,D[6]=-I*C-S*N*P,D[7]=I*P-S*N*C,D[8]=S*b,E.multiply(g,D,t)}}};var k=new n;T.pointToWindowCoordinates=function(e,t,r,n){return n=T.pointToGLWindowCoordinates(e,t,r,n),n.y=2*t[5]-n.y,n},T.pointToGLWindowCoordinates=function(e,r,i,a){if(!u(e))throw new c("modelViewProjectionMatrix is required.");if(!u(r))throw new c("viewportTransformation is required.");if(!u(i))throw new c("point is required.");u(a)||(a=new t);var o=k;return w.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,o),o),n.multiplyByScalar(o,1/o.w,o),w.multiplyByVector(r,o,o),t.fromCartesian4(o,a)};var Z=new r,K=new r,J=new r;T.rotationMatrixFromPositionVelocity=function(e,t,n,i){if(!u(e))throw new c("position is required.");if(!u(t))throw new c("velocity is required.");var a=o(n,d.WGS84).geodeticSurfaceNormal(e,Z),s=r.cross(t,a,K);r.equalsEpsilon(s,r.ZERO,m.EPSILON6)&&(s=r.clone(r.UNIT_X,s));var l=r.cross(s,t,J);return r.cross(t,l,s),r.negate(s,s),u(i)||(i=new E),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=s.x,i[4]=s.y,i[5]=s.z,i[6]=l.x,i[7]=l.y,i[8]=l.z,i};var Q=new i,$=new r,ee=new r,te=new n,re=new n,ne=new n,ie=new n,ae=new n,oe=new w,ue=new w;T.basisTo2D=function(e,t,i){if(!u(e))throw new c("projection is required.");if(!u(t))throw new c("matrix is required.");if(!u(i))throw new c("result is required.");var a=e.ellipsoid,o=w.getColumn(t,3,te),s=a.cartesianToCartographic(o,Q),l=T.eastNorthUpToFixedFrame(o,a,oe),f=w.inverseTransformation(l,ue),d=e.project(s,$),h=re;h.x=d.z,h.y=d.x,h.z=d.y,h.w=1;var p=w.getColumn(t,0,ee),y=r.magnitude(p),m=w.multiplyByVector(f,p,ne);n.fromElements(m.z,m.x,m.y,0,m);var E=w.getColumn(t,1,ee),_=r.magnitude(E),O=w.multiplyByVector(f,E,ie);n.fromElements(O.z,O.x,O.y,0,O);var v=w.getColumn(t,2,ee),R=r.magnitude(v),A=ae;return r.cross(m,O,A),r.normalize(A,A),r.cross(O,A,m),r.normalize(m,m),r.cross(A,m,O),r.normalize(O,O),r.multiplyByScalar(m,y,m),r.multiplyByScalar(O,_,O),r.multiplyByScalar(A,R,A),w.setColumn(i,0,m,i),w.setColumn(i,1,O,i),w.setColumn(i,2,A,i),w.setColumn(i,3,h,i),i};var se=new w(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1);return T.wgs84To2DModelMatrix=function(e,t,r){if(!u(e))throw new c("projection is required.");if(!u(t))throw new c("center is required.");if(!u(r))throw new c("result is required.");var n=e.ellipsoid,i=T.eastNorthUpToFixedFrame(t,n,oe),a=w.inverseTransformation(i,ue),o=n.cartesianToCartographic(t,Q),s=e.project(o,$),l=re;l.x=s.z,l.y=s.x,l.z=s.y,l.w=1;var f=w.fromTranslation(l,oe);return w.multiply(se,a,r),w.multiply(f,r,r),r},T}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,a){if(!t(n))throw new r("value is required");if(!t(i))throw new r("array is required");return a=e(a,0),i[a++]=n.position?1:0,i[a++]=n.normal?1:0,i[a++]=n.st?1:0,i[a++]=n.tangent?1:0,i[a++]=n.bitangent?1:0,i[a++]=n.color?1:0,i},i.unpack=function(n,a,o){if(!t(n))throw new r("array is required");return a=e(a,0),t(o)||(o=new i),o.position=1===n[a++],o.normal=1===n[a++],o.st=1===n[a++],o.tangent=1===n[a++],o.bitangent=1===n[a++],o.color=1===n[a++],o},i.clone=function(e,r){if(t(e))return t(r)||(r=new i),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r},i}),define("Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./Matrix4","./PrimitiveType","./Quaternion","./Rectangle","./Transforms","./VertexFormat"],function(e,t,r,n,i,a,o,u,s,c,l,f,d,h,p,y,m,E,w,_,O,T,v,R,A,g){"use strict";function b(e,n,a){var o=n.vertexFormat,u=n.center,s=n.semiMajorAxis,l=n.semiMinorAxis,d=n.ellipsoid,y=n.stRotation,m=a?e.length/3*2:e.length/3,E=n.shadowVolume,w=o.st?new Float32Array(2*m):void 0,O=o.normal?new Float32Array(3*m):void 0,T=o.tangent?new Float32Array(3*m):void 0,R=o.bitangent?new Float32Array(3*m):void 0,A=E?new Float32Array(3*m):void 0,g=0,b=j,S=G,N=V,I=new f(d),x=I.project(d.cartesianToCartographic(u,W),X),M=d.scaleToGeodeticSurface(u,D);d.geodeticSurfaceNormal(M,M);for(var P=v.fromAxisAngle(M,y,B),C=_.fromQuaternion(P,z),F=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,H),k=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Y),Z=e.length,K=a?Z:0,J=K/3*2,Q=0;Q<Z;Q+=3){var $=Q+1,ee=Q+2,te=r.fromArray(e,Q,D);if(o.st){var re=_.multiplyByVector(C,te,L),ne=I.project(d.cartesianToCartographic(re,W),U);r.subtract(ne,x,ne),q.x=(ne.x+s)/(2*s),q.y=(ne.y+l)/(2*l),F.x=Math.min(q.x,F.x),F.y=Math.min(q.y,F.y),k.x=Math.max(q.x,k.x),k.y=Math.max(q.y,k.y),a&&(w[g+J]=q.x,w[g+1+J]=q.y),w[g++]=q.x,w[g++]=q.y}(o.normal||o.tangent||o.bitangent||E)&&(b=d.geodeticSurfaceNormal(te,b),E&&(A[Q+K]=-b.x,A[$+K]=-b.y,A[ee+K]=-b.z),(o.normal||o.tangent||o.bitangent)&&((o.tangent||o.bitangent)&&(S=r.normalize(r.cross(r.UNIT_Z,b,S),S),_.multiplyByVector(C,S,S)),o.normal&&(O[Q]=b.x,O[$]=b.y,O[ee]=b.z,a&&(O[Q+K]=-b.x,O[$+K]=-b.y,O[ee+K]=-b.z)),o.tangent&&(T[Q]=S.x,T[$]=S.y,T[ee]=S.z,a&&(T[Q+K]=-S.x,T[$+K]=-S.y,T[ee+K]=-S.z)),o.bitangent&&(N=r.normalize(r.cross(b,S,N),N),R[Q]=N.x,R[$]=N.y,R[ee]=N.z,a&&(R[Q+K]=N.x,R[$+K]=N.y,R[ee+K]=N.z))))}if(o.st){Z=w.length;for(var ie=0;ie<Z;ie+=2)w[ie]=(w[ie]-F.x)/(k.x-F.x),w[ie+1]=(w[ie+1]-F.y)/(k.y-F.y)}var ae=new p;if(o.position){var oe=c.raisePositionsToHeight(e,n,a);ae.position=new h({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:oe})}return o.st&&(ae.st=new h({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:w})),o.normal&&(ae.normal=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:O})),o.tangent&&(ae.tangent=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:T})),o.bitangent&&(ae.bitangent=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R})),E&&(ae.extrudeDirection=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:A})),ae}function S(e){var t,r,n,i,a,o=new Array(12*(e*(e+1))-6),u=0;for(t=0,n=1,i=0;i<3;i++)o[u++]=n++,o[u++]=t,o[u++]=n;for(i=2;i<e+1;++i){for(n=i*(i+1)-1,t=(i-1)*i-1,o[u++]=n++,o[u++]=t,o[u++]=n,r=2*i,a=0;a<r-1;++a)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;o[u++]=n++,o[u++]=t,o[u++]=n}for(r=2*e,++n,++t,i=0;i<r-1;++i)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;for(o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t++,o[u++]=t,++t,i=e-1;i>1;--i){for(o[u++]=t++,o[u++]=t,o[u++]=n,r=2*i,a=0;a<r-1;++a)o[u++]=n,o[u++]=t++,o[u++]=t,o[u++]=n++,o[u++]=t,o[u++]=n;o[u++]=t++,o[u++]=t++,o[u++]=n++}for(i=0;i<3;i++)o[u++]=t++,o[u++]=t,o[u++]=n;return o}function N(t){var n=t.center;k=r.multiplyByScalar(t.ellipsoid.geodeticSurfaceNormal(n,k),t.height,k),k=r.add(n,k,k);var i=new e(k,t.semiMajorAxis),a=c.computeEllipsePositions(t,!0,!1),o=a.positions,u=a.numPts,s=b(o,t,!1),l=S(u);return l=E.createTypedArray(o.length/3,l),{boundingSphere:i,attributes:s,indices:l}}function I(e,n){var a=n.vertexFormat,o=n.center,u=n.semiMajorAxis,s=n.semiMinorAxis,c=n.ellipsoid,l=n.height,d=n.extrudedHeight,y=n.stRotation,m=e.length/3*2,E=new Float64Array(3*m),w=a.st?new Float32Array(2*m):void 0,O=a.normal?new Float32Array(3*m):void 0,T=a.tangent?new Float32Array(3*m):void 0,R=a.bitangent?new Float32Array(3*m):void 0,A=n.shadowVolume,g=A?new Float32Array(3*m):void 0,b=0,S=j,N=G,I=V,x=new f(c),M=x.project(c.cartesianToCartographic(o,W),X),P=c.scaleToGeodeticSurface(o,D);c.geodeticSurfaceNormal(P,P);for(var C=v.fromAxisAngle(P,y,B),k=_.fromQuaternion(C,z),Z=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,H),K=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Y),J=e.length,Q=J/3*2,$=0;$<J;$+=3){var ee,te=$+1,re=$+2,ne=r.fromArray(e,$,D);if(a.st){var ie=_.multiplyByVector(k,ne,L),ae=x.project(c.cartesianToCartographic(ie,W),U);r.subtract(ae,M,ae),q.x=(ae.x+u)/(2*u),q.y=(ae.y+s)/(2*s),Z.x=Math.min(q.x,Z.x),Z.y=Math.min(q.y,Z.y),K.x=Math.max(q.x,K.x),K.y=Math.max(q.y,K.y),w[b+Q]=q.x,w[b+1+Q]=q.y,w[b++]=q.x,w[b++]=q.y}ne=c.scaleToGeodeticSurface(ne,ne),ee=r.clone(ne,L),S=c.geodeticSurfaceNormal(ne,S),A&&(g[$+J]=-S.x,g[te+J]=-S.y,g[re+J]=-S.z);var oe=r.multiplyByScalar(S,l,F);if(ne=r.add(ne,oe,ne),oe=r.multiplyByScalar(S,d,oe),ee=r.add(ee,oe,ee),a.position&&(E[$+J]=ee.x,E[te+J]=ee.y,E[re+J]=ee.z,E[$]=ne.x,E[te]=ne.y,E[re]=ne.z),a.normal||a.tangent||a.bitangent){I=r.clone(S,I);var ue=r.fromArray(e,($+3)%J,F);r.subtract(ue,ne,ue);var se=r.subtract(ee,ne,U);S=r.normalize(r.cross(se,ue,S),S),a.normal&&(O[$]=S.x,O[te]=S.y,O[re]=S.z,O[$+J]=S.x,O[te+J]=S.y,O[re+J]=S.z),a.tangent&&(N=r.normalize(r.cross(I,S,N),N),T[$]=N.x,T[te]=N.y,T[re]=N.z,T[$+J]=N.x,T[$+1+J]=N.y,T[$+2+J]=N.z),a.bitangent&&(R[$]=I.x,R[te]=I.y,R[re]=I.z,R[$+J]=I.x,R[te+J]=I.y,R[re+J]=I.z)}}if(a.st){J=w.length;for(var ce=0;ce<J;ce+=2)w[ce]=(w[ce]-Z.x)/(K.x-Z.x),w[ce+1]=(w[ce+1]-Z.y)/(K.y-Z.y)}var le=new p;return a.position&&(le.position=new h({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:E})),a.st&&(le.st=new h({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:w})),a.normal&&(le.normal=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:O})),a.tangent&&(le.tangent=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:T})),a.bitangent&&(le.bitangent=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R})),A&&(le.extrudeDirection=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:g})),le}function x(e){for(var t=e.length/3,r=E.createTypedArray(t,6*t),n=0,i=0;i<t;i++){var a=i,o=i+t,u=(a+1)%t,s=u+t;r[n++]=a,r[n++]=o,r[n++]=u,r[n++]=u,r[n++]=o,r[n++]=s}return r}function M(t){var n=t.center,i=t.ellipsoid,a=t.semiMajorAxis,o=r.multiplyByScalar(i.geodeticSurfaceNormal(n,D),t.height,D);Z.center=r.add(n,o,Z.center),Z.radius=a,o=r.multiplyByScalar(i.geodeticSurfaceNormal(n,o),t.extrudedHeight,o),K.center=r.add(n,o,K.center),K.radius=a;var u=c.computeEllipsePositions(t,!0,!0),s=u.positions,l=u.numPts,f=u.outerPositions,h=e.union(Z,K),p=b(s,t,!0),w=S(l),_=w.length;w.length=2*_;for(var O=s.length/3,v=0;v<_;v+=3)w[v+_]=w[v+2]+O,w[v+1+_]=w[v+1]+O,w[v+2+_]=w[v]+O;var R=E.createTypedArray(2*O/3,w),A=new d({attributes:p,indices:R,primitiveType:T.TRIANGLES}),g=I(f,t);w=x(f);var N=E.createTypedArray(2*f.length/3,w),M=new d({attributes:g,indices:N,primitiveType:T.TRIANGLES}),P=m.combineInstances([new y({geometry:A}),new y({geometry:M})]);return{boundingSphere:h,attributes:P[0].attributes,indices:P[0].indices}}function P(e,t,n,i,a){A.eastNorthUpToFixedFrame(e,t,J),O.inverseTransformation(J,Q);for(var o=0;o<4;++o)r.clone(r.ZERO,ee[o]);for(ee[0].x+=n,ee[1].x-=n,ee[2].y+=i,ee[3].y-=i,_.fromRotationZ(a,$),o=0;o<4;++o)_.multiplyByVector($,ee[o],ee[o]),O.multiplyByPoint(J,ee[o],ee[o]),t.cartesianToCartographic(ee[o],te[o]);return R.fromCartographicArray(te)}function C(e){e=a(e,a.EMPTY_OBJECT);var t=e.center,n=a(e.ellipsoid,l.WGS84),i=e.semiMajorAxis,u=e.semiMinorAxis,c=a(e.granularity,w.RADIANS_PER_DEGREE),f=a(e.height,0),d=e.extrudedHeight,h=o(d)&&Math.abs(f-d)>1,p=a(e.vertexFormat,g.DEFAULT);if(!o(t))throw new s("center is required.");if(!o(i))throw new s("semiMajorAxis is required.");if(!o(u))throw new s("semiMinorAxis is required.");if(i<u)throw new s("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(c<=0)throw new s("granularity must be greater than zero.");this._center=r.clone(t),this._semiMajorAxis=i,this._semiMinorAxis=u,this._ellipsoid=l.clone(n),this._rotation=a(e.rotation,0),this._stRotation=a(e.stRotation,0),this._height=f,this._granularity=c,this._vertexFormat=g.clone(p),this._extrudedHeight=a(d,f),this._extrude=h,this._shadowVolume=a(e.shadowVolume,!1),this._workerName="createEllipseGeometry",this._rectangle=P(this._center,this._ellipsoid,i,u,this._rotation)}var D=new r,L=new r,U=new r,F=new r,q=new t,z=new _,B=new v,j=new r,G=new r,V=new r,W=new n,X=new r,H=new t,Y=new t,k=new r,Z=new e,K=new e,J=new O,Q=new O,$=new _,ee=[new r,new r,new r,new r],te=[new n,new n,new n,new n];C.packedLength=r.packedLength+l.packedLength+g.packedLength+R.packedLength+9,C.pack=function(e,t,n){if(!o(e))throw new s("value is required");if(!o(t))throw new s("array is required");return n=a(n,0),r.pack(e._center,t,n),n+=r.packedLength,l.pack(e._ellipsoid,t,n),n+=l.packedLength,g.pack(e._vertexFormat,t,n),n+=g.packedLength,R.pack(e._rectangle,t,n),n+=R.packedLength,t[n++]=e._semiMajorAxis,t[n++]=e._semiMinorAxis,t[n++]=e._rotation,t[n++]=e._stRotation,t[n++]=e._height,t[n++]=e._granularity,t[n++]=e._extrudedHeight,t[n++]=e._extrude?1:0,t[n]=e._shadowVolume?1:0,t};var re=new r,ne=new l,ie=new g,ae=new R,oe={center:re,ellipsoid:ne,vertexFormat:ie,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,shadowVolume:void 0};return C.unpack=function(e,t,n){if(!o(e))throw new s("array is required");t=a(t,0);var i=r.unpack(e,t,re);t+=r.packedLength;var u=l.unpack(e,t,ne);t+=l.packedLength;var c=g.unpack(e,t,ie);t+=g.packedLength;var f=R.unpack(e,t,ae);t+=R.packedLength;var d=e[t++],h=e[t++],p=e[t++],y=e[t++],m=e[t++],E=e[t++],w=e[t++],_=1===e[t++],O=1===e[t];return o(n)?(n._center=r.clone(i,n._center),n._ellipsoid=l.clone(u,n._ellipsoid),n._vertexFormat=g.clone(c,n._vertexFormat),n._semiMajorAxis=d,n._semiMinorAxis=h,n._rotation=p,n._stRotation=y,n._height=m,n._granularity=E,n._extrudedHeight=w,n._extrude=_,n._shadowVolume=O,n._rectangle=R.clone(f),n):(oe.height=m,oe.extrudedHeight=w,oe.granularity=E,oe.stRotation=y,oe.rotation=p,oe.semiMajorAxis=d,oe.semiMinorAxis=h,oe.shadowVolume=O,new C(oe))},C.createGeometry=function(e){if(!(e._semiMajorAxis<=0||e._semiMinorAxis<=0)){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),r.shadowVolume=e._shadowVolume,t=M(r)):t=N(r),new d({attributes:t.attributes,indices:t.indices,primitiveType:T.TRIANGLES,boundingSphere:t.boundingSphere})}},C.createShadowVolume=function(e,t,r){var n=e._granularity,i=e._ellipsoid,a=t(n,i),o=r(n,i);return new C({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:i,rotation:e._rotation,stRotation:e._stRotation,granularity:n,extrudedHeight:a,height:o,vertexFormat:g.POSITION_ONLY,shadowVolume:!0})},u(C.prototype,{rectangle:{get:function(){return this._rectangle}}}),C}),define("Core/CircleGeometry",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./EllipseGeometry","./Ellipsoid","./VertexFormat"],function(e,t,r,n,i,a,o,u){"use strict";function s(e){e=r(e,r.EMPTY_OBJECT);var n=e.radius;t.typeOf.number("radius",n);var i={center:e.center,semiMajorAxis:n,semiMinorAxis:n,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation,shadowVolume:e.shadowVolume};this._ellipseGeometry=new a(i),this._workerName="createCircleGeometry"}s.packedLength=a.packedLength,s.pack=function(e,r,n){return t.typeOf.object("value",e),a.pack(e._ellipseGeometry,r,n)};var c=new a({center:new e,semiMajorAxis:1,semiMinorAxis:1}),l={center:new e,radius:void 0,ellipsoid:o.clone(o.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new u,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0,shadowVolume:void 0};return s.unpack=function(t,r,i){var f=a.unpack(t,r,c);return l.center=e.clone(f._center,l.center),l.ellipsoid=o.clone(f._ellipsoid,l.ellipsoid),l.height=f._height,l.extrudedHeight=f._extrudedHeight,l.granularity=f._granularity,l.vertexFormat=u.clone(f._vertexFormat,l.vertexFormat),l.stRotation=f._stRotation,l.shadowVolume=f._shadowVolume,n(i)?(l.semiMajorAxis=f._semiMajorAxis,l.semiMinorAxis=f._semiMinorAxis,i._ellipseGeometry=new a(l),i):(l.radius=f._semiMajorAxis,new s(l))},s.createGeometry=function(e){return a.createGeometry(e._ellipseGeometry)},s.createShadowVolume=function(e,t,r){var n=e._ellipseGeometry._granularity,i=e._ellipseGeometry._ellipsoid,a=t(n,i),o=r(n,i);return new s({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:i,stRotation:e._ellipseGeometry._stRotation,granularity:n,extrudedHeight:a,height:o,vertexFormat:u.POSITION_ONLY,shadowVolume:!0})},i(s.prototype,{rectangle:{get:function(){return this._ellipseGeometry.rectangle}}}),s}),define("Workers/createCircleGeometry",["../Core/Cartesian3","../Core/CircleGeometry","../Core/defined","../Core/Ellipsoid"],function(e,t,r,n){"use strict";function i(i,a){return r(a)&&(i=t.unpack(i,a)),i._ellipseGeometry._center=e.clone(i._ellipseGeometry._center),i._ellipseGeometry._ellipsoid=n.clone(i._ellipseGeometry._ellipsoid),t.createGeometry(i)}return i})}();