/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import martin.tempest.core.TSDRLibrary;
import martin.tempest.core.exceptions.TSDRException;
import martin.tempest.core.exceptions.TSDRLoadPluginException;
import martin.tempest.gui.AutoScaleVisualizer;
import martin.tempest.gui.HoldButton;
import martin.tempest.gui.ImageVisualizer;
import martin.tempest.gui.OnTSDRParamChangedCallback;
import martin.tempest.gui.ParametersToggleButton;
import martin.tempest.gui.PlotVisualizer;
import martin.tempest.gui.VideoMode;
import martin.tempest.sources.TSDRSource;

public class Main
implements TSDRLibrary.FrameReadyCallback,
TSDRLibrary.IncomingValueCallback,
TSDRSource.TSDRSourceParamChangedListener,
OnTSDRParamChangedCallback {
    private static final String SNAPSHOT_FORMAT = "png";
    private static final int OSD_TIME = 2000;
    private static final int OSD_TIME_LONG = 5000;
    private static final int AUTO_FRAMERATE_CONVERGANCE_ITERATIONS = 3;
    private static final int FRAMERATE_SIGNIFICANT_FIGURES = 8;
    private static final long FREQUENCY_STEP = 5000000L;
    private static final double FRAMERATE_MIN_CHANGE = 1.0 / Math.pow(10.0, 8.0);
    private static final String FRAMERATE_FORMAT = "%.8f";
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private static final String PREF_WIDTH = "width";
    private static final String PREF_HEIGHT = "height";
    private static final String PREF_FRAMERATE = "framerate";
    private static final String PREF_COMMAND_PREFIX = "command";
    private static final String PREF_FREQ = "frequency";
    private static final String PREF_GAIN = "gain";
    private static final String PREF_MOTIONBLUR = "motionblur";
    private static final String PREF_HEIGHT_LOCK = "height_lock";
    private static final String PREF_AREA_AROUND_MOUSE = "area_around_mouse";
    private static final String PREF_HQ_REDNERING = "hq_rendering";
    private static final String PREF_NEAREST_NEIGHBOUR = "near_neigh_rend";
    private static final String PREF_LOW_PASS_BEFORE_SYNC = "lp_before_sync";
    private static final String PREF_AUTOGAIN_AFTER_PROC = "auto_bf_proc";
    private final SpinnerModel frequency_spinner_model = new SpinnerNumberModel(new Long(this.prefs.getLong("frequency", 400000000L)), new Long(0L), new Long(Integer.MAX_VALUE), new Long(5000000L));
    private JFrame frmTempestSdr;
    private JFrame fullscreenframe;
    private JDialog deviceframe;
    private JSpinner spWidth;
    private JSpinner spHeight;
    private JComboBox cbVideoModes;
    private JSpinner spFrequency;
    private JLabel lblFrequency;
    private JSlider slGain;
    private JSlider slMotionBlur;
    private JLabel lblGain;
    private JButton btnStartStop;
    private final TSDRLibrary mSdrlib;
    private ImageVisualizer visualizer;
    private PlotVisualizer line_plotter;
    private PlotVisualizer frame_plotter;
    private AutoScaleVisualizer autoScaleVisualizer;
    private Rectangle visualizer_bounds;
    private double framerate = 25.0;
    private JTextField txtFramerate;
    private HoldButton btnLowerFramerate;
    private HoldButton btnHigherFramerate;
    private HoldButton btnUp;
    private HoldButton btnDown;
    private HoldButton btnLeft;
    private HoldButton btnRight;
    private JPanel pnInputDeviceSettings;
    private ParametersToggleButton tglbtnAutoPosition;
    private ParametersToggleButton tglbtnPllFramerate;
    private ParametersToggleButton tglbtnAutocorrPlots;
    private ParametersToggleButton tglbtnSuperBandwidth;
    private JToggleButton tglbtnLockHeightAndFramerate;
    private JToggleButton btnReset;
    private JToggleButton tglbtnDmp;
    private JToggleButton btnAutoResolution;
    private JLabel lblFrames;
    private JSpinner spAreaAroundMouse;
    private JOptionPane optpaneDevices;
    private final TSDRSource[] souces = TSDRSource.getAvailableSources();
    private final JMenuItem[] souces_menues = new JMenuItem[this.souces.length];
    private final VideoMode[] videomodes = VideoMode.getVideoModes();
    private volatile boolean auto_resolution = false;
    private Integer auto_resolution_fps_id = null;
    private Integer auto_resolution_fps_offset = null;
    private final HashMap<Long, Integer> auto_resolution_map = new HashMap();
    private volatile boolean snapshot = false;
    private volatile boolean height_change_from_auto = false;
    private volatile boolean plot_change_from_auto = false;
    private volatile boolean spinner_change_from_auto = false;
    private boolean video_mode_change_manually_triggered = false;
    private int image_width = 1;
    private final KeyAdapter keyhook = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Main.this.onKeyboardKeyPressed(keyEvent);
            super.keyPressed(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            Main.this.onKeyboardKeyReleased(keyEvent);
            super.keyReleased(keyEvent);
        }
    };
    private JMenuBar menuBar;
    private JMenu mnTweaks;
    private JMenuItem mntmTakeSnapshot;
    private JCheckBoxMenuItem chckbxmntmNewCheckItem;
    private final PlotVisualizer.TransformerAndCallback fps_transofmer = new PlotVisualizer.TransformerAndCallback(){

        @Override
        public String getDescription(double d, int n) {
            return String.format("%.1f fps", d);
        }

        @Override
        public double fromIndex(int n, int n2, long l) {
            return (double)l / (double)(n2 + n);
        }

        @Override
        public void onMouseExited() {
            Main.this.height_transformer.setLength(null);
            Main.this.line_plotter.repaint();
        }

        @Override
        public void onMouseMoved(int n, int n2, long l) {
            Main.this.height_transformer.setLength(n2 + n);
            Main.this.line_plotter.repaint();
        }

        @Override
        public void executeIdSelected(int n, int n2, long l) {
            if (Main.this.plot_change_from_auto) {
                return;
            }
            Main.this.height_transformer.setLength(n2 + n);
            double d = Main.this.frame_plotter.getSelectedValue();
            int n3 = Main.this.roundData(Main.this.line_plotter.getSelectedValue());
            Main.this.onResolutionChange(d, n3, "Chosen %s");
        }

        @Override
        public int toIndex(double d, int n, long l) {
            return Main.this.roundData((double)l / d - (double)n);
        }
    };
    private final TransformerAndCallbackHeight height_transformer = new TransformerAndCallbackHeight();
    private JCheckBoxMenuItem chckbxmntmHighQualityRendering;
    private JCheckBoxMenuItem chckbxmntmLowpassBeforeSync;
    private JCheckBoxMenuItem chckbxmntmAutoCorrectAfterProc;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Main main = new Main();
                    main.frmTempestSdr.setVisible(true);
                }
                catch (Exception exception) {
                    Main.displayException(null, exception);
                }
            }
        });
    }

    private static void displayException(Component component, Throwable throwable) {
        String string = throwable.getMessage();
        String string2 = throwable.getClass().getSimpleName();
        JOptionPane.showMessageDialog(component, string == null || string.trim().isEmpty() ? "A " + string2 + " occured." : string, string2, 0);
        throwable.printStackTrace();
    }

    public Main() throws TSDRException {
        this.mSdrlib = new TSDRLibrary();
        this.mSdrlib.registerFrameReadyCallback(this);
        this.mSdrlib.registerValueChangedCallback(this);
        this.initialize();
    }

    private void initialize() {
        Object object;
        int n = this.prefs.getInt(PREF_WIDTH, 576);
        int n2 = this.prefs.getInt(PREF_HEIGHT, 625);
        double d = this.prefs.getDouble(PREF_FRAMERATE, this.framerate);
        int n3 = VideoMode.findClosestVideoModeId(n, n2, d, this.videomodes);
        boolean bl = this.prefs.getBoolean(PREF_HEIGHT_LOCK, true);
        this.frmTempestSdr = new JFrame();
        this.frmTempestSdr.setFocusable(true);
        this.frmTempestSdr.setFocusableWindowState(true);
        this.frmTempestSdr.addKeyListener(this.keyhook);
        this.frmTempestSdr.setResizable(false);
        this.frmTempestSdr.setTitle("TempestSDR");
        this.frmTempestSdr.setBounds(100, 100, 810, 632);
        this.frmTempestSdr.setDefaultCloseOperation(3);
        this.frmTempestSdr.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Main.this.frmTempestSdr.requestFocus();
            }
        });
        this.visualizer = new ImageVisualizer();
        this.visualizer.setBounds(10, 33, 530, 346);
        this.visualizer.addKeyListener(this.keyhook);
        this.visualizer.setFocusable(true);
        this.visualizer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (Main.this.fullscreenframe.isVisible()) {
                        Main.this.fullscreenframe.remove(Main.this.visualizer);
                        Main.this.visualizer.setBounds(Main.this.visualizer_bounds);
                        Main.this.frmTempestSdr.getContentPane().add(Main.this.visualizer);
                        Main.this.fullscreenframe.setVisible(false);
                        Main.this.frmTempestSdr.requestFocus();
                    } else {
                        Main.this.visualizer_bounds = Main.this.visualizer.getBounds();
                        Main.this.frmTempestSdr.remove(Main.this.visualizer);
                        Main.this.fullscreenframe.getContentPane().add(Main.this.visualizer);
                        Main.this.fullscreenframe.setVisible(true);
                        Main.this.visualizer.requestFocus();
                    }
                } else {
                    Main.this.visualizer.requestFocus();
                }
            }
        });
        this.frmTempestSdr.getContentPane().setLayout(null);
        this.frmTempestSdr.getContentPane().add(this.visualizer);
        this.line_plotter = new PlotVisualizer(this.height_transformer);
        this.line_plotter.setBounds(10, 498, 727, 95);
        this.frmTempestSdr.getContentPane().add(this.line_plotter);
        this.line_plotter.setSelectedValue(n2);
        this.btnStartStop = new JButton("Start");
        this.btnStartStop.setBounds(581, 33, 209, 25);
        this.btnStartStop.setEnabled(false);
        this.btnStartStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.performStartStop();
            }
        });
        this.frmTempestSdr.getContentPane().add(this.btnStartStop);
        this.lblFrequency = new JLabel("Freq.:");
        this.lblFrequency.setBounds(591, 358, 55, 16);
        this.lblFrequency.setHorizontalAlignment(4);
        this.frmTempestSdr.getContentPane().add(this.lblFrequency);
        this.spFrequency = new JSpinner();
        this.spFrequency.setBounds(651, 356, 139, 22);
        this.spFrequency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Main.this.onCenterFreqChange();
            }
        });
        this.spFrequency.setModel(this.frequency_spinner_model);
        this.frmTempestSdr.getContentPane().add(this.spFrequency);
        this.framerate = d;
        this.frame_plotter = new PlotVisualizer(this.fps_transofmer);
        this.frame_plotter.setBounds(10, 391, 727, 95);
        this.frmTempestSdr.getContentPane().add(this.frame_plotter);
        this.frame_plotter.setSelectedValue(this.framerate);
        this.menuBar = new JMenuBar();
        this.menuBar.setBounds(0, 0, 825, 21);
        this.frmTempestSdr.getContentPane().add(this.menuBar);
        JMenu jMenu = new JMenu("File");
        this.menuBar.add(jMenu);
        for (int i = 0; i < this.souces.length; ++i) {
            object = this.souces[i];
            this.souces_menues[i] = new JMenuItem("Load " + ((TSDRSource)object).toString());
            this.souces_menues[i].addActionListener(new ActionListener((TSDRSource)object){
                final /* synthetic */ TSDRSource val$src;
                {
                    this.val$src = tSDRSource;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Main.this.onPluginSelected(this.val$src);
                }
            });
            jMenu.add(this.souces_menues[i]);
        }
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        this.mnTweaks = new JMenu("Tweaks");
        this.menuBar.add(this.mnTweaks);
        this.mntmTakeSnapshot = new JMenuItem("Take snapshot");
        this.mntmTakeSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.snapshot = true;
            }
        });
        this.mnTweaks.add(this.mntmTakeSnapshot);
        this.chckbxmntmNewCheckItem = new JCheckBoxMenuItem("Inverted colours");
        this.chckbxmntmNewCheckItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.mSdrlib.setInvertedColors(Main.this.chckbxmntmNewCheckItem.isSelected());
            }
        });
        this.mnTweaks.add(this.chckbxmntmNewCheckItem);
        this.chckbxmntmHighQualityRendering = new JCheckBoxMenuItem("High quality rendering", this.prefs.getBoolean(PREF_HQ_REDNERING, false));
        this.chckbxmntmHighQualityRendering.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = Main.this.chckbxmntmHighQualityRendering.isSelected();
                Main.this.visualizer.setRenderingQualityHigh(bl);
                Main.this.prefs.putBoolean(Main.PREF_HQ_REDNERING, bl);
            }
        });
        this.mnTweaks.add(this.chckbxmntmHighQualityRendering);
        object = new JCheckBoxMenuItem("Nearest neighbour resampling", this.prefs.getBoolean(PREF_NEAREST_NEIGHBOUR, false));
        ((AbstractButton)object).addActionListener(new ActionListener((JCheckBoxMenuItem)object){
            final /* synthetic */ JCheckBoxMenuItem val$chckbxmntmNearestNeighbourResampling;
            {
                this.val$chckbxmntmNearestNeighbourResampling = jCheckBoxMenuItem;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl = this.val$chckbxmntmNearestNeighbourResampling.isSelected();
                    Main.this.mSdrlib.setParam(TSDRLibrary.PARAM.NEAREST_NEIGHBOUR_RESAMPLING, bl ? 1L : 0L);
                    Main.this.prefs.putBoolean(Main.PREF_NEAREST_NEIGHBOUR, bl);
                }
                catch (TSDRException tSDRException) {
                    Main.this.onException(Main.this.mSdrlib, tSDRException);
                }
            }
        });
        this.mnTweaks.add((JMenuItem)object);
        this.chckbxmntmLowpassBeforeSync = new JCheckBoxMenuItem("Lowpass before sync detection", this.prefs.getBoolean(PREF_LOW_PASS_BEFORE_SYNC, true));
        this.chckbxmntmLowpassBeforeSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl = Main.this.chckbxmntmLowpassBeforeSync.isSelected();
                    Main.this.mSdrlib.setParam(TSDRLibrary.PARAM.LOW_PASS_BEFORE_SYNC, bl ? 1L : 0L);
                    Main.this.prefs.putBoolean(Main.PREF_LOW_PASS_BEFORE_SYNC, bl);
                }
                catch (TSDRException tSDRException) {
                    Main.this.onException(Main.this.mSdrlib, tSDRException);
                }
            }
        });
        this.mnTweaks.add(this.chckbxmntmLowpassBeforeSync);
        this.chckbxmntmAutoCorrectAfterProc = new JCheckBoxMenuItem("Autogain after lowpass", this.prefs.getBoolean(PREF_AUTOGAIN_AFTER_PROC, false));
        this.chckbxmntmAutoCorrectAfterProc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl = Main.this.chckbxmntmAutoCorrectAfterProc.isSelected();
                    Main.this.mSdrlib.setParam(TSDRLibrary.PARAM.AUTOGAIN_AFTER_PROCESSING, bl ? 1L : 0L);
                    Main.this.prefs.putBoolean(Main.PREF_AUTOGAIN_AFTER_PROC, bl);
                }
                catch (TSDRException tSDRException) {
                    Main.this.onException(Main.this.mSdrlib, tSDRException);
                }
            }
        });
        this.mnTweaks.add(this.chckbxmntmAutoCorrectAfterProc);
        this.btnReset = new JToggleButton("RST");
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Main.this.btnReset.setSelected(true);
                    Main.this.mSdrlib.setParam(TSDRLibrary.PARAM.AUTOCORR_PLOTS_RESET, 1L);
                }
                catch (TSDRException tSDRException) {
                    Main.displayException(Main.this.frmTempestSdr, tSDRException);
                }
            }
        });
        this.btnReset.setToolTipText("Reset the autocorrelation plots");
        this.btnReset.setMargin(new Insets(0, 0, 0, 0));
        this.btnReset.setBounds(749, 417, 41, 22);
        this.frmTempestSdr.getContentPane().add(this.btnReset);
        this.cbVideoModes = new JComboBox();
        this.cbVideoModes.setBounds(581, 70, 209, 22);
        this.frmTempestSdr.getContentPane().add(this.cbVideoModes);
        this.cbVideoModes.setModel(new DefaultComboBoxModel<VideoMode>(this.videomodes));
        if (n3 != -1 && n3 < this.videomodes.length && n3 >= 0) {
            this.cbVideoModes.setSelectedIndex(n3);
        }
        JLabel jLabel = new JLabel("Width:");
        jLabel.setBounds(581, 100, 65, 16);
        this.frmTempestSdr.getContentPane().add(jLabel);
        jLabel.setHorizontalAlignment(4);
        JLabel jLabel2 = new JLabel("Height:");
        jLabel2.setBounds(581, 127, 65, 16);
        this.frmTempestSdr.getContentPane().add(jLabel2);
        jLabel2.setHorizontalAlignment(4);
        JLabel jLabel3 = new JLabel("FPS:");
        jLabel3.setBounds(581, 154, 65, 16);
        this.frmTempestSdr.getContentPane().add(jLabel3);
        jLabel3.setHorizontalAlignment(4);
        this.spWidth = new JSpinner();
        this.spWidth.setBounds(651, 97, 102, 22);
        this.frmTempestSdr.getContentPane().add(this.spWidth);
        this.spWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Main.this.spinner_change_from_auto) {
                    return;
                }
                Main.this.onResolutionChange((Integer)Main.this.spWidth.getValue(), (Integer)Main.this.spHeight.getValue(), Main.this.framerate);
            }
        });
        this.spWidth.setModel(new SpinnerNumberModel(n, 1, 10000, 1));
        this.spHeight = new JSpinner();
        this.spHeight.setBounds(651, 124, 102, 22);
        this.frmTempestSdr.getContentPane().add(this.spHeight);
        this.spHeight.addChangeListener(new ChangeListener(){
            private Integer oldheight = null;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Main.this.spinner_change_from_auto) {
                    return;
                }
                Integer n = (Integer)Main.this.spWidth.getValue();
                Integer n2 = (Integer)Main.this.spHeight.getValue();
                if (this.oldheight != null && Main.this.tglbtnLockHeightAndFramerate.isSelected() && !Main.this.height_change_from_auto) {
                    Main.this.onResolutionChange(n, n2, Main.this.framerate * (double)this.oldheight.intValue() / (double)n2.intValue());
                } else {
                    Main.this.onResolutionChange(n, n2, Main.this.framerate);
                }
                this.oldheight = n2;
            }
        });
        this.spHeight.setModel(new SpinnerNumberModel(n2, 1, 10000, 1));
        this.tglbtnLockHeightAndFramerate = new JToggleButton("L");
        this.tglbtnLockHeightAndFramerate.setBounds(765, 123, 25, 22);
        this.frmTempestSdr.getContentPane().add(this.tglbtnLockHeightAndFramerate);
        this.tglbtnLockHeightAndFramerate.setToolTipText("Link the framerate with the height");
        this.tglbtnLockHeightAndFramerate.setSelected(bl);
        this.tglbtnLockHeightAndFramerate.setMargin(new Insets(0, 0, 0, 0));
        this.tglbtnPllFramerate = new ParametersToggleButton(TSDRLibrary.PARAM.PLLFRAMERATE, "A", this.prefs, true);
        this.tglbtnPllFramerate.setBounds(765, 151, 25, 22);
        this.frmTempestSdr.getContentPane().add(this.tglbtnPllFramerate);
        this.tglbtnPllFramerate.setToolTipText("Automatically adjust the FPS to keep the video stable");
        this.tglbtnPllFramerate.setParaChangeCallback(this);
        this.tglbtnPllFramerate.setMargin(new Insets(0, 0, 0, 0));
        this.tglbtnAutocorrPlots = new ParametersToggleButton(TSDRLibrary.PARAM.AUTOCORR_PLOTS_OFF, "OFF", this.prefs, false);
        this.tglbtnAutocorrPlots.setBounds(749, 442, 41, 22);
        this.frmTempestSdr.getContentPane().add(this.tglbtnAutocorrPlots);
        this.tglbtnAutocorrPlots.setToolTipText("Turn off autocorrelation plots");
        this.tglbtnAutocorrPlots.setParaChangeCallback(this);
        this.tglbtnAutocorrPlots.setMargin(new Insets(0, 0, 0, 0));
        this.txtFramerate = new JTextField();
        this.txtFramerate.setBounds(651, 151, 102, 22);
        this.frmTempestSdr.getContentPane().add(this.txtFramerate);
        this.txtFramerate.setText(String.format(FRAMERATE_FORMAT, d));
        this.txtFramerate.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (Main.this.spinner_change_from_auto) {
                    return;
                }
                Main.this.onFrameRateTextChanged();
            }
        });
        this.txtFramerate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Main.this.spinner_change_from_auto) {
                    return;
                }
                if (keyEvent.getKeyCode() == 10) {
                    Main.this.onFrameRateTextChanged();
                }
            }
        });
        this.txtFramerate.setColumns(10);
        this.btnHigherFramerate = new HoldButton(">");
        this.btnHigherFramerate.setBounds(712, 174, 41, 25);
        this.frmTempestSdr.getContentPane().add(this.btnHigherFramerate);
        this.btnHigherFramerate.setMargin(new Insets(0, 0, 0, 0));
        this.btnLowerFramerate = new HoldButton("<");
        this.btnLowerFramerate.setBounds(651, 173, 41, 25);
        this.frmTempestSdr.getContentPane().add(this.btnLowerFramerate);
        this.btnLowerFramerate.setMargin(new Insets(0, 0, 0, 0));
        this.btnUp = new HoldButton("Up");
        this.btnUp.setBounds(652, 210, 70, 25);
        this.frmTempestSdr.getContentPane().add(this.btnUp);
        this.btnUp.setMargin(new Insets(0, 0, 0, 0));
        this.btnLeft = new HoldButton("Left");
        this.btnLeft.setBounds(581, 241, 65, 25);
        this.frmTempestSdr.getContentPane().add(this.btnLeft);
        this.btnLeft.setMargin(new Insets(0, 0, 0, 0));
        this.tglbtnAutoPosition = new ParametersToggleButton(TSDRLibrary.PARAM.AUTOSHIFT, "Auto", this.prefs, true);
        this.tglbtnAutoPosition.setBounds(651, 240, 70, 26);
        this.frmTempestSdr.getContentPane().add(this.tglbtnAutoPosition);
        this.tglbtnAutoPosition.setToolTipText("Automatically try to center on the image");
        this.tglbtnAutoPosition.setParaChangeCallback(this);
        this.tglbtnAutoPosition.setMargin(new Insets(0, 0, 0, 0));
        this.btnRight = new HoldButton("Right");
        this.btnRight.setBounds(725, 241, 65, 25);
        this.frmTempestSdr.getContentPane().add(this.btnRight);
        this.btnRight.setMargin(new Insets(0, 0, 0, 0));
        this.btnDown = new HoldButton("Down");
        this.btnDown.setBounds(651, 271, 70, 25);
        this.frmTempestSdr.getContentPane().add(this.btnDown);
        this.btnDown.setMargin(new Insets(0, 0, 0, 0));
        JLabel jLabel4 = new JLabel("Lpass:");
        jLabel4.setBounds(581, 308, 65, 16);
        this.frmTempestSdr.getContentPane().add(jLabel4);
        jLabel4.setHorizontalAlignment(4);
        this.lblGain = new JLabel("Gain:");
        this.lblGain.setBounds(581, 328, 65, 16);
        this.frmTempestSdr.getContentPane().add(this.lblGain);
        this.lblGain.setHorizontalAlignment(4);
        this.slGain = new JSlider();
        this.slGain.setBounds(652, 328, 138, 26);
        this.frmTempestSdr.getContentPane().add(this.slGain);
        this.slGain.setValue((int)(this.prefs.getFloat(PREF_GAIN, 0.5f) * (float)(this.slGain.getMaximum() - this.slGain.getMinimum()) + (float)this.slGain.getMinimum()));
        this.slMotionBlur = new JSlider();
        this.slMotionBlur.setBounds(652, 308, 139, 22);
        this.frmTempestSdr.getContentPane().add(this.slMotionBlur);
        this.slMotionBlur.setValue((int)(this.prefs.getFloat(PREF_MOTIONBLUR, 0.0f) * (float)(this.slMotionBlur.getMaximum() - this.slMotionBlur.getMinimum()) + (float)this.slMotionBlur.getMinimum()));
        this.lblFrames = new JLabel("00");
        this.lblFrames.setToolTipText("The number of  runs of the autocorrelation averaging");
        this.lblFrames.setHorizontalAlignment(4);
        this.lblFrames.setBounds(742, 390, 48, 15);
        this.frmTempestSdr.getContentPane().add(this.lblFrames);
        this.spAreaAroundMouse = new JSpinner();
        this.spAreaAroundMouse.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Main.this.setAreaAroundMouse();
            }
        });
        this.spAreaAroundMouse.setToolTipText("The area around the mouse in pixels used to picking the best value");
        this.spAreaAroundMouse.setModel(new SpinnerNumberModel(new Integer(this.prefs.getInt(PREF_AREA_AROUND_MOUSE, 15)), new Integer(0), null, new Integer(1)));
        this.spAreaAroundMouse.setBounds(749, 466, 41, 20);
        this.frmTempestSdr.getContentPane().add(this.spAreaAroundMouse);
        this.btnAutoResolution = new JToggleButton("AUT");
        this.btnAutoResolution.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = Main.this.btnAutoResolution.isSelected();
                if (bl) {
                    Main.this.auto_resolution_map.clear();
                    Main.this.auto_resolution_fps_id = null;
                    Main.this.auto_resolution_fps_offset = null;
                }
                Main.this.auto_resolution = bl;
            }
        });
        this.btnAutoResolution.setToolTipText("Automatically choose the best resolution and framerate from the available data");
        this.btnAutoResolution.setMargin(new Insets(0, 0, 0, 0));
        this.btnAutoResolution.setBounds(749, 571, 41, 22);
        this.frmTempestSdr.getContentPane().add(this.btnAutoResolution);
        this.tglbtnSuperBandwidth = new ParametersToggleButton(TSDRLibrary.PARAM.SUPERRESOLUTION, "T", null, false);
        this.tglbtnSuperBandwidth.setText("SB");
        this.tglbtnSuperBandwidth.setToolTipText("Simulate bandwidth several times bigger than what the device can offer");
        this.tglbtnSuperBandwidth.setMargin(new Insets(0, 0, 0, 0));
        this.tglbtnSuperBandwidth.setBounds(765, 278, 25, 22);
        this.tglbtnSuperBandwidth.setParaChangeCallback(this);
        this.frmTempestSdr.getContentPane().add(this.tglbtnSuperBandwidth);
        this.autoScaleVisualizer = new AutoScaleVisualizer();
        this.autoScaleVisualizer.setBounds(540, 33, 25, 346);
        this.frmTempestSdr.getContentPane().add(this.autoScaleVisualizer);
        this.slMotionBlur.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Main.this.onMotionBlurLevelChanged();
            }
        });
        this.slGain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Main.this.onGainLevelChanged();
            }
        });
        this.btnDown.addHoldListener(new HoldButton.HoldListener(){

            @Override
            public void onHold(int n) {
                Main.this.onSync(TSDRLibrary.SYNC_DIRECTION.DOWN, n);
            }
        });
        this.btnRight.addHoldListener(new HoldButton.HoldListener(){

            @Override
            public void onHold(int n) {
                Main.this.onSync(TSDRLibrary.SYNC_DIRECTION.RIGHT, n);
            }
        });
        this.tglbtnAutoPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.onAutoPostionChanged();
            }
        });
        this.btnLeft.addHoldListener(new HoldButton.HoldListener(){

            @Override
            public void onHold(int n) {
                Main.this.onSync(TSDRLibrary.SYNC_DIRECTION.LEFT, n);
            }
        });
        this.btnUp.addHoldListener(new HoldButton.HoldListener(){

            @Override
            public void onHold(int n) {
                Main.this.onSync(TSDRLibrary.SYNC_DIRECTION.UP, n);
            }
        });
        this.btnLowerFramerate.addHoldListener(new HoldButton.HoldListener(){

            @Override
            public void onHold(int n) {
                Main.this.onFrameRateChanged(true, n);
            }
        });
        this.btnHigherFramerate.addHoldListener(new HoldButton.HoldListener(){

            @Override
            public void onHold(int n) {
                Main.this.onFrameRateChanged(false, n);
            }
        });
        this.tglbtnAutocorrPlots.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.frame_plotter.reset();
                Main.this.line_plotter.reset();
            }
        });
        this.tglbtnLockHeightAndFramerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.prefs.putBoolean(Main.PREF_HEIGHT_LOCK, Main.this.tglbtnLockHeightAndFramerate.isSelected());
            }
        });
        this.cbVideoModes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoMode videoMode = (VideoMode)Main.this.cbVideoModes.getSelectedItem();
                for (int i = 0; i < Main.this.videomodes.length; ++i) {
                    if (!Main.this.videomodes[i].equals(videoMode)) continue;
                    Main.this.onVideoModeSelected(i);
                    return;
                }
            }
        });
        this.frmTempestSdr.setFocusableWindowState(true);
        this.frmTempestSdr.requestFocus();
        this.onGainLevelChanged();
        this.onMotionBlurLevelChanged();
        this.fullscreenframe = new JFrame("Video display");
        this.fullscreenframe.setFocusable(true);
        this.fullscreenframe.addKeyListener(this.keyhook);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n4 = (int)toolkit.getScreenSize().getWidth();
        int n5 = (int)toolkit.getScreenSize().getHeight();
        this.fullscreenframe.setSize(n4, n5);
        this.fullscreenframe.setUndecorated(true);
        this.fullscreenframe.setLocation(0, 0);
        this.pnInputDeviceSettings = new JPanel();
        this.pnInputDeviceSettings.setBounds(10, 68, 551, 74);
        this.pnInputDeviceSettings.setLayout(null);
        this.optpaneDevices = new JOptionPane();
        this.optpaneDevices.setMessage(this.pnInputDeviceSettings);
        this.optpaneDevices.setMessageType(-1);
        this.optpaneDevices.setOptionType(2);
        this.deviceframe = this.optpaneDevices.createDialog(this.frmTempestSdr, "");
        this.deviceframe.setResizable(false);
        this.deviceframe.getContentPane().add(this.optpaneDevices);
        this.onAutoPostionChanged();
        this.setAreaAroundMouse();
        this.visualizer.setRenderingQualityHigh(this.chckbxmntmHighQualityRendering.isSelected());
        this.tglbtnDmp = new JToggleButton("DMP");
        this.tglbtnDmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Main.this.tglbtnDmp.setSelected(true);
                    Main.this.mSdrlib.setParam(TSDRLibrary.PARAM.AUTOCORR_DUMP, 1L);
                }
                catch (TSDRException tSDRException) {
                    Main.displayException(Main.this.frmTempestSdr, tSDRException);
                }
            }
        });
        this.tglbtnDmp.setToolTipText("Dump the full instanteneous autocorrelation to file");
        this.tglbtnDmp.setMargin(new Insets(0, 0, 0, 0));
        this.tglbtnDmp.setBounds(749, 498, 41, 22);
        this.frmTempestSdr.getContentPane().add(this.tglbtnDmp);
        try {
            this.mSdrlib.setParam(TSDRLibrary.PARAM.NEAREST_NEIGHBOUR_RESAMPLING, ((AbstractButton)object).isSelected() ? 1L : 0L);
            this.mSdrlib.setParam(TSDRLibrary.PARAM.LOW_PASS_BEFORE_SYNC, this.chckbxmntmLowpassBeforeSync.isSelected() ? 1L : 0L);
            this.mSdrlib.setParam(TSDRLibrary.PARAM.AUTOGAIN_AFTER_PROCESSING, this.chckbxmntmAutoCorrectAfterProc.isSelected() ? 1L : 0L);
        }
        catch (TSDRException tSDRException) {
            // empty catch block
        }
    }

    private void onVideoModeSelected(int n) {
        if (this.video_mode_change_manually_triggered) {
            return;
        }
        this.onResolutionChange(n);
    }

    private void setAreaAroundMouse() {
        try {
            int n = (Integer)this.spAreaAroundMouse.getValue();
            this.line_plotter.setAreaAroundMouse(n);
            this.frame_plotter.setAreaAroundMouse(n);
            this.prefs.putInt(PREF_AREA_AROUND_MOUSE, n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void performStartStop() {
        if (this.mSdrlib.isRunning()) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        if (!Main.this.mSdrlib.isRunning()) {
                            Main.this.btnStartStop.setEnabled(false);
                        }
                        Main.this.mSdrlib.stop();
                    }
                    catch (TSDRException tSDRException) {
                        Main.displayException(Main.this.frmTempestSdr, tSDRException);
                    }
                }
            }.start();
        } else {
            try {
                float f;
                Long l = (Long)this.spFrequency.getValue();
                if (l != null && l > 0L) {
                    this.mSdrlib.setBaseFreq(l);
                }
                if ((f = (float)(this.slGain.getValue() - this.slGain.getMinimum()) / (float)(this.slGain.getMaximum() - this.slGain.getMinimum())) < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                this.mSdrlib.setGain(f);
            }
            catch (TSDRException tSDRException) {
                Main.displayException(this.frmTempestSdr, tSDRException);
                return;
            }
            try {
                this.image_width = (Integer)this.spWidth.getValue();
                this.mSdrlib.startAsync((Integer)this.spHeight.getValue(), this.framerate);
            }
            catch (TSDRException tSDRException) {
                Main.displayException(this.frmTempestSdr, tSDRException);
                this.btnStartStop.setText("Start");
                return;
            }
            this.btnStartStop.setText("Stop");
            this.setPluginMenuEnabled(false);
        }
    }

    private void onSync(TSDRLibrary.SYNC_DIRECTION sYNC_DIRECTION, int n) {
        this.mSdrlib.sync(n, sYNC_DIRECTION);
    }

    private void onResolutionChange(int n, double d, int n2) {
        if (n < 0 || n >= this.videomodes.length) {
            return;
        }
        VideoMode videoMode = this.videomodes[n];
        this.onResolutionChange(videoMode.width, n2, d, n);
    }

    private void onResolutionChange(int n) {
        if (n < 0 || n >= this.videomodes.length) {
            return;
        }
        VideoMode videoMode = this.videomodes[n];
        this.onResolutionChange(videoMode.width, videoMode.height, videoMode.refreshrate, n);
    }

    private void onResolutionChange(double d, int n, String string) {
        int n2 = VideoMode.findClosestVideoModeId(d, n, this.videomodes);
        if (n2 >= 0 && n2 < this.videomodes.length) {
            this.onResolutionChange(n2, d, n);
            this.visualizer.setOSD(String.format(string, " " + this.videomodes[n2]), 5000L);
        } else {
            this.setFrameRate(d);
        }
    }

    private void onResolutionChange(int n, int n2, double d) {
        this.onResolutionChange(n, n2, d, VideoMode.findClosestVideoModeId(n, n2, d, this.videomodes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResolutionChange(int n, int n2, double d, int n3) {
        this.framerate = d;
        this.plot_change_from_auto = true;
        this.frame_plotter.setSelectedValue(d);
        this.line_plotter.setSelectedValue(n2);
        this.spinner_change_from_auto = true;
        String string = String.format(FRAMERATE_FORMAT, d);
        this.txtFramerate.setText(string);
        try {
            this.image_width = n;
            this.mSdrlib.setResolution(n2, d);
            this.prefs.putDouble(PREF_FRAMERATE, d);
            this.prefs.putInt(PREF_WIDTH, n);
            this.spWidth.setValue(n);
            this.prefs.putInt(PREF_HEIGHT, n2);
            this.spHeight.setValue(n2);
            this.video_mode_change_manually_triggered = true;
            if (n3 >= 0 && n3 < this.videomodes.length) {
                this.cbVideoModes.setSelectedIndex(n3);
                this.cbVideoModes.repaint();
            }
            this.video_mode_change_manually_triggered = false;
        }
        catch (TSDRException tSDRException) {
            Main.displayException(this.frmTempestSdr, tSDRException);
        }
        finally {
            this.plot_change_from_auto = false;
        }
        this.spinner_change_from_auto = false;
    }

    private void onCenterFreqChange() {
        Long l = (Long)this.spFrequency.getValue();
        if (l == null || l < 0L) {
            return;
        }
        try {
            this.mSdrlib.setBaseFreq(l);
            this.visualizer.setOSD("Freq: " + l + " Hz", 2000L);
            this.prefs.putLong(PREF_FREQ, l);
        }
        catch (TSDRException tSDRException) {
            Main.displayException(this.frmTempestSdr, tSDRException);
        }
    }

    private void onGainLevelChanged() {
        float f = (float)(this.slGain.getValue() - this.slGain.getMinimum()) / (float)(this.slGain.getMaximum() - this.slGain.getMinimum());
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        try {
            this.mSdrlib.setGain(f);
            this.prefs.putFloat(PREF_GAIN, f);
        }
        catch (TSDRException tSDRException) {
            Main.displayException(this.frmTempestSdr, tSDRException);
        }
    }

    private void onMotionBlurLevelChanged() {
        float f = (float)this.slMotionBlur.getValue() / 100.0f;
        try {
            this.mSdrlib.setMotionBlur(f);
            this.prefs.putFloat(PREF_MOTIONBLUR, f);
        }
        catch (TSDRException tSDRException) {
            Main.displayException(this.frmTempestSdr, tSDRException);
        }
    }

    private void onFrameRateTextChanged() {
        try {
            Double d = Double.parseDouble(this.txtFramerate.getText().trim());
            if (d != null && d > 0.0) {
                this.framerate = d;
                this.frame_plotter.setSelectedValue(this.framerate);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setFrameRate(this.framerate);
    }

    private void setFramerateValButDoNotSyncWithLibrary(double d) {
        this.framerate = d;
        this.frame_plotter.setSelectedValue(this.framerate);
        String string = String.format(FRAMERATE_FORMAT, this.framerate);
        this.txtFramerate.setText(string);
        this.prefs.putDouble(PREF_FRAMERATE, this.framerate);
    }

    private void setFrameRate(double d) {
        int n = (Integer)this.spWidth.getValue();
        int n2 = (Integer)this.spHeight.getValue();
        this.onResolutionChange(n, n2, d);
        String string = String.format(FRAMERATE_FORMAT, this.framerate);
        this.visualizer.setOSD("Framerate: " + string + " fps", 2000L);
    }

    private void onKeyboardKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.isShiftDown()) {
            switch (n) {
                case 37: {
                    this.btnLeft.doHold();
                    this.visualizer.setOSD("Move: Left", 2000L);
                    break;
                }
                case 39: {
                    this.btnRight.doHold();
                    this.visualizer.setOSD("Move: Right", 2000L);
                    break;
                }
                case 38: {
                    this.btnUp.doHold();
                    this.visualizer.setOSD("Move: Up", 2000L);
                    break;
                }
                case 40: {
                    this.btnDown.doHold();
                    this.visualizer.setOSD("Move: Down", 2000L);
                }
            }
        } else {
            switch (n) {
                case 39: {
                    this.btnHigherFramerate.doHold();
                    break;
                }
                case 37: {
                    this.btnLowerFramerate.doHold();
                    break;
                }
                case 38: {
                    this.spFrequency.setValue(this.frequency_spinner_model.getNextValue());
                    break;
                }
                case 40: {
                    this.spFrequency.setValue(this.frequency_spinner_model.getPreviousValue());
                }
            }
        }
    }

    private void onKeyboardKeyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.isShiftDown()) {
            switch (n) {
                case 37: {
                    this.btnLeft.doRelease();
                    this.btnHigherFramerate.doRelease();
                    break;
                }
                case 39: {
                    this.btnRight.doRelease();
                    this.btnLowerFramerate.doRelease();
                    break;
                }
                case 38: {
                    this.btnUp.doRelease();
                    break;
                }
                case 40: {
                    this.btnDown.doRelease();
                }
            }
        } else {
            switch (n) {
                case 39: {
                    this.btnLeft.doRelease();
                    this.btnHigherFramerate.doRelease();
                    break;
                }
                case 37: {
                    this.btnRight.doRelease();
                    this.btnLowerFramerate.doRelease();
                }
            }
        }
    }

    private void onFrameRateChanged(boolean bl, int n) {
        double d = (double)(n * n) * FRAMERATE_MIN_CHANGE;
        if (d > 0.05) {
            d = 0.05;
        }
        if (bl && this.framerate > d) {
            this.framerate -= d;
        } else if (!bl) {
            this.framerate += d;
        }
        this.setFrameRate(this.framerate);
    }

    private void onAutoPostionChanged() {
        if (this.tglbtnAutoPosition.isSelected()) {
            this.btnDown.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnLeft.setEnabled(false);
            this.btnRight.setEnabled(false);
        } else {
            this.btnDown.setEnabled(true);
            this.btnUp.setEnabled(true);
            this.btnLeft.setEnabled(true);
            this.btnRight.setEnabled(true);
        }
    }

    private void setPluginMenuEnabled(boolean bl) {
        for (int i = 0; i < this.souces_menues.length; ++i) {
            this.souces_menues[i].setEnabled(bl);
        }
    }

    private int roundData(double d) {
        return (int)Math.round(d);
    }

    private void onPluginSelected(TSDRSource tSDRSource) {
        if (!this.mSdrlib.isRunning()) {
            this.btnStartStop.setEnabled(false);
        }
        try {
            this.mSdrlib.unloadPlugin();
        }
        catch (TSDRException tSDRException) {
            // empty catch block
        }
        this.pnInputDeviceSettings.removeAll();
        this.pnInputDeviceSettings.revalidate();
        this.pnInputDeviceSettings.repaint();
        String string = this.prefs.get(PREF_COMMAND_PREFIX + tSDRSource, "");
        tSDRSource.setOnParameterChangedCallback(this);
        ActRegistrator actRegistrator = new ActRegistrator();
        boolean bl = tSDRSource.populateGUI(this.pnInputDeviceSettings, string, actRegistrator);
        if (bl) {
            this.pnInputDeviceSettings.revalidate();
            this.pnInputDeviceSettings.repaint();
            this.deviceframe.setTitle("Load " + tSDRSource);
            this.deviceframe.setSize(570, 170);
            this.deviceframe.setLocationByPlatform(true);
            this.deviceframe.setVisible(true);
            try {
                if ((Integer)this.optpaneDevices.getValue() == 0) {
                    actRegistrator.action();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private static BufferedImage resize(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Override
    public void onFrameReady(TSDRLibrary tSDRLibrary, BufferedImage bufferedImage) {
        if (this.snapshot) {
            this.snapshot = false;
            try {
                BufferedImage bufferedImage2 = Main.resize(bufferedImage, this.image_width, bufferedImage.getHeight());
                int n = (int)Math.abs((double)((Long)this.spFrequency.getValue()).longValue() / 1000000.0);
                String string = "TSDR_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + "_" + n + "MHz." + SNAPSHOT_FORMAT;
                File file = new File(string);
                ImageIO.write((RenderedImage)bufferedImage2, SNAPSHOT_FORMAT, file);
                this.visualizer.setOSD("Saved to " + file.getAbsolutePath(), 2000L);
            }
            catch (Throwable throwable) {
                this.visualizer.setOSD("Failed to capture snapshot", 2000L);
                throwable.printStackTrace();
            }
        }
        this.visualizer.drawImage(bufferedImage, this.image_width);
    }

    @Override
    public void onException(TSDRLibrary tSDRLibrary, Exception exception) {
        this.btnStartStop.setEnabled(true);
        this.btnStartStop.setText("Start");
        this.setPluginMenuEnabled(true);
        Main.displayException(this.frmTempestSdr, exception);
        System.gc();
    }

    @Override
    public void onStopped(TSDRLibrary tSDRLibrary) {
        this.btnStartStop.setEnabled(true);
        this.btnStartStop.setText("Start");
        this.setPluginMenuEnabled(true);
        System.gc();
    }

    @Override
    public void onParametersChanged(TSDRSource tSDRSource) {
        this.setPluginMenuEnabled(false);
        if (!this.mSdrlib.isRunning()) {
            this.btnStartStop.setEnabled(false);
        }
        try {
            try {
                this.mSdrlib.unloadPlugin();
            }
            catch (TSDRLoadPluginException tSDRLoadPluginException) {
                // empty catch block
            }
            this.mSdrlib.loadPlugin(tSDRSource);
        }
        catch (Throwable throwable) {
            if (!this.mSdrlib.isRunning()) {
                this.btnStartStop.setEnabled(false);
            }
            Main.displayException(this.frmTempestSdr, throwable);
            this.setPluginMenuEnabled(true);
            return;
        }
        this.setPluginMenuEnabled(true);
        this.btnStartStop.setEnabled(true);
        this.prefs.put(PREF_COMMAND_PREFIX + tSDRSource, tSDRSource.getParams());
    }

    @Override
    public void onSetParam(TSDRLibrary.PARAM pARAM, long l) {
        try {
            if (this.mSdrlib != null) {
                this.mSdrlib.setParam(pARAM, l);
            }
        }
        catch (Throwable throwable) {
            Main.displayException(this.frmTempestSdr, throwable);
            return;
        }
    }

    @Override
    public void onSetParam(TSDRLibrary.PARAM_DOUBLE pARAM_DOUBLE, double d) {
        try {
            if (this.mSdrlib != null) {
                this.mSdrlib.setParamDouble(pARAM_DOUBLE, d);
            }
        }
        catch (Throwable throwable) {
            Main.displayException(this.frmTempestSdr, throwable);
            return;
        }
    }

    @Override
    public void onValueChanged(TSDRLibrary.IncomingValueCallback.VALUE_ID vALUE_ID, double d, double d2) {
        switch (vALUE_ID) {
            case PLL_FRAMERATE: {
                this.setFramerateValButDoNotSyncWithLibrary(d);
                break;
            }
            case AUTOCORRECT_RESET: {
                this.btnReset.setSelected(false);
                break;
            }
            case FRAMES_COUNT: {
                this.lblFrames.setText(Integer.toString((int)d2));
                break;
            }
            case AUTOGAIN: {
                this.autoScaleVisualizer.setValue(d, d2);
                break;
            }
            case SNR: {
                break;
            }
            case AUTOCORRECT_DUMPED: {
                this.tglbtnDmp.setSelected(false);
                File file = new File("autocorr.csv");
                this.visualizer.setOSD(file.exists() ? "Autocorrelation dumped " + file.getAbsolutePath() : "Failed to dump autocorrelation", 2000L);
                break;
            }
            default: {
                System.out.println("Java Main received notification that value " + (Object)((Object)vALUE_ID) + " has changed to arg0=" + d + " and arg1=" + d2);
            }
        }
    }

    private Long hashHeightAndFPS(double d, int n) {
        return (long)(d * (double)n);
    }

    @Override
    public void onIncommingPlot(TSDRLibrary.IncomingValueCallback.PLOT_ID pLOT_ID, int n, double[] dArray, int n2, long l) {
        this.btnReset.setSelected(false);
        switch (pLOT_ID) {
            case FRAME: {
                this.frame_plotter.plot(dArray, n, n2, l);
                if (!this.auto_resolution) break;
                this.auto_resolution_fps_id = this.frame_plotter.getMaxIndex();
                this.auto_resolution_fps_offset = this.frame_plotter.getOffset();
                break;
            }
            case LINE: {
                int n3;
                this.line_plotter.plot(dArray, n, n2, l);
                if (!this.auto_resolution || this.auto_resolution_fps_id == null) break;
                assert (this.auto_resolution_fps_offset != null);
                assert (l == this.line_plotter.getSamplerate());
                if (this.frame_plotter.getSamplerate() != l) break;
                double d = this.fps_transofmer.fromIndex(this.auto_resolution_fps_id, this.auto_resolution_fps_offset, l);
                Long l2 = this.hashHeightAndFPS(d, n3 = this.roundData(this.height_transformer.fromIndexAndLength(this.line_plotter.getMaxIndex(), this.line_plotter.getOffset(), l, this.auto_resolution_fps_id + this.auto_resolution_fps_offset)));
                Integer n4 = this.auto_resolution_map.get(l2);
                if (n4 != null && n4 == 3) {
                    this.onResolutionChange(d, n3, "Detected %s");
                    this.btnAutoResolution.setSelected(false);
                    this.auto_resolution = false;
                    break;
                }
                if (n4 == null) {
                    n4 = 0;
                }
                Integer n5 = n4;
                Integer n6 = n4 = Integer.valueOf(n4 + 1);
                this.auto_resolution_map.put(l2, n4);
                break;
            }
            default: {
                System.out.println("Java Main received unimplemented notification plot value " + (Object)((Object)pLOT_ID) + " with size " + n2);
            }
        }
    }

    private class TransformerAndCallbackHeight
    extends PlotVisualizer.TransformerAndCallback {
        private Integer length = null;

        private TransformerAndCallbackHeight() {
        }

        public void setLength(Integer n) {
            this.length = n;
        }

        @Override
        public String getDescription(double d, int n) {
            int n2 = Main.this.roundData(Math.max(Math.abs(Main.this.line_plotter.getValueFromId(n + 1) - d), Math.abs(Main.this.line_plotter.getValueFromId(n - 1) - d))) - 1;
            if (n2 > 0) {
                return String.format("%d (\u00b1%d) px", Main.this.roundData(d), n2);
            }
            return String.format("%d px", Main.this.roundData(d));
        }

        public double fromIndexAndLength(int n, int n2, long l, double d) {
            double d2 = n2 + n;
            return d / d2;
        }

        @Override
        public double fromIndex(int n, int n2, long l) {
            return this.fromIndexAndLength(n, n2, l, this.length == null ? (double)l / Main.this.framerate : (double)this.length.intValue());
        }

        @Override
        public void executeIdSelected(int n, int n2, long l) {
            if (Main.this.plot_change_from_auto) {
                return;
            }
            int n3 = Main.this.roundData(Main.this.line_plotter.getSelectedValue());
            Main.this.onResolutionChange(Main.this.framerate, n3, "Chosen %s");
        }

        @Override
        public int toIndex(double d, int n, long l) {
            double d2 = this.length == null ? (double)l / Main.this.framerate : (double)this.length.intValue();
            return Main.this.roundData(d2 / d - (double)n);
        }
    }

    private class ActRegistrator
    implements TSDRSource.ActionListenerRegistrator {
        private final ArrayList<ActionListener> listeners = new ArrayList();
        private final ActionEvent e = new ActionEvent(Main.this, 0, null);

        private ActRegistrator() {
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.listeners.add(actionListener);
        }

        public void action() {
            for (ActionListener actionListener : this.listeners) {
                actionListener.actionPerformed(this.e);
            }
        }
    }
}

