# This file is proprietary to Crowd Render Pty Limited and is confidential.

# <sort of PEP8 Compliant, lines are not always 79 chars long>

"""
crowdrender blender python package for crowd accelerated rendering 

This package implements a multi-process, multi-machine distributed 
rendering addon for Blender.

This package exports the following modules:

client - manage a user session across multiple nodes
CROWD_RENDER - define and register a RenderEngine subclass
hash_tree - define a custom hash tree for data checking between nodes
image_recombine - recombine parts of a single image rendered on other nodes
network_engine - manage network traffic between nodes
network_nodes - define a custom node tree for blenders node editor
node_sync - efficiently synchronise node data 
server - manage multiple user sessions on one node
settings - define settings for each scene
ui_operators - define Blender operators
ui_panels - define Blender panels
update_handler - handle events generated by changes to scene data

"""
# IMPORTS
import bpy, sys, os, logging


bl_info = {
    "name": "CrowdRender",
    "author": "www.crowd-render.com",
    "version": (0, 2, 2),
    "blender": (2, 80, 0),
    "location": "Render > Engine > Crowd Render",
    "description": "Network/Internet based rendering acceleration",
    "warning": "Alpha software, stability not guaranteed!",
    "wiki_url": "www.crowd-render.com",
    "tracker_url":"https://www.crowd-render.com/report-a-problem",
    "category": "Render"}



# Following the convention in 
# http://wiki.blender.org/index.php/Dev:2.5/Py/Scripts/Cookbook/Code_snippets/
# Multi-File_packages
# This block of code is used whenever blender is started to import the modules
# (.py files) of the crowdrender package. 







# PACKAGE GLOBALS
package_name = __name__
crowdrender_path = os.path.split(__file__)[0]


#Set path to include crowdrender so we can import subpackages like zmq

def select_platform():
    """ checks python/blender versions and sets import paths accordingly
    """
    
                    
    global cr_source
    
    if sys.platform.startswith('darwin'):
        set_sys_path('Darwin')

    
    elif sys.platform.startswith('linux'):
        set_sys_path('Linux')


    elif sys.platform.startswith('win'):
        set_sys_path('Win64')

    else:
        
        raise RuntimeError(" unsupported operating system! :" +\
                python_version +" Linux, MacOS and Win64 are supported")

    from . import src as cr_source
    
def get_blender_scripts_path():
    
    #first try the user path for scripts
    
    user_path = bpy.utils.user_resource('SCRIPTS', "addons", create=False)
    
    # if user_path == "":
        
        
def set_sys_path(platform_name):
    """ sets import paths to allow third party libs to be imported
        """
    
    #get python version
    major = sys.version_info.major
    minor = sys.version_info.minor

    
    sep = os.path.sep
    crowdrender_lib_path = crowdrender_path + sep +\
        'lib' + sep + platform_name + sep + str(major) + "_" + str(minor)
    
    sys.path.append(crowdrender_lib_path)

def register():
    
    select_platform()
    
    cr_source.register()
    
    
def unregister():
    
    if 'cr_platform' in globals():
    
        cr_source.unregister()
        
    else:
        print("dodgy, but trying to unregister anyway")
        
        cr_source.unregister()
        
#         raise RuntimeError("could not find the cr_platform while unregistering!")

 


if __name__ == '__main__':
    register()
