# This file is proprietary to Crowd Render Pty Limited and is confidential.

# <sort of PEP8 Compliant, lines are not always 79 chars long>

"""
crowdrender blender python package for crowd accelerated rendering 

This package implements a multi-process, multi-machine distributed 
rendering addon for Blender.

This package exports the following modules:

client - manage a user session across multiple nodes
CROWD_RENDER - define and register a RenderEngine subclass
hash_tree - define a custom hash tree for data checking between nodes
image_recombine - recombine parts of a single image rendered on other nodes
network_engine - manage network traffic between nodes
network_nodes - define a custom node tree for blenders node editor
node_sync - efficiently synchronise node data 
server - manage multiple user sessions on one node
settings - define settings for each scene
ui_operators - define Blender operators
ui_panels - define Blender panels
update_handler - handle events generated by changes to scene data

"""

# IMPORTS------------------------------------------------------------------
import sys, bpy, os


#Set path to include crowdrender so we can import subpackages like zmq

def select_versions():
    """ checks python/blender versions and sets import paths accordingly
    """
    
    global cr_version
    
    this_dir = os.path.split(__file__)[0]
    
    if os.path.exists(this_dir + os.sep + 'cr'):
        
        from . import cr as cr_version
    
    else:
        
        python_version = str(sys.version_info.major) + '.' +\
        str(sys.version_info.minor) + '.' +\
        str(sys.version_info.micro)
                    
        if python_version == '3.5.1':
        
            from . import py_3_5_2 as cr_version
        
        elif python_version == '3.5.2':
            from . import py_3_5_2 as cr_version
        
        elif python_version == '3.5.3':
            from . import py_3_5_3 as cr_version
            #python 3.5.3
            
        elif sys.version_info.minor == 6:
            
            from . import py_3_6 as cr_version
            
        elif sys.version_info.minor == 7:
        
            from . import py_3_7 as cr_version
            
             # better system on the way, now daily 2.79 blds
            # are using python 3.7.0 we're seeing this
            # method of conditional importing staarting
            # to look stupid, this particular line is 
            # for support of 2.79 daily builds with python
            # 3.7.0 and above.
            
        else:
            raise RuntimeError(" unsupported version of python, you have :" +\
                python_version +" supported versions are 3.5.2 and 3.5.3 for 2.78, and "+\
                    "3.6.7 and 3.7.0 for 2.79 daily builds and 2.80")

    



def register():
    
    select_versions()
    

    
    cr_version.register()
    
def unregister():

    if 'cr_version' in globals():
        
        cr_version.unregister()
        
    else:
        print('dodgy, but going to try and unregister anyway')
        
        cr_version.unregister()
        
        # raise RuntimeError("tried to unregister in " + __name__ +\
#             " but cr_version was not there, so could not unregister it!")




if __name__ == '__main__':
    register()
