# This file is property Crowd Render Pty Limited and is confidential.

# <sort of PEP8 Compliant, lines are not always 79 chars long>

import bpy, sys, os


s = os.path.sep
user_preferences = bpy.context.preferences

cr_pkg = 'crowdrender'

# if this addon is already enabled, then there is no need 
# to enable it a second time.
if not cr_pkg in user_preferences.addons:
    bpy.ops.preferences.addon_enable(module = cr_pkg)

crowdrender = sys.modules[cr_pkg]    
    
# get a ref to the crowdrender addon prefs so we can determine if debugging is on or not
addon_prefs = user_preferences.addons[cr_pkg].preferences

if addon_prefs.use_debug:

    try:
     
        ret = bpy.ops.preferences.addon_enable(module = "remote_debugger")
    
        if ret == {'CANCELLED'}:
            print("remote debugger could not be enabled, is it installed?")
    #     bpy.context.preferences.addons["remote_debugger"].preferences['pydevpath'] = \
    #     "/Applications/Eclipse.app/Contents/Eclipse/plugins/" +\
    #     "org.python.pydev_5.3.1.201610311318/pysrc/pydevd.py"
 
        else: 
            ret = bpy.ops.debug.connect_debugger_pydev()
        
            if ret == {"CANCELLED"}:
                print("remote debugger could not be enabled, the remote_debugger addon cancelled, "
                      "have you setup your path in user preferences?")
 
    except:
        
        print("could not start debugging environment, pls check remote_debugger ",
              "is enabled, you have configured the correct paths and the debug server",
              " is running")


    

#_______________ CONDITIONAL IMPORT BASED ON PACKAGE ___________________________________#

# for packages with source code
if s+'cr'+s in __file__:
    client_interface = crowdrender.src.cr.client_interface
    
# for packages using compiled code    
elif s+'py_3_5_2'+s in __file__:
    client_interface = crowdrender.src.py_3_5_2.client_interface
    
elif s+'py_3_5_3'+s in __file__:
    client_interface = crowdrender.src.py_3_5_3.client_interface
    
elif s+'py_3_6'+s in __file__:
    client_interface = crowdrender.src.py_3_6.client_interface
    
elif s+'py_3_7'+s in __file__:
    client_interface = crowdrender.src.py_3_7.client_interface

    

cs_manager = client_interface.CRClientServerManager()

