/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.sources;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JTextField;
import martin.tempest.core.TSDRLibrary;
import martin.tempest.core.exceptions.TSDRLibraryNotCompatible;
import martin.tempest.sources.TSDRExtIOSource;
import martin.tempest.sources.TSDRFileSource;
import martin.tempest.sources.TSDRMiricsSource;
import martin.tempest.sources.TSDRSDRPlaySource;
import martin.tempest.sources.TSDRUHDSource;

public class TSDRSource {
    private static final TSDRSource[] SOURCES = new TSDRSource[]{new TSDRFileSource(), new TSDRMiricsSource(), new TSDRUHDSource(), new TSDRExtIOSource(), new TSDRSDRPlaySource()};
    public final String libname;
    public final boolean absolute;
    public final String descr;
    private TSDRSourceParamChangedListener callback = null;
    private String params = "";

    public static TSDRSource[] getAvailableSources() {
        return SOURCES;
    }

    public TSDRSource(String string, String string2, boolean bl) {
        this.descr = string;
        this.libname = string2;
        this.absolute = bl;
    }

    public void setParams(String string) {
        this.params = string;
        if (this.callback != null) {
            this.callback.onParametersChanged(this);
        }
    }

    public String getParams() {
        return this.params;
    }

    public String toString() {
        return this.descr;
    }

    public String getAbsolutePathToLibrary() {
        if (this.absolute) {
            return this.libname;
        }
        try {
            return TSDRLibrary.extractLibrary(this.libname).getAbsolutePath();
        }
        catch (TSDRLibraryNotCompatible tSDRLibraryNotCompatible) {
            try {
                String[] stringArray;
                String string = TSDRLibrary.getNativeLibraryFullName(this.libname);
                File file = new File(string);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                for (String string2 : stringArray = System.getProperty("java.library.path").split(File.pathSeparator)) {
                    File file2 = new File(string2 + File.separator + string);
                    if (!file2.exists()) continue;
                    return file2.getAbsolutePath();
                }
            }
            catch (TSDRLibraryNotCompatible tSDRLibraryNotCompatible2) {
                // empty catch block
            }
            return this.libname;
        }
    }

    public void setOnParameterChangedCallback(TSDRSourceParamChangedListener tSDRSourceParamChangedListener) {
        this.callback = tSDRSourceParamChangedListener;
    }

    public boolean populateGUI(Container container, String string, ActionListenerRegistrator actionListenerRegistrator) {
        if (container == null) {
            this.setParams(string);
        }
        JLabel jLabel = new JLabel("Type in the parameters:");
        container.add(jLabel);
        jLabel.setBounds(12, 12, 388, 24);
        final JTextField jTextField = new JTextField(string);
        container.add(jTextField);
        jTextField.setBounds(12, 44, 388, 24);
        actionListenerRegistrator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TSDRSource.this.setParams(jTextField.getText());
            }
        });
        return true;
    }

    public static interface ActionListenerRegistrator {
        public void addActionListener(ActionListener var1);
    }

    public static interface TSDRSourceParamChangedListener {
        public void onParametersChanged(TSDRSource var1);
    }
}

