

// The Module object: Our interface to the outside world. We import
// and export values on it. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to check if Module already exists (e.g. case 3 above).
// Substitution will be replaced with actual code on later stage of the build,
// this way Closure Compiler will not mangle it (e.g. case 4. above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module = typeof Module !== 'undefined' ? Module : {};

// --pre-jses are emitted after the Module integration code, so that they can
// refer to Module (if they choose; they can also define Module)
(function(root,factory){
if(typeof define === 'function' && define.amd){
define(['module','require'],factory.bind(null,root));
}else if(typeof module === 'object' && module.exports){
var env=typeof process !== 'undefined' && process && process.env?process.env:root;
factory(env,module,module.require);
}else{
root.Flac=factory(root);
}
}(typeof self !== 'undefined'?self:typeof window !== 'undefined'?window:this,function(global,expLib,require){
'use strict';
var Module=Module || {};
var _flac_ready=false;
Module["onRuntimeInitialized"]=function(){
_flac_ready=true;
if(!_exported){
setTimeout(function(){do_fire_event('ready',[{type:'ready',target:_exported}],true);},0);
}else{
do_fire_event('ready',[{type:'ready',target:_exported}],true);
}
};
if(global && global.FLAC_SCRIPT_LOCATION){
Module["locateFile"]=function(fileName){
var path=global.FLAC_SCRIPT_LOCATION || '';
if(path[fileName]){
return path[fileName];
}
path+=path && !/\/$/.test(path)?'/':'';
return path+fileName;
};
var readBinary=function(filePath){
if(ENVIRONMENT_IS_NODE){
var ret=read_(filePath,true);
if(!ret.buffer){
ret=new Uint8Array(ret);
}
assert(ret.buffer);
return ret;
}
return new Promise(function(resolve,reject){
var xhr=new XMLHttpRequest();
xhr.responseType="arraybuffer";
xhr.addEventListener("load",function(evt){
resolve(xhr.response);
});
xhr.addEventListener("error",function(err){
reject(err);
});
xhr.open("GET",filePath);
xhr.send();
});};}
if(global && typeof global.fetch === 'function'){
var _fetch=global.fetch;
global.fetch=function(url){
return _fetch.apply(null,arguments).catch(function(err){
try{
var result=readBinary(url);
if(result && result.catch){
result.catch(function(_err){throw err;});
}
return result;
}catch(_err){
throw err;
}});};}


// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
var key;
for (key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

var arguments_ = [];
var thisProgram = './this.program';
var quit_ = function(status, toThrow) {
  throw toThrow;
};

// Determine the runtime environment we are in. You can customize this by
// setting the ENVIRONMENT setting at compile time (see settings.js).

// Attempt to auto-detect the environment
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
// N.b. Electron.js environment is simultaneously a NODE-environment, but
// also a web environment.
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof process.versions === 'object' && typeof process.versions.node === 'string';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (Module['ENVIRONMENT']) {
  throw new Error('Module.ENVIRONMENT has been deprecated. To force the environment, use the ENVIRONMENT compile-time option (for example, -s ENVIRONMENT=web or -s ENVIRONMENT=node)');
}

// `/` should be present at the end if `scriptDirectory` is not empty
var scriptDirectory = '';
function locateFile(path) {
  if (Module['locateFile']) {
    return Module['locateFile'](path, scriptDirectory);
  }
  return scriptDirectory + path;
}

// Hooks that are implemented differently in different runtime environments.
var read_,
    readAsync,
    readBinary,
    setWindowTitle;

var nodeFS;
var nodePath;

if (ENVIRONMENT_IS_NODE) {
  if (!(typeof process === 'object' && typeof require === 'function')) throw new Error('not compiled for this environment (did you build to HTML and try to run it not on the web, or set ENVIRONMENT to something - like node - and run it someplace else - like on the web?)');
  if (ENVIRONMENT_IS_WORKER) {
    scriptDirectory = require('path').dirname(scriptDirectory) + '/';
  } else {
    scriptDirectory = __dirname + '/';
  }

// include: node_shell_read.js


read_ = function shell_read(filename, binary) {
  var ret = tryParseAsDataURI(filename);
  if (ret) {
    return binary ? ret : ret.toString();
  }
  if (!nodeFS) nodeFS = require('fs');
  if (!nodePath) nodePath = require('path');
  filename = nodePath['normalize'](filename);
  return nodeFS['readFileSync'](filename, binary ? null : 'utf8');
};

readBinary = function readBinary(filename) {
  var ret = read_(filename, true);
  if (!ret.buffer) {
    ret = new Uint8Array(ret);
  }
  assert(ret.buffer);
  return ret;
};

readAsync = function readAsync(filename, onload, onerror) {
  var ret = tryParseAsDataURI(filename);
  if (ret) {
    onload(ret);
  }
  if (!nodeFS) nodeFS = require('fs');
  if (!nodePath) nodePath = require('path');
  filename = nodePath['normalize'](filename);
  nodeFS['readFile'](filename, function(err, data) {
    if (err) onerror(err);
    else onload(data.buffer);
  });
};

// end include: node_shell_read.js
  if (process['argv'].length > 1) {
    thisProgram = process['argv'][1].replace(/\\/g, '/');
  }

  arguments_ = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  quit_ = function(status, toThrow) {
    if (keepRuntimeAlive()) {
      process['exitCode'] = status;
      throw toThrow;
    }
    process['exit'](status);
  };

  Module['inspect'] = function () { return '[Emscripten Module object]'; };

} else
if (ENVIRONMENT_IS_SHELL) {

  if ((typeof process === 'object' && typeof require === 'function') || typeof window === 'object' || typeof importScripts === 'function') throw new Error('not compiled for this environment (did you build to HTML and try to run it not on the web, or set ENVIRONMENT to something - like node - and run it someplace else - like on the web?)');

  if (typeof read != 'undefined') {
    read_ = function shell_read(f) {
      var data = tryParseAsDataURI(f);
      if (data) {
        return intArrayToString(data);
      }
      return read(f);
    };
  }

  readBinary = function readBinary(f) {
    var data;
    data = tryParseAsDataURI(f);
    if (data) {
      return data;
    }
    if (typeof readbuffer === 'function') {
      return new Uint8Array(readbuffer(f));
    }
    data = read(f, 'binary');
    assert(typeof data === 'object');
    return data;
  };

  readAsync = function readAsync(f, onload, onerror) {
    setTimeout(function() { onload(readBinary(f)); }, 0);
  };

  if (typeof scriptArgs != 'undefined') {
    arguments_ = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    arguments_ = arguments;
  }

  if (typeof quit === 'function') {
    quit_ = function(status) {
      quit(status);
    };
  }

  if (typeof print !== 'undefined') {
    // Prefer to use print/printErr where they exist, as they usually work better.
    if (typeof console === 'undefined') console = /** @type{!Console} */({});
    console.log = /** @type{!function(this:Console, ...*): undefined} */ (print);
    console.warn = console.error = /** @type{!function(this:Console, ...*): undefined} */ (typeof printErr !== 'undefined' ? printErr : print);
  }

} else

// Note that this includes Node.js workers when relevant (pthreads is enabled).
// Node.js workers are detected as a combination of ENVIRONMENT_IS_WORKER and
// ENVIRONMENT_IS_NODE.
if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  if (ENVIRONMENT_IS_WORKER) { // Check worker, not web, since window could be polyfilled
    scriptDirectory = self.location.href;
  } else if (typeof document !== 'undefined' && document.currentScript) { // web
    scriptDirectory = document.currentScript.src;
  }
  // blob urls look like blob:http://site.com/etc/etc and we cannot infer anything from them.
  // otherwise, slice off the final part of the url to find the script directory.
  // if scriptDirectory does not contain a slash, lastIndexOf will return -1,
  // and scriptDirectory will correctly be replaced with an empty string.
  if (scriptDirectory.indexOf('blob:') !== 0) {
    scriptDirectory = scriptDirectory.substr(0, scriptDirectory.lastIndexOf('/')+1);
  } else {
    scriptDirectory = '';
  }

  if (!(typeof window === 'object' || typeof importScripts === 'function')) throw new Error('not compiled for this environment (did you build to HTML and try to run it not on the web, or set ENVIRONMENT to something - like node - and run it someplace else - like on the web?)');

  // Differentiate the Web Worker from the Node Worker case, as reading must
  // be done differently.
  {

// include: web_or_worker_shell_read.js


  read_ = function(url) {
    try {
      var xhr = new XMLHttpRequest();
      xhr.open('GET', url, false);
      xhr.send(null);
      return xhr.responseText;
    } catch (err) {
      var data = tryParseAsDataURI(url);
      if (data) {
        return intArrayToString(data);
      }
      throw err;
    }
  };

  if (ENVIRONMENT_IS_WORKER) {
    readBinary = function(url) {
      try {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, false);
        xhr.responseType = 'arraybuffer';
        xhr.send(null);
        return new Uint8Array(/** @type{!ArrayBuffer} */(xhr.response));
      } catch (err) {
        var data = tryParseAsDataURI(url);
        if (data) {
          return data;
        }
        throw err;
      }
    };
  }

  readAsync = function(url, onload, onerror) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function() {
      if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
        onload(xhr.response);
        return;
      }
      var data = tryParseAsDataURI(url);
      if (data) {
        onload(data.buffer);
        return;
      }
      onerror();
    };
    xhr.onerror = onerror;
    xhr.send(null);
  };

// end include: web_or_worker_shell_read.js
  }

  setWindowTitle = function(title) { document.title = title };
} else
{
  throw new Error('environment detection error');
}

// Set up the out() and err() hooks, which are how we can print to stdout or
// stderr, respectively.
var out = Module['print'] || console.log.bind(console);
var err = Module['printErr'] || console.warn.bind(console);

// Merge back in the overrides
for (key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// Free the object hierarchy contained in the overrides, this lets the GC
// reclaim data used e.g. in memoryInitializerRequest, which is a large typed array.
moduleOverrides = null;

// Emit code to handle expected values on the Module object. This applies Module.x
// to the proper local x. This has two benefits: first, we only emit it if it is
// expected to arrive, and second, by using a local everywhere else that can be
// minified.

if (Module['arguments']) arguments_ = Module['arguments'];
if (!Object.getOwnPropertyDescriptor(Module, 'arguments')) {
  Object.defineProperty(Module, 'arguments', {
    configurable: true,
    get: function() {
      abort('Module.arguments has been replaced with plain arguments_ (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (Module['thisProgram']) thisProgram = Module['thisProgram'];
if (!Object.getOwnPropertyDescriptor(Module, 'thisProgram')) {
  Object.defineProperty(Module, 'thisProgram', {
    configurable: true,
    get: function() {
      abort('Module.thisProgram has been replaced with plain thisProgram (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (Module['quit']) quit_ = Module['quit'];
if (!Object.getOwnPropertyDescriptor(Module, 'quit')) {
  Object.defineProperty(Module, 'quit', {
    configurable: true,
    get: function() {
      abort('Module.quit has been replaced with plain quit_ (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

// perform assertions in shell.js after we set up out() and err(), as otherwise if an assertion fails it cannot print the message
// Assertions on removed incoming Module JS APIs.
assert(typeof Module['memoryInitializerPrefixURL'] === 'undefined', 'Module.memoryInitializerPrefixURL option was removed, use Module.locateFile instead');
assert(typeof Module['pthreadMainPrefixURL'] === 'undefined', 'Module.pthreadMainPrefixURL option was removed, use Module.locateFile instead');
assert(typeof Module['cdInitializerPrefixURL'] === 'undefined', 'Module.cdInitializerPrefixURL option was removed, use Module.locateFile instead');
assert(typeof Module['filePackagePrefixURL'] === 'undefined', 'Module.filePackagePrefixURL option was removed, use Module.locateFile instead');
assert(typeof Module['read'] === 'undefined', 'Module.read option was removed (modify read_ in JS)');
assert(typeof Module['readAsync'] === 'undefined', 'Module.readAsync option was removed (modify readAsync in JS)');
assert(typeof Module['readBinary'] === 'undefined', 'Module.readBinary option was removed (modify readBinary in JS)');
assert(typeof Module['setWindowTitle'] === 'undefined', 'Module.setWindowTitle option was removed (modify setWindowTitle in JS)');
assert(typeof Module['TOTAL_MEMORY'] === 'undefined', 'Module.TOTAL_MEMORY has been renamed Module.INITIAL_MEMORY');

if (!Object.getOwnPropertyDescriptor(Module, 'read')) {
  Object.defineProperty(Module, 'read', {
    configurable: true,
    get: function() {
      abort('Module.read has been replaced with plain read_ (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (!Object.getOwnPropertyDescriptor(Module, 'readAsync')) {
  Object.defineProperty(Module, 'readAsync', {
    configurable: true,
    get: function() {
      abort('Module.readAsync has been replaced with plain readAsync (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (!Object.getOwnPropertyDescriptor(Module, 'readBinary')) {
  Object.defineProperty(Module, 'readBinary', {
    configurable: true,
    get: function() {
      abort('Module.readBinary has been replaced with plain readBinary (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

if (!Object.getOwnPropertyDescriptor(Module, 'setWindowTitle')) {
  Object.defineProperty(Module, 'setWindowTitle', {
    configurable: true,
    get: function() {
      abort('Module.setWindowTitle has been replaced with plain setWindowTitle (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}
var IDBFS = 'IDBFS is no longer included by default; build with -lidbfs.js';
var PROXYFS = 'PROXYFS is no longer included by default; build with -lproxyfs.js';
var WORKERFS = 'WORKERFS is no longer included by default; build with -lworkerfs.js';
var NODEFS = 'NODEFS is no longer included by default; build with -lnodefs.js';


assert(!ENVIRONMENT_IS_SHELL, "shell environment detected but not enabled at build time.  Add 'shell' to `-s ENVIRONMENT` to enable.");




var STACK_ALIGN = 16;

function getNativeTypeSize(type) {
  switch (type) {
    case 'i1': case 'i8': return 1;
    case 'i16': return 2;
    case 'i32': return 4;
    case 'i64': return 8;
    case 'float': return 4;
    case 'double': return 8;
    default: {
      if (type[type.length-1] === '*') {
        return 4; // A pointer
      } else if (type[0] === 'i') {
        var bits = Number(type.substr(1));
        assert(bits % 8 === 0, 'getNativeTypeSize invalid bits ' + bits + ', type ' + type);
        return bits / 8;
      } else {
        return 0;
      }
    }
  }
}

function warnOnce(text) {
  if (!warnOnce.shown) warnOnce.shown = {};
  if (!warnOnce.shown[text]) {
    warnOnce.shown[text] = 1;
    err(text);
  }
}

// include: runtime_functions.js


// Wraps a JS function as a wasm function with a given signature.
function convertJsFunctionToWasm(func, sig) {
  return func;
}

var freeTableIndexes = [];

// Weak map of functions in the table to their indexes, created on first use.
var functionsInTableMap;

function getEmptyTableSlot() {
  // Reuse a free index if there is one, otherwise grow.
  if (freeTableIndexes.length) {
    return freeTableIndexes.pop();
  }
  // Grow the table
  try {
    wasmTable.grow(1);
  } catch (err) {
    if (!(err instanceof RangeError)) {
      throw err;
    }
    throw 'Unable to grow wasm table. Set ALLOW_TABLE_GROWTH.';
  }
  return wasmTable.length - 1;
}

// Add a wasm function to the table.
function addFunctionWasm(func, sig) {
  // Check if the function is already in the table, to ensure each function
  // gets a unique index. First, create the map if this is the first use.
  if (!functionsInTableMap) {
    functionsInTableMap = new WeakMap();
    for (var i = 0; i < wasmTable.length; i++) {
      var item = wasmTable.get(i);
      // Ignore null values.
      if (item) {
        functionsInTableMap.set(item, i);
      }
    }
  }
  if (functionsInTableMap.has(func)) {
    return functionsInTableMap.get(func);
  }

  // It's not in the table, add it now.

  var ret = getEmptyTableSlot();

  // Set the new value.
  try {
    // Attempting to call this with JS function will cause of table.set() to fail
    wasmTable.set(ret, func);
  } catch (err) {
    if (!(err instanceof TypeError)) {
      throw err;
    }
    assert(typeof sig !== 'undefined', 'Missing signature argument to addFunction: ' + func);
    var wrapped = convertJsFunctionToWasm(func, sig);
    wasmTable.set(ret, wrapped);
  }

  functionsInTableMap.set(func, ret);

  return ret;
}

function removeFunction(index) {
  functionsInTableMap.delete(wasmTable.get(index));
  freeTableIndexes.push(index);
}

// 'sig' parameter is required for the llvm backend but only when func is not
// already a WebAssembly function.
function addFunction(func, sig) {
  assert(typeof func !== 'undefined');

  return addFunctionWasm(func, sig);
}

// end include: runtime_functions.js
// include: runtime_debug.js


// end include: runtime_debug.js
var tempRet0 = 0;

var setTempRet0 = function(value) {
  tempRet0 = value;
};

var getTempRet0 = function() {
  return tempRet0;
};



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in:
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at:
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html

var wasmBinary;
if (Module['wasmBinary']) wasmBinary = Module['wasmBinary'];
if (!Object.getOwnPropertyDescriptor(Module, 'wasmBinary')) {
  Object.defineProperty(Module, 'wasmBinary', {
    configurable: true,
    get: function() {
      abort('Module.wasmBinary has been replaced with plain wasmBinary (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}
var noExitRuntime = Module['noExitRuntime'] || true;
if (!Object.getOwnPropertyDescriptor(Module, 'noExitRuntime')) {
  Object.defineProperty(Module, 'noExitRuntime', {
    configurable: true,
    get: function() {
      abort('Module.noExitRuntime has been replaced with plain noExitRuntime (the initial value can be provided on Module, but after startup the value is only looked for on a local variable of that name)')
    }
  });
}

// include: wasm2js.js


// wasm2js.js - enough of a polyfill for the WebAssembly object so that we can load
// wasm2js code that way.

// Emit "var WebAssembly" if definitely using wasm2js. Otherwise, in MAYBE_WASM2JS
// mode, we can't use a "var" since it would prevent normal wasm from working.
/** @suppress{duplicate, const} */
var
WebAssembly = {
  // Note that we do not use closure quoting (this['buffer'], etc.) on these
  // functions, as they are just meant for internal use. In other words, this is
  // not a fully general polyfill.
  Memory: function(opts) {
    this.buffer = new ArrayBuffer(opts['initial'] * 65536);
  },

  Module: function(binary) {
    // TODO: use the binary and info somehow - right now the wasm2js output is embedded in
    // the main JS
  },

  Instance: function(module, info) {
    // TODO: use the module and info somehow - right now the wasm2js output is embedded in
    // the main JS
    // This will be replaced by the actual wasm2js code.
    this.exports = (
function instantiate(asmLibraryArg) {
function Table(ret) {
  ret.grow = function(by) {
    var old = this.length;
    this.length = this.length + by;
    return old;
  };
  ret.set = function(i, func) {
    this[i] = func;
  };
  ret.get = function(i) {
    return this[i];
  };
  return ret;
}

  var bufferView;
  var base64ReverseLookup = new Uint8Array(123/*'z'+1*/);
  for (var i = 25; i >= 0; --i) {
    base64ReverseLookup[48+i] = 52+i; // '0-9'
    base64ReverseLookup[65+i] = i; // 'A-Z'
    base64ReverseLookup[97+i] = 26+i; // 'a-z'
  }
  base64ReverseLookup[43] = 62; // '+'
  base64ReverseLookup[47] = 63; // '/'
  /** @noinline Inlining this function would mean expanding the base64 string 4x times in the source code, which Closure seems to be happy to do. */
  function base64DecodeToExistingUint8Array(uint8Array, offset, b64) {
    var b1, b2, i = 0, j = offset, bLength = b64.length, end = offset + (bLength*3>>2) - (b64[bLength-2] == '=') - (b64[bLength-1] == '=');
    for (; i < bLength; i += 4) {
      b1 = base64ReverseLookup[b64.charCodeAt(i+1)];
      b2 = base64ReverseLookup[b64.charCodeAt(i+2)];
      uint8Array[j++] = base64ReverseLookup[b64.charCodeAt(i)] << 2 | b1 >> 4;
      if (j < end) uint8Array[j++] = b1 << 4 | b2 >> 2;
      if (j < end) uint8Array[j++] = b2 << 6 | base64ReverseLookup[b64.charCodeAt(i+3)];
    }
  }
function initActiveSegments(imports) {
  base64DecodeToExistingUint8Array(bufferView, 1024, "AAcOCRwbEhU4PzYxJCMqLXB3fnlsa2JlSE9GQVRTWl3g5+7p/Pvy9djf1tHEw8rNkJeemYyLgoWor6ahtLO6vcfAyc7b3NXS//jx9uPk7eq3sLm+q6yloo+IgYaTlJ2aJyApLjs8NTIfGBEWAwQNCldQWV5LTEVCb2hhZnN0fXqJjoeAlZKbnLG2v7itqqOk+f738OXi6+zBxs/I3drT1GluZ2B1cnt8UVZfWE1KQ0QZHhcQBQILDCEmLyg9OjM0TklAR1JVXFt2cXh/am1kYz45MDciJSwrBgEIDxodFBOuqaCnsrW8u5aRmJ+KjYSD3tnQ18LFzMvm4ejv+v308wAABYAPgAoAG4AeABQAEYAzgDYAPAA5gCgALYAngCIAY4BmAGwAaYB4AH2Ad4ByAFAAVYBfgFoAS4BOAEQAQYDDgMYAzADJgNgA3YDXgNIA8AD1gP+A+gDrgO4A5ADhgKAApYCvgKoAu4C+ALQAsYCTgJYAnACZgIgAjYCHgIIAg4GGAYwBiYGYAZ2Bl4GSAbABtYG/gboBq4GuAaQBoYHgAeWB74HqAfuB/gH0AfGB04HWAdwB2YHIAc2Bx4HCAUABRYFPgUoBW4FeAVQBUYFzgXYBfAF5gWgBbYFngWIBI4EmASwBKYE4AT2BN4EyARABFYEfgRoBC4EOAQQBAYEDgwYDDAMJgxgDHYMXgxIDMAM1gz+DOgMrgy4DJAMhg2ADZYNvg2oDe4N+A3QDcYNTg1YDXANZg0gDTYNHg0IDwAPFg8+DygPbg94D1APRg/OD9gP8A/mD6APtg+eD4gOjg6YDrAOpg7gDvYO3g7IDkAOVg5+DmgOLg44DhAOBg4AChYKPgooCm4KeApQCkYKzgrYCvAK5gqgCrYKngqIC44LmAuwC6YL4Av2C94LyAtAC1YLfgtoCy4LOAsQCwYJDgkYCTAJJglgCXYJXglICcAJ1gn+CegJrgm4CZAJhgiACJYIvgioCO4I+AjQCMYITghYCHAIZgggCDYIHggICAAADhgOMAAoDmAAeABQDkgOwADYAPAO6ACgDrgOkACID4ABmAGwD6gB4A/4D9AByAFAD1gPcAFoDyABOAEQDwgNAAMYAzANKANgDXgNUANIA8AN2A3wA+gNoAO4A5ANiAKADJgMsAKoDOAC+ALQDMgMQAJYAnAMaAIgDDgMEAIIGgAUGBQwGigUYBp4GlAUSBTAGtga8BToGqAUuBSQGogVgBuYG7AVqBvgFfgV0BvIG0AVWBVwG2gVIBs4GxAVCBcAGRgZMBcoGWAXeBdQGUgZwBfYF/AZ6BegGbgZkBeIGIAWmBawGKgW4Bj4GNAWyBZAGFgYcBZoGCAWOBYQGAgmACgYKDAmKChgJngmUChIKMAm2CbwKOgmoCi4KJAmiCmAJ5gnsCmoJ+Ap+CnQJ8gnQClYKXAnaCkgJzgnECkIKwAlGCUwKyglYCt4K1AlSCXAK9gr8CXoK6AluCWQK4gkgCqYKrAkqCrgJPgk0CrIKkAkWCRwKmgkICo4KhAkCDwAMhgyMDwoMmA8eDxQMkgywDzYPPAy6DygMrgykDyIM4A9mD2wM6g94DP4M9A9yD1AM1gzcD1oMyA9OD0QMwgxAD8YPzAxKD9gMXgxUD9IP8Ax2DHwP+gxoD+4P5AxiD6AMJgwsD6oMOA++D7QMMgwQD5YPnAwaD4gMDgwED4IAABeAK4A8AFOARAB4AG+Ao4C0AIgAn4DwAOeA24DMAEOBVAFoAX+BEAEHgTuBLAHgAfeBy4HcAbOBpAGYAY+Bg4KUAqgCv4LQAseC+4LsAiACN4ILghwCc4JkAlgCT4LAA9eD64P8A5ODhAO4A6+DY4N0A0gDX4MwAyeDG4MMAwOFFAUoBT+FUAVHhXuFbAWgBbeFi4WcBfOF5AXYBc+FQARXhGuEfAQThAQEOAQvhOOE9ATIBN+EsASnhJuEjASAB5eHq4e8B9OHxAf4B++HI4c0BwgHH4dwB2eHW4dMB8OG1AboBv+GkAaHhruGrAZgBneGS4ZcBjOGJAYYBg+GA4oUCigKP4pQCkeKe4psCqAKt4qLipwK84rkCtgKz4pAC1eLa4t8CxOLBAs4Cy+L44v0C8gL34uwC6eLm4uMC4AIl4iriLwI04jECPgI74gjiDQICAgfiHAIZ4hbiEwIw4nUCegJ/4mQCYeJu4msCWAJd4lLiVwJM4kkCRgJD4kADxePK488D1OPRA94D2+Po4+0D4gPn4/wD+eP24/MD0OOVA5oDn+OEA4HjjuOLA7gDveOy47cDrOOpA6YDo+Og42UDagNv43QDceN+43sDSANN40LjRwNc41kDVgNT43ADNeM64z8DJOMhAy4DK+MY4x0DEgMX4wwDCeMG4wMDAAAA5QDqAA8A9AARAB4A+wDIAC0AIgDHADwA2QDWADMBkAF1AXoBnwFkAYEBjgFrAVgBvQGyAVcBrAFJAUYBowMgA8UDygMvA9QDMQM+A9sD6AMNAwID5wMcA/kD9gMTArACVQJaAr8CRAKhAq4CSwJ4Ap0CkgJ3AowCaQJmAoMHYAeFB4oHbweUB3EHfgebB6gHTQdCB6cHXAe5B7YHUwbwBhUGGgb/BgQG4QbuBgsGOAbdBtIGNwbMBikGJgbDBEAEpQSqBE8EtARRBF4EuwSIBG0EYgSHBHwEmQSWBHMF0AU1BToF3wUkBcEFzgUrBRgF/QXyBRcF7AUJBQYF4w/gDwUPCg/vDxQP8Q/+DxsPKA/ND8IPJw/cDzkPNg/TDnAOlQ6aDn8OhA5hDm4Oiw64Dl0OUg63DkwOqQ6mDkMMwAwlDCoMzww0DNEM3gw7DAgM7QziDAcM/AwZDBYM8w1QDbUNug1fDaQNQQ1ODasNmA19DXINlw1sDYkNhg1jCIAIZQhqCI8IdAiRCJ4IewhICK0IoghHCLwIWQhWCLMJEAn1CfoJHwnkCQEJDgnrCdgJPQkyCdcJLAnJCcYJIwugC0ULSguvC1QLsQu+C1sLaAuNC4ILZwucC3kLdguTCjAK1QraCj8KxAohCi4Kywr4Ch0KEgr3CgwK6QrmCgMAAB7gPOAiADjgZgBEAFrgcODuAMwA0uDIAJbgtOCqAKDh/gHcAcLh2AGG4aThugGQAQ7hLOEyASjhdgFUAUrhQOPeA/wD4uP4A6bjhOOaA7ADLuMM4xIDCONWA3QDauNgAj7iHOICAhjiRgJkAnriUOLOAuwC8uLoArbilOKKAoDnnge8B6LnuAfm58Tn2gfwB27nTOdSB0jnFgc0ByrnIAZ+5lzmQgZY5gYGJAY65hDmjgasBrLmqAb25tTmygbABF7kfORiBHjkJgQEBBrkMOSuBIwEkuSIBNbk9OTqBODlvgWcBYLlmAXG5eTl+gXQBU7lbOVyBWjlNgUUBQrlAO8eDzwPIu84D2bvRO9aD3AP7u/M79IPyO+WD7QPqu+gDv7u3O7CDtjuhg6kDrrukO4ODiwOMu4oDnbuVO5KDkAM3uz87OIM+OymDIQMmuyw7C4MDAwS7AgMVux07GoMYO0+DRwNAu0YDUbtZO16DVANzu3s7fIN6O22DZQNiu2ACJ7ovOiiCLjo5gjECNro8OhuCEwIUuhICBboNOgqCCDpfglcCULpWAkG6STpOgkQCY7prOmyCajp9gnUCcrpwOteC3wLYut4CybrBOsaCzALruuM65ILiOvWC/QL6uvgCr7qnOqCCpjqxgrkCvrq0OpOCmwKcupoCjbqFOoKCgAAAP4A3AAiAbgBRgFkAZoCUAKuAowCcgPoAxYDNAPKBKAEXgR8BIIFGAXmBcQFOgbwBg4GLAbSB0gHtgeUB2oIYAieCLwIQgnYCSYJBAn6CjAKzgrsChILiAt2C1QLqgzADD4MHAziDXgNhg2kDVoOkA5uDkwOsg8oD9YP9A8KEeARHhE8EcIQWBCmEIQQehOwE04TbBOSEggS9hLUEioVQBW+FZwVYhT4FAYUJBTaFxAX7hfMFzIWqBZWFnQWihmAGX4ZXBmiGDgYxhjkGBob0BsuGwwb8hpoGpYatBpKHSAd3h38HQIcmBxmHEQcuh9wH44frB9SHsgeNh4UHuoi4CIeIjwiwiNYI6YjhCN6ILAgTiBsIJIhCCH2IdQhKiZAJr4mnCZiJ/gnBickJ9okECTuJMwkMiWoJVYldCWKKoAqfipcKqIrOCvGK+QrGijQKC4oDCjyKWgplim0KUouIC7eLvwuAi+YL2YvRC+6LHAsjiysLFItyC02LRQt6jMAM/4z3DMiMrgyRjJkMpoxUDGuMYwxcjDoMBYwNDDKN6A3Xjd8N4I2GDbmNsQ2OjXwNQ41LDXSNEg0tjSUNGo7YDueO7w7QjrYOiY6BDr6OTA5zjnsORI4iDh2OFQ4qj/APz4/HD/iPng+hj6kPlo9kD1uPUw9sjwoPNY89DwKAAAE4EjgjADQ4RQBWAGc4eDiJAJoAqzi8AM043jjvAPA5EQECATM5JAFVOUY5dwFoAZk5ijm7Aaw53QHOAf854DohAjICAzoUAmU6djpHAlgCqTq6OosCnDrtAv4CzzrQAzE7IjsTAwQ7dQNmA1c7SDu5A6oDmzuMA/077jvfA8A8QQRSBGM8dAQFPBY8JwQ4BMk82jzrBPw8jQSeBK88sAVRPUI9cwVkPRUFBgU3PSg92QXKBfs97AWdPY49vwWgBmE+cj5DBlQ+JQY2Bgc+GD7pBvoGyz7cBq0+vj6PBpA/cQdiB1M/RAc1PyY/FwcIB/k/6j/bB8w/vQeuB58/gDCBCJIIozC0CMUw1jDnCPgICTAaMCsIPDBNCF4IbzBwCZExgjGzCaQx1QnGCfcx6DEZCQoJOzEsCV0xTjF/CWAKoTKyMoMKlDLlCvYKxzLYMikKOgoLMhwKbTJ+Mk8KUDOxC6ILkzOEC/Uz5jPXC8gLOTMqMxsLDDN9C24LXzNADME00jTjDPQ0hQyWDKc0uDRJDFoMazR8DA00HjQvDDA10Q3CDfM15A2VNYY1tw2oDVk1SjV7DWw1HQ0ODT81IDbhDvIOwzbUDqU2tjaHDpgOaTZ6NksOXDYtDj4ODzYQD/E34jfTD8Q3tQ+mD5c3iDd5D2oPWzdMDz03LjcfDwAAAGEAwgCjAYQB5QFGAScDCANpA8oDqwKMAu0CTgIvBlgGOQaaBvsH3Ae9Bx4HfwVQBTEFkgXzBNQEtQQWBHcM+AyZDDoMWw18DR0Nvg3fD/APkQ8yD1MOdA4VDrYO1wqgCsEKYgoDCyQLRQvmC4cJqAnJCWoJCwgsCE0I7giPCbgZ2Rl6GRsYPBhdGP4YnxqwGtEachoTGzQbVRv2G5cf4B+BHyIfQx5kHgUeph7HHOgciRwqHEsdbB0NHa4dzxVAFSEVghXjFMQUpRQGFGcWSBYpFooW6xfMF60XDhdvExgTeRPaE7sSnBL9El4SPxAQEHEQ0hCzEZQR9RFWETcTODNZM/ozmzK8Mt0yfjIfMDAwUTDyMJMxtDHVMXYxFzVgNQE1ojXDNOQ0hTQmNEc2aDYJNqo2yzfsN403LjdPP8A/oT8CP2M+RD4lPoY+5zzIPKk8CjxrPUw9LT2OPe85mDn5OVo5OzgcOH043ji/OpA68TpSOjM7FDt1O9Y7tzqAKuEqQiojKwQrZSvGK6cpiCnpKUopKygMKG0oziivLNgsuSwaLHstXC09LZ4t/y/QL7EvEi9zLlQuNS6WLvcmeCYZJrom2yf8J50nPidfJXAlESWyJdMk9CSVJDYkVyAgIEEg4iCDIaQhxSFmIQcjKCNJI+ojiyKsIs0ibiIPJpbmZpbml0eQBiYXJ0bGV0dABjdWUgc2hlZXQgdHJhY2sgbXVzdCBoYXZlIGF0IGxlYXN0IG9uZSBpbmRleCBwb2ludABjb25uZXMAQ0QtREEgY3VlIHNoZWV0IHRyYWNrIGluZGV4IG9mZnNldCBtdXN0IGJlIGV2ZW5seSBkaXZpc2libGUgYnkgNTg4IHNhbXBsZXMAQ0QtREEgY3VlIHNoZWV0IGxlYWQtb3V0IG9mZnNldCBtdXN0IGJlIGV2ZW5seSBkaXZpc2libGUgYnkgNTg4IHNhbXBsZXMAQ0QtREEgY3VlIHNoZWV0IHRyYWNrIG9mZnNldCBtdXN0IGJlIGV2ZW5seSBkaXZpc2libGUgYnkgNTg4IHNhbXBsZXMAQ0QtREEgY3VlIHNoZWV0IGxlYWQtaW4gbGVuZ3RoIG11c3QgYmUgZXZlbmx5IGRpdmlzaWJsZSBieSA1ODggc2FtcGxlcwBDRC1EQSBjdWUgc2hlZXQgbXVzdCBoYXZlIGEgbGVhZC1pbiBsZW5ndGggb2YgYXQgbGVhc3QgMiBzZWNvbmRzAGZsYXR0b3AAYmFydGxldHRfaGFubgBuYW4AYmxhY2ttYW4AbnV0dGFsbABrYWlzZXJfYmVzc2VsAHdlbGNoAGltYWdlL3BuZwBoYW1taW5nAHJlY3RhbmdsZQB0cmlhbmdsZQBibGFja21hbl9oYXJyaXNfNHRlcm1fOTJkYgBGTEFDAC0tPgBkZXNjcmlwdGlvbiBzdHJpbmcgbXVzdCBiZSB2YWxpZCBVVEYtOAByZWZlcmVuY2UgbGliRkxBQyAxLjMuMyAyMDE5MDgwNABjdWUgc2hlZXQgdHJhY2sgaW5kZXggbnVtYmVycyBtdXN0IGluY3JlYXNlIGJ5IDEAY3VlIHNoZWV0IHRyYWNrJ3MgZmlyc3QgaW5kZXggbnVtYmVyIG11c3QgYmUgMCBvciAxAENELURBIGN1ZSBzaGVldCB0cmFjayBudW1iZXIgbXVzdCBiZSAxLTk5IG9yIDE3MABjdWUgc2hlZXQgbWF5IG5vdCBoYXZlIGEgdHJhY2sgbnVtYmVyIDAAY3VlIHNoZWV0IG11c3QgaGF2ZSBhdCBsZWFzdCBvbmUgdHJhY2sgKHRoZSBsZWFkLW91dCkATUlNRSB0eXBlIHN0cmluZyBtdXN0IGNvbnRhaW4gb25seSBwcmludGFibGUgQVNDSUkgY2hhcmFjdGVycyAoMHgyMC0weDdlKQBDRC1EQSBjdWUgc2hlZXQgbXVzdCBoYXZlIGEgbGVhZC1vdXQgdHJhY2sgbnVtYmVyIDE3MCAoMHhBQSkAdHVrZXkoNWUtMSk7cGFydGlhbF90dWtleSgyKTtwdW5jaG91dF90dWtleSgzKQB0dWtleSg1ZS0xKTtwYXJ0aWFsX3R1a2V5KDIpAHR1a2V5KDVlLTEpAHB1bmNob3V0X3R1a2V5KABwYXJ0aWFsX3R1a2V5KABnYXVzcygAZkxhQwAAAENhTGYgAAAAEAAAABAAAAAYAAAAGAAAABQAAAADAAAABQAAACQAAAAgAAAAQAAAAEAAAAAQAAAAQAAAAAgAAAAYAAAAQAAAAAgAAABgAAAAAQAAAAEAAABuAAAACAAAAAAEAABAAAAAAQAAABcIAAAIAAAAIAAAACAAAAAgAAAAIAAAACAAAAAgAAAAIAAAACAAAAABAAAABwAAABgAAAD+PwAADgAAAAEAAAABAAAABAAAAAQAAAAEAAAAAwAAAAEAAAAIAAAAEAAAAAIAAAAEAAAABAAAAAUAAAAFAAAADwAAAB8AAAAEAAAABQAAAAEAAAAGAAAAAQAAAAAAAAACAAAAEAAAAEAAAAAAAAAAAAAAAAAAAAC3HcEEbjuCCdkmQw3cdgQTa2vFF7JNhhoFUEceuO0IJg/wySLW1oovYctLK2SbDDXThs0xCqCOPL29Tzhw2xFMx8bQSB7gk0Wp/VJBrK0VXxuw1FvClpdWdYtWUsg2GWp/K9hupg2bYxEQWmcUQB15o13cfXp7n3DNZl504LYjmFer4pyOjaGROZBglTzAJ4uL3eaPUvulguXmZIZYWyu+70bqujZgqbeBfWizhC0vrTMw7qnqFq2kXQtsoJBtMtQncPPQ/law3UlLcdlMGzbH+wb3wyIgtM6VPXXKKIA68p+d+/ZGu7j78aZ5//T2PuFD6//lms286C3Qfex3cIY0wG1HMBlLBD2uVsU5qwaCJxwbQyPFPQAuciDBKs+djhJ4gE8WoaYMGxa7zR8T64oBpPZLBX3QCAjKzckMB6uXeLC2VnxpkBVx3o3Uddvdk2tswFJvteYRYgL70Ga/Rp9eCFteWtF9HVdmYNxTYzCbTdQtWkkNCxlEuhbYQJfGpawg22So+f0npU7g5qFLsKG//K1guyWLI7aSluKyLyutipg2bI5BEC+D9g3uh/NdqZlEQGidnWYrkCp76pTnHbTgUAB15IkmNuk+O/ftO2uw84x2cfdVUDL64k3z/l/wvMbo7X3CMcs+z4bW/8uDhrjVNJt50e29OtxaoPvY7uAMaVn9zW2A245gN8ZPZDKWCHqFi8l+XK2Kc+uwS3dWDQRP4RDFSzg2hkaPK0dCinsAXD1mwVjkQIJVU11DUZ47HSUpJtwh8ACfLEcdXihCTRk29VDYMix2mz+ba1o7JtYVA5HL1AdI7ZcK//BWDvqgERBNvdAUlJuTGSOGUh0OVi/xuUvu9WBtrfjXcGz80iAr4mU96ua8G6nrCwZo77a7J9cBpubT2ICl3m+dZNpqzSPE3dDiwAT2oc2z62DJfo0+vcmQ/7kQtry0p6t9sKL7Oq4V5vuqzMC4p3vdeaPGYDabcX33n6hbtJIfRnWWGhYyiK0L84x0LbCBwzBxhZmQil0ujUtZ96sIVEC2yVBF5o5O8vtPSivdDEecwM1DIX2Ce5ZgQ39PRgBy+FvBdv0LhmhKFkdskzAEYSQtxWXpS5sRXlZaFYdwGRgwbdgcNT2fAoIgXgZbBh0L7BvcD1Gmkzfmu1IzP50RPoiA0DqN0JckOs1WIOPrFS1U9tQpeSapxc47aMEXHSvMoADqyKVQrdYSTWzSy2sv33x27tvBy6HjdtZg56/wI+oY7eLuHb2l8KqgZPRzhif5xJvm/Qn9uIm+4HmNZ8Y6gNDb+4TVi7yaYpZ9nruwPpMMrf+XsRCwrwYNcavfKzKmaDbzom1mtLzae3W4A102tbRA97F/AAAAEAAAAHAqAABJRDMAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAAABQAAAAArAAABAAAAAgAAAAQAAAAFAAAABgAAAAAAAAAAAAAAAAAAANF0ngBXnb0qgHBSD///PicKAAAAZAAAAOgDAAAQJwAAoIYBAEBCDwCAlpgAAOH1BRgAAAA1AAAAcQAAAGv////O+///kr///wAAAAAAAAAAAwAAAAQAAAAEAAAABgAAAIP5ogBETm4A/CkVANFXJwDdNPUAYtvAADyZlQBBkEMAY1H+ALveqwC3YcUAOm4kANJNQgBJBuAACeouAByS0QDrHf4AKbEcAOg+pwD1NYIARLsuAJzphAC0JnAAQX5fANaROQBTgzkAnPQ5AItfhAAo+b0A+B87AN7/lwAPmAUAES/vAApaiwBtH20Az342AAnLJwBGT7cAnmY/AC3qXwC6J3UA5evHAD178QD3OQcAklKKAPtr6gAfsV8ACF2NADADVgB7/EYA8KtrACC8zwA29JoA46kdAF5hkQAIG+YAhZllAKAUXwCNQGgAgNj/ACdzTQAGBjEAylYVAMmocwB74mAAa4zAABnERwDNZ8MACejcAFmDKgCLdsQAphyWAESv3QAZV9EApT4FAAUH/wAzfj8AwjLoAJhP3gC7fTIAJj3DAB5r7wCf+F4ANR86AH/yygDxhx0AfJAhAGokfADVbvoAMC13ABU7QwC1FMYAwxmdAK3EwgAsTUEADABdAIZ9RgDjcS0Am8aaADNiAAC00nwAtKeXADdV1QDXPvYAoxAYAE12/ABknSoAcNerAGN8+AB6sFcAFxXnAMBJVgA71tkAp4Q4ACQjywDWincAWlQjAAAfuQDxChsAGc7fAJ8x/wBmHmoAmVdhAKz7RwB+f9gAImW3ADLoiQDmv2AA78TNAGw2CQBdP9QAFt7XAFg73gDem5IA0iIoACiG6ADiWE0AxsoyAAjjFgDgfcsAF8BQAPMdpwAY4FsALhM0AIMSYgCDSAEA9Y5bAK2wfwAe6fIASEpDABBn0wCq3dgArl9CAGphzgAKKKQA05m0AAam8gBcd38Ao8KDAGE8iACKc3gAr4xaAG/XvQAtpmMA9L/LAI2B7wAmwWcAVcpFAMrZNgAoqNIAwmGNABLJdwAEJhQAEkabAMRZxADIxUQATbKRAAAX8wDUQ60AKUnlAP3VEAAAvvwAHpTMAHDO7gATPvUA7PGAALPnwwDH+CgAkwWUAMFxPgAuCbMAC0XzAIgSnACrIHsALrWfAEeSwgB7Mi8ADFVtAHKnkABr5x8AMcuWAHkWSgBBeeIA9N+JAOiUlwDi5oQAmTGXAIjtawBfXzYAu/0OAEiatABnpGwAcXJCAI1dMgCfFbgAvOUJAI0xJQD3dDkAMAUcAA0MAQBLCGgALO5YAEeqkAB05wIAvdYkAPd9pgBuSHIAnxbvAI6UpgC0kfYA0VNRAM8K8gAgmDMA9Ut+ALJjaADdPl8AQF0DAIWJfwBVUikAN2TAAG3YEAAySDIAW0x1AE5x1ABFVG4ACwnBACr1aQAUZtUAJwedAF0EUAC0O9sA6nbFAIf5FwBJa30AHSe6AJZpKQDGzKwArRRUAJDiagCI2YkALHJQAASkvgB3B5QA8zBwAAD8JwDqcagAZsJJAGTgPQCX3YMAoz+XAEOU/QANhowAMUHeAJI5nQDdcIwAF7fnAAjfOwAVNysAXICgAFqAkwAQEZIAD+jYAGyArwDb/0sAOJAPAFkYdgBipRUAYcu7AMeJuQAQQL0A0vIEAEl1JwDrtvYA2yK7AAoUqgCJJi8AZIN2AAk7MwAOlBoAUTqqAB2jwgCv7a4AXCYSAG3CTQAtepwAwFaXAAM/gwAJ8PYAK0CMAG0xmQA5tAcADCAVANjDWwD1ksQAxq1LAE7KpQCnN80A5qk2AKuSlADdQmgAGWPeAHaM7wBoi1IA/Ns3AK6hqwDfFTEAAK6hAAz72gBkTWYA7QW3ACllMABXVr8AR/86AGr5uQB1vvMAKJPfAKuAMABmjPYABMsVAPoiBgDZ5B0APbOkAFcbjwA2zQkATkLpABO+pAAzI7UA8KoaAE9lqADSwaUACz8PAFt4zQAj+XYAe4sEAIkXcgDGplMAb27iAO/rAACbSlgAxNq3AKpmugB2z88A0QIdALHxLQCMmcEAw613AIZI2gD3XaAAxoD0AKzwLwDd7JoAP1y8ANDebQCQxx8AKtu2AKMlOgAAr5oArVOTALZXBAApLbQAS4B+ANoHpwB2qg4Ae1mhABYSKgDcty0A+uX9AInb/gCJvv0A5HZsAAap/AA+gHAAhW4VAP2H/wAoPgcAYWczACoYhgBNveoAs+evAI9tbgCVZzkAMb9bAITXSAAw3xYAxy1DACVhNQDJcM4AMMu4AL9s/QCkAKIABWzkAFrdoAAhb0cAYhLSALlchABwYUkAa1bgAJlSAQBQVTcAHtW3ADPxxAATbl8AXTDkAIUuqQAdssMAoTI2AAi3pADqsdQAFvchAI9p5AAn/3cADAOAAI1ALQBPzaAAIKWZALOi0wAvXQoAtPlCABHaywB9vtAAm9vBAKsXvQDKooEACGpcAC5VFwAnAFUAfxTwAOEHhgAUC2QAlkGNAIe+3gDa/SoAayW2AHuJNAAF8/4Aub+eAGhqTwBKKqgAT8RaAC34vADXWpgA9MeVAA1NjQAgOqYApFdfABQ/sQCAOJUAzCABAHHdhgDJ3rYAv2D1AE1lEQABB2sAjLCsALLA0ABRVUgAHvsOAJVywwCjBjsAwEA1AAbcewDgRcwATin6ANbKyADo80EAfGTeAJtk2ADZvjEApJfDAHdY1ABp48UA8NoTALo6PABGGEYAVXVfANK99QBuksYArC5dAA5E7QAcPkIAYcSHACn96QDn1vMAInzKAG+RNQAI4MUA/9eNAG5q4gCw/cYAkwjBAHxddABrrbIAzW6dAD5yewDGEWoA98+pAClz3wC1yboAtwBRAOKyDQB0uiQA5X1gAHTYigANFSwAgRgMAH5mlAABKRYAn3p2AP39vgBWRe8A2X42AOzZEwCLurkAxJf8ADGoJwDxbsMAlMU2ANioVgC0qLUAz8wOABKJLQBvVzQALFaJAJnO4wDWILkAa16qAD4qnAARX8wA/QtKAOH0+wCOO20A4oYsAOnUhAD8tKkA7+7RAC41yQAvOWEAOCFEABvZyACB/AoA+0pqAC8c2ABTtIQATpmMAFQizAAqVdwAwMbWAAsZlgAacLgAaZVkACZaYAA/Uu4AfxEPAPS1EQD8y/UANLwtADS87gDoXcwA3V5gAGeOmwCSM+8AyRe4AGFYmwDhV7wAUYPGANg+EADdcUgALRzdAK8YoQAhLEYAWfPXANl6mACeVMAAT4b6AFYG/ADlea4AiSI2ADitIgBnk9wAVeiqAIImOADK55sAUQ2kAJkzsQCp1w4AaQVIAGWy8AB/iKcAiEyXAPnRNgAhkrMAe4JKAJjPIQBAn9wA3EdVAOF0OgBn60IA/p3fAF7UXwB7Z6QAuqx6AFX2ogAriCMAQbpVAFluCAAhKoYAOUeDAInj5gDlntQASftAAP9W6QAcD8oAxVmKAJT6KwDTwcUAD8XPANtargBHxYYAhUNiACGGOwAseZQAEGGHACpMewCALBoAQ78SAIgmkAB4PIkAqMTkAOXbewDEOsIAJvTqAPdnigANkr8AZaMrAD2TsQC9fAsApFHcACfdYwBp4d0AmpQZAKgplQBozigACe20AESfIABOmMoAcIJjAH58IwAPuTIAp/WOABRW5wAh8QgAtZ0qAG9+TQClGVEAtfmrAILf1gCW3WEAFjYCAMQ6nwCDoqEAcu1tADmNegCCuKkAazJcAEYnWwAANO0A0gB3APz0VQABWU0A4HGAAAAAAAAAAAAAAAAAQPsh+T8AAAAALUR0PgAAAICYRvg8AAAAYFHMeDsAAACAgxvwOQAAAEAgJXo4AAAAgCKC4zYAAAAAHfNpNQAAAAAAAOA/AAAAAAAA4L8=");
  base64DecodeToExistingUint8Array(bufferView, 10848, "UDdQAFsXAAArFwAAAAAAAAkAAAAAAAAAAAAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAAAAAAEAAAAOC8AAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD/////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoAAAALAAAASDMAAAAEAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAr/////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAArAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAQxkAAAEAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAAAAABDGQAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAEMZAAAAAAAAAAAAAAYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAQxkAAAEAAAABAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAAAAAAAABDGQAAAQAAAAAAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAEMZAAABAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAYAAAAAAAAAJhkAAAEAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABgAAAAAAAAAmGQAAAQAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGAAAAAAAAAPcYAAA=");
  base64DecodeToExistingUint8Array(bufferView, 11568, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==");
}

  var scratchBuffer = new ArrayBuffer(16);
  var i32ScratchView = new Int32Array(scratchBuffer);
  var f32ScratchView = new Float32Array(scratchBuffer);
  var f64ScratchView = new Float64Array(scratchBuffer);
  
  function wasm2js_scratch_load_i32(index) {
    return i32ScratchView[index];
  }
      
  function wasm2js_scratch_store_i32(index, value) {
    i32ScratchView[index] = value;
  }
      
  function wasm2js_scratch_load_f64() {
    return f64ScratchView[0];
  }
      
  function wasm2js_scratch_store_f64(value) {
    f64ScratchView[0] = value;
  }
      
  function wasm2js_scratch_store_f32(value) {
    f32ScratchView[2] = value;
  }
      
function asmFunc(env) {
 var memory = env.memory;
 var buffer = memory.buffer;
 memory.grow = __wasm_memory_grow;
 var HEAP8 = new Int8Array(buffer);
 var HEAP16 = new Int16Array(buffer);
 var HEAP32 = new Int32Array(buffer);
 var HEAPU8 = new Uint8Array(buffer);
 var HEAPU16 = new Uint16Array(buffer);
 var HEAPU32 = new Uint32Array(buffer);
 var HEAPF32 = new Float32Array(buffer);
 var HEAPF64 = new Float64Array(buffer);
 var Math_imul = Math.imul;
 var Math_fround = Math.fround;
 var Math_abs = Math.abs;
 var Math_clz32 = Math.clz32;
 var Math_min = Math.min;
 var Math_max = Math.max;
 var Math_floor = Math.floor;
 var Math_ceil = Math.ceil;
 var Math_trunc = Math.trunc;
 var Math_sqrt = Math.sqrt;
 var abort = env.abort;
 var nan = NaN;
 var infinity = Infinity;
 var emscripten_resize_heap = env.emscripten_resize_heap;
 var emscripten_memcpy_big = env.emscripten_memcpy_big;
 var __wasi_fd_close = env.fd_close;
 var __wasi_fd_read = env.fd_read;
 var __wasi_fd_write = env.fd_write;
 var setTempRet0 = env.setTempRet0;
 var legalimport$__wasi_fd_seek = env.fd_seek;
 var __stack_pointer = 5257040;
 var __stack_end = 0;
 var __stack_base = 0;
 var GOT_data_internal___memory_base = 0;
 var GOT_data_internal_FLAC__crc16_table = 1280;
 var GOT_data_internal___table_base = 1;
 var GOT_data_internal_FLAC__OGG_MAPPING_MAGIC = 10856;
 var GOT_data_internal_FLAC__OGG_MAPPING_FIRST_HEADER_PACKET_TYPE = 7824;
 var GOT_data_internal_FLAC__SUBFRAME_LPC_QLP_SHIFT_LEN = 6760;
 var GOT_data_internal_FLAC__STREAM_METADATA_APPLICATION_ID_LEN = 6564;
 var GOT_data_internal_stdin = 7832;
 var GOT_func_internal_FLAC__lpc_restore_signal = 5;
 var GOT_func_internal_FLAC__lpc_restore_signal_wide = 6;
 var GOT_data_internal_FLAC__STREAM_SYNC_STRING = 6517;
 var GOT_data_internal_FLAC__STREAM_METADATA_IS_LAST_LEN = 6672;
 var GOT_data_internal_FLAC__STREAM_METADATA_TYPE_LEN = 6676;
 var GOT_data_internal_FLAC__STREAM_METADATA_LENGTH_LEN = 6680;
 var GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MIN_BLOCK_SIZE_LEN = 6532;
 var GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MAX_BLOCK_SIZE_LEN = 6536;
 var GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MIN_FRAME_SIZE_LEN = 6540;
 var GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MAX_FRAME_SIZE_LEN = 6544;
 var GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_SAMPLE_RATE_LEN = 6548;
 var GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_CHANNELS_LEN = 6552;
 var GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_BITS_PER_SAMPLE_LEN = 6556;
 var GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_TOTAL_SAMPLES_LEN = 6560;
 var GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_FRAME_SAMPLES_LEN = 6576;
 var GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_STREAM_OFFSET_LEN = 6572;
 var GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_SAMPLE_NUMBER_LEN = 6568;
 var GOT_data_internal_FLAC__SUBFRAME_LPC_QLP_COEFF_PRECISION_LEN = 6756;
 var GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ORDER_LEN = 6732;
 var GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_TYPE_LEN = 6728;
 var GOT_data_internal_FLAC__FRAME_FOOTER_CRC_LEN = 6724;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_MEDIA_CATALOG_NUMBER_LEN = 6620;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_LEAD_IN_LEN = 6624;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_IS_CD_LEN = 6628;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_RESERVED_LEN = 6632;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_NUM_TRACKS_LEN = 6636;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_ISRC_LEN = 6600;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_RESERVED_LEN = 6588;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_NUMBER_LEN = 6584;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_OFFSET_LEN = 6580;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_NUM_INDICES_LEN = 6616;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_RESERVED_LEN = 6612;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_PRE_EMPHASIS_LEN = 6608;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_TYPE_LEN = 6604;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_NUMBER_LEN = 6596;
 var GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_OFFSET_LEN = 6592;
 var GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_TYPE_LEN = 6640;
 var GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_MIME_TYPE_LENGTH_LEN = 6644;
 var GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DESCRIPTION_LENGTH_LEN = 6648;
 var GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_WIDTH_LEN = 6652;
 var GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_HEIGHT_LEN = 6656;
 var GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DEPTH_LEN = 6660;
 var GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_COLORS_LEN = 6664;
 var GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DATA_LENGTH_LEN = 6668;
 var GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ESCAPE_PARAMETER = 6748;
 var GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2_ESCAPE_PARAMETER = 6752;
 var GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_PARAMETER_LEN = 6736;
 var GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2_PARAMETER_LEN = 6740;
 var GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_RAW_LEN = 6744;
 var GOT_data_internal_FLAC__OGG_MAPPING_NUM_HEADERS_LEN = 7828;
 var GOT_data_internal_FLAC__VENDOR_STRING = 10852;
 var GOT_data_internal_FLAC__FRAME_HEADER_SYNC_LEN = 6688;
 var GOT_data_internal_FLAC__FRAME_HEADER_SYNC = 6684;
 var GOT_data_internal_FLAC__FRAME_HEADER_RESERVED_LEN = 6692;
 var GOT_data_internal_FLAC__FRAME_HEADER_BLOCKING_STRATEGY_LEN = 6696;
 var GOT_data_internal_FLAC__FRAME_HEADER_BLOCK_SIZE_LEN = 6700;
 var GOT_data_internal_FLAC__FRAME_HEADER_SAMPLE_RATE_LEN = 6704;
 var GOT_data_internal_FLAC__FRAME_HEADER_CHANNEL_ASSIGNMENT_LEN = 6708;
 var GOT_data_internal_FLAC__FRAME_HEADER_BITS_PER_SAMPLE_LEN = 6712;
 var GOT_data_internal_FLAC__FRAME_HEADER_ZERO_PAD_LEN = 6716;
 var GOT_data_internal_FLAC__FRAME_HEADER_CRC_LEN = 6720;
 var GOT_data_internal_FLAC__SUBFRAME_TYPE_CONSTANT_BYTE_ALIGNED_MASK = 6776;
 var GOT_data_internal_FLAC__SUBFRAME_ZERO_PAD_LEN = 6764;
 var GOT_data_internal_FLAC__SUBFRAME_TYPE_LEN = 6768;
 var GOT_data_internal_FLAC__SUBFRAME_WASTED_BITS_FLAG_LEN = 6772;
 var GOT_data_internal_FLAC__SUBFRAME_TYPE_FIXED_BYTE_ALIGNED_MASK = 6784;
 var GOT_data_internal_FLAC__SUBFRAME_TYPE_LPC_BYTE_ALIGNED_MASK = 6788;
 var GOT_data_internal_FLAC__SUBFRAME_TYPE_VERBATIM_BYTE_ALIGNED_MASK = 6780;
 var GOT_data_internal_stdout = 7868;
 var GOT_func_internal_FLAC__lpc_compute_residual_from_qlp_coefficients = 12;
 var GOT_func_internal_FLAC__lpc_compute_residual_from_qlp_coefficients_wide = 13;
 var GOT_func_internal_FLAC__fixed_compute_best_predictor_wide = 14;
 var GOT_func_internal_FLAC__fixed_compute_best_predictor = 15;
 var GOT_func_internal_FLAC__lpc_compute_autocorrelation = 17;
 var GOT_data_internal_FLAC__STREAM_SYNC_LEN = 6528;
 var GOT_data_internal_FLAC__STREAM_SYNC = 6524;
 var __wasm_intrinsics_temp_i64 = 0;
 var __wasm_intrinsics_temp_i64$hi = 0;
 var i64toi32_i32$HIGH_BITS = 0;
 // EMSCRIPTEN_START_FUNCS
;
 function __wasm_call_ctors() {
  emscripten_stack_init();
 }
 
 function emscripten_stack_init() {
  __stack_base = 5257040;
  __stack_end = (14152 + 15 | 0) & -16 | 0;
 }
 
 function emscripten_stack_get_free() {
  return __stack_pointer - __stack_end | 0 | 0;
 }
 
 function emscripten_stack_get_end() {
  return __stack_end | 0;
 }
 
 function emscripten_get_heap_size() {
  return __wasm_memory_size() << 16 | 0 | 0;
 }
 
 function __errno_location() {
  return 11568 | 0;
 }
 
 function sbrk($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $1 = HEAP32[(0 + 10848 | 0) >> 2] | 0;
  $2 = ($0 + 3 | 0) & -4 | 0;
  $0 = $1 + $2 | 0;
  label$1 : {
   label$2 : {
    if (!$2) {
     break label$2
    }
    if ($0 >>> 0 <= $1 >>> 0) {
     break label$1
    }
   }
   label$3 : {
    if ($0 >>> 0 <= (emscripten_get_heap_size() | 0) >>> 0) {
     break label$3
    }
    if (!(emscripten_resize_heap($0 | 0) | 0)) {
     break label$1
    }
   }
   HEAP32[(0 + 10848 | 0) >> 2] = $0;
   return $1 | 0;
  }
  (wasm2js_i32$0 = __errno_location() | 0, wasm2js_i32$1 = 48), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
  return -1 | 0;
 }
 
 function memset($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, i64toi32_i32$0 = 0, $4 = 0, i64toi32_i32$1 = 0, $6 = 0, $5 = 0, $6$hi = 0;
  label$1 : {
   if (!$2) {
    break label$1
   }
   $3 = $2 + $0 | 0;
   HEAP8[($3 + -1 | 0) >> 0] = $1;
   HEAP8[$0 >> 0] = $1;
   if ($2 >>> 0 < 3 >>> 0) {
    break label$1
   }
   HEAP8[($3 + -2 | 0) >> 0] = $1;
   HEAP8[($0 + 1 | 0) >> 0] = $1;
   HEAP8[($3 + -3 | 0) >> 0] = $1;
   HEAP8[($0 + 2 | 0) >> 0] = $1;
   if ($2 >>> 0 < 7 >>> 0) {
    break label$1
   }
   HEAP8[($3 + -4 | 0) >> 0] = $1;
   HEAP8[($0 + 3 | 0) >> 0] = $1;
   if ($2 >>> 0 < 9 >>> 0) {
    break label$1
   }
   $4 = (0 - $0 | 0) & 3 | 0;
   $3 = $0 + $4 | 0;
   $1 = Math_imul($1 & 255 | 0, 16843009);
   HEAP32[$3 >> 2] = $1;
   $4 = ($2 - $4 | 0) & -4 | 0;
   $2 = $3 + $4 | 0;
   HEAP32[($2 + -4 | 0) >> 2] = $1;
   if ($4 >>> 0 < 9 >>> 0) {
    break label$1
   }
   HEAP32[($3 + 8 | 0) >> 2] = $1;
   HEAP32[($3 + 4 | 0) >> 2] = $1;
   HEAP32[($2 + -8 | 0) >> 2] = $1;
   HEAP32[($2 + -12 | 0) >> 2] = $1;
   if ($4 >>> 0 < 25 >>> 0) {
    break label$1
   }
   HEAP32[($3 + 24 | 0) >> 2] = $1;
   HEAP32[($3 + 20 | 0) >> 2] = $1;
   HEAP32[($3 + 16 | 0) >> 2] = $1;
   HEAP32[($3 + 12 | 0) >> 2] = $1;
   HEAP32[($2 + -16 | 0) >> 2] = $1;
   HEAP32[($2 + -20 | 0) >> 2] = $1;
   HEAP32[($2 + -24 | 0) >> 2] = $1;
   HEAP32[($2 + -28 | 0) >> 2] = $1;
   $5 = $3 & 4 | 0 | 24 | 0;
   $2 = $4 - $5 | 0;
   if ($2 >>> 0 < 32 >>> 0) {
    break label$1
   }
   i64toi32_i32$0 = 0;
   i64toi32_i32$1 = 1;
   i64toi32_i32$1 = __wasm_i64_mul($1 | 0, i64toi32_i32$0 | 0, 1 | 0, i64toi32_i32$1 | 0) | 0;
   i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
   $6 = i64toi32_i32$1;
   $6$hi = i64toi32_i32$0;
   $1 = $3 + $5 | 0;
   label$2 : while (1) {
    i64toi32_i32$0 = $6$hi;
    i64toi32_i32$1 = $1;
    HEAP32[($1 + 24 | 0) >> 2] = $6;
    HEAP32[($1 + 28 | 0) >> 2] = i64toi32_i32$0;
    i64toi32_i32$1 = $1;
    HEAP32[($1 + 16 | 0) >> 2] = $6;
    HEAP32[($1 + 20 | 0) >> 2] = i64toi32_i32$0;
    i64toi32_i32$1 = $1;
    HEAP32[($1 + 8 | 0) >> 2] = $6;
    HEAP32[($1 + 12 | 0) >> 2] = i64toi32_i32$0;
    i64toi32_i32$1 = $1;
    HEAP32[$1 >> 2] = $6;
    HEAP32[($1 + 4 | 0) >> 2] = i64toi32_i32$0;
    $1 = $1 + 32 | 0;
    $2 = $2 + -32 | 0;
    if ($2 >>> 0 > 31 >>> 0) {
     continue label$2
    }
    break label$2;
   };
  }
  return $0 | 0;
 }
 
 function __memcpy($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $4 = 0, $3 = 0, $5 = 0;
  label$1 : {
   if ($2 >>> 0 < 512 >>> 0) {
    break label$1
   }
   emscripten_memcpy_big($0 | 0, $1 | 0, $2 | 0) | 0;
   return $0 | 0;
  }
  $3 = $0 + $2 | 0;
  label$2 : {
   label$3 : {
    if (($1 ^ $0 | 0) & 3 | 0) {
     break label$3
    }
    label$4 : {
     label$5 : {
      if ($0 & 3 | 0) {
       break label$5
      }
      $2 = $0;
      break label$4;
     }
     label$6 : {
      if (($2 | 0) >= (1 | 0)) {
       break label$6
      }
      $2 = $0;
      break label$4;
     }
     $2 = $0;
     label$7 : while (1) {
      HEAP8[$2 >> 0] = HEAPU8[$1 >> 0] | 0;
      $1 = $1 + 1 | 0;
      $2 = $2 + 1 | 0;
      if (!($2 & 3 | 0)) {
       break label$4
      }
      if ($2 >>> 0 < $3 >>> 0) {
       continue label$7
      }
      break label$7;
     };
    }
    label$8 : {
     $4 = $3 & -4 | 0;
     if ($4 >>> 0 < 64 >>> 0) {
      break label$8
     }
     $5 = $4 + -64 | 0;
     if ($2 >>> 0 > $5 >>> 0) {
      break label$8
     }
     label$9 : while (1) {
      HEAP32[$2 >> 2] = HEAP32[$1 >> 2] | 0;
      HEAP32[($2 + 4 | 0) >> 2] = HEAP32[($1 + 4 | 0) >> 2] | 0;
      HEAP32[($2 + 8 | 0) >> 2] = HEAP32[($1 + 8 | 0) >> 2] | 0;
      HEAP32[($2 + 12 | 0) >> 2] = HEAP32[($1 + 12 | 0) >> 2] | 0;
      HEAP32[($2 + 16 | 0) >> 2] = HEAP32[($1 + 16 | 0) >> 2] | 0;
      HEAP32[($2 + 20 | 0) >> 2] = HEAP32[($1 + 20 | 0) >> 2] | 0;
      HEAP32[($2 + 24 | 0) >> 2] = HEAP32[($1 + 24 | 0) >> 2] | 0;
      HEAP32[($2 + 28 | 0) >> 2] = HEAP32[($1 + 28 | 0) >> 2] | 0;
      HEAP32[($2 + 32 | 0) >> 2] = HEAP32[($1 + 32 | 0) >> 2] | 0;
      HEAP32[($2 + 36 | 0) >> 2] = HEAP32[($1 + 36 | 0) >> 2] | 0;
      HEAP32[($2 + 40 | 0) >> 2] = HEAP32[($1 + 40 | 0) >> 2] | 0;
      HEAP32[($2 + 44 | 0) >> 2] = HEAP32[($1 + 44 | 0) >> 2] | 0;
      HEAP32[($2 + 48 | 0) >> 2] = HEAP32[($1 + 48 | 0) >> 2] | 0;
      HEAP32[($2 + 52 | 0) >> 2] = HEAP32[($1 + 52 | 0) >> 2] | 0;
      HEAP32[($2 + 56 | 0) >> 2] = HEAP32[($1 + 56 | 0) >> 2] | 0;
      HEAP32[($2 + 60 | 0) >> 2] = HEAP32[($1 + 60 | 0) >> 2] | 0;
      $1 = $1 + 64 | 0;
      $2 = $2 + 64 | 0;
      if ($2 >>> 0 <= $5 >>> 0) {
       continue label$9
      }
      break label$9;
     };
    }
    if ($2 >>> 0 >= $4 >>> 0) {
     break label$2
    }
    label$10 : while (1) {
     HEAP32[$2 >> 2] = HEAP32[$1 >> 2] | 0;
     $1 = $1 + 4 | 0;
     $2 = $2 + 4 | 0;
     if ($2 >>> 0 < $4 >>> 0) {
      continue label$10
     }
     break label$2;
    };
   }
   label$11 : {
    if ($3 >>> 0 >= 4 >>> 0) {
     break label$11
    }
    $2 = $0;
    break label$2;
   }
   label$12 : {
    $4 = $3 + -4 | 0;
    if ($4 >>> 0 >= $0 >>> 0) {
     break label$12
    }
    $2 = $0;
    break label$2;
   }
   $2 = $0;
   label$13 : while (1) {
    HEAP8[$2 >> 0] = HEAPU8[$1 >> 0] | 0;
    HEAP8[($2 + 1 | 0) >> 0] = HEAPU8[($1 + 1 | 0) >> 0] | 0;
    HEAP8[($2 + 2 | 0) >> 0] = HEAPU8[($1 + 2 | 0) >> 0] | 0;
    HEAP8[($2 + 3 | 0) >> 0] = HEAPU8[($1 + 3 | 0) >> 0] | 0;
    $1 = $1 + 4 | 0;
    $2 = $2 + 4 | 0;
    if ($2 >>> 0 <= $4 >>> 0) {
     continue label$13
    }
    break label$13;
   };
  }
  label$14 : {
   if ($2 >>> 0 >= $3 >>> 0) {
    break label$14
   }
   label$15 : while (1) {
    HEAP8[$2 >> 0] = HEAPU8[$1 >> 0] | 0;
    $1 = $1 + 1 | 0;
    $2 = $2 + 1 | 0;
    if (($2 | 0) != ($3 | 0)) {
     continue label$15
    }
    break label$15;
   };
  }
  return $0 | 0;
 }
 
 function dlmalloc($0) {
  $0 = $0 | 0;
  var $4 = 0, $5 = 0, $6 = 0, $8 = 0, $3 = 0, $2 = 0, $11 = 0, $7 = 0, i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, $9 = 0, i64toi32_i32$2 = 0, $10 = 0, $1 = 0, $79 = 0, $92 = 0, $103 = 0, $111 = 0, $119 = 0, $210 = 0, $221 = 0, $229 = 0, $237 = 0, $272 = 0, $339 = 0, $346 = 0, $353 = 0, $444 = 0, $455 = 0, $463 = 0, $471 = 0, $1157 = 0, $1164 = 0, $1171 = 0, $1293 = 0, $1295 = 0, $1356 = 0, $1363 = 0, $1370 = 0, $1606 = 0, $1613 = 0, $1620 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       label$6 : {
        label$7 : {
         label$8 : {
          label$9 : {
           label$10 : {
            label$11 : {
             label$12 : {
              if ($0 >>> 0 > 244 >>> 0) {
               break label$12
              }
              label$13 : {
               $2 = HEAP32[(0 + 11572 | 0) >> 2] | 0;
               $3 = $0 >>> 0 < 11 >>> 0 ? 16 : ($0 + 11 | 0) & -8 | 0;
               $4 = $3 >>> 3 | 0;
               $0 = $2 >>> $4 | 0;
               if (!($0 & 3 | 0)) {
                break label$13
               }
               $5 = (($0 ^ -1 | 0) & 1 | 0) + $4 | 0;
               $6 = $5 << 3 | 0;
               $4 = HEAP32[($6 + 11620 | 0) >> 2] | 0;
               $0 = $4 + 8 | 0;
               label$14 : {
                label$15 : {
                 $3 = HEAP32[($4 + 8 | 0) >> 2] | 0;
                 $6 = $6 + 11612 | 0;
                 if (($3 | 0) != ($6 | 0)) {
                  break label$15
                 }
                 (wasm2js_i32$0 = 0, wasm2js_i32$1 = $2 & (__wasm_rotl_i32(-2 | 0, $5 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11572 | 0) >> 2] = wasm2js_i32$1;
                 break label$14;
                }
                HEAP32[($3 + 12 | 0) >> 2] = $6;
                HEAP32[($6 + 8 | 0) >> 2] = $3;
               }
               $5 = $5 << 3 | 0;
               HEAP32[($4 + 4 | 0) >> 2] = $5 | 3 | 0;
               $4 = $4 + $5 | 0;
               HEAP32[($4 + 4 | 0) >> 2] = HEAP32[($4 + 4 | 0) >> 2] | 0 | 1 | 0;
               break label$1;
              }
              $7 = HEAP32[(0 + 11580 | 0) >> 2] | 0;
              if ($3 >>> 0 <= $7 >>> 0) {
               break label$11
              }
              label$16 : {
               if (!$0) {
                break label$16
               }
               label$17 : {
                label$18 : {
                 $79 = $0 << $4 | 0;
                 $0 = 2 << $4 | 0;
                 $0 = $79 & ($0 | (0 - $0 | 0) | 0) | 0;
                 $0 = ($0 & (0 - $0 | 0) | 0) + -1 | 0;
                 $92 = $0;
                 $0 = ($0 >>> 12 | 0) & 16 | 0;
                 $4 = $92 >>> $0 | 0;
                 $5 = ($4 >>> 5 | 0) & 8 | 0;
                 $103 = $5 | $0 | 0;
                 $0 = $4 >>> $5 | 0;
                 $4 = ($0 >>> 2 | 0) & 4 | 0;
                 $111 = $103 | $4 | 0;
                 $0 = $0 >>> $4 | 0;
                 $4 = ($0 >>> 1 | 0) & 2 | 0;
                 $119 = $111 | $4 | 0;
                 $0 = $0 >>> $4 | 0;
                 $4 = ($0 >>> 1 | 0) & 1 | 0;
                 $5 = ($119 | $4 | 0) + ($0 >>> $4 | 0) | 0;
                 $6 = $5 << 3 | 0;
                 $4 = HEAP32[($6 + 11620 | 0) >> 2] | 0;
                 $0 = HEAP32[($4 + 8 | 0) >> 2] | 0;
                 $6 = $6 + 11612 | 0;
                 if (($0 | 0) != ($6 | 0)) {
                  break label$18
                 }
                 $2 = $2 & (__wasm_rotl_i32(-2 | 0, $5 | 0) | 0) | 0;
                 HEAP32[(0 + 11572 | 0) >> 2] = $2;
                 break label$17;
                }
                HEAP32[($0 + 12 | 0) >> 2] = $6;
                HEAP32[($6 + 8 | 0) >> 2] = $0;
               }
               $0 = $4 + 8 | 0;
               HEAP32[($4 + 4 | 0) >> 2] = $3 | 3 | 0;
               $6 = $4 + $3 | 0;
               $8 = $5 << 3 | 0;
               $5 = $8 - $3 | 0;
               HEAP32[($6 + 4 | 0) >> 2] = $5 | 1 | 0;
               HEAP32[($4 + $8 | 0) >> 2] = $5;
               label$19 : {
                if (!$7) {
                 break label$19
                }
                $8 = $7 >>> 3 | 0;
                $3 = ($8 << 3 | 0) + 11612 | 0;
                $4 = HEAP32[(0 + 11592 | 0) >> 2] | 0;
                label$20 : {
                 label$21 : {
                  $8 = 1 << $8 | 0;
                  if ($2 & $8 | 0) {
                   break label$21
                  }
                  HEAP32[(0 + 11572 | 0) >> 2] = $2 | $8 | 0;
                  $8 = $3;
                  break label$20;
                 }
                 $8 = HEAP32[($3 + 8 | 0) >> 2] | 0;
                }
                HEAP32[($3 + 8 | 0) >> 2] = $4;
                HEAP32[($8 + 12 | 0) >> 2] = $4;
                HEAP32[($4 + 12 | 0) >> 2] = $3;
                HEAP32[($4 + 8 | 0) >> 2] = $8;
               }
               HEAP32[(0 + 11592 | 0) >> 2] = $6;
               HEAP32[(0 + 11580 | 0) >> 2] = $5;
               break label$1;
              }
              $9 = HEAP32[(0 + 11576 | 0) >> 2] | 0;
              if (!$9) {
               break label$11
              }
              $0 = ($9 & (0 - $9 | 0) | 0) + -1 | 0;
              $210 = $0;
              $0 = ($0 >>> 12 | 0) & 16 | 0;
              $4 = $210 >>> $0 | 0;
              $5 = ($4 >>> 5 | 0) & 8 | 0;
              $221 = $5 | $0 | 0;
              $0 = $4 >>> $5 | 0;
              $4 = ($0 >>> 2 | 0) & 4 | 0;
              $229 = $221 | $4 | 0;
              $0 = $0 >>> $4 | 0;
              $4 = ($0 >>> 1 | 0) & 2 | 0;
              $237 = $229 | $4 | 0;
              $0 = $0 >>> $4 | 0;
              $4 = ($0 >>> 1 | 0) & 1 | 0;
              $6 = HEAP32[(((($237 | $4 | 0) + ($0 >>> $4 | 0) | 0) << 2 | 0) + 11876 | 0) >> 2] | 0;
              $4 = ((HEAP32[($6 + 4 | 0) >> 2] | 0) & -8 | 0) - $3 | 0;
              $5 = $6;
              label$22 : {
               label$23 : while (1) {
                label$24 : {
                 $0 = HEAP32[($5 + 16 | 0) >> 2] | 0;
                 if ($0) {
                  break label$24
                 }
                 $0 = HEAP32[($5 + 20 | 0) >> 2] | 0;
                 if (!$0) {
                  break label$22
                 }
                }
                $5 = ((HEAP32[($0 + 4 | 0) >> 2] | 0) & -8 | 0) - $3 | 0;
                $272 = $5;
                $5 = $5 >>> 0 < $4 >>> 0;
                $4 = $5 ? $272 : $4;
                $6 = $5 ? $0 : $6;
                $5 = $0;
                continue label$23;
               };
              }
              $10 = HEAP32[($6 + 24 | 0) >> 2] | 0;
              label$25 : {
               $8 = HEAP32[($6 + 12 | 0) >> 2] | 0;
               if (($8 | 0) == ($6 | 0)) {
                break label$25
               }
               $0 = HEAP32[($6 + 8 | 0) >> 2] | 0;
               HEAP32[(0 + 11588 | 0) >> 2] | 0;
               HEAP32[($0 + 12 | 0) >> 2] = $8;
               HEAP32[($8 + 8 | 0) >> 2] = $0;
               break label$2;
              }
              label$26 : {
               $5 = $6 + 20 | 0;
               $0 = HEAP32[$5 >> 2] | 0;
               if ($0) {
                break label$26
               }
               $0 = HEAP32[($6 + 16 | 0) >> 2] | 0;
               if (!$0) {
                break label$10
               }
               $5 = $6 + 16 | 0;
              }
              label$27 : while (1) {
               $11 = $5;
               $8 = $0;
               $5 = $0 + 20 | 0;
               $0 = HEAP32[$5 >> 2] | 0;
               if ($0) {
                continue label$27
               }
               $5 = $8 + 16 | 0;
               $0 = HEAP32[($8 + 16 | 0) >> 2] | 0;
               if ($0) {
                continue label$27
               }
               break label$27;
              };
              HEAP32[$11 >> 2] = 0;
              break label$2;
             }
             $3 = -1;
             if ($0 >>> 0 > -65 >>> 0) {
              break label$11
             }
             $0 = $0 + 11 | 0;
             $3 = $0 & -8 | 0;
             $7 = HEAP32[(0 + 11576 | 0) >> 2] | 0;
             if (!$7) {
              break label$11
             }
             $11 = 0;
             label$28 : {
              if ($3 >>> 0 < 256 >>> 0) {
               break label$28
              }
              $11 = 31;
              if ($3 >>> 0 > 16777215 >>> 0) {
               break label$28
              }
              $0 = $0 >>> 8 | 0;
              $339 = $0;
              $0 = (($0 + 1048320 | 0) >>> 16 | 0) & 8 | 0;
              $4 = $339 << $0 | 0;
              $346 = $4;
              $4 = (($4 + 520192 | 0) >>> 16 | 0) & 4 | 0;
              $5 = $346 << $4 | 0;
              $353 = $5;
              $5 = (($5 + 245760 | 0) >>> 16 | 0) & 2 | 0;
              $0 = (($353 << $5 | 0) >>> 15 | 0) - ($0 | $4 | 0 | $5 | 0) | 0;
              $11 = ($0 << 1 | 0 | (($3 >>> ($0 + 21 | 0) | 0) & 1 | 0) | 0) + 28 | 0;
             }
             $4 = 0 - $3 | 0;
             label$29 : {
              label$30 : {
               label$31 : {
                label$32 : {
                 $5 = HEAP32[(($11 << 2 | 0) + 11876 | 0) >> 2] | 0;
                 if ($5) {
                  break label$32
                 }
                 $0 = 0;
                 $8 = 0;
                 break label$31;
                }
                $0 = 0;
                $6 = $3 << (($11 | 0) == (31 | 0) ? 0 : 25 - ($11 >>> 1 | 0) | 0) | 0;
                $8 = 0;
                label$33 : while (1) {
                 label$34 : {
                  $2 = ((HEAP32[($5 + 4 | 0) >> 2] | 0) & -8 | 0) - $3 | 0;
                  if ($2 >>> 0 >= $4 >>> 0) {
                   break label$34
                  }
                  $4 = $2;
                  $8 = $5;
                  if ($4) {
                   break label$34
                  }
                  $4 = 0;
                  $8 = $5;
                  $0 = $5;
                  break label$30;
                 }
                 $2 = HEAP32[($5 + 20 | 0) >> 2] | 0;
                 $5 = HEAP32[(($5 + (($6 >>> 29 | 0) & 4 | 0) | 0) + 16 | 0) >> 2] | 0;
                 $0 = $2 ? (($2 | 0) == ($5 | 0) ? $0 : $2) : $0;
                 $6 = $6 << 1 | 0;
                 if ($5) {
                  continue label$33
                 }
                 break label$33;
                };
               }
               label$35 : {
                if ($0 | $8 | 0) {
                 break label$35
                }
                $8 = 0;
                $0 = 2 << $11 | 0;
                $0 = ($0 | (0 - $0 | 0) | 0) & $7 | 0;
                if (!$0) {
                 break label$11
                }
                $0 = ($0 & (0 - $0 | 0) | 0) + -1 | 0;
                $444 = $0;
                $0 = ($0 >>> 12 | 0) & 16 | 0;
                $5 = $444 >>> $0 | 0;
                $6 = ($5 >>> 5 | 0) & 8 | 0;
                $455 = $6 | $0 | 0;
                $0 = $5 >>> $6 | 0;
                $5 = ($0 >>> 2 | 0) & 4 | 0;
                $463 = $455 | $5 | 0;
                $0 = $0 >>> $5 | 0;
                $5 = ($0 >>> 1 | 0) & 2 | 0;
                $471 = $463 | $5 | 0;
                $0 = $0 >>> $5 | 0;
                $5 = ($0 >>> 1 | 0) & 1 | 0;
                $0 = HEAP32[(((($471 | $5 | 0) + ($0 >>> $5 | 0) | 0) << 2 | 0) + 11876 | 0) >> 2] | 0;
               }
               if (!$0) {
                break label$29
               }
              }
              label$36 : while (1) {
               $2 = ((HEAP32[($0 + 4 | 0) >> 2] | 0) & -8 | 0) - $3 | 0;
               $6 = $2 >>> 0 < $4 >>> 0;
               label$37 : {
                $5 = HEAP32[($0 + 16 | 0) >> 2] | 0;
                if ($5) {
                 break label$37
                }
                $5 = HEAP32[($0 + 20 | 0) >> 2] | 0;
               }
               $4 = $6 ? $2 : $4;
               $8 = $6 ? $0 : $8;
               $0 = $5;
               if ($0) {
                continue label$36
               }
               break label$36;
              };
             }
             if (!$8) {
              break label$11
             }
             if ($4 >>> 0 >= ((HEAP32[(0 + 11580 | 0) >> 2] | 0) - $3 | 0) >>> 0) {
              break label$11
             }
             $11 = HEAP32[($8 + 24 | 0) >> 2] | 0;
             label$38 : {
              $6 = HEAP32[($8 + 12 | 0) >> 2] | 0;
              if (($6 | 0) == ($8 | 0)) {
               break label$38
              }
              $0 = HEAP32[($8 + 8 | 0) >> 2] | 0;
              HEAP32[(0 + 11588 | 0) >> 2] | 0;
              HEAP32[($0 + 12 | 0) >> 2] = $6;
              HEAP32[($6 + 8 | 0) >> 2] = $0;
              break label$3;
             }
             label$39 : {
              $5 = $8 + 20 | 0;
              $0 = HEAP32[$5 >> 2] | 0;
              if ($0) {
               break label$39
              }
              $0 = HEAP32[($8 + 16 | 0) >> 2] | 0;
              if (!$0) {
               break label$9
              }
              $5 = $8 + 16 | 0;
             }
             label$40 : while (1) {
              $2 = $5;
              $6 = $0;
              $5 = $0 + 20 | 0;
              $0 = HEAP32[$5 >> 2] | 0;
              if ($0) {
               continue label$40
              }
              $5 = $6 + 16 | 0;
              $0 = HEAP32[($6 + 16 | 0) >> 2] | 0;
              if ($0) {
               continue label$40
              }
              break label$40;
             };
             HEAP32[$2 >> 2] = 0;
             break label$3;
            }
            label$41 : {
             $0 = HEAP32[(0 + 11580 | 0) >> 2] | 0;
             if ($0 >>> 0 < $3 >>> 0) {
              break label$41
             }
             $4 = HEAP32[(0 + 11592 | 0) >> 2] | 0;
             label$42 : {
              label$43 : {
               $5 = $0 - $3 | 0;
               if ($5 >>> 0 < 16 >>> 0) {
                break label$43
               }
               HEAP32[(0 + 11580 | 0) >> 2] = $5;
               $6 = $4 + $3 | 0;
               HEAP32[(0 + 11592 | 0) >> 2] = $6;
               HEAP32[($6 + 4 | 0) >> 2] = $5 | 1 | 0;
               HEAP32[($4 + $0 | 0) >> 2] = $5;
               HEAP32[($4 + 4 | 0) >> 2] = $3 | 3 | 0;
               break label$42;
              }
              HEAP32[(0 + 11592 | 0) >> 2] = 0;
              HEAP32[(0 + 11580 | 0) >> 2] = 0;
              HEAP32[($4 + 4 | 0) >> 2] = $0 | 3 | 0;
              $0 = $4 + $0 | 0;
              HEAP32[($0 + 4 | 0) >> 2] = HEAP32[($0 + 4 | 0) >> 2] | 0 | 1 | 0;
             }
             $0 = $4 + 8 | 0;
             break label$1;
            }
            label$44 : {
             $6 = HEAP32[(0 + 11584 | 0) >> 2] | 0;
             if ($6 >>> 0 <= $3 >>> 0) {
              break label$44
             }
             $4 = $6 - $3 | 0;
             HEAP32[(0 + 11584 | 0) >> 2] = $4;
             $0 = HEAP32[(0 + 11596 | 0) >> 2] | 0;
             $5 = $0 + $3 | 0;
             HEAP32[(0 + 11596 | 0) >> 2] = $5;
             HEAP32[($5 + 4 | 0) >> 2] = $4 | 1 | 0;
             HEAP32[($0 + 4 | 0) >> 2] = $3 | 3 | 0;
             $0 = $0 + 8 | 0;
             break label$1;
            }
            label$45 : {
             label$46 : {
              if (!(HEAP32[(0 + 12044 | 0) >> 2] | 0)) {
               break label$46
              }
              $4 = HEAP32[(0 + 12052 | 0) >> 2] | 0;
              break label$45;
             }
             i64toi32_i32$1 = 0;
             i64toi32_i32$0 = -1;
             HEAP32[(i64toi32_i32$1 + 12056 | 0) >> 2] = -1;
             HEAP32[(i64toi32_i32$1 + 12060 | 0) >> 2] = i64toi32_i32$0;
             i64toi32_i32$1 = 0;
             i64toi32_i32$0 = 4096;
             HEAP32[(i64toi32_i32$1 + 12048 | 0) >> 2] = 4096;
             HEAP32[(i64toi32_i32$1 + 12052 | 0) >> 2] = i64toi32_i32$0;
             HEAP32[(0 + 12044 | 0) >> 2] = (($1 + 12 | 0) & -16 | 0) ^ 1431655768 | 0;
             HEAP32[(0 + 12064 | 0) >> 2] = 0;
             HEAP32[(0 + 12016 | 0) >> 2] = 0;
             $4 = 4096;
            }
            $0 = 0;
            $7 = $3 + 47 | 0;
            $2 = $4 + $7 | 0;
            $11 = 0 - $4 | 0;
            $8 = $2 & $11 | 0;
            if ($8 >>> 0 <= $3 >>> 0) {
             break label$1
            }
            $0 = 0;
            label$47 : {
             $4 = HEAP32[(0 + 12012 | 0) >> 2] | 0;
             if (!$4) {
              break label$47
             }
             $5 = HEAP32[(0 + 12004 | 0) >> 2] | 0;
             $9 = $5 + $8 | 0;
             if ($9 >>> 0 <= $5 >>> 0) {
              break label$1
             }
             if ($9 >>> 0 > $4 >>> 0) {
              break label$1
             }
            }
            if ((HEAPU8[(0 + 12016 | 0) >> 0] | 0) & 4 | 0) {
             break label$6
            }
            label$48 : {
             label$49 : {
              label$50 : {
               $4 = HEAP32[(0 + 11596 | 0) >> 2] | 0;
               if (!$4) {
                break label$50
               }
               $0 = 12020;
               label$51 : while (1) {
                label$52 : {
                 $5 = HEAP32[$0 >> 2] | 0;
                 if ($5 >>> 0 > $4 >>> 0) {
                  break label$52
                 }
                 if (($5 + (HEAP32[($0 + 4 | 0) >> 2] | 0) | 0) >>> 0 > $4 >>> 0) {
                  break label$49
                 }
                }
                $0 = HEAP32[($0 + 8 | 0) >> 2] | 0;
                if ($0) {
                 continue label$51
                }
                break label$51;
               };
              }
              $6 = sbrk(0 | 0) | 0;
              if (($6 | 0) == (-1 | 0)) {
               break label$7
              }
              $2 = $8;
              label$53 : {
               $0 = HEAP32[(0 + 12048 | 0) >> 2] | 0;
               $4 = $0 + -1 | 0;
               if (!($4 & $6 | 0)) {
                break label$53
               }
               $2 = ($8 - $6 | 0) + (($4 + $6 | 0) & (0 - $0 | 0) | 0) | 0;
              }
              if ($2 >>> 0 <= $3 >>> 0) {
               break label$7
              }
              if ($2 >>> 0 > 2147483646 >>> 0) {
               break label$7
              }
              label$54 : {
               $0 = HEAP32[(0 + 12012 | 0) >> 2] | 0;
               if (!$0) {
                break label$54
               }
               $4 = HEAP32[(0 + 12004 | 0) >> 2] | 0;
               $5 = $4 + $2 | 0;
               if ($5 >>> 0 <= $4 >>> 0) {
                break label$7
               }
               if ($5 >>> 0 > $0 >>> 0) {
                break label$7
               }
              }
              $0 = sbrk($2 | 0) | 0;
              if (($0 | 0) != ($6 | 0)) {
               break label$48
              }
              break label$5;
             }
             $2 = ($2 - $6 | 0) & $11 | 0;
             if ($2 >>> 0 > 2147483646 >>> 0) {
              break label$7
             }
             $6 = sbrk($2 | 0) | 0;
             if (($6 | 0) == ((HEAP32[$0 >> 2] | 0) + (HEAP32[($0 + 4 | 0) >> 2] | 0) | 0 | 0)) {
              break label$8
             }
             $0 = $6;
            }
            label$55 : {
             if (($0 | 0) == (-1 | 0)) {
              break label$55
             }
             if (($3 + 48 | 0) >>> 0 <= $2 >>> 0) {
              break label$55
             }
             label$56 : {
              $4 = HEAP32[(0 + 12052 | 0) >> 2] | 0;
              $4 = (($7 - $2 | 0) + $4 | 0) & (0 - $4 | 0) | 0;
              if ($4 >>> 0 <= 2147483646 >>> 0) {
               break label$56
              }
              $6 = $0;
              break label$5;
             }
             label$57 : {
              if ((sbrk($4 | 0) | 0 | 0) == (-1 | 0)) {
               break label$57
              }
              $2 = $4 + $2 | 0;
              $6 = $0;
              break label$5;
             }
             sbrk(0 - $2 | 0 | 0) | 0;
             break label$7;
            }
            $6 = $0;
            if (($0 | 0) != (-1 | 0)) {
             break label$5
            }
            break label$7;
           }
           $8 = 0;
           break label$2;
          }
          $6 = 0;
          break label$3;
         }
         if (($6 | 0) != (-1 | 0)) {
          break label$5
         }
        }
        HEAP32[(0 + 12016 | 0) >> 2] = HEAP32[(0 + 12016 | 0) >> 2] | 0 | 4 | 0;
       }
       if ($8 >>> 0 > 2147483646 >>> 0) {
        break label$4
       }
       $6 = sbrk($8 | 0) | 0;
       $0 = sbrk(0 | 0) | 0;
       if (($6 | 0) == (-1 | 0)) {
        break label$4
       }
       if (($0 | 0) == (-1 | 0)) {
        break label$4
       }
       if ($6 >>> 0 >= $0 >>> 0) {
        break label$4
       }
       $2 = $0 - $6 | 0;
       if ($2 >>> 0 <= ($3 + 40 | 0) >>> 0) {
        break label$4
       }
      }
      $0 = (HEAP32[(0 + 12004 | 0) >> 2] | 0) + $2 | 0;
      HEAP32[(0 + 12004 | 0) >> 2] = $0;
      label$58 : {
       if ($0 >>> 0 <= (HEAP32[(0 + 12008 | 0) >> 2] | 0) >>> 0) {
        break label$58
       }
       HEAP32[(0 + 12008 | 0) >> 2] = $0;
      }
      label$59 : {
       label$60 : {
        label$61 : {
         label$62 : {
          $4 = HEAP32[(0 + 11596 | 0) >> 2] | 0;
          if (!$4) {
           break label$62
          }
          $0 = 12020;
          label$63 : while (1) {
           $5 = HEAP32[$0 >> 2] | 0;
           $8 = HEAP32[($0 + 4 | 0) >> 2] | 0;
           if (($6 | 0) == ($5 + $8 | 0 | 0)) {
            break label$61
           }
           $0 = HEAP32[($0 + 8 | 0) >> 2] | 0;
           if ($0) {
            continue label$63
           }
           break label$60;
          };
         }
         label$64 : {
          label$65 : {
           $0 = HEAP32[(0 + 11588 | 0) >> 2] | 0;
           if (!$0) {
            break label$65
           }
           if ($6 >>> 0 >= $0 >>> 0) {
            break label$64
           }
          }
          HEAP32[(0 + 11588 | 0) >> 2] = $6;
         }
         $0 = 0;
         HEAP32[(0 + 12024 | 0) >> 2] = $2;
         HEAP32[(0 + 12020 | 0) >> 2] = $6;
         HEAP32[(0 + 11604 | 0) >> 2] = -1;
         HEAP32[(0 + 11608 | 0) >> 2] = HEAP32[(0 + 12044 | 0) >> 2] | 0;
         HEAP32[(0 + 12032 | 0) >> 2] = 0;
         label$66 : while (1) {
          $4 = $0 << 3 | 0;
          $5 = $4 + 11612 | 0;
          HEAP32[($4 + 11620 | 0) >> 2] = $5;
          HEAP32[($4 + 11624 | 0) >> 2] = $5;
          $0 = $0 + 1 | 0;
          if (($0 | 0) != (32 | 0)) {
           continue label$66
          }
          break label$66;
         };
         $0 = $2 + -40 | 0;
         $4 = ($6 + 8 | 0) & 7 | 0 ? (-8 - $6 | 0) & 7 | 0 : 0;
         $5 = $0 - $4 | 0;
         HEAP32[(0 + 11584 | 0) >> 2] = $5;
         $4 = $6 + $4 | 0;
         HEAP32[(0 + 11596 | 0) >> 2] = $4;
         HEAP32[($4 + 4 | 0) >> 2] = $5 | 1 | 0;
         HEAP32[(($6 + $0 | 0) + 4 | 0) >> 2] = 40;
         HEAP32[(0 + 11600 | 0) >> 2] = HEAP32[(0 + 12060 | 0) >> 2] | 0;
         break label$59;
        }
        if ((HEAPU8[($0 + 12 | 0) >> 0] | 0) & 8 | 0) {
         break label$60
        }
        if ($5 >>> 0 > $4 >>> 0) {
         break label$60
        }
        if ($6 >>> 0 <= $4 >>> 0) {
         break label$60
        }
        HEAP32[($0 + 4 | 0) >> 2] = $8 + $2 | 0;
        $0 = ($4 + 8 | 0) & 7 | 0 ? (-8 - $4 | 0) & 7 | 0 : 0;
        $5 = $4 + $0 | 0;
        HEAP32[(0 + 11596 | 0) >> 2] = $5;
        $6 = (HEAP32[(0 + 11584 | 0) >> 2] | 0) + $2 | 0;
        $0 = $6 - $0 | 0;
        HEAP32[(0 + 11584 | 0) >> 2] = $0;
        HEAP32[($5 + 4 | 0) >> 2] = $0 | 1 | 0;
        HEAP32[(($4 + $6 | 0) + 4 | 0) >> 2] = 40;
        HEAP32[(0 + 11600 | 0) >> 2] = HEAP32[(0 + 12060 | 0) >> 2] | 0;
        break label$59;
       }
       label$67 : {
        $8 = HEAP32[(0 + 11588 | 0) >> 2] | 0;
        if ($6 >>> 0 >= $8 >>> 0) {
         break label$67
        }
        HEAP32[(0 + 11588 | 0) >> 2] = $6;
        $8 = $6;
       }
       $5 = $6 + $2 | 0;
       $0 = 12020;
       label$68 : {
        label$69 : {
         label$70 : {
          label$71 : {
           label$72 : {
            label$73 : {
             label$74 : {
              label$75 : while (1) {
               if ((HEAP32[$0 >> 2] | 0 | 0) == ($5 | 0)) {
                break label$74
               }
               $0 = HEAP32[($0 + 8 | 0) >> 2] | 0;
               if ($0) {
                continue label$75
               }
               break label$73;
              };
             }
             if (!((HEAPU8[($0 + 12 | 0) >> 0] | 0) & 8 | 0)) {
              break label$72
             }
            }
            $0 = 12020;
            label$76 : while (1) {
             label$77 : {
              $5 = HEAP32[$0 >> 2] | 0;
              if ($5 >>> 0 > $4 >>> 0) {
               break label$77
              }
              $5 = $5 + (HEAP32[($0 + 4 | 0) >> 2] | 0) | 0;
              if ($5 >>> 0 > $4 >>> 0) {
               break label$71
              }
             }
             $0 = HEAP32[($0 + 8 | 0) >> 2] | 0;
             continue label$76;
            };
           }
           HEAP32[$0 >> 2] = $6;
           HEAP32[($0 + 4 | 0) >> 2] = (HEAP32[($0 + 4 | 0) >> 2] | 0) + $2 | 0;
           $11 = $6 + (($6 + 8 | 0) & 7 | 0 ? (-8 - $6 | 0) & 7 | 0 : 0) | 0;
           HEAP32[($11 + 4 | 0) >> 2] = $3 | 3 | 0;
           $2 = $5 + (($5 + 8 | 0) & 7 | 0 ? (-8 - $5 | 0) & 7 | 0 : 0) | 0;
           $3 = $11 + $3 | 0;
           $5 = $2 - $3 | 0;
           label$78 : {
            if (($4 | 0) != ($2 | 0)) {
             break label$78
            }
            HEAP32[(0 + 11596 | 0) >> 2] = $3;
            $0 = (HEAP32[(0 + 11584 | 0) >> 2] | 0) + $5 | 0;
            HEAP32[(0 + 11584 | 0) >> 2] = $0;
            HEAP32[($3 + 4 | 0) >> 2] = $0 | 1 | 0;
            break label$69;
           }
           label$79 : {
            if ((HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0) != ($2 | 0)) {
             break label$79
            }
            HEAP32[(0 + 11592 | 0) >> 2] = $3;
            $0 = (HEAP32[(0 + 11580 | 0) >> 2] | 0) + $5 | 0;
            HEAP32[(0 + 11580 | 0) >> 2] = $0;
            HEAP32[($3 + 4 | 0) >> 2] = $0 | 1 | 0;
            HEAP32[($3 + $0 | 0) >> 2] = $0;
            break label$69;
           }
           label$80 : {
            $0 = HEAP32[($2 + 4 | 0) >> 2] | 0;
            if (($0 & 3 | 0 | 0) != (1 | 0)) {
             break label$80
            }
            $7 = $0 & -8 | 0;
            label$81 : {
             label$82 : {
              if ($0 >>> 0 > 255 >>> 0) {
               break label$82
              }
              $4 = HEAP32[($2 + 8 | 0) >> 2] | 0;
              $8 = $0 >>> 3 | 0;
              $6 = ($8 << 3 | 0) + 11612 | 0;
              label$83 : {
               $0 = HEAP32[($2 + 12 | 0) >> 2] | 0;
               if (($0 | 0) != ($4 | 0)) {
                break label$83
               }
               (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11572 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $8 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11572 | 0) >> 2] = wasm2js_i32$1;
               break label$81;
              }
              HEAP32[($4 + 12 | 0) >> 2] = $0;
              HEAP32[($0 + 8 | 0) >> 2] = $4;
              break label$81;
             }
             $9 = HEAP32[($2 + 24 | 0) >> 2] | 0;
             label$84 : {
              label$85 : {
               $6 = HEAP32[($2 + 12 | 0) >> 2] | 0;
               if (($6 | 0) == ($2 | 0)) {
                break label$85
               }
               $0 = HEAP32[($2 + 8 | 0) >> 2] | 0;
               HEAP32[($0 + 12 | 0) >> 2] = $6;
               HEAP32[($6 + 8 | 0) >> 2] = $0;
               break label$84;
              }
              label$86 : {
               $0 = $2 + 20 | 0;
               $4 = HEAP32[$0 >> 2] | 0;
               if ($4) {
                break label$86
               }
               $0 = $2 + 16 | 0;
               $4 = HEAP32[$0 >> 2] | 0;
               if ($4) {
                break label$86
               }
               $6 = 0;
               break label$84;
              }
              label$87 : while (1) {
               $8 = $0;
               $6 = $4;
               $0 = $4 + 20 | 0;
               $4 = HEAP32[$0 >> 2] | 0;
               if ($4) {
                continue label$87
               }
               $0 = $6 + 16 | 0;
               $4 = HEAP32[($6 + 16 | 0) >> 2] | 0;
               if ($4) {
                continue label$87
               }
               break label$87;
              };
              HEAP32[$8 >> 2] = 0;
             }
             if (!$9) {
              break label$81
             }
             label$88 : {
              label$89 : {
               $4 = HEAP32[($2 + 28 | 0) >> 2] | 0;
               $0 = ($4 << 2 | 0) + 11876 | 0;
               if ((HEAP32[$0 >> 2] | 0 | 0) != ($2 | 0)) {
                break label$89
               }
               HEAP32[$0 >> 2] = $6;
               if ($6) {
                break label$88
               }
               (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11576 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $4 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11576 | 0) >> 2] = wasm2js_i32$1;
               break label$81;
              }
              HEAP32[($9 + ((HEAP32[($9 + 16 | 0) >> 2] | 0 | 0) == ($2 | 0) ? 16 : 20) | 0) >> 2] = $6;
              if (!$6) {
               break label$81
              }
             }
             HEAP32[($6 + 24 | 0) >> 2] = $9;
             label$90 : {
              $0 = HEAP32[($2 + 16 | 0) >> 2] | 0;
              if (!$0) {
               break label$90
              }
              HEAP32[($6 + 16 | 0) >> 2] = $0;
              HEAP32[($0 + 24 | 0) >> 2] = $6;
             }
             $0 = HEAP32[($2 + 20 | 0) >> 2] | 0;
             if (!$0) {
              break label$81
             }
             HEAP32[($6 + 20 | 0) >> 2] = $0;
             HEAP32[($0 + 24 | 0) >> 2] = $6;
            }
            $5 = $7 + $5 | 0;
            $2 = $2 + $7 | 0;
           }
           HEAP32[($2 + 4 | 0) >> 2] = (HEAP32[($2 + 4 | 0) >> 2] | 0) & -2 | 0;
           HEAP32[($3 + 4 | 0) >> 2] = $5 | 1 | 0;
           HEAP32[($3 + $5 | 0) >> 2] = $5;
           label$91 : {
            if ($5 >>> 0 > 255 >>> 0) {
             break label$91
            }
            $4 = $5 >>> 3 | 0;
            $0 = ($4 << 3 | 0) + 11612 | 0;
            label$92 : {
             label$93 : {
              $5 = HEAP32[(0 + 11572 | 0) >> 2] | 0;
              $4 = 1 << $4 | 0;
              if ($5 & $4 | 0) {
               break label$93
              }
              HEAP32[(0 + 11572 | 0) >> 2] = $5 | $4 | 0;
              $4 = $0;
              break label$92;
             }
             $4 = HEAP32[($0 + 8 | 0) >> 2] | 0;
            }
            HEAP32[($0 + 8 | 0) >> 2] = $3;
            HEAP32[($4 + 12 | 0) >> 2] = $3;
            HEAP32[($3 + 12 | 0) >> 2] = $0;
            HEAP32[($3 + 8 | 0) >> 2] = $4;
            break label$69;
           }
           $0 = 31;
           label$94 : {
            if ($5 >>> 0 > 16777215 >>> 0) {
             break label$94
            }
            $0 = $5 >>> 8 | 0;
            $1157 = $0;
            $0 = (($0 + 1048320 | 0) >>> 16 | 0) & 8 | 0;
            $4 = $1157 << $0 | 0;
            $1164 = $4;
            $4 = (($4 + 520192 | 0) >>> 16 | 0) & 4 | 0;
            $6 = $1164 << $4 | 0;
            $1171 = $6;
            $6 = (($6 + 245760 | 0) >>> 16 | 0) & 2 | 0;
            $0 = (($1171 << $6 | 0) >>> 15 | 0) - ($0 | $4 | 0 | $6 | 0) | 0;
            $0 = ($0 << 1 | 0 | (($5 >>> ($0 + 21 | 0) | 0) & 1 | 0) | 0) + 28 | 0;
           }
           HEAP32[($3 + 28 | 0) >> 2] = $0;
           i64toi32_i32$1 = $3;
           i64toi32_i32$0 = 0;
           HEAP32[($3 + 16 | 0) >> 2] = 0;
           HEAP32[($3 + 20 | 0) >> 2] = i64toi32_i32$0;
           $4 = ($0 << 2 | 0) + 11876 | 0;
           label$95 : {
            label$96 : {
             $6 = HEAP32[(0 + 11576 | 0) >> 2] | 0;
             $8 = 1 << $0 | 0;
             if ($6 & $8 | 0) {
              break label$96
             }
             HEAP32[(0 + 11576 | 0) >> 2] = $6 | $8 | 0;
             HEAP32[$4 >> 2] = $3;
             HEAP32[($3 + 24 | 0) >> 2] = $4;
             break label$95;
            }
            $0 = $5 << (($0 | 0) == (31 | 0) ? 0 : 25 - ($0 >>> 1 | 0) | 0) | 0;
            $6 = HEAP32[$4 >> 2] | 0;
            label$97 : while (1) {
             $4 = $6;
             if (((HEAP32[($4 + 4 | 0) >> 2] | 0) & -8 | 0 | 0) == ($5 | 0)) {
              break label$70
             }
             $6 = $0 >>> 29 | 0;
             $0 = $0 << 1 | 0;
             $8 = ($4 + ($6 & 4 | 0) | 0) + 16 | 0;
             $6 = HEAP32[$8 >> 2] | 0;
             if ($6) {
              continue label$97
             }
             break label$97;
            };
            HEAP32[$8 >> 2] = $3;
            HEAP32[($3 + 24 | 0) >> 2] = $4;
           }
           HEAP32[($3 + 12 | 0) >> 2] = $3;
           HEAP32[($3 + 8 | 0) >> 2] = $3;
           break label$69;
          }
          $0 = $2 + -40 | 0;
          $8 = ($6 + 8 | 0) & 7 | 0 ? (-8 - $6 | 0) & 7 | 0 : 0;
          $11 = $0 - $8 | 0;
          HEAP32[(0 + 11584 | 0) >> 2] = $11;
          $8 = $6 + $8 | 0;
          HEAP32[(0 + 11596 | 0) >> 2] = $8;
          HEAP32[($8 + 4 | 0) >> 2] = $11 | 1 | 0;
          HEAP32[(($6 + $0 | 0) + 4 | 0) >> 2] = 40;
          HEAP32[(0 + 11600 | 0) >> 2] = HEAP32[(0 + 12060 | 0) >> 2] | 0;
          $0 = ($5 + (($5 + -39 | 0) & 7 | 0 ? (39 - $5 | 0) & 7 | 0 : 0) | 0) + -47 | 0;
          $8 = $0 >>> 0 < ($4 + 16 | 0) >>> 0 ? $4 : $0;
          HEAP32[($8 + 4 | 0) >> 2] = 27;
          i64toi32_i32$2 = 0;
          i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 12028 | 0) >> 2] | 0;
          i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 12032 | 0) >> 2] | 0;
          $1293 = i64toi32_i32$0;
          i64toi32_i32$0 = $8 + 16 | 0;
          HEAP32[i64toi32_i32$0 >> 2] = $1293;
          HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
          i64toi32_i32$2 = 0;
          i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 12020 | 0) >> 2] | 0;
          i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 12024 | 0) >> 2] | 0;
          $1295 = i64toi32_i32$1;
          i64toi32_i32$1 = $8;
          HEAP32[($8 + 8 | 0) >> 2] = $1295;
          HEAP32[($8 + 12 | 0) >> 2] = i64toi32_i32$0;
          HEAP32[(0 + 12028 | 0) >> 2] = $8 + 8 | 0;
          HEAP32[(0 + 12024 | 0) >> 2] = $2;
          HEAP32[(0 + 12020 | 0) >> 2] = $6;
          HEAP32[(0 + 12032 | 0) >> 2] = 0;
          $0 = $8 + 24 | 0;
          label$98 : while (1) {
           HEAP32[($0 + 4 | 0) >> 2] = 7;
           $6 = $0 + 8 | 0;
           $0 = $0 + 4 | 0;
           if ($5 >>> 0 > $6 >>> 0) {
            continue label$98
           }
           break label$98;
          };
          if (($8 | 0) == ($4 | 0)) {
           break label$59
          }
          HEAP32[($8 + 4 | 0) >> 2] = (HEAP32[($8 + 4 | 0) >> 2] | 0) & -2 | 0;
          $2 = $8 - $4 | 0;
          HEAP32[($4 + 4 | 0) >> 2] = $2 | 1 | 0;
          HEAP32[$8 >> 2] = $2;
          label$99 : {
           if ($2 >>> 0 > 255 >>> 0) {
            break label$99
           }
           $5 = $2 >>> 3 | 0;
           $0 = ($5 << 3 | 0) + 11612 | 0;
           label$100 : {
            label$101 : {
             $6 = HEAP32[(0 + 11572 | 0) >> 2] | 0;
             $5 = 1 << $5 | 0;
             if ($6 & $5 | 0) {
              break label$101
             }
             HEAP32[(0 + 11572 | 0) >> 2] = $6 | $5 | 0;
             $5 = $0;
             break label$100;
            }
            $5 = HEAP32[($0 + 8 | 0) >> 2] | 0;
           }
           HEAP32[($0 + 8 | 0) >> 2] = $4;
           HEAP32[($5 + 12 | 0) >> 2] = $4;
           HEAP32[($4 + 12 | 0) >> 2] = $0;
           HEAP32[($4 + 8 | 0) >> 2] = $5;
           break label$59;
          }
          $0 = 31;
          label$102 : {
           if ($2 >>> 0 > 16777215 >>> 0) {
            break label$102
           }
           $0 = $2 >>> 8 | 0;
           $1356 = $0;
           $0 = (($0 + 1048320 | 0) >>> 16 | 0) & 8 | 0;
           $5 = $1356 << $0 | 0;
           $1363 = $5;
           $5 = (($5 + 520192 | 0) >>> 16 | 0) & 4 | 0;
           $6 = $1363 << $5 | 0;
           $1370 = $6;
           $6 = (($6 + 245760 | 0) >>> 16 | 0) & 2 | 0;
           $0 = (($1370 << $6 | 0) >>> 15 | 0) - ($0 | $5 | 0 | $6 | 0) | 0;
           $0 = ($0 << 1 | 0 | (($2 >>> ($0 + 21 | 0) | 0) & 1 | 0) | 0) + 28 | 0;
          }
          i64toi32_i32$1 = $4;
          i64toi32_i32$0 = 0;
          HEAP32[($4 + 16 | 0) >> 2] = 0;
          HEAP32[($4 + 20 | 0) >> 2] = i64toi32_i32$0;
          HEAP32[($4 + 28 | 0) >> 2] = $0;
          $5 = ($0 << 2 | 0) + 11876 | 0;
          label$103 : {
           label$104 : {
            $6 = HEAP32[(0 + 11576 | 0) >> 2] | 0;
            $8 = 1 << $0 | 0;
            if ($6 & $8 | 0) {
             break label$104
            }
            HEAP32[(0 + 11576 | 0) >> 2] = $6 | $8 | 0;
            HEAP32[$5 >> 2] = $4;
            HEAP32[($4 + 24 | 0) >> 2] = $5;
            break label$103;
           }
           $0 = $2 << (($0 | 0) == (31 | 0) ? 0 : 25 - ($0 >>> 1 | 0) | 0) | 0;
           $6 = HEAP32[$5 >> 2] | 0;
           label$105 : while (1) {
            $5 = $6;
            if (((HEAP32[($6 + 4 | 0) >> 2] | 0) & -8 | 0 | 0) == ($2 | 0)) {
             break label$68
            }
            $6 = $0 >>> 29 | 0;
            $0 = $0 << 1 | 0;
            $8 = ($5 + ($6 & 4 | 0) | 0) + 16 | 0;
            $6 = HEAP32[$8 >> 2] | 0;
            if ($6) {
             continue label$105
            }
            break label$105;
           };
           HEAP32[$8 >> 2] = $4;
           HEAP32[($4 + 24 | 0) >> 2] = $5;
          }
          HEAP32[($4 + 12 | 0) >> 2] = $4;
          HEAP32[($4 + 8 | 0) >> 2] = $4;
          break label$59;
         }
         $0 = HEAP32[($4 + 8 | 0) >> 2] | 0;
         HEAP32[($0 + 12 | 0) >> 2] = $3;
         HEAP32[($4 + 8 | 0) >> 2] = $3;
         HEAP32[($3 + 24 | 0) >> 2] = 0;
         HEAP32[($3 + 12 | 0) >> 2] = $4;
         HEAP32[($3 + 8 | 0) >> 2] = $0;
        }
        $0 = $11 + 8 | 0;
        break label$1;
       }
       $0 = HEAP32[($5 + 8 | 0) >> 2] | 0;
       HEAP32[($0 + 12 | 0) >> 2] = $4;
       HEAP32[($5 + 8 | 0) >> 2] = $4;
       HEAP32[($4 + 24 | 0) >> 2] = 0;
       HEAP32[($4 + 12 | 0) >> 2] = $5;
       HEAP32[($4 + 8 | 0) >> 2] = $0;
      }
      $0 = HEAP32[(0 + 11584 | 0) >> 2] | 0;
      if ($0 >>> 0 <= $3 >>> 0) {
       break label$4
      }
      $4 = $0 - $3 | 0;
      HEAP32[(0 + 11584 | 0) >> 2] = $4;
      $0 = HEAP32[(0 + 11596 | 0) >> 2] | 0;
      $5 = $0 + $3 | 0;
      HEAP32[(0 + 11596 | 0) >> 2] = $5;
      HEAP32[($5 + 4 | 0) >> 2] = $4 | 1 | 0;
      HEAP32[($0 + 4 | 0) >> 2] = $3 | 3 | 0;
      $0 = $0 + 8 | 0;
      break label$1;
     }
     (wasm2js_i32$0 = __errno_location() | 0, wasm2js_i32$1 = 48), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
     $0 = 0;
     break label$1;
    }
    label$106 : {
     if (!$11) {
      break label$106
     }
     label$107 : {
      label$108 : {
       $5 = HEAP32[($8 + 28 | 0) >> 2] | 0;
       $0 = ($5 << 2 | 0) + 11876 | 0;
       if (($8 | 0) != (HEAP32[$0 >> 2] | 0 | 0)) {
        break label$108
       }
       HEAP32[$0 >> 2] = $6;
       if ($6) {
        break label$107
       }
       $7 = $7 & (__wasm_rotl_i32(-2 | 0, $5 | 0) | 0) | 0;
       HEAP32[(0 + 11576 | 0) >> 2] = $7;
       break label$106;
      }
      HEAP32[($11 + ((HEAP32[($11 + 16 | 0) >> 2] | 0 | 0) == ($8 | 0) ? 16 : 20) | 0) >> 2] = $6;
      if (!$6) {
       break label$106
      }
     }
     HEAP32[($6 + 24 | 0) >> 2] = $11;
     label$109 : {
      $0 = HEAP32[($8 + 16 | 0) >> 2] | 0;
      if (!$0) {
       break label$109
      }
      HEAP32[($6 + 16 | 0) >> 2] = $0;
      HEAP32[($0 + 24 | 0) >> 2] = $6;
     }
     $0 = HEAP32[($8 + 20 | 0) >> 2] | 0;
     if (!$0) {
      break label$106
     }
     HEAP32[($6 + 20 | 0) >> 2] = $0;
     HEAP32[($0 + 24 | 0) >> 2] = $6;
    }
    label$110 : {
     label$111 : {
      if ($4 >>> 0 > 15 >>> 0) {
       break label$111
      }
      $0 = $4 + $3 | 0;
      HEAP32[($8 + 4 | 0) >> 2] = $0 | 3 | 0;
      $0 = $8 + $0 | 0;
      HEAP32[($0 + 4 | 0) >> 2] = HEAP32[($0 + 4 | 0) >> 2] | 0 | 1 | 0;
      break label$110;
     }
     HEAP32[($8 + 4 | 0) >> 2] = $3 | 3 | 0;
     $6 = $8 + $3 | 0;
     HEAP32[($6 + 4 | 0) >> 2] = $4 | 1 | 0;
     HEAP32[($6 + $4 | 0) >> 2] = $4;
     label$112 : {
      if ($4 >>> 0 > 255 >>> 0) {
       break label$112
      }
      $4 = $4 >>> 3 | 0;
      $0 = ($4 << 3 | 0) + 11612 | 0;
      label$113 : {
       label$114 : {
        $5 = HEAP32[(0 + 11572 | 0) >> 2] | 0;
        $4 = 1 << $4 | 0;
        if ($5 & $4 | 0) {
         break label$114
        }
        HEAP32[(0 + 11572 | 0) >> 2] = $5 | $4 | 0;
        $4 = $0;
        break label$113;
       }
       $4 = HEAP32[($0 + 8 | 0) >> 2] | 0;
      }
      HEAP32[($0 + 8 | 0) >> 2] = $6;
      HEAP32[($4 + 12 | 0) >> 2] = $6;
      HEAP32[($6 + 12 | 0) >> 2] = $0;
      HEAP32[($6 + 8 | 0) >> 2] = $4;
      break label$110;
     }
     $0 = 31;
     label$115 : {
      if ($4 >>> 0 > 16777215 >>> 0) {
       break label$115
      }
      $0 = $4 >>> 8 | 0;
      $1606 = $0;
      $0 = (($0 + 1048320 | 0) >>> 16 | 0) & 8 | 0;
      $5 = $1606 << $0 | 0;
      $1613 = $5;
      $5 = (($5 + 520192 | 0) >>> 16 | 0) & 4 | 0;
      $3 = $1613 << $5 | 0;
      $1620 = $3;
      $3 = (($3 + 245760 | 0) >>> 16 | 0) & 2 | 0;
      $0 = (($1620 << $3 | 0) >>> 15 | 0) - ($0 | $5 | 0 | $3 | 0) | 0;
      $0 = ($0 << 1 | 0 | (($4 >>> ($0 + 21 | 0) | 0) & 1 | 0) | 0) + 28 | 0;
     }
     HEAP32[($6 + 28 | 0) >> 2] = $0;
     i64toi32_i32$1 = $6;
     i64toi32_i32$0 = 0;
     HEAP32[($6 + 16 | 0) >> 2] = 0;
     HEAP32[($6 + 20 | 0) >> 2] = i64toi32_i32$0;
     $5 = ($0 << 2 | 0) + 11876 | 0;
     label$116 : {
      label$117 : {
       label$118 : {
        $3 = 1 << $0 | 0;
        if ($7 & $3 | 0) {
         break label$118
        }
        HEAP32[(0 + 11576 | 0) >> 2] = $7 | $3 | 0;
        HEAP32[$5 >> 2] = $6;
        HEAP32[($6 + 24 | 0) >> 2] = $5;
        break label$117;
       }
       $0 = $4 << (($0 | 0) == (31 | 0) ? 0 : 25 - ($0 >>> 1 | 0) | 0) | 0;
       $3 = HEAP32[$5 >> 2] | 0;
       label$119 : while (1) {
        $5 = $3;
        if (((HEAP32[($5 + 4 | 0) >> 2] | 0) & -8 | 0 | 0) == ($4 | 0)) {
         break label$116
        }
        $3 = $0 >>> 29 | 0;
        $0 = $0 << 1 | 0;
        $2 = ($5 + ($3 & 4 | 0) | 0) + 16 | 0;
        $3 = HEAP32[$2 >> 2] | 0;
        if ($3) {
         continue label$119
        }
        break label$119;
       };
       HEAP32[$2 >> 2] = $6;
       HEAP32[($6 + 24 | 0) >> 2] = $5;
      }
      HEAP32[($6 + 12 | 0) >> 2] = $6;
      HEAP32[($6 + 8 | 0) >> 2] = $6;
      break label$110;
     }
     $0 = HEAP32[($5 + 8 | 0) >> 2] | 0;
     HEAP32[($0 + 12 | 0) >> 2] = $6;
     HEAP32[($5 + 8 | 0) >> 2] = $6;
     HEAP32[($6 + 24 | 0) >> 2] = 0;
     HEAP32[($6 + 12 | 0) >> 2] = $5;
     HEAP32[($6 + 8 | 0) >> 2] = $0;
    }
    $0 = $8 + 8 | 0;
    break label$1;
   }
   label$120 : {
    if (!$10) {
     break label$120
    }
    label$121 : {
     label$122 : {
      $5 = HEAP32[($6 + 28 | 0) >> 2] | 0;
      $0 = ($5 << 2 | 0) + 11876 | 0;
      if (($6 | 0) != (HEAP32[$0 >> 2] | 0 | 0)) {
       break label$122
      }
      HEAP32[$0 >> 2] = $8;
      if ($8) {
       break label$121
      }
      (wasm2js_i32$0 = 0, wasm2js_i32$1 = $9 & (__wasm_rotl_i32(-2 | 0, $5 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11576 | 0) >> 2] = wasm2js_i32$1;
      break label$120;
     }
     HEAP32[($10 + ((HEAP32[($10 + 16 | 0) >> 2] | 0 | 0) == ($6 | 0) ? 16 : 20) | 0) >> 2] = $8;
     if (!$8) {
      break label$120
     }
    }
    HEAP32[($8 + 24 | 0) >> 2] = $10;
    label$123 : {
     $0 = HEAP32[($6 + 16 | 0) >> 2] | 0;
     if (!$0) {
      break label$123
     }
     HEAP32[($8 + 16 | 0) >> 2] = $0;
     HEAP32[($0 + 24 | 0) >> 2] = $8;
    }
    $0 = HEAP32[($6 + 20 | 0) >> 2] | 0;
    if (!$0) {
     break label$120
    }
    HEAP32[($8 + 20 | 0) >> 2] = $0;
    HEAP32[($0 + 24 | 0) >> 2] = $8;
   }
   label$124 : {
    label$125 : {
     if ($4 >>> 0 > 15 >>> 0) {
      break label$125
     }
     $0 = $4 + $3 | 0;
     HEAP32[($6 + 4 | 0) >> 2] = $0 | 3 | 0;
     $0 = $6 + $0 | 0;
     HEAP32[($0 + 4 | 0) >> 2] = HEAP32[($0 + 4 | 0) >> 2] | 0 | 1 | 0;
     break label$124;
    }
    HEAP32[($6 + 4 | 0) >> 2] = $3 | 3 | 0;
    $5 = $6 + $3 | 0;
    HEAP32[($5 + 4 | 0) >> 2] = $4 | 1 | 0;
    HEAP32[($5 + $4 | 0) >> 2] = $4;
    label$126 : {
     if (!$7) {
      break label$126
     }
     $8 = $7 >>> 3 | 0;
     $3 = ($8 << 3 | 0) + 11612 | 0;
     $0 = HEAP32[(0 + 11592 | 0) >> 2] | 0;
     label$127 : {
      label$128 : {
       $8 = 1 << $8 | 0;
       if ($8 & $2 | 0) {
        break label$128
       }
       HEAP32[(0 + 11572 | 0) >> 2] = $8 | $2 | 0;
       $8 = $3;
       break label$127;
      }
      $8 = HEAP32[($3 + 8 | 0) >> 2] | 0;
     }
     HEAP32[($3 + 8 | 0) >> 2] = $0;
     HEAP32[($8 + 12 | 0) >> 2] = $0;
     HEAP32[($0 + 12 | 0) >> 2] = $3;
     HEAP32[($0 + 8 | 0) >> 2] = $8;
    }
    HEAP32[(0 + 11592 | 0) >> 2] = $5;
    HEAP32[(0 + 11580 | 0) >> 2] = $4;
   }
   $0 = $6 + 8 | 0;
  }
  __stack_pointer = $1 + 16 | 0;
  return $0 | 0;
 }
 
 function dlfree($0) {
  $0 = $0 | 0;
  var $2 = 0, $6 = 0, $1 = 0, $4 = 0, $3 = 0, $5 = 0, $7 = 0, $379 = 0, $386 = 0, $393 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $1 = $0 + -8 | 0;
   $2 = HEAP32[($0 + -4 | 0) >> 2] | 0;
   $0 = $2 & -8 | 0;
   $3 = $1 + $0 | 0;
   label$2 : {
    if ($2 & 1 | 0) {
     break label$2
    }
    if (!($2 & 3 | 0)) {
     break label$1
    }
    $2 = HEAP32[$1 >> 2] | 0;
    $1 = $1 - $2 | 0;
    $4 = HEAP32[(0 + 11588 | 0) >> 2] | 0;
    if ($1 >>> 0 < $4 >>> 0) {
     break label$1
    }
    $0 = $2 + $0 | 0;
    label$3 : {
     if ((HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0) == ($1 | 0)) {
      break label$3
     }
     label$4 : {
      if ($2 >>> 0 > 255 >>> 0) {
       break label$4
      }
      $4 = HEAP32[($1 + 8 | 0) >> 2] | 0;
      $5 = $2 >>> 3 | 0;
      $6 = ($5 << 3 | 0) + 11612 | 0;
      label$5 : {
       $2 = HEAP32[($1 + 12 | 0) >> 2] | 0;
       if (($2 | 0) != ($4 | 0)) {
        break label$5
       }
       (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11572 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $5 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11572 | 0) >> 2] = wasm2js_i32$1;
       break label$2;
      }
      HEAP32[($4 + 12 | 0) >> 2] = $2;
      HEAP32[($2 + 8 | 0) >> 2] = $4;
      break label$2;
     }
     $7 = HEAP32[($1 + 24 | 0) >> 2] | 0;
     label$6 : {
      label$7 : {
       $6 = HEAP32[($1 + 12 | 0) >> 2] | 0;
       if (($6 | 0) == ($1 | 0)) {
        break label$7
       }
       $2 = HEAP32[($1 + 8 | 0) >> 2] | 0;
       HEAP32[($2 + 12 | 0) >> 2] = $6;
       HEAP32[($6 + 8 | 0) >> 2] = $2;
       break label$6;
      }
      label$8 : {
       $2 = $1 + 20 | 0;
       $4 = HEAP32[$2 >> 2] | 0;
       if ($4) {
        break label$8
       }
       $2 = $1 + 16 | 0;
       $4 = HEAP32[$2 >> 2] | 0;
       if ($4) {
        break label$8
       }
       $6 = 0;
       break label$6;
      }
      label$9 : while (1) {
       $5 = $2;
       $6 = $4;
       $2 = $6 + 20 | 0;
       $4 = HEAP32[$2 >> 2] | 0;
       if ($4) {
        continue label$9
       }
       $2 = $6 + 16 | 0;
       $4 = HEAP32[($6 + 16 | 0) >> 2] | 0;
       if ($4) {
        continue label$9
       }
       break label$9;
      };
      HEAP32[$5 >> 2] = 0;
     }
     if (!$7) {
      break label$2
     }
     label$10 : {
      label$11 : {
       $4 = HEAP32[($1 + 28 | 0) >> 2] | 0;
       $2 = ($4 << 2 | 0) + 11876 | 0;
       if ((HEAP32[$2 >> 2] | 0 | 0) != ($1 | 0)) {
        break label$11
       }
       HEAP32[$2 >> 2] = $6;
       if ($6) {
        break label$10
       }
       (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11576 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $4 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11576 | 0) >> 2] = wasm2js_i32$1;
       break label$2;
      }
      HEAP32[($7 + ((HEAP32[($7 + 16 | 0) >> 2] | 0 | 0) == ($1 | 0) ? 16 : 20) | 0) >> 2] = $6;
      if (!$6) {
       break label$2
      }
     }
     HEAP32[($6 + 24 | 0) >> 2] = $7;
     label$12 : {
      $2 = HEAP32[($1 + 16 | 0) >> 2] | 0;
      if (!$2) {
       break label$12
      }
      HEAP32[($6 + 16 | 0) >> 2] = $2;
      HEAP32[($2 + 24 | 0) >> 2] = $6;
     }
     $2 = HEAP32[($1 + 20 | 0) >> 2] | 0;
     if (!$2) {
      break label$2
     }
     HEAP32[($6 + 20 | 0) >> 2] = $2;
     HEAP32[($2 + 24 | 0) >> 2] = $6;
     break label$2;
    }
    $2 = HEAP32[($3 + 4 | 0) >> 2] | 0;
    if (($2 & 3 | 0 | 0) != (3 | 0)) {
     break label$2
    }
    HEAP32[(0 + 11580 | 0) >> 2] = $0;
    HEAP32[($3 + 4 | 0) >> 2] = $2 & -2 | 0;
    HEAP32[($1 + 4 | 0) >> 2] = $0 | 1 | 0;
    HEAP32[($1 + $0 | 0) >> 2] = $0;
    return;
   }
   if ($3 >>> 0 <= $1 >>> 0) {
    break label$1
   }
   $2 = HEAP32[($3 + 4 | 0) >> 2] | 0;
   if (!($2 & 1 | 0)) {
    break label$1
   }
   label$13 : {
    label$14 : {
     if ($2 & 2 | 0) {
      break label$14
     }
     label$15 : {
      if ((HEAP32[(0 + 11596 | 0) >> 2] | 0 | 0) != ($3 | 0)) {
       break label$15
      }
      HEAP32[(0 + 11596 | 0) >> 2] = $1;
      $0 = (HEAP32[(0 + 11584 | 0) >> 2] | 0) + $0 | 0;
      HEAP32[(0 + 11584 | 0) >> 2] = $0;
      HEAP32[($1 + 4 | 0) >> 2] = $0 | 1 | 0;
      if (($1 | 0) != (HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0)) {
       break label$1
      }
      HEAP32[(0 + 11580 | 0) >> 2] = 0;
      HEAP32[(0 + 11592 | 0) >> 2] = 0;
      return;
     }
     label$16 : {
      if ((HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0) != ($3 | 0)) {
       break label$16
      }
      HEAP32[(0 + 11592 | 0) >> 2] = $1;
      $0 = (HEAP32[(0 + 11580 | 0) >> 2] | 0) + $0 | 0;
      HEAP32[(0 + 11580 | 0) >> 2] = $0;
      HEAP32[($1 + 4 | 0) >> 2] = $0 | 1 | 0;
      HEAP32[($1 + $0 | 0) >> 2] = $0;
      return;
     }
     $0 = ($2 & -8 | 0) + $0 | 0;
     label$17 : {
      label$18 : {
       if ($2 >>> 0 > 255 >>> 0) {
        break label$18
       }
       $4 = HEAP32[($3 + 8 | 0) >> 2] | 0;
       $5 = $2 >>> 3 | 0;
       $6 = ($5 << 3 | 0) + 11612 | 0;
       label$19 : {
        $2 = HEAP32[($3 + 12 | 0) >> 2] | 0;
        if (($2 | 0) != ($4 | 0)) {
         break label$19
        }
        (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11572 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $5 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11572 | 0) >> 2] = wasm2js_i32$1;
        break label$17;
       }
       HEAP32[($4 + 12 | 0) >> 2] = $2;
       HEAP32[($2 + 8 | 0) >> 2] = $4;
       break label$17;
      }
      $7 = HEAP32[($3 + 24 | 0) >> 2] | 0;
      label$20 : {
       label$21 : {
        $6 = HEAP32[($3 + 12 | 0) >> 2] | 0;
        if (($6 | 0) == ($3 | 0)) {
         break label$21
        }
        $2 = HEAP32[($3 + 8 | 0) >> 2] | 0;
        HEAP32[(0 + 11588 | 0) >> 2] | 0;
        HEAP32[($2 + 12 | 0) >> 2] = $6;
        HEAP32[($6 + 8 | 0) >> 2] = $2;
        break label$20;
       }
       label$22 : {
        $2 = $3 + 20 | 0;
        $4 = HEAP32[$2 >> 2] | 0;
        if ($4) {
         break label$22
        }
        $2 = $3 + 16 | 0;
        $4 = HEAP32[$2 >> 2] | 0;
        if ($4) {
         break label$22
        }
        $6 = 0;
        break label$20;
       }
       label$23 : while (1) {
        $5 = $2;
        $6 = $4;
        $2 = $6 + 20 | 0;
        $4 = HEAP32[$2 >> 2] | 0;
        if ($4) {
         continue label$23
        }
        $2 = $6 + 16 | 0;
        $4 = HEAP32[($6 + 16 | 0) >> 2] | 0;
        if ($4) {
         continue label$23
        }
        break label$23;
       };
       HEAP32[$5 >> 2] = 0;
      }
      if (!$7) {
       break label$17
      }
      label$24 : {
       label$25 : {
        $4 = HEAP32[($3 + 28 | 0) >> 2] | 0;
        $2 = ($4 << 2 | 0) + 11876 | 0;
        if ((HEAP32[$2 >> 2] | 0 | 0) != ($3 | 0)) {
         break label$25
        }
        HEAP32[$2 >> 2] = $6;
        if ($6) {
         break label$24
        }
        (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11576 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $4 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11576 | 0) >> 2] = wasm2js_i32$1;
        break label$17;
       }
       HEAP32[($7 + ((HEAP32[($7 + 16 | 0) >> 2] | 0 | 0) == ($3 | 0) ? 16 : 20) | 0) >> 2] = $6;
       if (!$6) {
        break label$17
       }
      }
      HEAP32[($6 + 24 | 0) >> 2] = $7;
      label$26 : {
       $2 = HEAP32[($3 + 16 | 0) >> 2] | 0;
       if (!$2) {
        break label$26
       }
       HEAP32[($6 + 16 | 0) >> 2] = $2;
       HEAP32[($2 + 24 | 0) >> 2] = $6;
      }
      $2 = HEAP32[($3 + 20 | 0) >> 2] | 0;
      if (!$2) {
       break label$17
      }
      HEAP32[($6 + 20 | 0) >> 2] = $2;
      HEAP32[($2 + 24 | 0) >> 2] = $6;
     }
     HEAP32[($1 + 4 | 0) >> 2] = $0 | 1 | 0;
     HEAP32[($1 + $0 | 0) >> 2] = $0;
     if (($1 | 0) != (HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0)) {
      break label$13
     }
     HEAP32[(0 + 11580 | 0) >> 2] = $0;
     return;
    }
    HEAP32[($3 + 4 | 0) >> 2] = $2 & -2 | 0;
    HEAP32[($1 + 4 | 0) >> 2] = $0 | 1 | 0;
    HEAP32[($1 + $0 | 0) >> 2] = $0;
   }
   label$27 : {
    if ($0 >>> 0 > 255 >>> 0) {
     break label$27
    }
    $2 = $0 >>> 3 | 0;
    $0 = ($2 << 3 | 0) + 11612 | 0;
    label$28 : {
     label$29 : {
      $4 = HEAP32[(0 + 11572 | 0) >> 2] | 0;
      $2 = 1 << $2 | 0;
      if ($4 & $2 | 0) {
       break label$29
      }
      HEAP32[(0 + 11572 | 0) >> 2] = $4 | $2 | 0;
      $2 = $0;
      break label$28;
     }
     $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    }
    HEAP32[($0 + 8 | 0) >> 2] = $1;
    HEAP32[($2 + 12 | 0) >> 2] = $1;
    HEAP32[($1 + 12 | 0) >> 2] = $0;
    HEAP32[($1 + 8 | 0) >> 2] = $2;
    return;
   }
   $2 = 31;
   label$30 : {
    if ($0 >>> 0 > 16777215 >>> 0) {
     break label$30
    }
    $2 = $0 >>> 8 | 0;
    $379 = $2;
    $2 = (($2 + 1048320 | 0) >>> 16 | 0) & 8 | 0;
    $4 = $379 << $2 | 0;
    $386 = $4;
    $4 = (($4 + 520192 | 0) >>> 16 | 0) & 4 | 0;
    $6 = $386 << $4 | 0;
    $393 = $6;
    $6 = (($6 + 245760 | 0) >>> 16 | 0) & 2 | 0;
    $2 = (($393 << $6 | 0) >>> 15 | 0) - ($2 | $4 | 0 | $6 | 0) | 0;
    $2 = ($2 << 1 | 0 | (($0 >>> ($2 + 21 | 0) | 0) & 1 | 0) | 0) + 28 | 0;
   }
   HEAP32[($1 + 16 | 0) >> 2] = 0;
   HEAP32[($1 + 20 | 0) >> 2] = 0;
   HEAP32[($1 + 28 | 0) >> 2] = $2;
   $4 = ($2 << 2 | 0) + 11876 | 0;
   label$31 : {
    label$32 : {
     label$33 : {
      label$34 : {
       $6 = HEAP32[(0 + 11576 | 0) >> 2] | 0;
       $3 = 1 << $2 | 0;
       if ($6 & $3 | 0) {
        break label$34
       }
       HEAP32[(0 + 11576 | 0) >> 2] = $6 | $3 | 0;
       HEAP32[$4 >> 2] = $1;
       HEAP32[($1 + 24 | 0) >> 2] = $4;
       break label$33;
      }
      $2 = $0 << (($2 | 0) == (31 | 0) ? 0 : 25 - ($2 >>> 1 | 0) | 0) | 0;
      $6 = HEAP32[$4 >> 2] | 0;
      label$35 : while (1) {
       $4 = $6;
       if (((HEAP32[($6 + 4 | 0) >> 2] | 0) & -8 | 0 | 0) == ($0 | 0)) {
        break label$32
       }
       $6 = $2 >>> 29 | 0;
       $2 = $2 << 1 | 0;
       $3 = ($4 + ($6 & 4 | 0) | 0) + 16 | 0;
       $6 = HEAP32[$3 >> 2] | 0;
       if ($6) {
        continue label$35
       }
       break label$35;
      };
      HEAP32[$3 >> 2] = $1;
      HEAP32[($1 + 24 | 0) >> 2] = $4;
     }
     HEAP32[($1 + 12 | 0) >> 2] = $1;
     HEAP32[($1 + 8 | 0) >> 2] = $1;
     break label$31;
    }
    $0 = HEAP32[($4 + 8 | 0) >> 2] | 0;
    HEAP32[($0 + 12 | 0) >> 2] = $1;
    HEAP32[($4 + 8 | 0) >> 2] = $1;
    HEAP32[($1 + 24 | 0) >> 2] = 0;
    HEAP32[($1 + 12 | 0) >> 2] = $4;
    HEAP32[($1 + 8 | 0) >> 2] = $0;
   }
   $1 = (HEAP32[(0 + 11604 | 0) >> 2] | 0) + -1 | 0;
   HEAP32[(0 + 11604 | 0) >> 2] = $1 ? $1 : -1;
  }
 }
 
 function dlcalloc($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, $2 = 0, i64toi32_i32$4 = 0, i64toi32_i32$3 = 0, $13 = 0, $6$hi = 0, $8$hi = 0, $3 = 0, $3$hi = 0, $16 = 0, i64toi32_i32$2 = 0;
  label$1 : {
   label$2 : {
    if ($0) {
     break label$2
    }
    $2 = 0;
    break label$1;
   }
   i64toi32_i32$0 = 0;
   $6$hi = i64toi32_i32$0;
   i64toi32_i32$0 = 0;
   $8$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $6$hi;
   i64toi32_i32$1 = $8$hi;
   i64toi32_i32$1 = __wasm_i64_mul($0 | 0, i64toi32_i32$0 | 0, $1 | 0, i64toi32_i32$1 | 0) | 0;
   i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
   $3 = i64toi32_i32$1;
   $3$hi = i64toi32_i32$0;
   $2 = i64toi32_i32$1;
   if (($1 | $0 | 0) >>> 0 < 65536 >>> 0) {
    break label$1
   }
   $16 = $2;
   i64toi32_i32$0 = $3$hi;
   i64toi32_i32$2 = $3;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 32;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$1 = 0;
    $13 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
    $13 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
   }
   $2 = ($13 | 0) != (0 | 0) ? -1 : $16;
  }
  label$3 : {
   $0 = dlmalloc($2 | 0) | 0;
   if (!$0) {
    break label$3
   }
   if (!((HEAPU8[($0 + -4 | 0) >> 0] | 0) & 3 | 0)) {
    break label$3
   }
   memset($0 | 0, 0 | 0, $2 | 0) | 0;
  }
  return $0 | 0;
 }
 
 function dlrealloc($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  label$1 : {
   if ($0) {
    break label$1
   }
   return dlmalloc($1 | 0) | 0 | 0;
  }
  label$2 : {
   if ($1 >>> 0 < -64 >>> 0) {
    break label$2
   }
   (wasm2js_i32$0 = __errno_location() | 0, wasm2js_i32$1 = 48), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
   return 0 | 0;
  }
  label$3 : {
   $2 = try_realloc_chunk($0 + -8 | 0 | 0, ($1 >>> 0 < 11 >>> 0 ? 16 : ($1 + 11 | 0) & -8 | 0) | 0) | 0;
   if (!$2) {
    break label$3
   }
   return $2 + 8 | 0 | 0;
  }
  label$4 : {
   $2 = dlmalloc($1 | 0) | 0;
   if ($2) {
    break label$4
   }
   return 0 | 0;
  }
  $3 = HEAP32[($0 + -4 | 0) >> 2] | 0;
  $3 = ($3 & 3 | 0 ? -4 : -8) + ($3 & -8 | 0) | 0;
  __memcpy($2 | 0, $0 | 0, ($3 >>> 0 < $1 >>> 0 ? $3 : $1) | 0) | 0;
  dlfree($0 | 0);
  return $2 | 0;
 }
 
 function try_realloc_chunk($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $4 = 0, $6 = 0, $5 = 0, $2 = 0, $7 = 0, $9 = 0, $10 = 0, $8 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
  $3 = $2 & -8 | 0;
  label$1 : {
   label$2 : {
    if ($2 & 3 | 0) {
     break label$2
    }
    label$3 : {
     if ($1 >>> 0 >= 256 >>> 0) {
      break label$3
     }
     return 0 | 0;
    }
    label$4 : {
     if ($3 >>> 0 < ($1 + 4 | 0) >>> 0) {
      break label$4
     }
     $4 = $0;
     if (($3 - $1 | 0) >>> 0 <= ((HEAP32[(0 + 12052 | 0) >> 2] | 0) << 1 | 0) >>> 0) {
      break label$1
     }
    }
    return 0 | 0;
   }
   $5 = $0 + $3 | 0;
   label$5 : {
    label$6 : {
     if ($3 >>> 0 < $1 >>> 0) {
      break label$6
     }
     $3 = $3 - $1 | 0;
     if ($3 >>> 0 < 16 >>> 0) {
      break label$5
     }
     HEAP32[($0 + 4 | 0) >> 2] = $2 & 1 | 0 | $1 | 0 | 2 | 0;
     $1 = $0 + $1 | 0;
     HEAP32[($1 + 4 | 0) >> 2] = $3 | 3 | 0;
     HEAP32[($5 + 4 | 0) >> 2] = HEAP32[($5 + 4 | 0) >> 2] | 0 | 1 | 0;
     dispose_chunk($1 | 0, $3 | 0);
     break label$5;
    }
    $4 = 0;
    label$7 : {
     if ((HEAP32[(0 + 11596 | 0) >> 2] | 0 | 0) != ($5 | 0)) {
      break label$7
     }
     $3 = (HEAP32[(0 + 11584 | 0) >> 2] | 0) + $3 | 0;
     if ($3 >>> 0 <= $1 >>> 0) {
      break label$1
     }
     HEAP32[($0 + 4 | 0) >> 2] = $2 & 1 | 0 | $1 | 0 | 2 | 0;
     $2 = $0 + $1 | 0;
     $1 = $3 - $1 | 0;
     HEAP32[($2 + 4 | 0) >> 2] = $1 | 1 | 0;
     HEAP32[(0 + 11584 | 0) >> 2] = $1;
     HEAP32[(0 + 11596 | 0) >> 2] = $2;
     break label$5;
    }
    label$8 : {
     if ((HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0) != ($5 | 0)) {
      break label$8
     }
     $4 = 0;
     $3 = (HEAP32[(0 + 11580 | 0) >> 2] | 0) + $3 | 0;
     if ($3 >>> 0 < $1 >>> 0) {
      break label$1
     }
     label$9 : {
      label$10 : {
       $4 = $3 - $1 | 0;
       if ($4 >>> 0 < 16 >>> 0) {
        break label$10
       }
       HEAP32[($0 + 4 | 0) >> 2] = $2 & 1 | 0 | $1 | 0 | 2 | 0;
       $1 = $0 + $1 | 0;
       HEAP32[($1 + 4 | 0) >> 2] = $4 | 1 | 0;
       $3 = $0 + $3 | 0;
       HEAP32[$3 >> 2] = $4;
       HEAP32[($3 + 4 | 0) >> 2] = (HEAP32[($3 + 4 | 0) >> 2] | 0) & -2 | 0;
       break label$9;
      }
      HEAP32[($0 + 4 | 0) >> 2] = $2 & 1 | 0 | $3 | 0 | 2 | 0;
      $1 = $0 + $3 | 0;
      HEAP32[($1 + 4 | 0) >> 2] = HEAP32[($1 + 4 | 0) >> 2] | 0 | 1 | 0;
      $4 = 0;
      $1 = 0;
     }
     HEAP32[(0 + 11592 | 0) >> 2] = $1;
     HEAP32[(0 + 11580 | 0) >> 2] = $4;
     break label$5;
    }
    $4 = 0;
    $6 = HEAP32[($5 + 4 | 0) >> 2] | 0;
    if ($6 & 2 | 0) {
     break label$1
    }
    $7 = ($6 & -8 | 0) + $3 | 0;
    if ($7 >>> 0 < $1 >>> 0) {
     break label$1
    }
    $8 = $7 - $1 | 0;
    label$11 : {
     label$12 : {
      if ($6 >>> 0 > 255 >>> 0) {
       break label$12
      }
      $3 = HEAP32[($5 + 8 | 0) >> 2] | 0;
      $9 = $6 >>> 3 | 0;
      $6 = ($9 << 3 | 0) + 11612 | 0;
      label$13 : {
       $4 = HEAP32[($5 + 12 | 0) >> 2] | 0;
       if (($4 | 0) != ($3 | 0)) {
        break label$13
       }
       (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11572 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $9 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11572 | 0) >> 2] = wasm2js_i32$1;
       break label$11;
      }
      HEAP32[($3 + 12 | 0) >> 2] = $4;
      HEAP32[($4 + 8 | 0) >> 2] = $3;
      break label$11;
     }
     $10 = HEAP32[($5 + 24 | 0) >> 2] | 0;
     label$14 : {
      label$15 : {
       $6 = HEAP32[($5 + 12 | 0) >> 2] | 0;
       if (($6 | 0) == ($5 | 0)) {
        break label$15
       }
       $3 = HEAP32[($5 + 8 | 0) >> 2] | 0;
       HEAP32[(0 + 11588 | 0) >> 2] | 0;
       HEAP32[($3 + 12 | 0) >> 2] = $6;
       HEAP32[($6 + 8 | 0) >> 2] = $3;
       break label$14;
      }
      label$16 : {
       $3 = $5 + 20 | 0;
       $4 = HEAP32[$3 >> 2] | 0;
       if ($4) {
        break label$16
       }
       $3 = $5 + 16 | 0;
       $4 = HEAP32[$3 >> 2] | 0;
       if ($4) {
        break label$16
       }
       $6 = 0;
       break label$14;
      }
      label$17 : while (1) {
       $9 = $3;
       $6 = $4;
       $3 = $6 + 20 | 0;
       $4 = HEAP32[$3 >> 2] | 0;
       if ($4) {
        continue label$17
       }
       $3 = $6 + 16 | 0;
       $4 = HEAP32[($6 + 16 | 0) >> 2] | 0;
       if ($4) {
        continue label$17
       }
       break label$17;
      };
      HEAP32[$9 >> 2] = 0;
     }
     if (!$10) {
      break label$11
     }
     label$18 : {
      label$19 : {
       $4 = HEAP32[($5 + 28 | 0) >> 2] | 0;
       $3 = ($4 << 2 | 0) + 11876 | 0;
       if ((HEAP32[$3 >> 2] | 0 | 0) != ($5 | 0)) {
        break label$19
       }
       HEAP32[$3 >> 2] = $6;
       if ($6) {
        break label$18
       }
       (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11576 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $4 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11576 | 0) >> 2] = wasm2js_i32$1;
       break label$11;
      }
      HEAP32[($10 + ((HEAP32[($10 + 16 | 0) >> 2] | 0 | 0) == ($5 | 0) ? 16 : 20) | 0) >> 2] = $6;
      if (!$6) {
       break label$11
      }
     }
     HEAP32[($6 + 24 | 0) >> 2] = $10;
     label$20 : {
      $3 = HEAP32[($5 + 16 | 0) >> 2] | 0;
      if (!$3) {
       break label$20
      }
      HEAP32[($6 + 16 | 0) >> 2] = $3;
      HEAP32[($3 + 24 | 0) >> 2] = $6;
     }
     $3 = HEAP32[($5 + 20 | 0) >> 2] | 0;
     if (!$3) {
      break label$11
     }
     HEAP32[($6 + 20 | 0) >> 2] = $3;
     HEAP32[($3 + 24 | 0) >> 2] = $6;
    }
    label$21 : {
     if ($8 >>> 0 > 15 >>> 0) {
      break label$21
     }
     HEAP32[($0 + 4 | 0) >> 2] = $2 & 1 | 0 | $7 | 0 | 2 | 0;
     $1 = $0 + $7 | 0;
     HEAP32[($1 + 4 | 0) >> 2] = HEAP32[($1 + 4 | 0) >> 2] | 0 | 1 | 0;
     break label$5;
    }
    HEAP32[($0 + 4 | 0) >> 2] = $2 & 1 | 0 | $1 | 0 | 2 | 0;
    $1 = $0 + $1 | 0;
    HEAP32[($1 + 4 | 0) >> 2] = $8 | 3 | 0;
    $3 = $0 + $7 | 0;
    HEAP32[($3 + 4 | 0) >> 2] = HEAP32[($3 + 4 | 0) >> 2] | 0 | 1 | 0;
    dispose_chunk($1 | 0, $8 | 0);
   }
   $4 = $0;
  }
  return $4 | 0;
 }
 
 function dispose_chunk($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $6 = 0, $4 = 0, $2 = 0, $5 = 0, $7 = 0, $360 = 0, $367 = 0, $374 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $2 = $0 + $1 | 0;
  label$1 : {
   label$2 : {
    $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    if ($3 & 1 | 0) {
     break label$2
    }
    if (!($3 & 3 | 0)) {
     break label$1
    }
    $3 = HEAP32[$0 >> 2] | 0;
    $1 = $3 + $1 | 0;
    label$3 : {
     label$4 : {
      $0 = $0 - $3 | 0;
      if ((HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0) == ($0 | 0)) {
       break label$4
      }
      label$5 : {
       if ($3 >>> 0 > 255 >>> 0) {
        break label$5
       }
       $4 = HEAP32[($0 + 8 | 0) >> 2] | 0;
       $5 = $3 >>> 3 | 0;
       $6 = ($5 << 3 | 0) + 11612 | 0;
       $3 = HEAP32[($0 + 12 | 0) >> 2] | 0;
       if (($3 | 0) != ($4 | 0)) {
        break label$3
       }
       (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11572 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $5 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11572 | 0) >> 2] = wasm2js_i32$1;
       break label$2;
      }
      $7 = HEAP32[($0 + 24 | 0) >> 2] | 0;
      label$6 : {
       label$7 : {
        $6 = HEAP32[($0 + 12 | 0) >> 2] | 0;
        if (($6 | 0) == ($0 | 0)) {
         break label$7
        }
        $3 = HEAP32[($0 + 8 | 0) >> 2] | 0;
        HEAP32[(0 + 11588 | 0) >> 2] | 0;
        HEAP32[($3 + 12 | 0) >> 2] = $6;
        HEAP32[($6 + 8 | 0) >> 2] = $3;
        break label$6;
       }
       label$8 : {
        $3 = $0 + 20 | 0;
        $4 = HEAP32[$3 >> 2] | 0;
        if ($4) {
         break label$8
        }
        $3 = $0 + 16 | 0;
        $4 = HEAP32[$3 >> 2] | 0;
        if ($4) {
         break label$8
        }
        $6 = 0;
        break label$6;
       }
       label$9 : while (1) {
        $5 = $3;
        $6 = $4;
        $3 = $6 + 20 | 0;
        $4 = HEAP32[$3 >> 2] | 0;
        if ($4) {
         continue label$9
        }
        $3 = $6 + 16 | 0;
        $4 = HEAP32[($6 + 16 | 0) >> 2] | 0;
        if ($4) {
         continue label$9
        }
        break label$9;
       };
       HEAP32[$5 >> 2] = 0;
      }
      if (!$7) {
       break label$2
      }
      label$10 : {
       label$11 : {
        $4 = HEAP32[($0 + 28 | 0) >> 2] | 0;
        $3 = ($4 << 2 | 0) + 11876 | 0;
        if ((HEAP32[$3 >> 2] | 0 | 0) != ($0 | 0)) {
         break label$11
        }
        HEAP32[$3 >> 2] = $6;
        if ($6) {
         break label$10
        }
        (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11576 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $4 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11576 | 0) >> 2] = wasm2js_i32$1;
        break label$2;
       }
       HEAP32[($7 + ((HEAP32[($7 + 16 | 0) >> 2] | 0 | 0) == ($0 | 0) ? 16 : 20) | 0) >> 2] = $6;
       if (!$6) {
        break label$2
       }
      }
      HEAP32[($6 + 24 | 0) >> 2] = $7;
      label$12 : {
       $3 = HEAP32[($0 + 16 | 0) >> 2] | 0;
       if (!$3) {
        break label$12
       }
       HEAP32[($6 + 16 | 0) >> 2] = $3;
       HEAP32[($3 + 24 | 0) >> 2] = $6;
      }
      $3 = HEAP32[($0 + 20 | 0) >> 2] | 0;
      if (!$3) {
       break label$2
      }
      HEAP32[($6 + 20 | 0) >> 2] = $3;
      HEAP32[($3 + 24 | 0) >> 2] = $6;
      break label$2;
     }
     $3 = HEAP32[($2 + 4 | 0) >> 2] | 0;
     if (($3 & 3 | 0 | 0) != (3 | 0)) {
      break label$2
     }
     HEAP32[(0 + 11580 | 0) >> 2] = $1;
     HEAP32[($2 + 4 | 0) >> 2] = $3 & -2 | 0;
     HEAP32[($0 + 4 | 0) >> 2] = $1 | 1 | 0;
     HEAP32[$2 >> 2] = $1;
     return;
    }
    HEAP32[($4 + 12 | 0) >> 2] = $3;
    HEAP32[($3 + 8 | 0) >> 2] = $4;
   }
   label$13 : {
    label$14 : {
     $3 = HEAP32[($2 + 4 | 0) >> 2] | 0;
     if ($3 & 2 | 0) {
      break label$14
     }
     label$15 : {
      if ((HEAP32[(0 + 11596 | 0) >> 2] | 0 | 0) != ($2 | 0)) {
       break label$15
      }
      HEAP32[(0 + 11596 | 0) >> 2] = $0;
      $1 = (HEAP32[(0 + 11584 | 0) >> 2] | 0) + $1 | 0;
      HEAP32[(0 + 11584 | 0) >> 2] = $1;
      HEAP32[($0 + 4 | 0) >> 2] = $1 | 1 | 0;
      if (($0 | 0) != (HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0)) {
       break label$1
      }
      HEAP32[(0 + 11580 | 0) >> 2] = 0;
      HEAP32[(0 + 11592 | 0) >> 2] = 0;
      return;
     }
     label$16 : {
      if ((HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0) != ($2 | 0)) {
       break label$16
      }
      HEAP32[(0 + 11592 | 0) >> 2] = $0;
      $1 = (HEAP32[(0 + 11580 | 0) >> 2] | 0) + $1 | 0;
      HEAP32[(0 + 11580 | 0) >> 2] = $1;
      HEAP32[($0 + 4 | 0) >> 2] = $1 | 1 | 0;
      HEAP32[($0 + $1 | 0) >> 2] = $1;
      return;
     }
     $1 = ($3 & -8 | 0) + $1 | 0;
     label$17 : {
      label$18 : {
       if ($3 >>> 0 > 255 >>> 0) {
        break label$18
       }
       $4 = HEAP32[($2 + 8 | 0) >> 2] | 0;
       $5 = $3 >>> 3 | 0;
       $6 = ($5 << 3 | 0) + 11612 | 0;
       label$19 : {
        $3 = HEAP32[($2 + 12 | 0) >> 2] | 0;
        if (($3 | 0) != ($4 | 0)) {
         break label$19
        }
        (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11572 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $5 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11572 | 0) >> 2] = wasm2js_i32$1;
        break label$17;
       }
       HEAP32[($4 + 12 | 0) >> 2] = $3;
       HEAP32[($3 + 8 | 0) >> 2] = $4;
       break label$17;
      }
      $7 = HEAP32[($2 + 24 | 0) >> 2] | 0;
      label$20 : {
       label$21 : {
        $6 = HEAP32[($2 + 12 | 0) >> 2] | 0;
        if (($6 | 0) == ($2 | 0)) {
         break label$21
        }
        $3 = HEAP32[($2 + 8 | 0) >> 2] | 0;
        HEAP32[(0 + 11588 | 0) >> 2] | 0;
        HEAP32[($3 + 12 | 0) >> 2] = $6;
        HEAP32[($6 + 8 | 0) >> 2] = $3;
        break label$20;
       }
       label$22 : {
        $4 = $2 + 20 | 0;
        $3 = HEAP32[$4 >> 2] | 0;
        if ($3) {
         break label$22
        }
        $4 = $2 + 16 | 0;
        $3 = HEAP32[$4 >> 2] | 0;
        if ($3) {
         break label$22
        }
        $6 = 0;
        break label$20;
       }
       label$23 : while (1) {
        $5 = $4;
        $6 = $3;
        $4 = $3 + 20 | 0;
        $3 = HEAP32[$4 >> 2] | 0;
        if ($3) {
         continue label$23
        }
        $4 = $6 + 16 | 0;
        $3 = HEAP32[($6 + 16 | 0) >> 2] | 0;
        if ($3) {
         continue label$23
        }
        break label$23;
       };
       HEAP32[$5 >> 2] = 0;
      }
      if (!$7) {
       break label$17
      }
      label$24 : {
       label$25 : {
        $4 = HEAP32[($2 + 28 | 0) >> 2] | 0;
        $3 = ($4 << 2 | 0) + 11876 | 0;
        if ((HEAP32[$3 >> 2] | 0 | 0) != ($2 | 0)) {
         break label$25
        }
        HEAP32[$3 >> 2] = $6;
        if ($6) {
         break label$24
        }
        (wasm2js_i32$0 = 0, wasm2js_i32$1 = (HEAP32[(0 + 11576 | 0) >> 2] | 0) & (__wasm_rotl_i32(-2 | 0, $4 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 11576 | 0) >> 2] = wasm2js_i32$1;
        break label$17;
       }
       HEAP32[($7 + ((HEAP32[($7 + 16 | 0) >> 2] | 0 | 0) == ($2 | 0) ? 16 : 20) | 0) >> 2] = $6;
       if (!$6) {
        break label$17
       }
      }
      HEAP32[($6 + 24 | 0) >> 2] = $7;
      label$26 : {
       $3 = HEAP32[($2 + 16 | 0) >> 2] | 0;
       if (!$3) {
        break label$26
       }
       HEAP32[($6 + 16 | 0) >> 2] = $3;
       HEAP32[($3 + 24 | 0) >> 2] = $6;
      }
      $3 = HEAP32[($2 + 20 | 0) >> 2] | 0;
      if (!$3) {
       break label$17
      }
      HEAP32[($6 + 20 | 0) >> 2] = $3;
      HEAP32[($3 + 24 | 0) >> 2] = $6;
     }
     HEAP32[($0 + 4 | 0) >> 2] = $1 | 1 | 0;
     HEAP32[($0 + $1 | 0) >> 2] = $1;
     if (($0 | 0) != (HEAP32[(0 + 11592 | 0) >> 2] | 0 | 0)) {
      break label$13
     }
     HEAP32[(0 + 11580 | 0) >> 2] = $1;
     return;
    }
    HEAP32[($2 + 4 | 0) >> 2] = $3 & -2 | 0;
    HEAP32[($0 + 4 | 0) >> 2] = $1 | 1 | 0;
    HEAP32[($0 + $1 | 0) >> 2] = $1;
   }
   label$27 : {
    if ($1 >>> 0 > 255 >>> 0) {
     break label$27
    }
    $3 = $1 >>> 3 | 0;
    $1 = ($3 << 3 | 0) + 11612 | 0;
    label$28 : {
     label$29 : {
      $4 = HEAP32[(0 + 11572 | 0) >> 2] | 0;
      $3 = 1 << $3 | 0;
      if ($4 & $3 | 0) {
       break label$29
      }
      HEAP32[(0 + 11572 | 0) >> 2] = $4 | $3 | 0;
      $3 = $1;
      break label$28;
     }
     $3 = HEAP32[($1 + 8 | 0) >> 2] | 0;
    }
    HEAP32[($1 + 8 | 0) >> 2] = $0;
    HEAP32[($3 + 12 | 0) >> 2] = $0;
    HEAP32[($0 + 12 | 0) >> 2] = $1;
    HEAP32[($0 + 8 | 0) >> 2] = $3;
    return;
   }
   $3 = 31;
   label$30 : {
    if ($1 >>> 0 > 16777215 >>> 0) {
     break label$30
    }
    $3 = $1 >>> 8 | 0;
    $360 = $3;
    $3 = (($3 + 1048320 | 0) >>> 16 | 0) & 8 | 0;
    $4 = $360 << $3 | 0;
    $367 = $4;
    $4 = (($4 + 520192 | 0) >>> 16 | 0) & 4 | 0;
    $6 = $367 << $4 | 0;
    $374 = $6;
    $6 = (($6 + 245760 | 0) >>> 16 | 0) & 2 | 0;
    $3 = (($374 << $6 | 0) >>> 15 | 0) - ($3 | $4 | 0 | $6 | 0) | 0;
    $3 = ($3 << 1 | 0 | (($1 >>> ($3 + 21 | 0) | 0) & 1 | 0) | 0) + 28 | 0;
   }
   HEAP32[($0 + 16 | 0) >> 2] = 0;
   HEAP32[($0 + 20 | 0) >> 2] = 0;
   HEAP32[($0 + 28 | 0) >> 2] = $3;
   $4 = ($3 << 2 | 0) + 11876 | 0;
   label$31 : {
    label$32 : {
     label$33 : {
      $6 = HEAP32[(0 + 11576 | 0) >> 2] | 0;
      $2 = 1 << $3 | 0;
      if ($6 & $2 | 0) {
       break label$33
      }
      HEAP32[(0 + 11576 | 0) >> 2] = $6 | $2 | 0;
      HEAP32[$4 >> 2] = $0;
      HEAP32[($0 + 24 | 0) >> 2] = $4;
      break label$32;
     }
     $3 = $1 << (($3 | 0) == (31 | 0) ? 0 : 25 - ($3 >>> 1 | 0) | 0) | 0;
     $6 = HEAP32[$4 >> 2] | 0;
     label$34 : while (1) {
      $4 = $6;
      if (((HEAP32[($6 + 4 | 0) >> 2] | 0) & -8 | 0 | 0) == ($1 | 0)) {
       break label$31
      }
      $6 = $3 >>> 29 | 0;
      $3 = $3 << 1 | 0;
      $2 = ($4 + ($6 & 4 | 0) | 0) + 16 | 0;
      $6 = HEAP32[$2 >> 2] | 0;
      if ($6) {
       continue label$34
      }
      break label$34;
     };
     HEAP32[$2 >> 2] = $0;
     HEAP32[($0 + 24 | 0) >> 2] = $4;
    }
    HEAP32[($0 + 12 | 0) >> 2] = $0;
    HEAP32[($0 + 8 | 0) >> 2] = $0;
    return;
   }
   $1 = HEAP32[($4 + 8 | 0) >> 2] | 0;
   HEAP32[($1 + 12 | 0) >> 2] = $0;
   HEAP32[($4 + 8 | 0) >> 2] = $0;
   HEAP32[($0 + 24 | 0) >> 2] = 0;
   HEAP32[($0 + 12 | 0) >> 2] = $4;
   HEAP32[($0 + 8 | 0) >> 2] = $1;
  }
 }
 
 function __lock($0) {
  $0 = $0 | 0;
 }
 
 function __unlock($0) {
  $0 = $0 | 0;
 }
 
 function __ofl_lock() {
  __lock(12068 | 0);
  return 12076 | 0;
 }
 
 function __ofl_unlock() {
  __unlock(12068 | 0);
 }
 
 function __lockfile($0) {
  $0 = $0 | 0;
  return 1 | 0;
 }
 
 function __unlockfile($0) {
  $0 = $0 | 0;
 }
 
 function memchr($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0;
  $3 = ($2 | 0) != (0 | 0);
  label$1 : {
   label$2 : {
    label$3 : {
     if (!($0 & 3 | 0)) {
      break label$3
     }
     if (!$2) {
      break label$3
     }
     $4 = $1 & 255 | 0;
     label$4 : while (1) {
      if ((HEAPU8[$0 >> 0] | 0 | 0) == ($4 | 0)) {
       break label$2
      }
      $2 = $2 + -1 | 0;
      $3 = ($2 | 0) != (0 | 0);
      $0 = $0 + 1 | 0;
      if (!($0 & 3 | 0)) {
       break label$3
      }
      if ($2) {
       continue label$4
      }
      break label$4;
     };
    }
    if (!$3) {
     break label$1
    }
   }
   label$5 : {
    if ((HEAPU8[$0 >> 0] | 0 | 0) == ($1 & 255 | 0 | 0)) {
     break label$5
    }
    if ($2 >>> 0 < 4 >>> 0) {
     break label$5
    }
    $4 = Math_imul($1 & 255 | 0, 16843009);
    label$6 : while (1) {
     $3 = (HEAP32[$0 >> 2] | 0) ^ $4 | 0;
     if ((($3 ^ -1 | 0) & ($3 + -16843009 | 0) | 0) & -2139062144 | 0) {
      break label$5
     }
     $0 = $0 + 4 | 0;
     $2 = $2 + -4 | 0;
     if ($2 >>> 0 > 3 >>> 0) {
      continue label$6
     }
     break label$6;
    };
   }
   if (!$2) {
    break label$1
   }
   $3 = $1 & 255 | 0;
   label$7 : while (1) {
    label$8 : {
     if ((HEAPU8[$0 >> 0] | 0 | 0) != ($3 | 0)) {
      break label$8
     }
     return $0 | 0;
    }
    $0 = $0 + 1 | 0;
    $2 = $2 + -1 | 0;
    if ($2) {
     continue label$7
    }
    break label$7;
   };
  }
  return 0 | 0;
 }
 
 function frexp($0, $1) {
  $0 = +$0;
  $1 = $1 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, i64toi32_i32$3 = 0, $3 = 0, i64toi32_i32$2 = 0, i64toi32_i32$4 = 0, $2 = 0, $10 = 0, $2$hi = 0;
  label$1 : {
   wasm2js_scratch_store_f64(+$0);
   i64toi32_i32$0 = wasm2js_scratch_load_i32(1 | 0) | 0;
   $2 = wasm2js_scratch_load_i32(0 | 0) | 0;
   $2$hi = i64toi32_i32$0;
   i64toi32_i32$2 = $2;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 52;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$1 = 0;
    $10 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
    $10 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
   }
   $3 = $10 & 2047 | 0;
   if (($3 | 0) == (2047 | 0)) {
    break label$1
   }
   label$2 : {
    if ($3) {
     break label$2
    }
    label$3 : {
     label$4 : {
      if ($0 != 0.0) {
       break label$4
      }
      $3 = 0;
      break label$3;
     }
     $0 = +frexp(+($0 * 18446744073709551615.0), $1 | 0);
     $3 = (HEAP32[$1 >> 2] | 0) + -64 | 0;
    }
    HEAP32[$1 >> 2] = $3;
    return +$0;
   }
   HEAP32[$1 >> 2] = $3 + -1022 | 0;
   i64toi32_i32$1 = $2$hi;
   i64toi32_i32$0 = $2;
   i64toi32_i32$2 = -2146435073;
   i64toi32_i32$3 = -1;
   i64toi32_i32$2 = i64toi32_i32$1 & i64toi32_i32$2 | 0;
   i64toi32_i32$1 = i64toi32_i32$0 & i64toi32_i32$3 | 0;
   i64toi32_i32$0 = 1071644672;
   i64toi32_i32$3 = 0;
   i64toi32_i32$0 = i64toi32_i32$2 | i64toi32_i32$0 | 0;
   wasm2js_scratch_store_i32(0 | 0, i64toi32_i32$1 | i64toi32_i32$3 | 0 | 0);
   wasm2js_scratch_store_i32(1 | 0, i64toi32_i32$0 | 0);
   $0 = +wasm2js_scratch_load_f64();
  }
  return +$0;
 }
 
 function __ashlti3($0, $1, $1$hi, $2, $2$hi, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  $2 = $2 | 0;
  $2$hi = $2$hi | 0;
  $3 = $3 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$4 = 0, i64toi32_i32$2 = 0, i64toi32_i32$0 = 0, i64toi32_i32$3 = 0, $4$hi = 0, $18 = 0, $20 = 0, $21 = 0, $22 = 0, $11$hi = 0, $18$hi = 0, $19 = 0, $19$hi = 0, $4 = 0, $24$hi = 0;
  label$1 : {
   label$2 : {
    if (!($3 & 64 | 0)) {
     break label$2
    }
    i64toi32_i32$0 = $1$hi;
    i64toi32_i32$0 = 0;
    $11$hi = i64toi32_i32$0;
    i64toi32_i32$0 = $1$hi;
    i64toi32_i32$2 = $1;
    i64toi32_i32$1 = $11$hi;
    i64toi32_i32$3 = $3 + -64 | 0;
    i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     i64toi32_i32$1 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
     $18 = 0;
    } else {
     i64toi32_i32$1 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$2 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$0 << i64toi32_i32$4 | 0) | 0;
     $18 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
    }
    $2 = $18;
    $2$hi = i64toi32_i32$1;
    i64toi32_i32$1 = 0;
    $1 = 0;
    $1$hi = i64toi32_i32$1;
    break label$1;
   }
   if (!$3) {
    break label$1
   }
   i64toi32_i32$1 = $1$hi;
   i64toi32_i32$1 = 0;
   $18$hi = i64toi32_i32$1;
   i64toi32_i32$1 = $1$hi;
   i64toi32_i32$0 = $1;
   i64toi32_i32$2 = $18$hi;
   i64toi32_i32$3 = 64 - $3 | 0;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$2 = 0;
    $20 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$2 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    $20 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
   }
   $19 = $20;
   $19$hi = i64toi32_i32$2;
   i64toi32_i32$2 = $2$hi;
   i64toi32_i32$2 = 0;
   $4 = $3;
   $4$hi = i64toi32_i32$2;
   i64toi32_i32$2 = $2$hi;
   i64toi32_i32$1 = $2;
   i64toi32_i32$0 = $4$hi;
   i64toi32_i32$3 = $3;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$0 = i64toi32_i32$1 << i64toi32_i32$4 | 0;
    $21 = 0;
   } else {
    i64toi32_i32$0 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$1 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$2 << i64toi32_i32$4 | 0) | 0;
    $21 = i64toi32_i32$1 << i64toi32_i32$4 | 0;
   }
   $24$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $19$hi;
   i64toi32_i32$2 = $19;
   i64toi32_i32$1 = $24$hi;
   i64toi32_i32$3 = $21;
   i64toi32_i32$1 = i64toi32_i32$0 | i64toi32_i32$1 | 0;
   $2 = i64toi32_i32$2 | i64toi32_i32$3 | 0;
   $2$hi = i64toi32_i32$1;
   i64toi32_i32$1 = $1$hi;
   i64toi32_i32$1 = $4$hi;
   i64toi32_i32$1 = $1$hi;
   i64toi32_i32$0 = $1;
   i64toi32_i32$2 = $4$hi;
   i64toi32_i32$3 = $4;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$2 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
    $22 = 0;
   } else {
    i64toi32_i32$2 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$0 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$1 << i64toi32_i32$4 | 0) | 0;
    $22 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
   }
   $1 = $22;
   $1$hi = i64toi32_i32$2;
  }
  i64toi32_i32$2 = $1$hi;
  i64toi32_i32$0 = $0;
  HEAP32[i64toi32_i32$0 >> 2] = $1;
  HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$2;
  i64toi32_i32$2 = $2$hi;
  HEAP32[(i64toi32_i32$0 + 8 | 0) >> 2] = $2;
  HEAP32[(i64toi32_i32$0 + 12 | 0) >> 2] = i64toi32_i32$2;
 }
 
 function __lshrti3($0, $1, $1$hi, $2, $2$hi, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  $2 = $2 | 0;
  $2$hi = $2$hi | 0;
  $3 = $3 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$4 = 0, i64toi32_i32$2 = 0, i64toi32_i32$1 = 0, i64toi32_i32$3 = 0, $4$hi = 0, $18 = 0, $20 = 0, $21 = 0, $22 = 0, $11$hi = 0, $18$hi = 0, $19 = 0, $19$hi = 0, $4 = 0, $24$hi = 0;
  label$1 : {
   label$2 : {
    if (!($3 & 64 | 0)) {
     break label$2
    }
    i64toi32_i32$0 = $2$hi;
    i64toi32_i32$0 = 0;
    $11$hi = i64toi32_i32$0;
    i64toi32_i32$0 = $2$hi;
    i64toi32_i32$2 = $2;
    i64toi32_i32$1 = $11$hi;
    i64toi32_i32$3 = $3 + -64 | 0;
    i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     i64toi32_i32$1 = 0;
     $18 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
    } else {
     i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
     $18 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
    }
    $1 = $18;
    $1$hi = i64toi32_i32$1;
    i64toi32_i32$1 = 0;
    $2 = 0;
    $2$hi = i64toi32_i32$1;
    break label$1;
   }
   if (!$3) {
    break label$1
   }
   i64toi32_i32$1 = $2$hi;
   i64toi32_i32$1 = 0;
   $18$hi = i64toi32_i32$1;
   i64toi32_i32$1 = $2$hi;
   i64toi32_i32$0 = $2;
   i64toi32_i32$2 = $18$hi;
   i64toi32_i32$3 = 64 - $3 | 0;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$2 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
    $20 = 0;
   } else {
    i64toi32_i32$2 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$0 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$1 << i64toi32_i32$4 | 0) | 0;
    $20 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
   }
   $19 = $20;
   $19$hi = i64toi32_i32$2;
   i64toi32_i32$2 = $1$hi;
   i64toi32_i32$2 = 0;
   $4 = $3;
   $4$hi = i64toi32_i32$2;
   i64toi32_i32$2 = $1$hi;
   i64toi32_i32$1 = $1;
   i64toi32_i32$0 = $4$hi;
   i64toi32_i32$3 = $3;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$0 = 0;
    $21 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$0 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
    $21 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$4 | 0) | 0;
   }
   $24$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $19$hi;
   i64toi32_i32$2 = $19;
   i64toi32_i32$1 = $24$hi;
   i64toi32_i32$3 = $21;
   i64toi32_i32$1 = i64toi32_i32$0 | i64toi32_i32$1 | 0;
   $1 = i64toi32_i32$2 | i64toi32_i32$3 | 0;
   $1$hi = i64toi32_i32$1;
   i64toi32_i32$1 = $2$hi;
   i64toi32_i32$1 = $4$hi;
   i64toi32_i32$1 = $2$hi;
   i64toi32_i32$0 = $2;
   i64toi32_i32$2 = $4$hi;
   i64toi32_i32$3 = $4;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$2 = 0;
    $22 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$2 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    $22 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
   }
   $2 = $22;
   $2$hi = i64toi32_i32$2;
  }
  i64toi32_i32$2 = $1$hi;
  i64toi32_i32$0 = $0;
  HEAP32[i64toi32_i32$0 >> 2] = $1;
  HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$2;
  i64toi32_i32$2 = $2$hi;
  HEAP32[(i64toi32_i32$0 + 8 | 0) >> 2] = $2;
  HEAP32[(i64toi32_i32$0 + 12 | 0) >> 2] = i64toi32_i32$2;
 }
 
 function __trunctfdf2($0, $0$hi, $1, $1$hi) {
  $0 = $0 | 0;
  $0$hi = $0$hi | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$5 = 0, i64toi32_i32$4 = 0, i64toi32_i32$2 = 0, i64toi32_i32$3 = 0, i64toi32_i32$1 = 0, $3 = 0, $3$hi = 0, $4$hi = 0, $4 = 0, $2 = 0, $5 = 0, $43 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $50 = 0, $12 = 0, $12$hi = 0, $14$hi = 0, $17 = 0, $17$hi = 0, $19$hi = 0, $34 = 0, $34$hi = 0, $37 = 0, $39 = 0, $44 = 0, $44$hi = 0, $46$hi = 0, $74 = 0, $74$hi = 0, $78$hi = 0, $81 = 0, $81$hi = 0, $83 = 0, $83$hi = 0, $87 = 0, $87$hi = 0, $89 = 0, $90$hi = 0, $100$hi = 0, $107 = 0, $107$hi = 0;
  $2 = __stack_pointer - 32 | 0;
  __stack_pointer = $2;
  label$1 : {
   label$2 : {
    i64toi32_i32$0 = $1$hi;
    i64toi32_i32$2 = $1;
    i64toi32_i32$1 = 2147483647;
    i64toi32_i32$3 = -1;
    i64toi32_i32$1 = i64toi32_i32$0 & i64toi32_i32$1 | 0;
    $3 = i64toi32_i32$2 & i64toi32_i32$3 | 0;
    $3$hi = i64toi32_i32$1;
    i64toi32_i32$0 = $3;
    i64toi32_i32$2 = -1006698496;
    i64toi32_i32$3 = 0;
    i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
    i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
    if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
    }
    $12 = i64toi32_i32$4;
    $12$hi = i64toi32_i32$5;
    i64toi32_i32$5 = $3$hi;
    i64toi32_i32$1 = $3;
    i64toi32_i32$0 = -1140785152;
    i64toi32_i32$3 = 0;
    i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
    i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
    if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
    }
    $14$hi = i64toi32_i32$4;
    i64toi32_i32$4 = $12$hi;
    i64toi32_i32$5 = $12;
    i64toi32_i32$1 = $14$hi;
    i64toi32_i32$3 = i64toi32_i32$2;
    if (i64toi32_i32$4 >>> 0 > i64toi32_i32$1 >>> 0 | ((i64toi32_i32$4 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$5 >>> 0 >= i64toi32_i32$3 >>> 0 | 0) | 0) {
     break label$2
    }
    i64toi32_i32$5 = $0$hi;
    i64toi32_i32$3 = $0;
    i64toi32_i32$4 = 0;
    i64toi32_i32$1 = 60;
    i64toi32_i32$0 = i64toi32_i32$1 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$1 & 63 | 0) >>> 0) {
     i64toi32_i32$4 = 0;
     $43 = i64toi32_i32$5 >>> i64toi32_i32$0 | 0;
    } else {
     i64toi32_i32$4 = i64toi32_i32$5 >>> i64toi32_i32$0 | 0;
     $43 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$5 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$3 >>> i64toi32_i32$0 | 0) | 0;
    }
    $17 = $43;
    $17$hi = i64toi32_i32$4;
    i64toi32_i32$4 = $1$hi;
    i64toi32_i32$5 = $1;
    i64toi32_i32$3 = 0;
    i64toi32_i32$1 = 4;
    i64toi32_i32$0 = i64toi32_i32$1 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$1 & 63 | 0) >>> 0) {
     i64toi32_i32$3 = i64toi32_i32$5 << i64toi32_i32$0 | 0;
     $45 = 0;
    } else {
     i64toi32_i32$3 = ((1 << i64toi32_i32$0 | 0) - 1 | 0) & (i64toi32_i32$5 >>> (32 - i64toi32_i32$0 | 0) | 0) | 0 | (i64toi32_i32$4 << i64toi32_i32$0 | 0) | 0;
     $45 = i64toi32_i32$5 << i64toi32_i32$0 | 0;
    }
    $19$hi = i64toi32_i32$3;
    i64toi32_i32$3 = $17$hi;
    i64toi32_i32$4 = $17;
    i64toi32_i32$5 = $19$hi;
    i64toi32_i32$1 = $45;
    i64toi32_i32$5 = i64toi32_i32$3 | i64toi32_i32$5 | 0;
    $3 = i64toi32_i32$4 | i64toi32_i32$1 | 0;
    $3$hi = i64toi32_i32$5;
    label$3 : {
     i64toi32_i32$5 = $0$hi;
     i64toi32_i32$3 = $0;
     i64toi32_i32$4 = 268435455;
     i64toi32_i32$1 = -1;
     i64toi32_i32$4 = i64toi32_i32$5 & i64toi32_i32$4 | 0;
     $0 = i64toi32_i32$3 & i64toi32_i32$1 | 0;
     $0$hi = i64toi32_i32$4;
     i64toi32_i32$5 = $0;
     i64toi32_i32$3 = 134217728;
     i64toi32_i32$1 = 1;
     if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0 | ((i64toi32_i32$4 | 0) == (i64toi32_i32$3 | 0) & i64toi32_i32$5 >>> 0 < i64toi32_i32$1 >>> 0 | 0) | 0) {
      break label$3
     }
     i64toi32_i32$5 = $3$hi;
     i64toi32_i32$1 = $3;
     i64toi32_i32$4 = 1073741824;
     i64toi32_i32$3 = 1;
     i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
     i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
     if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
      i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
     }
     $4 = i64toi32_i32$0;
     $4$hi = i64toi32_i32$2;
     break label$1;
    }
    i64toi32_i32$2 = $3$hi;
    i64toi32_i32$5 = $3;
    i64toi32_i32$1 = 1073741824;
    i64toi32_i32$3 = 0;
    i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
    i64toi32_i32$0 = i64toi32_i32$2 + i64toi32_i32$1 | 0;
    if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
    }
    $4 = i64toi32_i32$4;
    $4$hi = i64toi32_i32$0;
    i64toi32_i32$0 = $0$hi;
    i64toi32_i32$2 = $0;
    i64toi32_i32$5 = 134217728;
    i64toi32_i32$3 = 0;
    i64toi32_i32$5 = i64toi32_i32$0 ^ i64toi32_i32$5 | 0;
    i64toi32_i32$0 = i64toi32_i32$2 ^ i64toi32_i32$3 | 0;
    i64toi32_i32$2 = 0;
    i64toi32_i32$3 = 0;
    if ((i64toi32_i32$0 | 0) != (i64toi32_i32$3 | 0) | (i64toi32_i32$5 | 0) != (i64toi32_i32$2 | 0) | 0) {
     break label$1
    }
    i64toi32_i32$0 = $4$hi;
    i64toi32_i32$0 = $3$hi;
    i64toi32_i32$3 = $3;
    i64toi32_i32$5 = 0;
    i64toi32_i32$2 = 1;
    i64toi32_i32$5 = i64toi32_i32$0 & i64toi32_i32$5 | 0;
    $34 = i64toi32_i32$3 & i64toi32_i32$2 | 0;
    $34$hi = i64toi32_i32$5;
    i64toi32_i32$5 = $4$hi;
    i64toi32_i32$0 = $4;
    i64toi32_i32$3 = $34$hi;
    i64toi32_i32$2 = $34;
    i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
    i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
    if (i64toi32_i32$1 >>> 0 < i64toi32_i32$2 >>> 0) {
     i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
    }
    $4 = i64toi32_i32$1;
    $4$hi = i64toi32_i32$4;
    break label$1;
   }
   label$4 : {
    i64toi32_i32$4 = $0$hi;
    $37 = !($0 | i64toi32_i32$4 | 0);
    i64toi32_i32$4 = $3$hi;
    i64toi32_i32$5 = $3;
    i64toi32_i32$0 = 2147418112;
    i64toi32_i32$2 = 0;
    $39 = i64toi32_i32$4 >>> 0 < i64toi32_i32$0 >>> 0 | ((i64toi32_i32$4 | 0) == (i64toi32_i32$0 | 0) & i64toi32_i32$5 >>> 0 < i64toi32_i32$2 >>> 0 | 0) | 0;
    i64toi32_i32$5 = i64toi32_i32$4;
    i64toi32_i32$2 = $3;
    i64toi32_i32$4 = 2147418112;
    i64toi32_i32$0 = 0;
    if ((i64toi32_i32$2 | 0) == (i64toi32_i32$0 | 0) & (i64toi32_i32$5 | 0) == (i64toi32_i32$4 | 0) | 0 ? $37 : $39) {
     break label$4
    }
    i64toi32_i32$2 = $0$hi;
    i64toi32_i32$0 = $0;
    i64toi32_i32$5 = 0;
    i64toi32_i32$4 = 60;
    i64toi32_i32$3 = i64toi32_i32$4 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$4 & 63 | 0) >>> 0) {
     i64toi32_i32$5 = 0;
     $46 = i64toi32_i32$2 >>> i64toi32_i32$3 | 0;
    } else {
     i64toi32_i32$5 = i64toi32_i32$2 >>> i64toi32_i32$3 | 0;
     $46 = (((1 << i64toi32_i32$3 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$3 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$3 | 0) | 0;
    }
    $44 = $46;
    $44$hi = i64toi32_i32$5;
    i64toi32_i32$5 = $1$hi;
    i64toi32_i32$2 = $1;
    i64toi32_i32$0 = 0;
    i64toi32_i32$4 = 4;
    i64toi32_i32$3 = i64toi32_i32$4 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$4 & 63 | 0) >>> 0) {
     i64toi32_i32$0 = i64toi32_i32$2 << i64toi32_i32$3 | 0;
     $47 = 0;
    } else {
     i64toi32_i32$0 = ((1 << i64toi32_i32$3 | 0) - 1 | 0) & (i64toi32_i32$2 >>> (32 - i64toi32_i32$3 | 0) | 0) | 0 | (i64toi32_i32$5 << i64toi32_i32$3 | 0) | 0;
     $47 = i64toi32_i32$2 << i64toi32_i32$3 | 0;
    }
    $46$hi = i64toi32_i32$0;
    i64toi32_i32$0 = $44$hi;
    i64toi32_i32$5 = $44;
    i64toi32_i32$2 = $46$hi;
    i64toi32_i32$4 = $47;
    i64toi32_i32$2 = i64toi32_i32$0 | i64toi32_i32$2 | 0;
    i64toi32_i32$0 = i64toi32_i32$5 | i64toi32_i32$4 | 0;
    i64toi32_i32$5 = 524287;
    i64toi32_i32$4 = -1;
    i64toi32_i32$5 = i64toi32_i32$2 & i64toi32_i32$5 | 0;
    i64toi32_i32$2 = i64toi32_i32$0 & i64toi32_i32$4 | 0;
    i64toi32_i32$0 = 2146959360;
    i64toi32_i32$4 = 0;
    i64toi32_i32$0 = i64toi32_i32$5 | i64toi32_i32$0 | 0;
    $4 = i64toi32_i32$2 | i64toi32_i32$4 | 0;
    $4$hi = i64toi32_i32$0;
    break label$1;
   }
   i64toi32_i32$0 = 2146435072;
   $4 = 0;
   $4$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $3$hi;
   i64toi32_i32$5 = $3;
   i64toi32_i32$2 = 1140785151;
   i64toi32_i32$4 = -1;
   if (i64toi32_i32$0 >>> 0 > i64toi32_i32$2 >>> 0 | ((i64toi32_i32$0 | 0) == (i64toi32_i32$2 | 0) & i64toi32_i32$5 >>> 0 > i64toi32_i32$4 >>> 0 | 0) | 0) {
    break label$1
   }
   i64toi32_i32$5 = 0;
   $4 = 0;
   $4$hi = i64toi32_i32$5;
   i64toi32_i32$5 = $3$hi;
   i64toi32_i32$4 = $3;
   i64toi32_i32$0 = 0;
   i64toi32_i32$2 = 48;
   i64toi32_i32$3 = i64toi32_i32$2 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$2 & 63 | 0) >>> 0) {
    i64toi32_i32$0 = 0;
    $48 = i64toi32_i32$5 >>> i64toi32_i32$3 | 0;
   } else {
    i64toi32_i32$0 = i64toi32_i32$5 >>> i64toi32_i32$3 | 0;
    $48 = (((1 << i64toi32_i32$3 | 0) - 1 | 0) & i64toi32_i32$5 | 0) << (32 - i64toi32_i32$3 | 0) | 0 | (i64toi32_i32$4 >>> i64toi32_i32$3 | 0) | 0;
   }
   $5 = $48;
   if ($5 >>> 0 < 15249 >>> 0) {
    break label$1
   }
   i64toi32_i32$0 = $0$hi;
   i64toi32_i32$0 = $1$hi;
   i64toi32_i32$5 = $1;
   i64toi32_i32$4 = 65535;
   i64toi32_i32$2 = -1;
   i64toi32_i32$4 = i64toi32_i32$0 & i64toi32_i32$4 | 0;
   i64toi32_i32$0 = i64toi32_i32$5 & i64toi32_i32$2 | 0;
   i64toi32_i32$5 = 65536;
   i64toi32_i32$2 = 0;
   i64toi32_i32$5 = i64toi32_i32$4 | i64toi32_i32$5 | 0;
   $3 = i64toi32_i32$0 | i64toi32_i32$2 | 0;
   $3$hi = i64toi32_i32$5;
   i64toi32_i32$5 = $0$hi;
   i64toi32_i32$0 = $3$hi;
   __ashlti3($2 + 16 | 0 | 0, $0 | 0, i64toi32_i32$5 | 0, $3 | 0, i64toi32_i32$0 | 0, $5 + -15233 | 0 | 0);
   i64toi32_i32$0 = i64toi32_i32$5;
   i64toi32_i32$0 = $3$hi;
   i64toi32_i32$0 = i64toi32_i32$5;
   i64toi32_i32$5 = $3$hi;
   __lshrti3($2 | 0, $0 | 0, i64toi32_i32$0 | 0, $3 | 0, i64toi32_i32$5 | 0, 15361 - $5 | 0 | 0);
   i64toi32_i32$4 = $2;
   i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
   i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 4 | 0) >> 2] | 0;
   $3 = i64toi32_i32$5;
   $3$hi = i64toi32_i32$0;
   i64toi32_i32$4 = i64toi32_i32$5;
   i64toi32_i32$5 = 0;
   i64toi32_i32$2 = 60;
   i64toi32_i32$3 = i64toi32_i32$2 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$2 & 63 | 0) >>> 0) {
    i64toi32_i32$5 = 0;
    $49 = i64toi32_i32$0 >>> i64toi32_i32$3 | 0;
   } else {
    i64toi32_i32$5 = i64toi32_i32$0 >>> i64toi32_i32$3 | 0;
    $49 = (((1 << i64toi32_i32$3 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$3 | 0) | 0 | (i64toi32_i32$4 >>> i64toi32_i32$3 | 0) | 0;
   }
   $74 = $49;
   $74$hi = i64toi32_i32$5;
   i64toi32_i32$0 = $2 + 8 | 0;
   i64toi32_i32$5 = HEAP32[i64toi32_i32$0 >> 2] | 0;
   i64toi32_i32$4 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
   i64toi32_i32$0 = i64toi32_i32$5;
   i64toi32_i32$5 = 0;
   i64toi32_i32$2 = 4;
   i64toi32_i32$3 = i64toi32_i32$2 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$2 & 63 | 0) >>> 0) {
    i64toi32_i32$5 = i64toi32_i32$0 << i64toi32_i32$3 | 0;
    $50 = 0;
   } else {
    i64toi32_i32$5 = ((1 << i64toi32_i32$3 | 0) - 1 | 0) & (i64toi32_i32$0 >>> (32 - i64toi32_i32$3 | 0) | 0) | 0 | (i64toi32_i32$4 << i64toi32_i32$3 | 0) | 0;
    $50 = i64toi32_i32$0 << i64toi32_i32$3 | 0;
   }
   $78$hi = i64toi32_i32$5;
   i64toi32_i32$5 = $74$hi;
   i64toi32_i32$4 = $74;
   i64toi32_i32$0 = $78$hi;
   i64toi32_i32$2 = $50;
   i64toi32_i32$0 = i64toi32_i32$5 | i64toi32_i32$0 | 0;
   $4 = i64toi32_i32$4 | i64toi32_i32$2 | 0;
   $4$hi = i64toi32_i32$0;
   label$5 : {
    i64toi32_i32$0 = $3$hi;
    i64toi32_i32$5 = $3;
    i64toi32_i32$4 = 268435455;
    i64toi32_i32$2 = -1;
    i64toi32_i32$4 = i64toi32_i32$0 & i64toi32_i32$4 | 0;
    $81 = i64toi32_i32$5 & i64toi32_i32$2 | 0;
    $81$hi = i64toi32_i32$4;
    i64toi32_i32$0 = $2;
    i64toi32_i32$4 = HEAP32[(i64toi32_i32$0 + 16 | 0) >> 2] | 0;
    i64toi32_i32$5 = HEAP32[(i64toi32_i32$0 + 20 | 0) >> 2] | 0;
    $83 = i64toi32_i32$4;
    $83$hi = i64toi32_i32$5;
    i64toi32_i32$0 = (i64toi32_i32$0 + 16 | 0) + 8 | 0;
    i64toi32_i32$5 = HEAP32[i64toi32_i32$0 >> 2] | 0;
    i64toi32_i32$4 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
    $87 = i64toi32_i32$5;
    $87$hi = i64toi32_i32$4;
    i64toi32_i32$4 = $83$hi;
    i64toi32_i32$0 = $83;
    i64toi32_i32$5 = $87$hi;
    i64toi32_i32$2 = $87;
    i64toi32_i32$5 = i64toi32_i32$4 | i64toi32_i32$5 | 0;
    i64toi32_i32$4 = i64toi32_i32$0 | i64toi32_i32$2 | 0;
    i64toi32_i32$0 = 0;
    i64toi32_i32$2 = 0;
    $89 = (i64toi32_i32$4 | 0) != (i64toi32_i32$2 | 0) | (i64toi32_i32$5 | 0) != (i64toi32_i32$0 | 0) | 0;
    i64toi32_i32$4 = 0;
    $90$hi = i64toi32_i32$4;
    i64toi32_i32$4 = $81$hi;
    i64toi32_i32$2 = $81;
    i64toi32_i32$5 = $90$hi;
    i64toi32_i32$0 = $89;
    i64toi32_i32$5 = i64toi32_i32$4 | i64toi32_i32$5 | 0;
    $3 = i64toi32_i32$2 | i64toi32_i32$0 | 0;
    $3$hi = i64toi32_i32$5;
    i64toi32_i32$4 = $3;
    i64toi32_i32$2 = 134217728;
    i64toi32_i32$0 = 1;
    if (i64toi32_i32$5 >>> 0 < i64toi32_i32$2 >>> 0 | ((i64toi32_i32$5 | 0) == (i64toi32_i32$2 | 0) & i64toi32_i32$4 >>> 0 < i64toi32_i32$0 >>> 0 | 0) | 0) {
     break label$5
    }
    i64toi32_i32$4 = $4$hi;
    i64toi32_i32$0 = $4;
    i64toi32_i32$5 = 0;
    i64toi32_i32$2 = 1;
    i64toi32_i32$3 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
    i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$5 | 0;
    if (i64toi32_i32$3 >>> 0 < i64toi32_i32$2 >>> 0) {
     i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
    }
    $4 = i64toi32_i32$3;
    $4$hi = i64toi32_i32$1;
    break label$1;
   }
   i64toi32_i32$1 = $3$hi;
   i64toi32_i32$4 = $3;
   i64toi32_i32$0 = 134217728;
   i64toi32_i32$2 = 0;
   i64toi32_i32$0 = i64toi32_i32$1 ^ i64toi32_i32$0 | 0;
   i64toi32_i32$1 = i64toi32_i32$4 ^ i64toi32_i32$2 | 0;
   i64toi32_i32$4 = 0;
   i64toi32_i32$2 = 0;
   if ((i64toi32_i32$1 | 0) != (i64toi32_i32$2 | 0) | (i64toi32_i32$0 | 0) != (i64toi32_i32$4 | 0) | 0) {
    break label$1
   }
   i64toi32_i32$1 = $4$hi;
   i64toi32_i32$2 = $4;
   i64toi32_i32$0 = 0;
   i64toi32_i32$4 = 1;
   i64toi32_i32$0 = i64toi32_i32$1 & i64toi32_i32$0 | 0;
   $100$hi = i64toi32_i32$0;
   i64toi32_i32$0 = i64toi32_i32$1;
   i64toi32_i32$0 = $100$hi;
   i64toi32_i32$1 = i64toi32_i32$2 & i64toi32_i32$4 | 0;
   i64toi32_i32$2 = $4$hi;
   i64toi32_i32$4 = $4;
   i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$4 | 0;
   i64toi32_i32$3 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
   if (i64toi32_i32$5 >>> 0 < i64toi32_i32$4 >>> 0) {
    i64toi32_i32$3 = i64toi32_i32$3 + 1 | 0
   }
   $4 = i64toi32_i32$5;
   $4$hi = i64toi32_i32$3;
  }
  __stack_pointer = $2 + 32 | 0;
  i64toi32_i32$3 = $4$hi;
  i64toi32_i32$3 = $1$hi;
  i64toi32_i32$0 = $1;
  i64toi32_i32$1 = -2147483648;
  i64toi32_i32$4 = 0;
  i64toi32_i32$1 = i64toi32_i32$3 & i64toi32_i32$1 | 0;
  $107 = i64toi32_i32$0 & i64toi32_i32$4 | 0;
  $107$hi = i64toi32_i32$1;
  i64toi32_i32$1 = $4$hi;
  i64toi32_i32$3 = $4;
  i64toi32_i32$0 = $107$hi;
  i64toi32_i32$4 = $107;
  i64toi32_i32$0 = i64toi32_i32$1 | i64toi32_i32$0 | 0;
  wasm2js_scratch_store_i32(0 | 0, i64toi32_i32$3 | i64toi32_i32$4 | 0 | 0);
  wasm2js_scratch_store_i32(1 | 0, i64toi32_i32$0 | 0);
  return +(+wasm2js_scratch_load_f64());
 }
 
 function FLAC__crc8($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $4 = 0, $3 = 0;
  label$1 : {
   label$2 : {
    if ($1) {
     break label$2
    }
    $1 = 0;
    break label$1;
   }
   $2 = $1 & 3 | 0;
   label$3 : {
    label$4 : {
     if (($1 + -1 | 0) >>> 0 >= 3 >>> 0) {
      break label$4
     }
     $1 = 0;
     break label$3;
    }
    $3 = $1 & -4 | 0;
    $1 = 0;
    label$5 : while (1) {
     $4 = GOT_data_internal___memory_base + 1024 | 0;
     $1 = HEAPU8[($4 + ((HEAPU8[($0 + 3 | 0) >> 0] | 0) ^ (HEAPU8[($4 + ((HEAPU8[($0 + 2 | 0) >> 0] | 0) ^ (HEAPU8[($4 + ((HEAPU8[($0 + 1 | 0) >> 0] | 0) ^ (HEAPU8[($4 + ((HEAPU8[$0 >> 0] | 0) ^ ($1 & 255 | 0) | 0) | 0) >> 0] | 0) | 0) | 0) >> 0] | 0) | 0) | 0) >> 0] | 0) | 0) | 0) >> 0] | 0;
     $0 = $0 + 4 | 0;
     $3 = $3 + -4 | 0;
     if ($3) {
      continue label$5
     }
     break label$5;
    };
   }
   if (!$2) {
    break label$1
   }
   label$6 : while (1) {
    $1 = HEAPU8[((GOT_data_internal___memory_base + 1024 | 0) + ((HEAPU8[$0 >> 0] | 0) ^ ($1 & 255 | 0) | 0) | 0) >> 0] | 0;
    $0 = $0 + 1 | 0;
    $2 = $2 + -1 | 0;
    if ($2) {
     continue label$6
    }
    break label$6;
   };
  }
  return $1 & 255 | 0 | 0;
 }
 
 function FLAC__crc16($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $4 = 0, $2 = 0, $3 = 0, $113 = 0;
  $2 = 0;
  label$1 : {
   if ($1 >>> 0 <= 7 >>> 0) {
    break label$1
   }
   label$2 : while (1) {
    $3 = HEAPU8[$0 >> 0] | 0 | ((HEAPU8[($0 + 1 | 0) >> 0] | 0) << 8 | 0) | 0;
    $4 = GOT_data_internal___memory_base + 1280 | 0;
    $2 = ($3 << 8 | 0 | ($3 >>> 8 | 0) | 0) ^ $2 | 0;
    $2 = (((((((HEAPU16[(($4 + (($2 & 255 | 0) << 1 | 0) | 0) + 3072 | 0) >> 1] | 0) ^ (HEAPU16[(($4 + (($2 >>> 7 | 0) & 510 | 0) | 0) + 3584 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($4 + ((HEAPU8[($0 + 2 | 0) >> 0] | 0) << 1 | 0) | 0) + 2560 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($4 + ((HEAPU8[($0 + 3 | 0) >> 0] | 0) << 1 | 0) | 0) + 2048 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($4 + ((HEAPU8[($0 + 4 | 0) >> 0] | 0) << 1 | 0) | 0) + 1536 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($4 + ((HEAPU8[($0 + 5 | 0) >> 0] | 0) << 1 | 0) | 0) + 1024 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($4 + ((HEAPU8[($0 + 6 | 0) >> 0] | 0) << 1 | 0) | 0) + 512 | 0) >> 1] | 0) | 0) ^ (HEAPU16[($4 + ((HEAPU8[($0 + 7 | 0) >> 0] | 0) << 1 | 0) | 0) >> 1] | 0) | 0;
    $0 = $0 + 8 | 0;
    $1 = $1 + -8 | 0;
    if ($1 >>> 0 > 7 >>> 0) {
     continue label$2
    }
    break label$2;
   };
  }
  label$3 : {
   if (!$1) {
    break label$3
   }
   label$4 : {
    label$5 : {
     if ($1 & 1 | 0) {
      break label$5
     }
     $4 = $1;
     break label$4;
    }
    $2 = (HEAPU16[((GOT_data_internal___memory_base + 1280 | 0) + (((HEAPU8[$0 >> 0] | 0) ^ (($2 & 65280 | 0) >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0) ^ ($2 << 8 | 0) | 0;
    $0 = $0 + 1 | 0;
    $4 = $1 + -1 | 0;
   }
   if (($1 | 0) == (1 | 0)) {
    break label$3
   }
   label$6 : while (1) {
    $3 = GOT_data_internal___memory_base + 1280 | 0;
    $113 = $3;
    $3 = HEAPU16[($3 + (((HEAPU8[$0 >> 0] | 0) ^ (($2 & 65280 | 0) >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0;
    $2 = (HEAPU16[($113 + (((HEAPU8[($0 + 1 | 0) >> 0] | 0) ^ ((($3 ^ ($2 << 8 | 0) | 0) & 65280 | 0) >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0) ^ ($3 << 8 | 0) | 0;
    $0 = $0 + 2 | 0;
    $4 = $4 + -2 | 0;
    if ($4) {
     continue label$6
    }
    break label$6;
   };
  }
  return $2 & 65535 | 0 | 0;
 }
 
 function FLAC__crc16_update_words32($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $45 = 0;
  label$1 : {
   if ($1 >>> 0 < 2 >>> 0) {
    break label$1
   }
   label$2 : while (1) {
    $3 = GOT_data_internal___memory_base + 1280 | 0;
    $4 = HEAP32[$0 >> 2] | 0;
    $2 = $2 ^ ($4 >>> 16 | 0) | 0;
    $45 = (((HEAPU16[(($3 + (($2 & 255 | 0) << 1 | 0) | 0) + 3072 | 0) >> 1] | 0) ^ (HEAPU16[(($3 + (($2 >>> 7 | 0) & 510 | 0) | 0) + 3584 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($3 + (($4 >>> 7 | 0) & 510 | 0) | 0) + 2560 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($3 + (($4 & 255 | 0) << 1 | 0) | 0) + 2048 | 0) >> 1] | 0) | 0;
    $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    $2 = ((($45 ^ (HEAPU16[(($3 + (($4 >>> 23 | 0) & 510 | 0) | 0) + 1536 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($3 + (($4 >>> 15 | 0) & 510 | 0) | 0) + 1024 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($3 + (($4 >>> 7 | 0) & 510 | 0) | 0) + 512 | 0) >> 1] | 0) | 0) ^ (HEAPU16[($3 + (($4 & 255 | 0) << 1 | 0) | 0) >> 1] | 0) | 0;
    $0 = $0 + 8 | 0;
    $1 = $1 + -2 | 0;
    if ($1 >>> 0 > 1 >>> 0) {
     continue label$2
    }
    break label$2;
   };
  }
  label$3 : {
   if (!$1) {
    break label$3
   }
   $3 = GOT_data_internal___memory_base + 1280 | 0;
   $0 = HEAP32[$0 >> 2] | 0;
   $4 = $2 ^ ($0 >>> 16 | 0) | 0;
   $2 = (((HEAPU16[(($3 + (($4 & 255 | 0) << 1 | 0) | 0) + 1024 | 0) >> 1] | 0) ^ (HEAPU16[(($3 + (($4 >>> 7 | 0) & 510 | 0) | 0) + 1536 | 0) >> 1] | 0) | 0) ^ (HEAPU16[(($3 + (($0 >>> 7 | 0) & 510 | 0) | 0) + 512 | 0) >> 1] | 0) | 0) ^ (HEAPU16[($3 + (($0 & 255 | 0) << 1 | 0) | 0) >> 1] | 0) | 0;
  }
  return $2 & 65535 | 0 | 0;
 }
 
 function memmove($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0;
  label$1 : {
   if (($0 | 0) == ($1 | 0)) {
    break label$1
   }
   label$2 : {
    $3 = $0 + $2 | 0;
    if (($1 - $3 | 0) >>> 0 > (0 - ($2 << 1 | 0) | 0) >>> 0) {
     break label$2
    }
    return __memcpy($0 | 0, $1 | 0, $2 | 0) | 0 | 0;
   }
   $4 = ($1 ^ $0 | 0) & 3 | 0;
   label$3 : {
    label$4 : {
     label$5 : {
      if ($0 >>> 0 >= $1 >>> 0) {
       break label$5
      }
      label$6 : {
       if (!$4) {
        break label$6
       }
       $3 = $0;
       break label$3;
      }
      label$7 : {
       if ($0 & 3 | 0) {
        break label$7
       }
       $3 = $0;
       break label$4;
      }
      $3 = $0;
      label$8 : while (1) {
       if (!$2) {
        break label$1
       }
       HEAP8[$3 >> 0] = HEAPU8[$1 >> 0] | 0;
       $1 = $1 + 1 | 0;
       $2 = $2 + -1 | 0;
       $3 = $3 + 1 | 0;
       if (!($3 & 3 | 0)) {
        break label$4
       }
       continue label$8;
      };
     }
     label$9 : {
      if ($4) {
       break label$9
      }
      label$10 : {
       if (!($3 & 3 | 0)) {
        break label$10
       }
       label$11 : while (1) {
        if (!$2) {
         break label$1
        }
        $2 = $2 + -1 | 0;
        $3 = $0 + $2 | 0;
        HEAP8[$3 >> 0] = HEAPU8[($1 + $2 | 0) >> 0] | 0;
        if ($3 & 3 | 0) {
         continue label$11
        }
        break label$11;
       };
      }
      if ($2 >>> 0 <= 3 >>> 0) {
       break label$9
      }
      label$12 : while (1) {
       $2 = $2 + -4 | 0;
       HEAP32[($0 + $2 | 0) >> 2] = HEAP32[($1 + $2 | 0) >> 2] | 0;
       if ($2 >>> 0 > 3 >>> 0) {
        continue label$12
       }
       break label$12;
      };
     }
     if (!$2) {
      break label$1
     }
     label$13 : while (1) {
      $2 = $2 + -1 | 0;
      HEAP8[($0 + $2 | 0) >> 0] = HEAPU8[($1 + $2 | 0) >> 0] | 0;
      if ($2) {
       continue label$13
      }
      break label$1;
     };
    }
    if ($2 >>> 0 <= 3 >>> 0) {
     break label$3
    }
    label$14 : while (1) {
     HEAP32[$3 >> 2] = HEAP32[$1 >> 2] | 0;
     $1 = $1 + 4 | 0;
     $3 = $3 + 4 | 0;
     $2 = $2 + -4 | 0;
     if ($2 >>> 0 > 3 >>> 0) {
      continue label$14
     }
     break label$14;
    };
   }
   if (!$2) {
    break label$1
   }
   label$15 : while (1) {
    HEAP8[$3 >> 0] = HEAPU8[$1 >> 0] | 0;
    $3 = $3 + 1 | 0;
    $1 = $1 + 1 | 0;
    $2 = $2 + -1 | 0;
    if ($2) {
     continue label$15
    }
    break label$15;
   };
  }
  return $0 | 0;
 }
 
 function FLAC__bitreader_new() {
  return dlcalloc(1 | 0, 44 | 0) | 0 | 0;
 }
 
 function FLAC__bitreader_delete($0) {
  $0 = $0 | 0;
  var $1 = 0;
  label$1 : {
   $1 = HEAP32[$0 >> 2] | 0;
   if (!$1) {
    break label$1
   }
   dlfree($1 | 0);
  }
  dlfree($0 | 0);
 }
 
 function FLAC__bitreader_free($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, $1 = 0;
  label$1 : {
   $1 = HEAP32[$0 >> 2] | 0;
   if (!$1) {
    break label$1
   }
   dlfree($1 | 0);
  }
  i64toi32_i32$1 = $0;
  i64toi32_i32$0 = 0;
  HEAP32[(i64toi32_i32$1 + 36 | 0) >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 40 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = i64toi32_i32$1 + 8 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = $0 + 16 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
 }
 
 function FLAC__bitreader_init($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, $3 = 0;
  i64toi32_i32$1 = $0;
  i64toi32_i32$0 = 0;
  HEAP32[($0 + 8 | 0) >> 2] = 0;
  HEAP32[($0 + 12 | 0) >> 2] = i64toi32_i32$0;
  HEAP32[($0 + 4 | 0) >> 2] = 2048;
  i64toi32_i32$1 = $0 + 16 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  $3 = dlmalloc(8192 | 0) | 0;
  HEAP32[$0 >> 2] = $3;
  label$1 : {
   if ($3) {
    break label$1
   }
   return 0 | 0;
  }
  HEAP32[($0 + 40 | 0) >> 2] = $2;
  HEAP32[($0 + 36 | 0) >> 2] = $1;
  return 1 | 0;
 }
 
 function FLAC__bitreader_clear($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0;
  i64toi32_i32$1 = $0;
  i64toi32_i32$0 = 0;
  HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = i64toi32_i32$1 + 16 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  return 1 | 0;
 }
 
 function FLAC__bitreader_reset_read_crc16($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var i64toi32_i32$1 = 0;
  HEAP32[($0 + 24 | 0) >> 2] = $1;
  i64toi32_i32$1 = HEAP32[($0 + 20 | 0) >> 2] | 0;
  HEAP32[($0 + 28 | 0) >> 2] = HEAP32[($0 + 16 | 0) >> 2] | 0;
  HEAP32[($0 + 32 | 0) >> 2] = i64toi32_i32$1;
 }
 
 function FLAC__bitreader_get_read_crc16($0) {
  $0 = $0 | 0;
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $1 = 0, $54 = 0, $73 = 0;
  label$1 : {
   label$2 : {
    $1 = HEAP32[($0 + 16 | 0) >> 2] | 0;
    $2 = HEAP32[($0 + 28 | 0) >> 2] | 0;
    if ($1 >>> 0 > $2 >>> 0) {
     break label$2
    }
    $3 = $2;
    break label$1;
   }
   label$3 : {
    $4 = HEAP32[($0 + 32 | 0) >> 2] | 0;
    if ($4) {
     break label$3
    }
    $3 = $2;
    break label$1;
   }
   $3 = $2 + 1 | 0;
   HEAP32[($0 + 28 | 0) >> 2] = $3;
   $5 = HEAP32[($0 + 24 | 0) >> 2] | 0;
   label$4 : {
    if ($4 >>> 0 > 31 >>> 0) {
     break label$4
    }
    $2 = HEAP32[((HEAP32[$0 >> 2] | 0) + ($2 << 2 | 0) | 0) >> 2] | 0;
    $6 = HEAPU16[(GOT_data_internal_FLAC__crc16_table + (((($2 >>> (24 - $4 | 0) | 0) & 255 | 0) ^ ($5 >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0;
    $5 = (($5 << 8 | 0) & 65280 | 0) ^ $6 | 0;
    if ($4 >>> 0 >= 24 >>> 0) {
     break label$4
    }
    $54 = ($6 << 8 | 0) & 65280 | 0;
    $6 = HEAPU16[(GOT_data_internal_FLAC__crc16_table + (((($2 >>> (16 - $4 | 0) | 0) & 255 | 0) ^ ($5 >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0;
    $5 = $54 ^ $6 | 0;
    if ($4 >>> 0 > 15 >>> 0) {
     break label$4
    }
    $73 = ($6 << 8 | 0) & 65280 | 0;
    $6 = HEAPU16[(GOT_data_internal_FLAC__crc16_table + (((($2 >>> (8 - $4 | 0) | 0) & 255 | 0) ^ ($5 >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0;
    $5 = $73 ^ $6 | 0;
    if ($4 >>> 0 > 7 >>> 0) {
     break label$4
    }
    $5 = (($6 << 8 | 0) & 65280 | 0) ^ (HEAPU16[(GOT_data_internal_FLAC__crc16_table + (((($2 >>> (0 - $4 | 0) | 0) & 255 | 0) ^ ($5 >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0) | 0;
   }
   HEAP32[($0 + 32 | 0) >> 2] = 0;
   HEAP32[($0 + 24 | 0) >> 2] = $5;
  }
  $3 = FLAC__crc16_update_words32((HEAP32[$0 >> 2] | 0) + ($3 << 2 | 0) | 0 | 0, $1 - $3 | 0 | 0, HEAPU16[($0 + 24 | 0) >> 1] | 0 | 0) | 0;
  HEAP32[($0 + 28 | 0) >> 2] = 0;
  HEAP32[($0 + 24 | 0) >> 2] = $3;
  label$5 : {
   $1 = HEAP32[($0 + 20 | 0) >> 2] | 0;
   if (!$1) {
    break label$5
   }
   $2 = HEAP32[($0 + 32 | 0) >> 2] | 0;
   if ($2 >>> 0 >= $1 >>> 0) {
    break label$5
   }
   $4 = HEAP32[((HEAP32[$0 >> 2] | 0) + ((HEAP32[($0 + 16 | 0) >> 2] | 0) << 2 | 0) | 0) >> 2] | 0;
   label$6 : while (1) {
    $3 = (($3 << 8 | 0) & 65280 | 0) ^ (HEAPU16[(GOT_data_internal_FLAC__crc16_table + ((($3 >>> 8 | 0) ^ (($4 >>> (24 - $2 | 0) | 0) & 255 | 0) | 0) << 1 | 0) | 0) >> 1] | 0) | 0;
    $2 = $2 + 8 | 0;
    if ($2 >>> 0 < $1 >>> 0) {
     continue label$6
    }
    break label$6;
   };
   HEAP32[($0 + 32 | 0) >> 2] = $2;
   HEAP32[($0 + 24 | 0) >> 2] = $3;
  }
  return $3 | 0;
 }
 
 function FLAC__bitreader_is_consumed_byte_aligned($0) {
  $0 = $0 | 0;
  return !((HEAPU8[($0 + 20 | 0) >> 0] | 0) & 7 | 0) | 0;
 }
 
 function FLAC__bitreader_bits_left_for_byte_alignment($0) {
  $0 = $0 | 0;
  return 8 - ((HEAP32[($0 + 20 | 0) >> 2] | 0) & 7 | 0) | 0 | 0;
 }
 
 function FLAC__bitreader_get_input_bits_unconsumed($0) {
  $0 = $0 | 0;
  return ((((HEAP32[($0 + 8 | 0) >> 2] | 0) - (HEAP32[($0 + 16 | 0) >> 2] | 0) | 0) << 5 | 0) + ((HEAP32[($0 + 12 | 0) >> 2] | 0) << 3 | 0) | 0) - (HEAP32[($0 + 20 | 0) >> 2] | 0) | 0 | 0;
 }
 
 function FLAC__bitreader_read_raw_uint32($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $5 = 0, $4 = 0, $3 = 0, $6 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     if (!$2) {
      break label$3
     }
     label$4 : {
      label$5 : while (1) {
       $3 = HEAP32[($0 + 8 | 0) >> 2] | 0;
       $4 = HEAP32[($0 + 16 | 0) >> 2] | 0;
       $5 = HEAP32[($0 + 20 | 0) >> 2] | 0;
       if ((((($3 - $4 | 0) << 5 | 0) + ((HEAP32[($0 + 12 | 0) >> 2] | 0) << 3 | 0) | 0) - $5 | 0) >>> 0 >= $2 >>> 0) {
        break label$4
       }
       if (bitreader_read_from_client_($0 | 0) | 0) {
        continue label$5
       }
       break label$5;
      };
      return 0 | 0;
     }
     label$6 : {
      if ($3 >>> 0 <= $4 >>> 0) {
       break label$6
      }
      label$7 : {
       if (!$5) {
        break label$7
       }
       $6 = HEAP32[$0 >> 2] | 0;
       $4 = (HEAP32[($6 + ($4 << 2 | 0) | 0) >> 2] | 0) & (-1 >>> $5 | 0) | 0;
       label$8 : {
        $3 = 32 - $5 | 0;
        if ($3 >>> 0 <= $2 >>> 0) {
         break label$8
        }
        HEAP32[$1 >> 2] = $4 >>> ($3 - $2 | 0) | 0;
        HEAP32[($0 + 20 | 0) >> 2] = (HEAP32[($0 + 20 | 0) >> 2] | 0) + $2 | 0;
        break label$2;
       }
       HEAP32[$1 >> 2] = $4;
       HEAP32[($0 + 20 | 0) >> 2] = 0;
       $5 = 1;
       HEAP32[($0 + 16 | 0) >> 2] = (HEAP32[($0 + 16 | 0) >> 2] | 0) + 1 | 0;
       $2 = $2 - $3 | 0;
       if (!$2) {
        break label$1
       }
       $5 = (HEAP32[$1 >> 2] | 0) << $2 | 0;
       HEAP32[$1 >> 2] = $5;
       HEAP32[$1 >> 2] = (HEAP32[($6 + ((HEAP32[($0 + 16 | 0) >> 2] | 0) << 2 | 0) | 0) >> 2] | 0) >>> (32 - $2 | 0) | 0 | $5 | 0;
       HEAP32[($0 + 20 | 0) >> 2] = $2;
       return 1 | 0;
      }
      $5 = HEAP32[((HEAP32[$0 >> 2] | 0) + ($4 << 2 | 0) | 0) >> 2] | 0;
      label$9 : {
       if ($2 >>> 0 > 31 >>> 0) {
        break label$9
       }
       HEAP32[$1 >> 2] = $5 >>> (32 - $2 | 0) | 0;
       HEAP32[($0 + 20 | 0) >> 2] = $2;
       break label$2;
      }
      HEAP32[$1 >> 2] = $5;
      HEAP32[($0 + 16 | 0) >> 2] = (HEAP32[($0 + 16 | 0) >> 2] | 0) + 1 | 0;
      return 1 | 0;
     }
     $4 = HEAP32[((HEAP32[$0 >> 2] | 0) + ($4 << 2 | 0) | 0) >> 2] | 0;
     label$10 : {
      if (!$5) {
       break label$10
      }
      HEAP32[$1 >> 2] = ($4 & (-1 >>> $5 | 0) | 0) >>> (32 - ($5 + $2 | 0) | 0) | 0;
      HEAP32[($0 + 20 | 0) >> 2] = (HEAP32[($0 + 20 | 0) >> 2] | 0) + $2 | 0;
      break label$2;
     }
     HEAP32[$1 >> 2] = $4 >>> (32 - $2 | 0) | 0;
     HEAP32[($0 + 20 | 0) >> 2] = (HEAP32[($0 + 20 | 0) >> 2] | 0) + $2 | 0;
     break label$2;
    }
    HEAP32[$1 >> 2] = 0;
   }
   $5 = 1;
  }
  return $5 | 0;
 }
 
 function bitreader_read_from_client_($0) {
  $0 = $0 | 0;
  var $3 = 0, $4 = 0, $2 = 0, $5 = 0, $6 = 0, $7 = 0, $1 = 0, $62 = 0, $81 = 0, $8 = 0, $239 = 0, $284 = 0, $302 = 0, $320 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  label$1 : {
   label$2 : {
    $2 = HEAP32[($0 + 16 | 0) >> 2] | 0;
    if ($2) {
     break label$2
    }
    $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    break label$1;
   }
   label$3 : {
    label$4 : {
     $3 = HEAP32[($0 + 28 | 0) >> 2] | 0;
     if ($2 >>> 0 > $3 >>> 0) {
      break label$4
     }
     $4 = $3;
     break label$3;
    }
    label$5 : {
     $5 = HEAP32[($0 + 32 | 0) >> 2] | 0;
     if ($5) {
      break label$5
     }
     $4 = $3;
     break label$3;
    }
    $4 = $3 + 1 | 0;
    HEAP32[($0 + 28 | 0) >> 2] = $4;
    $6 = HEAP32[($0 + 24 | 0) >> 2] | 0;
    label$6 : {
     if ($5 >>> 0 > 31 >>> 0) {
      break label$6
     }
     $3 = HEAP32[((HEAP32[$0 >> 2] | 0) + ($3 << 2 | 0) | 0) >> 2] | 0;
     $7 = HEAPU16[(GOT_data_internal_FLAC__crc16_table + (((($3 >>> (24 - $5 | 0) | 0) & 255 | 0) ^ ($6 >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0;
     $6 = (($6 << 8 | 0) & 65280 | 0) ^ $7 | 0;
     if ($5 >>> 0 >= 24 >>> 0) {
      break label$6
     }
     $62 = ($7 << 8 | 0) & 65280 | 0;
     $7 = HEAPU16[(GOT_data_internal_FLAC__crc16_table + (((($3 >>> (16 - $5 | 0) | 0) & 255 | 0) ^ ($6 >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0;
     $6 = $62 ^ $7 | 0;
     if ($5 >>> 0 > 15 >>> 0) {
      break label$6
     }
     $81 = ($7 << 8 | 0) & 65280 | 0;
     $7 = HEAPU16[(GOT_data_internal_FLAC__crc16_table + (((($3 >>> (8 - $5 | 0) | 0) & 255 | 0) ^ ($6 >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0;
     $6 = $81 ^ $7 | 0;
     if ($5 >>> 0 > 7 >>> 0) {
      break label$6
     }
     $6 = (($7 << 8 | 0) & 65280 | 0) ^ (HEAPU16[(GOT_data_internal_FLAC__crc16_table + (((($3 >>> (0 - $5 | 0) | 0) & 255 | 0) ^ ($6 >>> 8 | 0) | 0) << 1 | 0) | 0) >> 1] | 0) | 0;
    }
    HEAP32[($0 + 32 | 0) >> 2] = 0;
    HEAP32[($0 + 24 | 0) >> 2] = $6;
   }
   $2 = FLAC__crc16_update_words32((HEAP32[$0 >> 2] | 0) + ($4 << 2 | 0) | 0 | 0, $2 - $4 | 0 | 0, HEAPU16[($0 + 24 | 0) >> 1] | 0 | 0) | 0;
   HEAP32[($0 + 28 | 0) >> 2] = 0;
   HEAP32[($0 + 24 | 0) >> 2] = $2;
   $4 = HEAP32[$0 >> 2] | 0;
   $2 = HEAP32[($0 + 16 | 0) >> 2] | 0;
   memmove($4 | 0, $4 + ($2 << 2 | 0) | 0 | 0, (((HEAP32[($0 + 8 | 0) >> 2] | 0) - $2 | 0) + ((HEAP32[($0 + 12 | 0) >> 2] | 0 | 0) != (0 | 0)) | 0) << 2 | 0 | 0) | 0;
   HEAP32[($0 + 16 | 0) >> 2] = 0;
   $2 = (HEAP32[($0 + 8 | 0) >> 2] | 0) - $2 | 0;
   HEAP32[($0 + 8 | 0) >> 2] = $2;
  }
  $3 = HEAP32[($0 + 12 | 0) >> 2] | 0;
  $5 = (((HEAP32[($0 + 4 | 0) >> 2] | 0) - $2 | 0) << 2 | 0) - $3 | 0;
  HEAP32[($1 + 12 | 0) >> 2] = $5;
  $4 = 0;
  label$7 : {
   if (!$5) {
    break label$7
   }
   $5 = (HEAP32[$0 >> 2] | 0) + ($2 << 2 | 0) | 0;
   $6 = $5 + $3 | 0;
   label$8 : {
    if (!$3) {
     break label$8
    }
    $2 = HEAP32[$5 >> 2] | 0;
    HEAP32[$5 >> 2] = $2 << 24 | 0 | (($2 << 8 | 0) & 16711680 | 0) | 0 | (($2 >>> 8 | 0) & 65280 | 0 | ($2 >>> 24 | 0) | 0) | 0;
   }
   if (!(FUNCTION_TABLE[HEAP32[($0 + 36 | 0) >> 2] | 0 | 0]($6, $1 + 12 | 0, HEAP32[($0 + 40 | 0) >> 2] | 0) | 0)) {
    break label$7
   }
   label$9 : {
    $4 = HEAP32[($0 + 12 | 0) >> 2] | 0;
    $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    $3 = $2 << 2 | 0;
    $7 = HEAP32[($1 + 12 | 0) >> 2] | 0;
    $6 = ((($4 + $3 | 0) + $7 | 0) + 3 | 0) >>> 2 | 0;
    if ($6 >>> 0 <= $2 >>> 0) {
     break label$9
    }
    $8 = $6 + ($2 ^ -1 | 0) | 0;
    $5 = HEAP32[$0 >> 2] | 0;
    label$10 : {
     $3 = ($6 - $2 | 0) & 3 | 0;
     if (!$3) {
      break label$10
     }
     label$11 : while (1) {
      $4 = $5 + ($2 << 2 | 0) | 0;
      $239 = $4;
      $4 = HEAP32[$4 >> 2] | 0;
      HEAP32[$239 >> 2] = $4 << 24 | 0 | (($4 << 8 | 0) & 16711680 | 0) | 0 | (($4 >>> 8 | 0) & 65280 | 0 | ($4 >>> 24 | 0) | 0) | 0;
      $2 = $2 + 1 | 0;
      $3 = $3 + -1 | 0;
      if ($3) {
       continue label$11
      }
      break label$11;
     };
    }
    label$12 : {
     if ($8 >>> 0 < 3 >>> 0) {
      break label$12
     }
     label$13 : while (1) {
      $4 = $5 + ($2 << 2 | 0) | 0;
      $3 = HEAP32[$4 >> 2] | 0;
      HEAP32[$4 >> 2] = $3 << 24 | 0 | (($3 << 8 | 0) & 16711680 | 0) | 0 | (($3 >>> 8 | 0) & 65280 | 0 | ($3 >>> 24 | 0) | 0) | 0;
      $3 = $4 + 4 | 0;
      $284 = $3;
      $3 = HEAP32[$3 >> 2] | 0;
      HEAP32[$284 >> 2] = $3 << 24 | 0 | (($3 << 8 | 0) & 16711680 | 0) | 0 | (($3 >>> 8 | 0) & 65280 | 0 | ($3 >>> 24 | 0) | 0) | 0;
      $3 = $4 + 8 | 0;
      $302 = $3;
      $3 = HEAP32[$3 >> 2] | 0;
      HEAP32[$302 >> 2] = $3 << 24 | 0 | (($3 << 8 | 0) & 16711680 | 0) | 0 | (($3 >>> 8 | 0) & 65280 | 0 | ($3 >>> 24 | 0) | 0) | 0;
      $4 = $4 + 12 | 0;
      $320 = $4;
      $4 = HEAP32[$4 >> 2] | 0;
      HEAP32[$320 >> 2] = $4 << 24 | 0 | (($4 << 8 | 0) & 16711680 | 0) | 0 | (($4 >>> 8 | 0) & 65280 | 0 | ($4 >>> 24 | 0) | 0) | 0;
      $2 = $2 + 4 | 0;
      if (($2 | 0) != ($6 | 0)) {
       continue label$13
      }
      break label$13;
     };
    }
    $3 = (HEAP32[($0 + 8 | 0) >> 2] | 0) << 2 | 0;
    $4 = HEAP32[($0 + 12 | 0) >> 2] | 0;
   }
   $2 = ($4 + $7 | 0) + $3 | 0;
   HEAP32[($0 + 12 | 0) >> 2] = $2 & 3 | 0;
   HEAP32[($0 + 8 | 0) >> 2] = $2 >>> 2 | 0;
   $4 = 1;
  }
  __stack_pointer = $1 + 16 | 0;
  return $4 | 0;
 }
 
 function FLAC__bitreader_read_raw_int32($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0;
  $3 = __stack_pointer - 16 | 0;
  __stack_pointer = $3;
  label$1 : {
   label$2 : {
    if (FLAC__bitreader_read_raw_uint32($0 | 0, $3 + 12 | 0 | 0, $2 | 0) | 0) {
     break label$2
    }
    $0 = 0;
    break label$1;
   }
   $0 = 1;
   $2 = 1 << ($2 + -1 | 0) | 0;
   HEAP32[$1 >> 2] = ((HEAP32[($3 + 12 | 0) >> 2] | 0) ^ $2 | 0) - $2 | 0;
  }
  __stack_pointer = $3 + 16 | 0;
  return $0 | 0;
 }
 
 function FLAC__bitreader_read_raw_uint64($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var i64toi32_i32$0 = 0, $3 = 0, i64toi32_i32$2 = 0, i64toi32_i32$1 = 0, i64toi32_i32$4 = 0, i64toi32_i32$3 = 0, $4 = 0, $15 = 0, $5 = 0, $5$hi = 0, $25$hi = 0, $27 = 0, $27$hi = 0;
  $3 = __stack_pointer - 16 | 0;
  __stack_pointer = $3;
  label$1 : {
   label$2 : {
    label$3 : {
     if ($2 >>> 0 < 33 >>> 0) {
      break label$3
     }
     $4 = 0;
     if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $3 + 12 | 0 | 0, $2 + -32 | 0 | 0) | 0)) {
      break label$1
     }
     if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $3 + 8 | 0 | 0, 32 | 0) | 0)) {
      break label$1
     }
     i64toi32_i32$2 = $3;
     i64toi32_i32$0 = HEAP32[($3 + 12 | 0) >> 2] | 0;
     i64toi32_i32$1 = 0;
     i64toi32_i32$2 = i64toi32_i32$0;
     i64toi32_i32$0 = 0;
     i64toi32_i32$3 = 32;
     i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
     if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
      i64toi32_i32$0 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
      $15 = 0;
     } else {
      i64toi32_i32$0 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$2 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$1 << i64toi32_i32$4 | 0) | 0;
      $15 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
     }
     $25$hi = i64toi32_i32$0;
     i64toi32_i32$1 = $3;
     i64toi32_i32$0 = HEAP32[($3 + 8 | 0) >> 2] | 0;
     i64toi32_i32$2 = 0;
     $27 = i64toi32_i32$0;
     $27$hi = i64toi32_i32$2;
     i64toi32_i32$2 = $25$hi;
     i64toi32_i32$1 = $15;
     i64toi32_i32$0 = $27$hi;
     i64toi32_i32$3 = $27;
     i64toi32_i32$0 = i64toi32_i32$2 | i64toi32_i32$0 | 0;
     $5 = i64toi32_i32$1 | i64toi32_i32$3 | 0;
     $5$hi = i64toi32_i32$0;
     break label$2;
    }
    label$4 : {
     if (FLAC__bitreader_read_raw_uint32($0 | 0, $3 + 8 | 0 | 0, $2 | 0) | 0) {
      break label$4
     }
     $4 = 0;
     break label$1;
    }
    i64toi32_i32$2 = $3;
    i64toi32_i32$0 = HEAP32[($3 + 8 | 0) >> 2] | 0;
    i64toi32_i32$1 = 0;
    $5 = i64toi32_i32$0;
    $5$hi = i64toi32_i32$1;
   }
   i64toi32_i32$1 = $5$hi;
   i64toi32_i32$0 = $1;
   HEAP32[i64toi32_i32$0 >> 2] = $5;
   HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
   $4 = 1;
  }
  __stack_pointer = $3 + 16 | 0;
  return $4 | 0;
 }
 
 function FLAC__bitreader_read_uint32_little_endian($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  $3 = 0;
  HEAP32[($2 + 8 | 0) >> 2] = 0;
  label$1 : {
   if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 8 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 12 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   $4 = HEAP32[($2 + 8 | 0) >> 2] | 0;
   $5 = HEAP32[($2 + 12 | 0) >> 2] | 0;
   if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 12 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   $6 = HEAP32[($2 + 12 | 0) >> 2] | 0;
   if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 12 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   HEAP32[$1 >> 2] = (HEAP32[($2 + 12 | 0) >> 2] | 0) << 24 | 0 | ($6 << 16 | 0 | ($4 | ($5 << 8 | 0) | 0) | 0) | 0;
   $3 = 1;
  }
  __stack_pointer = $2 + 16 | 0;
  return $3 | 0;
 }
 
 function FLAC__bitreader_skip_bits_no_crc($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $4 = 0, $2 = 0, $3 = 0, $5 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  $3 = 1;
  label$1 : {
   if (!$1) {
    break label$1
   }
   label$2 : {
    label$3 : {
     $4 = (HEAP32[($0 + 20 | 0) >> 2] | 0) & 7 | 0;
     if (!$4) {
      break label$3
     }
     $4 = 8 - $4 | 0;
     $4 = $4 >>> 0 < $1 >>> 0 ? $4 : $1;
     if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 8 | 0 | 0, $4 | 0) | 0)) {
      break label$2
     }
     $1 = $1 - $4 | 0;
    }
    label$4 : {
     if ($1 >>> 0 < 8 >>> 0) {
      break label$4
     }
     $4 = $1 >>> 3 | 0;
     label$5 : {
      label$6 : while (1) {
       label$7 : {
        if (HEAP32[($0 + 20 | 0) >> 2] | 0) {
         break label$7
        }
        label$8 : {
         if ($4 >>> 0 <= 3 >>> 0) {
          break label$8
         }
         label$9 : while (1) {
          label$10 : {
           label$11 : {
            $5 = HEAP32[($0 + 16 | 0) >> 2] | 0;
            if ($5 >>> 0 >= (HEAP32[($0 + 8 | 0) >> 2] | 0) >>> 0) {
             break label$11
            }
            HEAP32[($0 + 16 | 0) >> 2] = $5 + 1 | 0;
            $4 = $4 + -4 | 0;
            break label$10;
           }
           if (!(bitreader_read_from_client_($0 | 0) | 0)) {
            break label$2
           }
          }
          if ($4 >>> 0 > 3 >>> 0) {
           continue label$9
          }
          break label$9;
         };
         if (!$4) {
          break label$5
         }
        }
        label$12 : while (1) {
         if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 12 | 0 | 0, 8 | 0) | 0)) {
          break label$2
         }
         $4 = $4 + -1 | 0;
         if (!$4) {
          break label$5
         }
         continue label$12;
        };
       }
       if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 12 | 0 | 0, 8 | 0) | 0)) {
        break label$2
       }
       $4 = $4 + -1 | 0;
       if ($4) {
        continue label$6
       }
       break label$6;
      };
     }
     $1 = $1 & 7 | 0;
    }
    if (!$1) {
     break label$1
    }
    if (FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 8 | 0 | 0, $1 | 0) | 0) {
     break label$1
    }
   }
   $3 = 0;
  }
  __stack_pointer = $2 + 16 | 0;
  return $3 | 0;
 }
 
 function FLAC__bitreader_skip_byte_block_aligned_no_crc($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  $3 = 1;
  label$1 : {
   if (!$1) {
    break label$1
   }
   label$2 : {
    label$3 : while (1) {
     label$4 : {
      if (HEAP32[($0 + 20 | 0) >> 2] | 0) {
       break label$4
      }
      label$5 : {
       if ($1 >>> 0 <= 3 >>> 0) {
        break label$5
       }
       label$6 : while (1) {
        label$7 : {
         label$8 : {
          $4 = HEAP32[($0 + 16 | 0) >> 2] | 0;
          if ($4 >>> 0 >= (HEAP32[($0 + 8 | 0) >> 2] | 0) >>> 0) {
           break label$8
          }
          HEAP32[($0 + 16 | 0) >> 2] = $4 + 1 | 0;
          $1 = $1 + -4 | 0;
          break label$7;
         }
         if (!(bitreader_read_from_client_($0 | 0) | 0)) {
          break label$2
         }
        }
        if ($1 >>> 0 > 3 >>> 0) {
         continue label$6
        }
        break label$6;
       };
       if ($1) {
        break label$5
       }
       $3 = 1;
       break label$1;
      }
      label$9 : while (1) {
       if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 12 | 0 | 0, 8 | 0) | 0)) {
        break label$2
       }
       $1 = $1 + -1 | 0;
       if ($1) {
        continue label$9
       }
       break label$1;
      };
     }
     if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $2 + 12 | 0 | 0, 8 | 0) | 0)) {
      break label$2
     }
     $1 = $1 + -1 | 0;
     if ($1) {
      continue label$3
     }
     break label$1;
    };
   }
   $3 = 0;
  }
  __stack_pointer = $2 + 16 | 0;
  return $3 | 0;
 }
 
 function FLAC__bitreader_read_byte_block_aligned_no_crc($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $4 = 0, $3 = 0, $5 = 0;
  $3 = __stack_pointer - 16 | 0;
  __stack_pointer = $3;
  label$1 : {
   label$2 : {
    if ($2) {
     break label$2
    }
    $4 = 1;
    break label$1;
   }
   label$3 : while (1) {
    label$4 : {
     if (HEAP32[($0 + 20 | 0) >> 2] | 0) {
      break label$4
     }
     label$5 : {
      if ($2 >>> 0 <= 3 >>> 0) {
       break label$5
      }
      label$6 : while (1) {
       label$7 : {
        label$8 : {
         $4 = HEAP32[($0 + 16 | 0) >> 2] | 0;
         if ($4 >>> 0 >= (HEAP32[($0 + 8 | 0) >> 2] | 0) >>> 0) {
          break label$8
         }
         HEAP32[($0 + 16 | 0) >> 2] = $4 + 1 | 0;
         $4 = HEAP32[((HEAP32[$0 >> 2] | 0) + ($4 << 2 | 0) | 0) >> 2] | 0;
         $5 = $4 << 24 | 0 | (($4 << 8 | 0) & 16711680 | 0) | 0 | (($4 >>> 8 | 0) & 65280 | 0 | ($4 >>> 24 | 0) | 0) | 0;
         HEAP8[$1 >> 0] = $5;
         HEAP8[($1 + 1 | 0) >> 0] = $5 >>> 8 | 0;
         HEAP8[($1 + 2 | 0) >> 0] = $5 >>> 16 | 0;
         HEAP8[($1 + 3 | 0) >> 0] = $5 >>> 24 | 0;
         $2 = $2 + -4 | 0;
         $1 = $1 + 4 | 0;
         break label$7;
        }
        if (bitreader_read_from_client_($0 | 0) | 0) {
         break label$7
        }
        $4 = 0;
        break label$1;
       }
       if ($2 >>> 0 > 3 >>> 0) {
        continue label$6
       }
       break label$6;
      };
      if ($2) {
       break label$5
      }
      $4 = 1;
      break label$1;
     }
     label$9 : while (1) {
      label$10 : {
       if (FLAC__bitreader_read_raw_uint32($0 | 0, $3 + 12 | 0 | 0, 8 | 0) | 0) {
        break label$10
       }
       $4 = 0;
       break label$1;
      }
      HEAP8[$1 >> 0] = HEAP32[($3 + 12 | 0) >> 2] | 0;
      $4 = 1;
      $1 = $1 + 1 | 0;
      $2 = $2 + -1 | 0;
      if ($2) {
       continue label$9
      }
      break label$1;
     };
    }
    label$11 : {
     if (FLAC__bitreader_read_raw_uint32($0 | 0, $3 + 12 | 0 | 0, 8 | 0) | 0) {
      break label$11
     }
     $4 = 0;
     break label$1;
    }
    HEAP8[$1 >> 0] = HEAP32[($3 + 12 | 0) >> 2] | 0;
    $4 = 1;
    $1 = $1 + 1 | 0;
    $2 = $2 + -1 | 0;
    if ($2) {
     continue label$3
    }
    break label$3;
   };
  }
  __stack_pointer = $3 + 16 | 0;
  return $4 | 0;
 }
 
 function FLAC__bitreader_read_unary_unsigned($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0;
  HEAP32[$1 >> 2] = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : while (1) {
      label$5 : {
       label$6 : {
        $2 = HEAP32[($0 + 16 | 0) >> 2] | 0;
        if ($2 >>> 0 < (HEAP32[($0 + 8 | 0) >> 2] | 0) >>> 0) {
         break label$6
        }
        $3 = HEAP32[($0 + 20 | 0) >> 2] | 0;
        break label$5;
       }
       $3 = HEAP32[($0 + 20 | 0) >> 2] | 0;
       $4 = HEAP32[$0 >> 2] | 0;
       label$7 : while (1) {
        label$8 : {
         $2 = (HEAP32[($4 + ($2 << 2 | 0) | 0) >> 2] | 0) << $3 | 0;
         if (!$2) {
          break label$8
         }
         $2 = Math_clz32($2);
         HEAP32[$1 >> 2] = (HEAP32[$1 >> 2] | 0) + $2 | 0;
         $3 = 1;
         $2 = ($2 + (HEAP32[($0 + 20 | 0) >> 2] | 0) | 0) + 1 | 0;
         HEAP32[($0 + 20 | 0) >> 2] = $2;
         if ($2 >>> 0 < 32 >>> 0) {
          break label$1
         }
         HEAP32[($0 + 16 | 0) >> 2] = (HEAP32[($0 + 16 | 0) >> 2] | 0) + 1 | 0;
         $3 = 0;
         break label$2;
        }
        HEAP32[$1 >> 2] = ((HEAP32[$1 >> 2] | 0) - $3 | 0) + 32 | 0;
        $3 = 0;
        HEAP32[($0 + 20 | 0) >> 2] = 0;
        $2 = (HEAP32[($0 + 16 | 0) >> 2] | 0) + 1 | 0;
        HEAP32[($0 + 16 | 0) >> 2] = $2;
        if ($2 >>> 0 < (HEAP32[($0 + 8 | 0) >> 2] | 0) >>> 0) {
         continue label$7
        }
        break label$7;
       };
      }
      label$9 : {
       $4 = (HEAP32[($0 + 12 | 0) >> 2] | 0) << 3 | 0;
       if ($4 >>> 0 <= $3 >>> 0) {
        break label$9
       }
       $2 = ((HEAP32[((HEAP32[$0 >> 2] | 0) + ($2 << 2 | 0) | 0) >> 2] | 0) & (-1 << (32 - $4 | 0) | 0) | 0) << $3 | 0;
       if ($2) {
        break label$3
       }
       HEAP32[$1 >> 2] = ($4 - $3 | 0) + (HEAP32[$1 >> 2] | 0) | 0;
       HEAP32[($0 + 20 | 0) >> 2] = $4;
      }
      if (bitreader_read_from_client_($0 | 0) | 0) {
       continue label$4
      }
      break label$4;
     };
     return 0 | 0;
    }
    $3 = Math_clz32($2);
    HEAP32[$1 >> 2] = (HEAP32[$1 >> 2] | 0) + $3 | 0;
    $3 = ($3 + (HEAP32[($0 + 20 | 0) >> 2] | 0) | 0) + 1 | 0;
   }
   HEAP32[($0 + 20 | 0) >> 2] = $3;
   $3 = 1;
  }
  return $3 | 0;
 }
 
 function FLAC__bitreader_read_rice_signed_block($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $7 = 0, $12 = 0, $13 = 0, $9 = 0, $4 = 0, $15 = 0, $8 = 0, $6 = 0, $10 = 0, $5 = 0, $11 = 0, $14 = 0;
  $4 = __stack_pointer - 16 | 0;
  __stack_pointer = $4;
  $5 = $1 + ($2 << 2 | 0) | 0;
  label$1 : {
   label$2 : {
    if ($3) {
     break label$2
    }
    $6 = 1;
    if (($2 | 0) < (1 | 0)) {
     break label$1
    }
    label$3 : while (1) {
     label$4 : {
      if (FLAC__bitreader_read_unary_unsigned($0 | 0, $4 + 8 | 0 | 0) | 0) {
       break label$4
      }
      $6 = 0;
      break label$1;
     }
     $6 = 1;
     $2 = HEAP32[($4 + 8 | 0) >> 2] | 0;
     HEAP32[$1 >> 2] = ($2 >>> 1 | 0) ^ (0 - ($2 & 1 | 0) | 0) | 0;
     $1 = $1 + 4 | 0;
     if ($1 >>> 0 < $5 >>> 0) {
      continue label$3
     }
     break label$1;
    };
   }
   $6 = 0;
   label$5 : {
    label$6 : {
     label$7 : {
      $7 = HEAP32[($0 + 16 | 0) >> 2] | 0;
      $8 = HEAP32[($0 + 8 | 0) >> 2] | 0;
      if ($7 >>> 0 < $8 >>> 0) {
       break label$7
      }
      $9 = 0;
      break label$6;
     }
     $10 = HEAP32[$0 >> 2] | 0;
     $11 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     $12 = (HEAP32[($10 + ($7 << 2 | 0) | 0) >> 2] | 0) << $11 | 0;
     $2 = 0;
     break label$5;
    }
    $2 = 1;
   }
   label$8 : while (1) {
    label$9 : {
     label$10 : {
      label$11 : {
       label$12 : {
        label$13 : {
         switch ($2 | 0) {
         case 0:
          $13 = 32 - $11 | 0;
          label$15 : {
           label$16 : {
            if ($1 >>> 0 >= $5 >>> 0) {
             break label$16
            }
            $14 = 32 - $3 | 0;
            label$17 : while (1) {
             $2 = $7;
             $9 = $13;
             label$18 : {
              label$19 : {
               if (!$12) {
                break label$19
               }
               $2 = $7;
               $9 = Math_clz32($12);
               $15 = $9;
               break label$18;
              }
              label$20 : while (1) {
               $2 = $2 + 1 | 0;
               if ($2 >>> 0 >= $8 >>> 0) {
                break label$15
               }
               $12 = HEAP32[($10 + ($2 << 2 | 0) | 0) >> 2] | 0;
               $15 = Math_clz32($12);
               $9 = $15 + $9 | 0;
               if (!$12) {
                continue label$20
               }
               break label$20;
              };
             }
             $12 = ($12 << $15 | 0) << 1 | 0;
             $15 = $12 >>> $14 | 0;
             HEAP32[($4 + 8 | 0) >> 2] = $9;
             label$21 : {
              label$22 : {
               $13 = ($13 + ($9 ^ -1 | 0) | 0) & 31 | 0;
               if ($13 >>> 0 < $3 >>> 0) {
                break label$22
               }
               $12 = $12 << $3 | 0;
               $13 = $13 - $3 | 0;
               $7 = $2;
               break label$21;
              }
              $7 = $2 + 1 | 0;
              if ($7 >>> 0 >= $8 >>> 0) {
               break label$12
              }
              $2 = HEAP32[($10 + ($7 << 2 | 0) | 0) >> 2] | 0;
              $13 = $13 + $14 | 0;
              $12 = $2 << (32 - $13 | 0) | 0;
              $15 = $2 >>> $13 | 0 | $15 | 0;
             }
             HEAP32[($4 + 12 | 0) >> 2] = $15;
             $2 = $15 | ($9 << $3 | 0) | 0;
             HEAP32[$1 >> 2] = ($2 >>> 1 | 0) ^ (0 - ($2 & 1 | 0) | 0) | 0;
             $1 = $1 + 4 | 0;
             if ($1 >>> 0 < $5 >>> 0) {
              continue label$17
             }
             break label$17;
            };
           }
           $2 = $7 >>> 0 < $8 >>> 0;
           HEAP32[($0 + 16 | 0) >> 2] = $7 + (!$13 & $2 | 0) | 0;
           HEAP32[($0 + 20 | 0) >> 2] = 32 - ($13 ? $13 : $2 << 5 | 0) | 0;
           $6 = 1;
           break label$1;
          }
          HEAP32[($0 + 20 | 0) >> 2] = 0;
          $2 = $7 + 1 | 0;
          HEAP32[($0 + 16 | 0) >> 2] = $8 >>> 0 > $2 >>> 0 ? $8 : $2;
          break label$10;
         default:
          break label$13;
         };
        }
        if (!(FLAC__bitreader_read_unary_unsigned($0 | 0, $4 + 8 | 0 | 0) | 0)) {
         break label$1
        }
        $9 = (HEAP32[($4 + 8 | 0) >> 2] | 0) + $9 | 0;
        HEAP32[($4 + 8 | 0) >> 2] = $9;
        $15 = 0;
        $13 = 0;
        break label$11;
       }
       HEAP32[($0 + 16 | 0) >> 2] = $7;
       HEAP32[($0 + 20 | 0) >> 2] = 0;
      }
      if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $4 + 12 | 0 | 0, $3 - $13 | 0 | 0) | 0)) {
       break label$1
      }
      $2 = $9 << $3 | 0;
      $12 = HEAP32[($4 + 12 | 0) >> 2] | 0 | $15 | 0;
      HEAP32[($4 + 12 | 0) >> 2] = $12;
      $9 = 0;
      $2 = $2 | $12 | 0;
      HEAP32[$1 >> 2] = ($2 >>> 1 | 0) ^ (0 - ($2 & 1 | 0) | 0) | 0;
      $1 = $1 + 4 | 0;
      $10 = HEAP32[$0 >> 2] | 0;
      $7 = HEAP32[($0 + 16 | 0) >> 2] | 0;
      $11 = HEAP32[($0 + 20 | 0) >> 2] | 0;
      $12 = (HEAP32[($10 + ($7 << 2 | 0) | 0) >> 2] | 0) << $11 | 0;
      $8 = HEAP32[($0 + 8 | 0) >> 2] | 0;
      if ($7 >>> 0 < $8 >>> 0) {
       break label$9
      }
      if ($1 >>> 0 >= $5 >>> 0) {
       break label$9
      }
     }
     $2 = 1;
     continue label$8;
    }
    $2 = 0;
    continue label$8;
   };
  }
  __stack_pointer = $4 + 16 | 0;
  return $6 | 0;
 }
 
 function FLAC__bitreader_read_utf8_uint32($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $6 = 0, $7 = 0, $8 = 0, $4 = 0, $5 = 0, $9 = 0;
  $4 = __stack_pointer - 16 | 0;
  __stack_pointer = $4;
  $5 = 0;
  label$1 : {
   if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $4 + 12 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   $6 = HEAP32[($4 + 12 | 0) >> 2] | 0;
   label$2 : {
    if (!$2) {
     break label$2
    }
    $7 = HEAP32[$3 >> 2] | 0;
    HEAP32[$3 >> 2] = $7 + 1 | 0;
    HEAP8[($2 + $7 | 0) >> 0] = $6;
   }
   label$3 : {
    label$4 : {
     if ($6 & 128 | 0) {
      break label$4
     }
     $7 = $6;
     break label$3;
    }
    label$5 : {
     label$6 : {
      if (!($6 & 192 | 0)) {
       break label$6
      }
      if ($6 & 32 | 0) {
       break label$6
      }
      $8 = 1;
      $7 = 31;
      break label$5;
     }
     label$7 : {
      if (!($6 & 224 | 0)) {
       break label$7
      }
      if ($6 & 16 | 0) {
       break label$7
      }
      $8 = 2;
      $7 = 15;
      break label$5;
     }
     label$8 : {
      if (!($6 & 240 | 0)) {
       break label$8
      }
      if ($6 & 8 | 0) {
       break label$8
      }
      $8 = 3;
      $7 = 7;
      break label$5;
     }
     label$9 : {
      if (!($6 & 248 | 0)) {
       break label$9
      }
      $8 = 4;
      $7 = 3;
      if (!($6 & 4 | 0)) {
       break label$5
      }
     }
     $7 = -1;
     if (!($6 & 252 | 0)) {
      break label$3
     }
     if ($6 & 2 | 0) {
      break label$3
     }
     $8 = 5;
     $7 = 1;
    }
    $7 = $6 & $7 | 0;
    label$10 : {
     if ($2) {
      break label$10
     }
     label$11 : while (1) {
      if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $4 + 12 | 0 | 0, 8 | 0) | 0)) {
       break label$1
      }
      label$12 : {
       $6 = HEAP32[($4 + 12 | 0) >> 2] | 0;
       if (($6 & 192 | 0 | 0) == (128 | 0)) {
        break label$12
       }
       $7 = -1;
       break label$3;
      }
      $7 = $6 & 63 | 0 | ($7 << 6 | 0) | 0;
      $8 = $8 + -1 | 0;
      if ($8) {
       continue label$11
      }
      break label$3;
     };
    }
    label$13 : while (1) {
     if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $4 + 12 | 0 | 0, 8 | 0) | 0)) {
      break label$1
     }
     $6 = HEAP32[($4 + 12 | 0) >> 2] | 0;
     $9 = HEAP32[$3 >> 2] | 0;
     HEAP32[$3 >> 2] = $9 + 1 | 0;
     HEAP8[($2 + $9 | 0) >> 0] = $6;
     label$14 : {
      if (($6 & 192 | 0 | 0) == (128 | 0)) {
       break label$14
      }
      $7 = -1;
      break label$3;
     }
     $7 = $6 & 63 | 0 | ($7 << 6 | 0) | 0;
     $8 = $8 + -1 | 0;
     if ($8) {
      continue label$13
     }
     break label$13;
    };
   }
   HEAP32[$1 >> 2] = $7;
   $5 = 1;
  }
  __stack_pointer = $4 + 16 | 0;
  return $5 | 0;
 }
 
 function FLAC__bitreader_read_utf8_uint64($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $6 = 0, i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, $7 = 0, i64toi32_i32$4 = 0, $8 = 0, $8$hi = 0, i64toi32_i32$3 = 0, $4 = 0, $5 = 0, $20 = 0, $9 = 0, $21 = 0, $88$hi = 0, $91$hi = 0, $116$hi = 0, $119$hi = 0;
  $4 = __stack_pointer - 16 | 0;
  __stack_pointer = $4;
  $5 = 0;
  label$1 : {
   if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $4 + 12 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   $6 = HEAP32[($4 + 12 | 0) >> 2] | 0;
   label$2 : {
    if (!$2) {
     break label$2
    }
    $7 = HEAP32[$3 >> 2] | 0;
    HEAP32[$3 >> 2] = $7 + 1 | 0;
    HEAP8[($2 + $7 | 0) >> 0] = $6;
   }
   label$3 : {
    label$4 : {
     if (!($6 & 128 | 0)) {
      break label$4
     }
     label$5 : {
      label$6 : {
       if (!($6 & 192 | 0)) {
        break label$6
       }
       if ($6 & 32 | 0) {
        break label$6
       }
       $6 = $6 & 31 | 0;
       $7 = 1;
       break label$5;
      }
      label$7 : {
       if (!($6 & 224 | 0)) {
        break label$7
       }
       if ($6 & 16 | 0) {
        break label$7
       }
       $6 = $6 & 15 | 0;
       $7 = 2;
       break label$5;
      }
      label$8 : {
       if (!($6 & 240 | 0)) {
        break label$8
       }
       if ($6 & 8 | 0) {
        break label$8
       }
       $6 = $6 & 7 | 0;
       $7 = 3;
       break label$5;
      }
      label$9 : {
       if (!($6 & 248 | 0)) {
        break label$9
       }
       if ($6 & 4 | 0) {
        break label$9
       }
       $6 = $6 & 3 | 0;
       $7 = 4;
       break label$5;
      }
      label$10 : {
       if (!($6 & 252 | 0)) {
        break label$10
       }
       if ($6 & 2 | 0) {
        break label$10
       }
       $6 = $6 & 1 | 0;
       $7 = 5;
       break label$5;
      }
      i64toi32_i32$0 = -1;
      $8 = -1;
      $8$hi = i64toi32_i32$0;
      if (!($6 & 254 | 0)) {
       break label$3
      }
      if ($6 & 1 | 0) {
       break label$3
      }
      $7 = 6;
      $6 = 0;
     }
     i64toi32_i32$0 = 0;
     $8 = $6;
     $8$hi = i64toi32_i32$0;
     label$11 : {
      if ($2) {
       break label$11
      }
      label$12 : while (1) {
       if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $4 + 12 | 0 | 0, 8 | 0) | 0)) {
        break label$1
       }
       label$13 : {
        $6 = HEAP32[($4 + 12 | 0) >> 2] | 0;
        if (($6 & 192 | 0 | 0) == (128 | 0)) {
         break label$13
        }
        i64toi32_i32$0 = -1;
        $8 = -1;
        $8$hi = i64toi32_i32$0;
        break label$3;
       }
       i64toi32_i32$0 = $8$hi;
       i64toi32_i32$2 = $8;
       i64toi32_i32$1 = 0;
       i64toi32_i32$3 = 6;
       i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
        $20 = 0;
       } else {
        i64toi32_i32$1 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$2 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$0 << i64toi32_i32$4 | 0) | 0;
        $20 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
       }
       $88$hi = i64toi32_i32$1;
       i64toi32_i32$1 = 0;
       $91$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $88$hi;
       i64toi32_i32$0 = $20;
       i64toi32_i32$2 = $91$hi;
       i64toi32_i32$3 = $6 & 63 | 0;
       i64toi32_i32$2 = i64toi32_i32$1 | i64toi32_i32$2 | 0;
       $8 = i64toi32_i32$0 | i64toi32_i32$3 | 0;
       $8$hi = i64toi32_i32$2;
       $7 = $7 + -1 | 0;
       if ($7) {
        continue label$12
       }
       break label$3;
      };
     }
     label$14 : while (1) {
      if (!(FLAC__bitreader_read_raw_uint32($0 | 0, $4 + 12 | 0 | 0, 8 | 0) | 0)) {
       break label$1
      }
      $6 = HEAP32[($4 + 12 | 0) >> 2] | 0;
      $9 = HEAP32[$3 >> 2] | 0;
      HEAP32[$3 >> 2] = $9 + 1 | 0;
      HEAP8[($2 + $9 | 0) >> 0] = $6;
      label$15 : {
       if (($6 & 192 | 0 | 0) == (128 | 0)) {
        break label$15
       }
       i64toi32_i32$2 = -1;
       $8 = -1;
       $8$hi = i64toi32_i32$2;
       break label$3;
      }
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$1 = $8;
      i64toi32_i32$0 = 0;
      i64toi32_i32$3 = 6;
      i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$1 << i64toi32_i32$4 | 0;
       $21 = 0;
      } else {
       i64toi32_i32$0 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$1 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$2 << i64toi32_i32$4 | 0) | 0;
       $21 = i64toi32_i32$1 << i64toi32_i32$4 | 0;
      }
      $116$hi = i64toi32_i32$0;
      i64toi32_i32$0 = 0;
      $119$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $116$hi;
      i64toi32_i32$2 = $21;
      i64toi32_i32$1 = $119$hi;
      i64toi32_i32$3 = $6 & 63 | 0;
      i64toi32_i32$1 = i64toi32_i32$0 | i64toi32_i32$1 | 0;
      $8 = i64toi32_i32$2 | i64toi32_i32$3 | 0;
      $8$hi = i64toi32_i32$1;
      $7 = $7 + -1 | 0;
      if ($7) {
       continue label$14
      }
      break label$3;
     };
    }
    i64toi32_i32$1 = 0;
    $8 = $6;
    $8$hi = i64toi32_i32$1;
   }
   i64toi32_i32$1 = $8$hi;
   i64toi32_i32$2 = $1;
   HEAP32[i64toi32_i32$2 >> 2] = $8;
   HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] = i64toi32_i32$1;
   $5 = 1;
  }
  __stack_pointer = $4 + 16 | 0;
  return $5 | 0;
 }
 
 function qsort($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0, $8 = 0, $7 = 0, $5 = 0, $6 = 0, $33 = 0, $126 = 0;
  $4 = __stack_pointer - 208 | 0;
  __stack_pointer = $4;
  HEAP32[($4 + 8 | 0) >> 2] = 1;
  HEAP32[($4 + 12 | 0) >> 2] = 0;
  label$1 : {
   $5 = Math_imul($2, $1);
   if (!$5) {
    break label$1
   }
   HEAP32[($4 + 16 | 0) >> 2] = $2;
   HEAP32[($4 + 20 | 0) >> 2] = $2;
   $6 = 0 - $2 | 0;
   $1 = $2;
   $7 = $1;
   $8 = 2;
   label$2 : while (1) {
    $33 = $7 + $2 | 0;
    $7 = $1;
    $1 = $33 + $1 | 0;
    HEAP32[(($4 + 16 | 0) + ($8 << 2 | 0) | 0) >> 2] = $1;
    $8 = $8 + 1 | 0;
    if ($1 >>> 0 < $5 >>> 0) {
     continue label$2
    }
    break label$2;
   };
   label$3 : {
    label$4 : {
     $7 = ($0 + $5 | 0) + $6 | 0;
     if ($7 >>> 0 > $0 >>> 0) {
      break label$4
     }
     $8 = 1;
     $1 = 1;
     break label$3;
    }
    $8 = 1;
    $1 = 1;
    label$5 : while (1) {
     label$6 : {
      label$7 : {
       if (($8 & 3 | 0 | 0) != (3 | 0)) {
        break label$7
       }
       sift($0 | 0, $2 | 0, $3 | 0, $1 | 0, $4 + 16 | 0 | 0);
       shr($4 + 8 | 0 | 0, 2 | 0);
       $1 = $1 + 2 | 0;
       break label$6;
      }
      label$8 : {
       label$9 : {
        $8 = $1 + -1 | 0;
        if ((HEAP32[(($4 + 16 | 0) + ($8 << 2 | 0) | 0) >> 2] | 0) >>> 0 < ($7 - $0 | 0) >>> 0) {
         break label$9
        }
        trinkle($0 | 0, $2 | 0, $3 | 0, $4 + 8 | 0 | 0, $1 | 0, 0 | 0, $4 + 16 | 0 | 0);
        break label$8;
       }
       sift($0 | 0, $2 | 0, $3 | 0, $1 | 0, $4 + 16 | 0 | 0);
      }
      label$10 : {
       if (($1 | 0) != (1 | 0)) {
        break label$10
       }
       shl($4 + 8 | 0 | 0, 1 | 0);
       $1 = 0;
       break label$6;
      }
      shl($4 + 8 | 0 | 0, $8 | 0);
      $1 = 1;
     }
     $8 = HEAP32[($4 + 8 | 0) >> 2] | 0 | 1 | 0;
     HEAP32[($4 + 8 | 0) >> 2] = $8;
     $0 = $0 + $2 | 0;
     if ($0 >>> 0 < $7 >>> 0) {
      continue label$5
     }
     break label$5;
    };
   }
   trinkle($0 | 0, $2 | 0, $3 | 0, $4 + 8 | 0 | 0, $1 | 0, 0 | 0, $4 + 16 | 0 | 0);
   label$11 : while (1) {
    label$12 : {
     label$13 : {
      label$14 : {
       label$15 : {
        if (($1 | 0) != (1 | 0)) {
         break label$15
        }
        if (($8 | 0) != (1 | 0)) {
         break label$15
        }
        if (HEAP32[($4 + 12 | 0) >> 2] | 0) {
         break label$14
        }
        break label$1;
       }
       if (($1 | 0) > (1 | 0)) {
        break label$13
       }
      }
      $126 = $4 + 8 | 0;
      $8 = pntz($4 + 8 | 0 | 0) | 0;
      shr($126 | 0, $8 | 0);
      $1 = $8 + $1 | 0;
      $8 = HEAP32[($4 + 8 | 0) >> 2] | 0;
      break label$12;
     }
     shl($4 + 8 | 0 | 0, 2 | 0);
     HEAP32[($4 + 8 | 0) >> 2] = (HEAP32[($4 + 8 | 0) >> 2] | 0) ^ 7 | 0;
     shr($4 + 8 | 0 | 0, 1 | 0);
     $5 = $0 + $6 | 0;
     $7 = $1 + -2 | 0;
     trinkle($5 - (HEAP32[(($4 + 16 | 0) + ($7 << 2 | 0) | 0) >> 2] | 0) | 0 | 0, $2 | 0, $3 | 0, $4 + 8 | 0 | 0, $1 + -1 | 0 | 0, 1 | 0, $4 + 16 | 0 | 0);
     shl($4 + 8 | 0 | 0, 1 | 0);
     $8 = HEAP32[($4 + 8 | 0) >> 2] | 0 | 1 | 0;
     HEAP32[($4 + 8 | 0) >> 2] = $8;
     trinkle($5 | 0, $2 | 0, $3 | 0, $4 + 8 | 0 | 0, $7 | 0, 1 | 0, $4 + 16 | 0 | 0);
     $1 = $7;
    }
    $0 = $0 + $6 | 0;
    continue label$11;
   };
  }
  __stack_pointer = $4 + 208 | 0;
 }
 
 function sift($0, $1, $2, $3, $4) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  var $8 = 0, $5 = 0, $6 = 0, $10 = 0, $9 = 0, $11 = 0, $7 = 0;
  $5 = __stack_pointer - 240 | 0;
  __stack_pointer = $5;
  HEAP32[$5 >> 2] = $0;
  $6 = 1;
  label$1 : {
   if (($3 | 0) < (2 | 0)) {
    break label$1
   }
   $7 = 0 - $1 | 0;
   $8 = $0;
   label$2 : while (1) {
    label$3 : {
     $8 = $8 + $7 | 0;
     $9 = $3 + -2 | 0;
     $10 = $8 - (HEAP32[($4 + ($9 << 2 | 0) | 0) >> 2] | 0) | 0;
     if ((FUNCTION_TABLE[$2 | 0]($0, $10) | 0 | 0) < (0 | 0)) {
      break label$3
     }
     if ((FUNCTION_TABLE[$2 | 0]($0, $8) | 0 | 0) > (-1 | 0)) {
      break label$1
     }
    }
    $11 = (FUNCTION_TABLE[$2 | 0]($10, $8) | 0 | 0) > (-1 | 0);
    $8 = $11 ? $10 : $8;
    HEAP32[($5 + ($6 << 2 | 0) | 0) >> 2] = $8;
    $6 = $6 + 1 | 0;
    $3 = $11 ? $3 + -1 | 0 : $9;
    if (($3 | 0) > (1 | 0)) {
     continue label$2
    }
    break label$2;
   };
  }
  cycle($1 | 0, $5 | 0, $6 | 0);
  __stack_pointer = $5 + 240 | 0;
 }
 
 function shr($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $2 = 0;
  label$1 : {
   label$2 : {
    if ($1 >>> 0 > 31 >>> 0) {
     break label$2
    }
    $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    $3 = $0;
    break label$1;
   }
   $3 = $0 + 4 | 0;
   $1 = $1 + -32 | 0;
   $2 = 0;
  }
  $3 = HEAP32[$3 >> 2] | 0;
  HEAP32[($0 + 4 | 0) >> 2] = $2 >>> $1 | 0;
  HEAP32[$0 >> 2] = $2 << (32 - $1 | 0) | 0 | ($3 >>> $1 | 0) | 0;
 }
 
 function trinkle($0, $1, $2, $3, $4, $5, $6) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  var $7 = 0, $10 = 0, $8 = 0, $11 = 0, $9 = 0, $76 = 0;
  $7 = __stack_pointer - 240 | 0;
  __stack_pointer = $7;
  $8 = HEAP32[$3 >> 2] | 0;
  HEAP32[($7 + 232 | 0) >> 2] = $8;
  $3 = HEAP32[($3 + 4 | 0) >> 2] | 0;
  HEAP32[$7 >> 2] = $0;
  HEAP32[($7 + 236 | 0) >> 2] = $3;
  $9 = 0 - $1 | 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       if (($8 | 0) == (1 | 0)) {
        break label$5
       }
       $10 = $0;
       $8 = 1;
       break label$4;
      }
      $10 = $0;
      $8 = 1;
      if ($3) {
       break label$4
      }
      $8 = 1;
      $3 = $0;
      break label$3;
     }
     label$6 : while (1) {
      label$7 : {
       $3 = $10 - (HEAP32[($6 + ($4 << 2 | 0) | 0) >> 2] | 0) | 0;
       if ((FUNCTION_TABLE[$2 | 0]($3, $0) | 0 | 0) >= (1 | 0)) {
        break label$7
       }
       $3 = $10;
       break label$3;
      }
      label$8 : {
       label$9 : {
        if ($5) {
         break label$9
        }
        if (($4 | 0) < (2 | 0)) {
         break label$9
        }
        $5 = HEAP32[((($4 << 2 | 0) + $6 | 0) + -8 | 0) >> 2] | 0;
        $11 = $10 + $9 | 0;
        if ((FUNCTION_TABLE[$2 | 0]($11, $3) | 0 | 0) > (-1 | 0)) {
         break label$8
        }
        if ((FUNCTION_TABLE[$2 | 0]($11 - $5 | 0, $3) | 0 | 0) > (-1 | 0)) {
         break label$8
        }
       }
       HEAP32[($7 + ($8 << 2 | 0) | 0) >> 2] = $3;
       $76 = $7 + 232 | 0;
       $10 = pntz($7 + 232 | 0 | 0) | 0;
       shr($76 | 0, $10 | 0);
       $8 = $8 + 1 | 0;
       $4 = $10 + $4 | 0;
       $5 = 0;
       $10 = $3;
       if ((HEAP32[($7 + 232 | 0) >> 2] | 0 | 0) != (1 | 0)) {
        continue label$6
       }
       $10 = $3;
       if (HEAP32[($7 + 236 | 0) >> 2] | 0) {
        continue label$6
       }
       break label$2;
      }
      break label$6;
     };
     $3 = $10;
     break label$2;
    }
    if ($5) {
     break label$1
    }
   }
   cycle($1 | 0, $7 | 0, $8 | 0);
   sift($3 | 0, $1 | 0, $2 | 0, $4 | 0, $6 | 0);
  }
  __stack_pointer = $7 + 240 | 0;
 }
 
 function shl($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0;
  label$1 : {
   label$2 : {
    if ($1 >>> 0 > 31 >>> 0) {
     break label$2
    }
    $2 = $0 + 4 | 0;
    $3 = HEAP32[$0 >> 2] | 0;
    break label$1;
   }
   $1 = $1 + -32 | 0;
   $3 = 0;
   $2 = $0;
  }
  $2 = HEAP32[$2 >> 2] | 0;
  HEAP32[$0 >> 2] = $3 << $1 | 0;
  HEAP32[($0 + 4 | 0) >> 2] = $3 >>> (32 - $1 | 0) | 0 | ($2 << $1 | 0) | 0;
 }
 
 function pntz($0) {
  $0 = $0 | 0;
  var $1 = 0;
  label$1 : {
   $1 = __wasm_ctz_i32((HEAP32[$0 >> 2] | 0) + -1 | 0 | 0) | 0;
   if ($1) {
    break label$1
   }
   $0 = __wasm_ctz_i32(HEAP32[($0 + 4 | 0) >> 2] | 0 | 0) | 0;
   $1 = $0 ? $0 + 32 | 0 : 0;
  }
  return $1 | 0;
 }
 
 function cycle($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $5 = 0, $3 = 0, $6 = 0, $7 = 0, $4 = 0;
  $3 = __stack_pointer - 256 | 0;
  __stack_pointer = $3;
  label$1 : {
   if (($2 | 0) < (2 | 0)) {
    break label$1
   }
   $4 = $1 + ($2 << 2 | 0) | 0;
   HEAP32[$4 >> 2] = $3;
   if (!$0) {
    break label$1
   }
   $5 = $3;
   label$2 : while (1) {
    $6 = $0 >>> 0 < 256 >>> 0 ? $0 : 256;
    __memcpy($5 | 0, HEAP32[$1 >> 2] | 0 | 0, $6 | 0) | 0;
    $5 = 0;
    label$3 : while (1) {
     $7 = $1 + ($5 << 2 | 0) | 0;
     $5 = $5 + 1 | 0;
     __memcpy(HEAP32[$7 >> 2] | 0 | 0, HEAP32[($1 + ($5 << 2 | 0) | 0) >> 2] | 0 | 0, $6 | 0) | 0;
     HEAP32[$7 >> 2] = (HEAP32[$7 >> 2] | 0) + $6 | 0;
     if (($5 | 0) != ($2 | 0)) {
      continue label$3
     }
     break label$3;
    };
    $0 = $0 - $6 | 0;
    if (!$0) {
     break label$1
    }
    $5 = HEAP32[$4 >> 2] | 0;
    continue label$2;
   };
  }
  __stack_pointer = $3 + 256 | 0;
 }
 
 function FLAC__format_sample_rate_is_valid($0) {
  $0 = $0 | 0;
  return ($0 + -1 | 0) >>> 0 < 655350 >>> 0 | 0;
 }
 
 function FLAC__format_blocksize_is_subset($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  return $0 >>> 0 < 16385 >>> 0 & ($1 >>> 0 > 48e3 >>> 0 | $0 >>> 0 < 4609 >>> 0 | 0) | 0 | 0;
 }
 
 function FLAC__format_sample_rate_is_subset($0) {
  $0 = $0 | 0;
  var $1 = 0;
  $1 = 0;
  label$1 : {
   if (($0 + -1 | 0) >>> 0 > 655349 >>> 0) {
    break label$1
   }
   $1 = !(($0 >>> 0) % (10 >>> 0) | 0) | ($0 >>> 0 < 65536 >>> 0 | !(($0 >>> 0) % (1e3 >>> 0) | 0) | 0) | 0;
  }
  return $1 | 0;
 }
 
 function FLAC__format_seektable_is_legal($0) {
  $0 = $0 | 0;
  var i64toi32_i32$0 = 0, $3$hi = 0, i64toi32_i32$2 = 0, i64toi32_i32$1 = 0, $3 = 0, $1 = 0, $4 = 0, $5$hi = 0, $2 = 0, $5 = 0;
  label$1 : {
   $1 = HEAP32[$0 >> 2] | 0;
   if ($1) {
    break label$1
   }
   return 1 | 0;
  }
  $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
  $0 = 0;
  i64toi32_i32$0 = 0;
  $3 = 0;
  $3$hi = i64toi32_i32$0;
  $4 = 1;
  label$2 : while (1) {
   i64toi32_i32$0 = $3$hi;
   $5 = $3;
   $5$hi = i64toi32_i32$0;
   i64toi32_i32$2 = $2 + Math_imul($0, 24) | 0;
   i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
   i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
   $3 = i64toi32_i32$0;
   $3$hi = i64toi32_i32$1;
   label$3 : {
    if ($4 & 1 | 0) {
     break label$3
    }
    i64toi32_i32$1 = $3$hi;
    i64toi32_i32$2 = $3;
    i64toi32_i32$0 = -1;
    if ((i64toi32_i32$2 | 0) == (-1 | 0) & ($3$hi | 0) == (i64toi32_i32$0 | 0) | 0) {
     break label$3
    }
    i64toi32_i32$2 = $3$hi;
    i64toi32_i32$2 = $5$hi;
    i64toi32_i32$2 = $3$hi;
    i64toi32_i32$1 = $5$hi;
    i64toi32_i32$0 = $5;
    if ($3$hi >>> 0 > i64toi32_i32$1 >>> 0 | (($3$hi | 0) == (i64toi32_i32$1 | 0) & $3 >>> 0 > i64toi32_i32$0 >>> 0 | 0) | 0) {
     break label$3
    }
    return 0 | 0;
   }
   $4 = 0;
   $0 = $0 + 1 | 0;
   if (($0 | 0) != ($1 | 0)) {
    continue label$2
   }
   break label$2;
  };
  return 1 | 0;
 }
 
 function FLAC__format_seektable_sort($0) {
  $0 = $0 | 0;
  var i64toi32_i32$3 = 0, i64toi32_i32$1 = 0, $2 = 0, $3 = 0, i64toi32_i32$0 = 0, $4 = 0, $1 = 0, $5 = 0, i64toi32_i32$2 = 0, $6$hi = 0, $6 = 0, $41 = 0, $41$hi = 0, $49 = 0, $54 = 0, $59 = 0, $7 = 0;
  $1 = 0;
  label$1 : {
   $2 = HEAP32[$0 >> 2] | 0;
   if (!$2) {
    break label$1
   }
   $3 = GOT_data_internal___table_base;
   qsort(HEAP32[($0 + 4 | 0) >> 2] | 0 | 0, $2 | 0, 24 | 0, $3 + 0 | 0 | 0);
   if (!(HEAP32[$0 >> 2] | 0)) {
    break label$1
   }
   $1 = 1;
   label$2 : {
    $4 = HEAP32[$0 >> 2] | 0;
    if ($4 >>> 0 <= 1 >>> 0) {
     break label$2
    }
    $3 = 1;
    label$3 : while (1) {
     label$4 : {
      label$5 : {
       $5 = HEAP32[($0 + 4 | 0) >> 2] | 0;
       $2 = $5 + Math_imul($3, 24) | 0;
       i64toi32_i32$2 = $2;
       i64toi32_i32$0 = HEAP32[$2 >> 2] | 0;
       i64toi32_i32$1 = HEAP32[($2 + 4 | 0) >> 2] | 0;
       $6 = i64toi32_i32$0;
       $6$hi = i64toi32_i32$1;
       i64toi32_i32$2 = i64toi32_i32$0;
       i64toi32_i32$0 = -1;
       i64toi32_i32$3 = -1;
       if ((i64toi32_i32$2 | 0) == (i64toi32_i32$3 | 0) & (i64toi32_i32$1 | 0) == (i64toi32_i32$0 | 0) | 0) {
        break label$5
       }
       i64toi32_i32$2 = $6$hi;
       i64toi32_i32$3 = (Math_imul($1, 24) + $5 | 0) + -24 | 0;
       i64toi32_i32$2 = HEAP32[i64toi32_i32$3 >> 2] | 0;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] | 0;
       $41 = i64toi32_i32$2;
       $41$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $6$hi;
       i64toi32_i32$3 = $6;
       i64toi32_i32$2 = $41$hi;
       i64toi32_i32$0 = $41;
       if ((i64toi32_i32$3 | 0) == (i64toi32_i32$0 | 0) & (i64toi32_i32$1 | 0) == (i64toi32_i32$2 | 0) | 0) {
        break label$4
       }
      }
      $4 = $5 + Math_imul($1, 24) | 0;
      i64toi32_i32$0 = $2;
      i64toi32_i32$3 = HEAP32[$2 >> 2] | 0;
      i64toi32_i32$1 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $49 = i64toi32_i32$3;
      i64toi32_i32$3 = $4;
      HEAP32[i64toi32_i32$3 >> 2] = $49;
      HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
      i64toi32_i32$0 = $2 + 16 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$3 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
      $54 = i64toi32_i32$1;
      i64toi32_i32$1 = $4 + 16 | 0;
      HEAP32[i64toi32_i32$1 >> 2] = $54;
      HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$3;
      i64toi32_i32$0 = $2 + 8 | 0;
      i64toi32_i32$3 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
      $59 = i64toi32_i32$3;
      i64toi32_i32$3 = $4 + 8 | 0;
      HEAP32[i64toi32_i32$3 >> 2] = $59;
      HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
      $1 = $1 + 1 | 0;
      $4 = HEAP32[$0 >> 2] | 0;
     }
     $3 = $3 + 1 | 0;
     if ($3 >>> 0 < $4 >>> 0) {
      continue label$3
     }
     break label$3;
    };
   }
   if ($4 >>> 0 <= $1 >>> 0) {
    break label$1
   }
   $7 = $4 + ($1 ^ -1 | 0) | 0;
   $0 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   $3 = $1;
   label$6 : {
    $5 = ($4 - $3 | 0) & 3 | 0;
    if (!$5) {
     break label$6
    }
    $3 = $1;
    label$7 : while (1) {
     $2 = $0 + Math_imul($3, 24) | 0;
     HEAP32[($2 + 16 | 0) >> 2] = 0;
     i64toi32_i32$3 = $2;
     i64toi32_i32$1 = 0;
     HEAP32[(i64toi32_i32$3 + 8 | 0) >> 2] = 0;
     HEAP32[(i64toi32_i32$3 + 12 | 0) >> 2] = i64toi32_i32$1;
     i64toi32_i32$1 = -1;
     HEAP32[i64toi32_i32$3 >> 2] = -1;
     HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
     $3 = $3 + 1 | 0;
     $5 = $5 + -1 | 0;
     if ($5) {
      continue label$7
     }
     break label$7;
    };
   }
   if ($7 >>> 0 < 3 >>> 0) {
    break label$1
   }
   label$8 : while (1) {
    $2 = $0 + Math_imul($3, 24) | 0;
    HEAP32[($2 + 16 | 0) >> 2] = 0;
    i64toi32_i32$3 = $2;
    i64toi32_i32$1 = 0;
    HEAP32[(i64toi32_i32$3 + 8 | 0) >> 2] = 0;
    HEAP32[(i64toi32_i32$3 + 12 | 0) >> 2] = i64toi32_i32$1;
    i64toi32_i32$1 = -1;
    HEAP32[i64toi32_i32$3 >> 2] = -1;
    HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
    i64toi32_i32$3 = i64toi32_i32$3 + 24 | 0;
    i64toi32_i32$1 = -1;
    HEAP32[i64toi32_i32$3 >> 2] = -1;
    HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
    HEAP32[($2 + 40 | 0) >> 2] = 0;
    i64toi32_i32$3 = $2 + 32 | 0;
    i64toi32_i32$1 = 0;
    HEAP32[i64toi32_i32$3 >> 2] = 0;
    HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
    HEAP32[($2 + 64 | 0) >> 2] = 0;
    i64toi32_i32$3 = $2 + 56 | 0;
    i64toi32_i32$1 = 0;
    HEAP32[i64toi32_i32$3 >> 2] = 0;
    HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
    i64toi32_i32$3 = $2 + 48 | 0;
    i64toi32_i32$1 = -1;
    HEAP32[i64toi32_i32$3 >> 2] = -1;
    HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
    HEAP32[($2 + 88 | 0) >> 2] = 0;
    i64toi32_i32$3 = $2 + 80 | 0;
    i64toi32_i32$1 = 0;
    HEAP32[i64toi32_i32$3 >> 2] = 0;
    HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
    i64toi32_i32$3 = $2 + 72 | 0;
    i64toi32_i32$1 = -1;
    HEAP32[i64toi32_i32$3 >> 2] = -1;
    HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] = i64toi32_i32$1;
    $3 = $3 + 4 | 0;
    if (($3 | 0) != ($4 | 0)) {
     continue label$8
    }
    break label$8;
   };
  }
  return $1 | 0;
 }
 
 function seekpoint_compare_($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var i64toi32_i32$2 = 0, i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, $2 = 0, $3 = 0, $2$hi = 0, $3$hi = 0, $11 = 0;
  i64toi32_i32$2 = $0;
  i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
  i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
  $2 = i64toi32_i32$0;
  $2$hi = i64toi32_i32$1;
  i64toi32_i32$2 = $1;
  i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
  i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
  $3 = i64toi32_i32$1;
  $3$hi = i64toi32_i32$0;
  i64toi32_i32$0 = $2$hi;
  i64toi32_i32$2 = $2;
  i64toi32_i32$1 = $3$hi;
  $11 = i64toi32_i32$0 >>> 0 < i64toi32_i32$1 >>> 0 | ((i64toi32_i32$0 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$2 >>> 0 < $3 >>> 0 | 0) | 0 ? -1 : 1;
  i64toi32_i32$2 = i64toi32_i32$0;
  i64toi32_i32$2 = i64toi32_i32$1;
  i64toi32_i32$2 = i64toi32_i32$0;
  i64toi32_i32$0 = i64toi32_i32$1;
  i64toi32_i32$1 = $3;
  return (($2 | 0) == (i64toi32_i32$1 | 0) & (i64toi32_i32$2 | 0) == (i64toi32_i32$0 | 0) | 0 ? 0 : $11) | 0;
 }
 
 function utf8len_($0) {
  $0 = $0 | 0;
  var $2 = 0, $1 = 0, $3 = 0, $4 = 0;
  $1 = 1;
  label$1 : {
   $2 = HEAPU8[$0 >> 0] | 0;
   if (!($2 & 128 | 0)) {
    break label$1
   }
   label$2 : {
    if (($2 & 224 | 0 | 0) != (192 | 0)) {
     break label$2
    }
    if (((HEAPU8[($0 + 1 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
     break label$2
    }
    return (($2 & 254 | 0 | 0) != (192 | 0)) << 1 | 0 | 0;
   }
   label$3 : {
    if (($2 & 240 | 0 | 0) != (224 | 0)) {
     break label$3
    }
    $3 = HEAPU8[($0 + 1 | 0) >> 0] | 0;
    if (($3 & 192 | 0 | 0) != (128 | 0)) {
     break label$3
    }
    $4 = HEAPU8[($0 + 2 | 0) >> 0] | 0;
    if (($4 & 192 | 0 | 0) != (128 | 0)) {
     break label$3
    }
    $1 = 0;
    label$4 : {
     if (($2 | 0) != (224 | 0)) {
      break label$4
     }
     if (($3 & 224 | 0 | 0) == (128 | 0)) {
      break label$1
     }
    }
    label$5 : {
     label$6 : {
      switch ($2 + -237 | 0 | 0) {
      case 0:
       if (($3 & 224 | 0 | 0) != (160 | 0)) {
        break label$5
       }
       break label$1;
      case 2:
       break label$6;
      default:
       break label$5;
      };
     }
     if (($3 | 0) != (191 | 0)) {
      break label$5
     }
     if (($4 & 254 | 0 | 0) == (190 | 0)) {
      break label$1
     }
    }
    return 3 | 0;
   }
   label$8 : {
    if (($2 & 248 | 0 | 0) != (240 | 0)) {
     break label$8
    }
    $1 = HEAPU8[($0 + 1 | 0) >> 0] | 0;
    if (($1 & 192 | 0 | 0) != (128 | 0)) {
     break label$8
    }
    if (((HEAPU8[($0 + 2 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
     break label$8
    }
    if (((HEAPU8[($0 + 3 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
     break label$8
    }
    return (($2 | 0) == (240 | 0) ? (($1 & 240 | 0 | 0) != (128 | 0)) << 2 | 0 : 4) | 0;
   }
   label$9 : {
    if (($2 & 252 | 0 | 0) != (248 | 0)) {
     break label$9
    }
    $1 = HEAPU8[($0 + 1 | 0) >> 0] | 0;
    if (($1 & 192 | 0 | 0) != (128 | 0)) {
     break label$9
    }
    if (((HEAPU8[($0 + 2 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
     break label$9
    }
    if (((HEAPU8[($0 + 3 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
     break label$9
    }
    if (((HEAPU8[($0 + 4 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
     break label$9
    }
    return (($2 | 0) == (248 | 0) ? (($1 & 248 | 0 | 0) == (128 | 0) ? 0 : 5) : 5) | 0;
   }
   $1 = 0;
   if (($2 & 254 | 0 | 0) != (252 | 0)) {
    break label$1
   }
   $3 = HEAPU8[($0 + 1 | 0) >> 0] | 0;
   if (($3 & 192 | 0 | 0) != (128 | 0)) {
    break label$1
   }
   if (((HEAPU8[($0 + 2 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
    break label$1
   }
   if (((HEAPU8[($0 + 3 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
    break label$1
   }
   if (((HEAPU8[($0 + 4 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
    break label$1
   }
   if (((HEAPU8[($0 + 5 | 0) >> 0] | 0) & 192 | 0 | 0) != (128 | 0)) {
    break label$1
   }
   $1 = ($2 | 0) == (252 | 0) ? (($3 & 252 | 0 | 0) == (128 | 0) ? 0 : 6) : 6;
  }
  return $1 | 0;
 }
 
 function FLAC__format_cuesheet_is_legal($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$2 = 0, $6 = 0, $4 = 0, $8 = 0, i64toi32_i32$0 = 0, $5 = 0, $7 = 0, $9 = 0, $3 = 0, $3$hi = 0, $14 = 0, $15 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       label$6 : {
        label$7 : {
         label$8 : {
          label$9 : {
           label$10 : {
            if (!$1) {
             break label$10
            }
            label$11 : {
             i64toi32_i32$2 = $0;
             i64toi32_i32$0 = HEAP32[($0 + 136 | 0) >> 2] | 0;
             i64toi32_i32$1 = HEAP32[($0 + 140 | 0) >> 2] | 0;
             $3 = i64toi32_i32$0;
             $3$hi = i64toi32_i32$1;
             i64toi32_i32$2 = i64toi32_i32$0;
             i64toi32_i32$0 = 0;
             if (i64toi32_i32$1 >>> 0 > i64toi32_i32$0 >>> 0 | ((i64toi32_i32$1 | 0) == (i64toi32_i32$0 | 0) & i64toi32_i32$2 >>> 0 > 88199 >>> 0 | 0) | 0) {
              break label$11
             }
             $0 = GOT_data_internal___memory_base;
             if (!$2) {
              break label$1
             }
             $0 = $0 + 5739 | 0;
             break label$2;
            }
            label$12 : {
             i64toi32_i32$2 = $3$hi;
             i64toi32_i32$1 = 0;
             i64toi32_i32$1 = __wasm_i64_urem($3 | 0, i64toi32_i32$2 | 0, 588 | 0, i64toi32_i32$1 | 0) | 0;
             i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
             if (!(i64toi32_i32$1 | i64toi32_i32$2 | 0)) {
              break label$12
             }
             $0 = GOT_data_internal___memory_base;
             if (!$2) {
              break label$1
             }
             $0 = $0 + 5668 | 0;
             break label$2;
            }
            $4 = HEAP32[($0 + 148 | 0) >> 2] | 0;
            if (!$4) {
             break label$3
            }
            $5 = $4 + -1 | 0;
            if ((HEAPU8[(((HEAP32[($0 + 152 | 0) >> 2] | 0) + ($5 << 5 | 0) | 0) + 8 | 0) >> 0] | 0 | 0) == (170 | 0)) {
             break label$9
            }
            $0 = GOT_data_internal___memory_base;
            if (!$2) {
             break label$1
            }
            $0 = $0 + 6330 | 0;
            break label$2;
           }
           $6 = HEAP32[($0 + 148 | 0) >> 2] | 0;
           if (!$6) {
            break label$3
           }
           $7 = $6 + -1 | 0;
           $5 = HEAP32[($0 + 152 | 0) >> 2] | 0;
           $4 = 0;
           label$13 : while (1) {
            $0 = $5 + ($4 << 5 | 0) | 0;
            if (!(HEAPU8[($0 + 8 | 0) >> 0] | 0)) {
             break label$4
            }
            $8 = HEAPU8[($0 + 23 | 0) >> 0] | 0;
            label$14 : {
             label$15 : {
              label$16 : {
               if ($4 >>> 0 >= $7 >>> 0) {
                break label$16
               }
               if (!$8) {
                break label$5
               }
               if ((HEAPU8[((HEAP32[($0 + 24 | 0) >> 2] | 0) + 8 | 0) >> 0] | 0) >>> 0 <= 1 >>> 0) {
                break label$15
               }
               break label$6;
              }
              if (!$8) {
               break label$14
              }
             }
             $9 = $0 + 24 | 0;
             $0 = 0;
             label$17 : while (1) {
              label$18 : {
               if (!$0) {
                break label$18
               }
               $1 = (HEAP32[$9 >> 2] | 0) + ($0 << 4 | 0) | 0;
               if (((HEAPU8[($1 + -8 | 0) >> 0] | 0) + 1 | 0 | 0) != (HEAPU8[($1 + 8 | 0) >> 0] | 0 | 0)) {
                break label$7
               }
              }
              $0 = $0 + 1 | 0;
              if (($0 | 0) != ($8 | 0)) {
               continue label$17
              }
              break label$17;
             };
            }
            $0 = 1;
            $4 = $4 + 1 | 0;
            if (($4 | 0) != ($6 | 0)) {
             continue label$13
            }
            break label$8;
           };
          }
          $7 = HEAP32[($0 + 152 | 0) >> 2] | 0;
          $6 = 0;
          label$19 : while (1) {
           $0 = $7 + ($6 << 5 | 0) | 0;
           $1 = HEAPU8[($0 + 8 | 0) >> 0] | 0;
           if (!$1) {
            break label$4
           }
           label$20 : {
            if ($1 >>> 0 < 100 >>> 0) {
             break label$20
            }
            if (($1 | 0) == (170 | 0)) {
             break label$20
            }
            $0 = GOT_data_internal___memory_base;
            if (!$2) {
             break label$1
            }
            $0 = $0 + 6113 | 0;
            break label$2;
           }
           label$21 : {
            i64toi32_i32$2 = HEAP32[$0 >> 2] | 0;
            i64toi32_i32$1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
            $14 = i64toi32_i32$2;
            i64toi32_i32$2 = 0;
            i64toi32_i32$2 = __wasm_i64_urem($14 | 0, i64toi32_i32$1 | 0, 588 | 0, i64toi32_i32$2 | 0) | 0;
            i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
            if (!(i64toi32_i32$2 | i64toi32_i32$1 | 0)) {
             break label$21
            }
            if (!$2) {
             break label$1
            }
            $0 = GOT_data_internal___memory_base + (($6 | 0) == ($5 | 0) ? 5527 : 5599) | 0;
            break label$2;
           }
           $8 = HEAPU8[($0 + 23 | 0) >> 0] | 0;
           label$22 : {
            label$23 : {
             label$24 : {
              if ($6 >>> 0 >= $5 >>> 0) {
               break label$24
              }
              if (!$8) {
               break label$5
              }
              if ((HEAPU8[((HEAP32[($0 + 24 | 0) >> 2] | 0) + 8 | 0) >> 0] | 0) >>> 0 < 2 >>> 0) {
               break label$23
              }
              break label$6;
             }
             if (!$8) {
              break label$22
             }
            }
            $9 = HEAP32[($0 + 24 | 0) >> 2] | 0;
            $0 = 0;
            label$25 : while (1) {
             label$26 : {
              $1 = $9 + ($0 << 4 | 0) | 0;
              i64toi32_i32$1 = HEAP32[$1 >> 2] | 0;
              i64toi32_i32$2 = HEAP32[($1 + 4 | 0) >> 2] | 0;
              $15 = i64toi32_i32$1;
              i64toi32_i32$1 = 0;
              i64toi32_i32$1 = __wasm_i64_urem($15 | 0, i64toi32_i32$2 | 0, 588 | 0, i64toi32_i32$1 | 0) | 0;
              i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
              if (!(i64toi32_i32$1 | i64toi32_i32$2 | 0)) {
               break label$26
              }
              $0 = GOT_data_internal___memory_base;
              if (!$2) {
               break label$1
              }
              $0 = $0 + 5452 | 0;
              break label$2;
             }
             label$27 : {
              if (!$0) {
               break label$27
              }
              if (((HEAPU8[($1 + -8 | 0) >> 0] | 0) + 1 | 0 | 0) != (HEAPU8[($1 + 8 | 0) >> 0] | 0 | 0)) {
               break label$7
              }
             }
             $0 = $0 + 1 | 0;
             if (($0 | 0) != ($8 | 0)) {
              continue label$25
             }
             break label$25;
            };
           }
           $0 = 1;
           $6 = $6 + 1 | 0;
           if (($6 | 0) != ($4 | 0)) {
            continue label$19
           }
           break label$19;
          };
         }
         return $0 | 0;
        }
        $0 = GOT_data_internal___memory_base;
        if (!$2) {
         break label$1
        }
        $0 = $0 + 6012 | 0;
        break label$2;
       }
       $0 = GOT_data_internal___memory_base;
       if (!$2) {
        break label$1
       }
       $0 = $0 + 6061 | 0;
       break label$2;
      }
      $0 = GOT_data_internal___memory_base;
      if (!$2) {
       break label$1
      }
      $0 = $0 + 5394 | 0;
      break label$2;
     }
     $0 = GOT_data_internal___memory_base;
     if (!$2) {
      break label$1
     }
     $0 = $0 + 6162 | 0;
     break label$2;
    }
    $0 = GOT_data_internal___memory_base;
    if (!$2) {
     break label$1
    }
    $0 = $0 + 6202 | 0;
   }
   HEAP32[$2 >> 2] = $0;
  }
  return 0 | 0;
 }
 
 function FLAC__format_picture_is_legal($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $2 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     $3 = HEAPU8[$2 >> 0] | 0;
     if (!$3) {
      break label$3
     }
     label$4 : {
      label$5 : while (1) {
       if ((($3 + -32 | 0) & 255 | 0) >>> 0 >= 95 >>> 0) {
        break label$4
       }
       $2 = $2 + 1 | 0;
       $3 = HEAPU8[$2 >> 0] | 0;
       if (!$3) {
        break label$3
       }
       continue label$5;
      };
     }
     $3 = GOT_data_internal___memory_base;
     if (!$1) {
      break label$1
     }
     $3 = $3 + 6256 | 0;
     break label$2;
    }
    label$6 : {
     $3 = HEAP32[($0 + 8 | 0) >> 2] | 0;
     if (!(HEAPU8[$3 >> 0] | 0)) {
      break label$6
     }
     label$7 : while (1) {
      label$8 : {
       $2 = utf8len_($3 | 0) | 0;
       if ($2) {
        break label$8
       }
       $3 = GOT_data_internal___memory_base;
       if (!$1) {
        break label$1
       }
       $3 = $3 + 5940 | 0;
       break label$2;
      }
      $3 = $3 + $2 | 0;
      if (HEAPU8[$3 >> 0] | 0) {
       continue label$7
      }
      break label$7;
     };
    }
    return 1 | 0;
   }
   HEAP32[$1 >> 2] = $3;
  }
  return 0 | 0;
 }
 
 function FLAC__format_get_max_rice_partition_order_from_blocksize_limited_max_and_predictor_order($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0;
  label$1 : {
   label$2 : while (1) {
    $3 = $0;
    if (!$3) {
     break label$1
    }
    $0 = $3 + -1 | 0;
    if (($1 >>> $3 | 0) >>> 0 <= $2 >>> 0) {
     continue label$2
    }
    break label$2;
   };
  }
  return $3 | 0;
 }
 
 function FLAC__format_get_max_rice_partition_order_from_blocksize($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0;
  $1 = 0;
  label$1 : {
   label$2 : {
    if ($0 & 1 | 0) {
     break label$2
    }
    label$3 : while (1) {
     $1 = $1 + 1 | 0;
     $2 = $0 & 2 | 0;
     $0 = $0 >>> 1 | 0;
     if (!$2) {
      continue label$3
     }
     break label$3;
    };
    $0 = 15;
    if ($1 >>> 0 > 14 >>> 0) {
     break label$1
    }
   }
   $0 = $1;
  }
  return $0 | 0;
 }
 
 function FLAC__format_entropy_coding_method_partitioned_rice_contents_init($0) {
  $0 = $0 | 0;
  HEAP32[($0 + 8 | 0) >> 2] = 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[($0 + 4 | 0) >> 2] = 0;
 }
 
 function FLAC__format_entropy_coding_method_partitioned_rice_contents_clear($0) {
  $0 = $0 | 0;
  var $1 = 0;
  label$1 : {
   $1 = HEAP32[$0 >> 2] | 0;
   if (!$1) {
    break label$1
   }
   dlfree($1 | 0);
  }
  label$2 : {
   $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   if (!$1) {
    break label$2
   }
   dlfree($1 | 0);
  }
  HEAP32[($0 + 8 | 0) >> 2] = 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[($0 + 4 | 0) >> 2] = 0;
 }
 
 function FLAC__format_entropy_coding_method_partitioned_rice_contents_ensure_size($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $4 = 0, $2 = 0, $3 = 0, $5 = 0;
  $2 = 1;
  label$1 : {
   if ((HEAP32[($0 + 8 | 0) >> 2] | 0) >>> 0 >= $1 >>> 0) {
    break label$1
   }
   $2 = HEAP32[$0 >> 2] | 0;
   $3 = 4 << $1 | 0;
   $4 = dlrealloc($2 | 0, $3 | 0) | 0;
   label$2 : {
    if ($1 >>> 0 > 29 >>> 0) {
     break label$2
    }
    if ($4) {
     break label$2
    }
    dlfree($2 | 0);
   }
   HEAP32[$0 >> 2] = $4;
   $2 = 0;
   if (!$4) {
    break label$1
   }
   $5 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   $4 = dlrealloc($5 | 0, $3 | 0) | 0;
   label$3 : {
    if ($1 >>> 0 > 29 >>> 0) {
     break label$3
    }
    if ($4) {
     break label$3
    }
    dlfree($5 | 0);
   }
   HEAP32[($0 + 4 | 0) >> 2] = $4;
   if (!$4) {
    break label$1
   }
   memset($4 | 0, 0 | 0, $3 | 0) | 0;
   HEAP32[($0 + 8 | 0) >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function ogg_page_serialno($0) {
  $0 = $0 | 0;
  var $1 = 0;
  $1 = HEAP32[$0 >> 2] | 0;
  return HEAPU8[($1 + 14 | 0) >> 0] | 0 | ((HEAPU8[($1 + 15 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($1 + 16 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($1 + 17 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0;
 }
 
 function ogg_stream_init($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $4 = 0, $3 = 0;
  $2 = -1;
  label$1 : {
   if (!$0) {
    break label$1
   }
   memset($0 + 8 | 0 | 0, 0 | 0, 352 | 0) | 0;
   HEAP32[($0 + 24 | 0) >> 2] = 1024;
   HEAP32[($0 + 4 | 0) >> 2] = 16384;
   $3 = dlmalloc(16384 | 0) | 0;
   HEAP32[$0 >> 2] = $3;
   $4 = dlmalloc(4096 | 0) | 0;
   HEAP32[($0 + 16 | 0) >> 2] = $4;
   $2 = dlmalloc(8192 | 0) | 0;
   HEAP32[($0 + 20 | 0) >> 2] = $2;
   label$2 : {
    label$3 : {
     if (!$3) {
      break label$3
     }
     label$4 : {
      if (!$2) {
       break label$4
      }
      if ($4) {
       break label$2
      }
     }
     dlfree($3 | 0);
    }
    label$5 : {
     if (!$4) {
      break label$5
     }
     dlfree($4 | 0);
    }
    label$6 : {
     if (!$2) {
      break label$6
     }
     dlfree($2 | 0);
    }
    memset($0 | 0, 0 | 0, 360 | 0) | 0;
    return -1 | 0;
   }
   HEAP32[($0 + 336 | 0) >> 2] = $1;
   $2 = 0;
  }
  return $2 | 0;
 }
 
 function ogg_stream_clear($0) {
  $0 = $0 | 0;
  var $1 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   label$2 : {
    $1 = HEAP32[$0 >> 2] | 0;
    if (!$1) {
     break label$2
    }
    dlfree($1 | 0);
   }
   label$3 : {
    $1 = HEAP32[($0 + 16 | 0) >> 2] | 0;
    if (!$1) {
     break label$3
    }
    dlfree($1 | 0);
   }
   label$4 : {
    $1 = HEAP32[($0 + 20 | 0) >> 2] | 0;
    if (!$1) {
     break label$4
    }
    dlfree($1 | 0);
   }
   memset($0 | 0, 0 | 0, 360 | 0) | 0;
  }
  return 0 | 0;
 }
 
 function ogg_page_checksum_set($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $4 = 0, $5 = 0, $3 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $1 = 0;
   HEAP8[((HEAP32[$0 >> 2] | 0) + 22 | 0) >> 0] = 0;
   HEAP8[((HEAP32[$0 >> 2] | 0) + 23 | 0) >> 0] = 0;
   HEAP8[((HEAP32[$0 >> 2] | 0) + 24 | 0) >> 0] = 0;
   HEAP8[((HEAP32[$0 >> 2] | 0) + 25 | 0) >> 0] = 0;
   label$2 : {
    $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    if (($2 | 0) < (1 | 0)) {
     break label$2
    }
    $3 = $2 & 1 | 0;
    $4 = HEAP32[$0 >> 2] | 0;
    label$3 : {
     label$4 : {
      if (($2 | 0) != (1 | 0)) {
       break label$4
      }
      $2 = 0;
      $1 = 0;
      break label$3;
     }
     $5 = $2 & -2 | 0;
     $2 = 0;
     $1 = 0;
     label$5 : while (1) {
      $1 = (HEAP32[(((($1 >>> 24 | 0) ^ (HEAPU8[($4 + $2 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($1 << 8 | 0) | 0;
      $1 = (HEAP32[(((($1 >>> 24 | 0) ^ (HEAPU8[($4 + ($2 | 1 | 0) | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($1 << 8 | 0) | 0;
      $2 = $2 + 2 | 0;
      $5 = $5 + -2 | 0;
      if ($5) {
       continue label$5
      }
      break label$5;
     };
    }
    if (!$3) {
     break label$2
    }
    $1 = (HEAP32[(((($1 >>> 24 | 0) ^ (HEAPU8[($4 + $2 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($1 << 8 | 0) | 0;
   }
   label$6 : {
    $2 = HEAP32[($0 + 12 | 0) >> 2] | 0;
    if (($2 | 0) < (1 | 0)) {
     break label$6
    }
    $3 = $2 & 1 | 0;
    $4 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    label$7 : {
     label$8 : {
      if (($2 | 0) != (1 | 0)) {
       break label$8
      }
      $2 = 0;
      break label$7;
     }
     $5 = $2 & -2 | 0;
     $2 = 0;
     label$9 : while (1) {
      $1 = (HEAP32[(((($1 >>> 24 | 0) ^ (HEAPU8[($4 + $2 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($1 << 8 | 0) | 0;
      $1 = (HEAP32[(((($1 >>> 24 | 0) ^ (HEAPU8[($4 + ($2 | 1 | 0) | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($1 << 8 | 0) | 0;
      $2 = $2 + 2 | 0;
      $5 = $5 + -2 | 0;
      if ($5) {
       continue label$9
      }
      break label$9;
     };
    }
    if (!$3) {
     break label$6
    }
    $1 = (HEAP32[(((($1 >>> 24 | 0) ^ (HEAPU8[($4 + $2 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($1 << 8 | 0) | 0;
   }
   HEAP8[((HEAP32[$0 >> 2] | 0) + 22 | 0) >> 0] = $1;
   HEAP8[((HEAP32[$0 >> 2] | 0) + 23 | 0) >> 0] = $1 >>> 8 | 0;
   HEAP8[((HEAP32[$0 >> 2] | 0) + 24 | 0) >> 0] = $1 >>> 16 | 0;
   HEAP8[((HEAP32[$0 >> 2] | 0) + 25 | 0) >> 0] = $1 >>> 24 | 0;
  }
 }
 
 function ogg_stream_iovecin($0, $1, $2, $3, $4, $4$hi) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $4$hi = $4$hi | 0;
  var $7 = 0, $9 = 0, i64toi32_i32$0 = 0, $8 = 0, i64toi32_i32$1 = 0, $12 = 0, $6 = 0, i64toi32_i32$2 = 0, $5 = 0, $10 = 0, i64toi32_i32$5 = 0, $11 = 0, i64toi32_i32$3 = 0, i64toi32_i32$4 = 0, $123 = 0, $178 = 0, $192 = 0, $206 = 0, $220 = 0, $240 = 0, $277 = 0;
  $5 = -1;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $6 = HEAP32[$0 >> 2] | 0;
   if (!$6) {
    break label$1
   }
   label$2 : {
    if ($1) {
     break label$2
    }
    return 0 | 0;
   }
   $7 = 0;
   label$3 : {
    label$4 : {
     if (($2 | 0) >= (1 | 0)) {
      break label$4
     }
     $8 = 0;
     break label$3;
    }
    $8 = 0;
    label$5 : while (1) {
     $9 = HEAP32[(($1 + ($7 << 3 | 0) | 0) + 4 | 0) >> 2] | 0;
     if (($9 | 0) < (0 | 0)) {
      break label$1
     }
     if (($8 | 0) > (2147483647 - $9 | 0 | 0)) {
      break label$1
     }
     $8 = $9 + $8 | 0;
     $7 = $7 + 1 | 0;
     if (($7 | 0) != ($2 | 0)) {
      continue label$5
     }
     break label$5;
    };
   }
   $10 = ($8 | 0) / (255 | 0) | 0;
   label$6 : {
    $7 = HEAP32[($0 + 12 | 0) >> 2] | 0;
    if (!$7) {
     break label$6
    }
    $9 = (HEAP32[($0 + 8 | 0) >> 2] | 0) - $7 | 0;
    HEAP32[($0 + 8 | 0) >> 2] = $9;
    label$7 : {
     if (!$9) {
      break label$7
     }
     memmove($6 | 0, $6 + $7 | 0 | 0, $9 | 0) | 0;
    }
    HEAP32[($0 + 12 | 0) >> 2] = 0;
   }
   label$8 : {
    $7 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    if (($7 - $8 | 0 | 0) > (HEAP32[($0 + 8 | 0) >> 2] | 0 | 0)) {
     break label$8
    }
    label$9 : {
     if (($7 | 0) <= (2147483647 - $8 | 0 | 0)) {
      break label$9
     }
     label$10 : {
      $8 = HEAP32[$0 >> 2] | 0;
      if (!$8) {
       break label$10
      }
      dlfree($8 | 0);
     }
     label$11 : {
      $8 = HEAP32[($0 + 16 | 0) >> 2] | 0;
      if (!$8) {
       break label$11
      }
      dlfree($8 | 0);
     }
     label$12 : {
      $8 = HEAP32[($0 + 20 | 0) >> 2] | 0;
      if (!$8) {
       break label$12
      }
      dlfree($8 | 0);
     }
     memset($0 | 0, 0 | 0, 360 | 0) | 0;
     return -1 | 0;
    }
    label$13 : {
     $7 = $7 + $8 | 0;
     $7 = ($7 | 0) < (2147482623 | 0) ? $7 + 1024 | 0 : $7;
     $9 = dlrealloc(HEAP32[$0 >> 2] | 0 | 0, $7 | 0) | 0;
     if ($9) {
      break label$13
     }
     ogg_stream_clear($0 | 0) | 0;
     return -1 | 0;
    }
    HEAP32[$0 >> 2] = $9;
    HEAP32[($0 + 4 | 0) >> 2] = $7;
   }
   $11 = $10 + 1 | 0;
   if (_os_lacing_expand($0 | 0, $11 | 0) | 0) {
    break label$1
   }
   label$14 : {
    if (($2 | 0) < (1 | 0)) {
     break label$14
    }
    $9 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    $7 = 0;
    label$15 : while (1) {
     $123 = (HEAP32[$0 >> 2] | 0) + $9 | 0;
     $9 = $1 + ($7 << 3 | 0) | 0;
     __memcpy($123 | 0, HEAP32[$9 >> 2] | 0 | 0, HEAP32[($9 + 4 | 0) >> 2] | 0 | 0) | 0;
     $9 = (HEAP32[($0 + 8 | 0) >> 2] | 0) + (HEAP32[($9 + 4 | 0) >> 2] | 0) | 0;
     HEAP32[($0 + 8 | 0) >> 2] = $9;
     $7 = $7 + 1 | 0;
     if (($7 | 0) != ($2 | 0)) {
      continue label$15
     }
     break label$15;
    };
   }
   label$16 : {
    label$17 : {
     if (($8 | 0) > (254 | 0)) {
      break label$17
     }
     $2 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     $9 = HEAP32[($0 + 28 | 0) >> 2] | 0;
     $1 = HEAP32[($0 + 16 | 0) >> 2] | 0;
     $7 = 0;
     break label$16;
    }
    $5 = $10 & 3 | 0;
    $2 = HEAP32[($0 + 20 | 0) >> 2] | 0;
    $9 = HEAP32[($0 + 28 | 0) >> 2] | 0;
    $1 = HEAP32[($0 + 16 | 0) >> 2] | 0;
    $7 = 0;
    label$18 : {
     if (($10 + -1 | 0) >>> 0 < 3 >>> 0) {
      break label$18
     }
     $6 = $10 & -4 | 0;
     $7 = 0;
     label$19 : while (1) {
      $12 = $9 + $7 | 0;
      HEAP32[($1 + ($12 << 2 | 0) | 0) >> 2] = 255;
      i64toi32_i32$2 = $0;
      i64toi32_i32$0 = HEAP32[($0 + 352 | 0) >> 2] | 0;
      i64toi32_i32$1 = HEAP32[($0 + 356 | 0) >> 2] | 0;
      $178 = i64toi32_i32$0;
      i64toi32_i32$0 = $2 + ($12 << 3 | 0) | 0;
      HEAP32[i64toi32_i32$0 >> 2] = $178;
      HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
      $12 = $9 + ($7 | 1 | 0) | 0;
      HEAP32[($1 + ($12 << 2 | 0) | 0) >> 2] = 255;
      i64toi32_i32$2 = $0;
      i64toi32_i32$1 = HEAP32[($0 + 352 | 0) >> 2] | 0;
      i64toi32_i32$0 = HEAP32[($0 + 356 | 0) >> 2] | 0;
      $192 = i64toi32_i32$1;
      i64toi32_i32$1 = $2 + ($12 << 3 | 0) | 0;
      HEAP32[i64toi32_i32$1 >> 2] = $192;
      HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
      $12 = $9 + ($7 | 2 | 0) | 0;
      HEAP32[($1 + ($12 << 2 | 0) | 0) >> 2] = 255;
      i64toi32_i32$2 = $0;
      i64toi32_i32$0 = HEAP32[($0 + 352 | 0) >> 2] | 0;
      i64toi32_i32$1 = HEAP32[($0 + 356 | 0) >> 2] | 0;
      $206 = i64toi32_i32$0;
      i64toi32_i32$0 = $2 + ($12 << 3 | 0) | 0;
      HEAP32[i64toi32_i32$0 >> 2] = $206;
      HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
      $12 = $9 + ($7 | 3 | 0) | 0;
      HEAP32[($1 + ($12 << 2 | 0) | 0) >> 2] = 255;
      i64toi32_i32$2 = $0;
      i64toi32_i32$1 = HEAP32[($0 + 352 | 0) >> 2] | 0;
      i64toi32_i32$0 = HEAP32[($0 + 356 | 0) >> 2] | 0;
      $220 = i64toi32_i32$1;
      i64toi32_i32$1 = $2 + ($12 << 3 | 0) | 0;
      HEAP32[i64toi32_i32$1 >> 2] = $220;
      HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
      $7 = $7 + 4 | 0;
      $6 = $6 + -4 | 0;
      if ($6) {
       continue label$19
      }
      break label$19;
     };
    }
    label$20 : {
     if (!$5) {
      break label$20
     }
     label$21 : while (1) {
      $6 = $9 + $7 | 0;
      HEAP32[($1 + ($6 << 2 | 0) | 0) >> 2] = 255;
      i64toi32_i32$2 = $0;
      i64toi32_i32$0 = HEAP32[($0 + 352 | 0) >> 2] | 0;
      i64toi32_i32$1 = HEAP32[($0 + 356 | 0) >> 2] | 0;
      $240 = i64toi32_i32$0;
      i64toi32_i32$0 = $2 + ($6 << 3 | 0) | 0;
      HEAP32[i64toi32_i32$0 >> 2] = $240;
      HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
      $7 = $7 + 1 | 0;
      $5 = $5 + -1 | 0;
      if ($5) {
       continue label$21
      }
      break label$21;
     };
    }
    $7 = $10;
   }
   $7 = $9 + $7 | 0;
   HEAP32[($1 + ($7 << 2 | 0) | 0) >> 2] = $8 - Math_imul($10, 255) | 0;
   i64toi32_i32$1 = $4$hi;
   i64toi32_i32$0 = $2 + ($7 << 3 | 0) | 0;
   HEAP32[i64toi32_i32$0 >> 2] = $4;
   HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
   i64toi32_i32$0 = $0;
   HEAP32[($0 + 352 | 0) >> 2] = $4;
   HEAP32[($0 + 356 | 0) >> 2] = i64toi32_i32$1;
   $8 = $1 + ($9 << 2 | 0) | 0;
   HEAP32[$8 >> 2] = HEAP32[$8 >> 2] | 0 | 256 | 0;
   HEAP32[($0 + 28 | 0) >> 2] = $9 + $11 | 0;
   $277 = $0;
   i64toi32_i32$2 = $0;
   i64toi32_i32$1 = HEAP32[($0 + 344 | 0) >> 2] | 0;
   i64toi32_i32$0 = HEAP32[($0 + 348 | 0) >> 2] | 0;
   i64toi32_i32$2 = i64toi32_i32$1;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 1;
   i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
   i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
   if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
    i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
   }
   i64toi32_i32$2 = $277;
   HEAP32[(i64toi32_i32$2 + 344 | 0) >> 2] = i64toi32_i32$4;
   HEAP32[(i64toi32_i32$2 + 348 | 0) >> 2] = i64toi32_i32$5;
   $5 = 0;
   if (!$3) {
    break label$1
   }
   HEAP32[($0 + 328 | 0) >> 2] = 1;
  }
  return $5 | 0;
 }
 
 function _os_lacing_expand($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  label$1 : {
   $2 = HEAP32[($0 + 24 | 0) >> 2] | 0;
   if (($2 - $1 | 0 | 0) > (HEAP32[($0 + 28 | 0) >> 2] | 0 | 0)) {
    break label$1
   }
   label$2 : {
    if (($2 | 0) <= (2147483647 - $1 | 0 | 0)) {
     break label$2
    }
    label$3 : {
     $1 = HEAP32[$0 >> 2] | 0;
     if (!$1) {
      break label$3
     }
     dlfree($1 | 0);
    }
    label$4 : {
     $1 = HEAP32[($0 + 16 | 0) >> 2] | 0;
     if (!$1) {
      break label$4
     }
     dlfree($1 | 0);
    }
    label$5 : {
     $1 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     if (!$1) {
      break label$5
     }
     dlfree($1 | 0);
    }
    memset($0 | 0, 0 | 0, 360 | 0) | 0;
    return -1 | 0;
   }
   label$6 : {
    $1 = $2 + $1 | 0;
    $1 = ($1 | 0) < (2147483615 | 0) ? $1 + 32 | 0 : $1;
    $2 = dlrealloc(HEAP32[($0 + 16 | 0) >> 2] | 0 | 0, $1 << 2 | 0 | 0) | 0;
    if ($2) {
     break label$6
    }
    label$7 : {
     $1 = HEAP32[$0 >> 2] | 0;
     if (!$1) {
      break label$7
     }
     dlfree($1 | 0);
    }
    label$8 : {
     $1 = HEAP32[($0 + 16 | 0) >> 2] | 0;
     if (!$1) {
      break label$8
     }
     dlfree($1 | 0);
    }
    label$9 : {
     $1 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     if (!$1) {
      break label$9
     }
     dlfree($1 | 0);
    }
    memset($0 | 0, 0 | 0, 360 | 0) | 0;
    return -1 | 0;
   }
   HEAP32[($0 + 16 | 0) >> 2] = $2;
   label$10 : {
    $2 = dlrealloc(HEAP32[($0 + 20 | 0) >> 2] | 0 | 0, $1 << 3 | 0 | 0) | 0;
    if ($2) {
     break label$10
    }
    label$11 : {
     $1 = HEAP32[$0 >> 2] | 0;
     if (!$1) {
      break label$11
     }
     dlfree($1 | 0);
    }
    label$12 : {
     $1 = HEAP32[($0 + 16 | 0) >> 2] | 0;
     if (!$1) {
      break label$12
     }
     dlfree($1 | 0);
    }
    label$13 : {
     $1 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     if (!$1) {
      break label$13
     }
     dlfree($1 | 0);
    }
    memset($0 | 0, 0 | 0, 360 | 0) | 0;
    return -1 | 0;
   }
   HEAP32[($0 + 24 | 0) >> 2] = $1;
   HEAP32[($0 + 20 | 0) >> 2] = $2;
  }
  return 0 | 0;
 }
 
 function ogg_stream_packetin($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, i64toi32_i32$1 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  HEAP32[($2 + 8 | 0) >> 2] = HEAP32[$1 >> 2] | 0;
  HEAP32[($2 + 12 | 0) >> 2] = HEAP32[($1 + 4 | 0) >> 2] | 0;
  i64toi32_i32$1 = HEAP32[($1 + 20 | 0) >> 2] | 0;
  $1 = ogg_stream_iovecin($0 | 0, $2 + 8 | 0 | 0, 1 | 0, HEAP32[($1 + 12 | 0) >> 2] | 0 | 0, HEAP32[($1 + 16 | 0) >> 2] | 0 | 0, i64toi32_i32$1 | 0) | 0;
  __stack_pointer = $2 + 16 | 0;
  return $1 | 0;
 }
 
 function ogg_stream_flush($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  return ogg_stream_flush_i($0 | 0, $1 | 0, 1 | 0, 4096 | 0) | 0 | 0;
 }
 
 function ogg_stream_flush_i($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $7 = 0, i64toi32_i32$4 = 0, i64toi32_i32$0 = 0, $12 = 0, i64toi32_i32$1 = 0, i64toi32_i32$2 = 0, $11 = 0, i64toi32_i32$3 = 0, $10 = 0, $9 = 0, $9$hi = 0, $15 = 0, $6 = 0, $14 = 0, $13 = 0, $4 = 0, $31 = 0, $32 = 0, $5 = 0, $8 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0, $41 = 0, $125 = 0, $129 = 0, $133 = 0, $137 = 0, $141 = 0, $145 = 0, $149 = 0, $209 = 0, $233 = 0;
  $4 = 0;
  label$1 : {
   $5 = HEAP32[$0 >> 2] | 0;
   if (!$5) {
    break label$1
   }
   $6 = HEAP32[($0 + 28 | 0) >> 2] | 0;
   $7 = ($6 | 0) < (255 | 0) ? $6 : 255;
   if (!$7) {
    break label$1
   }
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       $8 = HEAP32[($0 + 332 | 0) >> 2] | 0;
       if (!$8) {
        break label$5
       }
       if (($6 | 0) >= (1 | 0)) {
        break label$4
       }
       i64toi32_i32$0 = -1;
       $9 = -1;
       $9$hi = i64toi32_i32$0;
       $7 = 0;
       break label$3;
      }
      i64toi32_i32$0 = 0;
      $9 = 0;
      $9$hi = i64toi32_i32$0;
      label$6 : {
       if (($6 | 0) >= (1 | 0)) {
        break label$6
       }
       $7 = 0;
       break label$3;
      }
      $10 = ($7 | 0) > (1 | 0) ? $7 : 1;
      $11 = HEAP32[($0 + 16 | 0) >> 2] | 0;
      $12 = 0;
      label$7 : while (1) {
       $7 = $12 + 1 | 0;
       if ((HEAPU8[($11 + ($12 << 2 | 0) | 0) >> 0] | 0 | 0) != (255 | 0)) {
        break label$3
       }
       $12 = $7;
       if (($7 | 0) != ($10 | 0)) {
        continue label$7
       }
       break label$7;
      };
      $7 = $10;
      break label$3;
     }
     $13 = ($7 | 0) > (1 | 0) ? $7 : 1;
     i64toi32_i32$0 = -1;
     $9 = -1;
     $9$hi = i64toi32_i32$0;
     $11 = 0;
     $14 = 0;
     $12 = 0;
     $7 = 0;
     label$8 : {
      label$9 : while (1) {
       label$10 : {
        if (($12 | 0) <= ($3 | 0)) {
         break label$10
        }
        if (($11 | 0) <= (3 | 0)) {
         break label$10
        }
        $2 = 1;
        break label$8;
       }
       $11 = 0;
       label$11 : {
        $10 = HEAPU8[((HEAP32[($0 + 16 | 0) >> 2] | 0) + ($7 << 2 | 0) | 0) >> 0] | 0;
        if (($10 | 0) == (255 | 0)) {
         break label$11
        }
        i64toi32_i32$2 = (HEAP32[($0 + 20 | 0) >> 2] | 0) + ($7 << 3 | 0) | 0;
        i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
        i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
        $9 = i64toi32_i32$0;
        $9$hi = i64toi32_i32$1;
        $14 = $14 + 1 | 0;
        $11 = $14;
       }
       $12 = $10 + $12 | 0;
       $7 = $7 + 1 | 0;
       if (($7 | 0) != ($13 | 0)) {
        continue label$9
       }
       break label$9;
      };
      $7 = $13;
     }
     $15 = 255;
     if (($7 | 0) == (255 | 0)) {
      break label$2
     }
    }
    $15 = $7;
    if (!$2) {
     break label$1
    }
   }
   HEAP32[($0 + 40 | 0) >> 2] = 1399285583;
   $12 = 0;
   HEAP16[($0 + 44 | 0) >> 1] = 0;
   $11 = HEAP32[($0 + 16 | 0) >> 2] | 0;
   $7 = ((HEAPU8[($11 + 1 | 0) >> 0] | 0) ^ -1 | 0) & 1 | 0;
   $7 = $8 ? $7 : $7 | 2 | 0;
   HEAP8[($0 + 45 | 0) >> 0] = $7;
   label$12 : {
    if (!(HEAP32[($0 + 328 | 0) >> 2] | 0)) {
     break label$12
    }
    if (($6 | 0) != ($15 | 0)) {
     break label$12
    }
    HEAP8[($0 + 45 | 0) >> 0] = $7 | 4 | 0;
   }
   $4 = $0 + 40 | 0;
   HEAP32[($0 + 332 | 0) >> 2] = 1;
   $125 = $0 + 53 | 0;
   i64toi32_i32$1 = $9$hi;
   i64toi32_i32$2 = $9;
   i64toi32_i32$0 = 0;
   i64toi32_i32$3 = 56;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$0 = 0;
    $33 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$0 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    $33 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
   }
   HEAP8[$125 >> 0] = $33;
   $129 = $0 + 52 | 0;
   i64toi32_i32$0 = $9$hi;
   i64toi32_i32$1 = $9;
   i64toi32_i32$2 = 0;
   i64toi32_i32$3 = 48;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$2 = 0;
    $34 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$2 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
    $34 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$4 | 0) | 0;
   }
   HEAP8[$129 >> 0] = $34;
   $133 = $0 + 51 | 0;
   i64toi32_i32$2 = $9$hi;
   i64toi32_i32$0 = $9;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 40;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$1 = 0;
    $35 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$1 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
    $35 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
   }
   HEAP8[$133 >> 0] = $35;
   $137 = $0 + 50 | 0;
   i64toi32_i32$1 = $9$hi;
   i64toi32_i32$2 = $9;
   i64toi32_i32$0 = 0;
   i64toi32_i32$3 = 32;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$0 = 0;
    $36 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$0 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    $36 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
   }
   HEAP8[$137 >> 0] = $36;
   $141 = $0 + 49 | 0;
   i64toi32_i32$0 = $9$hi;
   i64toi32_i32$1 = $9;
   i64toi32_i32$2 = 0;
   i64toi32_i32$3 = 24;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$2 = 0;
    $37 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$2 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
    $37 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$4 | 0) | 0;
   }
   HEAP8[$141 >> 0] = $37;
   $145 = $0 + 48 | 0;
   i64toi32_i32$2 = $9$hi;
   i64toi32_i32$0 = $9;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 16;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$1 = 0;
    $38 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$1 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
    $38 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
   }
   HEAP8[$145 >> 0] = $38;
   $149 = $0 + 47 | 0;
   i64toi32_i32$1 = $9$hi;
   i64toi32_i32$2 = $9;
   i64toi32_i32$0 = 0;
   i64toi32_i32$3 = 8;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$0 = 0;
    $39 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$0 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    $39 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
   }
   HEAP8[$149 >> 0] = $39;
   i64toi32_i32$0 = $9$hi;
   HEAP8[($0 + 46 | 0) >> 0] = $9;
   $31 = $0 + 54 | 0;
   $32 = HEAP32[($0 + 336 | 0) >> 2] | 0;
   HEAP8[$31 >> 0] = $32;
   HEAP8[($31 + 1 | 0) >> 0] = $32 >>> 8 | 0;
   HEAP8[($31 + 2 | 0) >> 0] = $32 >>> 16 | 0;
   HEAP8[($31 + 3 | 0) >> 0] = $32 >>> 24 | 0;
   HEAP8[($0 + 66 | 0) >> 0] = $15;
   $40 = $0 + 62 | 0;
   $41 = 0;
   HEAP16[$40 >> 1] = $41;
   HEAP16[($40 + 2 | 0) >> 1] = $41 >>> 16 | 0;
   $7 = HEAP32[($0 + 340 | 0) >> 2] | 0;
   $7 = ($7 | 0) == (-1 | 0) ? 0 : $7;
   HEAP8[($0 + 58 | 0) >> 0] = $7;
   HEAP32[($0 + 340 | 0) >> 2] = $7 + 1 | 0;
   HEAP8[($0 + 61 | 0) >> 0] = $7 >>> 24 | 0;
   HEAP8[($0 + 60 | 0) >> 0] = $7 >>> 16 | 0;
   HEAP8[($0 + 59 | 0) >> 0] = $7 >>> 8 | 0;
   label$13 : {
    if (($15 | 0) < (1 | 0)) {
     break label$13
    }
    $2 = $15 & 1 | 0;
    label$14 : {
     label$15 : {
      if (($15 | 0) != (1 | 0)) {
       break label$15
      }
      $12 = 0;
      $7 = 0;
      break label$14;
     }
     $10 = $15 & -2 | 0;
     $12 = 0;
     $7 = 0;
     label$16 : while (1) {
      $3 = $0 + $7 | 0;
      $13 = $7 << 2 | 0;
      $14 = HEAP32[($11 + $13 | 0) >> 2] | 0;
      HEAP8[($3 + 67 | 0) >> 0] = $14;
      $209 = $3 + 68 | 0;
      $3 = HEAP32[($11 + ($13 | 4 | 0) | 0) >> 2] | 0;
      HEAP8[$209 >> 0] = $3;
      $12 = ($3 & 255 | 0) + (($14 & 255 | 0) + $12 | 0) | 0;
      $7 = $7 + 2 | 0;
      $10 = $10 + -2 | 0;
      if ($10) {
       continue label$16
      }
      break label$16;
     };
    }
    if (!$2) {
     break label$13
    }
    $233 = ($7 + $0 | 0) + 67 | 0;
    $7 = HEAP32[($11 + ($7 << 2 | 0) | 0) >> 2] | 0;
    HEAP8[$233 >> 0] = $7;
    $12 = ($7 & 255 | 0) + $12 | 0;
   }
   HEAP32[$1 >> 2] = $4;
   $7 = $15 + 27 | 0;
   HEAP32[($0 + 324 | 0) >> 2] = $7;
   HEAP32[($1 + 4 | 0) >> 2] = $7;
   $7 = HEAP32[($0 + 12 | 0) >> 2] | 0;
   HEAP32[($1 + 12 | 0) >> 2] = $12;
   HEAP32[($1 + 8 | 0) >> 2] = $5 + $7 | 0;
   $7 = $6 - $15 | 0;
   HEAP32[($0 + 28 | 0) >> 2] = $7;
   memmove($11 | 0, $11 + ($15 << 2 | 0) | 0 | 0, $7 << 2 | 0 | 0) | 0;
   $7 = HEAP32[($0 + 20 | 0) >> 2] | 0;
   memmove($7 | 0, $7 + ($15 << 3 | 0) | 0 | 0, (HEAP32[($0 + 28 | 0) >> 2] | 0) << 3 | 0 | 0) | 0;
   HEAP32[($0 + 12 | 0) >> 2] = (HEAP32[($0 + 12 | 0) >> 2] | 0) + $12 | 0;
   $0 = 0;
   HEAP8[((HEAP32[$1 >> 2] | 0) + 22 | 0) >> 0] = 0;
   HEAP8[((HEAP32[$1 >> 2] | 0) + 23 | 0) >> 0] = 0;
   HEAP8[((HEAP32[$1 >> 2] | 0) + 24 | 0) >> 0] = 0;
   HEAP8[((HEAP32[$1 >> 2] | 0) + 25 | 0) >> 0] = 0;
   label$17 : {
    $7 = HEAP32[($1 + 4 | 0) >> 2] | 0;
    if (($7 | 0) < (1 | 0)) {
     break label$17
    }
    $10 = $7 & 1 | 0;
    $12 = HEAP32[$1 >> 2] | 0;
    label$18 : {
     label$19 : {
      if (($7 | 0) != (1 | 0)) {
       break label$19
      }
      $7 = 0;
      $0 = 0;
      break label$18;
     }
     $11 = $7 & -2 | 0;
     $7 = 0;
     $0 = 0;
     label$20 : while (1) {
      $0 = (HEAP32[(((($0 >>> 24 | 0) ^ (HEAPU8[($12 + $7 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($0 << 8 | 0) | 0;
      $0 = (HEAP32[(((($0 >>> 24 | 0) ^ (HEAPU8[($12 + ($7 | 1 | 0) | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($0 << 8 | 0) | 0;
      $7 = $7 + 2 | 0;
      $11 = $11 + -2 | 0;
      if ($11) {
       continue label$20
      }
      break label$20;
     };
    }
    if (!$10) {
     break label$17
    }
    $0 = (HEAP32[(((($0 >>> 24 | 0) ^ (HEAPU8[($12 + $7 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($0 << 8 | 0) | 0;
   }
   label$21 : {
    $7 = HEAP32[($1 + 12 | 0) >> 2] | 0;
    if (($7 | 0) < (1 | 0)) {
     break label$21
    }
    $10 = $7 & 1 | 0;
    $12 = HEAP32[($1 + 8 | 0) >> 2] | 0;
    label$22 : {
     label$23 : {
      if (($7 | 0) != (1 | 0)) {
       break label$23
      }
      $7 = 0;
      break label$22;
     }
     $11 = $7 & -2 | 0;
     $7 = 0;
     label$24 : while (1) {
      $0 = (HEAP32[(((($0 >>> 24 | 0) ^ (HEAPU8[($12 + $7 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($0 << 8 | 0) | 0;
      $0 = (HEAP32[(((($0 >>> 24 | 0) ^ (HEAPU8[($12 + ($7 | 1 | 0) | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($0 << 8 | 0) | 0;
      $7 = $7 + 2 | 0;
      $11 = $11 + -2 | 0;
      if ($11) {
       continue label$24
      }
      break label$24;
     };
    }
    if (!$10) {
     break label$21
    }
    $0 = (HEAP32[(((($0 >>> 24 | 0) ^ (HEAPU8[($12 + $7 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($0 << 8 | 0) | 0;
   }
   HEAP8[((HEAP32[$1 >> 2] | 0) + 22 | 0) >> 0] = $0;
   HEAP8[((HEAP32[$1 >> 2] | 0) + 23 | 0) >> 0] = $0 >>> 8 | 0;
   HEAP8[((HEAP32[$1 >> 2] | 0) + 24 | 0) >> 0] = $0 >>> 16 | 0;
   HEAP8[((HEAP32[$1 >> 2] | 0) + 25 | 0) >> 0] = $0 >>> 24 | 0;
   $4 = 1;
  }
  return $4 | 0;
 }
 
 function ogg_stream_pageout($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0;
  $2 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   if (!(HEAP32[$0 >> 2] | 0)) {
    break label$1
   }
   $3 = HEAP32[($0 + 28 | 0) >> 2] | 0;
   label$2 : {
    label$3 : {
     label$4 : {
      if (!(HEAP32[($0 + 328 | 0) >> 2] | 0)) {
       break label$4
      }
      if ($3) {
       break label$3
      }
      $2 = 0;
      break label$2;
     }
     $2 = 0;
     if (!$3) {
      break label$2
     }
     if (HEAP32[($0 + 332 | 0) >> 2] | 0) {
      break label$2
     }
    }
    $2 = 1;
   }
   $2 = ogg_stream_flush_i($0 | 0, $1 | 0, $2 | 0, 4096 | 0) | 0;
  }
  return $2 | 0;
 }
 
 function ogg_sync_init($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   i64toi32_i32$1 = $0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
   HEAP32[(i64toi32_i32$1 + 24 | 0) >> 2] = 0;
   i64toi32_i32$1 = i64toi32_i32$1 + 16 | 0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$1 = $0 + 8 | 0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  }
  return 0 | 0;
 }
 
 function ogg_sync_clear($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, $1 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   label$2 : {
    $1 = HEAP32[$0 >> 2] | 0;
    if (!$1) {
     break label$2
    }
    dlfree($1 | 0);
   }
   i64toi32_i32$1 = $0;
   i64toi32_i32$0 = 0;
   HEAP32[$0 >> 2] = 0;
   HEAP32[($0 + 4 | 0) >> 2] = i64toi32_i32$0;
   HEAP32[($0 + 24 | 0) >> 2] = 0;
   i64toi32_i32$1 = $0 + 16 | 0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$1 = $0 + 8 | 0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  }
  return 0 | 0;
 }
 
 function ogg_sync_buffer($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, $4 = 0;
  $2 = 0;
  label$1 : {
   $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   if (($3 | 0) < (0 | 0)) {
    break label$1
   }
   label$2 : {
    $2 = HEAP32[($0 + 12 | 0) >> 2] | 0;
    if (!$2) {
     break label$2
    }
    $4 = (HEAP32[($0 + 8 | 0) >> 2] | 0) - $2 | 0;
    HEAP32[($0 + 8 | 0) >> 2] = $4;
    label$3 : {
     if (($4 | 0) < (1 | 0)) {
      break label$3
     }
     $3 = HEAP32[$0 >> 2] | 0;
     memmove($3 | 0, $3 + $2 | 0 | 0, $4 | 0) | 0;
     $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    }
    HEAP32[($0 + 12 | 0) >> 2] = 0;
   }
   label$4 : {
    label$5 : {
     $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
     if (($3 - $2 | 0 | 0) < ($1 | 0)) {
      break label$5
     }
     $1 = HEAP32[$0 >> 2] | 0;
     break label$4;
    }
    $2 = ($1 + $2 | 0) + 4096 | 0;
    label$6 : {
     label$7 : {
      $1 = HEAP32[$0 >> 2] | 0;
      if (!$1) {
       break label$7
      }
      $1 = dlrealloc($1 | 0, $2 | 0) | 0;
      break label$6;
     }
     $1 = dlmalloc($2 | 0) | 0;
    }
    label$8 : {
     if ($1) {
      break label$8
     }
     label$9 : {
      $2 = HEAP32[$0 >> 2] | 0;
      if (!$2) {
       break label$9
      }
      dlfree($2 | 0);
     }
     i64toi32_i32$1 = $0;
     i64toi32_i32$0 = 0;
     HEAP32[$0 >> 2] = 0;
     HEAP32[($0 + 4 | 0) >> 2] = i64toi32_i32$0;
     HEAP32[($0 + 24 | 0) >> 2] = 0;
     i64toi32_i32$1 = $0 + 16 | 0;
     i64toi32_i32$0 = 0;
     HEAP32[i64toi32_i32$1 >> 2] = 0;
     HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
     i64toi32_i32$1 = $0 + 8 | 0;
     i64toi32_i32$0 = 0;
     HEAP32[i64toi32_i32$1 >> 2] = 0;
     HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
     return 0 | 0;
    }
    HEAP32[($0 + 4 | 0) >> 2] = $2;
    HEAP32[$0 >> 2] = $1;
    $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
   }
   $2 = $1 + $2 | 0;
  }
  return $2 | 0;
 }
 
 function ogg_sync_wrote($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0;
  $2 = -1;
  label$1 : {
   $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   if (($3 | 0) < (0 | 0)) {
    break label$1
   }
   $1 = (HEAP32[($0 + 8 | 0) >> 2] | 0) + $1 | 0;
   if (($1 | 0) > ($3 | 0)) {
    break label$1
   }
   HEAP32[($0 + 8 | 0) >> 2] = $1;
   $2 = 0;
  }
  return $2 | 0;
 }
 
 function ogg_sync_pageseek($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $6 = 0, $4 = 0, $7 = 0, $8 = 0, $2 = 0, $5 = 0, $14 = 0, $10 = 0, $15 = 0, $11 = 0, $16 = 0, $17 = 0, $18 = 0, i64toi32_i32$0 = 0, $9 = 0, $12 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  $3 = 0;
  label$1 : {
   if ((HEAP32[($0 + 4 | 0) >> 2] | 0 | 0) < (0 | 0)) {
    break label$1
   }
   $4 = HEAP32[($0 + 12 | 0) >> 2] | 0;
   $5 = (HEAP32[($0 + 8 | 0) >> 2] | 0) - $4 | 0;
   $6 = (HEAP32[$0 >> 2] | 0) + $4 | 0;
   label$2 : {
    label$3 : {
     label$4 : {
      $7 = HEAP32[($0 + 20 | 0) >> 2] | 0;
      if ($7) {
       break label$4
      }
      if (($5 | 0) < (27 | 0)) {
       break label$1
      }
      if ((HEAPU8[$6 >> 0] | 0 | ((HEAPU8[($6 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($6 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($6 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0) != (1399285583 | 0)) {
       break label$3
      }
      $4 = HEAPU8[($6 + 26 | 0) >> 0] | 0;
      $7 = $4 + 27 | 0;
      if (($5 | 0) < ($7 | 0)) {
       break label$1
      }
      label$5 : {
       if (!$4) {
        break label$5
       }
       $8 = HEAP32[($0 + 24 | 0) >> 2] | 0;
       $4 = 0;
       label$6 : while (1) {
        $8 = $8 + (HEAPU8[(($4 + $6 | 0) + 27 | 0) >> 0] | 0) | 0;
        HEAP32[($0 + 24 | 0) >> 2] = $8;
        $4 = $4 + 1 | 0;
        if ($4 >>> 0 < (HEAPU8[($6 + 26 | 0) >> 0] | 0) >>> 0) {
         continue label$6
        }
        break label$6;
       };
      }
      HEAP32[($0 + 20 | 0) >> 2] = $7;
     }
     if (($7 + (HEAP32[($0 + 24 | 0) >> 2] | 0) | 0 | 0) > ($5 | 0)) {
      break label$1
     }
     $9 = HEAPU8[($6 + 22 | 0) >> 0] | 0 | ((HEAPU8[($6 + 23 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($6 + 24 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($6 + 25 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
     HEAP32[($2 + 12 | 0) >> 2] = $9;
     $3 = 0;
     $14 = 0;
     HEAP8[($6 + 22 | 0) >> 0] = $14;
     HEAP8[($6 + 23 | 0) >> 0] = $14 >>> 8 | 0;
     HEAP8[($6 + 24 | 0) >> 0] = $14 >>> 16 | 0;
     HEAP8[($6 + 25 | 0) >> 0] = $14 >>> 24 | 0;
     $10 = HEAP32[($0 + 24 | 0) >> 2] | 0;
     $8 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     $15 = 0;
     HEAP8[($6 + 22 | 0) >> 0] = $15;
     HEAP8[($6 + 23 | 0) >> 0] = $15 >>> 8 | 0;
     HEAP8[($6 + 24 | 0) >> 0] = $15 >>> 16 | 0;
     HEAP8[($6 + 25 | 0) >> 0] = $15 >>> 24 | 0;
     label$7 : {
      if (($8 | 0) < (1 | 0)) {
       break label$7
      }
      $11 = $8 & 1 | 0;
      label$8 : {
       label$9 : {
        if (($8 | 0) != (1 | 0)) {
         break label$9
        }
        $4 = 0;
        $3 = 0;
        break label$8;
       }
       $7 = $8 & -2 | 0;
       $4 = 0;
       $3 = 0;
       label$10 : while (1) {
        $3 = (HEAP32[(((($3 >>> 24 | 0) ^ (HEAPU8[($6 + $4 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($3 << 8 | 0) | 0;
        $3 = (HEAP32[(((($3 >>> 24 | 0) ^ (HEAPU8[($6 + ($4 | 1 | 0) | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($3 << 8 | 0) | 0;
        $4 = $4 + 2 | 0;
        $7 = $7 + -2 | 0;
        if ($7) {
         continue label$10
        }
        break label$10;
       };
      }
      if (!$11) {
       break label$7
      }
      $3 = (HEAP32[(((($3 >>> 24 | 0) ^ (HEAPU8[($6 + $4 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($3 << 8 | 0) | 0;
     }
     $11 = $6 + 22 | 0;
     label$11 : {
      if (($10 | 0) < (1 | 0)) {
       break label$11
      }
      $7 = $6 + $8 | 0;
      $12 = $10 & 1 | 0;
      label$12 : {
       label$13 : {
        if (($10 | 0) != (1 | 0)) {
         break label$13
        }
        $4 = 0;
        break label$12;
       }
       $8 = $10 & -2 | 0;
       $4 = 0;
       label$14 : while (1) {
        $3 = (HEAP32[(((($3 >>> 24 | 0) ^ (HEAPU8[($7 + $4 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($3 << 8 | 0) | 0;
        $3 = (HEAP32[(((($3 >>> 24 | 0) ^ (HEAPU8[($7 + ($4 | 1 | 0) | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($3 << 8 | 0) | 0;
        $4 = $4 + 2 | 0;
        $8 = $8 + -2 | 0;
        if ($8) {
         continue label$14
        }
        break label$14;
       };
      }
      if (!$12) {
       break label$11
      }
      $3 = (HEAP32[(((($3 >>> 24 | 0) ^ (HEAPU8[($7 + $4 | 0) >> 0] | 0) | 0) << 2 | 0) + 6800 | 0) >> 2] | 0) ^ ($3 << 8 | 0) | 0;
     }
     HEAP8[($6 + 22 | 0) >> 0] = $3;
     HEAP8[($6 + 23 | 0) >> 0] = $3 >>> 8 | 0;
     HEAP8[($6 + 24 | 0) >> 0] = $3 >>> 16 | 0;
     HEAP8[($6 + 25 | 0) >> 0] = $3 >>> 24 | 0;
     $16 = $11;
     if ((HEAP32[($2 + 12 | 0) >> 2] | 0 | 0) == (HEAPU8[$16 >> 0] | 0 | ((HEAPU8[($16 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($16 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($16 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0)) {
      break label$2
     }
     $17 = $11;
     $18 = $9;
     HEAP8[$17 >> 0] = $18;
     HEAP8[($17 + 1 | 0) >> 0] = $18 >>> 8 | 0;
     HEAP8[($17 + 2 | 0) >> 0] = $18 >>> 16 | 0;
     HEAP8[($17 + 3 | 0) >> 0] = $18 >>> 24 | 0;
    }
    i64toi32_i32$0 = 0;
    HEAP32[($0 + 20 | 0) >> 2] = 0;
    HEAP32[($0 + 24 | 0) >> 2] = i64toi32_i32$0;
    $4 = HEAP32[$0 >> 2] | 0;
    label$15 : {
     $3 = memchr($6 + 1 | 0 | 0, 79 | 0, $5 + -1 | 0 | 0) | 0;
     if ($3) {
      break label$15
     }
     $3 = $4 + (HEAP32[($0 + 8 | 0) >> 2] | 0) | 0;
    }
    HEAP32[($0 + 12 | 0) >> 2] = $3 - $4 | 0;
    $3 = $6 - $3 | 0;
    break label$1;
   }
   $4 = HEAP32[($0 + 12 | 0) >> 2] | 0;
   label$16 : {
    label$17 : {
     if ($1) {
      break label$17
     }
     $6 = HEAP32[($0 + 24 | 0) >> 2] | 0;
     $3 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     break label$16;
    }
    $6 = (HEAP32[$0 >> 2] | 0) + $4 | 0;
    HEAP32[$1 >> 2] = $6;
    $3 = HEAP32[($0 + 20 | 0) >> 2] | 0;
    HEAP32[($1 + 4 | 0) >> 2] = $3;
    HEAP32[($1 + 8 | 0) >> 2] = $6 + $3 | 0;
    $6 = HEAP32[($0 + 24 | 0) >> 2] | 0;
    HEAP32[($1 + 12 | 0) >> 2] = $6;
   }
   HEAP32[($0 + 24 | 0) >> 2] = 0;
   i64toi32_i32$0 = 0;
   HEAP32[($0 + 16 | 0) >> 2] = 0;
   HEAP32[($0 + 20 | 0) >> 2] = i64toi32_i32$0;
   $3 = $6 + $3 | 0;
   HEAP32[($0 + 12 | 0) >> 2] = $3 + $4 | 0;
  }
  __stack_pointer = $2 + 16 | 0;
  return $3 | 0;
 }
 
 function ogg_sync_pageout($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $2 = 0;
  label$1 : {
   if ((HEAP32[($0 + 4 | 0) >> 2] | 0 | 0) < (0 | 0)) {
    break label$1
   }
   label$2 : while (1) {
    label$3 : {
     $2 = ogg_sync_pageseek($0 | 0, $1 | 0) | 0;
     if (($2 | 0) <= (0 | 0)) {
      break label$3
     }
     return 1 | 0;
    }
    label$4 : {
     if ($2) {
      break label$4
     }
     return 0 | 0;
    }
    if (HEAP32[($0 + 16 | 0) >> 2] | 0) {
     continue label$2
    }
    break label$2;
   };
   HEAP32[($0 + 16 | 0) >> 2] = 1;
   $2 = -1;
  }
  return $2 | 0;
 }
 
 function ogg_stream_pagein($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $13 = 0, $4 = 0, $2 = 0, $10 = 0, i64toi32_i32$0 = 0, $14 = 0, $6 = 0, $12 = 0, i64toi32_i32$1 = 0, $8 = 0, $7 = 0, $5 = 0, $15 = 0, $9 = 0, $16 = 0, $11 = 0, $11$hi = 0, $17 = 0;
  $2 = -1;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $3 = HEAP32[$0 >> 2] | 0;
   if (!$3) {
    break label$1
   }
   $4 = HEAP32[$1 >> 2] | 0;
   $5 = HEAPU8[($4 + 5 | 0) >> 0] | 0;
   $6 = HEAP32[($1 + 12 | 0) >> 2] | 0;
   $7 = HEAP32[($1 + 8 | 0) >> 2] | 0;
   $8 = HEAPU8[($4 + 26 | 0) >> 0] | 0;
   $9 = HEAPU8[($4 + 18 | 0) >> 0] | 0 | ((HEAPU8[($4 + 19 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($4 + 20 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($4 + 21 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
   $10 = HEAPU8[($4 + 14 | 0) >> 0] | 0 | ((HEAPU8[($4 + 15 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($4 + 16 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($4 + 17 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
   i64toi32_i32$0 = HEAPU8[($4 + 6 | 0) >> 0] | 0 | ((HEAPU8[($4 + 7 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($4 + 8 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($4 + 9 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
   i64toi32_i32$1 = HEAPU8[($4 + 10 | 0) >> 0] | 0 | ((HEAPU8[($4 + 11 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($4 + 12 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($4 + 13 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
   $11 = i64toi32_i32$0;
   $11$hi = i64toi32_i32$1;
   $12 = HEAPU8[($4 + 4 | 0) >> 0] | 0;
   $1 = HEAP32[($0 + 36 | 0) >> 2] | 0;
   label$2 : {
    $13 = HEAP32[($0 + 12 | 0) >> 2] | 0;
    if (!$13) {
     break label$2
    }
    $14 = (HEAP32[($0 + 8 | 0) >> 2] | 0) - $13 | 0;
    HEAP32[($0 + 8 | 0) >> 2] = $14;
    label$3 : {
     if (!$14) {
      break label$3
     }
     memmove($3 | 0, $3 + $13 | 0 | 0, $14 | 0) | 0;
    }
    HEAP32[($0 + 12 | 0) >> 2] = 0;
   }
   label$4 : {
    if (!$1) {
     break label$4
    }
    $3 = 0;
    label$5 : {
     $13 = (HEAP32[($0 + 28 | 0) >> 2] | 0) - $1 | 0;
     if (!$13) {
      break label$5
     }
     $3 = HEAP32[($0 + 16 | 0) >> 2] | 0;
     memmove($3 | 0, $3 + ($1 << 2 | 0) | 0 | 0, $13 << 2 | 0 | 0) | 0;
     $3 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     memmove($3 | 0, $3 + ($1 << 3 | 0) | 0 | 0, ((HEAP32[($0 + 28 | 0) >> 2] | 0) - $1 | 0) << 3 | 0 | 0) | 0;
     $3 = (HEAP32[($0 + 28 | 0) >> 2] | 0) - $1 | 0;
    }
    HEAP32[($0 + 28 | 0) >> 2] = $3;
    HEAP32[($0 + 36 | 0) >> 2] = 0;
    HEAP32[($0 + 32 | 0) >> 2] = (HEAP32[($0 + 32 | 0) >> 2] | 0) - $1 | 0;
   }
   if (($10 | 0) != (HEAP32[($0 + 336 | 0) >> 2] | 0 | 0)) {
    break label$1
   }
   if ($12 & 255 | 0) {
    break label$1
   }
   if (_os_lacing_expand($0 | 0, $8 + 1 | 0 | 0) | 0) {
    break label$1
   }
   $15 = $5 & 1 | 0;
   label$6 : {
    $16 = HEAP32[($0 + 340 | 0) >> 2] | 0;
    if (($9 | 0) == ($16 | 0)) {
     break label$6
    }
    label$7 : {
     $12 = HEAP32[($0 + 28 | 0) >> 2] | 0;
     $14 = HEAP32[($0 + 32 | 0) >> 2] | 0;
     if (($12 | 0) <= ($14 | 0)) {
      break label$7
     }
     $17 = $12 + ($14 ^ -1 | 0) | 0;
     $1 = HEAP32[($0 + 8 | 0) >> 2] | 0;
     $10 = HEAP32[($0 + 16 | 0) >> 2] | 0;
     label$8 : {
      label$9 : {
       $13 = ($12 - $14 | 0) & 3 | 0;
       if ($13) {
        break label$9
       }
       $2 = $14;
       break label$8;
      }
      $3 = $14;
      label$10 : while (1) {
       $1 = $1 - (HEAPU8[($10 + ($3 << 2 | 0) | 0) >> 0] | 0) | 0;
       $2 = $3 + 1 | 0;
       $3 = $2;
       $13 = $13 + -1 | 0;
       if ($13) {
        continue label$10
       }
       break label$10;
      };
     }
     label$11 : {
      if ($17 >>> 0 < 3 >>> 0) {
       break label$11
      }
      label$12 : while (1) {
       $3 = $10 + ($2 << 2 | 0) | 0;
       $1 = $1 - ((((HEAPU8[$3 >> 0] | 0) + (HEAPU8[($3 + 4 | 0) >> 0] | 0) | 0) + (HEAPU8[($3 + 8 | 0) >> 0] | 0) | 0) + (HEAPU8[($3 + 12 | 0) >> 0] | 0) | 0) | 0;
       $2 = $2 + 4 | 0;
       if (($2 | 0) != ($12 | 0)) {
        continue label$12
       }
       break label$12;
      };
     }
     HEAP32[($0 + 8 | 0) >> 2] = $1;
    }
    HEAP32[($0 + 28 | 0) >> 2] = $14;
    if (($16 | 0) == (-1 | 0)) {
     break label$6
    }
    $1 = $14 + 1 | 0;
    HEAP32[($0 + 28 | 0) >> 2] = $1;
    HEAP32[((HEAP32[($0 + 16 | 0) >> 2] | 0) + ($14 << 2 | 0) | 0) >> 2] = 1024;
    HEAP32[($0 + 32 | 0) >> 2] = $1;
   }
   $1 = $5 & 2 | 0;
   $2 = 0;
   label$13 : {
    if (!$15) {
     break label$13
    }
    label$14 : {
     $3 = HEAP32[($0 + 28 | 0) >> 2] | 0;
     if (($3 | 0) < (1 | 0)) {
      break label$14
     }
     if ((HEAP32[((($3 << 2 | 0) + (HEAP32[($0 + 16 | 0) >> 2] | 0) | 0) + -4 | 0) >> 2] | 0 | 0) != (1024 | 0)) {
      break label$13
     }
    }
    $1 = 0;
    label$15 : {
     if ($8) {
      break label$15
     }
     $2 = 0;
     break label$13;
    }
    label$16 : while (1) {
     $2 = $1 + 1 | 0;
     $1 = HEAPU8[(($1 + $4 | 0) + 27 | 0) >> 0] | 0;
     $6 = $6 - $1 | 0;
     $7 = $7 + $1 | 0;
     label$17 : {
      if (($1 | 0) == (255 | 0)) {
       break label$17
      }
      $1 = 0;
      break label$13;
     }
     $1 = $2;
     if (($1 | 0) != ($8 | 0)) {
      continue label$16
     }
     break label$16;
    };
    $1 = 0;
    $2 = $8;
   }
   label$18 : {
    if (!$6) {
     break label$18
    }
    label$19 : {
     label$20 : {
      $13 = HEAP32[($0 + 4 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + 8 | 0) >> 2] | 0;
      if (($13 - $6 | 0 | 0) <= ($3 | 0)) {
       break label$20
      }
      $13 = HEAP32[$0 >> 2] | 0;
      break label$19;
     }
     label$21 : {
      if (($13 | 0) <= (2147483647 - $6 | 0 | 0)) {
       break label$21
      }
      ogg_stream_clear($0 | 0) | 0;
      return -1 | 0;
     }
     label$22 : {
      $3 = $13 + $6 | 0;
      $3 = ($3 | 0) < (2147482623 | 0) ? $3 + 1024 | 0 : $3;
      $13 = dlrealloc(HEAP32[$0 >> 2] | 0 | 0, $3 | 0) | 0;
      if ($13) {
       break label$22
      }
      ogg_stream_clear($0 | 0) | 0;
      return -1 | 0;
     }
     HEAP32[$0 >> 2] = $13;
     HEAP32[($0 + 4 | 0) >> 2] = $3;
     $3 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    }
    __memcpy($13 + $3 | 0 | 0, $7 | 0, $6 | 0) | 0;
    HEAP32[($0 + 8 | 0) >> 2] = (HEAP32[($0 + 8 | 0) >> 2] | 0) + $6 | 0;
   }
   $14 = $5 & 4 | 0;
   label$23 : {
    if (($2 | 0) >= ($8 | 0)) {
     break label$23
    }
    $6 = HEAP32[($0 + 20 | 0) >> 2] | 0;
    $7 = HEAP32[($0 + 16 | 0) >> 2] | 0;
    $13 = HEAP32[($0 + 28 | 0) >> 2] | 0;
    $10 = $7 + ($13 << 2 | 0) | 0;
    $5 = $2 + $4 | 0;
    $3 = HEAPU8[($5 + 27 | 0) >> 0] | 0;
    HEAP32[$10 >> 2] = $3;
    i64toi32_i32$0 = $6 + ($13 << 3 | 0) | 0;
    i64toi32_i32$1 = -1;
    HEAP32[i64toi32_i32$0 >> 2] = -1;
    HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
    label$24 : {
     if (!$1) {
      break label$24
     }
     HEAP32[$10 >> 2] = $3 | 256 | 0;
    }
    $10 = $13 + 1 | 0;
    HEAP32[($0 + 28 | 0) >> 2] = $10;
    label$25 : {
     label$26 : {
      if (($3 | 0) != (255 | 0)) {
       break label$26
      }
      $12 = -1;
      break label$25;
     }
     HEAP32[($0 + 32 | 0) >> 2] = $10;
     $12 = $13;
    }
    label$27 : {
     $3 = $2 + 1 | 0;
     if (($3 | 0) == ($8 | 0)) {
      break label$27
     }
     $15 = $8 + -2 | 0;
     label$28 : {
      label$29 : {
       if ((($2 ^ -1 | 0) + $8 | 0) & 1 | 0) {
        break label$29
       }
       $1 = $10;
       break label$28;
      }
      $3 = HEAPU8[($5 + 28 | 0) >> 0] | 0;
      HEAP32[($7 + ($10 << 2 | 0) | 0) >> 2] = $3;
      i64toi32_i32$0 = $6 + ($10 << 3 | 0) | 0;
      i64toi32_i32$1 = -1;
      HEAP32[i64toi32_i32$0 >> 2] = -1;
      HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
      $1 = $13 + 2 | 0;
      HEAP32[($0 + 28 | 0) >> 2] = $1;
      label$30 : {
       if (($3 | 0) == (255 | 0)) {
        break label$30
       }
       HEAP32[($0 + 32 | 0) >> 2] = $1;
       $12 = $10;
      }
      $3 = $2 + 2 | 0;
     }
     if (($15 | 0) == ($2 | 0)) {
      break label$27
     }
     label$31 : while (1) {
      $13 = $3 + $4 | 0;
      $10 = HEAPU8[($13 + 27 | 0) >> 0] | 0;
      HEAP32[($7 + ($1 << 2 | 0) | 0) >> 2] = $10;
      i64toi32_i32$0 = $6 + ($1 << 3 | 0) | 0;
      i64toi32_i32$1 = -1;
      HEAP32[i64toi32_i32$0 >> 2] = -1;
      HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
      $2 = $1 + 1 | 0;
      HEAP32[($0 + 28 | 0) >> 2] = $2;
      label$32 : {
       if (($10 | 0) == (255 | 0)) {
        break label$32
       }
       HEAP32[($0 + 32 | 0) >> 2] = $2;
       $12 = $1;
      }
      $13 = HEAPU8[($13 + 28 | 0) >> 0] | 0;
      HEAP32[($7 + ($2 << 2 | 0) | 0) >> 2] = $13;
      i64toi32_i32$0 = $6 + ($2 << 3 | 0) | 0;
      i64toi32_i32$1 = -1;
      HEAP32[i64toi32_i32$0 >> 2] = -1;
      HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
      $1 = $1 + 2 | 0;
      HEAP32[($0 + 28 | 0) >> 2] = $1;
      label$33 : {
       if (($13 | 0) == (255 | 0)) {
        break label$33
       }
       HEAP32[($0 + 32 | 0) >> 2] = $1;
       $12 = $2;
      }
      $3 = $3 + 2 | 0;
      if (($3 | 0) != ($8 | 0)) {
       continue label$31
      }
      break label$31;
     };
    }
    if (($12 | 0) == (-1 | 0)) {
     break label$23
    }
    i64toi32_i32$1 = $11$hi;
    i64toi32_i32$0 = (HEAP32[($0 + 20 | 0) >> 2] | 0) + ($12 << 3 | 0) | 0;
    HEAP32[i64toi32_i32$0 >> 2] = $11;
    HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
   }
   label$34 : {
    if (!$14) {
     break label$34
    }
    HEAP32[($0 + 328 | 0) >> 2] = 1;
    $4 = HEAP32[($0 + 28 | 0) >> 2] | 0;
    if (($4 | 0) < (1 | 0)) {
     break label$34
    }
    $4 = (($4 << 2 | 0) + (HEAP32[($0 + 16 | 0) >> 2] | 0) | 0) + -4 | 0;
    HEAP32[$4 >> 2] = HEAP32[$4 >> 2] | 0 | 512 | 0;
   }
   HEAP32[($0 + 340 | 0) >> 2] = $9 + 1 | 0;
   $2 = 0;
  }
  return $2 | 0;
 }
 
 function ogg_sync_reset($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0;
  label$1 : {
   if ((HEAP32[($0 + 4 | 0) >> 2] | 0 | 0) >= (0 | 0)) {
    break label$1
   }
   return -1 | 0;
  }
  i64toi32_i32$1 = $0;
  i64toi32_i32$0 = 0;
  HEAP32[($0 + 8 | 0) >> 2] = 0;
  HEAP32[($0 + 12 | 0) >> 2] = i64toi32_i32$0;
  HEAP32[($0 + 24 | 0) >> 2] = 0;
  i64toi32_i32$1 = $0 + 16 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  return 0 | 0;
 }
 
 function ogg_stream_reset($0) {
  $0 = $0 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, $1 = 0;
  $1 = -1;
  label$1 : {
   if (!$0) {
    break label$1
   }
   if (!(HEAP32[$0 >> 2] | 0)) {
    break label$1
   }
   i64toi32_i32$1 = $0;
   i64toi32_i32$0 = 0;
   HEAP32[($0 + 344 | 0) >> 2] = 0;
   HEAP32[($0 + 348 | 0) >> 2] = i64toi32_i32$0;
   HEAP32[($0 + 340 | 0) >> 2] = -1;
   $1 = 0;
   HEAP32[($0 + 332 | 0) >> 2] = 0;
   i64toi32_i32$1 = $0;
   i64toi32_i32$0 = 0;
   HEAP32[($0 + 324 | 0) >> 2] = 0;
   HEAP32[($0 + 328 | 0) >> 2] = i64toi32_i32$0;
   HEAP32[($0 + 36 | 0) >> 2] = 0;
   i64toi32_i32$1 = $0;
   i64toi32_i32$0 = 0;
   HEAP32[($0 + 28 | 0) >> 2] = 0;
   HEAP32[($0 + 32 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$1 = $0;
   i64toi32_i32$0 = 0;
   HEAP32[($0 + 8 | 0) >> 2] = 0;
   HEAP32[($0 + 12 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$1 = $0 + 352 | 0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  }
  return $1 | 0;
 }
 
 function ogg_stream_packetout($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var i64toi32_i32$0 = 0, $2 = 0, i64toi32_i32$2 = 0, $8 = 0, $4 = 0, $7 = 0, i64toi32_i32$1 = 0, $6 = 0, i64toi32_i32$5 = 0, $3 = 0, $5 = 0, i64toi32_i32$3 = 0, i64toi32_i32$4 = 0, $72 = 0, $82 = 0, $90 = 0;
  $2 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $3 = HEAP32[$0 >> 2] | 0;
   if (!$3) {
    break label$1
   }
   $4 = HEAP32[($0 + 36 | 0) >> 2] | 0;
   if ((HEAP32[($0 + 32 | 0) >> 2] | 0 | 0) <= ($4 | 0)) {
    break label$1
   }
   $2 = -1;
   label$2 : {
    $5 = HEAP32[($0 + 16 | 0) >> 2] | 0;
    $6 = HEAP32[($5 + ($4 << 2 | 0) | 0) >> 2] | 0;
    if ($6 & 1024 | 0) {
     break label$2
    }
    $7 = $6 & 512 | 0;
    $2 = 255;
    label$3 : {
     label$4 : {
      $8 = $6 & 255 | 0;
      if (($8 | 0) == (255 | 0)) {
       break label$4
      }
      $2 = $8;
      break label$3;
     }
     label$5 : while (1) {
      $4 = $4 + 1 | 0;
      $8 = HEAP32[($5 + ($4 << 2 | 0) | 0) >> 2] | 0;
      $7 = $8 & 512 | 0 ? 512 : $7;
      $8 = $8 & 255 | 0;
      $2 = $8 + $2 | 0;
      if (($8 | 0) == (255 | 0)) {
       continue label$5
      }
      break label$5;
     };
    }
    label$6 : {
     label$7 : {
      if ($1) {
       break label$7
      }
      $7 = HEAP32[($0 + 12 | 0) >> 2] | 0;
      break label$6;
     }
     HEAP32[($1 + 8 | 0) >> 2] = $6 & 256 | 0;
     HEAP32[($1 + 12 | 0) >> 2] = $7;
     $7 = HEAP32[($0 + 12 | 0) >> 2] | 0;
     HEAP32[$1 >> 2] = $3 + $7 | 0;
     i64toi32_i32$2 = $0;
     i64toi32_i32$0 = HEAP32[($0 + 344 | 0) >> 2] | 0;
     i64toi32_i32$1 = HEAP32[($0 + 348 | 0) >> 2] | 0;
     $72 = i64toi32_i32$0;
     i64toi32_i32$0 = $1;
     HEAP32[(i64toi32_i32$0 + 24 | 0) >> 2] = $72;
     HEAP32[(i64toi32_i32$0 + 28 | 0) >> 2] = i64toi32_i32$1;
     i64toi32_i32$2 = (HEAP32[($0 + 20 | 0) >> 2] | 0) + ($4 << 3 | 0) | 0;
     i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
     i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
     HEAP32[($1 + 4 | 0) >> 2] = $2;
     $82 = i64toi32_i32$1;
     i64toi32_i32$1 = $1;
     HEAP32[($1 + 16 | 0) >> 2] = $82;
     HEAP32[($1 + 20 | 0) >> 2] = i64toi32_i32$0;
    }
    HEAP32[($0 + 12 | 0) >> 2] = $7 + $2 | 0;
    $2 = 1;
   }
   HEAP32[($0 + 36 | 0) >> 2] = $4 + 1 | 0;
   $90 = $0;
   i64toi32_i32$2 = $0;
   i64toi32_i32$0 = HEAP32[($0 + 344 | 0) >> 2] | 0;
   i64toi32_i32$1 = HEAP32[($0 + 348 | 0) >> 2] | 0;
   i64toi32_i32$2 = i64toi32_i32$0;
   i64toi32_i32$0 = 0;
   i64toi32_i32$3 = 1;
   i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
   i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$0 | 0;
   if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
    i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
   }
   i64toi32_i32$2 = $90;
   HEAP32[(i64toi32_i32$2 + 344 | 0) >> 2] = i64toi32_i32$4;
   HEAP32[(i64toi32_i32$2 + 348 | 0) >> 2] = i64toi32_i32$5;
  }
  return $2 | 0;
 }
 
 function FLAC__ogg_decoder_aspect_init($0) {
  $0 = $0 | 0;
  var i64toi32_i32$0 = 0, $1 = 0;
  $1 = 0;
  label$1 : {
   if (ogg_stream_init($0 + 8 | 0 | 0, HEAP32[($0 + 4 | 0) >> 2] | 0 | 0) | 0) {
    break label$1
   }
   if (ogg_sync_init($0 + 368 | 0 | 0) | 0) {
    break label$1
   }
   i64toi32_i32$0 = -1;
   HEAP32[($0 + 396 | 0) >> 2] = -1;
   HEAP32[($0 + 400 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$0 = 0;
   HEAP32[($0 + 408 | 0) >> 2] = 0;
   HEAP32[($0 + 412 | 0) >> 2] = i64toi32_i32$0;
   HEAP32[($0 + 404 | 0) >> 2] = HEAP32[$0 >> 2] | 0;
   $1 = 1;
  }
  return $1 | 0;
 }
 
 function FLAC__ogg_decoder_aspect_finish($0) {
  $0 = $0 | 0;
  ogg_sync_clear($0 + 368 | 0 | 0) | 0;
  ogg_stream_clear($0 + 8 | 0 | 0) | 0;
 }
 
 function FLAC__ogg_decoder_aspect_set_serial_number($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  HEAP32[($0 + 4 | 0) >> 2] = $1;
  HEAP32[$0 >> 2] = 0;
 }
 
 function FLAC__ogg_decoder_aspect_set_defaults($0) {
  $0 = $0 | 0;
  HEAP32[$0 >> 2] = 1;
 }
 
 function FLAC__ogg_decoder_aspect_flush($0) {
  $0 = $0 | 0;
  ogg_stream_reset($0 + 8 | 0 | 0) | 0;
  ogg_sync_reset($0 + 368 | 0 | 0) | 0;
  HEAP32[($0 + 408 | 0) >> 2] = 0;
  HEAP32[($0 + 412 | 0) >> 2] = 0;
 }
 
 function FLAC__ogg_decoder_aspect_reset($0) {
  $0 = $0 | 0;
  ogg_stream_reset($0 + 8 | 0 | 0) | 0;
  ogg_sync_reset($0 + 368 | 0 | 0) | 0;
  HEAP32[($0 + 408 | 0) >> 2] = 0;
  HEAP32[($0 + 412 | 0) >> 2] = 0;
  label$1 : {
   if (!(HEAP32[$0 >> 2] | 0)) {
    break label$1
   }
   HEAP32[($0 + 404 | 0) >> 2] = 1;
  }
 }
 
 function FLAC__ogg_decoder_aspect_read_callback_wrapper($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $10 = 0, $8 = 0, $9 = 0, $6 = 0, $7 = 0, $17 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0;
  $6 = __stack_pointer - 16 | 0;
  __stack_pointer = $6;
  $7 = HEAP32[$2 >> 2] | 0;
  HEAP32[$2 >> 2] = 0;
  $8 = GOT_data_internal_FLAC__OGG_MAPPING_MAGIC;
  $9 = GOT_data_internal_FLAC__OGG_MAPPING_FIRST_HEADER_PACKET_TYPE;
  $10 = 0;
  label$1 : {
   label$2 : {
    if (!$7) {
     break label$2
    }
    $11 = $0 + 416 | 0;
    $12 = $0 + 368 | 0;
    $13 = $0 + 8 | 0;
    $14 = $0 + 440 | 0;
    $15 = HEAP32[$8 >> 2] | 0;
    $16 = (HEAPU8[$9 >> 0] | 0) & 255 | 0;
    $10 = 0;
    label$3 : while (1) {
     if (HEAP32[($0 + 408 | 0) >> 2] | 0) {
      break label$2
     }
     label$4 : {
      label$5 : {
       if (!(HEAP32[($0 + 412 | 0) >> 2] | 0)) {
        break label$5
       }
       label$6 : {
        if (!(HEAP32[($0 + 432 | 0) >> 2] | 0)) {
         break label$6
        }
        $9 = HEAP32[($0 + 440 | 0) >> 2] | 0;
        label$7 : {
         $8 = HEAP32[($0 + 444 | 0) >> 2] | 0;
         $10 = $7 - $10 | 0;
         if ($8 >>> 0 > $10 >>> 0) {
          break label$7
         }
         $10 = __memcpy($1 | 0, $9 | 0, $8 | 0) | 0;
         HEAP32[$2 >> 2] = (HEAP32[$2 >> 2] | 0) + $8 | 0;
         HEAP32[($0 + 432 | 0) >> 2] = 0;
         $1 = $10 + $8 | 0;
         break label$4;
        }
        $8 = __memcpy($1 | 0, $9 | 0, $10 | 0) | 0;
        HEAP32[$2 >> 2] = (HEAP32[$2 >> 2] | 0) + $10 | 0;
        HEAP32[($0 + 440 | 0) >> 2] = (HEAP32[($0 + 440 | 0) >> 2] | 0) + $10 | 0;
        HEAP32[($0 + 444 | 0) >> 2] = (HEAP32[($0 + 444 | 0) >> 2] | 0) - $10 | 0;
        $1 = $8 + $10 | 0;
        break label$4;
       }
       label$8 : {
        $10 = ogg_stream_packetout($13 | 0, $14 | 0) | 0;
        if (($10 | 0) < (1 | 0)) {
         break label$8
        }
        HEAP32[($0 + 432 | 0) >> 2] = 1;
        $9 = HEAP32[($0 + 444 | 0) >> 2] | 0;
        if (($9 | 0) < (1 | 0)) {
         break label$4
        }
        $8 = HEAP32[$14 >> 2] | 0;
        if ((HEAPU8[$8 >> 0] | 0 | 0) != ($16 | 0)) {
         break label$4
        }
        $10 = 3;
        if (($9 | 0) < (9 | 0)) {
         break label$1
        }
        $17 = $15;
        if ((HEAPU8[($8 + 1 | 0) >> 0] | 0 | ((HEAPU8[($8 + 2 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($8 + 3 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($8 + 4 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0) != (HEAPU8[$17 >> 0] | 0 | ((HEAPU8[($17 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($17 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($17 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0)) {
         break label$1
        }
        $10 = HEAPU8[($8 + 5 | 0) >> 0] | 0;
        HEAP32[($0 + 396 | 0) >> 2] = $10;
        HEAP32[($0 + 400 | 0) >> 2] = HEAPU8[($8 + 6 | 0) >> 0] | 0;
        label$9 : {
         if (($10 | 0) == (1 | 0)) {
          break label$9
         }
         $10 = 4;
         break label$1;
        }
        HEAP32[($0 + 444 | 0) >> 2] = $9 + -9 | 0;
        HEAP32[($0 + 440 | 0) >> 2] = $8 + 9 | 0;
        break label$4;
       }
       label$10 : {
        if (!$10) {
         break label$10
        }
        $10 = 2;
        break label$1;
       }
       HEAP32[($0 + 412 | 0) >> 2] = 0;
       break label$4;
      }
      label$11 : {
       $10 = ogg_sync_pageout($12 | 0, $11 | 0) | 0;
       if (($10 | 0) < (1 | 0)) {
        break label$11
       }
       label$12 : {
        if (!(HEAP32[($0 + 404 | 0) >> 2] | 0)) {
         break label$12
        }
        $10 = ogg_page_serialno($11 | 0) | 0;
        HEAP32[($0 + 404 | 0) >> 2] = 0;
        HEAP32[($0 + 344 | 0) >> 2] = $10;
        HEAP32[($0 + 4 | 0) >> 2] = $10;
       }
       if (ogg_stream_pagein($13 | 0, $11 | 0) | 0) {
        break label$4
       }
       HEAP32[($0 + 432 | 0) >> 2] = 0;
       HEAP32[($0 + 412 | 0) >> 2] = 1;
       break label$4;
      }
      label$13 : {
       if (!$10) {
        break label$13
       }
       $10 = 2;
       break label$1;
      }
      label$14 : {
       $10 = $7 - (HEAP32[$2 >> 2] | 0) | 0;
       $10 = $10 >>> 0 > 8192 >>> 0 ? $10 : 8192;
       $8 = ogg_sync_buffer($12 | 0, $10 | 0) | 0;
       if ($8) {
        break label$14
       }
       $10 = 7;
       break label$1;
      }
      HEAP32[($6 + 12 | 0) >> 2] = $10;
      label$15 : {
       label$16 : {
        $10 = FUNCTION_TABLE[$3 | 0]($4, $8, $6 + 12 | 0, $5) | 0;
        switch ($10 + -1 | 0 | 0) {
        case 4:
         break label$1;
        case 0:
         break label$16;
        default:
         break label$15;
        };
       }
       HEAP32[($0 + 408 | 0) >> 2] = 1;
      }
      if ((ogg_sync_wrote($12 | 0, HEAP32[($6 + 12 | 0) >> 2] | 0 | 0) | 0 | 0) > (-1 | 0)) {
       break label$4
      }
      $10 = 6;
      break label$1;
     }
     $10 = HEAP32[$2 >> 2] | 0;
     if ($7 >>> 0 > $10 >>> 0) {
      continue label$3
     }
     break label$3;
    };
   }
   $10 = (HEAP32[($0 + 408 | 0) >> 2] | 0 | 0) != (0 | 0) & !$10 | 0;
  }
  __stack_pointer = $6 + 16 | 0;
  return $10 | 0;
 }
 
 function FLAC__MD5Init($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0;
  i64toi32_i32$1 = $0;
  i64toi32_i32$0 = 0;
  HEAP32[(i64toi32_i32$1 + 80 | 0) >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 84 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$0 = -271733879;
  HEAP32[(i64toi32_i32$1 + 64 | 0) >> 2] = 1732584193;
  HEAP32[(i64toi32_i32$1 + 68 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = i64toi32_i32$1 + 72 | 0;
  i64toi32_i32$0 = 271733878;
  HEAP32[i64toi32_i32$1 >> 2] = -1732584194;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = $0 + 88 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
 }
 
 function FLAC__MD5Final($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, i64toi32_i32$2 = 0, $2 = 0, $3 = 0, $10 = 0, $11 = 0, $4 = 0, $49 = 0, $52 = 0;
  $2 = (HEAP32[($1 + 80 | 0) >> 2] | 0) & 63 | 0;
  $3 = $1 + $2 | 0;
  HEAP8[$3 >> 0] = 128;
  $3 = $3 + 1 | 0;
  $4 = 56;
  label$1 : {
   label$2 : {
    if ($2 >>> 0 >= 56 >>> 0) {
     break label$2
    }
    $4 = 55 - $2 | 0;
    break label$1;
   }
   memset($3 | 0, 0 | 0, $2 ^ 63 | 0 | 0) | 0;
   FLAC__MD5Transform($1 + 64 | 0 | 0, $1 | 0);
   $3 = $1;
  }
  memset($3 | 0, 0 | 0, $4 | 0) | 0;
  $2 = HEAP32[($1 + 80 | 0) >> 2] | 0;
  HEAP32[($1 + 56 | 0) >> 2] = $2 << 3 | 0;
  HEAP32[($1 + 60 | 0) >> 2] = (HEAP32[($1 + 84 | 0) >> 2] | 0) << 3 | 0 | ($2 >>> 29 | 0) | 0;
  FLAC__MD5Transform($1 + 64 | 0 | 0, $1 | 0);
  i64toi32_i32$2 = $1 + 72 | 0;
  i64toi32_i32$0 = HEAPU8[i64toi32_i32$2 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$2 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$2 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$2 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
  i64toi32_i32$1 = HEAPU8[(i64toi32_i32$2 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$2 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$2 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$2 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
  $49 = i64toi32_i32$0;
  i64toi32_i32$0 = $0 + 8 | 0;
  $10 = $49;
  HEAP8[i64toi32_i32$0 >> 0] = $10;
  HEAP8[(i64toi32_i32$0 + 1 | 0) >> 0] = $10 >>> 8 | 0;
  HEAP8[(i64toi32_i32$0 + 2 | 0) >> 0] = $10 >>> 16 | 0;
  HEAP8[(i64toi32_i32$0 + 3 | 0) >> 0] = $10 >>> 24 | 0;
  HEAP8[(i64toi32_i32$0 + 4 | 0) >> 0] = i64toi32_i32$1;
  HEAP8[(i64toi32_i32$0 + 5 | 0) >> 0] = i64toi32_i32$1 >>> 8 | 0;
  HEAP8[(i64toi32_i32$0 + 6 | 0) >> 0] = i64toi32_i32$1 >>> 16 | 0;
  HEAP8[(i64toi32_i32$0 + 7 | 0) >> 0] = i64toi32_i32$1 >>> 24 | 0;
  i64toi32_i32$2 = $1;
  i64toi32_i32$1 = HEAPU8[($1 + 64 | 0) >> 0] | 0 | ((HEAPU8[($1 + 65 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($1 + 66 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($1 + 67 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
  i64toi32_i32$0 = HEAPU8[($1 + 68 | 0) >> 0] | 0 | ((HEAPU8[($1 + 69 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($1 + 70 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($1 + 71 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
  $52 = i64toi32_i32$1;
  i64toi32_i32$1 = $0;
  $11 = $52;
  HEAP8[i64toi32_i32$1 >> 0] = $11;
  HEAP8[(i64toi32_i32$1 + 1 | 0) >> 0] = $11 >>> 8 | 0;
  HEAP8[(i64toi32_i32$1 + 2 | 0) >> 0] = $11 >>> 16 | 0;
  HEAP8[(i64toi32_i32$1 + 3 | 0) >> 0] = $11 >>> 24 | 0;
  HEAP8[(i64toi32_i32$1 + 4 | 0) >> 0] = i64toi32_i32$0;
  HEAP8[(i64toi32_i32$1 + 5 | 0) >> 0] = i64toi32_i32$0 >>> 8 | 0;
  HEAP8[(i64toi32_i32$1 + 6 | 0) >> 0] = i64toi32_i32$0 >>> 16 | 0;
  HEAP8[(i64toi32_i32$1 + 7 | 0) >> 0] = i64toi32_i32$0 >>> 24 | 0;
  label$3 : {
   $0 = HEAP32[($1 + 88 | 0) >> 2] | 0;
   if (!$0) {
    break label$3
   }
   dlfree($0 | 0);
  }
  memset($1 | 0, 0 | 0, 96 | 0) | 0;
 }
 
 function FLAC__MD5Transform($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $14 = 0, $17 = 0, $18 = 0, $19 = 0, $13 = 0, $12 = 0, $26 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $11 = 0, $15 = 0, $16 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $10 = 0, $83 = 0, $88 = 0, $93 = 0, $146 = 0, $151 = 0, $156 = 0, $209 = 0, $214 = 0, $219 = 0, $272 = 0, $277 = 0, $282 = 0, $335 = 0, $338 = 0, $341 = 0, $394 = 0, $397 = 0, $400 = 0, $453 = 0, $456 = 0, $459 = 0, $512 = 0, $515 = 0, $546 = 0, $568 = 0, $571 = 0, $574 = 0, $597 = 0, $619 = 0, $622 = 0, $625 = 0, $648 = 0, $670 = 0, $673 = 0, $676 = 0, $699 = 0, $721 = 0, $724 = 0, $740 = 0, $773 = 0, $776 = 0, $779 = 0, $828 = 0, $831 = 0, $834 = 0, $883 = 0, $886 = 0, $889 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $2 = HEAP32[($1 + 16 | 0) >> 2] | 0;
  $3 = HEAP32[($1 + 32 | 0) >> 2] | 0;
  $4 = HEAP32[($1 + 48 | 0) >> 2] | 0;
  $5 = HEAP32[$1 >> 2] | 0;
  $6 = HEAP32[($1 + 36 | 0) >> 2] | 0;
  $7 = HEAP32[($1 + 52 | 0) >> 2] | 0;
  $8 = HEAP32[($1 + 4 | 0) >> 2] | 0;
  $9 = HEAP32[($1 + 20 | 0) >> 2] | 0;
  $10 = HEAP32[$0 >> 2] | 0;
  $11 = HEAP32[($0 + 12 | 0) >> 2] | 0;
  $12 = HEAP32[($0 + 8 | 0) >> 2] | 0;
  $13 = HEAP32[($0 + 4 | 0) >> 2] | 0;
  $14 = (__wasm_rotl_i32((($5 + $10 | 0) + ((($11 ^ $12 | 0) & $13 | 0) ^ $11 | 0) | 0) + -680876936 | 0 | 0, 7 | 0) | 0) + $13 | 0;
  $83 = $2 + $14 | 0;
  $15 = HEAP32[($1 + 12 | 0) >> 2] | 0;
  $88 = $13 + $15 | 0;
  $16 = HEAP32[($1 + 8 | 0) >> 2] | 0;
  $93 = $12 + $16 | 0;
  $17 = (__wasm_rotl_i32((($11 + $8 | 0) + (($14 & ($12 ^ $13 | 0) | 0) ^ $12 | 0) | 0) + -389564586 | 0 | 0, 12 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($93 + (($17 & ($14 ^ $13 | 0) | 0) ^ $13 | 0) | 0) + 606105819 | 0 | 0, 17 | 0) | 0) + $17 | 0;
  $14 = (__wasm_rotl_i32(($88 + (($18 & ($17 ^ $14 | 0) | 0) ^ $14 | 0) | 0) + -1044525330 | 0 | 0, 22 | 0) | 0) + $18 | 0;
  $19 = (__wasm_rotl_i32(($83 + (($14 & ($18 ^ $17 | 0) | 0) ^ $17 | 0) | 0) + -176418897 | 0 | 0, 7 | 0) | 0) + $14 | 0;
  $146 = $3 + $19 | 0;
  $20 = HEAP32[($1 + 28 | 0) >> 2] | 0;
  $151 = $20 + $14 | 0;
  $21 = HEAP32[($1 + 24 | 0) >> 2] | 0;
  $156 = $21 + $18 | 0;
  $17 = (__wasm_rotl_i32((($9 + $17 | 0) + (($19 & ($14 ^ $18 | 0) | 0) ^ $18 | 0) | 0) + 1200080426 | 0 | 0, 12 | 0) | 0) + $19 | 0;
  $14 = (__wasm_rotl_i32(($156 + (($17 & ($19 ^ $14 | 0) | 0) ^ $14 | 0) | 0) + -1473231341 | 0 | 0, 17 | 0) | 0) + $17 | 0;
  $18 = (__wasm_rotl_i32(($151 + (($14 & ($17 ^ $19 | 0) | 0) ^ $19 | 0) | 0) + -45705983 | 0 | 0, 22 | 0) | 0) + $14 | 0;
  $19 = (__wasm_rotl_i32(($146 + (($18 & ($14 ^ $17 | 0) | 0) ^ $17 | 0) | 0) + 1770035416 | 0 | 0, 7 | 0) | 0) + $18 | 0;
  $209 = $4 + $19 | 0;
  $22 = HEAP32[($1 + 44 | 0) >> 2] | 0;
  $214 = $22 + $18 | 0;
  $23 = HEAP32[($1 + 40 | 0) >> 2] | 0;
  $219 = $23 + $14 | 0;
  $14 = (__wasm_rotl_i32((($6 + $17 | 0) + (($19 & ($18 ^ $14 | 0) | 0) ^ $14 | 0) | 0) + -1958414417 | 0 | 0, 12 | 0) | 0) + $19 | 0;
  $17 = (__wasm_rotl_i32(($219 + (($14 & ($19 ^ $18 | 0) | 0) ^ $18 | 0) | 0) + -42063 | 0 | 0, 17 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($214 + (($17 & ($14 ^ $19 | 0) | 0) ^ $19 | 0) | 0) + -1990404162 | 0 | 0, 22 | 0) | 0) + $17 | 0;
  $19 = (__wasm_rotl_i32(($209 + (($18 & ($17 ^ $14 | 0) | 0) ^ $14 | 0) | 0) + 1804603682 | 0 | 0, 7 | 0) | 0) + $18 | 0;
  $272 = $8 + $19 | 0;
  $24 = HEAP32[($1 + 60 | 0) >> 2] | 0;
  $277 = $24 + $18 | 0;
  $25 = HEAP32[($1 + 56 | 0) >> 2] | 0;
  $282 = $25 + $17 | 0;
  $26 = (__wasm_rotl_i32((($7 + $14 | 0) + (($19 & ($18 ^ $17 | 0) | 0) ^ $17 | 0) | 0) + -40341101 | 0 | 0, 12 | 0) | 0) + $19 | 0;
  $1 = (__wasm_rotl_i32(($282 + (($26 & ($19 ^ $18 | 0) | 0) ^ $18 | 0) | 0) + -1502002290 | 0 | 0, 17 | 0) | 0) + $26 | 0;
  $14 = (__wasm_rotl_i32(($277 + (($1 & ($26 ^ $19 | 0) | 0) ^ $19 | 0) | 0) + 1236535329 | 0 | 0, 22 | 0) | 0) + $1 | 0;
  $17 = (__wasm_rotl_i32(($272 + ((($14 ^ $1 | 0) & $26 | 0) ^ $1 | 0) | 0) + -165796510 | 0 | 0, 5 | 0) | 0) + $14 | 0;
  $335 = $9 + $17 | 0;
  $338 = $5 + $14 | 0;
  $341 = $22 + $1 | 0;
  $1 = (__wasm_rotl_i32((($21 + $26 | 0) + ((($17 ^ $14 | 0) & $1 | 0) ^ $14 | 0) | 0) + -1069501632 | 0 | 0, 9 | 0) | 0) + $17 | 0;
  $14 = (__wasm_rotl_i32(($341 + ((($1 ^ $17 | 0) & $14 | 0) ^ $17 | 0) | 0) + 643717713 | 0 | 0, 14 | 0) | 0) + $1 | 0;
  $17 = (__wasm_rotl_i32(($338 + ((($14 ^ $1 | 0) & $17 | 0) ^ $1 | 0) | 0) + -373897302 | 0 | 0, 20 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($335 + ((($17 ^ $14 | 0) & $1 | 0) ^ $14 | 0) | 0) + -701558691 | 0 | 0, 5 | 0) | 0) + $17 | 0;
  $394 = $6 + $18 | 0;
  $397 = $2 + $17 | 0;
  $400 = $24 + $14 | 0;
  $1 = (__wasm_rotl_i32((($23 + $1 | 0) + ((($18 ^ $17 | 0) & $14 | 0) ^ $17 | 0) | 0) + 38016083 | 0 | 0, 9 | 0) | 0) + $18 | 0;
  $14 = (__wasm_rotl_i32(($400 + ((($1 ^ $18 | 0) & $17 | 0) ^ $18 | 0) | 0) + -660478335 | 0 | 0, 14 | 0) | 0) + $1 | 0;
  $17 = (__wasm_rotl_i32(($397 + ((($14 ^ $1 | 0) & $18 | 0) ^ $1 | 0) | 0) + -405537848 | 0 | 0, 20 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($394 + ((($17 ^ $14 | 0) & $1 | 0) ^ $14 | 0) | 0) + 568446438 | 0 | 0, 5 | 0) | 0) + $17 | 0;
  $453 = $7 + $18 | 0;
  $456 = $3 + $17 | 0;
  $459 = $15 + $14 | 0;
  $1 = (__wasm_rotl_i32((($25 + $1 | 0) + ((($18 ^ $17 | 0) & $14 | 0) ^ $17 | 0) | 0) + -1019803690 | 0 | 0, 9 | 0) | 0) + $18 | 0;
  $14 = (__wasm_rotl_i32(($459 + ((($1 ^ $18 | 0) & $17 | 0) ^ $18 | 0) | 0) + -187363961 | 0 | 0, 14 | 0) | 0) + $1 | 0;
  $17 = (__wasm_rotl_i32(($456 + ((($14 ^ $1 | 0) & $18 | 0) ^ $1 | 0) | 0) + 1163531501 | 0 | 0, 20 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($453 + ((($17 ^ $14 | 0) & $1 | 0) ^ $14 | 0) | 0) + -1444681467 | 0 | 0, 5 | 0) | 0) + $17 | 0;
  $512 = $9 + $18 | 0;
  $515 = $20 + $14 | 0;
  $1 = (__wasm_rotl_i32((($16 + $1 | 0) + ((($18 ^ $17 | 0) & $14 | 0) ^ $17 | 0) | 0) + -51403784 | 0 | 0, 9 | 0) | 0) + $18 | 0;
  $19 = (__wasm_rotl_i32(($515 + ((($1 ^ $18 | 0) & $17 | 0) ^ $18 | 0) | 0) + 1735328473 | 0 | 0, 14 | 0) | 0) + $1 | 0;
  $14 = $19 ^ $1 | 0;
  $546 = $14;
  $14 = (__wasm_rotl_i32((($4 + $17 | 0) + (($14 & $18 | 0) ^ $1 | 0) | 0) + -1926607734 | 0 | 0, 20 | 0) | 0) + $19 | 0;
  $17 = (__wasm_rotl_i32(($512 + ($546 ^ $14 | 0) | 0) + -378558 | 0 | 0, 4 | 0) | 0) + $14 | 0;
  $568 = $8 + $17 | 0;
  $571 = $22 + $19 | 0;
  $574 = $17 ^ $14 | 0;
  $1 = (__wasm_rotl_i32((($3 + $1 | 0) + (($14 ^ $19 | 0) ^ $17 | 0) | 0) + -2022574463 | 0 | 0, 11 | 0) | 0) + $17 | 0;
  $18 = (__wasm_rotl_i32(($571 + ($574 ^ $1 | 0) | 0) + 1839030562 | 0 | 0, 16 | 0) | 0) + $1 | 0;
  $597 = $18 ^ $1 | 0;
  $14 = (__wasm_rotl_i32((($25 + $14 | 0) + (($1 ^ $17 | 0) ^ $18 | 0) | 0) + -35309556 | 0 | 0, 23 | 0) | 0) + $18 | 0;
  $17 = (__wasm_rotl_i32(($568 + ($597 ^ $14 | 0) | 0) + -1530992060 | 0 | 0, 4 | 0) | 0) + $14 | 0;
  $619 = $7 + $17 | 0;
  $622 = $20 + $18 | 0;
  $625 = $17 ^ $14 | 0;
  $1 = (__wasm_rotl_i32((($2 + $1 | 0) + (($14 ^ $18 | 0) ^ $17 | 0) | 0) + 1272893353 | 0 | 0, 11 | 0) | 0) + $17 | 0;
  $18 = (__wasm_rotl_i32(($622 + ($625 ^ $1 | 0) | 0) + -155497632 | 0 | 0, 16 | 0) | 0) + $1 | 0;
  $648 = $18 ^ $1 | 0;
  $14 = (__wasm_rotl_i32((($23 + $14 | 0) + (($1 ^ $17 | 0) ^ $18 | 0) | 0) + -1094730640 | 0 | 0, 23 | 0) | 0) + $18 | 0;
  $17 = (__wasm_rotl_i32(($619 + ($648 ^ $14 | 0) | 0) + 681279174 | 0 | 0, 4 | 0) | 0) + $14 | 0;
  $670 = $6 + $17 | 0;
  $673 = $15 + $18 | 0;
  $676 = $17 ^ $14 | 0;
  $1 = (__wasm_rotl_i32((($5 + $1 | 0) + (($14 ^ $18 | 0) ^ $17 | 0) | 0) + -358537222 | 0 | 0, 11 | 0) | 0) + $17 | 0;
  $18 = (__wasm_rotl_i32(($673 + ($676 ^ $1 | 0) | 0) + -722521979 | 0 | 0, 16 | 0) | 0) + $1 | 0;
  $699 = $18 ^ $1 | 0;
  $14 = (__wasm_rotl_i32((($21 + $14 | 0) + (($1 ^ $17 | 0) ^ $18 | 0) | 0) + 76029189 | 0 | 0, 23 | 0) | 0) + $18 | 0;
  $17 = (__wasm_rotl_i32(($670 + ($699 ^ $14 | 0) | 0) + -640364487 | 0 | 0, 4 | 0) | 0) + $14 | 0;
  $721 = $5 + $17 | 0;
  $724 = $16 + $14 | 0;
  $1 = (__wasm_rotl_i32((($4 + $1 | 0) + (($14 ^ $18 | 0) ^ $17 | 0) | 0) + -421815835 | 0 | 0, 11 | 0) | 0) + $17 | 0;
  $740 = $1 ^ $17 | 0;
  $14 = (__wasm_rotl_i32((($24 + $18 | 0) + (($17 ^ $14 | 0) ^ $1 | 0) | 0) + 530742520 | 0 | 0, 16 | 0) | 0) + $1 | 0;
  $17 = (__wasm_rotl_i32(($724 + ($740 ^ $14 | 0) | 0) + -995338651 | 0 | 0, 23 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($721 + (($17 | ($1 ^ -1 | 0) | 0) ^ $14 | 0) | 0) + -198630844 | 0 | 0, 6 | 0) | 0) + $17 | 0;
  $773 = $4 + $18 | 0;
  $776 = $9 + $17 | 0;
  $779 = $25 + $14 | 0;
  $1 = (__wasm_rotl_i32((($20 + $1 | 0) + (($18 | ($14 ^ -1 | 0) | 0) ^ $17 | 0) | 0) + 1126891415 | 0 | 0, 10 | 0) | 0) + $18 | 0;
  $14 = (__wasm_rotl_i32(($779 + (($1 | ($17 ^ -1 | 0) | 0) ^ $18 | 0) | 0) + -1416354905 | 0 | 0, 15 | 0) | 0) + $1 | 0;
  $17 = (__wasm_rotl_i32(($776 + (($14 | ($18 ^ -1 | 0) | 0) ^ $1 | 0) | 0) + -57434055 | 0 | 0, 21 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($773 + (($17 | ($1 ^ -1 | 0) | 0) ^ $14 | 0) | 0) + 1700485571 | 0 | 0, 6 | 0) | 0) + $17 | 0;
  $828 = $3 + $18 | 0;
  $831 = $8 + $17 | 0;
  $834 = $23 + $14 | 0;
  $1 = (__wasm_rotl_i32((($15 + $1 | 0) + (($18 | ($14 ^ -1 | 0) | 0) ^ $17 | 0) | 0) + -1894986606 | 0 | 0, 10 | 0) | 0) + $18 | 0;
  $14 = (__wasm_rotl_i32(($834 + (($1 | ($17 ^ -1 | 0) | 0) ^ $18 | 0) | 0) + -1051523 | 0 | 0, 15 | 0) | 0) + $1 | 0;
  $17 = (__wasm_rotl_i32(($831 + (($14 | ($18 ^ -1 | 0) | 0) ^ $1 | 0) | 0) + -2054922799 | 0 | 0, 21 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($828 + (($17 | ($1 ^ -1 | 0) | 0) ^ $14 | 0) | 0) + 1873313359 | 0 | 0, 6 | 0) | 0) + $17 | 0;
  $883 = $2 + $18 | 0;
  $886 = $7 + $17 | 0;
  $889 = $21 + $14 | 0;
  $1 = (__wasm_rotl_i32((($24 + $1 | 0) + (($18 | ($14 ^ -1 | 0) | 0) ^ $17 | 0) | 0) + -30611744 | 0 | 0, 10 | 0) | 0) + $18 | 0;
  $14 = (__wasm_rotl_i32(($889 + (($1 | ($17 ^ -1 | 0) | 0) ^ $18 | 0) | 0) + -1560198380 | 0 | 0, 15 | 0) | 0) + $1 | 0;
  $17 = (__wasm_rotl_i32(($886 + (($14 | ($18 ^ -1 | 0) | 0) ^ $1 | 0) | 0) + 1309151649 | 0 | 0, 21 | 0) | 0) + $14 | 0;
  $18 = (__wasm_rotl_i32(($883 + (($17 | ($1 ^ -1 | 0) | 0) ^ $14 | 0) | 0) + -145523070 | 0 | 0, 6 | 0) | 0) + $17 | 0;
  HEAP32[$0 >> 2] = $18 + $10 | 0;
  $1 = (__wasm_rotl_i32((($22 + $1 | 0) + (($18 | ($14 ^ -1 | 0) | 0) ^ $17 | 0) | 0) + -1120210379 | 0 | 0, 10 | 0) | 0) + $18 | 0;
  HEAP32[($0 + 12 | 0) >> 2] = $11 + $1 | 0;
  $14 = (__wasm_rotl_i32((($16 + $14 | 0) + (($1 | ($17 ^ -1 | 0) | 0) ^ $18 | 0) | 0) + 718787259 | 0 | 0, 15 | 0) | 0) + $1 | 0;
  HEAP32[($0 + 8 | 0) >> 2] = $12 + $14 | 0;
  (wasm2js_i32$0 = $0, wasm2js_i32$1 = ($14 + $13 | 0) + (__wasm_rotl_i32((($6 + $17 | 0) + (($14 | ($18 ^ -1 | 0) | 0) ^ $1 | 0) | 0) + -343485551 | 0 | 0, 21 | 0) | 0) | 0), HEAP32[(wasm2js_i32$0 + 4 | 0) >> 2] = wasm2js_i32$1;
 }
 
 function FLAC__MD5Accumulate($0, $1, $2, $3, $4) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  var $5 = 0, i64toi32_i32$1 = 0, $6 = 0, i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, $7 = 0, $9 = 0, $10 = 0, $11 = 0, i64toi32_i32$4 = 0, $12 = 0, $8 = 0, i64toi32_i32$3 = 0, $13 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0, $15$hi = 0, $17$hi = 0, $22$hi = 0, $27$hi = 0, $1531 = 0, $1536 = 0, $1541 = 0, $1546 = 0, $1551 = 0, $1556 = 0, $1561 = 0, $1566 = 0;
  $5 = 0;
  label$1 : {
   i64toi32_i32$0 = 0;
   $15$hi = i64toi32_i32$0;
   i64toi32_i32$0 = 0;
   $17$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $15$hi;
   i64toi32_i32$1 = $17$hi;
   i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$0 | 0, $2 | 0, i64toi32_i32$1 | 0) | 0;
   i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
   i64toi32_i32$2 = i64toi32_i32$1;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 32;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$1 = 0;
    $39 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
    $39 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
   }
   if ($39) {
    break label$1
   }
   i64toi32_i32$1 = 0;
   $22$hi = i64toi32_i32$1;
   $6 = Math_imul($4, $2);
   i64toi32_i32$1 = 0;
   $27$hi = i64toi32_i32$1;
   i64toi32_i32$1 = $22$hi;
   i64toi32_i32$2 = $27$hi;
   i64toi32_i32$2 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $6 | 0, i64toi32_i32$2 | 0) | 0;
   i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
   i64toi32_i32$0 = i64toi32_i32$2;
   i64toi32_i32$2 = 0;
   i64toi32_i32$3 = 32;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$2 = 0;
    $40 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$2 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    $40 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
   }
   if ($40) {
    break label$1
   }
   $7 = HEAP32[($0 + 88 | 0) >> 2] | 0;
   label$2 : {
    label$3 : {
     $8 = Math_imul($6, $3);
     if ((HEAP32[($0 + 92 | 0) >> 2] | 0) >>> 0 < $8 >>> 0) {
      break label$3
     }
     $5 = $7;
     break label$2;
    }
    label$4 : {
     label$5 : {
      $5 = dlrealloc($7 | 0, $8 | 0) | 0;
      if (!$5) {
       break label$5
      }
      HEAP32[($0 + 88 | 0) >> 2] = $5;
      break label$4;
     }
     dlfree($7 | 0);
     $5 = dlmalloc($8 | 0) | 0;
     HEAP32[($0 + 88 | 0) >> 2] = $5;
     if ($5) {
      break label$4
     }
     HEAP32[($0 + 92 | 0) >> 2] = 0;
     return 0 | 0;
    }
    HEAP32[($0 + 92 | 0) >> 2] = $8;
   }
   label$6 : {
    label$7 : {
     label$8 : {
      label$9 : {
       label$10 : {
        label$11 : {
         label$12 : {
          label$13 : {
           label$14 : {
            label$15 : {
             label$16 : {
              label$17 : {
               label$18 : {
                label$19 : {
                 label$20 : {
                  label$21 : {
                   label$22 : {
                    label$23 : {
                     label$24 : {
                      label$25 : {
                       label$26 : {
                        label$27 : {
                         label$28 : {
                          label$29 : {
                           label$30 : {
                            $6 = Math_imul($4, 100) + $2 | 0;
                            if (($6 | 0) > (300 | 0)) {
                             break label$30
                            }
                            label$31 : {
                             switch ($6 + -101 | 0 | 0) {
                             case 0:
                              break label$20;
                             case 1:
                              break label$21;
                             case 3:
                              break label$22;
                             case 5:
                              break label$23;
                             case 7:
                              break label$24;
                             case 2:
                             case 4:
                             case 6:
                              break label$7;
                             default:
                              break label$31;
                             };
                            }
                            switch ($6 + -201 | 0 | 0) {
                            case 0:
                             break label$25;
                            case 1:
                             break label$26;
                            case 3:
                             break label$27;
                            case 5:
                             break label$28;
                            case 7:
                             break label$29;
                            default:
                             break label$7;
                            };
                           }
                           label$32 : {
                            label$33 : {
                             label$34 : {
                              switch ($6 + -401 | 0 | 0) {
                              default:
                               switch ($6 + -301 | 0 | 0) {
                               case 0:
                                break label$32;
                               case 1:
                                break label$33;
                               default:
                                break label$7;
                               };
                              case 7:
                               if (!$3) {
                                break label$6
                               }
                               $4 = HEAP32[($1 + 28 | 0) >> 2] | 0;
                               $6 = HEAP32[($1 + 24 | 0) >> 2] | 0;
                               $7 = HEAP32[($1 + 20 | 0) >> 2] | 0;
                               $9 = HEAP32[($1 + 16 | 0) >> 2] | 0;
                               $10 = HEAP32[($1 + 12 | 0) >> 2] | 0;
                               $11 = HEAP32[($1 + 8 | 0) >> 2] | 0;
                               $12 = HEAP32[($1 + 4 | 0) >> 2] | 0;
                               $13 = HEAP32[$1 >> 2] | 0;
                               $2 = 0;
                               label$40 : while (1) {
                                $1 = $2 << 2 | 0;
                                HEAP32[$5 >> 2] = HEAP32[($13 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 4 | 0) >> 2] = HEAP32[($12 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 8 | 0) >> 2] = HEAP32[($11 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 12 | 0) >> 2] = HEAP32[($10 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 16 | 0) >> 2] = HEAP32[($9 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 20 | 0) >> 2] = HEAP32[($7 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 24 | 0) >> 2] = HEAP32[($6 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 28 | 0) >> 2] = HEAP32[($4 + $1 | 0) >> 2] | 0;
                                $5 = $5 + 32 | 0;
                                $2 = $2 + 1 | 0;
                                if (($2 | 0) != ($3 | 0)) {
                                 continue label$40
                                }
                                break label$6;
                               };
                              case 5:
                               if (!$3) {
                                break label$6
                               }
                               $4 = HEAP32[($1 + 20 | 0) >> 2] | 0;
                               $6 = HEAP32[($1 + 16 | 0) >> 2] | 0;
                               $7 = HEAP32[($1 + 12 | 0) >> 2] | 0;
                               $9 = HEAP32[($1 + 8 | 0) >> 2] | 0;
                               $10 = HEAP32[($1 + 4 | 0) >> 2] | 0;
                               $11 = HEAP32[$1 >> 2] | 0;
                               $2 = 0;
                               label$41 : while (1) {
                                $1 = $2 << 2 | 0;
                                HEAP32[$5 >> 2] = HEAP32[($11 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 4 | 0) >> 2] = HEAP32[($10 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 8 | 0) >> 2] = HEAP32[($9 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 12 | 0) >> 2] = HEAP32[($7 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 16 | 0) >> 2] = HEAP32[($6 + $1 | 0) >> 2] | 0;
                                HEAP32[($5 + 20 | 0) >> 2] = HEAP32[($4 + $1 | 0) >> 2] | 0;
                                $5 = $5 + 24 | 0;
                                $2 = $2 + 1 | 0;
                                if (($2 | 0) != ($3 | 0)) {
                                 continue label$41
                                }
                                break label$6;
                               };
                              case 3:
                               if (!$3) {
                                break label$6
                               }
                               $10 = $3 & 1 | 0;
                               $2 = HEAP32[($1 + 12 | 0) >> 2] | 0;
                               $4 = HEAP32[($1 + 8 | 0) >> 2] | 0;
                               $6 = HEAP32[($1 + 4 | 0) >> 2] | 0;
                               $7 = HEAP32[$1 >> 2] | 0;
                               if (($3 | 0) != (1 | 0)) {
                                break label$9
                               }
                               $3 = 0;
                               break label$8;
                              case 1:
                               if (!$3) {
                                break label$6
                               }
                               $6 = $3 & 3 | 0;
                               $2 = HEAP32[($1 + 4 | 0) >> 2] | 0;
                               $4 = HEAP32[$1 >> 2] | 0;
                               if (($3 + -1 | 0) >>> 0 >= 3 >>> 0) {
                                break label$11
                               }
                               $1 = 0;
                               break label$10;
                              case 0:
                               break label$34;
                              case 2:
                              case 4:
                              case 6:
                               break label$7;
                              };
                             }
                             if (!$3) {
                              break label$6
                             }
                             $4 = $3 & 3 | 0;
                             $2 = HEAP32[$1 >> 2] | 0;
                             if (($3 + -1 | 0) >>> 0 >= 3 >>> 0) {
                              break label$13
                             }
                             $1 = 0;
                             break label$12;
                            }
                            if (!$3) {
                             break label$6
                            }
                            $2 = 0;
                            label$42 : while (1) {
                             $6 = $2 << 2 | 0;
                             $4 = HEAP32[((HEAP32[$1 >> 2] | 0) + $6 | 0) >> 2] | 0;
                             HEAP8[$5 >> 0] = $4;
                             HEAP8[($5 + 2 | 0) >> 0] = $4 >>> 16 | 0;
                             HEAP8[($5 + 1 | 0) >> 0] = $4 >>> 8 | 0;
                             $4 = HEAP32[((HEAP32[($1 + 4 | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
                             HEAP8[($5 + 3 | 0) >> 0] = $4;
                             HEAP8[($5 + 5 | 0) >> 0] = $4 >>> 16 | 0;
                             HEAP8[($5 + 4 | 0) >> 0] = $4 >>> 8 | 0;
                             $5 = $5 + 6 | 0;
                             $2 = $2 + 1 | 0;
                             if (($2 | 0) != ($3 | 0)) {
                              continue label$42
                             }
                             break label$6;
                            };
                           }
                           if (!$3) {
                            break label$6
                           }
                           $7 = $3 & 1 | 0;
                           $2 = 0;
                           label$43 : {
                            if (($3 | 0) == (1 | 0)) {
                             break label$43
                            }
                            $4 = $3 & -2 | 0;
                            $2 = 0;
                            label$44 : while (1) {
                             $6 = $2 << 2 | 0;
                             $3 = HEAP32[((HEAP32[$1 >> 2] | 0) + $6 | 0) >> 2] | 0;
                             HEAP8[$5 >> 0] = $3;
                             HEAP8[($5 + 2 | 0) >> 0] = $3 >>> 16 | 0;
                             HEAP8[($5 + 1 | 0) >> 0] = $3 >>> 8 | 0;
                             $3 = HEAP32[((HEAP32[$1 >> 2] | 0) + ($6 | 4 | 0) | 0) >> 2] | 0;
                             HEAP8[($5 + 3 | 0) >> 0] = $3;
                             HEAP8[($5 + 5 | 0) >> 0] = $3 >>> 16 | 0;
                             HEAP8[($5 + 4 | 0) >> 0] = $3 >>> 8 | 0;
                             $2 = $2 + 2 | 0;
                             $5 = $5 + 6 | 0;
                             $4 = $4 + -2 | 0;
                             if ($4) {
                              continue label$44
                             }
                             break label$44;
                            };
                           }
                           if (!$7) {
                            break label$6
                           }
                           $1 = HEAP32[((HEAP32[$1 >> 2] | 0) + ($2 << 2 | 0) | 0) >> 2] | 0;
                           HEAP8[$5 >> 0] = $1;
                           HEAP8[($5 + 2 | 0) >> 0] = $1 >>> 16 | 0;
                           HEAP8[($5 + 1 | 0) >> 0] = $1 >>> 8 | 0;
                           break label$6;
                          }
                          if (!$3) {
                           break label$6
                          }
                          $4 = HEAP32[($1 + 28 | 0) >> 2] | 0;
                          $6 = HEAP32[($1 + 24 | 0) >> 2] | 0;
                          $7 = HEAP32[($1 + 20 | 0) >> 2] | 0;
                          $9 = HEAP32[($1 + 16 | 0) >> 2] | 0;
                          $10 = HEAP32[($1 + 12 | 0) >> 2] | 0;
                          $11 = HEAP32[($1 + 8 | 0) >> 2] | 0;
                          $12 = HEAP32[($1 + 4 | 0) >> 2] | 0;
                          $13 = HEAP32[$1 >> 2] | 0;
                          $2 = 0;
                          label$45 : while (1) {
                           $1 = $2 << 2 | 0;
                           HEAP16[$5 >> 1] = HEAP32[($13 + $1 | 0) >> 2] | 0;
                           HEAP16[($5 + 2 | 0) >> 1] = HEAP32[($12 + $1 | 0) >> 2] | 0;
                           HEAP16[($5 + 4 | 0) >> 1] = HEAP32[($11 + $1 | 0) >> 2] | 0;
                           HEAP16[($5 + 6 | 0) >> 1] = HEAP32[($10 + $1 | 0) >> 2] | 0;
                           HEAP16[($5 + 8 | 0) >> 1] = HEAP32[($9 + $1 | 0) >> 2] | 0;
                           HEAP16[($5 + 10 | 0) >> 1] = HEAP32[($7 + $1 | 0) >> 2] | 0;
                           HEAP16[($5 + 12 | 0) >> 1] = HEAP32[($6 + $1 | 0) >> 2] | 0;
                           HEAP16[($5 + 14 | 0) >> 1] = HEAP32[($4 + $1 | 0) >> 2] | 0;
                           $5 = $5 + 16 | 0;
                           $2 = $2 + 1 | 0;
                           if (($2 | 0) != ($3 | 0)) {
                            continue label$45
                           }
                           break label$6;
                          };
                         }
                         if (!$3) {
                          break label$6
                         }
                         $4 = HEAP32[($1 + 20 | 0) >> 2] | 0;
                         $6 = HEAP32[($1 + 16 | 0) >> 2] | 0;
                         $7 = HEAP32[($1 + 12 | 0) >> 2] | 0;
                         $9 = HEAP32[($1 + 8 | 0) >> 2] | 0;
                         $10 = HEAP32[($1 + 4 | 0) >> 2] | 0;
                         $11 = HEAP32[$1 >> 2] | 0;
                         $2 = 0;
                         label$46 : while (1) {
                          $1 = $2 << 2 | 0;
                          HEAP16[$5 >> 1] = HEAP32[($11 + $1 | 0) >> 2] | 0;
                          HEAP16[($5 + 2 | 0) >> 1] = HEAP32[($10 + $1 | 0) >> 2] | 0;
                          HEAP16[($5 + 4 | 0) >> 1] = HEAP32[($9 + $1 | 0) >> 2] | 0;
                          HEAP16[($5 + 6 | 0) >> 1] = HEAP32[($7 + $1 | 0) >> 2] | 0;
                          HEAP16[($5 + 8 | 0) >> 1] = HEAP32[($6 + $1 | 0) >> 2] | 0;
                          HEAP16[($5 + 10 | 0) >> 1] = HEAP32[($4 + $1 | 0) >> 2] | 0;
                          $5 = $5 + 12 | 0;
                          $2 = $2 + 1 | 0;
                          if (($2 | 0) != ($3 | 0)) {
                           continue label$46
                          }
                          break label$6;
                         };
                        }
                        if (!$3) {
                         break label$6
                        }
                        $10 = $3 & 1 | 0;
                        $2 = HEAP32[($1 + 12 | 0) >> 2] | 0;
                        $4 = HEAP32[($1 + 8 | 0) >> 2] | 0;
                        $6 = HEAP32[($1 + 4 | 0) >> 2] | 0;
                        $7 = HEAP32[$1 >> 2] | 0;
                        if (($3 | 0) != (1 | 0)) {
                         break label$15
                        }
                        $3 = 0;
                        break label$14;
                       }
                       if (!$3) {
                        break label$6
                       }
                       $6 = $3 & 3 | 0;
                       $2 = HEAP32[($1 + 4 | 0) >> 2] | 0;
                       $4 = HEAP32[$1 >> 2] | 0;
                       if (($3 + -1 | 0) >>> 0 >= 3 >>> 0) {
                        break label$17
                       }
                       $1 = 0;
                       break label$16;
                      }
                      if (!$3) {
                       break label$6
                      }
                      $4 = $3 & 3 | 0;
                      $2 = HEAP32[$1 >> 2] | 0;
                      if (($3 + -1 | 0) >>> 0 >= 3 >>> 0) {
                       break label$19
                      }
                      $1 = 0;
                      break label$18;
                     }
                     if (!$3) {
                      break label$6
                     }
                     $4 = 0;
                     label$47 : while (1) {
                      $2 = $4 << 2 | 0;
                      HEAP8[$5 >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + $2 | 0) >> 2] | 0;
                      HEAP8[($5 + 1 | 0) >> 0] = HEAP32[((HEAP32[($1 + 4 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                      HEAP8[($5 + 2 | 0) >> 0] = HEAP32[((HEAP32[($1 + 8 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                      HEAP8[($5 + 3 | 0) >> 0] = HEAP32[((HEAP32[($1 + 12 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                      HEAP8[($5 + 4 | 0) >> 0] = HEAP32[((HEAP32[($1 + 16 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                      HEAP8[($5 + 5 | 0) >> 0] = HEAP32[((HEAP32[($1 + 20 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                      HEAP8[($5 + 6 | 0) >> 0] = HEAP32[((HEAP32[($1 + 24 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                      HEAP8[($5 + 7 | 0) >> 0] = HEAP32[((HEAP32[($1 + 28 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                      $5 = $5 + 8 | 0;
                      $4 = $4 + 1 | 0;
                      if (($4 | 0) != ($3 | 0)) {
                       continue label$47
                      }
                      break label$6;
                     };
                    }
                    if (!$3) {
                     break label$6
                    }
                    $4 = 0;
                    label$48 : while (1) {
                     $2 = $4 << 2 | 0;
                     HEAP8[$5 >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + $2 | 0) >> 2] | 0;
                     HEAP8[($5 + 1 | 0) >> 0] = HEAP32[((HEAP32[($1 + 4 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                     HEAP8[($5 + 2 | 0) >> 0] = HEAP32[((HEAP32[($1 + 8 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                     HEAP8[($5 + 3 | 0) >> 0] = HEAP32[((HEAP32[($1 + 12 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                     HEAP8[($5 + 4 | 0) >> 0] = HEAP32[((HEAP32[($1 + 16 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                     HEAP8[($5 + 5 | 0) >> 0] = HEAP32[((HEAP32[($1 + 20 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                     $5 = $5 + 6 | 0;
                     $4 = $4 + 1 | 0;
                     if (($4 | 0) != ($3 | 0)) {
                      continue label$48
                     }
                     break label$6;
                    };
                   }
                   if (!$3) {
                    break label$6
                   }
                   $4 = 0;
                   label$49 : while (1) {
                    $2 = $4 << 2 | 0;
                    HEAP8[$5 >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + $2 | 0) >> 2] | 0;
                    HEAP8[($5 + 1 | 0) >> 0] = HEAP32[((HEAP32[($1 + 4 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                    HEAP8[($5 + 2 | 0) >> 0] = HEAP32[((HEAP32[($1 + 8 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                    HEAP8[($5 + 3 | 0) >> 0] = HEAP32[((HEAP32[($1 + 12 | 0) >> 2] | 0) + $2 | 0) >> 2] | 0;
                    $5 = $5 + 4 | 0;
                    $4 = $4 + 1 | 0;
                    if (($4 | 0) != ($3 | 0)) {
                     continue label$49
                    }
                    break label$6;
                   };
                  }
                  if (!$3) {
                   break label$6
                  }
                  $6 = $3 & 1 | 0;
                  $2 = 0;
                  label$50 : {
                   if (($3 | 0) == (1 | 0)) {
                    break label$50
                   }
                   $4 = $3 & -2 | 0;
                   $2 = 0;
                   label$51 : while (1) {
                    $3 = $2 << 2 | 0;
                    HEAP8[$5 >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + $3 | 0) >> 2] | 0;
                    HEAP8[($5 + 1 | 0) >> 0] = HEAP32[((HEAP32[($1 + 4 | 0) >> 2] | 0) + $3 | 0) >> 2] | 0;
                    $3 = $3 | 4 | 0;
                    HEAP8[($5 + 2 | 0) >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + $3 | 0) >> 2] | 0;
                    HEAP8[($5 + 3 | 0) >> 0] = HEAP32[((HEAP32[($1 + 4 | 0) >> 2] | 0) + $3 | 0) >> 2] | 0;
                    $2 = $2 + 2 | 0;
                    $5 = $5 + 4 | 0;
                    $4 = $4 + -2 | 0;
                    if ($4) {
                     continue label$51
                    }
                    break label$51;
                   };
                  }
                  if (!$6) {
                   break label$6
                  }
                  $3 = $2 << 2 | 0;
                  HEAP8[$5 >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + $3 | 0) >> 2] | 0;
                  HEAP8[($5 + 1 | 0) >> 0] = HEAP32[((HEAP32[($1 + 4 | 0) >> 2] | 0) + $3 | 0) >> 2] | 0;
                  break label$6;
                 }
                 if (!$3) {
                  break label$6
                 }
                 $4 = $3 & 3 | 0;
                 $2 = 0;
                 label$52 : {
                  if (($3 + -1 | 0) >>> 0 < 3 >>> 0) {
                   break label$52
                  }
                  $6 = $3 & -4 | 0;
                  $2 = 0;
                  label$53 : while (1) {
                   $3 = $2 << 2 | 0;
                   HEAP8[$5 >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + $3 | 0) >> 2] | 0;
                   HEAP8[($5 + 1 | 0) >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + ($3 | 4 | 0) | 0) >> 2] | 0;
                   HEAP8[($5 + 2 | 0) >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + ($3 | 8 | 0) | 0) >> 2] | 0;
                   HEAP8[($5 + 3 | 0) >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + ($3 | 12 | 0) | 0) >> 2] | 0;
                   $2 = $2 + 4 | 0;
                   $5 = $5 + 4 | 0;
                   $6 = $6 + -4 | 0;
                   if ($6) {
                    continue label$53
                   }
                   break label$53;
                  };
                 }
                 if (!$4) {
                  break label$6
                 }
                 label$54 : while (1) {
                  HEAP8[$5 >> 0] = HEAP32[((HEAP32[$1 >> 2] | 0) + ($2 << 2 | 0) | 0) >> 2] | 0;
                  $2 = $2 + 1 | 0;
                  $5 = $5 + 1 | 0;
                  $4 = $4 + -1 | 0;
                  if ($4) {
                   continue label$54
                  }
                  break label$6;
                 };
                }
                $6 = $3 & -4 | 0;
                $1 = 0;
                label$55 : while (1) {
                 $3 = $1 << 2 | 0;
                 HEAP16[$5 >> 1] = HEAP32[($2 + $3 | 0) >> 2] | 0;
                 HEAP16[($5 + 2 | 0) >> 1] = HEAP32[($2 + ($3 | 4 | 0) | 0) >> 2] | 0;
                 HEAP16[($5 + 4 | 0) >> 1] = HEAP32[($2 + ($3 | 8 | 0) | 0) >> 2] | 0;
                 HEAP16[($5 + 6 | 0) >> 1] = HEAP32[($2 + ($3 | 12 | 0) | 0) >> 2] | 0;
                 $1 = $1 + 4 | 0;
                 $5 = $5 + 8 | 0;
                 $6 = $6 + -4 | 0;
                 if ($6) {
                  continue label$55
                 }
                 break label$55;
                };
               }
               if (!$4) {
                break label$6
               }
               label$56 : while (1) {
                HEAP16[$5 >> 1] = HEAP32[($2 + ($1 << 2 | 0) | 0) >> 2] | 0;
                $1 = $1 + 1 | 0;
                $5 = $5 + 2 | 0;
                $4 = $4 + -1 | 0;
                if ($4) {
                 continue label$56
                }
                break label$6;
               };
              }
              $7 = $3 & -4 | 0;
              $1 = 0;
              label$57 : while (1) {
               $3 = $1 << 2 | 0;
               HEAP16[$5 >> 1] = HEAP32[($4 + $3 | 0) >> 2] | 0;
               HEAP16[($5 + 2 | 0) >> 1] = HEAP32[($2 + $3 | 0) >> 2] | 0;
               $9 = $3 | 4 | 0;
               HEAP16[($5 + 4 | 0) >> 1] = HEAP32[($4 + $9 | 0) >> 2] | 0;
               HEAP16[($5 + 6 | 0) >> 1] = HEAP32[($2 + $9 | 0) >> 2] | 0;
               $9 = $3 | 8 | 0;
               HEAP16[($5 + 8 | 0) >> 1] = HEAP32[($4 + $9 | 0) >> 2] | 0;
               HEAP16[($5 + 10 | 0) >> 1] = HEAP32[($2 + $9 | 0) >> 2] | 0;
               $3 = $3 | 12 | 0;
               HEAP16[($5 + 12 | 0) >> 1] = HEAP32[($4 + $3 | 0) >> 2] | 0;
               HEAP16[($5 + 14 | 0) >> 1] = HEAP32[($2 + $3 | 0) >> 2] | 0;
               $1 = $1 + 4 | 0;
               $5 = $5 + 16 | 0;
               $7 = $7 + -4 | 0;
               if ($7) {
                continue label$57
               }
               break label$57;
              };
             }
             if (!$6) {
              break label$6
             }
             label$58 : while (1) {
              $3 = $1 << 2 | 0;
              HEAP16[$5 >> 1] = HEAP32[($4 + $3 | 0) >> 2] | 0;
              HEAP16[($5 + 2 | 0) >> 1] = HEAP32[($2 + $3 | 0) >> 2] | 0;
              $1 = $1 + 1 | 0;
              $5 = $5 + 4 | 0;
              $6 = $6 + -1 | 0;
              if ($6) {
               continue label$58
              }
              break label$6;
             };
            }
            $9 = $3 & -2 | 0;
            $3 = 0;
            label$59 : while (1) {
             $1 = $3 << 2 | 0;
             HEAP16[$5 >> 1] = HEAP32[($7 + $1 | 0) >> 2] | 0;
             HEAP16[($5 + 2 | 0) >> 1] = HEAP32[($6 + $1 | 0) >> 2] | 0;
             HEAP16[($5 + 4 | 0) >> 1] = HEAP32[($4 + $1 | 0) >> 2] | 0;
             HEAP16[($5 + 6 | 0) >> 1] = HEAP32[($2 + $1 | 0) >> 2] | 0;
             $1 = $1 | 4 | 0;
             HEAP16[($5 + 8 | 0) >> 1] = HEAP32[($7 + $1 | 0) >> 2] | 0;
             HEAP16[($5 + 10 | 0) >> 1] = HEAP32[($6 + $1 | 0) >> 2] | 0;
             HEAP16[($5 + 12 | 0) >> 1] = HEAP32[($4 + $1 | 0) >> 2] | 0;
             HEAP16[($5 + 14 | 0) >> 1] = HEAP32[($2 + $1 | 0) >> 2] | 0;
             $3 = $3 + 2 | 0;
             $5 = $5 + 16 | 0;
             $9 = $9 + -2 | 0;
             if ($9) {
              continue label$59
             }
             break label$59;
            };
           }
           if (!$10) {
            break label$6
           }
           $1 = $3 << 2 | 0;
           HEAP16[$5 >> 1] = HEAP32[($7 + $1 | 0) >> 2] | 0;
           HEAP16[($5 + 2 | 0) >> 1] = HEAP32[($6 + $1 | 0) >> 2] | 0;
           HEAP16[($5 + 4 | 0) >> 1] = HEAP32[($4 + $1 | 0) >> 2] | 0;
           HEAP16[($5 + 6 | 0) >> 1] = HEAP32[($2 + $1 | 0) >> 2] | 0;
           break label$6;
          }
          $6 = $3 & -4 | 0;
          $1 = 0;
          label$60 : while (1) {
           $3 = $1 << 2 | 0;
           HEAP32[$5 >> 2] = HEAP32[($2 + $3 | 0) >> 2] | 0;
           HEAP32[($5 + 4 | 0) >> 2] = HEAP32[($2 + ($3 | 4 | 0) | 0) >> 2] | 0;
           HEAP32[($5 + 8 | 0) >> 2] = HEAP32[($2 + ($3 | 8 | 0) | 0) >> 2] | 0;
           HEAP32[($5 + 12 | 0) >> 2] = HEAP32[($2 + ($3 | 12 | 0) | 0) >> 2] | 0;
           $1 = $1 + 4 | 0;
           $5 = $5 + 16 | 0;
           $6 = $6 + -4 | 0;
           if ($6) {
            continue label$60
           }
           break label$60;
          };
         }
         if (!$4) {
          break label$6
         }
         label$61 : while (1) {
          HEAP32[$5 >> 2] = HEAP32[($2 + ($1 << 2 | 0) | 0) >> 2] | 0;
          $1 = $1 + 1 | 0;
          $5 = $5 + 4 | 0;
          $4 = $4 + -1 | 0;
          if ($4) {
           continue label$61
          }
          break label$6;
         };
        }
        $7 = $3 & -4 | 0;
        $1 = 0;
        label$62 : while (1) {
         $3 = $1 << 2 | 0;
         HEAP32[$5 >> 2] = HEAP32[($4 + $3 | 0) >> 2] | 0;
         HEAP32[($5 + 4 | 0) >> 2] = HEAP32[($2 + $3 | 0) >> 2] | 0;
         $9 = $3 | 4 | 0;
         HEAP32[($5 + 8 | 0) >> 2] = HEAP32[($4 + $9 | 0) >> 2] | 0;
         HEAP32[($5 + 12 | 0) >> 2] = HEAP32[($2 + $9 | 0) >> 2] | 0;
         $9 = $3 | 8 | 0;
         HEAP32[($5 + 16 | 0) >> 2] = HEAP32[($4 + $9 | 0) >> 2] | 0;
         HEAP32[($5 + 20 | 0) >> 2] = HEAP32[($2 + $9 | 0) >> 2] | 0;
         $3 = $3 | 12 | 0;
         HEAP32[($5 + 24 | 0) >> 2] = HEAP32[($4 + $3 | 0) >> 2] | 0;
         HEAP32[($5 + 28 | 0) >> 2] = HEAP32[($2 + $3 | 0) >> 2] | 0;
         $1 = $1 + 4 | 0;
         $5 = $5 + 32 | 0;
         $7 = $7 + -4 | 0;
         if ($7) {
          continue label$62
         }
         break label$62;
        };
       }
       if (!$6) {
        break label$6
       }
       label$63 : while (1) {
        $3 = $1 << 2 | 0;
        HEAP32[$5 >> 2] = HEAP32[($4 + $3 | 0) >> 2] | 0;
        HEAP32[($5 + 4 | 0) >> 2] = HEAP32[($2 + $3 | 0) >> 2] | 0;
        $1 = $1 + 1 | 0;
        $5 = $5 + 8 | 0;
        $6 = $6 + -1 | 0;
        if ($6) {
         continue label$63
        }
        break label$6;
       };
      }
      $9 = $3 & -2 | 0;
      $3 = 0;
      label$64 : while (1) {
       $1 = $3 << 2 | 0;
       HEAP32[$5 >> 2] = HEAP32[($7 + $1 | 0) >> 2] | 0;
       HEAP32[($5 + 4 | 0) >> 2] = HEAP32[($6 + $1 | 0) >> 2] | 0;
       HEAP32[($5 + 8 | 0) >> 2] = HEAP32[($4 + $1 | 0) >> 2] | 0;
       HEAP32[($5 + 12 | 0) >> 2] = HEAP32[($2 + $1 | 0) >> 2] | 0;
       $1 = $1 | 4 | 0;
       HEAP32[($5 + 16 | 0) >> 2] = HEAP32[($7 + $1 | 0) >> 2] | 0;
       HEAP32[($5 + 20 | 0) >> 2] = HEAP32[($6 + $1 | 0) >> 2] | 0;
       HEAP32[($5 + 24 | 0) >> 2] = HEAP32[($4 + $1 | 0) >> 2] | 0;
       HEAP32[($5 + 28 | 0) >> 2] = HEAP32[($2 + $1 | 0) >> 2] | 0;
       $3 = $3 + 2 | 0;
       $5 = $5 + 32 | 0;
       $9 = $9 + -2 | 0;
       if ($9) {
        continue label$64
       }
       break label$64;
      };
     }
     if (!$10) {
      break label$6
     }
     $1 = $3 << 2 | 0;
     HEAP32[$5 >> 2] = HEAP32[($7 + $1 | 0) >> 2] | 0;
     HEAP32[($5 + 4 | 0) >> 2] = HEAP32[($6 + $1 | 0) >> 2] | 0;
     HEAP32[($5 + 8 | 0) >> 2] = HEAP32[($4 + $1 | 0) >> 2] | 0;
     HEAP32[($5 + 12 | 0) >> 2] = HEAP32[($2 + $1 | 0) >> 2] | 0;
     break label$6;
    }
    label$65 : {
     switch ($4 + -1 | 0 | 0) {
     case 3:
      if (!$3) {
       break label$6
      }
      if (!$2) {
       break label$6
      }
      $11 = $2 & -4 | 0;
      $10 = $2 & 3 | 0;
      $7 = 0;
      $12 = ($2 + -1 | 0) >>> 0 < 3 >>> 0;
      label$69 : while (1) {
       $2 = 0;
       $9 = $11;
       label$70 : {
        if ($12) {
         break label$70
        }
        label$71 : while (1) {
         $4 = $2 << 2 | 0;
         $6 = $7 << 2 | 0;
         HEAP32[$5 >> 2] = HEAP32[((HEAP32[($1 + $4 | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
         HEAP32[($5 + 4 | 0) >> 2] = HEAP32[((HEAP32[($1 + ($4 | 4 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
         HEAP32[($5 + 8 | 0) >> 2] = HEAP32[((HEAP32[($1 + ($4 | 8 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
         HEAP32[($5 + 12 | 0) >> 2] = HEAP32[((HEAP32[($1 + ($4 | 12 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
         $2 = $2 + 4 | 0;
         $5 = $5 + 16 | 0;
         $9 = $9 + -4 | 0;
         if ($9) {
          continue label$71
         }
         break label$71;
        };
       }
       $4 = $10;
       label$72 : {
        if (!$4) {
         break label$72
        }
        label$73 : while (1) {
         HEAP32[$5 >> 2] = HEAP32[((HEAP32[($1 + ($2 << 2 | 0) | 0) >> 2] | 0) + ($7 << 2 | 0) | 0) >> 2] | 0;
         $2 = $2 + 1 | 0;
         $5 = $5 + 4 | 0;
         $4 = $4 + -1 | 0;
         if ($4) {
          continue label$73
         }
         break label$73;
        };
       }
       $7 = $7 + 1 | 0;
       if (($7 | 0) != ($3 | 0)) {
        continue label$69
       }
       break label$6;
      };
     case 2:
      if (!$3) {
       break label$6
      }
      if (!$2) {
       break label$6
      }
      $12 = $2 & -2 | 0;
      $13 = $2 & 1 | 0;
      $11 = 0;
      label$74 : while (1) {
       $4 = 0;
       $7 = $12;
       label$75 : {
        if (($2 | 0) == (1 | 0)) {
         break label$75
        }
        label$76 : while (1) {
         $9 = $4 << 2 | 0;
         $10 = $11 << 2 | 0;
         $6 = HEAP32[((HEAP32[($1 + $9 | 0) >> 2] | 0) + $10 | 0) >> 2] | 0;
         HEAP8[$5 >> 0] = $6;
         HEAP8[($5 + 2 | 0) >> 0] = $6 >>> 16 | 0;
         HEAP8[($5 + 1 | 0) >> 0] = $6 >>> 8 | 0;
         $6 = HEAP32[((HEAP32[($1 + ($9 | 4 | 0) | 0) >> 2] | 0) + $10 | 0) >> 2] | 0;
         HEAP8[($5 + 3 | 0) >> 0] = $6;
         HEAP8[($5 + 5 | 0) >> 0] = $6 >>> 16 | 0;
         HEAP8[($5 + 4 | 0) >> 0] = $6 >>> 8 | 0;
         $4 = $4 + 2 | 0;
         $5 = $5 + 6 | 0;
         $7 = $7 + -2 | 0;
         if ($7) {
          continue label$76
         }
         break label$76;
        };
       }
       label$77 : {
        if (!$13) {
         break label$77
        }
        $4 = HEAP32[((HEAP32[($1 + ($4 << 2 | 0) | 0) >> 2] | 0) + ($11 << 2 | 0) | 0) >> 2] | 0;
        HEAP8[$5 >> 0] = $4;
        HEAP8[($5 + 2 | 0) >> 0] = $4 >>> 16 | 0;
        HEAP8[($5 + 1 | 0) >> 0] = $4 >>> 8 | 0;
        $5 = $5 + 3 | 0;
       }
       $11 = $11 + 1 | 0;
       if (($11 | 0) != ($3 | 0)) {
        continue label$74
       }
       break label$6;
      };
     case 1:
      if (!$3) {
       break label$6
      }
      if (!$2) {
       break label$6
      }
      $11 = $2 & -4 | 0;
      $10 = $2 & 3 | 0;
      $7 = 0;
      $12 = ($2 + -1 | 0) >>> 0 < 3 >>> 0;
      label$78 : while (1) {
       $2 = 0;
       $9 = $11;
       label$79 : {
        if ($12) {
         break label$79
        }
        label$80 : while (1) {
         $4 = $2 << 2 | 0;
         $6 = $7 << 2 | 0;
         HEAP16[$5 >> 1] = HEAP32[((HEAP32[($1 + $4 | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
         HEAP16[($5 + 2 | 0) >> 1] = HEAP32[((HEAP32[($1 + ($4 | 4 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
         HEAP16[($5 + 4 | 0) >> 1] = HEAP32[((HEAP32[($1 + ($4 | 8 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
         HEAP16[($5 + 6 | 0) >> 1] = HEAP32[((HEAP32[($1 + ($4 | 12 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
         $2 = $2 + 4 | 0;
         $5 = $5 + 8 | 0;
         $9 = $9 + -4 | 0;
         if ($9) {
          continue label$80
         }
         break label$80;
        };
       }
       $4 = $10;
       label$81 : {
        if (!$4) {
         break label$81
        }
        label$82 : while (1) {
         HEAP16[$5 >> 1] = HEAP32[((HEAP32[($1 + ($2 << 2 | 0) | 0) >> 2] | 0) + ($7 << 2 | 0) | 0) >> 2] | 0;
         $2 = $2 + 1 | 0;
         $5 = $5 + 2 | 0;
         $4 = $4 + -1 | 0;
         if ($4) {
          continue label$82
         }
         break label$82;
        };
       }
       $7 = $7 + 1 | 0;
       if (($7 | 0) != ($3 | 0)) {
        continue label$78
       }
       break label$6;
      };
     case 0:
      break label$65;
     default:
      break label$6;
     };
    }
    if (!$3) {
     break label$6
    }
    if (!$2) {
     break label$6
    }
    $11 = $2 & -4 | 0;
    $10 = $2 & 3 | 0;
    $7 = 0;
    $12 = ($2 + -1 | 0) >>> 0 < 3 >>> 0;
    label$83 : while (1) {
     $2 = 0;
     $9 = $11;
     label$84 : {
      if ($12) {
       break label$84
      }
      label$85 : while (1) {
       $4 = $2 << 2 | 0;
       $6 = $7 << 2 | 0;
       HEAP8[$5 >> 0] = HEAP32[((HEAP32[($1 + $4 | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
       HEAP8[($5 + 1 | 0) >> 0] = HEAP32[((HEAP32[($1 + ($4 | 4 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
       HEAP8[($5 + 2 | 0) >> 0] = HEAP32[((HEAP32[($1 + ($4 | 8 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
       HEAP8[($5 + 3 | 0) >> 0] = HEAP32[((HEAP32[($1 + ($4 | 12 | 0) | 0) >> 2] | 0) + $6 | 0) >> 2] | 0;
       $2 = $2 + 4 | 0;
       $5 = $5 + 4 | 0;
       $9 = $9 + -4 | 0;
       if ($9) {
        continue label$85
       }
       break label$85;
      };
     }
     $4 = $10;
     label$86 : {
      if (!$4) {
       break label$86
      }
      label$87 : while (1) {
       HEAP8[$5 >> 0] = HEAP32[((HEAP32[($1 + ($2 << 2 | 0) | 0) >> 2] | 0) + ($7 << 2 | 0) | 0) >> 2] | 0;
       $2 = $2 + 1 | 0;
       $5 = $5 + 1 | 0;
       $4 = $4 + -1 | 0;
       if ($4) {
        continue label$87
       }
       break label$87;
      };
     }
     $7 = $7 + 1 | 0;
     if (($7 | 0) != ($3 | 0)) {
      continue label$83
     }
     break label$83;
    };
   }
   $5 = HEAP32[($0 + 80 | 0) >> 2] | 0;
   $1 = $5 + $8 | 0;
   HEAP32[($0 + 80 | 0) >> 2] = $1;
   label$88 : {
    if ($1 >>> 0 >= $5 >>> 0) {
     break label$88
    }
    $1 = $0 + 84 | 0;
    HEAP32[$1 >> 2] = (HEAP32[$1 >> 2] | 0) + 1 | 0;
   }
   $1 = HEAP32[($0 + 88 | 0) >> 2] | 0;
   $4 = $5 | -64 | 0;
   label$89 : {
    label$90 : {
     $2 = 64 - ($5 & 63 | 0) | 0;
     if ($8 >>> 0 >= $2 >>> 0) {
      break label$90
     }
     __memcpy(($0 + $4 | 0) + 64 | 0 | 0, $1 | 0, $8 | 0) | 0;
     break label$89;
    }
    $3 = $0 + 64 | 0;
    __memcpy($3 + $4 | 0 | 0, $1 | 0, $2 | 0) | 0;
    FLAC__MD5Transform($3 | 0, $0 | 0);
    $5 = $1 + $2 | 0;
    label$91 : {
     $1 = $8 - $2 | 0;
     if ($1 >>> 0 < 64 >>> 0) {
      break label$91
     }
     label$92 : while (1) {
      i64toi32_i32$1 = $5;
      i64toi32_i32$2 = HEAPU8[$5 >> 0] | 0 | ((HEAPU8[($5 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($5 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($5 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      i64toi32_i32$0 = HEAPU8[($5 + 4 | 0) >> 0] | 0 | ((HEAPU8[($5 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($5 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($5 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      $1531 = i64toi32_i32$2;
      i64toi32_i32$2 = $0;
      $31 = $1531;
      HEAP8[$0 >> 0] = $31;
      HEAP8[($0 + 1 | 0) >> 0] = $31 >>> 8 | 0;
      HEAP8[($0 + 2 | 0) >> 0] = $31 >>> 16 | 0;
      HEAP8[($0 + 3 | 0) >> 0] = $31 >>> 24 | 0;
      HEAP8[($0 + 4 | 0) >> 0] = i64toi32_i32$0;
      HEAP8[($0 + 5 | 0) >> 0] = i64toi32_i32$0 >>> 8 | 0;
      HEAP8[($0 + 6 | 0) >> 0] = i64toi32_i32$0 >>> 16 | 0;
      HEAP8[($0 + 7 | 0) >> 0] = i64toi32_i32$0 >>> 24 | 0;
      i64toi32_i32$1 = $5 + 56 | 0;
      i64toi32_i32$0 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      i64toi32_i32$2 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      $1536 = i64toi32_i32$0;
      i64toi32_i32$0 = $0 + 56 | 0;
      $32 = $1536;
      HEAP8[i64toi32_i32$0 >> 0] = $32;
      HEAP8[(i64toi32_i32$0 + 1 | 0) >> 0] = $32 >>> 8 | 0;
      HEAP8[(i64toi32_i32$0 + 2 | 0) >> 0] = $32 >>> 16 | 0;
      HEAP8[(i64toi32_i32$0 + 3 | 0) >> 0] = $32 >>> 24 | 0;
      HEAP8[(i64toi32_i32$0 + 4 | 0) >> 0] = i64toi32_i32$2;
      HEAP8[(i64toi32_i32$0 + 5 | 0) >> 0] = i64toi32_i32$2 >>> 8 | 0;
      HEAP8[(i64toi32_i32$0 + 6 | 0) >> 0] = i64toi32_i32$2 >>> 16 | 0;
      HEAP8[(i64toi32_i32$0 + 7 | 0) >> 0] = i64toi32_i32$2 >>> 24 | 0;
      i64toi32_i32$1 = $5 + 48 | 0;
      i64toi32_i32$2 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      i64toi32_i32$0 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      $1541 = i64toi32_i32$2;
      i64toi32_i32$2 = $0 + 48 | 0;
      $33 = $1541;
      HEAP8[i64toi32_i32$2 >> 0] = $33;
      HEAP8[(i64toi32_i32$2 + 1 | 0) >> 0] = $33 >>> 8 | 0;
      HEAP8[(i64toi32_i32$2 + 2 | 0) >> 0] = $33 >>> 16 | 0;
      HEAP8[(i64toi32_i32$2 + 3 | 0) >> 0] = $33 >>> 24 | 0;
      HEAP8[(i64toi32_i32$2 + 4 | 0) >> 0] = i64toi32_i32$0;
      HEAP8[(i64toi32_i32$2 + 5 | 0) >> 0] = i64toi32_i32$0 >>> 8 | 0;
      HEAP8[(i64toi32_i32$2 + 6 | 0) >> 0] = i64toi32_i32$0 >>> 16 | 0;
      HEAP8[(i64toi32_i32$2 + 7 | 0) >> 0] = i64toi32_i32$0 >>> 24 | 0;
      i64toi32_i32$1 = $5 + 40 | 0;
      i64toi32_i32$0 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      i64toi32_i32$2 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      $1546 = i64toi32_i32$0;
      i64toi32_i32$0 = $0 + 40 | 0;
      $34 = $1546;
      HEAP8[i64toi32_i32$0 >> 0] = $34;
      HEAP8[(i64toi32_i32$0 + 1 | 0) >> 0] = $34 >>> 8 | 0;
      HEAP8[(i64toi32_i32$0 + 2 | 0) >> 0] = $34 >>> 16 | 0;
      HEAP8[(i64toi32_i32$0 + 3 | 0) >> 0] = $34 >>> 24 | 0;
      HEAP8[(i64toi32_i32$0 + 4 | 0) >> 0] = i64toi32_i32$2;
      HEAP8[(i64toi32_i32$0 + 5 | 0) >> 0] = i64toi32_i32$2 >>> 8 | 0;
      HEAP8[(i64toi32_i32$0 + 6 | 0) >> 0] = i64toi32_i32$2 >>> 16 | 0;
      HEAP8[(i64toi32_i32$0 + 7 | 0) >> 0] = i64toi32_i32$2 >>> 24 | 0;
      i64toi32_i32$1 = $5 + 32 | 0;
      i64toi32_i32$2 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      i64toi32_i32$0 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      $1551 = i64toi32_i32$2;
      i64toi32_i32$2 = $0 + 32 | 0;
      $35 = $1551;
      HEAP8[i64toi32_i32$2 >> 0] = $35;
      HEAP8[(i64toi32_i32$2 + 1 | 0) >> 0] = $35 >>> 8 | 0;
      HEAP8[(i64toi32_i32$2 + 2 | 0) >> 0] = $35 >>> 16 | 0;
      HEAP8[(i64toi32_i32$2 + 3 | 0) >> 0] = $35 >>> 24 | 0;
      HEAP8[(i64toi32_i32$2 + 4 | 0) >> 0] = i64toi32_i32$0;
      HEAP8[(i64toi32_i32$2 + 5 | 0) >> 0] = i64toi32_i32$0 >>> 8 | 0;
      HEAP8[(i64toi32_i32$2 + 6 | 0) >> 0] = i64toi32_i32$0 >>> 16 | 0;
      HEAP8[(i64toi32_i32$2 + 7 | 0) >> 0] = i64toi32_i32$0 >>> 24 | 0;
      i64toi32_i32$1 = $5 + 24 | 0;
      i64toi32_i32$0 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      i64toi32_i32$2 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      $1556 = i64toi32_i32$0;
      i64toi32_i32$0 = $0 + 24 | 0;
      $36 = $1556;
      HEAP8[i64toi32_i32$0 >> 0] = $36;
      HEAP8[(i64toi32_i32$0 + 1 | 0) >> 0] = $36 >>> 8 | 0;
      HEAP8[(i64toi32_i32$0 + 2 | 0) >> 0] = $36 >>> 16 | 0;
      HEAP8[(i64toi32_i32$0 + 3 | 0) >> 0] = $36 >>> 24 | 0;
      HEAP8[(i64toi32_i32$0 + 4 | 0) >> 0] = i64toi32_i32$2;
      HEAP8[(i64toi32_i32$0 + 5 | 0) >> 0] = i64toi32_i32$2 >>> 8 | 0;
      HEAP8[(i64toi32_i32$0 + 6 | 0) >> 0] = i64toi32_i32$2 >>> 16 | 0;
      HEAP8[(i64toi32_i32$0 + 7 | 0) >> 0] = i64toi32_i32$2 >>> 24 | 0;
      i64toi32_i32$1 = $5 + 16 | 0;
      i64toi32_i32$2 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      i64toi32_i32$0 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      $1561 = i64toi32_i32$2;
      i64toi32_i32$2 = $0 + 16 | 0;
      $37 = $1561;
      HEAP8[i64toi32_i32$2 >> 0] = $37;
      HEAP8[(i64toi32_i32$2 + 1 | 0) >> 0] = $37 >>> 8 | 0;
      HEAP8[(i64toi32_i32$2 + 2 | 0) >> 0] = $37 >>> 16 | 0;
      HEAP8[(i64toi32_i32$2 + 3 | 0) >> 0] = $37 >>> 24 | 0;
      HEAP8[(i64toi32_i32$2 + 4 | 0) >> 0] = i64toi32_i32$0;
      HEAP8[(i64toi32_i32$2 + 5 | 0) >> 0] = i64toi32_i32$0 >>> 8 | 0;
      HEAP8[(i64toi32_i32$2 + 6 | 0) >> 0] = i64toi32_i32$0 >>> 16 | 0;
      HEAP8[(i64toi32_i32$2 + 7 | 0) >> 0] = i64toi32_i32$0 >>> 24 | 0;
      i64toi32_i32$1 = $5 + 8 | 0;
      i64toi32_i32$0 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      i64toi32_i32$2 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
      $1566 = i64toi32_i32$0;
      i64toi32_i32$0 = $0 + 8 | 0;
      $38 = $1566;
      HEAP8[i64toi32_i32$0 >> 0] = $38;
      HEAP8[(i64toi32_i32$0 + 1 | 0) >> 0] = $38 >>> 8 | 0;
      HEAP8[(i64toi32_i32$0 + 2 | 0) >> 0] = $38 >>> 16 | 0;
      HEAP8[(i64toi32_i32$0 + 3 | 0) >> 0] = $38 >>> 24 | 0;
      HEAP8[(i64toi32_i32$0 + 4 | 0) >> 0] = i64toi32_i32$2;
      HEAP8[(i64toi32_i32$0 + 5 | 0) >> 0] = i64toi32_i32$2 >>> 8 | 0;
      HEAP8[(i64toi32_i32$0 + 6 | 0) >> 0] = i64toi32_i32$2 >>> 16 | 0;
      HEAP8[(i64toi32_i32$0 + 7 | 0) >> 0] = i64toi32_i32$2 >>> 24 | 0;
      FLAC__MD5Transform($3 | 0, $0 | 0);
      $5 = $5 + 64 | 0;
      $1 = $1 + -64 | 0;
      if ($1 >>> 0 > 63 >>> 0) {
       continue label$92
      }
      break label$92;
     };
    }
    __memcpy($0 | 0, $5 | 0, $1 | 0) | 0;
   }
   $5 = 1;
  }
  return $5 | 0;
 }
 
 function dummy($0) {
  $0 = $0 | 0;
  return $0 | 0;
 }
 
 function __stdio_close($0) {
  $0 = $0 | 0;
  return __wasi_fd_close(dummy(HEAP32[($0 + 60 | 0) >> 2] | 0 | 0) | 0 | 0) | 0 | 0;
 }
 
 function __wasi_syscall_ret($0) {
  $0 = $0 | 0;
  var wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  label$1 : {
   if ($0) {
    break label$1
   }
   return 0 | 0;
  }
  (wasm2js_i32$0 = __errno_location() | 0, wasm2js_i32$1 = $0), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
  return -1 | 0;
 }
 
 function __stdio_read($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  $3 = __stack_pointer - 32 | 0;
  __stack_pointer = $3;
  HEAP32[($3 + 16 | 0) >> 2] = $1;
  $4 = HEAP32[($0 + 48 | 0) >> 2] | 0;
  HEAP32[($3 + 20 | 0) >> 2] = $2 - (($4 | 0) != (0 | 0)) | 0;
  $5 = HEAP32[($0 + 44 | 0) >> 2] | 0;
  HEAP32[($3 + 28 | 0) >> 2] = $4;
  HEAP32[($3 + 24 | 0) >> 2] = $5;
  $4 = -1;
  label$1 : {
   label$2 : {
    label$3 : {
     if (__wasi_syscall_ret(__wasi_fd_read(HEAP32[($0 + 60 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, 2 | 0, $3 + 12 | 0 | 0) | 0 | 0) | 0) {
      break label$3
     }
     $4 = HEAP32[($3 + 12 | 0) >> 2] | 0;
     if (($4 | 0) > (0 | 0)) {
      break label$2
     }
    }
    HEAP32[$0 >> 2] = ($4 & 48 | 0) ^ 16 | 0 | (HEAP32[$0 >> 2] | 0) | 0;
    break label$1;
   }
   $6 = HEAP32[($3 + 20 | 0) >> 2] | 0;
   if ($4 >>> 0 <= $6 >>> 0) {
    break label$1
   }
   $5 = HEAP32[($0 + 44 | 0) >> 2] | 0;
   HEAP32[($0 + 4 | 0) >> 2] = $5;
   HEAP32[($0 + 8 | 0) >> 2] = $5 + ($4 - $6 | 0) | 0;
   label$4 : {
    if (!(HEAP32[($0 + 48 | 0) >> 2] | 0)) {
     break label$4
    }
    HEAP32[($0 + 4 | 0) >> 2] = $5 + 1 | 0;
    HEAP8[(($2 + $1 | 0) + -1 | 0) >> 0] = HEAPU8[$5 >> 0] | 0;
   }
   $4 = $2;
  }
  __stack_pointer = $3 + 32 | 0;
  return $4 | 0;
 }
 
 function __stdio_seek($0, $1, $1$hi, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  $2 = $2 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, $3 = 0, i64toi32_i32$1 = 0, i64toi32_i32$3 = 0;
  $3 = __stack_pointer - 16 | 0;
  __stack_pointer = $3;
  i64toi32_i32$0 = $1$hi;
  $0 = __wasi_syscall_ret(legalfunc$__wasi_fd_seek(HEAP32[($0 + 60 | 0) >> 2] | 0 | 0, $1 | 0, i64toi32_i32$0 | 0, $2 & 255 | 0 | 0, $3 + 8 | 0 | 0) | 0 | 0) | 0;
  i64toi32_i32$2 = $3;
  i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 8 | 0) >> 2] | 0;
  i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 12 | 0) >> 2] | 0;
  $1 = i64toi32_i32$0;
  $1$hi = i64toi32_i32$1;
  __stack_pointer = i64toi32_i32$2 + 16 | 0;
  i64toi32_i32$1 = -1;
  i64toi32_i32$0 = $1$hi;
  i64toi32_i32$3 = $0 ? -1 : $1;
  i64toi32_i32$2 = $0 ? i64toi32_i32$1 : i64toi32_i32$0;
  i64toi32_i32$HIGH_BITS = i64toi32_i32$2;
  return i64toi32_i32$3 | 0;
 }
 
 function fflush($0) {
  $0 = $0 | 0;
  var $2 = 0, $1 = 0;
  label$1 : {
   label$2 : {
    if (!$0) {
     break label$2
    }
    label$3 : {
     if ((HEAP32[($0 + 76 | 0) >> 2] | 0 | 0) > (-1 | 0)) {
      break label$3
     }
     return __fflush_unlocked($0 | 0) | 0 | 0;
    }
    $1 = __lockfile($0 | 0) | 0;
    $2 = __fflush_unlocked($0 | 0) | 0;
    if (!$1) {
     break label$1
    }
    __unlockfile($0 | 0);
    return $2 | 0;
   }
   $2 = 0;
   label$4 : {
    if (!(HEAP32[(0 + 11152 | 0) >> 2] | 0)) {
     break label$4
    }
    $2 = fflush(HEAP32[(0 + 11152 | 0) >> 2] | 0 | 0) | 0;
   }
   label$5 : {
    $0 = HEAP32[(__ofl_lock() | 0) >> 2] | 0;
    if (!$0) {
     break label$5
    }
    label$6 : while (1) {
     $1 = 0;
     label$7 : {
      if ((HEAP32[($0 + 76 | 0) >> 2] | 0 | 0) < (0 | 0)) {
       break label$7
      }
      $1 = __lockfile($0 | 0) | 0;
     }
     label$8 : {
      if ((HEAP32[($0 + 20 | 0) >> 2] | 0) >>> 0 <= (HEAP32[($0 + 28 | 0) >> 2] | 0) >>> 0) {
       break label$8
      }
      $2 = __fflush_unlocked($0 | 0) | 0 | $2 | 0;
     }
     label$9 : {
      if (!$1) {
       break label$9
      }
      __unlockfile($0 | 0);
     }
     $0 = HEAP32[($0 + 56 | 0) >> 2] | 0;
     if ($0) {
      continue label$6
     }
     break label$6;
    };
   }
   __ofl_unlock();
  }
  return $2 | 0;
 }
 
 function __fflush_unlocked($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, $1 = 0, $2 = 0;
  label$1 : {
   if ((HEAP32[($0 + 20 | 0) >> 2] | 0) >>> 0 <= (HEAP32[($0 + 28 | 0) >> 2] | 0) >>> 0) {
    break label$1
   }
   FUNCTION_TABLE[HEAP32[($0 + 36 | 0) >> 2] | 0 | 0]($0, 0, 0) | 0;
   if (HEAP32[($0 + 20 | 0) >> 2] | 0) {
    break label$1
   }
   return -1 | 0;
  }
  label$2 : {
   $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
   if ($1 >>> 0 >= $2 >>> 0) {
    break label$2
   }
   i64toi32_i32$1 = $1 - $2 | 0;
   i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
   i64toi32_i32$0 = FUNCTION_TABLE[HEAP32[($0 + 40 | 0) >> 2] | 0 | 0]($0, i64toi32_i32$1, i64toi32_i32$0, 1) | 0;
   i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
  }
  HEAP32[($0 + 28 | 0) >> 2] = 0;
  i64toi32_i32$0 = $0;
  i64toi32_i32$1 = 0;
  HEAP32[($0 + 16 | 0) >> 2] = 0;
  HEAP32[($0 + 20 | 0) >> 2] = i64toi32_i32$1;
  i64toi32_i32$0 = $0;
  i64toi32_i32$1 = 0;
  HEAP32[($0 + 4 | 0) >> 2] = 0;
  HEAP32[($0 + 8 | 0) >> 2] = i64toi32_i32$1;
  return 0 | 0;
 }
 
 function dummy_1($0) {
  $0 = $0 | 0;
 }
 
 function fclose($0) {
  $0 = $0 | 0;
  var $5 = 0, $4 = 0, $3 = 0, $1 = 0, $2 = 0;
  $1 = 0;
  label$1 : {
   if ((HEAP32[($0 + 76 | 0) >> 2] | 0 | 0) < (0 | 0)) {
    break label$1
   }
   $1 = __lockfile($0 | 0) | 0;
  }
  dummy_1($0 | 0);
  label$2 : {
   $2 = (HEAP32[$0 >> 2] | 0) & 1 | 0;
   if ($2) {
    break label$2
   }
   $3 = __ofl_lock() | 0;
   label$3 : {
    $4 = HEAP32[($0 + 52 | 0) >> 2] | 0;
    if (!$4) {
     break label$3
    }
    HEAP32[($4 + 56 | 0) >> 2] = HEAP32[($0 + 56 | 0) >> 2] | 0;
   }
   label$4 : {
    $5 = HEAP32[($0 + 56 | 0) >> 2] | 0;
    if (!$5) {
     break label$4
    }
    HEAP32[($5 + 52 | 0) >> 2] = $4;
   }
   label$5 : {
    if ((HEAP32[$3 >> 2] | 0 | 0) != ($0 | 0)) {
     break label$5
    }
    HEAP32[$3 >> 2] = $5;
   }
   __ofl_unlock();
  }
  $3 = fflush($0 | 0) | 0;
  $4 = FUNCTION_TABLE[HEAP32[($0 + 12 | 0) >> 2] | 0 | 0]($0) | 0;
  label$6 : {
   $5 = HEAP32[($0 + 96 | 0) >> 2] | 0;
   if (!$5) {
    break label$6
   }
   dlfree($5 | 0);
  }
  label$7 : {
   label$8 : {
    if ($2) {
     break label$8
    }
    dlfree($0 | 0);
    break label$7;
   }
   if (!$1) {
    break label$7
   }
   __unlockfile($0 | 0);
  }
  return $4 | $3 | 0 | 0;
 }
 
 function memcmp($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     if ($2 >>> 0 < 4 >>> 0) {
      break label$3
     }
     if (($1 | $0 | 0) & 3 | 0) {
      break label$2
     }
     label$4 : while (1) {
      if ((HEAP32[$0 >> 2] | 0 | 0) != (HEAP32[$1 >> 2] | 0 | 0)) {
       break label$2
      }
      $1 = $1 + 4 | 0;
      $0 = $0 + 4 | 0;
      $2 = $2 + -4 | 0;
      if ($2 >>> 0 > 3 >>> 0) {
       continue label$4
      }
      break label$4;
     };
    }
    if (!$2) {
     break label$1
    }
   }
   label$5 : {
    label$6 : while (1) {
     $3 = HEAPU8[$0 >> 0] | 0;
     $4 = HEAPU8[$1 >> 0] | 0;
     if (($3 | 0) != ($4 | 0)) {
      break label$5
     }
     $1 = $1 + 1 | 0;
     $0 = $0 + 1 | 0;
     $2 = $2 + -1 | 0;
     if (!$2) {
      break label$1
     }
     continue label$6;
    };
   }
   return $3 - $4 | 0 | 0;
  }
  return 0 | 0;
 }
 
 function FLAC__cpu_info($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0;
  i64toi32_i32$1 = $0;
  i64toi32_i32$0 = 0;
  HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$0 = 3;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = i64toi32_i32$1 + 56 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = $0 + 48 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = $0 + 40 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = $0 + 32 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = $0 + 24 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = $0 + 16 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
 }
 
 function round($0) {
  $0 = +$0;
  var i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, i64toi32_i32$2 = 0, i64toi32_i32$3 = 0, i64toi32_i32$4 = 0, $3 = 0.0, $1 = 0, $1$hi = 0, $14 = 0, $2 = 0, $15 = 0, $17 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $16 = 0.0, $18 = 0.0, $42 = 0.0, $44 = 0.0;
  label$1 : {
   wasm2js_scratch_store_f64(+$0);
   i64toi32_i32$0 = wasm2js_scratch_load_i32(1 | 0) | 0;
   $1 = wasm2js_scratch_load_i32(0 | 0) | 0;
   $1$hi = i64toi32_i32$0;
   i64toi32_i32$2 = $1;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 52;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$1 = 0;
    $14 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
    $14 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
   }
   $2 = $14 & 2047 | 0;
   if ($2 >>> 0 > 1074 >>> 0) {
    break label$1
   }
   label$2 : {
    if ($2 >>> 0 > 1021 >>> 0) {
     break label$2
    }
    return +($0 * 0.0);
   }
   label$3 : {
    label$4 : {
     $16 = $0;
     $18 = -$0;
     i64toi32_i32$1 = $1$hi;
     i64toi32_i32$0 = $1;
     i64toi32_i32$2 = -1;
     i64toi32_i32$3 = -1;
     if ((i64toi32_i32$1 | 0) > (i64toi32_i32$2 | 0)) {
      $15 = 1
     } else {
      if ((i64toi32_i32$1 | 0) >= (i64toi32_i32$2 | 0)) {
       if (i64toi32_i32$0 >>> 0 <= i64toi32_i32$3 >>> 0) {
        $17 = 0
       } else {
        $17 = 1
       }
       $19 = $17;
      } else {
       $19 = 0
      }
      $15 = $19;
     }
     $0 = $15 ? $16 : $18;
     $3 = $0 + 4503599627370496.0 + -4503599627370496.0 - $0;
     if (!($3 > .5)) {
      break label$4
     }
     $0 = $0 + $3 + -1.0;
     break label$3;
    }
    $0 = $0 + $3;
    if (!($3 <= -.5)) {
     break label$3
    }
    $0 = $0 + 1.0;
   }
   $42 = $0;
   $44 = -$0;
   i64toi32_i32$0 = $1$hi;
   i64toi32_i32$3 = $1;
   i64toi32_i32$1 = -1;
   i64toi32_i32$2 = -1;
   if ((i64toi32_i32$0 | 0) > (i64toi32_i32$1 | 0)) {
    $20 = 1
   } else {
    if ((i64toi32_i32$0 | 0) >= (i64toi32_i32$1 | 0)) {
     if (i64toi32_i32$3 >>> 0 <= i64toi32_i32$2 >>> 0) {
      $21 = 0
     } else {
      $21 = 1
     }
     $22 = $21;
    } else {
     $22 = 0
    }
    $20 = $22;
   }
   $0 = $20 ? $42 : $44;
  }
  return +$0;
 }
 
 function lround($0) {
  $0 = +$0;
  label$1 : {
   $0 = +round(+$0);
   if (!(Math_abs($0) < 2147483648.0)) {
    break label$1
   }
   return ~~$0 | 0;
  }
  return -2147483648 | 0;
 }
 
 function log($0) {
  $0 = +$0;
  var i64toi32_i32$2 = 0, i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, i64toi32_i32$3 = 0, i64toi32_i32$4 = 0, $5 = 0.0, $1 = 0, $2 = 0, $1$hi = 0, $3 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $4 = 0, $27 = 0, $28 = 0, $6 = 0.0, $50 = 0.0, $55$hi = 0, $57 = 0, $57$hi = 0, $61 = 0.0, $63 = 0.0, $68 = 0.0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       wasm2js_scratch_store_f64(+$0);
       i64toi32_i32$0 = wasm2js_scratch_load_i32(1 | 0) | 0;
       $1 = wasm2js_scratch_load_i32(0 | 0) | 0;
       $1$hi = i64toi32_i32$0;
       i64toi32_i32$2 = $1;
       i64toi32_i32$1 = 0;
       i64toi32_i32$3 = 32;
       i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$1 = 0;
        $20 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
       } else {
        i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
        $20 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
       }
       $2 = $20;
       if ($2 >>> 0 < 1048576 >>> 0) {
        break label$5
       }
       i64toi32_i32$1 = $1$hi;
       i64toi32_i32$0 = $1;
       i64toi32_i32$2 = -1;
       i64toi32_i32$3 = -1;
       if ((i64toi32_i32$1 | 0) > (i64toi32_i32$2 | 0)) {
        $21 = 1
       } else {
        if ((i64toi32_i32$1 | 0) >= (i64toi32_i32$2 | 0)) {
         if (i64toi32_i32$0 >>> 0 <= i64toi32_i32$3 >>> 0) {
          $22 = 0
         } else {
          $22 = 1
         }
         $23 = $22;
        } else {
         $23 = 0
        }
        $21 = $23;
       }
       if ($21) {
        break label$4
       }
      }
      label$6 : {
       i64toi32_i32$0 = $1$hi;
       i64toi32_i32$3 = $1;
       i64toi32_i32$1 = 2147483647;
       i64toi32_i32$2 = -1;
       i64toi32_i32$1 = i64toi32_i32$0 & i64toi32_i32$1 | 0;
       i64toi32_i32$0 = i64toi32_i32$3 & i64toi32_i32$2 | 0;
       i64toi32_i32$3 = 0;
       i64toi32_i32$2 = 0;
       if ((i64toi32_i32$0 | 0) != (i64toi32_i32$2 | 0) | (i64toi32_i32$1 | 0) != (i64toi32_i32$3 | 0) | 0) {
        break label$6
       }
       return +(-1.0 / ($0 * $0));
      }
      i64toi32_i32$0 = $1$hi;
      i64toi32_i32$2 = $1;
      i64toi32_i32$1 = -1;
      i64toi32_i32$3 = -1;
      if ((i64toi32_i32$0 | 0) > (i64toi32_i32$1 | 0)) {
       $24 = 1
      } else {
       if ((i64toi32_i32$0 | 0) >= (i64toi32_i32$1 | 0)) {
        if (i64toi32_i32$2 >>> 0 <= i64toi32_i32$3 >>> 0) {
         $25 = 0
        } else {
         $25 = 1
        }
        $26 = $25;
       } else {
        $26 = 0
       }
       $24 = $26;
      }
      if ($24) {
       break label$3
      }
      return +(($0 - $0) / 0.0);
     }
     if ($2 >>> 0 > 2146435071 >>> 0) {
      break label$1
     }
     $3 = 1072693248;
     $4 = -1023;
     label$7 : {
      if (($2 | 0) == (1072693248 | 0)) {
       break label$7
      }
      $3 = $2;
      break label$2;
     }
     i64toi32_i32$2 = $1$hi;
     if ($1) {
      break label$2
     }
     return +(0.0);
    }
    wasm2js_scratch_store_f64(+($0 * 18014398509481984.0));
    i64toi32_i32$2 = wasm2js_scratch_load_i32(1 | 0) | 0;
    $1 = wasm2js_scratch_load_i32(0 | 0) | 0;
    $1$hi = i64toi32_i32$2;
    i64toi32_i32$3 = $1;
    i64toi32_i32$0 = 0;
    i64toi32_i32$1 = 32;
    i64toi32_i32$4 = i64toi32_i32$1 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$1 & 63 | 0) >>> 0) {
     i64toi32_i32$0 = 0;
     $27 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
    } else {
     i64toi32_i32$0 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
     $27 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$3 >>> i64toi32_i32$4 | 0) | 0;
    }
    $3 = $27;
    $4 = -1077;
   }
   $2 = $3 + 614242 | 0;
   $5 = +($4 + ($2 >>> 20 | 0) | 0 | 0);
   $50 = $5 * .6931471803691238;
   i64toi32_i32$0 = 0;
   i64toi32_i32$2 = ($2 & 1048575 | 0) + 1072079006 | 0;
   i64toi32_i32$3 = 0;
   i64toi32_i32$1 = 32;
   i64toi32_i32$4 = i64toi32_i32$1 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$1 & 63 | 0) >>> 0) {
    i64toi32_i32$3 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
    $28 = 0;
   } else {
    i64toi32_i32$3 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$2 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$0 << i64toi32_i32$4 | 0) | 0;
    $28 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
   }
   $55$hi = i64toi32_i32$3;
   i64toi32_i32$3 = $1$hi;
   i64toi32_i32$0 = $1;
   i64toi32_i32$2 = 0;
   i64toi32_i32$1 = -1;
   i64toi32_i32$2 = i64toi32_i32$3 & i64toi32_i32$2 | 0;
   $57 = i64toi32_i32$0 & i64toi32_i32$1 | 0;
   $57$hi = i64toi32_i32$2;
   i64toi32_i32$2 = $55$hi;
   i64toi32_i32$3 = $28;
   i64toi32_i32$0 = $57$hi;
   i64toi32_i32$1 = $57;
   i64toi32_i32$0 = i64toi32_i32$2 | i64toi32_i32$0 | 0;
   wasm2js_scratch_store_i32(0 | 0, i64toi32_i32$3 | i64toi32_i32$1 | 0 | 0);
   wasm2js_scratch_store_i32(1 | 0, i64toi32_i32$0 | 0);
   $0 = +wasm2js_scratch_load_f64() + -1.0;
   $61 = $0;
   $63 = $5 * 1.9082149292705877e-10;
   $5 = $0 / ($0 + 2.0);
   $68 = $5;
   $6 = $0 * ($0 * .5);
   $5 = $5 * $5;
   $0 = $5 * $5;
   $0 = $50 + ($61 + ($63 + $68 * ($6 + ($0 * ($0 * ($0 * .15313837699209373 + .22222198432149784) + .3999999999940942) + $5 * ($0 * ($0 * ($0 * .14798198605116586 + .1818357216161805) + .2857142874366239) + .6666666666666735))) - $6));
  }
  return +$0;
 }
 
 function FLAC__lpc_window_data($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $5 = 0, $6 = 0, $4 = 0;
  label$1 : {
   if (!$3) {
    break label$1
   }
   $4 = $3 & 1 | 0;
   $5 = 0;
   label$2 : {
    if (($3 | 0) == (1 | 0)) {
     break label$2
    }
    $6 = $3 & -2 | 0;
    $5 = 0;
    label$3 : while (1) {
     $3 = $5 << 2 | 0;
     HEAPF32[($2 + $3 | 0) >> 2] = Math_fround(Math_fround(HEAPF32[($1 + $3 | 0) >> 2]) * Math_fround(HEAP32[($0 + $3 | 0) >> 2] | 0 | 0));
     $3 = $3 | 4 | 0;
     HEAPF32[($2 + $3 | 0) >> 2] = Math_fround(Math_fround(HEAPF32[($1 + $3 | 0) >> 2]) * Math_fround(HEAP32[($0 + $3 | 0) >> 2] | 0 | 0));
     $5 = $5 + 2 | 0;
     $6 = $6 + -2 | 0;
     if ($6) {
      continue label$3
     }
     break label$3;
    };
   }
   if (!$4) {
    break label$1
   }
   $3 = $5 << 2 | 0;
   HEAPF32[($2 + $3 | 0) >> 2] = Math_fround(Math_fround(HEAPF32[($1 + $3 | 0) >> 2]) * Math_fround(HEAP32[($0 + $3 | 0) >> 2] | 0 | 0));
  }
 }
 
 function FLAC__lpc_compute_autocorrelation($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $10 = 0, $5 = 0, $11 = 0, $6 = 0, $12 = 0, $4 = 0, $9 = Math_fround(0), $13 = 0, $7 = 0, $8 = 0;
  $4 = $1 - $2 | 0;
  label$1 : {
   label$2 : {
    if ($2) {
     break label$2
    }
    $5 = 0;
    label$3 : while (1) {
     $5 = $5 + 1 | 0;
     if ($5 >>> 0 <= $4 >>> 0) {
      continue label$3
     }
     break label$1;
    };
   }
   $5 = 0;
   $6 = memset($3 | 0, 0 | 0, $2 << 2 | 0 | 0) | 0;
   $7 = $2 & -2 | 0;
   $8 = $2 & 1 | 0;
   label$4 : while (1) {
    $9 = Math_fround(HEAPF32[($0 + ($5 << 2 | 0) | 0) >> 2]);
    $10 = 0;
    $11 = $7;
    label$5 : {
     if (($2 | 0) == (1 | 0)) {
      break label$5
     }
     label$6 : while (1) {
      $12 = $6 + ($10 << 2 | 0) | 0;
      HEAPF32[$12 >> 2] = Math_fround(Math_fround(HEAPF32[$12 >> 2]) + Math_fround($9 * Math_fround(HEAPF32[($0 + (($10 + $5 | 0) << 2 | 0) | 0) >> 2])));
      $12 = $10 | 1 | 0;
      $13 = $6 + ($12 << 2 | 0) | 0;
      HEAPF32[$13 >> 2] = Math_fround(Math_fround(HEAPF32[$13 >> 2]) + Math_fround($9 * Math_fround(HEAPF32[($0 + (($12 + $5 | 0) << 2 | 0) | 0) >> 2])));
      $10 = $10 + 2 | 0;
      $11 = $11 + -2 | 0;
      if ($11) {
       continue label$6
      }
      break label$6;
     };
    }
    label$7 : {
     if (!$8) {
      break label$7
     }
     $11 = $6 + ($10 << 2 | 0) | 0;
     HEAPF32[$11 >> 2] = Math_fround(Math_fround(HEAPF32[$11 >> 2]) + Math_fround($9 * Math_fround(HEAPF32[($0 + (($10 + $5 | 0) << 2 | 0) | 0) >> 2])));
    }
    $5 = $5 + 1 | 0;
    if ($5 >>> 0 <= $4 >>> 0) {
     continue label$4
    }
    break label$4;
   };
  }
  label$8 : {
   if ($5 >>> 0 >= $1 >>> 0) {
    break label$8
   }
   $7 = ($5 ^ -1 | 0) + $1 | 0;
   $4 = 0;
   $11 = $5;
   label$9 : while (1) {
    label$10 : {
     if (($11 | 0) == ($1 | 0)) {
      break label$10
     }
     $9 = Math_fround(HEAPF32[($0 + ($11 << 2 | 0) | 0) >> 2]);
     $6 = $1 - ($5 + $4 | 0) | 0;
     $2 = $6 & 1 | 0;
     $10 = 0;
     label$11 : {
      if (($7 | 0) == ($4 | 0)) {
       break label$11
      }
      $6 = $6 & -2 | 0;
      $10 = 0;
      label$12 : while (1) {
       $12 = $3 + ($10 << 2 | 0) | 0;
       HEAPF32[$12 >> 2] = Math_fround(Math_fround(HEAPF32[$12 >> 2]) + Math_fround($9 * Math_fround(HEAPF32[($0 + (($10 + $11 | 0) << 2 | 0) | 0) >> 2])));
       $12 = $10 | 1 | 0;
       $13 = $3 + ($12 << 2 | 0) | 0;
       HEAPF32[$13 >> 2] = Math_fround(Math_fround(HEAPF32[$13 >> 2]) + Math_fround($9 * Math_fround(HEAPF32[($0 + (($12 + $11 | 0) << 2 | 0) | 0) >> 2])));
       $10 = $10 + 2 | 0;
       $6 = $6 + -2 | 0;
       if ($6) {
        continue label$12
       }
       break label$12;
      };
     }
     if (!$2) {
      break label$10
     }
     $6 = $3 + ($10 << 2 | 0) | 0;
     HEAPF32[$6 >> 2] = Math_fround(Math_fround(HEAPF32[$6 >> 2]) + Math_fround($9 * Math_fround(HEAPF32[($0 + (($10 + $11 | 0) << 2 | 0) | 0) >> 2])));
    }
    $4 = $4 + 1 | 0;
    $11 = $11 + 1 | 0;
    if (($11 | 0) != ($1 | 0)) {
     continue label$9
    }
    break label$9;
   };
  }
 }
 
 function FLAC__lpc_compute_lp_coefficients($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $11 = 0, $7 = 0, $9 = 0.0, $12 = 0, $4 = 0, $17 = 0.0, $6 = 0.0, $13 = 0, $14 = 0, $8 = 0, $10 = 0, $16 = 0, $5 = 0, $15 = 0, $129 = 0, $156 = 0;
  $4 = __stack_pointer - 256 | 0;
  __stack_pointer = $4;
  $5 = HEAP32[$1 >> 2] | 0;
  $6 = +Math_fround(HEAPF32[$0 >> 2]);
  $7 = 0;
  label$1 : {
   label$2 : while (1) {
    if (($7 | 0) == ($5 | 0)) {
     break label$1
    }
    $8 = $7 + 1 | 0;
    $9 = +Math_fround(-Math_fround(HEAPF32[($0 + ($8 << 2 | 0) | 0) >> 2]));
    label$3 : {
     label$4 : {
      if (!$7) {
       break label$4
      }
      $10 = $7 & 1 | 0;
      $11 = 0;
      label$5 : {
       if (($7 | 0) == (1 | 0)) {
        break label$5
       }
       $12 = $7 & -2 | 0;
       $11 = 0;
       label$6 : while (1) {
        $13 = $11 | 1 | 0;
        $9 = $9 - +HEAPF64[($4 + ($11 << 3 | 0) | 0) >> 3] * +Math_fround(HEAPF32[($0 + (($7 - $11 | 0) << 2 | 0) | 0) >> 2]) - +HEAPF64[($4 + ($13 << 3 | 0) | 0) >> 3] * +Math_fround(HEAPF32[($0 + (($7 - $13 | 0) << 2 | 0) | 0) >> 2]);
        $11 = $11 + 2 | 0;
        $12 = $12 + -2 | 0;
        if ($12) {
         continue label$6
        }
        break label$6;
       };
      }
      label$7 : {
       if (!$10) {
        break label$7
       }
       $9 = $9 - +HEAPF64[($4 + ($11 << 3 | 0) | 0) >> 3] * +Math_fround(HEAPF32[($0 + (($7 - $11 | 0) << 2 | 0) | 0) >> 2]);
      }
      $9 = $9 / $6;
      HEAPF64[($4 + ($7 << 3 | 0) | 0) >> 3] = $9;
      $14 = 0;
      label$8 : {
       if ($7 >>> 0 < 2 >>> 0) {
        break label$8
       }
       $11 = $7 >>> 1 | 0;
       $14 = $11 >>> 0 > 1 >>> 0 ? $11 : 1;
       $15 = $14 & 1 | 0;
       $11 = 0;
       label$9 : {
        if ($7 >>> 0 < 4 >>> 0) {
         break label$9
        }
        $13 = $14 & 2147483646 | 0;
        $11 = 0;
        label$10 : while (1) {
         $16 = $11 << 3 | 0;
         $12 = $4 + $16 | 0;
         $129 = $12;
         $17 = +HEAPF64[$12 >> 3];
         $12 = $4 + (($7 + ($11 ^ -1 | 0) | 0) << 3 | 0) | 0;
         HEAPF64[$129 >> 3] = $17 + $9 * +HEAPF64[$12 >> 3];
         HEAPF64[$12 >> 3] = $9 * $17 + +HEAPF64[$12 >> 3];
         $12 = $4 + ($16 | 8 | 0) | 0;
         $156 = $12;
         $17 = +HEAPF64[$12 >> 3];
         $12 = ((($7 - $11 | 0) << 3 | 0) + $4 | 0) + -16 | 0;
         HEAPF64[$156 >> 3] = $17 + $9 * +HEAPF64[$12 >> 3];
         HEAPF64[$12 >> 3] = $9 * $17 + +HEAPF64[$12 >> 3];
         $11 = $11 + 2 | 0;
         $13 = $13 + -2 | 0;
         if ($13) {
          continue label$10
         }
         break label$10;
        };
       }
       if (!$15) {
        break label$8
       }
       $12 = $4 + ($11 << 3 | 0) | 0;
       $17 = +HEAPF64[$12 >> 3];
       $11 = $4 + (($7 + ($11 ^ -1 | 0) | 0) << 3 | 0) | 0;
       HEAPF64[$12 >> 3] = $17 + $9 * +HEAPF64[$11 >> 3];
       HEAPF64[$11 >> 3] = $9 * $17 + +HEAPF64[$11 >> 3];
      }
      if (!$10) {
       break label$3
      }
      $11 = $4 + ($14 << 3 | 0) | 0;
      $17 = +HEAPF64[$11 >> 3];
      HEAPF64[$11 >> 3] = $17 + $9 * $17;
      break label$3;
     }
     $9 = $9 / $6;
     HEAPF64[($4 + ($7 << 3 | 0) | 0) >> 3] = $9;
    }
    $9 = 1.0 - $9 * $9;
    $11 = 0;
    label$11 : while (1) {
     HEAPF32[(($2 + ($7 << 7 | 0) | 0) + ($11 << 2 | 0) | 0) >> 2] = Math_fround(-Math_fround(+HEAPF64[($4 + ($11 << 3 | 0) | 0) >> 3]));
     $11 = $11 + 1 | 0;
     if ($11 >>> 0 <= $7 >>> 0) {
      continue label$11
     }
     break label$11;
    };
    $6 = $6 * $9;
    HEAPF64[($3 + ($7 << 3 | 0) | 0) >> 3] = $6;
    $7 = $8;
    if ($6 != 0.0) {
     continue label$2
    }
    break label$2;
   };
   HEAP32[$1 >> 2] = $8;
  }
  __stack_pointer = $4 + 256 | 0;
 }
 
 function FLAC__lpc_quantize_coefficients($0, $1, $2, $3, $4) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  var $7 = 0, $8 = 0.0, $11 = 0, $9 = 0, $10 = 0, $12 = 0.0, $5 = 0, $6 = 0, $13 = 0.0, $14 = 0.0, $15 = 0.0, $16 = 0, $151 = 0, $17 = Math_fround(0), $198 = 0;
  $5 = __stack_pointer - 16 | 0;
  __stack_pointer = $5;
  $6 = 2;
  label$1 : {
   if (!$1) {
    break label$1
   }
   $7 = $1 & 3 | 0;
   label$2 : {
    label$3 : {
     if (($1 + -1 | 0) >>> 0 >= 3 >>> 0) {
      break label$3
     }
     $8 = 0.0;
     $9 = 0;
     break label$2;
    }
    $10 = $1 & -4 | 0;
    $8 = 0.0;
    $9 = 0;
    label$4 : while (1) {
     $11 = $9 << 2 | 0;
     $12 = +Math_fround(Math_abs(Math_fround(HEAPF32[($0 + ($11 | 12 | 0) | 0) >> 2])));
     $13 = +Math_fround(Math_abs(Math_fround(HEAPF32[($0 + ($11 | 8 | 0) | 0) >> 2])));
     $14 = +Math_fround(Math_abs(Math_fround(HEAPF32[($0 + ($11 | 4 | 0) | 0) >> 2])));
     $15 = +Math_fround(Math_abs(Math_fround(HEAPF32[($0 + $11 | 0) >> 2])));
     $8 = $8 < $15 ? $15 : $8;
     $8 = $8 < $14 ? $14 : $8;
     $8 = $8 < $13 ? $13 : $8;
     $8 = $8 < $12 ? $12 : $8;
     $9 = $9 + 4 | 0;
     $10 = $10 + -4 | 0;
     if ($10) {
      continue label$4
     }
     break label$4;
    };
   }
   label$5 : {
    if (!$7) {
     break label$5
    }
    label$6 : while (1) {
     $12 = +Math_fround(Math_abs(Math_fround(HEAPF32[($0 + ($9 << 2 | 0) | 0) >> 2])));
     $8 = $8 < $12 ? $12 : $8;
     $9 = $9 + 1 | 0;
     $7 = $7 + -1 | 0;
     if ($7) {
      continue label$6
     }
     break label$6;
    };
   }
   if ($8 <= 0.0) {
    break label$1
   }
   +frexp(+$8, $5 + 12 | 0 | 0);
   $11 = $2 + -1 | 0;
   $7 = $11 - (HEAP32[($5 + 12 | 0) >> 2] | 0) | 0;
   HEAP32[$4 >> 2] = $7;
   label$7 : {
    label$8 : {
     $10 = -1 << ((HEAP32[GOT_data_internal_FLAC__SUBFRAME_LPC_QLP_SHIFT_LEN >> 2] | 0) + -1 | 0) | 0;
     $9 = $10 ^ -1 | 0;
     if (($7 | 0) <= ($9 | 0)) {
      break label$8
     }
     HEAP32[$4 >> 2] = $9;
     $7 = $9;
     break label$7;
    }
    if (($7 | 0) >= ($10 | 0)) {
     break label$7
    }
    $6 = 1;
    break label$1;
   }
   $2 = 1 << $11 | 0;
   $16 = $2 + -1 | 0;
   $9 = 0 - $2 | 0;
   $11 = 0;
   label$9 : {
    if (($7 | 0) < (0 | 0)) {
     break label$9
    }
    $6 = 0;
    if (!$1) {
     break label$1
    }
    $8 = 0.0;
    $11 = 0;
    label$10 : while (1) {
     $10 = $11 << 2 | 0;
     $151 = $3 + $10 | 0;
     $8 = $8 + +Math_fround(Math_fround(HEAPF32[($0 + $10 | 0) >> 2]) * Math_fround(1 << $7 | 0 | 0));
     $7 = lround(+$8) | 0;
     $7 = ($7 | 0) < ($2 | 0) ? (($7 | 0) < ($9 | 0) ? $9 : $7) : $16;
     HEAP32[$151 >> 2] = $7;
     $11 = $11 + 1 | 0;
     if (($11 | 0) == ($1 | 0)) {
      break label$1
     }
     $8 = $8 - +($7 | 0);
     $7 = HEAP32[$4 >> 2] | 0;
     continue label$10;
    };
   }
   label$11 : {
    if (!$1) {
     break label$11
    }
    $17 = Math_fround(1 << (0 - $7 | 0) | 0 | 0);
    $8 = 0.0;
    label$12 : while (1) {
     $7 = $11 << 2 | 0;
     $198 = $3 + $7 | 0;
     $8 = $8 + +Math_fround(Math_fround(HEAPF32[($0 + $7 | 0) >> 2]) / $17);
     $7 = lround(+$8) | 0;
     $7 = ($7 | 0) < ($2 | 0) ? (($7 | 0) < ($9 | 0) ? $9 : $7) : $16;
     HEAP32[$198 >> 2] = $7;
     $8 = $8 - +($7 | 0);
     $11 = $11 + 1 | 0;
     if (($11 | 0) != ($1 | 0)) {
      continue label$12
     }
     break label$12;
    };
   }
   $6 = 0;
   HEAP32[$4 >> 2] = 0;
  }
  __stack_pointer = $5 + 16 | 0;
  return $6 | 0;
 }
 
 function FLAC__lpc_compute_residual_from_qlp_coefficients($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $6 = 0, $9 = 0, $7 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $27 = 0, $8 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $113 = 0, $28 = 0, $29 = 0, $248 = 0, $371 = 0, $486 = 0, $593 = 0, $688 = 0, $771 = 0, $846 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     if ($3 >>> 0 < 13 >>> 0) {
      break label$3
     }
     $6 = 0;
     if (($1 | 0) <= (0 | 0)) {
      break label$1
     }
     $7 = $3 + -13 | 0;
     break label$2;
    }
    label$4 : {
     if ($3 >>> 0 < 9 >>> 0) {
      break label$4
     }
     label$5 : {
      if ($3 >>> 0 < 11 >>> 0) {
       break label$5
      }
      label$6 : {
       if (($3 | 0) == (12 | 0)) {
        break label$6
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $8 = HEAP32[($0 + -4 | 0) >> 2] | 0;
       $3 = HEAP32[($0 + -8 | 0) >> 2] | 0;
       $6 = HEAP32[($0 + -12 | 0) >> 2] | 0;
       $9 = HEAP32[($0 + -16 | 0) >> 2] | 0;
       $7 = HEAP32[($0 + -20 | 0) >> 2] | 0;
       $10 = HEAP32[($0 + -24 | 0) >> 2] | 0;
       $11 = HEAP32[($0 + -28 | 0) >> 2] | 0;
       $12 = HEAP32[($0 + -32 | 0) >> 2] | 0;
       $13 = HEAP32[($0 + -36 | 0) >> 2] | 0;
       $14 = HEAP32[($0 + -40 | 0) >> 2] | 0;
       $15 = HEAP32[($0 + -44 | 0) >> 2] | 0;
       $16 = HEAP32[$2 >> 2] | 0;
       $17 = HEAP32[($2 + 4 | 0) >> 2] | 0;
       $18 = HEAP32[($2 + 8 | 0) >> 2] | 0;
       $19 = HEAP32[($2 + 12 | 0) >> 2] | 0;
       $20 = HEAP32[($2 + 16 | 0) >> 2] | 0;
       $21 = HEAP32[($2 + 20 | 0) >> 2] | 0;
       $22 = HEAP32[($2 + 24 | 0) >> 2] | 0;
       $23 = HEAP32[($2 + 28 | 0) >> 2] | 0;
       $24 = HEAP32[($2 + 32 | 0) >> 2] | 0;
       $25 = HEAP32[($2 + 36 | 0) >> 2] | 0;
       $26 = HEAP32[($2 + 40 | 0) >> 2] | 0;
       $2 = 0;
       label$7 : while (1) {
        $27 = $14;
        $14 = $13;
        $13 = $12;
        $12 = $11;
        $11 = $10;
        $10 = $7;
        $7 = $9;
        $9 = $6;
        $6 = $3;
        $3 = $8;
        $8 = $2 << 2 | 0;
        $113 = $5 + $8 | 0;
        $8 = HEAP32[($0 + $8 | 0) >> 2] | 0;
        HEAP32[$113 >> 2] = $8 - (((((((((((Math_imul($27, $25) + Math_imul($15, $26) | 0) + Math_imul($14, $24) | 0) + Math_imul($13, $23) | 0) + Math_imul($12, $22) | 0) + Math_imul($11, $21) | 0) + Math_imul($10, $20) | 0) + Math_imul($7, $19) | 0) + Math_imul($9, $18) | 0) + Math_imul($6, $17) | 0) + Math_imul($3, $16) | 0) >> $4 | 0) | 0;
        $15 = $27;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue label$7
        }
        break label$1;
       };
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $15 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($0 + -16 | 0) >> 2] | 0;
      $7 = HEAP32[($0 + -20 | 0) >> 2] | 0;
      $10 = HEAP32[($0 + -24 | 0) >> 2] | 0;
      $11 = HEAP32[($0 + -28 | 0) >> 2] | 0;
      $12 = HEAP32[($0 + -32 | 0) >> 2] | 0;
      $13 = HEAP32[($0 + -36 | 0) >> 2] | 0;
      $14 = HEAP32[($0 + -40 | 0) >> 2] | 0;
      $27 = HEAP32[($0 + -44 | 0) >> 2] | 0;
      $16 = HEAP32[($0 + -48 | 0) >> 2] | 0;
      $17 = HEAP32[$2 >> 2] | 0;
      $18 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $19 = HEAP32[($2 + 8 | 0) >> 2] | 0;
      $20 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      $21 = HEAP32[($2 + 16 | 0) >> 2] | 0;
      $22 = HEAP32[($2 + 20 | 0) >> 2] | 0;
      $23 = HEAP32[($2 + 24 | 0) >> 2] | 0;
      $24 = HEAP32[($2 + 28 | 0) >> 2] | 0;
      $25 = HEAP32[($2 + 32 | 0) >> 2] | 0;
      $26 = HEAP32[($2 + 36 | 0) >> 2] | 0;
      $28 = HEAP32[($2 + 40 | 0) >> 2] | 0;
      $29 = HEAP32[($2 + 44 | 0) >> 2] | 0;
      $2 = 0;
      label$8 : while (1) {
       $8 = $27;
       $27 = $14;
       $14 = $13;
       $13 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $7;
       $7 = $9;
       $9 = $6;
       $6 = $3;
       $3 = $15;
       $15 = $2 << 2 | 0;
       $248 = $5 + $15 | 0;
       $15 = HEAP32[($0 + $15 | 0) >> 2] | 0;
       HEAP32[$248 >> 2] = $15 - ((((((((((((Math_imul($8, $28) + Math_imul($16, $29) | 0) + Math_imul($27, $26) | 0) + Math_imul($14, $25) | 0) + Math_imul($13, $24) | 0) + Math_imul($12, $23) | 0) + Math_imul($11, $22) | 0) + Math_imul($10, $21) | 0) + Math_imul($7, $20) | 0) + Math_imul($9, $19) | 0) + Math_imul($6, $18) | 0) + Math_imul($3, $17) | 0) >> $4 | 0) | 0;
       $16 = $8;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$8
       }
       break label$1;
      };
     }
     label$9 : {
      if (($3 | 0) == (10 | 0)) {
       break label$9
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $14 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($0 + -16 | 0) >> 2] | 0;
      $7 = HEAP32[($0 + -20 | 0) >> 2] | 0;
      $10 = HEAP32[($0 + -24 | 0) >> 2] | 0;
      $11 = HEAP32[($0 + -28 | 0) >> 2] | 0;
      $12 = HEAP32[($0 + -32 | 0) >> 2] | 0;
      $27 = HEAP32[($0 + -36 | 0) >> 2] | 0;
      $8 = HEAP32[$2 >> 2] | 0;
      $15 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $16 = HEAP32[($2 + 8 | 0) >> 2] | 0;
      $17 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      $18 = HEAP32[($2 + 16 | 0) >> 2] | 0;
      $19 = HEAP32[($2 + 20 | 0) >> 2] | 0;
      $20 = HEAP32[($2 + 24 | 0) >> 2] | 0;
      $21 = HEAP32[($2 + 28 | 0) >> 2] | 0;
      $22 = HEAP32[($2 + 32 | 0) >> 2] | 0;
      $2 = 0;
      label$10 : while (1) {
       $13 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $7;
       $7 = $9;
       $9 = $6;
       $6 = $3;
       $3 = $14;
       $14 = $2 << 2 | 0;
       $371 = $5 + $14 | 0;
       $14 = HEAP32[($0 + $14 | 0) >> 2] | 0;
       HEAP32[$371 >> 2] = $14 - (((((((((Math_imul($13, $21) + Math_imul($27, $22) | 0) + Math_imul($12, $20) | 0) + Math_imul($11, $19) | 0) + Math_imul($10, $18) | 0) + Math_imul($7, $17) | 0) + Math_imul($9, $16) | 0) + Math_imul($6, $15) | 0) + Math_imul($3, $8) | 0) >> $4 | 0) | 0;
       $27 = $13;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$10
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $27 = HEAP32[($0 + -4 | 0) >> 2] | 0;
     $3 = HEAP32[($0 + -8 | 0) >> 2] | 0;
     $6 = HEAP32[($0 + -12 | 0) >> 2] | 0;
     $9 = HEAP32[($0 + -16 | 0) >> 2] | 0;
     $7 = HEAP32[($0 + -20 | 0) >> 2] | 0;
     $10 = HEAP32[($0 + -24 | 0) >> 2] | 0;
     $11 = HEAP32[($0 + -28 | 0) >> 2] | 0;
     $12 = HEAP32[($0 + -32 | 0) >> 2] | 0;
     $13 = HEAP32[($0 + -36 | 0) >> 2] | 0;
     $8 = HEAP32[($0 + -40 | 0) >> 2] | 0;
     $15 = HEAP32[$2 >> 2] | 0;
     $16 = HEAP32[($2 + 4 | 0) >> 2] | 0;
     $17 = HEAP32[($2 + 8 | 0) >> 2] | 0;
     $18 = HEAP32[($2 + 12 | 0) >> 2] | 0;
     $19 = HEAP32[($2 + 16 | 0) >> 2] | 0;
     $20 = HEAP32[($2 + 20 | 0) >> 2] | 0;
     $21 = HEAP32[($2 + 24 | 0) >> 2] | 0;
     $22 = HEAP32[($2 + 28 | 0) >> 2] | 0;
     $23 = HEAP32[($2 + 32 | 0) >> 2] | 0;
     $24 = HEAP32[($2 + 36 | 0) >> 2] | 0;
     $2 = 0;
     label$11 : while (1) {
      $14 = $13;
      $13 = $12;
      $12 = $11;
      $11 = $10;
      $10 = $7;
      $7 = $9;
      $9 = $6;
      $6 = $3;
      $3 = $27;
      $27 = $2 << 2 | 0;
      $486 = $5 + $27 | 0;
      $27 = HEAP32[($0 + $27 | 0) >> 2] | 0;
      HEAP32[$486 >> 2] = $27 - ((((((((((Math_imul($14, $23) + Math_imul($8, $24) | 0) + Math_imul($13, $22) | 0) + Math_imul($12, $21) | 0) + Math_imul($11, $20) | 0) + Math_imul($10, $19) | 0) + Math_imul($7, $18) | 0) + Math_imul($9, $17) | 0) + Math_imul($6, $16) | 0) + Math_imul($3, $15) | 0) >> $4 | 0) | 0;
      $8 = $14;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue label$11
      }
      break label$1;
     };
    }
    label$12 : {
     if ($3 >>> 0 < 5 >>> 0) {
      break label$12
     }
     label$13 : {
      if ($3 >>> 0 < 7 >>> 0) {
       break label$13
      }
      label$14 : {
       if (($3 | 0) == (8 | 0)) {
        break label$14
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $12 = HEAP32[($0 + -4 | 0) >> 2] | 0;
       $3 = HEAP32[($0 + -8 | 0) >> 2] | 0;
       $6 = HEAP32[($0 + -12 | 0) >> 2] | 0;
       $9 = HEAP32[($0 + -16 | 0) >> 2] | 0;
       $7 = HEAP32[($0 + -20 | 0) >> 2] | 0;
       $10 = HEAP32[($0 + -24 | 0) >> 2] | 0;
       $13 = HEAP32[($0 + -28 | 0) >> 2] | 0;
       $14 = HEAP32[$2 >> 2] | 0;
       $27 = HEAP32[($2 + 4 | 0) >> 2] | 0;
       $8 = HEAP32[($2 + 8 | 0) >> 2] | 0;
       $15 = HEAP32[($2 + 12 | 0) >> 2] | 0;
       $16 = HEAP32[($2 + 16 | 0) >> 2] | 0;
       $17 = HEAP32[($2 + 20 | 0) >> 2] | 0;
       $18 = HEAP32[($2 + 24 | 0) >> 2] | 0;
       $2 = 0;
       label$15 : while (1) {
        $11 = $10;
        $10 = $7;
        $7 = $9;
        $9 = $6;
        $6 = $3;
        $3 = $12;
        $12 = $2 << 2 | 0;
        $593 = $5 + $12 | 0;
        $12 = HEAP32[($0 + $12 | 0) >> 2] | 0;
        HEAP32[$593 >> 2] = $12 - (((((((Math_imul($11, $17) + Math_imul($13, $18) | 0) + Math_imul($10, $16) | 0) + Math_imul($7, $15) | 0) + Math_imul($9, $8) | 0) + Math_imul($6, $27) | 0) + Math_imul($3, $14) | 0) >> $4 | 0) | 0;
        $13 = $11;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue label$15
        }
        break label$1;
       };
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $13 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($0 + -16 | 0) >> 2] | 0;
      $7 = HEAP32[($0 + -20 | 0) >> 2] | 0;
      $10 = HEAP32[($0 + -24 | 0) >> 2] | 0;
      $11 = HEAP32[($0 + -28 | 0) >> 2] | 0;
      $14 = HEAP32[($0 + -32 | 0) >> 2] | 0;
      $27 = HEAP32[$2 >> 2] | 0;
      $8 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $15 = HEAP32[($2 + 8 | 0) >> 2] | 0;
      $16 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      $17 = HEAP32[($2 + 16 | 0) >> 2] | 0;
      $18 = HEAP32[($2 + 20 | 0) >> 2] | 0;
      $19 = HEAP32[($2 + 24 | 0) >> 2] | 0;
      $20 = HEAP32[($2 + 28 | 0) >> 2] | 0;
      $2 = 0;
      label$16 : while (1) {
       $12 = $11;
       $11 = $10;
       $10 = $7;
       $7 = $9;
       $9 = $6;
       $6 = $3;
       $3 = $13;
       $13 = $2 << 2 | 0;
       $688 = $5 + $13 | 0;
       $13 = HEAP32[($0 + $13 | 0) >> 2] | 0;
       HEAP32[$688 >> 2] = $13 - ((((((((Math_imul($12, $19) + Math_imul($14, $20) | 0) + Math_imul($11, $18) | 0) + Math_imul($10, $17) | 0) + Math_imul($7, $16) | 0) + Math_imul($9, $15) | 0) + Math_imul($6, $8) | 0) + Math_imul($3, $27) | 0) >> $4 | 0) | 0;
       $14 = $12;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$16
       }
       break label$1;
      };
     }
     label$17 : {
      if (($3 | 0) == (6 | 0)) {
       break label$17
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $10 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($0 + -16 | 0) >> 2] | 0;
      $11 = HEAP32[($0 + -20 | 0) >> 2] | 0;
      $12 = HEAP32[$2 >> 2] | 0;
      $13 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $14 = HEAP32[($2 + 8 | 0) >> 2] | 0;
      $27 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      $8 = HEAP32[($2 + 16 | 0) >> 2] | 0;
      $2 = 0;
      label$18 : while (1) {
       $7 = $9;
       $9 = $6;
       $6 = $3;
       $3 = $10;
       $10 = $2 << 2 | 0;
       $771 = $5 + $10 | 0;
       $10 = HEAP32[($0 + $10 | 0) >> 2] | 0;
       HEAP32[$771 >> 2] = $10 - (((((Math_imul($7, $27) + Math_imul($11, $8) | 0) + Math_imul($9, $14) | 0) + Math_imul($6, $13) | 0) + Math_imul($3, $12) | 0) >> $4 | 0) | 0;
       $11 = $7;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$18
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $11 = HEAP32[($0 + -4 | 0) >> 2] | 0;
     $3 = HEAP32[($0 + -8 | 0) >> 2] | 0;
     $6 = HEAP32[($0 + -12 | 0) >> 2] | 0;
     $9 = HEAP32[($0 + -16 | 0) >> 2] | 0;
     $7 = HEAP32[($0 + -20 | 0) >> 2] | 0;
     $12 = HEAP32[($0 + -24 | 0) >> 2] | 0;
     $13 = HEAP32[$2 >> 2] | 0;
     $14 = HEAP32[($2 + 4 | 0) >> 2] | 0;
     $27 = HEAP32[($2 + 8 | 0) >> 2] | 0;
     $8 = HEAP32[($2 + 12 | 0) >> 2] | 0;
     $15 = HEAP32[($2 + 16 | 0) >> 2] | 0;
     $16 = HEAP32[($2 + 20 | 0) >> 2] | 0;
     $2 = 0;
     label$19 : while (1) {
      $10 = $7;
      $7 = $9;
      $9 = $6;
      $6 = $3;
      $3 = $11;
      $11 = $2 << 2 | 0;
      $846 = $5 + $11 | 0;
      $11 = HEAP32[($0 + $11 | 0) >> 2] | 0;
      HEAP32[$846 >> 2] = $11 - ((((((Math_imul($10, $15) + Math_imul($12, $16) | 0) + Math_imul($7, $8) | 0) + Math_imul($9, $27) | 0) + Math_imul($6, $14) | 0) + Math_imul($3, $13) | 0) >> $4 | 0) | 0;
      $12 = $10;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue label$19
      }
      break label$1;
     };
    }
    label$20 : {
     if ($3 >>> 0 < 3 >>> 0) {
      break label$20
     }
     label$21 : {
      label$22 : {
       label$23 : {
        if (($3 | 0) == (4 | 0)) {
         break label$23
        }
        if (($1 | 0) < (1 | 0)) {
         break label$1
        }
        $27 = $1 & 1 | 0;
        $7 = HEAP32[($0 + -4 | 0) >> 2] | 0;
        $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
        $10 = HEAP32[($0 + -12 | 0) >> 2] | 0;
        $11 = HEAP32[$2 >> 2] | 0;
        $12 = HEAP32[($2 + 4 | 0) >> 2] | 0;
        $13 = HEAP32[($2 + 8 | 0) >> 2] | 0;
        $3 = 0;
        if (($1 | 0) != (1 | 0)) {
         break label$22
        }
        $2 = $6;
        $9 = $10;
        break label$21;
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $15 = $1 & 1 | 0;
       $10 = HEAP32[($0 + -4 | 0) >> 2] | 0;
       $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
       $9 = HEAP32[($0 + -12 | 0) >> 2] | 0;
       $11 = HEAP32[($0 + -16 | 0) >> 2] | 0;
       $12 = HEAP32[$2 >> 2] | 0;
       $13 = HEAP32[($2 + 4 | 0) >> 2] | 0;
       $14 = HEAP32[($2 + 8 | 0) >> 2] | 0;
       $27 = HEAP32[($2 + 12 | 0) >> 2] | 0;
       $2 = 0;
       label$24 : {
        label$25 : {
         if (($1 | 0) != (1 | 0)) {
          break label$25
         }
         $1 = $9;
         $3 = $11;
         break label$24;
        }
        $8 = $1 & -2 | 0;
        $2 = 0;
        label$26 : while (1) {
         $3 = $6;
         $7 = $2 << 2 | 0;
         $6 = HEAP32[($0 + $7 | 0) >> 2] | 0;
         $1 = $10;
         HEAP32[($5 + $7 | 0) >> 2] = $6 - ((((Math_imul($9, $14) + Math_imul($11, $27) | 0) + Math_imul($3, $13) | 0) + Math_imul($1, $12) | 0) >> $4 | 0) | 0;
         $7 = $7 | 4 | 0;
         $10 = HEAP32[($0 + $7 | 0) >> 2] | 0;
         HEAP32[($5 + $7 | 0) >> 2] = $10 - ((((Math_imul($3, $14) + Math_imul($9, $27) | 0) + Math_imul($1, $13) | 0) + Math_imul($6, $12) | 0) >> $4 | 0) | 0;
         $2 = $2 + 2 | 0;
         $9 = $1;
         $11 = $3;
         $8 = $8 + -2 | 0;
         if ($8) {
          continue label$26
         }
         break label$26;
        };
       }
       if (!$15) {
        break label$1
       }
       $2 = $2 << 2 | 0;
       HEAP32[($5 + $2 | 0) >> 2] = (HEAP32[($0 + $2 | 0) >> 2] | 0) - ((((Math_imul($1, $14) + Math_imul($3, $27) | 0) + Math_imul($6, $13) | 0) + Math_imul($10, $12) | 0) >> $4 | 0) | 0;
       return;
      }
      $14 = $1 & -2 | 0;
      $3 = 0;
      label$27 : while (1) {
       $1 = $3 << 2 | 0;
       $2 = HEAP32[($0 + $1 | 0) >> 2] | 0;
       $9 = $7;
       HEAP32[($5 + $1 | 0) >> 2] = $2 - (((Math_imul($6, $12) + Math_imul($10, $13) | 0) + Math_imul($9, $11) | 0) >> $4 | 0) | 0;
       $1 = $1 | 4 | 0;
       $7 = HEAP32[($0 + $1 | 0) >> 2] | 0;
       HEAP32[($5 + $1 | 0) >> 2] = $7 - (((Math_imul($9, $12) + Math_imul($6, $13) | 0) + Math_imul($2, $11) | 0) >> $4 | 0) | 0;
       $3 = $3 + 2 | 0;
       $6 = $2;
       $10 = $9;
       $14 = $14 + -2 | 0;
       if ($14) {
        continue label$27
       }
       break label$27;
      };
     }
     if (!$27) {
      break label$1
     }
     $3 = $3 << 2 | 0;
     HEAP32[($5 + $3 | 0) >> 2] = (HEAP32[($0 + $3 | 0) >> 2] | 0) - (((Math_imul($2, $12) + Math_imul($9, $13) | 0) + Math_imul($7, $11) | 0) >> $4 | 0) | 0;
     return;
    }
    label$28 : {
     if (($3 | 0) == (2 | 0)) {
      break label$28
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $10 = $1 & 1 | 0;
     $6 = HEAP32[($0 + -4 | 0) >> 2] | 0;
     $9 = HEAP32[$2 >> 2] | 0;
     $3 = 0;
     label$29 : {
      if (($1 | 0) == (1 | 0)) {
       break label$29
      }
      $1 = $1 & -2 | 0;
      $3 = 0;
      label$30 : while (1) {
       $2 = $3 << 2 | 0;
       $7 = HEAP32[($0 + $2 | 0) >> 2] | 0;
       HEAP32[($5 + $2 | 0) >> 2] = $7 - (Math_imul($6, $9) >> $4 | 0) | 0;
       $2 = $2 | 4 | 0;
       $6 = HEAP32[($0 + $2 | 0) >> 2] | 0;
       HEAP32[($5 + $2 | 0) >> 2] = $6 - (Math_imul($7, $9) >> $4 | 0) | 0;
       $3 = $3 + 2 | 0;
       $1 = $1 + -2 | 0;
       if ($1) {
        continue label$30
       }
       break label$30;
      };
     }
     if (!$10) {
      break label$1
     }
     $3 = $3 << 2 | 0;
     HEAP32[($5 + $3 | 0) >> 2] = (HEAP32[($0 + $3 | 0) >> 2] | 0) - (Math_imul($6, $9) >> $4 | 0) | 0;
     break label$1;
    }
    if (($1 | 0) < (1 | 0)) {
     break label$1
    }
    $12 = $1 & 1 | 0;
    $6 = HEAP32[($0 + -4 | 0) >> 2] | 0;
    $9 = HEAP32[($0 + -8 | 0) >> 2] | 0;
    $7 = HEAP32[$2 >> 2] | 0;
    $10 = HEAP32[($2 + 4 | 0) >> 2] | 0;
    $3 = 0;
    label$31 : {
     if (($1 | 0) == (1 | 0)) {
      break label$31
     }
     $1 = $1 & -2 | 0;
     $3 = 0;
     label$32 : while (1) {
      $11 = Math_imul($9, $10);
      $2 = $3 << 2 | 0;
      $9 = HEAP32[($0 + $2 | 0) >> 2] | 0;
      HEAP32[($5 + $2 | 0) >> 2] = $9 - (($11 + Math_imul($6, $7) | 0) >> $4 | 0) | 0;
      $11 = Math_imul($6, $10);
      $2 = $2 | 4 | 0;
      $6 = HEAP32[($0 + $2 | 0) >> 2] | 0;
      HEAP32[($5 + $2 | 0) >> 2] = $6 - (($11 + Math_imul($9, $7) | 0) >> $4 | 0) | 0;
      $3 = $3 + 2 | 0;
      $1 = $1 + -2 | 0;
      if ($1) {
       continue label$32
      }
      break label$32;
     };
    }
    if (!$12) {
     break label$1
    }
    $3 = $3 << 2 | 0;
    HEAP32[($5 + $3 | 0) >> 2] = (HEAP32[($0 + $3 | 0) >> 2] | 0) - ((Math_imul($6, $7) + Math_imul($9, $10) | 0) >> $4 | 0) | 0;
    return;
   }
   label$33 : while (1) {
    $3 = 0;
    label$34 : {
     switch ($7 | 0) {
     case 19:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -128 | 0) >> 2] | 0, HEAP32[($2 + 124 | 0) >> 2] | 0);
     case 18:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -124 | 0) >> 2] | 0, HEAP32[($2 + 120 | 0) >> 2] | 0) + $3 | 0;
     case 17:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -120 | 0) >> 2] | 0, HEAP32[($2 + 116 | 0) >> 2] | 0) + $3 | 0;
     case 16:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -116 | 0) >> 2] | 0, HEAP32[($2 + 112 | 0) >> 2] | 0) + $3 | 0;
     case 15:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -112 | 0) >> 2] | 0, HEAP32[($2 + 108 | 0) >> 2] | 0) + $3 | 0;
     case 14:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -108 | 0) >> 2] | 0, HEAP32[($2 + 104 | 0) >> 2] | 0) + $3 | 0;
     case 13:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -104 | 0) >> 2] | 0, HEAP32[($2 + 100 | 0) >> 2] | 0) + $3 | 0;
     case 12:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -100 | 0) >> 2] | 0, HEAP32[($2 + 96 | 0) >> 2] | 0) + $3 | 0;
     case 11:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -96 | 0) >> 2] | 0, HEAP32[($2 + 92 | 0) >> 2] | 0) + $3 | 0;
     case 10:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -92 | 0) >> 2] | 0, HEAP32[($2 + 88 | 0) >> 2] | 0) + $3 | 0;
     case 9:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -88 | 0) >> 2] | 0, HEAP32[($2 + 84 | 0) >> 2] | 0) + $3 | 0;
     case 8:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -84 | 0) >> 2] | 0, HEAP32[($2 + 80 | 0) >> 2] | 0) + $3 | 0;
     case 7:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -80 | 0) >> 2] | 0, HEAP32[($2 + 76 | 0) >> 2] | 0) + $3 | 0;
     case 6:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -76 | 0) >> 2] | 0, HEAP32[($2 + 72 | 0) >> 2] | 0) + $3 | 0;
     case 5:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -72 | 0) >> 2] | 0, HEAP32[($2 + 68 | 0) >> 2] | 0) + $3 | 0;
     case 4:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -68 | 0) >> 2] | 0, HEAP32[($2 + 64 | 0) >> 2] | 0) + $3 | 0;
     case 3:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -64 | 0) >> 2] | 0, HEAP32[($2 + 60 | 0) >> 2] | 0) + $3 | 0;
     case 2:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -60 | 0) >> 2] | 0, HEAP32[($2 + 56 | 0) >> 2] | 0) + $3 | 0;
     case 1:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $0 | 0) + -56 | 0) >> 2] | 0, HEAP32[($2 + 52 | 0) >> 2] | 0) + $3 | 0;
     case 0:
      $9 = ($6 << 2 | 0) + $0 | 0;
      $3 = ((((((((((((Math_imul(HEAP32[($9 + -52 | 0) >> 2] | 0, HEAP32[($2 + 48 | 0) >> 2] | 0) + $3 | 0) + Math_imul(HEAP32[($9 + -48 | 0) >> 2] | 0, HEAP32[($2 + 44 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -44 | 0) >> 2] | 0, HEAP32[($2 + 40 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -40 | 0) >> 2] | 0, HEAP32[($2 + 36 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -36 | 0) >> 2] | 0, HEAP32[($2 + 32 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -32 | 0) >> 2] | 0, HEAP32[($2 + 28 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -28 | 0) >> 2] | 0, HEAP32[($2 + 24 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -24 | 0) >> 2] | 0, HEAP32[($2 + 20 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -20 | 0) >> 2] | 0, HEAP32[($2 + 16 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -16 | 0) >> 2] | 0, HEAP32[($2 + 12 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -12 | 0) >> 2] | 0, HEAP32[($2 + 8 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -8 | 0) >> 2] | 0, HEAP32[($2 + 4 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($9 + -4 | 0) >> 2] | 0, HEAP32[$2 >> 2] | 0) | 0;
      break;
     default:
      break label$34;
     };
    }
    $9 = $6 << 2 | 0;
    HEAP32[($5 + $9 | 0) >> 2] = (HEAP32[($0 + $9 | 0) >> 2] | 0) - ($3 >> $4 | 0) | 0;
    $6 = $6 + 1 | 0;
    if (($6 | 0) != ($1 | 0)) {
     continue label$33
    }
    break label$33;
   };
  }
 }
 
 function FLAC__lpc_compute_residual_from_qlp_coefficients_wide($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, i64toi32_i32$4 = 0, i64toi32_i32$5 = 0, i64toi32_i32$3 = 0, $8$hi = 0, $6 = 0, $8 = 0, $10 = 0, $7$hi = 0, $11 = 0, $12 = 0, $17$hi = 0, $13 = 0, $18$hi = 0, $19$hi = 0, $7 = 0, $14 = 0, $15 = 0, $17 = 0, $20$hi = 0, $18 = 0, $21$hi = 0, $19 = 0, $27 = 0, $22$hi = 0, $20 = 0, $9 = 0, $23$hi = 0, $21 = 0, $22 = 0, $24$hi = 0, $16 = 0, $23 = 0, $25$hi = 0, $24 = 0, $25 = 0, $26$hi = 0, $26 = 0, $28 = 0, $581 = 0, $29$hi = 0, $582 = 0, $583 = 0, $584 = 0, $585 = 0, $586 = 0, $587 = 0, $588 = 0, $589 = 0, $590 = 0, $591 = 0, $592 = 0, $593 = 0, $594 = 0, $595 = 0, $596 = 0, $597 = 0, $117 = 0, $122 = 0, $124$hi = 0, $126 = 0, $126$hi = 0, $128$hi = 0, $130 = 0, $130$hi = 0, $131$hi = 0, $133$hi = 0, $135 = 0, $135$hi = 0, $136$hi = 0, $138$hi = 0, $140 = 0, $140$hi = 0, $141$hi = 0, $143$hi = 0, $145 = 0, $145$hi = 0, $146$hi = 0, $148$hi = 0, $150 = 0, $150$hi = 0, $151$hi = 0, $153$hi = 0, $155 = 0, $155$hi = 0, $156$hi = 0, $158$hi = 0, $160 = 0, $160$hi = 0, $161$hi = 0, $163$hi = 0, $165 = 0, $165$hi = 0, $166$hi = 0, $168$hi = 0, $170 = 0, $170$hi = 0, $171$hi = 0, $173$hi = 0, $175 = 0, $175$hi = 0, $176$hi = 0, $29 = 0, $264 = 0, $269 = 0, $271$hi = 0, $273 = 0, $273$hi = 0, $275$hi = 0, $277 = 0, $277$hi = 0, $278$hi = 0, $280$hi = 0, $282 = 0, $282$hi = 0, $283$hi = 0, $285$hi = 0, $287 = 0, $287$hi = 0, $288$hi = 0, $290$hi = 0, $292 = 0, $292$hi = 0, $293$hi = 0, $295$hi = 0, $297 = 0, $297$hi = 0, $298$hi = 0, $300$hi = 0, $302 = 0, $302$hi = 0, $303$hi = 0, $305$hi = 0, $307 = 0, $307$hi = 0, $308$hi = 0, $310$hi = 0, $312 = 0, $312$hi = 0, $313$hi = 0, $315$hi = 0, $317 = 0, $317$hi = 0, $318$hi = 0, $320$hi = 0, $322 = 0, $322$hi = 0, $323$hi = 0, $325$hi = 0, $327 = 0, $327$hi = 0, $328$hi = 0, $402 = 0, $407 = 0, $409$hi = 0, $411 = 0, $411$hi = 0, $413$hi = 0, $415 = 0, $415$hi = 0, $416$hi = 0, $418$hi = 0, $420 = 0, $420$hi = 0, $421$hi = 0, $423$hi = 0, $425 = 0, $425$hi = 0, $426$hi = 0, $428$hi = 0, $430 = 0, $430$hi = 0, $431$hi = 0, $433$hi = 0, $435 = 0, $435$hi = 0, $436$hi = 0, $438$hi = 0, $440 = 0, $440$hi = 0, $441$hi = 0, $443$hi = 0, $445 = 0, $445$hi = 0, $446$hi = 0, $448$hi = 0, $450 = 0, $450$hi = 0, $451$hi = 0, $527 = 0, $532 = 0, $534$hi = 0, $536 = 0, $536$hi = 0, $538$hi = 0, $540 = 0, $540$hi = 0, $541$hi = 0, $543$hi = 0, $545 = 0, $545$hi = 0, $546$hi = 0, $548$hi = 0, $550 = 0, $550$hi = 0, $551$hi = 0, $553$hi = 0, $555 = 0, $555$hi = 0, $556$hi = 0, $558$hi = 0, $560 = 0, $560$hi = 0, $561$hi = 0, $563$hi = 0, $565 = 0, $565$hi = 0, $566$hi = 0, $568$hi = 0, $570 = 0, $570$hi = 0, $571$hi = 0, $573$hi = 0, $575 = 0, $575$hi = 0, $576$hi = 0, $578$hi = 0, $580 = 0, $580$hi = 0, $581$hi = 0, $647 = 0, $652 = 0, $654$hi = 0, $656 = 0, $656$hi = 0, $658$hi = 0, $660 = 0, $660$hi = 0, $661$hi = 0, $663$hi = 0, $665 = 0, $665$hi = 0, $666$hi = 0, $668$hi = 0, $670 = 0, $670$hi = 0, $671$hi = 0, $673$hi = 0, $675 = 0, $675$hi = 0, $676$hi = 0, $678$hi = 0, $680 = 0, $680$hi = 0, $681$hi = 0, $683$hi = 0, $685 = 0, $685$hi = 0, $686$hi = 0, $750 = 0, $755 = 0, $757$hi = 0, $759 = 0, $759$hi = 0, $761$hi = 0, $763 = 0, $763$hi = 0, $764$hi = 0, $766$hi = 0, $768 = 0, $768$hi = 0, $769$hi = 0, $771$hi = 0, $773 = 0, $773$hi = 0, $774$hi = 0, $776$hi = 0, $778 = 0, $778$hi = 0, $779$hi = 0, $781$hi = 0, $783 = 0, $783$hi = 0, $784$hi = 0, $786$hi = 0, $788 = 0, $788$hi = 0, $789$hi = 0, $791$hi = 0, $793 = 0, $793$hi = 0, $794$hi = 0, $844 = 0, $849 = 0, $851$hi = 0, $853 = 0, $853$hi = 0, $855$hi = 0, $857 = 0, $857$hi = 0, $858$hi = 0, $860$hi = 0, $862 = 0, $862$hi = 0, $863$hi = 0, $865$hi = 0, $867 = 0, $867$hi = 0, $868$hi = 0, $870$hi = 0, $872 = 0, $872$hi = 0, $873$hi = 0, $925 = 0, $930 = 0, $932$hi = 0, $934 = 0, $934$hi = 0, $936$hi = 0, $938 = 0, $938$hi = 0, $939$hi = 0, $941$hi = 0, $943 = 0, $943$hi = 0, $944$hi = 0, $946$hi = 0, $948 = 0, $948$hi = 0, $949$hi = 0, $951$hi = 0, $953 = 0, $953$hi = 0, $954$hi = 0, $956$hi = 0, $958 = 0, $958$hi = 0, $959$hi = 0, $999 = 0, $1004 = 0, $1006$hi = 0, $1008 = 0, $1008$hi = 0, $1010$hi = 0, $1012 = 0, $1012$hi = 0, $1013$hi = 0, $1015$hi = 0, $1017 = 0, $1017$hi = 0, $1018$hi = 0, $1058 = 0, $1063 = 0, $1065$hi = 0, $1067 = 0, $1067$hi = 0, $1069$hi = 0, $1071 = 0, $1071$hi = 0, $1072$hi = 0, $1074$hi = 0, $1076 = 0, $1076$hi = 0, $1077$hi = 0, $1079$hi = 0, $1081 = 0, $1081$hi = 0, $1082$hi = 0, $1114 = 0, $1119 = 0, $1121$hi = 0, $1123$hi = 0, $1132 = 0, $1137 = 0, $1139$hi = 0, $1141$hi = 0, $1157 = 0, $1161 = 0, $1163$hi = 0, $1165$hi = 0, $1194 = 0, $1199 = 0, $1204 = 0, $1204$hi = 0, $1207 = 0, $1207$hi = 0, $1208$hi = 0, $1217 = 0, $1222 = 0, $1224$hi = 0, $1226 = 0, $1226$hi = 0, $1229 = 0, $1229$hi = 0, $1230$hi = 0, $1246 = 0, $1250 = 0, $1252$hi = 0, $1254 = 0, $1254$hi = 0, $1256$hi = 0, $1258 = 0, $1258$hi = 0, $1259$hi = 0, $1270 = 0, $1270$hi = 0, $1272 = 0, $1272$hi = 0, $1279 = 0, $1279$hi = 0, $1281 = 0, $1281$hi = 0, $1282$hi = 0, $1290 = 0, $1290$hi = 0, $1292 = 0, $1292$hi = 0, $1293$hi = 0, $1301 = 0, $1301$hi = 0, $1303 = 0, $1303$hi = 0, $1304$hi = 0, $1312 = 0, $1312$hi = 0, $1314 = 0, $1314$hi = 0, $1315$hi = 0, $1323 = 0, $1323$hi = 0, $1325 = 0, $1325$hi = 0, $1326$hi = 0, $1334 = 0, $1334$hi = 0, $1336 = 0, $1336$hi = 0, $1337$hi = 0, $1345 = 0, $1345$hi = 0, $1347 = 0, $1347$hi = 0, $1348$hi = 0, $1356 = 0, $1356$hi = 0, $1358 = 0, $1358$hi = 0, $1359$hi = 0, $1367 = 0, $1367$hi = 0, $1369 = 0, $1369$hi = 0, $1370$hi = 0, $1378 = 0, $1378$hi = 0, $1380 = 0, $1380$hi = 0, $1381$hi = 0, $1389 = 0, $1389$hi = 0, $1391 = 0, $1391$hi = 0, $1392$hi = 0, $1400 = 0, $1400$hi = 0, $1402 = 0, $1402$hi = 0, $1403$hi = 0, $1411 = 0, $1411$hi = 0, $1413 = 0, $1413$hi = 0, $1414$hi = 0, $1422 = 0, $1422$hi = 0, $1424 = 0, $1424$hi = 0, $1425$hi = 0, $1433 = 0, $1433$hi = 0, $1435 = 0, $1435$hi = 0, $1436$hi = 0, $1444 = 0, $1444$hi = 0, $1446 = 0, $1446$hi = 0, $1447$hi = 0, $1455 = 0, $1455$hi = 0, $1457 = 0, $1457$hi = 0, $1458$hi = 0, $1466 = 0, $1466$hi = 0, $1468 = 0, $1468$hi = 0, $1469$hi = 0, $1478 = 0, $1478$hi = 0, $1480 = 0, $1480$hi = 0, $1481$hi = 0, $1483$hi = 0, $1486 = 0, $1486$hi = 0, $1488 = 0, $1488$hi = 0, $1489 = 0, $1489$hi = 0, $1490$hi = 0, $1493 = 0, $1493$hi = 0, $1495 = 0, $1495$hi = 0, $1496 = 0, $1496$hi = 0, $1497$hi = 0, $1500 = 0, $1500$hi = 0, $1502 = 0, $1502$hi = 0, $1503 = 0, $1503$hi = 0, $1504$hi = 0, $1507 = 0, $1507$hi = 0, $1509 = 0, $1509$hi = 0, $1510 = 0, $1510$hi = 0, $1511$hi = 0, $1514 = 0, $1514$hi = 0, $1516 = 0, $1516$hi = 0, $1517 = 0, $1517$hi = 0, $1518$hi = 0, $1521 = 0, $1521$hi = 0, $1523 = 0, $1523$hi = 0, $1524 = 0, $1524$hi = 0, $1525$hi = 0, $1528 = 0, $1528$hi = 0, $1530 = 0, $1530$hi = 0, $1531 = 0, $1531$hi = 0, $1532$hi = 0, $1535 = 0, $1535$hi = 0, $1537 = 0, $1537$hi = 0, $1538 = 0, $1538$hi = 0, $1539$hi = 0, $1542 = 0, $1542$hi = 0, $1544 = 0, $1544$hi = 0, $1545 = 0, $1545$hi = 0, $1546$hi = 0, $1549 = 0, $1549$hi = 0, $1551 = 0, $1551$hi = 0, $1552 = 0, $1552$hi = 0, $1553$hi = 0, $1556 = 0, $1556$hi = 0, $1558 = 0, $1558$hi = 0, $1559 = 0, $1559$hi = 0, $1560$hi = 0, $1563 = 0, $1563$hi = 0, $1565 = 0, $1565$hi = 0, $1566 = 0, $1566$hi = 0, $1572 = 0, $1576 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     if ($3 >>> 0 < 13 >>> 0) {
      break label$3
     }
     $6 = 0;
     if (($1 | 0) <= (0 | 0)) {
      break label$1
     }
     i64toi32_i32$0 = 0;
     $7 = $4;
     $7$hi = i64toi32_i32$0;
     $4 = $3 + -13 | 0;
     break label$2;
    }
    label$4 : {
     if ($3 >>> 0 < 9 >>> 0) {
      break label$4
     }
     label$5 : {
      if ($3 >>> 0 < 11 >>> 0) {
       break label$5
      }
      i64toi32_i32$0 = 0;
      $8 = $4;
      $8$hi = i64toi32_i32$0;
      label$6 : {
       if (($3 | 0) == (12 | 0)) {
        break label$6
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $9 = HEAP32[($0 + -4 | 0) >> 2] | 0;
       $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
       $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
       $4 = HEAP32[($0 + -16 | 0) >> 2] | 0;
       $10 = HEAP32[($0 + -20 | 0) >> 2] | 0;
       $11 = HEAP32[($0 + -24 | 0) >> 2] | 0;
       $12 = HEAP32[($0 + -28 | 0) >> 2] | 0;
       $13 = HEAP32[($0 + -32 | 0) >> 2] | 0;
       $14 = HEAP32[($0 + -36 | 0) >> 2] | 0;
       $15 = HEAP32[($0 + -40 | 0) >> 2] | 0;
       $16 = HEAP32[($0 + -44 | 0) >> 2] | 0;
       i64toi32_i32$2 = $2;
       i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $7 = i64toi32_i32$0;
       $7$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $17 = i64toi32_i32$1;
       $17$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 8 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $18 = i64toi32_i32$0;
       $18$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 12 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $19 = i64toi32_i32$1;
       $19$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 16 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $20 = i64toi32_i32$0;
       $20$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 20 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $21 = i64toi32_i32$1;
       $21$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 24 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $22 = i64toi32_i32$0;
       $22$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 28 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $23 = i64toi32_i32$1;
       $23$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 32 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $24 = i64toi32_i32$0;
       $24$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 36 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $25 = i64toi32_i32$1;
       $25$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 40 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $26 = i64toi32_i32$0;
       $26$hi = i64toi32_i32$1;
       $2 = 0;
       label$7 : while (1) {
        $27 = $15;
        $15 = $14;
        $14 = $13;
        $13 = $12;
        $12 = $11;
        $11 = $10;
        $10 = $4;
        $4 = $3;
        $3 = $6;
        $6 = $9;
        $9 = $2 << 2 | 0;
        $117 = $5 + $9 | 0;
        $9 = HEAP32[($0 + $9 | 0) >> 2] | 0;
        $122 = $9;
        i64toi32_i32$0 = $27;
        i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
        $124$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $25$hi;
        i64toi32_i32$1 = $124$hi;
        i64toi32_i32$0 = $25$hi;
        i64toi32_i32$0 = __wasm_i64_mul($27 | 0, i64toi32_i32$1 | 0, $25 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
        $126 = i64toi32_i32$0;
        $126$hi = i64toi32_i32$1;
        i64toi32_i32$0 = $16;
        i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
        $128$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $26$hi;
        i64toi32_i32$1 = $128$hi;
        i64toi32_i32$0 = $26$hi;
        i64toi32_i32$0 = __wasm_i64_mul($16 | 0, i64toi32_i32$1 | 0, $26 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
        $130 = i64toi32_i32$0;
        $130$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $126$hi;
        i64toi32_i32$2 = $126;
        i64toi32_i32$0 = $130$hi;
        i64toi32_i32$3 = $130;
        i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$0 | 0;
        if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
        }
        $131$hi = i64toi32_i32$5;
        i64toi32_i32$2 = $15;
        i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
        $133$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $24$hi;
        i64toi32_i32$5 = $133$hi;
        i64toi32_i32$2 = $24$hi;
        i64toi32_i32$2 = __wasm_i64_mul($15 | 0, i64toi32_i32$5 | 0, $24 | 0, i64toi32_i32$2 | 0) | 0;
        i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
        $135 = i64toi32_i32$2;
        $135$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $131$hi;
        i64toi32_i32$1 = i64toi32_i32$4;
        i64toi32_i32$2 = $135$hi;
        i64toi32_i32$3 = $135;
        i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
        if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
        }
        $136$hi = i64toi32_i32$4;
        i64toi32_i32$1 = $14;
        i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
        $138$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $23$hi;
        i64toi32_i32$4 = $138$hi;
        i64toi32_i32$1 = $23$hi;
        i64toi32_i32$1 = __wasm_i64_mul($14 | 0, i64toi32_i32$4 | 0, $23 | 0, i64toi32_i32$1 | 0) | 0;
        i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
        $140 = i64toi32_i32$1;
        $140$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $136$hi;
        i64toi32_i32$5 = i64toi32_i32$0;
        i64toi32_i32$1 = $140$hi;
        i64toi32_i32$3 = $140;
        i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
        i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
        if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
        }
        $141$hi = i64toi32_i32$0;
        i64toi32_i32$5 = $13;
        i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
        $143$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $22$hi;
        i64toi32_i32$0 = $143$hi;
        i64toi32_i32$5 = $22$hi;
        i64toi32_i32$5 = __wasm_i64_mul($13 | 0, i64toi32_i32$0 | 0, $22 | 0, i64toi32_i32$5 | 0) | 0;
        i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
        $145 = i64toi32_i32$5;
        $145$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $141$hi;
        i64toi32_i32$4 = i64toi32_i32$2;
        i64toi32_i32$5 = $145$hi;
        i64toi32_i32$3 = $145;
        i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$5 | 0;
        if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
        }
        $146$hi = i64toi32_i32$2;
        i64toi32_i32$4 = $12;
        i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
        $148$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $21$hi;
        i64toi32_i32$2 = $148$hi;
        i64toi32_i32$4 = $21$hi;
        i64toi32_i32$4 = __wasm_i64_mul($12 | 0, i64toi32_i32$2 | 0, $21 | 0, i64toi32_i32$4 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $150 = i64toi32_i32$4;
        $150$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $146$hi;
        i64toi32_i32$0 = i64toi32_i32$1;
        i64toi32_i32$4 = $150$hi;
        i64toi32_i32$3 = $150;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
        if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
        }
        $151$hi = i64toi32_i32$1;
        i64toi32_i32$0 = $11;
        i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
        $153$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $20$hi;
        i64toi32_i32$1 = $153$hi;
        i64toi32_i32$0 = $20$hi;
        i64toi32_i32$0 = __wasm_i64_mul($11 | 0, i64toi32_i32$1 | 0, $20 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
        $155 = i64toi32_i32$0;
        $155$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $151$hi;
        i64toi32_i32$2 = i64toi32_i32$5;
        i64toi32_i32$0 = $155$hi;
        i64toi32_i32$3 = $155;
        i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$0 | 0;
        if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
        }
        $156$hi = i64toi32_i32$5;
        i64toi32_i32$2 = $10;
        i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
        $158$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $19$hi;
        i64toi32_i32$5 = $158$hi;
        i64toi32_i32$2 = $19$hi;
        i64toi32_i32$2 = __wasm_i64_mul($10 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$2 | 0) | 0;
        i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
        $160 = i64toi32_i32$2;
        $160$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $156$hi;
        i64toi32_i32$1 = i64toi32_i32$4;
        i64toi32_i32$2 = $160$hi;
        i64toi32_i32$3 = $160;
        i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
        if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
        }
        $161$hi = i64toi32_i32$4;
        i64toi32_i32$1 = $4;
        i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
        $163$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $18$hi;
        i64toi32_i32$4 = $163$hi;
        i64toi32_i32$1 = $18$hi;
        i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$4 | 0, $18 | 0, i64toi32_i32$1 | 0) | 0;
        i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
        $165 = i64toi32_i32$1;
        $165$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $161$hi;
        i64toi32_i32$5 = i64toi32_i32$0;
        i64toi32_i32$1 = $165$hi;
        i64toi32_i32$3 = $165;
        i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
        i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
        if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
        }
        $166$hi = i64toi32_i32$0;
        i64toi32_i32$5 = $3;
        i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
        $168$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $17$hi;
        i64toi32_i32$0 = $168$hi;
        i64toi32_i32$5 = $17$hi;
        i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$0 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
        i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
        $170 = i64toi32_i32$5;
        $170$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $166$hi;
        i64toi32_i32$4 = i64toi32_i32$2;
        i64toi32_i32$5 = $170$hi;
        i64toi32_i32$3 = $170;
        i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$5 | 0;
        if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
        }
        $171$hi = i64toi32_i32$2;
        i64toi32_i32$4 = $6;
        i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
        $173$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $7$hi;
        i64toi32_i32$2 = $173$hi;
        i64toi32_i32$4 = $7$hi;
        i64toi32_i32$4 = __wasm_i64_mul($6 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $175 = i64toi32_i32$4;
        $175$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $171$hi;
        i64toi32_i32$0 = i64toi32_i32$1;
        i64toi32_i32$4 = $175$hi;
        i64toi32_i32$3 = $175;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
        if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
        }
        $176$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $8$hi;
        i64toi32_i32$1 = $176$hi;
        i64toi32_i32$2 = i64toi32_i32$5;
        i64toi32_i32$0 = $8$hi;
        i64toi32_i32$3 = $8;
        i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
        if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
         i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
         $581 = i64toi32_i32$1 >> i64toi32_i32$4 | 0;
        } else {
         i64toi32_i32$0 = i64toi32_i32$1 >> i64toi32_i32$4 | 0;
         $581 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
        }
        HEAP32[$117 >> 2] = $122 - $581 | 0;
        $16 = $27;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue label$7
        }
        break label$1;
       };
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $16 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      $4 = HEAP32[($0 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($0 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($0 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($0 + -28 | 0) >> 2] | 0;
      $13 = HEAP32[($0 + -32 | 0) >> 2] | 0;
      $14 = HEAP32[($0 + -36 | 0) >> 2] | 0;
      $15 = HEAP32[($0 + -40 | 0) >> 2] | 0;
      $27 = HEAP32[($0 + -44 | 0) >> 2] | 0;
      $28 = HEAP32[($0 + -48 | 0) >> 2] | 0;
      i64toi32_i32$1 = $2;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $7 = i64toi32_i32$0;
      $7$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $17 = i64toi32_i32$2;
      $17$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $18 = i64toi32_i32$0;
      $18$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $19 = i64toi32_i32$2;
      $19$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 16 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $20 = i64toi32_i32$0;
      $20$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 20 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $21 = i64toi32_i32$2;
      $21$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 24 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $22 = i64toi32_i32$0;
      $22$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 28 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $23 = i64toi32_i32$2;
      $23$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 32 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $24 = i64toi32_i32$0;
      $24$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 36 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $25 = i64toi32_i32$2;
      $25$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 40 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $26 = i64toi32_i32$0;
      $26$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 44 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $29 = i64toi32_i32$2;
      $29$hi = i64toi32_i32$0;
      $2 = 0;
      label$8 : while (1) {
       $9 = $27;
       $27 = $15;
       $15 = $14;
       $14 = $13;
       $13 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $4;
       $4 = $3;
       $3 = $6;
       $6 = $16;
       $16 = $2 << 2 | 0;
       $264 = $5 + $16 | 0;
       $16 = HEAP32[($0 + $16 | 0) >> 2] | 0;
       $269 = $16;
       i64toi32_i32$2 = $9;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $271$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $26$hi;
       i64toi32_i32$0 = $271$hi;
       i64toi32_i32$2 = $26$hi;
       i64toi32_i32$2 = __wasm_i64_mul($9 | 0, i64toi32_i32$0 | 0, $26 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $273 = i64toi32_i32$2;
       $273$hi = i64toi32_i32$0;
       i64toi32_i32$2 = $28;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $275$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $29$hi;
       i64toi32_i32$0 = $275$hi;
       i64toi32_i32$2 = $29$hi;
       i64toi32_i32$2 = __wasm_i64_mul($28 | 0, i64toi32_i32$0 | 0, $29 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $277 = i64toi32_i32$2;
       $277$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $273$hi;
       i64toi32_i32$1 = $273;
       i64toi32_i32$2 = $277$hi;
       i64toi32_i32$3 = $277;
       i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $278$hi = i64toi32_i32$5;
       i64toi32_i32$1 = $27;
       i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
       $280$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $25$hi;
       i64toi32_i32$5 = $280$hi;
       i64toi32_i32$1 = $25$hi;
       i64toi32_i32$1 = __wasm_i64_mul($27 | 0, i64toi32_i32$5 | 0, $25 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $282 = i64toi32_i32$1;
       $282$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $278$hi;
       i64toi32_i32$0 = i64toi32_i32$4;
       i64toi32_i32$1 = $282$hi;
       i64toi32_i32$3 = $282;
       i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $283$hi = i64toi32_i32$4;
       i64toi32_i32$0 = $15;
       i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
       $285$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $24$hi;
       i64toi32_i32$4 = $285$hi;
       i64toi32_i32$0 = $24$hi;
       i64toi32_i32$0 = __wasm_i64_mul($15 | 0, i64toi32_i32$4 | 0, $24 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $287 = i64toi32_i32$0;
       $287$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $283$hi;
       i64toi32_i32$5 = i64toi32_i32$2;
       i64toi32_i32$0 = $287$hi;
       i64toi32_i32$3 = $287;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $288$hi = i64toi32_i32$2;
       i64toi32_i32$5 = $14;
       i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
       $290$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $23$hi;
       i64toi32_i32$2 = $290$hi;
       i64toi32_i32$5 = $23$hi;
       i64toi32_i32$5 = __wasm_i64_mul($14 | 0, i64toi32_i32$2 | 0, $23 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $292 = i64toi32_i32$5;
       $292$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $288$hi;
       i64toi32_i32$4 = i64toi32_i32$1;
       i64toi32_i32$5 = $292$hi;
       i64toi32_i32$3 = $292;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $293$hi = i64toi32_i32$1;
       i64toi32_i32$4 = $13;
       i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
       $295$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $22$hi;
       i64toi32_i32$1 = $295$hi;
       i64toi32_i32$4 = $22$hi;
       i64toi32_i32$4 = __wasm_i64_mul($13 | 0, i64toi32_i32$1 | 0, $22 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $297 = i64toi32_i32$4;
       $297$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $293$hi;
       i64toi32_i32$2 = i64toi32_i32$0;
       i64toi32_i32$4 = $297$hi;
       i64toi32_i32$3 = $297;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $298$hi = i64toi32_i32$0;
       i64toi32_i32$2 = $12;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $300$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $21$hi;
       i64toi32_i32$0 = $300$hi;
       i64toi32_i32$2 = $21$hi;
       i64toi32_i32$2 = __wasm_i64_mul($12 | 0, i64toi32_i32$0 | 0, $21 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $302 = i64toi32_i32$2;
       $302$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $298$hi;
       i64toi32_i32$1 = i64toi32_i32$5;
       i64toi32_i32$2 = $302$hi;
       i64toi32_i32$3 = $302;
       i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $303$hi = i64toi32_i32$5;
       i64toi32_i32$1 = $11;
       i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
       $305$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $20$hi;
       i64toi32_i32$5 = $305$hi;
       i64toi32_i32$1 = $20$hi;
       i64toi32_i32$1 = __wasm_i64_mul($11 | 0, i64toi32_i32$5 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $307 = i64toi32_i32$1;
       $307$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $303$hi;
       i64toi32_i32$0 = i64toi32_i32$4;
       i64toi32_i32$1 = $307$hi;
       i64toi32_i32$3 = $307;
       i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $308$hi = i64toi32_i32$4;
       i64toi32_i32$0 = $10;
       i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
       $310$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $19$hi;
       i64toi32_i32$4 = $310$hi;
       i64toi32_i32$0 = $19$hi;
       i64toi32_i32$0 = __wasm_i64_mul($10 | 0, i64toi32_i32$4 | 0, $19 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $312 = i64toi32_i32$0;
       $312$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $308$hi;
       i64toi32_i32$5 = i64toi32_i32$2;
       i64toi32_i32$0 = $312$hi;
       i64toi32_i32$3 = $312;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $313$hi = i64toi32_i32$2;
       i64toi32_i32$5 = $4;
       i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
       $315$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $18$hi;
       i64toi32_i32$2 = $315$hi;
       i64toi32_i32$5 = $18$hi;
       i64toi32_i32$5 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $18 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $317 = i64toi32_i32$5;
       $317$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $313$hi;
       i64toi32_i32$4 = i64toi32_i32$1;
       i64toi32_i32$5 = $317$hi;
       i64toi32_i32$3 = $317;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $318$hi = i64toi32_i32$1;
       i64toi32_i32$4 = $3;
       i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
       $320$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $17$hi;
       i64toi32_i32$1 = $320$hi;
       i64toi32_i32$4 = $17$hi;
       i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $322 = i64toi32_i32$4;
       $322$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $318$hi;
       i64toi32_i32$2 = i64toi32_i32$0;
       i64toi32_i32$4 = $322$hi;
       i64toi32_i32$3 = $322;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $323$hi = i64toi32_i32$0;
       i64toi32_i32$2 = $6;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $325$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $7$hi;
       i64toi32_i32$0 = $325$hi;
       i64toi32_i32$2 = $7$hi;
       i64toi32_i32$2 = __wasm_i64_mul($6 | 0, i64toi32_i32$0 | 0, $7 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $327 = i64toi32_i32$2;
       $327$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $323$hi;
       i64toi32_i32$1 = i64toi32_i32$5;
       i64toi32_i32$2 = $327$hi;
       i64toi32_i32$3 = $327;
       i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $328$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $8$hi;
       i64toi32_i32$5 = $328$hi;
       i64toi32_i32$0 = i64toi32_i32$4;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
        $582 = i64toi32_i32$5 >> i64toi32_i32$2 | 0;
       } else {
        i64toi32_i32$1 = i64toi32_i32$5 >> i64toi32_i32$2 | 0;
        $582 = (((1 << i64toi32_i32$2 | 0) - 1 | 0) & i64toi32_i32$5 | 0) << (32 - i64toi32_i32$2 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$2 | 0) | 0;
       }
       HEAP32[$264 >> 2] = $269 - $582 | 0;
       $28 = $9;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$8
       }
       break label$1;
      };
     }
     i64toi32_i32$1 = 0;
     $8 = $4;
     $8$hi = i64toi32_i32$1;
     label$9 : {
      if (($3 | 0) == (10 | 0)) {
       break label$9
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $15 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      $4 = HEAP32[($0 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($0 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($0 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($0 + -28 | 0) >> 2] | 0;
      $13 = HEAP32[($0 + -32 | 0) >> 2] | 0;
      $27 = HEAP32[($0 + -36 | 0) >> 2] | 0;
      i64toi32_i32$5 = $2;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $7 = i64toi32_i32$1;
      $7$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$5 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $17 = i64toi32_i32$0;
      $17$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 8 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$5 + 12 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $19 = i64toi32_i32$0;
      $19$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 16 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $20 = i64toi32_i32$1;
      $20$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$5 + 20 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $21 = i64toi32_i32$0;
      $21$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 24 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $22 = i64toi32_i32$1;
      $22$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$5 + 28 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $23 = i64toi32_i32$0;
      $23$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 32 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $24 = i64toi32_i32$1;
      $24$hi = i64toi32_i32$0;
      $2 = 0;
      label$10 : while (1) {
       $14 = $13;
       $13 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $4;
       $4 = $3;
       $3 = $6;
       $6 = $15;
       $15 = $2 << 2 | 0;
       $402 = $5 + $15 | 0;
       $15 = HEAP32[($0 + $15 | 0) >> 2] | 0;
       $407 = $15;
       i64toi32_i32$1 = $14;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $409$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $23$hi;
       i64toi32_i32$0 = $409$hi;
       i64toi32_i32$1 = $23$hi;
       i64toi32_i32$1 = __wasm_i64_mul($14 | 0, i64toi32_i32$0 | 0, $23 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $411 = i64toi32_i32$1;
       $411$hi = i64toi32_i32$0;
       i64toi32_i32$1 = $27;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $413$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $24$hi;
       i64toi32_i32$0 = $413$hi;
       i64toi32_i32$1 = $24$hi;
       i64toi32_i32$1 = __wasm_i64_mul($27 | 0, i64toi32_i32$0 | 0, $24 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $415 = i64toi32_i32$1;
       $415$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $411$hi;
       i64toi32_i32$5 = $411;
       i64toi32_i32$1 = $415$hi;
       i64toi32_i32$3 = $415;
       i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $416$hi = i64toi32_i32$4;
       i64toi32_i32$5 = $13;
       i64toi32_i32$4 = i64toi32_i32$5 >> 31 | 0;
       $418$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $22$hi;
       i64toi32_i32$4 = $418$hi;
       i64toi32_i32$5 = $22$hi;
       i64toi32_i32$5 = __wasm_i64_mul($13 | 0, i64toi32_i32$4 | 0, $22 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $420 = i64toi32_i32$5;
       $420$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $416$hi;
       i64toi32_i32$0 = i64toi32_i32$2;
       i64toi32_i32$5 = $420$hi;
       i64toi32_i32$3 = $420;
       i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $421$hi = i64toi32_i32$2;
       i64toi32_i32$0 = $12;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $423$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $21$hi;
       i64toi32_i32$2 = $423$hi;
       i64toi32_i32$0 = $21$hi;
       i64toi32_i32$0 = __wasm_i64_mul($12 | 0, i64toi32_i32$2 | 0, $21 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $425 = i64toi32_i32$0;
       $425$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $421$hi;
       i64toi32_i32$4 = i64toi32_i32$1;
       i64toi32_i32$0 = $425$hi;
       i64toi32_i32$3 = $425;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $426$hi = i64toi32_i32$1;
       i64toi32_i32$4 = $11;
       i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
       $428$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $20$hi;
       i64toi32_i32$1 = $428$hi;
       i64toi32_i32$4 = $20$hi;
       i64toi32_i32$4 = __wasm_i64_mul($11 | 0, i64toi32_i32$1 | 0, $20 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $430 = i64toi32_i32$4;
       $430$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $426$hi;
       i64toi32_i32$2 = i64toi32_i32$5;
       i64toi32_i32$4 = $430$hi;
       i64toi32_i32$3 = $430;
       i64toi32_i32$0 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $431$hi = i64toi32_i32$5;
       i64toi32_i32$2 = $10;
       i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
       $433$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $19$hi;
       i64toi32_i32$5 = $433$hi;
       i64toi32_i32$2 = $19$hi;
       i64toi32_i32$2 = __wasm_i64_mul($10 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $435 = i64toi32_i32$2;
       $435$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $431$hi;
       i64toi32_i32$1 = i64toi32_i32$0;
       i64toi32_i32$2 = $435$hi;
       i64toi32_i32$3 = $435;
       i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $436$hi = i64toi32_i32$0;
       i64toi32_i32$1 = $4;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $438$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $18$hi;
       i64toi32_i32$0 = $438$hi;
       i64toi32_i32$1 = $18$hi;
       i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$0 | 0, $18 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $440 = i64toi32_i32$1;
       $440$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $436$hi;
       i64toi32_i32$5 = i64toi32_i32$4;
       i64toi32_i32$1 = $440$hi;
       i64toi32_i32$3 = $440;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $441$hi = i64toi32_i32$4;
       i64toi32_i32$5 = $3;
       i64toi32_i32$4 = i64toi32_i32$5 >> 31 | 0;
       $443$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $17$hi;
       i64toi32_i32$4 = $443$hi;
       i64toi32_i32$5 = $17$hi;
       i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$4 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $445 = i64toi32_i32$5;
       $445$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $441$hi;
       i64toi32_i32$0 = i64toi32_i32$2;
       i64toi32_i32$5 = $445$hi;
       i64toi32_i32$3 = $445;
       i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $446$hi = i64toi32_i32$2;
       i64toi32_i32$0 = $6;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $448$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $7$hi;
       i64toi32_i32$2 = $448$hi;
       i64toi32_i32$0 = $7$hi;
       i64toi32_i32$0 = __wasm_i64_mul($6 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $450 = i64toi32_i32$0;
       $450$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $446$hi;
       i64toi32_i32$4 = i64toi32_i32$1;
       i64toi32_i32$0 = $450$hi;
       i64toi32_i32$3 = $450;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $451$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$1 = $451$hi;
       i64toi32_i32$2 = i64toi32_i32$5;
       i64toi32_i32$4 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
        $583 = i64toi32_i32$1 >> i64toi32_i32$0 | 0;
       } else {
        i64toi32_i32$4 = i64toi32_i32$1 >> i64toi32_i32$0 | 0;
        $583 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$0 | 0) | 0;
       }
       HEAP32[$402 >> 2] = $407 - $583 | 0;
       $27 = $14;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$10
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $27 = HEAP32[($0 + -4 | 0) >> 2] | 0;
     $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
     $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
     $4 = HEAP32[($0 + -16 | 0) >> 2] | 0;
     $10 = HEAP32[($0 + -20 | 0) >> 2] | 0;
     $11 = HEAP32[($0 + -24 | 0) >> 2] | 0;
     $12 = HEAP32[($0 + -28 | 0) >> 2] | 0;
     $13 = HEAP32[($0 + -32 | 0) >> 2] | 0;
     $14 = HEAP32[($0 + -36 | 0) >> 2] | 0;
     $9 = HEAP32[($0 + -40 | 0) >> 2] | 0;
     i64toi32_i32$1 = $2;
     i64toi32_i32$4 = HEAP32[i64toi32_i32$1 >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $7 = i64toi32_i32$4;
     $7$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $17 = i64toi32_i32$2;
     $17$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $18 = i64toi32_i32$4;
     $18$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $19 = i64toi32_i32$2;
     $19$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$1 + 16 | 0) >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $20 = i64toi32_i32$4;
     $20$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 20 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $21 = i64toi32_i32$2;
     $21$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$1 + 24 | 0) >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $22 = i64toi32_i32$4;
     $22$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 28 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $23 = i64toi32_i32$2;
     $23$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$1 + 32 | 0) >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $24 = i64toi32_i32$4;
     $24$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 36 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $25 = i64toi32_i32$2;
     $25$hi = i64toi32_i32$4;
     $2 = 0;
     label$11 : while (1) {
      $15 = $14;
      $14 = $13;
      $13 = $12;
      $12 = $11;
      $11 = $10;
      $10 = $4;
      $4 = $3;
      $3 = $6;
      $6 = $27;
      $27 = $2 << 2 | 0;
      $527 = $5 + $27 | 0;
      $27 = HEAP32[($0 + $27 | 0) >> 2] | 0;
      $532 = $27;
      i64toi32_i32$2 = $15;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $534$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $24$hi;
      i64toi32_i32$4 = $534$hi;
      i64toi32_i32$2 = $24$hi;
      i64toi32_i32$2 = __wasm_i64_mul($15 | 0, i64toi32_i32$4 | 0, $24 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $536 = i64toi32_i32$2;
      $536$hi = i64toi32_i32$4;
      i64toi32_i32$2 = $9;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $538$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $25$hi;
      i64toi32_i32$4 = $538$hi;
      i64toi32_i32$2 = $25$hi;
      i64toi32_i32$2 = __wasm_i64_mul($9 | 0, i64toi32_i32$4 | 0, $25 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $540 = i64toi32_i32$2;
      $540$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $536$hi;
      i64toi32_i32$1 = $536;
      i64toi32_i32$2 = $540$hi;
      i64toi32_i32$3 = $540;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $541$hi = i64toi32_i32$5;
      i64toi32_i32$1 = $14;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $543$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $23$hi;
      i64toi32_i32$5 = $543$hi;
      i64toi32_i32$1 = $23$hi;
      i64toi32_i32$1 = __wasm_i64_mul($14 | 0, i64toi32_i32$5 | 0, $23 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $545 = i64toi32_i32$1;
      $545$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $541$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$1 = $545$hi;
      i64toi32_i32$3 = $545;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $546$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $13;
      i64toi32_i32$0 = i64toi32_i32$4 >> 31 | 0;
      $548$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $22$hi;
      i64toi32_i32$0 = $548$hi;
      i64toi32_i32$4 = $22$hi;
      i64toi32_i32$4 = __wasm_i64_mul($13 | 0, i64toi32_i32$0 | 0, $22 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $550 = i64toi32_i32$4;
      $550$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $546$hi;
      i64toi32_i32$5 = i64toi32_i32$2;
      i64toi32_i32$4 = $550$hi;
      i64toi32_i32$3 = $550;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $551$hi = i64toi32_i32$2;
      i64toi32_i32$5 = $12;
      i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
      $553$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $21$hi;
      i64toi32_i32$2 = $553$hi;
      i64toi32_i32$5 = $21$hi;
      i64toi32_i32$5 = __wasm_i64_mul($12 | 0, i64toi32_i32$2 | 0, $21 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $555 = i64toi32_i32$5;
      $555$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $551$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$5 = $555$hi;
      i64toi32_i32$3 = $555;
      i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $556$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $11;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $558$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $20$hi;
      i64toi32_i32$1 = $558$hi;
      i64toi32_i32$0 = $20$hi;
      i64toi32_i32$0 = __wasm_i64_mul($11 | 0, i64toi32_i32$1 | 0, $20 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $560 = i64toi32_i32$0;
      $560$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $556$hi;
      i64toi32_i32$2 = i64toi32_i32$4;
      i64toi32_i32$0 = $560$hi;
      i64toi32_i32$3 = $560;
      i64toi32_i32$5 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $561$hi = i64toi32_i32$4;
      i64toi32_i32$2 = $10;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $563$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $19$hi;
      i64toi32_i32$4 = $563$hi;
      i64toi32_i32$2 = $19$hi;
      i64toi32_i32$2 = __wasm_i64_mul($10 | 0, i64toi32_i32$4 | 0, $19 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $565 = i64toi32_i32$2;
      $565$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $561$hi;
      i64toi32_i32$1 = i64toi32_i32$5;
      i64toi32_i32$2 = $565$hi;
      i64toi32_i32$3 = $565;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $566$hi = i64toi32_i32$5;
      i64toi32_i32$1 = $4;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $568$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $18$hi;
      i64toi32_i32$5 = $568$hi;
      i64toi32_i32$1 = $18$hi;
      i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$5 | 0, $18 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $570 = i64toi32_i32$1;
      $570$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $566$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$1 = $570$hi;
      i64toi32_i32$3 = $570;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $571$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $3;
      i64toi32_i32$0 = i64toi32_i32$4 >> 31 | 0;
      $573$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $17$hi;
      i64toi32_i32$0 = $573$hi;
      i64toi32_i32$4 = $17$hi;
      i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$0 | 0, $17 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $575 = i64toi32_i32$4;
      $575$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $571$hi;
      i64toi32_i32$5 = i64toi32_i32$2;
      i64toi32_i32$4 = $575$hi;
      i64toi32_i32$3 = $575;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $576$hi = i64toi32_i32$2;
      i64toi32_i32$5 = $6;
      i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
      $578$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $7$hi;
      i64toi32_i32$2 = $578$hi;
      i64toi32_i32$5 = $7$hi;
      i64toi32_i32$5 = __wasm_i64_mul($6 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $580 = i64toi32_i32$5;
      $580$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $576$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$5 = $580$hi;
      i64toi32_i32$3 = $580;
      i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $581$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$1 = $581$hi;
      i64toi32_i32$2 = i64toi32_i32$4;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $584 = i64toi32_i32$1 >> i64toi32_i32$5 | 0;
      } else {
       i64toi32_i32$0 = i64toi32_i32$1 >> i64toi32_i32$5 | 0;
       $584 = (((1 << i64toi32_i32$5 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$5 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$5 | 0) | 0;
      }
      HEAP32[$527 >> 2] = $532 - $584 | 0;
      $9 = $15;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue label$11
      }
      break label$1;
     };
    }
    label$12 : {
     if ($3 >>> 0 < 5 >>> 0) {
      break label$12
     }
     label$13 : {
      if ($3 >>> 0 < 7 >>> 0) {
       break label$13
      }
      i64toi32_i32$0 = 0;
      $8 = $4;
      $8$hi = i64toi32_i32$0;
      label$14 : {
       if (($3 | 0) == (8 | 0)) {
        break label$14
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $13 = HEAP32[($0 + -4 | 0) >> 2] | 0;
       $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
       $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
       $4 = HEAP32[($0 + -16 | 0) >> 2] | 0;
       $10 = HEAP32[($0 + -20 | 0) >> 2] | 0;
       $11 = HEAP32[($0 + -24 | 0) >> 2] | 0;
       $14 = HEAP32[($0 + -28 | 0) >> 2] | 0;
       i64toi32_i32$1 = $2;
       i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $7 = i64toi32_i32$0;
       $7$hi = i64toi32_i32$2;
       i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $17 = i64toi32_i32$2;
       $17$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] | 0;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $18 = i64toi32_i32$0;
       $18$hi = i64toi32_i32$2;
       i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $19 = i64toi32_i32$2;
       $19$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 16 | 0) >> 2] | 0;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $20 = i64toi32_i32$0;
       $20$hi = i64toi32_i32$2;
       i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 20 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $21 = i64toi32_i32$2;
       $21$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 24 | 0) >> 2] | 0;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $22 = i64toi32_i32$0;
       $22$hi = i64toi32_i32$2;
       $2 = 0;
       label$15 : while (1) {
        $12 = $11;
        $11 = $10;
        $10 = $4;
        $4 = $3;
        $3 = $6;
        $6 = $13;
        $13 = $2 << 2 | 0;
        $647 = $5 + $13 | 0;
        $13 = HEAP32[($0 + $13 | 0) >> 2] | 0;
        $652 = $13;
        i64toi32_i32$0 = $12;
        i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
        $654$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $21$hi;
        i64toi32_i32$2 = $654$hi;
        i64toi32_i32$0 = $21$hi;
        i64toi32_i32$0 = __wasm_i64_mul($12 | 0, i64toi32_i32$2 | 0, $21 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $656 = i64toi32_i32$0;
        $656$hi = i64toi32_i32$2;
        i64toi32_i32$0 = $14;
        i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
        $658$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $22$hi;
        i64toi32_i32$2 = $658$hi;
        i64toi32_i32$0 = $22$hi;
        i64toi32_i32$0 = __wasm_i64_mul($14 | 0, i64toi32_i32$2 | 0, $22 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $660 = i64toi32_i32$0;
        $660$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $656$hi;
        i64toi32_i32$1 = $656;
        i64toi32_i32$0 = $660$hi;
        i64toi32_i32$3 = $660;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
        if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
        }
        $661$hi = i64toi32_i32$4;
        i64toi32_i32$1 = $11;
        i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
        $663$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $20$hi;
        i64toi32_i32$4 = $663$hi;
        i64toi32_i32$1 = $20$hi;
        i64toi32_i32$1 = __wasm_i64_mul($11 | 0, i64toi32_i32$4 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
        i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
        $665 = i64toi32_i32$1;
        $665$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $661$hi;
        i64toi32_i32$2 = i64toi32_i32$5;
        i64toi32_i32$1 = $665$hi;
        i64toi32_i32$3 = $665;
        i64toi32_i32$0 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
        if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
        }
        $666$hi = i64toi32_i32$5;
        i64toi32_i32$2 = $10;
        i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
        $668$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $19$hi;
        i64toi32_i32$5 = $668$hi;
        i64toi32_i32$2 = $19$hi;
        i64toi32_i32$2 = __wasm_i64_mul($10 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$2 | 0) | 0;
        i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
        $670 = i64toi32_i32$2;
        $670$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $666$hi;
        i64toi32_i32$4 = i64toi32_i32$0;
        i64toi32_i32$2 = $670$hi;
        i64toi32_i32$3 = $670;
        i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
        i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
        if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
        }
        $671$hi = i64toi32_i32$0;
        i64toi32_i32$4 = $4;
        i64toi32_i32$0 = i64toi32_i32$4 >> 31 | 0;
        $673$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $18$hi;
        i64toi32_i32$0 = $673$hi;
        i64toi32_i32$4 = $18$hi;
        i64toi32_i32$4 = __wasm_i64_mul($4 | 0, i64toi32_i32$0 | 0, $18 | 0, i64toi32_i32$4 | 0) | 0;
        i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
        $675 = i64toi32_i32$4;
        $675$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $671$hi;
        i64toi32_i32$5 = i64toi32_i32$1;
        i64toi32_i32$4 = $675$hi;
        i64toi32_i32$3 = $675;
        i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$4 | 0;
        if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
        }
        $676$hi = i64toi32_i32$1;
        i64toi32_i32$5 = $3;
        i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
        $678$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $17$hi;
        i64toi32_i32$1 = $678$hi;
        i64toi32_i32$5 = $17$hi;
        i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
        i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
        $680 = i64toi32_i32$5;
        $680$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $676$hi;
        i64toi32_i32$0 = i64toi32_i32$2;
        i64toi32_i32$5 = $680$hi;
        i64toi32_i32$3 = $680;
        i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
        i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
        if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
        }
        $681$hi = i64toi32_i32$2;
        i64toi32_i32$0 = $6;
        i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
        $683$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $7$hi;
        i64toi32_i32$2 = $683$hi;
        i64toi32_i32$0 = $7$hi;
        i64toi32_i32$0 = __wasm_i64_mul($6 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $685 = i64toi32_i32$0;
        $685$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $681$hi;
        i64toi32_i32$1 = i64toi32_i32$4;
        i64toi32_i32$0 = $685$hi;
        i64toi32_i32$3 = $685;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
        if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
        }
        $686$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $8$hi;
        i64toi32_i32$4 = $686$hi;
        i64toi32_i32$2 = i64toi32_i32$5;
        i64toi32_i32$1 = $8$hi;
        i64toi32_i32$3 = $8;
        i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
        if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
         i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
         $585 = i64toi32_i32$4 >> i64toi32_i32$0 | 0;
        } else {
         i64toi32_i32$1 = i64toi32_i32$4 >> i64toi32_i32$0 | 0;
         $585 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$4 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$0 | 0) | 0;
        }
        HEAP32[$647 >> 2] = $652 - $585 | 0;
        $14 = $12;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue label$15
        }
        break label$1;
       };
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $14 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      $4 = HEAP32[($0 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($0 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($0 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($0 + -28 | 0) >> 2] | 0;
      $15 = HEAP32[($0 + -32 | 0) >> 2] | 0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$1 >> 31 | 0;
      $7 = i64toi32_i32$1;
      $7$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$4 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $17 = i64toi32_i32$2;
      $17$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$4 + 8 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$4 + 12 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $19 = i64toi32_i32$2;
      $19$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$4 + 16 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$1 >> 31 | 0;
      $20 = i64toi32_i32$1;
      $20$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$4 + 20 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $21 = i64toi32_i32$2;
      $21$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$4 + 24 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$1 >> 31 | 0;
      $22 = i64toi32_i32$1;
      $22$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$4 + 28 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $23 = i64toi32_i32$2;
      $23$hi = i64toi32_i32$1;
      $2 = 0;
      label$16 : while (1) {
       $13 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $4;
       $4 = $3;
       $3 = $6;
       $6 = $14;
       $14 = $2 << 2 | 0;
       $750 = $5 + $14 | 0;
       $14 = HEAP32[($0 + $14 | 0) >> 2] | 0;
       $755 = $14;
       i64toi32_i32$2 = $13;
       i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
       $757$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $22$hi;
       i64toi32_i32$1 = $757$hi;
       i64toi32_i32$2 = $22$hi;
       i64toi32_i32$2 = __wasm_i64_mul($13 | 0, i64toi32_i32$1 | 0, $22 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $759 = i64toi32_i32$2;
       $759$hi = i64toi32_i32$1;
       i64toi32_i32$2 = $15;
       i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
       $761$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $23$hi;
       i64toi32_i32$1 = $761$hi;
       i64toi32_i32$2 = $23$hi;
       i64toi32_i32$2 = __wasm_i64_mul($15 | 0, i64toi32_i32$1 | 0, $23 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $763 = i64toi32_i32$2;
       $763$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $759$hi;
       i64toi32_i32$4 = $759;
       i64toi32_i32$2 = $763$hi;
       i64toi32_i32$3 = $763;
       i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $764$hi = i64toi32_i32$5;
       i64toi32_i32$4 = $12;
       i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
       $766$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $21$hi;
       i64toi32_i32$5 = $766$hi;
       i64toi32_i32$4 = $21$hi;
       i64toi32_i32$4 = __wasm_i64_mul($12 | 0, i64toi32_i32$5 | 0, $21 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $768 = i64toi32_i32$4;
       $768$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $764$hi;
       i64toi32_i32$1 = i64toi32_i32$0;
       i64toi32_i32$4 = $768$hi;
       i64toi32_i32$3 = $768;
       i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $769$hi = i64toi32_i32$0;
       i64toi32_i32$1 = $11;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $771$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $20$hi;
       i64toi32_i32$0 = $771$hi;
       i64toi32_i32$1 = $20$hi;
       i64toi32_i32$1 = __wasm_i64_mul($11 | 0, i64toi32_i32$0 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $773 = i64toi32_i32$1;
       $773$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $769$hi;
       i64toi32_i32$5 = i64toi32_i32$2;
       i64toi32_i32$1 = $773$hi;
       i64toi32_i32$3 = $773;
       i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $774$hi = i64toi32_i32$2;
       i64toi32_i32$5 = $10;
       i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
       $776$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $19$hi;
       i64toi32_i32$2 = $776$hi;
       i64toi32_i32$5 = $19$hi;
       i64toi32_i32$5 = __wasm_i64_mul($10 | 0, i64toi32_i32$2 | 0, $19 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $778 = i64toi32_i32$5;
       $778$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $774$hi;
       i64toi32_i32$0 = i64toi32_i32$4;
       i64toi32_i32$5 = $778$hi;
       i64toi32_i32$3 = $778;
       i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $779$hi = i64toi32_i32$4;
       i64toi32_i32$0 = $4;
       i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
       $781$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $18$hi;
       i64toi32_i32$4 = $781$hi;
       i64toi32_i32$0 = $18$hi;
       i64toi32_i32$0 = __wasm_i64_mul($4 | 0, i64toi32_i32$4 | 0, $18 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $783 = i64toi32_i32$0;
       $783$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $779$hi;
       i64toi32_i32$2 = i64toi32_i32$1;
       i64toi32_i32$0 = $783$hi;
       i64toi32_i32$3 = $783;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $784$hi = i64toi32_i32$1;
       i64toi32_i32$2 = $3;
       i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
       $786$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $17$hi;
       i64toi32_i32$1 = $786$hi;
       i64toi32_i32$2 = $17$hi;
       i64toi32_i32$2 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $788 = i64toi32_i32$2;
       $788$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $784$hi;
       i64toi32_i32$4 = i64toi32_i32$5;
       i64toi32_i32$2 = $788$hi;
       i64toi32_i32$3 = $788;
       i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $789$hi = i64toi32_i32$5;
       i64toi32_i32$4 = $6;
       i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
       $791$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $7$hi;
       i64toi32_i32$5 = $791$hi;
       i64toi32_i32$4 = $7$hi;
       i64toi32_i32$4 = __wasm_i64_mul($6 | 0, i64toi32_i32$5 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $793 = i64toi32_i32$4;
       $793$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $789$hi;
       i64toi32_i32$1 = i64toi32_i32$0;
       i64toi32_i32$4 = $793$hi;
       i64toi32_i32$3 = $793;
       i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $794$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $8$hi;
       i64toi32_i32$0 = $794$hi;
       i64toi32_i32$5 = i64toi32_i32$2;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
        $586 = i64toi32_i32$0 >> i64toi32_i32$4 | 0;
       } else {
        i64toi32_i32$1 = i64toi32_i32$0 >> i64toi32_i32$4 | 0;
        $586 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$5 >>> i64toi32_i32$4 | 0) | 0;
       }
       HEAP32[$750 >> 2] = $755 - $586 | 0;
       $15 = $13;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$16
       }
       break label$1;
      };
     }
     i64toi32_i32$1 = 0;
     $8 = $4;
     $8$hi = i64toi32_i32$1;
     label$17 : {
      if (($3 | 0) == (6 | 0)) {
       break label$17
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $11 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      $4 = HEAP32[($0 + -16 | 0) >> 2] | 0;
      $12 = HEAP32[($0 + -20 | 0) >> 2] | 0;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $7 = i64toi32_i32$1;
      $7$hi = i64toi32_i32$5;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $17 = i64toi32_i32$5;
      $17$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 8 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$5;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$0 + 12 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $19 = i64toi32_i32$5;
      $19$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 16 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $20 = i64toi32_i32$1;
      $20$hi = i64toi32_i32$5;
      $2 = 0;
      label$18 : while (1) {
       $10 = $4;
       $4 = $3;
       $3 = $6;
       $6 = $11;
       $11 = $2 << 2 | 0;
       $844 = $5 + $11 | 0;
       $11 = HEAP32[($0 + $11 | 0) >> 2] | 0;
       $849 = $11;
       i64toi32_i32$1 = $10;
       i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
       $851$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $19$hi;
       i64toi32_i32$5 = $851$hi;
       i64toi32_i32$1 = $19$hi;
       i64toi32_i32$1 = __wasm_i64_mul($10 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $853 = i64toi32_i32$1;
       $853$hi = i64toi32_i32$5;
       i64toi32_i32$1 = $12;
       i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
       $855$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $20$hi;
       i64toi32_i32$5 = $855$hi;
       i64toi32_i32$1 = $20$hi;
       i64toi32_i32$1 = __wasm_i64_mul($12 | 0, i64toi32_i32$5 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $857 = i64toi32_i32$1;
       $857$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $853$hi;
       i64toi32_i32$0 = $853;
       i64toi32_i32$1 = $857$hi;
       i64toi32_i32$3 = $857;
       i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $858$hi = i64toi32_i32$2;
       i64toi32_i32$0 = $4;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $860$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $18$hi;
       i64toi32_i32$2 = $860$hi;
       i64toi32_i32$0 = $18$hi;
       i64toi32_i32$0 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $18 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $862 = i64toi32_i32$0;
       $862$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $858$hi;
       i64toi32_i32$5 = i64toi32_i32$4;
       i64toi32_i32$0 = $862$hi;
       i64toi32_i32$3 = $862;
       i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $863$hi = i64toi32_i32$4;
       i64toi32_i32$5 = $3;
       i64toi32_i32$4 = i64toi32_i32$5 >> 31 | 0;
       $865$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $17$hi;
       i64toi32_i32$4 = $865$hi;
       i64toi32_i32$5 = $17$hi;
       i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$4 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $867 = i64toi32_i32$5;
       $867$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $863$hi;
       i64toi32_i32$2 = i64toi32_i32$1;
       i64toi32_i32$5 = $867$hi;
       i64toi32_i32$3 = $867;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $868$hi = i64toi32_i32$1;
       i64toi32_i32$2 = $6;
       i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
       $870$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $7$hi;
       i64toi32_i32$1 = $870$hi;
       i64toi32_i32$2 = $7$hi;
       i64toi32_i32$2 = __wasm_i64_mul($6 | 0, i64toi32_i32$1 | 0, $7 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $872 = i64toi32_i32$2;
       $872$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $868$hi;
       i64toi32_i32$4 = i64toi32_i32$0;
       i64toi32_i32$2 = $872$hi;
       i64toi32_i32$3 = $872;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $873$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $8$hi;
       i64toi32_i32$0 = $873$hi;
       i64toi32_i32$1 = i64toi32_i32$5;
       i64toi32_i32$4 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
        $587 = i64toi32_i32$0 >> i64toi32_i32$2 | 0;
       } else {
        i64toi32_i32$4 = i64toi32_i32$0 >> i64toi32_i32$2 | 0;
        $587 = (((1 << i64toi32_i32$2 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$2 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$2 | 0) | 0;
       }
       HEAP32[$844 >> 2] = $849 - $587 | 0;
       $12 = $10;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$18
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $12 = HEAP32[($0 + -4 | 0) >> 2] | 0;
     $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
     $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
     $4 = HEAP32[($0 + -16 | 0) >> 2] | 0;
     $10 = HEAP32[($0 + -20 | 0) >> 2] | 0;
     $13 = HEAP32[($0 + -24 | 0) >> 2] | 0;
     i64toi32_i32$0 = $2;
     i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
     i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
     $7 = i64toi32_i32$4;
     $7$hi = i64toi32_i32$1;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
     $17 = i64toi32_i32$1;
     $17$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$0 + 8 | 0) >> 2] | 0;
     i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
     $18 = i64toi32_i32$4;
     $18$hi = i64toi32_i32$1;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 12 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
     $19 = i64toi32_i32$1;
     $19$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$0 + 16 | 0) >> 2] | 0;
     i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
     $20 = i64toi32_i32$4;
     $20$hi = i64toi32_i32$1;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 20 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
     $21 = i64toi32_i32$1;
     $21$hi = i64toi32_i32$4;
     $2 = 0;
     label$19 : while (1) {
      $11 = $10;
      $10 = $4;
      $4 = $3;
      $3 = $6;
      $6 = $12;
      $12 = $2 << 2 | 0;
      $925 = $5 + $12 | 0;
      $12 = HEAP32[($0 + $12 | 0) >> 2] | 0;
      $930 = $12;
      i64toi32_i32$1 = $11;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $932$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $20$hi;
      i64toi32_i32$4 = $932$hi;
      i64toi32_i32$1 = $20$hi;
      i64toi32_i32$1 = __wasm_i64_mul($11 | 0, i64toi32_i32$4 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $934 = i64toi32_i32$1;
      $934$hi = i64toi32_i32$4;
      i64toi32_i32$1 = $13;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $936$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $21$hi;
      i64toi32_i32$4 = $936$hi;
      i64toi32_i32$1 = $21$hi;
      i64toi32_i32$1 = __wasm_i64_mul($13 | 0, i64toi32_i32$4 | 0, $21 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $938 = i64toi32_i32$1;
      $938$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $934$hi;
      i64toi32_i32$0 = $934;
      i64toi32_i32$1 = $938$hi;
      i64toi32_i32$3 = $938;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $939$hi = i64toi32_i32$5;
      i64toi32_i32$0 = $10;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $941$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $19$hi;
      i64toi32_i32$5 = $941$hi;
      i64toi32_i32$0 = $19$hi;
      i64toi32_i32$0 = __wasm_i64_mul($10 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $943 = i64toi32_i32$0;
      $943$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $939$hi;
      i64toi32_i32$4 = i64toi32_i32$2;
      i64toi32_i32$0 = $943$hi;
      i64toi32_i32$3 = $943;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $944$hi = i64toi32_i32$2;
      i64toi32_i32$4 = $4;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $946$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $18$hi;
      i64toi32_i32$2 = $946$hi;
      i64toi32_i32$4 = $18$hi;
      i64toi32_i32$4 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $18 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $948 = i64toi32_i32$4;
      $948$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $944$hi;
      i64toi32_i32$5 = i64toi32_i32$1;
      i64toi32_i32$4 = $948$hi;
      i64toi32_i32$3 = $948;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $949$hi = i64toi32_i32$1;
      i64toi32_i32$5 = $3;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $951$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $17$hi;
      i64toi32_i32$1 = $951$hi;
      i64toi32_i32$5 = $17$hi;
      i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $953 = i64toi32_i32$5;
      $953$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $949$hi;
      i64toi32_i32$2 = i64toi32_i32$0;
      i64toi32_i32$5 = $953$hi;
      i64toi32_i32$3 = $953;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $954$hi = i64toi32_i32$0;
      i64toi32_i32$2 = $6;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $956$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $7$hi;
      i64toi32_i32$0 = $956$hi;
      i64toi32_i32$2 = $7$hi;
      i64toi32_i32$2 = __wasm_i64_mul($6 | 0, i64toi32_i32$0 | 0, $7 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $958 = i64toi32_i32$2;
      $958$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $954$hi;
      i64toi32_i32$1 = i64toi32_i32$4;
      i64toi32_i32$2 = $958$hi;
      i64toi32_i32$3 = $958;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $959$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $959$hi;
      i64toi32_i32$0 = i64toi32_i32$5;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
       $588 = i64toi32_i32$4 >> i64toi32_i32$2 | 0;
      } else {
       i64toi32_i32$1 = i64toi32_i32$4 >> i64toi32_i32$2 | 0;
       $588 = (((1 << i64toi32_i32$2 | 0) - 1 | 0) & i64toi32_i32$4 | 0) << (32 - i64toi32_i32$2 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$2 | 0) | 0;
      }
      HEAP32[$925 >> 2] = $930 - $588 | 0;
      $13 = $11;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue label$19
      }
      break label$1;
     };
    }
    label$20 : {
     if ($3 >>> 0 < 3 >>> 0) {
      break label$20
     }
     i64toi32_i32$1 = 0;
     $8 = $4;
     $8$hi = i64toi32_i32$1;
     label$21 : {
      if (($3 | 0) == (4 | 0)) {
       break label$21
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $4 = HEAP32[($0 + -4 | 0) >> 2] | 0;
      $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
      $10 = HEAP32[($0 + -12 | 0) >> 2] | 0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $7 = i64toi32_i32$1;
      $7$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $17 = i64toi32_i32$0;
      $17$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$4 + 8 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$0;
      $2 = 0;
      label$22 : while (1) {
       $3 = $6;
       $6 = $4;
       $4 = $2 << 2 | 0;
       $999 = $5 + $4 | 0;
       $4 = HEAP32[($0 + $4 | 0) >> 2] | 0;
       $1004 = $4;
       i64toi32_i32$1 = $3;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $1006$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $17$hi;
       i64toi32_i32$0 = $1006$hi;
       i64toi32_i32$1 = $17$hi;
       i64toi32_i32$1 = __wasm_i64_mul($3 | 0, i64toi32_i32$0 | 0, $17 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $1008 = i64toi32_i32$1;
       $1008$hi = i64toi32_i32$0;
       i64toi32_i32$1 = $10;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $1010$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $18$hi;
       i64toi32_i32$0 = $1010$hi;
       i64toi32_i32$1 = $18$hi;
       i64toi32_i32$1 = __wasm_i64_mul($10 | 0, i64toi32_i32$0 | 0, $18 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $1012 = i64toi32_i32$1;
       $1012$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $1008$hi;
       i64toi32_i32$4 = $1008;
       i64toi32_i32$1 = $1012$hi;
       i64toi32_i32$3 = $1012;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $1013$hi = i64toi32_i32$5;
       i64toi32_i32$4 = $6;
       i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
       $1015$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $7$hi;
       i64toi32_i32$5 = $1015$hi;
       i64toi32_i32$4 = $7$hi;
       i64toi32_i32$4 = __wasm_i64_mul($6 | 0, i64toi32_i32$5 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $1017 = i64toi32_i32$4;
       $1017$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $1013$hi;
       i64toi32_i32$0 = i64toi32_i32$2;
       i64toi32_i32$4 = $1017$hi;
       i64toi32_i32$3 = $1017;
       i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $1018$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $8$hi;
       i64toi32_i32$2 = $1018$hi;
       i64toi32_i32$5 = i64toi32_i32$1;
       i64toi32_i32$0 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
        $589 = i64toi32_i32$2 >> i64toi32_i32$4 | 0;
       } else {
        i64toi32_i32$0 = i64toi32_i32$2 >> i64toi32_i32$4 | 0;
        $589 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$5 >>> i64toi32_i32$4 | 0) | 0;
       }
       HEAP32[$999 >> 2] = $1004 - $589 | 0;
       $10 = $3;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$22
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $10 = HEAP32[($0 + -4 | 0) >> 2] | 0;
     $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
     $3 = HEAP32[($0 + -12 | 0) >> 2] | 0;
     $11 = HEAP32[($0 + -16 | 0) >> 2] | 0;
     i64toi32_i32$2 = $2;
     i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
     i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
     $7 = i64toi32_i32$0;
     $7$hi = i64toi32_i32$5;
     i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
     i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
     $17 = i64toi32_i32$5;
     $17$hi = i64toi32_i32$0;
     i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 8 | 0) >> 2] | 0;
     i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
     $18 = i64toi32_i32$0;
     $18$hi = i64toi32_i32$5;
     i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 12 | 0) >> 2] | 0;
     i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
     $19 = i64toi32_i32$5;
     $19$hi = i64toi32_i32$0;
     $2 = 0;
     label$23 : while (1) {
      $4 = $3;
      $3 = $6;
      $6 = $10;
      $10 = $2 << 2 | 0;
      $1058 = $5 + $10 | 0;
      $10 = HEAP32[($0 + $10 | 0) >> 2] | 0;
      $1063 = $10;
      i64toi32_i32$5 = $4;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1065$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $18$hi;
      i64toi32_i32$0 = $1065$hi;
      i64toi32_i32$5 = $18$hi;
      i64toi32_i32$5 = __wasm_i64_mul($4 | 0, i64toi32_i32$0 | 0, $18 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1067 = i64toi32_i32$5;
      $1067$hi = i64toi32_i32$0;
      i64toi32_i32$5 = $11;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1069$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $19$hi;
      i64toi32_i32$0 = $1069$hi;
      i64toi32_i32$5 = $19$hi;
      i64toi32_i32$5 = __wasm_i64_mul($11 | 0, i64toi32_i32$0 | 0, $19 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1071 = i64toi32_i32$5;
      $1071$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1067$hi;
      i64toi32_i32$2 = $1067;
      i64toi32_i32$5 = $1071$hi;
      i64toi32_i32$3 = $1071;
      i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $1072$hi = i64toi32_i32$1;
      i64toi32_i32$2 = $3;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $1074$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $17$hi;
      i64toi32_i32$1 = $1074$hi;
      i64toi32_i32$2 = $17$hi;
      i64toi32_i32$2 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1076 = i64toi32_i32$2;
      $1076$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1072$hi;
      i64toi32_i32$0 = i64toi32_i32$4;
      i64toi32_i32$2 = $1076$hi;
      i64toi32_i32$3 = $1076;
      i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $1077$hi = i64toi32_i32$4;
      i64toi32_i32$0 = $6;
      i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
      $1079$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $7$hi;
      i64toi32_i32$4 = $1079$hi;
      i64toi32_i32$0 = $7$hi;
      i64toi32_i32$0 = __wasm_i64_mul($6 | 0, i64toi32_i32$4 | 0, $7 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1081 = i64toi32_i32$0;
      $1081$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1077$hi;
      i64toi32_i32$1 = i64toi32_i32$5;
      i64toi32_i32$0 = $1081$hi;
      i64toi32_i32$3 = $1081;
      i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $1082$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1082$hi;
      i64toi32_i32$4 = i64toi32_i32$2;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
       $590 = i64toi32_i32$5 >> i64toi32_i32$0 | 0;
      } else {
       i64toi32_i32$1 = i64toi32_i32$5 >> i64toi32_i32$0 | 0;
       $590 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$5 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$4 >>> i64toi32_i32$0 | 0) | 0;
      }
      HEAP32[$1058 >> 2] = $1063 - $590 | 0;
      $11 = $4;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue label$23
      }
      break label$1;
     };
    }
    i64toi32_i32$1 = 0;
    $8 = $4;
    $8$hi = i64toi32_i32$1;
    label$24 : {
     if (($3 | 0) == (2 | 0)) {
      break label$24
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $10 = $1 & 1 | 0;
     $3 = HEAP32[($0 + -4 | 0) >> 2] | 0;
     i64toi32_i32$5 = $2;
     i64toi32_i32$1 = HEAP32[i64toi32_i32$5 >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
     $7 = i64toi32_i32$1;
     $7$hi = i64toi32_i32$4;
     $2 = 0;
     label$25 : {
      if (($1 | 0) == (1 | 0)) {
       break label$25
      }
      $1 = $1 & -2 | 0;
      $2 = 0;
      label$26 : while (1) {
       $6 = $2 << 2 | 0;
       $1114 = $5 + $6 | 0;
       $4 = HEAP32[($0 + $6 | 0) >> 2] | 0;
       $1119 = $4;
       i64toi32_i32$1 = $3;
       i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
       $1121$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $7$hi;
       i64toi32_i32$4 = $1121$hi;
       i64toi32_i32$1 = $7$hi;
       i64toi32_i32$1 = __wasm_i64_mul($3 | 0, i64toi32_i32$4 | 0, $7 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $1123$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $8$hi;
       i64toi32_i32$4 = $1123$hi;
       i64toi32_i32$5 = i64toi32_i32$1;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
        $591 = i64toi32_i32$4 >> i64toi32_i32$0 | 0;
       } else {
        i64toi32_i32$1 = i64toi32_i32$4 >> i64toi32_i32$0 | 0;
        $591 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$4 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$5 >>> i64toi32_i32$0 | 0) | 0;
       }
       HEAP32[$1114 >> 2] = $1119 - $591 | 0;
       $6 = $6 | 4 | 0;
       $1132 = $5 + $6 | 0;
       $3 = HEAP32[($0 + $6 | 0) >> 2] | 0;
       $1137 = $3;
       i64toi32_i32$5 = $4;
       i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
       $1139$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $7$hi;
       i64toi32_i32$1 = $1139$hi;
       i64toi32_i32$5 = $7$hi;
       i64toi32_i32$5 = __wasm_i64_mul($4 | 0, i64toi32_i32$1 | 0, $7 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $1141$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$1 = $1141$hi;
       i64toi32_i32$4 = i64toi32_i32$5;
       i64toi32_i32$5 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
        $592 = i64toi32_i32$1 >> i64toi32_i32$0 | 0;
       } else {
        i64toi32_i32$5 = i64toi32_i32$1 >> i64toi32_i32$0 | 0;
        $592 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$4 >>> i64toi32_i32$0 | 0) | 0;
       }
       HEAP32[$1132 >> 2] = $1137 - $592 | 0;
       $2 = $2 + 2 | 0;
       $1 = $1 + -2 | 0;
       if ($1) {
        continue label$26
       }
       break label$26;
      };
     }
     if (!$10) {
      break label$1
     }
     $2 = $2 << 2 | 0;
     $1157 = $5 + $2 | 0;
     $1161 = HEAP32[($0 + $2 | 0) >> 2] | 0;
     i64toi32_i32$4 = $3;
     i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
     $1163$hi = i64toi32_i32$5;
     i64toi32_i32$5 = $7$hi;
     i64toi32_i32$5 = $1163$hi;
     i64toi32_i32$4 = $7$hi;
     i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$5 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
     i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
     $1165$hi = i64toi32_i32$5;
     i64toi32_i32$5 = $8$hi;
     i64toi32_i32$5 = $1165$hi;
     i64toi32_i32$1 = i64toi32_i32$4;
     i64toi32_i32$4 = $8$hi;
     i64toi32_i32$3 = $8;
     i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
     if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
      i64toi32_i32$4 = i64toi32_i32$5 >> 31 | 0;
      $593 = i64toi32_i32$5 >> i64toi32_i32$0 | 0;
     } else {
      i64toi32_i32$4 = i64toi32_i32$5 >> i64toi32_i32$0 | 0;
      $593 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$5 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$0 | 0) | 0;
     }
     HEAP32[$1157 >> 2] = $1161 - $593 | 0;
     break label$1;
    }
    if (($1 | 0) < (1 | 0)) {
     break label$1
    }
    $10 = $1 & 1 | 0;
    $4 = HEAP32[($0 + -4 | 0) >> 2] | 0;
    $6 = HEAP32[($0 + -8 | 0) >> 2] | 0;
    i64toi32_i32$5 = $2;
    i64toi32_i32$4 = HEAP32[i64toi32_i32$5 >> 2] | 0;
    i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
    $7 = i64toi32_i32$4;
    $7$hi = i64toi32_i32$1;
    i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 4 | 0) >> 2] | 0;
    i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
    $17 = i64toi32_i32$1;
    $17$hi = i64toi32_i32$4;
    $2 = 0;
    label$27 : {
     if (($1 | 0) == (1 | 0)) {
      break label$27
     }
     $1 = $1 & -2 | 0;
     $2 = 0;
     label$28 : while (1) {
      i64toi32_i32$1 = $6;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$4;
      $3 = $2 << 2 | 0;
      $1194 = $5 + $3 | 0;
      $6 = HEAP32[($0 + $3 | 0) >> 2] | 0;
      $1199 = $6;
      i64toi32_i32$1 = $4;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $19 = i64toi32_i32$1;
      $19$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $7$hi;
      i64toi32_i32$4 = $19$hi;
      i64toi32_i32$1 = $7$hi;
      i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$4 | 0, $7 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1204 = i64toi32_i32$1;
      $1204$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $18$hi;
      i64toi32_i32$4 = $17$hi;
      i64toi32_i32$4 = $18$hi;
      i64toi32_i32$1 = $17$hi;
      i64toi32_i32$1 = __wasm_i64_mul($18 | 0, i64toi32_i32$4 | 0, $17 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1207 = i64toi32_i32$1;
      $1207$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1204$hi;
      i64toi32_i32$5 = $1204;
      i64toi32_i32$1 = $1207$hi;
      i64toi32_i32$3 = $1207;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $1208$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1208$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
       $594 = i64toi32_i32$2 >> i64toi32_i32$1 | 0;
      } else {
       i64toi32_i32$5 = i64toi32_i32$2 >> i64toi32_i32$1 | 0;
       $594 = (((1 << i64toi32_i32$1 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$1 | 0) | 0 | (i64toi32_i32$4 >>> i64toi32_i32$1 | 0) | 0;
      }
      HEAP32[$1194 >> 2] = $1199 - $594 | 0;
      $3 = $3 | 4 | 0;
      $1217 = $5 + $3 | 0;
      $4 = HEAP32[($0 + $3 | 0) >> 2] | 0;
      $1222 = $4;
      i64toi32_i32$4 = $6;
      i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
      $1224$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $7$hi;
      i64toi32_i32$5 = $1224$hi;
      i64toi32_i32$4 = $7$hi;
      i64toi32_i32$4 = __wasm_i64_mul($6 | 0, i64toi32_i32$5 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1226 = i64toi32_i32$4;
      $1226$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $19$hi;
      i64toi32_i32$5 = $17$hi;
      i64toi32_i32$5 = $19$hi;
      i64toi32_i32$4 = $17$hi;
      i64toi32_i32$4 = __wasm_i64_mul($19 | 0, i64toi32_i32$5 | 0, $17 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1229 = i64toi32_i32$4;
      $1229$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1226$hi;
      i64toi32_i32$2 = $1226;
      i64toi32_i32$4 = $1229$hi;
      i64toi32_i32$3 = $1229;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $1230$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1230$hi;
      i64toi32_i32$5 = i64toi32_i32$1;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $595 = i64toi32_i32$0 >> i64toi32_i32$4 | 0;
      } else {
       i64toi32_i32$2 = i64toi32_i32$0 >> i64toi32_i32$4 | 0;
       $595 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$5 >>> i64toi32_i32$4 | 0) | 0;
      }
      HEAP32[$1217 >> 2] = $1222 - $595 | 0;
      $2 = $2 + 2 | 0;
      $1 = $1 + -2 | 0;
      if ($1) {
       continue label$28
      }
      break label$28;
     };
    }
    if (!$10) {
     break label$1
    }
    $2 = $2 << 2 | 0;
    $1246 = $5 + $2 | 0;
    $1250 = HEAP32[($0 + $2 | 0) >> 2] | 0;
    i64toi32_i32$5 = $4;
    i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
    $1252$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $7$hi;
    i64toi32_i32$2 = $1252$hi;
    i64toi32_i32$5 = $7$hi;
    i64toi32_i32$5 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$5 | 0) | 0;
    i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
    $1254 = i64toi32_i32$5;
    $1254$hi = i64toi32_i32$2;
    i64toi32_i32$5 = $6;
    i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
    $1256$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $17$hi;
    i64toi32_i32$2 = $1256$hi;
    i64toi32_i32$5 = $17$hi;
    i64toi32_i32$5 = __wasm_i64_mul($6 | 0, i64toi32_i32$2 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
    i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
    $1258 = i64toi32_i32$5;
    $1258$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $1254$hi;
    i64toi32_i32$0 = $1254;
    i64toi32_i32$5 = $1258$hi;
    i64toi32_i32$3 = $1258;
    i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
    i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
    if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
    }
    $1259$hi = i64toi32_i32$1;
    i64toi32_i32$1 = $8$hi;
    i64toi32_i32$1 = $1259$hi;
    i64toi32_i32$2 = i64toi32_i32$4;
    i64toi32_i32$0 = $8$hi;
    i64toi32_i32$3 = $8;
    i64toi32_i32$5 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
     $596 = i64toi32_i32$1 >> i64toi32_i32$5 | 0;
    } else {
     i64toi32_i32$0 = i64toi32_i32$1 >> i64toi32_i32$5 | 0;
     $596 = (((1 << i64toi32_i32$5 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$5 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$5 | 0) | 0;
    }
    HEAP32[$1246 >> 2] = $1250 - $596 | 0;
    return;
   }
   label$29 : while (1) {
    i64toi32_i32$0 = 0;
    $8 = 0;
    $8$hi = i64toi32_i32$0;
    label$30 : {
     switch ($4 | 0) {
     case 19:
      i64toi32_i32$1 = (($6 << 2 | 0) + $0 | 0) + -128 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1270 = i64toi32_i32$0;
      $1270$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 124 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1272 = i64toi32_i32$2;
      $1272$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1270$hi;
      i64toi32_i32$2 = $1272$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1270 | 0, i64toi32_i32$0 | 0, $1272 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$0;
     case 18:
      i64toi32_i32$1 = (($6 << 2 | 0) + $0 | 0) + -124 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1279 = i64toi32_i32$0;
      $1279$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 120 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1281 = i64toi32_i32$2;
      $1281$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1279$hi;
      i64toi32_i32$2 = $1281$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1279 | 0, i64toi32_i32$0 | 0, $1281 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1282$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1282$hi;
      i64toi32_i32$1 = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
     case 17:
      i64toi32_i32$0 = (($6 << 2 | 0) + $0 | 0) + -120 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1290 = i64toi32_i32$4;
      $1290$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 116 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1292 = i64toi32_i32$1;
      $1292$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1290$hi;
      i64toi32_i32$1 = $1292$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1290 | 0, i64toi32_i32$4 | 0, $1292 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1293$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $1293$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$5;
     case 16:
      i64toi32_i32$4 = (($6 << 2 | 0) + $0 | 0) + -116 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1301 = i64toi32_i32$5;
      $1301$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 112 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1303 = i64toi32_i32$0;
      $1303$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1301$hi;
      i64toi32_i32$0 = $1303$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1301 | 0, i64toi32_i32$5 | 0, $1303 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1304$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1304$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $8 = i64toi32_i32$1;
      $8$hi = i64toi32_i32$2;
     case 15:
      i64toi32_i32$5 = (($6 << 2 | 0) + $0 | 0) + -112 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1312 = i64toi32_i32$2;
      $1312$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 108 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1314 = i64toi32_i32$4;
      $1314$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1312$hi;
      i64toi32_i32$4 = $1314$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1312 | 0, i64toi32_i32$2 | 0, $1314 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1315$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1315$hi;
      i64toi32_i32$5 = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $8 = i64toi32_i32$0;
      $8$hi = i64toi32_i32$1;
     case 14:
      i64toi32_i32$2 = (($6 << 2 | 0) + $0 | 0) + -108 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1323 = i64toi32_i32$1;
      $1323$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 104 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1325 = i64toi32_i32$5;
      $1325$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1323$hi;
      i64toi32_i32$5 = $1325$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1323 | 0, i64toi32_i32$1 | 0, $1325 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1326$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$1 = $1326$hi;
      i64toi32_i32$2 = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $8 = i64toi32_i32$4;
      $8$hi = i64toi32_i32$0;
     case 13:
      i64toi32_i32$1 = (($6 << 2 | 0) + $0 | 0) + -104 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1334 = i64toi32_i32$0;
      $1334$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 100 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1336 = i64toi32_i32$2;
      $1336$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1334$hi;
      i64toi32_i32$2 = $1336$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1334 | 0, i64toi32_i32$0 | 0, $1336 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1337$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1337$hi;
      i64toi32_i32$1 = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
     case 12:
      i64toi32_i32$0 = (($6 << 2 | 0) + $0 | 0) + -100 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1345 = i64toi32_i32$4;
      $1345$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 96 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1347 = i64toi32_i32$1;
      $1347$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1345$hi;
      i64toi32_i32$1 = $1347$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1345 | 0, i64toi32_i32$4 | 0, $1347 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1348$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $1348$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$5;
     case 11:
      i64toi32_i32$4 = (($6 << 2 | 0) + $0 | 0) + -96 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1356 = i64toi32_i32$5;
      $1356$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 92 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1358 = i64toi32_i32$0;
      $1358$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1356$hi;
      i64toi32_i32$0 = $1358$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1356 | 0, i64toi32_i32$5 | 0, $1358 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1359$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1359$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $8 = i64toi32_i32$1;
      $8$hi = i64toi32_i32$2;
     case 10:
      i64toi32_i32$5 = (($6 << 2 | 0) + $0 | 0) + -92 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1367 = i64toi32_i32$2;
      $1367$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 88 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1369 = i64toi32_i32$4;
      $1369$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1367$hi;
      i64toi32_i32$4 = $1369$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1367 | 0, i64toi32_i32$2 | 0, $1369 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1370$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1370$hi;
      i64toi32_i32$5 = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $8 = i64toi32_i32$0;
      $8$hi = i64toi32_i32$1;
     case 9:
      i64toi32_i32$2 = (($6 << 2 | 0) + $0 | 0) + -88 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1378 = i64toi32_i32$1;
      $1378$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 84 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1380 = i64toi32_i32$5;
      $1380$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1378$hi;
      i64toi32_i32$5 = $1380$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1378 | 0, i64toi32_i32$1 | 0, $1380 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1381$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$1 = $1381$hi;
      i64toi32_i32$2 = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $8 = i64toi32_i32$4;
      $8$hi = i64toi32_i32$0;
     case 8:
      i64toi32_i32$1 = (($6 << 2 | 0) + $0 | 0) + -84 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1389 = i64toi32_i32$0;
      $1389$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 80 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1391 = i64toi32_i32$2;
      $1391$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1389$hi;
      i64toi32_i32$2 = $1391$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1389 | 0, i64toi32_i32$0 | 0, $1391 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1392$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1392$hi;
      i64toi32_i32$1 = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
     case 7:
      i64toi32_i32$0 = (($6 << 2 | 0) + $0 | 0) + -80 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1400 = i64toi32_i32$4;
      $1400$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 76 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1402 = i64toi32_i32$1;
      $1402$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1400$hi;
      i64toi32_i32$1 = $1402$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1400 | 0, i64toi32_i32$4 | 0, $1402 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1403$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $1403$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$5;
     case 6:
      i64toi32_i32$4 = (($6 << 2 | 0) + $0 | 0) + -76 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1411 = i64toi32_i32$5;
      $1411$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 72 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1413 = i64toi32_i32$0;
      $1413$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1411$hi;
      i64toi32_i32$0 = $1413$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1411 | 0, i64toi32_i32$5 | 0, $1413 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1414$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1414$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $8 = i64toi32_i32$1;
      $8$hi = i64toi32_i32$2;
     case 5:
      i64toi32_i32$5 = (($6 << 2 | 0) + $0 | 0) + -72 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1422 = i64toi32_i32$2;
      $1422$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 68 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1424 = i64toi32_i32$4;
      $1424$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1422$hi;
      i64toi32_i32$4 = $1424$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1422 | 0, i64toi32_i32$2 | 0, $1424 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1425$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1425$hi;
      i64toi32_i32$5 = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $8 = i64toi32_i32$0;
      $8$hi = i64toi32_i32$1;
     case 4:
      i64toi32_i32$2 = (($6 << 2 | 0) + $0 | 0) + -68 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1433 = i64toi32_i32$1;
      $1433$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 64 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1435 = i64toi32_i32$5;
      $1435$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1433$hi;
      i64toi32_i32$5 = $1435$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1433 | 0, i64toi32_i32$1 | 0, $1435 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1436$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$1 = $1436$hi;
      i64toi32_i32$2 = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $8 = i64toi32_i32$4;
      $8$hi = i64toi32_i32$0;
     case 3:
      i64toi32_i32$1 = (($6 << 2 | 0) + $0 | 0) + -64 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1444 = i64toi32_i32$0;
      $1444$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 60 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1446 = i64toi32_i32$2;
      $1446$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1444$hi;
      i64toi32_i32$2 = $1446$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1444 | 0, i64toi32_i32$0 | 0, $1446 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1447$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1447$hi;
      i64toi32_i32$1 = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
     case 2:
      i64toi32_i32$0 = (($6 << 2 | 0) + $0 | 0) + -60 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1455 = i64toi32_i32$4;
      $1455$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 56 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1457 = i64toi32_i32$1;
      $1457$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1455$hi;
      i64toi32_i32$1 = $1457$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1455 | 0, i64toi32_i32$4 | 0, $1457 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1458$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $1458$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$5;
     case 1:
      i64toi32_i32$4 = (($6 << 2 | 0) + $0 | 0) + -56 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1466 = i64toi32_i32$5;
      $1466$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 52 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1468 = i64toi32_i32$0;
      $1468$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1466$hi;
      i64toi32_i32$0 = $1468$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1466 | 0, i64toi32_i32$5 | 0, $1468 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1469$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1469$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $8 = i64toi32_i32$1;
      $8$hi = i64toi32_i32$2;
     case 0:
      $3 = ($6 << 2 | 0) + $0 | 0;
      i64toi32_i32$5 = $3 + -52 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1478 = i64toi32_i32$2;
      $1478$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 48 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1480 = i64toi32_i32$4;
      $1480$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1478$hi;
      i64toi32_i32$4 = $1480$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1478 | 0, i64toi32_i32$2 | 0, $1480 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1481$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1481$hi;
      i64toi32_i32$5 = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $1483$hi = i64toi32_i32$1;
      i64toi32_i32$2 = $3 + -48 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1486 = i64toi32_i32$1;
      $1486$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 44 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1488 = i64toi32_i32$5;
      $1488$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1486$hi;
      i64toi32_i32$5 = $1488$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1486 | 0, i64toi32_i32$1 | 0, $1488 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1489 = i64toi32_i32$5;
      $1489$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1483$hi;
      i64toi32_i32$2 = i64toi32_i32$0;
      i64toi32_i32$5 = $1489$hi;
      i64toi32_i32$3 = $1489;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $1490$hi = i64toi32_i32$0;
      i64toi32_i32$1 = $3 + -44 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1493 = i64toi32_i32$0;
      $1493$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 40 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1495 = i64toi32_i32$2;
      $1495$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1493$hi;
      i64toi32_i32$2 = $1495$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1493 | 0, i64toi32_i32$0 | 0, $1495 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1496 = i64toi32_i32$2;
      $1496$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1490$hi;
      i64toi32_i32$1 = i64toi32_i32$4;
      i64toi32_i32$2 = $1496$hi;
      i64toi32_i32$3 = $1496;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $1497$hi = i64toi32_i32$4;
      i64toi32_i32$0 = $3 + -40 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1500 = i64toi32_i32$4;
      $1500$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 36 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1502 = i64toi32_i32$1;
      $1502$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1500$hi;
      i64toi32_i32$1 = $1502$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1500 | 0, i64toi32_i32$4 | 0, $1502 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1503 = i64toi32_i32$1;
      $1503$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1497$hi;
      i64toi32_i32$0 = i64toi32_i32$5;
      i64toi32_i32$1 = $1503$hi;
      i64toi32_i32$3 = $1503;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $1504$hi = i64toi32_i32$5;
      i64toi32_i32$4 = $3 + -36 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1507 = i64toi32_i32$5;
      $1507$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 32 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1509 = i64toi32_i32$0;
      $1509$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1507$hi;
      i64toi32_i32$0 = $1509$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1507 | 0, i64toi32_i32$5 | 0, $1509 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1510 = i64toi32_i32$0;
      $1510$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1504$hi;
      i64toi32_i32$4 = i64toi32_i32$2;
      i64toi32_i32$0 = $1510$hi;
      i64toi32_i32$3 = $1510;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $1511$hi = i64toi32_i32$2;
      i64toi32_i32$5 = $3 + -32 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1514 = i64toi32_i32$2;
      $1514$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 28 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1516 = i64toi32_i32$4;
      $1516$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1514$hi;
      i64toi32_i32$4 = $1516$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1514 | 0, i64toi32_i32$2 | 0, $1516 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1517 = i64toi32_i32$4;
      $1517$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1511$hi;
      i64toi32_i32$5 = i64toi32_i32$1;
      i64toi32_i32$4 = $1517$hi;
      i64toi32_i32$3 = $1517;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $1518$hi = i64toi32_i32$1;
      i64toi32_i32$2 = $3 + -28 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1521 = i64toi32_i32$1;
      $1521$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 24 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1523 = i64toi32_i32$5;
      $1523$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1521$hi;
      i64toi32_i32$5 = $1523$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1521 | 0, i64toi32_i32$1 | 0, $1523 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1524 = i64toi32_i32$5;
      $1524$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1518$hi;
      i64toi32_i32$2 = i64toi32_i32$0;
      i64toi32_i32$5 = $1524$hi;
      i64toi32_i32$3 = $1524;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $1525$hi = i64toi32_i32$0;
      i64toi32_i32$1 = $3 + -24 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1528 = i64toi32_i32$0;
      $1528$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 20 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1530 = i64toi32_i32$2;
      $1530$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1528$hi;
      i64toi32_i32$2 = $1530$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1528 | 0, i64toi32_i32$0 | 0, $1530 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1531 = i64toi32_i32$2;
      $1531$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1525$hi;
      i64toi32_i32$1 = i64toi32_i32$4;
      i64toi32_i32$2 = $1531$hi;
      i64toi32_i32$3 = $1531;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $1532$hi = i64toi32_i32$4;
      i64toi32_i32$0 = $3 + -20 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1535 = i64toi32_i32$4;
      $1535$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 16 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1537 = i64toi32_i32$1;
      $1537$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1535$hi;
      i64toi32_i32$1 = $1537$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1535 | 0, i64toi32_i32$4 | 0, $1537 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1538 = i64toi32_i32$1;
      $1538$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1532$hi;
      i64toi32_i32$0 = i64toi32_i32$5;
      i64toi32_i32$1 = $1538$hi;
      i64toi32_i32$3 = $1538;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $1539$hi = i64toi32_i32$5;
      i64toi32_i32$4 = $3 + -16 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1542 = i64toi32_i32$5;
      $1542$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 12 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1544 = i64toi32_i32$0;
      $1544$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1542$hi;
      i64toi32_i32$0 = $1544$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1542 | 0, i64toi32_i32$5 | 0, $1544 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1545 = i64toi32_i32$0;
      $1545$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1539$hi;
      i64toi32_i32$4 = i64toi32_i32$2;
      i64toi32_i32$0 = $1545$hi;
      i64toi32_i32$3 = $1545;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $1546$hi = i64toi32_i32$2;
      i64toi32_i32$5 = $3 + -12 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1549 = i64toi32_i32$2;
      $1549$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 8 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1551 = i64toi32_i32$4;
      $1551$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1549$hi;
      i64toi32_i32$4 = $1551$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1549 | 0, i64toi32_i32$2 | 0, $1551 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1552 = i64toi32_i32$4;
      $1552$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1546$hi;
      i64toi32_i32$5 = i64toi32_i32$1;
      i64toi32_i32$4 = $1552$hi;
      i64toi32_i32$3 = $1552;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $1553$hi = i64toi32_i32$1;
      i64toi32_i32$2 = $3 + -8 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1556 = i64toi32_i32$1;
      $1556$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1558 = i64toi32_i32$5;
      $1558$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1556$hi;
      i64toi32_i32$5 = $1558$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1556 | 0, i64toi32_i32$1 | 0, $1558 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1559 = i64toi32_i32$5;
      $1559$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1553$hi;
      i64toi32_i32$2 = i64toi32_i32$0;
      i64toi32_i32$5 = $1559$hi;
      i64toi32_i32$3 = $1559;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $1560$hi = i64toi32_i32$0;
      i64toi32_i32$1 = $3 + -4 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1563 = i64toi32_i32$0;
      $1563$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1565 = i64toi32_i32$2;
      $1565$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1563$hi;
      i64toi32_i32$2 = $1565$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1563 | 0, i64toi32_i32$0 | 0, $1565 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1566 = i64toi32_i32$2;
      $1566$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1560$hi;
      i64toi32_i32$1 = i64toi32_i32$4;
      i64toi32_i32$2 = $1566$hi;
      i64toi32_i32$3 = $1566;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
      break;
     default:
      break label$30;
     };
    }
    $3 = $6 << 2 | 0;
    $1572 = $5 + $3 | 0;
    $1576 = HEAP32[($0 + $3 | 0) >> 2] | 0;
    i64toi32_i32$4 = $8$hi;
    i64toi32_i32$4 = $7$hi;
    i64toi32_i32$4 = $8$hi;
    i64toi32_i32$0 = $8;
    i64toi32_i32$1 = $7$hi;
    i64toi32_i32$3 = $7;
    i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
     $597 = i64toi32_i32$4 >> i64toi32_i32$2 | 0;
    } else {
     i64toi32_i32$1 = i64toi32_i32$4 >> i64toi32_i32$2 | 0;
     $597 = (((1 << i64toi32_i32$2 | 0) - 1 | 0) & i64toi32_i32$4 | 0) << (32 - i64toi32_i32$2 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$2 | 0) | 0;
    }
    HEAP32[$1572 >> 2] = $1576 - $597 | 0;
    $6 = $6 + 1 | 0;
    if (($6 | 0) != ($1 | 0)) {
     continue label$29
    }
    break label$29;
   };
  }
 }
 
 function FLAC__lpc_restore_signal($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $6 = 0, $8 = 0, $7 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $28 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $29 = 0, $30 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     if ($3 >>> 0 < 13 >>> 0) {
      break label$3
     }
     $6 = 0;
     if (($1 | 0) <= (0 | 0)) {
      break label$1
     }
     $7 = $3 + -13 | 0;
     break label$2;
    }
    label$4 : {
     if ($3 >>> 0 < 9 >>> 0) {
      break label$4
     }
     label$5 : {
      if ($3 >>> 0 < 11 >>> 0) {
       break label$5
      }
      label$6 : {
       if (($3 | 0) == (12 | 0)) {
        break label$6
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
       $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
       $7 = HEAP32[($5 + -12 | 0) >> 2] | 0;
       $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
       $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
       $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
       $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
       $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
       $14 = HEAP32[($5 + -36 | 0) >> 2] | 0;
       $15 = HEAP32[($5 + -40 | 0) >> 2] | 0;
       $16 = HEAP32[($5 + -44 | 0) >> 2] | 0;
       $17 = HEAP32[$2 >> 2] | 0;
       $18 = HEAP32[($2 + 4 | 0) >> 2] | 0;
       $19 = HEAP32[($2 + 8 | 0) >> 2] | 0;
       $20 = HEAP32[($2 + 12 | 0) >> 2] | 0;
       $21 = HEAP32[($2 + 16 | 0) >> 2] | 0;
       $22 = HEAP32[($2 + 20 | 0) >> 2] | 0;
       $23 = HEAP32[($2 + 24 | 0) >> 2] | 0;
       $24 = HEAP32[($2 + 28 | 0) >> 2] | 0;
       $25 = HEAP32[($2 + 32 | 0) >> 2] | 0;
       $26 = HEAP32[($2 + 36 | 0) >> 2] | 0;
       $27 = HEAP32[($2 + 40 | 0) >> 2] | 0;
       $3 = 0;
       label$7 : while (1) {
        $2 = $3 << 2 | 0;
        $28 = $15;
        $15 = $14;
        $14 = $13;
        $13 = $12;
        $12 = $11;
        $11 = $10;
        $10 = $9;
        $9 = $7;
        $7 = $8;
        $8 = $6;
        $6 = (((((((((((Math_imul($28, $26) + Math_imul($16, $27) | 0) + Math_imul($15, $25) | 0) + Math_imul($14, $24) | 0) + Math_imul($13, $23) | 0) + Math_imul($12, $22) | 0) + Math_imul($11, $21) | 0) + Math_imul($10, $20) | 0) + Math_imul($9, $19) | 0) + Math_imul($7, $18) | 0) + Math_imul($6, $17) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
        HEAP32[($5 + $2 | 0) >> 2] = $6;
        $16 = $28;
        $3 = $3 + 1 | 0;
        if (($3 | 0) != ($1 | 0)) {
         continue label$7
        }
        break label$1;
       };
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $7 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
      $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
      $14 = HEAP32[($5 + -36 | 0) >> 2] | 0;
      $15 = HEAP32[($5 + -40 | 0) >> 2] | 0;
      $16 = HEAP32[($5 + -44 | 0) >> 2] | 0;
      $28 = HEAP32[($5 + -48 | 0) >> 2] | 0;
      $18 = HEAP32[$2 >> 2] | 0;
      $19 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $20 = HEAP32[($2 + 8 | 0) >> 2] | 0;
      $21 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      $22 = HEAP32[($2 + 16 | 0) >> 2] | 0;
      $23 = HEAP32[($2 + 20 | 0) >> 2] | 0;
      $24 = HEAP32[($2 + 24 | 0) >> 2] | 0;
      $25 = HEAP32[($2 + 28 | 0) >> 2] | 0;
      $26 = HEAP32[($2 + 32 | 0) >> 2] | 0;
      $27 = HEAP32[($2 + 36 | 0) >> 2] | 0;
      $29 = HEAP32[($2 + 40 | 0) >> 2] | 0;
      $30 = HEAP32[($2 + 44 | 0) >> 2] | 0;
      $3 = 0;
      label$8 : while (1) {
       $2 = $3 << 2 | 0;
       $17 = $16;
       $16 = $15;
       $15 = $14;
       $14 = $13;
       $13 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $9;
       $9 = $7;
       $7 = $8;
       $8 = $6;
       $6 = ((((((((((((Math_imul($17, $29) + Math_imul($28, $30) | 0) + Math_imul($16, $27) | 0) + Math_imul($15, $26) | 0) + Math_imul($14, $25) | 0) + Math_imul($13, $24) | 0) + Math_imul($12, $23) | 0) + Math_imul($11, $22) | 0) + Math_imul($10, $21) | 0) + Math_imul($9, $20) | 0) + Math_imul($7, $19) | 0) + Math_imul($6, $18) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
       HEAP32[($5 + $2 | 0) >> 2] = $6;
       $28 = $17;
       $3 = $3 + 1 | 0;
       if (($3 | 0) != ($1 | 0)) {
        continue label$8
       }
       break label$1;
      };
     }
     label$9 : {
      if (($3 | 0) == (10 | 0)) {
       break label$9
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $7 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
      $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
      $14 = HEAP32[($5 + -36 | 0) >> 2] | 0;
      $16 = HEAP32[$2 >> 2] | 0;
      $28 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $17 = HEAP32[($2 + 8 | 0) >> 2] | 0;
      $18 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      $19 = HEAP32[($2 + 16 | 0) >> 2] | 0;
      $20 = HEAP32[($2 + 20 | 0) >> 2] | 0;
      $21 = HEAP32[($2 + 24 | 0) >> 2] | 0;
      $22 = HEAP32[($2 + 28 | 0) >> 2] | 0;
      $23 = HEAP32[($2 + 32 | 0) >> 2] | 0;
      $3 = 0;
      label$10 : while (1) {
       $2 = $3 << 2 | 0;
       $15 = $13;
       $13 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $9;
       $9 = $7;
       $7 = $8;
       $8 = $6;
       $6 = (((((((((Math_imul($15, $22) + Math_imul($14, $23) | 0) + Math_imul($13, $21) | 0) + Math_imul($12, $20) | 0) + Math_imul($11, $19) | 0) + Math_imul($10, $18) | 0) + Math_imul($9, $17) | 0) + Math_imul($7, $28) | 0) + Math_imul($6, $16) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
       HEAP32[($5 + $2 | 0) >> 2] = $6;
       $14 = $15;
       $3 = $3 + 1 | 0;
       if (($3 | 0) != ($1 | 0)) {
        continue label$10
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
     $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
     $7 = HEAP32[($5 + -12 | 0) >> 2] | 0;
     $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
     $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
     $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
     $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
     $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
     $14 = HEAP32[($5 + -36 | 0) >> 2] | 0;
     $15 = HEAP32[($5 + -40 | 0) >> 2] | 0;
     $28 = HEAP32[$2 >> 2] | 0;
     $17 = HEAP32[($2 + 4 | 0) >> 2] | 0;
     $18 = HEAP32[($2 + 8 | 0) >> 2] | 0;
     $19 = HEAP32[($2 + 12 | 0) >> 2] | 0;
     $20 = HEAP32[($2 + 16 | 0) >> 2] | 0;
     $21 = HEAP32[($2 + 20 | 0) >> 2] | 0;
     $22 = HEAP32[($2 + 24 | 0) >> 2] | 0;
     $23 = HEAP32[($2 + 28 | 0) >> 2] | 0;
     $24 = HEAP32[($2 + 32 | 0) >> 2] | 0;
     $25 = HEAP32[($2 + 36 | 0) >> 2] | 0;
     $3 = 0;
     label$11 : while (1) {
      $2 = $3 << 2 | 0;
      $16 = $14;
      $14 = $13;
      $13 = $12;
      $12 = $11;
      $11 = $10;
      $10 = $9;
      $9 = $7;
      $7 = $8;
      $8 = $6;
      $6 = ((((((((((Math_imul($16, $24) + Math_imul($15, $25) | 0) + Math_imul($14, $23) | 0) + Math_imul($13, $22) | 0) + Math_imul($12, $21) | 0) + Math_imul($11, $20) | 0) + Math_imul($10, $19) | 0) + Math_imul($9, $18) | 0) + Math_imul($7, $17) | 0) + Math_imul($6, $28) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
      HEAP32[($5 + $2 | 0) >> 2] = $6;
      $15 = $16;
      $3 = $3 + 1 | 0;
      if (($3 | 0) != ($1 | 0)) {
       continue label$11
      }
      break label$1;
     };
    }
    label$12 : {
     if ($3 >>> 0 < 5 >>> 0) {
      break label$12
     }
     label$13 : {
      if ($3 >>> 0 < 7 >>> 0) {
       break label$13
      }
      label$14 : {
       if (($3 | 0) == (8 | 0)) {
        break label$14
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
       $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
       $7 = HEAP32[($5 + -12 | 0) >> 2] | 0;
       $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
       $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
       $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
       $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
       $14 = HEAP32[$2 >> 2] | 0;
       $15 = HEAP32[($2 + 4 | 0) >> 2] | 0;
       $16 = HEAP32[($2 + 8 | 0) >> 2] | 0;
       $28 = HEAP32[($2 + 12 | 0) >> 2] | 0;
       $17 = HEAP32[($2 + 16 | 0) >> 2] | 0;
       $18 = HEAP32[($2 + 20 | 0) >> 2] | 0;
       $19 = HEAP32[($2 + 24 | 0) >> 2] | 0;
       $3 = 0;
       label$15 : while (1) {
        $2 = $3 << 2 | 0;
        $13 = $11;
        $11 = $10;
        $10 = $9;
        $9 = $7;
        $7 = $8;
        $8 = $6;
        $6 = (((((((Math_imul($13, $18) + Math_imul($12, $19) | 0) + Math_imul($11, $17) | 0) + Math_imul($10, $28) | 0) + Math_imul($9, $16) | 0) + Math_imul($7, $15) | 0) + Math_imul($6, $14) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
        HEAP32[($5 + $2 | 0) >> 2] = $6;
        $12 = $13;
        $3 = $3 + 1 | 0;
        if (($3 | 0) != ($1 | 0)) {
         continue label$15
        }
        break label$1;
       };
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $7 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
      $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
      $15 = HEAP32[$2 >> 2] | 0;
      $16 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $28 = HEAP32[($2 + 8 | 0) >> 2] | 0;
      $17 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      $18 = HEAP32[($2 + 16 | 0) >> 2] | 0;
      $19 = HEAP32[($2 + 20 | 0) >> 2] | 0;
      $20 = HEAP32[($2 + 24 | 0) >> 2] | 0;
      $21 = HEAP32[($2 + 28 | 0) >> 2] | 0;
      $3 = 0;
      label$16 : while (1) {
       $2 = $3 << 2 | 0;
       $14 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $9;
       $9 = $7;
       $7 = $8;
       $8 = $6;
       $6 = ((((((((Math_imul($14, $20) + Math_imul($13, $21) | 0) + Math_imul($12, $19) | 0) + Math_imul($11, $18) | 0) + Math_imul($10, $17) | 0) + Math_imul($9, $28) | 0) + Math_imul($7, $16) | 0) + Math_imul($6, $15) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
       HEAP32[($5 + $2 | 0) >> 2] = $6;
       $13 = $14;
       $3 = $3 + 1 | 0;
       if (($3 | 0) != ($1 | 0)) {
        continue label$16
       }
       break label$1;
      };
     }
     label$17 : {
      if (($3 | 0) == (6 | 0)) {
       break label$17
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $7 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
      $12 = HEAP32[$2 >> 2] | 0;
      $13 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      $14 = HEAP32[($2 + 8 | 0) >> 2] | 0;
      $15 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      $16 = HEAP32[($2 + 16 | 0) >> 2] | 0;
      $3 = 0;
      label$18 : while (1) {
       $2 = $3 << 2 | 0;
       $11 = $9;
       $9 = $7;
       $7 = $8;
       $8 = $6;
       $6 = (((((Math_imul($11, $15) + Math_imul($10, $16) | 0) + Math_imul($9, $14) | 0) + Math_imul($7, $13) | 0) + Math_imul($6, $12) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
       HEAP32[($5 + $2 | 0) >> 2] = $6;
       $10 = $11;
       $3 = $3 + 1 | 0;
       if (($3 | 0) != ($1 | 0)) {
        continue label$18
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
     $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
     $7 = HEAP32[($5 + -12 | 0) >> 2] | 0;
     $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
     $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
     $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
     $13 = HEAP32[$2 >> 2] | 0;
     $14 = HEAP32[($2 + 4 | 0) >> 2] | 0;
     $15 = HEAP32[($2 + 8 | 0) >> 2] | 0;
     $16 = HEAP32[($2 + 12 | 0) >> 2] | 0;
     $28 = HEAP32[($2 + 16 | 0) >> 2] | 0;
     $17 = HEAP32[($2 + 20 | 0) >> 2] | 0;
     $3 = 0;
     label$19 : while (1) {
      $2 = $3 << 2 | 0;
      $12 = $10;
      $10 = $9;
      $9 = $7;
      $7 = $8;
      $8 = $6;
      $6 = ((((((Math_imul($12, $28) + Math_imul($11, $17) | 0) + Math_imul($10, $16) | 0) + Math_imul($9, $15) | 0) + Math_imul($7, $14) | 0) + Math_imul($6, $13) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
      HEAP32[($5 + $2 | 0) >> 2] = $6;
      $11 = $12;
      $3 = $3 + 1 | 0;
      if (($3 | 0) != ($1 | 0)) {
       continue label$19
      }
      break label$1;
     };
    }
    label$20 : {
     if ($3 >>> 0 < 3 >>> 0) {
      break label$20
     }
     label$21 : {
      label$22 : {
       label$23 : {
        if (($3 | 0) == (4 | 0)) {
         break label$23
        }
        if (($1 | 0) < (1 | 0)) {
         break label$1
        }
        $14 = $1 & 1 | 0;
        $7 = HEAP32[($5 + -4 | 0) >> 2] | 0;
        $6 = HEAP32[($5 + -8 | 0) >> 2] | 0;
        $9 = HEAP32[($5 + -12 | 0) >> 2] | 0;
        $10 = HEAP32[$2 >> 2] | 0;
        $11 = HEAP32[($2 + 4 | 0) >> 2] | 0;
        $12 = HEAP32[($2 + 8 | 0) >> 2] | 0;
        $3 = 0;
        if (($1 | 0) != (1 | 0)) {
         break label$22
        }
        $2 = $6;
        $8 = $9;
        break label$21;
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $16 = $1 & 1 | 0;
       $9 = HEAP32[($5 + -4 | 0) >> 2] | 0;
       $6 = HEAP32[($5 + -8 | 0) >> 2] | 0;
       $8 = HEAP32[($5 + -12 | 0) >> 2] | 0;
       $10 = HEAP32[($5 + -16 | 0) >> 2] | 0;
       $11 = HEAP32[$2 >> 2] | 0;
       $12 = HEAP32[($2 + 4 | 0) >> 2] | 0;
       $13 = HEAP32[($2 + 8 | 0) >> 2] | 0;
       $14 = HEAP32[($2 + 12 | 0) >> 2] | 0;
       $3 = 0;
       label$24 : {
        label$25 : {
         if (($1 | 0) != (1 | 0)) {
          break label$25
         }
         $2 = $8;
         $1 = $10;
         break label$24;
        }
        $15 = $1 & -2 | 0;
        $3 = 0;
        label$26 : while (1) {
         $7 = $3 << 2 | 0;
         $1 = $6;
         $2 = $9;
         $6 = ((((Math_imul($8, $13) + Math_imul($10, $14) | 0) + Math_imul($6, $12) | 0) + Math_imul($2, $11) | 0) >> $4 | 0) + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0;
         HEAP32[($5 + $7 | 0) >> 2] = $6;
         $7 = $7 | 4 | 0;
         $9 = ((((Math_imul($1, $13) + Math_imul($8, $14) | 0) + Math_imul($2, $12) | 0) + Math_imul($6, $11) | 0) >> $4 | 0) + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0;
         HEAP32[($5 + $7 | 0) >> 2] = $9;
         $3 = $3 + 2 | 0;
         $8 = $2;
         $10 = $1;
         $15 = $15 + -2 | 0;
         if ($15) {
          continue label$26
         }
         break label$26;
        };
       }
       if (!$16) {
        break label$1
       }
       $3 = $3 << 2 | 0;
       HEAP32[($5 + $3 | 0) >> 2] = ((((Math_imul($2, $13) + Math_imul($1, $14) | 0) + Math_imul($6, $12) | 0) + Math_imul($9, $11) | 0) >> $4 | 0) + (HEAP32[($0 + $3 | 0) >> 2] | 0) | 0;
       return;
      }
      $13 = $1 & -2 | 0;
      $3 = 0;
      label$27 : while (1) {
       $1 = $3 << 2 | 0;
       $8 = $7;
       $2 = (((Math_imul($6, $11) + Math_imul($9, $12) | 0) + Math_imul($8, $10) | 0) >> $4 | 0) + (HEAP32[($0 + $1 | 0) >> 2] | 0) | 0;
       HEAP32[($5 + $1 | 0) >> 2] = $2;
       $1 = $1 | 4 | 0;
       $7 = (((Math_imul($8, $11) + Math_imul($6, $12) | 0) + Math_imul($2, $10) | 0) >> $4 | 0) + (HEAP32[($0 + $1 | 0) >> 2] | 0) | 0;
       HEAP32[($5 + $1 | 0) >> 2] = $7;
       $3 = $3 + 2 | 0;
       $6 = $2;
       $9 = $8;
       $13 = $13 + -2 | 0;
       if ($13) {
        continue label$27
       }
       break label$27;
      };
     }
     if (!$14) {
      break label$1
     }
     $3 = $3 << 2 | 0;
     HEAP32[($5 + $3 | 0) >> 2] = (((Math_imul($2, $11) + Math_imul($8, $12) | 0) + Math_imul($7, $10) | 0) >> $4 | 0) + (HEAP32[($0 + $3 | 0) >> 2] | 0) | 0;
     return;
    }
    label$28 : {
     if (($3 | 0) == (2 | 0)) {
      break label$28
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $7 = $1 & 1 | 0;
     $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
     $8 = HEAP32[$2 >> 2] | 0;
     $3 = 0;
     label$29 : {
      if (($1 | 0) == (1 | 0)) {
       break label$29
      }
      $1 = $1 & -2 | 0;
      $3 = 0;
      label$30 : while (1) {
       $2 = $3 << 2 | 0;
       $6 = (Math_imul($6, $8) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
       HEAP32[($5 + $2 | 0) >> 2] = $6;
       $2 = $2 | 4 | 0;
       $6 = (Math_imul($6, $8) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
       HEAP32[($5 + $2 | 0) >> 2] = $6;
       $3 = $3 + 2 | 0;
       $1 = $1 + -2 | 0;
       if ($1) {
        continue label$30
       }
       break label$30;
      };
     }
     if (!$7) {
      break label$1
     }
     $3 = $3 << 2 | 0;
     HEAP32[($5 + $3 | 0) >> 2] = (Math_imul($6, $8) >> $4 | 0) + (HEAP32[($0 + $3 | 0) >> 2] | 0) | 0;
     break label$1;
    }
    if (($1 | 0) < (1 | 0)) {
     break label$1
    }
    $10 = $1 & 1 | 0;
    $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
    $8 = HEAP32[($5 + -8 | 0) >> 2] | 0;
    $7 = HEAP32[$2 >> 2] | 0;
    $9 = HEAP32[($2 + 4 | 0) >> 2] | 0;
    $3 = 0;
    label$31 : {
     if (($1 | 0) == (1 | 0)) {
      break label$31
     }
     $1 = $1 & -2 | 0;
     $3 = 0;
     label$32 : while (1) {
      $2 = $3 << 2 | 0;
      $8 = ((Math_imul($6, $7) + Math_imul($8, $9) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
      HEAP32[($5 + $2 | 0) >> 2] = $8;
      $2 = $2 | 4 | 0;
      $6 = ((Math_imul($8, $7) + Math_imul($6, $9) | 0) >> $4 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0;
      HEAP32[($5 + $2 | 0) >> 2] = $6;
      $3 = $3 + 2 | 0;
      $1 = $1 + -2 | 0;
      if ($1) {
       continue label$32
      }
      break label$32;
     };
    }
    if (!$10) {
     break label$1
    }
    $3 = $3 << 2 | 0;
    HEAP32[($5 + $3 | 0) >> 2] = ((Math_imul($6, $7) + Math_imul($8, $9) | 0) >> $4 | 0) + (HEAP32[($0 + $3 | 0) >> 2] | 0) | 0;
    return;
   }
   label$33 : while (1) {
    $3 = 0;
    label$34 : {
     switch ($7 | 0) {
     case 19:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -128 | 0) >> 2] | 0, HEAP32[($2 + 124 | 0) >> 2] | 0);
     case 18:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -124 | 0) >> 2] | 0, HEAP32[($2 + 120 | 0) >> 2] | 0) + $3 | 0;
     case 17:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -120 | 0) >> 2] | 0, HEAP32[($2 + 116 | 0) >> 2] | 0) + $3 | 0;
     case 16:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -116 | 0) >> 2] | 0, HEAP32[($2 + 112 | 0) >> 2] | 0) + $3 | 0;
     case 15:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -112 | 0) >> 2] | 0, HEAP32[($2 + 108 | 0) >> 2] | 0) + $3 | 0;
     case 14:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -108 | 0) >> 2] | 0, HEAP32[($2 + 104 | 0) >> 2] | 0) + $3 | 0;
     case 13:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -104 | 0) >> 2] | 0, HEAP32[($2 + 100 | 0) >> 2] | 0) + $3 | 0;
     case 12:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -100 | 0) >> 2] | 0, HEAP32[($2 + 96 | 0) >> 2] | 0) + $3 | 0;
     case 11:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -96 | 0) >> 2] | 0, HEAP32[($2 + 92 | 0) >> 2] | 0) + $3 | 0;
     case 10:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -92 | 0) >> 2] | 0, HEAP32[($2 + 88 | 0) >> 2] | 0) + $3 | 0;
     case 9:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -88 | 0) >> 2] | 0, HEAP32[($2 + 84 | 0) >> 2] | 0) + $3 | 0;
     case 8:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -84 | 0) >> 2] | 0, HEAP32[($2 + 80 | 0) >> 2] | 0) + $3 | 0;
     case 7:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -80 | 0) >> 2] | 0, HEAP32[($2 + 76 | 0) >> 2] | 0) + $3 | 0;
     case 6:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -76 | 0) >> 2] | 0, HEAP32[($2 + 72 | 0) >> 2] | 0) + $3 | 0;
     case 5:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -72 | 0) >> 2] | 0, HEAP32[($2 + 68 | 0) >> 2] | 0) + $3 | 0;
     case 4:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -68 | 0) >> 2] | 0, HEAP32[($2 + 64 | 0) >> 2] | 0) + $3 | 0;
     case 3:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -64 | 0) >> 2] | 0, HEAP32[($2 + 60 | 0) >> 2] | 0) + $3 | 0;
     case 2:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -60 | 0) >> 2] | 0, HEAP32[($2 + 56 | 0) >> 2] | 0) + $3 | 0;
     case 1:
      $3 = Math_imul(HEAP32[((($6 << 2 | 0) + $5 | 0) + -56 | 0) >> 2] | 0, HEAP32[($2 + 52 | 0) >> 2] | 0) + $3 | 0;
     case 0:
      $8 = ($6 << 2 | 0) + $5 | 0;
      $3 = ((((((((((((Math_imul(HEAP32[($8 + -52 | 0) >> 2] | 0, HEAP32[($2 + 48 | 0) >> 2] | 0) + $3 | 0) + Math_imul(HEAP32[($8 + -48 | 0) >> 2] | 0, HEAP32[($2 + 44 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -44 | 0) >> 2] | 0, HEAP32[($2 + 40 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -40 | 0) >> 2] | 0, HEAP32[($2 + 36 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -36 | 0) >> 2] | 0, HEAP32[($2 + 32 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -32 | 0) >> 2] | 0, HEAP32[($2 + 28 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -28 | 0) >> 2] | 0, HEAP32[($2 + 24 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -24 | 0) >> 2] | 0, HEAP32[($2 + 20 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -20 | 0) >> 2] | 0, HEAP32[($2 + 16 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -16 | 0) >> 2] | 0, HEAP32[($2 + 12 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -12 | 0) >> 2] | 0, HEAP32[($2 + 8 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -8 | 0) >> 2] | 0, HEAP32[($2 + 4 | 0) >> 2] | 0) | 0) + Math_imul(HEAP32[($8 + -4 | 0) >> 2] | 0, HEAP32[$2 >> 2] | 0) | 0;
      break;
     default:
      break label$34;
     };
    }
    $8 = $6 << 2 | 0;
    HEAP32[($5 + $8 | 0) >> 2] = (HEAP32[($0 + $8 | 0) >> 2] | 0) + ($3 >> $4 | 0) | 0;
    $6 = $6 + 1 | 0;
    if (($6 | 0) != ($1 | 0)) {
     continue label$33
    }
    break label$33;
   };
  }
 }
 
 function FLAC__lpc_restore_signal_wide($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, i64toi32_i32$4 = 0, i64toi32_i32$5 = 0, i64toi32_i32$3 = 0, $8$hi = 0, $6 = 0, $8 = 0, $9 = 0, $7$hi = 0, $10 = 0, $11 = 0, $17$hi = 0, $12 = 0, $18$hi = 0, $7 = 0, $13 = 0, $19$hi = 0, $14 = 0, $17 = 0, $20$hi = 0, $18 = 0, $21$hi = 0, $15 = 0, $19 = 0, $22$hi = 0, $20 = 0, $23$hi = 0, $16 = 0, $21 = 0, $22 = 0, $24$hi = 0, $23 = 0, $25$hi = 0, $27 = 0, $24 = 0, $25 = 0, $26$hi = 0, $29 = 0, $26 = 0, $581 = 0, $28$hi = 0, $582 = 0, $583 = 0, $584 = 0, $585 = 0, $586 = 0, $587 = 0, $588 = 0, $589 = 0, $590 = 0, $591 = 0, $592 = 0, $593 = 0, $594 = 0, $595 = 0, $596 = 0, $597 = 0, $107 = 0, $111 = 0, $114$hi = 0, $116 = 0, $116$hi = 0, $118$hi = 0, $120 = 0, $120$hi = 0, $121$hi = 0, $124$hi = 0, $126 = 0, $126$hi = 0, $127$hi = 0, $130$hi = 0, $132 = 0, $132$hi = 0, $133$hi = 0, $136$hi = 0, $138 = 0, $138$hi = 0, $139$hi = 0, $142$hi = 0, $144 = 0, $144$hi = 0, $145$hi = 0, $148$hi = 0, $150 = 0, $150$hi = 0, $151$hi = 0, $154$hi = 0, $156 = 0, $156$hi = 0, $157$hi = 0, $160$hi = 0, $162 = 0, $162$hi = 0, $163$hi = 0, $166$hi = 0, $168 = 0, $168$hi = 0, $169$hi = 0, $172$hi = 0, $174 = 0, $174$hi = 0, $175$hi = 0, $28 = 0, $253 = 0, $257 = 0, $260$hi = 0, $262 = 0, $262$hi = 0, $264$hi = 0, $266 = 0, $266$hi = 0, $267$hi = 0, $270$hi = 0, $272 = 0, $272$hi = 0, $273$hi = 0, $276$hi = 0, $278 = 0, $278$hi = 0, $279$hi = 0, $282$hi = 0, $284 = 0, $284$hi = 0, $285$hi = 0, $288$hi = 0, $290 = 0, $290$hi = 0, $291$hi = 0, $294$hi = 0, $296 = 0, $296$hi = 0, $297$hi = 0, $300$hi = 0, $302 = 0, $302$hi = 0, $303$hi = 0, $306$hi = 0, $308 = 0, $308$hi = 0, $309$hi = 0, $312$hi = 0, $314 = 0, $314$hi = 0, $315$hi = 0, $318$hi = 0, $320 = 0, $320$hi = 0, $321$hi = 0, $324$hi = 0, $326 = 0, $326$hi = 0, $327$hi = 0, $394 = 0, $398 = 0, $401$hi = 0, $403 = 0, $403$hi = 0, $405$hi = 0, $407 = 0, $407$hi = 0, $408$hi = 0, $411$hi = 0, $413 = 0, $413$hi = 0, $414$hi = 0, $417$hi = 0, $419 = 0, $419$hi = 0, $420$hi = 0, $423$hi = 0, $425 = 0, $425$hi = 0, $426$hi = 0, $429$hi = 0, $431 = 0, $431$hi = 0, $432$hi = 0, $435$hi = 0, $437 = 0, $437$hi = 0, $438$hi = 0, $441$hi = 0, $443 = 0, $443$hi = 0, $444$hi = 0, $447$hi = 0, $449 = 0, $449$hi = 0, $450$hi = 0, $518 = 0, $522 = 0, $525$hi = 0, $527 = 0, $527$hi = 0, $529$hi = 0, $531 = 0, $531$hi = 0, $532$hi = 0, $535$hi = 0, $537 = 0, $537$hi = 0, $538$hi = 0, $541$hi = 0, $543 = 0, $543$hi = 0, $544$hi = 0, $547$hi = 0, $549 = 0, $549$hi = 0, $550$hi = 0, $553$hi = 0, $555 = 0, $555$hi = 0, $556$hi = 0, $559$hi = 0, $561 = 0, $561$hi = 0, $562$hi = 0, $565$hi = 0, $567 = 0, $567$hi = 0, $568$hi = 0, $571$hi = 0, $573 = 0, $573$hi = 0, $574$hi = 0, $577$hi = 0, $579 = 0, $579$hi = 0, $580$hi = 0, $641 = 0, $645 = 0, $648$hi = 0, $650 = 0, $650$hi = 0, $652$hi = 0, $654 = 0, $654$hi = 0, $655$hi = 0, $658$hi = 0, $660 = 0, $660$hi = 0, $661$hi = 0, $664$hi = 0, $666 = 0, $666$hi = 0, $667$hi = 0, $670$hi = 0, $672 = 0, $672$hi = 0, $673$hi = 0, $676$hi = 0, $678 = 0, $678$hi = 0, $679$hi = 0, $682$hi = 0, $684 = 0, $684$hi = 0, $685$hi = 0, $743 = 0, $747 = 0, $750$hi = 0, $752 = 0, $752$hi = 0, $754$hi = 0, $756 = 0, $756$hi = 0, $757$hi = 0, $760$hi = 0, $762 = 0, $762$hi = 0, $763$hi = 0, $766$hi = 0, $768 = 0, $768$hi = 0, $769$hi = 0, $772$hi = 0, $774 = 0, $774$hi = 0, $775$hi = 0, $778$hi = 0, $780 = 0, $780$hi = 0, $781$hi = 0, $784$hi = 0, $786 = 0, $786$hi = 0, $787$hi = 0, $790$hi = 0, $792 = 0, $792$hi = 0, $793$hi = 0, $840 = 0, $844 = 0, $847$hi = 0, $849 = 0, $849$hi = 0, $851$hi = 0, $853 = 0, $853$hi = 0, $854$hi = 0, $857$hi = 0, $859 = 0, $859$hi = 0, $860$hi = 0, $863$hi = 0, $865 = 0, $865$hi = 0, $866$hi = 0, $869$hi = 0, $871 = 0, $871$hi = 0, $872$hi = 0, $920 = 0, $924 = 0, $927$hi = 0, $929 = 0, $929$hi = 0, $931$hi = 0, $933 = 0, $933$hi = 0, $934$hi = 0, $937$hi = 0, $939 = 0, $939$hi = 0, $940$hi = 0, $943$hi = 0, $945 = 0, $945$hi = 0, $946$hi = 0, $949$hi = 0, $951 = 0, $951$hi = 0, $952$hi = 0, $955$hi = 0, $957 = 0, $957$hi = 0, $958$hi = 0, $997 = 0, $1001 = 0, $1004$hi = 0, $1006 = 0, $1006$hi = 0, $1008$hi = 0, $1010 = 0, $1010$hi = 0, $1011$hi = 0, $1014$hi = 0, $1016 = 0, $1016$hi = 0, $1017$hi = 0, $1055 = 0, $1059 = 0, $1062$hi = 0, $1064 = 0, $1064$hi = 0, $1066$hi = 0, $1068 = 0, $1068$hi = 0, $1069$hi = 0, $1072$hi = 0, $1074 = 0, $1074$hi = 0, $1075$hi = 0, $1078$hi = 0, $1080 = 0, $1080$hi = 0, $1081$hi = 0, $1114 = 0, $1118 = 0, $1120$hi = 0, $1122$hi = 0, $1132 = 0, $1136 = 0, $1138$hi = 0, $1140$hi = 0, $1157 = 0, $1161 = 0, $1163$hi = 0, $1165$hi = 0, $1192 = 0, $1196 = 0, $1201 = 0, $1201$hi = 0, $1203$hi = 0, $1205 = 0, $1205$hi = 0, $1206$hi = 0, $1216 = 0, $1220 = 0, $1222$hi = 0, $1224 = 0, $1224$hi = 0, $1227 = 0, $1227$hi = 0, $1228$hi = 0, $1245 = 0, $1249 = 0, $1251$hi = 0, $1253 = 0, $1253$hi = 0, $1255$hi = 0, $1257 = 0, $1257$hi = 0, $1258$hi = 0, $1269 = 0, $1269$hi = 0, $1271 = 0, $1271$hi = 0, $1278 = 0, $1278$hi = 0, $1280 = 0, $1280$hi = 0, $1281$hi = 0, $1289 = 0, $1289$hi = 0, $1291 = 0, $1291$hi = 0, $1292$hi = 0, $1300 = 0, $1300$hi = 0, $1302 = 0, $1302$hi = 0, $1303$hi = 0, $1311 = 0, $1311$hi = 0, $1313 = 0, $1313$hi = 0, $1314$hi = 0, $1322 = 0, $1322$hi = 0, $1324 = 0, $1324$hi = 0, $1325$hi = 0, $1333 = 0, $1333$hi = 0, $1335 = 0, $1335$hi = 0, $1336$hi = 0, $1344 = 0, $1344$hi = 0, $1346 = 0, $1346$hi = 0, $1347$hi = 0, $1355 = 0, $1355$hi = 0, $1357 = 0, $1357$hi = 0, $1358$hi = 0, $1366 = 0, $1366$hi = 0, $1368 = 0, $1368$hi = 0, $1369$hi = 0, $1377 = 0, $1377$hi = 0, $1379 = 0, $1379$hi = 0, $1380$hi = 0, $1388 = 0, $1388$hi = 0, $1390 = 0, $1390$hi = 0, $1391$hi = 0, $1399 = 0, $1399$hi = 0, $1401 = 0, $1401$hi = 0, $1402$hi = 0, $1410 = 0, $1410$hi = 0, $1412 = 0, $1412$hi = 0, $1413$hi = 0, $1421 = 0, $1421$hi = 0, $1423 = 0, $1423$hi = 0, $1424$hi = 0, $1432 = 0, $1432$hi = 0, $1434 = 0, $1434$hi = 0, $1435$hi = 0, $1443 = 0, $1443$hi = 0, $1445 = 0, $1445$hi = 0, $1446$hi = 0, $1454 = 0, $1454$hi = 0, $1456 = 0, $1456$hi = 0, $1457$hi = 0, $1465 = 0, $1465$hi = 0, $1467 = 0, $1467$hi = 0, $1468$hi = 0, $1477 = 0, $1477$hi = 0, $1479 = 0, $1479$hi = 0, $1480$hi = 0, $1482$hi = 0, $1485 = 0, $1485$hi = 0, $1487 = 0, $1487$hi = 0, $1488 = 0, $1488$hi = 0, $1489$hi = 0, $1492 = 0, $1492$hi = 0, $1494 = 0, $1494$hi = 0, $1495 = 0, $1495$hi = 0, $1496$hi = 0, $1499 = 0, $1499$hi = 0, $1501 = 0, $1501$hi = 0, $1502 = 0, $1502$hi = 0, $1503$hi = 0, $1506 = 0, $1506$hi = 0, $1508 = 0, $1508$hi = 0, $1509 = 0, $1509$hi = 0, $1510$hi = 0, $1513 = 0, $1513$hi = 0, $1515 = 0, $1515$hi = 0, $1516 = 0, $1516$hi = 0, $1517$hi = 0, $1520 = 0, $1520$hi = 0, $1522 = 0, $1522$hi = 0, $1523 = 0, $1523$hi = 0, $1524$hi = 0, $1527 = 0, $1527$hi = 0, $1529 = 0, $1529$hi = 0, $1530 = 0, $1530$hi = 0, $1531$hi = 0, $1534 = 0, $1534$hi = 0, $1536 = 0, $1536$hi = 0, $1537 = 0, $1537$hi = 0, $1538$hi = 0, $1541 = 0, $1541$hi = 0, $1543 = 0, $1543$hi = 0, $1544 = 0, $1544$hi = 0, $1545$hi = 0, $1548 = 0, $1548$hi = 0, $1550 = 0, $1550$hi = 0, $1551 = 0, $1551$hi = 0, $1552$hi = 0, $1555 = 0, $1555$hi = 0, $1557 = 0, $1557$hi = 0, $1558 = 0, $1558$hi = 0, $1559$hi = 0, $1562 = 0, $1562$hi = 0, $1564 = 0, $1564$hi = 0, $1565 = 0, $1565$hi = 0, $1571 = 0, $1575 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     if ($3 >>> 0 < 13 >>> 0) {
      break label$3
     }
     $6 = 0;
     if (($1 | 0) <= (0 | 0)) {
      break label$1
     }
     i64toi32_i32$0 = 0;
     $7 = $4;
     $7$hi = i64toi32_i32$0;
     $4 = $3 + -13 | 0;
     break label$2;
    }
    label$4 : {
     if ($3 >>> 0 < 9 >>> 0) {
      break label$4
     }
     label$5 : {
      if ($3 >>> 0 < 11 >>> 0) {
       break label$5
      }
      i64toi32_i32$0 = 0;
      $8 = $4;
      $8$hi = i64toi32_i32$0;
      label$6 : {
       if (($3 | 0) == (12 | 0)) {
        break label$6
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
       $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
       $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
       $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
       $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
       $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
       $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
       $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
       $14 = HEAP32[($5 + -36 | 0) >> 2] | 0;
       $15 = HEAP32[($5 + -40 | 0) >> 2] | 0;
       $16 = HEAP32[($5 + -44 | 0) >> 2] | 0;
       i64toi32_i32$2 = $2;
       i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $7 = i64toi32_i32$0;
       $7$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $17 = i64toi32_i32$1;
       $17$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 8 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $18 = i64toi32_i32$0;
       $18$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 12 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $19 = i64toi32_i32$1;
       $19$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 16 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $20 = i64toi32_i32$0;
       $20$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 20 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $21 = i64toi32_i32$1;
       $21$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 24 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $22 = i64toi32_i32$0;
       $22$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 28 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $23 = i64toi32_i32$1;
       $23$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 32 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $24 = i64toi32_i32$0;
       $24$hi = i64toi32_i32$1;
       i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 36 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $25 = i64toi32_i32$1;
       $25$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 40 | 0) >> 2] | 0;
       i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
       $26 = i64toi32_i32$0;
       $26$hi = i64toi32_i32$1;
       $2 = 0;
       label$7 : while (1) {
        $27 = $2 << 2 | 0;
        $107 = $5 + $27 | 0;
        $111 = HEAP32[($0 + $27 | 0) >> 2] | 0;
        $27 = $15;
        i64toi32_i32$0 = $15;
        i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
        $114$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $25$hi;
        i64toi32_i32$1 = $114$hi;
        i64toi32_i32$0 = $25$hi;
        i64toi32_i32$0 = __wasm_i64_mul($15 | 0, i64toi32_i32$1 | 0, $25 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
        $116 = i64toi32_i32$0;
        $116$hi = i64toi32_i32$1;
        i64toi32_i32$0 = $16;
        i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
        $118$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $26$hi;
        i64toi32_i32$1 = $118$hi;
        i64toi32_i32$0 = $26$hi;
        i64toi32_i32$0 = __wasm_i64_mul($16 | 0, i64toi32_i32$1 | 0, $26 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
        $120 = i64toi32_i32$0;
        $120$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $116$hi;
        i64toi32_i32$2 = $116;
        i64toi32_i32$0 = $120$hi;
        i64toi32_i32$3 = $120;
        i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$0 | 0;
        if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
        }
        $121$hi = i64toi32_i32$5;
        $15 = $14;
        i64toi32_i32$2 = $14;
        i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
        $124$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $24$hi;
        i64toi32_i32$5 = $124$hi;
        i64toi32_i32$2 = $24$hi;
        i64toi32_i32$2 = __wasm_i64_mul($14 | 0, i64toi32_i32$5 | 0, $24 | 0, i64toi32_i32$2 | 0) | 0;
        i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
        $126 = i64toi32_i32$2;
        $126$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $121$hi;
        i64toi32_i32$1 = i64toi32_i32$4;
        i64toi32_i32$2 = $126$hi;
        i64toi32_i32$3 = $126;
        i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
        if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
        }
        $127$hi = i64toi32_i32$4;
        $14 = $13;
        i64toi32_i32$1 = $13;
        i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
        $130$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $23$hi;
        i64toi32_i32$4 = $130$hi;
        i64toi32_i32$1 = $23$hi;
        i64toi32_i32$1 = __wasm_i64_mul($13 | 0, i64toi32_i32$4 | 0, $23 | 0, i64toi32_i32$1 | 0) | 0;
        i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
        $132 = i64toi32_i32$1;
        $132$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $127$hi;
        i64toi32_i32$5 = i64toi32_i32$0;
        i64toi32_i32$1 = $132$hi;
        i64toi32_i32$3 = $132;
        i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
        i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
        if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
        }
        $133$hi = i64toi32_i32$0;
        $13 = $12;
        i64toi32_i32$5 = $12;
        i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
        $136$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $22$hi;
        i64toi32_i32$0 = $136$hi;
        i64toi32_i32$5 = $22$hi;
        i64toi32_i32$5 = __wasm_i64_mul($12 | 0, i64toi32_i32$0 | 0, $22 | 0, i64toi32_i32$5 | 0) | 0;
        i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
        $138 = i64toi32_i32$5;
        $138$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $133$hi;
        i64toi32_i32$4 = i64toi32_i32$2;
        i64toi32_i32$5 = $138$hi;
        i64toi32_i32$3 = $138;
        i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$5 | 0;
        if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
        }
        $139$hi = i64toi32_i32$2;
        $12 = $11;
        i64toi32_i32$4 = $11;
        i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
        $142$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $21$hi;
        i64toi32_i32$2 = $142$hi;
        i64toi32_i32$4 = $21$hi;
        i64toi32_i32$4 = __wasm_i64_mul($11 | 0, i64toi32_i32$2 | 0, $21 | 0, i64toi32_i32$4 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $144 = i64toi32_i32$4;
        $144$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $139$hi;
        i64toi32_i32$0 = i64toi32_i32$1;
        i64toi32_i32$4 = $144$hi;
        i64toi32_i32$3 = $144;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
        if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
        }
        $145$hi = i64toi32_i32$1;
        $11 = $10;
        i64toi32_i32$0 = $10;
        i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
        $148$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $20$hi;
        i64toi32_i32$1 = $148$hi;
        i64toi32_i32$0 = $20$hi;
        i64toi32_i32$0 = __wasm_i64_mul($10 | 0, i64toi32_i32$1 | 0, $20 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
        $150 = i64toi32_i32$0;
        $150$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $145$hi;
        i64toi32_i32$2 = i64toi32_i32$5;
        i64toi32_i32$0 = $150$hi;
        i64toi32_i32$3 = $150;
        i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$0 | 0;
        if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
        }
        $151$hi = i64toi32_i32$5;
        $10 = $9;
        i64toi32_i32$2 = $9;
        i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
        $154$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $19$hi;
        i64toi32_i32$5 = $154$hi;
        i64toi32_i32$2 = $19$hi;
        i64toi32_i32$2 = __wasm_i64_mul($9 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$2 | 0) | 0;
        i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
        $156 = i64toi32_i32$2;
        $156$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $151$hi;
        i64toi32_i32$1 = i64toi32_i32$4;
        i64toi32_i32$2 = $156$hi;
        i64toi32_i32$3 = $156;
        i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
        if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
        }
        $157$hi = i64toi32_i32$4;
        $9 = $4;
        i64toi32_i32$1 = $4;
        i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
        $160$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $18$hi;
        i64toi32_i32$4 = $160$hi;
        i64toi32_i32$1 = $18$hi;
        i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$4 | 0, $18 | 0, i64toi32_i32$1 | 0) | 0;
        i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
        $162 = i64toi32_i32$1;
        $162$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $157$hi;
        i64toi32_i32$5 = i64toi32_i32$0;
        i64toi32_i32$1 = $162$hi;
        i64toi32_i32$3 = $162;
        i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
        i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
        if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
        }
        $163$hi = i64toi32_i32$0;
        $4 = $3;
        i64toi32_i32$5 = $3;
        i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
        $166$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $17$hi;
        i64toi32_i32$0 = $166$hi;
        i64toi32_i32$5 = $17$hi;
        i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$0 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
        i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
        $168 = i64toi32_i32$5;
        $168$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $163$hi;
        i64toi32_i32$4 = i64toi32_i32$2;
        i64toi32_i32$5 = $168$hi;
        i64toi32_i32$3 = $168;
        i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$5 | 0;
        if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
        }
        $169$hi = i64toi32_i32$2;
        $3 = $6;
        i64toi32_i32$4 = $3;
        i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
        $172$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $7$hi;
        i64toi32_i32$2 = $172$hi;
        i64toi32_i32$4 = $7$hi;
        i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $174 = i64toi32_i32$4;
        $174$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $169$hi;
        i64toi32_i32$0 = i64toi32_i32$1;
        i64toi32_i32$4 = $174$hi;
        i64toi32_i32$3 = $174;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
        if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
        }
        $175$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $8$hi;
        i64toi32_i32$1 = $175$hi;
        i64toi32_i32$2 = i64toi32_i32$5;
        i64toi32_i32$0 = $8$hi;
        i64toi32_i32$3 = $8;
        i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
        if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
         i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
         $581 = i64toi32_i32$1 >> i64toi32_i32$4 | 0;
        } else {
         i64toi32_i32$0 = i64toi32_i32$1 >> i64toi32_i32$4 | 0;
         $581 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
        }
        $6 = $111 + $581 | 0;
        HEAP32[$107 >> 2] = $6;
        $16 = $27;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue label$7
        }
        break label$1;
       };
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
      $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
      $14 = HEAP32[($5 + -36 | 0) >> 2] | 0;
      $15 = HEAP32[($5 + -40 | 0) >> 2] | 0;
      $16 = HEAP32[($5 + -44 | 0) >> 2] | 0;
      $27 = HEAP32[($5 + -48 | 0) >> 2] | 0;
      i64toi32_i32$1 = $2;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $7 = i64toi32_i32$0;
      $7$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $17 = i64toi32_i32$2;
      $17$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $18 = i64toi32_i32$0;
      $18$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $19 = i64toi32_i32$2;
      $19$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 16 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $20 = i64toi32_i32$0;
      $20$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 20 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $21 = i64toi32_i32$2;
      $21$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 24 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $22 = i64toi32_i32$0;
      $22$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 28 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $23 = i64toi32_i32$2;
      $23$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 32 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $24 = i64toi32_i32$0;
      $24$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 36 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $25 = i64toi32_i32$2;
      $25$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 40 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $26 = i64toi32_i32$0;
      $26$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 44 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $28 = i64toi32_i32$2;
      $28$hi = i64toi32_i32$0;
      $2 = 0;
      label$8 : while (1) {
       $29 = $2 << 2 | 0;
       $253 = $5 + $29 | 0;
       $257 = HEAP32[($0 + $29 | 0) >> 2] | 0;
       $29 = $16;
       i64toi32_i32$2 = $16;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $260$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $26$hi;
       i64toi32_i32$0 = $260$hi;
       i64toi32_i32$2 = $26$hi;
       i64toi32_i32$2 = __wasm_i64_mul($16 | 0, i64toi32_i32$0 | 0, $26 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $262 = i64toi32_i32$2;
       $262$hi = i64toi32_i32$0;
       i64toi32_i32$2 = $27;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $264$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $28$hi;
       i64toi32_i32$0 = $264$hi;
       i64toi32_i32$2 = $28$hi;
       i64toi32_i32$2 = __wasm_i64_mul($27 | 0, i64toi32_i32$0 | 0, $28 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $266 = i64toi32_i32$2;
       $266$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $262$hi;
       i64toi32_i32$1 = $262;
       i64toi32_i32$2 = $266$hi;
       i64toi32_i32$3 = $266;
       i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $267$hi = i64toi32_i32$5;
       $16 = $15;
       i64toi32_i32$1 = $15;
       i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
       $270$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $25$hi;
       i64toi32_i32$5 = $270$hi;
       i64toi32_i32$1 = $25$hi;
       i64toi32_i32$1 = __wasm_i64_mul($15 | 0, i64toi32_i32$5 | 0, $25 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $272 = i64toi32_i32$1;
       $272$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $267$hi;
       i64toi32_i32$0 = i64toi32_i32$4;
       i64toi32_i32$1 = $272$hi;
       i64toi32_i32$3 = $272;
       i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $273$hi = i64toi32_i32$4;
       $15 = $14;
       i64toi32_i32$0 = $14;
       i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
       $276$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $24$hi;
       i64toi32_i32$4 = $276$hi;
       i64toi32_i32$0 = $24$hi;
       i64toi32_i32$0 = __wasm_i64_mul($14 | 0, i64toi32_i32$4 | 0, $24 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $278 = i64toi32_i32$0;
       $278$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $273$hi;
       i64toi32_i32$5 = i64toi32_i32$2;
       i64toi32_i32$0 = $278$hi;
       i64toi32_i32$3 = $278;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $279$hi = i64toi32_i32$2;
       $14 = $13;
       i64toi32_i32$5 = $13;
       i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
       $282$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $23$hi;
       i64toi32_i32$2 = $282$hi;
       i64toi32_i32$5 = $23$hi;
       i64toi32_i32$5 = __wasm_i64_mul($13 | 0, i64toi32_i32$2 | 0, $23 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $284 = i64toi32_i32$5;
       $284$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $279$hi;
       i64toi32_i32$4 = i64toi32_i32$1;
       i64toi32_i32$5 = $284$hi;
       i64toi32_i32$3 = $284;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $285$hi = i64toi32_i32$1;
       $13 = $12;
       i64toi32_i32$4 = $12;
       i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
       $288$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $22$hi;
       i64toi32_i32$1 = $288$hi;
       i64toi32_i32$4 = $22$hi;
       i64toi32_i32$4 = __wasm_i64_mul($12 | 0, i64toi32_i32$1 | 0, $22 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $290 = i64toi32_i32$4;
       $290$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $285$hi;
       i64toi32_i32$2 = i64toi32_i32$0;
       i64toi32_i32$4 = $290$hi;
       i64toi32_i32$3 = $290;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $291$hi = i64toi32_i32$0;
       $12 = $11;
       i64toi32_i32$2 = $11;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $294$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $21$hi;
       i64toi32_i32$0 = $294$hi;
       i64toi32_i32$2 = $21$hi;
       i64toi32_i32$2 = __wasm_i64_mul($11 | 0, i64toi32_i32$0 | 0, $21 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $296 = i64toi32_i32$2;
       $296$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $291$hi;
       i64toi32_i32$1 = i64toi32_i32$5;
       i64toi32_i32$2 = $296$hi;
       i64toi32_i32$3 = $296;
       i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $297$hi = i64toi32_i32$5;
       $11 = $10;
       i64toi32_i32$1 = $10;
       i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
       $300$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $20$hi;
       i64toi32_i32$5 = $300$hi;
       i64toi32_i32$1 = $20$hi;
       i64toi32_i32$1 = __wasm_i64_mul($10 | 0, i64toi32_i32$5 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $302 = i64toi32_i32$1;
       $302$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $297$hi;
       i64toi32_i32$0 = i64toi32_i32$4;
       i64toi32_i32$1 = $302$hi;
       i64toi32_i32$3 = $302;
       i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $303$hi = i64toi32_i32$4;
       $10 = $9;
       i64toi32_i32$0 = $9;
       i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
       $306$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $19$hi;
       i64toi32_i32$4 = $306$hi;
       i64toi32_i32$0 = $19$hi;
       i64toi32_i32$0 = __wasm_i64_mul($9 | 0, i64toi32_i32$4 | 0, $19 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $308 = i64toi32_i32$0;
       $308$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $303$hi;
       i64toi32_i32$5 = i64toi32_i32$2;
       i64toi32_i32$0 = $308$hi;
       i64toi32_i32$3 = $308;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $309$hi = i64toi32_i32$2;
       $9 = $4;
       i64toi32_i32$5 = $4;
       i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
       $312$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $18$hi;
       i64toi32_i32$2 = $312$hi;
       i64toi32_i32$5 = $18$hi;
       i64toi32_i32$5 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $18 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $314 = i64toi32_i32$5;
       $314$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $309$hi;
       i64toi32_i32$4 = i64toi32_i32$1;
       i64toi32_i32$5 = $314$hi;
       i64toi32_i32$3 = $314;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $315$hi = i64toi32_i32$1;
       $4 = $3;
       i64toi32_i32$4 = $3;
       i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
       $318$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $17$hi;
       i64toi32_i32$1 = $318$hi;
       i64toi32_i32$4 = $17$hi;
       i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $320 = i64toi32_i32$4;
       $320$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $315$hi;
       i64toi32_i32$2 = i64toi32_i32$0;
       i64toi32_i32$4 = $320$hi;
       i64toi32_i32$3 = $320;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $321$hi = i64toi32_i32$0;
       $3 = $6;
       i64toi32_i32$2 = $3;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $324$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $7$hi;
       i64toi32_i32$0 = $324$hi;
       i64toi32_i32$2 = $7$hi;
       i64toi32_i32$2 = __wasm_i64_mul($3 | 0, i64toi32_i32$0 | 0, $7 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $326 = i64toi32_i32$2;
       $326$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $321$hi;
       i64toi32_i32$1 = i64toi32_i32$5;
       i64toi32_i32$2 = $326$hi;
       i64toi32_i32$3 = $326;
       i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $327$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $8$hi;
       i64toi32_i32$5 = $327$hi;
       i64toi32_i32$0 = i64toi32_i32$4;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
        $582 = i64toi32_i32$5 >> i64toi32_i32$2 | 0;
       } else {
        i64toi32_i32$1 = i64toi32_i32$5 >> i64toi32_i32$2 | 0;
        $582 = (((1 << i64toi32_i32$2 | 0) - 1 | 0) & i64toi32_i32$5 | 0) << (32 - i64toi32_i32$2 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$2 | 0) | 0;
       }
       $6 = $257 + $582 | 0;
       HEAP32[$253 >> 2] = $6;
       $27 = $29;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$8
       }
       break label$1;
      };
     }
     i64toi32_i32$1 = 0;
     $8 = $4;
     $8$hi = i64toi32_i32$1;
     label$9 : {
      if (($3 | 0) == (10 | 0)) {
       break label$9
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
      $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
      $14 = HEAP32[($5 + -36 | 0) >> 2] | 0;
      i64toi32_i32$5 = $2;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $7 = i64toi32_i32$1;
      $7$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$5 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $17 = i64toi32_i32$0;
      $17$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 8 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$5 + 12 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $19 = i64toi32_i32$0;
      $19$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 16 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $20 = i64toi32_i32$1;
      $20$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$5 + 20 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $21 = i64toi32_i32$0;
      $21$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 24 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $22 = i64toi32_i32$1;
      $22$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$5 + 28 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $23 = i64toi32_i32$0;
      $23$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 32 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $24 = i64toi32_i32$1;
      $24$hi = i64toi32_i32$0;
      $2 = 0;
      label$10 : while (1) {
       $15 = $2 << 2 | 0;
       $394 = $5 + $15 | 0;
       $398 = HEAP32[($0 + $15 | 0) >> 2] | 0;
       $15 = $13;
       i64toi32_i32$1 = $13;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $401$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $23$hi;
       i64toi32_i32$0 = $401$hi;
       i64toi32_i32$1 = $23$hi;
       i64toi32_i32$1 = __wasm_i64_mul($13 | 0, i64toi32_i32$0 | 0, $23 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $403 = i64toi32_i32$1;
       $403$hi = i64toi32_i32$0;
       i64toi32_i32$1 = $14;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $405$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $24$hi;
       i64toi32_i32$0 = $405$hi;
       i64toi32_i32$1 = $24$hi;
       i64toi32_i32$1 = __wasm_i64_mul($14 | 0, i64toi32_i32$0 | 0, $24 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $407 = i64toi32_i32$1;
       $407$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $403$hi;
       i64toi32_i32$5 = $403;
       i64toi32_i32$1 = $407$hi;
       i64toi32_i32$3 = $407;
       i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $408$hi = i64toi32_i32$4;
       $13 = $12;
       i64toi32_i32$5 = $12;
       i64toi32_i32$4 = i64toi32_i32$5 >> 31 | 0;
       $411$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $22$hi;
       i64toi32_i32$4 = $411$hi;
       i64toi32_i32$5 = $22$hi;
       i64toi32_i32$5 = __wasm_i64_mul($12 | 0, i64toi32_i32$4 | 0, $22 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $413 = i64toi32_i32$5;
       $413$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $408$hi;
       i64toi32_i32$0 = i64toi32_i32$2;
       i64toi32_i32$5 = $413$hi;
       i64toi32_i32$3 = $413;
       i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $414$hi = i64toi32_i32$2;
       $12 = $11;
       i64toi32_i32$0 = $11;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $417$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $21$hi;
       i64toi32_i32$2 = $417$hi;
       i64toi32_i32$0 = $21$hi;
       i64toi32_i32$0 = __wasm_i64_mul($11 | 0, i64toi32_i32$2 | 0, $21 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $419 = i64toi32_i32$0;
       $419$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $414$hi;
       i64toi32_i32$4 = i64toi32_i32$1;
       i64toi32_i32$0 = $419$hi;
       i64toi32_i32$3 = $419;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $420$hi = i64toi32_i32$1;
       $11 = $10;
       i64toi32_i32$4 = $10;
       i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
       $423$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $20$hi;
       i64toi32_i32$1 = $423$hi;
       i64toi32_i32$4 = $20$hi;
       i64toi32_i32$4 = __wasm_i64_mul($10 | 0, i64toi32_i32$1 | 0, $20 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $425 = i64toi32_i32$4;
       $425$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $420$hi;
       i64toi32_i32$2 = i64toi32_i32$5;
       i64toi32_i32$4 = $425$hi;
       i64toi32_i32$3 = $425;
       i64toi32_i32$0 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $426$hi = i64toi32_i32$5;
       $10 = $9;
       i64toi32_i32$2 = $9;
       i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
       $429$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $19$hi;
       i64toi32_i32$5 = $429$hi;
       i64toi32_i32$2 = $19$hi;
       i64toi32_i32$2 = __wasm_i64_mul($9 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $431 = i64toi32_i32$2;
       $431$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $426$hi;
       i64toi32_i32$1 = i64toi32_i32$0;
       i64toi32_i32$2 = $431$hi;
       i64toi32_i32$3 = $431;
       i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $432$hi = i64toi32_i32$0;
       $9 = $4;
       i64toi32_i32$1 = $4;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $435$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $18$hi;
       i64toi32_i32$0 = $435$hi;
       i64toi32_i32$1 = $18$hi;
       i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$0 | 0, $18 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $437 = i64toi32_i32$1;
       $437$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $432$hi;
       i64toi32_i32$5 = i64toi32_i32$4;
       i64toi32_i32$1 = $437$hi;
       i64toi32_i32$3 = $437;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $438$hi = i64toi32_i32$4;
       $4 = $3;
       i64toi32_i32$5 = $3;
       i64toi32_i32$4 = i64toi32_i32$5 >> 31 | 0;
       $441$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $17$hi;
       i64toi32_i32$4 = $441$hi;
       i64toi32_i32$5 = $17$hi;
       i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$4 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $443 = i64toi32_i32$5;
       $443$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $438$hi;
       i64toi32_i32$0 = i64toi32_i32$2;
       i64toi32_i32$5 = $443$hi;
       i64toi32_i32$3 = $443;
       i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $444$hi = i64toi32_i32$2;
       $3 = $6;
       i64toi32_i32$0 = $3;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $447$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $7$hi;
       i64toi32_i32$2 = $447$hi;
       i64toi32_i32$0 = $7$hi;
       i64toi32_i32$0 = __wasm_i64_mul($3 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $449 = i64toi32_i32$0;
       $449$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $444$hi;
       i64toi32_i32$4 = i64toi32_i32$1;
       i64toi32_i32$0 = $449$hi;
       i64toi32_i32$3 = $449;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $450$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$1 = $450$hi;
       i64toi32_i32$2 = i64toi32_i32$5;
       i64toi32_i32$4 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
        $583 = i64toi32_i32$1 >> i64toi32_i32$0 | 0;
       } else {
        i64toi32_i32$4 = i64toi32_i32$1 >> i64toi32_i32$0 | 0;
        $583 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$0 | 0) | 0;
       }
       $6 = $398 + $583 | 0;
       HEAP32[$394 >> 2] = $6;
       $14 = $15;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$10
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
     $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
     $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
     $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
     $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
     $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
     $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
     $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
     $14 = HEAP32[($5 + -36 | 0) >> 2] | 0;
     $15 = HEAP32[($5 + -40 | 0) >> 2] | 0;
     i64toi32_i32$1 = $2;
     i64toi32_i32$4 = HEAP32[i64toi32_i32$1 >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $7 = i64toi32_i32$4;
     $7$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $17 = i64toi32_i32$2;
     $17$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $18 = i64toi32_i32$4;
     $18$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $19 = i64toi32_i32$2;
     $19$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$1 + 16 | 0) >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $20 = i64toi32_i32$4;
     $20$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 20 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $21 = i64toi32_i32$2;
     $21$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$1 + 24 | 0) >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $22 = i64toi32_i32$4;
     $22$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 28 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $23 = i64toi32_i32$2;
     $23$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$1 + 32 | 0) >> 2] | 0;
     i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
     $24 = i64toi32_i32$4;
     $24$hi = i64toi32_i32$2;
     i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 36 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
     $25 = i64toi32_i32$2;
     $25$hi = i64toi32_i32$4;
     $2 = 0;
     label$11 : while (1) {
      $16 = $2 << 2 | 0;
      $518 = $5 + $16 | 0;
      $522 = HEAP32[($0 + $16 | 0) >> 2] | 0;
      $16 = $14;
      i64toi32_i32$2 = $14;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $525$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $24$hi;
      i64toi32_i32$4 = $525$hi;
      i64toi32_i32$2 = $24$hi;
      i64toi32_i32$2 = __wasm_i64_mul($14 | 0, i64toi32_i32$4 | 0, $24 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $527 = i64toi32_i32$2;
      $527$hi = i64toi32_i32$4;
      i64toi32_i32$2 = $15;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $529$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $25$hi;
      i64toi32_i32$4 = $529$hi;
      i64toi32_i32$2 = $25$hi;
      i64toi32_i32$2 = __wasm_i64_mul($15 | 0, i64toi32_i32$4 | 0, $25 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $531 = i64toi32_i32$2;
      $531$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $527$hi;
      i64toi32_i32$1 = $527;
      i64toi32_i32$2 = $531$hi;
      i64toi32_i32$3 = $531;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $532$hi = i64toi32_i32$5;
      $14 = $13;
      i64toi32_i32$1 = $13;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $535$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $23$hi;
      i64toi32_i32$5 = $535$hi;
      i64toi32_i32$1 = $23$hi;
      i64toi32_i32$1 = __wasm_i64_mul($13 | 0, i64toi32_i32$5 | 0, $23 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $537 = i64toi32_i32$1;
      $537$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $532$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$1 = $537$hi;
      i64toi32_i32$3 = $537;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $538$hi = i64toi32_i32$0;
      $13 = $12;
      i64toi32_i32$4 = $12;
      i64toi32_i32$0 = i64toi32_i32$4 >> 31 | 0;
      $541$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $22$hi;
      i64toi32_i32$0 = $541$hi;
      i64toi32_i32$4 = $22$hi;
      i64toi32_i32$4 = __wasm_i64_mul($12 | 0, i64toi32_i32$0 | 0, $22 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $543 = i64toi32_i32$4;
      $543$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $538$hi;
      i64toi32_i32$5 = i64toi32_i32$2;
      i64toi32_i32$4 = $543$hi;
      i64toi32_i32$3 = $543;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $544$hi = i64toi32_i32$2;
      $12 = $11;
      i64toi32_i32$5 = $11;
      i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
      $547$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $21$hi;
      i64toi32_i32$2 = $547$hi;
      i64toi32_i32$5 = $21$hi;
      i64toi32_i32$5 = __wasm_i64_mul($11 | 0, i64toi32_i32$2 | 0, $21 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $549 = i64toi32_i32$5;
      $549$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $544$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$5 = $549$hi;
      i64toi32_i32$3 = $549;
      i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $550$hi = i64toi32_i32$1;
      $11 = $10;
      i64toi32_i32$0 = $10;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $553$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $20$hi;
      i64toi32_i32$1 = $553$hi;
      i64toi32_i32$0 = $20$hi;
      i64toi32_i32$0 = __wasm_i64_mul($10 | 0, i64toi32_i32$1 | 0, $20 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $555 = i64toi32_i32$0;
      $555$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $550$hi;
      i64toi32_i32$2 = i64toi32_i32$4;
      i64toi32_i32$0 = $555$hi;
      i64toi32_i32$3 = $555;
      i64toi32_i32$5 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $556$hi = i64toi32_i32$4;
      $10 = $9;
      i64toi32_i32$2 = $9;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $559$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $19$hi;
      i64toi32_i32$4 = $559$hi;
      i64toi32_i32$2 = $19$hi;
      i64toi32_i32$2 = __wasm_i64_mul($9 | 0, i64toi32_i32$4 | 0, $19 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $561 = i64toi32_i32$2;
      $561$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $556$hi;
      i64toi32_i32$1 = i64toi32_i32$5;
      i64toi32_i32$2 = $561$hi;
      i64toi32_i32$3 = $561;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $562$hi = i64toi32_i32$5;
      $9 = $4;
      i64toi32_i32$1 = $4;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $565$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $18$hi;
      i64toi32_i32$5 = $565$hi;
      i64toi32_i32$1 = $18$hi;
      i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$5 | 0, $18 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $567 = i64toi32_i32$1;
      $567$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $562$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$1 = $567$hi;
      i64toi32_i32$3 = $567;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $568$hi = i64toi32_i32$0;
      $4 = $3;
      i64toi32_i32$4 = $3;
      i64toi32_i32$0 = i64toi32_i32$4 >> 31 | 0;
      $571$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $17$hi;
      i64toi32_i32$0 = $571$hi;
      i64toi32_i32$4 = $17$hi;
      i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$0 | 0, $17 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $573 = i64toi32_i32$4;
      $573$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $568$hi;
      i64toi32_i32$5 = i64toi32_i32$2;
      i64toi32_i32$4 = $573$hi;
      i64toi32_i32$3 = $573;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $574$hi = i64toi32_i32$2;
      $3 = $6;
      i64toi32_i32$5 = $3;
      i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
      $577$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $7$hi;
      i64toi32_i32$2 = $577$hi;
      i64toi32_i32$5 = $7$hi;
      i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $579 = i64toi32_i32$5;
      $579$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $574$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$5 = $579$hi;
      i64toi32_i32$3 = $579;
      i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $580$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$1 = $580$hi;
      i64toi32_i32$2 = i64toi32_i32$4;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $584 = i64toi32_i32$1 >> i64toi32_i32$5 | 0;
      } else {
       i64toi32_i32$0 = i64toi32_i32$1 >> i64toi32_i32$5 | 0;
       $584 = (((1 << i64toi32_i32$5 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$5 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$5 | 0) | 0;
      }
      $6 = $522 + $584 | 0;
      HEAP32[$518 >> 2] = $6;
      $15 = $16;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue label$11
      }
      break label$1;
     };
    }
    label$12 : {
     if ($3 >>> 0 < 5 >>> 0) {
      break label$12
     }
     label$13 : {
      if ($3 >>> 0 < 7 >>> 0) {
       break label$13
      }
      i64toi32_i32$0 = 0;
      $8 = $4;
      $8$hi = i64toi32_i32$0;
      label$14 : {
       if (($3 | 0) == (8 | 0)) {
        break label$14
       }
       if (($1 | 0) < (1 | 0)) {
        break label$1
       }
       $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
       $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
       $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
       $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
       $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
       $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
       $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
       i64toi32_i32$1 = $2;
       i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $7 = i64toi32_i32$0;
       $7$hi = i64toi32_i32$2;
       i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $17 = i64toi32_i32$2;
       $17$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] | 0;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $18 = i64toi32_i32$0;
       $18$hi = i64toi32_i32$2;
       i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $19 = i64toi32_i32$2;
       $19$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 16 | 0) >> 2] | 0;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $20 = i64toi32_i32$0;
       $20$hi = i64toi32_i32$2;
       i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 20 | 0) >> 2] | 0;
       i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
       $21 = i64toi32_i32$2;
       $21$hi = i64toi32_i32$0;
       i64toi32_i32$0 = HEAP32[(i64toi32_i32$1 + 24 | 0) >> 2] | 0;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $22 = i64toi32_i32$0;
       $22$hi = i64toi32_i32$2;
       $2 = 0;
       label$15 : while (1) {
        $13 = $2 << 2 | 0;
        $641 = $5 + $13 | 0;
        $645 = HEAP32[($0 + $13 | 0) >> 2] | 0;
        $13 = $11;
        i64toi32_i32$0 = $11;
        i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
        $648$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $21$hi;
        i64toi32_i32$2 = $648$hi;
        i64toi32_i32$0 = $21$hi;
        i64toi32_i32$0 = __wasm_i64_mul($11 | 0, i64toi32_i32$2 | 0, $21 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $650 = i64toi32_i32$0;
        $650$hi = i64toi32_i32$2;
        i64toi32_i32$0 = $12;
        i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
        $652$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $22$hi;
        i64toi32_i32$2 = $652$hi;
        i64toi32_i32$0 = $22$hi;
        i64toi32_i32$0 = __wasm_i64_mul($12 | 0, i64toi32_i32$2 | 0, $22 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $654 = i64toi32_i32$0;
        $654$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $650$hi;
        i64toi32_i32$1 = $650;
        i64toi32_i32$0 = $654$hi;
        i64toi32_i32$3 = $654;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
        if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
        }
        $655$hi = i64toi32_i32$4;
        $11 = $10;
        i64toi32_i32$1 = $10;
        i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
        $658$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $20$hi;
        i64toi32_i32$4 = $658$hi;
        i64toi32_i32$1 = $20$hi;
        i64toi32_i32$1 = __wasm_i64_mul($10 | 0, i64toi32_i32$4 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
        i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
        $660 = i64toi32_i32$1;
        $660$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $655$hi;
        i64toi32_i32$2 = i64toi32_i32$5;
        i64toi32_i32$1 = $660$hi;
        i64toi32_i32$3 = $660;
        i64toi32_i32$0 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
        i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
        if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
        }
        $661$hi = i64toi32_i32$5;
        $10 = $9;
        i64toi32_i32$2 = $9;
        i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
        $664$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $19$hi;
        i64toi32_i32$5 = $664$hi;
        i64toi32_i32$2 = $19$hi;
        i64toi32_i32$2 = __wasm_i64_mul($9 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$2 | 0) | 0;
        i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
        $666 = i64toi32_i32$2;
        $666$hi = i64toi32_i32$5;
        i64toi32_i32$5 = $661$hi;
        i64toi32_i32$4 = i64toi32_i32$0;
        i64toi32_i32$2 = $666$hi;
        i64toi32_i32$3 = $666;
        i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
        i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
        if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
        }
        $667$hi = i64toi32_i32$0;
        $9 = $4;
        i64toi32_i32$4 = $4;
        i64toi32_i32$0 = i64toi32_i32$4 >> 31 | 0;
        $670$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $18$hi;
        i64toi32_i32$0 = $670$hi;
        i64toi32_i32$4 = $18$hi;
        i64toi32_i32$4 = __wasm_i64_mul($4 | 0, i64toi32_i32$0 | 0, $18 | 0, i64toi32_i32$4 | 0) | 0;
        i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
        $672 = i64toi32_i32$4;
        $672$hi = i64toi32_i32$0;
        i64toi32_i32$0 = $667$hi;
        i64toi32_i32$5 = i64toi32_i32$1;
        i64toi32_i32$4 = $672$hi;
        i64toi32_i32$3 = $672;
        i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$4 | 0;
        if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
        }
        $673$hi = i64toi32_i32$1;
        $4 = $3;
        i64toi32_i32$5 = $3;
        i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
        $676$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $17$hi;
        i64toi32_i32$1 = $676$hi;
        i64toi32_i32$5 = $17$hi;
        i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
        i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
        $678 = i64toi32_i32$5;
        $678$hi = i64toi32_i32$1;
        i64toi32_i32$1 = $673$hi;
        i64toi32_i32$0 = i64toi32_i32$2;
        i64toi32_i32$5 = $678$hi;
        i64toi32_i32$3 = $678;
        i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
        i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
        if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
        }
        $679$hi = i64toi32_i32$2;
        $3 = $6;
        i64toi32_i32$0 = $3;
        i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
        $682$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $7$hi;
        i64toi32_i32$2 = $682$hi;
        i64toi32_i32$0 = $7$hi;
        i64toi32_i32$0 = __wasm_i64_mul($3 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$0 | 0) | 0;
        i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
        $684 = i64toi32_i32$0;
        $684$hi = i64toi32_i32$2;
        i64toi32_i32$2 = $679$hi;
        i64toi32_i32$1 = i64toi32_i32$4;
        i64toi32_i32$0 = $684$hi;
        i64toi32_i32$3 = $684;
        i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
        i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
        if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
         i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
        }
        $685$hi = i64toi32_i32$4;
        i64toi32_i32$4 = $8$hi;
        i64toi32_i32$4 = $685$hi;
        i64toi32_i32$2 = i64toi32_i32$5;
        i64toi32_i32$1 = $8$hi;
        i64toi32_i32$3 = $8;
        i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
        if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
         i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
         $585 = i64toi32_i32$4 >> i64toi32_i32$0 | 0;
        } else {
         i64toi32_i32$1 = i64toi32_i32$4 >> i64toi32_i32$0 | 0;
         $585 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$4 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$0 | 0) | 0;
        }
        $6 = $645 + $585 | 0;
        HEAP32[$641 >> 2] = $6;
        $12 = $13;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue label$15
        }
        break label$1;
       };
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
      $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
      $12 = HEAP32[($5 + -28 | 0) >> 2] | 0;
      $13 = HEAP32[($5 + -32 | 0) >> 2] | 0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$1 >> 31 | 0;
      $7 = i64toi32_i32$1;
      $7$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$4 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $17 = i64toi32_i32$2;
      $17$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$4 + 8 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$4 + 12 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $19 = i64toi32_i32$2;
      $19$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$4 + 16 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$1 >> 31 | 0;
      $20 = i64toi32_i32$1;
      $20$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$4 + 20 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $21 = i64toi32_i32$2;
      $21$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$4 + 24 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$1 >> 31 | 0;
      $22 = i64toi32_i32$1;
      $22$hi = i64toi32_i32$2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$4 + 28 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $23 = i64toi32_i32$2;
      $23$hi = i64toi32_i32$1;
      $2 = 0;
      label$16 : while (1) {
       $14 = $2 << 2 | 0;
       $743 = $5 + $14 | 0;
       $747 = HEAP32[($0 + $14 | 0) >> 2] | 0;
       $14 = $12;
       i64toi32_i32$2 = $12;
       i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
       $750$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $22$hi;
       i64toi32_i32$1 = $750$hi;
       i64toi32_i32$2 = $22$hi;
       i64toi32_i32$2 = __wasm_i64_mul($12 | 0, i64toi32_i32$1 | 0, $22 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $752 = i64toi32_i32$2;
       $752$hi = i64toi32_i32$1;
       i64toi32_i32$2 = $13;
       i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
       $754$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $23$hi;
       i64toi32_i32$1 = $754$hi;
       i64toi32_i32$2 = $23$hi;
       i64toi32_i32$2 = __wasm_i64_mul($13 | 0, i64toi32_i32$1 | 0, $23 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $756 = i64toi32_i32$2;
       $756$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $752$hi;
       i64toi32_i32$4 = $752;
       i64toi32_i32$2 = $756$hi;
       i64toi32_i32$3 = $756;
       i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $757$hi = i64toi32_i32$5;
       $12 = $11;
       i64toi32_i32$4 = $11;
       i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
       $760$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $21$hi;
       i64toi32_i32$5 = $760$hi;
       i64toi32_i32$4 = $21$hi;
       i64toi32_i32$4 = __wasm_i64_mul($11 | 0, i64toi32_i32$5 | 0, $21 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $762 = i64toi32_i32$4;
       $762$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $757$hi;
       i64toi32_i32$1 = i64toi32_i32$0;
       i64toi32_i32$4 = $762$hi;
       i64toi32_i32$3 = $762;
       i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $763$hi = i64toi32_i32$0;
       $11 = $10;
       i64toi32_i32$1 = $10;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $766$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $20$hi;
       i64toi32_i32$0 = $766$hi;
       i64toi32_i32$1 = $20$hi;
       i64toi32_i32$1 = __wasm_i64_mul($10 | 0, i64toi32_i32$0 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $768 = i64toi32_i32$1;
       $768$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $763$hi;
       i64toi32_i32$5 = i64toi32_i32$2;
       i64toi32_i32$1 = $768$hi;
       i64toi32_i32$3 = $768;
       i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $769$hi = i64toi32_i32$2;
       $10 = $9;
       i64toi32_i32$5 = $9;
       i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
       $772$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $19$hi;
       i64toi32_i32$2 = $772$hi;
       i64toi32_i32$5 = $19$hi;
       i64toi32_i32$5 = __wasm_i64_mul($9 | 0, i64toi32_i32$2 | 0, $19 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $774 = i64toi32_i32$5;
       $774$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $769$hi;
       i64toi32_i32$0 = i64toi32_i32$4;
       i64toi32_i32$5 = $774$hi;
       i64toi32_i32$3 = $774;
       i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $775$hi = i64toi32_i32$4;
       $9 = $4;
       i64toi32_i32$0 = $4;
       i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
       $778$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $18$hi;
       i64toi32_i32$4 = $778$hi;
       i64toi32_i32$0 = $18$hi;
       i64toi32_i32$0 = __wasm_i64_mul($4 | 0, i64toi32_i32$4 | 0, $18 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $780 = i64toi32_i32$0;
       $780$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $775$hi;
       i64toi32_i32$2 = i64toi32_i32$1;
       i64toi32_i32$0 = $780$hi;
       i64toi32_i32$3 = $780;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $781$hi = i64toi32_i32$1;
       $4 = $3;
       i64toi32_i32$2 = $3;
       i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
       $784$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $17$hi;
       i64toi32_i32$1 = $784$hi;
       i64toi32_i32$2 = $17$hi;
       i64toi32_i32$2 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $786 = i64toi32_i32$2;
       $786$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $781$hi;
       i64toi32_i32$4 = i64toi32_i32$5;
       i64toi32_i32$2 = $786$hi;
       i64toi32_i32$3 = $786;
       i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $787$hi = i64toi32_i32$5;
       $3 = $6;
       i64toi32_i32$4 = $3;
       i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
       $790$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $7$hi;
       i64toi32_i32$5 = $790$hi;
       i64toi32_i32$4 = $7$hi;
       i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$5 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $792 = i64toi32_i32$4;
       $792$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $787$hi;
       i64toi32_i32$1 = i64toi32_i32$0;
       i64toi32_i32$4 = $792$hi;
       i64toi32_i32$3 = $792;
       i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $793$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $8$hi;
       i64toi32_i32$0 = $793$hi;
       i64toi32_i32$5 = i64toi32_i32$2;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
        $586 = i64toi32_i32$0 >> i64toi32_i32$4 | 0;
       } else {
        i64toi32_i32$1 = i64toi32_i32$0 >> i64toi32_i32$4 | 0;
        $586 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$5 >>> i64toi32_i32$4 | 0) | 0;
       }
       $6 = $747 + $586 | 0;
       HEAP32[$743 >> 2] = $6;
       $13 = $14;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$16
       }
       break label$1;
      };
     }
     i64toi32_i32$1 = 0;
     $8 = $4;
     $8$hi = i64toi32_i32$1;
     label$17 : {
      if (($3 | 0) == (6 | 0)) {
       break label$17
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
      $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $7 = i64toi32_i32$1;
      $7$hi = i64toi32_i32$5;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $17 = i64toi32_i32$5;
      $17$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 8 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$5;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$0 + 12 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $19 = i64toi32_i32$5;
      $19$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 16 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $20 = i64toi32_i32$1;
      $20$hi = i64toi32_i32$5;
      $2 = 0;
      label$18 : while (1) {
       $11 = $2 << 2 | 0;
       $840 = $5 + $11 | 0;
       $844 = HEAP32[($0 + $11 | 0) >> 2] | 0;
       $11 = $9;
       i64toi32_i32$1 = $9;
       i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
       $847$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $19$hi;
       i64toi32_i32$5 = $847$hi;
       i64toi32_i32$1 = $19$hi;
       i64toi32_i32$1 = __wasm_i64_mul($9 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $849 = i64toi32_i32$1;
       $849$hi = i64toi32_i32$5;
       i64toi32_i32$1 = $10;
       i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
       $851$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $20$hi;
       i64toi32_i32$5 = $851$hi;
       i64toi32_i32$1 = $20$hi;
       i64toi32_i32$1 = __wasm_i64_mul($10 | 0, i64toi32_i32$5 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $853 = i64toi32_i32$1;
       $853$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $849$hi;
       i64toi32_i32$0 = $849;
       i64toi32_i32$1 = $853$hi;
       i64toi32_i32$3 = $853;
       i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $854$hi = i64toi32_i32$2;
       $9 = $4;
       i64toi32_i32$0 = $4;
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $857$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $18$hi;
       i64toi32_i32$2 = $857$hi;
       i64toi32_i32$0 = $18$hi;
       i64toi32_i32$0 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $18 | 0, i64toi32_i32$0 | 0) | 0;
       i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
       $859 = i64toi32_i32$0;
       $859$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $854$hi;
       i64toi32_i32$5 = i64toi32_i32$4;
       i64toi32_i32$0 = $859$hi;
       i64toi32_i32$3 = $859;
       i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
       }
       $860$hi = i64toi32_i32$4;
       $4 = $3;
       i64toi32_i32$5 = $3;
       i64toi32_i32$4 = i64toi32_i32$5 >> 31 | 0;
       $863$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $17$hi;
       i64toi32_i32$4 = $863$hi;
       i64toi32_i32$5 = $17$hi;
       i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$4 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $865 = i64toi32_i32$5;
       $865$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $860$hi;
       i64toi32_i32$2 = i64toi32_i32$1;
       i64toi32_i32$5 = $865$hi;
       i64toi32_i32$3 = $865;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
       i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$5 | 0;
       if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
       }
       $866$hi = i64toi32_i32$1;
       $3 = $6;
       i64toi32_i32$2 = $3;
       i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
       $869$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $7$hi;
       i64toi32_i32$1 = $869$hi;
       i64toi32_i32$2 = $7$hi;
       i64toi32_i32$2 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $7 | 0, i64toi32_i32$2 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $871 = i64toi32_i32$2;
       $871$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $866$hi;
       i64toi32_i32$4 = i64toi32_i32$0;
       i64toi32_i32$2 = $871$hi;
       i64toi32_i32$3 = $871;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
       if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
       }
       $872$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $8$hi;
       i64toi32_i32$0 = $872$hi;
       i64toi32_i32$1 = i64toi32_i32$5;
       i64toi32_i32$4 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
        $587 = i64toi32_i32$0 >> i64toi32_i32$2 | 0;
       } else {
        i64toi32_i32$4 = i64toi32_i32$0 >> i64toi32_i32$2 | 0;
        $587 = (((1 << i64toi32_i32$2 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$2 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$2 | 0) | 0;
       }
       $6 = $844 + $587 | 0;
       HEAP32[$840 >> 2] = $6;
       $10 = $11;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$18
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
     $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
     $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
     $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
     $10 = HEAP32[($5 + -20 | 0) >> 2] | 0;
     $11 = HEAP32[($5 + -24 | 0) >> 2] | 0;
     i64toi32_i32$0 = $2;
     i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
     i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
     $7 = i64toi32_i32$4;
     $7$hi = i64toi32_i32$1;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
     $17 = i64toi32_i32$1;
     $17$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$0 + 8 | 0) >> 2] | 0;
     i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
     $18 = i64toi32_i32$4;
     $18$hi = i64toi32_i32$1;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 12 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
     $19 = i64toi32_i32$1;
     $19$hi = i64toi32_i32$4;
     i64toi32_i32$4 = HEAP32[(i64toi32_i32$0 + 16 | 0) >> 2] | 0;
     i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
     $20 = i64toi32_i32$4;
     $20$hi = i64toi32_i32$1;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 20 | 0) >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
     $21 = i64toi32_i32$1;
     $21$hi = i64toi32_i32$4;
     $2 = 0;
     label$19 : while (1) {
      $12 = $2 << 2 | 0;
      $920 = $5 + $12 | 0;
      $924 = HEAP32[($0 + $12 | 0) >> 2] | 0;
      $12 = $10;
      i64toi32_i32$1 = $10;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $927$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $20$hi;
      i64toi32_i32$4 = $927$hi;
      i64toi32_i32$1 = $20$hi;
      i64toi32_i32$1 = __wasm_i64_mul($10 | 0, i64toi32_i32$4 | 0, $20 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $929 = i64toi32_i32$1;
      $929$hi = i64toi32_i32$4;
      i64toi32_i32$1 = $11;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $931$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $21$hi;
      i64toi32_i32$4 = $931$hi;
      i64toi32_i32$1 = $21$hi;
      i64toi32_i32$1 = __wasm_i64_mul($11 | 0, i64toi32_i32$4 | 0, $21 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $933 = i64toi32_i32$1;
      $933$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $929$hi;
      i64toi32_i32$0 = $929;
      i64toi32_i32$1 = $933$hi;
      i64toi32_i32$3 = $933;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $934$hi = i64toi32_i32$5;
      $10 = $9;
      i64toi32_i32$0 = $9;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $937$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $19$hi;
      i64toi32_i32$5 = $937$hi;
      i64toi32_i32$0 = $19$hi;
      i64toi32_i32$0 = __wasm_i64_mul($9 | 0, i64toi32_i32$5 | 0, $19 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $939 = i64toi32_i32$0;
      $939$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $934$hi;
      i64toi32_i32$4 = i64toi32_i32$2;
      i64toi32_i32$0 = $939$hi;
      i64toi32_i32$3 = $939;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $940$hi = i64toi32_i32$2;
      $9 = $4;
      i64toi32_i32$4 = $4;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $943$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $18$hi;
      i64toi32_i32$2 = $943$hi;
      i64toi32_i32$4 = $18$hi;
      i64toi32_i32$4 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $18 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $945 = i64toi32_i32$4;
      $945$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $940$hi;
      i64toi32_i32$5 = i64toi32_i32$1;
      i64toi32_i32$4 = $945$hi;
      i64toi32_i32$3 = $945;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $946$hi = i64toi32_i32$1;
      $4 = $3;
      i64toi32_i32$5 = $3;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $949$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $17$hi;
      i64toi32_i32$1 = $949$hi;
      i64toi32_i32$5 = $17$hi;
      i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $951 = i64toi32_i32$5;
      $951$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $946$hi;
      i64toi32_i32$2 = i64toi32_i32$0;
      i64toi32_i32$5 = $951$hi;
      i64toi32_i32$3 = $951;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $952$hi = i64toi32_i32$0;
      $3 = $6;
      i64toi32_i32$2 = $3;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $955$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $7$hi;
      i64toi32_i32$0 = $955$hi;
      i64toi32_i32$2 = $7$hi;
      i64toi32_i32$2 = __wasm_i64_mul($3 | 0, i64toi32_i32$0 | 0, $7 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $957 = i64toi32_i32$2;
      $957$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $952$hi;
      i64toi32_i32$1 = i64toi32_i32$4;
      i64toi32_i32$2 = $957$hi;
      i64toi32_i32$3 = $957;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $958$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $958$hi;
      i64toi32_i32$0 = i64toi32_i32$5;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
       $588 = i64toi32_i32$4 >> i64toi32_i32$2 | 0;
      } else {
       i64toi32_i32$1 = i64toi32_i32$4 >> i64toi32_i32$2 | 0;
       $588 = (((1 << i64toi32_i32$2 | 0) - 1 | 0) & i64toi32_i32$4 | 0) << (32 - i64toi32_i32$2 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$2 | 0) | 0;
      }
      $6 = $924 + $588 | 0;
      HEAP32[$920 >> 2] = $6;
      $11 = $12;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue label$19
      }
      break label$1;
     };
    }
    label$20 : {
     if ($3 >>> 0 < 3 >>> 0) {
      break label$20
     }
     i64toi32_i32$1 = 0;
     $8 = $4;
     $8$hi = i64toi32_i32$1;
     label$21 : {
      if (($3 | 0) == (4 | 0)) {
       break label$21
      }
      if (($1 | 0) < (1 | 0)) {
       break label$1
      }
      $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
      $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
      $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $7 = i64toi32_i32$1;
      $7$hi = i64toi32_i32$0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$0 >> 31 | 0;
      $17 = i64toi32_i32$0;
      $17$hi = i64toi32_i32$1;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$4 + 8 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$0;
      $2 = 0;
      label$22 : while (1) {
       $9 = $2 << 2 | 0;
       $997 = $5 + $9 | 0;
       $1001 = HEAP32[($0 + $9 | 0) >> 2] | 0;
       $9 = $3;
       i64toi32_i32$1 = $3;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $1004$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $17$hi;
       i64toi32_i32$0 = $1004$hi;
       i64toi32_i32$1 = $17$hi;
       i64toi32_i32$1 = __wasm_i64_mul($3 | 0, i64toi32_i32$0 | 0, $17 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $1006 = i64toi32_i32$1;
       $1006$hi = i64toi32_i32$0;
       i64toi32_i32$1 = $4;
       i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
       $1008$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $18$hi;
       i64toi32_i32$0 = $1008$hi;
       i64toi32_i32$1 = $18$hi;
       i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$0 | 0, $18 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
       $1010 = i64toi32_i32$1;
       $1010$hi = i64toi32_i32$0;
       i64toi32_i32$0 = $1006$hi;
       i64toi32_i32$4 = $1006;
       i64toi32_i32$1 = $1010$hi;
       i64toi32_i32$3 = $1010;
       i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
       i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
       }
       $1011$hi = i64toi32_i32$5;
       $3 = $6;
       i64toi32_i32$4 = $3;
       i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
       $1014$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $7$hi;
       i64toi32_i32$5 = $1014$hi;
       i64toi32_i32$4 = $7$hi;
       i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$5 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
       i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
       $1016 = i64toi32_i32$4;
       $1016$hi = i64toi32_i32$5;
       i64toi32_i32$5 = $1011$hi;
       i64toi32_i32$0 = i64toi32_i32$2;
       i64toi32_i32$4 = $1016$hi;
       i64toi32_i32$3 = $1016;
       i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
       i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
       if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
        i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
       }
       $1017$hi = i64toi32_i32$2;
       i64toi32_i32$2 = $8$hi;
       i64toi32_i32$2 = $1017$hi;
       i64toi32_i32$5 = i64toi32_i32$1;
       i64toi32_i32$0 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
        $589 = i64toi32_i32$2 >> i64toi32_i32$4 | 0;
       } else {
        i64toi32_i32$0 = i64toi32_i32$2 >> i64toi32_i32$4 | 0;
        $589 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$5 >>> i64toi32_i32$4 | 0) | 0;
       }
       $6 = $1001 + $589 | 0;
       HEAP32[$997 >> 2] = $6;
       $4 = $9;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$22
       }
       break label$1;
      };
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $6 = HEAP32[($5 + -4 | 0) >> 2] | 0;
     $3 = HEAP32[($5 + -8 | 0) >> 2] | 0;
     $4 = HEAP32[($5 + -12 | 0) >> 2] | 0;
     $9 = HEAP32[($5 + -16 | 0) >> 2] | 0;
     i64toi32_i32$2 = $2;
     i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
     i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
     $7 = i64toi32_i32$0;
     $7$hi = i64toi32_i32$5;
     i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
     i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
     $17 = i64toi32_i32$5;
     $17$hi = i64toi32_i32$0;
     i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 8 | 0) >> 2] | 0;
     i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
     $18 = i64toi32_i32$0;
     $18$hi = i64toi32_i32$5;
     i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 12 | 0) >> 2] | 0;
     i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
     $19 = i64toi32_i32$5;
     $19$hi = i64toi32_i32$0;
     $2 = 0;
     label$23 : while (1) {
      $10 = $2 << 2 | 0;
      $1055 = $5 + $10 | 0;
      $1059 = HEAP32[($0 + $10 | 0) >> 2] | 0;
      $10 = $4;
      i64toi32_i32$5 = $4;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1062$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $18$hi;
      i64toi32_i32$0 = $1062$hi;
      i64toi32_i32$5 = $18$hi;
      i64toi32_i32$5 = __wasm_i64_mul($4 | 0, i64toi32_i32$0 | 0, $18 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1064 = i64toi32_i32$5;
      $1064$hi = i64toi32_i32$0;
      i64toi32_i32$5 = $9;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1066$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $19$hi;
      i64toi32_i32$0 = $1066$hi;
      i64toi32_i32$5 = $19$hi;
      i64toi32_i32$5 = __wasm_i64_mul($9 | 0, i64toi32_i32$0 | 0, $19 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1068 = i64toi32_i32$5;
      $1068$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1064$hi;
      i64toi32_i32$2 = $1064;
      i64toi32_i32$5 = $1068$hi;
      i64toi32_i32$3 = $1068;
      i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $1069$hi = i64toi32_i32$1;
      $4 = $3;
      i64toi32_i32$2 = $3;
      i64toi32_i32$1 = i64toi32_i32$2 >> 31 | 0;
      $1072$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $17$hi;
      i64toi32_i32$1 = $1072$hi;
      i64toi32_i32$2 = $17$hi;
      i64toi32_i32$2 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $17 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1074 = i64toi32_i32$2;
      $1074$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1069$hi;
      i64toi32_i32$0 = i64toi32_i32$4;
      i64toi32_i32$2 = $1074$hi;
      i64toi32_i32$3 = $1074;
      i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $1075$hi = i64toi32_i32$4;
      $3 = $6;
      i64toi32_i32$0 = $3;
      i64toi32_i32$4 = i64toi32_i32$0 >> 31 | 0;
      $1078$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $7$hi;
      i64toi32_i32$4 = $1078$hi;
      i64toi32_i32$0 = $7$hi;
      i64toi32_i32$0 = __wasm_i64_mul($3 | 0, i64toi32_i32$4 | 0, $7 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1080 = i64toi32_i32$0;
      $1080$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1075$hi;
      i64toi32_i32$1 = i64toi32_i32$5;
      i64toi32_i32$0 = $1080$hi;
      i64toi32_i32$3 = $1080;
      i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $1081$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1081$hi;
      i64toi32_i32$4 = i64toi32_i32$2;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
       $590 = i64toi32_i32$5 >> i64toi32_i32$0 | 0;
      } else {
       i64toi32_i32$1 = i64toi32_i32$5 >> i64toi32_i32$0 | 0;
       $590 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$5 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$4 >>> i64toi32_i32$0 | 0) | 0;
      }
      $6 = $1059 + $590 | 0;
      HEAP32[$1055 >> 2] = $6;
      $9 = $10;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue label$23
      }
      break label$1;
     };
    }
    i64toi32_i32$1 = 0;
    $8 = $4;
    $8$hi = i64toi32_i32$1;
    label$24 : {
     if (($3 | 0) == (2 | 0)) {
      break label$24
     }
     if (($1 | 0) < (1 | 0)) {
      break label$1
     }
     $4 = $1 & 1 | 0;
     $3 = HEAP32[($5 + -4 | 0) >> 2] | 0;
     i64toi32_i32$5 = $2;
     i64toi32_i32$1 = HEAP32[i64toi32_i32$5 >> 2] | 0;
     i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
     $7 = i64toi32_i32$1;
     $7$hi = i64toi32_i32$4;
     $2 = 0;
     label$25 : {
      if (($1 | 0) == (1 | 0)) {
       break label$25
      }
      $1 = $1 & -2 | 0;
      $2 = 0;
      label$26 : while (1) {
       $6 = $2 << 2 | 0;
       $1114 = $5 + $6 | 0;
       $1118 = HEAP32[($0 + $6 | 0) >> 2] | 0;
       i64toi32_i32$1 = $3;
       i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
       $1120$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $7$hi;
       i64toi32_i32$4 = $1120$hi;
       i64toi32_i32$1 = $7$hi;
       i64toi32_i32$1 = __wasm_i64_mul($3 | 0, i64toi32_i32$4 | 0, $7 | 0, i64toi32_i32$1 | 0) | 0;
       i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
       $1122$hi = i64toi32_i32$4;
       i64toi32_i32$4 = $8$hi;
       i64toi32_i32$4 = $1122$hi;
       i64toi32_i32$5 = i64toi32_i32$1;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
        $591 = i64toi32_i32$4 >> i64toi32_i32$0 | 0;
       } else {
        i64toi32_i32$1 = i64toi32_i32$4 >> i64toi32_i32$0 | 0;
        $591 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$4 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$5 >>> i64toi32_i32$0 | 0) | 0;
       }
       $3 = $1118 + $591 | 0;
       HEAP32[$1114 >> 2] = $3;
       $6 = $6 | 4 | 0;
       $1132 = $5 + $6 | 0;
       $1136 = HEAP32[($0 + $6 | 0) >> 2] | 0;
       i64toi32_i32$5 = $3;
       i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
       $1138$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $7$hi;
       i64toi32_i32$1 = $1138$hi;
       i64toi32_i32$5 = $7$hi;
       i64toi32_i32$5 = __wasm_i64_mul($3 | 0, i64toi32_i32$1 | 0, $7 | 0, i64toi32_i32$5 | 0) | 0;
       i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
       $1140$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $8$hi;
       i64toi32_i32$1 = $1140$hi;
       i64toi32_i32$4 = i64toi32_i32$5;
       i64toi32_i32$5 = $8$hi;
       i64toi32_i32$3 = $8;
       i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
       if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
        i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
        $592 = i64toi32_i32$1 >> i64toi32_i32$0 | 0;
       } else {
        i64toi32_i32$5 = i64toi32_i32$1 >> i64toi32_i32$0 | 0;
        $592 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$4 >>> i64toi32_i32$0 | 0) | 0;
       }
       $3 = $1136 + $592 | 0;
       HEAP32[$1132 >> 2] = $3;
       $2 = $2 + 2 | 0;
       $1 = $1 + -2 | 0;
       if ($1) {
        continue label$26
       }
       break label$26;
      };
     }
     if (!$4) {
      break label$1
     }
     $2 = $2 << 2 | 0;
     $1157 = $5 + $2 | 0;
     $1161 = HEAP32[($0 + $2 | 0) >> 2] | 0;
     i64toi32_i32$4 = $3;
     i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
     $1163$hi = i64toi32_i32$5;
     i64toi32_i32$5 = $7$hi;
     i64toi32_i32$5 = $1163$hi;
     i64toi32_i32$4 = $7$hi;
     i64toi32_i32$4 = __wasm_i64_mul($3 | 0, i64toi32_i32$5 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
     i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
     $1165$hi = i64toi32_i32$5;
     i64toi32_i32$5 = $8$hi;
     i64toi32_i32$5 = $1165$hi;
     i64toi32_i32$1 = i64toi32_i32$4;
     i64toi32_i32$4 = $8$hi;
     i64toi32_i32$3 = $8;
     i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
     if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
      i64toi32_i32$4 = i64toi32_i32$5 >> 31 | 0;
      $593 = i64toi32_i32$5 >> i64toi32_i32$0 | 0;
     } else {
      i64toi32_i32$4 = i64toi32_i32$5 >> i64toi32_i32$0 | 0;
      $593 = (((1 << i64toi32_i32$0 | 0) - 1 | 0) & i64toi32_i32$5 | 0) << (32 - i64toi32_i32$0 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$0 | 0) | 0;
     }
     HEAP32[$1157 >> 2] = $1161 + $593 | 0;
     break label$1;
    }
    if (($1 | 0) < (1 | 0)) {
     break label$1
    }
    $9 = $1 & 1 | 0;
    $4 = HEAP32[($5 + -4 | 0) >> 2] | 0;
    $6 = HEAP32[($5 + -8 | 0) >> 2] | 0;
    i64toi32_i32$5 = $2;
    i64toi32_i32$4 = HEAP32[i64toi32_i32$5 >> 2] | 0;
    i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
    $7 = i64toi32_i32$4;
    $7$hi = i64toi32_i32$1;
    i64toi32_i32$1 = HEAP32[(i64toi32_i32$5 + 4 | 0) >> 2] | 0;
    i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
    $17 = i64toi32_i32$1;
    $17$hi = i64toi32_i32$4;
    $2 = 0;
    label$27 : {
     if (($1 | 0) == (1 | 0)) {
      break label$27
     }
     $1 = $1 & -2 | 0;
     $2 = 0;
     label$28 : while (1) {
      $3 = $2 << 2 | 0;
      $1192 = $5 + $3 | 0;
      $1196 = HEAP32[($0 + $3 | 0) >> 2] | 0;
      i64toi32_i32$1 = $4;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $18 = i64toi32_i32$1;
      $18$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $7$hi;
      i64toi32_i32$4 = $18$hi;
      i64toi32_i32$1 = $7$hi;
      i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$4 | 0, $7 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1201 = i64toi32_i32$1;
      $1201$hi = i64toi32_i32$4;
      i64toi32_i32$1 = $6;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1203$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $17$hi;
      i64toi32_i32$4 = $1203$hi;
      i64toi32_i32$1 = $17$hi;
      i64toi32_i32$1 = __wasm_i64_mul($6 | 0, i64toi32_i32$4 | 0, $17 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1205 = i64toi32_i32$1;
      $1205$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1201$hi;
      i64toi32_i32$5 = $1201;
      i64toi32_i32$1 = $1205$hi;
      i64toi32_i32$3 = $1205;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $1206$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1206$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
       $594 = i64toi32_i32$2 >> i64toi32_i32$1 | 0;
      } else {
       i64toi32_i32$5 = i64toi32_i32$2 >> i64toi32_i32$1 | 0;
       $594 = (((1 << i64toi32_i32$1 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$1 | 0) | 0 | (i64toi32_i32$4 >>> i64toi32_i32$1 | 0) | 0;
      }
      $6 = $1196 + $594 | 0;
      HEAP32[$1192 >> 2] = $6;
      $3 = $3 | 4 | 0;
      $1216 = $5 + $3 | 0;
      $1220 = HEAP32[($0 + $3 | 0) >> 2] | 0;
      i64toi32_i32$4 = $6;
      i64toi32_i32$5 = i64toi32_i32$4 >> 31 | 0;
      $1222$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $7$hi;
      i64toi32_i32$5 = $1222$hi;
      i64toi32_i32$4 = $7$hi;
      i64toi32_i32$4 = __wasm_i64_mul($6 | 0, i64toi32_i32$5 | 0, $7 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1224 = i64toi32_i32$4;
      $1224$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $18$hi;
      i64toi32_i32$5 = $17$hi;
      i64toi32_i32$5 = $18$hi;
      i64toi32_i32$4 = $17$hi;
      i64toi32_i32$4 = __wasm_i64_mul($18 | 0, i64toi32_i32$5 | 0, $17 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1227 = i64toi32_i32$4;
      $1227$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1224$hi;
      i64toi32_i32$2 = $1224;
      i64toi32_i32$4 = $1227$hi;
      i64toi32_i32$3 = $1227;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $1228$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1228$hi;
      i64toi32_i32$5 = i64toi32_i32$1;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
      if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
       $595 = i64toi32_i32$0 >> i64toi32_i32$4 | 0;
      } else {
       i64toi32_i32$2 = i64toi32_i32$0 >> i64toi32_i32$4 | 0;
       $595 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$5 >>> i64toi32_i32$4 | 0) | 0;
      }
      $4 = $1220 + $595 | 0;
      HEAP32[$1216 >> 2] = $4;
      $2 = $2 + 2 | 0;
      $1 = $1 + -2 | 0;
      if ($1) {
       continue label$28
      }
      break label$28;
     };
    }
    if (!$9) {
     break label$1
    }
    $2 = $2 << 2 | 0;
    $1245 = $5 + $2 | 0;
    $1249 = HEAP32[($0 + $2 | 0) >> 2] | 0;
    i64toi32_i32$5 = $4;
    i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
    $1251$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $7$hi;
    i64toi32_i32$2 = $1251$hi;
    i64toi32_i32$5 = $7$hi;
    i64toi32_i32$5 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $7 | 0, i64toi32_i32$5 | 0) | 0;
    i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
    $1253 = i64toi32_i32$5;
    $1253$hi = i64toi32_i32$2;
    i64toi32_i32$5 = $6;
    i64toi32_i32$2 = i64toi32_i32$5 >> 31 | 0;
    $1255$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $17$hi;
    i64toi32_i32$2 = $1255$hi;
    i64toi32_i32$5 = $17$hi;
    i64toi32_i32$5 = __wasm_i64_mul($6 | 0, i64toi32_i32$2 | 0, $17 | 0, i64toi32_i32$5 | 0) | 0;
    i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
    $1257 = i64toi32_i32$5;
    $1257$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $1253$hi;
    i64toi32_i32$0 = $1253;
    i64toi32_i32$5 = $1257$hi;
    i64toi32_i32$3 = $1257;
    i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
    i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$5 | 0;
    if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
    }
    $1258$hi = i64toi32_i32$1;
    i64toi32_i32$1 = $8$hi;
    i64toi32_i32$1 = $1258$hi;
    i64toi32_i32$2 = i64toi32_i32$4;
    i64toi32_i32$0 = $8$hi;
    i64toi32_i32$3 = $8;
    i64toi32_i32$5 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
     $596 = i64toi32_i32$1 >> i64toi32_i32$5 | 0;
    } else {
     i64toi32_i32$0 = i64toi32_i32$1 >> i64toi32_i32$5 | 0;
     $596 = (((1 << i64toi32_i32$5 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$5 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$5 | 0) | 0;
    }
    HEAP32[$1245 >> 2] = $1249 + $596 | 0;
    return;
   }
   label$29 : while (1) {
    i64toi32_i32$0 = 0;
    $8 = 0;
    $8$hi = i64toi32_i32$0;
    label$30 : {
     switch ($4 | 0) {
     case 19:
      i64toi32_i32$1 = (($6 << 2 | 0) + $5 | 0) + -128 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1269 = i64toi32_i32$0;
      $1269$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 124 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1271 = i64toi32_i32$2;
      $1271$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1269$hi;
      i64toi32_i32$2 = $1271$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1269 | 0, i64toi32_i32$0 | 0, $1271 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$0;
     case 18:
      i64toi32_i32$1 = (($6 << 2 | 0) + $5 | 0) + -124 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1278 = i64toi32_i32$0;
      $1278$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 120 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1280 = i64toi32_i32$2;
      $1280$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1278$hi;
      i64toi32_i32$2 = $1280$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1278 | 0, i64toi32_i32$0 | 0, $1280 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1281$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1281$hi;
      i64toi32_i32$1 = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
     case 17:
      i64toi32_i32$0 = (($6 << 2 | 0) + $5 | 0) + -120 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1289 = i64toi32_i32$4;
      $1289$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 116 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1291 = i64toi32_i32$1;
      $1291$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1289$hi;
      i64toi32_i32$1 = $1291$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1289 | 0, i64toi32_i32$4 | 0, $1291 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1292$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $1292$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$5;
     case 16:
      i64toi32_i32$4 = (($6 << 2 | 0) + $5 | 0) + -116 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1300 = i64toi32_i32$5;
      $1300$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 112 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1302 = i64toi32_i32$0;
      $1302$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1300$hi;
      i64toi32_i32$0 = $1302$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1300 | 0, i64toi32_i32$5 | 0, $1302 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1303$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1303$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $8 = i64toi32_i32$1;
      $8$hi = i64toi32_i32$2;
     case 15:
      i64toi32_i32$5 = (($6 << 2 | 0) + $5 | 0) + -112 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1311 = i64toi32_i32$2;
      $1311$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 108 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1313 = i64toi32_i32$4;
      $1313$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1311$hi;
      i64toi32_i32$4 = $1313$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1311 | 0, i64toi32_i32$2 | 0, $1313 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1314$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1314$hi;
      i64toi32_i32$5 = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $8 = i64toi32_i32$0;
      $8$hi = i64toi32_i32$1;
     case 14:
      i64toi32_i32$2 = (($6 << 2 | 0) + $5 | 0) + -108 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1322 = i64toi32_i32$1;
      $1322$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 104 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1324 = i64toi32_i32$5;
      $1324$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1322$hi;
      i64toi32_i32$5 = $1324$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1322 | 0, i64toi32_i32$1 | 0, $1324 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1325$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$1 = $1325$hi;
      i64toi32_i32$2 = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $8 = i64toi32_i32$4;
      $8$hi = i64toi32_i32$0;
     case 13:
      i64toi32_i32$1 = (($6 << 2 | 0) + $5 | 0) + -104 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1333 = i64toi32_i32$0;
      $1333$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 100 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1335 = i64toi32_i32$2;
      $1335$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1333$hi;
      i64toi32_i32$2 = $1335$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1333 | 0, i64toi32_i32$0 | 0, $1335 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1336$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1336$hi;
      i64toi32_i32$1 = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
     case 12:
      i64toi32_i32$0 = (($6 << 2 | 0) + $5 | 0) + -100 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1344 = i64toi32_i32$4;
      $1344$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 96 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1346 = i64toi32_i32$1;
      $1346$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1344$hi;
      i64toi32_i32$1 = $1346$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1344 | 0, i64toi32_i32$4 | 0, $1346 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1347$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $1347$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$5;
     case 11:
      i64toi32_i32$4 = (($6 << 2 | 0) + $5 | 0) + -96 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1355 = i64toi32_i32$5;
      $1355$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 92 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1357 = i64toi32_i32$0;
      $1357$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1355$hi;
      i64toi32_i32$0 = $1357$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1355 | 0, i64toi32_i32$5 | 0, $1357 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1358$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1358$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $8 = i64toi32_i32$1;
      $8$hi = i64toi32_i32$2;
     case 10:
      i64toi32_i32$5 = (($6 << 2 | 0) + $5 | 0) + -92 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1366 = i64toi32_i32$2;
      $1366$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 88 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1368 = i64toi32_i32$4;
      $1368$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1366$hi;
      i64toi32_i32$4 = $1368$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1366 | 0, i64toi32_i32$2 | 0, $1368 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1369$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1369$hi;
      i64toi32_i32$5 = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $8 = i64toi32_i32$0;
      $8$hi = i64toi32_i32$1;
     case 9:
      i64toi32_i32$2 = (($6 << 2 | 0) + $5 | 0) + -88 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1377 = i64toi32_i32$1;
      $1377$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 84 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1379 = i64toi32_i32$5;
      $1379$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1377$hi;
      i64toi32_i32$5 = $1379$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1377 | 0, i64toi32_i32$1 | 0, $1379 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1380$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$1 = $1380$hi;
      i64toi32_i32$2 = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $8 = i64toi32_i32$4;
      $8$hi = i64toi32_i32$0;
     case 8:
      i64toi32_i32$1 = (($6 << 2 | 0) + $5 | 0) + -84 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1388 = i64toi32_i32$0;
      $1388$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 80 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1390 = i64toi32_i32$2;
      $1390$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1388$hi;
      i64toi32_i32$2 = $1390$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1388 | 0, i64toi32_i32$0 | 0, $1390 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1391$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1391$hi;
      i64toi32_i32$1 = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
     case 7:
      i64toi32_i32$0 = (($6 << 2 | 0) + $5 | 0) + -80 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1399 = i64toi32_i32$4;
      $1399$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 76 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1401 = i64toi32_i32$1;
      $1401$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1399$hi;
      i64toi32_i32$1 = $1401$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1399 | 0, i64toi32_i32$4 | 0, $1401 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1402$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $1402$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$5;
     case 6:
      i64toi32_i32$4 = (($6 << 2 | 0) + $5 | 0) + -76 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1410 = i64toi32_i32$5;
      $1410$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 72 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1412 = i64toi32_i32$0;
      $1412$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1410$hi;
      i64toi32_i32$0 = $1412$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1410 | 0, i64toi32_i32$5 | 0, $1412 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1413$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1413$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $8 = i64toi32_i32$1;
      $8$hi = i64toi32_i32$2;
     case 5:
      i64toi32_i32$5 = (($6 << 2 | 0) + $5 | 0) + -72 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1421 = i64toi32_i32$2;
      $1421$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 68 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1423 = i64toi32_i32$4;
      $1423$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1421$hi;
      i64toi32_i32$4 = $1423$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1421 | 0, i64toi32_i32$2 | 0, $1423 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1424$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1424$hi;
      i64toi32_i32$5 = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $8 = i64toi32_i32$0;
      $8$hi = i64toi32_i32$1;
     case 4:
      i64toi32_i32$2 = (($6 << 2 | 0) + $5 | 0) + -68 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1432 = i64toi32_i32$1;
      $1432$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 64 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1434 = i64toi32_i32$5;
      $1434$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1432$hi;
      i64toi32_i32$5 = $1434$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1432 | 0, i64toi32_i32$1 | 0, $1434 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1435$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$1 = $1435$hi;
      i64toi32_i32$2 = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $8 = i64toi32_i32$4;
      $8$hi = i64toi32_i32$0;
     case 3:
      i64toi32_i32$1 = (($6 << 2 | 0) + $5 | 0) + -64 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1443 = i64toi32_i32$0;
      $1443$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 60 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1445 = i64toi32_i32$2;
      $1445$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1443$hi;
      i64toi32_i32$2 = $1445$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1443 | 0, i64toi32_i32$0 | 0, $1445 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1446$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$0 = $1446$hi;
      i64toi32_i32$1 = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
     case 2:
      i64toi32_i32$0 = (($6 << 2 | 0) + $5 | 0) + -60 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1454 = i64toi32_i32$4;
      $1454$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 56 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1456 = i64toi32_i32$1;
      $1456$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1454$hi;
      i64toi32_i32$1 = $1456$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1454 | 0, i64toi32_i32$4 | 0, $1456 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1457$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$4 = $1457$hi;
      i64toi32_i32$0 = i64toi32_i32$1;
      i64toi32_i32$1 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $8 = i64toi32_i32$2;
      $8$hi = i64toi32_i32$5;
     case 1:
      i64toi32_i32$4 = (($6 << 2 | 0) + $5 | 0) + -56 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1465 = i64toi32_i32$5;
      $1465$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 52 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1467 = i64toi32_i32$0;
      $1467$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1465$hi;
      i64toi32_i32$0 = $1467$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1465 | 0, i64toi32_i32$5 | 0, $1467 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1468$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $8$hi;
      i64toi32_i32$5 = $1468$hi;
      i64toi32_i32$4 = i64toi32_i32$0;
      i64toi32_i32$0 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $8 = i64toi32_i32$1;
      $8$hi = i64toi32_i32$2;
     case 0:
      $3 = ($6 << 2 | 0) + $5 | 0;
      i64toi32_i32$5 = $3 + -52 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1477 = i64toi32_i32$2;
      $1477$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 48 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1479 = i64toi32_i32$4;
      $1479$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1477$hi;
      i64toi32_i32$4 = $1479$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1477 | 0, i64toi32_i32$2 | 0, $1479 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1480$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $8$hi;
      i64toi32_i32$2 = $1480$hi;
      i64toi32_i32$5 = i64toi32_i32$4;
      i64toi32_i32$4 = $8$hi;
      i64toi32_i32$3 = $8;
      i64toi32_i32$0 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $1482$hi = i64toi32_i32$1;
      i64toi32_i32$2 = $3 + -48 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1485 = i64toi32_i32$1;
      $1485$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 44 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1487 = i64toi32_i32$5;
      $1487$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1485$hi;
      i64toi32_i32$5 = $1487$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1485 | 0, i64toi32_i32$1 | 0, $1487 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1488 = i64toi32_i32$5;
      $1488$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1482$hi;
      i64toi32_i32$2 = i64toi32_i32$0;
      i64toi32_i32$5 = $1488$hi;
      i64toi32_i32$3 = $1488;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $1489$hi = i64toi32_i32$0;
      i64toi32_i32$1 = $3 + -44 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1492 = i64toi32_i32$0;
      $1492$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 40 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1494 = i64toi32_i32$2;
      $1494$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1492$hi;
      i64toi32_i32$2 = $1494$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1492 | 0, i64toi32_i32$0 | 0, $1494 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1495 = i64toi32_i32$2;
      $1495$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1489$hi;
      i64toi32_i32$1 = i64toi32_i32$4;
      i64toi32_i32$2 = $1495$hi;
      i64toi32_i32$3 = $1495;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $1496$hi = i64toi32_i32$4;
      i64toi32_i32$0 = $3 + -40 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1499 = i64toi32_i32$4;
      $1499$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 36 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1501 = i64toi32_i32$1;
      $1501$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1499$hi;
      i64toi32_i32$1 = $1501$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1499 | 0, i64toi32_i32$4 | 0, $1501 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1502 = i64toi32_i32$1;
      $1502$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1496$hi;
      i64toi32_i32$0 = i64toi32_i32$5;
      i64toi32_i32$1 = $1502$hi;
      i64toi32_i32$3 = $1502;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $1503$hi = i64toi32_i32$5;
      i64toi32_i32$4 = $3 + -36 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1506 = i64toi32_i32$5;
      $1506$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 32 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1508 = i64toi32_i32$0;
      $1508$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1506$hi;
      i64toi32_i32$0 = $1508$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1506 | 0, i64toi32_i32$5 | 0, $1508 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1509 = i64toi32_i32$0;
      $1509$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1503$hi;
      i64toi32_i32$4 = i64toi32_i32$2;
      i64toi32_i32$0 = $1509$hi;
      i64toi32_i32$3 = $1509;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $1510$hi = i64toi32_i32$2;
      i64toi32_i32$5 = $3 + -32 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1513 = i64toi32_i32$2;
      $1513$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 28 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1515 = i64toi32_i32$4;
      $1515$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1513$hi;
      i64toi32_i32$4 = $1515$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1513 | 0, i64toi32_i32$2 | 0, $1515 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1516 = i64toi32_i32$4;
      $1516$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1510$hi;
      i64toi32_i32$5 = i64toi32_i32$1;
      i64toi32_i32$4 = $1516$hi;
      i64toi32_i32$3 = $1516;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $1517$hi = i64toi32_i32$1;
      i64toi32_i32$2 = $3 + -28 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1520 = i64toi32_i32$1;
      $1520$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 24 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1522 = i64toi32_i32$5;
      $1522$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1520$hi;
      i64toi32_i32$5 = $1522$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1520 | 0, i64toi32_i32$1 | 0, $1522 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1523 = i64toi32_i32$5;
      $1523$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1517$hi;
      i64toi32_i32$2 = i64toi32_i32$0;
      i64toi32_i32$5 = $1523$hi;
      i64toi32_i32$3 = $1523;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $1524$hi = i64toi32_i32$0;
      i64toi32_i32$1 = $3 + -24 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1527 = i64toi32_i32$0;
      $1527$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 20 | 0) >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1529 = i64toi32_i32$2;
      $1529$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1527$hi;
      i64toi32_i32$2 = $1529$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1527 | 0, i64toi32_i32$0 | 0, $1529 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1530 = i64toi32_i32$2;
      $1530$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1524$hi;
      i64toi32_i32$1 = i64toi32_i32$4;
      i64toi32_i32$2 = $1530$hi;
      i64toi32_i32$3 = $1530;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $1531$hi = i64toi32_i32$4;
      i64toi32_i32$0 = $3 + -20 | 0;
      i64toi32_i32$4 = HEAP32[i64toi32_i32$0 >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
      $1534 = i64toi32_i32$4;
      $1534$hi = i64toi32_i32$1;
      i64toi32_i32$0 = $2;
      i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 16 | 0) >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$1 >> 31 | 0;
      $1536 = i64toi32_i32$1;
      $1536$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1534$hi;
      i64toi32_i32$1 = $1536$hi;
      i64toi32_i32$1 = __wasm_i64_mul($1534 | 0, i64toi32_i32$4 | 0, $1536 | 0, i64toi32_i32$1 | 0) | 0;
      i64toi32_i32$4 = i64toi32_i32$HIGH_BITS;
      $1537 = i64toi32_i32$1;
      $1537$hi = i64toi32_i32$4;
      i64toi32_i32$4 = $1531$hi;
      i64toi32_i32$0 = i64toi32_i32$5;
      i64toi32_i32$1 = $1537$hi;
      i64toi32_i32$3 = $1537;
      i64toi32_i32$2 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$5 = i64toi32_i32$4 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      $1538$hi = i64toi32_i32$5;
      i64toi32_i32$4 = $3 + -16 | 0;
      i64toi32_i32$5 = HEAP32[i64toi32_i32$4 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$5 >> 31 | 0;
      $1541 = i64toi32_i32$5;
      $1541$hi = i64toi32_i32$0;
      i64toi32_i32$4 = $2;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$4 + 12 | 0) >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
      $1543 = i64toi32_i32$0;
      $1543$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1541$hi;
      i64toi32_i32$0 = $1543$hi;
      i64toi32_i32$0 = __wasm_i64_mul($1541 | 0, i64toi32_i32$5 | 0, $1543 | 0, i64toi32_i32$0 | 0) | 0;
      i64toi32_i32$5 = i64toi32_i32$HIGH_BITS;
      $1544 = i64toi32_i32$0;
      $1544$hi = i64toi32_i32$5;
      i64toi32_i32$5 = $1538$hi;
      i64toi32_i32$4 = i64toi32_i32$2;
      i64toi32_i32$0 = $1544$hi;
      i64toi32_i32$3 = $1544;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
      i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
      if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
      }
      $1545$hi = i64toi32_i32$2;
      i64toi32_i32$5 = $3 + -12 | 0;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$5 >> 2] | 0;
      i64toi32_i32$4 = i64toi32_i32$2 >> 31 | 0;
      $1548 = i64toi32_i32$2;
      $1548$hi = i64toi32_i32$4;
      i64toi32_i32$5 = $2;
      i64toi32_i32$4 = HEAP32[(i64toi32_i32$5 + 8 | 0) >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$4 >> 31 | 0;
      $1550 = i64toi32_i32$4;
      $1550$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1548$hi;
      i64toi32_i32$4 = $1550$hi;
      i64toi32_i32$4 = __wasm_i64_mul($1548 | 0, i64toi32_i32$2 | 0, $1550 | 0, i64toi32_i32$4 | 0) | 0;
      i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
      $1551 = i64toi32_i32$4;
      $1551$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1545$hi;
      i64toi32_i32$5 = i64toi32_i32$1;
      i64toi32_i32$4 = $1551$hi;
      i64toi32_i32$3 = $1551;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$1 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
      if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
      }
      $1552$hi = i64toi32_i32$1;
      i64toi32_i32$2 = $3 + -8 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$5 = i64toi32_i32$1 >> 31 | 0;
      $1555 = i64toi32_i32$1;
      $1555$hi = i64toi32_i32$5;
      i64toi32_i32$2 = $2;
      i64toi32_i32$5 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
      i64toi32_i32$1 = i64toi32_i32$5 >> 31 | 0;
      $1557 = i64toi32_i32$5;
      $1557$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1555$hi;
      i64toi32_i32$5 = $1557$hi;
      i64toi32_i32$5 = __wasm_i64_mul($1555 | 0, i64toi32_i32$1 | 0, $1557 | 0, i64toi32_i32$5 | 0) | 0;
      i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
      $1558 = i64toi32_i32$5;
      $1558$hi = i64toi32_i32$1;
      i64toi32_i32$1 = $1552$hi;
      i64toi32_i32$2 = i64toi32_i32$0;
      i64toi32_i32$5 = $1558$hi;
      i64toi32_i32$3 = $1558;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
      i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
      if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
      }
      $1559$hi = i64toi32_i32$0;
      i64toi32_i32$1 = $3 + -4 | 0;
      i64toi32_i32$0 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$2 = i64toi32_i32$0 >> 31 | 0;
      $1562 = i64toi32_i32$0;
      $1562$hi = i64toi32_i32$2;
      i64toi32_i32$1 = $2;
      i64toi32_i32$2 = HEAP32[i64toi32_i32$1 >> 2] | 0;
      i64toi32_i32$0 = i64toi32_i32$2 >> 31 | 0;
      $1564 = i64toi32_i32$2;
      $1564$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1562$hi;
      i64toi32_i32$2 = $1564$hi;
      i64toi32_i32$2 = __wasm_i64_mul($1562 | 0, i64toi32_i32$0 | 0, $1564 | 0, i64toi32_i32$2 | 0) | 0;
      i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
      $1565 = i64toi32_i32$2;
      $1565$hi = i64toi32_i32$0;
      i64toi32_i32$0 = $1559$hi;
      i64toi32_i32$1 = i64toi32_i32$4;
      i64toi32_i32$2 = $1565$hi;
      i64toi32_i32$3 = $1565;
      i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
      i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$2 | 0;
      if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
       i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
      }
      $8 = i64toi32_i32$5;
      $8$hi = i64toi32_i32$4;
      break;
     default:
      break label$30;
     };
    }
    $3 = $6 << 2 | 0;
    $1571 = $5 + $3 | 0;
    $1575 = HEAP32[($0 + $3 | 0) >> 2] | 0;
    i64toi32_i32$4 = $8$hi;
    i64toi32_i32$4 = $7$hi;
    i64toi32_i32$4 = $8$hi;
    i64toi32_i32$0 = $8;
    i64toi32_i32$1 = $7$hi;
    i64toi32_i32$3 = $7;
    i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     i64toi32_i32$1 = i64toi32_i32$4 >> 31 | 0;
     $597 = i64toi32_i32$4 >> i64toi32_i32$2 | 0;
    } else {
     i64toi32_i32$1 = i64toi32_i32$4 >> i64toi32_i32$2 | 0;
     $597 = (((1 << i64toi32_i32$2 | 0) - 1 | 0) & i64toi32_i32$4 | 0) << (32 - i64toi32_i32$2 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$2 | 0) | 0;
    }
    HEAP32[$1571 >> 2] = $1575 + $597 | 0;
    $6 = $6 + 1 | 0;
    if (($6 | 0) != ($1 | 0)) {
     continue label$29
    }
    break label$29;
   };
  }
 }
 
 function FLAC__lpc_compute_expected_bits_per_residual_sample($0, $1) {
  $0 = +$0;
  $1 = $1 | 0;
  label$1 : {
   if (!($0 > 0.0)) {
    break label$1
   }
   $0 = +log(+(.5 / +($1 >>> 0) * $0)) * .5 / .6931471805599453;
   return +($0 >= 0.0 ? $0 : 0.0);
  }
  return +($0 < 0.0 ? 1.e+32 : 0.0);
 }
 
 function FLAC__lpc_compute_best_order($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $9 = 0.0, $4 = 0, $6 = 0, $7 = 0.0, $8 = 0, $10 = 0, $5 = 0.0;
  $4 = 1;
  label$1 : {
   if (!$1) {
    break label$1
   }
   $5 = .5 / +($2 >>> 0);
   $6 = 0;
   $7 = 4294967295.0;
   $8 = 0;
   label$2 : while (1) {
    label$3 : {
     label$4 : {
      $9 = +HEAPF64[($0 + ($6 << 3 | 0) | 0) >> 3];
      if (!($9 > 0.0)) {
       break label$4
      }
      $9 = +log(+($5 * $9)) * .5 / .6931471805599453;
      $9 = $9 >= 0.0 ? $9 : 0.0;
      break label$3;
     }
     $9 = $9 < 0.0 ? 1.e+32 : 0.0;
    }
    $9 = $9 * +(($2 - $4 | 0) >>> 0) + +(Math_imul($4, $3) >>> 0);
    $10 = $9 < $7;
    $7 = $10 ? $9 : $7;
    $8 = $10 ? $6 : $8;
    $4 = $4 + 1 | 0;
    $6 = $6 + 1 | 0;
    if (($6 | 0) != ($1 | 0)) {
     continue label$2
    }
    break label$2;
   };
   $4 = $8 + 1 | 0;
  }
  return $4 | 0;
 }
 
 function strlen($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0;
  $1 = $0;
  label$1 : {
   label$2 : {
    if (!($1 & 3 | 0)) {
     break label$2
    }
    $1 = $0;
    label$3 : while (1) {
     if (!(HEAPU8[$1 >> 0] | 0)) {
      break label$1
     }
     $1 = $1 + 1 | 0;
     if ($1 & 3 | 0) {
      continue label$3
     }
     break label$3;
    };
   }
   label$4 : while (1) {
    $2 = $1;
    $1 = $1 + 4 | 0;
    $3 = HEAP32[$2 >> 2] | 0;
    if (!((($3 ^ -1 | 0) & ($3 + -16843009 | 0) | 0) & -2139062144 | 0)) {
     continue label$4
    }
    break label$4;
   };
   label$5 : {
    if ($3 & 255 | 0) {
     break label$5
    }
    return $2 - $0 | 0 | 0;
   }
   label$6 : while (1) {
    $3 = HEAPU8[($2 + 1 | 0) >> 0] | 0;
    $1 = $2 + 1 | 0;
    $2 = $1;
    if ($3) {
     continue label$6
    }
    break label$6;
   };
  }
  return $1 - $0 | 0 | 0;
 }
 
 function __strchrnul($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $2 = 0;
  label$1 : {
   label$2 : {
    $2 = $1 & 255 | 0;
    if (!$2) {
     break label$2
    }
    label$3 : {
     if (!($0 & 3 | 0)) {
      break label$3
     }
     label$4 : while (1) {
      $3 = HEAPU8[$0 >> 0] | 0;
      if (!$3) {
       break label$1
      }
      if (($3 | 0) == ($1 & 255 | 0 | 0)) {
       break label$1
      }
      $0 = $0 + 1 | 0;
      if ($0 & 3 | 0) {
       continue label$4
      }
      break label$4;
     };
    }
    label$5 : {
     $3 = HEAP32[$0 >> 2] | 0;
     if ((($3 ^ -1 | 0) & ($3 + -16843009 | 0) | 0) & -2139062144 | 0) {
      break label$5
     }
     $2 = Math_imul($2, 16843009);
     label$6 : while (1) {
      $3 = $3 ^ $2 | 0;
      if ((($3 ^ -1 | 0) & ($3 + -16843009 | 0) | 0) & -2139062144 | 0) {
       break label$5
      }
      $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
      $0 = $0 + 4 | 0;
      if (!((($3 ^ -1 | 0) & ($3 + -16843009 | 0) | 0) & -2139062144 | 0)) {
       continue label$6
      }
      break label$6;
     };
    }
    label$7 : {
     label$8 : while (1) {
      $3 = $0;
      $2 = HEAPU8[$3 >> 0] | 0;
      if (!$2) {
       break label$7
      }
      $0 = $3 + 1 | 0;
      if (($2 | 0) != ($1 & 255 | 0 | 0)) {
       continue label$8
      }
      break label$8;
     };
    }
    return $3 | 0;
   }
   return $0 + (strlen($0 | 0) | 0) | 0 | 0;
  }
  return $0 | 0;
 }
 
 function strchr($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $0 = __strchrnul($0 | 0, $1 | 0) | 0;
  return ((HEAPU8[$0 >> 0] | 0 | 0) == ($1 & 255 | 0 | 0) ? $0 : 0) | 0;
 }
 
 function __stdio_write($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $4 = 0, $3 = 0, $5 = 0, $8 = 0, $9 = 0, $6 = 0, $7 = 0;
  $3 = __stack_pointer - 32 | 0;
  __stack_pointer = $3;
  $4 = HEAP32[($0 + 28 | 0) >> 2] | 0;
  HEAP32[($3 + 16 | 0) >> 2] = $4;
  $5 = HEAP32[($0 + 20 | 0) >> 2] | 0;
  HEAP32[($3 + 28 | 0) >> 2] = $2;
  HEAP32[($3 + 24 | 0) >> 2] = $1;
  $1 = $5 - $4 | 0;
  HEAP32[($3 + 20 | 0) >> 2] = $1;
  $6 = $1 + $2 | 0;
  $7 = 2;
  $1 = $3 + 16 | 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      if (__wasi_syscall_ret(__wasi_fd_write(HEAP32[($0 + 60 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, 2 | 0, $3 + 12 | 0 | 0) | 0 | 0) | 0) {
       break label$4
      }
      label$5 : while (1) {
       $4 = HEAP32[($3 + 12 | 0) >> 2] | 0;
       if (($6 | 0) == ($4 | 0)) {
        break label$3
       }
       if (($4 | 0) <= (-1 | 0)) {
        break label$2
       }
       $8 = HEAP32[($1 + 4 | 0) >> 2] | 0;
       $5 = $4 >>> 0 > $8 >>> 0;
       $9 = $1 + ($5 << 3 | 0) | 0;
       $8 = $4 - ($5 ? $8 : 0) | 0;
       HEAP32[$9 >> 2] = (HEAP32[$9 >> 2] | 0) + $8 | 0;
       $9 = $1 + ($5 ? 12 : 4) | 0;
       HEAP32[$9 >> 2] = (HEAP32[$9 >> 2] | 0) - $8 | 0;
       $6 = $6 - $4 | 0;
       $1 = $5 ? $1 + 8 | 0 : $1;
       $7 = $7 - $5 | 0;
       if (!(__wasi_syscall_ret(__wasi_fd_write(HEAP32[($0 + 60 | 0) >> 2] | 0 | 0, $1 | 0, $7 | 0, $3 + 12 | 0 | 0) | 0 | 0) | 0)) {
        continue label$5
       }
       break label$5;
      };
     }
     if (($6 | 0) != (-1 | 0)) {
      break label$2
     }
    }
    $1 = HEAP32[($0 + 44 | 0) >> 2] | 0;
    HEAP32[($0 + 28 | 0) >> 2] = $1;
    HEAP32[($0 + 20 | 0) >> 2] = $1;
    HEAP32[($0 + 16 | 0) >> 2] = $1 + (HEAP32[($0 + 48 | 0) >> 2] | 0) | 0;
    $4 = $2;
    break label$1;
   }
   $4 = 0;
   HEAP32[($0 + 28 | 0) >> 2] = 0;
   HEAP32[($0 + 16 | 0) >> 2] = 0;
   HEAP32[($0 + 20 | 0) >> 2] = 0;
   HEAP32[$0 >> 2] = HEAP32[$0 >> 2] | 0 | 32 | 0;
   if (($7 | 0) == (2 | 0)) {
    break label$1
   }
   $4 = $2 - (HEAP32[($1 + 4 | 0) >> 2] | 0) | 0;
  }
  __stack_pointer = $3 + 32 | 0;
  return $4 | 0;
 }
 
 function FLAC__memory_alloc_aligned_int32_array($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0;
  $3 = 0;
  label$1 : {
   if ($0 >>> 0 > 1073741823 >>> 0) {
    break label$1
   }
   $0 = dlmalloc(($0 ? $0 << 2 | 0 : 1) | 0) | 0;
   if (!$0) {
    break label$1
   }
   label$2 : {
    $3 = HEAP32[$1 >> 2] | 0;
    if (!$3) {
     break label$2
    }
    dlfree($3 | 0);
   }
   HEAP32[$1 >> 2] = $0;
   HEAP32[$2 >> 2] = $0;
   $3 = 1;
  }
  return $3 | 0;
 }
 
 function FLAC__memory_alloc_aligned_uint64_array($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0;
  $3 = 0;
  label$1 : {
   if ($0 >>> 0 > 536870911 >>> 0) {
    break label$1
   }
   $0 = dlmalloc(($0 ? $0 << 3 | 0 : 1) | 0) | 0;
   if (!$0) {
    break label$1
   }
   label$2 : {
    $3 = HEAP32[$1 >> 2] | 0;
    if (!$3) {
     break label$2
    }
    dlfree($3 | 0);
   }
   HEAP32[$1 >> 2] = $0;
   HEAP32[$2 >> 2] = $0;
   $3 = 1;
  }
  return $3 | 0;
 }
 
 function FLAC__memory_alloc_aligned_unsigned_array($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0;
  $3 = 0;
  label$1 : {
   if ($0 >>> 0 > 1073741823 >>> 0) {
    break label$1
   }
   $0 = dlmalloc(($0 ? $0 << 2 | 0 : 1) | 0) | 0;
   if (!$0) {
    break label$1
   }
   label$2 : {
    $3 = HEAP32[$1 >> 2] | 0;
    if (!$3) {
     break label$2
    }
    dlfree($3 | 0);
   }
   HEAP32[$1 >> 2] = $0;
   HEAP32[$2 >> 2] = $0;
   $3 = 1;
  }
  return $3 | 0;
 }
 
 function FLAC__memory_alloc_aligned_real_array($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0;
  $3 = 0;
  label$1 : {
   if ($0 >>> 0 > 1073741823 >>> 0) {
    break label$1
   }
   $0 = dlmalloc(($0 ? $0 << 2 | 0 : 1) | 0) | 0;
   if (!$0) {
    break label$1
   }
   label$2 : {
    $3 = HEAP32[$1 >> 2] | 0;
    if (!$3) {
     break label$2
    }
    dlfree($3 | 0);
   }
   HEAP32[$1 >> 2] = $0;
   HEAP32[$2 >> 2] = $0;
   $3 = 1;
  }
  return $3 | 0;
 }
 
 function safe_malloc_mul_2op_p($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, i64toi32_i32$4 = 0, $2 = 0, i64toi32_i32$3 = 0, $10 = 0, $8$hi = 0, $10$hi = 0, i64toi32_i32$2 = 0;
  label$1 : {
   label$2 : {
    if (!$0) {
     break label$2
    }
    if ($1) {
     break label$1
    }
   }
   return dlmalloc(1 | 0) | 0 | 0;
  }
  $2 = 0;
  label$3 : {
   i64toi32_i32$0 = 0;
   $8$hi = i64toi32_i32$0;
   i64toi32_i32$0 = 0;
   $10$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $8$hi;
   i64toi32_i32$1 = $10$hi;
   i64toi32_i32$1 = __wasm_i64_mul($1 | 0, i64toi32_i32$0 | 0, $0 | 0, i64toi32_i32$1 | 0) | 0;
   i64toi32_i32$0 = i64toi32_i32$HIGH_BITS;
   i64toi32_i32$2 = i64toi32_i32$1;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 32;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$1 = 0;
    $10 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
    $10 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
   }
   if ($10) {
    break label$3
   }
   $2 = dlmalloc(Math_imul($1, $0) | 0) | 0;
  }
  return $2 | 0;
 }
 
 function FLAC__fixed_compute_best_predictor($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $10 = 0, $11 = 0, $7 = 0, $8 = 0, $6 = 0, $9 = 0, $5 = 0, $13 = 0, $16 = 0, $4 = 0, $17 = Math_fround(0), $18 = Math_fround(0), $3 = 0, $15 = 0, $12 = 0, $14 = 0, $101 = 0, wasm2js_i32$0 = 0, wasm2js_f32$0 = Math_fround(0);
  $3 = 0;
  $4 = 0;
  $5 = 0;
  $6 = 0;
  $7 = 0;
  $8 = 0;
  label$1 : {
   if (!$1) {
    break label$1
   }
   $9 = HEAP32[($0 + -12 | 0) >> 2] | 0;
   $10 = HEAP32[($0 + -8 | 0) >> 2] | 0;
   $11 = HEAP32[($0 + -4 | 0) >> 2] | 0;
   $12 = $11 - $10 | 0;
   $13 = ($9 - $10 | 0) + $12 | 0;
   $14 = (($9 << 1 | 0) - ($10 + (HEAP32[($0 + -16 | 0) >> 2] | 0) | 0) | 0) + $13 | 0;
   $15 = 0;
   $8 = 0;
   $7 = 0;
   $6 = 0;
   $5 = 0;
   $4 = 0;
   label$2 : while (1) {
    $10 = HEAP32[($0 + ($15 << 2 | 0) | 0) >> 2] | 0;
    $9 = $10 >> 31 | 0;
    $4 = (($10 + $9 | 0) ^ $9 | 0) + $4 | 0;
    $9 = $10 - $11 | 0;
    $16 = $9 >> 31 | 0;
    $5 = (($9 + $16 | 0) ^ $16 | 0) + $5 | 0;
    $16 = $9 - $12 | 0;
    $11 = $16 >> 31 | 0;
    $6 = (($16 + $11 | 0) ^ $11 | 0) + $6 | 0;
    $13 = $16 - $13 | 0;
    $11 = $13 >> 31 | 0;
    $7 = (($13 + $11 | 0) ^ $11 | 0) + $7 | 0;
    $11 = $13 - $14 | 0;
    $101 = $11;
    $11 = $11 >> 31 | 0;
    $8 = (($101 + $11 | 0) ^ $11 | 0) + $8 | 0;
    $11 = $10;
    $12 = $9;
    $14 = $13;
    $13 = $16;
    $15 = $15 + 1 | 0;
    if (($15 | 0) != ($1 | 0)) {
     continue label$2
    }
    break label$2;
   };
  }
  label$3 : {
   $10 = $5 >>> 0 < $6 >>> 0 ? $5 : $6;
   $10 = $10 >>> 0 < $7 >>> 0 ? $10 : $7;
   if ($4 >>> 0 < ($10 >>> 0 < $8 >>> 0 ? $10 : $8) >>> 0) {
    break label$3
   }
   $3 = 1;
   $10 = $6 >>> 0 < $7 >>> 0 ? $6 : $7;
   if ($5 >>> 0 < ($10 >>> 0 < $8 >>> 0 ? $10 : $8) >>> 0) {
    break label$3
   }
   $10 = $7 >>> 0 < $8 >>> 0;
   $3 = $6 >>> 0 < ($10 ? $7 : $8) >>> 0 ? 2 : $10 ? 3 : 4;
  }
  $17 = Math_fround(0.0);
  $18 = Math_fround(0.0);
  label$4 : {
   if (!$4) {
    break label$4
   }
   $18 = Math_fround(+log(+(+($4 >>> 0) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453);
  }
  HEAPF32[$2 >> 2] = $18;
  label$5 : {
   if (!$5) {
    break label$5
   }
   $17 = Math_fround(+log(+(+($5 >>> 0) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453);
  }
  HEAPF32[($2 + 4 | 0) >> 2] = $17;
  $17 = Math_fround(0.0);
  $18 = Math_fround(0.0);
  label$6 : {
   if (!$6) {
    break label$6
   }
   $18 = Math_fround(+log(+(+($6 >>> 0) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453);
  }
  HEAPF32[($2 + 8 | 0) >> 2] = $18;
  label$7 : {
   if (!$7) {
    break label$7
   }
   $17 = Math_fround(+log(+(+($7 >>> 0) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453);
  }
  HEAPF32[($2 + 12 | 0) >> 2] = $17;
  label$8 : {
   if ($8) {
    break label$8
   }
   HEAPF32[($2 + 16 | 0) >> 2] = Math_fround(0.0);
   return $3 | 0;
  }
  (wasm2js_i32$0 = $2, wasm2js_f32$0 = Math_fround(+log(+(+($8 >>> 0) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453)), HEAPF32[(wasm2js_i32$0 + 16 | 0) >> 2] = wasm2js_f32$0;
  return $3 | 0;
 }
 
 function FLAC__fixed_compute_best_predictor_wide($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, i64toi32_i32$4 = 0, i64toi32_i32$3 = 0, i64toi32_i32$2 = 0, $9 = 0, $10 = 0, i64toi32_i32$5 = 0, $5$hi = 0, $6$hi = 0, $7$hi = 0, $4$hi = 0, $8 = 0, $5 = 0, $6 = 0, $3$hi = 0, $4 = 0, $7 = 0, $12 = 0, $16$hi = 0, $15 = 0, $3 = 0, $16 = 0, $17 = Math_fround(0), $18 = Math_fround(0), $14 = 0, $11 = 0, $13 = 0, $60$hi = 0, $73$hi = 0, $86$hi = 0, $99$hi = 0, $105 = 0, $112$hi = 0, $141 = 0, $141$hi = 0, $155 = 0, $155$hi = 0, $166 = 0, $166$hi = 0, wasm2js_i32$0 = 0, wasm2js_f32$0 = Math_fround(0);
  label$1 : {
   label$2 : {
    if ($1) {
     break label$2
    }
    i64toi32_i32$0 = 0;
    $3 = 0;
    $3$hi = i64toi32_i32$0;
    i64toi32_i32$0 = 0;
    $4 = 0;
    $4$hi = i64toi32_i32$0;
    i64toi32_i32$0 = 0;
    $5 = 0;
    $5$hi = i64toi32_i32$0;
    i64toi32_i32$0 = 0;
    $6 = 0;
    $6$hi = i64toi32_i32$0;
    i64toi32_i32$0 = 0;
    $7 = 0;
    $7$hi = i64toi32_i32$0;
    break label$1;
   }
   $8 = HEAP32[($0 + -12 | 0) >> 2] | 0;
   $9 = HEAP32[($0 + -8 | 0) >> 2] | 0;
   $10 = HEAP32[($0 + -4 | 0) >> 2] | 0;
   $11 = $10 - $9 | 0;
   $12 = ($8 - $9 | 0) + $11 | 0;
   $13 = (($8 << 1 | 0) - ($9 + (HEAP32[($0 + -16 | 0) >> 2] | 0) | 0) | 0) + $12 | 0;
   i64toi32_i32$0 = 0;
   $7 = 0;
   $7$hi = i64toi32_i32$0;
   $14 = 0;
   i64toi32_i32$0 = 0;
   $6 = 0;
   $6$hi = i64toi32_i32$0;
   i64toi32_i32$0 = 0;
   $5 = 0;
   $5$hi = i64toi32_i32$0;
   i64toi32_i32$0 = 0;
   $4 = 0;
   $4$hi = i64toi32_i32$0;
   i64toi32_i32$0 = 0;
   $3 = 0;
   $3$hi = i64toi32_i32$0;
   label$3 : while (1) {
    i64toi32_i32$0 = $3$hi;
    $9 = HEAP32[($0 + ($14 << 2 | 0) | 0) >> 2] | 0;
    $8 = $9 >> 31 | 0;
    i64toi32_i32$0 = 0;
    $60$hi = i64toi32_i32$0;
    i64toi32_i32$0 = $3$hi;
    i64toi32_i32$2 = $3;
    i64toi32_i32$1 = $60$hi;
    i64toi32_i32$3 = ($9 + $8 | 0) ^ $8 | 0;
    i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$3 | 0;
    i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$1 | 0;
    if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
    }
    $3 = i64toi32_i32$4;
    $3$hi = i64toi32_i32$5;
    i64toi32_i32$5 = $4$hi;
    $8 = $9 - $10 | 0;
    $15 = $8 >> 31 | 0;
    i64toi32_i32$5 = 0;
    $73$hi = i64toi32_i32$5;
    i64toi32_i32$5 = $4$hi;
    i64toi32_i32$0 = $4;
    i64toi32_i32$2 = $73$hi;
    i64toi32_i32$3 = ($8 + $15 | 0) ^ $15 | 0;
    i64toi32_i32$1 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
    i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
    if (i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
    }
    $4 = i64toi32_i32$1;
    $4$hi = i64toi32_i32$4;
    i64toi32_i32$4 = $5$hi;
    $15 = $8 - $11 | 0;
    $10 = $15 >> 31 | 0;
    i64toi32_i32$4 = 0;
    $86$hi = i64toi32_i32$4;
    i64toi32_i32$4 = $5$hi;
    i64toi32_i32$5 = $5;
    i64toi32_i32$0 = $86$hi;
    i64toi32_i32$3 = ($15 + $10 | 0) ^ $10 | 0;
    i64toi32_i32$2 = i64toi32_i32$5 + i64toi32_i32$3 | 0;
    i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$0 | 0;
    if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
    }
    $5 = i64toi32_i32$2;
    $5$hi = i64toi32_i32$1;
    i64toi32_i32$1 = $6$hi;
    $12 = $15 - $12 | 0;
    $10 = $12 >> 31 | 0;
    i64toi32_i32$1 = 0;
    $99$hi = i64toi32_i32$1;
    i64toi32_i32$1 = $6$hi;
    i64toi32_i32$4 = $6;
    i64toi32_i32$5 = $99$hi;
    i64toi32_i32$3 = ($12 + $10 | 0) ^ $10 | 0;
    i64toi32_i32$0 = i64toi32_i32$4 + i64toi32_i32$3 | 0;
    i64toi32_i32$2 = i64toi32_i32$1 + i64toi32_i32$5 | 0;
    if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$2 = i64toi32_i32$2 + 1 | 0
    }
    $6 = i64toi32_i32$0;
    $6$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $7$hi;
    $10 = $12 - $13 | 0;
    $105 = $10;
    $10 = $10 >> 31 | 0;
    i64toi32_i32$2 = 0;
    $112$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $7$hi;
    i64toi32_i32$1 = $7;
    i64toi32_i32$4 = $112$hi;
    i64toi32_i32$3 = ($105 + $10 | 0) ^ $10 | 0;
    i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
    i64toi32_i32$0 = i64toi32_i32$2 + i64toi32_i32$4 | 0;
    if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$0 = i64toi32_i32$0 + 1 | 0
    }
    $7 = i64toi32_i32$5;
    $7$hi = i64toi32_i32$0;
    $10 = $9;
    $11 = $8;
    $13 = $12;
    $12 = $15;
    $14 = $14 + 1 | 0;
    if (($14 | 0) != ($1 | 0)) {
     continue label$3
    }
    break label$3;
   };
  }
  $9 = 0;
  label$4 : {
   i64toi32_i32$0 = $3$hi;
   i64toi32_i32$0 = $4$hi;
   i64toi32_i32$0 = $5$hi;
   i64toi32_i32$0 = $4$hi;
   i64toi32_i32$0 = $5$hi;
   i64toi32_i32$0 = $4$hi;
   i64toi32_i32$2 = $4;
   i64toi32_i32$1 = $5$hi;
   i64toi32_i32$3 = $5;
   i64toi32_i32$4 = i64toi32_i32$0 >>> 0 < i64toi32_i32$1 >>> 0 | ((i64toi32_i32$0 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0 | 0) | 0;
   i64toi32_i32$2 = i64toi32_i32$0;
   i64toi32_i32$0 = i64toi32_i32$1;
   i64toi32_i32$1 = i64toi32_i32$4 ? $4 : i64toi32_i32$3;
   i64toi32_i32$3 = i64toi32_i32$4 ? i64toi32_i32$2 : i64toi32_i32$0;
   $16 = i64toi32_i32$1;
   $16$hi = i64toi32_i32$3;
   i64toi32_i32$3 = $6$hi;
   i64toi32_i32$3 = $16$hi;
   i64toi32_i32$3 = $6$hi;
   i64toi32_i32$3 = $16$hi;
   i64toi32_i32$4 = i64toi32_i32$1;
   i64toi32_i32$1 = $6$hi;
   i64toi32_i32$2 = $6;
   i64toi32_i32$0 = i64toi32_i32$3 >>> 0 < i64toi32_i32$1 >>> 0 | ((i64toi32_i32$3 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$4 >>> 0 < i64toi32_i32$2 >>> 0 | 0) | 0;
   i64toi32_i32$4 = i64toi32_i32$3;
   i64toi32_i32$3 = i64toi32_i32$1;
   i64toi32_i32$1 = i64toi32_i32$0 ? $16 : i64toi32_i32$2;
   i64toi32_i32$2 = i64toi32_i32$0 ? i64toi32_i32$4 : i64toi32_i32$3;
   $16 = i64toi32_i32$1;
   $16$hi = i64toi32_i32$2;
   i64toi32_i32$2 = $7$hi;
   i64toi32_i32$2 = $16$hi;
   i64toi32_i32$2 = $7$hi;
   i64toi32_i32$2 = $16$hi;
   i64toi32_i32$0 = i64toi32_i32$1;
   i64toi32_i32$1 = $7$hi;
   i64toi32_i32$4 = $7;
   i64toi32_i32$3 = i64toi32_i32$2 >>> 0 < i64toi32_i32$1 >>> 0 | ((i64toi32_i32$2 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$0 >>> 0 < i64toi32_i32$4 >>> 0 | 0) | 0;
   i64toi32_i32$0 = i64toi32_i32$2;
   i64toi32_i32$2 = i64toi32_i32$1;
   i64toi32_i32$1 = i64toi32_i32$3 ? $16 : i64toi32_i32$4;
   i64toi32_i32$4 = i64toi32_i32$3 ? i64toi32_i32$0 : i64toi32_i32$2;
   $141 = i64toi32_i32$1;
   $141$hi = i64toi32_i32$4;
   i64toi32_i32$4 = $3$hi;
   i64toi32_i32$3 = $3;
   i64toi32_i32$1 = $141$hi;
   i64toi32_i32$0 = $141;
   if (i64toi32_i32$4 >>> 0 < i64toi32_i32$1 >>> 0 | ((i64toi32_i32$4 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$3 >>> 0 < i64toi32_i32$0 >>> 0 | 0) | 0) {
    break label$4
   }
   $9 = 1;
   i64toi32_i32$3 = $4$hi;
   i64toi32_i32$3 = $5$hi;
   i64toi32_i32$3 = $6$hi;
   i64toi32_i32$3 = $5$hi;
   i64toi32_i32$3 = $6$hi;
   i64toi32_i32$3 = $5$hi;
   i64toi32_i32$0 = $5;
   i64toi32_i32$4 = $6$hi;
   i64toi32_i32$1 = $6;
   i64toi32_i32$2 = i64toi32_i32$3 >>> 0 < i64toi32_i32$4 >>> 0 | ((i64toi32_i32$3 | 0) == (i64toi32_i32$4 | 0) & i64toi32_i32$0 >>> 0 < i64toi32_i32$1 >>> 0 | 0) | 0;
   i64toi32_i32$0 = i64toi32_i32$3;
   i64toi32_i32$3 = i64toi32_i32$4;
   i64toi32_i32$4 = i64toi32_i32$2 ? $5 : i64toi32_i32$1;
   i64toi32_i32$1 = i64toi32_i32$2 ? i64toi32_i32$0 : i64toi32_i32$3;
   $16 = i64toi32_i32$4;
   $16$hi = i64toi32_i32$1;
   i64toi32_i32$1 = $7$hi;
   i64toi32_i32$1 = $16$hi;
   i64toi32_i32$1 = $7$hi;
   i64toi32_i32$1 = $16$hi;
   i64toi32_i32$2 = i64toi32_i32$4;
   i64toi32_i32$4 = $7$hi;
   i64toi32_i32$0 = $7;
   i64toi32_i32$3 = i64toi32_i32$1 >>> 0 < i64toi32_i32$4 >>> 0 | ((i64toi32_i32$1 | 0) == (i64toi32_i32$4 | 0) & i64toi32_i32$2 >>> 0 < i64toi32_i32$0 >>> 0 | 0) | 0;
   i64toi32_i32$2 = i64toi32_i32$1;
   i64toi32_i32$1 = i64toi32_i32$4;
   i64toi32_i32$4 = i64toi32_i32$3 ? $16 : i64toi32_i32$0;
   i64toi32_i32$0 = i64toi32_i32$3 ? i64toi32_i32$2 : i64toi32_i32$1;
   $155 = i64toi32_i32$4;
   $155$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $4$hi;
   i64toi32_i32$3 = $4;
   i64toi32_i32$4 = $155$hi;
   i64toi32_i32$2 = $155;
   if (i64toi32_i32$0 >>> 0 < i64toi32_i32$4 >>> 0 | ((i64toi32_i32$0 | 0) == (i64toi32_i32$4 | 0) & i64toi32_i32$3 >>> 0 < i64toi32_i32$2 >>> 0 | 0) | 0) {
    break label$4
   }
   i64toi32_i32$3 = $6$hi;
   i64toi32_i32$3 = $7$hi;
   i64toi32_i32$3 = $6$hi;
   i64toi32_i32$2 = $6;
   i64toi32_i32$0 = $7$hi;
   i64toi32_i32$4 = $7;
   $9 = i64toi32_i32$3 >>> 0 < i64toi32_i32$0 >>> 0 | ((i64toi32_i32$3 | 0) == (i64toi32_i32$0 | 0) & i64toi32_i32$2 >>> 0 < i64toi32_i32$4 >>> 0 | 0) | 0;
   i64toi32_i32$2 = $5$hi;
   i64toi32_i32$2 = i64toi32_i32$3;
   i64toi32_i32$2 = i64toi32_i32$0;
   i64toi32_i32$1 = $9;
   i64toi32_i32$2 = i64toi32_i32$3;
   i64toi32_i32$3 = i64toi32_i32$0;
   i64toi32_i32$0 = i64toi32_i32$1 ? $6 : i64toi32_i32$4;
   i64toi32_i32$4 = i64toi32_i32$1 ? i64toi32_i32$2 : i64toi32_i32$3;
   $166 = i64toi32_i32$0;
   $166$hi = i64toi32_i32$4;
   i64toi32_i32$4 = $5$hi;
   i64toi32_i32$1 = $5;
   i64toi32_i32$0 = $166$hi;
   i64toi32_i32$2 = $166;
   $9 = i64toi32_i32$4 >>> 0 < i64toi32_i32$0 >>> 0 | ((i64toi32_i32$4 | 0) == (i64toi32_i32$0 | 0) & i64toi32_i32$1 >>> 0 < i64toi32_i32$2 >>> 0 | 0) | 0 ? 2 : $9 ? 3 : 4;
  }
  $17 = Math_fround(0.0);
  $18 = Math_fround(0.0);
  label$5 : {
   i64toi32_i32$1 = $3$hi;
   if (!($3 | i64toi32_i32$1 | 0)) {
    break label$5
   }
   i64toi32_i32$1 = $3$hi;
   i64toi32_i32$4 = $3;
   i64toi32_i32$2 = 0;
   $18 = Math_fround(+log(+((+(i64toi32_i32$4 >>> 0) + 4294967296.0 * +(i64toi32_i32$1 >>> 0)) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453);
  }
  HEAPF32[$2 >> 2] = $18;
  label$6 : {
   i64toi32_i32$1 = $4$hi;
   if (!($4 | i64toi32_i32$1 | 0)) {
    break label$6
   }
   i64toi32_i32$1 = $4$hi;
   i64toi32_i32$4 = $4;
   i64toi32_i32$2 = 0;
   $17 = Math_fround(+log(+((+(i64toi32_i32$4 >>> 0) + 4294967296.0 * +(i64toi32_i32$1 >>> 0)) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453);
  }
  HEAPF32[($2 + 4 | 0) >> 2] = $17;
  $17 = Math_fround(0.0);
  $18 = Math_fround(0.0);
  label$7 : {
   i64toi32_i32$1 = $5$hi;
   if (!($5 | i64toi32_i32$1 | 0)) {
    break label$7
   }
   i64toi32_i32$1 = $5$hi;
   i64toi32_i32$4 = $5;
   i64toi32_i32$2 = 0;
   $18 = Math_fround(+log(+((+(i64toi32_i32$4 >>> 0) + 4294967296.0 * +(i64toi32_i32$1 >>> 0)) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453);
  }
  HEAPF32[($2 + 8 | 0) >> 2] = $18;
  label$8 : {
   i64toi32_i32$1 = $6$hi;
   if (!($6 | i64toi32_i32$1 | 0)) {
    break label$8
   }
   i64toi32_i32$1 = $6$hi;
   i64toi32_i32$4 = $6;
   i64toi32_i32$2 = 0;
   $17 = Math_fround(+log(+((+(i64toi32_i32$4 >>> 0) + 4294967296.0 * +(i64toi32_i32$1 >>> 0)) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453);
  }
  HEAPF32[($2 + 12 | 0) >> 2] = $17;
  label$9 : {
   i64toi32_i32$1 = $7$hi;
   if (!!($7 | i64toi32_i32$1 | 0)) {
    break label$9
   }
   HEAPF32[($2 + 16 | 0) >> 2] = Math_fround(0.0);
   return $9 | 0;
  }
  i64toi32_i32$1 = $7$hi;
  i64toi32_i32$4 = $7;
  i64toi32_i32$2 = 0;
  (wasm2js_i32$0 = $2, wasm2js_f32$0 = Math_fround(+log(+((+(i64toi32_i32$4 >>> 0) + 4294967296.0 * +(i64toi32_i32$1 >>> 0)) * .6931471805599453 / +($1 >>> 0))) / .6931471805599453)), HEAPF32[(wasm2js_i32$0 + 16 | 0) >> 2] = wasm2js_f32$0;
  return $9 | 0;
 }
 
 function FLAC__fixed_compute_residual($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0, $6 = 0, $7 = 0, $15 = 0, $50 = 0, $5 = 0, $129 = 0, $189 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     switch ($2 | 0) {
     case 4:
      $4 = 0;
      if (($1 | 0) <= (0 | 0)) {
       break label$2
      }
      label$7 : while (1) {
       $2 = $4 << 2 | 0;
       $15 = $3 + $2 | 0;
       $2 = $0 + $2 | 0;
       HEAP32[$15 >> 2] = ((Math_imul(HEAP32[($2 + -8 | 0) >> 2] | 0, 6) + (HEAP32[$2 >> 2] | 0) | 0) + (HEAP32[($2 + -16 | 0) >> 2] | 0) | 0) - (((HEAP32[($2 + -12 | 0) >> 2] | 0) + (HEAP32[($2 + -4 | 0) >> 2] | 0) | 0) << 2 | 0) | 0;
       $4 = $4 + 1 | 0;
       if (($4 | 0) != ($1 | 0)) {
        continue label$7
       }
       break label$2;
      };
     case 3:
      $4 = 0;
      if (($1 | 0) <= (0 | 0)) {
       break label$2
      }
      label$8 : while (1) {
       $2 = $4 << 2 | 0;
       $50 = $3 + $2 | 0;
       $2 = $0 + $2 | 0;
       HEAP32[$50 >> 2] = ((HEAP32[$2 >> 2] | 0) - (HEAP32[($2 + -12 | 0) >> 2] | 0) | 0) + Math_imul((HEAP32[($2 + -8 | 0) >> 2] | 0) - (HEAP32[($2 + -4 | 0) >> 2] | 0) | 0, 3) | 0;
       $4 = $4 + 1 | 0;
       if (($4 | 0) != ($1 | 0)) {
        continue label$8
       }
       break label$2;
      };
     case 2:
      if (($1 | 0) < (1 | 0)) {
       break label$2
      }
      $5 = $1 & 1 | 0;
      $4 = 0;
      label$9 : {
       if (($1 | 0) == (1 | 0)) {
        break label$9
       }
       $6 = $1 & -2 | 0;
       $4 = 0;
       label$10 : while (1) {
        $1 = $4 << 2 | 0;
        $2 = $0 + $1 | 0;
        $7 = $2 + -4 | 0;
        HEAP32[($3 + $1 | 0) >> 2] = ((HEAP32[$2 >> 2] | 0) - ((HEAP32[$7 >> 2] | 0) << 1 | 0) | 0) + (HEAP32[($2 + -8 | 0) >> 2] | 0) | 0;
        $1 = $1 | 4 | 0;
        HEAP32[($3 + $1 | 0) >> 2] = ((HEAP32[($0 + $1 | 0) >> 2] | 0) - ((HEAP32[$2 >> 2] | 0) << 1 | 0) | 0) + (HEAP32[$7 >> 2] | 0) | 0;
        $4 = $4 + 2 | 0;
        $6 = $6 + -2 | 0;
        if ($6) {
         continue label$10
        }
        break label$10;
       };
      }
      if (!$5) {
       break label$2
      }
      $2 = $4 << 2 | 0;
      $129 = $3 + $2 | 0;
      $2 = $0 + $2 | 0;
      HEAP32[$129 >> 2] = ((HEAP32[$2 >> 2] | 0) - ((HEAP32[($2 + -4 | 0) >> 2] | 0) << 1 | 0) | 0) + (HEAP32[($2 + -8 | 0) >> 2] | 0) | 0;
      return;
     case 0:
      break label$1;
     case 1:
      break label$3;
     default:
      break label$2;
     };
    }
    if (($1 | 0) < (1 | 0)) {
     break label$2
    }
    $7 = $1 & 1 | 0;
    $2 = 0;
    label$11 : {
     if (($1 | 0) == (1 | 0)) {
      break label$11
     }
     $6 = $1 & -2 | 0;
     $2 = 0;
     label$12 : while (1) {
      $4 = $2 << 2 | 0;
      $1 = $0 + $4 | 0;
      HEAP32[($3 + $4 | 0) >> 2] = (HEAP32[$1 >> 2] | 0) - (HEAP32[($1 + -4 | 0) >> 2] | 0) | 0;
      $4 = $4 | 4 | 0;
      HEAP32[($3 + $4 | 0) >> 2] = (HEAP32[($0 + $4 | 0) >> 2] | 0) - (HEAP32[$1 >> 2] | 0) | 0;
      $2 = $2 + 2 | 0;
      $6 = $6 + -2 | 0;
      if ($6) {
       continue label$12
      }
      break label$12;
     };
    }
    if (!$7) {
     break label$2
    }
    $2 = $2 << 2 | 0;
    $189 = $3 + $2 | 0;
    $2 = $0 + $2 | 0;
    HEAP32[$189 >> 2] = (HEAP32[$2 >> 2] | 0) - (HEAP32[($2 + -4 | 0) >> 2] | 0) | 0;
   }
   return;
  }
  __memcpy($3 | 0, $0 | 0, $1 << 2 | 0 | 0) | 0;
 }
 
 function FLAC__fixed_restore_signal($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $7 = 0, $4 = 0, $5 = 0, $6 = 0, $8 = 0, $9 = 0, $76 = 0, $96 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     switch ($2 | 0) {
     case 4:
      if (($1 | 0) < (1 | 0)) {
       break label$2
      }
      $4 = HEAP32[($3 + -12 | 0) >> 2] | 0;
      $5 = HEAP32[($3 + -4 | 0) >> 2] | 0;
      $2 = 0;
      label$7 : while (1) {
       $6 = $2 << 2 | 0;
       $7 = $3 + $6 | 0;
       $8 = HEAP32[($7 + -8 | 0) >> 2] | 0;
       $5 = ((Math_imul($8, -6) + (HEAP32[($0 + $6 | 0) >> 2] | 0) | 0) - (HEAP32[($7 + -16 | 0) >> 2] | 0) | 0) + (($4 + $5 | 0) << 2 | 0) | 0;
       HEAP32[$7 >> 2] = $5;
       $4 = $8;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue label$7
       }
       break label$2;
      };
     case 3:
      if (($1 | 0) < (1 | 0)) {
       break label$2
      }
      $9 = $1 & 1 | 0;
      $5 = HEAP32[($3 + -12 | 0) >> 2] | 0;
      $6 = HEAP32[($3 + -4 | 0) >> 2] | 0;
      $2 = 0;
      label$8 : {
       if (($1 | 0) == (1 | 0)) {
        break label$8
       }
       $8 = $1 & -2 | 0;
       $2 = 0;
       label$9 : while (1) {
        $7 = $2 << 2 | 0;
        $4 = $3 + $7 | 0;
        $76 = $5 + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0;
        $5 = HEAP32[($4 + -8 | 0) >> 2] | 0;
        $6 = $76 + Math_imul($6 - $5 | 0, 3) | 0;
        HEAP32[$4 >> 2] = $6;
        $7 = $7 | 4 | 0;
        $96 = $5 + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0;
        $5 = HEAP32[($4 + -4 | 0) >> 2] | 0;
        $6 = $96 + Math_imul($6 - $5 | 0, 3) | 0;
        HEAP32[($3 + $7 | 0) >> 2] = $6;
        $2 = $2 + 2 | 0;
        $8 = $8 + -2 | 0;
        if ($8) {
         continue label$9
        }
        break label$9;
       };
      }
      if (!$9) {
       break label$2
      }
      $2 = $2 << 2 | 0;
      $3 = $3 + $2 | 0;
      HEAP32[$3 >> 2] = ($5 + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0) + Math_imul($6 - (HEAP32[($3 + -8 | 0) >> 2] | 0) | 0, 3) | 0;
      return;
     case 2:
      if (($1 | 0) < (1 | 0)) {
       break label$2
      }
      $8 = $1 & 1 | 0;
      $5 = HEAP32[($3 + -4 | 0) >> 2] | 0;
      $2 = 0;
      label$10 : {
       if (($1 | 0) == (1 | 0)) {
        break label$10
       }
       $6 = $1 & -2 | 0;
       $2 = 0;
       label$11 : while (1) {
        $7 = $2 << 2 | 0;
        $4 = $3 + $7 | 0;
        $5 = (($5 << 1 | 0) + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0) - (HEAP32[($4 + -8 | 0) >> 2] | 0) | 0;
        HEAP32[$4 >> 2] = $5;
        $7 = $7 | 4 | 0;
        $5 = (($5 << 1 | 0) + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0) - (HEAP32[($4 + -4 | 0) >> 2] | 0) | 0;
        HEAP32[($3 + $7 | 0) >> 2] = $5;
        $2 = $2 + 2 | 0;
        $6 = $6 + -2 | 0;
        if ($6) {
         continue label$11
        }
        break label$11;
       };
      }
      if (!$8) {
       break label$2
      }
      $2 = $2 << 2 | 0;
      $3 = $3 + $2 | 0;
      HEAP32[$3 >> 2] = (($5 << 1 | 0) + (HEAP32[($0 + $2 | 0) >> 2] | 0) | 0) - (HEAP32[($3 + -8 | 0) >> 2] | 0) | 0;
      return;
     case 0:
      break label$1;
     case 1:
      break label$3;
     default:
      break label$2;
     };
    }
    if (($1 | 0) < (1 | 0)) {
     break label$2
    }
    $5 = $1 & 3 | 0;
    $4 = HEAP32[($3 + -4 | 0) >> 2] | 0;
    $2 = 0;
    label$12 : {
     if (($1 + -1 | 0) >>> 0 < 3 >>> 0) {
      break label$12
     }
     $6 = $1 & -4 | 0;
     $2 = 0;
     label$13 : while (1) {
      $7 = $2 << 2 | 0;
      $4 = $4 + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0;
      HEAP32[($3 + $7 | 0) >> 2] = $4;
      $8 = $7 | 4 | 0;
      $4 = $4 + (HEAP32[($0 + $8 | 0) >> 2] | 0) | 0;
      HEAP32[($3 + $8 | 0) >> 2] = $4;
      $8 = $7 | 8 | 0;
      $4 = $4 + (HEAP32[($0 + $8 | 0) >> 2] | 0) | 0;
      HEAP32[($3 + $8 | 0) >> 2] = $4;
      $7 = $7 | 12 | 0;
      $4 = $4 + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0;
      HEAP32[($3 + $7 | 0) >> 2] = $4;
      $2 = $2 + 4 | 0;
      $6 = $6 + -4 | 0;
      if ($6) {
       continue label$13
      }
      break label$13;
     };
    }
    if (!$5) {
     break label$2
    }
    label$14 : while (1) {
     $7 = $2 << 2 | 0;
     $4 = $4 + (HEAP32[($0 + $7 | 0) >> 2] | 0) | 0;
     HEAP32[($3 + $7 | 0) >> 2] = $4;
     $2 = $2 + 1 | 0;
     $5 = $5 + -1 | 0;
     if ($5) {
      continue label$14
     }
     break label$14;
    };
   }
   return;
  }
  __memcpy($3 | 0, $0 | 0, $1 << 2 | 0 | 0) | 0;
 }
 
 function __toread($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0;
  $1 = HEAPU8[($0 + 74 | 0) >> 0] | 0;
  HEAP8[($0 + 74 | 0) >> 0] = $1 + -1 | 0 | $1 | 0;
  label$1 : {
   if ((HEAP32[($0 + 20 | 0) >> 2] | 0) >>> 0 <= (HEAP32[($0 + 28 | 0) >> 2] | 0) >>> 0) {
    break label$1
   }
   FUNCTION_TABLE[HEAP32[($0 + 36 | 0) >> 2] | 0 | 0]($0, 0, 0) | 0;
  }
  HEAP32[($0 + 28 | 0) >> 2] = 0;
  HEAP32[($0 + 16 | 0) >> 2] = 0;
  HEAP32[($0 + 20 | 0) >> 2] = 0;
  label$2 : {
   $1 = HEAP32[$0 >> 2] | 0;
   if (!($1 & 4 | 0)) {
    break label$2
   }
   HEAP32[$0 >> 2] = $1 | 32 | 0;
   return -1 | 0;
  }
  $2 = (HEAP32[($0 + 44 | 0) >> 2] | 0) + (HEAP32[($0 + 48 | 0) >> 2] | 0) | 0;
  HEAP32[($0 + 8 | 0) >> 2] = $2;
  HEAP32[($0 + 4 | 0) >> 2] = $2;
  return ($1 << 27 | 0) >> 31 | 0 | 0;
 }
 
 function FLAC__stream_decoder_new() {
  var i64toi32_i32$1 = 0, $2 = 0, i64toi32_i32$0 = 0, $1 = 0, $0 = 0, $3 = 0, $4 = 0;
  label$1 : {
   $0 = dlcalloc(1 | 0, 8 | 0) | 0;
   if (!$0) {
    break label$1
   }
   $1 = dlcalloc(1 | 0, 504 | 0) | 0;
   HEAP32[$0 >> 2] = $1;
   label$2 : {
    if (!$1) {
     break label$2
    }
    $2 = dlcalloc(1 | 0, 6160 | 0) | 0;
    HEAP32[($0 + 4 | 0) >> 2] = $2;
    label$3 : {
     if (!$2) {
      break label$3
     }
     $3 = FLAC__bitreader_new() | 0;
     HEAP32[($2 + 56 | 0) >> 2] = $3;
     label$4 : {
      if (!$3) {
       break label$4
      }
      HEAP32[($2 + 1128 | 0) >> 2] = 16;
      $4 = dlmalloc(((HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_APPLICATION_ID_LEN >> 2] | 0) << 1 | 0) & -16 | 0 | 0) | 0;
      HEAP32[($2 + 1120 | 0) >> 2] = $4;
      label$5 : {
       if (!$4) {
        break label$5
       }
       HEAP32[($2 + 252 | 0) >> 2] = 0;
       i64toi32_i32$1 = $2;
       i64toi32_i32$0 = 0;
       HEAP32[($2 + 220 | 0) >> 2] = 0;
       HEAP32[($2 + 224 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 3616 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 3608 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 3600 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 3592 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 60 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 68 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 76 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 84 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 92 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 100 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 108 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 116 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($2 + 124 | 0 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($2 + 136 | 0 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($2 + 148 | 0 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($2 + 160 | 0 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($2 + 172 | 0 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($2 + 184 | 0 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($2 + 196 | 0 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($2 + 208 | 0 | 0);
       i64toi32_i32$1 = $2;
       i64toi32_i32$0 = 0;
       HEAP32[($2 + 48 | 0) >> 2] = 0;
       HEAP32[($2 + 52 | 0) >> 2] = i64toi32_i32$0;
       memset($2 + 608 | 0 | 0, 0 | 0, 512 | 0) | 0;
       HEAP32[($2 + 1124 | 0) >> 2] = 0;
       HEAP32[($2 + 608 | 0) >> 2] = 1;
       HEAP32[($2 + 32 | 0) >> 2] = 0;
       i64toi32_i32$1 = $2 + 24 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 16 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2 + 8 | 0;
       i64toi32_i32$0 = 0;
       HEAP32[i64toi32_i32$1 >> 2] = 0;
       HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
       i64toi32_i32$1 = $2;
       i64toi32_i32$0 = 0;
       HEAP32[$2 >> 2] = 0;
       HEAP32[($2 + 4 | 0) >> 2] = i64toi32_i32$0;
       HEAP32[($1 + 28 | 0) >> 2] = 0;
       FLAC__ogg_decoder_aspect_set_defaults($1 + 32 | 0 | 0);
       HEAP32[$1 >> 2] = 9;
       return $0 | 0;
      }
      FLAC__bitreader_delete($3 | 0);
     }
     dlfree($2 | 0);
    }
    dlfree($1 | 0);
   }
   dlfree($0 | 0);
  }
  return 0 | 0;
 }
 
 function FLAC__stream_decoder_delete($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   FLAC__stream_decoder_finish($0 | 0) | 0;
   label$2 : {
    $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    $2 = HEAP32[($1 + 1120 | 0) >> 2] | 0;
    if (!$2) {
     break label$2
    }
    dlfree($2 | 0);
    $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   }
   FLAC__bitreader_delete(HEAP32[($1 + 56 | 0) >> 2] | 0 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear((HEAP32[($0 + 4 | 0) >> 2] | 0) + 124 | 0 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear((HEAP32[($0 + 4 | 0) >> 2] | 0) + 136 | 0 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear((HEAP32[($0 + 4 | 0) >> 2] | 0) + 148 | 0 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear((HEAP32[($0 + 4 | 0) >> 2] | 0) + 160 | 0 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear((HEAP32[($0 + 4 | 0) >> 2] | 0) + 172 | 0 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear((HEAP32[($0 + 4 | 0) >> 2] | 0) + 184 | 0 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear((HEAP32[($0 + 4 | 0) >> 2] | 0) + 196 | 0 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear((HEAP32[($0 + 4 | 0) >> 2] | 0) + 208 | 0 | 0);
   dlfree(HEAP32[($0 + 4 | 0) >> 2] | 0 | 0);
   dlfree(HEAP32[$0 >> 2] | 0 | 0);
   dlfree($0 | 0);
  }
 }
 
 function FLAC__stream_decoder_finish($0) {
  $0 = $0 | 0;
  var $2 = 0, $3 = 0, $1 = 0, i64toi32_i32$1 = 0, i64toi32_i32$0 = 0;
  $1 = 1;
  label$1 : {
   if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) == (9 | 0)) {
    break label$1
   }
   $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   FLAC__MD5Final($2 + 3732 | 0 | 0, $2 + 3636 | 0 | 0);
   dlfree(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 452 | 0) >> 2] | 0 | 0);
   HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 452 | 0) >> 2] = 0;
   $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   HEAP32[($2 + 252 | 0) >> 2] = 0;
   FLAC__bitreader_free(HEAP32[($2 + 56 | 0) >> 2] | 0 | 0);
   $1 = $0 + 4 | 0;
   label$2 : {
    $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    $3 = HEAP32[($2 + 60 | 0) >> 2] | 0;
    if (!$3) {
     break label$2
    }
    dlfree($3 + -16 | 0 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 60 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$3 : {
    $3 = HEAP32[($2 + 3592 | 0) >> 2] | 0;
    if (!$3) {
     break label$3
    }
    dlfree($3 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 92 | 0) >> 2] = 0;
    HEAP32[((HEAP32[$1 >> 2] | 0) + 3592 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$4 : {
    $3 = HEAP32[($2 + 64 | 0) >> 2] | 0;
    if (!$3) {
     break label$4
    }
    dlfree($3 + -16 | 0 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 64 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$5 : {
    $3 = HEAP32[($2 + 3596 | 0) >> 2] | 0;
    if (!$3) {
     break label$5
    }
    dlfree($3 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 96 | 0) >> 2] = 0;
    HEAP32[((HEAP32[$1 >> 2] | 0) + 3596 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$6 : {
    $3 = HEAP32[($2 + 68 | 0) >> 2] | 0;
    if (!$3) {
     break label$6
    }
    dlfree($3 + -16 | 0 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 68 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$7 : {
    $3 = HEAP32[($2 + 3600 | 0) >> 2] | 0;
    if (!$3) {
     break label$7
    }
    dlfree($3 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 100 | 0) >> 2] = 0;
    HEAP32[((HEAP32[$1 >> 2] | 0) + 3600 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$8 : {
    $3 = HEAP32[($2 + 72 | 0) >> 2] | 0;
    if (!$3) {
     break label$8
    }
    dlfree($3 + -16 | 0 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 72 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$9 : {
    $3 = HEAP32[($2 + 3604 | 0) >> 2] | 0;
    if (!$3) {
     break label$9
    }
    dlfree($3 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 104 | 0) >> 2] = 0;
    HEAP32[((HEAP32[$1 >> 2] | 0) + 3604 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$10 : {
    $3 = HEAP32[($2 + 76 | 0) >> 2] | 0;
    if (!$3) {
     break label$10
    }
    dlfree($3 + -16 | 0 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 76 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$11 : {
    $3 = HEAP32[($2 + 3608 | 0) >> 2] | 0;
    if (!$3) {
     break label$11
    }
    dlfree($3 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 108 | 0) >> 2] = 0;
    HEAP32[((HEAP32[$1 >> 2] | 0) + 3608 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$12 : {
    $3 = HEAP32[($2 + 80 | 0) >> 2] | 0;
    if (!$3) {
     break label$12
    }
    dlfree($3 + -16 | 0 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 80 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$13 : {
    $3 = HEAP32[($2 + 3612 | 0) >> 2] | 0;
    if (!$3) {
     break label$13
    }
    dlfree($3 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 112 | 0) >> 2] = 0;
    HEAP32[((HEAP32[$1 >> 2] | 0) + 3612 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$14 : {
    $3 = HEAP32[($2 + 84 | 0) >> 2] | 0;
    if (!$3) {
     break label$14
    }
    dlfree($3 + -16 | 0 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 84 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$15 : {
    $3 = HEAP32[($2 + 3616 | 0) >> 2] | 0;
    if (!$3) {
     break label$15
    }
    dlfree($3 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 116 | 0) >> 2] = 0;
    HEAP32[((HEAP32[$1 >> 2] | 0) + 3616 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$16 : {
    $3 = HEAP32[($2 + 88 | 0) >> 2] | 0;
    if (!$3) {
     break label$16
    }
    dlfree($3 + -16 | 0 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 88 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   label$17 : {
    $3 = HEAP32[($2 + 3620 | 0) >> 2] | 0;
    if (!$3) {
     break label$17
    }
    dlfree($3 | 0);
    HEAP32[((HEAP32[$1 >> 2] | 0) + 120 | 0) >> 2] = 0;
    HEAP32[((HEAP32[$1 >> 2] | 0) + 3620 | 0) >> 2] = 0;
    $2 = HEAP32[$1 >> 2] | 0;
   }
   i64toi32_i32$1 = $2;
   i64toi32_i32$0 = 0;
   HEAP32[($2 + 220 | 0) >> 2] = 0;
   HEAP32[($2 + 224 | 0) >> 2] = i64toi32_i32$0;
   label$18 : {
    if (!(HEAP32[$2 >> 2] | 0)) {
     break label$18
    }
    FLAC__ogg_decoder_aspect_finish((HEAP32[$0 >> 2] | 0) + 32 | 0 | 0);
    $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   }
   label$19 : {
    $3 = HEAP32[($2 + 52 | 0) >> 2] | 0;
    if (!$3) {
     break label$19
    }
    label$20 : {
     if (($3 | 0) == (HEAP32[GOT_data_internal_stdin >> 2] | 0 | 0)) {
      break label$20
     }
     fclose($3 | 0) | 0;
     $2 = HEAP32[$1 >> 2] | 0;
    }
    HEAP32[($2 + 52 | 0) >> 2] = 0;
   }
   $1 = 1;
   label$21 : {
    if (!(HEAP32[($2 + 3624 | 0) >> 2] | 0)) {
     break label$21
    }
    $1 = !(memcmp($2 + 312 | 0 | 0, $2 + 3732 | 0 | 0, 16 | 0) | 0);
   }
   HEAP32[($2 + 48 | 0) >> 2] = 0;
   HEAP32[($2 + 3632 | 0) >> 2] = 0;
   memset($2 + 608 | 0 | 0, 0 | 0, 512 | 0) | 0;
   HEAP32[($2 + 32 | 0) >> 2] = 0;
   i64toi32_i32$1 = $2 + 24 | 0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$1 = $2 + 16 | 0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$1 = $2 + 8 | 0;
   i64toi32_i32$0 = 0;
   HEAP32[i64toi32_i32$1 >> 2] = 0;
   HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$1 = $2;
   i64toi32_i32$0 = 0;
   HEAP32[$2 >> 2] = 0;
   HEAP32[($2 + 4 | 0) >> 2] = i64toi32_i32$0;
   $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   HEAP32[($2 + 1124 | 0) >> 2] = 0;
   HEAP32[($2 + 608 | 0) >> 2] = 1;
   $2 = HEAP32[$0 >> 2] | 0;
   HEAP32[($2 + 28 | 0) >> 2] = 0;
   FLAC__ogg_decoder_aspect_set_defaults($2 + 32 | 0 | 0);
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 9;
  }
  return $1 | 0;
 }
 
 function FLAC__stream_decoder_init_stream($0, $1, $2, $3, $4, $5, $6, $7, $8, $9) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  $7 = $7 | 0;
  $8 = $8 | 0;
  $9 = $9 | 0;
  return init_stream_internal_($0 | 0, $1 | 0, $2 | 0, $3 | 0, $4 | 0, $5 | 0, $6 | 0, $7 | 0, $8 | 0, $9 | 0, 0 | 0) | 0 | 0;
 }
 
 function init_stream_internal_($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  $7 = $7 | 0;
  $8 = $8 | 0;
  $9 = $9 | 0;
  $10 = $10 | 0;
  var $11 = 0, i64toi32_i32$0 = 0, $12 = 0;
  $11 = 5;
  label$1 : {
   label$2 : {
    $12 = HEAP32[$0 >> 2] | 0;
    if ((HEAP32[$12 >> 2] | 0 | 0) != (9 | 0)) {
     break label$2
    }
    $11 = 2;
    if (!$1) {
     break label$2
    }
    if (!$6) {
     break label$2
    }
    if (!$8) {
     break label$2
    }
    label$3 : {
     if (!$2) {
      break label$3
     }
     if (!$3) {
      break label$2
     }
     if (!$4) {
      break label$2
     }
     if (!$5) {
      break label$2
     }
    }
    $11 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    HEAP32[$11 >> 2] = $10;
    label$4 : {
     if (!$10) {
      break label$4
     }
     if (!(FLAC__ogg_decoder_aspect_init($12 + 32 | 0 | 0) | 0)) {
      break label$1
     }
     $11 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    }
    FLAC__cpu_info($11 + 3524 | 0 | 0);
    $11 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    $10 = GOT_func_internal_FLAC__lpc_restore_signal;
    HEAP32[($11 + 44 | 0) >> 2] = $10;
    HEAP32[($11 + 40 | 0) >> 2] = GOT_func_internal_FLAC__lpc_restore_signal_wide;
    HEAP32[($11 + 36 | 0) >> 2] = $10;
    $10 = GOT_data_internal___table_base;
    label$5 : {
     if (FLAC__bitreader_init(HEAP32[($11 + 56 | 0) >> 2] | 0 | 0, $10 + 6 | 0 | 0, $0 | 0) | 0) {
      break label$5
     }
     HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
     return 3 | 0;
    }
    $11 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    HEAP32[($11 + 48 | 0) >> 2] = $9;
    HEAP32[($11 + 32 | 0) >> 2] = $8;
    HEAP32[($11 + 28 | 0) >> 2] = $7;
    HEAP32[($11 + 24 | 0) >> 2] = $6;
    HEAP32[($11 + 20 | 0) >> 2] = $5;
    HEAP32[($11 + 16 | 0) >> 2] = $4;
    HEAP32[($11 + 12 | 0) >> 2] = $3;
    HEAP32[($11 + 8 | 0) >> 2] = $2;
    HEAP32[($11 + 4 | 0) >> 2] = $1;
    HEAP32[($11 + 3520 | 0) >> 2] = 0;
    HEAP32[($11 + 248 | 0) >> 2] = 0;
    i64toi32_i32$0 = 0;
    HEAP32[($11 + 240 | 0) >> 2] = 0;
    HEAP32[($11 + 244 | 0) >> 2] = i64toi32_i32$0;
    i64toi32_i32$0 = 0;
    HEAP32[($11 + 228 | 0) >> 2] = 0;
    HEAP32[($11 + 232 | 0) >> 2] = i64toi32_i32$0;
    HEAP32[($11 + 3624 | 0) >> 2] = HEAP32[((HEAP32[$0 >> 2] | 0) + 28 | 0) >> 2] | 0;
    i64toi32_i32$0 = 0;
    HEAP32[($11 + 3628 | 0) >> 2] = 1;
    HEAP32[($11 + 3632 | 0) >> 2] = i64toi32_i32$0;
    $11 = FLAC__stream_decoder_reset($0 | 0) | 0 ? 0 : 3;
   }
   return $11 | 0;
  }
  HEAP32[((HEAP32[$0 >> 2] | 0) + 4 | 0) >> 2] = 4;
  return 4 | 0;
 }
 
 function read_callback_($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $6 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      $3 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      if (HEAP32[$3 >> 2] | 0) {
       break label$4
      }
      $4 = HEAP32[($3 + 20 | 0) >> 2] | 0;
      if (!$4) {
       break label$4
      }
      if (!(FUNCTION_TABLE[$4 | 0]($2, HEAP32[($3 + 48 | 0) >> 2] | 0) | 0)) {
       break label$4
      }
      HEAP32[$1 >> 2] = 0;
      break label$3;
     }
     $4 = 7;
     if (!(HEAP32[$1 >> 2] | 0)) {
      break label$2
     }
     label$5 : {
      $3 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      if (!(HEAP32[($3 + 3632 | 0) >> 2] | 0)) {
       break label$5
      }
      if ((HEAP32[($3 + 6152 | 0) >> 2] | 0) >>> 0 > 20 >>> 0) {
       break label$2
      }
     }
     label$6 : {
      label$7 : {
       label$8 : {
        if (!(HEAP32[$3 >> 2] | 0)) {
         break label$8
        }
        $6 = 0;
        switch (FLAC__ogg_decoder_aspect_read_callback_wrapper((HEAP32[$2 >> 2] | 0) + 32 | 0 | 0, $0 | 0, $1 | 0, GOT_data_internal___table_base + 7 | 0 | 0, $2 | 0, HEAP32[($3 + 48 | 0) >> 2] | 0 | 0) | 0 | 0) {
        case 1:
         break label$6;
        case 0:
        case 2:
         break label$7;
        default:
         break label$2;
        };
       }
       $6 = FUNCTION_TABLE[HEAP32[($3 + 4 | 0) >> 2] | 0 | 0]($2, $0, $1, HEAP32[($3 + 48 | 0) >> 2] | 0) | 0;
       if (($6 | 0) == (2 | 0)) {
        break label$2
       }
      }
      $3 = 1;
      if (HEAP32[$1 >> 2] | 0) {
       break label$1
      }
      $3 = 1;
      $4 = 4;
      if (($6 | 0) == (1 | 0)) {
       break label$2
      }
      $1 = HEAP32[($2 + 4 | 0) >> 2] | 0;
      if (HEAP32[$1 >> 2] | 0) {
       break label$1
      }
      $0 = HEAP32[($1 + 20 | 0) >> 2] | 0;
      if (!$0) {
       break label$1
      }
      if (FUNCTION_TABLE[$0 | 0]($2, HEAP32[($1 + 48 | 0) >> 2] | 0) | 0) {
       break label$2
      }
      break label$1;
     }
     $3 = 1;
     if (HEAP32[$1 >> 2] | 0) {
      break label$1
     }
    }
    $4 = 4;
   }
   HEAP32[(HEAP32[$2 >> 2] | 0) >> 2] = $4;
   $3 = 0;
  }
  return $3 | 0;
 }
 
 function FLAC__stream_decoder_reset($0) {
  $0 = $0 | 0;
  var $1 = 0, i64toi32_i32$0 = 0, $3 = 0, $2 = 0;
  label$1 : {
   label$2 : {
    $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    if (HEAP32[($1 + 3628 | 0) >> 2] | 0) {
     break label$2
    }
    $2 = 0;
    if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) == (9 | 0)) {
     break label$1
    }
   }
   $2 = 0;
   HEAP32[($1 + 3624 | 0) >> 2] = 0;
   i64toi32_i32$0 = 0;
   HEAP32[($1 + 240 | 0) >> 2] = 0;
   HEAP32[($1 + 244 | 0) >> 2] = i64toi32_i32$0;
   label$3 : {
    if (!(HEAP32[$1 >> 2] | 0)) {
     break label$3
    }
    FLAC__ogg_decoder_aspect_flush((HEAP32[$0 >> 2] | 0) + 32 | 0 | 0);
    $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   }
   $1 = FLAC__bitreader_clear(HEAP32[($1 + 56 | 0) >> 2] | 0 | 0) | 0;
   $3 = HEAP32[$0 >> 2] | 0;
   HEAP32[$3 >> 2] = $1 ? 2 : 8;
   if (!$1) {
    break label$1
   }
   label$4 : {
    $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    if (!(HEAP32[$1 >> 2] | 0)) {
     break label$4
    }
    FLAC__ogg_decoder_aspect_reset($3 + 32 | 0 | 0);
    $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   }
   label$5 : {
    label$6 : {
     if (HEAP32[($1 + 3628 | 0) >> 2] | 0) {
      break label$6
     }
     $3 = GOT_data_internal_stdin;
     if ((HEAP32[($1 + 52 | 0) >> 2] | 0 | 0) == (HEAP32[$3 >> 2] | 0 | 0)) {
      break label$1
     }
     $3 = HEAP32[($1 + 8 | 0) >> 2] | 0;
     if (!$3) {
      break label$5
     }
     i64toi32_i32$0 = 0;
     if ((FUNCTION_TABLE[$3 | 0]($0, 0, i64toi32_i32$0, HEAP32[($1 + 48 | 0) >> 2] | 0) | 0 | 0) == (1 | 0)) {
      break label$1
     }
     $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     break label$5;
    }
    HEAP32[($1 + 3628 | 0) >> 2] = 0;
   }
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 0;
   HEAP32[($1 + 248 | 0) >> 2] = 0;
   dlfree(HEAP32[($1 + 452 | 0) >> 2] | 0 | 0);
   HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 452 | 0) >> 2] = 0;
   $1 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   HEAP32[($1 + 252 | 0) >> 2] = 0;
   HEAP32[($1 + 3624 | 0) >> 2] = HEAP32[((HEAP32[$0 >> 2] | 0) + 28 | 0) >> 2] | 0;
   i64toi32_i32$0 = 0;
   HEAP32[($1 + 228 | 0) >> 2] = 0;
   HEAP32[($1 + 232 | 0) >> 2] = i64toi32_i32$0;
   FLAC__MD5Init($1 + 3636 | 0 | 0);
   $0 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   HEAP32[($0 + 6152 | 0) >> 2] = 0;
   i64toi32_i32$0 = 0;
   HEAP32[($0 + 6136 | 0) >> 2] = 0;
   HEAP32[($0 + 6140 | 0) >> 2] = i64toi32_i32$0;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_init_ogg_stream($0, $1, $2, $3, $4, $5, $6, $7, $8, $9) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  $7 = $7 | 0;
  $8 = $8 | 0;
  $9 = $9 | 0;
  return init_stream_internal_($0 | 0, $1 | 0, $2 | 0, $3 | 0, $4 | 0, $5 | 0, $6 | 0, $7 | 0, $8 | 0, $9 | 0, 1 | 0) | 0 | 0;
 }
 
 function FLAC__stream_decoder_set_ogg_serial_number($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $2 = 0;
  label$1 : {
   $0 = HEAP32[$0 >> 2] | 0;
   if ((HEAP32[$0 >> 2] | 0 | 0) != (9 | 0)) {
    break label$1
   }
   FLAC__ogg_decoder_aspect_set_serial_number($0 + 32 | 0 | 0, $1 | 0);
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_md5_checking($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $2 = 0;
  label$1 : {
   $0 = HEAP32[$0 >> 2] | 0;
   if ((HEAP32[$0 >> 2] | 0 | 0) != (9 | 0)) {
    break label$1
   }
   HEAP32[($0 + 28 | 0) >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_respond($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $2 = 0;
  label$1 : {
   if ($1 >>> 0 > 126 >>> 0) {
    break label$1
   }
   if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) != (9 | 0)) {
    break label$1
   }
   $2 = 1;
   $0 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   HEAP32[(($0 + ($1 << 2 | 0) | 0) + 608 | 0) >> 2] = 1;
   if (($1 | 0) != (2 | 0)) {
    break label$1
   }
   HEAP32[($0 + 1124 | 0) >> 2] = 0;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_respond_application($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0;
  $2 = 0;
  label$1 : {
   if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) != (9 | 0)) {
    break label$1
   }
   $2 = 1;
   $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   if (HEAP32[($3 + 616 | 0) >> 2] | 0) {
    break label$1
   }
   $4 = HEAP32[($3 + 1120 | 0) >> 2] | 0;
   label$2 : {
    label$3 : {
     label$4 : {
      $2 = HEAP32[($3 + 1124 | 0) >> 2] | 0;
      if (($2 | 0) == (HEAP32[($3 + 1128 | 0) >> 2] | 0 | 0)) {
       break label$4
      }
      $3 = $4;
      break label$3;
     }
     label$5 : {
      label$6 : {
       if ($2) {
        break label$6
       }
       $3 = dlrealloc($4 | 0, 0 | 0) | 0;
       break label$5;
      }
      label$7 : {
       if (($2 | 0) < (0 | 0)) {
        break label$7
       }
       $3 = dlrealloc($4 | 0, $2 << 1 | 0 | 0) | 0;
       if ($3) {
        break label$5
       }
       dlfree($4 | 0);
       $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
      }
      HEAP32[($3 + 1120 | 0) >> 2] = 0;
      break label$2;
     }
     $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     HEAP32[($2 + 1120 | 0) >> 2] = $3;
     if (!$3) {
      break label$2
     }
     HEAP32[($2 + 1128 | 0) >> 2] = (HEAP32[($2 + 1128 | 0) >> 2] | 0) << 1 | 0;
     $2 = HEAP32[($2 + 1124 | 0) >> 2] | 0;
    }
    $4 = (HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_APPLICATION_ID_LEN >> 2] | 0) >>> 3 | 0;
    __memcpy($3 + Math_imul($4, $2) | 0 | 0, $1 | 0, $4 | 0) | 0;
    $0 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    HEAP32[($0 + 1124 | 0) >> 2] = (HEAP32[($0 + 1124 | 0) >> 2] | 0) + 1 | 0;
    return 1 | 0;
   }
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
   $2 = 0;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_respond_all($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0;
  $1 = 0;
  label$1 : {
   if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) != (9 | 0)) {
    break label$1
   }
   $2 = 0;
   $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   $0 = $3 + 608 | 0;
   label$2 : while (1) {
    $1 = $2 << 2 | 0;
    HEAP32[($0 + $1 | 0) >> 2] = 1;
    HEAP32[($0 + ($1 | 4 | 0) | 0) >> 2] = 1;
    HEAP32[($0 + ($1 | 8 | 0) | 0) >> 2] = 1;
    HEAP32[($0 + ($1 | 12 | 0) | 0) >> 2] = 1;
    HEAP32[($0 + ($1 | 16 | 0) | 0) >> 2] = 1;
    HEAP32[($0 + ($1 | 20 | 0) | 0) >> 2] = 1;
    HEAP32[($0 + ($1 | 24 | 0) | 0) >> 2] = 1;
    HEAP32[($0 + ($1 | 28 | 0) | 0) >> 2] = 1;
    $2 = $2 + 8 | 0;
    if (($2 | 0) != (128 | 0)) {
     continue label$2
    }
    break label$2;
   };
   HEAP32[($3 + 1124 | 0) >> 2] = 0;
   $1 = 1;
  }
  return $1 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_ignore($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $2 = 0;
  label$1 : {
   if ($1 >>> 0 > 126 >>> 0) {
    break label$1
   }
   if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) != (9 | 0)) {
    break label$1
   }
   $0 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   HEAP32[(($0 + ($1 << 2 | 0) | 0) + 608 | 0) >> 2] = 0;
   $2 = 1;
   if (($1 | 0) != (2 | 0)) {
    break label$1
   }
   HEAP32[($0 + 1124 | 0) >> 2] = 0;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_ignore_application($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $4 = 0, $3 = 0;
  label$1 : {
   if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) != (9 | 0)) {
    break label$1
   }
   label$2 : {
    $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    if (HEAP32[($2 + 616 | 0) >> 2] | 0) {
     break label$2
    }
    return 1 | 0;
   }
   $3 = HEAP32[($2 + 1120 | 0) >> 2] | 0;
   label$3 : {
    label$4 : {
     label$5 : {
      $4 = HEAP32[($2 + 1124 | 0) >> 2] | 0;
      if (($4 | 0) == (HEAP32[($2 + 1128 | 0) >> 2] | 0 | 0)) {
       break label$5
      }
      $2 = $3;
      break label$4;
     }
     label$6 : {
      label$7 : {
       if ($4) {
        break label$7
       }
       $2 = dlrealloc($3 | 0, 0 | 0) | 0;
       break label$6;
      }
      label$8 : {
       if (($4 | 0) < (0 | 0)) {
        break label$8
       }
       $2 = dlrealloc($3 | 0, $4 << 1 | 0 | 0) | 0;
       if ($2) {
        break label$6
       }
       dlfree($3 | 0);
       $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
      }
      HEAP32[($2 + 1120 | 0) >> 2] = 0;
      break label$3;
     }
     $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     HEAP32[($4 + 1120 | 0) >> 2] = $2;
     if (!$2) {
      break label$3
     }
     HEAP32[($4 + 1128 | 0) >> 2] = (HEAP32[($4 + 1128 | 0) >> 2] | 0) << 1 | 0;
     $4 = HEAP32[($4 + 1124 | 0) >> 2] | 0;
    }
    $3 = (HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_APPLICATION_ID_LEN >> 2] | 0) >>> 3 | 0;
    __memcpy($2 + Math_imul($3, $4) | 0 | 0, $1 | 0, $3 | 0) | 0;
    $0 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    HEAP32[($0 + 1124 | 0) >> 2] = (HEAP32[($0 + 1124 | 0) >> 2] | 0) + 1 | 0;
    return 1 | 0;
   }
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
  }
  return 0 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_ignore_all($0) {
  $0 = $0 | 0;
  var $1 = 0;
  $1 = 0;
  label$1 : {
   if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) != (9 | 0)) {
    break label$1
   }
   memset((HEAP32[($0 + 4 | 0) >> 2] | 0) + 608 | 0 | 0, 0 | 0, 512 | 0) | 0;
   HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 1124 | 0) >> 2] = 0;
   $1 = 1;
  }
  return $1 | 0;
 }
 
 function FLAC__stream_decoder_get_state($0) {
  $0 = $0 | 0;
  return HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0;
 }
 
 function FLAC__stream_decoder_get_md5_checking($0) {
  $0 = $0 | 0;
  return HEAP32[((HEAP32[$0 >> 2] | 0) + 28 | 0) >> 2] | 0 | 0;
 }
 
 function FLAC__stream_decoder_process_single($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  $2 = 1;
  label$1 : {
   label$2 : {
    label$3 : while (1) {
     $3 = 0;
     label$4 : {
      switch (HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) {
      case 0:
       if (find_metadata_($0 | 0) | 0) {
        continue label$3
       }
       $2 = 0;
       break label$2;
      case 1:
       $3 = (read_metadata_($0 | 0) | 0 | 0) != (0 | 0);
       break label$1;
      case 2:
       if (frame_sync_($0 | 0) | 0) {
        continue label$3
       }
       break label$2;
      case 4:
      case 7:
       break label$2;
      case 3:
       break label$4;
      default:
       break label$1;
      };
     }
     label$8 : {
      if (read_frame_($0 | 0, $1 + 12 | 0 | 0, 1 | 0) | 0) {
       break label$8
      }
      $2 = 0;
      break label$2;
     }
     if (!(HEAP32[($1 + 12 | 0) >> 2] | 0)) {
      continue label$3
     }
     break label$3;
    };
   }
   $3 = $2;
  }
  __stack_pointer = $1 + 16 | 0;
  return $3 | 0;
 }
 
 function find_metadata_($0) {
  $0 = $0 | 0;
  var $1 = 0, $4 = 0, $3 = 0, $6 = 0, $5 = 0, $2 = 0, $7 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  $2 = 1;
  $3 = 0;
  label$1 : {
   label$2 : while (1) {
    $4 = 0;
    label$3 : {
     label$4 : while (1) {
      label$5 : {
       label$6 : {
        $5 = HEAP32[($0 + 4 | 0) >> 2] | 0;
        if (!(HEAP32[($5 + 3520 | 0) >> 2] | 0)) {
         break label$6
        }
        $6 = HEAPU8[($5 + 3590 | 0) >> 0] | 0;
        HEAP32[($1 + 8 | 0) >> 2] = $6;
        HEAP32[($5 + 3520 | 0) >> 2] = 0;
        break label$5;
       }
       label$7 : {
        if (FLAC__bitreader_read_raw_uint32(HEAP32[($5 + 56 | 0) >> 2] | 0 | 0, $1 + 8 | 0 | 0, 8 | 0) | 0) {
         break label$7
        }
        $3 = 0;
        break label$1;
       }
       $6 = HEAP32[($1 + 8 | 0) >> 2] | 0;
      }
      label$8 : {
       if (($6 | 0) != (HEAPU8[(GOT_data_internal_FLAC__STREAM_SYNC_STRING + $3 | 0) >> 0] | 0 | 0)) {
        break label$8
       }
       $2 = 1;
       $3 = $3 + 1 | 0;
       break label$3;
      }
      $3 = 0;
      if (($4 | 0) == (3 | 0)) {
       break label$1
      }
      label$9 : {
       if (($6 | 0) != (HEAPU8[((GOT_data_internal___memory_base + 7836 | 0) + $4 | 0) >> 0] | 0 | 0)) {
        break label$9
       }
       $3 = 0;
       $4 = $4 + 1 | 0;
       if (($4 | 0) != (3 | 0)) {
        continue label$4
       }
       label$10 : {
        label$11 : {
         if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 12 | 0 | 0, 24 | 0) | 0)) {
          break label$11
         }
         if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 12 | 0 | 0, 8 | 0) | 0)) {
          break label$11
         }
         $6 = HEAP32[($1 + 12 | 0) >> 2] | 0;
         if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 12 | 0 | 0, 8 | 0) | 0)) {
          break label$11
         }
         $5 = HEAP32[($1 + 12 | 0) >> 2] | 0;
         if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 12 | 0 | 0, 8 | 0) | 0)) {
          break label$11
         }
         $7 = HEAP32[($1 + 12 | 0) >> 2] | 0;
         if (FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 12 | 0 | 0, 8 | 0) | 0) {
          break label$10
         }
        }
        $3 = 0;
        break label$1;
       }
       $3 = 0;
       if (FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, (HEAP32[($1 + 12 | 0) >> 2] | 0) & 127 | 0 | (($7 << 7 | 0) & 16256 | 0 | (($5 & 127 | 0 | (($6 << 7 | 0) & 16256 | 0) | 0) << 14 | 0) | 0) | 0 | 0) | 0) {
        continue label$4
       }
       break label$1;
      }
      break label$4;
     };
     label$12 : {
      if (($6 | 0) != (255 | 0)) {
       break label$12
      }
      HEAP8[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 3588 | 0) >> 0] = 255;
      if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 8 | 0 | 0, 8 | 0) | 0)) {
       break label$1
      }
      label$13 : {
       $4 = HEAP32[($1 + 8 | 0) >> 2] | 0;
       if (($4 | 0) != (255 | 0)) {
        break label$13
       }
       $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
       HEAP32[($4 + 3520 | 0) >> 2] = 1;
       HEAP8[($4 + 3590 | 0) >> 0] = 255;
       break label$12;
      }
      if (($4 & -2 | 0 | 0) != (248 | 0)) {
       break label$12
      }
      HEAP8[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 3589 | 0) >> 0] = $4;
      HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 3;
      $3 = 1;
      break label$1;
     }
     $3 = 0;
     label$14 : {
      if ($2) {
       break label$14
      }
      $2 = 0;
      break label$3;
     }
     $2 = 0;
     $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     if (HEAP32[($4 + 3632 | 0) >> 2] | 0) {
      break label$3
     }
     $3 = 0;
     FUNCTION_TABLE[HEAP32[($4 + 32 | 0) >> 2] | 0 | 0]($0, 0, HEAP32[($4 + 48 | 0) >> 2] | 0);
     $2 = 0;
    }
    if ($3 >>> 0 < 4 >>> 0) {
     continue label$2
    }
    break label$2;
   };
   $3 = 1;
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 1;
  }
  __stack_pointer = $1 + 16 | 0;
  return $3 | 0;
 }
 
 function read_metadata_($0) {
  $0 = $0 | 0;
  var $2 = 0, $1 = 0, $5 = 0, $7 = 0, $4 = 0, $6 = 0, i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, $8 = 0, i64toi32_i32$2 = 0, $3 = 0, $10 = 0, i64toi32_i32$5 = 0, $9 = 0, $11 = 0, $14 = 0, $12 = 0, $13 = 0, i64toi32_i32$3 = 0, $67 = 0, $175 = 0, $177 = 0, $322 = 0, $337 = 0, $461 = 0, $638$hi = 0, $641$hi = 0, $642 = 0;
  $1 = __stack_pointer - 192 | 0;
  __stack_pointer = $1;
  label$1 : {
   label$2 : {
    if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 184 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_IS_LAST_LEN >> 2] | 0 | 0) | 0)) {
     break label$2
    }
    $2 = 0;
    $3 = HEAP32[($1 + 184 | 0) >> 2] | 0;
    $4 = $0 + 4 | 0;
    if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 180 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_TYPE_LEN >> 2] | 0 | 0) | 0)) {
     break label$1
    }
    if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 176 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_LENGTH_LEN >> 2] | 0 | 0) | 0)) {
     break label$1
    }
    $5 = ($3 | 0) != (0 | 0);
    label$3 : {
     label$4 : {
      label$5 : {
       label$6 : {
        label$7 : {
         $2 = HEAP32[($1 + 180 | 0) >> 2] | 0;
         switch ($2 | 0) {
         case 3:
          break label$6;
         case 0:
          break label$7;
         default:
          break label$5;
         };
        }
        $6 = HEAP32[($1 + 176 | 0) >> 2] | 0;
        $2 = 0;
        $7 = HEAP32[$4 >> 2] | 0;
        HEAP32[($7 + 256 | 0) >> 2] = 0;
        HEAP32[($7 + 264 | 0) >> 2] = $6;
        HEAP32[($7 + 260 | 0) >> 2] = $5;
        $5 = GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MIN_BLOCK_SIZE_LEN;
        $67 = HEAP32[($7 + 56 | 0) >> 2] | 0;
        $7 = HEAP32[$5 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint32($67 | 0, $1 | 0, $7 | 0) | 0)) {
         break label$1
        }
        HEAP32[((HEAP32[$4 >> 2] | 0) + 272 | 0) >> 2] = HEAP32[$1 >> 2] | 0;
        $5 = GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MAX_BLOCK_SIZE_LEN;
        $8 = HEAP32[$5 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 | 0, $8 | 0) | 0)) {
         break label$1
        }
        HEAP32[((HEAP32[$4 >> 2] | 0) + 276 | 0) >> 2] = HEAP32[$1 >> 2] | 0;
        $5 = GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MIN_FRAME_SIZE_LEN;
        $9 = HEAP32[$5 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 | 0, $9 | 0) | 0)) {
         break label$1
        }
        HEAP32[((HEAP32[$4 >> 2] | 0) + 280 | 0) >> 2] = HEAP32[$1 >> 2] | 0;
        $5 = GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MAX_FRAME_SIZE_LEN;
        $10 = HEAP32[$5 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 | 0, $10 | 0) | 0)) {
         break label$1
        }
        HEAP32[((HEAP32[$4 >> 2] | 0) + 284 | 0) >> 2] = HEAP32[$1 >> 2] | 0;
        $5 = GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_SAMPLE_RATE_LEN;
        $11 = HEAP32[$5 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 | 0, $11 | 0) | 0)) {
         break label$1
        }
        HEAP32[((HEAP32[$4 >> 2] | 0) + 288 | 0) >> 2] = HEAP32[$1 >> 2] | 0;
        $5 = GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_CHANNELS_LEN;
        $12 = HEAP32[$5 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 | 0, $12 | 0) | 0)) {
         break label$1
        }
        HEAP32[((HEAP32[$4 >> 2] | 0) + 292 | 0) >> 2] = (HEAP32[$1 >> 2] | 0) + 1 | 0;
        $5 = GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_BITS_PER_SAMPLE_LEN;
        $13 = HEAP32[$5 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 | 0, $13 | 0) | 0)) {
         break label$1
        }
        HEAP32[((HEAP32[$4 >> 2] | 0) + 296 | 0) >> 2] = (HEAP32[$1 >> 2] | 0) + 1 | 0;
        $5 = HEAP32[$4 >> 2] | 0;
        $14 = GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_TOTAL_SAMPLES_LEN;
        $175 = HEAP32[($5 + 56 | 0) >> 2] | 0;
        $177 = $5 + 304 | 0;
        $5 = HEAP32[$14 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint64($175 | 0, $177 | 0, $5 | 0) | 0)) {
         break label$1
        }
        $14 = HEAP32[$4 >> 2] | 0;
        if (!(FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[($14 + 56 | 0) >> 2] | 0 | 0, $14 + 312 | 0 | 0, 16 | 0) | 0)) {
         break label$1
        }
        if (!(FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $6 - ((((((((($7 + $8 | 0) + $9 | 0) + $10 | 0) + $11 | 0) + $12 | 0) + $13 | 0) + $5 | 0) + 128 | 0) >>> 3 | 0) | 0 | 0) | 0)) {
         break label$2
        }
        $2 = HEAP32[$4 >> 2] | 0;
        HEAP32[($2 + 248 | 0) >> 2] = 1;
        label$8 : {
         if (memcmp($2 + 312 | 0 | 0, GOT_data_internal___memory_base + 7839 | 0 | 0, 16 | 0) | 0) {
          break label$8
         }
         HEAP32[($2 + 3624 | 0) >> 2] = 0;
        }
        if (HEAP32[($2 + 3632 | 0) >> 2] | 0) {
         break label$4
        }
        if (!(HEAP32[($2 + 608 | 0) >> 2] | 0)) {
         break label$4
        }
        $5 = HEAP32[($2 + 28 | 0) >> 2] | 0;
        if (!$5) {
         break label$4
        }
        FUNCTION_TABLE[$5 | 0]($0, $2 + 256 | 0, HEAP32[($2 + 48 | 0) >> 2] | 0);
        break label$4;
       }
       $2 = HEAP32[$4 >> 2] | 0;
       HEAP32[($2 + 252 | 0) >> 2] = 0;
       $10 = HEAP32[($1 + 176 | 0) >> 2] | 0;
       HEAP32[($2 + 448 | 0) >> 2] = ($10 >>> 0) / (18 >>> 0) | 0;
       HEAP32[($2 + 440 | 0) >> 2] = $10;
       HEAP32[($2 + 436 | 0) >> 2] = $5;
       HEAP32[($2 + 432 | 0) >> 2] = 3;
       $2 = HEAP32[$4 >> 2] | 0;
       $7 = HEAP32[($2 + 452 | 0) >> 2] | 0;
       label$9 : {
        label$10 : {
         $5 = HEAP32[($2 + 448 | 0) >> 2] | 0;
         if (!$5) {
          break label$10
         }
         label$11 : {
          if ($5 >>> 0 > 178956970 >>> 0) {
           break label$11
          }
          label$12 : {
           $2 = dlrealloc($7 | 0, Math_imul($5, 24) | 0) | 0;
           if (!$2) {
            break label$12
           }
           HEAP32[((HEAP32[$4 >> 2] | 0) + 452 | 0) >> 2] = $2;
           break label$9;
          }
          dlfree($7 | 0);
          $2 = HEAP32[$4 >> 2] | 0;
         }
         HEAP32[($2 + 452 | 0) >> 2] = 0;
         break label$3;
        }
        $2 = dlrealloc($7 | 0, 0 | 0) | 0;
        HEAP32[((HEAP32[$4 >> 2] | 0) + 452 | 0) >> 2] = $2;
        if (!$2) {
         break label$3
        }
       }
       $2 = HEAP32[$4 >> 2] | 0;
       $7 = HEAP32[($2 + 448 | 0) >> 2] | 0;
       $6 = GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_FRAME_SAMPLES_LEN;
       $8 = GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_STREAM_OFFSET_LEN;
       $11 = GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_SAMPLE_NUMBER_LEN;
       $5 = 0;
       label$13 : {
        if (!$7) {
         break label$13
        }
        $9 = HEAP32[$6 >> 2] | 0;
        $8 = HEAP32[$8 >> 2] | 0;
        $6 = HEAP32[$11 >> 2] | 0;
        label$14 : while (1) {
         if (!(FLAC__bitreader_read_raw_uint64(HEAP32[($2 + 56 | 0) >> 2] | 0 | 0, $1 | 0, $6 | 0) | 0)) {
          break label$2
         }
         $2 = HEAP32[$4 >> 2] | 0;
         $7 = Math_imul($5, 24);
         i64toi32_i32$2 = $1;
         i64toi32_i32$0 = HEAP32[$1 >> 2] | 0;
         i64toi32_i32$1 = HEAP32[($1 + 4 | 0) >> 2] | 0;
         $322 = i64toi32_i32$0;
         i64toi32_i32$0 = (HEAP32[($2 + 452 | 0) >> 2] | 0) + $7 | 0;
         HEAP32[i64toi32_i32$0 >> 2] = $322;
         HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
         if (!(FLAC__bitreader_read_raw_uint64(HEAP32[($2 + 56 | 0) >> 2] | 0 | 0, $1 | 0, $8 | 0) | 0)) {
          break label$2
         }
         $2 = HEAP32[$4 >> 2] | 0;
         i64toi32_i32$2 = $1;
         i64toi32_i32$1 = HEAP32[$1 >> 2] | 0;
         i64toi32_i32$0 = HEAP32[($1 + 4 | 0) >> 2] | 0;
         $337 = i64toi32_i32$1;
         i64toi32_i32$1 = (HEAP32[($2 + 452 | 0) >> 2] | 0) + $7 | 0;
         HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] = $337;
         HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] = i64toi32_i32$0;
         if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($2 + 56 | 0) >> 2] | 0 | 0, $1 + 188 | 0 | 0, $9 | 0) | 0)) {
          break label$2
         }
         $2 = HEAP32[$4 >> 2] | 0;
         HEAP32[(((HEAP32[($2 + 452 | 0) >> 2] | 0) + $7 | 0) + 16 | 0) >> 2] = HEAP32[($1 + 188 | 0) >> 2] | 0;
         $5 = $5 + 1 | 0;
         $7 = HEAP32[($2 + 448 | 0) >> 2] | 0;
         if ($5 >>> 0 < $7 >>> 0) {
          continue label$14
         }
         break label$14;
        };
        $5 = Math_imul($7, -18);
       }
       label$15 : {
        $5 = $5 + $10 | 0;
        if (!$5) {
         break label$15
        }
        if (!(FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[($2 + 56 | 0) >> 2] | 0 | 0, $5 | 0) | 0)) {
         break label$2
        }
        $2 = HEAP32[$4 >> 2] | 0;
       }
       HEAP32[($2 + 252 | 0) >> 2] = 1;
       if (HEAP32[($2 + 3632 | 0) >> 2] | 0) {
        break label$4
       }
       if (!(HEAP32[($2 + 620 | 0) >> 2] | 0)) {
        break label$4
       }
       $5 = HEAP32[($2 + 28 | 0) >> 2] | 0;
       if (!$5) {
        break label$4
       }
       FUNCTION_TABLE[$5 | 0]($0, $2 + 432 | 0, HEAP32[($2 + 48 | 0) >> 2] | 0);
       break label$4;
      }
      $6 = HEAP32[$4 >> 2] | 0;
      $8 = HEAP32[(($6 + ($2 << 2 | 0) | 0) + 608 | 0) >> 2] | 0;
      $7 = HEAP32[($1 + 176 | 0) >> 2] | 0;
      memset($1 + 8 | 0 | 0, 0 | 0, 168 | 0) | 0;
      HEAP32[($1 + 8 | 0) >> 2] = $7;
      HEAP32[$1 >> 2] = $2;
      HEAP32[($1 + 4 | 0) >> 2] = $5;
      label$16 : {
       label$17 : {
        label$18 : {
         if (($2 | 0) != (2 | 0)) {
          break label$18
         }
         $2 = GOT_data_internal_FLAC__STREAM_METADATA_APPLICATION_ID_LEN;
         $5 = $1 + 16 | 0;
         $2 = (HEAP32[$2 >> 2] | 0) >>> 3 | 0;
         if (!(FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[($6 + 56 | 0) >> 2] | 0 | 0, $5 | 0, $2 | 0) | 0)) {
          break label$2
         }
         label$19 : {
          if ($7 >>> 0 >= $2 >>> 0) {
           break label$19
          }
          HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
          $2 = 0;
          break label$1;
         }
         $7 = $7 - $2 | 0;
         $6 = HEAP32[$4 >> 2] | 0;
         if (!(HEAP32[($6 + 1124 | 0) >> 2] | 0)) {
          break label$18
         }
         if (($8 | 0) != (0 | 0) ^ !(has_id_filtered_($0 | 0, $5 | 0) | 0) | 0) {
          break label$17
         }
         break label$16;
        }
        if ($8) {
         break label$16
        }
       }
       if (!(FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[($6 + 56 | 0) >> 2] | 0 | 0, $7 | 0) | 0)) {
        break label$2
       }
       break label$4;
      }
      label$20 : {
       label$21 : {
        label$22 : {
         label$23 : {
          switch (HEAP32[($1 + 180 | 0) >> 2] | 0 | 0) {
          case 1:
           if (FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[($6 + 56 | 0) >> 2] | 0 | 0, $7 | 0) | 0) {
            break label$21
           }
           $6 = 1;
           break label$20;
          case 2:
           if (!$7) {
            break label$22
           }
           $461 = $1 + 20 | 0;
           $2 = dlmalloc($7 | 0) | 0;
           HEAP32[$461 >> 2] = $2;
           label$29 : {
            if ($2) {
             break label$29
            }
            HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
            $6 = 1;
            break label$20;
           }
           if (FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[($6 + 56 | 0) >> 2] | 0 | 0, $2 | 0, $7 | 0) | 0) {
            break label$21
           }
           $6 = 1;
           break label$20;
          case 4:
           if (read_metadata_vorbiscomment_($0 | 0, $1 + 16 | 0 | 0, $7 | 0) | 0) {
            break label$21
           }
           $6 = 1;
           break label$20;
          case 5:
           if (read_metadata_cuesheet_($0 | 0, $1 + 16 | 0 | 0) | 0) {
            break label$21
           }
           $6 = 1;
           break label$20;
          case 6:
           if (read_metadata_picture_($0 | 0, $1 + 16 | 0 | 0) | 0) {
            break label$21
           }
           $6 = 1;
           break label$20;
          case 0:
          case 3:
           break label$21;
          default:
           break label$23;
          };
         }
         label$30 : {
          label$31 : {
           if (!$7) {
            break label$31
           }
           $2 = dlmalloc($7 | 0) | 0;
           HEAP32[($1 + 16 | 0) >> 2] = $2;
           if ($2) {
            break label$30
           }
           HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
           $6 = 1;
           break label$20;
          }
          HEAP32[($1 + 16 | 0) >> 2] = 0;
          break label$21;
         }
         if (FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[($6 + 56 | 0) >> 2] | 0 | 0, $2 | 0, $7 | 0) | 0) {
          break label$21
         }
         $6 = 1;
         break label$20;
        }
        HEAP32[($1 + 20 | 0) >> 2] = 0;
       }
       $6 = 0;
       $2 = HEAP32[$4 >> 2] | 0;
       if (HEAP32[($2 + 3632 | 0) >> 2] | 0) {
        break label$20
       }
       $5 = HEAP32[($2 + 28 | 0) >> 2] | 0;
       if (!$5) {
        break label$20
       }
       FUNCTION_TABLE[$5 | 0]($0, $1, HEAP32[($2 + 48 | 0) >> 2] | 0);
      }
      label$32 : {
       label$33 : {
        switch ((HEAP32[($1 + 180 | 0) >> 2] | 0) + -1 | 0 | 0) {
        case 1:
         $2 = HEAP32[($1 + 20 | 0) >> 2] | 0;
         if (!$2) {
          break label$32
         }
         dlfree($2 | 0);
         break label$32;
        case 3:
         label$38 : {
          $2 = HEAP32[($1 + 20 | 0) >> 2] | 0;
          if (!$2) {
           break label$38
          }
          dlfree($2 | 0);
         }
         label$39 : {
          $5 = HEAP32[($1 + 24 | 0) >> 2] | 0;
          if (!$5) {
           break label$39
          }
          $2 = 0;
          label$40 : while (1) {
           label$41 : {
            $7 = HEAP32[(((HEAP32[($1 + 28 | 0) >> 2] | 0) + ($2 << 3 | 0) | 0) + 4 | 0) >> 2] | 0;
            if (!$7) {
             break label$41
            }
            dlfree($7 | 0);
            $5 = HEAP32[($1 + 24 | 0) >> 2] | 0;
           }
           $2 = $2 + 1 | 0;
           if ($2 >>> 0 < $5 >>> 0) {
            continue label$40
           }
           break label$40;
          };
         }
         $2 = HEAP32[($1 + 28 | 0) >> 2] | 0;
         if (!$2) {
          break label$32
         }
         dlfree($2 | 0);
         break label$32;
        case 4:
         label$42 : {
          $5 = HEAP32[($1 + 164 | 0) >> 2] | 0;
          if (!$5) {
           break label$42
          }
          $2 = 0;
          label$43 : while (1) {
           label$44 : {
            $7 = HEAP32[(((HEAP32[($1 + 168 | 0) >> 2] | 0) + ($2 << 5 | 0) | 0) + 24 | 0) >> 2] | 0;
            if (!$7) {
             break label$44
            }
            dlfree($7 | 0);
            $5 = HEAP32[($1 + 164 | 0) >> 2] | 0;
           }
           $2 = $2 + 1 | 0;
           if ($2 >>> 0 < $5 >>> 0) {
            continue label$43
           }
           break label$43;
          };
         }
         $2 = HEAP32[($1 + 168 | 0) >> 2] | 0;
         if (!$2) {
          break label$32
         }
         dlfree($2 | 0);
         break label$32;
        case 5:
         label$45 : {
          $2 = HEAP32[($1 + 20 | 0) >> 2] | 0;
          if (!$2) {
           break label$45
          }
          dlfree($2 | 0);
         }
         label$46 : {
          $2 = HEAP32[($1 + 24 | 0) >> 2] | 0;
          if (!$2) {
           break label$46
          }
          dlfree($2 | 0);
         }
         $2 = HEAP32[($1 + 48 | 0) >> 2] | 0;
         if (!$2) {
          break label$32
         }
         dlfree($2 | 0);
         break label$32;
        case 0:
         break label$32;
        default:
         break label$33;
        };
       }
       $2 = HEAP32[($1 + 16 | 0) >> 2] | 0;
       if (!$2) {
        break label$32
       }
       dlfree($2 | 0);
      }
      if ($6) {
       break label$2
      }
     }
     $2 = 1;
     if (!$3) {
      break label$1
     }
     label$47 : {
      label$48 : {
       $3 = HEAP32[$4 >> 2] | 0;
       if (HEAP32[$3 >> 2] | 0) {
        break label$48
       }
       $5 = HEAP32[($3 + 12 | 0) >> 2] | 0;
       if (!$5) {
        break label$48
       }
       $7 = $3 + 6136 | 0;
       if (FUNCTION_TABLE[$5 | 0]($0, $7, HEAP32[($3 + 48 | 0) >> 2] | 0) | 0) {
        break label$48
       }
       if (!(FLAC__bitreader_is_consumed_byte_aligned(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0) | 0)) {
        break label$48
       }
       $4 = FLAC__bitreader_get_input_bits_unconsumed(HEAP32[((HEAP32[$4 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0) | 0;
       i64toi32_i32$2 = $7;
       i64toi32_i32$0 = HEAP32[$7 >> 2] | 0;
       i64toi32_i32$1 = HEAP32[($7 + 4 | 0) >> 2] | 0;
       $638$hi = i64toi32_i32$1;
       i64toi32_i32$1 = 0;
       $641$hi = i64toi32_i32$1;
       i64toi32_i32$1 = $638$hi;
       i64toi32_i32$2 = i64toi32_i32$0;
       i64toi32_i32$0 = $641$hi;
       i64toi32_i32$3 = $4 >>> 3 | 0;
       i64toi32_i32$5 = (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) + i64toi32_i32$0 | 0;
       i64toi32_i32$5 = i64toi32_i32$1 - i64toi32_i32$5 | 0;
       $642 = i64toi32_i32$2 - i64toi32_i32$3 | 0;
       i64toi32_i32$2 = $7;
       HEAP32[$7 >> 2] = $642;
       HEAP32[($7 + 4 | 0) >> 2] = i64toi32_i32$5;
       break label$47;
      }
      i64toi32_i32$2 = HEAP32[$4 >> 2] | 0;
      i64toi32_i32$5 = 0;
      HEAP32[(i64toi32_i32$2 + 6136 | 0) >> 2] = 0;
      HEAP32[(i64toi32_i32$2 + 6140 | 0) >> 2] = i64toi32_i32$5;
     }
     HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
     break label$1;
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
   }
   $2 = 0;
  }
  __stack_pointer = $1 + 192 | 0;
  return $2 | 0;
 }
 
 function frame_sync_($0) {
  $0 = $0 | 0;
  var $4 = 0, $2 = 0, $1 = 0, i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, i64toi32_i32$2 = 0, $5 = 0, $3$hi = 0, $3 = 0, $20$hi = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  label$1 : {
   label$2 : {
    label$3 : {
     $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     if (!(HEAP32[($2 + 248 | 0) >> 2] | 0)) {
      break label$3
     }
     i64toi32_i32$2 = $2 + 304 | 0;
     i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
     $3 = i64toi32_i32$0;
     $3$hi = i64toi32_i32$1;
     if (!(i64toi32_i32$0 | i64toi32_i32$1 | 0)) {
      break label$3
     }
     $4 = 4;
     i64toi32_i32$2 = $2;
     i64toi32_i32$1 = HEAP32[($2 + 240 | 0) >> 2] | 0;
     i64toi32_i32$0 = HEAP32[($2 + 244 | 0) >> 2] | 0;
     $20$hi = i64toi32_i32$0;
     i64toi32_i32$0 = $3$hi;
     i64toi32_i32$0 = $20$hi;
     i64toi32_i32$2 = i64toi32_i32$1;
     i64toi32_i32$1 = $3$hi;
     if (i64toi32_i32$0 >>> 0 > i64toi32_i32$1 >>> 0 | ((i64toi32_i32$0 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$2 >>> 0 >= $3 >>> 0 | 0) | 0) {
      break label$2
     }
    }
    label$4 : {
     if (FLAC__bitreader_is_consumed_byte_aligned(HEAP32[($2 + 56 | 0) >> 2] | 0 | 0) | 0) {
      break label$4
     }
     $2 = HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0;
     if (FLAC__bitreader_read_raw_uint32($2 | 0, $1 + 12 | 0 | 0, FLAC__bitreader_bits_left_for_byte_alignment($2 | 0) | 0 | 0) | 0) {
      break label$4
     }
     $0 = 0;
     break label$1;
    }
    $2 = 0;
    label$5 : while (1) {
     label$6 : {
      label$7 : {
       $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
       if (!(HEAP32[($4 + 3520 | 0) >> 2] | 0)) {
        break label$7
       }
       $5 = HEAPU8[($4 + 3590 | 0) >> 0] | 0;
       HEAP32[($1 + 12 | 0) >> 2] = $5;
       HEAP32[($4 + 3520 | 0) >> 2] = 0;
       break label$6;
      }
      label$8 : {
       if (FLAC__bitreader_read_raw_uint32(HEAP32[($4 + 56 | 0) >> 2] | 0 | 0, $1 + 12 | 0 | 0, 8 | 0) | 0) {
        break label$8
       }
       $0 = 0;
       break label$1;
      }
      $5 = HEAP32[($1 + 12 | 0) >> 2] | 0;
     }
     label$9 : {
      if (($5 | 0) != (255 | 0)) {
       break label$9
      }
      HEAP8[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 3588 | 0) >> 0] = 255;
      label$10 : {
       if (FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 12 | 0 | 0, 8 | 0) | 0) {
        break label$10
       }
       $0 = 0;
       break label$1;
      }
      label$11 : {
       $4 = HEAP32[($1 + 12 | 0) >> 2] | 0;
       if (($4 | 0) != (255 | 0)) {
        break label$11
       }
       $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
       HEAP32[($4 + 3520 | 0) >> 2] = 1;
       HEAP8[($4 + 3590 | 0) >> 0] = 255;
       break label$9;
      }
      if (($4 & -2 | 0 | 0) != (248 | 0)) {
       break label$9
      }
      HEAP8[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 3589 | 0) >> 0] = $4;
      $4 = 3;
      break label$2;
     }
     $4 = $2 & 1 | 0;
     $2 = 1;
     if ($4) {
      continue label$5
     }
     $2 = 1;
     $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     if (HEAP32[($4 + 3632 | 0) >> 2] | 0) {
      continue label$5
     }
     FUNCTION_TABLE[HEAP32[($4 + 32 | 0) >> 2] | 0 | 0]($0, 0, HEAP32[($4 + 48 | 0) >> 2] | 0);
     $2 = 1;
     continue label$5;
    };
   }
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = $4;
   $0 = 1;
  }
  __stack_pointer = $1 + 16 | 0;
  return $0 | 0;
 }
 
 function read_frame_($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $7 = 0, $6 = 0, $5 = 0, $3 = 0, $9 = 0, $8 = 0, $10 = 0, i64toi32_i32$2 = 0, $11 = 0, i64toi32_i32$1 = 0, $4 = 0, $19 = 0, $20 = 0, i64toi32_i32$3 = 0, $12 = 0, $21 = 0, i64toi32_i32$0 = 0, $23 = 0, $22 = 0, i64toi32_i32$5 = 0, $14 = 0, $16 = 0, $17 = 0, i64toi32_i32$4 = 0, $13 = 0, $13$hi = 0, $468$hi = 0, $470$hi = 0, $471 = 0, $484 = 0, $486$hi = 0, $488$hi = 0, $489 = 0, $505 = 0, $507$hi = 0, $509$hi = 0, $46 = 0, $510 = 0, $15 = 0, $18 = 0, $1715 = 0, $1809 = 0, $1812$hi = 0, $1814$hi = 0;
  $3 = __stack_pointer - 48 | 0;
  __stack_pointer = $3;
  $4 = 0;
  HEAP32[$1 >> 2] = 0;
  $5 = HEAP32[($0 + 4 | 0) >> 2] | 0;
  $6 = HEAPU8[($5 + 3588 | 0) >> 0] | 0;
  $7 = GOT_data_internal_FLAC__crc16_table;
  $6 = HEAPU16[($7 + ($6 << 1 | 0) | 0) >> 1] | 0;
  FLAC__bitreader_reset_read_crc16(HEAP32[($5 + 56 | 0) >> 2] | 0 | 0, (HEAPU16[($7 + ((($6 >>> 8 | 0) ^ (HEAPU8[($5 + 3589 | 0) >> 0] | 0) | 0) << 1 | 0) | 0) >> 1] | 0) ^ (($6 << 8 | 0) & 65280 | 0) | 0 | 0);
  $5 = HEAP32[($0 + 4 | 0) >> 2] | 0;
  HEAP8[($3 + 16 | 0) >> 0] = HEAPU8[($5 + 3588 | 0) >> 0] | 0;
  $7 = HEAPU8[($5 + 3589 | 0) >> 0] | 0;
  HEAP32[($3 + 12 | 0) >> 2] = 2;
  HEAP8[($3 + 17 | 0) >> 0] = $7;
  label$1 : {
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($5 + 56 | 0) >> 2] | 0 | 0, $3 + 44 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   $5 = $0 + 4 | 0;
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       $6 = HEAP32[($3 + 44 | 0) >> 2] | 0;
       if (($6 | 0) == (255 | 0)) {
        break label$5
       }
       HEAP8[($3 + 18 | 0) >> 0] = $6;
       HEAP32[($3 + 12 | 0) >> 2] = 3;
       if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + 44 | 0 | 0, 8 | 0) | 0)) {
        break label$3
       }
       $6 = HEAP32[($3 + 44 | 0) >> 2] | 0;
       if (($6 | 0) == (255 | 0)) {
        break label$5
       }
       $4 = ($7 >>> 1 | 0) & 1 | 0;
       $7 = HEAP32[($3 + 12 | 0) >> 2] | 0;
       HEAP8[(($3 + 16 | 0) + $7 | 0) >> 0] = $6;
       $8 = 1;
       HEAP32[($3 + 12 | 0) >> 2] = $7 + 1 | 0;
       label$6 : {
        label$7 : {
         label$8 : {
          label$9 : {
           label$10 : {
            label$11 : {
             $7 = HEAPU8[($3 + 18 | 0) >> 0] | 0;
             $9 = $7 >>> 4 | 0;
             switch ($9 | 0) {
             case 2:
             case 3:
             case 4:
             case 5:
              break label$10;
             case 8:
             case 9:
             case 10:
             case 11:
             case 12:
             case 13:
             case 14:
             case 15:
              break label$11;
             case 6:
             case 7:
              break label$7;
             case 1:
              break label$9;
             default:
              break label$6;
             };
            }
            HEAP32[((HEAP32[$5 >> 2] | 0) + 1136 | 0) >> 2] = 256 << ($9 + -8 | 0) | 0;
            break label$8;
           }
           HEAP32[((HEAP32[$5 >> 2] | 0) + 1136 | 0) >> 2] = 576 << ($9 + -2 | 0) | 0;
           break label$8;
          }
          HEAP32[((HEAP32[$5 >> 2] | 0) + 1136 | 0) >> 2] = 192;
         }
         $9 = 0;
        }
        $8 = $4;
       }
       $4 = $7 & 15 | 0;
       HEAP32[($3 + 44 | 0) >> 2] = $4;
       label$12 : {
        label$13 : {
         label$14 : {
          label$15 : {
           label$16 : {
            switch ($4 | 0) {
            default:
             $7 = HEAP32[$5 >> 2] | 0;
             if (HEAP32[($7 + 248 | 0) >> 2] | 0) {
              break label$15
             }
             $8 = 1;
             break label$13;
            case 1:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 88200;
             break label$14;
            case 2:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 176400;
             break label$14;
            case 3:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 192e3;
             break label$14;
            case 4:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 8e3;
             break label$14;
            case 5:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 16e3;
             break label$14;
            case 6:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 22050;
             break label$14;
            case 7:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 24e3;
             break label$14;
            case 8:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 32e3;
             break label$14;
            case 9:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 44100;
             break label$14;
            case 10:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 48e3;
             break label$14;
            case 11:
             $7 = HEAP32[$5 >> 2] | 0;
             $6 = 96e3;
             break label$14;
            case 12:
            case 13:
            case 14:
             break label$12;
            case 15:
             break label$16;
            };
           }
           label$29 : {
            $7 = HEAP32[$5 >> 2] | 0;
            if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
             break label$29
            }
            FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 1, HEAP32[($7 + 48 | 0) >> 2] | 0);
           }
           $7 = HEAP32[$0 >> 2] | 0;
           HEAP32[$7 >> 2] = 2;
           break label$4;
          }
          $6 = HEAP32[($7 + 288 | 0) >> 2] | 0;
         }
         HEAP32[($7 + 1140 | 0) >> 2] = $6;
        }
        $4 = 0;
       }
       label$30 : {
        label$31 : {
         label$32 : {
          $10 = HEAPU8[($3 + 19 | 0) >> 0] | 0;
          $11 = $10 >>> 4 | 0;
          if (!($11 & 8 | 0)) {
           break label$32
          }
          $7 = HEAP32[$5 >> 2] | 0;
          HEAP32[($7 + 1144 | 0) >> 2] = 2;
          $6 = 1;
          label$33 : {
           switch ($11 & 7 | 0 | 0) {
           case 1:
            $6 = 2;
            break label$31;
           case 0:
            break label$31;
           case 2:
            break label$33;
           default:
            break label$30;
           };
          }
          $6 = 3;
          break label$31;
         }
         $7 = HEAP32[$5 >> 2] | 0;
         HEAP32[($7 + 1144 | 0) >> 2] = $11 + 1 | 0;
         $6 = 0;
        }
        HEAP32[($7 + 1148 | 0) >> 2] = $6;
        $6 = $8;
       }
       $11 = ($10 >>> 1 | 0) & 7 | 0;
       HEAP32[($3 + 44 | 0) >> 2] = $11;
       $8 = 8;
       $12 = 1;
       label$35 : {
        label$36 : {
         label$37 : {
          switch ($11 | 0) {
          default:
           $12 = 1;
           if (!(HEAP32[($7 + 248 | 0) >> 2] | 0)) {
            break label$35
           }
           $8 = HEAP32[($7 + 296 | 0) >> 2] | 0;
           break label$36;
          case 2:
           $8 = 12;
           break label$36;
          case 4:
           $8 = 16;
           break label$36;
          case 5:
           $8 = 20;
           break label$36;
          case 3:
          case 7:
           break label$35;
          case 1:
           break label$36;
          case 6:
           break label$37;
          };
         }
         $8 = 24;
        }
        HEAP32[($7 + 1152 | 0) >> 2] = $8;
        $12 = $6;
       }
       label$42 : {
        label$43 : {
         label$44 : {
          if ((HEAPU8[($3 + 17 | 0) >> 0] | 0) & 1 | 0) {
           break label$44
          }
          if (!(HEAP32[($7 + 248 | 0) >> 2] | 0)) {
           break label$43
          }
          if ((HEAP32[($7 + 272 | 0) >> 2] | 0 | 0) == (HEAP32[($7 + 276 | 0) >> 2] | 0 | 0)) {
           break label$43
          }
         }
         if (!(FLAC__bitreader_read_utf8_uint64(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 32 | 0 | 0, $3 + 16 | 0 | 0, $3 + 12 | 0 | 0) | 0)) {
          break label$3
         }
         label$45 : {
          i64toi32_i32$2 = $3;
          i64toi32_i32$0 = HEAP32[($3 + 32 | 0) >> 2] | 0;
          i64toi32_i32$1 = HEAP32[($3 + 36 | 0) >> 2] | 0;
          $13 = i64toi32_i32$0;
          $13$hi = i64toi32_i32$1;
          i64toi32_i32$2 = i64toi32_i32$0;
          i64toi32_i32$0 = -1;
          i64toi32_i32$3 = -1;
          if ((i64toi32_i32$2 | 0) != (i64toi32_i32$3 | 0) | (i64toi32_i32$1 | 0) != (i64toi32_i32$0 | 0) | 0) {
           break label$45
          }
          $6 = HEAPU8[(((HEAP32[($3 + 12 | 0) >> 2] | 0) + ($3 + 16 | 0) | 0) + -1 | 0) >> 0] | 0;
          $7 = HEAP32[$5 >> 2] | 0;
          HEAP32[($7 + 3520 | 0) >> 2] = 1;
          HEAP8[($7 + 3590 | 0) >> 0] = $6;
          label$46 : {
           if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
            break label$46
           }
           FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 1, HEAP32[($7 + 48 | 0) >> 2] | 0);
          }
          $7 = HEAP32[$0 >> 2] | 0;
          HEAP32[$7 >> 2] = 2;
          break label$4;
         }
         $7 = HEAP32[$5 >> 2] | 0;
         i64toi32_i32$2 = $13$hi;
         i64toi32_i32$1 = $7 + 1160 | 0;
         HEAP32[i64toi32_i32$1 >> 2] = $13;
         HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$2;
         HEAP32[($7 + 1156 | 0) >> 2] = 1;
         break label$42;
        }
        if (!(FLAC__bitreader_read_utf8_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 44 | 0 | 0, $3 + 16 | 0 | 0, $3 + 12 | 0 | 0) | 0)) {
         break label$3
        }
        label$47 : {
         $7 = HEAP32[($3 + 44 | 0) >> 2] | 0;
         if (($7 | 0) != (-1 | 0)) {
          break label$47
         }
         $6 = HEAPU8[(((HEAP32[($3 + 12 | 0) >> 2] | 0) + ($3 + 16 | 0) | 0) + -1 | 0) >> 0] | 0;
         $7 = HEAP32[$5 >> 2] | 0;
         HEAP32[($7 + 3520 | 0) >> 2] = 1;
         HEAP8[($7 + 3590 | 0) >> 0] = $6;
         label$48 : {
          if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
           break label$48
          }
          FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 1, HEAP32[($7 + 48 | 0) >> 2] | 0);
         }
         $7 = HEAP32[$0 >> 2] | 0;
         HEAP32[$7 >> 2] = 2;
         break label$4;
        }
        $6 = HEAP32[$5 >> 2] | 0;
        HEAP32[($6 + 1160 | 0) >> 2] = $7;
        HEAP32[($6 + 1156 | 0) >> 2] = 0;
       }
       $7 = HEAP32[$5 >> 2] | 0;
       label$49 : {
        if (!$9) {
         break label$49
        }
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 44 | 0 | 0, 8 | 0) | 0)) {
         break label$3
        }
        $7 = HEAP32[($3 + 12 | 0) >> 2] | 0;
        $6 = HEAP32[($3 + 44 | 0) >> 2] | 0;
        HEAP8[(($3 + 16 | 0) + $7 | 0) >> 0] = $6;
        HEAP32[($3 + 12 | 0) >> 2] = $7 + 1 | 0;
        label$50 : {
         if (($9 | 0) != (7 | 0)) {
          break label$50
         }
         if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + 8 | 0 | 0, 8 | 0) | 0)) {
          break label$3
         }
         $7 = HEAP32[($3 + 12 | 0) >> 2] | 0;
         $6 = HEAP32[($3 + 8 | 0) >> 2] | 0;
         HEAP8[(($3 + 16 | 0) + $7 | 0) >> 0] = $6;
         HEAP32[($3 + 12 | 0) >> 2] = $7 + 1 | 0;
         $6 = $6 | ((HEAP32[($3 + 44 | 0) >> 2] | 0) << 8 | 0) | 0;
         HEAP32[($3 + 44 | 0) >> 2] = $6;
        }
        $7 = HEAP32[$5 >> 2] | 0;
        HEAP32[($7 + 1136 | 0) >> 2] = $6 + 1 | 0;
       }
       label$51 : {
        if (!$4) {
         break label$51
        }
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 44 | 0 | 0, 8 | 0) | 0)) {
         break label$3
        }
        $7 = HEAP32[($3 + 12 | 0) >> 2] | 0;
        $6 = HEAP32[($3 + 44 | 0) >> 2] | 0;
        HEAP8[(($3 + 16 | 0) + $7 | 0) >> 0] = $6;
        HEAP32[($3 + 12 | 0) >> 2] = $7 + 1 | 0;
        label$52 : {
         label$53 : {
          label$54 : {
           if (($4 | 0) == (12 | 0)) {
            break label$54
           }
           if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + 8 | 0 | 0, 8 | 0) | 0)) {
            break label$3
           }
           $7 = HEAP32[($3 + 12 | 0) >> 2] | 0;
           $6 = HEAP32[($3 + 8 | 0) >> 2] | 0;
           HEAP8[(($3 + 16 | 0) + $7 | 0) >> 0] = $6;
           HEAP32[($3 + 12 | 0) >> 2] = $7 + 1 | 0;
           $6 = $6 | ((HEAP32[($3 + 44 | 0) >> 2] | 0) << 8 | 0) | 0;
           HEAP32[($3 + 44 | 0) >> 2] = $6;
           switch ($4 + -12 | 0 | 0) {
           case 1:
            break label$52;
           case 0:
            break label$54;
           default:
            break label$53;
           };
          }
          $6 = Math_imul($6, 1e3);
          break label$52;
         }
         $6 = Math_imul($6, 10);
        }
        $7 = HEAP32[$5 >> 2] | 0;
        HEAP32[($7 + 1140 | 0) >> 2] = $6;
       }
       if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 44 | 0 | 0, 8 | 0) | 0)) {
        break label$3
       }
       $6 = HEAPU8[($3 + 44 | 0) >> 0] | 0;
       $4 = FLAC__crc8($3 + 16 | 0 | 0, HEAP32[($3 + 12 | 0) >> 2] | 0 | 0) | 0;
       $7 = HEAP32[$5 >> 2] | 0;
       label$55 : {
        if (($4 | 0) == ($6 | 0)) {
         break label$55
        }
        label$56 : {
         if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
          break label$56
         }
         FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 1, HEAP32[($7 + 48 | 0) >> 2] | 0);
        }
        $7 = HEAP32[$0 >> 2] | 0;
        HEAP32[$7 >> 2] = 2;
        break label$4;
       }
       HEAP32[($7 + 232 | 0) >> 2] = 0;
       label$57 : {
        label$58 : {
         label$59 : {
          if (HEAP32[($7 + 1156 | 0) >> 2] | 0) {
           break label$59
          }
          $4 = $7 + 1160 | 0;
          $6 = HEAP32[$4 >> 2] | 0;
          HEAP32[($3 + 44 | 0) >> 2] = $6;
          HEAP32[($7 + 1156 | 0) >> 2] = 1;
          label$60 : {
           $9 = HEAP32[($7 + 228 | 0) >> 2] | 0;
           if (!$9) {
            break label$60
           }
           i64toi32_i32$2 = 0;
           $468$hi = i64toi32_i32$2;
           i64toi32_i32$2 = 0;
           $470$hi = i64toi32_i32$2;
           i64toi32_i32$2 = $468$hi;
           i64toi32_i32$1 = $470$hi;
           i64toi32_i32$1 = __wasm_i64_mul($9 | 0, i64toi32_i32$2 | 0, $6 | 0, i64toi32_i32$1 | 0) | 0;
           i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
           $471 = i64toi32_i32$1;
           i64toi32_i32$1 = $4;
           HEAP32[i64toi32_i32$1 >> 2] = $471;
           HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$2;
           break label$59;
          }
          label$61 : {
           if (!(HEAP32[($7 + 248 | 0) >> 2] | 0)) {
            break label$61
           }
           $4 = HEAP32[($7 + 272 | 0) >> 2] | 0;
           if (($4 | 0) != (HEAP32[($7 + 276 | 0) >> 2] | 0 | 0)) {
            break label$58
           }
           $484 = $7 + 1160 | 0;
           i64toi32_i32$2 = 0;
           $486$hi = i64toi32_i32$2;
           i64toi32_i32$2 = 0;
           $488$hi = i64toi32_i32$2;
           i64toi32_i32$2 = $486$hi;
           i64toi32_i32$1 = $488$hi;
           i64toi32_i32$1 = __wasm_i64_mul($4 | 0, i64toi32_i32$2 | 0, $6 | 0, i64toi32_i32$1 | 0) | 0;
           i64toi32_i32$2 = i64toi32_i32$HIGH_BITS;
           $489 = i64toi32_i32$1;
           i64toi32_i32$1 = $484;
           HEAP32[i64toi32_i32$1 >> 2] = $489;
           HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$2;
           $7 = HEAP32[$5 >> 2] | 0;
           HEAP32[($7 + 232 | 0) >> 2] = HEAP32[($7 + 276 | 0) >> 2] | 0;
           break label$59;
          }
          label$62 : {
           if ($6) {
            break label$62
           }
           i64toi32_i32$1 = $7 + 1160 | 0;
           i64toi32_i32$2 = 0;
           HEAP32[i64toi32_i32$1 >> 2] = 0;
           HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$2;
           $7 = HEAP32[$5 >> 2] | 0;
           HEAP32[($7 + 232 | 0) >> 2] = HEAP32[($7 + 1136 | 0) >> 2] | 0;
           break label$59;
          }
          $505 = $7 + 1160 | 0;
          i64toi32_i32$3 = $7;
          i64toi32_i32$2 = HEAP32[($7 + 1136 | 0) >> 2] | 0;
          i64toi32_i32$1 = 0;
          $507$hi = i64toi32_i32$1;
          i64toi32_i32$1 = 0;
          $509$hi = i64toi32_i32$1;
          i64toi32_i32$1 = $507$hi;
          $46 = i64toi32_i32$2;
          i64toi32_i32$2 = $509$hi;
          i64toi32_i32$2 = __wasm_i64_mul($46 | 0, i64toi32_i32$1 | 0, $6 | 0, i64toi32_i32$2 | 0) | 0;
          i64toi32_i32$1 = i64toi32_i32$HIGH_BITS;
          $510 = i64toi32_i32$2;
          i64toi32_i32$2 = $505;
          HEAP32[i64toi32_i32$2 >> 2] = $510;
          HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] = i64toi32_i32$1;
         }
         if (!($10 & 1 | 0 | $12 | 0)) {
          break label$57
         }
         $7 = HEAP32[$5 >> 2] | 0;
        }
        label$63 : {
         label$64 : {
          if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
           break label$64
          }
          FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 3, HEAP32[($7 + 48 | 0) >> 2] | 0);
          break label$63;
         }
         HEAP32[($7 + 6152 | 0) >> 2] = (HEAP32[($7 + 6152 | 0) >> 2] | 0) + 1 | 0;
        }
        $7 = HEAP32[$0 >> 2] | 0;
        HEAP32[$7 >> 2] = 2;
        break label$4;
       }
       $7 = HEAP32[$0 >> 2] | 0;
       break label$4;
      }
      $7 = HEAP32[$5 >> 2] | 0;
      HEAP32[($7 + 3520 | 0) >> 2] = 1;
      HEAP8[($7 + 3590 | 0) >> 0] = 255;
      label$65 : {
       if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
        break label$65
       }
       FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 1, HEAP32[($7 + 48 | 0) >> 2] | 0);
      }
      $7 = HEAP32[$0 >> 2] | 0;
      HEAP32[$7 >> 2] = 2;
     }
     $4 = 1;
     if ((HEAP32[$7 >> 2] | 0 | 0) == (2 | 0)) {
      break label$1
     }
     $7 = HEAP32[$5 >> 2] | 0;
     $9 = HEAP32[($7 + 1144 | 0) >> 2] | 0;
     label$66 : {
      label$67 : {
       $10 = HEAP32[($7 + 1136 | 0) >> 2] | 0;
       if ((HEAP32[($7 + 220 | 0) >> 2] | 0) >>> 0 < $10 >>> 0) {
        break label$67
       }
       if ((HEAP32[($7 + 224 | 0) >> 2] | 0) >>> 0 >= $9 >>> 0) {
        break label$66
       }
      }
      label$68 : {
       $6 = HEAP32[($7 + 60 | 0) >> 2] | 0;
       if (!$6) {
        break label$68
       }
       dlfree($6 + -16 | 0 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 60 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$69 : {
       $6 = HEAP32[($7 + 3592 | 0) >> 2] | 0;
       if (!$6) {
        break label$69
       }
       dlfree($6 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 92 | 0) >> 2] = 0;
       HEAP32[((HEAP32[$5 >> 2] | 0) + 3592 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$70 : {
       $6 = HEAP32[($7 + 64 | 0) >> 2] | 0;
       if (!$6) {
        break label$70
       }
       dlfree($6 + -16 | 0 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 64 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$71 : {
       $6 = HEAP32[($7 + 3596 | 0) >> 2] | 0;
       if (!$6) {
        break label$71
       }
       dlfree($6 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 96 | 0) >> 2] = 0;
       HEAP32[((HEAP32[$5 >> 2] | 0) + 3596 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$72 : {
       $6 = HEAP32[($7 + 68 | 0) >> 2] | 0;
       if (!$6) {
        break label$72
       }
       dlfree($6 + -16 | 0 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 68 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$73 : {
       $6 = HEAP32[($7 + 3600 | 0) >> 2] | 0;
       if (!$6) {
        break label$73
       }
       dlfree($6 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 100 | 0) >> 2] = 0;
       HEAP32[((HEAP32[$5 >> 2] | 0) + 3600 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$74 : {
       $6 = HEAP32[($7 + 72 | 0) >> 2] | 0;
       if (!$6) {
        break label$74
       }
       dlfree($6 + -16 | 0 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 72 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$75 : {
       $6 = HEAP32[($7 + 3604 | 0) >> 2] | 0;
       if (!$6) {
        break label$75
       }
       dlfree($6 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 104 | 0) >> 2] = 0;
       HEAP32[((HEAP32[$5 >> 2] | 0) + 3604 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$76 : {
       $6 = HEAP32[($7 + 76 | 0) >> 2] | 0;
       if (!$6) {
        break label$76
       }
       dlfree($6 + -16 | 0 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 76 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$77 : {
       $6 = HEAP32[($7 + 3608 | 0) >> 2] | 0;
       if (!$6) {
        break label$77
       }
       dlfree($6 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 108 | 0) >> 2] = 0;
       HEAP32[((HEAP32[$5 >> 2] | 0) + 3608 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$78 : {
       $6 = HEAP32[($7 + 80 | 0) >> 2] | 0;
       if (!$6) {
        break label$78
       }
       dlfree($6 + -16 | 0 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 80 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$79 : {
       $6 = HEAP32[($7 + 3612 | 0) >> 2] | 0;
       if (!$6) {
        break label$79
       }
       dlfree($6 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 112 | 0) >> 2] = 0;
       HEAP32[((HEAP32[$5 >> 2] | 0) + 3612 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$80 : {
       $6 = HEAP32[($7 + 84 | 0) >> 2] | 0;
       if (!$6) {
        break label$80
       }
       dlfree($6 + -16 | 0 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 84 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$81 : {
       $6 = HEAP32[($7 + 3616 | 0) >> 2] | 0;
       if (!$6) {
        break label$81
       }
       dlfree($6 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 116 | 0) >> 2] = 0;
       HEAP32[((HEAP32[$5 >> 2] | 0) + 3616 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$82 : {
       $6 = HEAP32[($7 + 88 | 0) >> 2] | 0;
       if (!$6) {
        break label$82
       }
       dlfree($6 + -16 | 0 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 88 | 0) >> 2] = 0;
       $7 = HEAP32[$5 >> 2] | 0;
      }
      label$83 : {
       $7 = HEAP32[($7 + 3620 | 0) >> 2] | 0;
       if (!$7) {
        break label$83
       }
       dlfree($7 | 0);
       HEAP32[((HEAP32[$5 >> 2] | 0) + 120 | 0) >> 2] = 0;
       HEAP32[((HEAP32[$5 >> 2] | 0) + 3620 | 0) >> 2] = 0;
      }
      label$84 : {
       if (!$9) {
        break label$84
       }
       if ($10 >>> 0 > -5 >>> 0) {
        break label$2
       }
       $7 = $10 + 4 | 0;
       if ($7 >>> 0 > 1073741823 >>> 0) {
        break label$2
       }
       $11 = $7 << 2 | 0;
       $6 = 0;
       label$85 : while (1) {
        $7 = dlmalloc($11 | 0) | 0;
        if (!$7) {
         break label$2
        }
        i64toi32_i32$2 = $7;
        i64toi32_i32$1 = 0;
        HEAP32[$7 >> 2] = 0;
        HEAP32[($7 + 4 | 0) >> 2] = i64toi32_i32$1;
        i64toi32_i32$2 = $7 + 8 | 0;
        i64toi32_i32$1 = 0;
        HEAP32[i64toi32_i32$2 >> 2] = 0;
        HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] = i64toi32_i32$1;
        $8 = $6 << 2 | 0;
        HEAP32[(((HEAP32[$5 >> 2] | 0) + $8 | 0) + 60 | 0) >> 2] = $7 + 16 | 0;
        label$86 : {
         $7 = (HEAP32[$5 >> 2] | 0) + $8 | 0;
         if (!(FLAC__memory_alloc_aligned_int32_array($10 | 0, $7 + 3592 | 0 | 0, $7 + 92 | 0 | 0) | 0)) {
          break label$86
         }
         $6 = $6 + 1 | 0;
         if (($6 | 0) == ($9 | 0)) {
          break label$84
         }
         continue label$85;
        }
        break label$85;
       };
       HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
       break label$3;
      }
      $7 = HEAP32[$5 >> 2] | 0;
      HEAP32[($7 + 224 | 0) >> 2] = $9;
      HEAP32[($7 + 220 | 0) >> 2] = $10;
      $9 = HEAP32[($7 + 1144 | 0) >> 2] | 0;
     }
     $6 = GOT_data_internal_FLAC__SUBFRAME_LPC_QLP_COEFF_PRECISION_LEN;
     $8 = GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ORDER_LEN;
     $10 = GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_TYPE_LEN;
     $11 = GOT_data_internal_FLAC__SUBFRAME_LPC_QLP_SHIFT_LEN;
     label$87 : {
      label$88 : {
       if (!$9) {
        break label$88
       }
       $14 = HEAP32[$6 >> 2] | 0;
       $15 = (-1 << $14 | 0) ^ -1 | 0;
       $16 = HEAP32[$8 >> 2] | 0;
       $17 = HEAP32[$10 >> 2] | 0;
       $18 = HEAP32[$11 >> 2] | 0;
       $8 = 0;
       label$89 : while (1) {
        $6 = HEAP32[($7 + 1152 | 0) >> 2] | 0;
        label$90 : {
         label$91 : {
          switch ((HEAP32[($7 + 1148 | 0) >> 2] | 0) + -1 | 0 | 0) {
          case 0:
           $6 = $6 + (($8 | 0) == (1 | 0)) | 0;
           break label$90;
          case 1:
           $6 = $6 + !$8 | 0;
           break label$90;
          case 2:
           break label$91;
          default:
           break label$90;
          };
         }
         $6 = $6 + (($8 | 0) == (1 | 0)) | 0;
        }
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 44 | 0 | 0, 8 | 0) | 0)) {
         break label$3
        }
        $7 = HEAP32[($3 + 44 | 0) >> 2] | 0;
        HEAP32[($3 + 44 | 0) >> 2] = $7 & 254 | 0;
        label$94 : {
         label$95 : {
          $12 = $7 & 1 | 0;
          if (!$12) {
           break label$95
          }
          if (!(FLAC__bitreader_read_unary_unsigned(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0) | 0)) {
           break label$3
          }
          $7 = HEAP32[$5 >> 2] | 0;
          $9 = (HEAP32[($3 + 16 | 0) >> 2] | 0) + 1 | 0;
          HEAP32[(($7 + Math_imul($8, 292) | 0) + 1464 | 0) >> 2] = $9;
          if ($6 >>> 0 <= $9 >>> 0) {
           break label$3
          }
          $6 = $6 - $9 | 0;
          break label$94;
         }
         $7 = HEAP32[$5 >> 2] | 0;
         HEAP32[(($7 + Math_imul($8, 292) | 0) + 1464 | 0) >> 2] = 0;
        }
        label$96 : {
         label$97 : {
          label$98 : {
           $9 = HEAP32[($3 + 44 | 0) >> 2] | 0;
           if (!($9 & 128 | 0)) {
            break label$98
           }
           if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
            break label$97
           }
           FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 0, HEAP32[($7 + 48 | 0) >> 2] | 0);
           break label$97;
          }
          label$99 : {
           label$100 : {
            label$101 : {
             switch ($9 | 0) {
             case 0:
              $9 = HEAP32[(($7 + ($8 << 2 | 0) | 0) + 60 | 0) >> 2] | 0;
              $10 = $7 + Math_imul($8, 292) | 0;
              HEAP32[($10 + 1176 | 0) >> 2] = 0;
              if (!(FLAC__bitreader_read_raw_int32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, $6 | 0) | 0)) {
               break label$3
              }
              HEAP32[($10 + 1180 | 0) >> 2] = HEAP32[($3 + 16 | 0) >> 2] | 0;
              if (!$2) {
               break label$100
              }
              $7 = 0;
              $6 = HEAP32[$5 >> 2] | 0;
              if (!(HEAP32[($6 + 1136 | 0) >> 2] | 0)) {
               break label$100
              }
              label$104 : while (1) {
               HEAP32[($9 + ($7 << 2 | 0) | 0) >> 2] = HEAP32[($3 + 16 | 0) >> 2] | 0;
               $7 = $7 + 1 | 0;
               if ($7 >>> 0 < (HEAP32[($6 + 1136 | 0) >> 2] | 0) >>> 0) {
                continue label$104
               }
               break label$100;
              };
             case 2:
              $9 = ($7 + 1136 | 0) + Math_imul($8, 292) | 0;
              $19 = $9 + 44 | 0;
              $20 = $8 << 2 | 0;
              $10 = HEAP32[(($7 + $20 | 0) + 92 | 0) >> 2] | 0;
              HEAP32[$19 >> 2] = $10;
              HEAP32[($9 + 40 | 0) >> 2] = 1;
              $9 = 0;
              label$105 : {
               if (!(HEAP32[($7 + 1136 | 0) >> 2] | 0)) {
                break label$105
               }
               label$106 : while (1) {
                if (!(FLAC__bitreader_read_raw_int32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, $6 | 0) | 0)) {
                 break label$3
                }
                HEAP32[($10 + ($9 << 2 | 0) | 0) >> 2] = HEAP32[($3 + 16 | 0) >> 2] | 0;
                $9 = $9 + 1 | 0;
                $7 = HEAP32[$5 >> 2] | 0;
                $11 = HEAP32[($7 + 1136 | 0) >> 2] | 0;
                if ($9 >>> 0 < $11 >>> 0) {
                 continue label$106
                }
                break label$106;
               };
               $9 = $11 << 2 | 0;
              }
              if (!$2) {
               break label$100
              }
              __memcpy(HEAP32[(($7 + $20 | 0) + 60 | 0) >> 2] | 0 | 0, HEAP32[$19 >> 2] | 0 | 0, $9 | 0) | 0;
              break label$100;
             default:
              break label$101;
             };
            }
            label$107 : {
             if ($9 >>> 0 > 15 >>> 0) {
              break label$107
             }
             if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
              break label$99
             }
             FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 3, HEAP32[($7 + 48 | 0) >> 2] | 0);
             break label$97;
            }
            label$108 : {
             if ($9 >>> 0 > 24 >>> 0) {
              break label$108
             }
             $19 = $7 + Math_imul($8, 292) | 0;
             HEAP32[($19 + 1176 | 0) >> 2] = 2;
             $20 = $8 << 2 | 0;
             $11 = HEAP32[(($7 + $20 | 0) + 92 | 0) >> 2] | 0;
             $10 = ($9 >>> 1 | 0) & 7 | 0;
             HEAP32[($19 + 1192 | 0) >> 2] = $10;
             HEAP32[($19 + 1212 | 0) >> 2] = $11;
             $11 = $19 + 1196 | 0;
             $9 = 0;
             label$109 : {
              if (!$10) {
               break label$109
              }
              label$110 : while (1) {
               if (!(FLAC__bitreader_read_raw_int32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, $6 | 0) | 0)) {
                break label$3
               }
               HEAP32[($11 + ($9 << 2 | 0) | 0) >> 2] = HEAP32[($3 + 16 | 0) >> 2] | 0;
               $7 = HEAP32[$5 >> 2] | 0;
               $9 = $9 + 1 | 0;
               if (($9 | 0) != ($10 | 0)) {
                continue label$110
               }
               break label$110;
              };
             }
             if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 32 | 0 | 0, $17 | 0) | 0)) {
              break label$3
             }
             $9 = $19 + 1180 | 0;
             $6 = HEAP32[($3 + 32 | 0) >> 2] | 0;
             HEAP32[$9 >> 2] = $6;
             $7 = HEAP32[$5 >> 2] | 0;
             label$111 : {
              label$112 : {
               label$113 : {
                if ($6 >>> 0 > 1 >>> 0) {
                 break label$113
                }
                if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 32 | 0 | 0, $16 | 0) | 0)) {
                 break label$3
                }
                $7 = HEAP32[$5 >> 2] | 0;
                $6 = HEAP32[($3 + 32 | 0) >> 2] | 0;
                if (((HEAP32[($7 + 1136 | 0) >> 2] | 0) >>> $6 | 0) >>> 0 >= $10 >>> 0) {
                 break label$112
                }
                label$114 : {
                 if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
                  break label$114
                 }
                 FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 0, HEAP32[($7 + 48 | 0) >> 2] | 0);
                }
                HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
                break label$111;
               }
               label$115 : {
                label$116 : {
                 if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
                  break label$116
                 }
                 FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 3, HEAP32[($7 + 48 | 0) >> 2] | 0);
                 break label$115;
                }
                HEAP32[($7 + 6152 | 0) >> 2] = (HEAP32[($7 + 6152 | 0) >> 2] | 0) + 1 | 0;
               }
               HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
               break label$111;
              }
              HEAP32[($19 + 1184 | 0) >> 2] = $6;
              $7 = Math_imul($8, 12);
              HEAP32[($19 + 1188 | 0) >> 2] = ((HEAP32[$5 >> 2] | 0) + $7 | 0) + 124 | 0;
              label$117 : {
               $9 = HEAP32[$9 >> 2] | 0;
               if ($9 >>> 0 >= 2 >>> 0) {
                break label$117
               }
               $19 = HEAP32[($0 + 4 | 0) >> 2] | 0;
               if (!(read_residual_partitioned_rice_($0 | 0, $10 | 0, $6 | 0, ($19 + $7 | 0) + 124 | 0 | 0, HEAP32[(($19 + $20 | 0) + 92 | 0) >> 2] | 0 | 0, ($9 | 0) == (1 | 0) | 0) | 0)) {
                break label$3
               }
              }
              if (!$2) {
               break label$111
              }
              $7 = $10 << 2 | 0;
              __memcpy(HEAP32[(((HEAP32[$5 >> 2] | 0) + $20 | 0) + 60 | 0) >> 2] | 0 | 0, $11 | 0, $7 | 0) | 0;
              $6 = HEAP32[$5 >> 2] | 0;
              $9 = $6 + $20 | 0;
              FLAC__fixed_restore_signal(HEAP32[($9 + 92 | 0) >> 2] | 0 | 0, (HEAP32[($6 + 1136 | 0) >> 2] | 0) - $10 | 0 | 0, $10 | 0, (HEAP32[($9 + 60 | 0) >> 2] | 0) + $7 | 0 | 0);
             }
             if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) != (2 | 0)) {
              break label$100
             }
             break label$96;
            }
            label$118 : {
             if ($9 >>> 0 > 63 >>> 0) {
              break label$118
             }
             label$119 : {
              if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
               break label$119
              }
              FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 3, HEAP32[($7 + 48 | 0) >> 2] | 0);
              break label$97;
             }
             HEAP32[($7 + 6152 | 0) >> 2] = (HEAP32[($7 + 6152 | 0) >> 2] | 0) + 1 | 0;
             break label$97;
            }
            $11 = $7 + Math_imul($8, 292) | 0;
            HEAP32[($11 + 1176 | 0) >> 2] = 3;
            $21 = $8 << 2 | 0;
            $10 = HEAP32[(($7 + $21 | 0) + 92 | 0) >> 2] | 0;
            $19 = ($9 >>> 1 | 0) & 31 | 0;
            $20 = $19 + 1 | 0;
            HEAP32[($11 + 1192 | 0) >> 2] = $20;
            HEAP32[($11 + 1460 | 0) >> 2] = $10;
            $9 = 0;
            label$120 : while (1) {
             if (!(FLAC__bitreader_read_raw_int32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, $6 | 0) | 0)) {
              break label$3
             }
             HEAP32[(($11 + ($9 << 2 | 0) | 0) + 1332 | 0) >> 2] = HEAP32[($3 + 16 | 0) >> 2] | 0;
             $10 = ($9 | 0) != ($19 | 0);
             $7 = HEAP32[$5 >> 2] | 0;
             $9 = $9 + 1 | 0;
             if ($10) {
              continue label$120
             }
             break label$120;
            };
            if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 32 | 0 | 0, $14 | 0) | 0)) {
             break label$3
            }
            label$121 : {
             label$122 : {
              $7 = HEAP32[($3 + 32 | 0) >> 2] | 0;
              if (($7 | 0) != ($15 | 0)) {
               break label$122
              }
              label$123 : {
               $7 = HEAP32[$5 >> 2] | 0;
               if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
                break label$123
               }
               FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 0, HEAP32[($7 + 48 | 0) >> 2] | 0);
              }
              HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
              break label$121;
             }
             $10 = $11 + 1196 | 0;
             HEAP32[$10 >> 2] = $7 + 1 | 0;
             if (!(FLAC__bitreader_read_raw_int32(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, $18 | 0) | 0)) {
              break label$3
             }
             label$124 : {
              $7 = HEAP32[($3 + 16 | 0) >> 2] | 0;
              if (($7 | 0) > (-1 | 0)) {
               break label$124
              }
              label$125 : {
               $7 = HEAP32[$5 >> 2] | 0;
               if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
                break label$125
               }
               FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 0, HEAP32[($7 + 48 | 0) >> 2] | 0);
              }
              HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
              break label$121;
             }
             $22 = $11 + 1200 | 0;
             HEAP32[$22 >> 2] = $7;
             $7 = 0;
             label$126 : while (1) {
              if (!(FLAC__bitreader_read_raw_int32(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, HEAP32[$10 >> 2] | 0 | 0) | 0)) {
               break label$3
              }
              HEAP32[(($11 + ($7 << 2 | 0) | 0) + 1204 | 0) >> 2] = HEAP32[($3 + 16 | 0) >> 2] | 0;
              $9 = ($7 | 0) != ($19 | 0);
              $7 = $7 + 1 | 0;
              if ($9) {
               continue label$126
              }
              break label$126;
             };
             if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + 32 | 0 | 0, $17 | 0) | 0)) {
              break label$3
             }
             $23 = $11 + 1180 | 0;
             $9 = HEAP32[($3 + 32 | 0) >> 2] | 0;
             HEAP32[$23 >> 2] = $9;
             $7 = HEAP32[$5 >> 2] | 0;
             label$127 : {
              label$128 : {
               if ($9 >>> 0 > 1 >>> 0) {
                break label$128
               }
               if (!(FLAC__bitreader_read_raw_uint32(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0, $3 + 32 | 0 | 0, $16 | 0) | 0)) {
                break label$3
               }
               $7 = HEAP32[$5 >> 2] | 0;
               $9 = HEAP32[($3 + 32 | 0) >> 2] | 0;
               if (((HEAP32[($7 + 1136 | 0) >> 2] | 0) >>> $9 | 0) >>> 0 > $19 >>> 0) {
                break label$127
               }
               label$129 : {
                if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
                 break label$129
                }
                FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 0, HEAP32[($7 + 48 | 0) >> 2] | 0);
               }
               HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
               break label$121;
              }
              label$130 : {
               label$131 : {
                if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
                 break label$131
                }
                FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 3, HEAP32[($7 + 48 | 0) >> 2] | 0);
                break label$130;
               }
               HEAP32[($7 + 6152 | 0) >> 2] = (HEAP32[($7 + 6152 | 0) >> 2] | 0) + 1 | 0;
              }
              HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
              break label$121;
             }
             HEAP32[($11 + 1184 | 0) >> 2] = $9;
             $7 = Math_imul($8, 12);
             HEAP32[($11 + 1188 | 0) >> 2] = ((HEAP32[$5 >> 2] | 0) + $7 | 0) + 124 | 0;
             label$132 : {
              $19 = HEAP32[$23 >> 2] | 0;
              if ($19 >>> 0 >= 2 >>> 0) {
               break label$132
              }
              $23 = HEAP32[($0 + 4 | 0) >> 2] | 0;
              if (!(read_residual_partitioned_rice_($0 | 0, $20 | 0, $9 | 0, ($23 + $7 | 0) + 124 | 0 | 0, HEAP32[(($23 + $21 | 0) + 92 | 0) >> 2] | 0 | 0, ($19 | 0) == (1 | 0) | 0) | 0)) {
               break label$3
              }
             }
             if (!$2) {
              break label$121
             }
             $7 = $20 << 2 | 0;
             __memcpy(HEAP32[(((HEAP32[$5 >> 2] | 0) + $21 | 0) + 60 | 0) >> 2] | 0 | 0, $11 + 1332 | 0 | 0, $7 | 0) | 0;
             label$133 : {
              label$134 : {
               $10 = HEAP32[$10 >> 2] | 0;
               if ((((Math_clz32($20) ^ 31 | 0) + $6 | 0) + $10 | 0) >>> 0 > 32 >>> 0) {
                break label$134
               }
               $9 = HEAP32[$5 >> 2] | 0;
               if ($6 >>> 0 > 16 >>> 0) {
                break label$133
               }
               if ($10 >>> 0 > 16 >>> 0) {
                break label$133
               }
               $6 = $9 + $21 | 0;
               FUNCTION_TABLE[HEAP32[($9 + 44 | 0) >> 2] | 0 | 0](HEAP32[($6 + 92 | 0) >> 2] | 0, (HEAP32[($9 + 1136 | 0) >> 2] | 0) - $20 | 0, $11 + 1204 | 0, $20, HEAP32[$22 >> 2] | 0, (HEAP32[($6 + 60 | 0) >> 2] | 0) + $7 | 0);
               break label$121;
              }
              $6 = HEAP32[$5 >> 2] | 0;
              $9 = $6 + $21 | 0;
              FUNCTION_TABLE[HEAP32[($6 + 40 | 0) >> 2] | 0 | 0](HEAP32[($9 + 92 | 0) >> 2] | 0, (HEAP32[($6 + 1136 | 0) >> 2] | 0) - $20 | 0, $11 + 1204 | 0, $20, HEAP32[$22 >> 2] | 0, (HEAP32[($9 + 60 | 0) >> 2] | 0) + $7 | 0);
              break label$121;
             }
             $6 = $9 + $21 | 0;
             FUNCTION_TABLE[HEAP32[($9 + 36 | 0) >> 2] | 0 | 0](HEAP32[($6 + 92 | 0) >> 2] | 0, (HEAP32[($9 + 1136 | 0) >> 2] | 0) - $20 | 0, $11 + 1204 | 0, $20, HEAP32[$22 >> 2] | 0, (HEAP32[($6 + 60 | 0) >> 2] | 0) + $7 | 0);
            }
            if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) == (2 | 0)) {
             break label$96
            }
           }
           if (!$12) {
            break label$96
           }
           if (!$2) {
            break label$96
           }
           $9 = HEAP32[$5 >> 2] | 0;
           $7 = HEAP32[((($9 + 1136 | 0) + Math_imul($8, 292) | 0) + 328 | 0) >> 2] | 0;
           HEAP32[($3 + 44 | 0) >> 2] = $7;
           if (!(HEAP32[($9 + 1136 | 0) >> 2] | 0)) {
            break label$96
           }
           $10 = HEAP32[(($9 + ($8 << 2 | 0) | 0) + 60 | 0) >> 2] | 0;
           HEAP32[$10 >> 2] = (HEAP32[$10 >> 2] | 0) << $7 | 0;
           $7 = 1;
           if ((HEAP32[($9 + 1136 | 0) >> 2] | 0) >>> 0 < 2 >>> 0) {
            break label$96
           }
           label$135 : while (1) {
            $6 = $10 + ($7 << 2 | 0) | 0;
            HEAP32[$6 >> 2] = (HEAP32[$6 >> 2] | 0) << (HEAP32[($3 + 44 | 0) >> 2] | 0) | 0;
            $7 = $7 + 1 | 0;
            if ($7 >>> 0 < (HEAP32[($9 + 1136 | 0) >> 2] | 0) >>> 0) {
             continue label$135
            }
            break label$96;
           };
          }
          HEAP32[($7 + 6152 | 0) >> 2] = (HEAP32[($7 + 6152 | 0) >> 2] | 0) + 1 | 0;
         }
         HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
        }
        if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) == (2 | 0)) {
         break label$87
        }
        $8 = $8 + 1 | 0;
        $7 = HEAP32[$5 >> 2] | 0;
        if ($8 >>> 0 < (HEAP32[($7 + 1144 | 0) >> 2] | 0) >>> 0) {
         continue label$89
        }
        break label$89;
       };
      }
      label$136 : {
       if (FLAC__bitreader_is_consumed_byte_aligned(HEAP32[($7 + 56 | 0) >> 2] | 0 | 0) | 0) {
        break label$136
       }
       HEAP32[($3 + 16 | 0) >> 2] = 0;
       $7 = HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0;
       if (!(FLAC__bitreader_read_raw_uint32($7 | 0, $3 + 16 | 0 | 0, FLAC__bitreader_bits_left_for_byte_alignment($7 | 0) | 0 | 0) | 0)) {
        break label$3
       }
       if (!(HEAP32[($3 + 16 | 0) >> 2] | 0)) {
        break label$136
       }
       label$137 : {
        $7 = HEAP32[$5 >> 2] | 0;
        if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
         break label$137
        }
        FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 0, HEAP32[($7 + 48 | 0) >> 2] | 0);
       }
       HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
      }
      if ((HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) == (2 | 0)) {
       break label$1
      }
      $7 = FLAC__bitreader_get_read_crc16(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0) | 0;
      $4 = 0;
      if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[$5 >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + 16 | 0 | 0, HEAP32[GOT_data_internal_FLAC__FRAME_FOOTER_CRC_LEN >> 2] | 0 | 0) | 0)) {
       break label$1
      }
      label$138 : {
       label$139 : {
        if ((HEAP32[($3 + 16 | 0) >> 2] | 0 | 0) != ($7 | 0)) {
         break label$139
        }
        if (!$2) {
         break label$138
        }
        label$140 : {
         label$141 : {
          label$142 : {
           $7 = HEAP32[$5 >> 2] | 0;
           switch ((HEAP32[($7 + 1148 | 0) >> 2] | 0) + -1 | 0 | 0) {
           case 2:
            break label$140;
           case 0:
            break label$141;
           case 1:
            break label$142;
           default:
            break label$138;
           };
          }
          if (!(HEAP32[($7 + 1136 | 0) >> 2] | 0)) {
           break label$138
          }
          $10 = HEAP32[($7 + 64 | 0) >> 2] | 0;
          $11 = HEAP32[($7 + 60 | 0) >> 2] | 0;
          $6 = 0;
          label$143 : while (1) {
           $9 = $6 << 2 | 0;
           $8 = $11 + $9 | 0;
           HEAP32[$8 >> 2] = (HEAP32[$8 >> 2] | 0) + (HEAP32[($10 + $9 | 0) >> 2] | 0) | 0;
           $6 = $6 + 1 | 0;
           if ($6 >>> 0 < (HEAP32[($7 + 1136 | 0) >> 2] | 0) >>> 0) {
            continue label$143
           }
           break label$138;
          };
         }
         if (!(HEAP32[($7 + 1136 | 0) >> 2] | 0)) {
          break label$138
         }
         $10 = HEAP32[($7 + 64 | 0) >> 2] | 0;
         $11 = HEAP32[($7 + 60 | 0) >> 2] | 0;
         $6 = 0;
         label$144 : while (1) {
          $9 = $6 << 2 | 0;
          $8 = $10 + $9 | 0;
          HEAP32[$8 >> 2] = (HEAP32[($11 + $9 | 0) >> 2] | 0) - (HEAP32[$8 >> 2] | 0) | 0;
          $6 = $6 + 1 | 0;
          if ($6 >>> 0 < (HEAP32[($7 + 1136 | 0) >> 2] | 0) >>> 0) {
           continue label$144
          }
          break label$138;
         };
        }
        if (!(HEAP32[($7 + 1136 | 0) >> 2] | 0)) {
         break label$138
        }
        $11 = HEAP32[($7 + 64 | 0) >> 2] | 0;
        $12 = HEAP32[($7 + 60 | 0) >> 2] | 0;
        $6 = 0;
        label$145 : while (1) {
         $9 = $6 << 2 | 0;
         $8 = $12 + $9 | 0;
         $1715 = $8;
         $10 = $11 + $9 | 0;
         $9 = HEAP32[$10 >> 2] | 0;
         $8 = $9 & 1 | 0 | ((HEAP32[$8 >> 2] | 0) << 1 | 0) | 0;
         HEAP32[$1715 >> 2] = ($8 + $9 | 0) >> 1 | 0;
         HEAP32[$10 >> 2] = ($8 - $9 | 0) >> 1 | 0;
         $6 = $6 + 1 | 0;
         if ($6 >>> 0 < (HEAP32[($7 + 1136 | 0) >> 2] | 0) >>> 0) {
          continue label$145
         }
         break label$138;
        };
       }
       label$146 : {
        $7 = HEAP32[$5 >> 2] | 0;
        if (HEAP32[($7 + 3632 | 0) >> 2] | 0) {
         break label$146
        }
        FUNCTION_TABLE[HEAP32[($7 + 32 | 0) >> 2] | 0 | 0]($0, 2, HEAP32[($7 + 48 | 0) >> 2] | 0);
       }
       if (!$2) {
        break label$138
       }
       $7 = HEAP32[$5 >> 2] | 0;
       if (!(HEAP32[($7 + 1144 | 0) >> 2] | 0)) {
        break label$138
       }
       $6 = 0;
       label$147 : while (1) {
        memset(HEAP32[(($7 + ($6 << 2 | 0) | 0) + 60 | 0) >> 2] | 0 | 0, 0 | 0, (HEAP32[($7 + 1136 | 0) >> 2] | 0) << 2 | 0 | 0) | 0;
        $6 = $6 + 1 | 0;
        $7 = HEAP32[$5 >> 2] | 0;
        if ($6 >>> 0 < (HEAP32[($7 + 1144 | 0) >> 2] | 0) >>> 0) {
         continue label$147
        }
        break label$147;
       };
      }
      HEAP32[$1 >> 2] = 1;
      label$148 : {
       $5 = HEAP32[$5 >> 2] | 0;
       $7 = HEAP32[($5 + 232 | 0) >> 2] | 0;
       if (!$7) {
        break label$148
       }
       HEAP32[($5 + 228 | 0) >> 2] = $7;
      }
      $7 = HEAP32[$0 >> 2] | 0;
      HEAP32[($7 + 8 | 0) >> 2] = HEAP32[($5 + 1144 | 0) >> 2] | 0;
      HEAP32[($7 + 12 | 0) >> 2] = HEAP32[($5 + 1148 | 0) >> 2] | 0;
      HEAP32[($7 + 16 | 0) >> 2] = HEAP32[($5 + 1152 | 0) >> 2] | 0;
      HEAP32[($7 + 20 | 0) >> 2] = HEAP32[($5 + 1140 | 0) >> 2] | 0;
      $6 = HEAP32[($5 + 1136 | 0) >> 2] | 0;
      HEAP32[($7 + 24 | 0) >> 2] = $6;
      $1809 = $5;
      i64toi32_i32$3 = $5 + 1160 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$3 >> 2] | 0;
      i64toi32_i32$2 = HEAP32[(i64toi32_i32$3 + 4 | 0) >> 2] | 0;
      $1812$hi = i64toi32_i32$2;
      i64toi32_i32$2 = 0;
      $1814$hi = i64toi32_i32$2;
      i64toi32_i32$2 = $1812$hi;
      i64toi32_i32$3 = i64toi32_i32$1;
      i64toi32_i32$1 = $1814$hi;
      i64toi32_i32$0 = $6;
      i64toi32_i32$4 = i64toi32_i32$3 + $6 | 0;
      i64toi32_i32$5 = i64toi32_i32$2 + i64toi32_i32$1 | 0;
      if (i64toi32_i32$4 >>> 0 < $6 >>> 0) {
       i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
      }
      i64toi32_i32$3 = $1809;
      HEAP32[(i64toi32_i32$3 + 240 | 0) >> 2] = i64toi32_i32$4;
      HEAP32[(i64toi32_i32$3 + 244 | 0) >> 2] = i64toi32_i32$5;
      label$149 : {
       if (!$2) {
        break label$149
       }
       $5 = write_audio_frame_to_client_($0 | 0, $5 + 1136 | 0 | 0, $5 + 60 | 0 | 0) | 0;
       $7 = HEAP32[$0 >> 2] | 0;
       if (!$5) {
        break label$149
       }
       HEAP32[$7 >> 2] = 7;
       break label$1;
      }
      HEAP32[$7 >> 2] = 2;
     }
     $4 = 1;
     break label$1;
    }
    $4 = 0;
    break label$1;
   }
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
   $4 = 0;
  }
  __stack_pointer = $3 + 48 | 0;
  return $4 | 0;
 }
 
 function has_id_filtered_($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0;
  $2 = GOT_data_internal_FLAC__STREAM_METADATA_APPLICATION_ID_LEN;
  label$1 : {
   $0 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   $3 = HEAP32[($0 + 1124 | 0) >> 2] | 0;
   if ($3) {
    break label$1
   }
   return 0 | 0;
  }
  $2 = (HEAP32[$2 >> 2] | 0) >>> 3 | 0;
  $4 = HEAP32[($0 + 1120 | 0) >> 2] | 0;
  $0 = 0;
  label$2 : {
   label$3 : while (1) {
    if (!(memcmp($4 + Math_imul($2, $0) | 0 | 0, $1 | 0, $2 | 0) | 0)) {
     break label$2
    }
    $0 = $0 + 1 | 0;
    if (($0 | 0) != ($3 | 0)) {
     continue label$3
    }
    break label$3;
   };
   return 0 | 0;
  }
  return 1 | 0;
 }
 
 function read_metadata_vorbiscomment_($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $5 = 0, $3 = 0, $4 = 0, $6 = 0, $8 = 0, i64toi32_i32$0 = 0, $7 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      if ($2 >>> 0 < 8 >>> 0) {
       break label$4
      }
      $3 = 0;
      if (!(FLAC__bitreader_read_uint32_little_endian(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 | 0) | 0)) {
       break label$3
      }
      $2 = $2 + -8 | 0;
      label$5 : {
       label$6 : {
        $4 = HEAP32[$1 >> 2] | 0;
        if (!$4) {
         break label$6
        }
        label$7 : {
         if ($2 >>> 0 >= $4 >>> 0) {
          break label$7
         }
         i64toi32_i32$0 = 0;
         HEAP32[$1 >> 2] = 0;
         HEAP32[($1 + 4 | 0) >> 2] = i64toi32_i32$0;
         break label$4;
        }
        label$8 : {
         label$9 : {
          label$10 : {
           if (($4 | 0) != (-1 | 0)) {
            break label$10
           }
           HEAP32[($1 + 4 | 0) >> 2] = 0;
           break label$9;
          }
          $5 = dlmalloc($4 + 1 | 0 | 0) | 0;
          HEAP32[($1 + 4 | 0) >> 2] = $5;
          if ($5) {
           break label$8
          }
         }
         HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
         return 0 | 0;
        }
        if (!(FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $5 | 0, $4 | 0) | 0)) {
         break label$3
        }
        $2 = $2 - $4 | 0;
        HEAP8[((HEAP32[($1 + 4 | 0) >> 2] | 0) + (HEAP32[$1 >> 2] | 0) | 0) >> 0] = 0;
        break label$5;
       }
       HEAP32[($1 + 4 | 0) >> 2] = 0;
      }
      $4 = $1 + 8 | 0;
      if (!(FLAC__bitreader_read_uint32_little_endian(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $4 | 0) | 0)) {
       break label$3
      }
      label$11 : {
       $3 = HEAP32[$4 >> 2] | 0;
       if ($3 >>> 0 < 100001 >>> 0) {
        break label$11
       }
       HEAP32[$4 >> 2] = 0;
       return 0 | 0;
      }
      if (!$3) {
       break label$4
      }
      $5 = safe_malloc_mul_2op_p($3 | 0, 8 | 0) | 0;
      HEAP32[($1 + 12 | 0) >> 2] = $5;
      if (!$5) {
       break label$2
      }
      if (!(HEAP32[$4 >> 2] | 0)) {
       break label$4
      }
      i64toi32_i32$0 = 0;
      HEAP32[$5 >> 2] = 0;
      HEAP32[($5 + 4 | 0) >> 2] = i64toi32_i32$0;
      $3 = 0;
      label$12 : {
       if ($2 >>> 0 < 4 >>> 0) {
        break label$12
       }
       label$13 : while (1) {
        if (!(FLAC__bitreader_read_uint32_little_endian(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $5 | 0) | 0)) {
         break label$1
        }
        $2 = $2 + -4 | 0;
        label$14 : {
         label$15 : {
          $6 = HEAP32[($1 + 12 | 0) >> 2] | 0;
          $7 = $3 << 3 | 0;
          $8 = $6 + $7 | 0;
          $5 = HEAP32[$8 >> 2] | 0;
          if (!$5) {
           break label$15
          }
          if ($2 >>> 0 < $5 >>> 0) {
           break label$12
          }
          label$16 : {
           label$17 : {
            label$18 : {
             if (($5 | 0) != (-1 | 0)) {
              break label$18
             }
             HEAP32[(($6 + ($3 << 3 | 0) | 0) + 4 | 0) >> 2] = 0;
             break label$17;
            }
            $6 = dlmalloc($5 + 1 | 0 | 0) | 0;
            HEAP32[($8 + 4 | 0) >> 2] = $6;
            if ($6) {
             break label$16
            }
           }
           HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
           break label$1;
          }
          $2 = $2 - $5 | 0;
          memset($6 | 0, 0 | 0, $5 | 0) | 0;
          $5 = FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, HEAP32[($8 + 4 | 0) >> 2] | 0 | 0, HEAP32[$8 >> 2] | 0 | 0) | 0;
          $6 = (HEAP32[($1 + 12 | 0) >> 2] | 0) + $7 | 0;
          $8 = HEAP32[($6 + 4 | 0) >> 2] | 0;
          label$19 : {
           if ($5) {
            break label$19
           }
           dlfree($8 | 0);
           HEAP32[(((HEAP32[($1 + 12 | 0) >> 2] | 0) + ($3 << 3 | 0) | 0) + 4 | 0) >> 2] = 0;
           HEAP32[($1 + 8 | 0) >> 2] = $3;
           break label$4;
          }
          HEAP8[($8 + (HEAP32[$6 >> 2] | 0) | 0) >> 0] = 0;
          break label$14;
         }
         HEAP32[($8 + 4 | 0) >> 2] = 0;
        }
        $3 = $3 + 1 | 0;
        if ($3 >>> 0 >= (HEAP32[$4 >> 2] | 0) >>> 0) {
         break label$4
        }
        $5 = (HEAP32[($1 + 12 | 0) >> 2] | 0) + ($3 << 3 | 0) | 0;
        i64toi32_i32$0 = 0;
        HEAP32[$5 >> 2] = 0;
        HEAP32[($5 + 4 | 0) >> 2] = i64toi32_i32$0;
        if ($2 >>> 0 >= 4 >>> 0) {
         continue label$13
        }
        break label$13;
       };
      }
      HEAP32[$4 >> 2] = $3;
     }
     label$20 : {
      if (!$2) {
       break label$20
      }
      label$21 : {
       if (HEAP32[($1 + 8 | 0) >> 2] | 0) {
        break label$21
       }
       dlfree(HEAP32[($1 + 12 | 0) >> 2] | 0 | 0);
       HEAP32[($1 + 12 | 0) >> 2] = 0;
      }
      if (FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 | 0) | 0) {
       break label$20
      }
      return 0 | 0;
     }
     $3 = 1;
    }
    return $3 | 0;
   }
   HEAP32[$4 >> 2] = 0;
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
   return 0 | 0;
  }
  HEAP32[$4 >> 2] = $3;
  return 0 | 0;
 }
 
 function read_metadata_cuesheet_($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $4 = 0, $2 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $14 = 0, $13 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  $3 = 0;
  $1 = memset($1 | 0, 0 | 0, 160 | 0) | 0;
  $4 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_MEDIA_CATALOG_NUMBER_LEN;
  label$1 : {
   if (!(FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 | 0, (HEAP32[$4 >> 2] | 0) >>> 3 | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitreader_read_raw_uint64(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 136 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_LEAD_IN_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_IS_CD_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $3 = 0;
   HEAP32[($1 + 144 | 0) >> 2] = (HEAP32[($2 + 12 | 0) >> 2] | 0 | 0) != (0 | 0);
   if (!(FLAC__bitreader_skip_bits_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_RESERVED_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_NUM_TRACKS_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $3 = HEAP32[($2 + 12 | 0) >> 2] | 0;
   HEAP32[($1 + 148 | 0) >> 2] = $3;
   label$2 : {
    if ($3) {
     break label$2
    }
    $3 = 1;
    break label$1;
   }
   $3 = dlcalloc($3 | 0, 32 | 0) | 0;
   HEAP32[($1 + 152 | 0) >> 2] = $3;
   label$3 : {
    label$4 : {
     if (!$3) {
      break label$4
     }
     $5 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_ISRC_LEN;
     $6 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_RESERVED_LEN;
     $7 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_NUMBER_LEN;
     $8 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_OFFSET_LEN;
     $9 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_NUM_INDICES_LEN;
     $10 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_RESERVED_LEN;
     $11 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_PRE_EMPHASIS_LEN;
     $12 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_TYPE_LEN;
     $13 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_NUMBER_LEN;
     $4 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_OFFSET_LEN;
     $14 = HEAP32[$4 >> 2] | 0;
     if (!(FLAC__bitreader_read_raw_uint64(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 | 0, $14 | 0) | 0)) {
      break label$3
     }
     $15 = (HEAP32[$5 >> 2] | 0) >>> 3 | 0;
     $16 = HEAP32[$6 >> 2] | 0;
     $17 = HEAP32[$7 >> 2] | 0;
     $7 = HEAP32[$8 >> 2] | 0;
     $18 = HEAP32[$9 >> 2] | 0;
     $19 = HEAP32[$10 >> 2] | 0;
     $11 = HEAP32[$11 >> 2] | 0;
     $12 = HEAP32[$12 >> 2] | 0;
     $10 = HEAP32[$13 >> 2] | 0;
     $6 = 0;
     label$5 : while (1) {
      if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, $10 | 0) | 0)) {
       break label$3
      }
      $4 = $3 + ($6 << 5 | 0) | 0;
      HEAP8[($4 + 8 | 0) >> 0] = HEAP32[($2 + 12 | 0) >> 2] | 0;
      if (!(FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $4 + 9 | 0 | 0, $15 | 0) | 0)) {
       break label$3
      }
      if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, $12 | 0) | 0)) {
       break label$3
      }
      HEAP8[($4 + 22 | 0) >> 0] = (HEAPU8[($4 + 22 | 0) >> 0] | 0) & 254 | 0 | ((HEAPU8[($2 + 12 | 0) >> 0] | 0) & 1 | 0) | 0;
      if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, $11 | 0) | 0)) {
       break label$3
      }
      $3 = $4 + 22 | 0;
      HEAP8[$3 >> 0] = ((HEAPU8[($2 + 12 | 0) >> 0] | 0) << 1 | 0) & 2 | 0 | ((HEAPU8[$3 >> 0] | 0) & 253 | 0) | 0;
      if (!(FLAC__bitreader_skip_bits_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $19 | 0) | 0)) {
       break label$3
      }
      if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, $18 | 0) | 0)) {
       break label$3
      }
      $3 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      HEAP8[($4 + 23 | 0) >> 0] = $3;
      label$6 : {
       $3 = $3 & 255 | 0;
       if (!$3) {
        break label$6
       }
       $5 = dlcalloc($3 | 0, 16 | 0) | 0;
       HEAP32[($4 + 24 | 0) >> 2] = $5;
       if (!$5) {
        break label$4
       }
       $8 = $4 + 23 | 0;
       if (!(HEAPU8[$8 >> 0] | 0)) {
        break label$6
       }
       $3 = 0;
       if (!(FLAC__bitreader_read_raw_uint64(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $5 | 0, $7 | 0) | 0)) {
        break label$1
       }
       $9 = $4 + 24 | 0;
       $4 = 0;
       label$7 : while (1) {
        if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, $17 | 0) | 0)) {
         break label$1
        }
        HEAP8[(($5 + ($4 << 4 | 0) | 0) + 8 | 0) >> 0] = HEAP32[($2 + 12 | 0) >> 2] | 0;
        if (!(FLAC__bitreader_skip_bits_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $16 | 0) | 0)) {
         break label$1
        }
        $4 = $4 + 1 | 0;
        if ($4 >>> 0 >= (HEAPU8[$8 >> 0] | 0) >>> 0) {
         break label$6
        }
        $5 = HEAP32[$9 >> 2] | 0;
        if (!(FLAC__bitreader_read_raw_uint64(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $5 + ($4 << 4 | 0) | 0 | 0, $7 | 0) | 0)) {
         break label$1
        }
        continue label$7;
       };
      }
      $3 = 1;
      $6 = $6 + 1 | 0;
      if ($6 >>> 0 >= (HEAP32[($1 + 148 | 0) >> 2] | 0) >>> 0) {
       break label$1
      }
      $3 = HEAP32[($1 + 152 | 0) >> 2] | 0;
      if (FLAC__bitreader_read_raw_uint64(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $3 + ($6 << 5 | 0) | 0 | 0, $14 | 0) | 0) {
       continue label$5
      }
      break label$3;
     };
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
   }
   $3 = 0;
  }
  __stack_pointer = $2 + 16 | 0;
  return $3 | 0;
 }
 
 function read_metadata_picture_($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $4 = 0, $5 = 0, $2 = 0, $3 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  $3 = 0;
  label$1 : {
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_TYPE_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   HEAP32[$1 >> 2] = HEAP32[($2 + 12 | 0) >> 2] | 0;
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_MIME_TYPE_LENGTH_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   label$2 : {
    label$3 : {
     label$4 : {
      $4 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      if (($4 | 0) != (-1 | 0)) {
       break label$4
      }
      HEAP32[($1 + 4 | 0) >> 2] = 0;
      break label$3;
     }
     $5 = dlmalloc($4 + 1 | 0 | 0) | 0;
     HEAP32[($1 + 4 | 0) >> 2] = $5;
     if ($5) {
      break label$2
     }
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
    break label$1;
   }
   $3 = 0;
   label$5 : {
    label$6 : {
     if ($4) {
      break label$6
     }
     $4 = 0;
     break label$5;
    }
    label$7 : {
     if (FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $5 | 0, $4 | 0) | 0) {
      break label$7
     }
     $3 = 0;
     break label$1;
    }
    $5 = HEAP32[($1 + 4 | 0) >> 2] | 0;
    $4 = HEAP32[($2 + 12 | 0) >> 2] | 0;
   }
   HEAP8[($5 + $4 | 0) >> 0] = 0;
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $2 + 12 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DESCRIPTION_LENGTH_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   label$8 : {
    label$9 : {
     label$10 : {
      $4 = HEAP32[($2 + 12 | 0) >> 2] | 0;
      if (($4 | 0) != (-1 | 0)) {
       break label$10
      }
      HEAP32[($1 + 8 | 0) >> 2] = 0;
      break label$9;
     }
     $5 = dlmalloc($4 + 1 | 0 | 0) | 0;
     HEAP32[($1 + 8 | 0) >> 2] = $5;
     if ($5) {
      break label$8
     }
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
    break label$1;
   }
   $3 = 0;
   label$11 : {
    label$12 : {
     if ($4) {
      break label$12
     }
     $4 = 0;
     break label$11;
    }
    label$13 : {
     if (FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $5 | 0, $4 | 0) | 0) {
      break label$13
     }
     $3 = 0;
     break label$1;
    }
    $5 = HEAP32[($1 + 8 | 0) >> 2] | 0;
    $4 = HEAP32[($2 + 12 | 0) >> 2] | 0;
   }
   HEAP8[($5 + $4 | 0) >> 0] = 0;
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 12 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_WIDTH_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 16 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_HEIGHT_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 20 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DEPTH_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 24 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_COLORS_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $1 + 28 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DATA_LENGTH_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $4 = HEAP32[($1 + 28 | 0) >> 2] | 0;
   $5 = dlmalloc(($4 ? $4 : 1) | 0) | 0;
   HEAP32[($1 + 32 | 0) >> 2] = $5;
   label$14 : {
    if ($5) {
     break label$14
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
    break label$1;
   }
   label$15 : {
    if (!$4) {
     break label$15
    }
    if (!(FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $5 | 0, $4 | 0) | 0)) {
     break label$1
    }
   }
   $3 = 1;
  }
  __stack_pointer = $2 + 16 | 0;
  return $3 | 0;
 }
 
 function read_residual_partitioned_rice_($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $7 = 0, $6 = 0, $8 = 0, $12 = 0, $13 = 0, $9 = 0, $10 = 0, $11 = 0;
  $6 = __stack_pointer - 16 | 0;
  __stack_pointer = $6;
  $7 = HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 1136 | 0) >> 2] | 0;
  $8 = GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ESCAPE_PARAMETER;
  $9 = HEAP32[($5 ? GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2_ESCAPE_PARAMETER : $8) >> 2] | 0;
  $8 = GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_PARAMETER_LEN;
  $10 = HEAP32[($5 ? GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2_PARAMETER_LEN : $8) >> 2] | 0;
  label$1 : {
   label$2 : {
    if (!(FLAC__format_entropy_coding_method_partitioned_rice_contents_ensure_size($3 | 0, ($2 >>> 0 > 6 >>> 0 ? $2 : 6) | 0) | 0)) {
     break label$2
    }
    $8 = $2 ? $7 >>> $2 | 0 : $7 - $1 | 0;
    $11 = HEAP32[GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_RAW_LEN >> 2] | 0;
    $12 = 0;
    $5 = 0;
    label$3 : while (1) {
     label$4 : {
      if (FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $6 + 12 | 0 | 0, $10 | 0) | 0) {
       break label$4
      }
      $13 = 0;
      break label$1;
     }
     $7 = $12 << 2 | 0;
     HEAP32[((HEAP32[$3 >> 2] | 0) + $7 | 0) >> 2] = HEAP32[($6 + 12 | 0) >> 2] | 0;
     label$5 : {
      label$6 : {
       if ((HEAP32[($6 + 12 | 0) >> 2] | 0) >>> 0 >= $9 >>> 0) {
        break label$6
       }
       $13 = 0;
       HEAP32[((HEAP32[($3 + 4 | 0) >> 2] | 0) + $7 | 0) >> 2] = 0;
       $7 = $8 - ($2 ? ($12 ? 0 : $1) : 0) | 0;
       if (!(FLAC__bitreader_read_rice_signed_block(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $4 + ($5 << 2 | 0) | 0 | 0, $7 | 0, HEAP32[($6 + 12 | 0) >> 2] | 0 | 0) | 0)) {
        break label$1
       }
       $5 = $7 + $5 | 0;
       break label$5;
      }
      label$7 : {
       if (FLAC__bitreader_read_raw_uint32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $6 + 12 | 0 | 0, $11 | 0) | 0) {
        break label$7
       }
       $13 = 0;
       break label$1;
      }
      HEAP32[((HEAP32[($3 + 4 | 0) >> 2] | 0) + $7 | 0) >> 2] = HEAP32[($6 + 12 | 0) >> 2] | 0;
      $7 = $2 ? ($12 ? 0 : $1) : 0;
      if ($7 >>> 0 >= $8 >>> 0) {
       break label$5
      }
      label$8 : while (1) {
       label$9 : {
        if (FLAC__bitreader_read_raw_int32(HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 56 | 0) >> 2] | 0 | 0, $6 + 8 | 0 | 0, HEAP32[($6 + 12 | 0) >> 2] | 0 | 0) | 0) {
         break label$9
        }
        $13 = 0;
        break label$1;
       }
       HEAP32[($4 + ($5 << 2 | 0) | 0) >> 2] = HEAP32[($6 + 8 | 0) >> 2] | 0;
       $5 = $5 + 1 | 0;
       $7 = $7 + 1 | 0;
       if (($7 | 0) != ($8 | 0)) {
        continue label$8
       }
       break label$8;
      };
     }
     $13 = 1;
     $12 = $12 + 1 | 0;
     if (!($12 >>> $2 | 0)) {
      continue label$3
     }
     break label$1;
    };
   }
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
   $13 = 0;
  }
  __stack_pointer = $6 + 16 | 0;
  return $13 | 0;
 }
 
 function write_audio_frame_to_client_($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $4 = 0, i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, i64toi32_i32$1 = 0, i64toi32_i32$3 = 0, i64toi32_i32$4 = 0, i64toi32_i32$5 = 0, $6$hi = 0, $3 = 0, $8 = 0, $6 = 0, $13 = 0, $7$hi = 0, $10 = 0, $12 = 0, $9 = 0, $11 = 0, $5$hi = 0, $7 = 0, $5 = 0, $36 = 0, $36$hi = 0, $39$hi = 0, $139 = 0, $141 = 0, $141$hi = 0, $143 = 0, $143$hi = 0;
  $3 = __stack_pointer - 32 | 0;
  __stack_pointer = $3;
  label$1 : {
   label$2 : {
    $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    if (!(HEAP32[($4 + 3632 | 0) >> 2] | 0)) {
     break label$2
    }
    i64toi32_i32$2 = $1;
    i64toi32_i32$0 = HEAP32[$1 >> 2] | 0;
    i64toi32_i32$1 = 0;
    $5 = i64toi32_i32$0;
    $5$hi = i64toi32_i32$1;
    i64toi32_i32$2 = $1;
    i64toi32_i32$1 = HEAP32[($1 + 24 | 0) >> 2] | 0;
    i64toi32_i32$0 = HEAP32[($1 + 28 | 0) >> 2] | 0;
    $6 = i64toi32_i32$1;
    $6$hi = i64toi32_i32$0;
    HEAP32[($4 + 6156 | 0) >> 2] = 1;
    i64toi32_i32$2 = $4;
    i64toi32_i32$0 = HEAP32[($4 + 6144 | 0) >> 2] | 0;
    i64toi32_i32$1 = HEAP32[($4 + 6148 | 0) >> 2] | 0;
    $7 = i64toi32_i32$0;
    $7$hi = i64toi32_i32$1;
    __memcpy($4 + 3752 | 0 | 0, $1 | 0, 2384 | 0) | 0;
    $4 = 0;
    i64toi32_i32$1 = $6$hi;
    i64toi32_i32$1 = $7$hi;
    i64toi32_i32$2 = i64toi32_i32$0;
    i64toi32_i32$0 = $6$hi;
    i64toi32_i32$3 = $6;
    if (i64toi32_i32$1 >>> 0 < i64toi32_i32$0 >>> 0 | ((i64toi32_i32$1 | 0) == (i64toi32_i32$0 | 0) & i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0 | 0) | 0) {
     break label$1
    }
    i64toi32_i32$2 = $7$hi;
    $36 = $7;
    $36$hi = i64toi32_i32$2;
    i64toi32_i32$2 = $6$hi;
    i64toi32_i32$2 = $5$hi;
    i64toi32_i32$2 = $6$hi;
    i64toi32_i32$3 = $6;
    i64toi32_i32$1 = $5$hi;
    i64toi32_i32$0 = $5;
    i64toi32_i32$4 = i64toi32_i32$3 + i64toi32_i32$0 | 0;
    i64toi32_i32$5 = i64toi32_i32$2 + i64toi32_i32$1 | 0;
    if (i64toi32_i32$4 >>> 0 < i64toi32_i32$0 >>> 0) {
     i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
    }
    $39$hi = i64toi32_i32$5;
    i64toi32_i32$5 = $36$hi;
    i64toi32_i32$2 = $36;
    i64toi32_i32$3 = $39$hi;
    i64toi32_i32$0 = i64toi32_i32$4;
    if (i64toi32_i32$5 >>> 0 > i64toi32_i32$3 >>> 0 | ((i64toi32_i32$5 | 0) == (i64toi32_i32$3 | 0) & i64toi32_i32$2 >>> 0 >= i64toi32_i32$0 >>> 0 | 0) | 0) {
     break label$1
    }
    $8 = HEAP32[($0 + 4 | 0) >> 2] | 0;
    HEAP32[($8 + 3632 | 0) >> 2] = 0;
    label$3 : {
     i64toi32_i32$2 = $7$hi;
     i64toi32_i32$2 = $6$hi;
     i64toi32_i32$2 = $7$hi;
     i64toi32_i32$0 = $7;
     i64toi32_i32$5 = $6$hi;
     i64toi32_i32$3 = $6;
     i64toi32_i32$1 = i64toi32_i32$0 - i64toi32_i32$3 | 0;
     i64toi32_i32$4 = (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) + $6$hi | 0;
     i64toi32_i32$4 = i64toi32_i32$2 - i64toi32_i32$4 | 0;
     $6 = i64toi32_i32$1;
     $6$hi = i64toi32_i32$4;
     $9 = i64toi32_i32$1;
     if (!i64toi32_i32$1) {
      break label$3
     }
     label$4 : {
      $1 = HEAP32[($1 + 8 | 0) >> 2] | 0;
      if (!$1) {
       break label$4
      }
      $10 = $1 & 3 | 0;
      $4 = 0;
      label$5 : {
       if (($1 + -1 | 0) >>> 0 < 3 >>> 0) {
        break label$5
       }
       $11 = $1 & -4 | 0;
       $4 = 0;
       label$6 : while (1) {
        $1 = $4 << 2 | 0;
        $12 = $9 << 2 | 0;
        HEAP32[($3 + $1 | 0) >> 2] = (HEAP32[($2 + $1 | 0) >> 2] | 0) + $12 | 0;
        $13 = $1 | 4 | 0;
        HEAP32[($3 + $13 | 0) >> 2] = (HEAP32[($2 + $13 | 0) >> 2] | 0) + $12 | 0;
        $13 = $1 | 8 | 0;
        HEAP32[($3 + $13 | 0) >> 2] = (HEAP32[($2 + $13 | 0) >> 2] | 0) + $12 | 0;
        $1 = $1 | 12 | 0;
        HEAP32[($3 + $1 | 0) >> 2] = (HEAP32[($2 + $1 | 0) >> 2] | 0) + $12 | 0;
        $4 = $4 + 4 | 0;
        $11 = $11 + -4 | 0;
        if ($11) {
         continue label$6
        }
        break label$6;
       };
      }
      if (!$10) {
       break label$4
      }
      label$7 : while (1) {
       $1 = $4 << 2 | 0;
       HEAP32[($3 + $1 | 0) >> 2] = (HEAP32[($2 + $1 | 0) >> 2] | 0) + ($9 << 2 | 0) | 0;
       $4 = $4 + 1 | 0;
       $10 = $10 + -1 | 0;
       if ($10) {
        continue label$7
       }
       break label$7;
      };
     }
     HEAP32[($8 + 3752 | 0) >> 2] = (HEAP32[($8 + 3752 | 0) >> 2] | 0) - $9 | 0;
     $4 = $8 + 3776 | 0;
     $139 = $4;
     i64toi32_i32$2 = $4;
     i64toi32_i32$4 = HEAP32[$4 >> 2] | 0;
     i64toi32_i32$0 = HEAP32[($4 + 4 | 0) >> 2] | 0;
     $141 = i64toi32_i32$4;
     $141$hi = i64toi32_i32$0;
     i64toi32_i32$0 = $6$hi;
     i64toi32_i32$2 = $6;
     i64toi32_i32$4 = 0;
     i64toi32_i32$3 = -1;
     i64toi32_i32$4 = i64toi32_i32$0 & i64toi32_i32$4 | 0;
     $143 = i64toi32_i32$2 & i64toi32_i32$3 | 0;
     $143$hi = i64toi32_i32$4;
     i64toi32_i32$4 = $141$hi;
     i64toi32_i32$0 = $141;
     i64toi32_i32$2 = $143$hi;
     i64toi32_i32$3 = $143;
     i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
     i64toi32_i32$1 = i64toi32_i32$4 + i64toi32_i32$2 | 0;
     if (i64toi32_i32$5 >>> 0 < i64toi32_i32$3 >>> 0) {
      i64toi32_i32$1 = i64toi32_i32$1 + 1 | 0
     }
     i64toi32_i32$0 = $139;
     HEAP32[i64toi32_i32$0 >> 2] = i64toi32_i32$5;
     HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] = i64toi32_i32$1;
     $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     $4 = FUNCTION_TABLE[HEAP32[($4 + 24 | 0) >> 2] | 0 | 0]($0, $4 + 3752 | 0, $3, HEAP32[($4 + 48 | 0) >> 2] | 0) | 0;
     break label$1;
    }
    $4 = FUNCTION_TABLE[HEAP32[($8 + 24 | 0) >> 2] | 0 | 0]($0, $1, $2, HEAP32[($8 + 48 | 0) >> 2] | 0) | 0;
    break label$1;
   }
   label$8 : {
    label$9 : {
     if (HEAP32[($4 + 248 | 0) >> 2] | 0) {
      break label$9
     }
     HEAP32[($4 + 3624 | 0) >> 2] = 0;
     break label$8;
    }
    if (!(HEAP32[($4 + 3624 | 0) >> 2] | 0)) {
     break label$8
    }
    label$10 : {
     if (FLAC__MD5Accumulate($4 + 3636 | 0 | 0, $2 | 0, HEAP32[($1 + 8 | 0) >> 2] | 0 | 0, HEAP32[$1 >> 2] | 0 | 0, ((HEAP32[($1 + 16 | 0) >> 2] | 0) + 7 | 0) >>> 3 | 0 | 0) | 0) {
      break label$10
     }
     $4 = 1;
     break label$1;
    }
    $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   }
   $4 = FUNCTION_TABLE[HEAP32[($4 + 24 | 0) >> 2] | 0 | 0]($0, $1, $2, HEAP32[($4 + 48 | 0) >> 2] | 0) | 0;
  }
  __stack_pointer = $3 + 32 | 0;
  return $4 | 0;
 }
 
 function FLAC__stream_decoder_process_until_end_of_metadata($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : while (1) {
      $1 = 1;
      $2 = 0;
      label$5 : {
       switch (HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) {
       case 0:
        if (find_metadata_($0 | 0) | 0) {
         continue label$4
        }
        break label$3;
       case 2:
       case 3:
       case 4:
       case 7:
        break label$2;
       case 1:
        break label$5;
       default:
        break label$1;
       };
      }
      if (read_metadata_($0 | 0) | 0) {
       continue label$4
      }
      break label$4;
     };
    }
    $1 = 0;
   }
   $2 = $1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_process_until_end_of_stream($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  $2 = 1;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : while (1) {
      $3 = 0;
      label$5 : {
       switch (HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] | 0 | 0) {
       case 0:
        if (find_metadata_($0 | 0) | 0) {
         continue label$4
        }
        break label$3;
       case 1:
        if (read_metadata_($0 | 0) | 0) {
         continue label$4
        }
        break label$3;
       case 2:
        if (frame_sync_($0 | 0) | 0) {
         continue label$4
        }
        break label$2;
       case 4:
       case 7:
        break label$2;
       case 3:
        break label$5;
       default:
        break label$1;
       };
      }
      if (read_frame_($0 | 0, $1 + 12 | 0 | 0, 1 | 0) | 0) {
       continue label$4
      }
      break label$4;
     };
    }
    $2 = 0;
   }
   $3 = $2;
  }
  __stack_pointer = $1 + 16 | 0;
  return $3 | 0;
 }
 
 function read_callback_proxy_($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0;
  $4 = 5;
  label$1 : {
   $0 = FUNCTION_TABLE[HEAP32[((HEAP32[($0 + 4 | 0) >> 2] | 0) + 4 | 0) >> 2] | 0 | 0]($0, $1, $2, $3) | 0;
   if ($0 >>> 0 > 2 >>> 0) {
    break label$1
   }
   $4 = HEAP32[((GOT_data_internal___memory_base + 7856 | 0) + ($0 << 2 | 0) | 0) >> 2] | 0;
  }
  return $4 | 0;
 }
 
 function FLAC__bitwriter_new() {
  return dlcalloc(1 | 0, 20 | 0) | 0 | 0;
 }
 
 function FLAC__bitwriter_delete($0) {
  $0 = $0 | 0;
  var $1 = 0;
  label$1 : {
   $1 = HEAP32[$0 >> 2] | 0;
   if (!$1) {
    break label$1
   }
   dlfree($1 | 0);
  }
  dlfree($0 | 0);
 }
 
 function FLAC__bitwriter_free($0) {
  $0 = $0 | 0;
  var $1 = 0;
  label$1 : {
   $1 = HEAP32[$0 >> 2] | 0;
   if (!$1) {
    break label$1
   }
   dlfree($1 | 0);
  }
  HEAP32[($0 + 16 | 0) >> 2] = 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[($0 + 8 | 0) >> 2] = 0;
  HEAP32[($0 + 12 | 0) >> 2] = 0;
 }
 
 function FLAC__bitwriter_init($0) {
  $0 = $0 | 0;
  var $1 = 0;
  HEAP32[($0 + 16 | 0) >> 2] = 0;
  HEAP32[($0 + 8 | 0) >> 2] = 8192;
  HEAP32[($0 + 12 | 0) >> 2] = 0;
  $1 = dlmalloc(32768 | 0) | 0;
  HEAP32[$0 >> 2] = $1;
  return ($1 | 0) != (0 | 0) | 0;
 }
 
 function FLAC__bitwriter_clear($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0;
  i64toi32_i32$1 = $0;
  HEAP32[(i64toi32_i32$1 + 12 | 0) >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 16 | 0) >> 2] = 0;
 }
 
 function FLAC__bitwriter_get_write_crc16($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  label$1 : {
   label$2 : {
    if (FLAC__bitwriter_get_buffer($0 | 0, $2 + 12 | 0 | 0, $2 + 8 | 0 | 0) | 0) {
     break label$2
    }
    $0 = 0;
    break label$1;
   }
   (wasm2js_i32$0 = $1, wasm2js_i32$1 = FLAC__crc16(HEAP32[($2 + 12 | 0) >> 2] | 0 | 0, HEAP32[($2 + 8 | 0) >> 2] | 0 | 0) | 0), HEAP16[wasm2js_i32$0 >> 1] = wasm2js_i32$1;
   $0 = 1;
  }
  __stack_pointer = $2 + 16 | 0;
  return $0 | 0;
 }
 
 function FLAC__bitwriter_get_buffer($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $7 = 0, $6 = 0, $67 = 0;
  $3 = 0;
  label$1 : {
   $4 = HEAP32[($0 + 16 | 0) >> 2] | 0;
   if ($4 & 7 | 0) {
    break label$1
   }
   label$2 : {
    label$3 : {
     if ($4) {
      break label$3
     }
     $5 = HEAP32[$0 >> 2] | 0;
     $3 = 0;
     break label$2;
    }
    label$4 : {
     $3 = HEAP32[($0 + 12 | 0) >> 2] | 0;
     if (($3 | 0) != (HEAP32[($0 + 8 | 0) >> 2] | 0 | 0)) {
      break label$4
     }
     $5 = ($4 + 63 | 0) >>> 5 | 0;
     $6 = $3 + $5 | 0;
     if ($6 >>> 0 <= $3 >>> 0) {
      break label$4
     }
     $3 = 0;
     $7 = HEAP32[$0 >> 2] | 0;
     label$5 : {
      label$6 : {
       $4 = $5 & 1023 | 0;
       $4 = ($4 ? 1024 - $4 | 0 : 0) + $6 | 0;
       if (!$4) {
        break label$6
       }
       if ($4 >>> 0 > 1073741823 >>> 0) {
        break label$1
       }
       $5 = dlrealloc($7 | 0, $4 << 2 | 0 | 0) | 0;
       if ($5) {
        break label$5
       }
       dlfree($7 | 0);
       return 0 | 0;
      }
      $3 = 0;
      $5 = dlrealloc($7 | 0, 0 | 0) | 0;
      if (!$5) {
       break label$1
      }
     }
     HEAP32[($0 + 8 | 0) >> 2] = $4;
     HEAP32[$0 >> 2] = $5;
     $3 = HEAP32[($0 + 12 | 0) >> 2] | 0;
     $4 = HEAP32[($0 + 16 | 0) >> 2] | 0;
    }
    $5 = HEAP32[$0 >> 2] | 0;
    $67 = $5 + ($3 << 2 | 0) | 0;
    $3 = (HEAP32[($0 + 4 | 0) >> 2] | 0) << (32 - $4 | 0) | 0;
    HEAP32[$67 >> 2] = $3 << 24 | 0 | (($3 << 8 | 0) & 16711680 | 0) | 0 | (($3 >>> 8 | 0) & 65280 | 0 | ($3 >>> 24 | 0) | 0) | 0;
    $3 = (HEAP32[($0 + 16 | 0) >> 2] | 0) >>> 3 | 0;
   }
   HEAP32[$1 >> 2] = $5;
   HEAP32[$2 >> 2] = $3 + ((HEAP32[($0 + 12 | 0) >> 2] | 0) << 2 | 0) | 0;
   $3 = 1;
  }
  return $3 | 0;
 }
 
 function FLAC__bitwriter_release_buffer($0) {
  $0 = $0 | 0;
 }
 
 function FLAC__bitwriter_get_write_crc8($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  label$1 : {
   label$2 : {
    if (FLAC__bitwriter_get_buffer($0 | 0, $2 + 12 | 0 | 0, $2 + 8 | 0 | 0) | 0) {
     break label$2
    }
    $0 = 0;
    break label$1;
   }
   (wasm2js_i32$0 = $1, wasm2js_i32$1 = FLAC__crc8(HEAP32[($2 + 12 | 0) >> 2] | 0 | 0, HEAP32[($2 + 8 | 0) >> 2] | 0 | 0) | 0), HEAP8[wasm2js_i32$0 >> 0] = wasm2js_i32$1;
   $0 = 1;
  }
  __stack_pointer = $2 + 16 | 0;
  return $0 | 0;
 }
 
 function FLAC__bitwriter_write_zeroes($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0;
  label$1 : {
   label$2 : {
    if (!$1) {
     break label$2
    }
    label$3 : {
     $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
     $3 = HEAP32[($0 + 12 | 0) >> 2] | 0;
     if ($2 >>> 0 > ($3 + $1 | 0) >>> 0) {
      break label$3
     }
     $4 = ((($1 + (HEAP32[($0 + 16 | 0) >> 2] | 0) | 0) + 31 | 0) >>> 5 | 0) + $3 | 0;
     if ($4 >>> 0 <= $2 >>> 0) {
      break label$3
     }
     $3 = 0;
     $5 = HEAP32[$0 >> 2] | 0;
     label$4 : {
      label$5 : {
       $2 = ($4 - $2 | 0) & 1023 | 0;
       $2 = ($2 ? 1024 - $2 | 0 : 0) + $4 | 0;
       if (!$2) {
        break label$5
       }
       if ($2 >>> 0 > 1073741823 >>> 0) {
        break label$1
       }
       $4 = dlrealloc($5 | 0, $2 << 2 | 0 | 0) | 0;
       if ($4) {
        break label$4
       }
       dlfree($5 | 0);
       return 0 | 0;
      }
      $3 = 0;
      $4 = dlrealloc($5 | 0, 0 | 0) | 0;
      if (!$4) {
       break label$1
      }
     }
     HEAP32[($0 + 8 | 0) >> 2] = $2;
     HEAP32[$0 >> 2] = $4;
    }
    label$6 : {
     $3 = HEAP32[($0 + 16 | 0) >> 2] | 0;
     if (!$3) {
      break label$6
     }
     $2 = 32 - $3 | 0;
     $2 = $2 >>> 0 < $1 >>> 0 ? $2 : $1;
     $4 = $2 + $3 | 0;
     HEAP32[($0 + 16 | 0) >> 2] = $4;
     $3 = (HEAP32[($0 + 4 | 0) >> 2] | 0) << $2 | 0;
     HEAP32[($0 + 4 | 0) >> 2] = $3;
     if (($4 | 0) != (32 | 0)) {
      break label$2
     }
     $4 = HEAP32[($0 + 12 | 0) >> 2] | 0;
     HEAP32[($0 + 12 | 0) >> 2] = $4 + 1 | 0;
     HEAP32[((HEAP32[$0 >> 2] | 0) + ($4 << 2 | 0) | 0) >> 2] = $3 << 24 | 0 | (($3 << 8 | 0) & 16711680 | 0) | 0 | (($3 >>> 8 | 0) & 65280 | 0 | ($3 >>> 24 | 0) | 0) | 0;
     HEAP32[($0 + 16 | 0) >> 2] = 0;
     $1 = $1 - $2 | 0;
    }
    label$7 : {
     if ($1 >>> 0 < 32 >>> 0) {
      break label$7
     }
     $3 = HEAP32[$0 >> 2] | 0;
     label$8 : {
      $5 = $1 + -32 | 0;
      $2 = (($5 >>> 5 | 0) + 1 | 0) & 3 | 0;
      if (!$2) {
       break label$8
      }
      label$9 : while (1) {
       $4 = HEAP32[($0 + 12 | 0) >> 2] | 0;
       HEAP32[($0 + 12 | 0) >> 2] = $4 + 1 | 0;
       HEAP32[($3 + ($4 << 2 | 0) | 0) >> 2] = 0;
       $1 = $1 + -32 | 0;
       $2 = $2 + -1 | 0;
       if ($2) {
        continue label$9
       }
       break label$9;
      };
     }
     if ($5 >>> 0 < 96 >>> 0) {
      break label$7
     }
     label$10 : while (1) {
      $2 = HEAP32[($0 + 12 | 0) >> 2] | 0;
      HEAP32[($0 + 12 | 0) >> 2] = $2 + 1 | 0;
      HEAP32[($3 + ($2 << 2 | 0) | 0) >> 2] = 0;
      $2 = HEAP32[($0 + 12 | 0) >> 2] | 0;
      HEAP32[($0 + 12 | 0) >> 2] = $2 + 1 | 0;
      HEAP32[($3 + ($2 << 2 | 0) | 0) >> 2] = 0;
      $2 = HEAP32[($0 + 12 | 0) >> 2] | 0;
      HEAP32[($0 + 12 | 0) >> 2] = $2 + 1 | 0;
      HEAP32[($3 + ($2 << 2 | 0) | 0) >> 2] = 0;
      $2 = HEAP32[($0 + 12 | 0) >> 2] | 0;
      HEAP32[($0 + 12 | 0) >> 2] = $2 + 1 | 0;
      HEAP32[($3 + ($2 << 2 | 0) | 0) >> 2] = 0;
      $1 = $1 + -128 | 0;
      if ($1 >>> 0 > 31 >>> 0) {
       continue label$10
      }
      break label$10;
     };
    }
    if (!$1) {
     break label$2
    }
    HEAP32[($0 + 16 | 0) >> 2] = $1;
    HEAP32[($0 + 4 | 0) >> 2] = 0;
   }
   $3 = 1;
  }
  return $3 | 0;
 }
 
 function FLAC__bitwriter_write_raw_uint32($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0;
  label$1 : {
   label$2 : {
    if ($2 >>> 0 > 31 >>> 0) {
     break label$2
    }
    $3 = 0;
    if ($1 >>> $2 | 0) {
     break label$1
    }
   }
   $3 = FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 | 0, $2 | 0) | 0;
  }
  return $3 | 0;
 }
 
 function FLAC__bitwriter_write_raw_uint32_nocheck($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $5 = 0, $4 = 0, $6 = 0;
  $3 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $4 = HEAP32[$0 >> 2] | 0;
   if (!$4) {
    break label$1
   }
   if ($2 >>> 0 > 32 >>> 0) {
    break label$1
   }
   $3 = 1;
   if (!$2) {
    break label$1
   }
   label$2 : {
    label$3 : {
     $5 = HEAP32[($0 + 8 | 0) >> 2] | 0;
     $3 = HEAP32[($0 + 12 | 0) >> 2] | 0;
     if ($5 >>> 0 <= ($3 + $2 | 0) >>> 0) {
      break label$3
     }
     $5 = $4;
     break label$2;
    }
    label$4 : {
     $6 = ((($2 + (HEAP32[($0 + 16 | 0) >> 2] | 0) | 0) + 31 | 0) >>> 5 | 0) + $3 | 0;
     if ($6 >>> 0 > $5 >>> 0) {
      break label$4
     }
     $5 = $4;
     break label$2;
    }
    $3 = 0;
    label$5 : {
     label$6 : {
      $5 = ($6 - $5 | 0) & 1023 | 0;
      $6 = ($5 ? 1024 - $5 | 0 : 0) + $6 | 0;
      if (!$6) {
       break label$6
      }
      if ($6 >>> 0 > 1073741823 >>> 0) {
       break label$1
      }
      $5 = dlrealloc($4 | 0, $6 << 2 | 0 | 0) | 0;
      if ($5) {
       break label$5
      }
      dlfree($4 | 0);
      return 0 | 0;
     }
     $3 = 0;
     $5 = dlrealloc($4 | 0, 0 | 0) | 0;
     if (!$5) {
      break label$1
     }
    }
    HEAP32[($0 + 8 | 0) >> 2] = $6;
    HEAP32[$0 >> 2] = $5;
   }
   label$7 : {
    $3 = HEAP32[($0 + 16 | 0) >> 2] | 0;
    $4 = 32 - $3 | 0;
    if ($4 >>> 0 <= $2 >>> 0) {
     break label$7
    }
    HEAP32[($0 + 16 | 0) >> 2] = $3 + $2 | 0;
    HEAP32[($0 + 4 | 0) >> 2] = (HEAP32[($0 + 4 | 0) >> 2] | 0) << $2 | 0 | $1 | 0;
    return 1 | 0;
   }
   label$8 : {
    if (!$3) {
     break label$8
    }
    $2 = $2 - $4 | 0;
    HEAP32[($0 + 16 | 0) >> 2] = $2;
    $3 = HEAP32[($0 + 12 | 0) >> 2] | 0;
    HEAP32[($0 + 12 | 0) >> 2] = $3 + 1 | 0;
    $2 = (HEAP32[($0 + 4 | 0) >> 2] | 0) << $4 | 0 | ($1 >>> $2 | 0) | 0;
    HEAP32[($5 + ($3 << 2 | 0) | 0) >> 2] = $2 << 24 | 0 | (($2 << 8 | 0) & 16711680 | 0) | 0 | (($2 >>> 8 | 0) & 65280 | 0 | ($2 >>> 24 | 0) | 0) | 0;
    HEAP32[($0 + 4 | 0) >> 2] = $1;
    return 1 | 0;
   }
   $3 = 1;
   $2 = HEAP32[($0 + 12 | 0) >> 2] | 0;
   HEAP32[($0 + 12 | 0) >> 2] = $2 + 1 | 0;
   HEAP32[($5 + ($2 << 2 | 0) | 0) >> 2] = $1 << 24 | 0 | (($1 << 8 | 0) & 16711680 | 0) | 0 | (($1 >>> 8 | 0) & 65280 | 0 | ($1 >>> 24 | 0) | 0) | 0;
  }
  return $3 | 0;
 }
 
 function FLAC__bitwriter_write_raw_int32($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  return FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($2 >>> 0 < 32 >>> 0 ? (-1 << $2 | 0) ^ -1 | 0 : -1) & $1 | 0 | 0, $2 | 0) | 0 | 0;
 }
 
 function FLAC__bitwriter_write_raw_uint64($0, $1, $1$hi, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  $2 = $2 | 0;
  var $3 = 0, i64toi32_i32$4 = 0, $4 = 0, i64toi32_i32$0 = 0, i64toi32_i32$3 = 0, $10 = 0, i64toi32_i32$2 = 0;
  label$1 : {
   label$2 : {
    if ($2 >>> 0 < 33 >>> 0) {
     break label$2
    }
    i64toi32_i32$0 = $1$hi;
    i64toi32_i32$2 = $1;
    i64toi32_i32$3 = 32;
    i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     $10 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0
    } else {
     $10 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0
    }
    $3 = $10;
    $4 = 0;
    label$3 : {
     $2 = $2 + -32 | 0;
     if ($2 >>> 0 > 31 >>> 0) {
      break label$3
     }
     if ($3 >>> $2 | 0) {
      break label$1
     }
    }
    if (!(FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $3 | 0, $2 | 0) | 0)) {
     break label$1
    }
    return (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 | 0, 32 | 0) | 0 | 0) != (0 | 0) | 0;
   }
   $3 = $1;
   label$4 : {
    if (($2 | 0) == (32 | 0)) {
     break label$4
    }
    $4 = 0;
    if ($3 >>> $2 | 0) {
     break label$1
    }
   }
   $4 = FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $3 | 0, $2 | 0) | 0;
  }
  return $4 | 0;
 }
 
 function FLAC__bitwriter_write_raw_uint32_little_endian($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $2 = 0;
  label$1 : {
   if (!(FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 255 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 8 | 0) & 255 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 16 | 0) & 255 | 0 | 0, 8 | 0) | 0)) {
    break label$1
   }
   $2 = (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 >>> 24 | 0 | 0, 8 | 0) | 0 | 0) != (0 | 0);
  }
  return $2 | 0;
 }
 
 function FLAC__bitwriter_write_byte_block($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $4 = 0, $3 = 0, $5 = 0, $6 = 0;
  label$1 : {
   label$2 : {
    $3 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    $4 = HEAP32[($0 + 12 | 0) >> 2] | 0;
    if ($3 >>> 0 > ((($2 >>> 2 | 0) + $4 | 0) + 1 | 0) >>> 0) {
     break label$2
    }
    $5 = (((($2 << 3 | 0) + (HEAP32[($0 + 16 | 0) >> 2] | 0) | 0) + 31 | 0) >>> 5 | 0) + $4 | 0;
    if ($5 >>> 0 <= $3 >>> 0) {
     break label$2
    }
    $4 = 0;
    $6 = HEAP32[$0 >> 2] | 0;
    label$3 : {
     label$4 : {
      $3 = ($5 - $3 | 0) & 1023 | 0;
      $3 = ($3 ? 1024 - $3 | 0 : 0) + $5 | 0;
      if (!$3) {
       break label$4
      }
      if ($3 >>> 0 > 1073741823 >>> 0) {
       break label$1
      }
      $5 = dlrealloc($6 | 0, $3 << 2 | 0 | 0) | 0;
      if ($5) {
       break label$3
      }
      dlfree($6 | 0);
      return 0 | 0;
     }
     $4 = 0;
     $5 = dlrealloc($6 | 0, 0 | 0) | 0;
     if (!$5) {
      break label$1
     }
    }
    HEAP32[($0 + 8 | 0) >> 2] = $3;
    HEAP32[$0 >> 2] = $5;
   }
   $4 = 1;
   if (!$2) {
    break label$1
   }
   $4 = 0;
   label$5 : {
    label$6 : while (1) {
     if (!(FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, HEAPU8[($1 + $4 | 0) >> 0] | 0 | 0, 8 | 0) | 0)) {
      break label$5
     }
     $4 = $4 + 1 | 0;
     if (($4 | 0) != ($2 | 0)) {
      continue label$6
     }
     break label$6;
    };
    return 1 | 0;
   }
   $4 = 0;
  }
  return $4 | 0;
 }
 
 function FLAC__bitwriter_write_unary_unsigned($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  label$1 : {
   if ($1 >>> 0 > 31 >>> 0) {
    break label$1
   }
   return FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, 1 | 0, $1 + 1 | 0 | 0) | 0 | 0;
  }
  label$2 : {
   if (FLAC__bitwriter_write_zeroes($0 | 0, $1 | 0) | 0) {
    break label$2
   }
   return 0 | 0;
  }
  return (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, 1 | 0, 1 | 0) | 0 | 0) != (0 | 0) | 0;
 }
 
 function FLAC__bitwriter_write_rice_signed_block($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $10 = 0, $11 = 0, $8 = 0, $4 = 0, $12 = 0, $9 = 0, $5 = 0, $6 = 0, $7 = 0;
  $4 = 1;
  label$1 : {
   if (!$2) {
    break label$1
   }
   $5 = $3 + 1 | 0;
   $6 = -1 << $3 | 0;
   $7 = -1 >>> (31 - $3 | 0) | 0;
   label$2 : while (1) {
    $8 = HEAP32[$1 >> 2] | 0;
    $9 = ($8 << 1 | 0) ^ ($8 >> 31 | 0) | 0;
    $8 = $9 >>> $3 | 0;
    $10 = $8 + $5 | 0;
    label$3 : {
     label$4 : {
      $11 = HEAP32[($0 + 16 | 0) >> 2] | 0;
      if (!$11) {
       break label$4
      }
      $4 = $10 + $11 | 0;
      if ($4 >>> 0 > 31 >>> 0) {
       break label$4
      }
      HEAP32[($0 + 16 | 0) >> 2] = $4;
      HEAP32[($0 + 4 | 0) >> 2] = (HEAP32[($0 + 4 | 0) >> 2] | 0) << $10 | 0 | (($9 | $6 | 0) & $7 | 0) | 0;
      break label$3;
     }
     label$5 : {
      $4 = HEAP32[($0 + 8 | 0) >> 2] | 0;
      $12 = HEAP32[($0 + 12 | 0) >> 2] | 0;
      if ($4 >>> 0 > ((($11 + $8 | 0) + $12 | 0) + 1 | 0) >>> 0) {
       break label$5
      }
      $11 = $12 + ((($10 + $11 | 0) + 31 | 0) >>> 5 | 0) | 0;
      if ($11 >>> 0 <= $4 >>> 0) {
       break label$5
      }
      $12 = HEAP32[$0 >> 2] | 0;
      label$6 : {
       label$7 : {
        $10 = ($11 - $4 | 0) & 1023 | 0;
        $11 = ($10 ? 1024 - $10 | 0 : 0) + $11 | 0;
        if (!$11) {
         break label$7
        }
        $4 = 0;
        if ($11 >>> 0 > 1073741823 >>> 0) {
         break label$1
        }
        $10 = dlrealloc($12 | 0, $11 << 2 | 0 | 0) | 0;
        if ($10) {
         break label$6
        }
        dlfree($12 | 0);
        return 0 | 0;
       }
       $4 = 0;
       $10 = dlrealloc($12 | 0, 0 | 0) | 0;
       if (!$10) {
        break label$1
       }
      }
      HEAP32[($0 + 8 | 0) >> 2] = $11;
      HEAP32[$0 >> 2] = $10;
     }
     label$8 : {
      if (!$8) {
       break label$8
      }
      label$9 : {
       label$10 : {
        $11 = HEAP32[($0 + 16 | 0) >> 2] | 0;
        if (!$11) {
         break label$10
        }
        $10 = HEAP32[($0 + 4 | 0) >> 2] | 0;
        label$11 : {
         $4 = 32 - $11 | 0;
         if ($8 >>> 0 >= $4 >>> 0) {
          break label$11
         }
         HEAP32[($0 + 4 | 0) >> 2] = $10 << $8 | 0;
         $8 = $11 + $8 | 0;
         break label$9;
        }
        $11 = $10 << $4 | 0;
        HEAP32[($0 + 4 | 0) >> 2] = $11;
        $10 = HEAP32[($0 + 12 | 0) >> 2] | 0;
        HEAP32[($0 + 12 | 0) >> 2] = $10 + 1 | 0;
        HEAP32[((HEAP32[$0 >> 2] | 0) + ($10 << 2 | 0) | 0) >> 2] = $11 << 24 | 0 | (($11 << 8 | 0) & 16711680 | 0) | 0 | (($11 >>> 8 | 0) & 65280 | 0 | ($11 >>> 24 | 0) | 0) | 0;
        HEAP32[($0 + 16 | 0) >> 2] = 0;
        $8 = $8 - $4 | 0;
       }
       label$12 : {
        if ($8 >>> 0 < 32 >>> 0) {
         break label$12
        }
        $11 = HEAP32[$0 >> 2] | 0;
        label$13 : {
         $12 = $8 + -32 | 0;
         $10 = (($12 >>> 5 | 0) + 1 | 0) & 3 | 0;
         if (!$10) {
          break label$13
         }
         label$14 : while (1) {
          $4 = HEAP32[($0 + 12 | 0) >> 2] | 0;
          HEAP32[($0 + 12 | 0) >> 2] = $4 + 1 | 0;
          HEAP32[($11 + ($4 << 2 | 0) | 0) >> 2] = 0;
          $8 = $8 + -32 | 0;
          $10 = $10 + -1 | 0;
          if ($10) {
           continue label$14
          }
          break label$14;
         };
        }
        if ($12 >>> 0 < 96 >>> 0) {
         break label$12
        }
        label$15 : while (1) {
         $10 = HEAP32[($0 + 12 | 0) >> 2] | 0;
         HEAP32[($0 + 12 | 0) >> 2] = $10 + 1 | 0;
         HEAP32[($11 + ($10 << 2 | 0) | 0) >> 2] = 0;
         $10 = HEAP32[($0 + 12 | 0) >> 2] | 0;
         HEAP32[($0 + 12 | 0) >> 2] = $10 + 1 | 0;
         HEAP32[($11 + ($10 << 2 | 0) | 0) >> 2] = 0;
         $10 = HEAP32[($0 + 12 | 0) >> 2] | 0;
         HEAP32[($0 + 12 | 0) >> 2] = $10 + 1 | 0;
         HEAP32[($11 + ($10 << 2 | 0) | 0) >> 2] = 0;
         $10 = HEAP32[($0 + 12 | 0) >> 2] | 0;
         HEAP32[($0 + 12 | 0) >> 2] = $10 + 1 | 0;
         HEAP32[($11 + ($10 << 2 | 0) | 0) >> 2] = 0;
         $8 = $8 + -128 | 0;
         if ($8 >>> 0 > 31 >>> 0) {
          continue label$15
         }
         break label$15;
        };
       }
       if (!$8) {
        break label$8
       }
       HEAP32[($0 + 4 | 0) >> 2] = 0;
      }
      HEAP32[($0 + 16 | 0) >> 2] = $8;
     }
     $8 = ($9 | $6 | 0) & $7 | 0;
     $11 = HEAP32[($0 + 4 | 0) >> 2] | 0;
     label$16 : {
      $4 = HEAP32[($0 + 16 | 0) >> 2] | 0;
      $10 = 32 - $4 | 0;
      if ($5 >>> 0 >= $10 >>> 0) {
       break label$16
      }
      HEAP32[($0 + 16 | 0) >> 2] = $4 + $5 | 0;
      HEAP32[($0 + 4 | 0) >> 2] = $11 << $5 | 0 | $8 | 0;
      break label$3;
     }
     $4 = $5 - $10 | 0;
     HEAP32[($0 + 16 | 0) >> 2] = $4;
     $9 = HEAP32[($0 + 12 | 0) >> 2] | 0;
     HEAP32[($0 + 12 | 0) >> 2] = $9 + 1 | 0;
     $11 = $11 << $10 | 0 | ($8 >>> $4 | 0) | 0;
     HEAP32[((HEAP32[$0 >> 2] | 0) + ($9 << 2 | 0) | 0) >> 2] = $11 << 24 | 0 | (($11 << 8 | 0) & 16711680 | 0) | 0 | (($11 >>> 8 | 0) & 65280 | 0 | ($11 >>> 24 | 0) | 0) | 0;
     HEAP32[($0 + 4 | 0) >> 2] = $8;
    }
    $1 = $1 + 4 | 0;
    $2 = $2 + -1 | 0;
    if ($2) {
     continue label$2
    }
    break label$2;
   };
   $4 = 1;
  }
  return $4 | 0;
 }
 
 function FLAC__bitwriter_write_utf8_uint32($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $2 = 0;
  label$1 : {
   if (($1 | 0) < (0 | 0)) {
    break label$1
   }
   label$2 : {
    if ($1 >>> 0 > 127 >>> 0) {
     break label$2
    }
    return FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 | 0, 8 | 0) | 0 | 0;
   }
   label$3 : {
    if ($1 >>> 0 > 2047 >>> 0) {
     break label$3
    }
    return ((FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 >>> 6 | 0 | 192 | 0 | 0, 8 | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   label$4 : {
    if ($1 >>> 0 > 65535 >>> 0) {
     break label$4
    }
    return (((FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 >>> 12 | 0 | 224 | 0 | 0, 8 | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   label$5 : {
    if ($1 >>> 0 > 2097151 >>> 0) {
     break label$5
    }
    return ((((FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 >>> 18 | 0 | 240 | 0 | 0, 8 | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 12 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   label$6 : {
    if ($1 >>> 0 > 67108863 >>> 0) {
     break label$6
    }
    return (((((FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 >>> 24 | 0 | 248 | 0 | 0, 8 | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 18 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 12 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   $2 = ((((((FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 >>> 30 | 0 | 252 | 0 | 0, 8 | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 24 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 18 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 12 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0;
  }
  return $2 | 0;
 }
 
 function FLAC__bitwriter_write_utf8_uint64($0, $1, $1$hi) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  var i64toi32_i32$3 = 0, i64toi32_i32$1 = 0, i64toi32_i32$4 = 0, i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, $2 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $13 = 0, $18 = 0, $29 = 0, $34 = 0, $53 = 0, $58 = 0, $84 = 0, $89 = 0, $122 = 0, $127 = 0, $166 = 0, $167 = 0, $173 = 0;
  $2 = 0;
  label$1 : {
   i64toi32_i32$0 = $1$hi;
   i64toi32_i32$2 = $1;
   i64toi32_i32$1 = 15;
   i64toi32_i32$3 = -1;
   if (i64toi32_i32$0 >>> 0 > i64toi32_i32$1 >>> 0 | ((i64toi32_i32$0 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$2 >>> 0 > i64toi32_i32$3 >>> 0 | 0) | 0) {
    break label$1
   }
   label$2 : {
    i64toi32_i32$2 = $1$hi;
    i64toi32_i32$3 = $1;
    i64toi32_i32$0 = 0;
    i64toi32_i32$1 = 127;
    if (i64toi32_i32$2 >>> 0 > i64toi32_i32$0 >>> 0 | ((i64toi32_i32$2 | 0) == (i64toi32_i32$0 | 0) & i64toi32_i32$3 >>> 0 > i64toi32_i32$1 >>> 0 | 0) | 0) {
     break label$2
    }
    i64toi32_i32$3 = $1$hi;
    return FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 | 0, 8 | 0) | 0 | 0;
   }
   label$3 : {
    i64toi32_i32$3 = $1$hi;
    i64toi32_i32$1 = $1;
    i64toi32_i32$2 = 0;
    i64toi32_i32$0 = 2047;
    if (i64toi32_i32$3 >>> 0 > i64toi32_i32$2 >>> 0 | ((i64toi32_i32$3 | 0) == (i64toi32_i32$2 | 0) & i64toi32_i32$1 >>> 0 > i64toi32_i32$0 >>> 0 | 0) | 0) {
     break label$3
    }
    $13 = $0;
    i64toi32_i32$1 = $1$hi;
    i64toi32_i32$0 = $1;
    i64toi32_i32$3 = 0;
    i64toi32_i32$2 = 6;
    i64toi32_i32$4 = i64toi32_i32$2 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$2 & 63 | 0) >>> 0) {
     i64toi32_i32$3 = 0;
     $22 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    } else {
     i64toi32_i32$3 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
     $22 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
    }
    $18 = FLAC__bitwriter_write_raw_uint32_nocheck($13 | 0, $22 | 192 | 0 | 0, 8 | 0) | 0;
    i64toi32_i32$3 = $1$hi;
    return ($18 & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   label$4 : {
    i64toi32_i32$3 = $1$hi;
    i64toi32_i32$1 = $1;
    i64toi32_i32$0 = 0;
    i64toi32_i32$2 = 65535;
    if (i64toi32_i32$3 >>> 0 > i64toi32_i32$0 >>> 0 | ((i64toi32_i32$3 | 0) == (i64toi32_i32$0 | 0) & i64toi32_i32$1 >>> 0 > i64toi32_i32$2 >>> 0 | 0) | 0) {
     break label$4
    }
    $29 = $0;
    i64toi32_i32$1 = $1$hi;
    i64toi32_i32$2 = $1;
    i64toi32_i32$3 = 0;
    i64toi32_i32$0 = 12;
    i64toi32_i32$4 = i64toi32_i32$0 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$0 & 63 | 0) >>> 0) {
     i64toi32_i32$3 = 0;
     $23 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    } else {
     i64toi32_i32$3 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
     $23 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
    }
    $34 = FLAC__bitwriter_write_raw_uint32_nocheck($29 | 0, $23 | 224 | 0 | 0, 8 | 0) | 0;
    i64toi32_i32$3 = $1$hi;
    $2 = $1;
    return (($34 & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   label$5 : {
    i64toi32_i32$3 = $1$hi;
    i64toi32_i32$1 = $1;
    i64toi32_i32$2 = 0;
    i64toi32_i32$0 = 2097151;
    if (i64toi32_i32$3 >>> 0 > i64toi32_i32$2 >>> 0 | ((i64toi32_i32$3 | 0) == (i64toi32_i32$2 | 0) & i64toi32_i32$1 >>> 0 > i64toi32_i32$0 >>> 0 | 0) | 0) {
     break label$5
    }
    $53 = $0;
    i64toi32_i32$1 = $1$hi;
    i64toi32_i32$0 = $1;
    i64toi32_i32$3 = 0;
    i64toi32_i32$2 = 18;
    i64toi32_i32$4 = i64toi32_i32$2 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$2 & 63 | 0) >>> 0) {
     i64toi32_i32$3 = 0;
     $24 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    } else {
     i64toi32_i32$3 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
     $24 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
    }
    $58 = FLAC__bitwriter_write_raw_uint32_nocheck($53 | 0, $24 | 240 | 0 | 0, 8 | 0) | 0;
    i64toi32_i32$3 = $1$hi;
    $2 = $1;
    return ((($58 & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 12 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   label$6 : {
    i64toi32_i32$3 = $1$hi;
    i64toi32_i32$1 = $1;
    i64toi32_i32$0 = 0;
    i64toi32_i32$2 = 67108863;
    if (i64toi32_i32$3 >>> 0 > i64toi32_i32$0 >>> 0 | ((i64toi32_i32$3 | 0) == (i64toi32_i32$0 | 0) & i64toi32_i32$1 >>> 0 > i64toi32_i32$2 >>> 0 | 0) | 0) {
     break label$6
    }
    $84 = $0;
    i64toi32_i32$1 = $1$hi;
    i64toi32_i32$2 = $1;
    i64toi32_i32$3 = 0;
    i64toi32_i32$0 = 24;
    i64toi32_i32$4 = i64toi32_i32$0 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$0 & 63 | 0) >>> 0) {
     i64toi32_i32$3 = 0;
     $25 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    } else {
     i64toi32_i32$3 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
     $25 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
    }
    $89 = FLAC__bitwriter_write_raw_uint32_nocheck($84 | 0, $25 | 248 | 0 | 0, 8 | 0) | 0;
    i64toi32_i32$3 = $1$hi;
    $2 = $1;
    return (((($89 & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 18 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 12 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   label$7 : {
    i64toi32_i32$3 = $1$hi;
    i64toi32_i32$1 = $1;
    i64toi32_i32$2 = 0;
    i64toi32_i32$0 = 2147483647;
    if (i64toi32_i32$3 >>> 0 > i64toi32_i32$2 >>> 0 | ((i64toi32_i32$3 | 0) == (i64toi32_i32$2 | 0) & $1 >>> 0 > i64toi32_i32$0 >>> 0 | 0) | 0) {
     break label$7
    }
    $122 = $0;
    i64toi32_i32$1 = $1$hi;
    i64toi32_i32$0 = $1;
    i64toi32_i32$3 = 0;
    i64toi32_i32$2 = 30;
    i64toi32_i32$4 = i64toi32_i32$2 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$2 & 63 | 0) >>> 0) {
     i64toi32_i32$3 = 0;
     $26 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
    } else {
     i64toi32_i32$3 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
     $26 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
    }
    $127 = FLAC__bitwriter_write_raw_uint32_nocheck($122 | 0, $26 | 252 | 0 | 0, 8 | 0) | 0;
    i64toi32_i32$3 = $1$hi;
    $2 = $1;
    return ((((($127 & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 24 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 18 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 12 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0 | 0;
   }
   $166 = FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, 254 | 0, 8 | 0) | 0;
   $167 = $0;
   i64toi32_i32$3 = $1$hi;
   i64toi32_i32$1 = $1;
   i64toi32_i32$0 = 0;
   i64toi32_i32$2 = 30;
   i64toi32_i32$4 = i64toi32_i32$2 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$2 & 63 | 0) >>> 0) {
    i64toi32_i32$0 = 0;
    $27 = i64toi32_i32$3 >>> i64toi32_i32$4 | 0;
   } else {
    i64toi32_i32$0 = i64toi32_i32$3 >>> i64toi32_i32$4 | 0;
    $27 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$3 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$4 | 0) | 0;
   }
   $173 = $166 & (FLAC__bitwriter_write_raw_uint32_nocheck($167 | 0, $27 | 128 | 0 | 0, 8 | 0) | 0) | 0;
   i64toi32_i32$0 = $1$hi;
   $2 = $1;
   $2 = ((((($173 & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 24 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 18 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 12 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, ($1 >>> 6 | 0) & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & (FLAC__bitwriter_write_raw_uint32_nocheck($0 | 0, $1 & 63 | 0 | 128 | 0 | 0, 8 | 0) | 0) | 0) & 1 | 0;
  }
  return $2 | 0;
 }
 
 function FLAC__bitwriter_zero_pad_to_byte_boundary($0) {
  $0 = $0 | 0;
  var $1 = 0;
  label$1 : {
   $1 = (HEAP32[($0 + 16 | 0) >> 2] | 0) & 7 | 0;
   if ($1) {
    break label$1
   }
   return 1 | 0;
  }
  return FLAC__bitwriter_write_zeroes($0 | 0, 8 - $1 | 0 | 0) | 0 | 0;
 }
 
 function FLAC__ogg_encoder_aspect_init($0) {
  $0 = $0 | 0;
  var i64toi32_i32$0 = 0, $1 = 0;
  $1 = 0;
  label$1 : {
   if (ogg_stream_init($0 + 8 | 0 | 0, HEAP32[$0 >> 2] | 0 | 0) | 0) {
    break label$1
   }
   i64toi32_i32$0 = 0;
   HEAP32[($0 + 392 | 0) >> 2] = 0;
   HEAP32[($0 + 396 | 0) >> 2] = i64toi32_i32$0;
   i64toi32_i32$0 = 1;
   HEAP32[($0 + 384 | 0) >> 2] = 0;
   HEAP32[($0 + 388 | 0) >> 2] = i64toi32_i32$0;
   $1 = 1;
  }
  return $1 | 0;
 }
 
 function FLAC__ogg_encoder_aspect_finish($0) {
  $0 = $0 | 0;
  ogg_stream_clear($0 + 8 | 0 | 0) | 0;
 }
 
 function FLAC__ogg_encoder_aspect_set_serial_number($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  HEAP32[$0 >> 2] = $1;
 }
 
 function FLAC__ogg_encoder_aspect_set_num_metadata($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $2 = 0;
  label$1 : {
   if ($1 >>> (HEAP32[GOT_data_internal_FLAC__OGG_MAPPING_NUM_HEADERS_LEN >> 2] | 0) | 0) {
    break label$1
   }
   HEAP32[($0 + 4 | 0) >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__ogg_encoder_aspect_set_defaults($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0;
  i64toi32_i32$1 = $0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = 0;
 }
 
 function FLAC__ogg_encoder_aspect_write_callback_wrapper($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  $7 = $7 | 0;
  $8 = $8 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$5 = 0, i64toi32_i32$2 = 0, $9 = 0, i64toi32_i32$0 = 0, i64toi32_i32$4 = 0, $11$hi = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, i64toi32_i32$3 = 0, $10 = 0, $11 = 0, $36 = 0, $26 = 0, $28$hi = 0, $61 = 0, $66 = 0, $71 = 0, $76 = 0, $79 = 0, $157 = 0, $159$hi = 0;
  $9 = __stack_pointer - 96 | 0;
  __stack_pointer = $9;
  label$1 : {
   label$2 : {
    label$3 : {
     if (!(HEAP32[($0 + 384 | 0) >> 2] | 0)) {
      break label$3
     }
     i64toi32_i32$1 = $9 + 72 | 0;
     i64toi32_i32$0 = 0;
     HEAP32[i64toi32_i32$1 >> 2] = 0;
     HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
     $10 = $9 + 80 | 0;
     i64toi32_i32$1 = $10;
     i64toi32_i32$0 = 0;
     HEAP32[i64toi32_i32$1 >> 2] = 0;
     HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
     i64toi32_i32$1 = $9 + 88 | 0;
     i64toi32_i32$0 = 0;
     HEAP32[i64toi32_i32$1 >> 2] = 0;
     HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
     i64toi32_i32$1 = $9;
     i64toi32_i32$0 = 0;
     HEAP32[(i64toi32_i32$1 + 64 | 0) >> 2] = 0;
     HEAP32[(i64toi32_i32$1 + 68 | 0) >> 2] = i64toi32_i32$0;
     $26 = $10;
     i64toi32_i32$2 = $0;
     i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 392 | 0) >> 2] | 0;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 396 | 0) >> 2] | 0;
     $28$hi = i64toi32_i32$1;
     i64toi32_i32$1 = 0;
     $11 = $3;
     $11$hi = i64toi32_i32$1;
     i64toi32_i32$1 = $28$hi;
     i64toi32_i32$2 = i64toi32_i32$0;
     i64toi32_i32$0 = $11$hi;
     i64toi32_i32$3 = $3;
     i64toi32_i32$4 = i64toi32_i32$2 + $3 | 0;
     i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$0 | 0;
     if (i64toi32_i32$4 >>> 0 < $3 >>> 0) {
      i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
     }
     i64toi32_i32$2 = $26;
     HEAP32[i64toi32_i32$2 >> 2] = i64toi32_i32$4;
     HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] = i64toi32_i32$5;
     label$4 : {
      label$5 : {
       label$6 : {
        if (!(HEAP32[($0 + 388 | 0) >> 2] | 0)) {
         break label$6
        }
        if (($2 | 0) != (38 | 0)) {
         break label$4
        }
        HEAP8[$9 >> 0] = HEAPU8[GOT_data_internal_FLAC__OGG_MAPPING_FIRST_HEADER_PACKET_TYPE >> 0] | 0;
        $28 = HEAP32[GOT_data_internal_FLAC__OGG_MAPPING_MAGIC >> 2] | 0;
        $2 = HEAPU8[$28 >> 0] | 0 | ((HEAPU8[($28 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($28 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($28 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        $36 = 1;
        HEAP8[($9 + 5 | 0) >> 0] = $36;
        HEAP8[($9 + 6 | 0) >> 0] = $36 >>> 8 | 0;
        HEAP8[($9 + 1 | 0) >> 0] = $2;
        HEAP8[($9 + 2 | 0) >> 0] = $2 >>> 8 | 0;
        HEAP8[($9 + 3 | 0) >> 0] = $2 >>> 16 | 0;
        HEAP8[($9 + 4 | 0) >> 0] = $2 >>> 24 | 0;
        $2 = HEAP32[($0 + 4 | 0) >> 2] | 0;
        $29 = GOT_data_internal_FLAC__STREAM_SYNC_STRING;
        $30 = HEAPU8[$29 >> 0] | 0 | ((HEAPU8[($29 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($29 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($29 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        HEAP8[($9 + 9 | 0) >> 0] = $30;
        HEAP8[($9 + 10 | 0) >> 0] = $30 >>> 8 | 0;
        HEAP8[($9 + 11 | 0) >> 0] = $30 >>> 16 | 0;
        HEAP8[($9 + 12 | 0) >> 0] = $30 >>> 24 | 0;
        HEAP8[($9 + 8 | 0) >> 0] = $2;
        HEAP8[($9 + 7 | 0) >> 0] = $2 >>> 8 | 0;
        i64toi32_i32$1 = $1 + 30 | 0;
        i64toi32_i32$5 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        i64toi32_i32$2 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        $61 = i64toi32_i32$5;
        i64toi32_i32$5 = $9 + 43 | 0;
        $31 = $61;
        HEAP8[i64toi32_i32$5 >> 0] = $31;
        HEAP8[(i64toi32_i32$5 + 1 | 0) >> 0] = $31 >>> 8 | 0;
        HEAP8[(i64toi32_i32$5 + 2 | 0) >> 0] = $31 >>> 16 | 0;
        HEAP8[(i64toi32_i32$5 + 3 | 0) >> 0] = $31 >>> 24 | 0;
        HEAP8[(i64toi32_i32$5 + 4 | 0) >> 0] = i64toi32_i32$2;
        HEAP8[(i64toi32_i32$5 + 5 | 0) >> 0] = i64toi32_i32$2 >>> 8 | 0;
        HEAP8[(i64toi32_i32$5 + 6 | 0) >> 0] = i64toi32_i32$2 >>> 16 | 0;
        HEAP8[(i64toi32_i32$5 + 7 | 0) >> 0] = i64toi32_i32$2 >>> 24 | 0;
        i64toi32_i32$1 = $1 + 24 | 0;
        i64toi32_i32$2 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        i64toi32_i32$5 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        $66 = i64toi32_i32$2;
        i64toi32_i32$2 = $9 + 37 | 0;
        $32 = $66;
        HEAP8[i64toi32_i32$2 >> 0] = $32;
        HEAP8[(i64toi32_i32$2 + 1 | 0) >> 0] = $32 >>> 8 | 0;
        HEAP8[(i64toi32_i32$2 + 2 | 0) >> 0] = $32 >>> 16 | 0;
        HEAP8[(i64toi32_i32$2 + 3 | 0) >> 0] = $32 >>> 24 | 0;
        HEAP8[(i64toi32_i32$2 + 4 | 0) >> 0] = i64toi32_i32$5;
        HEAP8[(i64toi32_i32$2 + 5 | 0) >> 0] = i64toi32_i32$5 >>> 8 | 0;
        HEAP8[(i64toi32_i32$2 + 6 | 0) >> 0] = i64toi32_i32$5 >>> 16 | 0;
        HEAP8[(i64toi32_i32$2 + 7 | 0) >> 0] = i64toi32_i32$5 >>> 24 | 0;
        i64toi32_i32$1 = $1 + 16 | 0;
        i64toi32_i32$5 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        i64toi32_i32$2 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        $71 = i64toi32_i32$5;
        i64toi32_i32$5 = $9 + 29 | 0;
        $33 = $71;
        HEAP8[i64toi32_i32$5 >> 0] = $33;
        HEAP8[(i64toi32_i32$5 + 1 | 0) >> 0] = $33 >>> 8 | 0;
        HEAP8[(i64toi32_i32$5 + 2 | 0) >> 0] = $33 >>> 16 | 0;
        HEAP8[(i64toi32_i32$5 + 3 | 0) >> 0] = $33 >>> 24 | 0;
        HEAP8[(i64toi32_i32$5 + 4 | 0) >> 0] = i64toi32_i32$2;
        HEAP8[(i64toi32_i32$5 + 5 | 0) >> 0] = i64toi32_i32$2 >>> 8 | 0;
        HEAP8[(i64toi32_i32$5 + 6 | 0) >> 0] = i64toi32_i32$2 >>> 16 | 0;
        HEAP8[(i64toi32_i32$5 + 7 | 0) >> 0] = i64toi32_i32$2 >>> 24 | 0;
        i64toi32_i32$1 = $1 + 8 | 0;
        i64toi32_i32$2 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        i64toi32_i32$5 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        $76 = i64toi32_i32$2;
        i64toi32_i32$2 = $9 + 21 | 0;
        $34 = $76;
        HEAP8[i64toi32_i32$2 >> 0] = $34;
        HEAP8[(i64toi32_i32$2 + 1 | 0) >> 0] = $34 >>> 8 | 0;
        HEAP8[(i64toi32_i32$2 + 2 | 0) >> 0] = $34 >>> 16 | 0;
        HEAP8[(i64toi32_i32$2 + 3 | 0) >> 0] = $34 >>> 24 | 0;
        HEAP8[(i64toi32_i32$2 + 4 | 0) >> 0] = i64toi32_i32$5;
        HEAP8[(i64toi32_i32$2 + 5 | 0) >> 0] = i64toi32_i32$5 >>> 8 | 0;
        HEAP8[(i64toi32_i32$2 + 6 | 0) >> 0] = i64toi32_i32$5 >>> 16 | 0;
        HEAP8[(i64toi32_i32$2 + 7 | 0) >> 0] = i64toi32_i32$5 >>> 24 | 0;
        i64toi32_i32$1 = $1;
        i64toi32_i32$5 = HEAPU8[i64toi32_i32$1 >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        i64toi32_i32$2 = HEAPU8[(i64toi32_i32$1 + 4 | 0) >> 0] | 0 | ((HEAPU8[(i64toi32_i32$1 + 5 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[(i64toi32_i32$1 + 6 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[(i64toi32_i32$1 + 7 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
        $79 = i64toi32_i32$5;
        i64toi32_i32$5 = $9;
        $35 = $79;
        HEAP8[(i64toi32_i32$5 + 13 | 0) >> 0] = $35;
        HEAP8[(i64toi32_i32$5 + 14 | 0) >> 0] = $35 >>> 8 | 0;
        HEAP8[(i64toi32_i32$5 + 15 | 0) >> 0] = $35 >>> 16 | 0;
        HEAP8[(i64toi32_i32$5 + 16 | 0) >> 0] = $35 >>> 24 | 0;
        HEAP8[(i64toi32_i32$5 + 17 | 0) >> 0] = i64toi32_i32$2;
        HEAP8[(i64toi32_i32$5 + 18 | 0) >> 0] = i64toi32_i32$2 >>> 8 | 0;
        HEAP8[(i64toi32_i32$5 + 19 | 0) >> 0] = i64toi32_i32$2 >>> 16 | 0;
        HEAP8[(i64toi32_i32$5 + 20 | 0) >> 0] = i64toi32_i32$2 >>> 24 | 0;
        i64toi32_i32$2 = 1;
        HEAP32[(i64toi32_i32$5 + 68 | 0) >> 2] = 51;
        HEAP32[(i64toi32_i32$5 + 72 | 0) >> 2] = i64toi32_i32$2;
        HEAP32[(i64toi32_i32$5 + 64 | 0) >> 2] = i64toi32_i32$5;
        HEAP32[($0 + 388 | 0) >> 2] = 0;
        break label$5;
       }
       HEAP32[($9 + 68 | 0) >> 2] = $2;
       HEAP32[($9 + 64 | 0) >> 2] = $1;
      }
      label$7 : {
       if (!$5) {
        break label$7
       }
       HEAP32[($9 + 76 | 0) >> 2] = 1;
      }
      $1 = $0 + 8 | 0;
      if (ogg_stream_packetin($1 | 0, $9 + 64 | 0 | 0) | 0) {
       break label$4
      }
      $2 = $0 + 368 | 0;
      label$8 : {
       if ($3) {
        break label$8
       }
       label$9 : while (1) {
        if (!(ogg_stream_flush($1 | 0, $2 | 0) | 0)) {
         break label$2
        }
        if (FUNCTION_TABLE[$6 | 0]($7, HEAP32[($0 + 368 | 0) >> 2] | 0, HEAP32[($0 + 372 | 0) >> 2] | 0, 0, $4, $8) | 0) {
         break label$4
        }
        if (!(FUNCTION_TABLE[$6 | 0]($7, HEAP32[($0 + 376 | 0) >> 2] | 0, HEAP32[($0 + 380 | 0) >> 2] | 0, 0, $4, $8) | 0)) {
         continue label$9
        }
        break label$4;
       };
      }
      label$10 : while (1) {
       if (!(ogg_stream_pageout($1 | 0, $2 | 0) | 0)) {
        break label$2
       }
       if (FUNCTION_TABLE[$6 | 0]($7, HEAP32[($0 + 368 | 0) >> 2] | 0, HEAP32[($0 + 372 | 0) >> 2] | 0, 0, $4, $8) | 0) {
        break label$4
       }
       if (!(FUNCTION_TABLE[$6 | 0]($7, HEAP32[($0 + 376 | 0) >> 2] | 0, HEAP32[($0 + 380 | 0) >> 2] | 0, 0, $4, $8) | 0)) {
        continue label$10
       }
       break label$10;
      };
     }
     $6 = 1;
     break label$1;
    }
    $6 = 1;
    if ($3) {
     break label$1
    }
    if ($4) {
     break label$1
    }
    if (($2 | 0) != (4 | 0)) {
     break label$1
    }
    $4 = GOT_data_internal_FLAC__STREAM_SYNC_STRING;
    if ((HEAPU8[$1 >> 0] | 0 | ((HEAPU8[($1 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($1 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($1 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0) != (HEAPU8[$4 >> 0] | 0 | ((HEAPU8[($4 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($4 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($4 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0)) {
     break label$1
    }
    HEAP32[($0 + 384 | 0) >> 2] = 1;
    i64toi32_i32$2 = 0;
    $11 = 0;
    $11$hi = i64toi32_i32$2;
   }
   $157 = $0;
   i64toi32_i32$1 = $0;
   i64toi32_i32$2 = HEAP32[(i64toi32_i32$1 + 392 | 0) >> 2] | 0;
   i64toi32_i32$5 = HEAP32[(i64toi32_i32$1 + 396 | 0) >> 2] | 0;
   $159$hi = i64toi32_i32$5;
   i64toi32_i32$5 = $11$hi;
   i64toi32_i32$5 = $159$hi;
   i64toi32_i32$1 = i64toi32_i32$2;
   i64toi32_i32$2 = $11$hi;
   i64toi32_i32$3 = $11;
   i64toi32_i32$0 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
   i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$2 | 0;
   if (i64toi32_i32$0 >>> 0 < i64toi32_i32$3 >>> 0) {
    i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
   }
   i64toi32_i32$1 = $157;
   HEAP32[(i64toi32_i32$1 + 392 | 0) >> 2] = i64toi32_i32$0;
   HEAP32[(i64toi32_i32$1 + 396 | 0) >> 2] = i64toi32_i32$4;
   $6 = 0;
  }
  __stack_pointer = $9 + 96 | 0;
  return $6 | 0;
 }
 
 function simple_ogg_page__init($0) {
  $0 = $0 | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0;
  i64toi32_i32$1 = $0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = i64toi32_i32$1 + 8 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
 }
 
 function simple_ogg_page__clear($0) {
  $0 = $0 | 0;
  var $1 = 0, i64toi32_i32$1 = 0, i64toi32_i32$0 = 0;
  label$1 : {
   $1 = HEAP32[$0 >> 2] | 0;
   if (!$1) {
    break label$1
   }
   dlfree($1 | 0);
  }
  label$2 : {
   $1 = HEAP32[($0 + 8 | 0) >> 2] | 0;
   if (!$1) {
    break label$2
   }
   dlfree($1 | 0);
  }
  i64toi32_i32$1 = $0;
  i64toi32_i32$0 = 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[($0 + 4 | 0) >> 2] = i64toi32_i32$0;
  i64toi32_i32$1 = $0 + 8 | 0;
  i64toi32_i32$0 = 0;
  HEAP32[i64toi32_i32$1 >> 2] = 0;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$0;
 }
 
 function simple_ogg_page__get_at($0, $1, $1$hi, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $8 = 0, $9 = 0, $6 = 0, $7 = 0, i64toi32_i32$0 = 0, $14 = 0, $15 = 0, i64toi32_i32$1 = 0, i64toi32_i32$2 = 0;
  $6 = __stack_pointer - 16 | 0;
  __stack_pointer = $6;
  $7 = 0;
  label$1 : {
   if (!$3) {
    break label$1
   }
   label$2 : {
    label$3 : {
     i64toi32_i32$0 = $1$hi;
     switch (FUNCTION_TABLE[$3 | 0]($0, $1, i64toi32_i32$0, $5) | 0 | 0) {
     case 0:
      break label$2;
     case 1:
      break label$3;
     default:
      break label$1;
     };
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 5;
    break label$1;
   }
   $3 = dlmalloc(282 | 0) | 0;
   HEAP32[$2 >> 2] = $3;
   label$4 : {
    if ($3) {
     break label$4
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
    break label$1;
   }
   $8 = 27;
   label$5 : while (1) {
    HEAP32[($6 + 12 | 0) >> 2] = $8;
    $9 = 5;
    label$6 : {
     label$7 : {
      switch (FUNCTION_TABLE[$4 | 0]($0, $3, $6 + 12 | 0, $5) | 0 | 0) {
      case 1:
       $9 = HEAP32[($6 + 12 | 0) >> 2] | 0;
       if ($9) {
        break label$6
       }
       $9 = 2;
      default:
       HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = $9;
       break label$1;
      case 3:
       break label$1;
      case 0:
       break label$7;
      };
     }
     $9 = HEAP32[($6 + 12 | 0) >> 2] | 0;
    }
    $3 = $3 + $9 | 0;
    $8 = $8 - $9 | 0;
    if ($8) {
     continue label$5
    }
    break label$5;
   };
   $3 = HEAP32[$2 >> 2] | 0;
   HEAP32[($2 + 4 | 0) >> 2] = (HEAPU8[($3 + 26 | 0) >> 0] | 0) + 27 | 0;
   label$10 : {
    label$11 : {
     if ((HEAPU8[$3 >> 0] | 0 | ((HEAPU8[($3 + 1 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($3 + 2 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($3 + 3 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0) != (1399285583 | 0)) {
      break label$11
     }
     if ((HEAPU8[($3 + 5 | 0) >> 0] | 0) & 1 | 0) {
      break label$11
     }
     i64toi32_i32$0 = HEAPU8[($3 + 6 | 0) >> 0] | 0 | ((HEAPU8[($3 + 7 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($3 + 8 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($3 + 9 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
     i64toi32_i32$1 = HEAPU8[($3 + 10 | 0) >> 0] | 0 | ((HEAPU8[($3 + 11 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($3 + 12 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($3 + 13 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
     i64toi32_i32$2 = i64toi32_i32$0;
     i64toi32_i32$0 = 0;
     if ((i64toi32_i32$2 | 0) != (0 | 0) | (i64toi32_i32$1 | 0) != (i64toi32_i32$0 | 0) | 0) {
      break label$11
     }
     $8 = HEAPU8[($3 + 26 | 0) >> 0] | 0;
     if ($8) {
      break label$10
     }
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
    break label$1;
   }
   if (!(full_read_($0 | 0, $3 + 27 | 0 | 0, $8 | 0, $4 | 0, $5 | 0) | 0)) {
    break label$1
   }
   label$12 : {
    $8 = HEAP32[$2 >> 2] | 0;
    $7 = HEAPU8[($8 + 26 | 0) >> 0] | 0;
    $9 = $7 + -1 | 0;
    if (!$9) {
     break label$12
    }
    $3 = 0;
    label$13 : while (1) {
     label$14 : {
      if ((HEAPU8[(($3 + $8 | 0) + 27 | 0) >> 0] | 0 | 0) == (255 | 0)) {
       break label$14
      }
      HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
      $7 = 0;
      break label$1;
     }
     $3 = $3 + 1 | 0;
     if (($3 | 0) != ($9 | 0)) {
      continue label$13
     }
     break label$13;
    };
   }
   $3 = Math_imul($9, 255) + (HEAPU8[(($7 + $8 | 0) + 26 | 0) >> 0] | 0) | 0;
   HEAP32[($2 + 12 | 0) >> 2] = $3;
   $8 = dlmalloc(($3 ? $3 : 1) | 0) | 0;
   HEAP32[($2 + 8 | 0) >> 2] = $8;
   label$15 : {
    if ($8) {
     break label$15
    }
    HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 8;
    $7 = 0;
    break label$1;
   }
   $7 = 0;
   if (!(full_read_($0 | 0, $8 | 0, $3 | 0, $4 | 0, $5 | 0) | 0)) {
    break label$1
   }
   $14 = HEAP32[$2 >> 2] | 0;
   HEAP32[($6 + 8 | 0) >> 2] = HEAPU8[($14 + 22 | 0) >> 0] | 0 | ((HEAPU8[($14 + 23 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($14 + 24 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($14 + 25 | 0) >> 0] | 0) << 24 | 0) | 0) | 0;
   ogg_page_checksum_set($2 | 0);
   label$16 : {
    $15 = HEAP32[$2 >> 2] | 0;
    if ((HEAP32[($6 + 8 | 0) >> 2] | 0 | 0) != (HEAPU8[($15 + 22 | 0) >> 0] | 0 | ((HEAPU8[($15 + 23 | 0) >> 0] | 0) << 8 | 0) | 0 | ((HEAPU8[($15 + 24 | 0) >> 0] | 0) << 16 | 0 | ((HEAPU8[($15 + 25 | 0) >> 0] | 0) << 24 | 0) | 0) | 0 | 0)) {
     break label$16
    }
    $7 = 1;
    break label$1;
   }
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 2;
  }
  __stack_pointer = $6 + 16 | 0;
  return $7 | 0;
 }
 
 function full_read_($0, $1, $2, $3, $4) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  var $7 = 0, $5 = 0, $6 = 0;
  $5 = __stack_pointer - 16 | 0;
  __stack_pointer = $5;
  $6 = 1;
  label$1 : {
   if (!$2) {
    break label$1
   }
   label$2 : while (1) {
    HEAP32[($5 + 12 | 0) >> 2] = $2;
    $7 = 5;
    label$3 : {
     label$4 : {
      switch (FUNCTION_TABLE[$3 | 0]($0, $1, $5 + 12 | 0, $4) | 0 | 0) {
      case 1:
       $7 = HEAP32[($5 + 12 | 0) >> 2] | 0;
       if ($7) {
        break label$3
       }
       $7 = 2;
      default:
       HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = $7;
      case 3:
       $6 = 0;
       break label$1;
      case 0:
       break label$4;
      };
     }
     $7 = HEAP32[($5 + 12 | 0) >> 2] | 0;
    }
    $1 = $1 + $7 | 0;
    $2 = $2 - $7 | 0;
    if ($2) {
     continue label$2
    }
    break label$2;
   };
  }
  __stack_pointer = $5 + 16 | 0;
  return $6 | 0;
 }
 
 function simple_ogg_page__set_at($0, $1, $1$hi, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var i64toi32_i32$0 = 0;
  label$1 : {
   if (!$3) {
    break label$1
   }
   label$2 : {
    label$3 : {
     i64toi32_i32$0 = $1$hi;
     switch (FUNCTION_TABLE[$3 | 0]($0, $1, i64toi32_i32$0, $5) | 0 | 0) {
     case 1:
      break label$2;
     case 0:
      break label$3;
     default:
      break label$1;
     };
    }
    ogg_page_checksum_set($2 | 0);
    if (FUNCTION_TABLE[$4 | 0]($0, HEAP32[$2 >> 2] | 0, HEAP32[($2 + 4 | 0) >> 2] | 0, 0, 0, $5) | 0) {
     break label$2
    }
    if (FUNCTION_TABLE[$4 | 0]($0, HEAP32[($2 + 8 | 0) >> 2] | 0, HEAP32[($2 + 12 | 0) >> 2] | 0, 0, 0, $5) | 0) {
     break label$2
    }
    return 1 | 0;
   }
   HEAP32[(HEAP32[$0 >> 2] | 0) >> 2] = 5;
  }
  return 0 | 0;
 }
 
 function __emscripten_stdout_close($0) {
  $0 = $0 | 0;
  return 0 | 0;
 }
 
 function __emscripten_stdout_seek($0, $1, $1$hi, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  $2 = $2 | 0;
  i64toi32_i32$HIGH_BITS = 0;
  return 0 | 0;
 }
 
 function strcmp($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $3 = 0, $2 = 0;
  $2 = HEAPU8[$1 >> 0] | 0;
  label$1 : {
   $3 = HEAPU8[$0 >> 0] | 0;
   if (!$3) {
    break label$1
   }
   if (($3 | 0) != ($2 & 255 | 0 | 0)) {
    break label$1
   }
   label$2 : while (1) {
    $2 = HEAPU8[($1 + 1 | 0) >> 0] | 0;
    $3 = HEAPU8[($0 + 1 | 0) >> 0] | 0;
    if (!$3) {
     break label$1
    }
    $1 = $1 + 1 | 0;
    $0 = $0 + 1 | 0;
    if (($3 | 0) == ($2 & 255 | 0 | 0)) {
     continue label$2
    }
    break label$2;
   };
  }
  return $3 - ($2 & 255 | 0) | 0 | 0;
 }
 
 function FLAC__add_metadata_block($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, i64toi32_i32$2 = 0, $4 = 0, i64toi32_i32$0 = 0, i64toi32_i32$1 = 0, $5 = 0, $9 = 0, $7 = 0, $8 = 0, $6 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0;
  $2 = GOT_data_internal_FLAC__STREAM_METADATA_IS_LAST_LEN;
  $3 = strlen(HEAP32[GOT_data_internal_FLAC__VENDOR_STRING >> 2] | 0 | 0) | 0;
  $4 = 0;
  label$1 : {
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 4 | 0) >> 2] | 0 | 0, HEAP32[$2 >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[$0 >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_TYPE_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
   label$2 : {
    if ((HEAP32[$0 >> 2] | 0 | 0) != (4 | 0)) {
     break label$2
    }
    $2 = ($2 + $3 | 0) - (HEAP32[($0 + 16 | 0) >> 2] | 0) | 0;
   }
   $5 = HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_LENGTH_LEN >> 2] | 0;
   if ($2 >>> $5 | 0) {
    break label$1
   }
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, $2 | 0, $5 | 0) | 0)) {
    break label$1
   }
   label$3 : {
    label$4 : {
     label$5 : {
      label$6 : {
       label$7 : {
        label$8 : {
         label$9 : {
          switch (HEAP32[$0 >> 2] | 0 | 0) {
          case 3:
           $4 = GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_FRAME_SAMPLES_LEN;
           $2 = GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_STREAM_OFFSET_LEN;
           $3 = GOT_data_internal_FLAC__STREAM_METADATA_SEEKPOINT_SAMPLE_NUMBER_LEN;
           if (!(HEAP32[($0 + 16 | 0) >> 2] | 0)) {
            break label$3
           }
           $6 = HEAP32[$4 >> 2] | 0;
           $7 = HEAP32[$2 >> 2] | 0;
           $5 = HEAP32[$3 >> 2] | 0;
           $2 = 0;
           break label$8;
          case 0:
           if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 16 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MIN_BLOCK_SIZE_LEN >> 2] | 0 | 0) | 0)) {
            break label$1
           }
           if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 20 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MAX_BLOCK_SIZE_LEN >> 2] | 0 | 0) | 0)) {
            break label$1
           }
           if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 24 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MIN_FRAME_SIZE_LEN >> 2] | 0 | 0) | 0)) {
            break label$1
           }
           if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 28 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_MAX_FRAME_SIZE_LEN >> 2] | 0 | 0) | 0)) {
            break label$1
           }
           if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 32 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_SAMPLE_RATE_LEN >> 2] | 0 | 0) | 0)) {
            break label$1
           }
           if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, (HEAP32[($0 + 36 | 0) >> 2] | 0) + -1 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_CHANNELS_LEN >> 2] | 0 | 0) | 0)) {
            break label$1
           }
           if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, (HEAP32[($0 + 40 | 0) >> 2] | 0) + -1 | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_BITS_PER_SAMPLE_LEN >> 2] | 0 | 0) | 0)) {
            break label$1
           }
           i64toi32_i32$2 = $0 + 48 | 0;
           i64toi32_i32$0 = HEAP32[i64toi32_i32$2 >> 2] | 0;
           i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
           if (!(FLAC__bitwriter_write_raw_uint64($1 | 0, i64toi32_i32$0 | 0, i64toi32_i32$1 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_STREAMINFO_TOTAL_SAMPLES_LEN >> 2] | 0 | 0) | 0)) {
            break label$1
           }
           if (FLAC__bitwriter_write_byte_block($1 | 0, $0 + 56 | 0 | 0, 16 | 0) | 0) {
            break label$3
           }
           break label$1;
          case 1:
           if (FLAC__bitwriter_write_zeroes($1 | 0, (HEAP32[($0 + 8 | 0) >> 2] | 0) << 3 | 0 | 0) | 0) {
            break label$3
           }
           break label$1;
          case 6:
           break label$5;
          case 5:
           break label$6;
          case 4:
           break label$7;
          case 2:
           break label$9;
          default:
           break label$4;
          };
         }
         $2 = (HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_APPLICATION_ID_LEN >> 2] | 0) >>> 3 | 0;
         if (!(FLAC__bitwriter_write_byte_block($1 | 0, $0 + 16 | 0 | 0, $2 | 0) | 0)) {
          break label$1
         }
         if (FLAC__bitwriter_write_byte_block($1 | 0, HEAP32[($0 + 20 | 0) >> 2] | 0 | 0, (HEAP32[($0 + 8 | 0) >> 2] | 0) - $2 | 0 | 0) | 0) {
          break label$3
         }
         break label$1;
        }
        label$13 : while (1) {
         $4 = 0;
         $3 = Math_imul($2, 24);
         i64toi32_i32$2 = (HEAP32[($0 + 20 | 0) >> 2] | 0) + $3 | 0;
         i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
         i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
         if (!(FLAC__bitwriter_write_raw_uint64($1 | 0, i64toi32_i32$1 | 0, i64toi32_i32$0 | 0, $5 | 0) | 0)) {
          break label$1
         }
         i64toi32_i32$2 = (HEAP32[($0 + 20 | 0) >> 2] | 0) + $3 | 0;
         i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 8 | 0) >> 2] | 0;
         i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 12 | 0) >> 2] | 0;
         if (!(FLAC__bitwriter_write_raw_uint64($1 | 0, i64toi32_i32$0 | 0, i64toi32_i32$1 | 0, $7 | 0) | 0)) {
          break label$1
         }
         if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[(((HEAP32[($0 + 20 | 0) >> 2] | 0) + $3 | 0) + 16 | 0) >> 2] | 0 | 0, $6 | 0) | 0)) {
          break label$1
         }
         $2 = $2 + 1 | 0;
         if ($2 >>> 0 >= (HEAP32[($0 + 16 | 0) >> 2] | 0) >>> 0) {
          break label$3
         }
         continue label$13;
        };
       }
       if (!(FLAC__bitwriter_write_raw_uint32_little_endian($1 | 0, $3 | 0) | 0)) {
        break label$1
       }
       if (!(FLAC__bitwriter_write_byte_block($1 | 0, HEAP32[GOT_data_internal_FLAC__VENDOR_STRING >> 2] | 0 | 0, $3 | 0) | 0)) {
        break label$1
       }
       if (!(FLAC__bitwriter_write_raw_uint32_little_endian($1 | 0, HEAP32[($0 + 24 | 0) >> 2] | 0 | 0) | 0)) {
        break label$1
       }
       if (!(HEAP32[($0 + 24 | 0) >> 2] | 0)) {
        break label$3
       }
       $2 = 0;
       label$14 : while (1) {
        $4 = 0;
        $3 = $2 << 3 | 0;
        if (!(FLAC__bitwriter_write_raw_uint32_little_endian($1 | 0, HEAP32[((HEAP32[($0 + 28 | 0) >> 2] | 0) + $3 | 0) >> 2] | 0 | 0) | 0)) {
         break label$1
        }
        $3 = (HEAP32[($0 + 28 | 0) >> 2] | 0) + $3 | 0;
        if (!(FLAC__bitwriter_write_byte_block($1 | 0, HEAP32[($3 + 4 | 0) >> 2] | 0 | 0, HEAP32[$3 >> 2] | 0 | 0) | 0)) {
         break label$1
        }
        $2 = $2 + 1 | 0;
        if ($2 >>> 0 >= (HEAP32[($0 + 24 | 0) >> 2] | 0) >>> 0) {
         break label$3
        }
        continue label$14;
       };
      }
      if (!(FLAC__bitwriter_write_byte_block($1 | 0, $0 + 16 | 0 | 0, (HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_MEDIA_CATALOG_NUMBER_LEN >> 2] | 0) >>> 3 | 0 | 0) | 0)) {
       break label$1
      }
      i64toi32_i32$2 = $0 + 152 | 0;
      i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
      i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
      if (!(FLAC__bitwriter_write_raw_uint64($1 | 0, i64toi32_i32$1 | 0, i64toi32_i32$0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_LEAD_IN_LEN >> 2] | 0 | 0) | 0)) {
       break label$1
      }
      $4 = 0;
      if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, (HEAP32[($0 + 160 | 0) >> 2] | 0 | 0) != (0 | 0) | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_IS_CD_LEN >> 2] | 0 | 0) | 0)) {
       break label$1
      }
      if (!(FLAC__bitwriter_write_zeroes($1 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_RESERVED_LEN >> 2] | 0 | 0) | 0)) {
       break label$1
      }
      if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 164 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_NUM_TRACKS_LEN >> 2] | 0 | 0) | 0)) {
       break label$1
      }
      $4 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_ISRC_LEN;
      $2 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_RESERVED_LEN;
      $3 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_NUMBER_LEN;
      $5 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_INDEX_OFFSET_LEN;
      $7 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_NUM_INDICES_LEN;
      $8 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_RESERVED_LEN;
      $9 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_PRE_EMPHASIS_LEN;
      $10 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_TYPE_LEN;
      $11 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_NUMBER_LEN;
      $12 = GOT_data_internal_FLAC__STREAM_METADATA_CUESHEET_TRACK_OFFSET_LEN;
      if (!(HEAP32[($0 + 164 | 0) >> 2] | 0)) {
       break label$3
      }
      $13 = (HEAP32[$4 >> 2] | 0) >>> 3 | 0;
      $14 = HEAP32[$2 >> 2] | 0;
      $6 = HEAP32[$3 >> 2] | 0;
      $5 = HEAP32[$5 >> 2] | 0;
      $15 = HEAP32[$7 >> 2] | 0;
      $16 = HEAP32[$8 >> 2] | 0;
      $17 = HEAP32[$9 >> 2] | 0;
      $18 = HEAP32[$10 >> 2] | 0;
      $11 = HEAP32[$11 >> 2] | 0;
      $10 = HEAP32[$12 >> 2] | 0;
      $9 = 0;
      label$15 : while (1) {
       $4 = 0;
       $2 = (HEAP32[($0 + 168 | 0) >> 2] | 0) + ($9 << 5 | 0) | 0;
       i64toi32_i32$2 = $2;
       i64toi32_i32$0 = HEAP32[$2 >> 2] | 0;
       i64toi32_i32$1 = HEAP32[($2 + 4 | 0) >> 2] | 0;
       if (!(FLAC__bitwriter_write_raw_uint64($1 | 0, i64toi32_i32$0 | 0, i64toi32_i32$1 | 0, $10 | 0) | 0)) {
        break label$1
       }
       if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAPU8[($2 + 8 | 0) >> 0] | 0 | 0, $11 | 0) | 0)) {
        break label$1
       }
       if (!(FLAC__bitwriter_write_byte_block($1 | 0, $2 + 9 | 0 | 0, $13 | 0) | 0)) {
        break label$1
       }
       if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, (HEAPU8[($2 + 22 | 0) >> 0] | 0) & 1 | 0 | 0, $18 | 0) | 0)) {
        break label$1
       }
       if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, ((HEAPU8[($2 + 22 | 0) >> 0] | 0) >>> 1 | 0) & 1 | 0 | 0, $17 | 0) | 0)) {
        break label$1
       }
       if (!(FLAC__bitwriter_write_zeroes($1 | 0, $16 | 0) | 0)) {
        break label$1
       }
       if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAPU8[($2 + 23 | 0) >> 0] | 0 | 0, $15 | 0) | 0)) {
        break label$1
       }
       label$16 : {
        $8 = $2 + 23 | 0;
        if (!(HEAPU8[$8 >> 0] | 0)) {
         break label$16
        }
        $7 = $2 + 24 | 0;
        $4 = 0;
        $2 = 0;
        label$17 : while (1) {
         $3 = (HEAP32[$7 >> 2] | 0) + ($2 << 4 | 0) | 0;
         i64toi32_i32$2 = $3;
         i64toi32_i32$1 = HEAP32[$3 >> 2] | 0;
         i64toi32_i32$0 = HEAP32[($3 + 4 | 0) >> 2] | 0;
         if (!(FLAC__bitwriter_write_raw_uint64($1 | 0, i64toi32_i32$1 | 0, i64toi32_i32$0 | 0, $5 | 0) | 0)) {
          break label$1
         }
         if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAPU8[($3 + 8 | 0) >> 0] | 0 | 0, $6 | 0) | 0)) {
          break label$1
         }
         if (!(FLAC__bitwriter_write_zeroes($1 | 0, $14 | 0) | 0)) {
          break label$1
         }
         $2 = $2 + 1 | 0;
         if ($2 >>> 0 < (HEAPU8[$8 >> 0] | 0) >>> 0) {
          continue label$17
         }
         break label$17;
        };
       }
       $9 = $9 + 1 | 0;
       if ($9 >>> 0 < (HEAP32[($0 + 164 | 0) >> 2] | 0) >>> 0) {
        continue label$15
       }
       break label$3;
      };
     }
     if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 16 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_TYPE_LEN >> 2] | 0 | 0) | 0)) {
      break label$1
     }
     $2 = HEAP32[($0 + 20 | 0) >> 2] | 0;
     $3 = GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_MIME_TYPE_LENGTH_LEN;
     $2 = strlen($2 | 0) | 0;
     if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, $2 | 0, HEAP32[$3 >> 2] | 0 | 0) | 0)) {
      break label$1
     }
     if (!(FLAC__bitwriter_write_byte_block($1 | 0, HEAP32[($0 + 20 | 0) >> 2] | 0 | 0, $2 | 0) | 0)) {
      break label$1
     }
     $2 = HEAP32[($0 + 24 | 0) >> 2] | 0;
     $3 = GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DESCRIPTION_LENGTH_LEN;
     $2 = strlen($2 | 0) | 0;
     if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, $2 | 0, HEAP32[$3 >> 2] | 0 | 0) | 0)) {
      break label$1
     }
     if (!(FLAC__bitwriter_write_byte_block($1 | 0, HEAP32[($0 + 24 | 0) >> 2] | 0 | 0, $2 | 0) | 0)) {
      break label$1
     }
     if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 28 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_WIDTH_LEN >> 2] | 0 | 0) | 0)) {
      break label$1
     }
     if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 32 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_HEIGHT_LEN >> 2] | 0 | 0) | 0)) {
      break label$1
     }
     if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 36 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DEPTH_LEN >> 2] | 0 | 0) | 0)) {
      break label$1
     }
     if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 40 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_COLORS_LEN >> 2] | 0 | 0) | 0)) {
      break label$1
     }
     if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 44 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__STREAM_METADATA_PICTURE_DATA_LENGTH_LEN >> 2] | 0 | 0) | 0)) {
      break label$1
     }
     if (FLAC__bitwriter_write_byte_block($1 | 0, HEAP32[($0 + 48 | 0) >> 2] | 0 | 0, HEAP32[($0 + 44 | 0) >> 2] | 0 | 0) | 0) {
      break label$3
     }
     break label$1;
    }
    if (!(FLAC__bitwriter_write_byte_block($1 | 0, HEAP32[($0 + 16 | 0) >> 2] | 0 | 0, HEAP32[($0 + 8 | 0) >> 2] | 0 | 0) | 0)) {
     break label$1
    }
   }
   $4 = 1;
  }
  return $4 | 0;
 }
 
 function FLAC__frame_add_header($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $6 = 0, $3 = 0, $2 = 0, $7 = 0, $8 = 0, $4 = 0, $5 = 0, i64toi32_i32$1 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  $3 = GOT_data_internal_FLAC__FRAME_HEADER_SYNC_LEN;
  label$1 : {
   label$2 : {
    if (FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[GOT_data_internal_FLAC__FRAME_HEADER_SYNC >> 2] | 0 | 0, HEAP32[$3 >> 2] | 0 | 0) | 0) {
     break label$2
    }
    $3 = 0;
    break label$1;
   }
   $3 = 0;
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, 0 | 0, HEAP32[GOT_data_internal_FLAC__FRAME_HEADER_RESERVED_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $3 = 0;
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, (HEAP32[($0 + 20 | 0) >> 2] | 0 | 0) != (0 | 0) | 0, HEAP32[GOT_data_internal_FLAC__FRAME_HEADER_BLOCKING_STRATEGY_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $4 = 16;
   $5 = 1;
   label$3 : {
    label$4 : {
     label$5 : {
      label$6 : {
       label$7 : {
        label$8 : {
         label$9 : {
          label$10 : {
           label$11 : {
            label$12 : {
             $6 = HEAP32[$0 >> 2] | 0;
             if (($6 | 0) > (2047 | 0)) {
              break label$12
             }
             label$13 : {
              if (($6 | 0) > (575 | 0)) {
               break label$13
              }
              label$14 : {
               if (($6 | 0) != (192 | 0)) {
                break label$14
               }
               $6 = 1;
               break label$3;
              }
              if (($6 | 0) == (256 | 0)) {
               break label$8
              }
              if (($6 | 0) != (512 | 0)) {
               break label$4
              }
              $6 = 9;
              break label$3;
             }
             if (($6 | 0) == (576 | 0)) {
              break label$11
             }
             if (($6 | 0) == (1024 | 0)) {
              break label$7
             }
             if (($6 | 0) != (1152 | 0)) {
              break label$4
             }
             $6 = 3;
             break label$3;
            }
            label$15 : {
             if (($6 | 0) > (4607 | 0)) {
              break label$15
             }
             if (($6 | 0) == (2048 | 0)) {
              break label$6
             }
             if (($6 | 0) == (2304 | 0)) {
              break label$10
             }
             if (($6 | 0) != (4096 | 0)) {
              break label$4
             }
             $6 = 12;
             break label$3;
            }
            label$16 : {
             if (($6 | 0) > (16383 | 0)) {
              break label$16
             }
             if (($6 | 0) == (4608 | 0)) {
              break label$9
             }
             if (($6 | 0) != (8192 | 0)) {
              break label$4
             }
             $6 = 13;
             break label$3;
            }
            if (($6 | 0) == (16384 | 0)) {
             break label$5
            }
            if (($6 | 0) != (32768 | 0)) {
             break label$4
            }
            $6 = 15;
            break label$3;
           }
           $6 = 2;
           break label$3;
          }
          $6 = 4;
          break label$3;
         }
         $6 = 5;
         break label$3;
        }
        $6 = 8;
        break label$3;
       }
       $6 = 10;
       break label$3;
      }
      $6 = 11;
      break label$3;
     }
     $6 = 14;
     break label$3;
    }
    $6 = $6 >>> 0 < 257 >>> 0;
    $4 = $6 ? 8 : 16;
    $6 = $6 ? 6 : 7;
    $5 = 0;
   }
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, $6 | 0, HEAP32[GOT_data_internal_FLAC__FRAME_HEADER_BLOCK_SIZE_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $7 = 0;
   label$17 : {
    label$18 : {
     label$19 : {
      label$20 : {
       label$21 : {
        label$22 : {
         label$23 : {
          label$24 : {
           label$25 : {
            $3 = HEAP32[($0 + 4 | 0) >> 2] | 0;
            if (($3 | 0) > (44099 | 0)) {
             break label$25
            }
            label$26 : {
             if (($3 | 0) > (22049 | 0)) {
              break label$26
             }
             if (($3 | 0) == (8e3 | 0)) {
              break label$24
             }
             if (($3 | 0) != (16e3 | 0)) {
              break label$18
             }
             $6 = 5;
             break label$17;
            }
            if (($3 | 0) == (22050 | 0)) {
             break label$23
            }
            if (($3 | 0) == (24e3 | 0)) {
             break label$22
            }
            if (($3 | 0) != (32e3 | 0)) {
             break label$18
            }
            $6 = 8;
            break label$17;
           }
           label$27 : {
            if (($3 | 0) > (95999 | 0)) {
             break label$27
            }
            if (($3 | 0) == (44100 | 0)) {
             break label$21
            }
            if (($3 | 0) == (48e3 | 0)) {
             break label$20
            }
            $6 = 1;
            if (($3 | 0) == (88200 | 0)) {
             break label$17
            }
            break label$18;
           }
           if (($3 | 0) == (96e3 | 0)) {
            break label$19
           }
           label$28 : {
            if (($3 | 0) == (192e3 | 0)) {
             break label$28
            }
            if (($3 | 0) != (176400 | 0)) {
             break label$18
            }
            $6 = 2;
            break label$17;
           }
           $6 = 3;
           break label$17;
          }
          $6 = 4;
          break label$17;
         }
         $6 = 6;
         break label$17;
        }
        $6 = 7;
        break label$17;
       }
       $6 = 9;
       break label$17;
      }
      $6 = 10;
      break label$17;
     }
     $6 = 11;
     break label$17;
    }
    $8 = ($3 >>> 0) % (1e3 >>> 0) | 0;
    label$29 : {
     if ($3 >>> 0 > 255e3 >>> 0) {
      break label$29
     }
     $6 = 12;
     $7 = 12;
     if (!$8) {
      break label$17
     }
    }
    label$30 : {
     if (($3 >>> 0) % (10 >>> 0) | 0) {
      break label$30
     }
     $6 = 14;
     $7 = 14;
     break label$17;
    }
    $6 = $3 >>> 0 < 65536 >>> 0 ? 13 : 0;
    $7 = $6;
   }
   $3 = 0;
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, $6 | 0, HEAP32[GOT_data_internal_FLAC__FRAME_HEADER_SAMPLE_RATE_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   label$31 : {
    label$32 : {
     switch (HEAP32[($0 + 12 | 0) >> 2] | 0 | 0) {
     case 0:
      $6 = (HEAP32[($0 + 8 | 0) >> 2] | 0) + -1 | 0;
      break label$31;
     case 1:
      $6 = 8;
      break label$31;
     case 2:
      $6 = 9;
      break label$31;
     case 3:
      break label$32;
     default:
      break label$31;
     };
    }
    $6 = 10;
   }
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, $6 | 0, HEAP32[GOT_data_internal_FLAC__FRAME_HEADER_CHANNEL_ASSIGNMENT_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $3 = 0;
   $6 = 0;
   label$36 : {
    $8 = __wasm_rotl_i32((HEAP32[($0 + 16 | 0) >> 2] | 0) + -8 | 0 | 0, 30 | 0) | 0;
    if ($8 >>> 0 > 4 >>> 0) {
     break label$36
    }
    $6 = HEAP32[((GOT_data_internal___memory_base + 7872 | 0) + ($8 << 2 | 0) | 0) >> 2] | 0;
   }
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, $6 | 0, HEAP32[GOT_data_internal_FLAC__FRAME_HEADER_BITS_PER_SAMPLE_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   $3 = 0;
   if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, 0 | 0, HEAP32[GOT_data_internal_FLAC__FRAME_HEADER_ZERO_PAD_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   label$37 : {
    label$38 : {
     if (HEAP32[($0 + 20 | 0) >> 2] | 0) {
      break label$38
     }
     if (FLAC__bitwriter_write_utf8_uint32($1 | 0, HEAP32[($0 + 24 | 0) >> 2] | 0 | 0) | 0) {
      break label$37
     }
     break label$1;
    }
    i64toi32_i32$1 = HEAP32[($0 + 28 | 0) >> 2] | 0;
    if (!(FLAC__bitwriter_write_utf8_uint64($1 | 0, HEAP32[($0 + 24 | 0) >> 2] | 0 | 0, i64toi32_i32$1 | 0) | 0)) {
     break label$1
    }
   }
   label$39 : {
    if ($5) {
     break label$39
    }
    if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, (HEAP32[$0 >> 2] | 0) + -1 | 0 | 0, $4 | 0) | 0)) {
     break label$1
    }
   }
   label$40 : {
    label$41 : {
     switch ($7 + -12 | 0 | 0) {
     case 0:
      if (FLAC__bitwriter_write_raw_uint32($1 | 0, ((HEAP32[($0 + 4 | 0) >> 2] | 0) >>> 0) / (1e3 >>> 0) | 0 | 0, 8 | 0) | 0) {
       break label$40
      }
      break label$1;
     case 1:
      if (FLAC__bitwriter_write_raw_uint32($1 | 0, HEAP32[($0 + 4 | 0) >> 2] | 0 | 0, 16 | 0) | 0) {
       break label$40
      }
      break label$1;
     case 2:
      break label$41;
     default:
      break label$40;
     };
    }
    if (!(FLAC__bitwriter_write_raw_uint32($1 | 0, ((HEAP32[($0 + 4 | 0) >> 2] | 0) >>> 0) / (10 >>> 0) | 0 | 0, 16 | 0) | 0)) {
     break label$1
    }
   }
   if (!(FLAC__bitwriter_get_write_crc8($1 | 0, $2 + 15 | 0 | 0) | 0)) {
    break label$1
   }
   $3 = GOT_data_internal_FLAC__FRAME_HEADER_CRC_LEN;
   $3 = (FLAC__bitwriter_write_raw_uint32($1 | 0, HEAPU8[($2 + 15 | 0) >> 0] | 0 | 0, HEAP32[$3 >> 2] | 0 | 0) | 0 | 0) != (0 | 0);
  }
  __stack_pointer = $2 + 16 | 0;
  return $3 | 0;
 }
 
 function FLAC__subframe_add_constant($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0;
  $4 = 0;
  label$1 : {
   if (!(FLAC__bitwriter_write_raw_uint32($3 | 0, HEAP32[GOT_data_internal_FLAC__SUBFRAME_TYPE_CONSTANT_BYTE_ALIGNED_MASK >> 2] | 0 | ($2 | 0) != (0 | 0) | 0 | 0, ((HEAP32[GOT_data_internal_FLAC__SUBFRAME_TYPE_LEN >> 2] | 0) + (HEAP32[GOT_data_internal_FLAC__SUBFRAME_ZERO_PAD_LEN >> 2] | 0) | 0) + (HEAP32[GOT_data_internal_FLAC__SUBFRAME_WASTED_BITS_FLAG_LEN >> 2] | 0) | 0 | 0) | 0)) {
    break label$1
   }
   label$2 : {
    if (!$2) {
     break label$2
    }
    if (!(FLAC__bitwriter_write_unary_unsigned($3 | 0, $2 + -1 | 0 | 0) | 0)) {
     break label$1
    }
   }
   $4 = (FLAC__bitwriter_write_raw_int32($3 | 0, HEAP32[$0 >> 2] | 0 | 0, $1 | 0) | 0 | 0) != (0 | 0);
  }
  return $4 | 0;
 }
 
 function FLAC__subframe_add_fixed($0, $1, $2, $3, $4) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  var $6 = 0;
  $6 = 0;
  label$1 : {
   if (!(FLAC__bitwriter_write_raw_uint32($4 | 0, HEAP32[GOT_data_internal_FLAC__SUBFRAME_TYPE_FIXED_BYTE_ALIGNED_MASK >> 2] | 0 | ($3 | 0) != (0 | 0) | 0 | ((HEAP32[($0 + 12 | 0) >> 2] | 0) << 1 | 0) | 0 | 0, ((HEAP32[GOT_data_internal_FLAC__SUBFRAME_TYPE_LEN >> 2] | 0) + (HEAP32[GOT_data_internal_FLAC__SUBFRAME_ZERO_PAD_LEN >> 2] | 0) | 0) + (HEAP32[GOT_data_internal_FLAC__SUBFRAME_WASTED_BITS_FLAG_LEN >> 2] | 0) | 0 | 0) | 0)) {
    break label$1
   }
   label$2 : {
    if (!$3) {
     break label$2
    }
    if (!(FLAC__bitwriter_write_unary_unsigned($4 | 0, $3 + -1 | 0 | 0) | 0)) {
     break label$1
    }
   }
   label$3 : {
    if (!(HEAP32[($0 + 12 | 0) >> 2] | 0)) {
     break label$3
    }
    $3 = 0;
    label$4 : {
     label$5 : while (1) {
      if (!(FLAC__bitwriter_write_raw_int32($4 | 0, HEAP32[(($0 + ($3 << 2 | 0) | 0) + 16 | 0) >> 2] | 0 | 0, $2 | 0) | 0)) {
       break label$4
      }
      $3 = $3 + 1 | 0;
      if ($3 >>> 0 >= (HEAP32[($0 + 12 | 0) >> 2] | 0) >>> 0) {
       break label$3
      }
      continue label$5;
     };
    }
    return 0 | 0;
   }
   $6 = 0;
   if (!(FLAC__bitwriter_write_raw_uint32($4 | 0, HEAP32[$0 >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_TYPE_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   label$6 : {
    if ((HEAP32[$0 >> 2] | 0) >>> 0 > 1 >>> 0) {
     break label$6
    }
    if (!(FLAC__bitwriter_write_raw_uint32($4 | 0, HEAP32[($0 + 4 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ORDER_LEN >> 2] | 0 | 0) | 0)) {
     break label$1
    }
    $3 = HEAP32[$0 >> 2] | 0;
    if ($3 >>> 0 > 1 >>> 0) {
     break label$6
    }
    $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    if (!(add_residual_partitioned_rice_($4 | 0, HEAP32[($0 + 32 | 0) >> 2] | 0 | 0, $1 | 0, HEAP32[($0 + 12 | 0) >> 2] | 0 | 0, HEAP32[$2 >> 2] | 0 | 0, HEAP32[($2 + 4 | 0) >> 2] | 0 | 0, HEAP32[($0 + 4 | 0) >> 2] | 0 | 0, ($3 | 0) == (1 | 0) | 0) | 0)) {
     break label$1
    }
   }
   $6 = 1;
  }
  return $6 | 0;
 }
 
 function add_residual_partitioned_rice_($0, $1, $2, $3, $4, $5, $6, $7) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  $7 = $7 | 0;
  var $8 = 0, $11 = 0, $14 = 0, $10 = 0, $9 = 0, $15 = 0, $16 = 0, $12 = 0, $13 = 0;
  $8 = GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ESCAPE_PARAMETER;
  $9 = HEAP32[($7 ? GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2_ESCAPE_PARAMETER : $8) >> 2] | 0;
  $8 = GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_PARAMETER_LEN;
  $10 = HEAP32[($7 ? GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE2_PARAMETER_LEN : $8) >> 2] | 0;
  label$1 : {
   label$2 : {
    label$3 : {
     if ($6) {
      break label$3
     }
     label$4 : {
      if (HEAP32[$5 >> 2] | 0) {
       break label$4
      }
      $11 = 0;
      if (!(FLAC__bitwriter_write_raw_uint32($0 | 0, HEAP32[$4 >> 2] | 0 | 0, $10 | 0) | 0)) {
       break label$2
      }
      if (!(FLAC__bitwriter_write_rice_signed_block($0 | 0, $1 | 0, $2 | 0, HEAP32[$4 >> 2] | 0 | 0) | 0)) {
       break label$2
      }
      break label$1;
     }
     $11 = 0;
     if (!(FLAC__bitwriter_write_raw_uint32($0 | 0, $9 | 0, $10 | 0) | 0)) {
      break label$2
     }
     if (!(FLAC__bitwriter_write_raw_uint32($0 | 0, HEAP32[$5 >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_RAW_LEN >> 2] | 0 | 0) | 0)) {
      break label$2
     }
     if (!$2) {
      break label$1
     }
     $7 = 0;
     label$5 : {
      label$6 : while (1) {
       if (!(FLAC__bitwriter_write_raw_int32($0 | 0, HEAP32[($1 + ($7 << 2 | 0) | 0) >> 2] | 0 | 0, HEAP32[$5 >> 2] | 0 | 0) | 0)) {
        break label$5
       }
       $7 = $7 + 1 | 0;
       if (($7 | 0) == ($2 | 0)) {
        break label$1
       }
       continue label$6;
      };
     }
     return 0 | 0;
    }
    $12 = ($3 + $2 | 0) >>> $6 | 0;
    $13 = HEAP32[GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_RAW_LEN >> 2] | 0;
    $2 = 0;
    $14 = 0;
    label$7 : while (1) {
     $15 = $12 - ($14 ? 0 : $3) | 0;
     $7 = $2;
     $2 = $15 + $7 | 0;
     label$8 : {
      label$9 : {
       $16 = $14 << 2 | 0;
       $8 = $5 + $16 | 0;
       if (HEAP32[$8 >> 2] | 0) {
        break label$9
       }
       $11 = 0;
       $8 = $4 + $16 | 0;
       if (!(FLAC__bitwriter_write_raw_uint32($0 | 0, HEAP32[$8 >> 2] | 0 | 0, $10 | 0) | 0)) {
        break label$2
       }
       if (FLAC__bitwriter_write_rice_signed_block($0 | 0, $1 + ($7 << 2 | 0) | 0 | 0, $15 | 0, HEAP32[$8 >> 2] | 0 | 0) | 0) {
        break label$8
       }
       break label$2;
      }
      $11 = 0;
      if (!(FLAC__bitwriter_write_raw_uint32($0 | 0, $9 | 0, $10 | 0) | 0)) {
       break label$2
      }
      if (!(FLAC__bitwriter_write_raw_uint32($0 | 0, HEAP32[$8 >> 2] | 0 | 0, $13 | 0) | 0)) {
       break label$2
      }
      if ($7 >>> 0 >= $2 >>> 0) {
       break label$8
      }
      label$10 : while (1) {
       if (!(FLAC__bitwriter_write_raw_int32($0 | 0, HEAP32[($1 + ($7 << 2 | 0) | 0) >> 2] | 0 | 0, HEAP32[$8 >> 2] | 0 | 0) | 0)) {
        break label$2
       }
       $7 = $7 + 1 | 0;
       if (($7 | 0) != ($2 | 0)) {
        continue label$10
       }
       break label$10;
      };
     }
     $11 = 1;
     $14 = $14 + 1 | 0;
     if (!($14 >>> $6 | 0)) {
      continue label$7
     }
     break label$7;
    };
   }
   return $11 | 0;
  }
  return 1 | 0;
 }
 
 function FLAC__subframe_add_lpc($0, $1, $2, $3, $4) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  var $5 = 0;
  $5 = 0;
  label$1 : {
   if (!(FLAC__bitwriter_write_raw_uint32($4 | 0, HEAP32[GOT_data_internal_FLAC__SUBFRAME_TYPE_LPC_BYTE_ALIGNED_MASK >> 2] | 0 | ($3 | 0) != (0 | 0) | 0 | (((HEAP32[($0 + 12 | 0) >> 2] | 0) << 1 | 0) + -2 | 0) | 0 | 0, ((HEAP32[GOT_data_internal_FLAC__SUBFRAME_TYPE_LEN >> 2] | 0) + (HEAP32[GOT_data_internal_FLAC__SUBFRAME_ZERO_PAD_LEN >> 2] | 0) | 0) + (HEAP32[GOT_data_internal_FLAC__SUBFRAME_WASTED_BITS_FLAG_LEN >> 2] | 0) | 0 | 0) | 0)) {
    break label$1
   }
   label$2 : {
    if (!$3) {
     break label$2
    }
    if (!(FLAC__bitwriter_write_unary_unsigned($4 | 0, $3 + -1 | 0 | 0) | 0)) {
     break label$1
    }
   }
   label$3 : {
    if (!(HEAP32[($0 + 12 | 0) >> 2] | 0)) {
     break label$3
    }
    $3 = 0;
    label$4 : {
     label$5 : while (1) {
      if (!(FLAC__bitwriter_write_raw_int32($4 | 0, HEAP32[(($0 + ($3 << 2 | 0) | 0) + 152 | 0) >> 2] | 0 | 0, $2 | 0) | 0)) {
       break label$4
      }
      $3 = $3 + 1 | 0;
      if ($3 >>> 0 >= (HEAP32[($0 + 12 | 0) >> 2] | 0) >>> 0) {
       break label$3
      }
      continue label$5;
     };
    }
    return 0 | 0;
   }
   $5 = 0;
   if (!(FLAC__bitwriter_write_raw_uint32($4 | 0, (HEAP32[($0 + 16 | 0) >> 2] | 0) + -1 | 0 | 0, HEAP32[GOT_data_internal_FLAC__SUBFRAME_LPC_QLP_COEFF_PRECISION_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   if (!(FLAC__bitwriter_write_raw_int32($4 | 0, HEAP32[($0 + 20 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__SUBFRAME_LPC_QLP_SHIFT_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   label$6 : {
    if (!(HEAP32[($0 + 12 | 0) >> 2] | 0)) {
     break label$6
    }
    $3 = 0;
    label$7 : {
     label$8 : while (1) {
      if (!(FLAC__bitwriter_write_raw_int32($4 | 0, HEAP32[(($0 + ($3 << 2 | 0) | 0) + 24 | 0) >> 2] | 0 | 0, HEAP32[($0 + 16 | 0) >> 2] | 0 | 0) | 0)) {
       break label$7
      }
      $3 = $3 + 1 | 0;
      if ($3 >>> 0 >= (HEAP32[($0 + 12 | 0) >> 2] | 0) >>> 0) {
       break label$6
      }
      continue label$8;
     };
    }
    return 0 | 0;
   }
   $5 = 0;
   if (!(FLAC__bitwriter_write_raw_uint32($4 | 0, HEAP32[$0 >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_TYPE_LEN >> 2] | 0 | 0) | 0)) {
    break label$1
   }
   label$9 : {
    if ((HEAP32[$0 >> 2] | 0) >>> 0 > 1 >>> 0) {
     break label$9
    }
    if (!(FLAC__bitwriter_write_raw_uint32($4 | 0, HEAP32[($0 + 4 | 0) >> 2] | 0 | 0, HEAP32[GOT_data_internal_FLAC__ENTROPY_CODING_METHOD_PARTITIONED_RICE_ORDER_LEN >> 2] | 0 | 0) | 0)) {
     break label$1
    }
    $3 = HEAP32[$0 >> 2] | 0;
    if ($3 >>> 0 > 1 >>> 0) {
     break label$9
    }
    $2 = HEAP32[($0 + 8 | 0) >> 2] | 0;
    if (!(add_residual_partitioned_rice_($4 | 0, HEAP32[($0 + 280 | 0) >> 2] | 0 | 0, $1 | 0, HEAP32[($0 + 12 | 0) >> 2] | 0 | 0, HEAP32[$2 >> 2] | 0 | 0, HEAP32[($2 + 4 | 0) >> 2] | 0 | 0, HEAP32[($0 + 4 | 0) >> 2] | 0 | 0, ($3 | 0) == (1 | 0) | 0) | 0)) {
     break label$1
    }
   }
   $5 = 1;
  }
  return $5 | 0;
 }
 
 function FLAC__subframe_add_verbatim($0, $1, $2, $3, $4) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  var $5 = 0;
  $5 = 0;
  $0 = HEAP32[$0 >> 2] | 0;
  label$1 : {
   if (!(FLAC__bitwriter_write_raw_uint32($4 | 0, HEAP32[GOT_data_internal_FLAC__SUBFRAME_TYPE_VERBATIM_BYTE_ALIGNED_MASK >> 2] | 0 | ($3 | 0) != (0 | 0) | 0 | 0, ((HEAP32[GOT_data_internal_FLAC__SUBFRAME_TYPE_LEN >> 2] | 0) + (HEAP32[GOT_data_internal_FLAC__SUBFRAME_ZERO_PAD_LEN >> 2] | 0) | 0) + (HEAP32[GOT_data_internal_FLAC__SUBFRAME_WASTED_BITS_FLAG_LEN >> 2] | 0) | 0 | 0) | 0)) {
    break label$1
   }
   label$2 : {
    if (!$3) {
     break label$2
    }
    if (!(FLAC__bitwriter_write_unary_unsigned($4 | 0, $3 + -1 | 0 | 0) | 0)) {
     break label$1
    }
   }
   label$3 : {
    if ($1) {
     break label$3
    }
    return 1 | 0;
   }
   $3 = 0;
   label$4 : {
    label$5 : while (1) {
     if (!(FLAC__bitwriter_write_raw_int32($4 | 0, HEAP32[($0 + ($3 << 2 | 0) | 0) >> 2] | 0 | 0, $2 | 0) | 0)) {
      break label$4
     }
     $3 = $3 + 1 | 0;
     if (($3 | 0) != ($1 | 0)) {
      continue label$5
     }
     break label$5;
    };
    return 1 | 0;
   }
   $5 = 0;
  }
  return $5 | 0;
 }
 
 function strncmp($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $4 = 0, $3 = 0, $5 = 0;
  label$1 : {
   if ($2) {
    break label$1
   }
   return 0 | 0;
  }
  $3 = 0;
  label$2 : {
   $4 = HEAPU8[$0 >> 0] | 0;
   if (!$4) {
    break label$2
   }
   label$3 : {
    label$4 : while (1) {
     $5 = HEAPU8[$1 >> 0] | 0;
     if (!$5) {
      break label$3
     }
     $2 = $2 + -1 | 0;
     if (!$2) {
      break label$3
     }
     if (($4 & 255 | 0 | 0) != ($5 | 0)) {
      break label$3
     }
     $1 = $1 + 1 | 0;
     $4 = HEAPU8[($0 + 1 | 0) >> 0] | 0;
     $0 = $0 + 1 | 0;
     if ($4) {
      continue label$4
     }
     break label$2;
    };
   }
   $3 = $4;
  }
  return ($3 & 255 | 0) - (HEAPU8[$1 >> 0] | 0) | 0 | 0;
 }
 
 function __uflow($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  $2 = -1;
  label$1 : {
   if (__toread($0 | 0) | 0) {
    break label$1
   }
   if ((FUNCTION_TABLE[HEAP32[($0 + 32 | 0) >> 2] | 0 | 0]($0, $1 + 15 | 0, 1) | 0 | 0) != (1 | 0)) {
    break label$1
   }
   $2 = HEAPU8[($1 + 15 | 0) >> 0] | 0;
  }
  __stack_pointer = $1 + 16 | 0;
  return $2 | 0;
 }
 
 function __shlim($0, $1, $1$hi) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, $2 = 0, $3 = 0, $4 = 0, $4$hi = 0, i64toi32_i32$2 = 0, i64toi32_i32$3 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $21 = 0, $22 = 0;
  i64toi32_i32$0 = $1$hi;
  i64toi32_i32$1 = $0;
  HEAP32[(i64toi32_i32$1 + 112 | 0) >> 2] = $1;
  HEAP32[(i64toi32_i32$1 + 116 | 0) >> 2] = $1$hi;
  $2 = HEAP32[(i64toi32_i32$1 + 8 | 0) >> 2] | 0;
  $3 = HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] | 0;
  i64toi32_i32$1 = $2 - $3 | 0;
  i64toi32_i32$0 = i64toi32_i32$1 >> 31 | 0;
  $4 = i64toi32_i32$1;
  $4$hi = i64toi32_i32$0;
  i64toi32_i32$1 = $0;
  HEAP32[(i64toi32_i32$1 + 120 | 0) >> 2] = $4;
  HEAP32[(i64toi32_i32$1 + 124 | 0) >> 2] = i64toi32_i32$0;
  $17 = i64toi32_i32$1;
  i64toi32_i32$0 = $1$hi;
  $21 = $3 + $1 | 0;
  $22 = $2;
  i64toi32_i32$0 = $4$hi;
  i64toi32_i32$0 = $1$hi;
  i64toi32_i32$0 = $4$hi;
  i64toi32_i32$2 = $4;
  i64toi32_i32$1 = $1$hi;
  i64toi32_i32$3 = $1;
  if ((i64toi32_i32$0 | 0) > (i64toi32_i32$1 | 0)) {
   $14 = 1
  } else {
   if ((i64toi32_i32$0 | 0) >= (i64toi32_i32$1 | 0)) {
    if (i64toi32_i32$2 >>> 0 <= i64toi32_i32$3 >>> 0) {
     $15 = 0
    } else {
     $15 = 1
    }
    $16 = $15;
   } else {
    $16 = 0
   }
   $14 = $16;
  }
  i64toi32_i32$2 = $1$hi;
  i64toi32_i32$3 = $1;
  i64toi32_i32$0 = 0;
  i64toi32_i32$1 = 0;
  HEAP32[($17 + 104 | 0) >> 2] = ($1 | 0) != (i64toi32_i32$1 | 0) | ($1$hi | 0) != (i64toi32_i32$0 | 0) | 0 ? ($14 ? $21 : $22) : $2;
 }
 
 function __shgetc($0) {
  $0 = $0 | 0;
  var i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, i64toi32_i32$1 = 0, i64toi32_i32$5 = 0, i64toi32_i32$3 = 0, $1$hi = 0, i64toi32_i32$4 = 0, $4 = 0, $1 = 0, $3 = 0, $2 = 0, $23 = 0, $24 = 0, $25 = 0, $5 = 0, $26 = 0, $27 = 0, $28 = 0, $11$hi = 0, $30 = 0, $30$hi = 0, $38 = 0, $38$hi = 0, $50 = 0, $52 = 0, $52$hi = 0, $57 = 0, $57$hi = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     i64toi32_i32$2 = $0;
     i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 112 | 0) >> 2] | 0;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 116 | 0) >> 2] | 0;
     $1 = i64toi32_i32$0;
     $1$hi = i64toi32_i32$1;
     if (!(i64toi32_i32$0 | i64toi32_i32$1 | 0)) {
      break label$3
     }
     i64toi32_i32$2 = $0;
     i64toi32_i32$1 = HEAP32[(i64toi32_i32$2 + 120 | 0) >> 2] | 0;
     i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 124 | 0) >> 2] | 0;
     $11$hi = i64toi32_i32$0;
     i64toi32_i32$0 = $1$hi;
     i64toi32_i32$0 = $11$hi;
     i64toi32_i32$2 = i64toi32_i32$1;
     i64toi32_i32$1 = $1$hi;
     i64toi32_i32$3 = $1;
     if ((i64toi32_i32$0 | 0) > (i64toi32_i32$1 | 0)) {
      $23 = 1
     } else {
      if ((i64toi32_i32$0 | 0) >= (i64toi32_i32$1 | 0)) {
       if (i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0) {
        $24 = 0
       } else {
        $24 = 1
       }
       $25 = $24;
      } else {
       $25 = 0
      }
      $23 = $25;
     }
     if ($23) {
      break label$2
     }
    }
    $2 = __uflow($0 | 0) | 0;
    if (($2 | 0) > (-1 | 0)) {
     break label$1
    }
   }
   HEAP32[($0 + 104 | 0) >> 2] = 0;
   return -1 | 0;
  }
  $3 = HEAP32[($0 + 8 | 0) >> 2] | 0;
  $4 = $3;
  label$4 : {
   i64toi32_i32$3 = $0;
   i64toi32_i32$2 = HEAP32[($0 + 112 | 0) >> 2] | 0;
   i64toi32_i32$0 = HEAP32[($0 + 116 | 0) >> 2] | 0;
   $1 = i64toi32_i32$2;
   $1$hi = i64toi32_i32$0;
   if (!(i64toi32_i32$2 | i64toi32_i32$0 | 0)) {
    break label$4
   }
   $4 = $3;
   i64toi32_i32$0 = $1$hi;
   i64toi32_i32$3 = $0;
   i64toi32_i32$0 = HEAP32[($0 + 120 | 0) >> 2] | 0;
   i64toi32_i32$2 = HEAP32[($0 + 124 | 0) >> 2] | 0;
   i64toi32_i32$3 = i64toi32_i32$0;
   i64toi32_i32$0 = -1;
   i64toi32_i32$1 = -1;
   i64toi32_i32$0 = i64toi32_i32$2 ^ i64toi32_i32$0 | 0;
   $30 = i64toi32_i32$3 ^ i64toi32_i32$1 | 0;
   $30$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $1$hi;
   i64toi32_i32$2 = $1;
   i64toi32_i32$3 = $30$hi;
   i64toi32_i32$1 = $30;
   i64toi32_i32$4 = i64toi32_i32$2 + i64toi32_i32$1 | 0;
   i64toi32_i32$5 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
   if (i64toi32_i32$4 >>> 0 < i64toi32_i32$1 >>> 0) {
    i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
   }
   $1 = i64toi32_i32$4;
   $1$hi = i64toi32_i32$5;
   $5 = HEAP32[($0 + 4 | 0) >> 2] | 0;
   i64toi32_i32$2 = $3 - $5 | 0;
   i64toi32_i32$5 = i64toi32_i32$2 >> 31 | 0;
   $38 = i64toi32_i32$2;
   $38$hi = i64toi32_i32$5;
   i64toi32_i32$5 = $1$hi;
   i64toi32_i32$0 = i64toi32_i32$4;
   i64toi32_i32$2 = $38$hi;
   i64toi32_i32$1 = $38;
   if ((i64toi32_i32$5 | 0) > (i64toi32_i32$2 | 0)) {
    $26 = 1
   } else {
    if ((i64toi32_i32$5 | 0) >= (i64toi32_i32$2 | 0)) {
     if (i64toi32_i32$0 >>> 0 < i64toi32_i32$1 >>> 0) {
      $27 = 0
     } else {
      $27 = 1
     }
     $28 = $27;
    } else {
     $28 = 0
    }
    $26 = $28;
   }
   if ($26) {
    break label$4
   }
   i64toi32_i32$0 = $1$hi;
   $4 = $5 + $1 | 0;
  }
  HEAP32[($0 + 104 | 0) >> 2] = $4;
  $4 = HEAP32[($0 + 4 | 0) >> 2] | 0;
  label$5 : {
   if (!$3) {
    break label$5
   }
   $50 = $0;
   i64toi32_i32$1 = $0;
   i64toi32_i32$0 = HEAP32[($0 + 120 | 0) >> 2] | 0;
   i64toi32_i32$5 = HEAP32[($0 + 124 | 0) >> 2] | 0;
   $52 = i64toi32_i32$0;
   $52$hi = i64toi32_i32$5;
   i64toi32_i32$0 = ($3 - $4 | 0) + 1 | 0;
   i64toi32_i32$5 = i64toi32_i32$0 >> 31 | 0;
   $57 = i64toi32_i32$0;
   $57$hi = i64toi32_i32$5;
   i64toi32_i32$5 = $52$hi;
   i64toi32_i32$1 = $52;
   i64toi32_i32$0 = $57$hi;
   i64toi32_i32$2 = $57;
   i64toi32_i32$3 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
   i64toi32_i32$4 = i64toi32_i32$5 + i64toi32_i32$0 | 0;
   if (i64toi32_i32$3 >>> 0 < i64toi32_i32$2 >>> 0) {
    i64toi32_i32$4 = i64toi32_i32$4 + 1 | 0
   }
   i64toi32_i32$1 = $50;
   HEAP32[(i64toi32_i32$1 + 120 | 0) >> 2] = i64toi32_i32$3;
   HEAP32[(i64toi32_i32$1 + 124 | 0) >> 2] = i64toi32_i32$4;
  }
  label$6 : {
   $0 = $4 + -1 | 0;
   if (($2 | 0) == (HEAPU8[$0 >> 0] | 0 | 0)) {
    break label$6
   }
   HEAP8[$0 >> 0] = $2;
  }
  return $2 | 0;
 }
 
 function isspace($0) {
  $0 = $0 | 0;
  return ($0 | 0) == (32 | 0) | ($0 + -9 | 0) >>> 0 < 5 >>> 0 | 0 | 0;
 }
 
 function __extendsftf2($0, $1) {
  $0 = $0 | 0;
  $1 = Math_fround($1);
  var i64toi32_i32$1 = 0, i64toi32_i32$5 = 0, i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, i64toi32_i32$3 = 0, $4 = 0, i64toi32_i32$4 = 0, $2 = 0, $5 = 0, $5$hi = 0, $6 = 0, $6$hi = 0, $3 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $30 = 0, $38 = 0, $38$hi = 0, $42$hi = 0, $48 = 0, $49 = 0, $49$hi = 0, $53$hi = 0, $54 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  label$1 : {
   label$2 : {
    $3 = (wasm2js_scratch_store_f32($1), wasm2js_scratch_load_i32(2));
    $4 = $3 & 2147483647 | 0;
    if (($4 + -8388608 | 0) >>> 0 > 2130706431 >>> 0) {
     break label$2
    }
    i64toi32_i32$0 = 0;
    i64toi32_i32$2 = $4;
    i64toi32_i32$1 = 0;
    i64toi32_i32$3 = 25;
    i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     i64toi32_i32$1 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
     $24 = 0;
    } else {
     i64toi32_i32$1 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$2 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$0 << i64toi32_i32$4 | 0) | 0;
     $24 = i64toi32_i32$2 << i64toi32_i32$4 | 0;
    }
    i64toi32_i32$0 = $24;
    i64toi32_i32$2 = 1065353216;
    i64toi32_i32$3 = 0;
    i64toi32_i32$4 = i64toi32_i32$0 + i64toi32_i32$3 | 0;
    i64toi32_i32$5 = i64toi32_i32$1 + i64toi32_i32$2 | 0;
    if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
     i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
    }
    $5 = i64toi32_i32$4;
    $5$hi = i64toi32_i32$5;
    i64toi32_i32$5 = 0;
    $6 = 0;
    $6$hi = i64toi32_i32$5;
    break label$1;
   }
   label$3 : {
    if ($4 >>> 0 < 2139095040 >>> 0) {
     break label$3
    }
    i64toi32_i32$5 = 0;
    i64toi32_i32$1 = $3;
    i64toi32_i32$0 = 0;
    i64toi32_i32$3 = 25;
    i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
    if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
     i64toi32_i32$0 = i64toi32_i32$1 << i64toi32_i32$2 | 0;
     $25 = 0;
    } else {
     i64toi32_i32$0 = ((1 << i64toi32_i32$2 | 0) - 1 | 0) & (i64toi32_i32$1 >>> (32 - i64toi32_i32$2 | 0) | 0) | 0 | (i64toi32_i32$5 << i64toi32_i32$2 | 0) | 0;
     $25 = i64toi32_i32$1 << i64toi32_i32$2 | 0;
    }
    i64toi32_i32$5 = $25;
    i64toi32_i32$1 = 2147418112;
    i64toi32_i32$3 = 0;
    i64toi32_i32$1 = i64toi32_i32$0 | i64toi32_i32$1 | 0;
    $5 = i64toi32_i32$5 | i64toi32_i32$3 | 0;
    $5$hi = i64toi32_i32$1;
    i64toi32_i32$1 = 0;
    $6 = 0;
    $6$hi = i64toi32_i32$1;
    break label$1;
   }
   label$4 : {
    if ($4) {
     break label$4
    }
    i64toi32_i32$1 = 0;
    $6 = 0;
    $6$hi = i64toi32_i32$1;
    i64toi32_i32$1 = 0;
    $5 = 0;
    $5$hi = i64toi32_i32$1;
    break label$1;
   }
   i64toi32_i32$1 = 0;
   $30 = $4;
   $4 = Math_clz32($4);
   i64toi32_i32$5 = 0;
   __ashlti3($2 | 0, $30 | 0, i64toi32_i32$1 | 0, 0 | 0, i64toi32_i32$5 | 0, $4 + 81 | 0 | 0);
   i64toi32_i32$0 = $2 + 8 | 0;
   i64toi32_i32$5 = HEAP32[i64toi32_i32$0 >> 2] | 0;
   i64toi32_i32$1 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
   i64toi32_i32$0 = i64toi32_i32$5;
   i64toi32_i32$5 = 65536;
   i64toi32_i32$3 = 0;
   i64toi32_i32$5 = i64toi32_i32$1 ^ i64toi32_i32$5 | 0;
   $38 = i64toi32_i32$0 ^ i64toi32_i32$3 | 0;
   $38$hi = i64toi32_i32$5;
   i64toi32_i32$5 = 0;
   i64toi32_i32$1 = 16265 - $4 | 0;
   i64toi32_i32$0 = 0;
   i64toi32_i32$3 = 48;
   i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$0 = i64toi32_i32$1 << i64toi32_i32$2 | 0;
    $26 = 0;
   } else {
    i64toi32_i32$0 = ((1 << i64toi32_i32$2 | 0) - 1 | 0) & (i64toi32_i32$1 >>> (32 - i64toi32_i32$2 | 0) | 0) | 0 | (i64toi32_i32$5 << i64toi32_i32$2 | 0) | 0;
    $26 = i64toi32_i32$1 << i64toi32_i32$2 | 0;
   }
   $42$hi = i64toi32_i32$0;
   i64toi32_i32$0 = $38$hi;
   i64toi32_i32$5 = $38;
   i64toi32_i32$1 = $42$hi;
   i64toi32_i32$3 = $26;
   i64toi32_i32$1 = i64toi32_i32$0 | i64toi32_i32$1 | 0;
   $5 = i64toi32_i32$5 | i64toi32_i32$3 | 0;
   $5$hi = i64toi32_i32$1;
   i64toi32_i32$0 = $2;
   i64toi32_i32$1 = HEAP32[i64toi32_i32$0 >> 2] | 0;
   i64toi32_i32$5 = HEAP32[(i64toi32_i32$0 + 4 | 0) >> 2] | 0;
   $6 = i64toi32_i32$1;
   $6$hi = i64toi32_i32$5;
  }
  i64toi32_i32$5 = $6$hi;
  i64toi32_i32$1 = $0;
  HEAP32[i64toi32_i32$1 >> 2] = $6;
  HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] = i64toi32_i32$5;
  $48 = i64toi32_i32$1;
  i64toi32_i32$5 = $5$hi;
  $49 = $5;
  $49$hi = i64toi32_i32$5;
  i64toi32_i32$5 = 0;
  i64toi32_i32$0 = $3 & -2147483648 | 0;
  i64toi32_i32$1 = 0;
  i64toi32_i32$3 = 32;
  i64toi32_i32$2 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$1 = i64toi32_i32$0 << i64toi32_i32$2 | 0;
   $27 = 0;
  } else {
   i64toi32_i32$1 = ((1 << i64toi32_i32$2 | 0) - 1 | 0) & (i64toi32_i32$0 >>> (32 - i64toi32_i32$2 | 0) | 0) | 0 | (i64toi32_i32$5 << i64toi32_i32$2 | 0) | 0;
   $27 = i64toi32_i32$0 << i64toi32_i32$2 | 0;
  }
  $53$hi = i64toi32_i32$1;
  i64toi32_i32$1 = $49$hi;
  i64toi32_i32$5 = $49;
  i64toi32_i32$0 = $53$hi;
  i64toi32_i32$3 = $27;
  i64toi32_i32$0 = i64toi32_i32$1 | i64toi32_i32$0 | 0;
  $54 = i64toi32_i32$5 | i64toi32_i32$3 | 0;
  i64toi32_i32$5 = $48;
  HEAP32[(i64toi32_i32$5 + 8 | 0) >> 2] = $54;
  HEAP32[(i64toi32_i32$5 + 12 | 0) >> 2] = i64toi32_i32$0;
  __stack_pointer = $2 + 16 | 0;
 }
 
 function __floatsitf($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var i64toi32_i32$2 = 0, i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, i64toi32_i32$5 = 0, i64toi32_i32$3 = 0, $5 = 0, i64toi32_i32$4 = 0, $2 = 0, $3 = 0, $3$hi = 0, $4 = 0, $4$hi = 0, $21 = 0, $22 = 0, $19 = 0, $27 = 0, $27$hi = 0, $31$hi = 0, $32 = 0, $32$hi = 0, $36$hi = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  label$1 : {
   label$2 : {
    if ($1) {
     break label$2
    }
    i64toi32_i32$0 = 0;
    $3 = 0;
    $3$hi = i64toi32_i32$0;
    i64toi32_i32$0 = 0;
    $4 = 0;
    $4$hi = i64toi32_i32$0;
    break label$1;
   }
   $5 = $1 >> 31 | 0;
   $5 = ($1 + $5 | 0) ^ $5 | 0;
   i64toi32_i32$0 = 0;
   $19 = $5;
   $5 = Math_clz32($5);
   i64toi32_i32$1 = 0;
   __ashlti3($2 | 0, $19 | 0, i64toi32_i32$0 | 0, 0 | 0, i64toi32_i32$1 | 0, $5 + 81 | 0 | 0);
   i64toi32_i32$2 = $2 + 8 | 0;
   i64toi32_i32$1 = HEAP32[i64toi32_i32$2 >> 2] | 0;
   i64toi32_i32$0 = HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] | 0;
   i64toi32_i32$2 = i64toi32_i32$1;
   i64toi32_i32$1 = 65536;
   i64toi32_i32$3 = 0;
   i64toi32_i32$1 = i64toi32_i32$0 ^ i64toi32_i32$1 | 0;
   $27 = i64toi32_i32$2 ^ i64toi32_i32$3 | 0;
   $27$hi = i64toi32_i32$1;
   i64toi32_i32$1 = 0;
   i64toi32_i32$0 = 16414 - $5 | 0;
   i64toi32_i32$2 = 0;
   i64toi32_i32$3 = 48;
   i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$2 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
    $21 = 0;
   } else {
    i64toi32_i32$2 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$0 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$1 << i64toi32_i32$4 | 0) | 0;
    $21 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
   }
   $31$hi = i64toi32_i32$2;
   i64toi32_i32$2 = $27$hi;
   i64toi32_i32$1 = $27;
   i64toi32_i32$0 = $31$hi;
   i64toi32_i32$3 = $21;
   i64toi32_i32$4 = i64toi32_i32$1 + i64toi32_i32$3 | 0;
   i64toi32_i32$5 = i64toi32_i32$2 + i64toi32_i32$0 | 0;
   if (i64toi32_i32$4 >>> 0 < i64toi32_i32$3 >>> 0) {
    i64toi32_i32$5 = i64toi32_i32$5 + 1 | 0
   }
   $32 = i64toi32_i32$4;
   $32$hi = i64toi32_i32$5;
   i64toi32_i32$5 = 0;
   i64toi32_i32$2 = $1 & -2147483648 | 0;
   i64toi32_i32$1 = 0;
   i64toi32_i32$3 = 32;
   i64toi32_i32$0 = i64toi32_i32$3 & 31 | 0;
   if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
    i64toi32_i32$1 = i64toi32_i32$2 << i64toi32_i32$0 | 0;
    $22 = 0;
   } else {
    i64toi32_i32$1 = ((1 << i64toi32_i32$0 | 0) - 1 | 0) & (i64toi32_i32$2 >>> (32 - i64toi32_i32$0 | 0) | 0) | 0 | (i64toi32_i32$5 << i64toi32_i32$0 | 0) | 0;
    $22 = i64toi32_i32$2 << i64toi32_i32$0 | 0;
   }
   $36$hi = i64toi32_i32$1;
   i64toi32_i32$1 = $32$hi;
   i64toi32_i32$5 = $32;
   i64toi32_i32$2 = $36$hi;
   i64toi32_i32$3 = $22;
   i64toi32_i32$2 = i64toi32_i32$1 | i64toi32_i32$2 | 0;
   $4 = i64toi32_i32$5 | i64toi32_i32$3 | 0;
   $4$hi = i64toi32_i32$2;
   i64toi32_i32$1 = $2;
   i64toi32_i32$2 = HEAP32[i64toi32_i32$1 >> 2] | 0;
   i64toi32_i32$5 = HEAP32[(i64toi32_i32$1 + 4 | 0) >> 2] | 0;
   $3 = i64toi32_i32$2;
   $3$hi = i64toi32_i32$5;
  }
  i64toi32_i32$5 = $3$hi;
  i64toi32_i32$2 = $0;
  HEAP32[i64toi32_i32$2 >> 2] = $3;
  HEAP32[(i64toi32_i32$2 + 4 | 0) >> 2] = i64toi32_i32$5;
  i64toi32_i32$5 = $4$hi;
  HEAP32[(i64toi32_i32$2 + 8 | 0) >> 2] = $4;
  HEAP32[(i64toi32_i32$2 + 12 | 0) >> 2] = i64toi32_i32$5;
  __stack_pointer = $2 + 16 | 0;
 }
 
 function __multf3($0, $1, $1$hi, $2, $2$hi, $3, $3$hi, $4, $4$hi) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $1$hi = $1$hi | 0;
  $2 = $2 | 0;
  $2$hi = $2$hi | 0;
  $3 = $3 | 0;
  $3$hi = $3$hi | 0;
  $4 = $4 | 0;
  $4$hi = $4$hi | 0;
  var i64toi32_i32$1 = 0, i64toi32_i32$0 = 0, i64toi32_i32$2 = 0, i64toi32_i32$3 = 0, i64toi32_i32$5 = 0, i64toi32_i32$4 = 0, $5 = 0, $10$hi = 0, $10 = 0, $8$hi = 0, $7$hi = 0, $6$hi = 0, $11$hi = 0, $8 = 0, $14 = 0, $11 = 0, $7 = 0, $6 = 0, $17$hi = 0, $16 = 0, $17 = 0, $9$hi = 0, $12$hi = 0, $13$hi = 0, $15 = 0, $9 = 0, $12 = 0, $13 = 0, $19$hi = 0, $22$hi = 0, $19 = 0, $18 = 0, $20$hi = 0, $21$hi = 0, $23$hi = 0, $24$hi = 0, $228 = 0, $229 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $237 = 0, $238 = 0, $239 = 0, $240 = 0, $241 = 0, $242 = 0, $244 = 0, $246 = 0, $248 = 0, $249 = 0, $251 = 0, $252 = 0, $254 = 0, $256 = 0, $20 = 0, $257 = 0, $258 = 0, $21 = 0, $22 = 0, $259 = 0, $24 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $278 = 0, $29 = 0, $29$hi = 0, $31$hi = 0, $34 = 0, $34$hi = 0, $36$hi = 0, $39 = 0, $39$hi = 0, $43$hi = 0, $70 = 0, $74 = 0, $81 = 0, $85 = 0, $94 = 0, $94$hi = 0, $106 = 0, $106$hi = 0, $128 = 0, $129 = 0, $129$hi = 0, $130 = 0, $130$hi = 0, $137$hi = 0, $140$hi = 0, $150 = 0, $150$hi = 0, $155$hi = 0, $162 = 0, $163 = 0, $163$hi = 0, $164 = 0, $164$hi = 0, $171$hi = 0, $174$hi = 0, $186 = 0, $186$hi = 0, $191$hi = 0, $194 = 0, $194$hi = 0, $196$hi = 0, $207 = 0, $207$hi = 0, $215 = 0, $215$hi = 0, $222 = 0, $222$hi = 0, $227 = 0, $227$hi = 0, $236 = 0, $236$hi = 0, $243 = 0, $243$hi = 0, $245 = 0, $245$hi = 0, $247 = 0, $247$hi = 0, $250 = 0, $252$hi = 0, $253 = 0, $253$hi = 0, $255 = 0, $255$hi = 0, $264 = 0, $264$hi = 0, $269 = 0, $269$hi = 0, $277 = 0, $277$hi = 0, $280$hi = 0, $23 = 0, $296 = 0, $296$hi = 0, $300 = 0, $301 = 0, $301$hi = 0, $305 = 0, $305$hi = 0, $309 = 0, $310$hi = 0, $311 = 0, $311$hi = 0, $312 = 0, $312$hi = 0, $315 = 0, $316$hi = 0, $319 = 0, $320$hi = 0, $321$hi = 0, $325 = 0, $326$hi = 0, $327$hi = 0, $330 = 0, $330$hi = 0, $331 = 0, $331$hi = 0, $338 = 0, $338$hi = 0, $344 = 0, $344$hi = 0, $346$hi = 0, $347 = 0, $347$hi = 0, $348 = 0, $348$hi = 0, $349 = 0, $349$hi = 0, $351$hi = 0, $355 = 0, $356$hi = 0, $357 = 0, $357$hi = 0, $358 = 0, $358$hi = 0, $360 = 0, $360$hi = 0, $363 = 0, $364$hi = 0, $367 = 0, $368$hi = 0, $369$hi = 0, $372 = 0, $373$hi = 0, $375$hi = 0, $376 = 0, $376$hi = 0, $380 = 0, $381$hi = 0, $382 = 0, $382$hi = 0, $383 = 0, $383$hi = 0, $386 = 0, $387$hi = 0, $390 = 0, $391$hi = 0, $392$hi = 0, $396 = 0, $397$hi = 0, $407 = 0, $407$hi = 0, $409$hi = 0, $412 = 0, $412$hi = 0, $414$hi = 0, $418 = 0, $418$hi = 0, $420$hi = 0, $454 = 0, $454$hi = 0, $456 = 0, $456$hi = 0, $457 = 0, $457$hi = 0, $459 = 0, $459$hi = 0, $463 = 0, $463$hi = 0, $465 = 0, $466$hi = 0, $471 = 0, $471$hi = 0, $475 = 0, $475$hi = 0, $484$hi = 0, $486 = 0, $486$hi = 0, $492 = 0, $498 = 0, $498$hi = 0, $503 = 0, $504$hi = 0, $508 = 0, $508$hi = 0, $512 = 0, $512$hi = 0, $515 = 0, $515$hi = 0, $519 = 0, $520$hi = 0;
  $5 = __stack_pointer - 96 | 0;
  __stack_pointer = $5;
  i64toi32_i32$0 = $1$hi;
  i64toi32_i32$2 = $1;
  i64toi32_i32$1 = 0;
  i64toi32_i32$3 = 32;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$1 = 0;
   $228 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
  } else {
   i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   $228 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
  }
  $29 = $228;
  $29$hi = i64toi32_i32$1;
  i64toi32_i32$1 = $2$hi;
  i64toi32_i32$0 = $2;
  i64toi32_i32$2 = 0;
  i64toi32_i32$3 = 32;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$2 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
   $229 = 0;
  } else {
   i64toi32_i32$2 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$0 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$1 << i64toi32_i32$4 | 0) | 0;
   $229 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
  }
  $31$hi = i64toi32_i32$2;
  i64toi32_i32$2 = $29$hi;
  i64toi32_i32$1 = $29;
  i64toi32_i32$0 = $31$hi;
  i64toi32_i32$3 = $229;
  i64toi32_i32$0 = i64toi32_i32$2 | i64toi32_i32$0 | 0;
  $6 = i64toi32_i32$1 | i64toi32_i32$3 | 0;
  $6$hi = i64toi32_i32$0;
  i64toi32_i32$0 = $3$hi;
  i64toi32_i32$2 = $3;
  i64toi32_i32$1 = 0;
  i64toi32_i32$3 = 17;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$1 = 0;
   $230 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
  } else {
   i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   $230 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
  }
  $34 = $230;
  $34$hi = i64toi32_i32$1;
  i64toi32_i32$1 = $4$hi;
  i64toi32_i32$0 = $4;
  i64toi32_i32$2 = 0;
  i64toi32_i32$3 = 47;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$2 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
   $231 = 0;
  } else {
   i64toi32_i32$2 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$0 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$1 << i64toi32_i32$4 | 0) | 0;
   $231 = i64toi32_i32$0 << i64toi32_i32$4 | 0;
  }
  $36$hi = i64toi32_i32$2;
  i64toi32_i32$2 = $34$hi;
  i64toi32_i32$1 = $34;
  i64toi32_i32$0 = $36$hi;
  i64toi32_i32$3 = $231;
  i64toi32_i32$0 = i64toi32_i32$2 | i64toi32_i32$0 | 0;
  $7 = i64toi32_i32$1 | i64toi32_i32$3 | 0;
  $7$hi = i64toi32_i32$0;
  i64toi32_i32$0 = $3$hi;
  i64toi32_i32$2 = $3;
  i64toi32_i32$1 = 0;
  i64toi32_i32$3 = 49;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$1 = 0;
   $232 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
  } else {
   i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   $232 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
  }
  $39 = $232;
  $39$hi = i64toi32_i32$1;
  i64toi32_i32$1 = $4$hi;
  i64toi32_i32$0 = $4;
  i64toi32_i32$2 = 65535;
  i64toi32_i32$3 = -1;
  i64toi32_i32$2 = i64toi32_i32$1 & i64toi32_i32$2 | 0;
  $8 = i64toi32_i32$0 & i64toi32_i32$3 | 0;
  $8$hi = i64toi32_i32$2;
  i64toi32_i32$1 = $8;
  i64toi32_i32$0 = 0;
  i64toi32_i32$3 = 15;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$0 = i64toi32_i32$1 << i64toi32_i32$4 | 0;
   $233 = 0;
  } else {
   i64toi32_i32$0 = ((1 << i64toi32_i32$4 | 0) - 1 | 0) & (i64toi32_i32$1 >>> (32 - i64toi32_i32$4 | 0) | 0) | 0 | (i64toi32_i32$2 << i64toi32_i32$4 | 0) | 0;
   $233 = i64toi32_i32$1 << i64toi32_i32$4 | 0;
  }
  $43$hi = i64toi32_i32$0;
  i64toi32_i32$0 = $39$hi;
  i64toi32_i32$2 = $39;
  i64toi32_i32$1 = $43$hi;
  i64toi32_i32$3 = $233;
  i64toi32_i32$1 = i64toi32_i32$0 | i64toi32_i32$1 | 0;
  $9 = i64toi32_i32$2 | i64toi32_i32$3 | 0;
  $9$hi = i64toi32_i32$1;
  i64toi32_i32$1 = $4$hi;
  i64toi32_i32$1 = $2$hi;
  i64toi32_i32$1 = $4$hi;
  i64toi32_i32$0 = $4;
  i64toi32_i32$2 = $2$hi;
  i64toi32_i32$3 = $2;
  i64toi32_i32$2 = i64toi32_i32$1 ^ i64toi32_i32$2 | 0;
  i64toi32_i32$1 = i64toi32_i32$0 ^ i64toi32_i32$3 | 0;
  i64toi32_i32$0 = -2147483648;
  i64toi32_i32$3 = 0;
  i64toi32_i32$0 = i64toi32_i32$2 & i64toi32_i32$0 | 0;
  $10 = i64toi32_i32$1 & i64toi32_i32$3 | 0;
  $10$hi = i64toi32_i32$0;
  i64toi32_i32$0 = $2$hi;
  i64toi32_i32$2 = $2;
  i64toi32_i32$1 = 65535;
  i64toi32_i32$3 = -1;
  i64toi32_i32$1 = i64toi32_i32$0 & i64toi32_i32$1 | 0;
  $11 = i64toi32_i32$2 & i64toi32_i32$3 | 0;
  $11$hi = i64toi32_i32$1;
  i64toi32_i32$0 = $11;
  i64toi32_i32$2 = 0;
  i64toi32_i32$3 = 32;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$2 = 0;
   $234 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
  } else {
   i64toi32_i32$2 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
   $234 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
  }
  $12 = $234;
  $12$hi = i64toi32_i32$2;
  i64toi32_i32$2 = $8$hi;
  i64toi32_i32$1 = $8;
  i64toi32_i32$0 = 0;
  i64toi32_i32$3 = 17;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$0 = 0;
   $235 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
  } else {
   i64toi32_i32$0 = i64toi32_i32$2 >>> i64toi32_i32$4 | 0;
   $235 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$2 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$1 >>> i64toi32_i32$4 | 0) | 0;
  }
  $13 = $235;
  $13$hi = i64toi32_i32$0;
  i64toi32_i32$0 = $4$hi;
  i64toi32_i32$2 = $4;
  i64toi32_i32$1 = 0;
  i64toi32_i32$3 = 48;
  i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
  if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
   i64toi32_i32$1 = 0;
   $237 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
  } else {
   i64toi32_i32$1 = i64toi32_i32$0 >>> i64toi32_i32$4 | 0;
   $237 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$0 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$2 >>> i64toi32_i32$4 | 0) | 0;
  }
  $14 = $237 & 32767 | 0;
  label$1 : {
   label$2 : {
    label$3 : {
     i64toi32_i32$1 = $2$hi;
     i64toi32_i32$0 = $2;
     i64toi32_i32$2 = 0;
     i64toi32_i32$3 = 48;
     i64toi32_i32$4 = i64toi32_i32$3 & 31 | 0;
     if (32 >>> 0 <= (i64toi32_i32$3 & 63 | 0) >>> 0) {
      i64toi32_i32$2 = 0;
      $238 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
     } else {
      i64toi32_i32$2 = i64toi32_i32$1 >>> i64toi32_i32$4 | 0;
      $238 = (((1 << i64toi32_i32$4 | 0) - 1 | 0) & i64toi32_i32$1 | 0) << (32 - i64toi32_i32$4 | 0) | 0 | (i64toi32_i32$0 >>> i64toi32_i32$4 | 0) | 0;
     }
     $15 = $238 & 32767 | 0;
     if (($15 + -1 | 0) >>> 0 > 32765 >>> 0) {
      break label$3
     }
     $16 = 0;
     if (($14 + -1 | 0) >>> 0 < 32766 >>> 0) {
      break label$2
     }
    }
    label$4 : {
     i64toi32_i32$2 = $1$hi;
     $70 = !($1 | i64toi32_i32$2 | 0);
     i64toi32_i32$2 = $2$hi;
     i64toi32_i32$1 = $2;
     i64toi32_i32$0 = 2147483647;
     i64toi32_i32$3 = -1;
     i64toi32_i32$0 = i64toi32_i32$2 & i64toi32_i32$0 | 0;
     $17 = i64toi32_i32$1 & i64toi32_i32$3 | 0;
     $17$hi = i64toi32_i32$0;
     i64toi32_i32$2 = $17;
     i64toi32_i32$1 = 2147418112;
     i64toi32_i32$3 = 0;
     $74 = i64toi32_i32$0 >>> 0 < i64toi32_i32$1 >>> 0 | ((i64toi32_i32$0 | 0) == (i64toi32_i32$1 | 0) & i64toi32_i32$2 >>> 0 < i64toi32_i32$3 >>> 0 | 0) | 0;
     i64toi32_i32$2 = i64toi32_i32$0;
     i64toi32_i32$2 = i64toi32_i32$0;
     i64toi32_i32$3 = $17;
     i64toi32_i32$0 = 2147418112;
     i64toi32_i32$1 = 0;
     if ((i64toi32_i32$3 | 0) == (i64toi32_i32$1 | 0) & (i64toi32_i32$2 | 0) == (i64toi32_i32$0 | 0) | 0 ? $70 : $74) {
      break label$4
     }
     i64toi32_i32$3 = $2$hi;
     i64toi32_i32$1 = $2;
     i64toi32_i32$2 = 32768;
     i64toi32_i32$0 = 0;
     i64toi32_i32$2 = i64toi32_i32$3 | i64toi32_i32$2 | 0;
     $10 = i64toi32_i32$1 | i64toi32_i32$0 | 0;
     $10$hi = i64toi32_i32$2;
     break label$1;
    }
    label$5 : {
     i64toi32_i32$2 = $3$hi;
     $81 = !($3 | i64toi32_i32$2 | 0);
     i64toi32_i32$2 = $4$hi;
     i64toi32_i32$3 = $4;
     i64toi32_i32$1 = 2147483647;
     i64toi32_i32$0 = -1;
     i64toi32_i32$1 = i64toi32_i32$2 & i64toi32_i32$1 | 0;
     $2 = i64toi32_i32$3 & i64toi32_i32$0 | 0;
     $2$hi = i64toi32_i32$1;
     i64toi32_i32$2 = $2;
     i64toi32_i32$3 = 2147418112;
     i64toi32_i32$0 = 0;
     $85 = i64toi32_i32$1 >>> 0 < i64toi32_i32$3 >>> 0 | ((i64toi32_i32$1 | 0) == (i64toi32_i32$3 | 0) & i64toi32_i32$2 >>> 0 < i64toi32_i32$0 >>> 0 | 0) | 0;
     i64toi32_i32$2 = i64toi32_i32$1;
     i64toi32_i32$0 = $2;
     i64toi32_i32$1 = 2147418112;
     i64toi32_i32$3 = 0;
     if ((i64toi32_i32$0 | 0) == (i64toi32_i32$3 | 0) & (i64toi32_i32$2 | 0) == (i64toi32_i32$1 | 0) | 0 ? $81 : $85) {
      break label$5
     }
     i64toi32_i32$0 = $4$hi;
     i64toi32_i32$3 = $4;
     i64toi32_i32$2 = 32768;
     i64toi32_i32$1 = 0;
     i64toi32_i32$2 = i64toi32_i32$0 | i64toi32_i32$2 | 0;
     $10 = i64toi32_i32$3 | i64toi32_i32$1 | 0;
     $10$hi = i64toi32_i32$2;
     i64toi32_i32$2 = $3$hi;
     $1 = $3;
     $1$hi = i64toi32_i32$2;
     break label$1;
    }
    label$6 : {
     i64toi32_i32$2 = $1$hi;
     i64toi32_i32$2 = $17$hi;
     i64toi32_i32$0 = $17;
     i64toi32_i32$3 = 2147418112;
     i64toi32_i32$1 = 0;
     i64toi32_i32$3 = i64toi32_i32$2 ^ i64toi32_i32$3 | 0;
     $94 = i64toi32_i32$0 ^ i64toi32_i32$1 | 0;
     $94$hi = i64toi32_i32$3;
     i64toi32_i32$3 = $1$hi;
     i64toi32_i32$2 = $1;
     i64toi32_i32$0 = $94$hi;
     i64toi32_i32$1 = $94;
     i64toi32_i32$0 = i64toi32_i32$3 | i64toi32_i32$0 | 0;
     i64toi32_i32$3 = i64toi32_i32$2 | i64toi32_i32$1 | 0;
     i64toi32_i32$2 = 0;
     i64toi32_i32$1 = 0;
     if ((i64toi32_i32$3 | 0) != (i64toi32_i32$1 | 0) | (i64toi32_i32$0 | 0) != (i64toi32_i32$2 | 0) | 0) {
      break label$6
     }
     label$7 : {
      i64toi32_i32$3 = $3$hi;
      i64toi32_i32$3 = $2$hi;
      i64toi32_i32$3 = $3$hi;
      i64toi32_i32$1 = $3;
      i64toi32_i32$0 = $2$hi;
      i64toi32_i32$2 = $2;
      i64toi32_i32$0 = i64toi32_i32$3 | i64toi32_i32$0 | 0;
      if (!!(i64toi32_i32$1 | i64toi32_i32$2 | 0 | i64toi32_i32$0 | 0)) {
       break label$7
      }
      i64toi32_i32$0 = 2147450880;
      $10 = 0;
      $10$hi = i64toi32_i32$0;
      i64toi32_i32$0 = 0;
      $1 = 0;
      $1$hi = i64toi32_i32$0;
      break label$1;
     }
     i64toi32_i32$0 = $10$hi;
     i64toi32_i32$3 = $10;
     i64toi32_i32$1 = 2147418112;
     i64toi32_i32$2 = 0;
     i64toi32_i32$1 = i64toi32_i32$0 | i64toi32_i32$1 | 0;
     $10 = i64toi32_i32$3 | i64toi32_i32$2 | 0;
     $10$hi = i64toi32_i32$1;
     i64toi32_i32$1 = 0;
     $1 = 0;
     $1$hi = i64toi32_i32$1;
     break label$1;
    }
    label$8 : {
     i64toi32_i32$1 = $3$hi;
     i64toi32_i32$1 = $2$hi;
     i64toi32_i32$0 = $2;
     i64toi32_i32$3 = 2147418112;
     i64toi32_i32$2 = 0;
     i64toi32_i32$