

// The Module object: Our interface to the outside world. We import
// and export values on it. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to check if Module already exists (e.g. case 3 above).
// Substitution will be replaced with actual code on later stage of the build,
// this way Closure Compiler will not mangle it (e.g. case 4. above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module = typeof Module !== 'undefined' ? Module : {};

// --pre-jses are emitted after the Module integration code, so that they can
// refer to Module (if they choose; they can also define Module)
// libflac.js - port of libflac to JavaScript using emscripten


(function (root, factory) {

	if (typeof define === 'function' && define.amd) {
		// AMD. Register as an anonymous module.
		define(['module', 'require'], factory.bind(null, root));
	} else if (typeof module === 'object' && module.exports) {
		// Node. Does not work with strict CommonJS, but
		// only CommonJS-like environments that support module.exports,
		// like Node.

		// use process.env (if available) for reading Flac environment settings:
		var env = typeof process !== 'undefined' && process && process.env? process.env : root;
		factory(env, module, module.require);
	} else {
		// Browser globals
		root.Flac = factory(root);
	}

}(typeof self !== 'undefined' ? self : typeof window !== 'undefined' ? window : this, function (global, expLib, require) {
'use strict';

var Module = Module || {};
var _flac_ready = false;
//in case resources are loaded asynchronously (e.g. *.mem file for minified version): setup "ready" handling
Module["onRuntimeInitialized"] = function(){
	_flac_ready = true;
	if(!_exported){
		//if _exported is not yet set (may happen, in case initialization was strictly synchronously),
		// do "pause" until sync initialization has run through
		setTimeout(function(){do_fire_event('ready', [{type: 'ready', target: _exported}], true);}, 0);
	} else {
		do_fire_event('ready', [{type: 'ready', target: _exported}], true);
	}
};

if(global && global.FLAC_SCRIPT_LOCATION){

	Module["locateFile"] = function(fileName){
		var path = global.FLAC_SCRIPT_LOCATION || '';
		if(path[fileName]){
			return path[fileName];
		}
		path += path && !/\/$/.test(path)? '/' : '';
		return path + fileName;
	};

	//NOTE will be overwritten if emscripten has env specific implementation for this
	var readBinary = function(filePath){

		//for Node: use default implementation (copied from generated code):
		if(ENVIRONMENT_IS_NODE){
			var ret = read_(filePath, true);
			if (!ret.buffer) {
				ret = new Uint8Array(ret);
			}
			assert(ret.buffer);
			return ret;
		}

		//otherwise: try "fallback" to AJAX
		return new Promise(function(resolve, reject){
			var xhr = new XMLHttpRequest();
			xhr.responseType = "arraybuffer";
			xhr.addEventListener("load", function(evt){
				resolve(xhr.response);
			});
			xhr.addEventListener("error", function(err){
				reject(err);
			});
			xhr.open("GET", filePath);
			xhr.send();
		});
	};
}

//fallback for fetch && support file://-protocol: try read as binary if fetch fails
if(global && typeof global.fetch === 'function'){
	var _fetch = global.fetch;
	global.fetch = function(url){
		return _fetch.apply(null, arguments).catch(function(err){
			try{
				var result = readBinary(url);
				if(result && result.catch){
					result.catch(function(_err){throw err});
				}
				return result;
			} catch(_err){
				throw err;
			}
		});
	};
}


// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
var key;
for (key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

var arguments_ = [];
var thisProgram = './this.program';
var quit_ = function(status, toThrow) {
  throw toThrow;
};

// Determine the runtime environment we are in. You can customize this by
// setting the ENVIRONMENT setting at compile time (see settings.js).

// Attempt to auto-detect the environment
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
// N.b. Electron.js environment is simultaneously a NODE-environment, but
// also a web environment.
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof process.versions === 'object' && typeof process.versions.node === 'string';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

// `/` should be present at the end if `scriptDirectory` is not empty
var scriptDirectory = '';
function locateFile(path) {
  if (Module['locateFile']) {
    return Module['locateFile'](path, scriptDirectory);
  }
  return scriptDirectory + path;
}

// Hooks that are implemented differently in different runtime environments.
var read_,
    readAsync,
    readBinary,
    setWindowTitle;

var nodeFS;
var nodePath;

if (ENVIRONMENT_IS_NODE) {
  if (ENVIRONMENT_IS_WORKER) {
    scriptDirectory = require('path').dirname(scriptDirectory) + '/';
  } else {
    scriptDirectory = __dirname + '/';
  }

// include: node_shell_read.js


read_ = function shell_read(filename, binary) {
  var ret = tryParseAsDataURI(filename);
  if (ret) {
    return binary ? ret : ret.toString();
  }
  if (!nodeFS) nodeFS = require('fs');
  if (!nodePath) nodePath = require('path');
  filename = nodePath['normalize'](filename);
  return nodeFS['readFileSync'](filename, binary ? null : 'utf8');
};

readBinary = function readBinary(filename) {
  var ret = read_(filename, true);
  if (!ret.buffer) {
    ret = new Uint8Array(ret);
  }
  assert(ret.buffer);
  return ret;
};

readAsync = function readAsync(filename, onload, onerror) {
  var ret = tryParseAsDataURI(filename);
  if (ret) {
    onload(ret);
  }
  if (!nodeFS) nodeFS = require('fs');
  if (!nodePath) nodePath = require('path');
  filename = nodePath['normalize'](filename);
  nodeFS['readFile'](filename, function(err, data) {
    if (err) onerror(err);
    else onload(data.buffer);
  });
};

// end include: node_shell_read.js
  if (process['argv'].length > 1) {
    thisProgram = process['argv'][1].replace(/\\/g, '/');
  }

  arguments_ = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  quit_ = function(status, toThrow) {
    if (keepRuntimeAlive()) {
      process['exitCode'] = status;
      throw toThrow;
    }
    process['exit'](status);
  };

  Module['inspect'] = function () { return '[Emscripten Module object]'; };

} else

// Note that this includes Node.js workers when relevant (pthreads is enabled).
// Node.js workers are detected as a combination of ENVIRONMENT_IS_WORKER and
// ENVIRONMENT_IS_NODE.
if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  if (ENVIRONMENT_IS_WORKER) { // Check worker, not web, since window could be polyfilled
    scriptDirectory = self.location.href;
  } else if (typeof document !== 'undefined' && document.currentScript) { // web
    scriptDirectory = document.currentScript.src;
  }
  // blob urls look like blob:http://site.com/etc/etc and we cannot infer anything from them.
  // otherwise, slice off the final part of the url to find the script directory.
  // if scriptDirectory does not contain a slash, lastIndexOf will return -1,
  // and scriptDirectory will correctly be replaced with an empty string.
  if (scriptDirectory.indexOf('blob:') !== 0) {
    scriptDirectory = scriptDirectory.substr(0, scriptDirectory.lastIndexOf('/')+1);
  } else {
    scriptDirectory = '';
  }

  // Differentiate the Web Worker from the Node Worker case, as reading must
  // be done differently.
  {

// include: web_or_worker_shell_read.js


  read_ = function(url) {
    try {
      var xhr = new XMLHttpRequest();
      xhr.open('GET', url, false);
      xhr.send(null);
      return xhr.responseText;
    } catch (err) {
      var data = tryParseAsDataURI(url);
      if (data) {
        return intArrayToString(data);
      }
      throw err;
    }
  };

  if (ENVIRONMENT_IS_WORKER) {
    readBinary = function(url) {
      try {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, false);
        xhr.responseType = 'arraybuffer';
        xhr.send(null);
        return new Uint8Array(/** @type{!ArrayBuffer} */(xhr.response));
      } catch (err) {
        var data = tryParseAsDataURI(url);
        if (data) {
          return data;
        }
        throw err;
      }
    };
  }

  readAsync = function(url, onload, onerror) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function() {
      if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
        onload(xhr.response);
        return;
      }
      var data = tryParseAsDataURI(url);
      if (data) {
        onload(data.buffer);
        return;
      }
      onerror();
    };
    xhr.onerror = onerror;
    xhr.send(null);
  };

// end include: web_or_worker_shell_read.js
  }

  setWindowTitle = function(title) { document.title = title };
} else
{
}

// Set up the out() and err() hooks, which are how we can print to stdout or
// stderr, respectively.
var out = Module['print'] || console.log.bind(console);
var err = Module['printErr'] || console.warn.bind(console);

// Merge back in the overrides
for (key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// Free the object hierarchy contained in the overrides, this lets the GC
// reclaim data used e.g. in memoryInitializerRequest, which is a large typed array.
moduleOverrides = null;

// Emit code to handle expected values on the Module object. This applies Module.x
// to the proper local x. This has two benefits: first, we only emit it if it is
// expected to arrive, and second, by using a local everywhere else that can be
// minified.

if (Module['arguments']) arguments_ = Module['arguments'];

if (Module['thisProgram']) thisProgram = Module['thisProgram'];

if (Module['quit']) quit_ = Module['quit'];

// perform assertions in shell.js after we set up out() and err(), as otherwise if an assertion fails it cannot print the message




var STACK_ALIGN = 16;

function getNativeTypeSize(type) {
  switch (type) {
    case 'i1': case 'i8': return 1;
    case 'i16': return 2;
    case 'i32': return 4;
    case 'i64': return 8;
    case 'float': return 4;
    case 'double': return 8;
    default: {
      if (type[type.length-1] === '*') {
        return 4; // A pointer
      } else if (type[0] === 'i') {
        var bits = Number(type.substr(1));
        assert(bits % 8 === 0, 'getNativeTypeSize invalid bits ' + bits + ', type ' + type);
        return bits / 8;
      } else {
        return 0;
      }
    }
  }
}

function warnOnce(text) {
  if (!warnOnce.shown) warnOnce.shown = {};
  if (!warnOnce.shown[text]) {
    warnOnce.shown[text] = 1;
    err(text);
  }
}

// include: runtime_functions.js


// Wraps a JS function as a wasm function with a given signature.
function convertJsFunctionToWasm(func, sig) {
  return func;
}

var freeTableIndexes = [];

// Weak map of functions in the table to their indexes, created on first use.
var functionsInTableMap;

function getEmptyTableSlot() {
  // Reuse a free index if there is one, otherwise grow.
  if (freeTableIndexes.length) {
    return freeTableIndexes.pop();
  }
  // Grow the table
  try {
    wasmTable.grow(1);
  } catch (err) {
    if (!(err instanceof RangeError)) {
      throw err;
    }
    throw 'Unable to grow wasm table. Set ALLOW_TABLE_GROWTH.';
  }
  return wasmTable.length - 1;
}

// Add a wasm function to the table.
function addFunctionWasm(func, sig) {
  // Check if the function is already in the table, to ensure each function
  // gets a unique index. First, create the map if this is the first use.
  if (!functionsInTableMap) {
    functionsInTableMap = new WeakMap();
    for (var i = 0; i < wasmTable.length; i++) {
      var item = wasmTable.get(i);
      // Ignore null values.
      if (item) {
        functionsInTableMap.set(item, i);
      }
    }
  }
  if (functionsInTableMap.has(func)) {
    return functionsInTableMap.get(func);
  }

  // It's not in the table, add it now.

  var ret = getEmptyTableSlot();

  // Set the new value.
  try {
    // Attempting to call this with JS function will cause of table.set() to fail
    wasmTable.set(ret, func);
  } catch (err) {
    if (!(err instanceof TypeError)) {
      throw err;
    }
    var wrapped = convertJsFunctionToWasm(func, sig);
    wasmTable.set(ret, wrapped);
  }

  functionsInTableMap.set(func, ret);

  return ret;
}

function removeFunction(index) {
  functionsInTableMap.delete(wasmTable.get(index));
  freeTableIndexes.push(index);
}

// 'sig' parameter is required for the llvm backend but only when func is not
// already a WebAssembly function.
function addFunction(func, sig) {

  return addFunctionWasm(func, sig);
}

// end include: runtime_functions.js
// include: runtime_debug.js


// end include: runtime_debug.js
var tempRet0 = 0;

var setTempRet0 = function(value) {
  tempRet0 = value;
};

var getTempRet0 = function() {
  return tempRet0;
};



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in:
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at:
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html

var wasmBinary;
if (Module['wasmBinary']) wasmBinary = Module['wasmBinary'];
var noExitRuntime = Module['noExitRuntime'] || true;

// include: wasm2js.js


// wasm2js.js - enough of a polyfill for the WebAssembly object so that we can load
// wasm2js code that way.

// Emit "var WebAssembly" if definitely using wasm2js. Otherwise, in MAYBE_WASM2JS
// mode, we can't use a "var" since it would prevent normal wasm from working.
/** @suppress{duplicate, const} */
var
WebAssembly = {
  // Note that we do not use closure quoting (this['buffer'], etc.) on these
  // functions, as they are just meant for internal use. In other words, this is
  // not a fully general polyfill.
  Memory: function(opts) {
    this.buffer = new ArrayBuffer(opts['initial'] * 65536);
  },

  Module: function(binary) {
    // TODO: use the binary and info somehow - right now the wasm2js output is embedded in
    // the main JS
  },

  Instance: function(module, info) {
    // TODO: use the module and info somehow - right now the wasm2js output is embedded in
    // the main JS
    // This will be replaced by the actual wasm2js code.
    this.exports = (
function instantiate(asmLibraryArg) {
function Table(ret) {
  ret.grow = function(by) {
    var old = this.length;
    this.length = this.length + by;
    return old;
  };
  ret.set = function(i, func) {
    this[i] = func;
  };
  ret.get = function(i) {
    return this[i];
  };
  return ret;
}

  var bufferView;
  var base64ReverseLookup = new Uint8Array(123/*'z'+1*/);
  for (var i = 25; i >= 0; --i) {
    base64ReverseLookup[48+i] = 52+i; // '0-9'
    base64ReverseLookup[65+i] = i; // 'A-Z'
    base64ReverseLookup[97+i] = 26+i; // 'a-z'
  }
  base64ReverseLookup[43] = 62; // '+'
  base64ReverseLookup[47] = 63; // '/'
  /** @noinline Inlining this function would mean expanding the base64 string 4x times in the source code, which Closure seems to be happy to do. */
  function base64DecodeToExistingUint8Array(uint8Array, offset, b64) {
    var b1, b2, i = 0, j = offset, bLength = b64.length, end = offset + (bLength*3>>2) - (b64[bLength-2] == '=') - (b64[bLength-1] == '=');
    for (; i < bLength; i += 4) {
      b1 = base64ReverseLookup[b64.charCodeAt(i+1)];
      b2 = base64ReverseLookup[b64.charCodeAt(i+2)];
      uint8Array[j++] = base64ReverseLookup[b64.charCodeAt(i)] << 2 | b1 >> 4;
      if (j < end) uint8Array[j++] = b1 << 4 | b2 >> 2;
      if (j < end) uint8Array[j++] = b2 << 6 | base64ReverseLookup[b64.charCodeAt(i+3)];
    }
  }
function initActiveSegments(imports) {
  base64DecodeToExistingUint8Array(bufferView, 1024, "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");
  base64DecodeToExistingUint8Array(bufferView, 10848, "UDdQAFsXAAArFwAAAAAAAAkAAAAAAAAAAAAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAAAAAAEAAAAOC8AAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD/////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUAAAAAAAAAAAAAAAkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoAAAALAAAASDMAAAAEAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAr/////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAArAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAQxkAAAEAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAAAAABDGQAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAEMZAAAAAAAAAAAAAAYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAQxkAAAEAAAABAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAAAAAAAABDGQAAAQAAAAAAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAAAAAAAAAEMZAAABAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAYAAAAAAAAAJhkAAAEAAAAAAAAADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABgAAAAAAAAAmGQAAAQAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGAAAAAAAAAPcYAAA=");
  base64DecodeToExistingUint8Array(bufferView, 11568, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==");
}

  var scratchBuffer = new ArrayBuffer(16);
  var i32ScratchView = new Int32Array(scratchBuffer);
  var f32ScratchView = new Float32Array(scratchBuffer);
  var f64ScratchView = new Float64Array(scratchBuffer);
  
  function wasm2js_scratch_load_i32(index) {
    return i32ScratchView[index];
  }
      
  function wasm2js_scratch_store_i32(index, value) {
    i32ScratchView[index] = value;
  }
      
  function wasm2js_scratch_load_f64() {
    return f64ScratchView[0];
  }
      
  function wasm2js_scratch_store_f64(value) {
    f64ScratchView[0] = value;
  }
      
  function wasm2js_scratch_store_f32(value) {
    f32ScratchView[2] = value;
  }
      
function asmFunc(env) {
 var memory = env.memory;
 var buffer = memory.buffer;
 memory.grow = __wasm_memory_grow;
 var HEAP8 = new Int8Array(buffer);
 var HEAP16 = new Int16Array(buffer);
 var HEAP32 = new Int32Array(buffer);
 var HEAPU8 = new Uint8Array(buffer);
 var HEAPU16 = new Uint16Array(buffer);
 var HEAPU32 = new Uint32Array(buffer);
 var HEAPF32 = new Float32Array(buffer);
 var HEAPF64 = new Float64Array(buffer);
 var Math_imul = Math.imul;
 var Math_fround = Math.fround;
 var Math_abs = Math.abs;
 var Math_clz32 = Math.clz32;
 var Math_min = Math.min;
 var Math_max = Math.max;
 var Math_floor = Math.floor;
 var Math_ceil = Math.ceil;
 var Math_trunc = Math.trunc;
 var Math_sqrt = Math.sqrt;
 var abort = env.abort;
 var nan = NaN;
 var infinity = Infinity;
 var emscripten_resize_heap = env.emscripten_resize_heap;
 var emscripten_memcpy_big = env.emscripten_memcpy_big;
 var __wasi_fd_close = env.fd_close;
 var __wasi_fd_read = env.fd_read;
 var __wasi_fd_write = env.fd_write;
 var setTempRet0 = env.setTempRet0;
 var legalimport$__wasi_fd_seek = env.fd_seek;
 var __stack_pointer = 5257040;
 var __wasm_intrinsics_temp_i64 = 0;
 var __wasm_intrinsics_temp_i64$hi = 0;
 var i64toi32_i32$HIGH_BITS = 0;
 // EMSCRIPTEN_START_FUNCS
;
 function __wasm_call_ctors() {
  
 }
 
 function stackSave() {
  return __stack_pointer | 0;
 }
 
 function stackRestore($0) {
  $0 = $0 | 0;
  __stack_pointer = $0;
 }
 
 function stackAlloc($0) {
  $0 = $0 | 0;
  $0 = __stack_pointer - $0 & -16;
  __stack_pointer = $0;
  return $0 | 0;
 }
 
 function __errno_location() {
  return 11568;
 }
 
 function sbrk($0) {
  var $1 = 0, $2 = 0;
  $1 = HEAP32[2712];
  $2 = $0 + 3 & -4;
  $0 = $1 + $2 | 0;
  label$1 : {
   if (!!$2 & $0 >>> 0 <= $1 >>> 0) {
    break label$1
   }
   if ($0 >>> 0 > __wasm_memory_size() << 16 >>> 0) {
    if (!(emscripten_resize_heap($0 | 0) | 0)) {
     break label$1
    }
   }
   HEAP32[2712] = $0;
   return $1;
  }
  HEAP32[2892] = 48;
  return -1;
 }
 
 function memset($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0;
  label$1 : {
   if (!$1) {
    break label$1
   }
   $2 = $0 + $1 | 0;
   HEAP8[$2 - 1 | 0] = 0;
   HEAP8[$0 | 0] = 0;
   if ($1 >>> 0 < 3) {
    break label$1
   }
   HEAP8[$2 - 2 | 0] = 0;
   HEAP8[$0 + 1 | 0] = 0;
   HEAP8[$2 - 3 | 0] = 0;
   HEAP8[$0 + 2 | 0] = 0;
   if ($1 >>> 0 < 7) {
    break label$1
   }
   HEAP8[$2 - 4 | 0] = 0;
   HEAP8[$0 + 3 | 0] = 0;
   if ($1 >>> 0 < 9) {
    break label$1
   }
   $4 = 0 - $0 & 3;
   $2 = $4 + $0 | 0;
   HEAP32[$2 >> 2] = 0;
   $4 = $1 - $4 & -4;
   $1 = $4 + $2 | 0;
   HEAP32[$1 - 4 >> 2] = 0;
   if ($4 >>> 0 < 9) {
    break label$1
   }
   HEAP32[$2 + 8 >> 2] = 0;
   HEAP32[$2 + 4 >> 2] = 0;
   HEAP32[$1 - 8 >> 2] = 0;
   HEAP32[$1 - 12 >> 2] = 0;
   if ($4 >>> 0 < 25) {
    break label$1
   }
   HEAP32[$2 + 24 >> 2] = 0;
   HEAP32[$2 + 20 >> 2] = 0;
   HEAP32[$2 + 16 >> 2] = 0;
   HEAP32[$2 + 12 >> 2] = 0;
   HEAP32[$1 - 16 >> 2] = 0;
   HEAP32[$1 - 20 >> 2] = 0;
   HEAP32[$1 - 24 >> 2] = 0;
   HEAP32[$1 - 28 >> 2] = 0;
   $3 = $2 & 4 | 24;
   $1 = $4 - $3 | 0;
   if ($1 >>> 0 < 32) {
    break label$1
   }
   $5 = __wasm_i64_mul(0, 0, 1, 1);
   $4 = i64toi32_i32$HIGH_BITS;
   $3 = $2 + $3 | 0;
   while (1) {
    HEAP32[$3 + 24 >> 2] = $5;
    $2 = $4;
    HEAP32[$3 + 28 >> 2] = $2;
    HEAP32[$3 + 16 >> 2] = $5;
    HEAP32[$3 + 20 >> 2] = $2;
    HEAP32[$3 + 8 >> 2] = $5;
    HEAP32[$3 + 12 >> 2] = $2;
    HEAP32[$3 >> 2] = $5;
    HEAP32[$3 + 4 >> 2] = $2;
    $3 = $3 + 32 | 0;
    $1 = $1 - 32 | 0;
    if ($1 >>> 0 > 31) {
     continue
    }
    break;
   };
  }
  return $0;
 }
 
 function __memcpy($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0;
  if ($2 >>> 0 >= 512) {
   emscripten_memcpy_big($0 | 0, $1 | 0, $2 | 0) | 0;
   return $0;
  }
  $4 = $0 + $2 | 0;
  label$2 : {
   if (!(($0 ^ $1) & 3)) {
    label$4 : {
     if (!($0 & 3)) {
      $2 = $0;
      break label$4;
     }
     if (($2 | 0) < 1) {
      $2 = $0;
      break label$4;
     }
     $2 = $0;
     while (1) {
      HEAP8[$2 | 0] = HEAPU8[$1 | 0];
      $1 = $1 + 1 | 0;
      $2 = $2 + 1 | 0;
      if (!($2 & 3)) {
       break label$4
      }
      if ($2 >>> 0 < $4 >>> 0) {
       continue
      }
      break;
     };
    }
    $3 = $4 & -4;
    label$8 : {
     if ($3 >>> 0 < 64) {
      break label$8
     }
     $5 = $3 + -64 | 0;
     if ($5 >>> 0 < $2 >>> 0) {
      break label$8
     }
     while (1) {
      HEAP32[$2 >> 2] = HEAP32[$1 >> 2];
      HEAP32[$2 + 4 >> 2] = HEAP32[$1 + 4 >> 2];
      HEAP32[$2 + 8 >> 2] = HEAP32[$1 + 8 >> 2];
      HEAP32[$2 + 12 >> 2] = HEAP32[$1 + 12 >> 2];
      HEAP32[$2 + 16 >> 2] = HEAP32[$1 + 16 >> 2];
      HEAP32[$2 + 20 >> 2] = HEAP32[$1 + 20 >> 2];
      HEAP32[$2 + 24 >> 2] = HEAP32[$1 + 24 >> 2];
      HEAP32[$2 + 28 >> 2] = HEAP32[$1 + 28 >> 2];
      HEAP32[$2 + 32 >> 2] = HEAP32[$1 + 32 >> 2];
      HEAP32[$2 + 36 >> 2] = HEAP32[$1 + 36 >> 2];
      HEAP32[$2 + 40 >> 2] = HEAP32[$1 + 40 >> 2];
      HEAP32[$2 + 44 >> 2] = HEAP32[$1 + 44 >> 2];
      HEAP32[$2 + 48 >> 2] = HEAP32[$1 + 48 >> 2];
      HEAP32[$2 + 52 >> 2] = HEAP32[$1 + 52 >> 2];
      HEAP32[$2 + 56 >> 2] = HEAP32[$1 + 56 >> 2];
      HEAP32[$2 + 60 >> 2] = HEAP32[$1 + 60 >> 2];
      $1 = $1 - -64 | 0;
      $2 = $2 - -64 | 0;
      if ($5 >>> 0 >= $2 >>> 0) {
       continue
      }
      break;
     };
    }
    if ($2 >>> 0 >= $3 >>> 0) {
     break label$2
    }
    while (1) {
     HEAP32[$2 >> 2] = HEAP32[$1 >> 2];
     $1 = $1 + 4 | 0;
     $2 = $2 + 4 | 0;
     if ($3 >>> 0 > $2 >>> 0) {
      continue
     }
     break;
    };
    break label$2;
   }
   if ($4 >>> 0 < 4) {
    $2 = $0;
    break label$2;
   }
   $3 = $4 - 4 | 0;
   if ($0 >>> 0 > $3 >>> 0) {
    $2 = $0;
    break label$2;
   }
   $2 = $0;
   while (1) {
    HEAP8[$2 | 0] = HEAPU8[$1 | 0];
    HEAP8[$2 + 1 | 0] = HEAPU8[$1 + 1 | 0];
    HEAP8[$2 + 2 | 0] = HEAPU8[$1 + 2 | 0];
    HEAP8[$2 + 3 | 0] = HEAPU8[$1 + 3 | 0];
    $1 = $1 + 4 | 0;
    $2 = $2 + 4 | 0;
    if ($3 >>> 0 >= $2 >>> 0) {
     continue
    }
    break;
   };
  }
  if ($2 >>> 0 < $4 >>> 0) {
   while (1) {
    HEAP8[$2 | 0] = HEAPU8[$1 | 0];
    $1 = $1 + 1 | 0;
    $2 = $2 + 1 | 0;
    if (($4 | 0) != ($2 | 0)) {
     continue
    }
    break;
   }
  }
  return $0;
 }
 
 function dlmalloc($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $11 = __stack_pointer - 16 | 0;
  __stack_pointer = $11;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       label$6 : {
        label$7 : {
         label$8 : {
          label$9 : {
           label$10 : {
            label$11 : {
             if ($0 >>> 0 <= 244) {
              $5 = HEAP32[2893];
              $7 = $0 >>> 0 < 11 ? 16 : $0 + 11 & -8;
              $2 = $7 >>> 3 | 0;
              $1 = $5 >>> $2 | 0;
              if ($1 & 3) {
               $3 = $2 + (($1 ^ -1) & 1) | 0;
               $1 = $3 << 3;
               $4 = HEAP32[$1 + 11620 >> 2];
               $0 = $4 + 8 | 0;
               $2 = HEAP32[$4 + 8 >> 2];
               $1 = $1 + 11612 | 0;
               label$14 : {
                if (($2 | 0) == ($1 | 0)) {
                 (wasm2js_i32$0 = 11572, wasm2js_i32$1 = __wasm_rotl_i32(-2, $3) & $5), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
                 break label$14;
                }
                HEAP32[$2 + 12 >> 2] = $1;
                HEAP32[$1 + 8 >> 2] = $2;
               }
               $1 = $3 << 3;
               HEAP32[$4 + 4 >> 2] = $1 | 3;
               $1 = $1 + $4 | 0;
               HEAP32[$1 + 4 >> 2] = HEAP32[$1 + 4 >> 2] | 1;
               break label$1;
              }
              $10 = HEAP32[2895];
              if ($10 >>> 0 >= $7 >>> 0) {
               break label$11
              }
              if ($1) {
               $0 = 2 << $2;
               $0 = (0 - $0 | $0) & $1 << $2;
               $1 = (0 - $0 & $0) - 1 | 0;
               $0 = $1 >>> 12 & 16;
               $2 = $0;
               $1 = $1 >>> $0 | 0;
               $0 = $1 >>> 5 & 8;
               $2 = $2 | $0;
               $1 = $1 >>> $0 | 0;
               $0 = $1 >>> 2 & 4;
               $2 = $2 | $0;
               $1 = $1 >>> $0 | 0;
               $0 = $1 >>> 1 & 2;
               $2 = $2 | $0;
               $1 = $1 >>> $0 | 0;
               $0 = $1 >>> 1 & 1;
               $3 = ($2 | $0) + ($1 >>> $0 | 0) | 0;
               $0 = $3 << 3;
               $4 = HEAP32[$0 + 11620 >> 2];
               $1 = HEAP32[$4 + 8 >> 2];
               $0 = $0 + 11612 | 0;
               label$17 : {
                if (($1 | 0) == ($0 | 0)) {
                 $5 = __wasm_rotl_i32(-2, $3) & $5;
                 HEAP32[2893] = $5;
                 break label$17;
                }
                HEAP32[$1 + 12 >> 2] = $0;
                HEAP32[$0 + 8 >> 2] = $1;
               }
               $0 = $4 + 8 | 0;
               HEAP32[$4 + 4 >> 2] = $7 | 3;
               $2 = $4 + $7 | 0;
               $1 = $3 << 3;
               $3 = $1 - $7 | 0;
               HEAP32[$2 + 4 >> 2] = $3 | 1;
               HEAP32[$1 + $4 >> 2] = $3;
               if ($10) {
                $1 = $10 >>> 3 | 0;
                $6 = ($1 << 3) + 11612 | 0;
                $4 = HEAP32[2898];
                $1 = 1 << $1;
                label$20 : {
                 if (!($1 & $5)) {
                  HEAP32[2893] = $1 | $5;
                  $1 = $6;
                  break label$20;
                 }
                 $1 = HEAP32[$6 + 8 >> 2];
                }
                HEAP32[$6 + 8 >> 2] = $4;
                HEAP32[$1 + 12 >> 2] = $4;
                HEAP32[$4 + 12 >> 2] = $6;
                HEAP32[$4 + 8 >> 2] = $1;
               }
               HEAP32[2898] = $2;
               HEAP32[2895] = $3;
               break label$1;
              }
              $9 = HEAP32[2894];
              if (!$9) {
               break label$11
              }
              $1 = ($9 & 0 - $9) - 1 | 0;
              $0 = $1 >>> 12 & 16;
              $2 = $0;
              $1 = $1 >>> $0 | 0;
              $0 = $1 >>> 5 & 8;
              $2 = $2 | $0;
              $1 = $1 >>> $0 | 0;
              $0 = $1 >>> 2 & 4;
              $2 = $2 | $0;
              $1 = $1 >>> $0 | 0;
              $0 = $1 >>> 1 & 2;
              $2 = $2 | $0;
              $1 = $1 >>> $0 | 0;
              $0 = $1 >>> 1 & 1;
              $1 = HEAP32[(($2 | $0) + ($1 >>> $0 | 0) << 2) + 11876 >> 2];
              $3 = (HEAP32[$1 + 4 >> 2] & -8) - $7 | 0;
              $2 = $1;
              while (1) {
               label$22 : {
                $0 = HEAP32[$2 + 16 >> 2];
                if (!$0) {
                 $0 = HEAP32[$2 + 20 >> 2];
                 if (!$0) {
                  break label$22
                 }
                }
                $2 = (HEAP32[$0 + 4 >> 2] & -8) - $7 | 0;
                $4 = $2 >>> 0 < $3 >>> 0;
                $3 = $4 ? $2 : $3;
                $1 = $4 ? $0 : $1;
                $2 = $0;
                continue;
               }
               break;
              };
              $8 = HEAP32[$1 + 24 >> 2];
              $4 = HEAP32[$1 + 12 >> 2];
              if (($1 | 0) != ($4 | 0)) {
               $0 = HEAP32[$1 + 8 >> 2];
               HEAP32[$0 + 12 >> 2] = $4;
               HEAP32[$4 + 8 >> 2] = $0;
               break label$2;
              }
              $2 = $1 + 20 | 0;
              $0 = HEAP32[$2 >> 2];
              if (!$0) {
               $0 = HEAP32[$1 + 16 >> 2];
               if (!$0) {
                break label$10
               }
               $2 = $1 + 16 | 0;
              }
              while (1) {
               $6 = $2;
               $4 = $0;
               $2 = $0 + 20 | 0;
               $0 = HEAP32[$2 >> 2];
               if ($0) {
                continue
               }
               $2 = $4 + 16 | 0;
               $0 = HEAP32[$4 + 16 >> 2];
               if ($0) {
                continue
               }
               break;
              };
              HEAP32[$6 >> 2] = 0;
              break label$2;
             }
             $7 = -1;
             if ($0 >>> 0 > 4294967231) {
              break label$11
             }
             $0 = $0 + 11 | 0;
             $7 = $0 & -8;
             $9 = HEAP32[2894];
             if (!$9) {
              break label$11
             }
             $3 = 0 - $7 | 0;
             $5 = 0;
             label$28 : {
              if ($7 >>> 0 < 256) {
               break label$28
              }
              $5 = 31;
              if ($7 >>> 0 > 16777215) {
               break label$28
              }
              $0 = $0 >>> 8 | 0;
              $4 = $0 + 1048320 >>> 16 & 8;
              $0 = $0 << $4;
              $2 = $0 + 520192 >>> 16 & 4;
              $0 = $0 << $2;
              $1 = $0 + 245760 >>> 16 & 2;
              $0 = ($0 << $1 >>> 15 | 0) - ($1 | ($2 | $4)) | 0;
              $5 = ($0 << 1 | $7 >>> $0 + 21 & 1) + 28 | 0;
             }
             $2 = HEAP32[($5 << 2) + 11876 >> 2];
             label$29 : {
              label$30 : {
               label$31 : {
                if (!$2) {
                 $0 = 0;
                 $4 = 0;
                 break label$31;
                }
                $0 = 0;
                $1 = $7 << (($5 | 0) == 31 ? 0 : 25 - ($5 >>> 1 | 0) | 0);
                $4 = 0;
                while (1) {
                 label$34 : {
                  $6 = (HEAP32[$2 + 4 >> 2] & -8) - $7 | 0;
                  if ($6 >>> 0 >= $3 >>> 0) {
                   break label$34
                  }
                  $4 = $2;
                  $3 = $6;
                  if ($3) {
                   break label$34
                  }
                  $3 = 0;
                  $0 = $2;
                  break label$30;
                 }
                 $6 = HEAP32[$2 + 20 >> 2];
                 $2 = HEAP32[(($1 >>> 29 & 4) + $2 | 0) + 16 >> 2];
                 $0 = $6 ? (($6 | 0) == ($2 | 0) ? $0 : $6) : $0;
                 $1 = $1 << 1;
                 if ($2) {
                  continue
                 }
                 break;
                };
               }
               if (!($0 | $4)) {
                $4 = 0;
                $0 = 2 << $5;
                $0 = (0 - $0 | $0) & $9;
                if (!$0) {
                 break label$11
                }
                $1 = ($0 & 0 - $0) - 1 | 0;
                $0 = $1 >>> 12 & 16;
                $2 = $0;
                $1 = $1 >>> $0 | 0;
                $0 = $1 >>> 5 & 8;
                $2 = $2 | $0;
                $1 = $1 >>> $0 | 0;
                $0 = $1 >>> 2 & 4;
                $2 = $2 | $0;
                $1 = $1 >>> $0 | 0;
                $0 = $1 >>> 1 & 2;
                $2 = $2 | $0;
                $1 = $1 >>> $0 | 0;
                $0 = $1 >>> 1 & 1;
                $0 = HEAP32[(($2 | $0) + ($1 >>> $0 | 0) << 2) + 11876 >> 2];
               }
               if (!$0) {
                break label$29
               }
              }
              while (1) {
               $1 = (HEAP32[$0 + 4 >> 2] & -8) - $7 | 0;
               $2 = $1 >>> 0 < $3 >>> 0;
               $3 = $2 ? $1 : $3;
               $4 = $2 ? $0 : $4;
               $1 = HEAP32[$0 + 16 >> 2];
               if ($1) {
                $0 = $1
               } else {
                $0 = HEAP32[$0 + 20 >> 2]
               }
               if ($0) {
                continue
               }
               break;
              };
             }
             if (!$4 | HEAP32[2895] - $7 >>> 0 <= $3 >>> 0) {
              break label$11
             }
             $5 = HEAP32[$4 + 24 >> 2];
             $1 = HEAP32[$4 + 12 >> 2];
             if (($1 | 0) != ($4 | 0)) {
              $0 = HEAP32[$4 + 8 >> 2];
              HEAP32[$0 + 12 >> 2] = $1;
              HEAP32[$1 + 8 >> 2] = $0;
              break label$3;
             }
             $2 = $4 + 20 | 0;
             $0 = HEAP32[$2 >> 2];
             if (!$0) {
              $0 = HEAP32[$4 + 16 >> 2];
              if (!$0) {
               break label$9
              }
              $2 = $4 + 16 | 0;
             }
             while (1) {
              $6 = $2;
              $1 = $0;
              $2 = $0 + 20 | 0;
              $0 = HEAP32[$2 >> 2];
              if ($0) {
               continue
              }
              $2 = $1 + 16 | 0;
              $0 = HEAP32[$1 + 16 >> 2];
              if ($0) {
               continue
              }
              break;
             };
             HEAP32[$6 >> 2] = 0;
             break label$3;
            }
            $2 = HEAP32[2895];
            if ($7 >>> 0 <= $2 >>> 0) {
             $3 = HEAP32[2898];
             $1 = $2 - $7 | 0;
             label$42 : {
              if ($1 >>> 0 >= 16) {
               HEAP32[2895] = $1;
               $0 = $3 + $7 | 0;
               HEAP32[2898] = $0;
               HEAP32[$0 + 4 >> 2] = $1 | 1;
               HEAP32[$2 + $3 >> 2] = $1;
               HEAP32[$3 + 4 >> 2] = $7 | 3;
               break label$42;
              }
              HEAP32[2898] = 0;
              HEAP32[2895] = 0;
              HEAP32[$3 + 4 >> 2] = $2 | 3;
              $0 = $2 + $3 | 0;
              HEAP32[$0 + 4 >> 2] = HEAP32[$0 + 4 >> 2] | 1;
             }
             $0 = $3 + 8 | 0;
             break label$1;
            }
            $5 = HEAP32[2896];
            if ($7 >>> 0 < $5 >>> 0) {
             $1 = $5 - $7 | 0;
             HEAP32[2896] = $1;
             $2 = HEAP32[2899];
             $0 = $2 + $7 | 0;
             HEAP32[2899] = $0;
             HEAP32[$0 + 4 >> 2] = $1 | 1;
             HEAP32[$2 + 4 >> 2] = $7 | 3;
             $0 = $2 + 8 | 0;
             break label$1;
            }
            $0 = 0;
            if (HEAP32[3011]) {
             $1 = HEAP32[3013]
            } else {
             HEAP32[3014] = -1;
             HEAP32[3015] = -1;
             HEAP32[3012] = 4096;
             HEAP32[3013] = 4096;
             HEAP32[3011] = $11 + 12 & -16 ^ 1431655768;
             HEAP32[3016] = 0;
             HEAP32[3004] = 0;
             $1 = 4096;
            }
            $9 = $7 + 47 | 0;
            $6 = $1 + $9 | 0;
            $4 = 0 - $1 | 0;
            $2 = $6 & $4;
            if ($2 >>> 0 <= $7 >>> 0) {
             break label$1
            }
            $1 = HEAP32[3003];
            if ($1) {
             $8 = $1;
             $3 = HEAP32[3001];
             $1 = $3 + $2 | 0;
             if ($8 >>> 0 < $1 >>> 0 | $1 >>> 0 <= $3 >>> 0) {
              break label$1
             }
            }
            if (HEAPU8[12016] & 4) {
             break label$6
            }
            label$48 : {
             label$49 : {
              $3 = HEAP32[2899];
              if ($3) {
               $0 = 12020;
               while (1) {
                $1 = HEAP32[$0 >> 2];
                if ($3 >>> 0 >= $1 >>> 0 & $3 >>> 0 < $1 + HEAP32[$0 + 4 >> 2] >>> 0) {
                 break label$49
                }
                $0 = HEAP32[$0 + 8 >> 2];
                if ($0) {
                 continue
                }
                break;
               };
              }
              $1 = sbrk(0);
              if (($1 | 0) == -1) {
               break label$7
              }
              $5 = $2;
              $3 = HEAP32[3012];
              $0 = $3 - 1 | 0;
              if ($0 & $1) {
               $5 = ($2 - $1 | 0) + ($0 + $1 & 0 - $3) | 0
              }
              if ($5 >>> 0 <= $7 >>> 0 | $5 >>> 0 > 2147483646) {
               break label$7
              }
              $0 = HEAP32[3003];
              if ($0) {
               $6 = $0;
               $3 = HEAP32[3001];
               $0 = $3 + $5 | 0;
               if ($6 >>> 0 < $0 >>> 0 | $0 >>> 0 <= $3 >>> 0) {
                break label$7
               }
              }
              $0 = sbrk($5);
              if (($1 | 0) != ($0 | 0)) {
               break label$48
              }
              break label$5;
             }
             $5 = $4 & $6 - $5;
             if ($5 >>> 0 > 2147483646) {
              break label$7
             }
             $1 = sbrk($5);
             if (($1 | 0) == (HEAP32[$0 >> 2] + HEAP32[$0 + 4 >> 2] | 0)) {
              break label$8
             }
             $0 = $1;
            }
            if (!(($0 | 0) == -1 | $7 + 48 >>> 0 <= $5 >>> 0)) {
             $1 = HEAP32[3013];
             $1 = $1 + ($9 - $5 | 0) & 0 - $1;
             if ($1 >>> 0 > 2147483646) {
              $1 = $0;
              break label$5;
             }
             if ((sbrk($1) | 0) != -1) {
              $5 = $1 + $5 | 0;
              $1 = $0;
              break label$5;
             }
             sbrk(0 - $5 | 0);
             break label$7;
            }
            $1 = $0;
            if (($0 | 0) != -1) {
             break label$5
            }
            break label$7;
           }
           $4 = 0;
           break label$2;
          }
          $1 = 0;
          break label$3;
         }
         if (($1 | 0) != -1) {
          break label$5
         }
        }
        HEAP32[3004] = HEAP32[3004] | 4;
       }
       if ($2 >>> 0 > 2147483646) {
        break label$4
       }
       $1 = sbrk($2);
       $0 = sbrk(0);
       if (($1 | 0) == -1 | ($0 | 0) == -1 | $0 >>> 0 <= $1 >>> 0) {
        break label$4
       }
       $5 = $0 - $1 | 0;
       if ($5 >>> 0 <= $7 + 40 >>> 0) {
        break label$4
       }
      }
      $0 = HEAP32[3001] + $5 | 0;
      HEAP32[3001] = $0;
      if (HEAPU32[3002] < $0 >>> 0) {
       HEAP32[3002] = $0
      }
      label$59 : {
       label$60 : {
        label$61 : {
         $6 = HEAP32[2899];
         if ($6) {
          $0 = 12020;
          while (1) {
           $3 = HEAP32[$0 >> 2];
           $2 = HEAP32[$0 + 4 >> 2];
           if (($3 + $2 | 0) == ($1 | 0)) {
            break label$61
           }
           $0 = HEAP32[$0 + 8 >> 2];
           if ($0) {
            continue
           }
           break;
          };
          break label$60;
         }
         $0 = HEAP32[2897];
         if (!(!!$0 & $0 >>> 0 <= $1 >>> 0)) {
          HEAP32[2897] = $1
         }
         $0 = 0;
         HEAP32[3006] = $5;
         HEAP32[3005] = $1;
         HEAP32[2901] = -1;
         HEAP32[2902] = HEAP32[3011];
         HEAP32[3008] = 0;
         while (1) {
          $3 = $0 << 3;
          $2 = $3 + 11612 | 0;
          HEAP32[$3 + 11620 >> 2] = $2;
          HEAP32[$3 + 11624 >> 2] = $2;
          $0 = $0 + 1 | 0;
          if (($0 | 0) != 32) {
           continue
          }
          break;
         };
         $3 = $5 - 40 | 0;
         $0 = $1 + 8 & 7 ? -8 - $1 & 7 : 0;
         $2 = $3 - $0 | 0;
         HEAP32[2896] = $2;
         $0 = $0 + $1 | 0;
         HEAP32[2899] = $0;
         HEAP32[$0 + 4 >> 2] = $2 | 1;
         HEAP32[($1 + $3 | 0) + 4 >> 2] = 40;
         HEAP32[2900] = HEAP32[3015];
         break label$59;
        }
        if (HEAPU8[$0 + 12 | 0] & 8 | $3 >>> 0 > $6 >>> 0 | $1 >>> 0 <= $6 >>> 0) {
         break label$60
        }
        HEAP32[$0 + 4 >> 2] = $2 + $5;
        $0 = $6 + 8 & 7 ? -8 - $6 & 7 : 0;
        $2 = $0 + $6 | 0;
        HEAP32[2899] = $2;
        $1 = HEAP32[2896] + $5 | 0;
        $0 = $1 - $0 | 0;
        HEAP32[2896] = $0;
        HEAP32[$2 + 4 >> 2] = $0 | 1;
        HEAP32[($1 + $6 | 0) + 4 >> 2] = 40;
        HEAP32[2900] = HEAP32[3015];
        break label$59;
       }
       if ($1 >>> 0 < HEAPU32[2897]) {
        HEAP32[2897] = $1
       }
       $2 = $1 + $5 | 0;
       $0 = 12020;
       label$68 : {
        label$69 : {
         label$70 : {
          label$71 : {
           label$72 : {
            label$73 : {
             while (1) {
              if (HEAP32[$0 >> 2] != ($2 | 0)) {
               $0 = HEAP32[$0 + 8 >> 2];
               if ($0) {
                continue
               }
               break label$73;
              }
              break;
             };
             if (!(HEAPU8[$0 + 12 | 0] & 8)) {
              break label$72
             }
            }
            $0 = 12020;
            while (1) {
             $2 = HEAP32[$0 >> 2];
             if ($6 >>> 0 >= $2 >>> 0) {
              $4 = $2 + HEAP32[$0 + 4 >> 2] | 0;
              if ($4 >>> 0 > $6 >>> 0) {
               break label$71
              }
             }
             $0 = HEAP32[$0 + 8 >> 2];
             continue;
            };
           }
           HEAP32[$0 >> 2] = $1;
           HEAP32[$0 + 4 >> 2] = HEAP32[$0 + 4 >> 2] + $5;
           $9 = ($1 + 8 & 7 ? -8 - $1 & 7 : 0) + $1 | 0;
           HEAP32[$9 + 4 >> 2] = $7 | 3;
           $5 = $2 + ($2 + 8 & 7 ? -8 - $2 & 7 : 0) | 0;
           $8 = $7 + $9 | 0;
           $2 = $5 - $8 | 0;
           if (($5 | 0) == ($6 | 0)) {
            HEAP32[2899] = $8;
            $0 = HEAP32[2896] + $2 | 0;
            HEAP32[2896] = $0;
            HEAP32[$8 + 4 >> 2] = $0 | 1;
            break label$69;
           }
           if (($5 | 0) == HEAP32[2898]) {
            HEAP32[2898] = $8;
            $0 = HEAP32[2895] + $2 | 0;
            HEAP32[2895] = $0;
            HEAP32[$8 + 4 >> 2] = $0 | 1;
            HEAP32[$0 + $8 >> 2] = $0;
            break label$69;
           }
           $0 = HEAP32[$5 + 4 >> 2];
           if (($0 & 3) == 1) {
            $6 = $0 & -8;
            label$81 : {
             if ($0 >>> 0 <= 255) {
              $3 = HEAP32[$5 + 8 >> 2];
              $0 = $0 >>> 3 | 0;
              $1 = HEAP32[$5 + 12 >> 2];
              if (($3 | 0) == ($1 | 0)) {
               (wasm2js_i32$0 = 11572, wasm2js_i32$1 = HEAP32[2893] & __wasm_rotl_i32(-2, $0)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
               break label$81;
              }
              HEAP32[$3 + 12 >> 2] = $1;
              HEAP32[$1 + 8 >> 2] = $3;
              break label$81;
             }
             $7 = HEAP32[$5 + 24 >> 2];
             $1 = HEAP32[$5 + 12 >> 2];
             label$84 : {
              if (($5 | 0) != ($1 | 0)) {
               $0 = HEAP32[$5 + 8 >> 2];
               HEAP32[$0 + 12 >> 2] = $1;
               HEAP32[$1 + 8 >> 2] = $0;
               break label$84;
              }
              label$86 : {
               $0 = $5 + 20 | 0;
               $3 = HEAP32[$0 >> 2];
               if ($3) {
                break label$86
               }
               $0 = $5 + 16 | 0;
               $3 = HEAP32[$0 >> 2];
               if ($3) {
                break label$86
               }
               $1 = 0;
               break label$84;
              }
              while (1) {
               $4 = $0;
               $1 = $3;
               $0 = $1 + 20 | 0;
               $3 = HEAP32[$0 >> 2];
               if ($3) {
                continue
               }
               $0 = $1 + 16 | 0;
               $3 = HEAP32[$1 + 16 >> 2];
               if ($3) {
                continue
               }
               break;
              };
              HEAP32[$4 >> 2] = 0;
             }
             if (!$7) {
              break label$81
             }
             $3 = HEAP32[$5 + 28 >> 2];
             $0 = ($3 << 2) + 11876 | 0;
             label$88 : {
              if (($5 | 0) == HEAP32[$0 >> 2]) {
               HEAP32[$0 >> 2] = $1;
               if ($1) {
                break label$88
               }
               (wasm2js_i32$0 = 11576, wasm2js_i32$1 = HEAP32[2894] & __wasm_rotl_i32(-2, $3)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
               break label$81;
              }
              HEAP32[$7 + (HEAP32[$7 + 16 >> 2] == ($5 | 0) ? 16 : 20) >> 2] = $1;
              if (!$1) {
               break label$81
              }
             }
             HEAP32[$1 + 24 >> 2] = $7;
             $0 = HEAP32[$5 + 16 >> 2];
             if ($0) {
              HEAP32[$1 + 16 >> 2] = $0;
              HEAP32[$0 + 24 >> 2] = $1;
             }
             $0 = HEAP32[$5 + 20 >> 2];
             if (!$0) {
              break label$81
             }
             HEAP32[$1 + 20 >> 2] = $0;
             HEAP32[$0 + 24 >> 2] = $1;
            }
            $5 = $5 + $6 | 0;
            $2 = $2 + $6 | 0;
           }
           HEAP32[$5 + 4 >> 2] = HEAP32[$5 + 4 >> 2] & -2;
           HEAP32[$8 + 4 >> 2] = $2 | 1;
           HEAP32[$2 + $8 >> 2] = $2;
           if ($2 >>> 0 <= 255) {
            $0 = $2 >>> 3 | 0;
            $2 = ($0 << 3) + 11612 | 0;
            $1 = HEAP32[2893];
            $0 = 1 << $0;
            label$92 : {
             if (!($1 & $0)) {
              HEAP32[2893] = $0 | $1;
              $0 = $2;
              break label$92;
             }
             $0 = HEAP32[$2 + 8 >> 2];
            }
            HEAP32[$2 + 8 >> 2] = $8;
            HEAP32[$0 + 12 >> 2] = $8;
            HEAP32[$8 + 12 >> 2] = $2;
            HEAP32[$8 + 8 >> 2] = $0;
            break label$69;
           }
           $0 = 31;
           if ($2 >>> 0 <= 16777215) {
            $0 = $2 >>> 8 | 0;
            $4 = $0 + 1048320 >>> 16 & 8;
            $0 = $0 << $4;
            $3 = $0 + 520192 >>> 16 & 4;
            $0 = $0 << $3;
            $1 = $0 + 245760 >>> 16 & 2;
            $0 = ($0 << $1 >>> 15 | 0) - ($1 | ($3 | $4)) | 0;
            $0 = ($0 << 1 | $2 >>> $0 + 21 & 1) + 28 | 0;
           }
           HEAP32[$8 + 28 >> 2] = $0;
           HEAP32[$8 + 16 >> 2] = 0;
           HEAP32[$8 + 20 >> 2] = 0;
           $4 = ($0 << 2) + 11876 | 0;
           $3 = HEAP32[2894];
           $1 = 1 << $0;
           label$95 : {
            if (!($3 & $1)) {
             HEAP32[2894] = $1 | $3;
             HEAP32[$4 >> 2] = $8;
             HEAP32[$8 + 24 >> 2] = $4;
             break label$95;
            }
            $0 = $2 << (($0 | 0) == 31 ? 0 : 25 - ($0 >>> 1 | 0) | 0);
            $1 = HEAP32[$4 >> 2];
            while (1) {
             $3 = $1;
             if ((HEAP32[$1 + 4 >> 2] & -8) == ($2 | 0)) {
              break label$70
             }
             $1 = $0 >>> 29 | 0;
             $0 = $0 << 1;
             $4 = ($3 + ($1 & 4) | 0) + 16 | 0;
             $1 = HEAP32[$4 >> 2];
             if ($1) {
              continue
             }
             break;
            };
            HEAP32[$4 >> 2] = $8;
            HEAP32[$8 + 24 >> 2] = $3;
           }
           HEAP32[$8 + 12 >> 2] = $8;
           HEAP32[$8 + 8 >> 2] = $8;
           break label$69;
          }
          $3 = $5 - 40 | 0;
          $0 = $1 + 8 & 7 ? -8 - $1 & 7 : 0;
          $2 = $3 - $0 | 0;
          HEAP32[2896] = $2;
          $0 = $0 + $1 | 0;
          HEAP32[2899] = $0;
          HEAP32[$0 + 4 >> 2] = $2 | 1;
          HEAP32[($1 + $3 | 0) + 4 >> 2] = 40;
          HEAP32[2900] = HEAP32[3015];
          $0 = ($4 + ($4 - 39 & 7 ? 39 - $4 & 7 : 0) | 0) - 47 | 0;
          $3 = $0 >>> 0 < $6 + 16 >>> 0 ? $6 : $0;
          HEAP32[$3 + 4 >> 2] = 27;
          $2 = HEAP32[3008];
          $0 = $3 + 16 | 0;
          HEAP32[$0 >> 2] = HEAP32[3007];
          HEAP32[$0 + 4 >> 2] = $2;
          $0 = HEAP32[3006];
          HEAP32[$3 + 8 >> 2] = HEAP32[3005];
          HEAP32[$3 + 12 >> 2] = $0;
          HEAP32[3007] = $3 + 8;
          HEAP32[3006] = $5;
          HEAP32[3005] = $1;
          HEAP32[3008] = 0;
          $0 = $3 + 24 | 0;
          while (1) {
           HEAP32[$0 + 4 >> 2] = 7;
           $1 = $0 + 8 | 0;
           $0 = $0 + 4 | 0;
           if ($1 >>> 0 < $4 >>> 0) {
            continue
           }
           break;
          };
          if (($3 | 0) == ($6 | 0)) {
           break label$59
          }
          HEAP32[$3 + 4 >> 2] = HEAP32[$3 + 4 >> 2] & -2;
          $4 = $3 - $6 | 0;
          HEAP32[$6 + 4 >> 2] = $4 | 1;
          HEAP32[$3 >> 2] = $4;
          if ($4 >>> 0 <= 255) {
           $0 = $4 >>> 3 | 0;
           $2 = ($0 << 3) + 11612 | 0;
           $1 = HEAP32[2893];
           $0 = 1 << $0;
           label$100 : {
            if (!($1 & $0)) {
             HEAP32[2893] = $0 | $1;
             $0 = $2;
             break label$100;
            }
            $0 = HEAP32[$2 + 8 >> 2];
           }
           HEAP32[$2 + 8 >> 2] = $6;
           HEAP32[$0 + 12 >> 2] = $6;
           HEAP32[$6 + 12 >> 2] = $2;
           HEAP32[$6 + 8 >> 2] = $0;
           break label$59;
          }
          $0 = 31;
          HEAP32[$6 + 16 >> 2] = 0;
          HEAP32[$6 + 20 >> 2] = 0;
          if ($4 >>> 0 <= 16777215) {
           $0 = $4 >>> 8 | 0;
           $3 = $0 + 1048320 >>> 16 & 8;
           $0 = $0 << $3;
           $2 = $0 + 520192 >>> 16 & 4;
           $0 = $0 << $2;
           $1 = $0 + 245760 >>> 16 & 2;
           $0 = ($0 << $1 >>> 15 | 0) - ($1 | ($2 | $3)) | 0;
           $0 = ($0 << 1 | $4 >>> $0 + 21 & 1) + 28 | 0;
          }
          HEAP32[$6 + 28 >> 2] = $0;
          $3 = ($0 << 2) + 11876 | 0;
          $2 = HEAP32[2894];
          $1 = 1 << $0;
          label$103 : {
           if (!($2 & $1)) {
            HEAP32[2894] = $1 | $2;
            HEAP32[$3 >> 2] = $6;
            HEAP32[$6 + 24 >> 2] = $3;
            break label$103;
           }
           $0 = $4 << (($0 | 0) == 31 ? 0 : 25 - ($0 >>> 1 | 0) | 0);
           $1 = HEAP32[$3 >> 2];
           while (1) {
            $2 = $1;
            if (($4 | 0) == (HEAP32[$1 + 4 >> 2] & -8)) {
             break label$68
            }
            $1 = $0 >>> 29 | 0;
            $0 = $0 << 1;
            $3 = ($2 + ($1 & 4) | 0) + 16 | 0;
            $1 = HEAP32[$3 >> 2];
            if ($1) {
             continue
            }
            break;
           };
           HEAP32[$3 >> 2] = $6;
           HEAP32[$6 + 24 >> 2] = $2;
          }
          HEAP32[$6 + 12 >> 2] = $6;
          HEAP32[$6 + 8 >> 2] = $6;
          break label$59;
         }
         $0 = HEAP32[$3 + 8 >> 2];
         HEAP32[$0 + 12 >> 2] = $8;
         HEAP32[$3 + 8 >> 2] = $8;
         HEAP32[$8 + 24 >> 2] = 0;
         HEAP32[$8 + 12 >> 2] = $3;
         HEAP32[$8 + 8 >> 2] = $0;
        }
        $0 = $9 + 8 | 0;
        break label$1;
       }
       $0 = HEAP32[$2 + 8 >> 2];
       HEAP32[$0 + 12 >> 2] = $6;
       HEAP32[$2 + 8 >> 2] = $6;
       HEAP32[$6 + 24 >> 2] = 0;
       HEAP32[$6 + 12 >> 2] = $2;
       HEAP32[$6 + 8 >> 2] = $0;
      }
      $0 = HEAP32[2896];
      if ($0 >>> 0 <= $7 >>> 0) {
       break label$4
      }
      $1 = $0 - $7 | 0;
      HEAP32[2896] = $1;
      $2 = HEAP32[2899];
      $0 = $2 + $7 | 0;
      HEAP32[2899] = $0;
      HEAP32[$0 + 4 >> 2] = $1 | 1;
      HEAP32[$2 + 4 >> 2] = $7 | 3;
      $0 = $2 + 8 | 0;
      break label$1;
     }
     HEAP32[2892] = 48;
     $0 = 0;
     break label$1;
    }
    label$106 : {
     if (!$5) {
      break label$106
     }
     $2 = HEAP32[$4 + 28 >> 2];
     $0 = ($2 << 2) + 11876 | 0;
     label$107 : {
      if (($4 | 0) == HEAP32[$0 >> 2]) {
       HEAP32[$0 >> 2] = $1;
       if ($1) {
        break label$107
       }
       $9 = __wasm_rotl_i32(-2, $2) & $9;
       HEAP32[2894] = $9;
       break label$106;
      }
      HEAP32[$5 + (HEAP32[$5 + 16 >> 2] == ($4 | 0) ? 16 : 20) >> 2] = $1;
      if (!$1) {
       break label$106
      }
     }
     HEAP32[$1 + 24 >> 2] = $5;
     $0 = HEAP32[$4 + 16 >> 2];
     if ($0) {
      HEAP32[$1 + 16 >> 2] = $0;
      HEAP32[$0 + 24 >> 2] = $1;
     }
     $0 = HEAP32[$4 + 20 >> 2];
     if (!$0) {
      break label$106
     }
     HEAP32[$1 + 20 >> 2] = $0;
     HEAP32[$0 + 24 >> 2] = $1;
    }
    label$110 : {
     if ($3 >>> 0 <= 15) {
      $0 = $3 + $7 | 0;
      HEAP32[$4 + 4 >> 2] = $0 | 3;
      $0 = $0 + $4 | 0;
      HEAP32[$0 + 4 >> 2] = HEAP32[$0 + 4 >> 2] | 1;
      break label$110;
     }
     HEAP32[$4 + 4 >> 2] = $7 | 3;
     $5 = $4 + $7 | 0;
     HEAP32[$5 + 4 >> 2] = $3 | 1;
     HEAP32[$3 + $5 >> 2] = $3;
     if ($3 >>> 0 <= 255) {
      $0 = $3 >>> 3 | 0;
      $2 = ($0 << 3) + 11612 | 0;
      $1 = HEAP32[2893];
      $0 = 1 << $0;
      label$113 : {
       if (!($1 & $0)) {
        HEAP32[2893] = $0 | $1;
        $0 = $2;
        break label$113;
       }
       $0 = HEAP32[$2 + 8 >> 2];
      }
      HEAP32[$2 + 8 >> 2] = $5;
      HEAP32[$0 + 12 >> 2] = $5;
      HEAP32[$5 + 12 >> 2] = $2;
      HEAP32[$5 + 8 >> 2] = $0;
      break label$110;
     }
     $0 = 31;
     if ($3 >>> 0 <= 16777215) {
      $0 = $3 >>> 8 | 0;
      $6 = $0 + 1048320 >>> 16 & 8;
      $0 = $0 << $6;
      $2 = $0 + 520192 >>> 16 & 4;
      $0 = $0 << $2;
      $1 = $0 + 245760 >>> 16 & 2;
      $0 = ($0 << $1 >>> 15 | 0) - ($1 | ($2 | $6)) | 0;
      $0 = ($0 << 1 | $3 >>> $0 + 21 & 1) + 28 | 0;
     }
     HEAP32[$5 + 28 >> 2] = $0;
     HEAP32[$5 + 16 >> 2] = 0;
     HEAP32[$5 + 20 >> 2] = 0;
     $1 = ($0 << 2) + 11876 | 0;
     label$116 : {
      $2 = 1 << $0;
      label$117 : {
       if (!($2 & $9)) {
        HEAP32[2894] = $2 | $9;
        HEAP32[$1 >> 2] = $5;
        break label$117;
       }
       $0 = $3 << (($0 | 0) == 31 ? 0 : 25 - ($0 >>> 1 | 0) | 0);
       $7 = HEAP32[$1 >> 2];
       while (1) {
        $1 = $7;
        if ((HEAP32[$1 + 4 >> 2] & -8) == ($3 | 0)) {
         break label$116
        }
        $2 = $0 >>> 29 | 0;
        $0 = $0 << 1;
        $2 = ($1 + ($2 & 4) | 0) + 16 | 0;
        $7 = HEAP32[$2 >> 2];
        if ($7) {
         continue
        }
        break;
       };
       HEAP32[$2 >> 2] = $5;
      }
      HEAP32[$5 + 24 >> 2] = $1;
      HEAP32[$5 + 12 >> 2] = $5;
      HEAP32[$5 + 8 >> 2] = $5;
      break label$110;
     }
     $0 = HEAP32[$1 + 8 >> 2];
     HEAP32[$0 + 12 >> 2] = $5;
     HEAP32[$1 + 8 >> 2] = $5;
     HEAP32[$5 + 24 >> 2] = 0;
     HEAP32[$5 + 12 >> 2] = $1;
     HEAP32[$5 + 8 >> 2] = $0;
    }
    $0 = $4 + 8 | 0;
    break label$1;
   }
   label$120 : {
    if (!$8) {
     break label$120
    }
    $2 = HEAP32[$1 + 28 >> 2];
    $0 = ($2 << 2) + 11876 | 0;
    label$121 : {
     if (($1 | 0) == HEAP32[$0 >> 2]) {
      HEAP32[$0 >> 2] = $4;
      if ($4) {
       break label$121
      }
      (wasm2js_i32$0 = 11576, wasm2js_i32$1 = __wasm_rotl_i32(-2, $2) & $9), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
      break label$120;
     }
     HEAP32[(HEAP32[$8 + 16 >> 2] == ($1 | 0) ? 16 : 20) + $8 >> 2] = $4;
     if (!$4) {
      break label$120
     }
    }
    HEAP32[$4 + 24 >> 2] = $8;
    $0 = HEAP32[$1 + 16 >> 2];
    if ($0) {
     HEAP32[$4 + 16 >> 2] = $0;
     HEAP32[$0 + 24 >> 2] = $4;
    }
    $0 = HEAP32[$1 + 20 >> 2];
    if (!$0) {
     break label$120
    }
    HEAP32[$4 + 20 >> 2] = $0;
    HEAP32[$0 + 24 >> 2] = $4;
   }
   label$124 : {
    if ($3 >>> 0 <= 15) {
     $0 = $3 + $7 | 0;
     HEAP32[$1 + 4 >> 2] = $0 | 3;
     $0 = $0 + $1 | 0;
     HEAP32[$0 + 4 >> 2] = HEAP32[$0 + 4 >> 2] | 1;
     break label$124;
    }
    HEAP32[$1 + 4 >> 2] = $7 | 3;
    $2 = $1 + $7 | 0;
    HEAP32[$2 + 4 >> 2] = $3 | 1;
    HEAP32[$2 + $3 >> 2] = $3;
    if ($10) {
     $0 = $10 >>> 3 | 0;
     $6 = ($0 << 3) + 11612 | 0;
     $4 = HEAP32[2898];
     $0 = 1 << $0;
     label$127 : {
      if (!($0 & $5)) {
       HEAP32[2893] = $0 | $5;
       $0 = $6;
       break label$127;
      }
      $0 = HEAP32[$6 + 8 >> 2];
     }
     HEAP32[$6 + 8 >> 2] = $4;
     HEAP32[$0 + 12 >> 2] = $4;
     HEAP32[$4 + 12 >> 2] = $6;
     HEAP32[$4 + 8 >> 2] = $0;
    }
    HEAP32[2898] = $2;
    HEAP32[2895] = $3;
   }
   $0 = $1 + 8 | 0;
  }
  __stack_pointer = $11 + 16 | 0;
  return $0;
 }
 
 function dlfree($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $3 = $0 - 8 | 0;
   $1 = HEAP32[$0 - 4 >> 2];
   $0 = $1 & -8;
   $5 = $3 + $0 | 0;
   label$2 : {
    if ($1 & 1) {
     break label$2
    }
    if (!($1 & 3)) {
     break label$1
    }
    $1 = HEAP32[$3 >> 2];
    $3 = $3 - $1 | 0;
    if ($3 >>> 0 < HEAPU32[2897]) {
     break label$1
    }
    $0 = $0 + $1 | 0;
    if (($3 | 0) != HEAP32[2898]) {
     if ($1 >>> 0 <= 255) {
      $2 = HEAP32[$3 + 8 >> 2];
      $4 = $1 >>> 3 | 0;
      $1 = HEAP32[$3 + 12 >> 2];
      if (($2 | 0) == ($1 | 0)) {
       (wasm2js_i32$0 = 11572, wasm2js_i32$1 = HEAP32[2893] & __wasm_rotl_i32(-2, $4)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
       break label$2;
      }
      HEAP32[$2 + 12 >> 2] = $1;
      HEAP32[$1 + 8 >> 2] = $2;
      break label$2;
     }
     $7 = HEAP32[$3 + 24 >> 2];
     $1 = HEAP32[$3 + 12 >> 2];
     label$6 : {
      if (($3 | 0) != ($1 | 0)) {
       $2 = HEAP32[$3 + 8 >> 2];
       HEAP32[$2 + 12 >> 2] = $1;
       HEAP32[$1 + 8 >> 2] = $2;
       break label$6;
      }
      label$8 : {
       $2 = $3 + 20 | 0;
       $4 = HEAP32[$2 >> 2];
       if ($4) {
        break label$8
       }
       $2 = $3 + 16 | 0;
       $4 = HEAP32[$2 >> 2];
       if ($4) {
        break label$8
       }
       $1 = 0;
       break label$6;
      }
      while (1) {
       $6 = $2;
       $1 = $4;
       $2 = $1 + 20 | 0;
       $4 = HEAP32[$2 >> 2];
       if ($4) {
        continue
       }
       $2 = $1 + 16 | 0;
       $4 = HEAP32[$1 + 16 >> 2];
       if ($4) {
        continue
       }
       break;
      };
      HEAP32[$6 >> 2] = 0;
     }
     if (!$7) {
      break label$2
     }
     $2 = HEAP32[$3 + 28 >> 2];
     $4 = ($2 << 2) + 11876 | 0;
     label$10 : {
      if (($3 | 0) == HEAP32[$4 >> 2]) {
       HEAP32[$4 >> 2] = $1;
       if ($1) {
        break label$10
       }
       (wasm2js_i32$0 = 11576, wasm2js_i32$1 = HEAP32[2894] & __wasm_rotl_i32(-2, $2)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
       break label$2;
      }
      HEAP32[$7 + (HEAP32[$7 + 16 >> 2] == ($3 | 0) ? 16 : 20) >> 2] = $1;
      if (!$1) {
       break label$2
      }
     }
     HEAP32[$1 + 24 >> 2] = $7;
     $2 = HEAP32[$3 + 16 >> 2];
     if ($2) {
      HEAP32[$1 + 16 >> 2] = $2;
      HEAP32[$2 + 24 >> 2] = $1;
     }
     $2 = HEAP32[$3 + 20 >> 2];
     if (!$2) {
      break label$2
     }
     HEAP32[$1 + 20 >> 2] = $2;
     HEAP32[$2 + 24 >> 2] = $1;
     break label$2;
    }
    $1 = HEAP32[$5 + 4 >> 2];
    if (($1 & 3) != 3) {
     break label$2
    }
    HEAP32[2895] = $0;
    HEAP32[$5 + 4 >> 2] = $1 & -2;
    HEAP32[$3 + 4 >> 2] = $0 | 1;
    HEAP32[$0 + $3 >> 2] = $0;
    return;
   }
   if ($3 >>> 0 >= $5 >>> 0) {
    break label$1
   }
   $1 = HEAP32[$5 + 4 >> 2];
   if (!($1 & 1)) {
    break label$1
   }
   label$13 : {
    if (!($1 & 2)) {
     if (HEAP32[2899] == ($5 | 0)) {
      HEAP32[2899] = $3;
      $0 = HEAP32[2896] + $0 | 0;
      HEAP32[2896] = $0;
      HEAP32[$3 + 4 >> 2] = $0 | 1;
      if (HEAP32[2898] != ($3 | 0)) {
       break label$1
      }
      HEAP32[2895] = 0;
      HEAP32[2898] = 0;
      return;
     }
     if (HEAP32[2898] == ($5 | 0)) {
      HEAP32[2898] = $3;
      $0 = HEAP32[2895] + $0 | 0;
      HEAP32[2895] = $0;
      HEAP32[$3 + 4 >> 2] = $0 | 1;
      HEAP32[$0 + $3 >> 2] = $0;
      return;
     }
     $0 = ($1 & -8) + $0 | 0;
     label$17 : {
      if ($1 >>> 0 <= 255) {
       $2 = HEAP32[$5 + 8 >> 2];
       $4 = $1 >>> 3 | 0;
       $1 = HEAP32[$5 + 12 >> 2];
       if (($2 | 0) == ($1 | 0)) {
        (wasm2js_i32$0 = 11572, wasm2js_i32$1 = HEAP32[2893] & __wasm_rotl_i32(-2, $4)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
        break label$17;
       }
       HEAP32[$2 + 12 >> 2] = $1;
       HEAP32[$1 + 8 >> 2] = $2;
       break label$17;
      }
      $7 = HEAP32[$5 + 24 >> 2];
      $1 = HEAP32[$5 + 12 >> 2];
      label$20 : {
       if (($1 | 0) != ($5 | 0)) {
        $2 = HEAP32[$5 + 8 >> 2];
        HEAP32[$2 + 12 >> 2] = $1;
        HEAP32[$1 + 8 >> 2] = $2;
        break label$20;
       }
       label$22 : {
        $2 = $5 + 20 | 0;
        $4 = HEAP32[$2 >> 2];
        if ($4) {
         break label$22
        }
        $2 = $5 + 16 | 0;
        $4 = HEAP32[$2 >> 2];
        if ($4) {
         break label$22
        }
        $1 = 0;
        break label$20;
       }
       while (1) {
        $6 = $2;
        $1 = $4;
        $2 = $1 + 20 | 0;
        $4 = HEAP32[$2 >> 2];
        if ($4) {
         continue
        }
        $2 = $1 + 16 | 0;
        $4 = HEAP32[$1 + 16 >> 2];
        if ($4) {
         continue
        }
        break;
       };
       HEAP32[$6 >> 2] = 0;
      }
      if (!$7) {
       break label$17
      }
      $2 = HEAP32[$5 + 28 >> 2];
      $4 = ($2 << 2) + 11876 | 0;
      label$24 : {
       if (HEAP32[$4 >> 2] == ($5 | 0)) {
        HEAP32[$4 >> 2] = $1;
        if ($1) {
         break label$24
        }
        (wasm2js_i32$0 = 11576, wasm2js_i32$1 = HEAP32[2894] & __wasm_rotl_i32(-2, $2)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
        break label$17;
       }
       HEAP32[$7 + (($5 | 0) == HEAP32[$7 + 16 >> 2] ? 16 : 20) >> 2] = $1;
       if (!$1) {
        break label$17
       }
      }
      HEAP32[$1 + 24 >> 2] = $7;
      $2 = HEAP32[$5 + 16 >> 2];
      if ($2) {
       HEAP32[$1 + 16 >> 2] = $2;
       HEAP32[$2 + 24 >> 2] = $1;
      }
      $2 = HEAP32[$5 + 20 >> 2];
      if (!$2) {
       break label$17
      }
      HEAP32[$1 + 20 >> 2] = $2;
      HEAP32[$2 + 24 >> 2] = $1;
     }
     HEAP32[$3 + 4 >> 2] = $0 | 1;
     HEAP32[$0 + $3 >> 2] = $0;
     if (HEAP32[2898] != ($3 | 0)) {
      break label$13
     }
     HEAP32[2895] = $0;
     return;
    }
    HEAP32[$5 + 4 >> 2] = $1 & -2;
    HEAP32[$3 + 4 >> 2] = $0 | 1;
    HEAP32[$0 + $3 >> 2] = $0;
   }
   if ($0 >>> 0 <= 255) {
    $1 = $0 >>> 3 | 0;
    $0 = ($1 << 3) + 11612 | 0;
    $2 = HEAP32[2893];
    $1 = 1 << $1;
    label$28 : {
     if (!($2 & $1)) {
      HEAP32[2893] = $1 | $2;
      $2 = $0;
      break label$28;
     }
     $2 = HEAP32[$0 + 8 >> 2];
    }
    HEAP32[$0 + 8 >> 2] = $3;
    HEAP32[$2 + 12 >> 2] = $3;
    HEAP32[$3 + 12 >> 2] = $0;
    HEAP32[$3 + 8 >> 2] = $2;
    return;
   }
   $2 = 31;
   HEAP32[$3 + 16 >> 2] = 0;
   HEAP32[$3 + 20 >> 2] = 0;
   if ($0 >>> 0 <= 16777215) {
    $2 = $0 >>> 8 | 0;
    $1 = $2 + 1048320 >>> 16 & 8;
    $4 = $2 << $1;
    $2 = $4 + 520192 >>> 16 & 4;
    $6 = $4 << $2;
    $4 = $6 + 245760 >>> 16 & 2;
    $1 = ($6 << $4 >>> 15 | 0) - ($4 | ($1 | $2)) | 0;
    $2 = ($1 << 1 | $0 >>> $1 + 21 & 1) + 28 | 0;
   }
   HEAP32[$3 + 28 >> 2] = $2;
   $1 = ($2 << 2) + 11876 | 0;
   label$31 : {
    label$32 : {
     $4 = HEAP32[2894];
     $6 = 1 << $2;
     label$33 : {
      if (!($4 & $6)) {
       HEAP32[2894] = $4 | $6;
       HEAP32[$1 >> 2] = $3;
       HEAP32[$3 + 24 >> 2] = $1;
       break label$33;
      }
      $2 = $0 << (($2 | 0) == 31 ? 0 : 25 - ($2 >>> 1 | 0) | 0);
      $1 = HEAP32[$1 >> 2];
      while (1) {
       $4 = $1;
       if ((HEAP32[$1 + 4 >> 2] & -8) == ($0 | 0)) {
        break label$32
       }
       $1 = $2 >>> 29 | 0;
       $2 = $2 << 1;
       $6 = ($4 + ($1 & 4) | 0) + 16 | 0;
       $1 = HEAP32[$6 >> 2];
       if ($1) {
        continue
       }
       break;
      };
      HEAP32[$6 >> 2] = $3;
      HEAP32[$3 + 24 >> 2] = $4;
     }
     HEAP32[$3 + 12 >> 2] = $3;
     HEAP32[$3 + 8 >> 2] = $3;
     break label$31;
    }
    $0 = HEAP32[$4 + 8 >> 2];
    HEAP32[$0 + 12 >> 2] = $3;
    HEAP32[$4 + 8 >> 2] = $3;
    HEAP32[$3 + 24 >> 2] = 0;
    HEAP32[$3 + 12 >> 2] = $4;
    HEAP32[$3 + 8 >> 2] = $0;
   }
   $0 = HEAP32[2901] - 1 | 0;
   HEAP32[2901] = $0 ? $0 : -1;
  }
 }
 
 function dlcalloc($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0;
  $2 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $3 = __wasm_i64_mul($0, 0, $1, 0);
   $4 = i64toi32_i32$HIGH_BITS;
   $2 = $3;
   if (($0 | $1) >>> 0 < 65536) {
    break label$1
   }
   $2 = $4 ? -1 : $3;
  }
  $3 = $2;
  $0 = dlmalloc($3);
  if (!(!$0 | !(HEAPU8[$0 - 4 | 0] & 3))) {
   memset($0, $3)
  }
  return $0;
 }
 
 function dlrealloc($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  if (!$0) {
   return dlmalloc($1)
  }
  if ($1 >>> 0 >= 4294967232) {
   HEAP32[2892] = 48;
   return 0;
  }
  $6 = $1 >>> 0 < 11 ? 16 : $1 + 11 & -8;
  $5 = $0 - 8 | 0;
  $9 = HEAP32[$5 + 4 >> 2];
  $4 = $9 & -8;
  __inlined_func$try_realloc_chunk : {
   label$1 : {
    if (!($9 & 3)) {
     $2 = 0;
     if ($6 >>> 0 < 256) {
      break __inlined_func$try_realloc_chunk
     }
     if ($6 + 4 >>> 0 <= $4 >>> 0) {
      $2 = $5;
      if ($4 - $6 >>> 0 <= HEAP32[3013] << 1 >>> 0) {
       break label$1
      }
     }
     $2 = 0;
     break __inlined_func$try_realloc_chunk;
    }
    $7 = $4 + $5 | 0;
    label$5 : {
     if ($4 >>> 0 >= $6 >>> 0) {
      $3 = $4 - $6 | 0;
      if ($3 >>> 0 < 16) {
       break label$5
      }
      HEAP32[$5 + 4 >> 2] = $9 & 1 | $6 | 2;
      $2 = $5 + $6 | 0;
      HEAP32[$2 + 4 >> 2] = $3 | 3;
      HEAP32[$7 + 4 >> 2] = HEAP32[$7 + 4 >> 2] | 1;
      dispose_chunk($2, $3);
      break label$5;
     }
     if (($7 | 0) == HEAP32[2899]) {
      $4 = $4 + HEAP32[2896] | 0;
      if ($4 >>> 0 <= $6 >>> 0) {
       break label$1
      }
      HEAP32[$5 + 4 >> 2] = $9 & 1 | $6 | 2;
      $3 = $5 + $6 | 0;
      $2 = $4 - $6 | 0;
      HEAP32[$3 + 4 >> 2] = $2 | 1;
      HEAP32[2896] = $2;
      HEAP32[2899] = $3;
      break label$5;
     }
     if (($7 | 0) == HEAP32[2898]) {
      $3 = $4 + HEAP32[2895] | 0;
      if ($3 >>> 0 < $6 >>> 0) {
       break label$1
      }
      $2 = $3 - $6 | 0;
      label$9 : {
       if ($2 >>> 0 >= 16) {
        HEAP32[$5 + 4 >> 2] = $9 & 1 | $6 | 2;
        $4 = $5 + $6 | 0;
        HEAP32[$4 + 4 >> 2] = $2 | 1;
        $3 = $3 + $5 | 0;
        HEAP32[$3 >> 2] = $2;
        HEAP32[$3 + 4 >> 2] = HEAP32[$3 + 4 >> 2] & -2;
        break label$9;
       }
       HEAP32[$5 + 4 >> 2] = $3 | $9 & 1 | 2;
       $2 = $3 + $5 | 0;
       HEAP32[$2 + 4 >> 2] = HEAP32[$2 + 4 >> 2] | 1;
       $2 = 0;
       $4 = 0;
      }
      HEAP32[2898] = $4;
      HEAP32[2895] = $2;
      break label$5;
     }
     $3 = HEAP32[$7 + 4 >> 2];
     if ($3 & 2) {
      break label$1
     }
     $10 = $4 + ($3 & -8) | 0;
     if ($10 >>> 0 < $6 >>> 0) {
      break label$1
     }
     $12 = $10 - $6 | 0;
     label$11 : {
      if ($3 >>> 0 <= 255) {
       $4 = HEAP32[$7 + 8 >> 2];
       $2 = $3 >>> 3 | 0;
       $3 = HEAP32[$7 + 12 >> 2];
       if (($4 | 0) == ($3 | 0)) {
        (wasm2js_i32$0 = 11572, wasm2js_i32$1 = HEAP32[2893] & __wasm_rotl_i32(-2, $2)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
        break label$11;
       }
       HEAP32[$4 + 12 >> 2] = $3;
       HEAP32[$3 + 8 >> 2] = $4;
       break label$11;
      }
      $11 = HEAP32[$7 + 24 >> 2];
      $8 = HEAP32[$7 + 12 >> 2];
      label$14 : {
       if (($7 | 0) != ($8 | 0)) {
        $2 = HEAP32[$7 + 8 >> 2];
        HEAP32[$2 + 12 >> 2] = $8;
        HEAP32[$8 + 8 >> 2] = $2;
        break label$14;
       }
       label$16 : {
        $4 = $7 + 20 | 0;
        $2 = HEAP32[$4 >> 2];
        if ($2) {
         break label$16
        }
        $4 = $7 + 16 | 0;
        $2 = HEAP32[$4 >> 2];
        if ($2) {
         break label$16
        }
        $8 = 0;
        break label$14;
       }
       while (1) {
        $3 = $4;
        $8 = $2;
        $4 = $2 + 20 | 0;
        $2 = HEAP32[$4 >> 2];
        if ($2) {
         continue
        }
        $4 = $8 + 16 | 0;
        $2 = HEAP32[$8 + 16 >> 2];
        if ($2) {
         continue
        }
        break;
       };
       HEAP32[$3 >> 2] = 0;
      }
      if (!$11) {
       break label$11
      }
      $3 = HEAP32[$7 + 28 >> 2];
      $2 = ($3 << 2) + 11876 | 0;
      label$18 : {
       if (($7 | 0) == HEAP32[$2 >> 2]) {
        HEAP32[$2 >> 2] = $8;
        if ($8) {
         break label$18
        }
        (wasm2js_i32$0 = 11576, wasm2js_i32$1 = HEAP32[2894] & __wasm_rotl_i32(-2, $3)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
        break label$11;
       }
       HEAP32[(HEAP32[$11 + 16 >> 2] == ($7 | 0) ? 16 : 20) + $11 >> 2] = $8;
       if (!$8) {
        break label$11
       }
      }
      HEAP32[$8 + 24 >> 2] = $11;
      $2 = HEAP32[$7 + 16 >> 2];
      if ($2) {
       HEAP32[$8 + 16 >> 2] = $2;
       HEAP32[$2 + 24 >> 2] = $8;
      }
      $2 = HEAP32[$7 + 20 >> 2];
      if (!$2) {
       break label$11
      }
      HEAP32[$8 + 20 >> 2] = $2;
      HEAP32[$2 + 24 >> 2] = $8;
     }
     if ($12 >>> 0 <= 15) {
      HEAP32[$5 + 4 >> 2] = $9 & 1 | $10 | 2;
      $2 = $5 + $10 | 0;
      HEAP32[$2 + 4 >> 2] = HEAP32[$2 + 4 >> 2] | 1;
      break label$5;
     }
     HEAP32[$5 + 4 >> 2] = $9 & 1 | $6 | 2;
     $3 = $5 + $6 | 0;
     HEAP32[$3 + 4 >> 2] = $12 | 3;
     $2 = $5 + $10 | 0;
     HEAP32[$2 + 4 >> 2] = HEAP32[$2 + 4 >> 2] | 1;
     dispose_chunk($3, $12);
    }
    $2 = $5;
   }
  }
  if ($2) {
   return $2 + 8 | 0
  }
  $5 = dlmalloc($1);
  if (!$5) {
   return 0
  }
  $2 = HEAP32[$0 - 4 >> 2];
  $2 = ($2 & 3 ? -4 : -8) + ($2 & -8) | 0;
  __memcpy($5, $0, $1 >>> 0 > $2 >>> 0 ? $2 : $1);
  dlfree($0);
  return $5;
 }
 
 function dispose_chunk($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $5 = $0 + $1 | 0;
  $2 = HEAP32[$0 + 4 >> 2];
  label$1 : {
   label$2 : {
    if ($2 & 1) {
     break label$2
    }
    if (!($2 & 3)) {
     break label$1
    }
    $2 = HEAP32[$0 >> 2];
    $1 = $2 + $1 | 0;
    label$3 : {
     $0 = $0 - $2 | 0;
     if (($0 | 0) != HEAP32[2898]) {
      if ($2 >>> 0 <= 255) {
       $4 = HEAP32[$0 + 8 >> 2];
       $2 = $2 >>> 3 | 0;
       $3 = HEAP32[$0 + 12 >> 2];
       if (($3 | 0) != ($4 | 0)) {
        break label$3
       }
       (wasm2js_i32$0 = 11572, wasm2js_i32$1 = HEAP32[2893] & __wasm_rotl_i32(-2, $2)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
       break label$2;
      }
      $7 = HEAP32[$0 + 24 >> 2];
      $3 = HEAP32[$0 + 12 >> 2];
      label$6 : {
       if (($0 | 0) != ($3 | 0)) {
        $2 = HEAP32[$0 + 8 >> 2];
        HEAP32[$2 + 12 >> 2] = $3;
        HEAP32[$3 + 8 >> 2] = $2;
        break label$6;
       }
       label$8 : {
        $2 = $0 + 20 | 0;
        $4 = HEAP32[$2 >> 2];
        if ($4) {
         break label$8
        }
        $2 = $0 + 16 | 0;
        $4 = HEAP32[$2 >> 2];
        if ($4) {
         break label$8
        }
        $3 = 0;
        break label$6;
       }
       while (1) {
        $6 = $2;
        $3 = $4;
        $2 = $3 + 20 | 0;
        $4 = HEAP32[$2 >> 2];
        if ($4) {
         continue
        }
        $2 = $3 + 16 | 0;
        $4 = HEAP32[$3 + 16 >> 2];
        if ($4) {
         continue
        }
        break;
       };
       HEAP32[$6 >> 2] = 0;
      }
      if (!$7) {
       break label$2
      }
      $4 = HEAP32[$0 + 28 >> 2];
      $2 = ($4 << 2) + 11876 | 0;
      label$10 : {
       if (($0 | 0) == HEAP32[$2 >> 2]) {
        HEAP32[$2 >> 2] = $3;
        if ($3) {
         break label$10
        }
        (wasm2js_i32$0 = 11576, wasm2js_i32$1 = HEAP32[2894] & __wasm_rotl_i32(-2, $4)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
        break label$2;
       }
       HEAP32[$7 + (HEAP32[$7 + 16 >> 2] == ($0 | 0) ? 16 : 20) >> 2] = $3;
       if (!$3) {
        break label$2
       }
      }
      HEAP32[$3 + 24 >> 2] = $7;
      $2 = HEAP32[$0 + 16 >> 2];
      if ($2) {
       HEAP32[$3 + 16 >> 2] = $2;
       HEAP32[$2 + 24 >> 2] = $3;
      }
      $2 = HEAP32[$0 + 20 >> 2];
      if (!$2) {
       break label$2
      }
      HEAP32[$3 + 20 >> 2] = $2;
      HEAP32[$2 + 24 >> 2] = $3;
      break label$2;
     }
     $2 = HEAP32[$5 + 4 >> 2];
     if (($2 & 3) != 3) {
      break label$2
     }
     HEAP32[2895] = $1;
     HEAP32[$5 + 4 >> 2] = $2 & -2;
     HEAP32[$0 + 4 >> 2] = $1 | 1;
     HEAP32[$5 >> 2] = $1;
     return;
    }
    HEAP32[$4 + 12 >> 2] = $3;
    HEAP32[$3 + 8 >> 2] = $4;
   }
   $2 = HEAP32[$5 + 4 >> 2];
   label$13 : {
    if (!($2 & 2)) {
     if (HEAP32[2899] == ($5 | 0)) {
      HEAP32[2899] = $0;
      $1 = HEAP32[2896] + $1 | 0;
      HEAP32[2896] = $1;
      HEAP32[$0 + 4 >> 2] = $1 | 1;
      if (HEAP32[2898] != ($0 | 0)) {
       break label$1
      }
      HEAP32[2895] = 0;
      HEAP32[2898] = 0;
      return;
     }
     if (HEAP32[2898] == ($5 | 0)) {
      HEAP32[2898] = $0;
      $1 = HEAP32[2895] + $1 | 0;
      HEAP32[2895] = $1;
      HEAP32[$0 + 4 >> 2] = $1 | 1;
      HEAP32[$0 + $1 >> 2] = $1;
      return;
     }
     $1 = ($2 & -8) + $1 | 0;
     label$17 : {
      if ($2 >>> 0 <= 255) {
       $4 = HEAP32[$5 + 8 >> 2];
       $2 = $2 >>> 3 | 0;
       $3 = HEAP32[$5 + 12 >> 2];
       if (($4 | 0) == ($3 | 0)) {
        (wasm2js_i32$0 = 11572, wasm2js_i32$1 = HEAP32[2893] & __wasm_rotl_i32(-2, $2)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
        break label$17;
       }
       HEAP32[$4 + 12 >> 2] = $3;
       HEAP32[$3 + 8 >> 2] = $4;
       break label$17;
      }
      $7 = HEAP32[$5 + 24 >> 2];
      $3 = HEAP32[$5 + 12 >> 2];
      label$20 : {
       if (($3 | 0) != ($5 | 0)) {
        $2 = HEAP32[$5 + 8 >> 2];
        HEAP32[$2 + 12 >> 2] = $3;
        HEAP32[$3 + 8 >> 2] = $2;
        break label$20;
       }
       label$22 : {
        $4 = $5 + 20 | 0;
        $2 = HEAP32[$4 >> 2];
        if ($2) {
         break label$22
        }
        $4 = $5 + 16 | 0;
        $2 = HEAP32[$4 >> 2];
        if ($2) {
         break label$22
        }
        $3 = 0;
        break label$20;
       }
       while (1) {
        $6 = $4;
        $3 = $2;
        $4 = $2 + 20 | 0;
        $2 = HEAP32[$4 >> 2];
        if ($2) {
         continue
        }
        $4 = $3 + 16 | 0;
        $2 = HEAP32[$3 + 16 >> 2];
        if ($2) {
         continue
        }
        break;
       };
       HEAP32[$6 >> 2] = 0;
      }
      if (!$7) {
       break label$17
      }
      $4 = HEAP32[$5 + 28 >> 2];
      $2 = ($4 << 2) + 11876 | 0;
      label$24 : {
       if (HEAP32[$2 >> 2] == ($5 | 0)) {
        HEAP32[$2 >> 2] = $3;
        if ($3) {
         break label$24
        }
        (wasm2js_i32$0 = 11576, wasm2js_i32$1 = HEAP32[2894] & __wasm_rotl_i32(-2, $4)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
        break label$17;
       }
       HEAP32[$7 + (($5 | 0) == HEAP32[$7 + 16 >> 2] ? 16 : 20) >> 2] = $3;
       if (!$3) {
        break label$17
       }
      }
      HEAP32[$3 + 24 >> 2] = $7;
      $2 = HEAP32[$5 + 16 >> 2];
      if ($2) {
       HEAP32[$3 + 16 >> 2] = $2;
       HEAP32[$2 + 24 >> 2] = $3;
      }
      $2 = HEAP32[$5 + 20 >> 2];
      if (!$2) {
       break label$17
      }
      HEAP32[$3 + 20 >> 2] = $2;
      HEAP32[$2 + 24 >> 2] = $3;
     }
     HEAP32[$0 + 4 >> 2] = $1 | 1;
     HEAP32[$0 + $1 >> 2] = $1;
     if (HEAP32[2898] != ($0 | 0)) {
      break label$13
     }
     HEAP32[2895] = $1;
     return;
    }
    HEAP32[$5 + 4 >> 2] = $2 & -2;
    HEAP32[$0 + 4 >> 2] = $1 | 1;
    HEAP32[$0 + $1 >> 2] = $1;
   }
   if ($1 >>> 0 <= 255) {
    $2 = $1 >>> 3 | 0;
    $1 = ($2 << 3) + 11612 | 0;
    $3 = HEAP32[2893];
    $2 = 1 << $2;
    label$28 : {
     if (!($3 & $2)) {
      HEAP32[2893] = $2 | $3;
      $2 = $1;
      break label$28;
     }
     $2 = HEAP32[$1 + 8 >> 2];
    }
    HEAP32[$1 + 8 >> 2] = $0;
    HEAP32[$2 + 12 >> 2] = $0;
    HEAP32[$0 + 12 >> 2] = $1;
    HEAP32[$0 + 8 >> 2] = $2;
    return;
   }
   $2 = 31;
   HEAP32[$0 + 16 >> 2] = 0;
   HEAP32[$0 + 20 >> 2] = 0;
   if ($1 >>> 0 <= 16777215) {
    $2 = $1 >>> 8 | 0;
    $6 = $2 + 1048320 >>> 16 & 8;
    $2 = $2 << $6;
    $4 = $2 + 520192 >>> 16 & 4;
    $2 = $2 << $4;
    $3 = $2 + 245760 >>> 16 & 2;
    $2 = ($2 << $3 >>> 15 | 0) - ($3 | ($4 | $6)) | 0;
    $2 = ($2 << 1 | $1 >>> $2 + 21 & 1) + 28 | 0;
   }
   HEAP32[$0 + 28 >> 2] = $2;
   $6 = ($2 << 2) + 11876 | 0;
   label$31 : {
    $4 = HEAP32[2894];
    $3 = 1 << $2;
    label$32 : {
     if (!($4 & $3)) {
      HEAP32[2894] = $3 | $4;
      HEAP32[$6 >> 2] = $0;
      HEAP32[$0 + 24 >> 2] = $6;
      break label$32;
     }
     $2 = $1 << (($2 | 0) == 31 ? 0 : 25 - ($2 >>> 1 | 0) | 0);
     $3 = HEAP32[$6 >> 2];
     while (1) {
      $4 = $3;
      if ((HEAP32[$3 + 4 >> 2] & -8) == ($1 | 0)) {
       break label$31
      }
      $3 = $2 >>> 29 | 0;
      $2 = $2 << 1;
      $6 = ($4 + ($3 & 4) | 0) + 16 | 0;
      $3 = HEAP32[$6 >> 2];
      if ($3) {
       continue
      }
      break;
     };
     HEAP32[$6 >> 2] = $0;
     HEAP32[$0 + 24 >> 2] = $4;
    }
    HEAP32[$0 + 12 >> 2] = $0;
    HEAP32[$0 + 8 >> 2] = $0;
    return;
   }
   $1 = HEAP32[$4 + 8 >> 2];
   HEAP32[$1 + 12 >> 2] = $0;
   HEAP32[$4 + 8 >> 2] = $0;
   HEAP32[$0 + 24 >> 2] = 0;
   HEAP32[$0 + 12 >> 2] = $4;
   HEAP32[$0 + 8 >> 2] = $1;
  }
 }
 
 function frexp($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0;
  wasm2js_scratch_store_f64(+$0);
  $2 = wasm2js_scratch_load_i32(1) | 0;
  $3 = wasm2js_scratch_load_i32(0) | 0;
  $4 = $2;
  $2 = $2 >>> 20 & 2047;
  if (($2 | 0) != 2047) {
   if (!$2) {
    $2 = $1;
    if ($0 == 0.0) {
     $1 = 0
    } else {
     $0 = frexp($0 * 18446744073709551615.0, $1);
     $1 = HEAP32[$1 >> 2] + -64 | 0;
    }
    HEAP32[$2 >> 2] = $1;
    return $0;
   }
   HEAP32[$1 >> 2] = $2 - 1022;
   wasm2js_scratch_store_i32(0, $3 | 0);
   wasm2js_scratch_store_i32(1, $4 & -2146435073 | 1071644672);
   $0 = +wasm2js_scratch_load_f64();
  }
  return $0;
 }
 
 function __ashlti3($0, $1, $2, $3, $4, $5) {
  var $6 = 0, $7 = 0, $8 = 0, $9 = 0;
  label$1 : {
   if ($5 & 64) {
    $3 = $1;
    $4 = $5 + -64 | 0;
    $1 = $4 & 31;
    if (($4 & 63) >>> 0 >= 32) {
     $4 = $3 << $1;
     $3 = 0;
    } else {
     $4 = (1 << $1) - 1 & $3 >>> 32 - $1 | $2 << $1;
     $3 = $3 << $1;
    }
    $1 = 0;
    $2 = 0;
    break label$1;
   }
   if (!$5) {
    break label$1
   }
   $6 = $2;
   $9 = $1;
   $7 = 64 - $5 | 0;
   $8 = $7 & 31;
   if (($7 & 63) >>> 0 >= 32) {
    $7 = 0;
    $9 = $6 >>> $8 | 0;
   } else {
    $7 = $6 >>> $8 | 0;
    $9 = ((1 << $8) - 1 & $6) << 32 - $8 | $9 >>> $8;
   }
   $6 = $3;
   $3 = $5 & 31;
   if (($5 & 63) >>> 0 >= 32) {
    $4 = $6 << $3;
    $3 = 0;
   } else {
    $4 = (1 << $3) - 1 & $6 >>> 32 - $3 | $4 << $3;
    $3 = $6 << $3;
   }
   $3 = $9 | $3;
   $4 = $4 | $7;
   $6 = $1;
   $1 = $5 & 31;
   if (($5 & 63) >>> 0 >= 32) {
    $7 = $6 << $1;
    $1 = 0;
   } else {
    $7 = (1 << $1) - 1 & $6 >>> 32 - $1 | $2 << $1;
    $1 = $6 << $1;
   }
   $2 = $7;
  }
  HEAP32[$0 >> 2] = $1;
  HEAP32[$0 + 4 >> 2] = $2;
  HEAP32[$0 + 8 >> 2] = $3;
  HEAP32[$0 + 12 >> 2] = $4;
 }
 
 function __lshrti3($0, $1, $2, $3, $4, $5) {
  var $6 = 0, $7 = 0, $8 = 0, $9 = 0;
  label$1 : {
   if ($5 & 64) {
    $2 = $5 + -64 | 0;
    $1 = $2 & 31;
    if (($2 & 63) >>> 0 >= 32) {
     $2 = 0;
     $1 = $4 >>> $1 | 0;
    } else {
     $2 = $4 >>> $1 | 0;
     $1 = ((1 << $1) - 1 & $4) << 32 - $1 | $3 >>> $1;
    }
    $3 = 0;
    $4 = 0;
    break label$1;
   }
   if (!$5) {
    break label$1
   }
   $7 = $4;
   $8 = $3;
   $9 = 64 - $5 | 0;
   $6 = $9 & 31;
   if (($9 & 63) >>> 0 >= 32) {
    $7 = $8 << $6;
    $9 = 0;
   } else {
    $7 = (1 << $6) - 1 & $8 >>> 32 - $6 | $7 << $6;
    $9 = $8 << $6;
   }
   $8 = $1;
   $6 = $5;
   $1 = $6 & 31;
   if (($6 & 63) >>> 0 >= 32) {
    $6 = 0;
    $1 = $2 >>> $1 | 0;
   } else {
    $6 = $2 >>> $1 | 0;
    $1 = ((1 << $1) - 1 & $2) << 32 - $1 | $8 >>> $1;
   }
   $1 = $9 | $1;
   $2 = $6 | $7;
   $6 = $3;
   $3 = $5 & 31;
   if (($5 & 63) >>> 0 >= 32) {
    $7 = 0;
    $3 = $4 >>> $3 | 0;
   } else {
    $7 = $4 >>> $3 | 0;
    $3 = ((1 << $3) - 1 & $4) << 32 - $3 | $6 >>> $3;
   }
   $4 = $7;
  }
  HEAP32[$0 >> 2] = $1;
  HEAP32[$0 + 4 >> 2] = $2;
  HEAP32[$0 + 8 >> 2] = $3;
  HEAP32[$0 + 12 >> 2] = $4;
 }
 
 function FLAC__crc8($0, $1) {
  var $2 = 0, $3 = 0;
  label$1 : {
   if (!$1) {
    $1 = 0;
    break label$1;
   }
   $2 = $1 & 3;
   label$3 : {
    if ($1 - 1 >>> 0 < 3) {
     $1 = 0;
     break label$3;
    }
    $3 = $1 & -4;
    $1 = 0;
    while (1) {
     $1 = HEAPU8[(HEAPU8[$0 + 3 | 0] ^ HEAPU8[(HEAPU8[$0 + 2 | 0] ^ HEAPU8[(HEAPU8[$0 + 1 | 0] ^ HEAPU8[(HEAPU8[$0 | 0] ^ $1 & 255) + 1024 | 0]) + 1024 | 0]) + 1024 | 0]) + 1024 | 0];
     $0 = $0 + 4 | 0;
     $3 = $3 - 4 | 0;
     if ($3) {
      continue
     }
     break;
    };
   }
   if (!$2) {
    break label$1
   }
   while (1) {
    $1 = HEAPU8[(HEAPU8[$0 | 0] ^ $1 & 255) + 1024 | 0];
    $0 = $0 + 1 | 0;
    $2 = $2 - 1 | 0;
    if ($2) {
     continue
    }
    break;
   };
  }
  return $1 & 255;
 }
 
 function FLAC__crc16_update_words32($0, $1, $2) {
  var $3 = 0;
  if ($1 >>> 0 >= 2) {
   while (1) {
    $3 = $2;
    $2 = HEAP32[$0 >> 2];
    $3 = $3 ^ $2 >>> 16;
    $3 = HEAPU16[(($3 & 255) << 1) + 4352 >> 1] ^ HEAPU16[($3 >>> 7 & 510) + 4864 >> 1] ^ HEAPU16[($2 >>> 7 & 510) + 3840 >> 1] ^ HEAPU16[(($2 & 255) << 1) + 3328 >> 1];
    $2 = HEAP32[$0 + 4 >> 2];
    $2 = $3 ^ HEAPU16[($2 >>> 23 & 510) + 2816 >> 1] ^ HEAPU16[($2 >>> 15 & 510) + 2304 >> 1] ^ HEAPU16[($2 >>> 7 & 510) + 1792 >> 1] ^ HEAPU16[(($2 & 255) << 1) + 1280 >> 1];
    $0 = $0 + 8 | 0;
    $1 = $1 - 2 | 0;
    if ($1 >>> 0 > 1) {
     continue
    }
    break;
   }
  }
  if ($1) {
   $0 = HEAP32[$0 >> 2];
   $1 = $0 >>> 16 ^ $2;
   $2 = HEAPU16[(($1 & 255) << 1) + 2304 >> 1] ^ HEAPU16[($1 >>> 7 & 510) + 2816 >> 1] ^ HEAPU16[($0 >>> 7 & 510) + 1792 >> 1] ^ HEAPU16[(($0 & 255) << 1) + 1280 >> 1];
  }
  return $2 & 65535;
 }
 
 function memmove($0, $1, $2) {
  var $3 = 0, $4 = 0;
  label$1 : {
   if (($0 | 0) == ($1 | 0)) {
    break label$1
   }
   $4 = $0 + $2 | 0;
   if ($1 - $4 >>> 0 <= 0 - ($2 << 1) >>> 0) {
    __memcpy($0, $1, $2);
    return;
   }
   $3 = ($0 ^ $1) & 3;
   label$3 : {
    label$4 : {
     if ($0 >>> 0 < $1 >>> 0) {
      if ($3) {
       break label$3
      }
      if (!($0 & 3)) {
       break label$4
      }
      while (1) {
       if (!$2) {
        break label$1
       }
       HEAP8[$0 | 0] = HEAPU8[$1 | 0];
       $1 = $1 + 1 | 0;
       $2 = $2 - 1 | 0;
       $0 = $0 + 1 | 0;
       if ($0 & 3) {
        continue
       }
       break;
      };
      break label$4;
     }
     label$9 : {
      if ($3) {
       break label$9
      }
      if ($4 & 3) {
       while (1) {
        if (!$2) {
         break label$1
        }
        $2 = $2 - 1 | 0;
        $3 = $2 + $0 | 0;
        HEAP8[$3 | 0] = HEAPU8[$1 + $2 | 0];
        if ($3 & 3) {
         continue
        }
        break;
       }
      }
      if ($2 >>> 0 <= 3) {
       break label$9
      }
      while (1) {
       $2 = $2 - 4 | 0;
       HEAP32[$2 + $0 >> 2] = HEAP32[$1 + $2 >> 2];
       if ($2 >>> 0 > 3) {
        continue
       }
       break;
      };
     }
     if (!$2) {
      break label$1
     }
     while (1) {
      $2 = $2 - 1 | 0;
      HEAP8[$2 + $0 | 0] = HEAPU8[$1 + $2 | 0];
      if ($2) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($2 >>> 0 <= 3) {
     break label$3
    }
    while (1) {
     HEAP32[$0 >> 2] = HEAP32[$1 >> 2];
     $1 = $1 + 4 | 0;
     $0 = $0 + 4 | 0;
     $2 = $2 - 4 | 0;
     if ($2 >>> 0 > 3) {
      continue
     }
     break;
    };
   }
   if (!$2) {
    break label$1
   }
   while (1) {
    HEAP8[$0 | 0] = HEAPU8[$1 | 0];
    $0 = $0 + 1 | 0;
    $1 = $1 + 1 | 0;
    $2 = $2 - 1 | 0;
    if ($2) {
     continue
    }
    break;
   };
  }
 }
 
 function FLAC__bitreader_delete($0) {
  var $1 = 0;
  $1 = HEAP32[$0 >> 2];
  if ($1) {
   dlfree($1)
  }
  dlfree($0);
 }
 
 function FLAC__bitreader_is_consumed_byte_aligned($0) {
  return !(HEAPU8[$0 + 20 | 0] & 7);
 }
 
 function FLAC__bitreader_bits_left_for_byte_alignment($0) {
  return 8 - (HEAP32[$0 + 20 >> 2] & 7) | 0;
 }
 
 function FLAC__bitreader_read_raw_uint32($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0;
  label$1 : {
   if ($2) {
    label$4 : {
     while (1) {
      $5 = HEAP32[$0 + 8 >> 2];
      $4 = HEAP32[$0 + 16 >> 2];
      $3 = HEAP32[$0 + 20 >> 2];
      if ((($5 - $4 << 5) + (HEAP32[$0 + 12 >> 2] << 3) | 0) - $3 >>> 0 >= $2 >>> 0) {
       break label$4
      }
      if (bitreader_read_from_client_($0)) {
       continue
      }
      break;
     };
     return 0;
    }
    if ($4 >>> 0 < $5 >>> 0) {
     if ($3) {
      $5 = HEAP32[$0 >> 2];
      $4 = HEAP32[$5 + ($4 << 2) >> 2] & -1 >>> $3;
      $3 = 32 - $3 | 0;
      if ($2 >>> 0 < $3 >>> 0) {
       HEAP32[$1 >> 2] = $4 >>> $3 - $2;
       HEAP32[$0 + 20 >> 2] = HEAP32[$0 + 20 >> 2] + $2;
       break label$1;
      }
      HEAP32[$1 >> 2] = $4;
      HEAP32[$0 + 20 >> 2] = 0;
      HEAP32[$0 + 16 >> 2] = HEAP32[$0 + 16 >> 2] + 1;
      $2 = $2 - $3 | 0;
      if (!$2) {
       break label$1
      }
      $3 = HEAP32[$1 >> 2] << $2;
      HEAP32[$1 >> 2] = $3;
      HEAP32[$1 >> 2] = $3 | HEAP32[(HEAP32[$0 + 16 >> 2] << 2) + $5 >> 2] >>> 32 - $2;
      HEAP32[$0 + 20 >> 2] = $2;
      return 1;
     }
     $3 = HEAP32[HEAP32[$0 >> 2] + ($4 << 2) >> 2];
     if ($2 >>> 0 <= 31) {
      HEAP32[$1 >> 2] = $3 >>> 32 - $2;
      HEAP32[$0 + 20 >> 2] = $2;
      break label$1;
     }
     HEAP32[$1 >> 2] = $3;
     HEAP32[$0 + 16 >> 2] = HEAP32[$0 + 16 >> 2] + 1;
     return 1;
    }
    $4 = HEAP32[HEAP32[$0 >> 2] + ($4 << 2) >> 2];
    if ($3) {
     HEAP32[$1 >> 2] = ($4 & -1 >>> $3) >>> 32 - ($2 + $3 | 0);
     HEAP32[$0 + 20 >> 2] = HEAP32[$0 + 20 >> 2] + $2;
     break label$1;
    }
    HEAP32[$1 >> 2] = $4 >>> 32 - $2;
    HEAP32[$0 + 20 >> 2] = HEAP32[$0 + 20 >> 2] + $2;
    break label$1;
   }
   HEAP32[$1 >> 2] = 0;
  }
  return 1;
 }
 
 function bitreader_read_from_client_($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
  $9 = __stack_pointer - 16 | 0;
  __stack_pointer = $9;
  $8 = HEAP32[$0 + 16 >> 2];
  label$1 : {
   if (!$8) {
    $2 = HEAP32[$0 + 8 >> 2];
    break label$1;
   }
   $2 = HEAP32[$0 + 28 >> 2];
   label$3 : {
    if ($8 >>> 0 <= $2 >>> 0) {
     $3 = $2;
     break label$3;
    }
    $4 = HEAP32[$0 + 32 >> 2];
    if (!$4) {
     $3 = $2;
     break label$3;
    }
    $3 = $2 + 1 | 0;
    HEAP32[$0 + 28 >> 2] = $3;
    $1 = HEAP32[$0 + 24 >> 2];
    $5 = $1;
    label$6 : {
     if ($4 >>> 0 > 31) {
      break label$6
     }
     $2 = HEAP32[HEAP32[$0 >> 2] + ($2 << 2) >> 2];
     $6 = HEAPU16[(($2 >>> 24 - $4 & 255 ^ $1 >>> 8) << 1) + 1280 >> 1];
     $1 = $6 ^ $1 << 8 & 65280;
     $5 = $1;
     if ($4 >>> 0 >= 24) {
      break label$6
     }
     $5 = $6 << 8 & 65280;
     $6 = HEAPU16[(($2 >>> 16 - $4 & 255 ^ $1 >>> 8) << 1) + 1280 >> 1];
     $1 = $5 ^ $6;
     $5 = $1;
     if ($4 >>> 0 > 15) {
      break label$6
     }
     $5 = $6 << 8 & 65280;
     $6 = HEAPU16[(($2 >>> 8 - $4 & 255 ^ $1 >>> 8) << 1) + 1280 >> 1];
     $1 = $5 ^ $6;
     $5 = $1;
     if ($4 >>> 0 > 7) {
      break label$6
     }
     $5 = HEAPU16[(($2 >>> 0 - $4 & 255 ^ $1 >>> 8) << 1) + 1280 >> 1] ^ $6 << 8 & 65280;
    }
    $1 = $5;
    HEAP32[$0 + 32 >> 2] = 0;
    HEAP32[$0 + 24 >> 2] = $1;
   }
   $3 = FLAC__crc16_update_words32(HEAP32[$0 >> 2] + ($3 << 2) | 0, $8 - $3 | 0, HEAPU16[$0 + 24 >> 1]);
   HEAP32[$0 + 28 >> 2] = 0;
   HEAP32[$0 + 24 >> 2] = $3;
   $2 = HEAP32[$0 >> 2];
   $3 = HEAP32[$0 + 16 >> 2];
   memmove($2, $2 + ($3 << 2) | 0, (HEAP32[$0 + 8 >> 2] - $3 | 0) + (HEAP32[$0 + 12 >> 2] != 0) << 2);
   HEAP32[$0 + 16 >> 2] = 0;
   $2 = HEAP32[$0 + 8 >> 2] - $3 | 0;
   HEAP32[$0 + 8 >> 2] = $2;
  }
  $1 = HEAP32[$0 + 12 >> 2];
  $4 = (HEAP32[$0 + 4 >> 2] - $2 << 2) - $1 | 0;
  HEAP32[$9 + 12 >> 2] = $4;
  $3 = 0;
  label$7 : {
   if (!$4) {
    break label$7
   }
   $2 = HEAP32[$0 >> 2] + ($2 << 2) | 0;
   $4 = $2 + $1 | 0;
   if ($1) {
    $5 = $2;
    $2 = HEAP32[$2 >> 2];
    HEAP32[$5 >> 2] = $2 << 24 | $2 << 8 & 16711680 | ($2 >>> 8 & 65280 | $2 >>> 24);
   }
   if (!(FUNCTION_TABLE[HEAP32[$0 + 36 >> 2]]($4, $9 + 12 | 0, HEAP32[$0 + 40 >> 2]) | 0)) {
    break label$7
   }
   $6 = HEAP32[$9 + 12 >> 2];
   $2 = HEAP32[$0 + 8 >> 2];
   $1 = $2 << 2;
   $3 = HEAP32[$0 + 12 >> 2];
   $4 = ($6 + ($1 + $3 | 0) | 0) + 3 >>> 2 | 0;
   if ($2 >>> 0 < $4 >>> 0) {
    $7 = $4 + ($2 ^ -1) | 0;
    $8 = HEAP32[$0 >> 2];
    $1 = $4 - $2 & 3;
    if ($1) {
     while (1) {
      $5 = $8 + ($2 << 2) | 0;
      $3 = HEAP32[$5 >> 2];
      HEAP32[$5 >> 2] = $3 << 8 & 16711680 | $3 << 24 | ($3 >>> 8 & 65280 | $3 >>> 24);
      $2 = $2 + 1 | 0;
      $1 = $1 - 1 | 0;
      if ($1) {
       continue
      }
      break;
     }
    }
    if ($7 >>> 0 >= 3) {
     while (1) {
      $3 = $8 + ($2 << 2) | 0;
      $1 = HEAP32[$3 >> 2];
      HEAP32[$3 >> 2] = $1 << 8 & 16711680 | $1 << 24 | ($1 >>> 8 & 65280 | $1 >>> 24);
      $7 = $3 + 4 | 0;
      $1 = HEAP32[$7 >> 2];
      HEAP32[$7 >> 2] = $1 << 8 & 16711680 | $1 << 24 | ($1 >>> 8 & 65280 | $1 >>> 24);
      $7 = $3 + 8 | 0;
      $1 = HEAP32[$7 >> 2];
      HEAP32[$7 >> 2] = $1 << 8 & 16711680 | $1 << 24 | ($1 >>> 8 & 65280 | $1 >>> 24);
      $1 = $3 + 12 | 0;
      $3 = HEAP32[$1 >> 2];
      HEAP32[$1 >> 2] = $3 << 8 & 16711680 | $3 << 24 | ($3 >>> 8 & 65280 | $3 >>> 24);
      $2 = $2 + 4 | 0;
      if (($4 | 0) != ($2 | 0)) {
       continue
      }
      break;
     }
    }
    $1 = HEAP32[$0 + 8 >> 2] << 2;
    $3 = HEAP32[$0 + 12 >> 2];
   }
   $3 = ($3 + $6 | 0) + $1 | 0;
   HEAP32[$0 + 12 >> 2] = $3 & 3;
   HEAP32[$0 + 8 >> 2] = $3 >>> 2;
   $3 = 1;
  }
  __stack_pointer = $9 + 16 | 0;
  return $3;
 }
 
 function FLAC__bitreader_read_raw_int32($0, $1, $2) {
  var $3 = 0;
  $3 = __stack_pointer - 16 | 0;
  __stack_pointer = $3;
  if (FLAC__bitreader_read_raw_uint32($0, $3 + 12 | 0, $2)) {
   $0 = $1;
   $1 = 1 << $2 - 1;
   HEAP32[$0 >> 2] = ($1 ^ HEAP32[$3 + 12 >> 2]) - $1;
   $0 = 1;
  } else {
   $0 = 0
  }
  __stack_pointer = $3 + 16 | 0;
  return $0;
 }
 
 function FLAC__bitreader_read_raw_uint64($0, $1, $2) {
  var $3 = 0, $4 = 0;
  $3 = __stack_pointer - 16 | 0;
  __stack_pointer = $3;
  label$1 : {
   label$2 : {
    if ($2 >>> 0 >= 33) {
     if (!FLAC__bitreader_read_raw_uint32($0, $3 + 12 | 0, $2 - 32 | 0)) {
      break label$1
     }
     if (!FLAC__bitreader_read_raw_uint32($0, $3 + 8 | 0, 32)) {
      break label$1
     }
     $2 = HEAP32[$3 + 8 >> 2];
     $0 = HEAP32[$3 + 12 >> 2];
     break label$2;
    }
    if (!FLAC__bitreader_read_raw_uint32($0, $3 + 8 | 0, $2)) {
     break label$1
    }
    $2 = HEAP32[$3 + 8 >> 2];
    $0 = 0;
   }
   HEAP32[$1 >> 2] = $2;
   HEAP32[$1 + 4 >> 2] = $0;
   $4 = 1;
  }
  __stack_pointer = $3 + 16 | 0;
  return $4;
 }
 
 function FLAC__bitreader_read_uint32_little_endian($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  HEAP32[$2 + 8 >> 2] = 0;
  label$1 : {
   if (!FLAC__bitreader_read_raw_uint32($0, $2 + 8 | 0, 8)) {
    break label$1
   }
   if (!FLAC__bitreader_read_raw_uint32($0, $2 + 12 | 0, 8)) {
    break label$1
   }
   $3 = HEAP32[$2 + 8 >> 2];
   $4 = HEAP32[$2 + 12 >> 2];
   if (!FLAC__bitreader_read_raw_uint32($0, $2 + 12 | 0, 8)) {
    break label$1
   }
   $5 = HEAP32[$2 + 12 >> 2];
   if (!FLAC__bitreader_read_raw_uint32($0, $2 + 12 | 0, 8)) {
    break label$1
   }
   HEAP32[$1 >> 2] = $4 << 8 | $3 | $5 << 16 | HEAP32[$2 + 12 >> 2] << 24;
   $6 = 1;
  }
  __stack_pointer = $2 + 16 | 0;
  return $6;
 }
 
 function FLAC__bitreader_skip_bits_no_crc($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0;
  $3 = __stack_pointer - 16 | 0;
  __stack_pointer = $3;
  $4 = 1;
  label$1 : {
   if (!$1) {
    break label$1
   }
   $2 = HEAP32[$0 + 20 >> 2] & 7;
   label$2 : {
    if ($2) {
     $2 = 8 - $2 | 0;
     $2 = $1 >>> 0 > $2 >>> 0 ? $2 : $1;
     if (!FLAC__bitreader_read_raw_uint32($0, $3 + 8 | 0, $2)) {
      break label$2
     }
     $1 = $1 - $2 | 0;
    }
    if ($1 >>> 0 >= 8) {
     $2 = $1 >>> 3 | 0;
     while (1) {
      label$5 : {
       if (!HEAP32[$0 + 20 >> 2]) {
        if ($2 >>> 0 > 3) {
         while (1) {
          $5 = HEAP32[$0 + 16 >> 2];
          label$10 : {
           if ($5 >>> 0 < HEAPU32[$0 + 8 >> 2]) {
            HEAP32[$0 + 16 >> 2] = $5 + 1;
            $2 = $2 - 4 | 0;
            break label$10;
           }
           if (!bitreader_read_from_client_($0)) {
            break label$2
           }
          }
          if ($2 >>> 0 > 3) {
           continue
          }
          break;
         };
         if (!$2) {
          break label$5
         }
        }
        while (1) {
         if (!FLAC__bitreader_read_raw_uint32($0, $3 + 12 | 0, 8)) {
          break label$2
         }
         $2 = $2 - 1 | 0;
         if ($2) {
          continue
         }
         break;
        };
        break label$5;
       }
       if (!FLAC__bitreader_read_raw_uint32($0, $3 + 12 | 0, 8)) {
        break label$2
       }
       $2 = $2 - 1 | 0;
       if ($2) {
        continue
       }
      }
      break;
     };
     $1 = $1 & 7;
    }
    if (!$1) {
     break label$1
    }
    if (FLAC__bitreader_read_raw_uint32($0, $3 + 8 | 0, $1)) {
     break label$1
    }
   }
   $4 = 0;
  }
  __stack_pointer = $3 + 16 | 0;
  return $4;
 }
 
 function FLAC__bitreader_skip_byte_block_aligned_no_crc($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0;
  $2 = __stack_pointer - 16 | 0;
  __stack_pointer = $2;
  $3 = 1;
  label$1 : {
   if (!$1) {
    break label$1
   }
   while (1) {
    label$2 : {
     if (!HEAP32[$0 + 20 >> 2]) {
      label$5 : {
       if ($1 >>> 0 <= 3) {
        break label$5
       }
       while (1) {
        $4 = HEAP32[$0 + 16 >> 2];
        label$7 : {
         if ($4 >>> 0 < HEAPU32[$0 + 8 >> 2]) {
          HEAP32[$0 + 16 >> 2] = $4 + 1;
          $1 = $1 - 4 | 0;
          break label$7;
         }
         if (!bitreader_read_from_client_($0)) {
          break label$2
         }
        }
        if ($1 >>> 0 > 3) {
         continue
        }
        break;
       };
       if ($1) {
        break label$5
       }
       break label$1;
      }
      while (1) {
       if (!FLAC__bitreader_read_raw_uint32($0, $2 + 12 | 0, 8)) {
        break label$2
       }
       $1 = $1 - 1 | 0;
       if ($1) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (!FLAC__bitreader_read_raw_uint32($0, $2 + 12 | 0, 8)) {
      break label$2
     }
     $1 = $1 - 1 | 0;
     if ($1) {
      continue
     }
     break label$1;
    }
    break;
   };
   $3 = 0;
  }
  __stack_pointer = $2 + 16 | 0;
  return $3;
 }
 
 function FLAC__bitreader_read_byte_block_aligned_no_crc($0, $1, $2) {
  var $3 = 0, $4 = 0;
  $4 = __stack_pointer - 16 | 0;
  __stack_pointer = $4;
  label$1 : {
   if (!$2) {
    $3 = 1;
    break label$1;
   }
   while (1) {
    if (!HEAP32[$0 + 20 >> 2]) {
     label$5 : {
      if ($2 >>> 0 <= 3) {
       break label$5
      }
      while (1) {
       label$7 : {
        $3 = HEAP32[$0 + 16 >> 2];
        if ($3 >>> 0 < HEAPU32[$0 + 8 >> 2]) {
         HEAP32[$0 + 16 >> 2] = $3 + 1;
         $3 = HEAP32[HEAP32[$0 >> 2] + ($3 << 2) >> 2];
         $3 = $3 << 24 | $3 << 8 & 16711680 | ($3 >>> 8 & 65280 | $3 >>> 24);
         HEAP8[$1 | 0] = $3;
         HEAP8[$1 + 1 | 0] = $3 >>> 8;
         HEAP8[$1 + 2 | 0] = $3 >>> 16;
         HEAP8[$1 + 3 | 0] = $3 >>> 24;
         $2 = $2 - 4 | 0;
         $1 = $1 + 4 | 0;
         break label$7;
        }
        if (bitreader_read_from_client_($0)) {
         break label$7
        }
        $3 = 0;
        break label$1;
       }
       if ($2 >>> 0 > 3) {
        continue
       }
       break;
      };
      if ($2) {
       break label$5
      }
      $3 = 1;
      break label$1;
     }
     while (1) {
      if (!FLAC__bitreader_read_raw_uint32($0, $4 + 12 | 0, 8)) {
       $3 = 0;
       break label$1;
      }
      HEAP8[$1 | 0] = HEAP32[$4 + 12 >> 2];
      $3 = 1;
      $1 = $1 + 1 | 0;
      $2 = $2 - 1 | 0;
      if ($2) {
       continue
      }
      break;
     };
     break label$1;
    }
    if (!FLAC__bitreader_read_raw_uint32($0, $4 + 12 | 0, 8)) {
     $3 = 0;
     break label$1;
    }
    HEAP8[$1 | 0] = HEAP32[$4 + 12 >> 2];
    $3 = 1;
    $1 = $1 + 1 | 0;
    $2 = $2 - 1 | 0;
    if ($2) {
     continue
    }
    break;
   };
  }
  __stack_pointer = $4 + 16 | 0;
  return $3;
 }
 
 function FLAC__bitreader_read_unary_unsigned($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0;
  HEAP32[$1 >> 2] = 0;
  $5 = $0;
  label$1 : {
   label$2 : {
    label$3 : {
     while (1) {
      $2 = HEAP32[$0 + 16 >> 2];
      label$5 : {
       if ($2 >>> 0 >= HEAPU32[$0 + 8 >> 2]) {
        $3 = HEAP32[$0 + 20 >> 2];
        break label$5;
       }
       $3 = HEAP32[$0 + 20 >> 2];
       $4 = HEAP32[$0 >> 2];
       while (1) {
        $2 = HEAP32[$4 + ($2 << 2) >> 2] << $3;
        if ($2) {
         $3 = $1;
         $4 = HEAP32[$1 >> 2];
         $1 = Math_clz32($2);
         HEAP32[$3 >> 2] = $4 + $1;
         $1 = ($1 + HEAP32[$0 + 20 >> 2] | 0) + 1 | 0;
         HEAP32[$0 + 20 >> 2] = $1;
         if ($1 >>> 0 < 32) {
          break label$1
         }
         HEAP32[$0 + 16 >> 2] = HEAP32[$0 + 16 >> 2] + 1;
         $0 = 0;
         break label$2;
        }
        HEAP32[$1 >> 2] = (HEAP32[$1 >> 2] - $3 | 0) + 32;
        $3 = 0;
        HEAP32[$0 + 20 >> 2] = 0;
        $2 = HEAP32[$0 + 16 >> 2] + 1 | 0;
        HEAP32[$0 + 16 >> 2] = $2;
        if (HEAPU32[$0 + 8 >> 2] > $2 >>> 0) {
         continue
        }
        break;
       };
      }
      $4 = HEAP32[$0 + 12 >> 2] << 3;
      if ($3 >>> 0 < $4 >>> 0) {
       $2 = (HEAP32[HEAP32[$0 >> 2] + ($2 << 2) >> 2] & -1 << 32 - $4) << $3;
       if ($2) {
        break label$3
       }
       HEAP32[$1 >> 2] = HEAP32[$1 >> 2] + ($4 - $3 | 0);
       HEAP32[$0 + 20 >> 2] = $4;
      }
      if (bitreader_read_from_client_($0)) {
       continue
      }
      break;
     };
     return 0;
    }
    $3 = $1;
    $4 = HEAP32[$1 >> 2];
    $1 = Math_clz32($2);
    HEAP32[$3 >> 2] = $4 + $1;
    $0 = ($1 + HEAP32[$0 + 20 >> 2] | 0) + 1 | 0;
   }
   HEAP32[$5 + 20 >> 2] = $0;
  }
  return 1;
 }
 
 function sift($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
  $5 = __stack_pointer - 240 | 0;
  __stack_pointer = $5;
  HEAP32[$5 >> 2] = $0;
  $6 = 1;
  label$1 : {
   if (($1 | 0) < 2) {
    break label$1
   }
   $3 = $0;
   while (1) {
    $3 = $3 - 24 | 0;
    $7 = $1 - 2 | 0;
    $4 = $3 - HEAP32[($7 << 2) + $2 >> 2] | 0;
    if ((FUNCTION_TABLE[1]($0, $4) | 0) >= 0) {
     if ((FUNCTION_TABLE[1]($0, $3) | 0) > -1) {
      break label$1
     }
    }
    $8 = $4;
    $4 = (FUNCTION_TABLE[1]($4, $3) | 0) > -1;
    $3 = $4 ? $8 : $3;
    HEAP32[($6 << 2) + $5 >> 2] = $3;
    $6 = $6 + 1 | 0;
    $1 = $4 ? $1 - 1 | 0 : $7;
    if (($1 | 0) > 1) {
     continue
    }
    break;
   };
  }
  cycle($5, $6);
  __stack_pointer = $5 + 240 | 0;
 }
 
 function shr($0, $1) {
  var $2 = 0, $3 = 0;
  label$1 : {
   if ($1 >>> 0 <= 31) {
    $3 = HEAP32[$0 + 4 >> 2];
    $2 = $0;
    break label$1;
   }
   $1 = $1 - 32 | 0;
   $2 = $0 + 4 | 0;
  }
  $2 = HEAP32[$2 >> 2];
  HEAP32[$0 + 4 >> 2] = $3 >>> $1;
  HEAP32[$0 >> 2] = $3 << 32 - $1 | $2 >>> $1;
 }
 
 function trinkle($0, $1, $2, $3, $4) {
  var $5 = 0, $6 = 0, $7 = 0, $8 = 0;
  $6 = __stack_pointer - 240 | 0;
  __stack_pointer = $6;
  $5 = HEAP32[$1 >> 2];
  HEAP32[$6 + 232 >> 2] = $5;
  $1 = HEAP32[$1 + 4 >> 2];
  HEAP32[$6 >> 2] = $0;
  HEAP32[$6 + 236 >> 2] = $1;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      if (($5 | 0) != 1) {
       $5 = $0;
       $7 = 1;
       break label$4;
      }
      $5 = $0;
      $7 = 1;
      if ($1) {
       break label$4
      }
      $1 = $0;
      break label$3;
     }
     while (1) {
      $1 = $5 - HEAP32[($2 << 2) + $4 >> 2] | 0;
      if ((FUNCTION_TABLE[1]($1, $0) | 0) < 1) {
       $1 = $5;
       break label$3;
      }
      label$8 : {
       if (!(($2 | 0) < 2 | $3)) {
        $3 = HEAP32[(($2 << 2) + $4 | 0) - 8 >> 2];
        $8 = $5 - 24 | 0;
        if ((FUNCTION_TABLE[1]($8, $1) | 0) > -1) {
         break label$8
        }
        if ((FUNCTION_TABLE[1]($8 - $3 | 0, $1) | 0) > -1) {
         break label$8
        }
       }
       HEAP32[($7 << 2) + $6 >> 2] = $1;
       $3 = $6 + 232 | 0;
       $5 = $3;
       $3 = pntz($3);
       shr($5, $3);
       $7 = $7 + 1 | 0;
       $2 = $2 + $3 | 0;
       $3 = 0;
       $5 = $1;
       if (HEAP32[$6 + 236 >> 2] | HEAP32[$6 + 232 >> 2] != 1) {
        continue
       }
       break label$2;
      }
      break;
     };
     $1 = $5;
     break label$2;
    }
    if ($3) {
     break label$1
    }
   }
   cycle($6, $7);
   sift($1, $2, $4);
  }
  __stack_pointer = $6 + 240 | 0;
 }
 
 function shl($0, $1) {
  var $2 = 0, $3 = 0;
  label$1 : {
   if ($1 >>> 0 <= 31) {
    $3 = HEAP32[$0 >> 2];
    $2 = $0 + 4 | 0;
    break label$1;
   }
   $1 = $1 - 32 | 0;
   $2 = $0;
  }
  $2 = HEAP32[$2 >> 2];
  HEAP32[$0 >> 2] = $3 << $1;
  HEAP32[$0 + 4 >> 2] = $2 << $1 | $3 >>> 32 - $1;
 }
 
 function pntz($0) {
  var $1 = 0;
  $1 = __wasm_ctz_i32(HEAP32[$0 >> 2] - 1 | 0);
  if (!$1) {
   $0 = __wasm_ctz_i32(HEAP32[$0 + 4 >> 2]);
   $1 = $0 ? $0 + 32 | 0 : 0;
  }
  return $1;
 }
 
 function cycle($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
  $3 = 24;
  $4 = __stack_pointer - 256 | 0;
  __stack_pointer = $4;
  label$1 : {
   if (($1 | 0) < 2) {
    break label$1
   }
   $7 = ($1 << 2) + $0 | 0;
   HEAP32[$7 >> 2] = $4;
   $2 = $4;
   while (1) {
    $5 = $3 >>> 0 < 256 ? $3 : 256;
    __memcpy($2, HEAP32[$0 >> 2], $5);
    $2 = 0;
    while (1) {
     $6 = ($2 << 2) + $0 | 0;
     $2 = $2 + 1 | 0;
     __memcpy(HEAP32[$6 >> 2], HEAP32[($2 << 2) + $0 >> 2], $5);
     HEAP32[$6 >> 2] = HEAP32[$6 >> 2] + $5;
     if (($1 | 0) != ($2 | 0)) {
      continue
     }
     break;
    };
    $3 = $3 - $5 | 0;
    if (!$3) {
     break label$1
    }
    $2 = HEAP32[$7 >> 2];
    continue;
   };
  }
  __stack_pointer = $4 + 256 | 0;
 }
 
 function FLAC__format_seektable_sort($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
  label$1 : {
   $3 = HEAP32[$0 >> 2];
   if (!$3) {
    break label$1
   }
   $5 = HEAP32[$0 + 4 >> 2];
   $1 = __stack_pointer - 208 | 0;
   __stack_pointer = $1;
   HEAP32[$1 + 8 >> 2] = 1;
   HEAP32[$1 + 12 >> 2] = 0;
   label$10 : {
    $7 = Math_imul($3, 24);
    if (!$7) {
     break label$10
    }
    HEAP32[$1 + 16 >> 2] = 24;
    HEAP32[$1 + 20 >> 2] = 24;
    $3 = 24;
    $2 = $3;
    $4 = 2;
    while (1) {
     $6 = $2 + 24 | 0;
     $2 = $3;
     $3 = $2 + $6 | 0;
     HEAP32[($1 + 16 | 0) + ($4 << 2) >> 2] = $3;
     $4 = $4 + 1 | 0;
     if ($3 >>> 0 < $7 >>> 0) {
      continue
     }
     break;
    };
    $2 = ($5 + $7 | 0) - 24 | 0;
    label$3 : {
     if ($5 >>> 0 >= $2 >>> 0) {
      $4 = 1;
      $3 = 1;
      break label$3;
     }
     $4 = 1;
     $3 = 1;
     while (1) {
      label$6 : {
       if (($4 & 3) == 3) {
        sift($5, $3, $1 + 16 | 0);
        shr($1 + 8 | 0, 2);
        $3 = $3 + 2 | 0;
        break label$6;
       }
       $4 = $3 - 1 | 0;
       label$8 : {
        if (HEAPU32[($1 + 16 | 0) + ($4 << 2) >> 2] >= $2 - $5 >>> 0) {
         trinkle($5, $1 + 8 | 0, $3, 0, $1 + 16 | 0);
         break label$8;
        }
        sift($5, $3, $1 + 16 | 0);
       }
       if (($3 | 0) == 1) {
        shl($1 + 8 | 0, 1);
        $3 = 0;
        break label$6;
       }
       shl($1 + 8 | 0, $4);
       $3 = 1;
      }
      $4 = HEAP32[$1 + 8 >> 2] | 1;
      HEAP32[$1 + 8 >> 2] = $4;
      $5 = $5 + 24 | 0;
      if ($2 >>> 0 > $5 >>> 0) {
       continue
      }
      break;
     };
    }
    trinkle($5, $1 + 8 | 0, $3, 0, $1 + 16 | 0);
    while (1) {
     label$12 : {
      label$13 : {
       label$14 : {
        if (!(($3 | 0) != 1 | ($4 | 0) != 1)) {
         if (HEAP32[$1 + 12 >> 2]) {
          break label$14
         }
         break label$10;
        }
        if (($3 | 0) > 1) {
         break label$13
        }
       }
       $2 = $1 + 8 | 0;
       $6 = $2;
       $2 = pntz($2);
       shr($6, $2);
       $4 = HEAP32[$1 + 8 >> 2];
       $3 = $3 + $2 | 0;
       break label$12;
      }
      $2 = $1 + 8 | 0;
      shl($2, 2);
      HEAP32[$1 + 8 >> 2] = HEAP32[$1 + 8 >> 2] ^ 7;
      shr($2, 1);
      $8 = $5 - 24 | 0;
      $7 = $1 + 16 | 0;
      $6 = $3 - 2 | 0;
      trinkle($8 - HEAP32[$7 + ($6 << 2) >> 2] | 0, $2, $3 - 1 | 0, 1, $7);
      shl($2, 1);
      $4 = HEAP32[$1 + 8 >> 2] | 1;
      HEAP32[$1 + 8 >> 2] = $4;
      trinkle($8, $2, $6, 1, $7);
      $3 = $6;
     }
     $5 = $5 - 24 | 0;
     continue;
    };
   }
   __stack_pointer = $1 + 208 | 0;
   if (!HEAP32[$0 >> 2]) {
    break label$1
   }
   $2 = 1;
   $1 = HEAP32[$0 >> 2];
   if ($1 >>> 0 > 1) {
    $3 = 1;
    while (1) {
     $4 = HEAP32[$0 + 4 >> 2];
     $5 = $4 + Math_imul($3, 24) | 0;
     $7 = HEAP32[$5 >> 2];
     $6 = HEAP32[$5 + 4 >> 2];
     $8 = $6;
     label$4 : {
      if (!(($7 | 0) == -1 & ($6 | 0) == -1)) {
       $6 = ($4 + Math_imul($2, 24) | 0) - 24 | 0;
       if (($7 | 0) == HEAP32[$6 >> 2] & HEAP32[$6 + 4 >> 2] == ($8 | 0)) {
        break label$4
       }
      }
      $7 = HEAP32[$5 + 4 >> 2];
      $1 = $4 + Math_imul($2, 24) | 0;
      HEAP32[$1 >> 2] = HEAP32[$5 >> 2];
      HEAP32[$1 + 4 >> 2] = $7;
      $4 = $5 + 16 | 0;
      $7 = HEAP32[$4 + 4 >> 2];
      $6 = $1 + 16 | 0;
      HEAP32[$6 >> 2] = HEAP32[$4 >> 2];
      HEAP32[$6 + 4 >> 2] = $7;
      $5 = $5 + 8 | 0;
      $4 = HEAP32[$5 + 4 >> 2];
      $1 = $1 + 8 | 0;
      HEAP32[$1 >> 2] = HEAP32[$5 >> 2];
      HEAP32[$1 + 4 >> 2] = $4;
      $2 = $2 + 1 | 0;
      $1 = HEAP32[$0 >> 2];
     }
     $3 = $3 + 1 | 0;
     if ($1 >>> 0 > $3 >>> 0) {
      continue
     }
     break;
    };
   }
   if ($1 >>> 0 <= $2 >>> 0) {
    break label$1
   }
   $5 = HEAP32[$0 + 4 >> 2];
   $3 = $2;
   $4 = $1 - $2 & 3;
   if ($4) {
    while (1) {
     $0 = $5 + Math_imul($3, 24) | 0;
     HEAP32[$0 + 16 >> 2] = 0;
     HEAP32[$0 + 8 >> 2] = 0;
     HEAP32[$0 + 12 >> 2] = 0;
     HEAP32[$0 >> 2] = -1;
     HEAP32[$0 + 4 >> 2] = -1;
     $3 = $3 + 1 | 0;
     $4 = $4 - 1 | 0;
     if ($4) {
      continue
     }
     break;
    }
   }
   if (($2 ^ -1) + $1 >>> 0 < 3) {
    break label$1
   }
   while (1) {
    $0 = $5 + Math_imul($3, 24) | 0;
    HEAP32[$0 + 16 >> 2] = 0;
    HEAP32[$0 + 8 >> 2] = 0;
    HEAP32[$0 + 12 >> 2] = 0;
    HEAP32[$0 >> 2] = -1;
    HEAP32[$0 + 4 >> 2] = -1;
    $2 = $0 + 24 | 0;
    HEAP32[$2 >> 2] = -1;
    HEAP32[$2 + 4 >> 2] = -1;
    HEAP32[$0 + 40 >> 2] = 0;
    $2 = $0 + 32 | 0;
    HEAP32[$2 >> 2] = 0;
    HEAP32[$2 + 4 >> 2] = 0;
    HEAP32[$0 - -64 >> 2] = 0;
    $2 = $0 + 56 | 0;
    HEAP32[$2 >> 2] = 0;
    HEAP32[$2 + 4 >> 2] = 0;
    $2 = $0 + 48 | 0;
    HEAP32[$2 >> 2] = -1;
    HEAP32[$2 + 4 >> 2] = -1;
    HEAP32[$0 + 88 >> 2] = 0;
    $2 = $0 + 80 | 0;
    HEAP32[$2 >> 2] = 0;
    HEAP32[$2 + 4 >> 2] = 0;
    $0 = $0 + 72 | 0;
    HEAP32[$0 >> 2] = -1;
    HEAP32[$0 + 4 >> 2] = -1;
    $3 = $3 + 4 | 0;
    if (($1 | 0) != ($3 | 0)) {
     continue
    }
    break;
   };
  }
 }
 
 function seekpoint_compare_($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0;
  $2 = HEAP32[$0 + 4 >> 2];
  $3 = HEAP32[$1 + 4 >> 2];
  $0 = HEAP32[$0 >> 2];
  $1 = HEAP32[$1 >> 2];
  return (($0 | 0) == ($1 | 0) & ($2 | 0) == ($3 | 0) ? 0 : ($2 | 0) == ($3 | 0) & $0 >>> 0 < $1 >>> 0 | $2 >>> 0 < $3 >>> 0 ? -1 : 1) | 0;
 }
 
 function FLAC__format_entropy_coding_method_partitioned_rice_contents_init($0) {
  HEAP32[$0 + 8 >> 2] = 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
 }
 
 function FLAC__format_entropy_coding_method_partitioned_rice_contents_clear($0) {
  var $1 = 0;
  $1 = HEAP32[$0 >> 2];
  if ($1) {
   dlfree($1)
  }
  $1 = HEAP32[$0 + 4 >> 2];
  if ($1) {
   dlfree($1)
  }
  HEAP32[$0 + 8 >> 2] = 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
 }
 
 function FLAC__format_entropy_coding_method_partitioned_rice_contents_ensure_size($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0;
  $3 = 1;
  label$1 : {
   if (HEAPU32[$0 + 8 >> 2] >= $1 >>> 0) {
    break label$1
   }
   $3 = HEAP32[$0 >> 2];
   $4 = 4 << $1;
   $2 = dlrealloc($3, $4);
   if (!($2 | $1 >>> 0 > 29)) {
    dlfree($3)
   }
   HEAP32[$0 >> 2] = $2;
   $3 = 0;
   if (!$2) {
    break label$1
   }
   $5 = HEAP32[$0 + 4 >> 2];
   $2 = dlrealloc($5, $4);
   if (!($2 | $1 >>> 0 > 29)) {
    dlfree($5)
   }
   HEAP32[$0 + 4 >> 2] = $2;
   if (!$2) {
    break label$1
   }
   memset($2, $4);
   HEAP32[$0 + 8 >> 2] = $1;
   $3 = 1;
  }
  return $3;
 }
 
 function ogg_stream_init($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0;
  $2 = -1;
  if ($0) {
   memset($0 + 8 | 0, 352);
   HEAP32[$0 + 24 >> 2] = 1024;
   HEAP32[$0 + 4 >> 2] = 16384;
   $4 = dlmalloc(16384);
   HEAP32[$0 >> 2] = $4;
   $2 = dlmalloc(4096);
   HEAP32[$0 + 16 >> 2] = $2;
   $3 = dlmalloc(8192);
   HEAP32[$0 + 20 >> 2] = $3;
   label$2 : {
    if ($4) {
     if (!($2 ? !$3 : 1)) {
      break label$2
     }
     dlfree($4);
    }
    if ($2) {
     dlfree($2)
    }
    if ($3) {
     dlfree($3)
    }
    memset($0, 360);
    return -1;
   }
   HEAP32[$0 + 336 >> 2] = $1;
   $2 = 0;
  }
  return $2;
 }
 
 function ogg_stream_clear($0) {
  var $1 = 0;
  if ($0) {
   $1 = HEAP32[$0 >> 2];
   if ($1) {
    dlfree($1)
   }
   $1 = HEAP32[$0 + 16 >> 2];
   if ($1) {
    dlfree($1)
   }
   $1 = HEAP32[$0 + 20 >> 2];
   if ($1) {
    dlfree($1)
   }
   memset($0, 360);
  }
 }
 
 function ogg_page_checksum_set($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0;
  if ($0) {
   HEAP8[HEAP32[$0 >> 2] + 22 | 0] = 0;
   HEAP8[HEAP32[$0 >> 2] + 23 | 0] = 0;
   HEAP8[HEAP32[$0 >> 2] + 24 | 0] = 0;
   HEAP8[HEAP32[$0 >> 2] + 25 | 0] = 0;
   $1 = HEAP32[$0 + 4 >> 2];
   label$2 : {
    if (($1 | 0) < 1) {
     break label$2
    }
    $5 = $1 & 1;
    $3 = HEAP32[$0 >> 2];
    label$3 : {
     if (($1 | 0) == 1) {
      $1 = 0;
      break label$3;
     }
     $4 = $1 & -2;
     $1 = 0;
     while (1) {
      $2 = HEAP32[((HEAPU8[$1 + $3 | 0] ^ $2 >>> 24) << 2) + 6800 >> 2] ^ $2 << 8;
      $2 = HEAP32[((HEAPU8[$3 + ($1 | 1) | 0] ^ $2 >>> 24) << 2) + 6800 >> 2] ^ $2 << 8;
      $1 = $1 + 2 | 0;
      $4 = $4 - 2 | 0;
      if ($4) {
       continue
      }
      break;
     };
    }
    if (!$5) {
     break label$2
    }
    $2 = HEAP32[((HEAPU8[$1 + $3 | 0] ^ $2 >>> 24) << 2) + 6800 >> 2] ^ $2 << 8;
   }
   $1 = HEAP32[$0 + 12 >> 2];
   label$6 : {
    if (($1 | 0) < 1) {
     break label$6
    }
    $5 = $1 & 1;
    $3 = HEAP32[$0 + 8 >> 2];
    label$7 : {
     if (($1 | 0) == 1) {
      $1 = 0;
      break label$7;
     }
     $4 = $1 & -2;
     $1 = 0;
     while (1) {
      $2 = HEAP32[((HEAPU8[$1 + $3 | 0] ^ $2 >>> 24) << 2) + 6800 >> 2] ^ $2 << 8;
      $2 = HEAP32[((HEAPU8[$3 + ($1 | 1) | 0] ^ $2 >>> 24) << 2) + 6800 >> 2] ^ $2 << 8;
      $1 = $1 + 2 | 0;
      $4 = $4 - 2 | 0;
      if ($4) {
       continue
      }
      break;
     };
    }
    if (!$5) {
     break label$6
    }
    $2 = HEAP32[((HEAPU8[$1 + $3 | 0] ^ $2 >>> 24) << 2) + 6800 >> 2] ^ $2 << 8;
   }
   HEAP8[HEAP32[$0 >> 2] + 22 | 0] = $2;
   HEAP8[HEAP32[$0 >> 2] + 23 | 0] = $2 >>> 8;
   HEAP8[HEAP32[$0 >> 2] + 24 | 0] = $2 >>> 16;
   HEAP8[HEAP32[$0 >> 2] + 25 | 0] = $2 >>> 24;
  }
 }
 
 function _os_lacing_expand($0, $1) {
  var $2 = 0;
  folding_inner0 : {
   $2 = HEAP32[$0 + 24 >> 2];
   if (HEAP32[$0 + 28 >> 2] >= ($2 - $1 | 0)) {
    if ((2147483647 - $1 | 0) < ($2 | 0)) {
     break folding_inner0
    }
    $1 = $1 + $2 | 0;
    $1 = ($1 | 0) < 2147483615 ? $1 + 32 | 0 : $1;
    $2 = dlrealloc(HEAP32[$0 + 16 >> 2], $1 << 2);
    if (!$2) {
     break folding_inner0
    }
    HEAP32[$0 + 16 >> 2] = $2;
    $2 = dlrealloc(HEAP32[$0 + 20 >> 2], $1 << 3);
    if (!$2) {
     break folding_inner0
    }
    HEAP32[$0 + 24 >> 2] = $1;
    HEAP32[$0 + 20 >> 2] = $2;
   }
   return 0;
  }
  $1 = HEAP32[$0 >> 2];
  if ($1) {
   dlfree($1)
  }
  $1 = HEAP32[$0 + 16 >> 2];
  if ($1) {
   dlfree($1)
  }
  $1 = HEAP32[$0 + 20 >> 2];
  if ($1) {
   dlfree($1)
  }
  memset($0, 360);
  return -1;
 }
 
 function ogg_stream_flush_i($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0;
  $14 = HEAP32[$0 >> 2];
  label$1 : {
   if (!$14) {
    break label$1
   }
   $9 = HEAP32[$0 + 28 >> 2];
   $3 = ($9 | 0) < 255 ? $9 : 255;
   if (!$3) {
    break label$1
   }
   label$2 : {
    label$3 : {
     label$4 : {
      $11 = HEAP32[$0 + 332 >> 2];
      if ($11) {
       if (($9 | 0) >= 1) {
        break label$4
       }
       $10 = -1;
       $5 = -1;
       $3 = 0;
       break label$3;
      }
      if (($9 | 0) < 1) {
       $3 = 0;
       break label$3;
      }
      $4 = ($3 | 0) > 1 ? $3 : 1;
      $8 = HEAP32[$0 + 16 >> 2];
      while (1) {
       $3 = $7 + 1 | 0;
       if (HEAPU8[$8 + ($7 << 2) | 0] != 255) {
        break label$3
       }
       $7 = $3;
       if (($3 | 0) != ($4 | 0)) {
        continue
       }
       break;
      };
      $3 = $4;
      break label$3;
     }
     $4 = ($3 | 0) > 1 ? $3 : 1;
     $10 = -1;
     $5 = -1;
     $3 = 0;
     label$8 : {
      while (1) {
       if (!(($6 | 0) <= 3 | ($7 | 0) <= 4096)) {
        $2 = 1;
        break label$8;
       }
       $6 = 0;
       $12 = HEAPU8[HEAP32[$0 + 16 >> 2] + ($3 << 2) | 0];
       if (($12 | 0) != 255) {
        $5 = HEAP32[$0 + 20 >> 2] + ($3 << 3) | 0;
        $10 = HEAP32[$5 >> 2];
        $8 = $8 + 1 | 0;
        $6 = $8;
        $5 = HEAP32[$5 + 4 >> 2];
       }
       $7 = $7 + $12 | 0;
       $3 = $3 + 1 | 0;
       if (($4 | 0) != ($3 | 0)) {
        continue
       }
       break;
      };
      $3 = $4;
     }
     $4 = 255;
     if (($3 | 0) == 255) {
      break label$2
     }
    }
    $4 = $3;
    if (!$2) {
     break label$1
    }
   }
   HEAP32[$0 + 40 >> 2] = 1399285583;
   $7 = 0;
   HEAP16[$0 + 44 >> 1] = 0;
   $6 = HEAP32[$0 + 16 >> 2];
   $2 = (HEAPU8[$6 + 1 | 0] ^ -1) & 1;
   $2 = $11 ? $2 : $2 | 2;
   HEAP8[$0 + 45 | 0] = $2;
   if (!(!HEAP32[$0 + 328 >> 2] | ($4 | 0) != ($9 | 0))) {
    HEAP8[$0 + 45 | 0] = $2 | 4
   }
   $11 = $0 + 40 | 0;
   HEAP32[$0 + 332 >> 2] = 1;
   HEAP8[$0 + 53 | 0] = $5 >>> 24;
   HEAP8[$0 + 52 | 0] = $5 >>> 16;
   HEAP8[$0 + 51 | 0] = $5 >>> 8;
   HEAP8[$0 + 50 | 0] = $5;
   HEAP8[$0 + 49 | 0] = ($5 & 16777215) << 8 | $10 >>> 24;
   HEAP8[$0 + 48 | 0] = ($5 & 65535) << 16 | $10 >>> 16;
   HEAP8[$0 + 47 | 0] = ($5 & 255) << 24 | $10 >>> 8;
   HEAP8[$0 + 46 | 0] = $10;
   $3 = $0 + 54 | 0;
   $2 = HEAP32[$0 + 336 >> 2];
   HEAP8[$3 | 0] = $2;
   HEAP8[$3 + 1 | 0] = $2 >>> 8;
   HEAP8[$3 + 2 | 0] = $2 >>> 16;
   HEAP8[$3 + 3 | 0] = $2 >>> 24;
   HEAP8[$0 + 66 | 0] = $4;
   $2 = $0 + 62 | 0;
   HEAP16[$2 >> 1] = 0;
   HEAP16[$2 + 2 >> 1] = 0;
   $2 = HEAP32[$0 + 340 >> 2];
   $2 = ($2 | 0) == -1 ? 0 : $2;
   HEAP8[$0 + 58 | 0] = $2;
   HEAP32[$0 + 340 >> 2] = $2 + 1;
   HEAP8[$0 + 61 | 0] = $2 >>> 24;
   HEAP8[$0 + 60 | 0] = $2 >>> 16;
   HEAP8[$0 + 59 | 0] = $2 >>> 8;
   label$13 : {
    if (($4 | 0) < 1) {
     break label$13
    }
    $12 = $4 & 1;
    label$14 : {
     if (($4 | 0) == 1) {
      $3 = 0;
      break label$14;
     }
     $2 = $4 & -2;
     $3 = 0;
     while (1) {
      $8 = $0 + $3 | 0;
      $5 = $3 << 2;
      $13 = HEAP32[$5 + $6 >> 2];
      HEAP8[$8 + 67 | 0] = $13;
      $5 = HEAP32[$6 + ($5 | 4) >> 2];
      HEAP8[$8 + 68 | 0] = $5;
      $7 = (($13 & 255) + $7 | 0) + ($5 & 255) | 0;
      $3 = $3 + 2 | 0;
      $2 = $2 - 2 | 0;
      if ($2) {
       continue
      }
      break;
     };
    }
    if (!$12) {
     break label$13
    }
    $2 = HEAP32[$6 + ($3 << 2) >> 2];
    HEAP8[($0 + $3 | 0) + 67 | 0] = $2;
    $7 = ($2 & 255) + $7 | 0;
   }
   HEAP32[$1 >> 2] = $11;
   $2 = $4 + 27 | 0;
   HEAP32[$0 + 324 >> 2] = $2;
   HEAP32[$1 + 4 >> 2] = $2;
   $2 = HEAP32[$0 + 12 >> 2];
   HEAP32[$1 + 12 >> 2] = $7;
   HEAP32[$1 + 8 >> 2] = $2 + $14;
   $2 = $9 - $4 | 0;
   HEAP32[$0 + 28 >> 2] = $2;
   memmove($6, $6 + ($4 << 2) | 0, $2 << 2);
   $2 = HEAP32[$0 + 20 >> 2];
   memmove($2, $2 + ($4 << 3) | 0, HEAP32[$0 + 28 >> 2] << 3);
   HEAP32[$0 + 12 >> 2] = HEAP32[$0 + 12 >> 2] + $7;
   $0 = 0;
   HEAP8[HEAP32[$1 >> 2] + 22 | 0] = 0;
   HEAP8[HEAP32[$1 >> 2] + 23 | 0] = 0;
   HEAP8[HEAP32[$1 >> 2] + 24 | 0] = 0;
   HEAP8[HEAP32[$1 >> 2] + 25 | 0] = 0;
   $3 = HEAP32[$1 + 4 >> 2];
   label$17 : {
    if (($3 | 0) < 1) {
     break label$17
    }
    $2 = $3 & 1;
    $4 = HEAP32[$1 >> 2];
    label$18 : {
     if (($3 | 0) == 1) {
      $3 = 0;
      break label$18;
     }
     $6 = $3 & -2;
     $3 = 0;
     while (1) {
      $0 = HEAP32[((HEAPU8[$3 + $4 | 0] ^ $0 >>> 24) << 2) + 6800 >> 2] ^ $0 << 8;
      $0 = HEAP32[((HEAPU8[$4 + ($3 | 1) | 0] ^ $0 >>> 24) << 2) + 6800 >> 2] ^ $0 << 8;
      $3 = $3 + 2 | 0;
      $6 = $6 - 2 | 0;
      if ($6) {
       continue
      }
      break;
     };
    }
    if (!$2) {
     break label$17
    }
    $0 = HEAP32[((HEAPU8[$3 + $4 | 0] ^ $0 >>> 24) << 2) + 6800 >> 2] ^ $0 << 8;
   }
   $3 = HEAP32[$1 + 12 >> 2];
   label$21 : {
    if (($3 | 0) < 1) {
     break label$21
    }
    $2 = $3 & 1;
    $4 = HEAP32[$1 + 8 >> 2];
    label$22 : {
     if (($3 | 0) == 1) {
      $3 = 0;
      break label$22;
     }
     $6 = $3 & -2;
     $3 = 0;
     while (1) {
      $0 = HEAP32[((HEAPU8[$3 + $4 | 0] ^ $0 >>> 24) << 2) + 6800 >> 2] ^ $0 << 8;
      $0 = HEAP32[((HEAPU8[$4 + ($3 | 1) | 0] ^ $0 >>> 24) << 2) + 6800 >> 2] ^ $0 << 8;
      $3 = $3 + 2 | 0;
      $6 = $6 - 2 | 0;
      if ($6) {
       continue
      }
      break;
     };
    }
    if (!$2) {
     break label$21
    }
    $0 = HEAP32[((HEAPU8[$3 + $4 | 0] ^ $0 >>> 24) << 2) + 6800 >> 2] ^ $0 << 8;
   }
   HEAP8[HEAP32[$1 >> 2] + 22 | 0] = $0;
   HEAP8[HEAP32[$1 >> 2] + 23 | 0] = $0 >>> 8;
   HEAP8[HEAP32[$1 >> 2] + 24 | 0] = $0 >>> 16;
   HEAP8[HEAP32[$1 >> 2] + 25 | 0] = $0 >>> 24;
   $13 = 1;
  }
  return $13;
 }
 
 function ogg_sync_reset($0) {
  if (HEAP32[$0 + 4 >> 2] < 0) {
   return
  }
  HEAP32[$0 + 8 >> 2] = 0;
  HEAP32[$0 + 12 >> 2] = 0;
  HEAP32[$0 + 24 >> 2] = 0;
  $0 = $0 + 16 | 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
 }
 
 function ogg_stream_reset($0) {
  if (!$0 | !HEAP32[$0 >> 2]) {
   $0 = -1
  } else {
   HEAP32[$0 + 344 >> 2] = 0;
   HEAP32[$0 + 348 >> 2] = 0;
   HEAP32[$0 + 340 >> 2] = -1;
   HEAP32[$0 + 332 >> 2] = 0;
   HEAP32[$0 + 324 >> 2] = 0;
   HEAP32[$0 + 328 >> 2] = 0;
   HEAP32[$0 + 36 >> 2] = 0;
   HEAP32[$0 + 28 >> 2] = 0;
   HEAP32[$0 + 32 >> 2] = 0;
   HEAP32[$0 + 8 >> 2] = 0;
   HEAP32[$0 + 12 >> 2] = 0;
   $0 = $0 + 352 | 0;
   HEAP32[$0 >> 2] = 0;
   HEAP32[$0 + 4 >> 2] = 0;
   $0 = 0;
  }
 }
 
 function FLAC__ogg_decoder_aspect_set_defaults($0) {
  HEAP32[$0 >> 2] = 1;
 }
 
 function FLAC__MD5Init($0) {
  var $1 = 0;
  HEAP32[$0 + 80 >> 2] = 0;
  HEAP32[$0 + 84 >> 2] = 0;
  HEAP32[$0 + 64 >> 2] = 1732584193;
  HEAP32[$0 + 68 >> 2] = -271733879;
  $1 = $0 + 72 | 0;
  HEAP32[$1 >> 2] = -1732584194;
  HEAP32[$1 + 4 >> 2] = 271733878;
  $0 = $0 + 88 | 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
 }
 
 function FLAC__MD5Final($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0;
  $2 = HEAP32[$1 + 80 >> 2] & 63;
  $3 = $2 + $1 | 0;
  HEAP8[$3 | 0] = 128;
  $3 = $3 + 1 | 0;
  $4 = 56;
  label$1 : {
   if ($2 >>> 0 < 56) {
    $4 = 55 - $2 | 0;
    break label$1;
   }
   memset($3, $2 ^ 63);
   FLAC__MD5Transform($1 - -64 | 0, $1);
   $3 = $1;
  }
  memset($3, $4);
  $3 = HEAP32[$1 + 80 >> 2];
  HEAP32[$1 + 56 >> 2] = $3 << 3;
  HEAP32[$1 + 60 >> 2] = HEAP32[$1 + 84 >> 2] << 3 | $3 >>> 29;
  FLAC__MD5Transform($1 - -64 | 0, $1);
  $2 = $1 + 72 | 0;
  $4 = HEAPU8[$2 + 4 | 0] | HEAPU8[$2 + 5 | 0] << 8 | (HEAPU8[$2 + 6 | 0] << 16 | HEAPU8[$2 + 7 | 0] << 24);
  $3 = $0 + 8 | 0;
  $2 = HEAPU8[$2 | 0] | HEAPU8[$2 + 1 | 0] << 8 | (HEAPU8[$2 + 2 | 0] << 16 | HEAPU8[$2 + 3 | 0] << 24);
  HEAP8[$3 | 0] = $2;
  HEAP8[$3 + 1 | 0] = $2 >>> 8;
  HEAP8[$3 + 2 | 0] = $2 >>> 16;
  HEAP8[$3 + 3 | 0] = $2 >>> 24;
  HEAP8[$3 + 4 | 0] = $4;
  HEAP8[$3 + 5 | 0] = $4 >>> 8;
  HEAP8[$3 + 6 | 0] = $4 >>> 16;
  HEAP8[$3 + 7 | 0] = $4 >>> 24;
  $3 = HEAPU8[$1 + 68 | 0] | HEAPU8[$1 + 69 | 0] << 8 | (HEAPU8[$1 + 70 | 0] << 16 | HEAPU8[$1 + 71 | 0] << 24);
  $2 = HEAPU8[$1 + 64 | 0] | HEAPU8[$1 + 65 | 0] << 8 | (HEAPU8[$1 + 66 | 0] << 16 | HEAPU8[$1 + 67 | 0] << 24);
  HEAP8[$0 | 0] = $2;
  HEAP8[$0 + 1 | 0] = $2 >>> 8;
  HEAP8[$0 + 2 | 0] = $2 >>> 16;
  HEAP8[$0 + 3 | 0] = $2 >>> 24;
  HEAP8[$0 + 4 | 0] = $3;
  HEAP8[$0 + 5 | 0] = $3 >>> 8;
  HEAP8[$0 + 6 | 0] = $3 >>> 16;
  HEAP8[$0 + 7 | 0] = $3 >>> 24;
  $0 = HEAP32[$1 + 88 >> 2];
  if ($0) {
   dlfree($0)
  }
  memset($1, 96);
 }
 
 function FLAC__MD5Transform($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $11 = HEAP32[$1 + 16 >> 2];
  $8 = HEAP32[$1 + 32 >> 2];
  $12 = HEAP32[$1 + 48 >> 2];
  $13 = HEAP32[$1 + 36 >> 2];
  $14 = HEAP32[$1 + 52 >> 2];
  $15 = HEAP32[$1 + 4 >> 2];
  $6 = HEAP32[$1 + 20 >> 2];
  $7 = HEAP32[$0 + 4 >> 2];
  $9 = HEAP32[$1 >> 2];
  $25 = HEAP32[$0 >> 2];
  $16 = HEAP32[$0 + 12 >> 2];
  $10 = HEAP32[$0 + 8 >> 2];
  $3 = $7 + __wasm_rotl_i32((($9 + $25 | 0) + ($16 ^ ($10 ^ $16) & $7) | 0) - 680876936 | 0, 7) | 0;
  $17 = HEAP32[$1 + 12 >> 2];
  $18 = HEAP32[$1 + 8 >> 2];
  $4 = __wasm_rotl_i32((($15 + $16 | 0) + ($3 & ($7 ^ $10) ^ $10) | 0) - 389564586 | 0, 12) + $3 | 0;
  $2 = __wasm_rotl_i32((($18 + $10 | 0) + ($4 & ($3 ^ $7) ^ $7) | 0) + 606105819 | 0, 17) + $4 | 0;
  $5 = __wasm_rotl_i32((($7 + $17 | 0) + ($3 ^ $2 & ($3 ^ $4)) | 0) - 1044525330 | 0, 22) + $2 | 0;
  $3 = __wasm_rotl_i32((($3 + $11 | 0) + ($4 ^ $5 & ($2 ^ $4)) | 0) - 176418897 | 0, 7) + $5 | 0;
  $19 = HEAP32[$1 + 28 >> 2];
  $20 = HEAP32[$1 + 24 >> 2];
  $4 = __wasm_rotl_i32((($4 + $6 | 0) + ($2 ^ $3 & ($2 ^ $5)) | 0) + 1200080426 | 0, 12) + $3 | 0;
  $2 = __wasm_rotl_i32((($2 + $20 | 0) + ($5 ^ $4 & ($3 ^ $5)) | 0) - 1473231341 | 0, 17) + $4 | 0;
  $5 = __wasm_rotl_i32((($5 + $19 | 0) + ($3 ^ $2 & ($3 ^ $4)) | 0) - 45705983 | 0, 22) + $2 | 0;
  $3 = __wasm_rotl_i32((($3 + $8 | 0) + ($4 ^ $5 & ($2 ^ $4)) | 0) + 1770035416 | 0, 7) + $5 | 0;
  $21 = HEAP32[$1 + 44 >> 2];
  $22 = HEAP32[$1 + 40 >> 2];
  $4 = __wasm_rotl_i32((($4 + $13 | 0) + ($2 ^ $3 & ($2 ^ $5)) | 0) - 1958414417 | 0, 12) + $3 | 0;
  $2 = __wasm_rotl_i32((($2 + $22 | 0) + ($5 ^ $4 & ($3 ^ $5)) | 0) - 42063 | 0, 17) + $4 | 0;
  $5 = __wasm_rotl_i32((($5 + $21 | 0) + ($3 ^ $2 & ($3 ^ $4)) | 0) - 1990404162 | 0, 22) + $2 | 0;
  $3 = __wasm_rotl_i32((($3 + $12 | 0) + ($4 ^ $5 & ($2 ^ $4)) | 0) + 1804603682 | 0, 7) + $5 | 0;
  $23 = HEAP32[$1 + 56 >> 2];
  $24 = HEAP32[$1 + 60 >> 2];
  $4 = __wasm_rotl_i32((($4 + $14 | 0) + ($2 ^ $3 & ($2 ^ $5)) | 0) - 40341101 | 0, 12) + $3 | 0;
  $1 = $4 + __wasm_rotl_i32((($2 + $23 | 0) + ($5 ^ ($3 ^ $5) & $4) | 0) - 1502002290 | 0, 17) | 0;
  $26 = $1 + $21 | 0;
  $2 = $3 + $15 | 0;
  $3 = __wasm_rotl_i32((($5 + $24 | 0) + ($3 ^ $1 & ($3 ^ $4)) | 0) + 1236535329 | 0, 22) + $1 | 0;
  $2 = __wasm_rotl_i32(($2 + ($1 ^ ($3 ^ $1) & $4) | 0) - 165796510 | 0, 5) + $3 | 0;
  $1 = __wasm_rotl_i32((($4 + $20 | 0) + ($3 ^ $1 & ($3 ^ $2)) | 0) - 1069501632 | 0, 9) + $2 | 0;
  $4 = __wasm_rotl_i32(($26 + (($2 ^ $1) & $3 ^ $2) | 0) + 643717713 | 0, 14) + $1 | 0;
  $3 = __wasm_rotl_i32((($3 + $9 | 0) + ($1 ^ $2 & ($1 ^ $4)) | 0) - 373897302 | 0, 20) + $4 | 0;
  $2 = __wasm_rotl_i32((($2 + $6 | 0) + ($4 ^ $1 & ($3 ^ $4)) | 0) - 701558691 | 0, 5) + $3 | 0;
  $1 = __wasm_rotl_i32((($1 + $22 | 0) + ($3 ^ $4 & ($3 ^ $2)) | 0) + 38016083 | 0, 9) + $2 | 0;
  $4 = __wasm_rotl_i32((($24 + $4 | 0) + (($2 ^ $1) & $3 ^ $2) | 0) - 660478335 | 0, 14) + $1 | 0;
  $3 = __wasm_rotl_i32((($3 + $11 | 0) + ($1 ^ $2 & ($1 ^ $4)) | 0) - 405537848 | 0, 20) + $4 | 0;
  $2 = __wasm_rotl_i32((($2 + $13 | 0) + ($4 ^ $1 & ($3 ^ $4)) | 0) + 568446438 | 0, 5) + $3 | 0;
  $1 = __wasm_rotl_i32((($1 + $23 | 0) + ($3 ^ $4 & ($3 ^ $2)) | 0) - 1019803690 | 0, 9) + $2 | 0;
  $4 = __wasm_rotl_i32((($4 + $17 | 0) + (($2 ^ $1) & $3 ^ $2) | 0) - 187363961 | 0, 14) + $1 | 0;
  $3 = __wasm_rotl_i32((($3 + $8 | 0) + ($1 ^ $2 & ($1 ^ $4)) | 0) + 1163531501 | 0, 20) + $4 | 0;
  $2 = __wasm_rotl_i32((($2 + $14 | 0) + ($4 ^ $1 & ($3 ^ $4)) | 0) - 1444681467 | 0, 5) + $3 | 0;
  $1 = __wasm_rotl_i32((($1 + $18 | 0) + ($3 ^ $4 & ($3 ^ $2)) | 0) - 51403784 | 0, 9) + $2 | 0;
  $4 = __wasm_rotl_i32((($4 + $19 | 0) + (($2 ^ $1) & $3 ^ $2) | 0) + 1735328473 | 0, 14) + $1 | 0;
  $5 = $1 ^ $4;
  $3 = __wasm_rotl_i32((($3 + $12 | 0) + ($1 ^ $5 & $2) | 0) - 1926607734 | 0, 20) + $4 | 0;
  $2 = __wasm_rotl_i32((($2 + $6 | 0) + ($3 ^ $5) | 0) - 378558 | 0, 4) + $3 | 0;
  $1 = __wasm_rotl_i32((($1 + $8 | 0) + ($3 ^ $4 ^ $2) | 0) - 2022574463 | 0, 11) + $2 | 0;
  $4 = __wasm_rotl_i32((($4 + $21 | 0) + ($1 ^ ($3 ^ $2)) | 0) + 1839030562 | 0, 16) + $1 | 0;
  $3 = __wasm_rotl_i32((($3 + $23 | 0) + ($4 ^ ($1 ^ $2)) | 0) - 35309556 | 0, 23) + $4 | 0;
  $2 = __wasm_rotl_i32((($2 + $15 | 0) + ($3 ^ ($1 ^ $4)) | 0) - 1530992060 | 0, 4) + $3 | 0;
  $1 = __wasm_rotl_i32((($1 + $11 | 0) + ($2 ^ ($3 ^ $4)) | 0) + 1272893353 | 0, 11) + $2 | 0;
  $4 = __wasm_rotl_i32((($4 + $19 | 0) + ($1 ^ ($3 ^ $2)) | 0) - 155497632 | 0, 16) + $1 | 0;
  $3 = __wasm_rotl_i32((($3 + $22 | 0) + ($4 ^ ($1 ^ $2)) | 0) - 1094730640 | 0, 23) + $4 | 0;
  $2 = __wasm_rotl_i32((($2 + $14 | 0) + ($3 ^ ($1 ^ $4)) | 0) + 681279174 | 0, 4) + $3 | 0;
  $1 = __wasm_rotl_i32((($1 + $9 | 0) + ($2 ^ ($3 ^ $4)) | 0) - 358537222 | 0, 11) + $2 | 0;
  $4 = __wasm_rotl_i32((($4 + $17 | 0) + ($1 ^ ($3 ^ $2)) | 0) - 722521979 | 0, 16) + $1 | 0;
  $3 = __wasm_rotl_i32((($3 + $20 | 0) + ($4 ^ ($1 ^ $2)) | 0) + 76029189 | 0, 23) + $4 | 0;
  $2 = __wasm_rotl_i32((($2 + $13 | 0) + ($3 ^ ($1 ^ $4)) | 0) - 640364487 | 0, 4) + $3 | 0;
  $1 = __wasm_rotl_i32((($1 + $12 | 0) + ($2 ^ ($3 ^ $4)) | 0) - 421815835 | 0, 11) + $2 | 0;
  $5 = $2 + $9 | 0;
  $9 = $1 ^ $2;
  $2 = __wasm_rotl_i32((($4 + $24 | 0) + ($1 ^ ($3 ^ $2)) | 0) + 530742520 | 0, 16) + $1 | 0;
  $4 = __wasm_rotl_i32((($3 + $18 | 0) + ($9 ^ $2) | 0) - 995338651 | 0, 23) + $2 | 0;
  $3 = __wasm_rotl_i32(($5 + (($4 | $1 ^ -1) ^ $2) | 0) - 198630844 | 0, 6) + $4 | 0;
  $5 = $4 + $6 | 0;
  $6 = $2 + $23 | 0;
  $2 = __wasm_rotl_i32((($1 + $19 | 0) + ($4 ^ ($3 | $2 ^ -1)) | 0) + 1126891415 | 0, 10) + $3 | 0;
  $4 = __wasm_rotl_i32(($6 + ($3 ^ ($2 | $4 ^ -1)) | 0) - 1416354905 | 0, 15) + $2 | 0;
  $1 = __wasm_rotl_i32(($5 + (($4 | $3 ^ -1) ^ $2) | 0) - 57434055 | 0, 21) + $4 | 0;
  $5 = $4 + $22 | 0;
  $6 = $2 + $17 | 0;
  $2 = __wasm_rotl_i32((($3 + $12 | 0) + ($4 ^ ($1 | $2 ^ -1)) | 0) + 1700485571 | 0, 6) + $1 | 0;
  $4 = __wasm_rotl_i32(($6 + ($1 ^ ($2 | $4 ^ -1)) | 0) - 1894986606 | 0, 10) + $2 | 0;
  $3 = __wasm_rotl_i32(($5 + (($4 | $1 ^ -1) ^ $2) | 0) - 1051523 | 0, 15) + $4 | 0;
  $5 = $4 + $24 | 0;
  $8 = $2 + $8 | 0;
  $2 = __wasm_rotl_i32((($1 + $15 | 0) + ($4 ^ ($3 | $2 ^ -1)) | 0) - 2054922799 | 0, 21) + $3 | 0;
  $4 = __wasm_rotl_i32(($8 + ($3 ^ ($2 | $4 ^ -1)) | 0) + 1873313359 | 0, 6) + $2 | 0;
  $1 = __wasm_rotl_i32(($5 + (($4 | $3 ^ -1) ^ $2) | 0) - 30611744 | 0, 10) + $4 | 0;
  $3 = __wasm_rotl_i32((($3 + $20 | 0) + ($4 ^ ($1 | $2 ^ -1)) | 0) - 1560198380 | 0, 15) + $1 | 0;
  $2 = __wasm_rotl_i32((($2 + $14 | 0) + ($1 ^ ($3 | $4 ^ -1)) | 0) + 1309151649 | 0, 21) + $3 | 0;
  $4 = __wasm_rotl_i32((($4 + $11 | 0) + (($2 | $1 ^ -1) ^ $3) | 0) - 145523070 | 0, 6) + $2 | 0;
  HEAP32[$0 >> 2] = $4 + $25;
  $1 = __wasm_rotl_i32((($1 + $21 | 0) + ($2 ^ ($4 | $3 ^ -1)) | 0) - 1120210379 | 0, 10) + $4 | 0;
  HEAP32[$0 + 12 >> 2] = $1 + $16;
  $3 = __wasm_rotl_i32((($3 + $18 | 0) + ($4 ^ ($1 | $2 ^ -1)) | 0) + 718787259 | 0, 15) + $1 | 0;
  HEAP32[$0 + 8 >> 2] = $3 + $10;
  (wasm2js_i32$0 = $0, wasm2js_i32$1 = __wasm_rotl_i32((($2 + $13 | 0) + ($1 ^ ($3 | $4 ^ -1)) | 0) - 343485551 | 0, 21) + ($3 + $7 | 0) | 0), HEAP32[wasm2js_i32$0 + 4 >> 2] = wasm2js_i32$1;
 }
 
 function FLAC__MD5Accumulate($0, $1, $2, $3, $4) {
  var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0;
  __wasm_i64_mul($4, 0, $2, 0);
  label$1 : {
   if (i64toi32_i32$HIGH_BITS) {
    break label$1
   }
   $7 = Math_imul($2, $4);
   __wasm_i64_mul($3, 0, $7, 0);
   if (i64toi32_i32$HIGH_BITS) {
    break label$1
   }
   $6 = HEAP32[$0 + 88 >> 2];
   $12 = Math_imul($3, $7);
   label$2 : {
    if ($12 >>> 0 <= HEAPU32[$0 + 92 >> 2]) {
     $5 = $6;
     break label$2;
    }
    label$4 : {
     $5 = dlrealloc($6, $12);
     if ($5) {
      HEAP32[$0 + 88 >> 2] = $5;
      break label$4;
     }
     dlfree($6);
     $5 = dlmalloc($12);
     HEAP32[$0 + 88 >> 2] = $5;
     if ($5) {
      break label$4
     }
     HEAP32[$0 + 92 >> 2] = 0;
     return 0;
    }
    HEAP32[$0 + 92 >> 2] = $12;
   }
   label$6 : {
    label$7 : {
     label$8 : {
      label$9 : {
       label$10 : {
        label$11 : {
         label$12 : {
          label$13 : {
           label$14 : {
            label$15 : {
             label$16 : {
              label$17 : {
               label$18 : {
                label$19 : {
                 label$20 : {
                  label$21 : {
                   label$22 : {
                    label$23 : {
                     label$24 : {
                      label$25 : {
                       label$26 : {
                        label$27 : {
                         label$28 : {
                          label$29 : {
                           $6 = Math_imul($4, 100) + $2 | 0;
                           if (($6 | 0) <= 300) {
                            label$31 : {
                             switch ($6 - 101 | 0) {
                             case 0:
                              break label$20;
                             case 1:
                              break label$21;
                             case 3:
                              break label$22;
                             case 5:
                              break label$23;
                             case 7:
                              break label$24;
                             case 2:
                             case 4:
                             case 6:
                              break label$7;
                             default:
                              break label$31;
                             };
                            }
                            switch ($6 - 201 | 0) {
                            case 0:
                             break label$25;
                            case 1:
                             break label$26;
                            case 3:
                             break label$27;
                            case 5:
                             break label$28;
                            case 7:
                             break label$29;
                            default:
                             break label$7;
                            };
                           }
                           label$32 : {
                            label$33 : {
                             label$34 : {
                              switch ($6 - 401 | 0) {
                              default:
                               switch ($6 - 301 | 0) {
                               case 0:
                                break label$32;
                               case 1:
                                break label$33;
                               default:
                                break label$7;
                               };
                              case 7:
                               if (!$3) {
                                break label$6
                               }
                               $4 = HEAP32[$1 + 28 >> 2];
                               $6 = HEAP32[$1 + 24 >> 2];
                               $7 = HEAP32[$1 + 20 >> 2];
                               $8 = HEAP32[$1 + 16 >> 2];
                               $9 = HEAP32[$1 + 12 >> 2];
                               $10 = HEAP32[$1 + 8 >> 2];
                               $11 = HEAP32[$1 + 4 >> 2];
                               $13 = HEAP32[$1 >> 2];
                               $2 = 0;
                               while (1) {
                                $1 = $2 << 2;
                                HEAP32[$5 >> 2] = HEAP32[$1 + $13 >> 2];
                                HEAP32[$5 + 4 >> 2] = HEAP32[$1 + $11 >> 2];
                                HEAP32[$5 + 8 >> 2] = HEAP32[$1 + $10 >> 2];
                                HEAP32[$5 + 12 >> 2] = HEAP32[$1 + $9 >> 2];
                                HEAP32[$5 + 16 >> 2] = HEAP32[$1 + $8 >> 2];
                                HEAP32[$5 + 20 >> 2] = HEAP32[$1 + $7 >> 2];
                                HEAP32[$5 + 24 >> 2] = HEAP32[$1 + $6 >> 2];
                                HEAP32[$5 + 28 >> 2] = HEAP32[$1 + $4 >> 2];
                                $5 = $5 + 32 | 0;
                                $2 = $2 + 1 | 0;
                                if (($3 | 0) != ($2 | 0)) {
                                 continue
                                }
                                break;
                               };
                               break label$6;
                              case 5:
                               if (!$3) {
                                break label$6
                               }
                               $4 = HEAP32[$1 + 20 >> 2];
                               $6 = HEAP32[$1 + 16 >> 2];
                               $7 = HEAP32[$1 + 12 >> 2];
                               $8 = HEAP32[$1 + 8 >> 2];
                               $9 = HEAP32[$1 + 4 >> 2];
                               $10 = HEAP32[$1 >> 2];
                               $2 = 0;
                               while (1) {
                                $1 = $2 << 2;
                                HEAP32[$5 >> 2] = HEAP32[$1 + $10 >> 2];
                                HEAP32[$5 + 4 >> 2] = HEAP32[$1 + $9 >> 2];
                                HEAP32[$5 + 8 >> 2] = HEAP32[$1 + $8 >> 2];
                                HEAP32[$5 + 12 >> 2] = HEAP32[$1 + $7 >> 2];
                                HEAP32[$5 + 16 >> 2] = HEAP32[$1 + $6 >> 2];
                                HEAP32[$5 + 20 >> 2] = HEAP32[$1 + $4 >> 2];
                                $5 = $5 + 24 | 0;
                                $2 = $2 + 1 | 0;
                                if (($3 | 0) != ($2 | 0)) {
                                 continue
                                }
                                break;
                               };
                               break label$6;
                              case 3:
                               if (!$3) {
                                break label$6
                               }
                               $9 = $3 & 1;
                               $2 = HEAP32[$1 + 12 >> 2];
                               $6 = HEAP32[$1 + 8 >> 2];
                               $7 = HEAP32[$1 + 4 >> 2];
                               $8 = HEAP32[$1 >> 2];
                               if (($3 | 0) != 1) {
                                break label$9
                               }
                               $3 = 0;
                               break label$8;
                              case 1:
                               if (!$3) {
                                break label$6
                               }
                               $7 = $3 & 3;
                               $2 = HEAP32[$1 + 4 >> 2];
                               $4 = HEAP32[$1 >> 2];
                               if ($3 - 1 >>> 0 >= 3) {
                                break label$11
                               }
                               $1 = 0;
                               break label$10;
                              case 0:
                               break label$34;
                              case 2:
                              case 4:
                              case 6:
                               break label$7;
                              };
                             }
                             if (!$3) {
                              break label$6
                             }
                             $4 = $3 & 3;
                             $2 = HEAP32[$1 >> 2];
                             if ($3 - 1 >>> 0 >= 3) {
                              break label$13
                             }
                             $1 = 0;
                             break label$12;
                            }
                            if (!$3) {
                             break label$6
                            }
                            $2 = 0;
                            while (1) {
                             $6 = $2 << 2;
                             $4 = HEAP32[$6 + HEAP32[$1 >> 2] >> 2];
                             HEAP8[$5 | 0] = $4;
                             HEAP8[$5 + 2 | 0] = $4 >>> 16;
                             HEAP8[$5 + 1 | 0] = $4 >>> 8;
                             $4 = HEAP32[$6 + HEAP32[$1 + 4 >> 2] >> 2];
                             HEAP8[$5 + 3 | 0] = $4;
                             HEAP8[$5 + 5 | 0] = $4 >>> 16;
                             HEAP8[$5 + 4 | 0] = $4 >>> 8;
                             $5 = $5 + 6 | 0;
                             $2 = $2 + 1 | 0;
                             if (($3 | 0) != ($2 | 0)) {
                              continue
                             }
                             break;
                            };
                            break label$6;
                           }
                           if (!$3) {
                            break label$6
                           }
                           $6 = $3 & 1;
                           $2 = 0;
                           if (($3 | 0) != 1) {
                            $4 = $3 & -2;
                            while (1) {
                             $7 = $2 << 2;
                             $3 = HEAP32[$7 + HEAP32[$1 >> 2] >> 2];
                             HEAP8[$5 | 0] = $3;
                             HEAP8[$5 + 2 | 0] = $3 >>> 16;
                             HEAP8[$5 + 1 | 0] = $3 >>> 8;
                             $3 = HEAP32[HEAP32[$1 >> 2] + ($7 | 4) >> 2];
                             HEAP8[$5 + 3 | 0] = $3;
                             HEAP8[$5 + 5 | 0] = $3 >>> 16;
                             HEAP8[$5 + 4 | 0] = $3 >>> 8;
                             $2 = $2 + 2 | 0;
                             $5 = $5 + 6 | 0;
                             $4 = $4 - 2 | 0;
                             if ($4) {
                              continue
                             }
                             break;
                            };
                           }
                           if (!$6) {
                            break label$6
                           }
                           $1 = HEAP32[HEAP32[$1 >> 2] + ($2 << 2) >> 2];
                           HEAP8[$5 | 0] = $1;
                           HEAP8[$5 + 2 | 0] = $1 >>> 16;
                           HEAP8[$5 + 1 | 0] = $1 >>> 8;
                           break label$6;
                          }
                          if (!$3) {
                           break label$6
                          }
                          $4 = HEAP32[$1 + 28 >> 2];
                          $6 = HEAP32[$1 + 24 >> 2];
                          $7 = HEAP32[$1 + 20 >> 2];
                          $8 = HEAP32[$1 + 16 >> 2];
                          $9 = HEAP32[$1 + 12 >> 2];
                          $10 = HEAP32[$1 + 8 >> 2];
                          $11 = HEAP32[$1 + 4 >> 2];
                          $13 = HEAP32[$1 >> 2];
                          $2 = 0;
                          while (1) {
                           $1 = $2 << 2;
                           HEAP16[$5 >> 1] = HEAP32[$1 + $13 >> 2];
                           HEAP16[$5 + 2 >> 1] = HEAP32[$1 + $11 >> 2];
                           HEAP16[$5 + 4 >> 1] = HEAP32[$1 + $10 >> 2];
                           HEAP16[$5 + 6 >> 1] = HEAP32[$1 + $9 >> 2];
                           HEAP16[$5 + 8 >> 1] = HEAP32[$1 + $8 >> 2];
                           HEAP16[$5 + 10 >> 1] = HEAP32[$1 + $7 >> 2];
                           HEAP16[$5 + 12 >> 1] = HEAP32[$1 + $6 >> 2];
                           HEAP16[$5 + 14 >> 1] = HEAP32[$1 + $4 >> 2];
                           $5 = $5 + 16 | 0;
                           $2 = $2 + 1 | 0;
                           if (($3 | 0) != ($2 | 0)) {
                            continue
                           }
                           break;
                          };
                          break label$6;
                         }
                         if (!$3) {
                          break label$6
                         }
                         $4 = HEAP32[$1 + 20 >> 2];
                         $6 = HEAP32[$1 + 16 >> 2];
                         $7 = HEAP32[$1 + 12 >> 2];
                         $8 = HEAP32[$1 + 8 >> 2];
                         $9 = HEAP32[$1 + 4 >> 2];
                         $10 = HEAP32[$1 >> 2];
                         $2 = 0;
                         while (1) {
                          $1 = $2 << 2;
                          HEAP16[$5 >> 1] = HEAP32[$1 + $10 >> 2];
                          HEAP16[$5 + 2 >> 1] = HEAP32[$1 + $9 >> 2];
                          HEAP16[$5 + 4 >> 1] = HEAP32[$1 + $8 >> 2];
                          HEAP16[$5 + 6 >> 1] = HEAP32[$1 + $7 >> 2];
                          HEAP16[$5 + 8 >> 1] = HEAP32[$1 + $6 >> 2];
                          HEAP16[$5 + 10 >> 1] = HEAP32[$1 + $4 >> 2];
                          $5 = $5 + 12 | 0;
                          $2 = $2 + 1 | 0;
                          if (($3 | 0) != ($2 | 0)) {
                           continue
                          }
                          break;
                         };
                         break label$6;
                        }
                        if (!$3) {
                         break label$6
                        }
                        $9 = $3 & 1;
                        $2 = HEAP32[$1 + 12 >> 2];
                        $6 = HEAP32[$1 + 8 >> 2];
                        $7 = HEAP32[$1 + 4 >> 2];
                        $8 = HEAP32[$1 >> 2];
                        if (($3 | 0) != 1) {
                         break label$15
                        }
                        $3 = 0;
                        break label$14;
                       }
                       if (!$3) {
                        break label$6
                       }
                       $7 = $3 & 3;
                       $2 = HEAP32[$1 + 4 >> 2];
                       $4 = HEAP32[$1 >> 2];
                       if ($3 - 1 >>> 0 >= 3) {
                        break label$17
                       }
                       $1 = 0;
                       break label$16;
                      }
                      if (!$3) {
                       break label$6
                      }
                      $4 = $3 & 3;
                      $2 = HEAP32[$1 >> 2];
                      if ($3 - 1 >>> 0 >= 3) {
                       break label$19
                      }
                      $1 = 0;
                      break label$18;
                     }
                     if (!$3) {
                      break label$6
                     }
                     $4 = 0;
                     while (1) {
                      $2 = $4 << 2;
                      HEAP8[$5 | 0] = HEAP32[$2 + HEAP32[$1 >> 2] >> 2];
                      HEAP8[$5 + 1 | 0] = HEAP32[$2 + HEAP32[$1 + 4 >> 2] >> 2];
                      HEAP8[$5 + 2 | 0] = HEAP32[$2 + HEAP32[$1 + 8 >> 2] >> 2];
                      HEAP8[$5 + 3 | 0] = HEAP32[$2 + HEAP32[$1 + 12 >> 2] >> 2];
                      HEAP8[$5 + 4 | 0] = HEAP32[$2 + HEAP32[$1 + 16 >> 2] >> 2];
                      HEAP8[$5 + 5 | 0] = HEAP32[$2 + HEAP32[$1 + 20 >> 2] >> 2];
                      HEAP8[$5 + 6 | 0] = HEAP32[$2 + HEAP32[$1 + 24 >> 2] >> 2];
                      HEAP8[$5 + 7 | 0] = HEAP32[$2 + HEAP32[$1 + 28 >> 2] >> 2];
                      $5 = $5 + 8 | 0;
                      $4 = $4 + 1 | 0;
                      if (($4 | 0) != ($3 | 0)) {
                       continue
                      }
                      break;
                     };
                     break label$6;
                    }
                    if (!$3) {
                     break label$6
                    }
                    $4 = 0;
                    while (1) {
                     $2 = $4 << 2;
                     HEAP8[$5 | 0] = HEAP32[$2 + HEAP32[$1 >> 2] >> 2];
                     HEAP8[$5 + 1 | 0] = HEAP32[$2 + HEAP32[$1 + 4 >> 2] >> 2];
                     HEAP8[$5 + 2 | 0] = HEAP32[$2 + HEAP32[$1 + 8 >> 2] >> 2];
                     HEAP8[$5 + 3 | 0] = HEAP32[$2 + HEAP32[$1 + 12 >> 2] >> 2];
                     HEAP8[$5 + 4 | 0] = HEAP32[$2 + HEAP32[$1 + 16 >> 2] >> 2];
                     HEAP8[$5 + 5 | 0] = HEAP32[$2 + HEAP32[$1 + 20 >> 2] >> 2];
                     $5 = $5 + 6 | 0;
                     $4 = $4 + 1 | 0;
                     if (($4 | 0) != ($3 | 0)) {
                      continue
                     }
                     break;
                    };
                    break label$6;
                   }
                   if (!$3) {
                    break label$6
                   }
                   $4 = 0;
                   while (1) {
                    $2 = $4 << 2;
                    HEAP8[$5 | 0] = HEAP32[$2 + HEAP32[$1 >> 2] >> 2];
                    HEAP8[$5 + 1 | 0] = HEAP32[$2 + HEAP32[$1 + 4 >> 2] >> 2];
                    HEAP8[$5 + 2 | 0] = HEAP32[$2 + HEAP32[$1 + 8 >> 2] >> 2];
                    HEAP8[$5 + 3 | 0] = HEAP32[$2 + HEAP32[$1 + 12 >> 2] >> 2];
                    $5 = $5 + 4 | 0;
                    $4 = $4 + 1 | 0;
                    if (($4 | 0) != ($3 | 0)) {
                     continue
                    }
                    break;
                   };
                   break label$6;
                  }
                  if (!$3) {
                   break label$6
                  }
                  $6 = $3 & 1;
                  $2 = 0;
                  if (($3 | 0) != 1) {
                   $4 = $3 & -2;
                   while (1) {
                    $3 = $2 << 2;
                    HEAP8[$5 | 0] = HEAP32[$3 + HEAP32[$1 >> 2] >> 2];
                    HEAP8[$5 + 1 | 0] = HEAP32[$3 + HEAP32[$1 + 4 >> 2] >> 2];
                    $3 = $3 | 4;
                    HEAP8[$5 + 2 | 0] = HEAP32[$3 + HEAP32[$1 >> 2] >> 2];
                    HEAP8[$5 + 3 | 0] = HEAP32[$3 + HEAP32[$1 + 4 >> 2] >> 2];
                    $2 = $2 + 2 | 0;
                    $5 = $5 + 4 | 0;
                    $4 = $4 - 2 | 0;
                    if ($4) {
                     continue
                    }
                    break;
                   };
                  }
                  if (!$6) {
                   break label$6
                  }
                  $2 = $2 << 2;
                  HEAP8[$5 | 0] = HEAP32[$2 + HEAP32[$1 >> 2] >> 2];
                  HEAP8[$5 + 1 | 0] = HEAP32[$2 + HEAP32[$1 + 4 >> 2] >> 2];
                  break label$6;
                 }
                 if (!$3) {
                  break label$6
                 }
                 $4 = $3 & 3;
                 $2 = 0;
                 if ($3 - 1 >>> 0 >= 3) {
                  $7 = $3 & -4;
                  while (1) {
                   $3 = $2 << 2;
                   HEAP8[$5 | 0] = HEAP32[$3 + HEAP32[$1 >> 2] >> 2];
                   HEAP8[$5 + 1 | 0] = HEAP32[HEAP32[$1 >> 2] + ($3 | 4) >> 2];
                   HEAP8[$5 + 2 | 0] = HEAP32[HEAP32[$1 >> 2] + ($3 | 8) >> 2];
                   HEAP8[$5 + 3 | 0] = HEAP32[HEAP32[$1 >> 2] + ($3 | 12) >> 2];
                   $2 = $2 + 4 | 0;
                   $5 = $5 + 4 | 0;
                   $7 = $7 - 4 | 0;
                   if ($7) {
                    continue
                   }
                   break;
                  };
                 }
                 if (!$4) {
                  break label$6
                 }
                 while (1) {
                  HEAP8[$5 | 0] = HEAP32[HEAP32[$1 >> 2] + ($2 << 2) >> 2];
                  $2 = $2 + 1 | 0;
                  $5 = $5 + 1 | 0;
                  $4 = $4 - 1 | 0;
                  if ($4) {
                   continue
                  }
                  break;
                 };
                 break label$6;
                }
                $7 = $3 & -4;
                $1 = 0;
                while (1) {
                 $3 = $1 << 2;
                 HEAP16[$5 >> 1] = HEAP32[$3 + $2 >> 2];
                 HEAP16[$5 + 2 >> 1] = HEAP32[$2 + ($3 | 4) >> 2];
                 HEAP16[$5 + 4 >> 1] = HEAP32[$2 + ($3 | 8) >> 2];
                 HEAP16[$5 + 6 >> 1] = HEAP32[$2 + ($3 | 12) >> 2];
                 $1 = $1 + 4 | 0;
                 $5 = $5 + 8 | 0;
                 $7 = $7 - 4 | 0;
                 if ($7) {
                  continue
                 }
                 break;
                };
               }
               if (!$4) {
                break label$6
               }
               while (1) {
                HEAP16[$5 >> 1] = HEAP32[$2 + ($1 << 2) >> 2];
                $1 = $1 + 1 | 0;
                $5 = $5 + 2 | 0;
                $4 = $4 - 1 | 0;
                if ($4) {
                 continue
                }
                break;
               };
               break label$6;
              }
              $6 = $3 & -4;
              $1 = 0;
              while (1) {
               $3 = $1 << 2;
               HEAP16[$5 >> 1] = HEAP32[$3 + $4 >> 2];
               HEAP16[$5 + 2 >> 1] = HEAP32[$2 + $3 >> 2];
               $8 = $3 | 4;
               HEAP16[$5 + 4 >> 1] = HEAP32[$8 + $4 >> 2];
               HEAP16[$5 + 6 >> 1] = HEAP32[$2 + $8 >> 2];
               $8 = $3 | 8;
               HEAP16[$5 + 8 >> 1] = HEAP32[$8 + $4 >> 2];
               HEAP16[$5 + 10 >> 1] = HEAP32[$2 + $8 >> 2];
               $3 = $3 | 12;
               HEAP16[$5 + 12 >> 1] = HEAP32[$3 + $4 >> 2];
               HEAP16[$5 + 14 >> 1] = HEAP32[$2 + $3 >> 2];
               $1 = $1 + 4 | 0;
               $5 = $5 + 16 | 0;
               $6 = $6 - 4 | 0;
               if ($6) {
                continue
               }
               break;
              };
             }
             if (!$7) {
              break label$6
             }
             while (1) {
              $3 = $1 << 2;
              HEAP16[$5 >> 1] = HEAP32[$3 + $4 >> 2];
              HEAP16[$5 + 2 >> 1] = HEAP32[$2 + $3 >> 2];
              $1 = $1 + 1 | 0;
              $5 = $5 + 4 | 0;
              $7 = $7 - 1 | 0;
              if ($7) {
               continue
              }
              break;
             };
             break label$6;
            }
            $4 = $3 & -2;
            $3 = 0;
            while (1) {
             $1 = $3 << 2;
             HEAP16[$5 >> 1] = HEAP32[$1 + $8 >> 2];
             HEAP16[$5 + 2 >> 1] = HEAP32[$1 + $7 >> 2];
             HEAP16[$5 + 4 >> 1] = HEAP32[$1 + $6 >> 2];
             HEAP16[$5 + 6 >> 1] = HEAP32[$1 + $2 >> 2];
             $1 = $1 | 4;
             HEAP16[$5 + 8 >> 1] = HEAP32[$1 + $8 >> 2];
             HEAP16[$5 + 10 >> 1] = HEAP32[$1 + $7 >> 2];
             HEAP16[$5 + 12 >> 1] = HEAP32[$1 + $6 >> 2];
             HEAP16[$5 + 14 >> 1] = HEAP32[$1 + $2 >> 2];
             $3 = $3 + 2 | 0;
             $5 = $5 + 16 | 0;
             $4 = $4 - 2 | 0;
             if ($4) {
              continue
             }
             break;
            };
           }
           if (!$9) {
            break label$6
           }
           $1 = $3 << 2;
           HEAP16[$5 >> 1] = HEAP32[$1 + $8 >> 2];
           HEAP16[$5 + 2 >> 1] = HEAP32[$1 + $7 >> 2];
           HEAP16[$5 + 4 >> 1] = HEAP32[$1 + $6 >> 2];
           HEAP16[$5 + 6 >> 1] = HEAP32[$1 + $2 >> 2];
           break label$6;
          }
          $7 = $3 & -4;
          $1 = 0;
          while (1) {
           $3 = $1 << 2;
           HEAP32[$5 >> 2] = HEAP32[$3 + $2 >> 2];
           HEAP32[$5 + 4 >> 2] = HEAP32[$2 + ($3 | 4) >> 2];
           HEAP32[$5 + 8 >> 2] = HEAP32[$2 + ($3 | 8) >> 2];
           HEAP32[$5 + 12 >> 2] = HEAP32[$2 + ($3 | 12) >> 2];
           $1 = $1 + 4 | 0;
           $5 = $5 + 16 | 0;
           $7 = $7 - 4 | 0;
           if ($7) {
            continue
           }
           break;
          };
         }
         if (!$4) {
          break label$6
         }
         while (1) {
          HEAP32[$5 >> 2] = HEAP32[$2 + ($1 << 2) >> 2];
          $1 = $1 + 1 | 0;
          $5 = $5 + 4 | 0;
          $4 = $4 - 1 | 0;
          if ($4) {
           continue
          }
          break;
         };
         break label$6;
        }
        $6 = $3 & -4;
        $1 = 0;
        while (1) {
         $3 = $1 << 2;
         HEAP32[$5 >> 2] = HEAP32[$3 + $4 >> 2];
         HEAP32[$5 + 4 >> 2] = HEAP32[$2 + $3 >> 2];
         $8 = $3 | 4;
         HEAP32[$5 + 8 >> 2] = HEAP32[$8 + $4 >> 2];
         HEAP32[$5 + 12 >> 2] = HEAP32[$2 + $8 >> 2];
         $8 = $3 | 8;
         HEAP32[$5 + 16 >> 2] = HEAP32[$8 + $4 >> 2];
         HEAP32[$5 + 20 >> 2] = HEAP32[$2 + $8 >> 2];
         $3 = $3 | 12;
         HEAP32[$5 + 24 >> 2] = HEAP32[$3 + $4 >> 2];
         HEAP32[$5 + 28 >> 2] = HEAP32[$2 + $3 >> 2];
         $1 = $1 + 4 | 0;
         $5 = $5 + 32 | 0;
         $6 = $6 - 4 | 0;
         if ($6) {
          continue
         }
         break;
        };
       }
       if (!$7) {
        break label$6
       }
       while (1) {
        $3 = $1 << 2;
        HEAP32[$5 >> 2] = HEAP32[$3 + $4 >> 2];
        HEAP32[$5 + 4 >> 2] = HEAP32[$2 + $3 >> 2];
        $1 = $1 + 1 | 0;
        $5 = $5 + 8 | 0;
        $7 = $7 - 1 | 0;
        if ($7) {
         continue
        }
        break;
       };
       break label$6;
      }
      $4 = $3 & -2;
      $3 = 0;
      while (1) {
       $1 = $3 << 2;
       HEAP32[$5 >> 2] = HEAP32[$1 + $8 >> 2];
       HEAP32[$5 + 4 >> 2] = HEAP32[$1 + $7 >> 2];
       HEAP32[$5 + 8 >> 2] = HEAP32[$1 + $6 >> 2];
       HEAP32[$5 + 12 >> 2] = HEAP32[$1 + $2 >> 2];
       $1 = $1 | 4;
       HEAP32[$5 + 16 >> 2] = HEAP32[$1 + $8 >> 2];
       HEAP32[$5 + 20 >> 2] = HEAP32[$1 + $7 >> 2];
       HEAP32[$5 + 24 >> 2] = HEAP32[$1 + $6 >> 2];
       HEAP32[$5 + 28 >> 2] = HEAP32[$1 + $2 >> 2];
       $3 = $3 + 2 | 0;
       $5 = $5 + 32 | 0;
       $4 = $4 - 2 | 0;
       if ($4) {
        continue
       }
       break;
      };
     }
     if (!$9) {
      break label$6
     }
     $1 = $3 << 2;
     HEAP32[$5 >> 2] = HEAP32[$1 + $8 >> 2];
     HEAP32[$5 + 4 >> 2] = HEAP32[$1 + $7 >> 2];
     HEAP32[$5 + 8 >> 2] = HEAP32[$1 + $6 >> 2];
     HEAP32[$5 + 12 >> 2] = HEAP32[$1 + $2 >> 2];
     break label$6;
    }
    label$65 : {
     switch ($4 - 1 | 0) {
     case 3:
      if (!$3 | !$2) {
       break label$6
      }
      $7 = $2 & -4;
      $8 = $2 & 3;
      $6 = 0;
      $11 = $2 - 1 >>> 0 < 3;
      while (1) {
       $2 = 0;
       $4 = $7;
       if (!$11) {
        while (1) {
         $10 = $6 << 2;
         $9 = $2 << 2;
         HEAP32[$5 >> 2] = HEAP32[$10 + HEAP32[$9 + $1 >> 2] >> 2];
         HEAP32[$5 + 4 >> 2] = HEAP32[$10 + HEAP32[($9 | 4) + $1 >> 2] >> 2];
         HEAP32[$5 + 8 >> 2] = HEAP32[$10 + HEAP32[($9 | 8) + $1 >> 2] >> 2];
         HEAP32[$5 + 12 >> 2] = HEAP32[$10 + HEAP32[($9 | 12) + $1 >> 2] >> 2];
         $2 = $2 + 4 | 0;
         $5 = $5 + 16 | 0;
         $4 = $4 - 4 | 0;
         if ($4) {
          continue
         }
         break;
        }
       }
       $4 = $8;
       if ($4) {
        while (1) {
         HEAP32[$5 >> 2] = HEAP32[HEAP32[($2 << 2) + $1 >> 2] + ($6 << 2) >> 2];
         $2 = $2 + 1 | 0;
         $5 = $5 + 4 | 0;
         $4 = $4 - 1 | 0;
         if ($4) {
          continue
         }
         break;
        }
       }
       $6 = $6 + 1 | 0;
       if (($6 | 0) != ($3 | 0)) {
        continue
       }
       break;
      };
      break label$6;
     case 2:
      if (!$3 | !$2) {
       break label$6
      }
      $7 = $2 & -2;
      $10 = $2 & 1;
      while (1) {
       $4 = 0;
       $6 = $7;
       if (($2 | 0) != 1) {
        while (1) {
         $13 = $8 << 2;
         $11 = $4 << 2;
         $9 = HEAP32[$13 + HEAP32[$11 + $1 >> 2] >> 2];
         HEAP8[$5 | 0] = $9;
         HEAP8[$5 + 2 | 0] = $9 >>> 16;
         HEAP8[$5 + 1 | 0] = $9 >>> 8;
         $9 = HEAP32[$13 + HEAP32[($11 | 4) + $1 >> 2] >> 2];
         HEAP8[$5 + 3 | 0] = $9;
         HEAP8[$5 + 5 | 0] = $9 >>> 16;
         HEAP8[$5 + 4 | 0] = $9 >>> 8;
         $4 = $4 + 2 | 0;
         $5 = $5 + 6 | 0;
         $6 = $6 - 2 | 0;
         if ($6) {
          continue
         }
         break;
        }
       }
       if ($10) {
        $4 = HEAP32[HEAP32[($4 << 2) + $1 >> 2] + ($8 << 2) >> 2];
        HEAP8[$5 | 0] = $4;
        HEAP8[$5 + 2 | 0] = $4 >>> 16;
        HEAP8[$5 + 1 | 0] = $4 >>> 8;
        $5 = $5 + 3 | 0;
       }
       $8 = $8 + 1 | 0;
       if (($8 | 0) != ($3 | 0)) {
        continue
       }
       break;
      };
      break label$6;
     case 1:
      if (!$3 | !$2) {
       break label$6
      }
      $7 = $2 & -4;
      $8 = $2 & 3;
      $6 = 0;
      $11 = $2 - 1 >>> 0 < 3;
      while (1) {
       $2 = 0;
       $4 = $7;
       if (!$11) {
        while (1) {
         $10 = $6 << 2;
         $9 = $2 << 2;
         HEAP16[$5 >> 1] = HEAP32[$10 + HEAP32[$9 + $1 >> 2] >> 2];
         HEAP16[$5 + 2 >> 1] = HEAP32[$10 + HEAP32[($9 | 4) + $1 >> 2] >> 2];
         HEAP16[$5 + 4 >> 1] = HEAP32[$10 + HEAP32[($9 | 8) + $1 >> 2] >> 2];
         HEAP16[$5 + 6 >> 1] = HEAP32[$10 + HEAP32[($9 | 12) + $1 >> 2] >> 2];
         $2 = $2 + 4 | 0;
         $5 = $5 + 8 | 0;
         $4 = $4 - 4 | 0;
         if ($4) {
          continue
         }
         break;
        }
       }
       $4 = $8;
       if ($4) {
        while (1) {
         HEAP16[$5 >> 1] = HEAP32[HEAP32[($2 << 2) + $1 >> 2] + ($6 << 2) >> 2];
         $2 = $2 + 1 | 0;
         $5 = $5 + 2 | 0;
         $4 = $4 - 1 | 0;
         if ($4) {
          continue
         }
         break;
        }
       }
       $6 = $6 + 1 | 0;
       if (($6 | 0) != ($3 | 0)) {
        continue
       }
       break;
      };
      break label$6;
     case 0:
      break label$65;
     default:
      break label$6;
     };
    }
    if (!$3 | !$2) {
     break label$6
    }
    $7 = $2 & -4;
    $8 = $2 & 3;
    $6 = 0;
    $11 = $2 - 1 >>> 0 < 3;
    while (1) {
     $2 = 0;
     $4 = $7;
     if (!$11) {
      while (1) {
       $10 = $6 << 2;
       $9 = $2 << 2;
       HEAP8[$5 | 0] = HEAP32[$10 + HEAP32[$9 + $1 >> 2] >> 2];
       HEAP8[$5 + 1 | 0] = HEAP32[$10 + HEAP32[($9 | 4) + $1 >> 2] >> 2];
       HEAP8[$5 + 2 | 0] = HEAP32[$10 + HEAP32[($9 | 8) + $1 >> 2] >> 2];
       HEAP8[$5 + 3 | 0] = HEAP32[$10 + HEAP32[($9 | 12) + $1 >> 2] >> 2];
       $2 = $2 + 4 | 0;
       $5 = $5 + 4 | 0;
       $4 = $4 - 4 | 0;
       if ($4) {
        continue
       }
       break;
      }
     }
     $4 = $8;
     if ($4) {
      while (1) {
       HEAP8[$5 | 0] = HEAP32[HEAP32[($2 << 2) + $1 >> 2] + ($6 << 2) >> 2];
       $2 = $2 + 1 | 0;
       $5 = $5 + 1 | 0;
       $4 = $4 - 1 | 0;
       if ($4) {
        continue
       }
       break;
      }
     }
     $6 = $6 + 1 | 0;
     if (($6 | 0) != ($3 | 0)) {
      continue
     }
     break;
    };
   }
   $1 = HEAP32[$0 + 80 >> 2];
   $2 = $1 + $12 | 0;
   HEAP32[$0 + 80 >> 2] = $2;
   if ($1 >>> 0 > $2 >>> 0) {
    $2 = $0 + 84 | 0;
    HEAP32[$2 >> 2] = HEAP32[$2 >> 2] + 1;
   }
   $2 = HEAP32[$0 + 88 >> 2];
   $3 = $1 | -64;
   $1 = 64 - ($1 & 63) | 0;
   label$89 : {
    if ($12 >>> 0 < $1 >>> 0) {
     __memcpy(($0 + $3 | 0) - -64 | 0, $2, $12);
     break label$89;
    }
    $6 = $0 - -64 | 0;
    __memcpy($6 + $3 | 0, $2, $1);
    FLAC__MD5Transform($6, $0);
    $5 = $1 + $2 | 0;
    $1 = $12 - $1 | 0;
    if ($1 >>> 0 >= 64) {
     while (1) {
      $2 = HEAPU8[$5 + 4 | 0] | HEAPU8[$5 + 5 | 0] << 8 | (HEAPU8[$5 + 6 | 0] << 16 | HEAPU8[$5 + 7 | 0] << 24);
      $3 = HEAPU8[$5 | 0] | HEAPU8[$5 + 1 | 0] << 8 | (HEAPU8[$5 + 2 | 0] << 16 | HEAPU8[$5 + 3 | 0] << 24);
      HEAP8[$0 | 0] = $3;
      HEAP8[$0 + 1 | 0] = $3 >>> 8;
      HEAP8[$0 + 2 | 0] = $3 >>> 16;
      HEAP8[$0 + 3 | 0] = $3 >>> 24;
      HEAP8[$0 + 4 | 0] = $2;
      HEAP8[$0 + 5 | 0] = $2 >>> 8;
      HEAP8[$0 + 6 | 0] = $2 >>> 16;
      HEAP8[$0 + 7 | 0] = $2 >>> 24;
      $3 = $5 + 56 | 0;
      $4 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
      $2 = $0 + 56 | 0;
      $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
      HEAP8[$2 | 0] = $3;
      HEAP8[$2 + 1 | 0] = $3 >>> 8;
      HEAP8[$2 + 2 | 0] = $3 >>> 16;
      HEAP8[$2 + 3 | 0] = $3 >>> 24;
      HEAP8[$2 + 4 | 0] = $4;
      HEAP8[$2 + 5 | 0] = $4 >>> 8;
      HEAP8[$2 + 6 | 0] = $4 >>> 16;
      HEAP8[$2 + 7 | 0] = $4 >>> 24;
      $3 = $5 + 48 | 0;
      $4 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
      $2 = $0 + 48 | 0;
      $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
      HEAP8[$2 | 0] = $3;
      HEAP8[$2 + 1 | 0] = $3 >>> 8;
      HEAP8[$2 + 2 | 0] = $3 >>> 16;
      HEAP8[$2 + 3 | 0] = $3 >>> 24;
      HEAP8[$2 + 4 | 0] = $4;
      HEAP8[$2 + 5 | 0] = $4 >>> 8;
      HEAP8[$2 + 6 | 0] = $4 >>> 16;
      HEAP8[$2 + 7 | 0] = $4 >>> 24;
      $3 = $5 + 40 | 0;
      $4 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
      $2 = $0 + 40 | 0;
      $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
      HEAP8[$2 | 0] = $3;
      HEAP8[$2 + 1 | 0] = $3 >>> 8;
      HEAP8[$2 + 2 | 0] = $3 >>> 16;
      HEAP8[$2 + 3 | 0] = $3 >>> 24;
      HEAP8[$2 + 4 | 0] = $4;
      HEAP8[$2 + 5 | 0] = $4 >>> 8;
      HEAP8[$2 + 6 | 0] = $4 >>> 16;
      HEAP8[$2 + 7 | 0] = $4 >>> 24;
      $3 = $5 + 32 | 0;
      $4 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
      $2 = $0 + 32 | 0;
      $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
      HEAP8[$2 | 0] = $3;
      HEAP8[$2 + 1 | 0] = $3 >>> 8;
      HEAP8[$2 + 2 | 0] = $3 >>> 16;
      HEAP8[$2 + 3 | 0] = $3 >>> 24;
      HEAP8[$2 + 4 | 0] = $4;
      HEAP8[$2 + 5 | 0] = $4 >>> 8;
      HEAP8[$2 + 6 | 0] = $4 >>> 16;
      HEAP8[$2 + 7 | 0] = $4 >>> 24;
      $3 = $5 + 24 | 0;
      $4 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
      $2 = $0 + 24 | 0;
      $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
      HEAP8[$2 | 0] = $3;
      HEAP8[$2 + 1 | 0] = $3 >>> 8;
      HEAP8[$2 + 2 | 0] = $3 >>> 16;
      HEAP8[$2 + 3 | 0] = $3 >>> 24;
      HEAP8[$2 + 4 | 0] = $4;
      HEAP8[$2 + 5 | 0] = $4 >>> 8;
      HEAP8[$2 + 6 | 0] = $4 >>> 16;
      HEAP8[$2 + 7 | 0] = $4 >>> 24;
      $3 = $5 + 16 | 0;
      $4 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
      $2 = $0 + 16 | 0;
      $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
      HEAP8[$2 | 0] = $3;
      HEAP8[$2 + 1 | 0] = $3 >>> 8;
      HEAP8[$2 + 2 | 0] = $3 >>> 16;
      HEAP8[$2 + 3 | 0] = $3 >>> 24;
      HEAP8[$2 + 4 | 0] = $4;
      HEAP8[$2 + 5 | 0] = $4 >>> 8;
      HEAP8[$2 + 6 | 0] = $4 >>> 16;
      HEAP8[$2 + 7 | 0] = $4 >>> 24;
      $3 = $5 + 8 | 0;
      $4 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
      $2 = $0 + 8 | 0;
      $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
      HEAP8[$2 | 0] = $3;
      HEAP8[$2 + 1 | 0] = $3 >>> 8;
      HEAP8[$2 + 2 | 0] = $3 >>> 16;
      HEAP8[$2 + 3 | 0] = $3 >>> 24;
      HEAP8[$2 + 4 | 0] = $4;
      HEAP8[$2 + 5 | 0] = $4 >>> 8;
      HEAP8[$2 + 6 | 0] = $4 >>> 16;
      HEAP8[$2 + 7 | 0] = $4 >>> 24;
      FLAC__MD5Transform($6, $0);
      $5 = $5 - -64 | 0;
      $1 = $1 + -64 | 0;
      if ($1 >>> 0 > 63) {
       continue
      }
      break;
     }
    }
    __memcpy($0, $5, $1);
   }
   $5 = 1;
  }
  return $5;
 }
 
 function __stdio_close($0) {
  $0 = $0 | 0;
  return __wasi_fd_close(HEAP32[$0 + 60 >> 2]) | 0;
 }
 
 function __wasi_syscall_ret($0) {
  if (!$0) {
   return 0
  }
  HEAP32[2892] = $0;
  return -1;
 }
 
 function __stdio_read($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  $3 = __stack_pointer - 32 | 0;
  __stack_pointer = $3;
  HEAP32[$3 + 16 >> 2] = $1;
  $4 = HEAP32[$0 + 48 >> 2];
  HEAP32[$3 + 20 >> 2] = $2 - (($4 | 0) != 0);
  $5 = HEAP32[$0 + 44 >> 2];
  HEAP32[$3 + 28 >> 2] = $4;
  HEAP32[$3 + 24 >> 2] = $5;
  $4 = -1;
  label$1 : {
   label$2 : {
    if (!__wasi_syscall_ret(__wasi_fd_read(HEAP32[$0 + 60 >> 2], $3 + 16 | 0, 2, $3 + 12 | 0) | 0)) {
     $4 = HEAP32[$3 + 12 >> 2];
     if (($4 | 0) > 0) {
      break label$2
     }
    }
    HEAP32[$0 >> 2] = HEAP32[$0 >> 2] | $4 & 48 ^ 16;
    break label$1;
   }
   $6 = HEAP32[$3 + 20 >> 2];
   if ($6 >>> 0 >= $4 >>> 0) {
    break label$1
   }
   $5 = HEAP32[$0 + 44 >> 2];
   HEAP32[$0 + 4 >> 2] = $5;
   HEAP32[$0 + 8 >> 2] = $5 + ($4 - $6 | 0);
   if (HEAP32[$0 + 48 >> 2]) {
    HEAP32[$0 + 4 >> 2] = $5 + 1;
    HEAP8[($1 + $2 | 0) - 1 | 0] = HEAPU8[$5 | 0];
   }
   $4 = $2;
  }
  __stack_pointer = $3 + 32 | 0;
  return $4 | 0;
 }
 
 function __stdio_seek($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0;
  $4 = __stack_pointer - 16 | 0;
  __stack_pointer = $4;
  $0 = __wasi_syscall_ret(legalimport$__wasi_fd_seek(HEAP32[$0 + 60 >> 2], $1 | 0, $2 | 0, $3 & 255, $4 + 8 | 0) | 0);
  __stack_pointer = $4 + 16 | 0;
  i64toi32_i32$HIGH_BITS = $0 ? -1 : HEAP32[$4 + 12 >> 2];
  return ($0 ? -1 : HEAP32[$4 + 8 >> 2]) | 0;
 }
 
 function fflush($0) {
  var $1 = 0;
  if ($0) {
   if (HEAP32[$0 + 76 >> 2] <= -1) {
    return __fflush_unlocked($0)
   }
   return __fflush_unlocked($0);
  }
  if (HEAP32[2788]) {
   $1 = fflush(HEAP32[2788])
  }
  $0 = HEAP32[3019];
  if ($0) {
   while (1) {
    if (HEAPU32[$0 + 20 >> 2] > HEAPU32[$0 + 28 >> 2]) {
     $1 = __fflush_unlocked($0) | $1
    }
    $0 = HEAP32[$0 + 56 >> 2];
    if ($0) {
     continue
    }
    break;
   }
  }
  return $1;
 }
 
 function __fflush_unlocked($0) {
  var $1 = 0, $2 = 0;
  label$1 : {
   if (HEAPU32[$0 + 20 >> 2] <= HEAPU32[$0 + 28 >> 2]) {
    break label$1
   }
   FUNCTION_TABLE[HEAP32[$0 + 36 >> 2]]($0, 0, 0) | 0;
   if (HEAP32[$0 + 20 >> 2]) {
    break label$1
   }
   return -1;
  }
  $1 = HEAP32[$0 + 4 >> 2];
  $2 = HEAP32[$0 + 8 >> 2];
  if ($1 >>> 0 < $2 >>> 0) {
   $1 = $1 - $2 | 0;
   FUNCTION_TABLE[HEAP32[$0 + 40 >> 2]]($0, $1, $1 >> 31, 1) | 0;
  }
  HEAP32[$0 + 28 >> 2] = 0;
  HEAP32[$0 + 16 >> 2] = 0;
  HEAP32[$0 + 20 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
  HEAP32[$0 + 8 >> 2] = 0;
  return 0;
 }
 
 function fclose($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0;
  $4 = HEAP32[$0 + 76 >> 2] >= 0;
  $3 = HEAP32[$0 >> 2] & 1;
  if (!$3) {
   $1 = HEAP32[$0 + 52 >> 2];
   if ($1) {
    HEAP32[$1 + 56 >> 2] = HEAP32[$0 + 56 >> 2]
   }
   $2 = HEAP32[$0 + 56 >> 2];
   if ($2) {
    HEAP32[$2 + 52 >> 2] = $1
   }
   if (($0 | 0) == HEAP32[3019]) {
    HEAP32[3019] = $2
   }
  }
  fflush($0);
  FUNCTION_TABLE[HEAP32[$0 + 12 >> 2]]($0) | 0;
  $1 = HEAP32[$0 + 96 >> 2];
  if ($1) {
   dlfree($1)
  }
  label$7 : {
   if (!$3) {
    dlfree($0);
    break label$7;
   }
   if (!$4) {
    break label$7
   }
  }
 }
 
 function memcmp($0, $1, $2) {
  var $3 = 0, $4 = 0;
  label$1 : {
   label$2 : {
    if ($2 >>> 0 >= 4) {
     if (($0 | $1) & 3) {
      break label$2
     }
     while (1) {
      if (HEAP32[$0 >> 2] != HEAP32[$1 >> 2]) {
       break label$2
      }
      $1 = $1 + 4 | 0;
      $0 = $0 + 4 | 0;
      $2 = $2 - 4 | 0;
      if ($2 >>> 0 > 3) {
       continue
      }
      break;
     };
    }
    if (!$2) {
     break label$1
    }
   }
   while (1) {
    $3 = HEAPU8[$0 | 0];
    $4 = HEAPU8[$1 | 0];
    if (($3 | 0) == ($4 | 0)) {
     $1 = $1 + 1 | 0;
     $0 = $0 + 1 | 0;
     $2 = $2 - 1 | 0;
     if ($2) {
      continue
     }
     break label$1;
    }
    break;
   };
   return $3 - $4 | 0;
  }
  return 0;
 }
 
 function FLAC__cpu_info($0) {
  var $1 = 0;
  HEAP32[$0 + 8 >> 2] = 0;
  HEAP32[$0 + 12 >> 2] = 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 3;
  $1 = $0 + 56 | 0;
  HEAP32[$1 >> 2] = 0;
  HEAP32[$1 + 4 >> 2] = 0;
  $1 = $0 + 48 | 0;
  HEAP32[$1 >> 2] = 0;
  HEAP32[$1 + 4 >> 2] = 0;
  $1 = $0 + 40 | 0;
  HEAP32[$1 >> 2] = 0;
  HEAP32[$1 + 4 >> 2] = 0;
  $1 = $0 + 32 | 0;
  HEAP32[$1 >> 2] = 0;
  HEAP32[$1 + 4 >> 2] = 0;
  $1 = $0 + 24 | 0;
  HEAP32[$1 >> 2] = 0;
  HEAP32[$1 + 4 >> 2] = 0;
  $0 = $0 + 16 | 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
 }
 
 function lround($0) {
  var $1 = 0.0, $2 = 0.0, $3 = 0, $4 = 0;
  wasm2js_scratch_store_f64(+$0);
  $3 = wasm2js_scratch_load_i32(1) | 0;
  wasm2js_scratch_load_i32(0) | 0;
  $4 = $3 >>> 20 & 2047;
  __inlined_func$round : {
   if ($4 >>> 0 <= 1074) {
    $1 = $0 * 0.0;
    if ($4 >>> 0 <= 1021) {
     break __inlined_func$round
    }
    $0 = ($3 | 0) > -1 ? $0 : -$0;
    $2 = $0 + 4503599627370496.0 + -4503599627370496.0 - $0;
    label$3 : {
     if ($2 > .5) {
      $1 = $0 + $2 + -1.0;
      break label$3;
     }
     $0 = $0 + $2;
     $1 = $0;
     if (!($2 <= -.5)) {
      break label$3
     }
     $1 = $0 + 1.0;
    }
    $0 = $1;
    $0 = ($3 | 0) > -1 ? $0 : -$0;
   }
   $1 = $0;
  }
  $0 = $1;
  if (Math_abs($0) < 2147483648.0) {
   return ~~$0
  }
  return -2147483648;
 }
 
 function log($0) {
  var $1 = 0, $2 = 0.0, $3 = 0.0, $4 = 0, $5 = 0.0, $6 = 0, $7 = 0, $8 = 0.0, $9 = 0.0, $10 = 0.0;
  wasm2js_scratch_store_f64(+$0);
  $4 = wasm2js_scratch_load_i32(1) | 0;
  $6 = wasm2js_scratch_load_i32(0) | 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      $1 = $4;
      $4 = $1;
      if ($1 >>> 0 >= 1048576) {
       if (($1 | 0) > -1) {
        break label$4
       }
      }
      if (!(($6 | 0) != 0 | ($1 & 2147483647) != 0)) {
       return -1.0 / ($0 * $0)
      }
      if (($1 | 0) > -1) {
       break label$3
      }
      return ($0 - $0) / 0.0;
     }
     if ($4 >>> 0 > 2146435071) {
      break label$1
     }
     $1 = 1072693248;
     $7 = -1023;
     if (($4 | 0) != 1072693248) {
      $1 = $4;
      break label$2;
     }
     if ($6) {
      break label$2
     }
     return 0.0;
    }
    wasm2js_scratch_store_f64(+($0 * 18014398509481984.0));
    $1 = wasm2js_scratch_load_i32(1) | 0;
    $6 = wasm2js_scratch_load_i32(0) | 0;
    $7 = -1077;
   }
   $1 = $1 + 614242 | 0;
   $3 = +(($1 >>> 20 | 0) + $7 | 0);
   $0 = $3 * .6931471803691238;
   wasm2js_scratch_store_i32(0, $6 | 0);
   wasm2js_scratch_store_i32(1, ($1 & 1048575) + 1072079006 | 0);
   $5 = +wasm2js_scratch_load_f64() + -1.0;
   $2 = $5 / ($5 + 2.0);
   $8 = $0;
   $9 = $3 * 1.9082149292705877e-10;
   $10 = $2;
   $0 = $5 * ($5 * .5);
   $3 = $2 * $2;
   $2 = $3 * $3;
   $0 = $8 + ($5 + ($9 + $10 * ($0 + ($2 * ($2 * ($2 * .15313837699209373 + .22222198432149784) + .3999999999940942) + $3 * ($2 * ($2 * ($2 * .14798198605116586 + .1818357216161805) + .2857142874366239) + .6666666666666735))) - $0));
  }
  return $0;
 }
 
 function FLAC__lpc_compute_autocorrelation($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = Math_fround(0), $11 = 0, $12 = 0, $13 = 0;
  $12 = $1 - $2 | 0;
  label$1 : {
   if (!$2) {
    while (1) {
     $6 = $6 + 1 | 0;
     if ($12 >>> 0 >= $6 >>> 0) {
      continue
     }
     break;
    };
    break label$1;
   }
   $11 = memset($3, $2 << 2);
   $7 = $2 & -2;
   $9 = $2 & 1;
   while (1) {
    $10 = HEAPF32[($6 << 2) + $0 >> 2];
    $4 = 0;
    $5 = $7;
    if (($2 | 0) != 1) {
     while (1) {
      $8 = $11 + ($4 << 2) | 0;
      HEAPF32[$8 >> 2] = HEAPF32[$8 >> 2] + Math_fround($10 * HEAPF32[($4 + $6 << 2) + $0 >> 2]);
      $8 = $4 | 1;
      $13 = $11 + ($8 << 2) | 0;
      HEAPF32[$13 >> 2] = HEAPF32[$13 >> 2] + Math_fround($10 * HEAPF32[($6 + $8 << 2) + $0 >> 2]);
      $4 = $4 + 2 | 0;
      $5 = $5 - 2 | 0;
      if ($5) {
       continue
      }
      break;
     }
    }
    if ($9) {
     $5 = $11 + ($4 << 2) | 0;
     HEAPF32[$5 >> 2] = HEAPF32[$5 >> 2] + Math_fround($10 * HEAPF32[($4 + $6 << 2) + $0 >> 2]);
    }
    $6 = $6 + 1 | 0;
    if ($12 >>> 0 >= $6 >>> 0) {
     continue
    }
    break;
   };
  }
  if ($1 >>> 0 > $6 >>> 0) {
   $11 = ($6 ^ -1) + $1 | 0;
   $2 = 0;
   $5 = $6;
   while (1) {
    label$10 : {
     if (($1 | 0) == ($5 | 0)) {
      break label$10
     }
     $10 = HEAPF32[($5 << 2) + $0 >> 2];
     $7 = $1 - ($2 + $6 | 0) | 0;
     $12 = $7 & 1;
     $4 = 0;
     if (($2 | 0) != ($11 | 0)) {
      $7 = $7 & -2;
      while (1) {
       $9 = ($4 << 2) + $3 | 0;
       HEAPF32[$9 >> 2] = HEAPF32[$9 >> 2] + Math_fround($10 * HEAPF32[($4 + $5 << 2) + $0 >> 2]);
       $9 = $4 | 1;
       $8 = ($9 << 2) + $3 | 0;
       HEAPF32[$8 >> 2] = HEAPF32[$8 >> 2] + Math_fround($10 * HEAPF32[($5 + $9 << 2) + $0 >> 2]);
       $4 = $4 + 2 | 0;
       $7 = $7 - 2 | 0;
       if ($7) {
        continue
       }
       break;
      };
     }
     if (!$12) {
      break label$10
     }
     $7 = ($4 << 2) + $3 | 0;
     HEAPF32[$7 >> 2] = HEAPF32[$7 >> 2] + Math_fround($10 * HEAPF32[($4 + $5 << 2) + $0 >> 2]);
    }
    $2 = $2 + 1 | 0;
    $5 = $5 + 1 | 0;
    if (($5 | 0) != ($1 | 0)) {
     continue
    }
    break;
   };
  }
 }
 
 function FLAC__lpc_compute_residual_from_qlp_coefficients($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0;
  label$1 : {
   label$2 : {
    if ($3 >>> 0 >= 13) {
     if (($1 | 0) <= 0) {
      break label$1
     }
     $9 = $3 - 13 | 0;
     break label$2;
    }
    if ($3 >>> 0 >= 9) {
     if ($3 >>> 0 >= 11) {
      if (($3 | 0) != 12) {
       if (($1 | 0) < 1) {
        break label$1
       }
       $15 = HEAP32[$0 - 4 >> 2];
       $3 = HEAP32[$0 - 8 >> 2];
       $6 = HEAP32[$0 - 12 >> 2];
       $7 = HEAP32[$0 - 16 >> 2];
       $8 = HEAP32[$0 - 20 >> 2];
       $9 = HEAP32[$0 - 24 >> 2];
       $10 = HEAP32[$0 - 28 >> 2];
       $11 = HEAP32[$0 - 32 >> 2];
       $12 = HEAP32[$0 - 36 >> 2];
       $13 = HEAP32[$0 - 40 >> 2];
       $16 = HEAP32[$0 - 44 >> 2];
       $27 = HEAP32[$2 >> 2];
       $28 = HEAP32[$2 + 4 >> 2];
       $25 = HEAP32[$2 + 8 >> 2];
       $26 = HEAP32[$2 + 12 >> 2];
       $23 = HEAP32[$2 + 16 >> 2];
       $24 = HEAP32[$2 + 20 >> 2];
       $21 = HEAP32[$2 + 24 >> 2];
       $22 = HEAP32[$2 + 28 >> 2];
       $19 = HEAP32[$2 + 32 >> 2];
       $20 = HEAP32[$2 + 36 >> 2];
       $18 = HEAP32[$2 + 40 >> 2];
       $2 = 0;
       while (1) {
        $14 = $13;
        $13 = $12;
        $12 = $11;
        $11 = $10;
        $10 = $9;
        $9 = $8;
        $8 = $7;
        $7 = $6;
        $6 = $3;
        $3 = $15;
        $17 = $2 << 2;
        $15 = HEAP32[$17 + $0 >> 2];
        HEAP32[$5 + $17 >> 2] = $15 - ((((((((((Math_imul($14, $20) + Math_imul($16, $18) | 0) + Math_imul($13, $19) | 0) + Math_imul($12, $22) | 0) + Math_imul($11, $21) | 0) + Math_imul($10, $24) | 0) + Math_imul($9, $23) | 0) + Math_imul($8, $26) | 0) + Math_imul($7, $25) | 0) + Math_imul($6, $28) | 0) + Math_imul($3, $27) >> $4);
        $16 = $14;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       break label$1;
      }
      if (($1 | 0) < 1) {
       break label$1
      }
      $16 = HEAP32[$0 - 4 >> 2];
      $3 = HEAP32[$0 - 8 >> 2];
      $6 = HEAP32[$0 - 12 >> 2];
      $7 = HEAP32[$0 - 16 >> 2];
      $8 = HEAP32[$0 - 20 >> 2];
      $9 = HEAP32[$0 - 24 >> 2];
      $10 = HEAP32[$0 - 28 >> 2];
      $11 = HEAP32[$0 - 32 >> 2];
      $12 = HEAP32[$0 - 36 >> 2];
      $13 = HEAP32[$0 - 40 >> 2];
      $14 = HEAP32[$0 - 44 >> 2];
      $17 = HEAP32[$0 - 48 >> 2];
      $29 = HEAP32[$2 >> 2];
      $30 = HEAP32[$2 + 4 >> 2];
      $27 = HEAP32[$2 + 8 >> 2];
      $28 = HEAP32[$2 + 12 >> 2];
      $25 = HEAP32[$2 + 16 >> 2];
      $26 = HEAP32[$2 + 20 >> 2];
      $23 = HEAP32[$2 + 24 >> 2];
      $24 = HEAP32[$2 + 28 >> 2];
      $21 = HEAP32[$2 + 32 >> 2];
      $22 = HEAP32[$2 + 36 >> 2];
      $19 = HEAP32[$2 + 40 >> 2];
      $20 = HEAP32[$2 + 44 >> 2];
      $2 = 0;
      while (1) {
       $15 = $14;
       $14 = $13;
       $13 = $12;
       $12 = $11;
       $11 = $10;
       $10 = $9;
       $9 = $8;
       $8 = $7;
       $7 = $6;
       $6 = $3;
       $3 = $16;
       $18 = $2 << 2;
       $16 = HEAP32[$18 + $0 >> 2];
       HEAP32[$5 + $18 >> 2] = $16 - (((((((((((Math_imul($15, $19) + Math_imul($17, $20) | 0) + Math_imul($14, $22) | 0) + Math_imul($13, $21) | 0) + Math_imul($12, $24) | 0) + Math_imul($11, $23) | 0) + Math_imul($10, $26) | 0) + Math_imul($9, $25) | 0) + Math_imul($8, $28) | 0) + Math_imul($7, $27) | 0) + Math_imul($6, $30) | 0) + Math_imul($3, $29) >> $4);
       $17 = $15;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($3 | 0) != 10) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $13 = HEAP32[$0 - 4 >> 2];
      $3 = HEAP32[$0 - 8 >> 2];
      $6 = HEAP32[$0 - 12 >> 2];
      $7 = HEAP32[$0 - 16 >> 2];
      $8 = HEAP32[$0 - 20 >> 2];
      $9 = HEAP32[$0 - 24 >> 2];
      $10 = HEAP32[$0 - 28 >> 2];
      $11 = HEAP32[$0 - 32 >> 2];
      $14 = HEAP32[$0 - 36 >> 2];
      $23 = HEAP32[$2 >> 2];
      $24 = HEAP32[$2 + 4 >> 2];
      $21 = HEAP32[$2 + 8 >> 2];
      $22 = HEAP32[$2 + 12 >> 2];
      $19 = HEAP32[$2 + 16 >> 2];
      $20 = HEAP32[$2 + 20 >> 2];
      $18 = HEAP32[$2 + 24 >> 2];
      $17 = HEAP32[$2 + 28 >> 2];
      $16 = HEAP32[$2 + 32 >> 2];
      $2 = 0;
      while (1) {
       $12 = $11;
       $11 = $10;
       $10 = $9;
       $9 = $8;
       $8 = $7;
       $7 = $6;
       $6 = $3;
       $3 = $13;
       $15 = $2 << 2;
       $13 = HEAP32[$15 + $0 >> 2];
       HEAP32[$5 + $15 >> 2] = $13 - ((((((((Math_imul($12, $17) + Math_imul($14, $16) | 0) + Math_imul($11, $18) | 0) + Math_imul($10, $20) | 0) + Math_imul($9, $19) | 0) + Math_imul($8, $22) | 0) + Math_imul($7, $21) | 0) + Math_imul($6, $24) | 0) + Math_imul($3, $23) >> $4);
       $14 = $12;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $14 = HEAP32[$0 - 4 >> 2];
     $3 = HEAP32[$0 - 8 >> 2];
     $6 = HEAP32[$0 - 12 >> 2];
     $7 = HEAP32[$0 - 16 >> 2];
     $8 = HEAP32[$0 - 20 >> 2];
     $9 = HEAP32[$0 - 24 >> 2];
     $10 = HEAP32[$0 - 28 >> 2];
     $11 = HEAP32[$0 - 32 >> 2];
     $12 = HEAP32[$0 - 36 >> 2];
     $15 = HEAP32[$0 - 40 >> 2];
     $25 = HEAP32[$2 >> 2];
     $26 = HEAP32[$2 + 4 >> 2];
     $23 = HEAP32[$2 + 8 >> 2];
     $24 = HEAP32[$2 + 12 >> 2];
     $21 = HEAP32[$2 + 16 >> 2];
     $22 = HEAP32[$2 + 20 >> 2];
     $19 = HEAP32[$2 + 24 >> 2];
     $20 = HEAP32[$2 + 28 >> 2];
     $18 = HEAP32[$2 + 32 >> 2];
     $17 = HEAP32[$2 + 36 >> 2];
     $2 = 0;
     while (1) {
      $13 = $12;
      $12 = $11;
      $11 = $10;
      $10 = $9;
      $9 = $8;
      $8 = $7;
      $7 = $6;
      $6 = $3;
      $3 = $14;
      $16 = $2 << 2;
      $14 = HEAP32[$16 + $0 >> 2];
      HEAP32[$5 + $16 >> 2] = $14 - (((((((((Math_imul($13, $18) + Math_imul($15, $17) | 0) + Math_imul($12, $20) | 0) + Math_imul($11, $19) | 0) + Math_imul($10, $22) | 0) + Math_imul($9, $21) | 0) + Math_imul($8, $24) | 0) + Math_imul($7, $23) | 0) + Math_imul($6, $26) | 0) + Math_imul($3, $25) >> $4);
      $15 = $13;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($3 >>> 0 >= 5) {
     if ($3 >>> 0 >= 7) {
      if (($3 | 0) != 8) {
       if (($1 | 0) < 1) {
        break label$1
       }
       $11 = HEAP32[$0 - 4 >> 2];
       $3 = HEAP32[$0 - 8 >> 2];
       $6 = HEAP32[$0 - 12 >> 2];
       $7 = HEAP32[$0 - 16 >> 2];
       $8 = HEAP32[$0 - 20 >> 2];
       $9 = HEAP32[$0 - 24 >> 2];
       $12 = HEAP32[$0 - 28 >> 2];
       $19 = HEAP32[$2 >> 2];
       $20 = HEAP32[$2 + 4 >> 2];
       $18 = HEAP32[$2 + 8 >> 2];
       $17 = HEAP32[$2 + 12 >> 2];
       $16 = HEAP32[$2 + 16 >> 2];
       $15 = HEAP32[$2 + 20 >> 2];
       $14 = HEAP32[$2 + 24 >> 2];
       $2 = 0;
       while (1) {
        $10 = $9;
        $9 = $8;
        $8 = $7;
        $7 = $6;
        $6 = $3;
        $3 = $11;
        $13 = $2 << 2;
        $11 = HEAP32[$13 + $0 >> 2];
        HEAP32[$5 + $13 >> 2] = $11 - ((((((Math_imul($10, $15) + Math_imul($12, $14) | 0) + Math_imul($9, $16) | 0) + Math_imul($8, $17) | 0) + Math_imul($7, $18) | 0) + Math_imul($6, $20) | 0) + Math_imul($3, $19) >> $4);
        $12 = $10;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       break label$1;
      }
      if (($1 | 0) < 1) {
       break label$1
      }
      $12 = HEAP32[$0 - 4 >> 2];
      $3 = HEAP32[$0 - 8 >> 2];
      $6 = HEAP32[$0 - 12 >> 2];
      $7 = HEAP32[$0 - 16 >> 2];
      $8 = HEAP32[$0 - 20 >> 2];
      $9 = HEAP32[$0 - 24 >> 2];
      $10 = HEAP32[$0 - 28 >> 2];
      $13 = HEAP32[$0 - 32 >> 2];
      $21 = HEAP32[$2 >> 2];
      $22 = HEAP32[$2 + 4 >> 2];
      $19 = HEAP32[$2 + 8 >> 2];
      $20 = HEAP32[$2 + 12 >> 2];
      $18 = HEAP32[$2 + 16 >> 2];
      $17 = HEAP32[$2 + 20 >> 2];
      $16 = HEAP32[$2 + 24 >> 2];
      $15 = HEAP32[$2 + 28 >> 2];
      $2 = 0;
      while (1) {
       $11 = $10;
       $10 = $9;
       $9 = $8;
       $8 = $7;
       $7 = $6;
       $6 = $3;
       $3 = $12;
       $14 = $2 << 2;
       $12 = HEAP32[$14 + $0 >> 2];
       HEAP32[$5 + $14 >> 2] = $12 - (((((((Math_imul($11, $16) + Math_imul($13, $15) | 0) + Math_imul($10, $17) | 0) + Math_imul($9, $18) | 0) + Math_imul($8, $20) | 0) + Math_imul($7, $19) | 0) + Math_imul($6, $22) | 0) + Math_imul($3, $21) >> $4);
       $13 = $11;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($3 | 0) != 6) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $9 = HEAP32[$0 - 4 >> 2];
      $3 = HEAP32[$0 - 8 >> 2];
      $6 = HEAP32[$0 - 12 >> 2];
      $7 = HEAP32[$0 - 16 >> 2];
      $10 = HEAP32[$0 - 20 >> 2];
      $16 = HEAP32[$2 >> 2];
      $15 = HEAP32[$2 + 4 >> 2];
      $14 = HEAP32[$2 + 8 >> 2];
      $13 = HEAP32[$2 + 12 >> 2];
      $12 = HEAP32[$2 + 16 >> 2];
      $2 = 0;
      while (1) {
       $8 = $7;
       $7 = $6;
       $6 = $3;
       $3 = $9;
       $11 = $2 << 2;
       $9 = HEAP32[$11 + $0 >> 2];
       HEAP32[$5 + $11 >> 2] = $9 - ((((Math_imul($8, $13) + Math_imul($10, $12) | 0) + Math_imul($7, $14) | 0) + Math_imul($6, $15) | 0) + Math_imul($3, $16) >> $4);
       $10 = $8;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $10 = HEAP32[$0 - 4 >> 2];
     $3 = HEAP32[$0 - 8 >> 2];
     $6 = HEAP32[$0 - 12 >> 2];
     $7 = HEAP32[$0 - 16 >> 2];
     $8 = HEAP32[$0 - 20 >> 2];
     $11 = HEAP32[$0 - 24 >> 2];
     $18 = HEAP32[$2 >> 2];
     $17 = HEAP32[$2 + 4 >> 2];
     $16 = HEAP32[$2 + 8 >> 2];
     $15 = HEAP32[$2 + 12 >> 2];
     $14 = HEAP32[$2 + 16 >> 2];
     $13 = HEAP32[$2 + 20 >> 2];
     $2 = 0;
     while (1) {
      $9 = $8;
      $8 = $7;
      $7 = $6;
      $6 = $3;
      $3 = $10;
      $12 = $2 << 2;
      $10 = HEAP32[$12 + $0 >> 2];
      HEAP32[$5 + $12 >> 2] = $10 - (((((Math_imul($9, $14) + Math_imul($11, $13) | 0) + Math_imul($8, $15) | 0) + Math_imul($7, $16) | 0) + Math_imul($6, $17) | 0) + Math_imul($3, $18) >> $4);
      $11 = $9;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($3 >>> 0 >= 3) {
     label$21 : {
      label$22 : {
       if (($3 | 0) != 4) {
        if (($1 | 0) < 1) {
         break label$1
        }
        $10 = $1 & 1;
        $8 = HEAP32[$0 - 4 >> 2];
        $6 = HEAP32[$0 - 8 >> 2];
        $9 = HEAP32[$0 - 12 >> 2];
        $14 = HEAP32[$2 >> 2];
        $12 = HEAP32[$2 + 4 >> 2];
        $11 = HEAP32[$2 + 8 >> 2];
        $3 = 0;
        if (($1 | 0) != 1) {
         break label$22
        }
        $2 = $6;
        $7 = $9;
        break label$21;
       }
       if (($1 | 0) < 1) {
        break label$1
       }
       $11 = $1 & 1;
       $9 = HEAP32[$0 - 4 >> 2];
       $6 = HEAP32[$0 - 8 >> 2];
       $7 = HEAP32[$0 - 12 >> 2];
       $10 = HEAP32[$0 - 16 >> 2];
       $16 = HEAP32[$2 >> 2];
       $14 = HEAP32[$2 + 4 >> 2];
       $13 = HEAP32[$2 + 8 >> 2];
       $12 = HEAP32[$2 + 12 >> 2];
       $2 = 0;
       label$24 : {
        if (($1 | 0) == 1) {
         $1 = $7;
         $3 = $10;
         break label$24;
        }
        $15 = $1 & -2;
        while (1) {
         $3 = $6;
         $8 = $2 << 2;
         $6 = HEAP32[$8 + $0 >> 2];
         $1 = $9;
         HEAP32[$5 + $8 >> 2] = $6 - (((Math_imul($7, $13) + Math_imul($10, $12) | 0) + Math_imul($3, $14) | 0) + Math_imul($16, $1) >> $4);
         $8 = $8 | 4;
         $9 = HEAP32[$8 + $0 >> 2];
         HEAP32[$5 + $8 >> 2] = $9 - (((Math_imul($3, $13) + Math_imul($7, $12) | 0) + Math_imul($1, $14) | 0) + Math_imul($6, $16) >> $4);
         $2 = $2 + 2 | 0;
         $7 = $1;
         $10 = $3;
         $15 = $15 - 2 | 0;
         if ($15) {
          continue
         }
         break;
        };
       }
       if (!$11) {
        break label$1
       }
       $2 = $2 << 2;
       HEAP32[$2 + $5 >> 2] = HEAP32[$0 + $2 >> 2] - (((Math_imul($1, $13) + Math_imul($3, $12) | 0) + Math_imul($6, $14) | 0) + Math_imul($9, $16) >> $4);
       return;
      }
      $13 = $1 & -2;
      while (1) {
       $1 = $3 << 2;
       $2 = HEAP32[$1 + $0 >> 2];
       $7 = $8;
       HEAP32[$1 + $5 >> 2] = $2 - ((Math_imul($6, $12) + Math_imul($9, $11) | 0) + Math_imul($14, $7) >> $4);
       $1 = $1 | 4;
       $8 = HEAP32[$1 + $0 >> 2];
       HEAP32[$1 + $5 >> 2] = $8 - ((Math_imul($7, $12) + Math_imul($6, $11) | 0) + Math_imul($2, $14) >> $4);
       $3 = $3 + 2 | 0;
       $6 = $2;
       $9 = $7;
       $13 = $13 - 2 | 0;
       if ($13) {
        continue
       }
       break;
      };
     }
     if (!$10) {
      break label$1
     }
     $1 = $3 << 2;
     HEAP32[$1 + $5 >> 2] = HEAP32[$0 + $1 >> 2] - ((Math_imul($2, $12) + Math_imul($7, $11) | 0) + Math_imul($8, $14) >> $4);
     return;
    }
    if (($3 | 0) != 2) {
     if (($1 | 0) < 1) {
      break label$1
     }
     $7 = $1 & 1;
     $6 = HEAP32[$0 - 4 >> 2];
     $8 = HEAP32[$2 >> 2];
     $3 = 0;
     if (($1 | 0) != 1) {
      $1 = $1 & -2;
      while (1) {
       $2 = $3 << 2;
       $9 = HEAP32[$2 + $0 >> 2];
       HEAP32[$2 + $5 >> 2] = $9 - (Math_imul($6, $8) >> $4);
       $2 = $2 | 4;
       $6 = HEAP32[$2 + $0 >> 2];
       HEAP32[$2 + $5 >> 2] = $6 - (Math_imul($9, $8) >> $4);
       $3 = $3 + 2 | 0;
       $1 = $1 - 2 | 0;
       if ($1) {
        continue
       }
       break;
      };
     }
     if (!$7) {
      break label$1
     }
     $1 = $3 << 2;
     HEAP32[$1 + $5 >> 2] = HEAP32[$0 + $1 >> 2] - (Math_imul($6, $8) >> $4);
     break label$1;
    }
    if (($1 | 0) < 1) {
     break label$1
    }
    $8 = $1 & 1;
    $6 = HEAP32[$0 - 4 >> 2];
    $7 = HEAP32[$0 - 8 >> 2];
    $12 = HEAP32[$2 >> 2];
    $11 = HEAP32[$2 + 4 >> 2];
    $3 = 0;
    if (($1 | 0) != 1) {
     $1 = $1 & -2;
     while (1) {
      $2 = Math_imul($7, $11);
      $10 = $3 << 2;
      $7 = HEAP32[$10 + $0 >> 2];
      HEAP32[$5 + $10 >> 2] = $7 - ($2 + Math_imul($6, $12) >> $4);
      $9 = Math_imul($6, $11);
      $2 = $10 | 4;
      $6 = HEAP32[$2 + $0 >> 2];
      HEAP32[$2 + $5 >> 2] = $6 - ($9 + Math_imul($7, $12) >> $4);
      $3 = $3 + 2 | 0;
      $1 = $1 - 2 | 0;
      if ($1) {
       continue
      }
      break;
     };
    }
    if (!$8) {
     break label$1
    }
    $1 = $3 << 2;
    HEAP32[$1 + $5 >> 2] = HEAP32[$0 + $1 >> 2] - (Math_imul($6, $12) + Math_imul($7, $11) >> $4);
    return;
   }
   while (1) {
    $3 = 0;
    label$34 : {
     switch ($9 | 0) {
     case 19:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 128 >> 2], HEAP32[$2 + 124 >> 2]);
     case 18:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 124 >> 2], HEAP32[$2 + 120 >> 2]) + $3 | 0;
     case 17:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 120 >> 2], HEAP32[$2 + 116 >> 2]) + $3 | 0;
     case 16:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 116 >> 2], HEAP32[$2 + 112 >> 2]) + $3 | 0;
     case 15:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 112 >> 2], HEAP32[$2 + 108 >> 2]) + $3 | 0;
     case 14:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 108 >> 2], HEAP32[$2 + 104 >> 2]) + $3 | 0;
     case 13:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 104 >> 2], HEAP32[$2 + 100 >> 2]) + $3 | 0;
     case 12:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 100 >> 2], HEAP32[$2 + 96 >> 2]) + $3 | 0;
     case 11:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 96 >> 2], HEAP32[$2 + 92 >> 2]) + $3 | 0;
     case 10:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 92 >> 2], HEAP32[$2 + 88 >> 2]) + $3 | 0;
     case 9:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 88 >> 2], HEAP32[$2 + 84 >> 2]) + $3 | 0;
     case 8:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 84 >> 2], HEAP32[$2 + 80 >> 2]) + $3 | 0;
     case 7:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 80 >> 2], HEAP32[$2 + 76 >> 2]) + $3 | 0;
     case 6:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 76 >> 2], HEAP32[$2 + 72 >> 2]) + $3 | 0;
     case 5:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 72 >> 2], HEAP32[$2 + 68 >> 2]) + $3 | 0;
     case 4:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 68 >> 2], HEAP32[$2 + 64 >> 2]) + $3 | 0;
     case 3:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) + -64 >> 2], HEAP32[$2 + 60 >> 2]) + $3 | 0;
     case 2:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 60 >> 2], HEAP32[$2 + 56 >> 2]) + $3 | 0;
     case 1:
      $3 = Math_imul(HEAP32[(($6 << 2) + $0 | 0) - 56 >> 2], HEAP32[$2 + 52 >> 2]) + $3 | 0;
     case 0:
      $7 = $3;
      $3 = ($6 << 2) + $0 | 0;
      $3 = (((((((((((($7 + Math_imul(HEAP32[$3 - 52 >> 2], HEAP32[$2 + 48 >> 2]) | 0) + Math_imul(HEAP32[$3 - 48 >> 2], HEAP32[$2 + 44 >> 2]) | 0) + Math_imul(HEAP32[$3 - 44 >> 2], HEAP32[$2 + 40 >> 2]) | 0) + Math_imul(HEAP32[$3 - 40 >> 2], HEAP32[$2 + 36 >> 2]) | 0) + Math_imul(HEAP32[$3 - 36 >> 2], HEAP32[$2 + 32 >> 2]) | 0) + Math_imul(HEAP32[$3 - 32 >> 2], HEAP32[$2 + 28 >> 2]) | 0) + Math_imul(HEAP32[$3 - 28 >> 2], HEAP32[$2 + 24 >> 2]) | 0) + Math_imul(HEAP32[$3 - 24 >> 2], HEAP32[$2 + 20 >> 2]) | 0) + Math_imul(HEAP32[$3 - 20 >> 2], HEAP32[$2 + 16 >> 2]) | 0) + Math_imul(HEAP32[$3 - 16 >> 2], HEAP32[$2 + 12 >> 2]) | 0) + Math_imul(HEAP32[$3 - 12 >> 2], HEAP32[$2 + 8 >> 2]) | 0) + Math_imul(HEAP32[$3 - 8 >> 2], HEAP32[$2 + 4 >> 2]) | 0) + Math_imul(HEAP32[$3 - 4 >> 2], HEAP32[$2 >> 2]) | 0;
      break;
     default:
      break label$34;
     };
    }
    $7 = $6 << 2;
    HEAP32[$7 + $5 >> 2] = HEAP32[$0 + $7 >> 2] - ($3 >> $4);
    $6 = $6 + 1 | 0;
    if (($6 | 0) != ($1 | 0)) {
     continue
    }
    break;
   };
  }
 }
 
 function FLAC__lpc_compute_residual_from_qlp_coefficients_wide($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
  label$1 : {
   label$2 : {
    if ($3 >>> 0 >= 13) {
     if (($1 | 0) <= 0) {
      break label$1
     }
     $13 = $4;
     $10 = $3 - 13 | 0;
     break label$2;
    }
    if ($3 >>> 0 >= 9) {
     if ($3 >>> 0 >= 11) {
      $26 = $4;
      if (($3 | 0) != 12) {
       if (($1 | 0) < 1) {
        break label$1
       }
       $11 = HEAP32[$0 - 4 >> 2];
       $12 = HEAP32[$0 - 8 >> 2];
       $3 = HEAP32[$0 - 12 >> 2];
       $4 = HEAP32[$0 - 16 >> 2];
       $13 = HEAP32[$0 - 20 >> 2];
       $7 = HEAP32[$0 - 24 >> 2];
       $8 = HEAP32[$0 - 28 >> 2];
       $10 = HEAP32[$0 - 32 >> 2];
       $9 = HEAP32[$0 - 36 >> 2];
       $14 = HEAP32[$0 - 40 >> 2];
       $15 = HEAP32[$0 - 44 >> 2];
       $6 = HEAP32[$2 >> 2];
       $19 = $6;
       $30 = $6 >> 31;
       $6 = HEAP32[$2 + 4 >> 2];
       $28 = $6;
       $29 = $6 >> 31;
       $6 = HEAP32[$2 + 8 >> 2];
       $33 = $6;
       $27 = $6 >> 31;
       $6 = HEAP32[$2 + 12 >> 2];
       $32 = $6;
       $31 = $6 >> 31;
       $6 = HEAP32[$2 + 16 >> 2];
       $25 = $6;
       $34 = $6 >> 31;
       $6 = HEAP32[$2 + 20 >> 2];
       $37 = $6;
       $24 = $6 >> 31;
       $6 = HEAP32[$2 + 24 >> 2];
       $36 = $6;
       $35 = $6 >> 31;
       $6 = HEAP32[$2 + 28 >> 2];
       $23 = $6;
       $38 = $6 >> 31;
       $6 = HEAP32[$2 + 32 >> 2];
       $41 = $6;
       $22 = $6 >> 31;
       $6 = HEAP32[$2 + 36 >> 2];
       $40 = $6;
       $39 = $6 >> 31;
       $2 = HEAP32[$2 + 40 >> 2];
       $21 = $2;
       $42 = $2 >> 31;
       $2 = 0;
       while (1) {
        $17 = $14;
        $14 = $9;
        $9 = $10;
        $10 = $8;
        $8 = $7;
        $7 = $13;
        $13 = $4;
        $4 = $3;
        $3 = $12;
        $12 = $11;
        $6 = $2 << 2;
        $16 = $6 + $5 | 0;
        $11 = HEAP32[$0 + $6 >> 2];
        $6 = __wasm_i64_mul($17, $17 >> 31, $40, $39);
        $20 = i64toi32_i32$HIGH_BITS;
        $18 = $16;
        $44 = __wasm_i64_mul($15, $15 >> 31, $21, $42);
        $15 = $44 + $6 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $20 | 0;
        $6 = $15 >>> 0 < $44 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($14, $14 >> 31, $41, $22);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($9, $9 >> 31, $23, $38);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($10, $10 >> 31, $36, $35);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($8, $8 >> 31, $37, $24);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($7, $7 >> 31, $25, $34);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($13, $13 >> 31, $32, $31);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($4, $4 >> 31, $33, $27);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($3, $3 >> 31, $28, $29);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = __wasm_i64_mul($12, $12 >> 31, $19, $30);
        $15 = $20 + $15 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $15 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $43 = $15;
        $15 = $26;
        $16 = $15 & 31;
        HEAP32[$18 >> 2] = $11 - (($15 & 63) >>> 0 >= 32 ? $6 >> $16 : ((1 << $16) - 1 & $6) << 32 - $16 | $43 >>> $16);
        $15 = $17;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       break label$1;
      }
      if (($1 | 0) < 1) {
       break label$1
      }
      $15 = HEAP32[$0 - 4 >> 2];
      $12 = HEAP32[$0 - 8 >> 2];
      $3 = HEAP32[$0 - 12 >> 2];
      $4 = HEAP32[$0 - 16 >> 2];
      $13 = HEAP32[$0 - 20 >> 2];
      $7 = HEAP32[$0 - 24 >> 2];
      $8 = HEAP32[$0 - 28 >> 2];
      $10 = HEAP32[$0 - 32 >> 2];
      $9 = HEAP32[$0 - 36 >> 2];
      $14 = HEAP32[$0 - 40 >> 2];
      $17 = HEAP32[$0 - 44 >> 2];
      $6 = HEAP32[$0 - 48 >> 2];
      $11 = HEAP32[$2 >> 2];
      $30 = $11;
      $28 = $11 >> 31;
      $11 = HEAP32[$2 + 4 >> 2];
      $29 = $11;
      $33 = $11 >> 31;
      $11 = HEAP32[$2 + 8 >> 2];
      $27 = $11;
      $32 = $11 >> 31;
      $11 = HEAP32[$2 + 12 >> 2];
      $31 = $11;
      $25 = $11 >> 31;
      $11 = HEAP32[$2 + 16 >> 2];
      $34 = $11;
      $37 = $11 >> 31;
      $11 = HEAP32[$2 + 20 >> 2];
      $24 = $11;
      $36 = $11 >> 31;
      $11 = HEAP32[$2 + 24 >> 2];
      $35 = $11;
      $23 = $11 >> 31;
      $11 = HEAP32[$2 + 28 >> 2];
      $38 = $11;
      $41 = $11 >> 31;
      $11 = HEAP32[$2 + 32 >> 2];
      $22 = $11;
      $40 = $11 >> 31;
      $11 = HEAP32[$2 + 36 >> 2];
      $39 = $11;
      $21 = $11 >> 31;
      $11 = HEAP32[$2 + 40 >> 2];
      $42 = $11;
      $43 = $11 >> 31;
      $2 = HEAP32[$2 + 44 >> 2];
      $20 = $2;
      $44 = $2 >> 31;
      $2 = 0;
      while (1) {
       $11 = $17;
       $17 = $14;
       $14 = $9;
       $9 = $10;
       $10 = $8;
       $8 = $7;
       $7 = $13;
       $13 = $4;
       $4 = $3;
       $3 = $12;
       $12 = $15;
       $15 = $2 << 2;
       $19 = $15 + $5 | 0;
       $15 = HEAP32[$0 + $15 >> 2];
       $16 = __wasm_i64_mul($11, $11 >> 31, $42, $43);
       $18 = i64toi32_i32$HIGH_BITS;
       $45 = $19;
       $19 = __wasm_i64_mul($6, $6 >> 31, $20, $44);
       $16 = $19 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $18 | 0;
       $6 = $16 >>> 0 < $19 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($17, $17 >> 31, $39, $21);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($14, $14 >> 31, $22, $40);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($9, $9 >> 31, $38, $41);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($10, $10 >> 31, $35, $23);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($8, $8 >> 31, $24, $36);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($7, $7 >> 31, $34, $37);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($13, $13 >> 31, $31, $25);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($4, $4 >> 31, $27, $32);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($3, $3 >> 31, $29, $33);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = __wasm_i64_mul($12, $12 >> 31, $30, $28);
       $16 = $18 + $16 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = $16;
       $16 = $26;
       $19 = $16 & 31;
       HEAP32[$45 >> 2] = $15 - (($16 & 63) >>> 0 >= 32 ? $6 >> $19 : ((1 << $19) - 1 & $6) << 32 - $19 | $18 >>> $19);
       $6 = $11;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     $26 = $4;
     if (($3 | 0) != 10) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $14 = HEAP32[$0 - 4 >> 2];
      $12 = HEAP32[$0 - 8 >> 2];
      $3 = HEAP32[$0 - 12 >> 2];
      $4 = HEAP32[$0 - 16 >> 2];
      $13 = HEAP32[$0 - 20 >> 2];
      $7 = HEAP32[$0 - 24 >> 2];
      $8 = HEAP32[$0 - 28 >> 2];
      $10 = HEAP32[$0 - 32 >> 2];
      $17 = HEAP32[$0 - 36 >> 2];
      $9 = HEAP32[$2 >> 2];
      $15 = $9;
      $16 = $9 >> 31;
      $9 = HEAP32[$2 + 4 >> 2];
      $19 = $9;
      $30 = $9 >> 31;
      $9 = HEAP32[$2 + 8 >> 2];
      $28 = $9;
      $29 = $9 >> 31;
      $9 = HEAP32[$2 + 12 >> 2];
      $33 = $9;
      $27 = $9 >> 31;
      $9 = HEAP32[$2 + 16 >> 2];
      $32 = $9;
      $31 = $9 >> 31;
      $9 = HEAP32[$2 + 20 >> 2];
      $25 = $9;
      $34 = $9 >> 31;
      $9 = HEAP32[$2 + 24 >> 2];
      $37 = $9;
      $24 = $9 >> 31;
      $9 = HEAP32[$2 + 28 >> 2];
      $36 = $9;
      $35 = $9 >> 31;
      $2 = HEAP32[$2 + 32 >> 2];
      $23 = $2;
      $38 = $2 >> 31;
      $2 = 0;
      while (1) {
       $9 = $10;
       $10 = $8;
       $8 = $7;
       $7 = $13;
       $13 = $4;
       $4 = $3;
       $3 = $12;
       $12 = $14;
       $6 = $2 << 2;
       $11 = $6 + $5 | 0;
       $14 = HEAP32[$0 + $6 >> 2];
       $6 = __wasm_i64_mul($9, $9 >> 31, $36, $35);
       $22 = i64toi32_i32$HIGH_BITS;
       $39 = $11;
       $40 = __wasm_i64_mul($17, $17 >> 31, $23, $38);
       $17 = $40 + $6 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $22 | 0;
       $6 = $17 >>> 0 < $40 >>> 0 ? $6 + 1 | 0 : $6;
       $22 = __wasm_i64_mul($10, $10 >> 31, $37, $24);
       $17 = $22 + $17 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $17 >>> 0 < $22 >>> 0 ? $6 + 1 | 0 : $6;
       $22 = __wasm_i64_mul($8, $8 >> 31, $25, $34);
       $17 = $22 + $17 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $17 >>> 0 < $22 >>> 0 ? $6 + 1 | 0 : $6;
       $22 = __wasm_i64_mul($7, $7 >> 31, $32, $31);
       $17 = $22 + $17 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $17 >>> 0 < $22 >>> 0 ? $6 + 1 | 0 : $6;
       $22 = __wasm_i64_mul($13, $13 >> 31, $33, $27);
       $17 = $22 + $17 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $17 >>> 0 < $22 >>> 0 ? $6 + 1 | 0 : $6;
       $22 = __wasm_i64_mul($4, $4 >> 31, $28, $29);
       $17 = $22 + $17 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $17 >>> 0 < $22 >>> 0 ? $6 + 1 | 0 : $6;
       $22 = __wasm_i64_mul($3, $3 >> 31, $19, $30);
       $17 = $22 + $17 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $17 >>> 0 < $22 >>> 0 ? $6 + 1 | 0 : $6;
       $22 = __wasm_i64_mul($12, $12 >> 31, $15, $16);
       $17 = $22 + $17 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $17 >>> 0 < $22 >>> 0 ? $6 + 1 | 0 : $6;
       $41 = $17;
       $17 = $26;
       $11 = $17 & 31;
       HEAP32[$39 >> 2] = $14 - (($17 & 63) >>> 0 >= 32 ? $6 >> $11 : ((1 << $11) - 1 & $6) << 32 - $11 | $41 >>> $11);
       $17 = $9;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $17 = HEAP32[$0 - 4 >> 2];
     $12 = HEAP32[$0 - 8 >> 2];
     $3 = HEAP32[$0 - 12 >> 2];
     $4 = HEAP32[$0 - 16 >> 2];
     $13 = HEAP32[$0 - 20 >> 2];
     $7 = HEAP32[$0 - 24 >> 2];
     $8 = HEAP32[$0 - 28 >> 2];
     $10 = HEAP32[$0 - 32 >> 2];
     $9 = HEAP32[$0 - 36 >> 2];
     $11 = HEAP32[$0 - 40 >> 2];
     $6 = HEAP32[$2 >> 2];
     $16 = $6;
     $19 = $6 >> 31;
     $6 = HEAP32[$2 + 4 >> 2];
     $30 = $6;
     $28 = $6 >> 31;
     $6 = HEAP32[$2 + 8 >> 2];
     $29 = $6;
     $33 = $6 >> 31;
     $6 = HEAP32[$2 + 12 >> 2];
     $27 = $6;
     $32 = $6 >> 31;
     $6 = HEAP32[$2 + 16 >> 2];
     $31 = $6;
     $25 = $6 >> 31;
     $6 = HEAP32[$2 + 20 >> 2];
     $34 = $6;
     $37 = $6 >> 31;
     $6 = HEAP32[$2 + 24 >> 2];
     $24 = $6;
     $36 = $6 >> 31;
     $6 = HEAP32[$2 + 28 >> 2];
     $35 = $6;
     $23 = $6 >> 31;
     $6 = HEAP32[$2 + 32 >> 2];
     $38 = $6;
     $41 = $6 >> 31;
     $2 = HEAP32[$2 + 36 >> 2];
     $22 = $2;
     $40 = $2 >> 31;
     $2 = 0;
     while (1) {
      $14 = $9;
      $9 = $10;
      $10 = $8;
      $8 = $7;
      $7 = $13;
      $13 = $4;
      $4 = $3;
      $3 = $12;
      $12 = $17;
      $6 = $2 << 2;
      $15 = $6 + $5 | 0;
      $17 = HEAP32[$0 + $6 >> 2];
      $6 = __wasm_i64_mul($14, $14 >> 31, $38, $41);
      $21 = i64toi32_i32$HIGH_BITS;
      $43 = $15;
      $42 = __wasm_i64_mul($11, $11 >> 31, $22, $40);
      $11 = $42 + $6 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $21 | 0;
      $6 = $11 >>> 0 < $42 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = __wasm_i64_mul($9, $9 >> 31, $35, $23);
      $11 = $21 + $11 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = __wasm_i64_mul($10, $10 >> 31, $24, $36);
      $11 = $21 + $11 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = __wasm_i64_mul($8, $8 >> 31, $34, $37);
      $11 = $21 + $11 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = __wasm_i64_mul($7, $7 >> 31, $31, $25);
      $11 = $21 + $11 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = __wasm_i64_mul($13, $13 >> 31, $27, $32);
      $11 = $21 + $11 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = __wasm_i64_mul($4, $4 >> 31, $29, $33);
      $11 = $21 + $11 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = __wasm_i64_mul($3, $3 >> 31, $30, $28);
      $11 = $21 + $11 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = __wasm_i64_mul($12, $12 >> 31, $16, $19);
      $11 = $21 + $11 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
      $39 = $11;
      $11 = $26;
      $15 = $11 & 31;
      HEAP32[$43 >> 2] = $17 - (($11 & 63) >>> 0 >= 32 ? $6 >> $15 : ((1 << $15) - 1 & $6) << 32 - $15 | $39 >>> $15);
      $11 = $14;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($3 >>> 0 >= 5) {
     if ($3 >>> 0 >= 7) {
      $17 = $4;
      if (($3 | 0) != 8) {
       if (($1 | 0) < 1) {
        break label$1
       }
       $10 = HEAP32[$0 - 4 >> 2];
       $12 = HEAP32[$0 - 8 >> 2];
       $3 = HEAP32[$0 - 12 >> 2];
       $4 = HEAP32[$0 - 16 >> 2];
       $13 = HEAP32[$0 - 20 >> 2];
       $7 = HEAP32[$0 - 24 >> 2];
       $9 = HEAP32[$0 - 28 >> 2];
       $8 = HEAP32[$2 >> 2];
       $26 = $8;
       $11 = $8 >> 31;
       $8 = HEAP32[$2 + 4 >> 2];
       $15 = $8;
       $16 = $8 >> 31;
       $8 = HEAP32[$2 + 8 >> 2];
       $19 = $8;
       $30 = $8 >> 31;
       $8 = HEAP32[$2 + 12 >> 2];
       $28 = $8;
       $29 = $8 >> 31;
       $8 = HEAP32[$2 + 16 >> 2];
       $33 = $8;
       $27 = $8 >> 31;
       $8 = HEAP32[$2 + 20 >> 2];
       $32 = $8;
       $31 = $8 >> 31;
       $2 = HEAP32[$2 + 24 >> 2];
       $25 = $2;
       $34 = $2 >> 31;
       $2 = 0;
       while (1) {
        $8 = $7;
        $7 = $13;
        $13 = $4;
        $4 = $3;
        $3 = $12;
        $12 = $10;
        $10 = $2 << 2;
        $14 = $10 + $5 | 0;
        $10 = HEAP32[$0 + $10 >> 2];
        $6 = __wasm_i64_mul($8, $8 >> 31, $32, $31);
        $24 = i64toi32_i32$HIGH_BITS;
        $35 = $14;
        $36 = __wasm_i64_mul($9, $9 >> 31, $25, $34);
        $9 = $36 + $6 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $24 | 0;
        $6 = $9 >>> 0 < $36 >>> 0 ? $6 + 1 | 0 : $6;
        $24 = __wasm_i64_mul($7, $7 >> 31, $33, $27);
        $9 = $24 + $9 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $9 >>> 0 < $24 >>> 0 ? $6 + 1 | 0 : $6;
        $24 = __wasm_i64_mul($13, $13 >> 31, $28, $29);
        $9 = $24 + $9 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $9 >>> 0 < $24 >>> 0 ? $6 + 1 | 0 : $6;
        $24 = __wasm_i64_mul($4, $4 >> 31, $19, $30);
        $9 = $24 + $9 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $9 >>> 0 < $24 >>> 0 ? $6 + 1 | 0 : $6;
        $24 = __wasm_i64_mul($3, $3 >> 31, $15, $16);
        $9 = $24 + $9 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $9 >>> 0 < $24 >>> 0 ? $6 + 1 | 0 : $6;
        $24 = __wasm_i64_mul($12, $12 >> 31, $26, $11);
        $9 = $24 + $9 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $9 >>> 0 < $24 >>> 0 ? $6 + 1 | 0 : $6;
        $37 = $9;
        $9 = $17;
        $14 = $9 & 31;
        HEAP32[$35 >> 2] = $10 - (($9 & 63) >>> 0 >= 32 ? $6 >> $14 : ((1 << $14) - 1 & $6) << 32 - $14 | $37 >>> $14);
        $9 = $8;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       break label$1;
      }
      if (($1 | 0) < 1) {
       break label$1
      }
      $9 = HEAP32[$0 - 4 >> 2];
      $12 = HEAP32[$0 - 8 >> 2];
      $3 = HEAP32[$0 - 12 >> 2];
      $4 = HEAP32[$0 - 16 >> 2];
      $13 = HEAP32[$0 - 20 >> 2];
      $7 = HEAP32[$0 - 24 >> 2];
      $8 = HEAP32[$0 - 28 >> 2];
      $14 = HEAP32[$0 - 32 >> 2];
      $10 = HEAP32[$2 >> 2];
      $11 = $10;
      $15 = $10 >> 31;
      $10 = HEAP32[$2 + 4 >> 2];
      $16 = $10;
      $19 = $10 >> 31;
      $10 = HEAP32[$2 + 8 >> 2];
      $30 = $10;
      $28 = $10 >> 31;
      $10 = HEAP32[$2 + 12 >> 2];
      $29 = $10;
      $33 = $10 >> 31;
      $10 = HEAP32[$2 + 16 >> 2];
      $27 = $10;
      $32 = $10 >> 31;
      $10 = HEAP32[$2 + 20 >> 2];
      $31 = $10;
      $25 = $10 >> 31;
      $10 = HEAP32[$2 + 24 >> 2];
      $34 = $10;
      $37 = $10 >> 31;
      $2 = HEAP32[$2 + 28 >> 2];
      $24 = $2;
      $36 = $2 >> 31;
      $2 = 0;
      while (1) {
       $10 = $8;
       $8 = $7;
       $7 = $13;
       $13 = $4;
       $4 = $3;
       $3 = $12;
       $12 = $9;
       $9 = $2 << 2;
       $26 = $9 + $5 | 0;
       $9 = HEAP32[$0 + $9 >> 2];
       $6 = __wasm_i64_mul($10, $10 >> 31, $34, $37);
       $23 = i64toi32_i32$HIGH_BITS;
       $39 = $26;
       $38 = __wasm_i64_mul($14, $14 >> 31, $24, $36);
       $14 = $38 + $6 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $23 | 0;
       $6 = $14 >>> 0 < $38 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = __wasm_i64_mul($8, $8 >> 31, $31, $25);
       $14 = $23 + $14 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $14 >>> 0 < $23 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = __wasm_i64_mul($7, $7 >> 31, $27, $32);
       $14 = $23 + $14 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $14 >>> 0 < $23 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = __wasm_i64_mul($13, $13 >> 31, $29, $33);
       $14 = $23 + $14 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $14 >>> 0 < $23 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = __wasm_i64_mul($4, $4 >> 31, $30, $28);
       $14 = $23 + $14 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $14 >>> 0 < $23 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = __wasm_i64_mul($3, $3 >> 31, $16, $19);
       $14 = $23 + $14 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $14 >>> 0 < $23 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = __wasm_i64_mul($12, $12 >> 31, $11, $15);
       $14 = $23 + $14 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $14 >>> 0 < $23 >>> 0 ? $6 + 1 | 0 : $6;
       $35 = $14;
       $14 = $17;
       $26 = $14 & 31;
       HEAP32[$39 >> 2] = $9 - (($14 & 63) >>> 0 >= 32 ? $6 >> $26 : ((1 << $26) - 1 & $6) << 32 - $26 | $35 >>> $26);
       $14 = $10;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     $9 = $4;
     if (($3 | 0) != 6) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $7 = HEAP32[$0 - 4 >> 2];
      $12 = HEAP32[$0 - 8 >> 2];
      $3 = HEAP32[$0 - 12 >> 2];
      $4 = HEAP32[$0 - 16 >> 2];
      $8 = HEAP32[$0 - 20 >> 2];
      $13 = HEAP32[$2 >> 2];
      $14 = $13;
      $17 = $13 >> 31;
      $13 = HEAP32[$2 + 4 >> 2];
      $26 = $13;
      $11 = $13 >> 31;
      $13 = HEAP32[$2 + 8 >> 2];
      $15 = $13;
      $16 = $13 >> 31;
      $13 = HEAP32[$2 + 12 >> 2];
      $19 = $13;
      $30 = $13 >> 31;
      $2 = HEAP32[$2 + 16 >> 2];
      $28 = $2;
      $29 = $2 >> 31;
      $2 = 0;
      while (1) {
       $13 = $4;
       $4 = $3;
       $3 = $12;
       $12 = $7;
       $7 = $2 << 2;
       $10 = $7 + $5 | 0;
       $7 = HEAP32[$0 + $7 >> 2];
       $6 = __wasm_i64_mul($13, $13 >> 31, $19, $30);
       $27 = i64toi32_i32$HIGH_BITS;
       $31 = $10;
       $32 = __wasm_i64_mul($8, $8 >> 31, $28, $29);
       $8 = $32 + $6 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $27 | 0;
       $6 = $8 >>> 0 < $32 >>> 0 ? $6 + 1 | 0 : $6;
       $27 = __wasm_i64_mul($4, $4 >> 31, $15, $16);
       $8 = $27 + $8 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $8 >>> 0 < $27 >>> 0 ? $6 + 1 | 0 : $6;
       $27 = __wasm_i64_mul($3, $3 >> 31, $26, $11);
       $8 = $27 + $8 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $8 >>> 0 < $27 >>> 0 ? $6 + 1 | 0 : $6;
       $27 = __wasm_i64_mul($12, $12 >> 31, $14, $17);
       $8 = $27 + $8 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $8 >>> 0 < $27 >>> 0 ? $6 + 1 | 0 : $6;
       $33 = $8;
       $8 = $9;
       $10 = $8 & 31;
       HEAP32[$31 >> 2] = $7 - (($8 & 63) >>> 0 >= 32 ? $6 >> $10 : ((1 << $10) - 1 & $6) << 32 - $10 | $33 >>> $10);
       $8 = $13;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $8 = HEAP32[$0 - 4 >> 2];
     $12 = HEAP32[$0 - 8 >> 2];
     $3 = HEAP32[$0 - 12 >> 2];
     $4 = HEAP32[$0 - 16 >> 2];
     $13 = HEAP32[$0 - 20 >> 2];
     $10 = HEAP32[$0 - 24 >> 2];
     $7 = HEAP32[$2 >> 2];
     $17 = $7;
     $26 = $7 >> 31;
     $7 = HEAP32[$2 + 4 >> 2];
     $11 = $7;
     $15 = $7 >> 31;
     $7 = HEAP32[$2 + 8 >> 2];
     $16 = $7;
     $19 = $7 >> 31;
     $7 = HEAP32[$2 + 12 >> 2];
     $30 = $7;
     $28 = $7 >> 31;
     $7 = HEAP32[$2 + 16 >> 2];
     $29 = $7;
     $33 = $7 >> 31;
     $2 = HEAP32[$2 + 20 >> 2];
     $27 = $2;
     $32 = $2 >> 31;
     $2 = 0;
     while (1) {
      $7 = $13;
      $13 = $4;
      $4 = $3;
      $3 = $12;
      $12 = $8;
      $8 = $2 << 2;
      $14 = $8 + $5 | 0;
      $8 = HEAP32[$0 + $8 >> 2];
      $6 = __wasm_i64_mul($7, $7 >> 31, $29, $33);
      $25 = i64toi32_i32$HIGH_BITS;
      $35 = $14;
      $34 = __wasm_i64_mul($10, $10 >> 31, $27, $32);
      $10 = $34 + $6 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $25 | 0;
      $6 = $10 >>> 0 < $34 >>> 0 ? $6 + 1 | 0 : $6;
      $25 = __wasm_i64_mul($13, $13 >> 31, $30, $28);
      $10 = $25 + $10 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $10 >>> 0 < $25 >>> 0 ? $6 + 1 | 0 : $6;
      $25 = __wasm_i64_mul($4, $4 >> 31, $16, $19);
      $10 = $25 + $10 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $10 >>> 0 < $25 >>> 0 ? $6 + 1 | 0 : $6;
      $25 = __wasm_i64_mul($3, $3 >> 31, $11, $15);
      $10 = $25 + $10 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $10 >>> 0 < $25 >>> 0 ? $6 + 1 | 0 : $6;
      $25 = __wasm_i64_mul($12, $12 >> 31, $17, $26);
      $10 = $25 + $10 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $10 >>> 0 < $25 >>> 0 ? $6 + 1 | 0 : $6;
      $31 = $10;
      $10 = $9;
      $14 = $10 & 31;
      HEAP32[$35 >> 2] = $8 - (($10 & 63) >>> 0 >= 32 ? $6 >> $14 : ((1 << $14) - 1 & $6) << 32 - $14 | $31 >>> $14);
      $10 = $7;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($3 >>> 0 >= 3) {
     $8 = $4;
     if (($3 | 0) != 4) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $4 = HEAP32[$0 - 4 >> 2];
      $12 = HEAP32[$0 - 8 >> 2];
      $13 = HEAP32[$0 - 12 >> 2];
      $3 = HEAP32[$2 >> 2];
      $10 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 4 >> 2];
      $14 = $3;
      $17 = $3 >> 31;
      $2 = HEAP32[$2 + 8 >> 2];
      $26 = $2;
      $11 = $2 >> 31;
      $2 = 0;
      while (1) {
       $3 = $12;
       $12 = $4;
       $4 = $2 << 2;
       $7 = $4 + $5 | 0;
       $4 = HEAP32[$0 + $4 >> 2];
       $6 = __wasm_i64_mul($3, $3 >> 31, $14, $17);
       $16 = i64toi32_i32$HIGH_BITS;
       $15 = $7;
       $19 = __wasm_i64_mul($13, $13 >> 31, $26, $11);
       $13 = $19 + $6 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $16 | 0;
       $6 = $13 >>> 0 < $19 >>> 0 ? $6 + 1 | 0 : $6;
       $16 = __wasm_i64_mul($12, $12 >> 31, $10, $9);
       $13 = $16 + $13 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $13 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
       $7 = $8 & 31;
       HEAP32[$15 >> 2] = $4 - (($8 & 63) >>> 0 >= 32 ? $6 >> $7 : ((1 << $7) - 1 & $6) << 32 - $7 | $13 >>> $7);
       $13 = $3;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $13 = HEAP32[$0 - 4 >> 2];
     $12 = HEAP32[$0 - 8 >> 2];
     $3 = HEAP32[$0 - 12 >> 2];
     $7 = HEAP32[$0 - 16 >> 2];
     $4 = HEAP32[$2 >> 2];
     $9 = $4;
     $14 = $4 >> 31;
     $4 = HEAP32[$2 + 4 >> 2];
     $17 = $4;
     $26 = $4 >> 31;
     $4 = HEAP32[$2 + 8 >> 2];
     $11 = $4;
     $15 = $4 >> 31;
     $2 = HEAP32[$2 + 12 >> 2];
     $16 = $2;
     $19 = $2 >> 31;
     $2 = 0;
     while (1) {
      $4 = $3;
      $3 = $12;
      $12 = $13;
      $13 = $2 << 2;
      $10 = $13 + $5 | 0;
      $13 = HEAP32[$0 + $13 >> 2];
      $6 = __wasm_i64_mul($4, $4 >> 31, $11, $15);
      $28 = i64toi32_i32$HIGH_BITS;
      $31 = $10;
      $29 = __wasm_i64_mul($7, $7 >> 31, $16, $19);
      $7 = $29 + $6 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $28 | 0;
      $6 = $7 >>> 0 < $29 >>> 0 ? $6 + 1 | 0 : $6;
      $28 = __wasm_i64_mul($3, $3 >> 31, $17, $26);
      $7 = $28 + $7 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $7 >>> 0 < $28 >>> 0 ? $6 + 1 | 0 : $6;
      $28 = __wasm_i64_mul($12, $12 >> 31, $9, $14);
      $7 = $28 + $7 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $7 >>> 0 < $28 >>> 0 ? $6 + 1 | 0 : $6;
      $30 = $7;
      $7 = $8;
      $10 = $7 & 31;
      HEAP32[$31 >> 2] = $13 - (($7 & 63) >>> 0 >= 32 ? $6 >> $10 : ((1 << $10) - 1 & $6) << 32 - $10 | $30 >>> $10);
      $7 = $4;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    $13 = $4;
    if (($3 | 0) != 2) {
     if (($1 | 0) < 1) {
      break label$1
     }
     $6 = $1 & 1;
     $3 = HEAP32[$0 - 4 >> 2];
     $2 = HEAP32[$2 >> 2];
     $7 = $2;
     $8 = $7 >> 31;
     $2 = 0;
     if (($1 | 0) != 1) {
      $1 = $1 & -2;
      while (1) {
       $12 = $2 << 2;
       $10 = HEAP32[$0 + $12 >> 2];
       $14 = __wasm_i64_mul($3, $3 >> 31, $7, $8);
       $9 = i64toi32_i32$HIGH_BITS;
       $3 = $13;
       $4 = $3 & 31;
       HEAP32[$12 + $5 >> 2] = $10 - (($3 & 63) >>> 0 >= 32 ? $9 >> $4 : ((1 << $4) - 1 & $9) << 32 - $4 | $14 >>> $4);
       $3 = $12 | 4;
       $11 = $3 + $5 | 0;
       $3 = HEAP32[$0 + $3 >> 2];
       $9 = __wasm_i64_mul($10, $10 >> 31, $7, $8);
       $10 = i64toi32_i32$HIGH_BITS;
       $4 = $13;
       $12 = $4 & 31;
       HEAP32[$11 >> 2] = $3 - (($4 & 63) >>> 0 >= 32 ? $10 >> $12 : ((1 << $12) - 1 & $10) << 32 - $12 | $9 >>> $12);
       $2 = $2 + 2 | 0;
       $1 = $1 - 2 | 0;
       if ($1) {
        continue
       }
       break;
      };
     }
     if (!$6) {
      break label$1
     }
     $1 = $2 << 2;
     $5 = $1 + $5 | 0;
     $4 = HEAP32[$0 + $1 >> 2];
     $2 = __wasm_i64_mul($3, $3 >> 31, $7, $8);
     $1 = i64toi32_i32$HIGH_BITS;
     $0 = $13 & 31;
     HEAP32[$5 >> 2] = $4 - (($13 & 63) >>> 0 >= 32 ? $1 >> $0 : ((1 << $0) - 1 & $1) << 32 - $0 | $2 >>> $0);
     break label$1;
    }
    if (($1 | 0) < 1) {
     break label$1
    }
    $26 = $1 & 1;
    $4 = HEAP32[$0 - 4 >> 2];
    $12 = HEAP32[$0 - 8 >> 2];
    $3 = HEAP32[$2 >> 2];
    $8 = $3;
    $10 = $3 >> 31;
    $2 = HEAP32[$2 + 4 >> 2];
    $9 = $2;
    $14 = $2 >> 31;
    $2 = 0;
    if (($1 | 0) != 1) {
     $1 = $1 & -2;
     while (1) {
      $6 = $12;
      $17 = $2 << 2;
      $11 = $17 + $5 | 0;
      $12 = HEAP32[$0 + $17 >> 2];
      $7 = $4;
      $16 = $7 >> 31;
      $4 = __wasm_i64_mul($7, $16, $8, $10);
      $19 = i64toi32_i32$HIGH_BITS;
      $15 = $11;
      $3 = $4;
      $4 = __wasm_i64_mul($6, $6 >> 31, $9, $14);
      $3 = $3 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $19 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $11 = $3;
      $3 = $13;
      $4 = $3 & 31;
      HEAP32[$15 >> 2] = $12 - (($3 & 63) >>> 0 >= 32 ? $6 >> $4 : ((1 << $4) - 1 & $6) << 32 - $4 | $11 >>> $4);
      $3 = $17 | 4;
      $17 = $3 + $5 | 0;
      $4 = HEAP32[$0 + $3 >> 2];
      $3 = __wasm_i64_mul($12, $12 >> 31, $8, $10);
      $6 = i64toi32_i32$HIGH_BITS;
      $11 = $17;
      $7 = __wasm_i64_mul($7, $16, $9, $14);
      $3 = $7 + $3 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $7 >>> 0 ? $6 + 1 | 0 : $6;
      $17 = $3;
      $3 = $13;
      $7 = $3 & 31;
      HEAP32[$11 >> 2] = $4 - (($3 & 63) >>> 0 >= 32 ? $6 >> $7 : ((1 << $7) - 1 & $6) << 32 - $7 | $17 >>> $7);
      $2 = $2 + 2 | 0;
      $1 = $1 - 2 | 0;
      if ($1) {
       continue
      }
      break;
     };
    }
    if (!$26) {
     break label$1
    }
    $1 = $2 << 2;
    $2 = $1 + $5 | 0;
    $1 = HEAP32[$0 + $1 >> 2];
    $0 = __wasm_i64_mul($4, $4 >> 31, $8, $10);
    $3 = i64toi32_i32$HIGH_BITS;
    $5 = $1;
    $4 = __wasm_i64_mul($12, $12 >> 31, $9, $14);
    $0 = $4 + $0 | 0;
    $6 = i64toi32_i32$HIGH_BITS + $3 | 0;
    $6 = $0 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
    $1 = $0;
    $0 = $13 & 31;
    HEAP32[$2 >> 2] = $5 - (($13 & 63) >>> 0 >= 32 ? $6 >> $0 : ((1 << $0) - 1 & $6) << 32 - $0 | $1 >>> $0);
    return;
   }
   while (1) {
    $4 = 0;
    $3 = 0;
    label$30 : {
     switch ($10 | 0) {
     case 19:
      $3 = HEAP32[(($12 << 2) + $0 | 0) - 128 >> 2];
      $4 = $3;
      $7 = $3 >> 31;
      $3 = HEAP32[$2 + 124 >> 2];
      $4 = __wasm_i64_mul($4, $7, $3, $3 >> 31);
      $3 = i64toi32_i32$HIGH_BITS;
     case 18:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 124 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 120 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 17:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 120 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 116 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 16:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 116 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 112 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 15:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 112 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 108 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 14:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 108 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 104 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 13:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 104 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 100 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 12:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 100 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 96 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 11:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 96 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 92 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 10:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 92 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 88 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 9:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 88 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 84 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 8:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 84 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 80 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 7:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 80 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 76 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 6:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 76 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 72 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 5:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 72 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 68 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 4:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 68 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 64 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 3:
      $7 = HEAP32[(($12 << 2) + $0 | 0) + -64 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 60 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 2:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 60 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 56 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 1:
      $7 = HEAP32[(($12 << 2) + $0 | 0) - 56 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 52 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 0:
      $7 = ($12 << 2) + $0 | 0;
      $8 = HEAP32[$7 - 52 >> 2];
      $6 = $8;
      $9 = $8 >> 31;
      $8 = HEAP32[$2 + 48 >> 2];
      $8 = __wasm_i64_mul($6, $9, $8, $8 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $8 >>> 0 ? $6 + 1 | 0 : $6;
      $3 = HEAP32[$7 - 48 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 44 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $4 + $8 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 44 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 40 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 40 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 36 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 36 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 32 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 32 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 28 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 28 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 24 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 24 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 20 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 20 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 16 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 16 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 12 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 12 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 8 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 8 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 4 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 4 >> 2];
      $4 = $3;
      $7 = $3 >> 31;
      $3 = HEAP32[$2 >> 2];
      $4 = __wasm_i64_mul($4, $7, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $3;
      $3 = $6;
      break;
     default:
      break label$30;
     };
    }
    $7 = $12 << 2;
    $9 = $7 + $5 | 0;
    $6 = HEAP32[$0 + $7 >> 2];
    $8 = $4;
    $4 = $13;
    $7 = $4 & 31;
    HEAP32[$9 >> 2] = $6 - (($4 & 63) >>> 0 >= 32 ? $3 >> $7 : ((1 << $7) - 1 & $3) << 32 - $7 | $8 >>> $7);
    $12 = $12 + 1 | 0;
    if (($12 | 0) != ($1 | 0)) {
     continue
    }
    break;
   };
  }
 }
 
 function FLAC__lpc_restore_signal($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
  label$1 : {
   label$2 : {
    if ($3 >>> 0 >= 13) {
     if (($1 | 0) <= 0) {
      break label$1
     }
     $8 = $3 - 13 | 0;
     break label$2;
    }
    if ($3 >>> 0 >= 9) {
     if ($3 >>> 0 >= 11) {
      if (($3 | 0) != 12) {
       if (($1 | 0) < 1) {
        break label$1
       }
       $6 = HEAP32[$5 - 4 >> 2];
       $8 = HEAP32[$5 - 8 >> 2];
       $14 = HEAP32[$5 - 12 >> 2];
       $7 = HEAP32[$5 - 16 >> 2];
       $12 = HEAP32[$5 - 20 >> 2];
       $9 = HEAP32[$5 - 24 >> 2];
       $10 = HEAP32[$5 - 28 >> 2];
       $11 = HEAP32[$5 - 32 >> 2];
       $15 = HEAP32[$5 - 36 >> 2];
       $13 = HEAP32[$5 - 40 >> 2];
       $17 = HEAP32[$5 - 44 >> 2];
       $16 = HEAP32[$2 >> 2];
       $18 = HEAP32[$2 + 4 >> 2];
       $19 = HEAP32[$2 + 8 >> 2];
       $20 = HEAP32[$2 + 12 >> 2];
       $21 = HEAP32[$2 + 16 >> 2];
       $22 = HEAP32[$2 + 20 >> 2];
       $23 = HEAP32[$2 + 24 >> 2];
       $24 = HEAP32[$2 + 28 >> 2];
       $25 = HEAP32[$2 + 32 >> 2];
       $26 = HEAP32[$2 + 36 >> 2];
       $27 = HEAP32[$2 + 40 >> 2];
       $3 = 0;
       while (1) {
        $2 = $13;
        $17 = Math_imul($26, $2) + Math_imul($17, $27) | 0;
        $13 = $15;
        $17 = Math_imul($13, $25) + $17 | 0;
        $15 = $11;
        $17 = Math_imul($11, $24) + $17 | 0;
        $11 = $10;
        $17 = Math_imul($10, $23) + $17 | 0;
        $10 = $9;
        $17 = Math_imul($9, $22) + $17 | 0;
        $9 = $12;
        $12 = $7;
        $17 = (Math_imul($9, $21) + $17 | 0) + Math_imul($7, $20) | 0;
        $7 = $14;
        $17 = $17 + Math_imul($19, $7) | 0;
        $14 = $8;
        $17 = Math_imul($8, $18) + $17 | 0;
        $8 = $6;
        $6 = Math_imul($6, $16) + $17 >> $4;
        $17 = $3 << 2;
        $6 = $6 + HEAP32[$17 + $0 >> 2] | 0;
        HEAP32[$5 + $17 >> 2] = $6;
        $17 = $2;
        $3 = $3 + 1 | 0;
        if (($3 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       break label$1;
      }
      if (($1 | 0) < 1) {
       break label$1
      }
      $6 = HEAP32[$5 - 4 >> 2];
      $8 = HEAP32[$5 - 8 >> 2];
      $14 = HEAP32[$5 - 12 >> 2];
      $7 = HEAP32[$5 - 16 >> 2];
      $12 = HEAP32[$5 - 20 >> 2];
      $9 = HEAP32[$5 - 24 >> 2];
      $10 = HEAP32[$5 - 28 >> 2];
      $11 = HEAP32[$5 - 32 >> 2];
      $15 = HEAP32[$5 - 36 >> 2];
      $13 = HEAP32[$5 - 40 >> 2];
      $17 = HEAP32[$5 - 44 >> 2];
      $16 = HEAP32[$5 - 48 >> 2];
      $18 = HEAP32[$2 >> 2];
      $19 = HEAP32[$2 + 4 >> 2];
      $20 = HEAP32[$2 + 8 >> 2];
      $21 = HEAP32[$2 + 12 >> 2];
      $22 = HEAP32[$2 + 16 >> 2];
      $23 = HEAP32[$2 + 20 >> 2];
      $24 = HEAP32[$2 + 24 >> 2];
      $25 = HEAP32[$2 + 28 >> 2];
      $26 = HEAP32[$2 + 32 >> 2];
      $27 = HEAP32[$2 + 36 >> 2];
      $28 = HEAP32[$2 + 40 >> 2];
      $29 = HEAP32[$2 + 44 >> 2];
      $3 = 0;
      while (1) {
       $2 = $17;
       $16 = Math_imul($28, $2) + Math_imul($16, $29) | 0;
       $17 = $13;
       $16 = Math_imul($13, $27) + $16 | 0;
       $13 = $15;
       $16 = Math_imul($13, $26) + $16 | 0;
       $15 = $11;
       $16 = Math_imul($11, $25) + $16 | 0;
       $11 = $10;
       $16 = Math_imul($10, $24) + $16 | 0;
       $10 = $9;
       $16 = Math_imul($9, $23) + $16 | 0;
       $9 = $12;
       $12 = $7;
       $16 = (Math_imul($9, $22) + $16 | 0) + Math_imul($7, $21) | 0;
       $7 = $14;
       $16 = $16 + Math_imul($20, $7) | 0;
       $14 = $8;
       $16 = Math_imul($8, $19) + $16 | 0;
       $8 = $6;
       $6 = Math_imul($6, $18) + $16 >> $4;
       $16 = $3 << 2;
       $6 = $6 + HEAP32[$16 + $0 >> 2] | 0;
       HEAP32[$5 + $16 >> 2] = $6;
       $16 = $2;
       $3 = $3 + 1 | 0;
       if (($3 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($3 | 0) != 10) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $6 = HEAP32[$5 - 4 >> 2];
      $8 = HEAP32[$5 - 8 >> 2];
      $14 = HEAP32[$5 - 12 >> 2];
      $7 = HEAP32[$5 - 16 >> 2];
      $12 = HEAP32[$5 - 20 >> 2];
      $9 = HEAP32[$5 - 24 >> 2];
      $10 = HEAP32[$5 - 28 >> 2];
      $11 = HEAP32[$5 - 32 >> 2];
      $15 = HEAP32[$5 - 36 >> 2];
      $13 = HEAP32[$2 >> 2];
      $17 = HEAP32[$2 + 4 >> 2];
      $16 = HEAP32[$2 + 8 >> 2];
      $18 = HEAP32[$2 + 12 >> 2];
      $19 = HEAP32[$2 + 16 >> 2];
      $20 = HEAP32[$2 + 20 >> 2];
      $21 = HEAP32[$2 + 24 >> 2];
      $22 = HEAP32[$2 + 28 >> 2];
      $23 = HEAP32[$2 + 32 >> 2];
      $3 = 0;
      while (1) {
       $2 = $11;
       $15 = Math_imul($22, $2) + Math_imul($15, $23) | 0;
       $11 = $10;
       $15 = Math_imul($10, $21) + $15 | 0;
       $10 = $9;
       $15 = Math_imul($9, $20) + $15 | 0;
       $9 = $12;
       $12 = $7;
       $15 = (Math_imul($9, $19) + $15 | 0) + Math_imul($7, $18) | 0;
       $7 = $14;
       $15 = $15 + Math_imul($16, $7) | 0;
       $14 = $8;
       $15 = Math_imul($8, $17) + $15 | 0;
       $8 = $6;
       $6 = Math_imul($6, $13) + $15 >> $4;
       $15 = $3 << 2;
       $6 = $6 + HEAP32[$15 + $0 >> 2] | 0;
       HEAP32[$5 + $15 >> 2] = $6;
       $15 = $2;
       $3 = $3 + 1 | 0;
       if (($3 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $6 = HEAP32[$5 - 4 >> 2];
     $8 = HEAP32[$5 - 8 >> 2];
     $14 = HEAP32[$5 - 12 >> 2];
     $7 = HEAP32[$5 - 16 >> 2];
     $12 = HEAP32[$5 - 20 >> 2];
     $9 = HEAP32[$5 - 24 >> 2];
     $10 = HEAP32[$5 - 28 >> 2];
     $11 = HEAP32[$5 - 32 >> 2];
     $15 = HEAP32[$5 - 36 >> 2];
     $13 = HEAP32[$5 - 40 >> 2];
     $17 = HEAP32[$2 >> 2];
     $16 = HEAP32[$2 + 4 >> 2];
     $18 = HEAP32[$2 + 8 >> 2];
     $19 = HEAP32[$2 + 12 >> 2];
     $20 = HEAP32[$2 + 16 >> 2];
     $21 = HEAP32[$2 + 20 >> 2];
     $22 = HEAP32[$2 + 24 >> 2];
     $23 = HEAP32[$2 + 28 >> 2];
     $24 = HEAP32[$2 + 32 >> 2];
     $25 = HEAP32[$2 + 36 >> 2];
     $3 = 0;
     while (1) {
      $2 = $15;
      $13 = Math_imul($24, $2) + Math_imul($13, $25) | 0;
      $15 = $11;
      $13 = Math_imul($11, $23) + $13 | 0;
      $11 = $10;
      $13 = Math_imul($10, $22) + $13 | 0;
      $10 = $9;
      $13 = Math_imul($9, $21) + $13 | 0;
      $9 = $12;
      $12 = $7;
      $13 = (Math_imul($9, $20) + $13 | 0) + Math_imul($7, $19) | 0;
      $7 = $14;
      $13 = $13 + Math_imul($18, $7) | 0;
      $14 = $8;
      $13 = Math_imul($8, $16) + $13 | 0;
      $8 = $6;
      $6 = Math_imul($6, $17) + $13 >> $4;
      $13 = $3 << 2;
      $6 = $6 + HEAP32[$13 + $0 >> 2] | 0;
      HEAP32[$5 + $13 >> 2] = $6;
      $13 = $2;
      $3 = $3 + 1 | 0;
      if (($3 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($3 >>> 0 >= 5) {
     if ($3 >>> 0 >= 7) {
      if (($3 | 0) != 8) {
       if (($1 | 0) < 1) {
        break label$1
       }
       $6 = HEAP32[$5 - 4 >> 2];
       $8 = HEAP32[$5 - 8 >> 2];
       $14 = HEAP32[$5 - 12 >> 2];
       $7 = HEAP32[$5 - 16 >> 2];
       $12 = HEAP32[$5 - 20 >> 2];
       $9 = HEAP32[$5 - 24 >> 2];
       $10 = HEAP32[$5 - 28 >> 2];
       $11 = HEAP32[$2 >> 2];
       $15 = HEAP32[$2 + 4 >> 2];
       $13 = HEAP32[$2 + 8 >> 2];
       $17 = HEAP32[$2 + 12 >> 2];
       $16 = HEAP32[$2 + 16 >> 2];
       $18 = HEAP32[$2 + 20 >> 2];
       $19 = HEAP32[$2 + 24 >> 2];
       $3 = 0;
       while (1) {
        $2 = $9;
        $10 = Math_imul($18, $2) + Math_imul($10, $19) | 0;
        $9 = $12;
        $12 = $7;
        $10 = (Math_imul($9, $16) + $10 | 0) + Math_imul($7, $17) | 0;
        $7 = $14;
        $10 = $10 + Math_imul($13, $7) | 0;
        $14 = $8;
        $10 = Math_imul($8, $15) + $10 | 0;
        $8 = $6;
        $6 = Math_imul($6, $11) + $10 >> $4;
        $10 = $3 << 2;
        $6 = $6 + HEAP32[$10 + $0 >> 2] | 0;
        HEAP32[$5 + $10 >> 2] = $6;
        $10 = $2;
        $3 = $3 + 1 | 0;
        if (($3 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       break label$1;
      }
      if (($1 | 0) < 1) {
       break label$1
      }
      $6 = HEAP32[$5 - 4 >> 2];
      $8 = HEAP32[$5 - 8 >> 2];
      $14 = HEAP32[$5 - 12 >> 2];
      $7 = HEAP32[$5 - 16 >> 2];
      $12 = HEAP32[$5 - 20 >> 2];
      $9 = HEAP32[$5 - 24 >> 2];
      $10 = HEAP32[$5 - 28 >> 2];
      $11 = HEAP32[$5 - 32 >> 2];
      $15 = HEAP32[$2 >> 2];
      $13 = HEAP32[$2 + 4 >> 2];
      $17 = HEAP32[$2 + 8 >> 2];
      $16 = HEAP32[$2 + 12 >> 2];
      $18 = HEAP32[$2 + 16 >> 2];
      $19 = HEAP32[$2 + 20 >> 2];
      $20 = HEAP32[$2 + 24 >> 2];
      $21 = HEAP32[$2 + 28 >> 2];
      $3 = 0;
      while (1) {
       $2 = $10;
       $11 = Math_imul($20, $2) + Math_imul($11, $21) | 0;
       $10 = $9;
       $11 = Math_imul($9, $19) + $11 | 0;
       $9 = $12;
       $12 = $7;
       $11 = (Math_imul($9, $18) + $11 | 0) + Math_imul($7, $16) | 0;
       $7 = $14;
       $11 = $11 + Math_imul($17, $7) | 0;
       $14 = $8;
       $11 = Math_imul($8, $13) + $11 | 0;
       $8 = $6;
       $6 = Math_imul($6, $15) + $11 >> $4;
       $11 = $3 << 2;
       $6 = $6 + HEAP32[$11 + $0 >> 2] | 0;
       HEAP32[$5 + $11 >> 2] = $6;
       $11 = $2;
       $3 = $3 + 1 | 0;
       if (($3 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($3 | 0) != 6) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $6 = HEAP32[$5 - 4 >> 2];
      $8 = HEAP32[$5 - 8 >> 2];
      $14 = HEAP32[$5 - 12 >> 2];
      $7 = HEAP32[$5 - 16 >> 2];
      $12 = HEAP32[$5 - 20 >> 2];
      $9 = HEAP32[$2 >> 2];
      $10 = HEAP32[$2 + 4 >> 2];
      $11 = HEAP32[$2 + 8 >> 2];
      $15 = HEAP32[$2 + 12 >> 2];
      $13 = HEAP32[$2 + 16 >> 2];
      $3 = 0;
      while (1) {
       $2 = $7;
       $7 = $14;
       $12 = (Math_imul($2, $15) + Math_imul($12, $13) | 0) + Math_imul($11, $7) | 0;
       $14 = $8;
       $12 = Math_imul($8, $10) + $12 | 0;
       $8 = $6;
       $6 = Math_imul($6, $9) + $12 >> $4;
       $12 = $3 << 2;
       $6 = $6 + HEAP32[$12 + $0 >> 2] | 0;
       HEAP32[$5 + $12 >> 2] = $6;
       $12 = $2;
       $3 = $3 + 1 | 0;
       if (($3 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $6 = HEAP32[$5 - 4 >> 2];
     $8 = HEAP32[$5 - 8 >> 2];
     $14 = HEAP32[$5 - 12 >> 2];
     $7 = HEAP32[$5 - 16 >> 2];
     $12 = HEAP32[$5 - 20 >> 2];
     $9 = HEAP32[$5 - 24 >> 2];
     $10 = HEAP32[$2 >> 2];
     $11 = HEAP32[$2 + 4 >> 2];
     $15 = HEAP32[$2 + 8 >> 2];
     $13 = HEAP32[$2 + 12 >> 2];
     $17 = HEAP32[$2 + 16 >> 2];
     $16 = HEAP32[$2 + 20 >> 2];
     $3 = 0;
     while (1) {
      $2 = $12;
      $12 = $7;
      $9 = (Math_imul($2, $17) + Math_imul($9, $16) | 0) + Math_imul($7, $13) | 0;
      $7 = $14;
      $9 = $9 + Math_imul($15, $7) | 0;
      $14 = $8;
      $9 = Math_imul($8, $11) + $9 | 0;
      $8 = $6;
      $6 = Math_imul($6, $10) + $9 >> $4;
      $9 = $3 << 2;
      $6 = $6 + HEAP32[$9 + $0 >> 2] | 0;
      HEAP32[$5 + $9 >> 2] = $6;
      $9 = $2;
      $3 = $3 + 1 | 0;
      if (($3 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($3 >>> 0 >= 3) {
     label$21 : {
      label$22 : {
       if (($3 | 0) != 4) {
        if (($1 | 0) < 1) {
         break label$1
        }
        $15 = $1 & 1;
        $14 = HEAP32[$5 - 4 >> 2];
        $6 = HEAP32[$5 - 8 >> 2];
        $7 = HEAP32[$5 - 12 >> 2];
        $12 = HEAP32[$2 >> 2];
        $9 = HEAP32[$2 + 4 >> 2];
        $10 = HEAP32[$2 + 8 >> 2];
        $3 = 0;
        if (($1 | 0) != 1) {
         break label$22
        }
        $2 = $6;
        $8 = $7;
        break label$21;
       }
       if (($1 | 0) < 1) {
        break label$1
       }
       $15 = $1 & 1;
       $7 = HEAP32[$5 - 4 >> 2];
       $6 = HEAP32[$5 - 8 >> 2];
       $8 = HEAP32[$5 - 12 >> 2];
       $12 = HEAP32[$5 - 16 >> 2];
       $14 = HEAP32[$2 >> 2];
       $9 = HEAP32[$2 + 4 >> 2];
       $10 = HEAP32[$2 + 8 >> 2];
       $11 = HEAP32[$2 + 12 >> 2];
       $3 = 0;
       label$24 : {
        if (($1 | 0) == 1) {
         $2 = $8;
         $1 = $12;
         break label$24;
        }
        $13 = $1 & -2;
        while (1) {
         $1 = $6;
         $2 = $7;
         $7 = $3 << 2;
         $6 = (((Math_imul($8, $10) + Math_imul($11, $12) | 0) + Math_imul($6, $9) | 0) + Math_imul($14, $2) >> $4) + HEAP32[$7 + $0 >> 2] | 0;
         HEAP32[$5 + $7 >> 2] = $6;
         $12 = ((Math_imul($1, $10) + Math_imul($8, $11) | 0) + Math_imul($2, $9) | 0) + Math_imul($6, $14) >> $4;
         $8 = $7 | 4;
         $7 = $12 + HEAP32[$8 + $0 >> 2] | 0;
         HEAP32[$5 + $8 >> 2] = $7;
         $3 = $3 + 2 | 0;
         $8 = $2;
         $12 = $1;
         $13 = $13 - 2 | 0;
         if ($13) {
          continue
         }
         break;
        };
       }
       if (!$15) {
        break label$1
       }
       $3 = $3 << 2;
       HEAP32[$3 + $5 >> 2] = HEAP32[$0 + $3 >> 2] + (((Math_imul($2, $10) + Math_imul($1, $11) | 0) + Math_imul($6, $9) | 0) + Math_imul($7, $14) >> $4);
       return;
      }
      $11 = $1 & -2;
      while (1) {
       $1 = $3 << 2;
       $8 = $14;
       $2 = HEAP32[$1 + $0 >> 2] + ((Math_imul($6, $9) + Math_imul($7, $10) | 0) + Math_imul($12, $8) >> $4) | 0;
       HEAP32[$1 + $5 >> 2] = $2;
       $1 = $1 | 4;
       $14 = HEAP32[$1 + $0 >> 2] + ((Math_imul($8, $9) + Math_imul($6, $10) | 0) + Math_imul($2, $12) >> $4) | 0;
       HEAP32[$1 + $5 >> 2] = $14;
       $3 = $3 + 2 | 0;
       $6 = $2;
       $7 = $8;
       $11 = $11 - 2 | 0;
       if ($11) {
        continue
       }
       break;
      };
     }
     if (!$15) {
      break label$1
     }
     $1 = $3 << 2;
     HEAP32[$1 + $5 >> 2] = HEAP32[$0 + $1 >> 2] + ((Math_imul($2, $9) + Math_imul($8, $10) | 0) + Math_imul($14, $12) >> $4);
     return;
    }
    if (($3 | 0) != 2) {
     if (($1 | 0) < 1) {
      break label$1
     }
     $14 = $1 & 1;
     $6 = HEAP32[$5 - 4 >> 2];
     $2 = HEAP32[$2 >> 2];
     $3 = 0;
     if (($1 | 0) != 1) {
      $1 = $1 & -2;
      while (1) {
       $8 = $3 << 2;
       $7 = HEAP32[$8 + $0 >> 2] + (Math_imul($2, $6) >> $4) | 0;
       HEAP32[$5 + $8 >> 2] = $7;
       $8 = $8 | 4;
       $6 = HEAP32[$8 + $0 >> 2] + (Math_imul($2, $7) >> $4) | 0;
       HEAP32[$5 + $8 >> 2] = $6;
       $3 = $3 + 2 | 0;
       $1 = $1 - 2 | 0;
       if ($1) {
        continue
       }
       break;
      };
     }
     if (!$14) {
      break label$1
     }
     $1 = $3 << 2;
     HEAP32[$1 + $5 >> 2] = HEAP32[$0 + $1 >> 2] + (Math_imul($2, $6) >> $4);
     break label$1;
    }
    if (($1 | 0) < 1) {
     break label$1
    }
    $12 = $1 & 1;
    $6 = HEAP32[$5 - 4 >> 2];
    $8 = HEAP32[$5 - 8 >> 2];
    $7 = HEAP32[$2 >> 2];
    $2 = HEAP32[$2 + 4 >> 2];
    $3 = 0;
    if (($1 | 0) != 1) {
     $1 = $1 & -2;
     while (1) {
      $14 = $3 << 2;
      $8 = HEAP32[$14 + $0 >> 2] + (Math_imul($6, $7) + Math_imul($2, $8) >> $4) | 0;
      HEAP32[$5 + $14 >> 2] = $8;
      $14 = $14 | 4;
      $6 = HEAP32[$14 + $0 >> 2] + (Math_imul($8, $7) + Math_imul($2, $6) >> $4) | 0;
      HEAP32[$5 + $14 >> 2] = $6;
      $3 = $3 + 2 | 0;
      $1 = $1 - 2 | 0;
      if ($1) {
       continue
      }
      break;
     };
    }
    if (!$12) {
     break label$1
    }
    $1 = $3 << 2;
    HEAP32[$1 + $5 >> 2] = HEAP32[$0 + $1 >> 2] + (Math_imul($6, $7) + Math_imul($2, $8) >> $4);
    return;
   }
   while (1) {
    $3 = 0;
    label$34 : {
     switch ($8 | 0) {
     case 19:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 128 >> 2], HEAP32[$2 + 124 >> 2]);
     case 18:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 124 >> 2], HEAP32[$2 + 120 >> 2]) + $3 | 0;
     case 17:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 120 >> 2], HEAP32[$2 + 116 >> 2]) + $3 | 0;
     case 16:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 116 >> 2], HEAP32[$2 + 112 >> 2]) + $3 | 0;
     case 15:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 112 >> 2], HEAP32[$2 + 108 >> 2]) + $3 | 0;
     case 14:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 108 >> 2], HEAP32[$2 + 104 >> 2]) + $3 | 0;
     case 13:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 104 >> 2], HEAP32[$2 + 100 >> 2]) + $3 | 0;
     case 12:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 100 >> 2], HEAP32[$2 + 96 >> 2]) + $3 | 0;
     case 11:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 96 >> 2], HEAP32[$2 + 92 >> 2]) + $3 | 0;
     case 10:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 92 >> 2], HEAP32[$2 + 88 >> 2]) + $3 | 0;
     case 9:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 88 >> 2], HEAP32[$2 + 84 >> 2]) + $3 | 0;
     case 8:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 84 >> 2], HEAP32[$2 + 80 >> 2]) + $3 | 0;
     case 7:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 80 >> 2], HEAP32[$2 + 76 >> 2]) + $3 | 0;
     case 6:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 76 >> 2], HEAP32[$2 + 72 >> 2]) + $3 | 0;
     case 5:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 72 >> 2], HEAP32[$2 + 68 >> 2]) + $3 | 0;
     case 4:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 68 >> 2], HEAP32[$2 + 64 >> 2]) + $3 | 0;
     case 3:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) + -64 >> 2], HEAP32[$2 + 60 >> 2]) + $3 | 0;
     case 2:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 60 >> 2], HEAP32[$2 + 56 >> 2]) + $3 | 0;
     case 1:
      $3 = Math_imul(HEAP32[(($6 << 2) + $5 | 0) - 56 >> 2], HEAP32[$2 + 52 >> 2]) + $3 | 0;
     case 0:
      $7 = $3;
      $3 = ($6 << 2) + $5 | 0;
      $3 = (((((((((((($7 + Math_imul(HEAP32[$3 - 52 >> 2], HEAP32[$2 + 48 >> 2]) | 0) + Math_imul(HEAP32[$3 - 48 >> 2], HEAP32[$2 + 44 >> 2]) | 0) + Math_imul(HEAP32[$3 - 44 >> 2], HEAP32[$2 + 40 >> 2]) | 0) + Math_imul(HEAP32[$3 - 40 >> 2], HEAP32[$2 + 36 >> 2]) | 0) + Math_imul(HEAP32[$3 - 36 >> 2], HEAP32[$2 + 32 >> 2]) | 0) + Math_imul(HEAP32[$3 - 32 >> 2], HEAP32[$2 + 28 >> 2]) | 0) + Math_imul(HEAP32[$3 - 28 >> 2], HEAP32[$2 + 24 >> 2]) | 0) + Math_imul(HEAP32[$3 - 24 >> 2], HEAP32[$2 + 20 >> 2]) | 0) + Math_imul(HEAP32[$3 - 20 >> 2], HEAP32[$2 + 16 >> 2]) | 0) + Math_imul(HEAP32[$3 - 16 >> 2], HEAP32[$2 + 12 >> 2]) | 0) + Math_imul(HEAP32[$3 - 12 >> 2], HEAP32[$2 + 8 >> 2]) | 0) + Math_imul(HEAP32[$3 - 8 >> 2], HEAP32[$2 + 4 >> 2]) | 0) + Math_imul(HEAP32[$3 - 4 >> 2], HEAP32[$2 >> 2]) | 0;
      break;
     default:
      break label$34;
     };
    }
    $7 = $6 << 2;
    HEAP32[$7 + $5 >> 2] = HEAP32[$0 + $7 >> 2] + ($3 >> $4);
    $6 = $6 + 1 | 0;
    if (($6 | 0) != ($1 | 0)) {
     continue
    }
    break;
   };
  }
 }
 
 function FLAC__lpc_restore_signal_wide($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
  label$1 : {
   label$2 : {
    if ($3 >>> 0 >= 13) {
     if (($1 | 0) <= 0) {
      break label$1
     }
     $12 = $4;
     $11 = $3 - 13 | 0;
     break label$2;
    }
    if ($3 >>> 0 >= 9) {
     if ($3 >>> 0 >= 11) {
      $22 = $4;
      if (($3 | 0) != 12) {
       if (($1 | 0) < 1) {
        break label$1
       }
       $10 = HEAP32[$5 - 4 >> 2];
       $3 = HEAP32[$5 - 8 >> 2];
       $4 = HEAP32[$5 - 12 >> 2];
       $12 = HEAP32[$5 - 16 >> 2];
       $7 = HEAP32[$5 - 20 >> 2];
       $8 = HEAP32[$5 - 24 >> 2];
       $11 = HEAP32[$5 - 28 >> 2];
       $9 = HEAP32[$5 - 32 >> 2];
       $13 = HEAP32[$5 - 36 >> 2];
       $14 = HEAP32[$5 - 40 >> 2];
       $16 = HEAP32[$5 - 44 >> 2];
       $6 = HEAP32[$2 >> 2];
       $15 = $6;
       $25 = $6 >> 31;
       $6 = HEAP32[$2 + 4 >> 2];
       $26 = $6;
       $27 = $6 >> 31;
       $6 = HEAP32[$2 + 8 >> 2];
       $24 = $6;
       $29 = $6 >> 31;
       $6 = HEAP32[$2 + 12 >> 2];
       $30 = $6;
       $21 = $6 >> 31;
       $6 = HEAP32[$2 + 16 >> 2];
       $31 = $6;
       $32 = $6 >> 31;
       $6 = HEAP32[$2 + 20 >> 2];
       $28 = $6;
       $34 = $6 >> 31;
       $6 = HEAP32[$2 + 24 >> 2];
       $35 = $6;
       $20 = $6 >> 31;
       $6 = HEAP32[$2 + 28 >> 2];
       $36 = $6;
       $37 = $6 >> 31;
       $6 = HEAP32[$2 + 32 >> 2];
       $33 = $6;
       $39 = $6 >> 31;
       $6 = HEAP32[$2 + 36 >> 2];
       $40 = $6;
       $19 = $6 >> 31;
       $2 = HEAP32[$2 + 40 >> 2];
       $41 = $2;
       $42 = $2 >> 31;
       $2 = 0;
       while (1) {
        $6 = $2 << 2;
        $38 = $6 + $5 | 0;
        $43 = HEAP32[$0 + $6 >> 2];
        $17 = $14;
        $6 = __wasm_i64_mul($14, $14 >> 31, $40, $19);
        $44 = i64toi32_i32$HIGH_BITS;
        $14 = $13;
        $18 = __wasm_i64_mul($16, $16 >> 31, $41, $42);
        $16 = $18 + $6 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $44 | 0;
        $6 = $16 >>> 0 < $18 >>> 0 ? $6 + 1 | 0 : $6;
        $18 = $16;
        $16 = __wasm_i64_mul($13, $13 >> 31, $33, $39);
        $13 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $13 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $16 = $13;
        $13 = $9;
        $18 = $16;
        $16 = __wasm_i64_mul($9, $9 >> 31, $36, $37);
        $9 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $9 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $18 = $9;
        $9 = $11;
        $16 = __wasm_i64_mul($9, $9 >> 31, $35, $20);
        $11 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $11 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $16 = $11;
        $11 = $8;
        $18 = $16;
        $16 = __wasm_i64_mul($8, $8 >> 31, $28, $34);
        $8 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $8 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $16 = $8;
        $8 = $7;
        $18 = $16;
        $16 = __wasm_i64_mul($7, $7 >> 31, $31, $32);
        $7 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $7 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $18 = $7;
        $7 = $12;
        $16 = __wasm_i64_mul($7, $7 >> 31, $30, $21);
        $12 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $12 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $16 = $12;
        $12 = $4;
        $18 = $16;
        $16 = __wasm_i64_mul($4, $4 >> 31, $24, $29);
        $4 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $4 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $16 = $4;
        $4 = $3;
        $23 = $38;
        $18 = $16;
        $16 = __wasm_i64_mul($3, $3 >> 31, $26, $27);
        $3 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $3 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $18 = $3;
        $3 = $10;
        $16 = __wasm_i64_mul($3, $3 >> 31, $15, $25);
        $10 = $18 + $16 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $10 >>> 0 < $16 >>> 0 ? $6 + 1 | 0 : $6;
        $38 = $10;
        $10 = $22;
        $16 = $10 & 31;
        $10 = (($10 & 63) >>> 0 >= 32 ? $6 >> $16 : ((1 << $16) - 1 & $6) << 32 - $16 | $38 >>> $16) + $43 | 0;
        HEAP32[$23 >> 2] = $10;
        $16 = $17;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       break label$1;
      }
      if (($1 | 0) < 1) {
       break label$1
      }
      $10 = HEAP32[$5 - 4 >> 2];
      $3 = HEAP32[$5 - 8 >> 2];
      $4 = HEAP32[$5 - 12 >> 2];
      $12 = HEAP32[$5 - 16 >> 2];
      $7 = HEAP32[$5 - 20 >> 2];
      $8 = HEAP32[$5 - 24 >> 2];
      $11 = HEAP32[$5 - 28 >> 2];
      $9 = HEAP32[$5 - 32 >> 2];
      $13 = HEAP32[$5 - 36 >> 2];
      $14 = HEAP32[$5 - 40 >> 2];
      $16 = HEAP32[$5 - 44 >> 2];
      $6 = HEAP32[$5 - 48 >> 2];
      $17 = HEAP32[$2 >> 2];
      $25 = $17;
      $26 = $17 >> 31;
      $17 = HEAP32[$2 + 4 >> 2];
      $27 = $17;
      $24 = $17 >> 31;
      $17 = HEAP32[$2 + 8 >> 2];
      $29 = $17;
      $30 = $17 >> 31;
      $17 = HEAP32[$2 + 12 >> 2];
      $21 = $17;
      $31 = $17 >> 31;
      $17 = HEAP32[$2 + 16 >> 2];
      $32 = $17;
      $28 = $17 >> 31;
      $17 = HEAP32[$2 + 20 >> 2];
      $34 = $17;
      $35 = $17 >> 31;
      $17 = HEAP32[$2 + 24 >> 2];
      $20 = $17;
      $36 = $17 >> 31;
      $17 = HEAP32[$2 + 28 >> 2];
      $37 = $17;
      $33 = $17 >> 31;
      $17 = HEAP32[$2 + 32 >> 2];
      $39 = $17;
      $40 = $17 >> 31;
      $17 = HEAP32[$2 + 36 >> 2];
      $19 = $17;
      $41 = $17 >> 31;
      $17 = HEAP32[$2 + 40 >> 2];
      $42 = $17;
      $38 = $17 >> 31;
      $2 = HEAP32[$2 + 44 >> 2];
      $43 = $2;
      $44 = $2 >> 31;
      $2 = 0;
      while (1) {
       $17 = $2 << 2;
       $18 = $17 + $5 | 0;
       $46 = HEAP32[$0 + $17 >> 2];
       $17 = $16;
       $15 = __wasm_i64_mul($16, $16 >> 31, $42, $38);
       $23 = i64toi32_i32$HIGH_BITS;
       $16 = $14;
       $45 = __wasm_i64_mul($6, $6 >> 31, $43, $44);
       $15 = $45 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $23 | 0;
       $6 = $15 >>> 0 < $45 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = $15;
       $15 = __wasm_i64_mul($14, $14 >> 31, $19, $41);
       $14 = $23 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $14 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $15 = $14;
       $14 = $13;
       $23 = $15;
       $15 = __wasm_i64_mul($13, $13 >> 31, $39, $40);
       $13 = $23 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $13 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $15 = $13;
       $13 = $9;
       $23 = $15;
       $15 = __wasm_i64_mul($9, $9 >> 31, $37, $33);
       $9 = $23 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $9 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = $9;
       $9 = $11;
       $15 = __wasm_i64_mul($9, $9 >> 31, $20, $36);
       $11 = $23 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $11 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $15 = $11;
       $11 = $8;
       $23 = $15;
       $15 = __wasm_i64_mul($8, $8 >> 31, $34, $35);
       $8 = $23 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $8 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $15 = $8;
       $8 = $7;
       $23 = $15;
       $15 = __wasm_i64_mul($7, $7 >> 31, $32, $28);
       $7 = $23 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $7 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $23 = $7;
       $7 = $12;
       $15 = __wasm_i64_mul($7, $7 >> 31, $21, $31);
       $12 = $23 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $12 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $15 = $12;
       $12 = $4;
       $23 = $15;
       $15 = __wasm_i64_mul($4, $4 >> 31, $29, $30);
       $4 = $23 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $4 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $15 = $4;
       $4 = $3;
       $23 = $18;
       $18 = $15;
       $15 = __wasm_i64_mul($3, $3 >> 31, $27, $24);
       $3 = $18 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $3 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = $3;
       $3 = $10;
       $15 = __wasm_i64_mul($3, $3 >> 31, $25, $26);
       $10 = $18 + $15 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $10 >>> 0 < $15 >>> 0 ? $6 + 1 | 0 : $6;
       $18 = $10;
       $10 = $22;
       $15 = $10 & 31;
       $10 = (($10 & 63) >>> 0 >= 32 ? $6 >> $15 : ((1 << $15) - 1 & $6) << 32 - $15 | $18 >>> $15) + $46 | 0;
       HEAP32[$23 >> 2] = $10;
       $6 = $17;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     $16 = $4;
     if (($3 | 0) != 10) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $10 = HEAP32[$5 - 4 >> 2];
      $3 = HEAP32[$5 - 8 >> 2];
      $4 = HEAP32[$5 - 12 >> 2];
      $12 = HEAP32[$5 - 16 >> 2];
      $7 = HEAP32[$5 - 20 >> 2];
      $8 = HEAP32[$5 - 24 >> 2];
      $11 = HEAP32[$5 - 28 >> 2];
      $9 = HEAP32[$5 - 32 >> 2];
      $13 = HEAP32[$5 - 36 >> 2];
      $6 = HEAP32[$2 >> 2];
      $22 = $6;
      $17 = $6 >> 31;
      $6 = HEAP32[$2 + 4 >> 2];
      $15 = $6;
      $25 = $6 >> 31;
      $6 = HEAP32[$2 + 8 >> 2];
      $26 = $6;
      $27 = $6 >> 31;
      $6 = HEAP32[$2 + 12 >> 2];
      $24 = $6;
      $29 = $6 >> 31;
      $6 = HEAP32[$2 + 16 >> 2];
      $30 = $6;
      $21 = $6 >> 31;
      $6 = HEAP32[$2 + 20 >> 2];
      $31 = $6;
      $32 = $6 >> 31;
      $6 = HEAP32[$2 + 24 >> 2];
      $28 = $6;
      $34 = $6 >> 31;
      $6 = HEAP32[$2 + 28 >> 2];
      $35 = $6;
      $20 = $6 >> 31;
      $2 = HEAP32[$2 + 32 >> 2];
      $36 = $2;
      $37 = $2 >> 31;
      $2 = 0;
      while (1) {
       $6 = $2 << 2;
       $33 = $6 + $5 | 0;
       $39 = HEAP32[$0 + $6 >> 2];
       $14 = $9;
       $6 = __wasm_i64_mul($9, $9 >> 31, $35, $20);
       $40 = i64toi32_i32$HIGH_BITS;
       $9 = $11;
       $19 = __wasm_i64_mul($13, $13 >> 31, $36, $37);
       $13 = $19 + $6 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $40 | 0;
       $6 = $13 >>> 0 < $19 >>> 0 ? $6 + 1 | 0 : $6;
       $11 = $13;
       $13 = __wasm_i64_mul($9, $9 >> 31, $28, $34);
       $11 = $11 + $13 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $11 >>> 0 < $13 >>> 0 ? $6 + 1 | 0 : $6;
       $13 = $11;
       $11 = $8;
       $19 = $13;
       $13 = __wasm_i64_mul($8, $8 >> 31, $31, $32);
       $8 = $19 + $13 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $8 >>> 0 < $13 >>> 0 ? $6 + 1 | 0 : $6;
       $13 = $8;
       $8 = $7;
       $19 = $13;
       $13 = __wasm_i64_mul($7, $7 >> 31, $30, $21);
       $7 = $19 + $13 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $7 >>> 0 < $13 >>> 0 ? $6 + 1 | 0 : $6;
       $19 = $7;
       $7 = $12;
       $13 = __wasm_i64_mul($7, $7 >> 31, $24, $29);
       $12 = $19 + $13 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $12 >>> 0 < $13 >>> 0 ? $6 + 1 | 0 : $6;
       $13 = $12;
       $12 = $4;
       $19 = $13;
       $13 = __wasm_i64_mul($4, $4 >> 31, $26, $27);
       $4 = $19 + $13 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $4 >>> 0 < $13 >>> 0 ? $6 + 1 | 0 : $6;
       $13 = $4;
       $4 = $3;
       $18 = $33;
       $19 = $13;
       $13 = __wasm_i64_mul($3, $3 >> 31, $15, $25);
       $3 = $19 + $13 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $3 >>> 0 < $13 >>> 0 ? $6 + 1 | 0 : $6;
       $19 = $3;
       $3 = $10;
       $13 = __wasm_i64_mul($3, $3 >> 31, $22, $17);
       $10 = $19 + $13 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $10 >>> 0 < $13 >>> 0 ? $6 + 1 | 0 : $6;
       $33 = $10;
       $10 = $16;
       $13 = $10 & 31;
       $10 = (($10 & 63) >>> 0 >= 32 ? $6 >> $13 : ((1 << $13) - 1 & $6) << 32 - $13 | $33 >>> $13) + $39 | 0;
       HEAP32[$18 >> 2] = $10;
       $13 = $14;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $10 = HEAP32[$5 - 4 >> 2];
     $3 = HEAP32[$5 - 8 >> 2];
     $4 = HEAP32[$5 - 12 >> 2];
     $12 = HEAP32[$5 - 16 >> 2];
     $7 = HEAP32[$5 - 20 >> 2];
     $8 = HEAP32[$5 - 24 >> 2];
     $11 = HEAP32[$5 - 28 >> 2];
     $9 = HEAP32[$5 - 32 >> 2];
     $13 = HEAP32[$5 - 36 >> 2];
     $14 = HEAP32[$5 - 40 >> 2];
     $6 = HEAP32[$2 >> 2];
     $17 = $6;
     $15 = $6 >> 31;
     $6 = HEAP32[$2 + 4 >> 2];
     $25 = $6;
     $26 = $6 >> 31;
     $6 = HEAP32[$2 + 8 >> 2];
     $27 = $6;
     $24 = $6 >> 31;
     $6 = HEAP32[$2 + 12 >> 2];
     $29 = $6;
     $30 = $6 >> 31;
     $6 = HEAP32[$2 + 16 >> 2];
     $21 = $6;
     $31 = $6 >> 31;
     $6 = HEAP32[$2 + 20 >> 2];
     $32 = $6;
     $28 = $6 >> 31;
     $6 = HEAP32[$2 + 24 >> 2];
     $34 = $6;
     $35 = $6 >> 31;
     $6 = HEAP32[$2 + 28 >> 2];
     $20 = $6;
     $36 = $6 >> 31;
     $6 = HEAP32[$2 + 32 >> 2];
     $37 = $6;
     $33 = $6 >> 31;
     $2 = HEAP32[$2 + 36 >> 2];
     $39 = $2;
     $40 = $2 >> 31;
     $2 = 0;
     while (1) {
      $6 = $2 << 2;
      $19 = $6 + $5 | 0;
      $41 = HEAP32[$0 + $6 >> 2];
      $22 = $13;
      $6 = __wasm_i64_mul($13, $13 >> 31, $37, $33);
      $42 = i64toi32_i32$HIGH_BITS;
      $13 = $9;
      $38 = __wasm_i64_mul($14, $14 >> 31, $39, $40);
      $14 = $38 + $6 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $42 | 0;
      $6 = $14 >>> 0 < $38 >>> 0 ? $6 + 1 | 0 : $6;
      $18 = $14;
      $14 = __wasm_i64_mul($9, $9 >> 31, $20, $36);
      $9 = $18 + $14 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $9 >>> 0 < $14 >>> 0 ? $6 + 1 | 0 : $6;
      $18 = $9;
      $9 = $11;
      $14 = __wasm_i64_mul($9, $9 >> 31, $34, $35);
      $11 = $18 + $14 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $11 >>> 0 < $14 >>> 0 ? $6 + 1 | 0 : $6;
      $14 = $11;
      $11 = $8;
      $18 = $14;
      $14 = __wasm_i64_mul($8, $8 >> 31, $32, $28);
      $8 = $18 + $14 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $8 >>> 0 < $14 >>> 0 ? $6 + 1 | 0 : $6;
      $14 = $8;
      $8 = $7;
      $18 = $14;
      $14 = __wasm_i64_mul($7, $7 >> 31, $21, $31);
      $7 = $18 + $14 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $7 >>> 0 < $14 >>> 0 ? $6 + 1 | 0 : $6;
      $18 = $7;
      $7 = $12;
      $14 = __wasm_i64_mul($7, $7 >> 31, $29, $30);
      $12 = $18 + $14 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $12 >>> 0 < $14 >>> 0 ? $6 + 1 | 0 : $6;
      $14 = $12;
      $12 = $4;
      $18 = $14;
      $14 = __wasm_i64_mul($4, $4 >> 31, $27, $24);
      $4 = $18 + $14 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $4 >>> 0 < $14 >>> 0 ? $6 + 1 | 0 : $6;
      $14 = $4;
      $4 = $3;
      $18 = $19;
      $19 = $14;
      $14 = __wasm_i64_mul($3, $3 >> 31, $25, $26);
      $3 = $19 + $14 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $14 >>> 0 ? $6 + 1 | 0 : $6;
      $19 = $3;
      $3 = $10;
      $14 = __wasm_i64_mul($3, $3 >> 31, $17, $15);
      $10 = $19 + $14 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $10 >>> 0 < $14 >>> 0 ? $6 + 1 | 0 : $6;
      $19 = $10;
      $10 = $16;
      $14 = $10 & 31;
      $10 = (($10 & 63) >>> 0 >= 32 ? $6 >> $14 : ((1 << $14) - 1 & $6) << 32 - $14 | $19 >>> $14) + $41 | 0;
      HEAP32[$18 >> 2] = $10;
      $14 = $22;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($3 >>> 0 >= 5) {
     if ($3 >>> 0 >= 7) {
      $13 = $4;
      if (($3 | 0) != 8) {
       if (($1 | 0) < 1) {
        break label$1
       }
       $10 = HEAP32[$5 - 4 >> 2];
       $3 = HEAP32[$5 - 8 >> 2];
       $4 = HEAP32[$5 - 12 >> 2];
       $12 = HEAP32[$5 - 16 >> 2];
       $7 = HEAP32[$5 - 20 >> 2];
       $8 = HEAP32[$5 - 24 >> 2];
       $11 = HEAP32[$5 - 28 >> 2];
       $9 = HEAP32[$2 >> 2];
       $14 = $9;
       $16 = $9 >> 31;
       $9 = HEAP32[$2 + 4 >> 2];
       $22 = $9;
       $17 = $9 >> 31;
       $9 = HEAP32[$2 + 8 >> 2];
       $15 = $9;
       $25 = $9 >> 31;
       $9 = HEAP32[$2 + 12 >> 2];
       $26 = $9;
       $27 = $9 >> 31;
       $9 = HEAP32[$2 + 16 >> 2];
       $24 = $9;
       $29 = $9 >> 31;
       $9 = HEAP32[$2 + 20 >> 2];
       $30 = $9;
       $21 = $9 >> 31;
       $2 = HEAP32[$2 + 24 >> 2];
       $31 = $2;
       $32 = $2 >> 31;
       $2 = 0;
       while (1) {
        $9 = $2 << 2;
        $28 = $9 + $5 | 0;
        $34 = HEAP32[$0 + $9 >> 2];
        $9 = $8;
        $6 = __wasm_i64_mul($9, $9 >> 31, $30, $21);
        $35 = i64toi32_i32$HIGH_BITS;
        $8 = $7;
        $20 = __wasm_i64_mul($11, $11 >> 31, $31, $32);
        $11 = $20 + $6 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $35 | 0;
        $6 = $11 >>> 0 < $20 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = $11;
        $11 = __wasm_i64_mul($7, $7 >> 31, $24, $29);
        $7 = $20 + $11 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $7 >>> 0 < $11 >>> 0 ? $6 + 1 | 0 : $6;
        $20 = $7;
        $7 = $12;
        $11 = __wasm_i64_mul($7, $7 >> 31, $26, $27);
        $12 = $20 + $11 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $12 >>> 0 < $11 >>> 0 ? $6 + 1 | 0 : $6;
        $11 = $12;
        $12 = $4;
        $20 = $11;
        $11 = __wasm_i64_mul($4, $4 >> 31, $15, $25);
        $4 = $20 + $11 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $4 >>> 0 < $11 >>> 0 ? $6 + 1 | 0 : $6;
        $11 = $4;
        $4 = $3;
        $19 = $28;
        $20 = $11;
        $11 = __wasm_i64_mul($3, $3 >> 31, $22, $17);
        $3 = $20 + $11 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $3 >>> 0 < $11 >>> 0 ? $6 + 1 | 0 : $6;
        $11 = $3;
        $3 = $10;
        $10 = __wasm_i64_mul($3, $3 >> 31, $14, $16);
        $11 = $11 + $10 | 0;
        $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
        $6 = $10 >>> 0 > $11 >>> 0 ? $6 + 1 | 0 : $6;
        $28 = $11;
        $11 = $13;
        $10 = $11 & 31;
        $10 = (($11 & 63) >>> 0 >= 32 ? $6 >> $10 : ((1 << $10) - 1 & $6) << 32 - $10 | $28 >>> $10) + $34 | 0;
        HEAP32[$19 >> 2] = $10;
        $11 = $9;
        $2 = $2 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       break label$1;
      }
      if (($1 | 0) < 1) {
       break label$1
      }
      $10 = HEAP32[$5 - 4 >> 2];
      $3 = HEAP32[$5 - 8 >> 2];
      $4 = HEAP32[$5 - 12 >> 2];
      $12 = HEAP32[$5 - 16 >> 2];
      $7 = HEAP32[$5 - 20 >> 2];
      $8 = HEAP32[$5 - 24 >> 2];
      $11 = HEAP32[$5 - 28 >> 2];
      $9 = HEAP32[$5 - 32 >> 2];
      $6 = HEAP32[$2 >> 2];
      $16 = $6;
      $22 = $6 >> 31;
      $6 = HEAP32[$2 + 4 >> 2];
      $17 = $6;
      $15 = $6 >> 31;
      $6 = HEAP32[$2 + 8 >> 2];
      $25 = $6;
      $26 = $6 >> 31;
      $6 = HEAP32[$2 + 12 >> 2];
      $27 = $6;
      $24 = $6 >> 31;
      $6 = HEAP32[$2 + 16 >> 2];
      $29 = $6;
      $30 = $6 >> 31;
      $6 = HEAP32[$2 + 20 >> 2];
      $21 = $6;
      $31 = $6 >> 31;
      $6 = HEAP32[$2 + 24 >> 2];
      $32 = $6;
      $28 = $6 >> 31;
      $2 = HEAP32[$2 + 28 >> 2];
      $34 = $2;
      $35 = $2 >> 31;
      $2 = 0;
      while (1) {
       $6 = $2 << 2;
       $20 = $6 + $5 | 0;
       $36 = HEAP32[$0 + $6 >> 2];
       $14 = $11;
       $6 = __wasm_i64_mul($11, $11 >> 31, $32, $28);
       $37 = i64toi32_i32$HIGH_BITS;
       $11 = $8;
       $33 = __wasm_i64_mul($9, $9 >> 31, $34, $35);
       $9 = $33 + $6 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $37 | 0;
       $6 = $9 >>> 0 < $33 >>> 0 ? $6 + 1 | 0 : $6;
       $19 = $9;
       $9 = __wasm_i64_mul($8, $8 >> 31, $21, $31);
       $8 = $19 + $9 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $8 >>> 0 < $9 >>> 0 ? $6 + 1 | 0 : $6;
       $9 = $8;
       $8 = $7;
       $19 = $9;
       $9 = __wasm_i64_mul($7, $7 >> 31, $29, $30);
       $7 = $19 + $9 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $7 >>> 0 < $9 >>> 0 ? $6 + 1 | 0 : $6;
       $19 = $7;
       $7 = $12;
       $9 = __wasm_i64_mul($7, $7 >> 31, $27, $24);
       $12 = $19 + $9 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $9 >>> 0 > $12 >>> 0 ? $6 + 1 | 0 : $6;
       $9 = $12;
       $12 = $4;
       $19 = $9;
       $9 = __wasm_i64_mul($4, $4 >> 31, $25, $26);
       $4 = $19 + $9 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $4 >>> 0 < $9 >>> 0 ? $6 + 1 | 0 : $6;
       $9 = $4;
       $4 = $3;
       $19 = $20;
       $20 = $9;
       $9 = __wasm_i64_mul($3, $3 >> 31, $17, $15);
       $3 = $20 + $9 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $3 >>> 0 < $9 >>> 0 ? $6 + 1 | 0 : $6;
       $20 = $3;
       $3 = $10;
       $9 = __wasm_i64_mul($3, $3 >> 31, $16, $22);
       $10 = $20 + $9 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $10 >>> 0 < $9 >>> 0 ? $6 + 1 | 0 : $6;
       $20 = $10;
       $10 = $13;
       $9 = $10 & 31;
       $10 = (($10 & 63) >>> 0 >= 32 ? $6 >> $9 : ((1 << $9) - 1 & $6) << 32 - $9 | $20 >>> $9) + $36 | 0;
       HEAP32[$19 >> 2] = $10;
       $9 = $14;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     $11 = $4;
     if (($3 | 0) != 6) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $10 = HEAP32[$5 - 4 >> 2];
      $3 = HEAP32[$5 - 8 >> 2];
      $4 = HEAP32[$5 - 12 >> 2];
      $12 = HEAP32[$5 - 16 >> 2];
      $7 = HEAP32[$5 - 20 >> 2];
      $8 = HEAP32[$2 >> 2];
      $9 = $8;
      $13 = $9 >> 31;
      $8 = HEAP32[$2 + 4 >> 2];
      $14 = $8;
      $16 = $8 >> 31;
      $8 = HEAP32[$2 + 8 >> 2];
      $22 = $8;
      $17 = $8 >> 31;
      $8 = HEAP32[$2 + 12 >> 2];
      $15 = $8;
      $25 = $8 >> 31;
      $2 = HEAP32[$2 + 16 >> 2];
      $26 = $2;
      $27 = $2 >> 31;
      $2 = 0;
      while (1) {
       $8 = $2 << 2;
       $24 = $8 + $5 | 0;
       $29 = HEAP32[$0 + $8 >> 2];
       $8 = $12;
       $6 = __wasm_i64_mul($8, $8 >> 31, $15, $25);
       $30 = i64toi32_i32$HIGH_BITS;
       $12 = $4;
       $21 = __wasm_i64_mul($7, $7 >> 31, $26, $27);
       $7 = $21 + $6 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $30 | 0;
       $6 = $7 >>> 0 < $21 >>> 0 ? $6 + 1 | 0 : $6;
       $21 = $7;
       $7 = __wasm_i64_mul($4, $4 >> 31, $22, $17);
       $4 = $21 + $7 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $4 >>> 0 < $7 >>> 0 ? $6 + 1 | 0 : $6;
       $7 = $4;
       $4 = $3;
       $20 = $24;
       $21 = $7;
       $7 = __wasm_i64_mul($3, $3 >> 31, $14, $16);
       $3 = $21 + $7 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $3 >>> 0 < $7 >>> 0 ? $6 + 1 | 0 : $6;
       $7 = $3;
       $3 = $10;
       $10 = __wasm_i64_mul($3, $3 >> 31, $9, $13);
       $7 = $7 + $10 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $7 >>> 0 < $10 >>> 0 ? $6 + 1 | 0 : $6;
       $24 = $7;
       $7 = $11;
       $10 = $7 & 31;
       $10 = (($7 & 63) >>> 0 >= 32 ? $6 >> $10 : ((1 << $10) - 1 & $6) << 32 - $10 | $24 >>> $10) + $29 | 0;
       HEAP32[$20 >> 2] = $10;
       $7 = $8;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $10 = HEAP32[$5 - 4 >> 2];
     $3 = HEAP32[$5 - 8 >> 2];
     $4 = HEAP32[$5 - 12 >> 2];
     $12 = HEAP32[$5 - 16 >> 2];
     $7 = HEAP32[$5 - 20 >> 2];
     $8 = HEAP32[$5 - 24 >> 2];
     $9 = HEAP32[$2 >> 2];
     $13 = $9;
     $14 = $9 >> 31;
     $9 = HEAP32[$2 + 4 >> 2];
     $16 = $9;
     $22 = $9 >> 31;
     $9 = HEAP32[$2 + 8 >> 2];
     $17 = $9;
     $15 = $9 >> 31;
     $9 = HEAP32[$2 + 12 >> 2];
     $25 = $9;
     $26 = $9 >> 31;
     $9 = HEAP32[$2 + 16 >> 2];
     $27 = $9;
     $24 = $9 >> 31;
     $2 = HEAP32[$2 + 20 >> 2];
     $29 = $2;
     $30 = $2 >> 31;
     $2 = 0;
     while (1) {
      $9 = $2 << 2;
      $21 = $9 + $5 | 0;
      $31 = HEAP32[$0 + $9 >> 2];
      $9 = $7;
      $6 = __wasm_i64_mul($7, $7 >> 31, $27, $24);
      $32 = i64toi32_i32$HIGH_BITS;
      $7 = $12;
      $28 = __wasm_i64_mul($8, $8 >> 31, $29, $30);
      $8 = $28 + $6 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $32 | 0;
      $6 = $8 >>> 0 < $28 >>> 0 ? $6 + 1 | 0 : $6;
      $12 = $8;
      $8 = __wasm_i64_mul($7, $7 >> 31, $25, $26);
      $12 = $12 + $8 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $8 >>> 0 > $12 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $12;
      $12 = $4;
      $20 = $8;
      $8 = __wasm_i64_mul($4, $4 >> 31, $17, $15);
      $4 = $20 + $8 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $4 >>> 0 < $8 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $4;
      $4 = $3;
      $20 = $21;
      $21 = $8;
      $8 = __wasm_i64_mul($3, $3 >> 31, $16, $22);
      $3 = $21 + $8 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $8 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = $10;
      $10 = __wasm_i64_mul($3, $3 >> 31, $13, $14);
      $8 = $8 + $10 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $10 >>> 0 > $8 >>> 0 ? $6 + 1 | 0 : $6;
      $21 = $8;
      $8 = $11;
      $10 = $8 & 31;
      $10 = (($8 & 63) >>> 0 >= 32 ? $6 >> $10 : ((1 << $10) - 1 & $6) << 32 - $10 | $21 >>> $10) + $31 | 0;
      HEAP32[$20 >> 2] = $10;
      $8 = $9;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    if ($3 >>> 0 >= 3) {
     $7 = $4;
     if (($3 | 0) != 4) {
      if (($1 | 0) < 1) {
       break label$1
      }
      $10 = HEAP32[$5 - 4 >> 2];
      $3 = HEAP32[$5 - 8 >> 2];
      $4 = HEAP32[$5 - 12 >> 2];
      $12 = HEAP32[$2 >> 2];
      $11 = $12;
      $9 = $11 >> 31;
      $12 = HEAP32[$2 + 4 >> 2];
      $13 = $12;
      $14 = $13 >> 31;
      $2 = HEAP32[$2 + 8 >> 2];
      $16 = $2;
      $22 = $2 >> 31;
      $2 = 0;
      while (1) {
       $12 = $2 << 2;
       $8 = $12 + $5 | 0;
       $17 = HEAP32[$0 + $12 >> 2];
       $12 = $3;
       $3 = __wasm_i64_mul($3, $3 >> 31, $13, $14);
       $6 = i64toi32_i32$HIGH_BITS;
       $15 = $8;
       $4 = __wasm_i64_mul($4, $4 >> 31, $16, $22);
       $3 = $4 + $3 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
       $4 = $3;
       $3 = $10;
       $10 = __wasm_i64_mul($3, $3 >> 31, $11, $9);
       $4 = $4 + $10 | 0;
       $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
       $6 = $4 >>> 0 < $10 >>> 0 ? $6 + 1 | 0 : $6;
       $8 = $7 & 31;
       $10 = (($7 & 63) >>> 0 >= 32 ? $6 >> $8 : ((1 << $8) - 1 & $6) << 32 - $8 | $4 >>> $8) + $17 | 0;
       HEAP32[$15 >> 2] = $10;
       $4 = $12;
       $2 = $2 + 1 | 0;
       if (($2 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
      break label$1;
     }
     if (($1 | 0) < 1) {
      break label$1
     }
     $10 = HEAP32[$5 - 4 >> 2];
     $3 = HEAP32[$5 - 8 >> 2];
     $4 = HEAP32[$5 - 12 >> 2];
     $12 = HEAP32[$5 - 16 >> 2];
     $8 = HEAP32[$2 >> 2];
     $9 = $8;
     $13 = $9 >> 31;
     $8 = HEAP32[$2 + 4 >> 2];
     $14 = $8;
     $16 = $8 >> 31;
     $8 = HEAP32[$2 + 8 >> 2];
     $22 = $8;
     $17 = $8 >> 31;
     $2 = HEAP32[$2 + 12 >> 2];
     $15 = $2;
     $25 = $2 >> 31;
     $2 = 0;
     while (1) {
      $8 = $2 << 2;
      $11 = $8 + $5 | 0;
      $26 = HEAP32[$0 + $8 >> 2];
      $8 = $4;
      $6 = __wasm_i64_mul($4, $4 >> 31, $22, $17);
      $27 = i64toi32_i32$HIGH_BITS;
      $4 = $3;
      $21 = $11;
      $24 = __wasm_i64_mul($12, $12 >> 31, $15, $25);
      $12 = $24 + $6 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $27 | 0;
      $6 = $12 >>> 0 < $24 >>> 0 ? $6 + 1 | 0 : $6;
      $11 = $12;
      $12 = __wasm_i64_mul($3, $3 >> 31, $14, $16);
      $3 = $11 + $12 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $12 >>> 0 ? $6 + 1 | 0 : $6;
      $12 = $3;
      $3 = $10;
      $10 = __wasm_i64_mul($3, $3 >> 31, $9, $13);
      $12 = $12 + $10 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $10 >>> 0 > $12 >>> 0 ? $6 + 1 | 0 : $6;
      $10 = $12;
      $11 = $7 & 31;
      $10 = (($7 & 63) >>> 0 >= 32 ? $6 >> $11 : ((1 << $11) - 1 & $6) << 32 - $11 | $10 >>> $11) + $26 | 0;
      HEAP32[$21 >> 2] = $10;
      $12 = $8;
      $2 = $2 + 1 | 0;
      if (($2 | 0) != ($1 | 0)) {
       continue
      }
      break;
     };
     break label$1;
    }
    $12 = $4;
    if (($3 | 0) != 2) {
     if (($1 | 0) < 1) {
      break label$1
     }
     $9 = $1 & 1;
     $3 = HEAP32[$5 - 4 >> 2];
     $2 = HEAP32[$2 >> 2];
     $7 = $2;
     $8 = $7 >> 31;
     $2 = 0;
     if (($1 | 0) != 1) {
      $1 = $1 & -2;
      while (1) {
       $11 = $2 << 2;
       $13 = HEAP32[$0 + $11 >> 2];
       $6 = __wasm_i64_mul($3, $3 >> 31, $7, $8);
       $10 = i64toi32_i32$HIGH_BITS;
       $3 = $12;
       $4 = $3 & 31;
       $3 = $13 + (($3 & 63) >>> 0 >= 32 ? $10 >> $4 : ((1 << $4) - 1 & $10) << 32 - $4 | $6 >>> $4) | 0;
       HEAP32[$11 + $5 >> 2] = $3;
       $4 = $11 | 4;
       $13 = $4 + $5 | 0;
       $6 = HEAP32[$0 + $4 >> 2];
       $10 = __wasm_i64_mul($3, $3 >> 31, $7, $8);
       $11 = i64toi32_i32$HIGH_BITS;
       $3 = $12;
       $4 = $3 & 31;
       $3 = $6 + (($3 & 63) >>> 0 >= 32 ? $11 >> $4 : ((1 << $4) - 1 & $11) << 32 - $4 | $10 >>> $4) | 0;
       HEAP32[$13 >> 2] = $3;
       $2 = $2 + 2 | 0;
       $1 = $1 - 2 | 0;
       if ($1) {
        continue
       }
       break;
      };
     }
     if (!$9) {
      break label$1
     }
     $1 = $2 << 2;
     $5 = $1 + $5 | 0;
     $4 = HEAP32[$0 + $1 >> 2];
     $2 = __wasm_i64_mul($3, $3 >> 31, $7, $8);
     $1 = i64toi32_i32$HIGH_BITS;
     $0 = $12 & 31;
     HEAP32[$5 >> 2] = $4 + (($12 & 63) >>> 0 >= 32 ? $1 >> $0 : ((1 << $0) - 1 & $1) << 32 - $0 | $2 >>> $0);
     break label$1;
    }
    if (($1 | 0) < 1) {
     break label$1
    }
    $16 = $1 & 1;
    $4 = HEAP32[$5 - 4 >> 2];
    $10 = HEAP32[$5 - 8 >> 2];
    $3 = HEAP32[$2 >> 2];
    $8 = $3;
    $11 = $3 >> 31;
    $2 = HEAP32[$2 + 4 >> 2];
    $9 = $2;
    $13 = $2 >> 31;
    $2 = 0;
    if (($1 | 0) != 1) {
     $1 = $1 & -2;
     while (1) {
      $14 = $2 << 2;
      $7 = $14 + $5 | 0;
      $22 = HEAP32[$0 + $14 >> 2];
      $3 = $4;
      $17 = $3 >> 31;
      $4 = __wasm_i64_mul($3, $17, $8, $11);
      $6 = i64toi32_i32$HIGH_BITS;
      $15 = $7;
      $10 = __wasm_i64_mul($10, $10 >> 31, $9, $13);
      $4 = $10 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $4 >>> 0 < $10 >>> 0 ? $6 + 1 | 0 : $6;
      $10 = $4;
      $4 = $12;
      $7 = $4 & 31;
      $10 = (($4 & 63) >>> 0 >= 32 ? $6 >> $7 : ((1 << $7) - 1 & $6) << 32 - $7 | $10 >>> $7) + $22 | 0;
      HEAP32[$15 >> 2] = $10;
      $4 = $14 | 4;
      $7 = $4 + $5 | 0;
      $4 = HEAP32[$0 + $4 >> 2];
      $6 = __wasm_i64_mul($10, $10 >> 31, $8, $11);
      $14 = i64toi32_i32$HIGH_BITS;
      $21 = $7;
      $15 = $4;
      $22 = __wasm_i64_mul($3, $17, $9, $13);
      $3 = $22 + $6 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $14 | 0;
      $6 = $3 >>> 0 < $22 >>> 0 ? $6 + 1 | 0 : $6;
      $7 = $3;
      $3 = $12;
      $4 = $3 & 31;
      $4 = $15 + (($3 & 63) >>> 0 >= 32 ? $6 >> $4 : ((1 << $4) - 1 & $6) << 32 - $4 | $7 >>> $4) | 0;
      HEAP32[$21 >> 2] = $4;
      $2 = $2 + 2 | 0;
      $1 = $1 - 2 | 0;
      if ($1) {
       continue
      }
      break;
     };
    }
    if (!$16) {
     break label$1
    }
    $1 = $2 << 2;
    $2 = $1 + $5 | 0;
    $1 = HEAP32[$0 + $1 >> 2];
    $0 = __wasm_i64_mul($4, $4 >> 31, $8, $11);
    $3 = i64toi32_i32$HIGH_BITS;
    $5 = $1;
    $4 = __wasm_i64_mul($10, $10 >> 31, $9, $13);
    $0 = $4 + $0 | 0;
    $6 = i64toi32_i32$HIGH_BITS + $3 | 0;
    $6 = $0 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
    $1 = $0;
    $0 = $12 & 31;
    HEAP32[$2 >> 2] = $5 + (($12 & 63) >>> 0 >= 32 ? $6 >> $0 : ((1 << $0) - 1 & $6) << 32 - $0 | $1 >>> $0);
    return;
   }
   while (1) {
    $4 = 0;
    $3 = 0;
    label$30 : {
     switch ($11 | 0) {
     case 19:
      $3 = HEAP32[(($10 << 2) + $5 | 0) - 128 >> 2];
      $4 = $3;
      $7 = $3 >> 31;
      $3 = HEAP32[$2 + 124 >> 2];
      $4 = __wasm_i64_mul($4, $7, $3, $3 >> 31);
      $3 = i64toi32_i32$HIGH_BITS;
     case 18:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 124 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 120 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 17:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 120 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 116 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 16:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 116 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 112 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 15:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 112 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 108 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 14:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 108 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 104 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 13:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 104 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 100 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 12:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 100 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 96 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 11:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 96 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 92 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 10:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 92 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 88 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 9:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 88 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 84 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 8:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 84 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 80 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 7:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 80 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 76 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 6:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 76 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 72 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 5:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 72 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 68 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 4:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 68 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 64 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 3:
      $7 = HEAP32[(($10 << 2) + $5 | 0) + -64 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 60 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 2:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 60 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 56 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 1:
      $7 = HEAP32[(($10 << 2) + $5 | 0) - 56 >> 2];
      $6 = $7;
      $8 = $7 >> 31;
      $7 = HEAP32[$2 + 52 >> 2];
      $7 = __wasm_i64_mul($6, $8, $7, $7 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $7 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $7;
      $3 = $6;
     case 0:
      $7 = ($10 << 2) + $5 | 0;
      $8 = HEAP32[$7 - 52 >> 2];
      $6 = $8;
      $9 = $8 >> 31;
      $8 = HEAP32[$2 + 48 >> 2];
      $8 = __wasm_i64_mul($6, $9, $8, $8 >> 31) + $4 | 0;
      $6 = $3 + i64toi32_i32$HIGH_BITS | 0;
      $6 = $4 >>> 0 > $8 >>> 0 ? $6 + 1 | 0 : $6;
      $3 = HEAP32[$7 - 48 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 44 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $4 + $8 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 44 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 40 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 40 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 36 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 36 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 32 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 32 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 28 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 28 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 24 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 24 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 20 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 20 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 16 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 16 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 12 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 12 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 8 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 8 >> 2];
      $4 = $3;
      $9 = $3 >> 31;
      $3 = HEAP32[$2 + 4 >> 2];
      $4 = __wasm_i64_mul($4, $9, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $8 = $3;
      $3 = HEAP32[$7 - 4 >> 2];
      $4 = $3;
      $7 = $3 >> 31;
      $3 = HEAP32[$2 >> 2];
      $4 = __wasm_i64_mul($4, $7, $3, $3 >> 31);
      $3 = $8 + $4 | 0;
      $6 = i64toi32_i32$HIGH_BITS + $6 | 0;
      $6 = $3 >>> 0 < $4 >>> 0 ? $6 + 1 | 0 : $6;
      $4 = $3;
      $3 = $6;
      break;
     default:
      break label$30;
     };
    }
    $7 = $10 << 2;
    $9 = $7 + $5 | 0;
    $6 = HEAP32[$0 + $7 >> 2];
    $8 = $4;
    $4 = $12;
    $7 = $4 & 31;
    HEAP32[$9 >> 2] = $6 + (($4 & 63) >>> 0 >= 32 ? $3 >> $7 : ((1 << $7) - 1 & $3) << 32 - $7 | $8 >>> $7);
    $10 = $10 + 1 | 0;
    if (($10 | 0) != ($1 | 0)) {
     continue
    }
    break;
   };
  }
 }
 
 function strlen($0) {
  var $1 = 0, $2 = 0, $3 = 0;
  $1 = $0;
  label$1 : {
   if ($1 & 3) {
    while (1) {
     if (!HEAPU8[$1 | 0]) {
      break label$1
     }
     $1 = $1 + 1 | 0;
     if ($1 & 3) {
      continue
     }
     break;
    }
   }
   while (1) {
    $2 = $1;
    $1 = $1 + 4 | 0;
    $3 = HEAP32[$2 >> 2];
    if (!(($3 ^ -1) & $3 - 16843009 & -2139062144)) {
     continue
    }
    break;
   };
   if (!($3 & 255)) {
    return $2 - $0 | 0
   }
   while (1) {
    $3 = HEAPU8[$2 + 1 | 0];
    $1 = $2 + 1 | 0;
    $2 = $1;
    if ($3) {
     continue
    }
    break;
   };
  }
  return $1 - $0 | 0;
 }
 
 function strchr($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0;
  __inlined_func$__strchrnul : {
   label$1 : {
    $4 = $1;
    $3 = $4 & 255;
    if ($3) {
     if ($0 & 3) {
      while (1) {
       $2 = HEAPU8[$0 | 0];
       if (!$2 | ($2 | 0) == ($4 & 255)) {
        break label$1
       }
       $0 = $0 + 1 | 0;
       if ($0 & 3) {
        continue
       }
       break;
      }
     }
     $2 = HEAP32[$0 >> 2];
     label$5 : {
      if (($2 ^ -1) & $2 - 16843009 & -2139062144) {
       break label$5
      }
      $3 = Math_imul($3, 16843009);
      while (1) {
       $2 = $2 ^ $3;
       if (($2 ^ -1) & $2 - 16843009 & -2139062144) {
        break label$5
       }
       $2 = HEAP32[$0 + 4 >> 2];
       $0 = $0 + 4 | 0;
       if (!($2 - 16843009 & ($2 ^ -1) & -2139062144)) {
        continue
       }
       break;
      };
     }
     while (1) {
      $2 = $0;
      $3 = HEAPU8[$0 | 0];
      if ($3) {
       $0 = $2 + 1 | 0;
       if (($3 | 0) != ($4 & 255)) {
        continue
       }
      }
      break;
     };
     $0 = $2;
     break __inlined_func$__strchrnul;
    }
    $0 = strlen($0) + $0 | 0;
    break __inlined_func$__strchrnul;
   }
  }
  return HEAPU8[$0 | 0] == ($1 & 255) ? $0 : 0;
 }
 
 function __stdio_write($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
  $3 = __stack_pointer - 32 | 0;
  __stack_pointer = $3;
  $4 = HEAP32[$0 + 28 >> 2];
  HEAP32[$3 + 16 >> 2] = $4;
  $5 = HEAP32[$0 + 20 >> 2];
  HEAP32[$3 + 28 >> 2] = $2;
  HEAP32[$3 + 24 >> 2] = $1;
  $1 = $5 - $4 | 0;
  HEAP32[$3 + 20 >> 2] = $1;
  $4 = $1 + $2 | 0;
  $9 = 2;
  $5 = $3 + 16 | 0;
  $1 = $5;
  label$1 : {
   label$2 : {
    label$3 : {
     if (!__wasi_syscall_ret(__wasi_fd_write(HEAP32[$0 + 60 >> 2], $1 | 0, 2, $3 + 12 | 0) | 0)) {
      while (1) {
       $5 = HEAP32[$3 + 12 >> 2];
       if (($5 | 0) == ($4 | 0)) {
        break label$3
       }
       if (($5 | 0) <= -1) {
        break label$2
       }
       $6 = HEAP32[$1 + 4 >> 2];
       $7 = $6 >>> 0 < $5 >>> 0;
       $8 = ($7 << 3) + $1 | 0;
       $6 = $5 - ($7 ? $6 : 0) | 0;
       HEAP32[$8 >> 2] = $6 + HEAP32[$8 >> 2];
       $8 = ($7 ? 12 : 4) + $1 | 0;
       HEAP32[$8 >> 2] = HEAP32[$8 >> 2] - $6;
       $4 = $4 - $5 | 0;
       $1 = $7 ? $1 + 8 | 0 : $1;
       $9 = $9 - $7 | 0;
       if (!__wasi_syscall_ret(__wasi_fd_write(HEAP32[$0 + 60 >> 2], $1 | 0, $9 | 0, $3 + 12 | 0) | 0)) {
        continue
       }
       break;
      }
     }
     if (($4 | 0) != -1) {
      break label$2
     }
    }
    $1 = HEAP32[$0 + 44 >> 2];
    HEAP32[$0 + 28 >> 2] = $1;
    HEAP32[$0 + 20 >> 2] = $1;
    HEAP32[$0 + 16 >> 2] = $1 + HEAP32[$0 + 48 >> 2];
    $0 = $2;
    break label$1;
   }
   HEAP32[$0 + 28 >> 2] = 0;
   HEAP32[$0 + 16 >> 2] = 0;
   HEAP32[$0 + 20 >> 2] = 0;
   HEAP32[$0 >> 2] = HEAP32[$0 >> 2] | 32;
   $0 = 0;
   if (($9 | 0) == 2) {
    break label$1
   }
   $0 = $2 - HEAP32[$1 + 4 >> 2] | 0;
  }
  $4 = $0;
  __stack_pointer = $3 + 32 | 0;
  return $4 | 0;
 }
 
 function FLAC__memory_alloc_aligned_int32_array($0, $1, $2) {
  var $3 = 0;
  label$1 : {
   if ($0 >>> 0 > 1073741823) {
    break label$1
   }
   $0 = dlmalloc($0 ? $0 << 2 : 1);
   if (!$0) {
    break label$1
   }
   $3 = HEAP32[$1 >> 2];
   if ($3) {
    dlfree($3)
   }
   HEAP32[$1 >> 2] = $0;
   HEAP32[$2 >> 2] = $0;
   $3 = 1;
  }
  return $3;
 }
 
 function safe_malloc_mul_2op_p($0, $1) {
  var $2 = 0;
  if ($1 ? !$0 : 1) {
   return dlmalloc(1)
  }
  __wasm_i64_mul($1, 0, $0, 0);
  if (!i64toi32_i32$HIGH_BITS) {
   $2 = dlmalloc(Math_imul($0, $1))
  }
  return $2;
 }
 
 function FLAC__fixed_compute_best_predictor($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = Math_fround(0), $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = Math_fround(0), $19 = Math_fround(0), wasm2js_i32$0 = 0, wasm2js_f32$0 = Math_fround(0);
  if ($1) {
   $3 = HEAP32[$0 - 4 >> 2];
   $7 = HEAP32[$0 - 8 >> 2];
   $11 = $3 - $7 | 0;
   $4 = HEAP32[$0 - 12 >> 2];
   $8 = $11 + ($4 - $7 | 0) | 0;
   $17 = $8 + (($4 << 1) - ($7 + HEAP32[$0 - 16 >> 2] | 0) | 0) | 0;
   while (1) {
    $7 = HEAP32[($15 << 2) + $0 >> 2];
    $4 = $7 >> 31;
    $14 = ($4 ^ $4 + $7) + $14 | 0;
    $4 = $7 - $3 | 0;
    $10 = $4 >> 31;
    $12 = ($10 ^ $4 + $10) + $12 | 0;
    $10 = $4 - $11 | 0;
    $3 = $10 >> 31;
    $9 = ($3 ^ $3 + $10) + $9 | 0;
    $8 = $10 - $8 | 0;
    $3 = $8 >> 31;
    $5 = ($3 ^ $3 + $8) + $5 | 0;
    $11 = $8 - $17 | 0;
    $3 = $11 >> 31;
    $6 = ($3 ^ $3 + $11) + $6 | 0;
    $3 = $7;
    $11 = $4;
    $17 = $8;
    $8 = $10;
    $15 = $15 + 1 | 0;
    if (($15 | 0) != ($1 | 0)) {
     continue
    }
    break;
   };
  }
  $0 = $9 >>> 0 > $12 >>> 0 ? $12 : $9;
  $0 = $0 >>> 0 < $5 >>> 0 ? $0 : $5;
  label$3 : {
   if (($0 >>> 0 < $6 >>> 0 ? $0 : $6) >>> 0 > $14 >>> 0) {
    break label$3
   }
   $16 = 1;
   $0 = $5 >>> 0 > $9 >>> 0 ? $9 : $5;
   if (($0 >>> 0 < $6 >>> 0 ? $0 : $6) >>> 0 > $12 >>> 0) {
    break label$3
   }
   $0 = $5 >>> 0 < $6 >>> 0;
   $16 = ($0 ? $5 : $6) >>> 0 > $9 >>> 0 ? 2 : $0 ? 3 : 4;
  }
  $0 = $2;
  if ($14) {
   $13 = Math_fround(log(+($14 >>> 0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)
  } else {
   $13 = $18
  }
  HEAPF32[$0 >> 2] = $13;
  $0 = $2;
  if ($12) {
   $13 = Math_fround(log(+($12 >>> 0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)
  } else {
   $13 = $19
  }
  HEAPF32[$0 + 4 >> 2] = $13;
  $0 = $2;
  if ($9) {
   $18 = Math_fround(log(+($9 >>> 0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)
  }
  HEAPF32[$0 + 8 >> 2] = $18;
  $0 = $2;
  if ($5) {
   $19 = Math_fround(log(+($5 >>> 0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)
  }
  HEAPF32[$0 + 12 >> 2] = $19;
  if (!$6) {
   HEAPF32[$2 + 16 >> 2] = 0;
   return $16 | 0;
  }
  (wasm2js_i32$0 = $2, wasm2js_f32$0 = Math_fround(log(+($6 >>> 0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)), HEAPF32[wasm2js_i32$0 + 16 >> 2] = wasm2js_f32$0;
  return $16 | 0;
 }
 
 function FLAC__fixed_compute_best_predictor_wide($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = Math_fround(0), $19 = 0, $20 = 0, $21 = 0, $22 = Math_fround(0), $23 = Math_fround(0), wasm2js_i32$0 = 0, wasm2js_f32$0 = Math_fround(0);
  label$1 : {
   if (!$1) {
    break label$1
   }
   $5 = HEAP32[$0 - 4 >> 2];
   $7 = HEAP32[$0 - 8 >> 2];
   $9 = $5 - $7 | 0;
   $8 = HEAP32[$0 - 12 >> 2];
   $14 = $9 + ($8 - $7 | 0) | 0;
   $21 = $14 + (($8 << 1) - ($7 + HEAP32[$0 - 16 >> 2] | 0) | 0) | 0;
   $8 = 0;
   $7 = 0;
   while (1) {
    $4 = HEAP32[($20 << 2) + $0 >> 2];
    $3 = $4 >> 31;
    $6 = $3 ^ $4 + $3;
    $3 = $6 + $19 | 0;
    $16 = $3 >>> 0 < $6 >>> 0 ? $16 + 1 | 0 : $16;
    $19 = $3;
    $3 = $4 - $5 | 0;
    $6 = $3 >> 31;
    $5 = $6 ^ $3 + $6;
    $6 = $5 + $17 | 0;
    $11 = $5 >>> 0 > $6 >>> 0 ? $11 + 1 | 0 : $11;
    $17 = $6;
    $6 = $3 - $9 | 0;
    $5 = $6 >> 31;
    $9 = $5 ^ $5 + $6;
    $5 = $9 + $15 | 0;
    $10 = $5 >>> 0 < $9 >>> 0 ? $10 + 1 | 0 : $10;
    $15 = $5;
    $14 = $6 - $14 | 0;
    $5 = $14 >> 31;
    $9 = $5 ^ $5 + $14;
    $5 = $9 + $12 | 0;
    $7 = $5 >>> 0 < $9 >>> 0 ? $7 + 1 | 0 : $7;
    $12 = $5;
    $9 = $14 - $21 | 0;
    $5 = $9 >> 31;
    $9 = $5 ^ $5 + $9;
    $5 = $9 + $13 | 0;
    $8 = $5 >>> 0 < $9 >>> 0 ? $8 + 1 | 0 : $8;
    $13 = $5;
    $5 = $4;
    $9 = $3;
    $21 = $14;
    $14 = $6;
    $20 = $20 + 1 | 0;
    if (($20 | 0) != ($1 | 0)) {
     continue
    }
    break;
   };
  }
  $4 = ($10 | 0) == ($11 | 0) & $15 >>> 0 > $17 >>> 0 | $10 >>> 0 > $11 >>> 0;
  $3 = $4 ? $17 : $15;
  $0 = $3;
  $4 = $4 ? $11 : $10;
  $3 = ($7 | 0) == ($4 | 0) & $3 >>> 0 < $12 >>> 0 | $4 >>> 0 < $7 >>> 0;
  $6 = $3 ? $0 : $12;
  $4 = $3 ? $4 : $7;
  $3 = ($8 | 0) == ($4 | 0) & $6 >>> 0 < $13 >>> 0 | $4 >>> 0 < $8 >>> 0;
  $6 = $3 ? $6 : $13;
  $4 = $3 ? $4 : $8;
  $0 = 0;
  label$4 : {
   if (($4 | 0) == ($16 | 0) & $6 >>> 0 > $19 >>> 0 | $4 >>> 0 > $16 >>> 0) {
    break label$4
   }
   $4 = ($7 | 0) == ($10 | 0) & $12 >>> 0 > $15 >>> 0 | $7 >>> 0 > $10 >>> 0;
   $3 = $4 ? $15 : $12;
   $0 = $3;
   $4 = $4 ? $10 : $7;
   $3 = ($8 | 0) == ($4 | 0) & $3 >>> 0 < $13 >>> 0 | $4 >>> 0 < $8 >>> 0;
   $6 = $3 ? $0 : $13;
   $4 = $3 ? $4 : $8;
   $0 = 1;
   if (($4 | 0) == ($11 | 0) & $6 >>> 0 > $17 >>> 0 | $4 >>> 0 > $11 >>> 0) {
    break label$4
   }
   $0 = ($7 | 0) == ($8 | 0) & $12 >>> 0 < $13 >>> 0 | $7 >>> 0 < $8 >>> 0;
   $4 = $0;
   $3 = $4 ? $12 : $13;
   $0 = $4 ? $7 : $8;
   $0 = ($0 | 0) == ($10 | 0) & $3 >>> 0 > $15 >>> 0 | $0 >>> 0 > $10 >>> 0 ? 2 : $4 ? 3 : 4;
  }
  $3 = $2;
  if ($16 | $19) {
   $18 = Math_fround(log((+($19 >>> 0) + +($16 >>> 0) * 4294967296.0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)
  } else {
   $18 = $22
  }
  HEAPF32[$3 >> 2] = $18;
  $3 = $2;
  if ($11 | $17) {
   $18 = Math_fround(log((+($17 >>> 0) + +($11 >>> 0) * 4294967296.0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)
  } else {
   $18 = $23
  }
  HEAPF32[$3 + 4 >> 2] = $18;
  $3 = $2;
  if ($10 | $15) {
   $22 = Math_fround(log((+($15 >>> 0) + +($10 >>> 0) * 4294967296.0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)
  }
  HEAPF32[$3 + 8 >> 2] = $22;
  $3 = $2;
  if ($7 | $12) {
   $23 = Math_fround(log((+($12 >>> 0) + +($7 >>> 0) * 4294967296.0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)
  }
  HEAPF32[$3 + 12 >> 2] = $23;
  if (!($8 | $13)) {
   HEAPF32[$2 + 16 >> 2] = 0;
   return $0 | 0;
  }
  (wasm2js_i32$0 = $2, wasm2js_f32$0 = Math_fround(log((+($13 >>> 0) + +($8 >>> 0) * 4294967296.0) * .6931471805599453 / +($1 >>> 0)) / .6931471805599453)), HEAPF32[wasm2js_i32$0 + 16 >> 2] = wasm2js_f32$0;
  return $0 | 0;
 }
 
 function FLAC__stream_decoder_new() {
  var $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0;
  $3 = dlcalloc(1, 8);
  if ($3) {
   $2 = dlcalloc(1, 504);
   HEAP32[$3 >> 2] = $2;
   if ($2) {
    $1 = dlcalloc(1, 6160);
    HEAP32[$3 + 4 >> 2] = $1;
    if ($1) {
     $0 = dlcalloc(1, 44);
     HEAP32[$1 + 56 >> 2] = $0;
     if ($0) {
      HEAP32[$1 + 1128 >> 2] = 16;
      $4 = dlmalloc(HEAP32[1641] << 1 & -16);
      HEAP32[$1 + 1120 >> 2] = $4;
      if ($4) {
       HEAP32[$1 + 252 >> 2] = 0;
       HEAP32[$1 + 220 >> 2] = 0;
       HEAP32[$1 + 224 >> 2] = 0;
       $0 = $1 + 3616 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 3608 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 3600 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 3592 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 60 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 68 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 76 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 84 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 92 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 100 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 108 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 116 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($1 + 124 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($1 + 136 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($1 + 148 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($1 + 160 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($1 + 172 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($1 + 184 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($1 + 196 | 0);
       FLAC__format_entropy_coding_method_partitioned_rice_contents_init($1 + 208 | 0);
       HEAP32[$1 + 48 >> 2] = 0;
       HEAP32[$1 + 52 >> 2] = 0;
       memset($1 + 608 | 0, 512);
       HEAP32[$1 + 1124 >> 2] = 0;
       HEAP32[$1 + 608 >> 2] = 1;
       HEAP32[$1 + 32 >> 2] = 0;
       $0 = $1 + 24 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 16 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       $0 = $1 + 8 | 0;
       HEAP32[$0 >> 2] = 0;
       HEAP32[$0 + 4 >> 2] = 0;
       HEAP32[$1 >> 2] = 0;
       HEAP32[$1 + 4 >> 2] = 0;
       HEAP32[$2 + 28 >> 2] = 0;
       FLAC__ogg_decoder_aspect_set_defaults($2 + 32 | 0);
       HEAP32[$2 >> 2] = 9;
       return $3 | 0;
      }
      FLAC__bitreader_delete($0);
     }
     dlfree($1);
    }
    dlfree($2);
   }
   dlfree($3);
  }
  return 0;
 }
 
 function FLAC__stream_decoder_delete($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0;
  if ($0) {
   FLAC__stream_decoder_finish($0);
   $1 = HEAP32[$0 + 4 >> 2];
   $2 = HEAP32[$1 + 1120 >> 2];
   if ($2) {
    dlfree($2);
    $1 = HEAP32[$0 + 4 >> 2];
   }
   FLAC__bitreader_delete(HEAP32[$1 + 56 >> 2]);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 124 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 136 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 148 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 160 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 172 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 184 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 196 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 208 | 0);
   dlfree(HEAP32[$0 + 4 >> 2]);
   dlfree(HEAP32[$0 >> 2]);
   dlfree($0);
  }
 }
 
 function FLAC__stream_decoder_finish($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0;
  $3 = 1;
  if (HEAP32[HEAP32[$0 >> 2] >> 2] != 9) {
   $1 = HEAP32[$0 + 4 >> 2];
   FLAC__MD5Final($1 + 3732 | 0, $1 + 3636 | 0);
   dlfree(HEAP32[HEAP32[$0 + 4 >> 2] + 452 >> 2]);
   HEAP32[HEAP32[$0 + 4 >> 2] + 452 >> 2] = 0;
   $1 = HEAP32[$0 + 4 >> 2];
   HEAP32[$1 + 252 >> 2] = 0;
   $1 = HEAP32[$1 + 56 >> 2];
   $3 = HEAP32[$1 >> 2];
   if ($3) {
    dlfree($3)
   }
   HEAP32[$1 + 36 >> 2] = 0;
   HEAP32[$1 + 40 >> 2] = 0;
   HEAP32[$1 >> 2] = 0;
   HEAP32[$1 + 4 >> 2] = 0;
   $3 = $1 + 8 | 0;
   HEAP32[$3 >> 2] = 0;
   HEAP32[$3 + 4 >> 2] = 0;
   $1 = $1 + 16 | 0;
   HEAP32[$1 >> 2] = 0;
   HEAP32[$1 + 4 >> 2] = 0;
   $3 = $0 + 4 | 0;
   $1 = HEAP32[$0 + 4 >> 2];
   $2 = HEAP32[$1 + 60 >> 2];
   if ($2) {
    dlfree($2 - 16 | 0);
    HEAP32[HEAP32[$3 >> 2] + 60 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 3592 >> 2];
   if ($2) {
    dlfree($2);
    HEAP32[HEAP32[$3 >> 2] + 92 >> 2] = 0;
    HEAP32[HEAP32[$3 >> 2] + 3592 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 - -64 >> 2];
   if ($2) {
    dlfree($2 - 16 | 0);
    HEAP32[HEAP32[$3 >> 2] - -64 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 3596 >> 2];
   if ($2) {
    dlfree($2);
    HEAP32[HEAP32[$3 >> 2] + 96 >> 2] = 0;
    HEAP32[HEAP32[$3 >> 2] + 3596 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 68 >> 2];
   if ($2) {
    dlfree($2 - 16 | 0);
    HEAP32[HEAP32[$3 >> 2] + 68 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 3600 >> 2];
   if ($2) {
    dlfree($2);
    HEAP32[HEAP32[$3 >> 2] + 100 >> 2] = 0;
    HEAP32[HEAP32[$3 >> 2] + 3600 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 72 >> 2];
   if ($2) {
    dlfree($2 - 16 | 0);
    HEAP32[HEAP32[$3 >> 2] + 72 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 3604 >> 2];
   if ($2) {
    dlfree($2);
    HEAP32[HEAP32[$3 >> 2] + 104 >> 2] = 0;
    HEAP32[HEAP32[$3 >> 2] + 3604 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 76 >> 2];
   if ($2) {
    dlfree($2 - 16 | 0);
    HEAP32[HEAP32[$3 >> 2] + 76 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 3608 >> 2];
   if ($2) {
    dlfree($2);
    HEAP32[HEAP32[$3 >> 2] + 108 >> 2] = 0;
    HEAP32[HEAP32[$3 >> 2] + 3608 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 80 >> 2];
   if ($2) {
    dlfree($2 - 16 | 0);
    HEAP32[HEAP32[$3 >> 2] + 80 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 3612 >> 2];
   if ($2) {
    dlfree($2);
    HEAP32[HEAP32[$3 >> 2] + 112 >> 2] = 0;
    HEAP32[HEAP32[$3 >> 2] + 3612 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 84 >> 2];
   if ($2) {
    dlfree($2 - 16 | 0);
    HEAP32[HEAP32[$3 >> 2] + 84 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 3616 >> 2];
   if ($2) {
    dlfree($2);
    HEAP32[HEAP32[$3 >> 2] + 116 >> 2] = 0;
    HEAP32[HEAP32[$3 >> 2] + 3616 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 88 >> 2];
   if ($2) {
    dlfree($2 - 16 | 0);
    HEAP32[HEAP32[$3 >> 2] + 88 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   $2 = HEAP32[$1 + 3620 >> 2];
   if ($2) {
    dlfree($2);
    HEAP32[HEAP32[$3 >> 2] + 120 >> 2] = 0;
    HEAP32[HEAP32[$3 >> 2] + 3620 >> 2] = 0;
    $1 = HEAP32[$3 >> 2];
   }
   HEAP32[$1 + 220 >> 2] = 0;
   HEAP32[$1 + 224 >> 2] = 0;
   if (HEAP32[$1 >> 2]) {
    $2 = HEAP32[$0 >> 2] + 32 | 0;
    $1 = $2 + 368 | 0;
    if ($1) {
     $4 = HEAP32[$1 >> 2];
     if ($4) {
      dlfree($4)
     }
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     HEAP32[$1 + 24 >> 2] = 0;
     $4 = $1 + 16 | 0;
     HEAP32[$4 >> 2] = 0;
     HEAP32[$4 + 4 >> 2] = 0;
     $1 = $1 + 8 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
    }
    ogg_stream_clear($2 + 8 | 0);
    $1 = HEAP32[$0 + 4 >> 2];
   }
   $2 = HEAP32[$1 + 52 >> 2];
   if ($2) {
    if (HEAP32[1958] != ($2 | 0)) {
     fclose($2);
     $1 = HEAP32[$3 >> 2];
    }
    HEAP32[$1 + 52 >> 2] = 0;
   }
   $3 = 1;
   if (HEAP32[$1 + 3624 >> 2]) {
    $3 = !memcmp($1 + 312 | 0, $1 + 3732 | 0, 16)
   }
   HEAP32[$1 + 48 >> 2] = 0;
   HEAP32[$1 + 3632 >> 2] = 0;
   memset($1 + 608 | 0, 512);
   HEAP32[$1 + 32 >> 2] = 0;
   $2 = $1 + 24 | 0;
   HEAP32[$2 >> 2] = 0;
   HEAP32[$2 + 4 >> 2] = 0;
   $2 = $1 + 16 | 0;
   HEAP32[$2 >> 2] = 0;
   HEAP32[$2 + 4 >> 2] = 0;
   $2 = $1 + 8 | 0;
   HEAP32[$2 >> 2] = 0;
   HEAP32[$2 + 4 >> 2] = 0;
   HEAP32[$1 >> 2] = 0;
   HEAP32[$1 + 4 >> 2] = 0;
   $1 = HEAP32[$0 + 4 >> 2];
   HEAP32[$1 + 1124 >> 2] = 0;
   HEAP32[$1 + 608 >> 2] = 1;
   $1 = HEAP32[$0 >> 2];
   HEAP32[$1 + 28 >> 2] = 0;
   FLAC__ogg_decoder_aspect_set_defaults($1 + 32 | 0);
   HEAP32[HEAP32[$0 >> 2] >> 2] = 9;
  }
  return $3 | 0;
 }
 
 function FLAC__stream_decoder_init_stream($0, $1, $2, $3, $4, $5, $6, $7, $8, $9) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  $7 = $7 | 0;
  $8 = $8 | 0;
  $9 = $9 | 0;
  return init_stream_internal_($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, 0) | 0;
 }
 
 function init_stream_internal_($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10) {
  var $11 = 0, $12 = 0;
  label$1 : {
   $12 = HEAP32[$0 >> 2];
   $11 = 5;
   label$2 : {
    if (HEAP32[$12 >> 2] != 9) {
     break label$2
    }
    $11 = 2;
    if (!$8 | (!$1 | !$6) | (!$5 | (!$3 | !$4) ? $2 : 0)) {
     break label$2
    }
    $11 = HEAP32[$0 + 4 >> 2];
    HEAP32[$11 >> 2] = $10;
    if ($10) {
     $11 = 0;
     $10 = $12 + 32 | 0;
     if (!ogg_stream_init($10 + 8 | 0, HEAP32[$10 + 4 >> 2])) {
      $11 = $10 + 368 | 0;
      if ($11) {
       HEAP32[$11 >> 2] = 0;
       HEAP32[$11 + 4 >> 2] = 0;
       HEAP32[$11 + 24 >> 2] = 0;
       $12 = $11 + 16 | 0;
       HEAP32[$12 >> 2] = 0;
       HEAP32[$12 + 4 >> 2] = 0;
       $11 = $11 + 8 | 0;
       HEAP32[$11 >> 2] = 0;
       HEAP32[$11 + 4 >> 2] = 0;
      }
      HEAP32[$10 + 396 >> 2] = -1;
      HEAP32[$10 + 400 >> 2] = -1;
      HEAP32[$10 + 408 >> 2] = 0;
      HEAP32[$10 + 412 >> 2] = 0;
      HEAP32[$10 + 404 >> 2] = HEAP32[$10 >> 2];
      $11 = 1;
     }
     if (!$11) {
      break label$1
     }
     $11 = HEAP32[$0 + 4 >> 2];
    }
    FLAC__cpu_info($11 + 3524 | 0);
    $10 = HEAP32[$0 + 4 >> 2];
    HEAP32[$10 + 44 >> 2] = 5;
    HEAP32[$10 + 40 >> 2] = 6;
    HEAP32[$10 + 36 >> 2] = 5;
    $10 = HEAP32[$10 + 56 >> 2];
    HEAP32[$10 + 8 >> 2] = 0;
    HEAP32[$10 + 12 >> 2] = 0;
    HEAP32[$10 + 4 >> 2] = 2048;
    $11 = $10 + 16 | 0;
    HEAP32[$11 >> 2] = 0;
    HEAP32[$11 + 4 >> 2] = 0;
    $11 = dlmalloc(8192);
    HEAP32[$10 >> 2] = $11;
    $12 = 0;
    __inlined_func$FLAC__bitreader_init : {
     if (!$11) {
      break __inlined_func$FLAC__bitreader_init
     }
     HEAP32[$10 + 40 >> 2] = $0;
     HEAP32[$10 + 36 >> 2] = 7;
     $12 = 1;
    }
    if (!$12) {
     HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
     return 3;
    }
    $10 = HEAP32[$0 + 4 >> 2];
    HEAP32[$10 + 48 >> 2] = $9;
    HEAP32[$10 + 32 >> 2] = $8;
    HEAP32[$10 + 28 >> 2] = $7;
    HEAP32[$10 + 24 >> 2] = $6;
    HEAP32[$10 + 20 >> 2] = $5;
    HEAP32[$10 + 16 >> 2] = $4;
    HEAP32[$10 + 12 >> 2] = $3;
    HEAP32[$10 + 8 >> 2] = $2;
    HEAP32[$10 + 4 >> 2] = $1;
    HEAP32[$10 + 3520 >> 2] = 0;
    HEAP32[$10 + 248 >> 2] = 0;
    HEAP32[$10 + 240 >> 2] = 0;
    HEAP32[$10 + 244 >> 2] = 0;
    HEAP32[$10 + 228 >> 2] = 0;
    HEAP32[$10 + 232 >> 2] = 0;
    HEAP32[$10 + 3624 >> 2] = HEAP32[HEAP32[$0 >> 2] + 28 >> 2];
    HEAP32[$10 + 3628 >> 2] = 1;
    HEAP32[$10 + 3632 >> 2] = 0;
    $11 = FLAC__stream_decoder_reset($0) ? 0 : 3;
   }
   return $11;
  }
  HEAP32[HEAP32[$0 >> 2] + 4 >> 2] = 4;
  return 4;
 }
 
 function read_callback_($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      $4 = HEAP32[$2 + 4 >> 2];
      if (HEAP32[$4 >> 2]) {
       break label$4
      }
      $3 = HEAP32[$4 + 20 >> 2];
      if (!$3) {
       break label$4
      }
      if (!(FUNCTION_TABLE[$3 | 0]($2, HEAP32[$4 + 48 >> 2]) | 0)) {
       break label$4
      }
      HEAP32[$1 >> 2] = 0;
      break label$3;
     }
     $21 = 7;
     if (!HEAP32[$1 >> 2]) {
      break label$2
     }
     $4 = HEAP32[$2 + 4 >> 2];
     if (!!HEAP32[$4 + 3632 >> 2] & HEAPU32[$4 + 6152 >> 2] > 20) {
      break label$2
     }
     label$6 : {
      label$7 : {
       if (HEAP32[$4 >> 2]) {
        $12 = HEAP32[$2 >> 2] + 32 | 0;
        $19 = $0;
        $30 = $2;
        $31 = HEAP32[$4 + 48 >> 2];
        $4 = 0;
        $18 = __stack_pointer - 16 | 0;
        __stack_pointer = $18;
        $17 = $1;
        $20 = HEAP32[$1 >> 2];
        HEAP32[$1 >> 2] = 0;
        label$10 : {
         label$21 : {
          if (!$20) {
           break label$21
          }
          $22 = $12 + 416 | 0;
          $23 = $12 + 368 | 0;
          $26 = $12 + 8 | 0;
          $27 = $12 + 440 | 0;
          $32 = HEAP32[2714];
          $33 = HEAPU8[7824];
          while (1) {
           if (HEAP32[$12 + 408 >> 2]) {
            break label$21
           }
           label$43 : {
            if (HEAP32[$12 + 412 >> 2]) {
             if (HEAP32[$12 + 432 >> 2]) {
              $7 = HEAP32[$12 + 440 >> 2];
              $3 = HEAP32[$12 + 444 >> 2];
              $0 = $20 - $4 | 0;
              if ($3 >>> 0 <= $0 >>> 0) {
               $0 = __memcpy($19, $7, $3);
               HEAP32[$17 >> 2] = $3 + HEAP32[$17 >> 2];
               HEAP32[$12 + 432 >> 2] = 0;
               $19 = $0 + $3 | 0;
               break label$43;
              }
              $4 = __memcpy($19, $7, $0);
              HEAP32[$17 >> 2] = $0 + HEAP32[$17 >> 2];
              HEAP32[$12 + 440 >> 2] = $0 + HEAP32[$12 + 440 >> 2];
              HEAP32[$12 + 444 >> 2] = HEAP32[$12 + 444 >> 2] - $0;
              $19 = $0 + $4 | 0;
              break label$43;
             }
             $7 = $27;
             $0 = 0;
             $4 = $26;
             label$104 : {
              if (!$4) {
               break label$104
              }
              $8 = HEAP32[$4 >> 2];
              if (!$8) {
               break label$104
              }
              $6 = HEAP32[$4 + 36 >> 2];
              if (($6 | 0) >= HEAP32[$4 + 32 >> 2]) {
               break label$104
              }
              $0 = -1;
              $10 = HEAP32[$4 + 16 >> 2];
              $9 = HEAP32[$10 + ($6 << 2) >> 2];
              if (!($9 & 1024)) {
               $3 = $9 & 512;
               $0 = 255;
               $5 = $9 & 255;
               label$31 : {
                if (($5 | 0) != 255) {
                 $0 = $5;
                 break label$31;
                }
                while (1) {
                 $6 = $6 + 1 | 0;
                 $5 = HEAP32[($6 << 2) + $10 >> 2];
                 $3 = $5 & 512 ? 512 : $3;
                 $5 = $5 & 255;
                 $0 = $5 + $0 | 0;
                 if (($5 | 0) == 255) {
                  continue
                 }
                 break;
                };
               }
               label$65 : {
                if (!$7) {
                 $3 = HEAP32[$4 + 12 >> 2];
                 break label$65;
                }
                HEAP32[$7 + 8 >> 2] = $9 & 256;
                HEAP32[$7 + 12 >> 2] = $3;
                $3 = HEAP32[$4 + 12 >> 2];
                HEAP32[$7 >> 2] = $3 + $8;
                $5 = HEAP32[$4 + 348 >> 2];
                HEAP32[$7 + 24 >> 2] = HEAP32[$4 + 344 >> 2];
                HEAP32[$7 + 28 >> 2] = $5;
                $5 = HEAP32[$4 + 20 >> 2] + ($6 << 3) | 0;
                $9 = HEAP32[$5 + 4 >> 2];
                $5 = HEAP32[$5 >> 2];
                HEAP32[$7 + 4 >> 2] = $0;
                HEAP32[$7 + 16 >> 2] = $5;
                HEAP32[$7 + 20 >> 2] = $9;
               }
               HEAP32[$4 + 12 >> 2] = $0 + $3;
               $0 = 1;
              }
              HEAP32[$4 + 36 >> 2] = $6 + 1;
              $3 = HEAP32[$4 + 348 >> 2];
              $7 = $3 + 1 | 0;
              $5 = $3;
              $3 = HEAP32[$4 + 344 >> 2] + 1 | 0;
              $7 = $3 >>> 0 < 1 ? $7 : $5;
              HEAP32[$4 + 344 >> 2] = $3;
              HEAP32[$4 + 348 >> 2] = $7;
             }
             if (($0 | 0) >= 1) {
              HEAP32[$12 + 432 >> 2] = 1;
              $7 = HEAP32[$12 + 444 >> 2];
              if (($7 | 0) < 1) {
               break label$43
              }
              $3 = HEAP32[$27 >> 2];
              if (HEAPU8[$3 | 0] != ($33 | 0)) {
               break label$43
              }
              $4 = 3;
              if (($7 | 0) < 9) {
               break label$10
              }
              $0 = $32;
              if ((HEAPU8[$3 + 1 | 0] | HEAPU8[$3 + 2 | 0] << 8 | (HEAPU8[$3 + 3 | 0] << 16 | HEAPU8[$3 + 4 | 0] << 24)) != (HEAPU8[$0 | 0] | HEAPU8[$0 + 1 | 0] << 8 | (HEAPU8[$0 + 2 | 0] << 16 | HEAPU8[$0 + 3 | 0] << 24))) {
               break label$10
              }
              $0 = HEAPU8[$3 + 5 | 0];
              HEAP32[$12 + 396 >> 2] = $0;
              HEAP32[$12 + 400 >> 2] = HEAPU8[$3 + 6 | 0];
              if (($0 | 0) != 1) {
               $4 = 4;
               break label$10;
              }
              HEAP32[$12 + 444 >> 2] = $7 - 9;
              HEAP32[$12 + 440 >> 2] = $3 + 9;
              break label$43;
             }
             if ($0) {
              $4 = 2;
              break label$10;
             }
             HEAP32[$12 + 412 >> 2] = 0;
             break label$43;
            }
            $4 = $22;
            $0 = $23;
            __inlined_func$ogg_sync_pageout : {
             if (HEAP32[$0 + 4 >> 2] >= 0) {
              while (1) {
               $5 = $4;
               $3 = 0;
               $9 = 0;
               $15 = __stack_pointer - 16 | 0;
               __stack_pointer = $15;
               $7 = $0;
               label$11 : {
                if (HEAP32[$0 + 4 >> 2] < 0) {
                 break label$11
                }
                $6 = HEAP32[$7 + 12 >> 2];
                $14 = HEAP32[$7 + 8 >> 2] - $6 | 0;
                $6 = $6 + HEAP32[$7 >> 2] | 0;
                label$23 : {
                 $10 = HEAP32[$7 + 20 >> 2];
                 label$34 : {
                  if (!$10) {
                   if (($14 | 0) < 27) {
                    break label$11
                   }
                   if ((HEAPU8[$6 | 0] | HEAPU8[$6 + 1 | 0] << 8 | (HEAPU8[$6 + 2 | 0] << 16 | HEAPU8[$6 + 3 | 0] << 24)) != 1399285583) {
                    break label$34
                   }
                   $8 = HEAPU8[$6 + 26 | 0];
                   $10 = $8 + 27 | 0;
                   if (($10 | 0) > ($14 | 0)) {
                    break label$11
                   }
                   if ($8) {
                    $11 = HEAP32[$7 + 24 >> 2];
                    while (1) {
                     $11 = HEAPU8[($6 + $9 | 0) + 27 | 0] + $11 | 0;
                     HEAP32[$7 + 24 >> 2] = $11;
                     $9 = $9 + 1 | 0;
                     if ($9 >>> 0 < HEAPU8[$6 + 26 | 0]) {
                      continue
                     }
                     break;
                    };
                   }
                   HEAP32[$7 + 20 >> 2] = $10;
                  }
                  if ((HEAP32[$7 + 24 >> 2] + $10 | 0) > ($14 | 0)) {
                   break label$11
                  }
                  $13 = HEAPU8[$6 + 22 | 0] | HEAPU8[$6 + 23 | 0] << 8 | (HEAPU8[$6 + 24 | 0] << 16 | HEAPU8[$6 + 25 | 0] << 24);
                  HEAP32[$15 + 12 >> 2] = $13;
                  HEAP8[$6 + 22 | 0] = 0;
                  HEAP8[$6 + 23 | 0] = 0;
                  HEAP8[$6 + 24 | 0] = 0;
                  HEAP8[$6 + 25 | 0] = 0;
                  $16 = HEAP32[$7 + 24 >> 2];
                  $11 = HEAP32[$7 + 20 >> 2];
                  HEAP8[$6 + 22 | 0] = 0;
                  HEAP8[$6 + 23 | 0] = 0;
                  HEAP8[$6 + 24 | 0] = 0;
                  HEAP8[$6 + 25 | 0] = 0;
                  label$77 : {
                   if (($11 | 0) < 1) {
                    break label$77
                   }
                   $8 = $11 & 1;
                   label$8 : {
                    if (($11 | 0) == 1) {
                     $9 = 0;
                     break label$8;
                    }
                    $10 = $11 & -2;
                    $9 = 0;
                    while (1) {
                     $3 = HEAP32[((HEAPU8[$6 + $9 | 0] ^ $3 >>> 24) << 2) + 6800 >> 2] ^ $3 << 8;
                     $3 = HEAP32[((HEAPU8[$6 + ($9 | 1) | 0] ^ $3 >>> 24) << 2) + 6800 >> 2] ^ $3 << 8;
                     $9 = $9 + 2 | 0;
                     $10 = $10 - 2 | 0;
                     if ($10) {
                      continue
                     }
                     break;
                    };
                   }
                   if (!$8) {
                    break label$77
                   }
                   $3 = HEAP32[((HEAPU8[$6 + $9 | 0] ^ $3 >>> 24) << 2) + 6800 >> 2] ^ $3 << 8;
                  }
                  $8 = $6 + 22 | 0;
                  label$117 : {
                   if (($16 | 0) < 1) {
                    break label$117
                   }
                   $10 = $6 + $11 | 0;
                   $24 = $16 & 1;
                   label$12 : {
                    if (($16 | 0) == 1) {
                     $9 = 0;
                     break label$12;
                    }
                    $11 = $16 & -2;
                    $9 = 0;
                    while (1) {
                     $3 = HEAP32[((HEAPU8[$10 + $9 | 0] ^ $3 >>> 24) << 2) + 6800 >> 2] ^ $3 << 8;
                     $3 = HEAP32[((HEAPU8[$10 + ($9 | 1) | 0] ^ $3 >>> 24) << 2) + 6800 >> 2] ^ $3 << 8;
                     $9 = $9 + 2 | 0;
                     $11 = $11 - 2 | 0;
                     if ($11) {
                      continue
                     }
                     break;
                    };
                   }
                   if (!$24) {
                    break label$117
                   }
                   $3 = HEAP32[((HEAPU8[$10 + $9 | 0] ^ $3 >>> 24) << 2) + 6800 >> 2] ^ $3 << 8;
                  }
                  HEAP8[$6 + 22 | 0] = $3;
                  HEAP8[$6 + 23 | 0] = $3 >>> 8;
                  HEAP8[$6 + 24 | 0] = $3 >>> 16;
                  HEAP8[$6 + 25 | 0] = $3 >>> 24;
                  if (HEAP32[$15 + 12 >> 2] == (HEAPU8[$8 | 0] | HEAPU8[$8 + 1 | 0] << 8 | (HEAPU8[$8 + 2 | 0] << 16 | HEAPU8[$8 + 3 | 0] << 24))) {
                   break label$23
                  }
                  HEAP8[$8 | 0] = $13;
                  HEAP8[$8 + 1 | 0] = $13 >>> 8;
                  HEAP8[$8 + 2 | 0] = $13 >>> 16;
                  HEAP8[$8 + 3 | 0] = $13 >>> 24;
                 }
                 HEAP32[$7 + 20 >> 2] = 0;
                 HEAP32[$7 + 24 >> 2] = 0;
                 $5 = HEAP32[$7 >> 2];
                 $3 = $14 - 1 | 0;
                 $10 = ($3 | 0) != 0;
                 $8 = $6 + 1 | 0;
                 __inlined_func$memchr : {
                  label$13 : {
                   label$24 : {
                    label$35 : {
                     if (!($8 & 3) | !$3) {
                      break label$35
                     }
                     while (1) {
                      if (HEAPU8[$8 | 0] == 79) {
                       break label$24
                      }
                      $3 = $3 - 1 | 0;
                      $10 = ($3 | 0) != 0;
                      $8 = $8 + 1 | 0;
                      if (!($8 & 3)) {
                       break label$35
                      }
                      if ($3) {
                       continue
                      }
                      break;
                     };
                    }
                    if (!$10) {
                     break label$13
                    }
                   }
                   label$59 : {
                    if (HEAPU8[$8 | 0] == 79 | $3 >>> 0 < 4) {
                     break label$59
                    }
                    while (1) {
                     $9 = HEAP32[$8 >> 2] ^ 1330597711;
                     if (($9 ^ -1) & $9 - 16843009 & -2139062144) {
                      break label$59
                     }
                     $8 = $8 + 4 | 0;
                     $3 = $3 - 4 | 0;
                     if ($3 >>> 0 > 3) {
                      continue
                     }
                     break;
                    };
                   }
                   if (!$3) {
                    break label$13
                   }
                   while (1) {
                    $9 = $8;
                    if (HEAPU8[$8 | 0] == 79) {
                     break __inlined_func$memchr
                    }
                    $8 = $8 + 1 | 0;
                    $3 = $3 - 1 | 0;
                    if ($3) {
                     continue
                    }
                    break;
                   };
                  }
                  $9 = 0;
                 }
                 $3 = $9;
                 if (!$3) {
                  $3 = $5 + HEAP32[$7 + 8 >> 2] | 0
                 }
                 HEAP32[$7 + 12 >> 2] = $3 - $5;
                 $3 = $6 - $3 | 0;
                 break label$11;
                }
                $6 = HEAP32[$7 + 12 >> 2];
                label$16 : {
                 if (!$5) {
                  $8 = HEAP32[$7 + 24 >> 2];
                  $3 = HEAP32[$7 + 20 >> 2];
                  break label$16;
                 }
                 $9 = $6 + HEAP32[$7 >> 2] | 0;
                 HEAP32[$5 >> 2] = $9;
                 $3 = HEAP32[$7 + 20 >> 2];
                 HEAP32[$5 + 4 >> 2] = $3;
                 HEAP32[$5 + 8 >> 2] = $3 + $9;
                 $8 = HEAP32[$7 + 24 >> 2];
                 HEAP32[$5 + 12 >> 2] = $8;
                }
                HEAP32[$7 + 24 >> 2] = 0;
                HEAP32[$7 + 16 >> 2] = 0;
                HEAP32[$7 + 20 >> 2] = 0;
                $3 = $3 + $8 | 0;
                HEAP32[$7 + 12 >> 2] = $6 + $3;
               }
               __stack_pointer = $15 + 16 | 0;
               $5 = 1;
               if (($3 | 0) > 0) {
                break __inlined_func$ogg_sync_pageout
               }
               $5 = 0;
               if (!$3) {
                break __inlined_func$ogg_sync_pageout
               }
               if (HEAP32[$0 + 16 >> 2]) {
                continue
               }
               break;
              };
              HEAP32[$0 + 16 >> 2] = 1;
              $5 = -1;
             } else {
              $5 = 0
             }
            }
            $0 = $5;
            if (($0 | 0) >= 1) {
             if (HEAP32[$12 + 404 >> 2]) {
              $0 = HEAP32[$22 >> 2];
              $0 = HEAPU8[$0 + 14 | 0] | HEAPU8[$0 + 15 | 0] << 8 | (HEAPU8[$0 + 16 | 0] << 16 | HEAPU8[$0 + 17 | 0] << 24);
              HEAP32[$12 + 404 >> 2] = 0;
              HEAP32[$12 + 344 >> 2] = $0;
              HEAP32[$12 + 4 >> 2] = $0;
             }
             $0 = $22;
             $4 = -1;
             $5 = $26;
             __inlined_func$ogg_stream_pagein : {
              label$1310 : {
               if (!$5) {
                break label$1310
               }
               $3 = HEAP32[$5 >> 2];
               if (!$3) {
                break label$1310
               }
               $10 = HEAP32[$0 >> 2];
               $7 = HEAPU8[$10 + 5 | 0];
               $8 = HEAP32[$0 + 12 >> 2];
               $14 = HEAP32[$0 + 8 >> 2];
               $9 = HEAPU8[$10 + 26 | 0];
               $16 = HEAPU8[$10 + 18 | 0] | HEAPU8[$10 + 19 | 0] << 8 | (HEAPU8[$10 + 20 | 0] << 16 | HEAPU8[$10 + 21 | 0] << 24);
               $13 = HEAPU8[$10 + 14 | 0] | HEAPU8[$10 + 15 | 0] << 8 | (HEAPU8[$10 + 16 | 0] << 16 | HEAPU8[$10 + 17 | 0] << 24);
               $24 = HEAPU8[$10 + 6 | 0] | HEAPU8[$10 + 7 | 0] << 8 | (HEAPU8[$10 + 8 | 0] << 16 | HEAPU8[$10 + 9 | 0] << 24);
               $34 = HEAPU8[$10 + 10 | 0] | HEAPU8[$10 + 11 | 0] << 8 | (HEAPU8[$10 + 12 | 0] << 16 | HEAPU8[$10 + 13 | 0] << 24);
               $15 = HEAPU8[$10 + 4 | 0];
               $0 = HEAP32[$5 + 36 >> 2];
               $6 = HEAP32[$5 + 12 >> 2];
               if ($6) {
                $11 = HEAP32[$5 + 8 >> 2] - $6 | 0;
                HEAP32[$5 + 8 >> 2] = $11;
                if ($11) {
                 memmove($3, $3 + $6 | 0, $11)
                }
                HEAP32[$5 + 12 >> 2] = 0;
               }
               if ($0) {
                $11 = $5;
                $3 = HEAP32[$5 + 28 >> 2] - $0 | 0;
                if ($3) {
                 $6 = HEAP32[$5 + 16 >> 2];
                 memmove($6, $6 + ($0 << 2) | 0, $3 << 2);
                 $3 = HEAP32[$5 + 20 >> 2];
                 memmove($3, $3 + ($0 << 3) | 0, HEAP32[$5 + 28 >> 2] - $0 << 3);
                 $3 = HEAP32[$5 + 28 >> 2] - $0 | 0;
                } else {
                 $3 = 0
                }
                HEAP32[$11 + 28 >> 2] = $3;
                HEAP32[$5 + 36 >> 2] = 0;
                HEAP32[$5 + 32 >> 2] = HEAP32[$5 + 32 >> 2] - $0;
               }
               if ($15 | ($13 | 0) != HEAP32[$5 + 336 >> 2]) {
                break label$1310
               }
               if (_os_lacing_expand($5, $9 + 1 | 0)) {
                break label$1310
               }
               $25 = $7 & 1;
               $28 = HEAP32[$5 + 340 >> 2];
               label$64 : {
                if (($28 | 0) == ($16 | 0)) {
                 break label$64
                }
                $13 = HEAP32[$5 + 28 >> 2];
                $0 = HEAP32[$5 + 32 >> 2];
                if (($13 | 0) > ($0 | 0)) {
                 $35 = $13 + ($0 ^ -1) | 0;
                 $3 = HEAP32[$5 + 8 >> 2];
                 $15 = HEAP32[$5 + 16 >> 2];
                 $11 = $13 - $0 & 3;
                 label$811 : {
                  if (!$11) {
                   $4 = $0;
                   break label$811;
                  }
                  $6 = $0;
                  while (1) {
                   $3 = $3 - HEAPU8[$15 + ($6 << 2) | 0] | 0;
                   $4 = $6 + 1 | 0;
                   $6 = $4;
                   $11 = $11 - 1 | 0;
                   if ($11) {
                    continue
                   }
                   break;
                  };
                 }
                 if ($35 >>> 0 >= 3) {
                  while (1) {
                   $6 = $3;
                   $3 = $15 + ($4 << 2) | 0;
                   $3 = $6 - (((HEAPU8[$3 | 0] + HEAPU8[$3 + 4 | 0] | 0) + HEAPU8[$3 + 8 | 0] | 0) + HEAPU8[$3 + 12 | 0] | 0) | 0;
                   $4 = $4 + 4 | 0;
                   if (($13 | 0) != ($4 | 0)) {
                    continue
                   }
                   break;
                  }
                 }
                 HEAP32[$5 + 8 >> 2] = $3;
                }
                HEAP32[$5 + 28 >> 2] = $0;
                if (($28 | 0) == -1) {
                 break label$64
                }
                $4 = $0 + 1 | 0;
                HEAP32[$5 + 28 >> 2] = $4;
                HEAP32[HEAP32[$5 + 16 >> 2] + ($0 << 2) >> 2] = 1024;
                HEAP32[$5 + 32 >> 2] = $4;
               }
               $3 = $7 & 2;
               $4 = 0;
               label$136 : {
                if (!$25) {
                 break label$136
                }
                $0 = HEAP32[$5 + 28 >> 2];
                if (($0 | 0) >= 1 & HEAP32[(HEAP32[$5 + 16 >> 2] + ($0 << 2) | 0) - 4 >> 2] != 1024) {
                 break label$136
                }
                $3 = 0;
                if (!$9) {
                 break label$136
                }
                while (1) {
                 $4 = $3 + 1 | 0;
                 $0 = HEAPU8[($3 + $10 | 0) + 27 | 0];
                 $8 = $8 - $0 | 0;
                 $14 = $0 + $14 | 0;
                 if (($0 | 0) != 255) {
                  $3 = 0;
                  break label$136;
                 }
                 $3 = $4;
                 if (($9 | 0) != ($3 | 0)) {
                  continue
                 }
                 break;
                };
                $3 = 0;
                $4 = $9;
               }
               if ($8) {
                $6 = HEAP32[$5 + 8 >> 2];
                $0 = HEAP32[$5 + 4 >> 2];
                label$19 : {
                 if (($6 | 0) < ($0 - $8 | 0)) {
                  $11 = HEAP32[$5 >> 2];
                  break label$19;
                 }
                 if ((2147483647 - $8 | 0) < ($0 | 0)) {
                  ogg_stream_clear($5);
                  $4 = -1;
                  break __inlined_func$ogg_stream_pagein;
                 }
                 $0 = $0 + $8 | 0;
                 $0 = ($0 | 0) < 2147482623 ? $0 + 1024 | 0 : $0;
                 $11 = dlrealloc(HEAP32[$5 >> 2], $0);
                 if (!$11) {
                  ogg_stream_clear($5);
                  $4 = -1;
                  break __inlined_func$ogg_stream_pagein;
                 }
                 HEAP32[$5 >> 2] = $11;
                 HEAP32[$5 + 4 >> 2] = $0;
                 $6 = HEAP32[$5 + 8 >> 2];
                }
                __memcpy($6 + $11 | 0, $14, $8);
                HEAP32[$5 + 8 >> 2] = HEAP32[$5 + 8 >> 2] + $8;
               }
               $13 = $7 & 4;
               label$2314 : {
                if (($4 | 0) >= ($9 | 0)) {
                 break label$2314
                }
                $8 = HEAP32[$5 + 20 >> 2];
                $14 = HEAP32[$5 + 16 >> 2];
                $11 = HEAP32[$5 + 28 >> 2];
                $7 = $14 + ($11 << 2) | 0;
                $15 = $4 + $10 | 0;
                $0 = HEAPU8[$15 + 27 | 0];
                HEAP32[$7 >> 2] = $0;
                $6 = $8 + ($11 << 3) | 0;
                HEAP32[$6 >> 2] = -1;
                HEAP32[$6 + 4 >> 2] = -1;
                if ($3) {
                 HEAP32[$7 >> 2] = $0 | 256
                }
                $7 = $11 + 1 | 0;
                HEAP32[$5 + 28 >> 2] = $7;
                if (($0 | 0) == 255) {
                 $0 = -1
                } else {
                 HEAP32[$5 + 32 >> 2] = $7;
                 $0 = $11;
                }
                $6 = $4 + 1 | 0;
                label$27 : {
                 if (($9 | 0) == ($6 | 0)) {
                  break label$27
                 }
                 $25 = $9 - 2 | 0;
                 label$28 : {
                  if (!(($4 ^ -1) + $9 & 1)) {
                   $3 = $7;
                   break label$28;
                  }
                  $6 = HEAPU8[$15 + 28 | 0];
                  HEAP32[$14 + ($7 << 2) >> 2] = $6;
                  $3 = $8 + ($7 << 3) | 0;
                  HEAP32[$3 >> 2] = -1;
                  HEAP32[$3 + 4 >> 2] = -1;
                  $3 = $11 + 2 | 0;
                  HEAP32[$5 + 28 >> 2] = $3;
                  if (($6 | 0) != 255) {
                   HEAP32[$5 + 32 >> 2] = $3;
                   $0 = $7;
                  }
                  $6 = $4 + 2 | 0;
                 }
                 if (($4 | 0) == ($25 | 0)) {
                  break label$27
                 }
                 while (1) {
                  $7 = $6 + $10 | 0;
                  $11 = HEAPU8[$7 + 27 | 0];
                  HEAP32[$14 + ($3 << 2) >> 2] = $11;
                  $4 = $8 + ($3 << 3) | 0;
                  HEAP32[$4 >> 2] = -1;
                  HEAP32[$4 + 4 >> 2] = -1;
                  $4 = $3 + 1 | 0;
                  HEAP32[$5 + 28 >> 2] = $4;
                  if (($11 | 0) != 255) {
                   HEAP32[$5 + 32 >> 2] = $4;
                   $0 = $3;
                  }
                  $7 = HEAPU8[$7 + 28 | 0];
                  HEAP32[$14 + ($4 << 2) >> 2] = $7;
                  $11 = $8 + ($4 << 3) | 0;
                  HEAP32[$11 >> 2] = -1;
                  HEAP32[$11 + 4 >> 2] = -1;
                  $3 = $3 + 2 | 0;
                  HEAP32[$5 + 28 >> 2] = $3;
                  if (($7 | 0) != 255) {
                   HEAP32[$5 + 32 >> 2] = $3;
                   $0 = $4;
                  }
                  $6 = $6 + 2 | 0;
                  if (($9 | 0) != ($6 | 0)) {
                   continue
                  }
                  break;
                 };
                }
                if (($0 | 0) == -1) {
                 break label$2314
                }
                $0 = HEAP32[$5 + 20 >> 2] + ($0 << 3) | 0;
                HEAP32[$0 >> 2] = $24;
                HEAP32[$0 + 4 >> 2] = $34;
               }
               label$3415 : {
                if (!$13) {
                 break label$3415
                }
                HEAP32[$5 + 328 >> 2] = 1;
                $0 = HEAP32[$5 + 28 >> 2];
                if (($0 | 0) < 1) {
                 break label$3415
                }
                $0 = (HEAP32[$5 + 16 >> 2] + ($0 << 2) | 0) - 4 | 0;
                HEAP32[$0 >> 2] = HEAP32[$0 >> 2] | 512;
               }
               HEAP32[$5 + 340 >> 2] = $16 + 1;
               $4 = 0;
              }
             }
             if ($4) {
              break label$43
             }
             HEAP32[$12 + 432 >> 2] = 0;
             HEAP32[$12 + 412 >> 2] = 1;
             break label$43;
            }
            if ($0) {
             $4 = 2;
             break label$10;
            }
            $0 = $20 - HEAP32[$17 >> 2] | 0;
            $6 = $0 >>> 0 > 8192 ? $0 : 8192;
            $0 = $6;
            $3 = $23;
            $4 = HEAP32[$3 + 4 >> 2];
            __inlined_func$ogg_sync_buffer : {
             if (($4 | 0) >= 0) {
              $7 = HEAP32[$3 + 12 >> 2];
              if ($7) {
               $5 = HEAP32[$3 + 8 >> 2] - $7 | 0;
               HEAP32[$3 + 8 >> 2] = $5;
               if (($5 | 0) >= 1) {
                $4 = HEAP32[$3 >> 2];
                memmove($4, $4 + $7 | 0, $5);
                $4 = HEAP32[$3 + 4 >> 2];
               }
               HEAP32[$3 + 12 >> 2] = 0;
              }
              $5 = $4;
              $4 = HEAP32[$3 + 8 >> 2];
              label$4816 : {
               if (($0 | 0) <= ($5 - $4 | 0)) {
                $0 = HEAP32[$3 >> 2];
                break label$4816;
               }
               $4 = ($0 + $4 | 0) + 4096 | 0;
               $0 = HEAP32[$3 >> 2];
               label$69 : {
                if ($0) {
                 $0 = dlrealloc($0, $4);
                 break label$69;
                }
                $0 = dlmalloc($4);
               }
               if (!$0) {
                $0 = HEAP32[$3 >> 2];
                if ($0) {
                 dlfree($0)
                }
                HEAP32[$3 >> 2] = 0;
                HEAP32[$3 + 4 >> 2] = 0;
                HEAP32[$3 + 24 >> 2] = 0;
                $0 = $3 + 16 | 0;
                HEAP32[$0 >> 2] = 0;
                HEAP32[$0 + 4 >> 2] = 0;
                $0 = $3 + 8 | 0;
                HEAP32[$0 >> 2] = 0;
                HEAP32[$0 + 4 >> 2] = 0;
                $0 = 0;
                break __inlined_func$ogg_sync_buffer;
               }
               HEAP32[$3 + 4 >> 2] = $4;
               HEAP32[$3 >> 2] = $0;
               $4 = HEAP32[$3 + 8 >> 2];
              }
              $0 = $0 + $4 | 0;
             } else {
              $0 = 0
             }
            }
            if (!$0) {
             $4 = 7;
             break label$10;
            }
            HEAP32[$18 + 12 >> 2] = $6;
            label$15 : {
             label$1610 : {
              $4 = FUNCTION_TABLE[8]($30, $0, $18 + 12 | 0, $31) | 0;
              switch ($4 - 1 | 0) {
              case 4:
               break label$10;
              case 0:
               break label$1610;
              default:
               break label$15;
              };
             }
             HEAP32[$12 + 408 >> 2] = 1;
            }
            $3 = HEAP32[$18 + 12 >> 2];
            $4 = -1;
            $0 = $23;
            $7 = HEAP32[$0 + 4 >> 2];
            label$111 : {
             if (($7 | 0) < 0) {
              break label$111
             }
             $3 = HEAP32[$0 + 8 >> 2] + $3 | 0;
             if (($3 | 0) > ($7 | 0)) {
              break label$111
             }
             HEAP32[$0 + 8 >> 2] = $3;
             $4 = 0;
            }
            if (($4 | 0) > -1) {
             break label$43
            }
            $4 = 6;
            break label$10;
           }
           $4 = HEAP32[$17 >> 2];
           if ($4 >>> 0 < $20 >>> 0) {
            continue
           }
           break;
          };
         }
         $4 = !$4 & HEAP32[$12 + 408 >> 2] != 0;
        }
        __stack_pointer = $18 + 16 | 0;
        switch ($4 | 0) {
        case 1:
         break label$6;
        case 0:
        case 2:
         break label$7;
        default:
         break label$2;
        };
       }
       $29 = FUNCTION_TABLE[HEAP32[$4 + 4 >> 2]]($2, $0, $1, HEAP32[$4 + 48 >> 2]) | 0;
       if (($29 | 0) == 2) {
        break label$2
       }
      }
      $0 = 1;
      if (HEAP32[$1 >> 2]) {
       break label$1
      }
      $21 = 4;
      if (($29 | 0) == 1) {
       break label$2
      }
      $1 = HEAP32[$2 + 4 >> 2];
      if (HEAP32[$1 >> 2]) {
       break label$1
      }
      $4 = HEAP32[$1 + 20 >> 2];
      if (!$4) {
       break label$1
      }
      if (FUNCTION_TABLE[$4 | 0]($2, HEAP32[$1 + 48 >> 2]) | 0) {
       break label$2
      }
      break label$1;
     }
     $0 = 1;
     if (HEAP32[$1 >> 2]) {
      break label$1
     }
    }
    $21 = 4;
   }
   HEAP32[HEAP32[$2 >> 2] >> 2] = $21;
   $0 = 0;
  }
  return $0 | 0;
 }
 
 function FLAC__stream_decoder_reset($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0;
  $1 = HEAP32[$0 + 4 >> 2];
  label$1 : {
   if (!HEAP32[$1 + 3628 >> 2] & HEAP32[HEAP32[$0 >> 2] >> 2] == 9) {
    break label$1
   }
   HEAP32[$1 + 3624 >> 2] = 0;
   HEAP32[$1 + 240 >> 2] = 0;
   HEAP32[$1 + 244 >> 2] = 0;
   if (HEAP32[$1 >> 2]) {
    $1 = HEAP32[$0 >> 2] + 32 | 0;
    ogg_stream_reset($1 + 8 | 0);
    ogg_sync_reset($1 + 368 | 0);
    HEAP32[$1 + 408 >> 2] = 0;
    HEAP32[$1 + 412 >> 2] = 0;
    $1 = HEAP32[$0 + 4 >> 2];
   }
   $1 = HEAP32[$1 + 56 >> 2];
   HEAP32[$1 + 8 >> 2] = 0;
   HEAP32[$1 + 12 >> 2] = 0;
   $1 = $1 + 16 | 0;
   HEAP32[$1 >> 2] = 0;
   HEAP32[$1 + 4 >> 2] = 0;
   $1 = 1;
   $2 = HEAP32[$0 >> 2];
   HEAP32[$2 >> 2] = $1 ? 2 : 8;
   if (!$1) {
    break label$1
   }
   $1 = HEAP32[$0 + 4 >> 2];
   if (HEAP32[$1 >> 2]) {
    $1 = $2 + 32 | 0;
    ogg_stream_reset($1 + 8 | 0);
    ogg_sync_reset($1 + 368 | 0);
    HEAP32[$1 + 408 >> 2] = 0;
    HEAP32[$1 + 412 >> 2] = 0;
    if (HEAP32[$1 >> 2]) {
     HEAP32[$1 + 404 >> 2] = 1
    }
    $1 = HEAP32[$0 + 4 >> 2];
   }
   label$5 : {
    if (!HEAP32[$1 + 3628 >> 2]) {
     if (HEAP32[$1 + 52 >> 2] == HEAP32[1958]) {
      break label$1
     }
     $2 = HEAP32[$1 + 8 >> 2];
     if (!$2) {
      break label$5
     }
     if ((FUNCTION_TABLE[$2 | 0]($0, 0, 0, HEAP32[$1 + 48 >> 2]) | 0) == 1) {
      break label$1
     }
     $1 = HEAP32[$0 + 4 >> 2];
     break label$5;
    }
    HEAP32[$1 + 3628 >> 2] = 0;
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = 0;
   HEAP32[$1 + 248 >> 2] = 0;
   dlfree(HEAP32[$1 + 452 >> 2]);
   HEAP32[HEAP32[$0 + 4 >> 2] + 452 >> 2] = 0;
   $1 = HEAP32[$0 + 4 >> 2];
   HEAP32[$1 + 252 >> 2] = 0;
   HEAP32[$1 + 3624 >> 2] = HEAP32[HEAP32[$0 >> 2] + 28 >> 2];
   HEAP32[$1 + 228 >> 2] = 0;
   HEAP32[$1 + 232 >> 2] = 0;
   FLAC__MD5Init($1 + 3636 | 0);
   $0 = HEAP32[$0 + 4 >> 2];
   HEAP32[$0 + 6152 >> 2] = 0;
   HEAP32[$0 + 6136 >> 2] = 0;
   HEAP32[$0 + 6140 >> 2] = 0;
   $3 = 1;
  }
  return $3 | 0;
 }
 
 function FLAC__stream_decoder_init_ogg_stream($0, $1, $2, $3, $4, $5, $6, $7, $8, $9) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  $7 = $7 | 0;
  $8 = $8 | 0;
  $9 = $9 | 0;
  return init_stream_internal_($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, 1) | 0;
 }
 
 function FLAC__stream_decoder_set_ogg_serial_number($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $0 = HEAP32[$0 >> 2];
  if (HEAP32[$0 >> 2] == 9) {
   $0 = $0 + 32 | 0;
   HEAP32[$0 + 4 >> 2] = $1;
   HEAP32[$0 >> 2] = 0;
   $0 = 1;
  } else {
   $0 = 0
  }
  return $0 | 0;
 }
 
 function FLAC__stream_decoder_set_md5_checking($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $0 = HEAP32[$0 >> 2];
  if (HEAP32[$0 >> 2] == 9) {
   HEAP32[$0 + 28 >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_respond($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  label$1 : {
   if (HEAP32[HEAP32[$0 >> 2] >> 2] != 9 | $1 >>> 0 > 126) {
    break label$1
   }
   $2 = 1;
   $0 = HEAP32[$0 + 4 >> 2];
   HEAP32[($0 + ($1 << 2) | 0) + 608 >> 2] = 1;
   if (($1 | 0) != 2) {
    break label$1
   }
   HEAP32[$0 + 1124 >> 2] = 0;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_respond_application($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0;
  $2 = 0;
  label$1 : {
   if (HEAP32[HEAP32[$0 >> 2] >> 2] != 9) {
    break label$1
   }
   $3 = HEAP32[$0 + 4 >> 2];
   $2 = 1;
   if (HEAP32[$3 + 616 >> 2]) {
    break label$1
   }
   $2 = HEAP32[$3 + 1120 >> 2];
   label$2 : {
    $4 = HEAP32[$3 + 1124 >> 2];
    label$3 : {
     if (($4 | 0) != HEAP32[$3 + 1128 >> 2]) {
      $3 = $2;
      break label$3;
     }
     label$5 : {
      if (!$4) {
       $3 = dlrealloc($2, 0);
       break label$5;
      }
      if (($4 | 0) >= 0) {
       $3 = dlrealloc($2, $4 << 1);
       if ($3) {
        break label$5
       }
       dlfree($2);
       $3 = HEAP32[$0 + 4 >> 2];
      }
      HEAP32[$3 + 1120 >> 2] = 0;
      break label$2;
     }
     $2 = HEAP32[$0 + 4 >> 2];
     HEAP32[$2 + 1120 >> 2] = $3;
     if (!$3) {
      break label$2
     }
     HEAP32[$2 + 1128 >> 2] = HEAP32[$2 + 1128 >> 2] << 1;
     $4 = HEAP32[$2 + 1124 >> 2];
    }
    $2 = HEAP32[1641] >>> 3 | 0;
    __memcpy(Math_imul($2, $4) + $3 | 0, $1, $2);
    $0 = HEAP32[$0 + 4 >> 2];
    HEAP32[$0 + 1124 >> 2] = HEAP32[$0 + 1124 >> 2] + 1;
    return 1;
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
   $2 = 0;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_respond_all($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0;
  if (HEAP32[HEAP32[$0 >> 2] >> 2] == 9) {
   $3 = HEAP32[$0 + 4 >> 2];
   $0 = $3 + 608 | 0;
   while (1) {
    $1 = $2 << 2;
    HEAP32[$1 + $0 >> 2] = 1;
    HEAP32[$0 + ($1 | 4) >> 2] = 1;
    HEAP32[$0 + ($1 | 8) >> 2] = 1;
    HEAP32[$0 + ($1 | 12) >> 2] = 1;
    HEAP32[$0 + ($1 | 16) >> 2] = 1;
    HEAP32[$0 + ($1 | 20) >> 2] = 1;
    HEAP32[$0 + ($1 | 24) >> 2] = 1;
    HEAP32[$0 + ($1 | 28) >> 2] = 1;
    $2 = $2 + 8 | 0;
    if (($2 | 0) != 128) {
     continue
    }
    break;
   };
   HEAP32[$3 + 1124 >> 2] = 0;
   $1 = 1;
  }
  return $1 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_ignore($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  label$1 : {
   if (HEAP32[HEAP32[$0 >> 2] >> 2] != 9 | $1 >>> 0 > 126) {
    break label$1
   }
   $0 = HEAP32[$0 + 4 >> 2];
   HEAP32[($0 + ($1 << 2) | 0) + 608 >> 2] = 0;
   $2 = 1;
   if (($1 | 0) != 2) {
    break label$1
   }
   HEAP32[$0 + 1124 >> 2] = 0;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_set_metadata_ignore_application($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0;
  if (HEAP32[HEAP32[$0 >> 2] >> 2] == 9) {
   $2 = HEAP32[$0 + 4 >> 2];
   if (!HEAP32[$2 + 616 >> 2]) {
    return 1
   }
   $3 = HEAP32[$2 + 1120 >> 2];
   label$3 : {
    $4 = HEAP32[$2 + 1124 >> 2];
    label$4 : {
     if (($4 | 0) != HEAP32[$2 + 1128 >> 2]) {
      $2 = $3;
      break label$4;
     }
     label$6 : {
      if (!$4) {
       $2 = dlrealloc($3, 0);
       break label$6;
      }
      if (($4 | 0) >= 0) {
       $2 = dlrealloc($3, $4 << 1);
       if ($2) {
        break label$6
       }
       dlfree($3);
       $2 = HEAP32[$0 + 4 >> 2];
      }
      HEAP32[$2 + 1120 >> 2] = 0;
      break label$3;
     }
     $3 = HEAP32[$0 + 4 >> 2];
     HEAP32[$3 + 1120 >> 2] = $2;
     if (!$2) {
      break label$3
     }
     HEAP32[$3 + 1128 >> 2] = HEAP32[$3 + 1128 >> 2] << 1;
     $4 = HEAP32[$3 + 1124 >> 2];
    }
    $3 = HEAP32[1641] >>> 3 | 0;
    __memcpy(Math_imul($3, $4) + $2 | 0, $1, $3);
    $0 = HEAP32[$0 + 4 >> 2];
    HEAP32[$0 + 1124 >> 2] = HEAP32[$0 + 1124 >> 2] + 1;
    return 1;
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
  }
  return 0;
 }
 
 function FLAC__stream_decoder_set_metadata_ignore_all($0) {
  $0 = $0 | 0;
  var $1 = 0;
  if (HEAP32[HEAP32[$0 >> 2] >> 2] == 9) {
   memset(HEAP32[$0 + 4 >> 2] + 608 | 0, 512);
   HEAP32[HEAP32[$0 + 4 >> 2] + 1124 >> 2] = 0;
   $1 = 1;
  }
  return $1 | 0;
 }
 
 function FLAC__stream_decoder_get_state($0) {
  $0 = $0 | 0;
  return HEAP32[HEAP32[$0 >> 2] >> 2];
 }
 
 function FLAC__stream_decoder_get_md5_checking($0) {
  $0 = $0 | 0;
  return HEAP32[HEAP32[$0 >> 2] + 28 >> 2];
 }
 
 function FLAC__stream_decoder_process_single($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  $2 = 1;
  label$1 : {
   while (1) {
    label$2 : {
     label$4 : {
      switch (HEAP32[HEAP32[$0 >> 2] >> 2]) {
      case 0:
       if (find_metadata_($0)) {
        continue
       }
       $2 = 0;
       break label$2;
      case 1:
       $3 = (read_metadata_($0) | 0) != 0;
       break label$1;
      case 2:
       if (frame_sync_($0)) {
        continue
       }
       break label$2;
      case 4:
      case 7:
       break label$2;
      case 3:
       break label$4;
      default:
       break label$1;
      };
     }
     if (!read_frame_($0, $1 + 12 | 0)) {
      $2 = 0;
      break label$2;
     }
     if (!HEAP32[$1 + 12 >> 2]) {
      continue
     }
    }
    break;
   };
   $3 = $2;
  }
  __stack_pointer = $1 + 16 | 0;
  return $3 | 0;
 }
 
 function find_metadata_($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  $6 = 1;
  label$1 : {
   while (1) {
    $4 = 0;
    label$3 : {
     while (1) {
      $5 = HEAP32[$0 + 4 >> 2];
      label$5 : {
       if (HEAP32[$5 + 3520 >> 2]) {
        $3 = HEAPU8[$5 + 3590 | 0];
        HEAP32[$1 + 8 >> 2] = $3;
        HEAP32[$5 + 3520 >> 2] = 0;
        break label$5;
       }
       if (!FLAC__bitreader_read_raw_uint32(HEAP32[$5 + 56 >> 2], $1 + 8 | 0, 8)) {
        $2 = 0;
        break label$1;
       }
       $3 = HEAP32[$1 + 8 >> 2];
      }
      if (($3 | 0) == HEAPU8[$2 + 6517 | 0]) {
       $2 = $2 + 1 | 0;
       $3 = 1;
       break label$3;
      }
      $2 = 0;
      if (($4 | 0) == 3) {
       break label$1
      }
      if (($3 | 0) == HEAPU8[$4 + 7836 | 0]) {
       $4 = $4 + 1 | 0;
       if (($4 | 0) != 3) {
        continue
       }
       label$10 : {
        label$11 : {
         if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $1 + 12 | 0, 24)) {
          break label$11
         }
         if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $1 + 12 | 0, 8)) {
          break label$11
         }
         $3 = HEAP32[$1 + 12 >> 2];
         if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $1 + 12 | 0, 8)) {
          break label$11
         }
         $5 = HEAP32[$1 + 12 >> 2];
         if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $1 + 12 | 0, 8)) {
          break label$11
         }
         $7 = HEAP32[$1 + 12 >> 2];
         if (FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $1 + 12 | 0, 8)) {
          break label$10
         }
        }
        break label$1;
       }
       if (FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], HEAP32[$1 + 12 >> 2] & 127 | ($7 << 7 & 16256 | ($5 & 127 | $3 << 7 & 16256) << 14))) {
        continue
       }
       break label$1;
      }
      break;
     };
     label$12 : {
      if (($3 | 0) != 255) {
       break label$12
      }
      HEAP8[HEAP32[$0 + 4 >> 2] + 3588 | 0] = 255;
      if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $1 + 8 | 0, 8)) {
       break label$1
      }
      $2 = HEAP32[$1 + 8 >> 2];
      if (($2 | 0) == 255) {
       $2 = HEAP32[$0 + 4 >> 2];
       HEAP32[$2 + 3520 >> 2] = 1;
       HEAP8[$2 + 3590 | 0] = 255;
       break label$12;
      }
      if (($2 & -2) != 248) {
       break label$12
      }
      HEAP8[HEAP32[$0 + 4 >> 2] + 3589 | 0] = $2;
      HEAP32[HEAP32[$0 >> 2] >> 2] = 3;
      $2 = 1;
      break label$1;
     }
     $2 = 0;
     $3 = 0;
     if (!$6) {
      break label$3
     }
     $4 = HEAP32[$0 + 4 >> 2];
     $3 = 0;
     if (HEAP32[$4 + 3632 >> 2]) {
      break label$3
     }
     FUNCTION_TABLE[HEAP32[$4 + 32 >> 2]]($0, 0, HEAP32[$4 + 48 >> 2]);
     $3 = 0;
    }
    $6 = $3;
    if ($2 >>> 0 < 4) {
     continue
    }
    break;
   };
   $2 = 1;
   HEAP32[HEAP32[$0 >> 2] >> 2] = 1;
  }
  __stack_pointer = $1 + 16 | 0;
  return $2;
 }
 
 function read_metadata_($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0;
  $4 = __stack_pointer - 192 | 0;
  __stack_pointer = $4;
  label$1 : {
   label$2 : {
    if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $4 + 184 | 0, HEAP32[1668])) {
     break label$2
    }
    $20 = HEAP32[$4 + 184 >> 2];
    $8 = $0 + 4 | 0;
    if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $4 + 180 | 0, HEAP32[1669])) {
     break label$1
    }
    if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $4 + 176 | 0, HEAP32[1670])) {
     break label$1
    }
    $3 = ($20 | 0) != 0;
    label$3 : {
     label$4 : {
      label$5 : {
       label$6 : {
        label$7 : {
         $1 = HEAP32[$4 + 180 >> 2];
         switch ($1 | 0) {
         case 3:
          break label$6;
         case 0:
          break label$7;
         default:
          break label$5;
         };
        }
        $17 = HEAP32[$4 + 176 >> 2];
        $1 = HEAP32[$8 >> 2];
        HEAP32[$1 + 256 >> 2] = 0;
        HEAP32[$1 + 264 >> 2] = $17;
        HEAP32[$1 + 260 >> 2] = $3;
        $18 = HEAP32[1633];
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[$1 + 56 >> 2], $4, $18)) {
         break label$1
        }
        HEAP32[HEAP32[$8 >> 2] + 272 >> 2] = HEAP32[$4 >> 2];
        $7 = HEAP32[1634];
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $4, $7)) {
         break label$1
        }
        HEAP32[HEAP32[$8 >> 2] + 276 >> 2] = HEAP32[$4 >> 2];
        $5 = HEAP32[1635];
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $4, $5)) {
         break label$1
        }
        HEAP32[HEAP32[$8 >> 2] + 280 >> 2] = HEAP32[$4 >> 2];
        $11 = HEAP32[1636];
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $4, $11)) {
         break label$1
        }
        HEAP32[HEAP32[$8 >> 2] + 284 >> 2] = HEAP32[$4 >> 2];
        $10 = HEAP32[1637];
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $4, $10)) {
         break label$1
        }
        HEAP32[HEAP32[$8 >> 2] + 288 >> 2] = HEAP32[$4 >> 2];
        $9 = HEAP32[1638];
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $4, $9)) {
         break label$1
        }
        HEAP32[HEAP32[$8 >> 2] + 292 >> 2] = HEAP32[$4 >> 2] + 1;
        $6 = HEAP32[1639];
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $4, $6)) {
         break label$1
        }
        HEAP32[HEAP32[$8 >> 2] + 296 >> 2] = HEAP32[$4 >> 2] + 1;
        $1 = HEAP32[$8 >> 2];
        $3 = HEAP32[1640];
        if (!FLAC__bitreader_read_raw_uint64(HEAP32[$1 + 56 >> 2], $1 + 304 | 0, $3)) {
         break label$1
        }
        $1 = HEAP32[$8 >> 2];
        if (!FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[$1 + 56 >> 2], $1 + 312 | 0, 16)) {
         break label$1
        }
        if (!FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[HEAP32[$8 >> 2] + 56 >> 2], $17 - (($3 + ((($10 + ($11 + ($5 + ($7 + $18 | 0) | 0) | 0) | 0) + $9 | 0) + $6 | 0) | 0) + 128 >>> 3 | 0) | 0)) {
         break label$2
        }
        $2 = HEAP32[$8 >> 2];
        HEAP32[$2 + 248 >> 2] = 1;
        if (!memcmp($2 + 312 | 0, 7839, 16)) {
         HEAP32[$2 + 3624 >> 2] = 0
        }
        if (HEAP32[$2 + 3632 >> 2] | !HEAP32[$2 + 608 >> 2]) {
         break label$4
        }
        $1 = HEAP32[$2 + 28 >> 2];
        if (!$1) {
         break label$4
        }
        FUNCTION_TABLE[$1 | 0]($0, $2 + 256 | 0, HEAP32[$2 + 48 >> 2]);
        break label$4;
       }
       $1 = HEAP32[$8 >> 2];
       HEAP32[$1 + 252 >> 2] = 0;
       $5 = HEAP32[$4 + 176 >> 2];
       HEAP32[$1 + 448 >> 2] = ($5 >>> 0) / 18;
       HEAP32[$1 + 440 >> 2] = $5;
       HEAP32[$1 + 436 >> 2] = $3;
       HEAP32[$1 + 432 >> 2] = 3;
       $2 = HEAP32[$8 >> 2];
       $3 = HEAP32[$2 + 452 >> 2];
       $1 = HEAP32[$2 + 448 >> 2];
       label$9 : {
        if ($1) {
         if ($1 >>> 0 <= 178956970) {
          $1 = dlrealloc($3, Math_imul($1, 24));
          if ($1) {
           HEAP32[HEAP32[$8 >> 2] + 452 >> 2] = $1;
           break label$9;
          }
          dlfree($3);
          $2 = HEAP32[$8 >> 2];
         }
         HEAP32[$2 + 452 >> 2] = 0;
         break label$3;
        }
        $1 = dlrealloc($3, 0);
        HEAP32[HEAP32[$8 >> 2] + 452 >> 2] = $1;
        if (!$1) {
         break label$3
        }
       }
       $2 = HEAP32[$8 >> 2];
       if (HEAP32[$2 + 448 >> 2]) {
        $10 = HEAP32[1644];
        $9 = HEAP32[1643];
        $6 = HEAP32[1642];
        while (1) {
         if (!FLAC__bitreader_read_raw_uint64(HEAP32[$2 + 56 >> 2], $4, $6)) {
          break label$2
         }
         $3 = HEAP32[$4 + 4 >> 2];
         $11 = Math_imul($7, 24);
         $2 = HEAP32[$8 >> 2];
         $1 = $11 + HEAP32[$2 + 452 >> 2] | 0;
         HEAP32[$1 >> 2] = HEAP32[$4 >> 2];
         HEAP32[$1 + 4 >> 2] = $3;
         if (!FLAC__bitreader_read_raw_uint64(HEAP32[$2 + 56 >> 2], $4, $9)) {
          break label$2
         }
         $3 = HEAP32[$4 + 4 >> 2];
         $2 = HEAP32[$8 >> 2];
         $1 = $11 + HEAP32[$2 + 452 >> 2] | 0;
         HEAP32[$1 + 8 >> 2] = HEAP32[$4 >> 2];
         HEAP32[$1 + 12 >> 2] = $3;
         if (!FLAC__bitreader_read_raw_uint32(HEAP32[$2 + 56 >> 2], $4 + 188 | 0, $10)) {
          break label$2
         }
         $2 = HEAP32[$8 >> 2];
         HEAP32[($11 + HEAP32[$2 + 452 >> 2] | 0) + 16 >> 2] = HEAP32[$4 + 188 >> 2];
         $7 = $7 + 1 | 0;
         $1 = HEAP32[$2 + 448 >> 2];
         if ($7 >>> 0 < $1 >>> 0) {
          continue
         }
         break;
        };
        $1 = Math_imul($1, -18);
       } else {
        $1 = 0
       }
       $1 = $1 + $5 | 0;
       if ($1) {
        if (!FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[$2 + 56 >> 2], $1)) {
         break label$2
        }
        $2 = HEAP32[$8 >> 2];
       }
       HEAP32[$2 + 252 >> 2] = 1;
       if (HEAP32[$2 + 3632 >> 2] | !HEAP32[$2 + 620 >> 2]) {
        break label$4
       }
       $1 = HEAP32[$2 + 28 >> 2];
       if (!$1) {
        break label$4
       }
       FUNCTION_TABLE[$1 | 0]($0, $2 + 432 | 0, HEAP32[$2 + 48 >> 2]);
       break label$4;
      }
      $5 = HEAP32[$8 >> 2];
      $10 = HEAP32[($5 + ($1 << 2) | 0) + 608 >> 2];
      $2 = HEAP32[$4 + 176 >> 2];
      memset($4 + 8 | 0, 168);
      HEAP32[$4 + 8 >> 2] = $2;
      HEAP32[$4 >> 2] = $1;
      HEAP32[$4 + 4 >> 2] = $3;
      label$16 : {
       label$17 : {
        label$18 : {
         if (($1 | 0) != 2) {
          break label$18
         }
         $1 = $4 + 16 | 0;
         $3 = HEAP32[1641] >>> 3 | 0;
         if (!FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[$5 + 56 >> 2], $1, $3)) {
          break label$2
         }
         if ($2 >>> 0 < $3 >>> 0) {
          HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
          $2 = 0;
          break label$1;
         }
         $2 = $2 - $3 | 0;
         $5 = HEAP32[$8 >> 2];
         if (!HEAP32[$5 + 1124 >> 2]) {
          break label$18
         }
         $3 = HEAP32[$0 + 4 >> 2];
         $6 = HEAP32[$3 + 1124 >> 2];
         $7 = 0;
         __inlined_func$has_id_filtered_ : {
          if (!$6) {
           break __inlined_func$has_id_filtered_
          }
          $9 = HEAP32[1641] >>> 3 | 0;
          $3 = HEAP32[$3 + 1120 >> 2];
          label$20 : {
           while (1) {
            if (!memcmp(Math_imul($9, $11) + $3 | 0, $1, $9)) {
             break label$20
            }
            $11 = $11 + 1 | 0;
            if (($6 | 0) != ($11 | 0)) {
             continue
            }
            break;
           };
           $7 = 0;
           break __inlined_func$has_id_filtered_;
          }
          $7 = 1;
         }
         if (!$7 ^ ($10 | 0) != 0) {
          break label$17
         }
         break label$16;
        }
        if ($10) {
         break label$16
        }
       }
       if (!FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[$5 + 56 >> 2], $2)) {
        break label$2
       }
       break label$4;
      }
      label$202 : {
       label$21 : {
        label$22 : {
         label$23 : {
          switch (HEAP32[$4 + 180 >> 2]) {
          case 1:
           if (FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[$5 + 56 >> 2], $2)) {
            break label$21
           }
           $5 = 1;
           break label$202;
          case 2:
           if (!$2) {
            break label$22
           }
           $1 = dlmalloc($2);
           HEAP32[$4 + 20 >> 2] = $1;
           if (!$1) {
            HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
            $5 = 1;
            break label$202;
           }
           if (FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[$5 + 56 >> 2], $1, $2)) {
            break label$21
           }
           $5 = 1;
           break label$202;
          case 4:
           $1 = $0;
           $7 = $4 + 16 | 0;
           $5 = 0;
           __inlined_func$read_metadata_vorbiscomment_ : {
            folding_inner0 : {
             label$13 : {
              label$29 : {
               label$310 : {
                label$411 : {
                 if ($2 >>> 0 < 8) {
                  break label$411
                 }
                 if (!FLAC__bitreader_read_uint32_little_endian(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $7)) {
                  break label$310
                 }
                 $2 = $2 - 8 | 0;
                 $6 = HEAP32[$7 >> 2];
                 label$512 : {
                  if ($6) {
                   if ($2 >>> 0 < $6 >>> 0) {
                    HEAP32[$7 >> 2] = 0;
                    HEAP32[$7 + 4 >> 2] = 0;
                    break label$411;
                   }
                   if (($6 | 0) == -1) {
                    HEAP32[$7 + 4 >> 2] = 0;
                    break folding_inner0;
                   }
                   $3 = dlmalloc($6 + 1 | 0);
                   HEAP32[$7 + 4 >> 2] = $3;
                   if (!$3) {
                    break folding_inner0
                   }
                   if (!FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $3, $6)) {
                    break label$310
                   }
                   $2 = $2 - $6 | 0;
                   HEAP8[HEAP32[$7 + 4 >> 2] + HEAP32[$7 >> 2] | 0] = 0;
                   break label$512;
                  }
                  HEAP32[$7 + 4 >> 2] = 0;
                 }
                 $11 = $7 + 8 | 0;
                 if (!FLAC__bitreader_read_uint32_little_endian(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $11)) {
                  break label$310
                 }
                 $3 = HEAP32[$11 >> 2];
                 if ($3 >>> 0 >= 100001) {
                  HEAP32[$11 >> 2] = 0;
                  $5 = 0;
                  break __inlined_func$read_metadata_vorbiscomment_;
                 }
                 if (!$3) {
                  break label$411
                 }
                 $3 = safe_malloc_mul_2op_p($3, 8);
                 HEAP32[$7 + 12 >> 2] = $3;
                 if (!$3) {
                  break label$29
                 }
                 if (!HEAP32[$11 >> 2]) {
                  break label$411
                 }
                 HEAP32[$3 >> 2] = 0;
                 HEAP32[$3 + 4 >> 2] = 0;
                 label$12 : {
                  if ($2 >>> 0 < 4) {
                   break label$12
                  }
                  while (1) {
                   if (!FLAC__bitreader_read_uint32_little_endian(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $3)) {
                    break label$13
                   }
                   $2 = $2 - 4 | 0;
                   $9 = $5 << 3;
                   $3 = HEAP32[$7 + 12 >> 2];
                   $6 = $9 + $3 | 0;
                   $10 = HEAP32[$6 >> 2];
                   label$1414 : {
                    if ($10) {
                     if ($2 >>> 0 < $10 >>> 0) {
                      break label$12
                     }
                     label$1615 : {
                      label$1716 : {
                       if (($10 | 0) == -1) {
                        HEAP32[($3 + ($5 << 3) | 0) + 4 >> 2] = 0;
                        break label$1716;
                       }
                       $3 = dlmalloc($10 + 1 | 0);
                       HEAP32[$6 + 4 >> 2] = $3;
                       if ($3) {
                        break label$1615
                       }
                      }
                      HEAP32[HEAP32[$1 >> 2] >> 2] = 8;
                      break label$13;
                     }
                     $2 = $2 - $10 | 0;
                     memset($3, $10);
                     $6 = FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], HEAP32[$6 + 4 >> 2], HEAP32[$6 >> 2]);
                     $3 = HEAP32[$7 + 12 >> 2] + $9 | 0;
                     $9 = HEAP32[$3 + 4 >> 2];
                     if (!$6) {
                      dlfree($9);
                      HEAP32[(HEAP32[$7 + 12 >> 2] + ($5 << 3) | 0) + 4 >> 2] = 0;
                      HEAP32[$7 + 8 >> 2] = $5;
                      break label$411;
                     }
                     HEAP8[$9 + HEAP32[$3 >> 2] | 0] = 0;
                     break label$1414;
                    }
                    HEAP32[$6 + 4 >> 2] = 0;
                   }
                   $5 = $5 + 1 | 0;
                   if ($5 >>> 0 >= HEAPU32[$11 >> 2]) {
                    break label$411
                   }
                   $3 = HEAP32[$7 + 12 >> 2] + ($5 << 3) | 0;
                   HEAP32[$3 >> 2] = 0;
                   HEAP32[$3 + 4 >> 2] = 0;
                   if ($2 >>> 0 >= 4) {
                    continue
                   }
                   break;
                  };
                 }
                 HEAP32[$11 >> 2] = $5;
                }
                label$2017 : {
                 if (!$2) {
                  break label$2017
                 }
                 if (!HEAP32[$7 + 8 >> 2]) {
                  dlfree(HEAP32[$7 + 12 >> 2]);
                  HEAP32[$7 + 12 >> 2] = 0;
                 }
                 if (FLAC__bitreader_skip_byte_block_aligned_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $2)) {
                  break label$2017
                 }
                 $5 = 0;
                 break __inlined_func$read_metadata_vorbiscomment_;
                }
                $5 = 1;
               }
               break __inlined_func$read_metadata_vorbiscomment_;
              }
              HEAP32[$11 >> 2] = 0;
              break folding_inner0;
             }
             HEAP32[$11 >> 2] = $5;
             $5 = 0;
             break __inlined_func$read_metadata_vorbiscomment_;
            }
            HEAP32[HEAP32[$1 >> 2] >> 2] = 8;
            $5 = 0;
           }
           if ($5) {
            break label$21
           }
           $5 = 1;
           break label$202;
          case 5:
           $12 = __stack_pointer - 16 | 0;
           __stack_pointer = $12;
           $15 = memset($4 + 16 | 0, 160);
           $1 = $0;
           label$118 : {
            if (!FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $15, HEAP32[1655] >>> 3 | 0)) {
             break label$118
            }
            if (!FLAC__bitreader_read_raw_uint64(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $15 + 136 | 0, HEAP32[1656])) {
             break label$118
            }
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $12 + 12 | 0, HEAP32[1657])) {
             break label$118
            }
            HEAP32[$15 + 144 >> 2] = HEAP32[$12 + 12 >> 2] != 0;
            if (!FLAC__bitreader_skip_bits_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], HEAP32[1658])) {
             break label$118
            }
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $12 + 12 | 0, HEAP32[1659])) {
             break label$118
            }
            $2 = HEAP32[$12 + 12 >> 2];
            HEAP32[$15 + 148 >> 2] = $2;
            if (!$2) {
             $14 = 1;
             break label$118;
            }
            $14 = dlcalloc($2, 32);
            HEAP32[$15 + 152 >> 2] = $14;
            label$319 : {
             label$420 : {
              if (!$14) {
               break label$420
              }
              $21 = HEAP32[1648];
              if (!FLAC__bitreader_read_raw_uint64(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $14, $21)) {
               break label$319
              }
              $17 = HEAP32[1650] >>> 3 | 0;
              $18 = HEAP32[1647];
              $7 = HEAP32[1646];
              $22 = HEAP32[1645];
              $5 = HEAP32[1654];
              $11 = HEAP32[1653];
              $10 = HEAP32[1652];
              $9 = HEAP32[1651];
              $6 = HEAP32[1649];
              while (1) {
               if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $12 + 12 | 0, $6)) {
                break label$319
               }
               $13 = ($19 << 5) + $14 | 0;
               HEAP8[$13 + 8 | 0] = HEAP32[$12 + 12 >> 2];
               if (!FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $13 + 9 | 0, $17)) {
                break label$319
               }
               if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $12 + 12 | 0, $9)) {
                break label$319
               }
               HEAP8[$13 + 22 | 0] = HEAPU8[$13 + 22 | 0] & 254 | HEAP8[$12 + 12 | 0] & 1;
               if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $12 + 12 | 0, $10)) {
                break label$319
               }
               $2 = $13 + 22 | 0;
               HEAP8[$2 | 0] = HEAPU8[$12 + 12 | 0] << 1 & 2 | HEAPU8[$2 | 0] & 253;
               if (!FLAC__bitreader_skip_bits_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $11)) {
                break label$319
               }
               if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $12 + 12 | 0, $5)) {
                break label$319
               }
               $2 = HEAP32[$12 + 12 >> 2];
               HEAP8[$13 + 23 | 0] = $2;
               label$622 : {
                $2 = $2 & 255;
                if (!$2) {
                 break label$622
                }
                $16 = dlcalloc($2, 16);
                HEAP32[$13 + 24 >> 2] = $16;
                if (!$16) {
                 break label$420
                }
                $3 = $13 + 23 | 0;
                if (!HEAPU8[$3 | 0]) {
                 break label$622
                }
                $14 = 0;
                if (!FLAC__bitreader_read_raw_uint64(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $16, $22)) {
                 break label$118
                }
                $2 = $13 + 24 | 0;
                $13 = 0;
                while (1) {
                 if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $12 + 12 | 0, $7)) {
                  break label$118
                 }
                 HEAP8[(($13 << 4) + $16 | 0) + 8 | 0] = HEAP32[$12 + 12 >> 2];
                 if (!FLAC__bitreader_skip_bits_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $18)) {
                  break label$118
                 }
                 $13 = $13 + 1 | 0;
                 if ($13 >>> 0 >= HEAPU8[$3 | 0]) {
                  break label$622
                 }
                 $16 = HEAP32[$2 >> 2];
                 if (FLAC__bitreader_read_raw_uint64(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $16 + ($13 << 4) | 0, $22)) {
                  continue
                 }
                 break;
                };
                break label$118;
               }
               $14 = 1;
               $19 = $19 + 1 | 0;
               if ($19 >>> 0 >= HEAPU32[$15 + 148 >> 2]) {
                break label$118
               }
               $14 = HEAP32[$15 + 152 >> 2];
               if (FLAC__bitreader_read_raw_uint64(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $14 + ($19 << 5) | 0, $21)) {
                continue
               }
               break;
              };
              break label$319;
             }
             HEAP32[HEAP32[$1 >> 2] >> 2] = 8;
            }
            $14 = 0;
           }
           __stack_pointer = $12 + 16 | 0;
           if ($14) {
            break label$21
           }
           $5 = 1;
           break label$202;
          case 6:
           $10 = $4 + 16 | 0;
           $3 = 0;
           $9 = __stack_pointer - 16 | 0;
           __stack_pointer = $9;
           $1 = $0;
           label$124 : {
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $9 + 12 | 0, HEAP32[1660])) {
             break label$124
            }
            HEAP32[$10 >> 2] = HEAP32[$9 + 12 >> 2];
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $9 + 12 | 0, HEAP32[1661])) {
             break label$124
            }
            label$225 : {
             $2 = HEAP32[$9 + 12 >> 2];
             label$326 : {
              if (($2 | 0) == -1) {
               HEAP32[$10 + 4 >> 2] = 0;
               break label$326;
              }
              $6 = dlmalloc($2 + 1 | 0);
              HEAP32[$10 + 4 >> 2] = $6;
              if ($6) {
               break label$225
              }
             }
             HEAP32[HEAP32[$1 >> 2] >> 2] = 8;
             break label$124;
            }
            if ($2) {
             if (!FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $6, $2)) {
              break label$124
             }
             $6 = HEAP32[$10 + 4 >> 2];
             $2 = HEAP32[$9 + 12 >> 2];
            } else {
             $2 = 0
            }
            HEAP8[$2 + $6 | 0] = 0;
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $9 + 12 | 0, HEAP32[1662])) {
             break label$124
            }
            label$827 : {
             $2 = HEAP32[$9 + 12 >> 2];
             label$928 : {
              if (($2 | 0) == -1) {
               HEAP32[$10 + 8 >> 2] = 0;
               break label$928;
              }
              $6 = dlmalloc($2 + 1 | 0);
              HEAP32[$10 + 8 >> 2] = $6;
              if ($6) {
               break label$827
              }
             }
             HEAP32[HEAP32[$1 >> 2] >> 2] = 8;
             break label$124;
            }
            if ($2) {
             if (!FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $6, $2)) {
              break label$124
             }
             $6 = HEAP32[$10 + 8 >> 2];
             $2 = HEAP32[$9 + 12 >> 2];
            } else {
             $2 = 0
            }
            HEAP8[$2 + $6 | 0] = 0;
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $10 + 12 | 0, HEAP32[1663])) {
             break label$124
            }
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $10 + 16 | 0, HEAP32[1664])) {
             break label$124
            }
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $10 + 20 | 0, HEAP32[1665])) {
             break label$124
            }
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $10 + 24 | 0, HEAP32[1666])) {
             break label$124
            }
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $10 + 28 | 0, HEAP32[1667])) {
             break label$124
            }
            $6 = HEAP32[$10 + 28 >> 2];
            $2 = dlmalloc($6 ? $6 : 1);
            HEAP32[$10 + 32 >> 2] = $2;
            if (!$2) {
             HEAP32[HEAP32[$1 >> 2] >> 2] = 8;
             break label$124;
            }
            if ($6) {
             if (!FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[HEAP32[$1 + 4 >> 2] + 56 >> 2], $2, $6)) {
              break label$124
             }
            }
            $3 = 1;
           }
           __stack_pointer = $9 + 16 | 0;
           if ($3) {
            break label$21
           }
           $5 = 1;
           break label$202;
          case 0:
          case 3:
           break label$21;
          default:
           break label$23;
          };
         }
         label$30 : {
          if ($2) {
           $1 = dlmalloc($2);
           HEAP32[$4 + 16 >> 2] = $1;
           if ($1) {
            break label$30
           }
           HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
           $5 = 1;
           break label$202;
          }
          HEAP32[$4 + 16 >> 2] = 0;
          break label$21;
         }
         if (FLAC__bitreader_read_byte_block_aligned_no_crc(HEAP32[$5 + 56 >> 2], $1, $2)) {
          break label$21
         }
         $5 = 1;
         break label$202;
        }
        HEAP32[$4 + 20 >> 2] = 0;
       }
       $5 = 0;
       $2 = HEAP32[$8 >> 2];
       if (HEAP32[$2 + 3632 >> 2]) {
        break label$202
       }
       $1 = HEAP32[$2 + 28 >> 2];
       if (!$1) {
        break label$202
       }
       FUNCTION_TABLE[$1 | 0]($0, $4, HEAP32[$2 + 48 >> 2]);
      }
      label$32 : {
       label$33 : {
        switch (HEAP32[$4 + 180 >> 2] - 1 | 0) {
        case 1:
         $1 = HEAP32[$4 + 20 >> 2];
         if (!$1) {
          break label$32
         }
         dlfree($1);
         break label$32;
        case 3:
         $1 = HEAP32[$4 + 20 >> 2];
         if ($1) {
          dlfree($1)
         }
         $7 = HEAP32[$4 + 24 >> 2];
         if ($7) {
          $2 = 0;
          while (1) {
           $1 = HEAP32[(HEAP32[$4 + 28 >> 2] + ($2 << 3) | 0) + 4 >> 2];
           if ($1) {
            dlfree($1);
            $7 = HEAP32[$4 + 24 >> 2];
           }
           $2 = $2 + 1 | 0;
           if ($7 >>> 0 > $2 >>> 0) {
            continue
           }
           break;
          };
         }
         $1 = HEAP32[$4 + 28 >> 2];
         if (!$1) {
          break label$32
         }
         dlfree($1);
         break label$32;
        case 4:
         $7 = HEAP32[$4 + 164 >> 2];
         if ($7) {
          $2 = 0;
          while (1) {
           $1 = HEAP32[(HEAP32[$4 + 168 >> 2] + ($2 << 5) | 0) + 24 >> 2];
           if ($1) {
            dlfree($1);
            $7 = HEAP32[$4 + 164 >> 2];
           }
           $2 = $2 + 1 | 0;
           if ($7 >>> 0 > $2 >>> 0) {
            continue
           }
           break;
          };
         }
         $1 = HEAP32[$4 + 168 >> 2];
         if (!$1) {
          break label$32
         }
         dlfree($1);
         break label$32;
        case 5:
         $1 = HEAP32[$4 + 20 >> 2];
         if ($1) {
          dlfree($1)
         }
         $1 = HEAP32[$4 + 24 >> 2];
         if ($1) {
          dlfree($1)
         }
         $1 = HEAP32[$4 + 48 >> 2];
         if (!$1) {
          break label$32
         }
         dlfree($1);
         break label$32;
        case 0:
         break label$32;
        default:
         break label$33;
        };
       }
       $1 = HEAP32[$4 + 16 >> 2];
       if (!$1) {
        break label$32
       }
       dlfree($1);
      }
      if ($5) {
       break label$2
      }
     }
     $2 = 1;
     if (!$20) {
      break label$1
     }
     label$47 : {
      label$48 : {
       $3 = HEAP32[$8 >> 2];
       if (HEAP32[$3 >> 2]) {
        break label$48
       }
       $1 = HEAP32[$3 + 12 >> 2];
       if (!$1) {
        break label$48
       }
       $9 = $3 + 6136 | 0;
       if (FUNCTION_TABLE[$1 | 0]($0, $9, HEAP32[$3 + 48 >> 2]) | 0) {
        break label$48
       }
       if (!FLAC__bitreader_is_consumed_byte_aligned(HEAP32[HEAP32[$8 >> 2] + 56 >> 2])) {
        break label$48
       }
       $1 = HEAP32[HEAP32[$8 >> 2] + 56 >> 2];
       $6 = ((HEAP32[$1 + 8 >> 2] - HEAP32[$1 + 16 >> 2] << 5) + (HEAP32[$1 + 12 >> 2] << 3) | 0) - HEAP32[$1 + 20 >> 2] >>> 3 | 0;
       $3 = HEAP32[$9 >> 2];
       $1 = HEAP32[$9 + 4 >> 2] - ($6 >>> 0 > $3 >>> 0) | 0;
       HEAP32[$9 >> 2] = $3 - $6;
       HEAP32[$9 + 4 >> 2] = $1;
       break label$47;
      }
      $1 = HEAP32[$8 >> 2];
      HEAP32[$1 + 6136 >> 2] = 0;
      HEAP32[$1 + 6140 >> 2] = 0;
     }
     HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
     break label$1;
    }
    HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
   }
   $2 = 0;
  }
  __stack_pointer = $4 + 192 | 0;
  return $2;
 }
 
 function frame_sync_($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  $5 = __stack_pointer - 16 | 0;
  __stack_pointer = $5;
  label$1 : {
   label$2 : {
    $1 = HEAP32[$0 + 4 >> 2];
    label$3 : {
     if (!HEAP32[$1 + 248 >> 2]) {
      break label$3
     }
     $2 = $1 + 304 | 0;
     $3 = HEAP32[$2 + 4 >> 2];
     $6 = HEAP32[$2 >> 2];
     if (!($3 | $6)) {
      break label$3
     }
     $2 = 4;
     $4 = HEAP32[$1 + 244 >> 2];
     if (($3 | 0) == ($4 | 0) & HEAPU32[$1 + 240 >> 2] >= $6 >>> 0 | $3 >>> 0 < $4 >>> 0) {
      break label$2
     }
    }
    label$4 : {
     if (FLAC__bitreader_is_consumed_byte_aligned(HEAP32[$1 + 56 >> 2])) {
      break label$4
     }
     $3 = HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2];
     if (FLAC__bitreader_read_raw_uint32($3, $5 + 12 | 0, FLAC__bitreader_bits_left_for_byte_alignment($3))) {
      break label$4
     }
     $4 = 0;
     break label$1;
    }
    $3 = 0;
    while (1) {
     $1 = HEAP32[$0 + 4 >> 2];
     label$6 : {
      if (HEAP32[$1 + 3520 >> 2]) {
       $2 = HEAPU8[$1 + 3590 | 0];
       HEAP32[$5 + 12 >> 2] = $2;
       HEAP32[$1 + 3520 >> 2] = 0;
       break label$6;
      }
      $4 = 0;
      if (!FLAC__bitreader_read_raw_uint32(HEAP32[$1 + 56 >> 2], $5 + 12 | 0, 8)) {
       break label$1
      }
      $2 = HEAP32[$5 + 12 >> 2];
     }
     label$9 : {
      if (($2 | 0) != 255) {
       break label$9
      }
      HEAP8[HEAP32[$0 + 4 >> 2] + 3588 | 0] = 255;
      $4 = 0;
      if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $5 + 12 | 0, 8)) {
       break label$1
      }
      $1 = HEAP32[$5 + 12 >> 2];
      if (($1 | 0) == 255) {
       $1 = HEAP32[$0 + 4 >> 2];
       HEAP32[$1 + 3520 >> 2] = 1;
       HEAP8[$1 + 3590 | 0] = 255;
       break label$9;
      }
      if (($1 & -2) != 248) {
       break label$9
      }
      HEAP8[HEAP32[$0 + 4 >> 2] + 3589 | 0] = $1;
      $2 = 3;
      break label$2;
     }
     $1 = $3;
     $3 = 1;
     if ($1) {
      continue
     }
     $1 = HEAP32[$0 + 4 >> 2];
     if (HEAP32[$1 + 3632 >> 2]) {
      continue
     }
     FUNCTION_TABLE[HEAP32[$1 + 32 >> 2]]($0, 0, HEAP32[$1 + 48 >> 2]);
     continue;
    };
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = $2;
   $4 = 1;
  }
  $0 = $4;
  __stack_pointer = $5 + 16 | 0;
  return $0;
 }
 
 function read_frame_($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $8 = __stack_pointer - 48 | 0;
  __stack_pointer = $8;
  HEAP32[$1 >> 2] = 0;
  $4 = HEAP32[$0 + 4 >> 2];
  $5 = HEAPU16[(HEAPU8[$4 + 3588 | 0] << 1) + 1280 >> 1];
  $2 = HEAP32[$4 + 56 >> 2];
  HEAP32[$2 + 24 >> 2] = HEAPU16[((HEAPU8[$4 + 3589 | 0] ^ $5 >>> 8) << 1) + 1280 >> 1] ^ $5 << 8 & 65280;
  $4 = HEAP32[$2 + 20 >> 2];
  HEAP32[$2 + 28 >> 2] = HEAP32[$2 + 16 >> 2];
  HEAP32[$2 + 32 >> 2] = $4;
  $2 = HEAP32[$0 + 4 >> 2];
  HEAP8[$8 + 16 | 0] = HEAPU8[$2 + 3588 | 0];
  $4 = HEAPU8[$2 + 3589 | 0];
  HEAP32[$8 + 12 >> 2] = 2;
  HEAP8[$8 + 17 | 0] = $4;
  label$1 : {
   if (!FLAC__bitreader_read_raw_uint32(HEAP32[$2 + 56 >> 2], $8 + 44 | 0, 8)) {
    break label$1
   }
   $6 = $0 + 4 | 0;
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       $2 = HEAP32[$8 + 44 >> 2];
       if (($2 | 0) == 255) {
        break label$5
       }
       HEAP8[$8 + 18 | 0] = $2;
       HEAP32[$8 + 12 >> 2] = 3;
       if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$6 >> 2] + 56 >> 2], $8 + 44 | 0, 8)) {
        break label$3
       }
       $5 = HEAP32[$8 + 44 >> 2];
       if (($5 | 0) == 255) {
        break label$5
       }
       $2 = $4 >>> 1 & 1;
       $3 = HEAP32[$8 + 12 >> 2];
       HEAP8[$3 + ($8 + 16 | 0) | 0] = $5;
       $4 = 1;
       HEAP32[$8 + 12 >> 2] = $3 + 1;
       label$6 : {
        label$7 : {
         label$8 : {
          label$9 : {
           label$10 : {
            label$11 : {
             $5 = HEAPU8[$8 + 18 | 0];
             $7 = $5 >>> 4 | 0;
             switch ($7 - 1 | 0) {
             case 1:
             case 2:
             case 3:
             case 4:
              break label$10;
             case 7:
             case 8:
             case 9:
             case 10:
             case 11:
             case 12:
             case 13:
             case 14:
              break label$11;
             case 5:
             case 6:
              break label$7;
             case 0:
              break label$9;
             default:
              break label$6;
             };
            }
            HEAP32[HEAP32[$6 >> 2] + 1136 >> 2] = 256 << $7 - 8;
            break label$8;
           }
           HEAP32[HEAP32[$6 >> 2] + 1136 >> 2] = 576 << $7 - 2;
           break label$8;
          }
          HEAP32[HEAP32[$6 >> 2] + 1136 >> 2] = 192;
         }
         $7 = 0;
        }
        $4 = $2;
       }
       $15 = $5 & 15;
       HEAP32[$8 + 44 >> 2] = $15;
       label$12 : {
        label$13 : {
         label$14 : {
          label$15 : {
           label$16 : {
            switch ($15 - 1 | 0) {
            default:
             $3 = HEAP32[$6 >> 2];
             if (HEAP32[$3 + 248 >> 2]) {
              break label$15
             }
             $4 = 1;
             break label$13;
            case 0:
             $3 = HEAP32[$6 >> 2];
             $2 = 88200;
             break label$14;
            case 1:
             $3 = HEAP32[$6 >> 2];
             $2 = 176400;
             break label$14;
            case 2:
             $3 = HEAP32[$6 >> 2];
             $2 = 192e3;
             break label$14;
            case 3:
             $3 = HEAP32[$6 >> 2];
             $2 = 8e3;
             break label$14;
            case 4:
             $3 = HEAP32[$6 >> 2];
             $2 = 16e3;
             break label$14;
            case 5:
             $3 = HEAP32[$6 >> 2];
             $2 = 22050;
             break label$14;
            case 6:
             $3 = HEAP32[$6 >> 2];
             $2 = 24e3;
             break label$14;
            case 7:
             $3 = HEAP32[$6 >> 2];
             $2 = 32e3;
             break label$14;
            case 8:
             $3 = HEAP32[$6 >> 2];
             $2 = 44100;
             break label$14;
            case 9:
             $3 = HEAP32[$6 >> 2];
             $2 = 48e3;
             break label$14;
            case 10:
             $3 = HEAP32[$6 >> 2];
             $2 = 96e3;
             break label$14;
            case 11:
            case 12:
            case 13:
             break label$12;
            case 14:
             break label$16;
            };
           }
           $2 = HEAP32[$6 >> 2];
           if (!HEAP32[$2 + 3632 >> 2]) {
            FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 1, HEAP32[$2 + 48 >> 2])
           }
           $3 = HEAP32[$0 >> 2];
           HEAP32[$3 >> 2] = 2;
           break label$4;
          }
          $2 = HEAP32[$3 + 288 >> 2];
         }
         HEAP32[$3 + 1140 >> 2] = $2;
        }
        $15 = 0;
       }
       $16 = HEAPU8[$8 + 19 | 0];
       $5 = $16 >>> 4 | 0;
       label$30 : {
        label$31 : {
         if ($5 & 8) {
          $3 = HEAP32[$6 >> 2];
          HEAP32[$3 + 1144 >> 2] = 2;
          $2 = 1;
          label$33 : {
           switch ($5 & 7) {
           case 1:
            $2 = 2;
            break label$31;
           case 0:
            break label$31;
           case 2:
            break label$33;
           default:
            break label$30;
           };
          }
          $2 = 3;
          break label$31;
         }
         $3 = HEAP32[$6 >> 2];
         HEAP32[$3 + 1144 >> 2] = $5 + 1;
         $2 = 0;
        }
        HEAP32[$3 + 1148 >> 2] = $2;
        $2 = $4;
       }
       $9 = $16 >>> 1 & 7;
       HEAP32[$8 + 44 >> 2] = $9;
       $4 = 8;
       $5 = 1;
       label$35 : {
        label$36 : {
         label$37 : {
          switch ($9 - 1 | 0) {
          default:
           if (!HEAP32[$3 + 248 >> 2]) {
            break label$35
           }
           $4 = HEAP32[$3 + 296 >> 2];
           break label$36;
          case 1:
           $4 = 12;
           break label$36;
          case 3:
           $4 = 16;
           break label$36;
          case 4:
           $4 = 20;
           break label$36;
          case 2:
          case 6:
           break label$35;
          case 0:
           break label$36;
          case 5:
           break label$37;
          };
         }
         $4 = 24;
        }
        HEAP32[$3 + 1152 >> 2] = $4;
        $5 = $2;
       }
       label$42 : {
        if (!(!(HEAP8[$8 + 17 | 0] & 1) & (!HEAP32[$3 + 248 >> 2] | HEAP32[$3 + 272 >> 2] == HEAP32[$3 + 276 >> 2]))) {
         $12 = $8 + 32 | 0;
         $10 = $8 + 16 | 0;
         $11 = $8 + 12 | 0;
         $9 = __stack_pointer - 16 | 0;
         __stack_pointer = $9;
         $14 = HEAP32[$3 + 56 >> 2];
         label$110 : {
          if (!FLAC__bitreader_read_raw_uint32($14, $9 + 12 | 0, 8)) {
           break label$110
          }
          $2 = HEAP32[$9 + 12 >> 2];
          if ($10) {
           $4 = HEAP32[$11 >> 2];
           HEAP32[$11 >> 2] = $4 + 1;
           HEAP8[$4 + $10 | 0] = $2;
          }
          label$311 : {
           if ($2 & 128) {
            label$512 : {
             if (!(!($2 & 192) | $2 & 32)) {
              $4 = $2 & 31;
              $2 = 1;
              break label$512;
             }
             if (!(!($2 & 224) | $2 & 16)) {
              $4 = $2 & 15;
              $2 = 2;
              break label$512;
             }
             if (!(!($2 & 240) | $2 & 8)) {
              $4 = $2 & 7;
              $2 = 3;
              break label$512;
             }
             if (!(!($2 & 248) | $2 & 4)) {
              $4 = $2 & 3;
              $2 = 4;
              break label$512;
             }
             if (!(!($2 & 252) | $2 & 2)) {
              $4 = $2 & 1;
              $2 = 5;
              break label$512;
             }
             $4 = -1;
             $3 = -1;
             if (!($2 & 254) | $2 & 1) {
              break label$311
             }
             $4 = 0;
             $2 = 6;
            }
            $3 = 0;
            if (!$10) {
             while (1) {
              if (!FLAC__bitreader_read_raw_uint32($14, $9 + 12 | 0, 8)) {
               break label$110
              }
              $10 = HEAP32[$9 + 12 >> 2];
              if (($10 & 192) != 128) {
               $4 = -1;
               $3 = -1;
               break label$311;
              }
              $3 = $3 << 6 | $4 >>> 26;
              $4 = $10 & 63 | $4 << 6;
              $2 = $2 - 1 | 0;
              if ($2) {
               continue
              }
              break label$311;
             }
            }
            while (1) {
             if (!FLAC__bitreader_read_raw_uint32($14, $9 + 12 | 0, 8)) {
              break label$110
             }
             $17 = HEAP32[$9 + 12 >> 2];
             $18 = HEAP32[$11 >> 2];
             HEAP32[$11 >> 2] = $18 + 1;
             HEAP8[$10 + $18 | 0] = $17;
             if (($17 & 192) != 128) {
              $4 = -1;
              $3 = -1;
              break label$311;
             }
             $3 = $3 << 6 | $4 >>> 26;
             $4 = $17 & 63 | $4 << 6;
             $2 = $2 - 1 | 0;
             if ($2) {
              continue
             }
             break;
            };
            break label$311;
           }
           $4 = $2;
           $3 = 0;
          }
          HEAP32[$12 >> 2] = $4;
          HEAP32[$12 + 4 >> 2] = $3;
          $13 = 1;
         }
         __stack_pointer = $9 + 16 | 0;
         if (!$13) {
          break label$3
         }
         $2 = HEAP32[$8 + 36 >> 2];
         $4 = $2;
         $3 = HEAP32[$8 + 32 >> 2];
         if (!(($3 | 0) != -1 | ($2 | 0) != -1)) {
          $4 = HEAPU8[(HEAP32[$8 + 12 >> 2] + $8 | 0) + 15 | 0];
          $2 = HEAP32[$6 >> 2];
          HEAP32[$2 + 3520 >> 2] = 1;
          HEAP8[$2 + 3590 | 0] = $4;
          if (!HEAP32[$2 + 3632 >> 2]) {
           FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 1, HEAP32[$2 + 48 >> 2])
          }
          $3 = HEAP32[$0 >> 2];
          HEAP32[$3 >> 2] = 2;
          break label$4;
         }
         $2 = HEAP32[$6 >> 2];
         $9 = $2 + 1160 | 0;
         HEAP32[$9 >> 2] = $3;
         HEAP32[$9 + 4 >> 2] = $4;
         HEAP32[$2 + 1156 >> 2] = 1;
         break label$42;
        }
        $13 = $8 + 44 | 0;
        $10 = $8 + 16 | 0;
        $11 = $8 + 12 | 0;
        $9 = __stack_pointer - 16 | 0;
        __stack_pointer = $9;
        $12 = HEAP32[$3 + 56 >> 2];
        label$115 : {
         if (!FLAC__bitreader_read_raw_uint32($12, $9 + 12 | 0, 8)) {
          break label$115
         }
         $2 = HEAP32[$9 + 12 >> 2];
         if ($10) {
          $4 = HEAP32[$11 >> 2];
          HEAP32[$11 >> 2] = $4 + 1;
          HEAP8[$4 + $10 | 0] = $2;
         }
         label$316 : {
          if (!($2 & 128)) {
           $4 = $2;
           break label$316;
          }
          label$517 : {
           if (!(!($2 & 192) | $2 & 32)) {
            $3 = 1;
            $4 = 31;
            break label$517;
           }
           if (!(!($2 & 224) | $2 & 16)) {
            $3 = 2;
            $4 = 15;
            break label$517;
           }
           if (!(!($2 & 240) | $2 & 8)) {
            $3 = 3;
            $4 = 7;
            break label$517;
           }
           if ($2 & 248) {
            $3 = 4;
            $4 = 3;
            if (!($2 & 4)) {
             break label$517
            }
           }
           $4 = -1;
           if (!($2 & 252) | $2 & 2) {
            break label$316
           }
           $3 = 5;
           $4 = 1;
          }
          $4 = $4 & $2;
          if (!$10) {
           while (1) {
            if (!FLAC__bitreader_read_raw_uint32($12, $9 + 12 | 0, 8)) {
             break label$115
            }
            $2 = HEAP32[$9 + 12 >> 2];
            if (($2 & 192) != 128) {
             $4 = -1;
             break label$316;
            }
            $4 = $2 & 63 | $4 << 6;
            $3 = $3 - 1 | 0;
            if ($3) {
             continue
            }
            break label$316;
           }
          }
          while (1) {
           if (!FLAC__bitreader_read_raw_uint32($12, $9 + 12 | 0, 8)) {
            break label$115
           }
           $2 = HEAP32[$9 + 12 >> 2];
           $14 = HEAP32[$11 >> 2];
           HEAP32[$11 >> 2] = $14 + 1;
           HEAP8[$10 + $14 | 0] = $2;
           if (($2 & 192) != 128) {
            $4 = -1;
            break label$316;
           }
           $4 = $2 & 63 | $4 << 6;
           $3 = $3 - 1 | 0;
           if ($3) {
            continue
           }
           break;
          };
         }
         HEAP32[$13 >> 2] = $4;
         $17 = 1;
        }
        __stack_pointer = $9 + 16 | 0;
        if (!$17) {
         break label$3
        }
        $2 = HEAP32[$8 + 44 >> 2];
        if (($2 | 0) == -1) {
         $4 = HEAPU8[(HEAP32[$8 + 12 >> 2] + $8 | 0) + 15 | 0];
         $2 = HEAP32[$6 >> 2];
         HEAP32[$2 + 3520 >> 2] = 1;
         HEAP8[$2 + 3590 | 0] = $4;
         if (!HEAP32[$2 + 3632 >> 2]) {
          FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 1, HEAP32[$2 + 48 >> 2])
         }
         $3 = HEAP32[$0 >> 2];
         HEAP32[$3 >> 2] = 2;
         break label$4;
        }
        $4 = HEAP32[$6 >> 2];
        HEAP32[$4 + 1160 >> 2] = $2;
        HEAP32[$4 + 1156 >> 2] = 0;
       }
       $3 = HEAP32[$6 >> 2];
       if ($7) {
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[$3 + 56 >> 2], $8 + 44 | 0, 8)) {
         break label$3
        }
        $4 = HEAP32[$8 + 12 >> 2];
        $2 = HEAP32[$8 + 44 >> 2];
        HEAP8[$4 + ($8 + 16 | 0) | 0] = $2;
        HEAP32[$8 + 12 >> 2] = $4 + 1;
        if (($7 | 0) == 7) {
         if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$6 >> 2] + 56 >> 2], $8 + 8 | 0, 8)) {
          break label$3
         }
         $2 = HEAP32[$8 + 12 >> 2];
         $4 = HEAP32[$8 + 8 >> 2];
         HEAP8[$2 + ($8 + 16 | 0) | 0] = $4;
         HEAP32[$8 + 12 >> 2] = $2 + 1;
         $2 = $4 | HEAP32[$8 + 44 >> 2] << 8;
         HEAP32[$8 + 44 >> 2] = $2;
        }
        $3 = HEAP32[$6 >> 2];
        HEAP32[$3 + 1136 >> 2] = $2 + 1;
       }
       if ($15) {
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[$3 + 56 >> 2], $8 + 44 | 0, 8)) {
         break label$3
        }
        $4 = HEAP32[$8 + 12 >> 2];
        $2 = HEAP32[$8 + 44 >> 2];
        HEAP8[$4 + ($8 + 16 | 0) | 0] = $2;
        HEAP32[$8 + 12 >> 2] = $4 + 1;
        label$52 : {
         label$53 : {
          label$54 : {
           if (($15 | 0) == 12) {
            break label$54
           }
           if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$6 >> 2] + 56 >> 2], $8 + 8 | 0, 8)) {
            break label$3
           }
           $2 = HEAP32[$8 + 12 >> 2];
           $4 = HEAP32[$8 + 8 >> 2];
           HEAP8[$2 + ($8 + 16 | 0) | 0] = $4;
           HEAP32[$8 + 12 >> 2] = $2 + 1;
           $2 = $4 | HEAP32[$8 + 44 >> 2] << 8;
           HEAP32[$8 + 44 >> 2] = $2;
           switch ($15 - 12 | 0) {
           case 1:
            break label$52;
           case 0:
            break label$54;
           default:
            break label$53;
           };
          }
          $2 = Math_imul($2, 1e3);
          break label$52;
         }
         $2 = Math_imul($2, 10);
        }
        $3 = HEAP32[$6 >> 2];
        HEAP32[$3 + 1140 >> 2] = $2;
       }
       if (!FLAC__bitreader_read_raw_uint32(HEAP32[$3 + 56 >> 2], $8 + 44 | 0, 8)) {
        break label$3
       }
       $2 = HEAPU8[$8 + 44 | 0];
       $4 = FLAC__crc8($8 + 16 | 0, HEAP32[$8 + 12 >> 2]);
       $3 = HEAP32[$6 >> 2];
       if (($2 | 0) != ($4 | 0)) {
        if (!HEAP32[$3 + 3632 >> 2]) {
         FUNCTION_TABLE[HEAP32[$3 + 32 >> 2]]($0, 1, HEAP32[$3 + 48 >> 2])
        }
        $3 = HEAP32[$0 >> 2];
        HEAP32[$3 >> 2] = 2;
        break label$4;
       }
       HEAP32[$3 + 232 >> 2] = 0;
       label$57 : {
        label$58 : {
         label$59 : {
          if (HEAP32[$3 + 1156 >> 2]) {
           break label$59
          }
          $4 = $3 + 1160 | 0;
          $2 = HEAP32[$4 >> 2];
          HEAP32[$8 + 44 >> 2] = $2;
          HEAP32[$3 + 1156 >> 2] = 1;
          $7 = HEAP32[$3 + 228 >> 2];
          if ($7) {
           (wasm2js_i32$0 = $4, wasm2js_i32$1 = __wasm_i64_mul($7, 0, $2, 0)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
           HEAP32[$4 + 4 >> 2] = i64toi32_i32$HIGH_BITS;
           break label$59;
          }
          if (HEAP32[$3 + 248 >> 2]) {
           $4 = HEAP32[$3 + 272 >> 2];
           if (($4 | 0) != HEAP32[$3 + 276 >> 2]) {
            break label$58
           }
           $3 = $3 + 1160 | 0;
           (wasm2js_i32$0 = $3, wasm2js_i32$1 = __wasm_i64_mul($4, 0, $2, 0)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
           HEAP32[$3 + 4 >> 2] = i64toi32_i32$HIGH_BITS;
           $2 = HEAP32[$6 >> 2];
           HEAP32[$2 + 232 >> 2] = HEAP32[$2 + 276 >> 2];
           break label$59;
          }
          if (!$2) {
           $2 = $3 + 1160 | 0;
           HEAP32[$2 >> 2] = 0;
           HEAP32[$2 + 4 >> 2] = 0;
           $2 = HEAP32[$6 >> 2];
           HEAP32[$2 + 232 >> 2] = HEAP32[$2 + 1136 >> 2];
           break label$59;
          }
          $4 = $3 + 1160 | 0;
          (wasm2js_i32$0 = $4, wasm2js_i32$1 = __wasm_i64_mul(HEAP32[$3 + 1136 >> 2], 0, $2, 0)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
          HEAP32[$4 + 4 >> 2] = i64toi32_i32$HIGH_BITS;
         }
         if (!($16 & 1 | $5)) {
          break label$57
         }
         $3 = HEAP32[$6 >> 2];
        }
        label$63 : {
         if (!HEAP32[$3 + 3632 >> 2]) {
          FUNCTION_TABLE[HEAP32[$3 + 32 >> 2]]($0, 3, HEAP32[$3 + 48 >> 2]);
          break label$63;
         }
         HEAP32[$3 + 6152 >> 2] = HEAP32[$3 + 6152 >> 2] + 1;
        }
        $3 = HEAP32[$0 >> 2];
        HEAP32[$3 >> 2] = 2;
        break label$4;
       }
       $3 = HEAP32[$0 >> 2];
       break label$4;
      }
      $2 = HEAP32[$6 >> 2];
      HEAP32[$2 + 3520 >> 2] = 1;
      HEAP8[$2 + 3590 | 0] = 255;
      if (!HEAP32[$2 + 3632 >> 2]) {
       FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 1, HEAP32[$2 + 48 >> 2])
      }
      $3 = HEAP32[$0 >> 2];
      HEAP32[$3 >> 2] = 2;
     }
     $15 = 1;
     if (HEAP32[$3 >> 2] == 2) {
      break label$1
     }
     $3 = HEAP32[$6 >> 2];
     $4 = HEAP32[$3 + 1144 >> 2];
     $5 = HEAP32[$3 + 1136 >> 2];
     if (!($5 >>> 0 <= HEAPU32[$3 + 220 >> 2] & HEAPU32[$3 + 224 >> 2] >= $4 >>> 0)) {
      $2 = HEAP32[$3 + 60 >> 2];
      if ($2) {
       dlfree($2 - 16 | 0);
       HEAP32[HEAP32[$6 >> 2] + 60 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 3592 >> 2];
      if ($2) {
       dlfree($2);
       HEAP32[HEAP32[$6 >> 2] + 92 >> 2] = 0;
       HEAP32[HEAP32[$6 >> 2] + 3592 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 - -64 >> 2];
      if ($2) {
       dlfree($2 - 16 | 0);
       HEAP32[HEAP32[$6 >> 2] - -64 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 3596 >> 2];
      if ($2) {
       dlfree($2);
       HEAP32[HEAP32[$6 >> 2] + 96 >> 2] = 0;
       HEAP32[HEAP32[$6 >> 2] + 3596 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 68 >> 2];
      if ($2) {
       dlfree($2 - 16 | 0);
       HEAP32[HEAP32[$6 >> 2] + 68 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 3600 >> 2];
      if ($2) {
       dlfree($2);
       HEAP32[HEAP32[$6 >> 2] + 100 >> 2] = 0;
       HEAP32[HEAP32[$6 >> 2] + 3600 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 72 >> 2];
      if ($2) {
       dlfree($2 - 16 | 0);
       HEAP32[HEAP32[$6 >> 2] + 72 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 3604 >> 2];
      if ($2) {
       dlfree($2);
       HEAP32[HEAP32[$6 >> 2] + 104 >> 2] = 0;
       HEAP32[HEAP32[$6 >> 2] + 3604 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 76 >> 2];
      if ($2) {
       dlfree($2 - 16 | 0);
       HEAP32[HEAP32[$6 >> 2] + 76 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 3608 >> 2];
      if ($2) {
       dlfree($2);
       HEAP32[HEAP32[$6 >> 2] + 108 >> 2] = 0;
       HEAP32[HEAP32[$6 >> 2] + 3608 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 80 >> 2];
      if ($2) {
       dlfree($2 - 16 | 0);
       HEAP32[HEAP32[$6 >> 2] + 80 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 3612 >> 2];
      if ($2) {
       dlfree($2);
       HEAP32[HEAP32[$6 >> 2] + 112 >> 2] = 0;
       HEAP32[HEAP32[$6 >> 2] + 3612 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 84 >> 2];
      if ($2) {
       dlfree($2 - 16 | 0);
       HEAP32[HEAP32[$6 >> 2] + 84 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 3616 >> 2];
      if ($2) {
       dlfree($2);
       HEAP32[HEAP32[$6 >> 2] + 116 >> 2] = 0;
       HEAP32[HEAP32[$6 >> 2] + 3616 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 88 >> 2];
      if ($2) {
       dlfree($2 - 16 | 0);
       HEAP32[HEAP32[$6 >> 2] + 88 >> 2] = 0;
       $3 = HEAP32[$6 >> 2];
      }
      $2 = HEAP32[$3 + 3620 >> 2];
      if ($2) {
       dlfree($2);
       HEAP32[HEAP32[$6 >> 2] + 120 >> 2] = 0;
       HEAP32[HEAP32[$6 >> 2] + 3620 >> 2] = 0;
      }
      label$84 : {
       if (!$4) {
        break label$84
       }
       if ($5 >>> 0 > 4294967291) {
        break label$2
       }
       $2 = $5 + 4 | 0;
       if ($2 >>> 0 > 1073741823) {
        break label$2
       }
       $7 = $2 << 2;
       $2 = 0;
       while (1) {
        $3 = dlmalloc($7);
        if (!$3) {
         break label$2
        }
        HEAP32[$3 >> 2] = 0;
        HEAP32[$3 + 4 >> 2] = 0;
        $9 = $3 + 8 | 0;
        HEAP32[$9 >> 2] = 0;
        HEAP32[$9 + 4 >> 2] = 0;
        $9 = $2 << 2;
        HEAP32[($9 + HEAP32[$6 >> 2] | 0) + 60 >> 2] = $3 + 16;
        $3 = $9 + HEAP32[$6 >> 2] | 0;
        if (FLAC__memory_alloc_aligned_int32_array($5, $3 + 3592 | 0, $3 + 92 | 0)) {
         $2 = $2 + 1 | 0;
         if (($4 | 0) == ($2 | 0)) {
          break label$84
         }
         continue;
        }
        break;
       };
       HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
       break label$3;
      }
      $3 = HEAP32[$6 >> 2];
      HEAP32[$3 + 224 >> 2] = $4;
      HEAP32[$3 + 220 >> 2] = $5;
      $4 = HEAP32[$3 + 1144 >> 2];
     }
     label$87 : {
      if ($4) {
       $18 = HEAP32[1689];
       $20 = -1 << $18 ^ -1;
       $17 = HEAP32[1683];
       $16 = HEAP32[1682];
       $21 = HEAP32[1690];
       $4 = 0;
       while (1) {
        $2 = HEAP32[$3 + 1152 >> 2];
        label$90 : {
         label$91 : {
          switch (HEAP32[$3 + 1148 >> 2] - 1 | 0) {
          case 0:
           $2 = (($4 | 0) == 1) + $2 | 0;
           break label$90;
          case 1:
           $2 = !$4 + $2 | 0;
           break label$90;
          case 2:
           break label$91;
          default:
           break label$90;
          };
         }
         $2 = (($4 | 0) == 1) + $2 | 0;
        }
        if (!FLAC__bitreader_read_raw_uint32(HEAP32[$3 + 56 >> 2], $8 + 44 | 0, 8)) {
         break label$3
        }
        $5 = HEAP32[$8 + 44 >> 2];
        HEAP32[$8 + 44 >> 2] = $5 & 254;
        $19 = $5 & 1;
        label$94 : {
         if ($19) {
          if (!FLAC__bitreader_read_unary_unsigned(HEAP32[HEAP32[$6 >> 2] + 56 >> 2], $8 + 16 | 0)) {
           break label$3
          }
          $3 = HEAP32[$6 >> 2];
          $5 = HEAP32[$8 + 16 >> 2] + 1 | 0;
          HEAP32[($3 + Math_imul($4, 292) | 0) + 1464 >> 2] = $5;
          if ($2 >>> 0 <= $5 >>> 0) {
           break label$3
          }
          $2 = $2 - $5 | 0;
          break label$94;
         }
         $3 = HEAP32[$6 >> 2];
         HEAP32[($3 + Math_imul($4, 292) | 0) + 1464 >> 2] = 0;
        }
        $7 = HEAP32[$8 + 44 >> 2];
        label$96 : {
         label$97 : {
          if ($7 & 128) {
           if (HEAP32[$3 + 3632 >> 2]) {
            break label$97
           }
           FUNCTION_TABLE[HEAP32[$3 + 32 >> 2]]($0, 0, HEAP32[$3 + 48 >> 2]);
           break label$97;
          }
          label$99 : {
           label$100 : {
            label$101 : {
             switch ($7 | 0) {
             case 0:
              $5 = HEAP32[(($4 << 2) + $3 | 0) + 60 >> 2];
              $7 = Math_imul($4, 292) + $3 | 0;
              HEAP32[$7 + 1176 >> 2] = 0;
              if (!FLAC__bitreader_read_raw_int32(HEAP32[$3 + 56 >> 2], $8 + 16 | 0, $2)) {
               break label$3
              }
              HEAP32[$7 + 1180 >> 2] = HEAP32[$8 + 16 >> 2];
              $3 = 0;
              $2 = HEAP32[$6 >> 2];
              if (!HEAP32[$2 + 1136 >> 2]) {
               break label$100
              }
              while (1) {
               HEAP32[$5 + ($3 << 2) >> 2] = HEAP32[$8 + 16 >> 2];
               $3 = $3 + 1 | 0;
               if ($3 >>> 0 < HEAPU32[$2 + 1136 >> 2]) {
                continue
               }
               break;
              };
              break label$100;
             case 2:
              $5 = ($3 + 1136 | 0) + Math_imul($4, 292) | 0;
              $9 = $5 + 44 | 0;
              $10 = $4 << 2;
              $11 = HEAP32[($10 + $3 | 0) + 92 >> 2];
              HEAP32[$9 >> 2] = $11;
              HEAP32[$5 + 40 >> 2] = 1;
              $7 = 0;
              if (HEAP32[$3 + 1136 >> 2]) {
               while (1) {
                if (!FLAC__bitreader_read_raw_int32(HEAP32[$3 + 56 >> 2], $8 + 16 | 0, $2)) {
                 break label$3
                }
                HEAP32[$11 + ($7 << 2) >> 2] = HEAP32[$8 + 16 >> 2];
                $7 = $7 + 1 | 0;
                $3 = HEAP32[$6 >> 2];
                $5 = HEAP32[$3 + 1136 >> 2];
                if ($7 >>> 0 < $5 >>> 0) {
                 continue
                }
                break;
               };
               $7 = $5 << 2;
              }
              __memcpy(HEAP32[($3 + $10 | 0) + 60 >> 2], HEAP32[$9 >> 2], $7);
              break label$100;
             default:
              break label$101;
             };
            }
            if ($7 >>> 0 <= 15) {
             if (HEAP32[$3 + 3632 >> 2]) {
              break label$99
             }
             FUNCTION_TABLE[HEAP32[$3 + 32 >> 2]]($0, 3, HEAP32[$3 + 48 >> 2]);
             break label$97;
            }
            if ($7 >>> 0 <= 24) {
             $9 = Math_imul($4, 292) + $3 | 0;
             HEAP32[$9 + 1176 >> 2] = 2;
             $10 = $4 << 2;
             $11 = HEAP32[($10 + $3 | 0) + 92 >> 2];
             $5 = $7 >>> 1 & 7;
             HEAP32[$9 + 1192 >> 2] = $5;
             HEAP32[$9 + 1212 >> 2] = $11;
             $11 = $9 + 1196 | 0;
             $7 = 0;
             if ($5) {
              while (1) {
               if (!FLAC__bitreader_read_raw_int32(HEAP32[$3 + 56 >> 2], $8 + 16 | 0, $2)) {
                break label$3
               }
               HEAP32[$11 + ($7 << 2) >> 2] = HEAP32[$8 + 16 >> 2];
               $3 = HEAP32[$6 >> 2];
               $7 = $7 + 1 | 0;
               if (($5 | 0) != ($7 | 0)) {
                continue
               }
               break;
              }
             }
             if (!FLAC__bitreader_read_raw_uint32(HEAP32[$3 + 56 >> 2], $8 + 32 | 0, $16)) {
              break label$3
             }
             $7 = $9 + 1180 | 0;
             $3 = HEAP32[$8 + 32 >> 2];
             HEAP32[$7 >> 2] = $3;
             $2 = HEAP32[$6 >> 2];
             label$111 : {
              label$112 : {
               if ($3 >>> 0 <= 1) {
                if (!FLAC__bitreader_read_raw_uint32(HEAP32[$2 + 56 >> 2], $8 + 32 | 0, $17)) {
                 break label$3
                }
                $2 = HEAP32[$6 >> 2];
                $3 = HEAP32[$8 + 32 >> 2];
                if ($5 >>> 0 <= HEAP32[$2 + 1136 >> 2] >>> $3 >>> 0) {
                 break label$112
                }
                if (!HEAP32[$2 + 3632 >> 2]) {
                 FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 0, HEAP32[$2 + 48 >> 2])
                }
                HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
                break label$111;
               }
               label$11521 : {
                if (!HEAP32[$2 + 3632 >> 2]) {
                 FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 3, HEAP32[$2 + 48 >> 2]);
                 break label$11521;
                }
                HEAP32[$2 + 6152 >> 2] = HEAP32[$2 + 6152 >> 2] + 1;
               }
               HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
               break label$111;
              }
              HEAP32[$9 + 1184 >> 2] = $3;
              $2 = Math_imul($4, 12);
              HEAP32[$9 + 1188 >> 2] = ($2 + HEAP32[$6 >> 2] | 0) + 124;
              $7 = HEAP32[$7 >> 2];
              if ($7 >>> 0 < 2) {
               $13 = $3;
               $3 = HEAP32[$0 + 4 >> 2];
               if (!read_residual_partitioned_rice_($0, $5, $13, ($2 + $3 | 0) + 124 | 0, HEAP32[($3 + $10 | 0) + 92 >> 2], ($7 | 0) == 1)) {
                break label$3
               }
              }
              $2 = $5 << 2;
              __memcpy(HEAP32[($10 + HEAP32[$6 >> 2] | 0) + 60 >> 2], $11, $2);
              $3 = HEAP32[$6 >> 2];
              $7 = $3 + $10 | 0;
              $11 = HEAP32[$7 + 92 >> 2];
              $10 = HEAP32[$3 + 1136 >> 2] - $5 | 0;
              $7 = $2 + HEAP32[$7 + 60 >> 2] | 0;
              __inlined_func$FLAC__fixed_restore_signal : {
               label$122 : {
                switch ($5 | 0) {
                case 4:
                 if (($10 | 0) < 1) {
                  break __inlined_func$FLAC__fixed_restore_signal
                 }
                 $2 = HEAP32[$7 - 12 >> 2];
                 $9 = HEAP32[$7 - 4 >> 2];
                 $3 = 0;
                 while (1) {
                  $13 = $3 << 2;
                  $12 = $13 + $7 | 0;
                  $5 = HEAP32[$12 - 8 >> 2];
                  $9 = ((Math_imul($5, -6) + HEAP32[$11 + $13 >> 2] | 0) - HEAP32[$12 - 16 >> 2] | 0) + ($2 + $9 << 2) | 0;
                  HEAP32[$12 >> 2] = $9;
                  $2 = $5;
                  $3 = $3 + 1 | 0;
                  if (($3 | 0) != ($10 | 0)) {
                   continue
                  }
                  break;
                 };
                 break __inlined_func$FLAC__fixed_restore_signal;
                case 3:
                 if (($10 | 0) < 1) {
                  break __inlined_func$FLAC__fixed_restore_signal
                 }
                 $9 = HEAP32[$7 - 12 >> 2];
                 $5 = HEAP32[$7 - 4 >> 2];
                 $3 = 0;
                 if (($10 | 0) != 1) {
                  $2 = $10 & -2;
                  while (1) {
                   $12 = $3 << 2;
                   $13 = $12 + $7 | 0;
                   $14 = HEAP32[$13 - 8 >> 2];
                   $5 = (HEAP32[$11 + $12 >> 2] + $9 | 0) + Math_imul($5 - $14 | 0, 3) | 0;
                   HEAP32[$13 >> 2] = $5;
                   $12 = $12 | 4;
                   $9 = HEAP32[$13 - 4 >> 2];
                   $5 = ($14 + HEAP32[$12 + $11 >> 2] | 0) + Math_imul($5 - $9 | 0, 3) | 0;
                   HEAP32[$7 + $12 >> 2] = $5;
                   $3 = $3 + 2 | 0;
                   $2 = $2 - 2 | 0;
                   if ($2) {
                    continue
                   }
                   break;
                  };
                 }
                 if (!($10 & 1)) {
                  break __inlined_func$FLAC__fixed_restore_signal
                 }
                 $2 = $3 << 2;
                 $3 = $2 + $7 | 0;
                 HEAP32[$3 >> 2] = (HEAP32[$2 + $11 >> 2] + $9 | 0) + Math_imul($5 - HEAP32[$3 - 8 >> 2] | 0, 3);
                 break __inlined_func$FLAC__fixed_restore_signal;
                case 2:
                 if (($10 | 0) < 1) {
                  break __inlined_func$FLAC__fixed_restore_signal
                 }
                 $9 = HEAP32[$7 - 4 >> 2];
                 $3 = 0;
                 if (($10 | 0) != 1) {
                  $5 = $10 & -2;
                  while (1) {
                   $2 = $3 << 2;
                   $12 = $2 + $7 | 0;
                   $9 = (HEAP32[$2 + $11 >> 2] + ($9 << 1) | 0) - HEAP32[$12 - 8 >> 2] | 0;
                   HEAP32[$12 >> 2] = $9;
                   $2 = $2 | 4;
                   $9 = (HEAP32[$2 + $11 >> 2] + ($9 << 1) | 0) - HEAP32[$12 - 4 >> 2] | 0;
                   HEAP32[$2 + $7 >> 2] = $9;
                   $3 = $3 + 2 | 0;
                   $5 = $5 - 2 | 0;
                   if ($5) {
                    continue
                   }
                   break;
                  };
                 }
                 if (!($10 & 1)) {
                  break __inlined_func$FLAC__fixed_restore_signal
                 }
                 $2 = $3 << 2;
                 $5 = $2 + $7 | 0;
                 HEAP32[$5 >> 2] = (HEAP32[$2 + $11 >> 2] + ($9 << 1) | 0) - HEAP32[$5 - 8 >> 2];
                 break __inlined_func$FLAC__fixed_restore_signal;
                case 1:
                 if (($10 | 0) < 1) {
                  break __inlined_func$FLAC__fixed_restore_signal
                 }
                 $9 = $10 & 3;
                 $2 = HEAP32[$7 - 4 >> 2];
                 $3 = 0;
                 if ($10 - 1 >>> 0 >= 3) {
                  $5 = $10 & -4;
                  while (1) {
                   $10 = $2;
                   $2 = $3 << 2;
                   $10 = $10 + HEAP32[$2 + $11 >> 2] | 0;
                   HEAP32[$2 + $7 >> 2] = $10;
                   $12 = $2 | 4;
                   $10 = $10 + HEAP32[$12 + $11 >> 2] | 0;
                   HEAP32[$7 + $12 >> 2] = $10;
                   $12 = $2 | 8;
                   $10 = $10 + HEAP32[$12 + $11 >> 2] | 0;
                   HEAP32[$7 + $12 >> 2] = $10;
                   $12 = $2 | 12;
                   $2 = $10 + HEAP32[$12 + $11 >> 2] | 0;
                   HEAP32[$7 + $12 >> 2] = $2;
                   $3 = $3 + 4 | 0;
                   $5 = $5 - 4 | 0;
                   if ($5) {
                    continue
                   }
                   break;
                  };
                 }
                 if (!$9) {
                  break __inlined_func$FLAC__fixed_restore_signal
                 }
                 while (1) {
                  $5 = $3 << 2;
                  $2 = HEAP32[$5 + $11 >> 2] + $2 | 0;
                  HEAP32[$5 + $7 >> 2] = $2;
                  $3 = $3 + 1 | 0;
                  $9 = $9 - 1 | 0;
                  if ($9) {
                   continue
                  }
                  break;
                 };
                 break __inlined_func$FLAC__fixed_restore_signal;
                case 0:
                 break label$122;
                default:
                 break __inlined_func$FLAC__fixed_restore_signal;
                };
               }
               __memcpy($7, $11, $10 << 2);
              }
             }
             if (HEAP32[HEAP32[$0 >> 2] >> 2] != 2) {
              break label$100
             }
             break label$96;
            }
            if ($7 >>> 0 <= 63) {
             if (!HEAP32[$3 + 3632 >> 2]) {
              FUNCTION_TABLE[HEAP32[$3 + 32 >> 2]]($0, 3, HEAP32[$3 + 48 >> 2]);
              break label$97;
             }
             HEAP32[$3 + 6152 >> 2] = HEAP32[$3 + 6152 >> 2] + 1;
             break label$97;
            }
            $5 = Math_imul($4, 292) + $3 | 0;
            HEAP32[$5 + 1176 >> 2] = 3;
            $10 = $4 << 2;
            $12 = HEAP32[($10 + $3 | 0) + 92 >> 2];
            $11 = $7 >>> 1 & 31;
            $9 = $11 + 1 | 0;
            HEAP32[$5 + 1192 >> 2] = $9;
            HEAP32[$5 + 1460 >> 2] = $12;
            $7 = 0;
            while (1) {
             if (!FLAC__bitreader_read_raw_int32(HEAP32[$3 + 56 >> 2], $8 + 16 | 0, $2)) {
              break label$3
             }
             HEAP32[($5 + ($7 << 2) | 0) + 1332 >> 2] = HEAP32[$8 + 16 >> 2];
             $12 = ($7 | 0) != ($11 | 0);
             $3 = HEAP32[$6 >> 2];
             $7 = $7 + 1 | 0;
             if ($12) {
              continue
             }
             break;
            };
            if (!FLAC__bitreader_read_raw_uint32(HEAP32[$3 + 56 >> 2], $8 + 32 | 0, $18)) {
             break label$3
            }
            $3 = HEAP32[$8 + 32 >> 2];
            label$121 : {
             if (($20 | 0) == ($3 | 0)) {
              $2 = HEAP32[$6 >> 2];
              if (!HEAP32[$2 + 3632 >> 2]) {
               FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 0, HEAP32[$2 + 48 >> 2])
              }
              HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
              break label$121;
             }
             $12 = $5 + 1196 | 0;
             HEAP32[$12 >> 2] = $3 + 1;
             if (!FLAC__bitreader_read_raw_int32(HEAP32[HEAP32[$6 >> 2] + 56 >> 2], $8 + 16 | 0, $21)) {
              break label$3
             }
             $3 = HEAP32[$8 + 16 >> 2];
             if (($3 | 0) <= -1) {
              $2 = HEAP32[$6 >> 2];
              if (!HEAP32[$2 + 3632 >> 2]) {
               FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 0, HEAP32[$2 + 48 >> 2])
              }
              HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
              break label$121;
             }
             $7 = $5 + 1200 | 0;
             HEAP32[$7 >> 2] = $3;
             $3 = 0;
             while (1) {
              if (!FLAC__bitreader_read_raw_int32(HEAP32[HEAP32[$6 >> 2] + 56 >> 2], $8 + 16 | 0, HEAP32[$12 >> 2])) {
               break label$3
              }
              HEAP32[($5 + ($3 << 2) | 0) + 1204 >> 2] = HEAP32[$8 + 16 >> 2];
              $13 = ($3 | 0) != ($11 | 0);
              $3 = $3 + 1 | 0;
              if ($13) {
               continue
              }
              break;
             };
             if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$6 >> 2] + 56 >> 2], $8 + 32 | 0, $16)) {
              break label$3
             }
             $14 = $5 + 1180 | 0;
             $13 = HEAP32[$8 + 32 >> 2];
             HEAP32[$14 >> 2] = $13;
             $3 = HEAP32[$6 >> 2];
             label$127 : {
              if ($13 >>> 0 <= 1) {
               if (!FLAC__bitreader_read_raw_uint32(HEAP32[$3 + 56 >> 2], $8 + 32 | 0, $17)) {
                break label$3
               }
               $3 = HEAP32[$6 >> 2];
               $13 = HEAP32[$8 + 32 >> 2];
               if ($11 >>> 0 < HEAP32[$3 + 1136 >> 2] >>> $13 >>> 0) {
                break label$127
               }
               if (!HEAP32[$3 + 3632 >> 2]) {
                FUNCTION_TABLE[HEAP32[$3 + 32 >> 2]]($0, 0, HEAP32[$3 + 48 >> 2])
               }
               HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
               break label$121;
              }
              label$130 : {
               if (!HEAP32[$3 + 3632 >> 2]) {
                FUNCTION_TABLE[HEAP32[$3 + 32 >> 2]]($0, 3, HEAP32[$3 + 48 >> 2]);
                break label$130;
               }
               HEAP32[$3 + 6152 >> 2] = HEAP32[$3 + 6152 >> 2] + 1;
              }
              HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
              break label$121;
             }
             HEAP32[$5 + 1184 >> 2] = $13;
             $3 = Math_imul($4, 12);
             HEAP32[$5 + 1188 >> 2] = ($3 + HEAP32[$6 >> 2] | 0) + 124;
             $11 = HEAP32[$14 >> 2];
             if ($11 >>> 0 < 2) {
              $14 = $13;
              $13 = HEAP32[$0 + 4 >> 2];
              if (!read_residual_partitioned_rice_($0, $9, $14, ($3 + $13 | 0) + 124 | 0, HEAP32[($10 + $13 | 0) + 92 >> 2], ($11 | 0) == 1)) {
               break label$3
              }
             }
             $11 = $9 << 2;
             __memcpy(HEAP32[(HEAP32[$6 >> 2] + $10 | 0) + 60 >> 2], $5 + 1332 | 0, $11);
             label$133 : {
              $12 = HEAP32[$12 >> 2];
              if ($12 + ((Math_clz32($9) ^ 31) + $2 | 0) >>> 0 <= 32) {
               $3 = HEAP32[$6 >> 2];
               if ($2 >>> 0 > 16 | $12 >>> 0 > 16) {
                break label$133
               }
               $2 = $3 + $10 | 0;
               FUNCTION_TABLE[HEAP32[$3 + 44 >> 2]](HEAP32[$2 + 92 >> 2], HEAP32[$3 + 1136 >> 2] - $9 | 0, $5 + 1204 | 0, $9, HEAP32[$7 >> 2], $11 + HEAP32[$2 + 60 >> 2] | 0);
               break label$121;
              }
              $2 = HEAP32[$6 >> 2];
              $3 = $2 + $10 | 0;
              FUNCTION_TABLE[HEAP32[$2 + 40 >> 2]](HEAP32[$3 + 92 >> 2], HEAP32[$2 + 1136 >> 2] - $9 | 0, $5 + 1204 | 0, $9, HEAP32[$7 >> 2], $11 + HEAP32[$3 + 60 >> 2] | 0);
              break label$121;
             }
             $2 = $3 + $10 | 0;
             FUNCTION_TABLE[HEAP32[$3 + 36 >> 2]](HEAP32[$2 + 92 >> 2], HEAP32[$3 + 1136 >> 2] - $9 | 0, $5 + 1204 | 0, $9, HEAP32[$7 >> 2], $11 + HEAP32[$2 + 60 >> 2] | 0);
            }
            if (HEAP32[HEAP32[$0 >> 2] >> 2] == 2) {
             break label$96
            }
           }
           if (!$19) {
            break label$96
           }
           $2 = HEAP32[$6 >> 2];
           $3 = HEAP32[($2 + Math_imul($4, 292) | 0) + 1464 >> 2];
           HEAP32[$8 + 44 >> 2] = $3;
           if (!HEAP32[$2 + 1136 >> 2]) {
            break label$96
           }
           $5 = HEAP32[($2 + ($4 << 2) | 0) + 60 >> 2];
           HEAP32[$5 >> 2] = HEAP32[$5 >> 2] << $3;
           $3 = 1;
           if (HEAPU32[$2 + 1136 >> 2] < 2) {
            break label$96
           }
           while (1) {
            $7 = $5 + ($3 << 2) | 0;
            HEAP32[$7 >> 2] = HEAP32[$7 >> 2] << HEAP32[$8 + 44 >> 2];
            $3 = $3 + 1 | 0;
            if ($3 >>> 0 < HEAPU32[$2 + 1136 >> 2]) {
             continue
            }
            break;
           };
           break label$96;
          }
          HEAP32[$3 + 6152 >> 2] = HEAP32[$3 + 6152 >> 2] + 1;
         }
         HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
        }
        if (HEAP32[HEAP32[$0 >> 2] >> 2] == 2) {
         break label$87
        }
        $4 = $4 + 1 | 0;
        $3 = HEAP32[$6 >> 2];
        if ($4 >>> 0 < HEAPU32[$3 + 1144 >> 2]) {
         continue
        }
        break;
       };
      }
      label$136 : {
       if (FLAC__bitreader_is_consumed_byte_aligned(HEAP32[$3 + 56 >> 2])) {
        break label$136
       }
       HEAP32[$8 + 16 >> 2] = 0;
       $2 = HEAP32[HEAP32[$6 >> 2] + 56 >> 2];
       if (!FLAC__bitreader_read_raw_uint32($2, $8 + 16 | 0, FLAC__bitreader_bits_left_for_byte_alignment($2))) {
        break label$3
       }
       if (!HEAP32[$8 + 16 >> 2]) {
        break label$136
       }
       $2 = HEAP32[$6 >> 2];
       if (!HEAP32[$2 + 3632 >> 2]) {
        FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 0, HEAP32[$2 + 48 >> 2])
       }
       HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
      }
      if (HEAP32[HEAP32[$0 >> 2] >> 2] == 2) {
       break label$1
      }
      $5 = HEAP32[HEAP32[$6 >> 2] + 56 >> 2];
      $9 = HEAP32[$5 + 16 >> 2];
      $4 = HEAP32[$5 + 28 >> 2];
      label$134 : {
       if ($9 >>> 0 <= $4 >>> 0) {
        $2 = $4;
        break label$134;
       }
       $3 = HEAP32[$5 + 32 >> 2];
       if (!$3) {
        $2 = $4;
        break label$134;
       }
       $2 = $4 + 1 | 0;
       HEAP32[$5 + 28 >> 2] = $2;
       $7 = HEAP32[$5 + 24 >> 2];
       $11 = $7;
       label$435 : {
        if ($3 >>> 0 > 31) {
         break label$435
        }
        $4 = HEAP32[HEAP32[$5 >> 2] + ($4 << 2) >> 2];
        $10 = HEAPU16[(($4 >>> 24 - $3 & 255 ^ $7 >>> 8) << 1) + 1280 >> 1];
        $7 = $10 ^ $7 << 8 & 65280;
        $11 = $7;
        if ($3 >>> 0 >= 24) {
         break label$435
        }
        $7 = HEAPU16[(($4 >>> 16 - $3 & 255 ^ $7 >>> 8) << 1) + 1280 >> 1];
        $10 = $7 ^ $10 << 8 & 65280;
        $11 = $10;
        if ($3 >>> 0 > 15) {
         break label$435
        }
        $10 = HEAPU16[(($4 >>> 8 - $3 & 255 ^ $10 >>> 8) << 1) + 1280 >> 1];
        $7 = $10 ^ $7 << 8 & 65280;
        $11 = $7;
        if ($3 >>> 0 > 7) {
         break label$435
        }
        $11 = HEAPU16[(($4 >>> 0 - $3 & 255 ^ $7 >>> 8) << 1) + 1280 >> 1] ^ $10 << 8 & 65280;
       }
       $4 = $11;
       HEAP32[$5 + 32 >> 2] = 0;
       HEAP32[$5 + 24 >> 2] = $4;
      }
      $2 = FLAC__crc16_update_words32(HEAP32[$5 >> 2] + ($2 << 2) | 0, $9 - $2 | 0, HEAPU16[$5 + 24 >> 1]);
      HEAP32[$5 + 28 >> 2] = 0;
      HEAP32[$5 + 24 >> 2] = $2;
      $3 = HEAP32[$5 + 20 >> 2];
      label$536 : {
       if (!$3) {
        break label$536
       }
       $4 = HEAP32[$5 + 32 >> 2];
       if ($3 >>> 0 <= $4 >>> 0) {
        break label$536
       }
       $7 = HEAP32[HEAP32[$5 >> 2] + (HEAP32[$5 + 16 >> 2] << 2) >> 2];
       while (1) {
        $2 = HEAPU16[(($7 >>> 24 - $4 & 255 ^ $2 >>> 8) << 1) + 1280 >> 1] ^ $2 << 8 & 65280;
        $4 = $4 + 8 | 0;
        if ($3 >>> 0 > $4 >>> 0) {
         continue
        }
        break;
       };
       HEAP32[$5 + 32 >> 2] = $4;
       HEAP32[$5 + 24 >> 2] = $2;
      }
      $15 = 0;
      if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$6 >> 2] + 56 >> 2], $8 + 16 | 0, HEAP32[1681])) {
       break label$1
      }
      label$138 : {
       if (HEAP32[$8 + 16 >> 2] == ($2 | 0)) {
        label$140 : {
         label$141 : {
          label$142 : {
           $4 = HEAP32[$6 >> 2];
           switch (HEAP32[$4 + 1148 >> 2] - 1 | 0) {
           case 2:
            break label$140;
           case 0:
            break label$141;
           case 1:
            break label$142;
           default:
            break label$138;
           };
          }
          if (!HEAP32[$4 + 1136 >> 2]) {
           break label$138
          }
          $5 = HEAP32[$4 - -64 >> 2];
          $3 = HEAP32[$4 + 60 >> 2];
          $2 = 0;
          while (1) {
           $7 = $2 << 2;
           $9 = $7 + $3 | 0;
           HEAP32[$9 >> 2] = HEAP32[$9 >> 2] + HEAP32[$5 + $7 >> 2];
           $2 = $2 + 1 | 0;
           if ($2 >>> 0 < HEAPU32[$4 + 1136 >> 2]) {
            continue
           }
           break;
          };
          break label$138;
         }
         if (!HEAP32[$4 + 1136 >> 2]) {
          break label$138
         }
         $5 = HEAP32[$4 - -64 >> 2];
         $3 = HEAP32[$4 + 60 >> 2];
         $2 = 0;
         while (1) {
          $7 = $2 << 2;
          $9 = $7 + $5 | 0;
          HEAP32[$9 >> 2] = HEAP32[$3 + $7 >> 2] - HEAP32[$9 >> 2];
          $2 = $2 + 1 | 0;
          if ($2 >>> 0 < HEAPU32[$4 + 1136 >> 2]) {
           continue
          }
          break;
         };
         break label$138;
        }
        if (!HEAP32[$4 + 1136 >> 2]) {
         break label$138
        }
        $9 = HEAP32[$4 - -64 >> 2];
        $10 = HEAP32[$4 + 60 >> 2];
        $2 = 0;
        while (1) {
         $3 = $2 << 2;
         $5 = $3 + $10 | 0;
         $11 = $3 + $9 | 0;
         $3 = HEAP32[$11 >> 2];
         $7 = $3 & 1 | HEAP32[$5 >> 2] << 1;
         HEAP32[$5 >> 2] = $3 + $7 >> 1;
         HEAP32[$11 >> 2] = $7 - $3 >> 1;
         $2 = $2 + 1 | 0;
         if ($2 >>> 0 < HEAPU32[$4 + 1136 >> 2]) {
          continue
         }
         break;
        };
        break label$138;
       }
       $2 = HEAP32[$6 >> 2];
       if (!HEAP32[$2 + 3632 >> 2]) {
        FUNCTION_TABLE[HEAP32[$2 + 32 >> 2]]($0, 2, HEAP32[$2 + 48 >> 2])
       }
       $3 = HEAP32[$6 >> 2];
       if (!HEAP32[$3 + 1144 >> 2]) {
        break label$138
       }
       $2 = 0;
       while (1) {
        memset(HEAP32[(($2 << 2) + $3 | 0) + 60 >> 2], HEAP32[$3 + 1136 >> 2] << 2);
        $2 = $2 + 1 | 0;
        $3 = HEAP32[$6 >> 2];
        if ($2 >>> 0 < HEAPU32[$3 + 1144 >> 2]) {
         continue
        }
        break;
       };
      }
      HEAP32[$1 >> 2] = 1;
      $1 = HEAP32[$6 >> 2];
      $2 = HEAP32[$1 + 232 >> 2];
      if ($2) {
       HEAP32[$1 + 228 >> 2] = $2
      }
      $2 = HEAP32[$0 >> 2];
      HEAP32[$2 + 8 >> 2] = HEAP32[$1 + 1144 >> 2];
      HEAP32[$2 + 12 >> 2] = HEAP32[$1 + 1148 >> 2];
      HEAP32[$2 + 16 >> 2] = HEAP32[$1 + 1152 >> 2];
      HEAP32[$2 + 20 >> 2] = HEAP32[$1 + 1140 >> 2];
      $4 = $2;
      $2 = HEAP32[$1 + 1136 >> 2];
      HEAP32[$4 + 24 >> 2] = $2;
      $5 = $1 + 1160 | 0;
      $4 = $2 + HEAP32[$5 >> 2] | 0;
      $5 = HEAP32[$5 + 4 >> 2];
      HEAP32[$1 + 240 >> 2] = $4;
      HEAP32[$1 + 244 >> 2] = $2 >>> 0 > $4 >>> 0 ? $5 + 1 | 0 : $5;
      $4 = $1 + 1136 | 0;
      $5 = $1 + 60 | 0;
      $3 = __stack_pointer - 32 | 0;
      __stack_pointer = $3;
      $1 = $0;
      $2 = HEAP32[$0 + 4 >> 2];
      label$139 : {
       if (HEAP32[$2 + 3632 >> 2]) {
        $11 = HEAP32[$4 >> 2];
        $9 = HEAP32[$4 + 24 >> 2];
        $6 = HEAP32[$4 + 28 >> 2];
        HEAP32[$2 + 6156 >> 2] = 1;
        $10 = HEAP32[$2 + 6144 >> 2];
        $7 = HEAP32[$2 + 6148 >> 2];
        __memcpy($2 + 3752 | 0, $4, 2384);
        $2 = 0;
        if (($6 | 0) == ($7 | 0) & $9 >>> 0 > $10 >>> 0 | $6 >>> 0 > $7 >>> 0) {
         break label$139
        }
        $14 = $6 + 1 | 0;
        $13 = $6;
        $6 = $9 + $11 | 0;
        $11 = $6 >>> 0 < $11 >>> 0 ? $14 : $13;
        if (($11 | 0) == ($7 | 0) & $6 >>> 0 <= $10 >>> 0 | $7 >>> 0 > $11 >>> 0) {
         break label$139
        }
        $6 = HEAP32[$1 + 4 >> 2];
        HEAP32[$6 + 3632 >> 2] = 0;
        $11 = $10 - $9 | 0;
        $7 = $11;
        if ($7) {
         $4 = HEAP32[$4 + 8 >> 2];
         label$440 : {
          if (!$4) {
           break label$440
          }
          $9 = $4 & 3;
          if ($4 - 1 >>> 0 >= 3) {
           $17 = $4 & -4;
           while (1) {
            $4 = $2 << 2;
            $10 = $7 << 2;
            HEAP32[$4 + $3 >> 2] = $10 + HEAP32[$4 + $5 >> 2];
            $16 = $4 | 4;
            HEAP32[$16 + $3 >> 2] = HEAP32[$5 + $16 >> 2] + $10;
            $16 = $4 | 8;
            HEAP32[$16 + $3 >> 2] = HEAP32[$5 + $16 >> 2] + $10;
            $4 = $4 | 12;
            HEAP32[$4 + $3 >> 2] = HEAP32[$4 + $5 >> 2] + $10;
            $2 = $2 + 4 | 0;
            $17 = $17 - 4 | 0;
            if ($17) {
             continue
            }
            break;
           };
          }
          if (!$9) {
           break label$440
          }
          while (1) {
           $4 = $2 << 2;
           HEAP32[$4 + $3 >> 2] = HEAP32[$4 + $5 >> 2] + ($7 << 2);
           $2 = $2 + 1 | 0;
           $9 = $9 - 1 | 0;
           if ($9) {
            continue
           }
           break;
          };
         }
         HEAP32[$6 + 3752 >> 2] = HEAP32[$6 + 3752 >> 2] - $7;
         $2 = $6 + 3776 | 0;
         $5 = $2;
         $4 = HEAP32[$2 + 4 >> 2];
         $2 = $11 + HEAP32[$2 >> 2] | 0;
         HEAP32[$5 >> 2] = $2;
         HEAP32[$5 + 4 >> 2] = $2 >>> 0 < $11 >>> 0 ? $4 + 1 | 0 : $4;
         $2 = $1;
         $1 = HEAP32[$1 + 4 >> 2];
         $2 = FUNCTION_TABLE[HEAP32[$1 + 24 >> 2]]($2, $1 + 3752 | 0, $3, HEAP32[$1 + 48 >> 2]) | 0;
         break label$139;
        }
        $2 = FUNCTION_TABLE[HEAP32[$6 + 24 >> 2]]($1, $4, $5, HEAP32[$6 + 48 >> 2]) | 0;
        break label$139;
       }
       label$843 : {
        if (!HEAP32[$2 + 248 >> 2]) {
         HEAP32[$2 + 3624 >> 2] = 0;
         break label$843;
        }
        if (!HEAP32[$2 + 3624 >> 2]) {
         break label$843
        }
        if (!FLAC__MD5Accumulate($2 + 3636 | 0, $5, HEAP32[$4 + 8 >> 2], HEAP32[$4 >> 2], HEAP32[$4 + 16 >> 2] + 7 >>> 3 | 0)) {
         $2 = 1;
         break label$139;
        }
        $2 = HEAP32[$1 + 4 >> 2];
       }
       $2 = FUNCTION_TABLE[HEAP32[$2 + 24 >> 2]]($1, $4, $5, HEAP32[$2 + 48 >> 2]) | 0;
      }
      __stack_pointer = $3 + 32 | 0;
      $0 = HEAP32[$0 >> 2];
      if ($2) {
       HEAP32[$0 >> 2] = 7;
       break label$1;
      }
      HEAP32[$0 >> 2] = 2;
     }
     $15 = 1;
     break label$1;
    }
    $15 = 0;
    break label$1;
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
   $15 = 0;
  }
  __stack_pointer = $8 + 48 | 0;
  return $15;
 }
 
 function read_residual_partitioned_rice_($0, $1, $2, $3, $4, $5) {
  var $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
  $13 = __stack_pointer - 16 | 0;
  __stack_pointer = $13;
  $6 = HEAP32[HEAP32[$0 + 4 >> 2] + 1136 >> 2];
  $27 = HEAP32[($5 ? 6752 : 6748) >> 2];
  $28 = HEAP32[($5 ? 6740 : 6736) >> 2];
  label$1 : {
   if (FLAC__format_entropy_coding_method_partitioned_rice_contents_ensure_size($3, $2 >>> 0 > 6 ? $2 : 6)) {
    $24 = $2 ? $6 >>> $2 | 0 : $6 - $1 | 0;
    $29 = HEAP32[1686];
    $5 = 0;
    while (1) {
     if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $13 + 12 | 0, $28)) {
      $14 = 0;
      break label$1;
     }
     $6 = $20 << 2;
     HEAP32[$6 + HEAP32[$3 >> 2] >> 2] = HEAP32[$13 + 12 >> 2];
     label$5 : {
      if ($27 >>> 0 > HEAPU32[$13 + 12 >> 2]) {
       $14 = 0;
       HEAP32[$6 + HEAP32[$3 + 4 >> 2] >> 2] = 0;
       $8 = HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2];
       $11 = 0;
       $15 = 0;
       $22 = 0;
       $19 = 0;
       $21 = 0;
       $12 = __stack_pointer - 16 | 0;
       __stack_pointer = $12;
       $10 = ($5 << 2) + $4 | 0;
       $25 = $24 - ($2 ? ($20 ? 0 : $1) : 0) | 0;
       $6 = $25;
       $23 = $10 + ($6 << 2) | 0;
       label$10 : {
        $17 = HEAP32[$13 + 12 >> 2];
        if (!$17) {
         $22 = 1;
         if (($6 | 0) < 1) {
          break label$10
         }
         while (1) {
          if (!FLAC__bitreader_read_unary_unsigned($8, $12 + 8 | 0)) {
           $22 = 0;
           break label$10;
          }
          $6 = HEAP32[$12 + 8 >> 2];
          HEAP32[$10 >> 2] = $6 >>> 1 ^ 0 - ($6 & 1);
          $10 = $10 + 4 | 0;
          if ($23 >>> 0 > $10 >>> 0) {
           continue
          }
          break;
         };
         break label$10;
        }
        $6 = HEAP32[$8 + 16 >> 2];
        $18 = HEAP32[$8 + 8 >> 2];
        label$52 : {
         if ($6 >>> 0 < $18 >>> 0) {
          $19 = HEAP32[$8 >> 2];
          $21 = HEAP32[$8 + 20 >> 2];
          $15 = HEAP32[$19 + ($6 << 2) >> 2] << $21;
          $7 = 0;
          break label$52;
         }
         $7 = 1;
        }
        while (1) {
         label$9 : {
          label$103 : {
           label$11 : {
            label$12 : {
             if (!$7) {
              $9 = 32 - $21 | 0;
              label$15 : {
               if ($10 >>> 0 < $23 >>> 0) {
                $26 = 32 - $17 | 0;
                while (1) {
                 $7 = $6;
                 $11 = $9;
                 label$18 : {
                  if ($15) {
                   $11 = Math_clz32($15);
                   $16 = $11;
                   break label$18;
                  }
                  while (1) {
                   $7 = $7 + 1 | 0;
                   if ($18 >>> 0 <= $7 >>> 0) {
                    break label$15
                   }
                   $15 = HEAP32[($7 << 2) + $19 >> 2];
                   $16 = Math_clz32($15);
                   $11 = $16 + $11 | 0;
                   if (!$15) {
                    continue
                   }
                   break;
                  };
                 }
                 $6 = $15 << $16 << 1;
                 $16 = $6 >>> $26 | 0;
                 HEAP32[$12 + 8 >> 2] = $11;
                 $9 = ($11 ^ -1) + $9 & 31;
                 label$21 : {
                  if ($17 >>> 0 <= $9 >>> 0) {
                   $15 = $6 << $17;
                   $9 = $9 - $17 | 0;
                   $6 = $7;
                   break label$21;
                  }
                  $6 = $7 + 1 | 0;
                  if ($18 >>> 0 <= $6 >>> 0) {
                   break label$12
                  }
                  $7 = HEAP32[($6 << 2) + $19 >> 2];
                  $9 = $9 + $26 | 0;
                  $15 = $7 << 32 - $9;
                  $16 = $7 >>> $9 | $16;
                 }
                 HEAP32[$12 + 12 >> 2] = $16;
                 $7 = $11 << $17 | $16;
                 HEAP32[$10 >> 2] = $7 >>> 1 ^ 0 - ($7 & 1);
                 $10 = $10 + 4 | 0;
                 if ($23 >>> 0 > $10 >>> 0) {
                  continue
                 }
                 break;
                };
               }
               $7 = $6;
               $6 = $6 >>> 0 < $18 >>> 0;
               HEAP32[$8 + 16 >> 2] = $7 + ($6 & !$9);
               HEAP32[$8 + 20 >> 2] = 32 - ($9 ? $9 : $6 << 5);
               $22 = 1;
               break label$10;
              }
              HEAP32[$8 + 20 >> 2] = 0;
              $7 = $6 + 1 | 0;
              HEAP32[$8 + 16 >> 2] = $7 >>> 0 < $18 >>> 0 ? $18 : $7;
              break label$103;
             }
             if (!FLAC__bitreader_read_unary_unsigned($8, $12 + 8 | 0)) {
              break label$10
             }
             $11 = HEAP32[$12 + 8 >> 2] + $11 | 0;
             HEAP32[$12 + 8 >> 2] = $11;
             $16 = 0;
             $9 = 0;
             break label$11;
            }
            HEAP32[$8 + 16 >> 2] = $6;
            HEAP32[$8 + 20 >> 2] = 0;
           }
           if (!FLAC__bitreader_read_raw_uint32($8, $12 + 12 | 0, $17 - $9 | 0)) {
            break label$10
           }
           $6 = $11 << $17;
           $7 = HEAP32[$12 + 12 >> 2] | $16;
           HEAP32[$12 + 12 >> 2] = $7;
           $11 = 0;
           $6 = $6 | $7;
           HEAP32[$10 >> 2] = $6 >>> 1 ^ 0 - ($6 & 1);
           $19 = HEAP32[$8 >> 2];
           $6 = HEAP32[$8 + 16 >> 2];
           $21 = HEAP32[$8 + 20 >> 2];
           $15 = HEAP32[$19 + ($6 << 2) >> 2] << $21;
           $10 = $10 + 4 | 0;
           $18 = HEAP32[$8 + 8 >> 2];
           if ($23 >>> 0 <= $10 >>> 0 | $18 >>> 0 > $6 >>> 0) {
            break label$9
           }
          }
          $7 = 1;
          continue;
         }
         $7 = 0;
         continue;
        };
       }
       __stack_pointer = $12 + 16 | 0;
       if (!$22) {
        break label$1
       }
       $5 = $5 + $25 | 0;
       break label$5;
      }
      if (!FLAC__bitreader_read_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $13 + 12 | 0, $29)) {
       $14 = 0;
       break label$1;
      }
      HEAP32[$6 + HEAP32[$3 + 4 >> 2] >> 2] = HEAP32[$13 + 12 >> 2];
      $14 = $2 ? ($20 ? 0 : $1) : 0;
      if ($24 >>> 0 <= $14 >>> 0) {
       break label$5
      }
      while (1) {
       if (!FLAC__bitreader_read_raw_int32(HEAP32[HEAP32[$0 + 4 >> 2] + 56 >> 2], $13 + 8 | 0, HEAP32[$13 + 12 >> 2])) {
        $14 = 0;
        break label$1;
       }
       HEAP32[($5 << 2) + $4 >> 2] = HEAP32[$13 + 8 >> 2];
       $5 = $5 + 1 | 0;
       $14 = $14 + 1 | 0;
       if (($24 | 0) != ($14 | 0)) {
        continue
       }
       break;
      };
     }
     $14 = 1;
     $20 = $20 + 1 | 0;
     if (!($20 >>> $2 | 0)) {
      continue
     }
     break;
    };
    break label$1;
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
  }
  __stack_pointer = $13 + 16 | 0;
  return $14;
 }
 
 function FLAC__stream_decoder_process_until_end_of_metadata($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0;
  label$1 : {
   label$2 : {
    while (1) {
     label$3 : {
      $1 = 1;
      label$5 : {
       switch (HEAP32[HEAP32[$0 >> 2] >> 2]) {
       case 0:
        if (find_metadata_($0)) {
         continue
        }
        break label$3;
       case 2:
       case 3:
       case 4:
       case 7:
        break label$2;
       case 1:
        break label$5;
       default:
        break label$1;
       };
      }
      if (read_metadata_($0)) {
       continue
      }
     }
     break;
    };
    $1 = 0;
   }
   $2 = $1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_decoder_process_until_end_of_stream($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0;
  $1 = __stack_pointer - 16 | 0;
  __stack_pointer = $1;
  $2 = 1;
  label$1 : {
   label$2 : {
    while (1) {
     label$3 : {
      label$5 : {
       switch (HEAP32[HEAP32[$0 >> 2] >> 2]) {
       case 0:
        if (find_metadata_($0)) {
         continue
        }
        break label$3;
       case 1:
        if (read_metadata_($0)) {
         continue
        }
        break label$3;
       case 2:
        if (frame_sync_($0)) {
         continue
        }
        break label$2;
       case 4:
       case 7:
        break label$2;
       case 3:
        break label$5;
       default:
        break label$1;
       };
      }
      if (read_frame_($0, $1 + 12 | 0)) {
       continue
      }
     }
     break;
    };
    $2 = 0;
   }
   $3 = $2;
  }
  __stack_pointer = $1 + 16 | 0;
  return $3 | 0;
 }
 
 function read_callback_proxy_($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0;
  $4 = 5;
  $0 = FUNCTION_TABLE[HEAP32[HEAP32[$0 + 4 >> 2] + 4 >> 2]]($0, $1, $2, $3) | 0;
  if ($0 >>> 0 <= 2) {
   $4 = HEAP32[($0 << 2) + 7856 >> 2]
  }
  return $4 | 0;
 }
 
 function FLAC__bitwriter_clear($0) {
  HEAP32[$0 + 12 >> 2] = 0;
  HEAP32[$0 + 16 >> 2] = 0;
 }
 
 function FLAC__bitwriter_get_buffer($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  $5 = HEAP32[$0 + 16 >> 2];
  label$1 : {
   if ($5 & 7) {
    break label$1
   }
   label$2 : {
    if (!$5) {
     $4 = HEAP32[$0 >> 2];
     $3 = 0;
     break label$2;
    }
    $3 = HEAP32[$0 + 12 >> 2];
    label$4 : {
     if (($3 | 0) != HEAP32[$0 + 8 >> 2]) {
      break label$4
     }
     $4 = $5 + 63 >>> 5 | 0;
     $6 = $4 + $3 | 0;
     if ($6 >>> 0 <= $3 >>> 0) {
      break label$4
     }
     $3 = 0;
     $5 = HEAP32[$0 >> 2];
     $4 = $4 & 1023;
     $6 = ($4 ? 1024 - $4 | 0 : 0) + $6 | 0;
     label$5 : {
      if ($6) {
       if ($6 >>> 0 > 1073741823) {
        break label$1
       }
       $4 = dlrealloc($5, $6 << 2);
       if ($4) {
        break label$5
       }
       dlfree($5);
       return 0;
      }
      $4 = dlrealloc($5, 0);
      if (!$4) {
       break label$1
      }
     }
     HEAP32[$0 + 8 >> 2] = $6;
     HEAP32[$0 >> 2] = $4;
     $3 = HEAP32[$0 + 12 >> 2];
     $5 = HEAP32[$0 + 16 >> 2];
    }
    $4 = HEAP32[$0 >> 2];
    $6 = $4 + ($3 << 2) | 0;
    $3 = HEAP32[$0 + 4 >> 2] << 32 - $5;
    HEAP32[$6 >> 2] = $3 << 24 | $3 << 8 & 16711680 | ($3 >>> 8 & 65280 | $3 >>> 24);
    $3 = HEAP32[$0 + 16 >> 2] >>> 3 | 0;
   }
   HEAP32[$1 >> 2] = $4;
   HEAP32[$2 >> 2] = (HEAP32[$0 + 12 >> 2] << 2) + $3;
   $3 = 1;
  }
  return $3;
 }
 
 function FLAC__bitwriter_write_zeroes($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0;
  label$1 : {
   label$2 : {
    if (!$1) {
     break label$2
    }
    $4 = HEAP32[$0 + 8 >> 2];
    $2 = HEAP32[$0 + 12 >> 2];
    label$3 : {
     if ($4 >>> 0 > $2 + $1 >>> 0) {
      break label$3
     }
     $5 = $2 + ((HEAP32[$0 + 16 >> 2] + $1 | 0) + 31 >>> 5 | 0) | 0;
     if ($5 >>> 0 <= $4 >>> 0) {
      break label$3
     }
     $2 = 0;
     $3 = HEAP32[$0 >> 2];
     $4 = $5 - $4 & 1023;
     $4 = $5 + ($4 ? 1024 - $4 | 0 : 0) | 0;
     label$4 : {
      if ($4) {
       if ($4 >>> 0 > 1073741823) {
        break label$1
       }
       $5 = dlrealloc($3, $4 << 2);
       if ($5) {
        break label$4
       }
       dlfree($3);
       return 0;
      }
      $5 = dlrealloc($3, 0);
      if (!$5) {
       break label$1
      }
     }
     HEAP32[$0 + 8 >> 2] = $4;
     HEAP32[$0 >> 2] = $5;
    }
    $2 = HEAP32[$0 + 16 >> 2];
    if ($2) {
     $5 = $2;
     $2 = 32 - $2 | 0;
     $3 = $1 >>> 0 > $2 >>> 0 ? $2 : $1;
     $4 = $5 + $3 | 0;
     HEAP32[$0 + 16 >> 2] = $4;
     $2 = HEAP32[$0 + 4 >> 2] << $3;
     HEAP32[$0 + 4 >> 2] = $2;
     if (($4 | 0) != 32) {
      break label$2
     }
     $4 = HEAP32[$0 + 12 >> 2];
     HEAP32[$0 + 12 >> 2] = $4 + 1;
     HEAP32[HEAP32[$0 >> 2] + ($4 << 2) >> 2] = $2 << 8 & 16711680 | $2 << 24 | ($2 >>> 8 & 65280 | $2 >>> 24);
     HEAP32[$0 + 16 >> 2] = 0;
     $1 = $1 - $3 | 0;
    }
    label$7 : {
     if ($1 >>> 0 < 32) {
      break label$7
     }
     $2 = HEAP32[$0 >> 2];
     $4 = $1 - 32 | 0;
     $3 = ($4 >>> 5 | 0) + 1 & 3;
     if ($3) {
      while (1) {
       $5 = HEAP32[$0 + 12 >> 2];
       HEAP32[$0 + 12 >> 2] = $5 + 1;
       HEAP32[$2 + ($5 << 2) >> 2] = 0;
       $1 = $1 - 32 | 0;
       $3 = $3 - 1 | 0;
       if ($3) {
        continue
       }
       break;
      }
     }
     if ($4 >>> 0 < 96) {
      break label$7
     }
     while (1) {
      $3 = HEAP32[$0 + 12 >> 2];
      HEAP32[$0 + 12 >> 2] = $3 + 1;
      HEAP32[$2 + ($3 << 2) >> 2] = 0;
      $3 = HEAP32[$0 + 12 >> 2];
      HEAP32[$0 + 12 >> 2] = $3 + 1;
      HEAP32[$2 + ($3 << 2) >> 2] = 0;
      $3 = HEAP32[$0 + 12 >> 2];
      HEAP32[$0 + 12 >> 2] = $3 + 1;
      HEAP32[$2 + ($3 << 2) >> 2] = 0;
      $3 = HEAP32[$0 + 12 >> 2];
      HEAP32[$0 + 12 >> 2] = $3 + 1;
      HEAP32[$2 + ($3 << 2) >> 2] = 0;
      $1 = $1 - 128 | 0;
      if ($1 >>> 0 > 31) {
       continue
      }
      break;
     };
    }
    if (!$1) {
     break label$2
    }
    HEAP32[$0 + 16 >> 2] = $1;
    HEAP32[$0 + 4 >> 2] = 0;
   }
   $2 = 1;
  }
  return $2;
 }
 
 function FLAC__bitwriter_write_raw_uint32($0, $1, $2) {
  var $3 = 0;
  label$1 : {
   if ($2 >>> 0 <= 31) {
    $3 = 0;
    if ($1 >>> $2 | 0) {
     break label$1
    }
   }
   $3 = FLAC__bitwriter_write_raw_uint32_nocheck($0, $1, $2);
  }
  return $3;
 }
 
 function FLAC__bitwriter_write_raw_uint32_nocheck($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
  label$1 : {
   if (!$0) {
    break label$1
   }
   $4 = HEAP32[$0 >> 2];
   if (!$4 | $2 >>> 0 > 32) {
    break label$1
   }
   $6 = 1;
   if (!$2) {
    break label$1
   }
   $7 = HEAP32[$0 + 8 >> 2];
   $3 = HEAP32[$0 + 12 >> 2];
   label$2 : {
    if ($7 >>> 0 > $3 + $2 >>> 0) {
     $3 = $4;
     break label$2;
    }
    $5 = $3 + ((HEAP32[$0 + 16 >> 2] + $2 | 0) + 31 >>> 5 | 0) | 0;
    if ($7 >>> 0 >= $5 >>> 0) {
     $3 = $4;
     break label$2;
    }
    $6 = 0;
    $3 = $5 - $7 & 1023;
    $5 = $5 + ($3 ? 1024 - $3 | 0 : 0) | 0;
    label$5 : {
     if ($5) {
      if ($5 >>> 0 > 1073741823) {
       break label$1
      }
      $3 = dlrealloc($4, $5 << 2);
      if ($3) {
       break label$5
      }
      dlfree($4);
      return 0;
     }
     $3 = dlrealloc($4, 0);
     if (!$3) {
      break label$1
     }
    }
    HEAP32[$0 + 8 >> 2] = $5;
    HEAP32[$0 >> 2] = $3;
   }
   $4 = HEAP32[$0 + 16 >> 2];
   $5 = 32 - $4 | 0;
   if ($2 >>> 0 < $5 >>> 0) {
    HEAP32[$0 + 16 >> 2] = $2 + $4;
    HEAP32[$0 + 4 >> 2] = HEAP32[$0 + 4 >> 2] << $2 | $1;
    return 1;
   }
   if ($4) {
    $4 = $2 - $5 | 0;
    HEAP32[$0 + 16 >> 2] = $4;
    $2 = HEAP32[$0 + 12 >> 2];
    HEAP32[$0 + 12 >> 2] = $2 + 1;
    $3 = ($2 << 2) + $3 | 0;
    $2 = HEAP32[$0 + 4 >> 2] << $5 | $1 >>> $4;
    HEAP32[$3 >> 2] = $2 << 24 | $2 << 8 & 16711680 | ($2 >>> 8 & 65280 | $2 >>> 24);
    HEAP32[$0 + 4 >> 2] = $1;
    return 1;
   }
   $6 = 1;
   $2 = $0;
   $0 = HEAP32[$0 + 12 >> 2];
   HEAP32[$2 + 12 >> 2] = $0 + 1;
   HEAP32[($0 << 2) + $3 >> 2] = $1 << 8 & 16711680 | $1 << 24 | ($1 >>> 8 & 65280 | $1 >>> 24);
  }
  return $6;
 }
 
 function FLAC__bitwriter_write_raw_int32($0, $1, $2) {
  return FLAC__bitwriter_write_raw_uint32_nocheck($0, ($2 >>> 0 < 32 ? -1 << $2 ^ -1 : -1) & $1, $2);
 }
 
 function FLAC__bitwriter_write_raw_uint64($0, $1, $2, $3) {
  var $4 = 0;
  label$1 : {
   if ($3 >>> 0 >= 33) {
    $3 = $3 - 32 | 0;
    if ($2 >>> $3 | 0 ? $3 >>> 0 <= 31 : 0) {
     break label$1
    }
    if (!FLAC__bitwriter_write_raw_uint32_nocheck($0, $2, $3)) {
     break label$1
    }
    return (FLAC__bitwriter_write_raw_uint32_nocheck($0, $1, 32) | 0) != 0;
   }
   if (($3 | 0) != 32) {
    if ($1 >>> $3 | 0) {
     break label$1
    }
   }
   $4 = FLAC__bitwriter_write_raw_uint32_nocheck($0, $1, $3);
  }
  return $4;
 }
 
 function FLAC__bitwriter_write_raw_uint32_little_endian($0, $1) {
  var $2 = 0;
  label$1 : {
   if (!FLAC__bitwriter_write_raw_uint32_nocheck($0, $1 & 255, 8)) {
    break label$1
   }
   if (!FLAC__bitwriter_write_raw_uint32_nocheck($0, $1 >>> 8 & 255, 8)) {
    break label$1
   }
   if (!FLAC__bitwriter_write_raw_uint32_nocheck($0, $1 >>> 16 & 255, 8)) {
    break label$1
   }
   $2 = (FLAC__bitwriter_write_raw_uint32_nocheck($0, $1 >>> 24 | 0, 8) | 0) != 0;
  }
  return $2;
 }
 
 function FLAC__bitwriter_write_byte_block($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  $3 = HEAP32[$0 + 8 >> 2];
  $4 = HEAP32[$0 + 12 >> 2];
  label$1 : {
   label$2 : {
    if ($3 >>> 0 > ($4 + ($2 >>> 2 | 0) | 0) + 1 >>> 0) {
     break label$2
    }
    $5 = $4 + ((HEAP32[$0 + 16 >> 2] + ($2 << 3) | 0) + 31 >>> 5 | 0) | 0;
    if ($5 >>> 0 <= $3 >>> 0) {
     break label$2
    }
    $4 = 0;
    $6 = HEAP32[$0 >> 2];
    $3 = $5 - $3 & 1023;
    $3 = $5 + ($3 ? 1024 - $3 | 0 : 0) | 0;
    label$3 : {
     if ($3) {
      if ($3 >>> 0 > 1073741823) {
       break label$1
      }
      $5 = dlrealloc($6, $3 << 2);
      if ($5) {
       break label$3
      }
      dlfree($6);
      return 0;
     }
     $5 = dlrealloc($6, 0);
     if (!$5) {
      break label$1
     }
    }
    HEAP32[$0 + 8 >> 2] = $3;
    HEAP32[$0 >> 2] = $5;
   }
   $4 = 1;
   if (!$2) {
    break label$1
   }
   $4 = 0;
   label$5 : {
    while (1) {
     if (!FLAC__bitwriter_write_raw_uint32_nocheck($0, HEAPU8[$1 + $4 | 0], 8)) {
      break label$5
     }
     $4 = $4 + 1 | 0;
     if (($4 | 0) != ($2 | 0)) {
      continue
     }
     break;
    };
    return 1;
   }
   $4 = 0;
  }
  return $4;
 }
 
 function FLAC__bitwriter_write_unary_unsigned($0, $1) {
  if ($1 >>> 0 <= 31) {
   return FLAC__bitwriter_write_raw_uint32_nocheck($0, 1, $1 + 1 | 0)
  }
  if (!FLAC__bitwriter_write_zeroes($0, $1)) {
   return 0
  }
  return (FLAC__bitwriter_write_raw_uint32_nocheck($0, 1, 1) | 0) != 0;
 }
 
 function FLAC__bitwriter_write_rice_signed_block($0, $1, $2, $3) {
  var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0;
  $5 = 1;
  label$1 : {
   if (!$2) {
    break label$1
   }
   $9 = $3 + 1 | 0;
   $11 = -1 << $3;
   $12 = -1 >>> 31 - $3 | 0;
   while (1) {
    $6 = HEAP32[$1 >> 2];
    $10 = $6 << 1 ^ $6 >> 31;
    $6 = $10 >>> $3 | 0;
    $4 = $6 + $9 | 0;
    label$3 : {
     label$4 : {
      $5 = HEAP32[$0 + 16 >> 2];
      if (!$5) {
       break label$4
      }
      $7 = $4 + $5 | 0;
      if ($7 >>> 0 > 31) {
       break label$4
      }
      HEAP32[$0 + 16 >> 2] = $7;
      HEAP32[$0 + 4 >> 2] = ($11 | $10) & $12 | HEAP32[$0 + 4 >> 2] << $4;
      break label$3;
     }
     $8 = HEAP32[$0 + 8 >> 2];
     $7 = HEAP32[$0 + 12 >> 2];
     label$5 : {
      if ($8 >>> 0 > ($7 + ($6 + $5 | 0) | 0) + 1 >>> 0) {
       break label$5
      }
      $4 = $7 + (($4 + $5 | 0) + 31 >>> 5 | 0) | 0;
      if ($4 >>> 0 <= $8 >>> 0) {
       break label$5
      }
      $7 = HEAP32[$0 >> 2];
      $5 = $4 - $8 & 1023;
      $8 = $4 + ($5 ? 1024 - $5 | 0 : 0) | 0;
      label$6 : {
       if ($8) {
        $5 = 0;
        if ($8 >>> 0 > 1073741823) {
         break label$1
        }
        $4 = dlrealloc($7, $8 << 2);
        if ($4) {
         break label$6
        }
        dlfree($7);
        return 0;
       }
       $4 = dlrealloc($7, 0);
       $5 = 0;
       if (!$4) {
        break label$1
       }
      }
      HEAP32[$0 + 8 >> 2] = $8;
      HEAP32[$0 >> 2] = $4;
     }
     label$8 : {
      if (!$6) {
       break label$8
      }
      $4 = HEAP32[$0 + 16 >> 2];
      label$9 : {
       if ($4) {
        $5 = HEAP32[$0 + 4 >> 2];
        $7 = 32 - $4 | 0;
        if ($6 >>> 0 < $7 >>> 0) {
         HEAP32[$0 + 4 >> 2] = $5 << $6;
         $6 = $4 + $6 | 0;
         break label$9;
        }
        $4 = $5 << $7;
        HEAP32[$0 + 4 >> 2] = $4;
        $5 = HEAP32[$0 + 12 >> 2];
        HEAP32[$0 + 12 >> 2] = $5 + 1;
        HEAP32[HEAP32[$0 >> 2] + ($5 << 2) >> 2] = $4 << 8 & 16711680 | $4 << 24 | ($4 >>> 8 & 65280 | $4 >>> 24);
        HEAP32[$0 + 16 >> 2] = 0;
        $6 = $6 - $7 | 0;
       }
       label$12 : {
        if ($6 >>> 0 < 32) {
         break label$12
        }
        $5 = HEAP32[$0 >> 2];
        $7 = $6 - 32 | 0;
        $4 = ($7 >>> 5 | 0) + 1 & 3;
        if ($4) {
         while (1) {
          $8 = HEAP32[$0 + 12 >> 2];
          HEAP32[$0 + 12 >> 2] = $8 + 1;
          HEAP32[$5 + ($8 << 2) >> 2] = 0;
          $6 = $6 - 32 | 0;
          $4 = $4 - 1 | 0;
          if ($4) {
           continue
          }
          break;
         }
        }
        if ($7 >>> 0 < 96) {
         break label$12
        }
        while (1) {
         $4 = HEAP32[$0 + 12 >> 2];
         HEAP32[$0 + 12 >> 2] = $4 + 1;
         HEAP32[$5 + ($4 << 2) >> 2] = 0;
         $4 = HEAP32[$0 + 12 >> 2];
         HEAP32[$0 + 12 >> 2] = $4 + 1;
         HEAP32[$5 + ($4 << 2) >> 2] = 0;
         $4 = HEAP32[$0 + 12 >> 2];
         HEAP32[$0 + 12 >> 2] = $4 + 1;
         HEAP32[$5 + ($4 << 2) >> 2] = 0;
         $4 = HEAP32[$0 + 12 >> 2];
         HEAP32[$0 + 12 >> 2] = $4 + 1;
         HEAP32[$5 + ($4 << 2) >> 2] = 0;
         $6 = $6 - 128 | 0;
         if ($6 >>> 0 > 31) {
          continue
         }
         break;
        };
       }
       if (!$6) {
        break label$8
       }
       HEAP32[$0 + 4 >> 2] = 0;
      }
      HEAP32[$0 + 16 >> 2] = $6;
     }
     $6 = ($11 | $10) & $12;
     $4 = HEAP32[$0 + 4 >> 2];
     $7 = HEAP32[$0 + 16 >> 2];
     $5 = 32 - $7 | 0;
     if ($9 >>> 0 < $5 >>> 0) {
      HEAP32[$0 + 16 >> 2] = $7 + $9;
      HEAP32[$0 + 4 >> 2] = $6 | $4 << $9;
      break label$3;
     }
     $7 = $9 - $5 | 0;
     HEAP32[$0 + 16 >> 2] = $7;
     $8 = HEAP32[$0 + 12 >> 2];
     HEAP32[$0 + 12 >> 2] = $8 + 1;
     $4 = $4 << $5 | $6 >>> $7;
     HEAP32[HEAP32[$0 >> 2] + ($8 << 2) >> 2] = $4 << 24 | $4 << 8 & 16711680 | ($4 >>> 8 & 65280 | $4 >>> 24);
     HEAP32[$0 + 4 >> 2] = $6;
    }
    $1 = $1 + 4 | 0;
    $2 = $2 - 1 | 0;
    if ($2) {
     continue
    }
    break;
   };
   $5 = 1;
  }
  return $5;
 }
 
 function FLAC__ogg_encoder_aspect_set_defaults($0) {
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
 }
 
 function simple_ogg_page__init($0) {
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
  $0 = $0 + 8 | 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
 }
 
 function simple_ogg_page__clear($0) {
  var $1 = 0;
  $1 = HEAP32[$0 >> 2];
  if ($1) {
   dlfree($1)
  }
  $1 = HEAP32[$0 + 8 >> 2];
  if ($1) {
   dlfree($1)
  }
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
  $0 = $0 + 8 | 0;
  HEAP32[$0 >> 2] = 0;
  HEAP32[$0 + 4 >> 2] = 0;
 }
 
 function simple_ogg_page__get_at($0, $1, $2, $3, $4, $5, $6) {
  var $7 = 0, $8 = 0;
  $7 = __stack_pointer - 16 | 0;
  __stack_pointer = $7;
  label$1 : {
   if (!$4) {
    break label$1
   }
   label$2 : {
    switch (FUNCTION_TABLE[$4 | 0]($0, $1, $2, $6) | 0) {
    case 1:
     HEAP32[HEAP32[$0 >> 2] >> 2] = 5;
     break label$1;
    case 0:
     break label$2;
    default:
     break label$1;
    };
   }
   $4 = dlmalloc(282);
   HEAP32[$3 >> 2] = $4;
   if (!$4) {
    HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
    break label$1;
   }
   $2 = 27;
   while (1) {
    HEAP32[$7 + 12 >> 2] = $2;
    $1 = 5;
    label$6 : {
     label$7 : {
      switch (FUNCTION_TABLE[$5 | 0]($0, $4, $7 + 12 | 0, $6) | 0) {
      case 1:
       $1 = HEAP32[$7 + 12 >> 2];
       if ($1) {
        break label$6
       }
       $1 = 2;
      default:
       HEAP32[HEAP32[$0 >> 2] >> 2] = $1;
       break label$1;
      case 3:
       break label$1;
      case 0:
       break label$7;
      };
     }
     $1 = HEAP32[$7 + 12 >> 2];
    }
    $4 = $1 + $4 | 0;
    $2 = $2 - $1 | 0;
    if ($2) {
     continue
    }
    break;
   };
   $1 = HEAP32[$3 >> 2];
   HEAP32[$3 + 4 >> 2] = HEAPU8[$1 + 26 | 0] + 27;
   label$10 : {
    if (!(HEAP8[$1 + 5 | 0] & 1 | (HEAPU8[$1 | 0] | HEAPU8[$1 + 1 | 0] << 8 | (HEAPU8[$1 + 2 | 0] << 16 | HEAPU8[$1 + 3 | 0] << 24)) != 1399285583 | ((HEAPU8[$1 + 6 | 0] | HEAPU8[$1 + 7 | 0] << 8 | (HEAPU8[$1 + 8 | 0] << 16 | HEAPU8[$1 + 9 | 0] << 24)) != 0 | (HEAPU8[$1 + 10 | 0] | HEAPU8[$1 + 11 | 0] << 8 | (HEAPU8[$1 + 12 | 0] << 16 | HEAPU8[$1 + 13 | 0] << 24)) != 0))) {
     $2 = HEAPU8[$1 + 26 | 0];
     if ($2) {
      break label$10
     }
    }
    HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
    break label$1;
   }
   if (!full_read_($0, $1 + 27 | 0, $2, $5, $6)) {
    break label$1
   }
   $1 = HEAP32[$3 >> 2];
   $8 = HEAPU8[$1 + 26 | 0];
   $2 = $8 - 1 | 0;
   if ($2) {
    $4 = 0;
    while (1) {
     if (HEAPU8[($1 + $4 | 0) + 27 | 0] != 255) {
      HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
      $8 = 0;
      break label$1;
     }
     $4 = $4 + 1 | 0;
     if (($2 | 0) != ($4 | 0)) {
      continue
     }
     break;
    };
   }
   $1 = HEAPU8[($1 + $8 | 0) + 26 | 0] + Math_imul($2, 255) | 0;
   HEAP32[$3 + 12 >> 2] = $1;
   $2 = dlmalloc($1 ? $1 : 1);
   HEAP32[$3 + 8 >> 2] = $2;
   if (!$2) {
    HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
    $8 = 0;
    break label$1;
   }
   $8 = 0;
   if (!full_read_($0, $2, $1, $5, $6)) {
    break label$1
   }
   $1 = HEAP32[$3 >> 2];
   HEAP32[$7 + 8 >> 2] = HEAPU8[$1 + 22 | 0] | HEAPU8[$1 + 23 | 0] << 8 | (HEAPU8[$1 + 24 | 0] << 16 | HEAPU8[$1 + 25 | 0] << 24);
   ogg_page_checksum_set($3);
   $1 = HEAP32[$3 >> 2];
   if (HEAP32[$7 + 8 >> 2] == (HEAPU8[$1 + 22 | 0] | HEAPU8[$1 + 23 | 0] << 8 | (HEAPU8[$1 + 24 | 0] << 16 | HEAPU8[$1 + 25 | 0] << 24))) {
    $8 = 1;
    break label$1;
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
  }
  __stack_pointer = $7 + 16 | 0;
  return $8;
 }
 
 function full_read_($0, $1, $2, $3, $4) {
  var $5 = 0, $6 = 0, $7 = 0;
  $6 = __stack_pointer - 16 | 0;
  __stack_pointer = $6;
  $7 = 1;
  label$1 : {
   if (!$2) {
    break label$1
   }
   while (1) {
    HEAP32[$6 + 12 >> 2] = $2;
    $5 = 5;
    label$3 : {
     label$4 : {
      switch (FUNCTION_TABLE[$3 | 0]($0, $1, $6 + 12 | 0, $4) | 0) {
      case 1:
       $5 = HEAP32[$6 + 12 >> 2];
       if ($5) {
        break label$3
       }
       $5 = 2;
      default:
       HEAP32[HEAP32[$0 >> 2] >> 2] = $5;
      case 3:
       $7 = 0;
       break label$1;
      case 0:
       break label$4;
      };
     }
     $5 = HEAP32[$6 + 12 >> 2];
    }
    $1 = $1 + $5 | 0;
    $2 = $2 - $5 | 0;
    if ($2) {
     continue
    }
    break;
   };
  }
  __stack_pointer = $6 + 16 | 0;
  return $7;
 }
 
 function simple_ogg_page__set_at($0, $1, $2, $3, $4, $5, $6) {
  label$1 : {
   if (!$4) {
    break label$1
   }
   label$2 : {
    label$3 : {
     switch (FUNCTION_TABLE[$4 | 0]($0, $1, $2, $6) | 0) {
     case 1:
      break label$2;
     case 0:
      break label$3;
     default:
      break label$1;
     };
    }
    ogg_page_checksum_set($3);
    if (FUNCTION_TABLE[$5 | 0]($0, HEAP32[$3 >> 2], HEAP32[$3 + 4 >> 2], 0, 0, $6) | 0) {
     break label$2
    }
    if (FUNCTION_TABLE[$5 | 0]($0, HEAP32[$3 + 8 >> 2], HEAP32[$3 + 12 >> 2], 0, 0, $6) | 0) {
     break label$2
    }
    return 1;
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = 5;
  }
  return 0;
 }
 
 function __emscripten_stdout_close($0) {
  $0 = $0 | 0;
  return 0;
 }
 
 function __emscripten_stdout_seek($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  i64toi32_i32$HIGH_BITS = 0;
  return 0;
 }
 
 function strcmp($0, $1) {
  var $2 = 0, $3 = 0;
  $2 = HEAPU8[$0 | 0];
  $3 = HEAPU8[$1 | 0];
  label$1 : {
   if (!$2 | ($3 | 0) != ($2 | 0)) {
    break label$1
   }
   while (1) {
    $3 = HEAPU8[$1 + 1 | 0];
    $2 = HEAPU8[$0 + 1 | 0];
    if (!$2) {
     break label$1
    }
    $1 = $1 + 1 | 0;
    $0 = $0 + 1 | 0;
    if (($2 | 0) == ($3 | 0)) {
     continue
    }
    break;
   };
  }
  return $2 - $3 | 0;
 }
 
 function FLAC__add_metadata_block($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0;
  $3 = strlen(HEAP32[2713]);
  label$1 : {
   if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 4 >> 2], HEAP32[1668])) {
    break label$1
   }
   if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 >> 2], HEAP32[1669])) {
    break label$1
   }
   $2 = HEAP32[$0 + 8 >> 2];
   $2 = HEAP32[$0 >> 2] == 4 ? ($2 + $3 | 0) - HEAP32[$0 + 16 >> 2] | 0 : $2;
   $4 = HEAP32[1670];
   if ($2 >>> $4 | 0) {
    break label$1
   }
   if (!FLAC__bitwriter_write_raw_uint32($1, $2, $4)) {
    break label$1
   }
   label$3 : {
    label$4 : {
     label$5 : {
      label$6 : {
       label$7 : {
        label$8 : {
         label$9 : {
          switch (HEAP32[$0 >> 2]) {
          case 3:
           if (!HEAP32[$0 + 16 >> 2]) {
            break label$3
           }
           $4 = HEAP32[1644];
           $6 = HEAP32[1643];
           $7 = HEAP32[1642];
           $2 = 0;
           break label$8;
          case 0:
           if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 16 >> 2], HEAP32[1633])) {
            break label$1
           }
           if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 20 >> 2], HEAP32[1634])) {
            break label$1
           }
           if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 24 >> 2], HEAP32[1635])) {
            break label$1
           }
           if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 28 >> 2], HEAP32[1636])) {
            break label$1
           }
           if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 32 >> 2], HEAP32[1637])) {
            break label$1
           }
           if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 36 >> 2] - 1 | 0, HEAP32[1638])) {
            break label$1
           }
           if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 40 >> 2] - 1 | 0, HEAP32[1639])) {
            break label$1
           }
           $2 = $0 + 48 | 0;
           if (!FLAC__bitwriter_write_raw_uint64($1, HEAP32[$2 >> 2], HEAP32[$2 + 4 >> 2], HEAP32[1640])) {
            break label$1
           }
           if (FLAC__bitwriter_write_byte_block($1, $0 + 56 | 0, 16)) {
            break label$3
           }
           break label$1;
          case 1:
           if (FLAC__bitwriter_write_zeroes($1, HEAP32[$0 + 8 >> 2] << 3)) {
            break label$3
           }
           break label$1;
          case 6:
           break label$5;
          case 5:
           break label$6;
          case 4:
           break label$7;
          case 2:
           break label$9;
          default:
           break label$4;
          };
         }
         $2 = HEAP32[1641] >>> 3 | 0;
         if (!FLAC__bitwriter_write_byte_block($1, $0 + 16 | 0, $2)) {
          break label$1
         }
         if (FLAC__bitwriter_write_byte_block($1, HEAP32[$0 + 20 >> 2], HEAP32[$0 + 8 >> 2] - $2 | 0)) {
          break label$3
         }
         break label$1;
        }
        while (1) {
         $3 = Math_imul($2, 24);
         $5 = $3 + HEAP32[$0 + 20 >> 2] | 0;
         if (!FLAC__bitwriter_write_raw_uint64($1, HEAP32[$5 >> 2], HEAP32[$5 + 4 >> 2], $7)) {
          break label$1
         }
         $5 = $3 + HEAP32[$0 + 20 >> 2] | 0;
         if (!FLAC__bitwriter_write_raw_uint64($1, HEAP32[$5 + 8 >> 2], HEAP32[$5 + 12 >> 2], $6)) {
          break label$1
         }
         if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[($3 + HEAP32[$0 + 20 >> 2] | 0) + 16 >> 2], $4)) {
          break label$1
         }
         $2 = $2 + 1 | 0;
         if ($2 >>> 0 < HEAPU32[$0 + 16 >> 2]) {
          continue
         }
         break;
        };
        break label$3;
       }
       if (!FLAC__bitwriter_write_raw_uint32_little_endian($1, $3)) {
        break label$1
       }
       if (!FLAC__bitwriter_write_byte_block($1, HEAP32[2713], $3)) {
        break label$1
       }
       if (!FLAC__bitwriter_write_raw_uint32_little_endian($1, HEAP32[$0 + 24 >> 2])) {
        break label$1
       }
       if (!HEAP32[$0 + 24 >> 2]) {
        break label$3
       }
       $2 = 0;
       while (1) {
        $3 = $2 << 3;
        if (!FLAC__bitwriter_write_raw_uint32_little_endian($1, HEAP32[$3 + HEAP32[$0 + 28 >> 2] >> 2])) {
         break label$1
        }
        $3 = $3 + HEAP32[$0 + 28 >> 2] | 0;
        if (!FLAC__bitwriter_write_byte_block($1, HEAP32[$3 + 4 >> 2], HEAP32[$3 >> 2])) {
         break label$1
        }
        $2 = $2 + 1 | 0;
        if ($2 >>> 0 < HEAPU32[$0 + 24 >> 2]) {
         continue
        }
        break;
       };
       break label$3;
      }
      if (!FLAC__bitwriter_write_byte_block($1, $0 + 16 | 0, HEAP32[1655] >>> 3 | 0)) {
       break label$1
      }
      $2 = $0 + 152 | 0;
      if (!FLAC__bitwriter_write_raw_uint64($1, HEAP32[$2 >> 2], HEAP32[$2 + 4 >> 2], HEAP32[1656])) {
       break label$1
      }
      if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 160 >> 2] != 0, HEAP32[1657])) {
       break label$1
      }
      if (!FLAC__bitwriter_write_zeroes($1, HEAP32[1658])) {
       break label$1
      }
      if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 164 >> 2], HEAP32[1659])) {
       break label$1
      }
      if (!HEAP32[$0 + 164 >> 2]) {
       break label$3
      }
      $6 = HEAP32[1650] >>> 3 | 0;
      $7 = HEAP32[1647];
      $5 = HEAP32[1646];
      $9 = HEAP32[1645];
      $10 = HEAP32[1654];
      $11 = HEAP32[1653];
      $12 = HEAP32[1652];
      $13 = HEAP32[1651];
      $14 = HEAP32[1649];
      $15 = HEAP32[1648];
      $3 = 0;
      while (1) {
       $2 = HEAP32[$0 + 168 >> 2] + ($3 << 5) | 0;
       if (!FLAC__bitwriter_write_raw_uint64($1, HEAP32[$2 >> 2], HEAP32[$2 + 4 >> 2], $15)) {
        break label$1
       }
       if (!FLAC__bitwriter_write_raw_uint32($1, HEAPU8[$2 + 8 | 0], $14)) {
        break label$1
       }
       if (!FLAC__bitwriter_write_byte_block($1, $2 + 9 | 0, $6)) {
        break label$1
       }
       if (!FLAC__bitwriter_write_raw_uint32($1, HEAP8[$2 + 22 | 0] & 1, $13)) {
        break label$1
       }
       if (!FLAC__bitwriter_write_raw_uint32($1, HEAPU8[$2 + 22 | 0] >>> 1 & 1, $12)) {
        break label$1
       }
       if (!FLAC__bitwriter_write_zeroes($1, $11)) {
        break label$1
       }
       if (!FLAC__bitwriter_write_raw_uint32($1, HEAPU8[$2 + 23 | 0], $10)) {
        break label$1
       }
       $8 = $2 + 23 | 0;
       if (HEAPU8[$8 | 0]) {
        $16 = $2 + 24 | 0;
        $2 = 0;
        while (1) {
         $4 = HEAP32[$16 >> 2] + ($2 << 4) | 0;
         if (!FLAC__bitwriter_write_raw_uint64($1, HEAP32[$4 >> 2], HEAP32[$4 + 4 >> 2], $9)) {
          break label$1
         }
         if (!FLAC__bitwriter_write_raw_uint32($1, HEAPU8[$4 + 8 | 0], $5)) {
          break label$1
         }
         if (!FLAC__bitwriter_write_zeroes($1, $7)) {
          break label$1
         }
         $2 = $2 + 1 | 0;
         if ($2 >>> 0 < HEAPU8[$8 | 0]) {
          continue
         }
         break;
        };
       }
       $3 = $3 + 1 | 0;
       if ($3 >>> 0 < HEAPU32[$0 + 164 >> 2]) {
        continue
       }
       break;
      };
      break label$3;
     }
     if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 16 >> 2], HEAP32[1660])) {
      break label$1
     }
     $2 = strlen(HEAP32[$0 + 20 >> 2]);
     if (!FLAC__bitwriter_write_raw_uint32($1, $2, HEAP32[1661])) {
      break label$1
     }
     if (!FLAC__bitwriter_write_byte_block($1, HEAP32[$0 + 20 >> 2], $2)) {
      break label$1
     }
     $2 = strlen(HEAP32[$0 + 24 >> 2]);
     if (!FLAC__bitwriter_write_raw_uint32($1, $2, HEAP32[1662])) {
      break label$1
     }
     if (!FLAC__bitwriter_write_byte_block($1, HEAP32[$0 + 24 >> 2], $2)) {
      break label$1
     }
     if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 28 >> 2], HEAP32[1663])) {
      break label$1
     }
     if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 32 >> 2], HEAP32[1664])) {
      break label$1
     }
     if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 36 >> 2], HEAP32[1665])) {
      break label$1
     }
     if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 40 >> 2], HEAP32[1666])) {
      break label$1
     }
     if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 44 >> 2], HEAP32[1667])) {
      break label$1
     }
     if (FLAC__bitwriter_write_byte_block($1, HEAP32[$0 + 48 >> 2], HEAP32[$0 + 44 >> 2])) {
      break label$3
     }
     break label$1;
    }
    if (!FLAC__bitwriter_write_byte_block($1, HEAP32[$0 + 16 >> 2], HEAP32[$0 + 8 >> 2])) {
     break label$1
    }
   }
   $17 = 1;
  }
  return $17;
 }
 
 function FLAC__frame_add_header($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $5 = __stack_pointer - 16 | 0;
  __stack_pointer = $5;
  label$1 : {
   if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[1671], HEAP32[1672])) {
    break label$1
   }
   if (!FLAC__bitwriter_write_raw_uint32($1, 0, HEAP32[1673])) {
    break label$1
   }
   if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 20 >> 2] != 0, HEAP32[1674])) {
    break label$1
   }
   $7 = 16;
   $8 = 1;
   $3 = $1;
   label$3 : {
    label$4 : {
     label$5 : {
      label$6 : {
       label$7 : {
        label$8 : {
         label$9 : {
          label$10 : {
           label$11 : {
            $2 = HEAP32[$0 >> 2];
            if (($2 | 0) <= 2047) {
             if (($2 | 0) <= 575) {
              $4 = 1;
              if (($2 | 0) == 192) {
               break label$3
              }
              if (($2 | 0) == 256) {
               break label$8
              }
              if (($2 | 0) != 512) {
               break label$4
              }
              $4 = 9;
              break label$3;
             }
             if (($2 | 0) == 576) {
              break label$11
             }
             if (($2 | 0) == 1024) {
              break label$7
             }
             if (($2 | 0) != 1152) {
              break label$4
             }
             $4 = 3;
             break label$3;
            }
            if (($2 | 0) <= 4607) {
             if (($2 | 0) == 2048) {
              break label$6
             }
             if (($2 | 0) == 2304) {
              break label$10
             }
             if (($2 | 0) != 4096) {
              break label$4
             }
             $4 = 12;
             break label$3;
            }
            if (($2 | 0) <= 16383) {
             if (($2 | 0) == 4608) {
              break label$9
             }
             if (($2 | 0) != 8192) {
              break label$4
             }
             $4 = 13;
             break label$3;
            }
            if (($2 | 0) == 16384) {
             break label$5
            }
            if (($2 | 0) != 32768) {
             break label$4
            }
            $4 = 15;
            break label$3;
           }
           $4 = 2;
           break label$3;
          }
          $4 = 4;
          break label$3;
         }
         $4 = 5;
         break label$3;
        }
        $4 = 8;
        break label$3;
       }
       $4 = 10;
       break label$3;
      }
      $4 = 11;
      break label$3;
     }
     $4 = 14;
     break label$3;
    }
    $2 = $2 >>> 0 < 257;
    $7 = $2 ? 8 : 16;
    $8 = 0;
    $4 = $2 ? 6 : 7;
   }
   if (!FLAC__bitwriter_write_raw_uint32($3, $4, HEAP32[1675])) {
    break label$1
   }
   label$17 : {
    label$18 : {
     label$19 : {
      label$20 : {
       label$21 : {
        label$22 : {
         label$23 : {
          label$24 : {
           $3 = HEAP32[$0 + 4 >> 2];
           if (($3 | 0) <= 44099) {
            if (($3 | 0) <= 22049) {
             if (($3 | 0) == 8e3) {
              break label$24
             }
             if (($3 | 0) != 16e3) {
              break label$18
             }
             $2 = 5;
             break label$17;
            }
            if (($3 | 0) == 22050) {
             break label$23
            }
            if (($3 | 0) == 24e3) {
             break label$22
            }
            if (($3 | 0) != 32e3) {
             break label$18
            }
            $2 = 8;
            break label$17;
           }
           if (($3 | 0) <= 95999) {
            if (($3 | 0) == 44100) {
             break label$21
            }
            if (($3 | 0) == 48e3) {
             break label$20
            }
            $2 = 1;
            if (($3 | 0) == 88200) {
             break label$17
            }
            break label$18;
           }
           if (($3 | 0) == 96e3) {
            break label$19
           }
           if (($3 | 0) != 192e3) {
            if (($3 | 0) != 176400) {
             break label$18
            }
            $2 = 2;
            break label$17;
           }
           $2 = 3;
           break label$17;
          }
          $2 = 4;
          break label$17;
         }
         $2 = 6;
         break label$17;
        }
        $2 = 7;
        break label$17;
       }
       $2 = 9;
       break label$17;
      }
      $2 = 10;
      break label$17;
     }
     $2 = 11;
     break label$17;
    }
    $4 = ($3 >>> 0) % 1e3 | 0;
    if ($3 >>> 0 <= 255e3) {
     $2 = 12;
     $6 = 12;
     if (!$4) {
      break label$17
     }
    }
    if (!(($3 >>> 0) % 10 | 0)) {
     $2 = 14;
     $6 = 14;
     break label$17;
    }
    $2 = $3 >>> 0 < 65536 ? 13 : 0;
    $6 = $2;
   }
   if (!FLAC__bitwriter_write_raw_uint32($1, $2, HEAP32[1676])) {
    break label$1
   }
   label$31 : {
    label$32 : {
     switch (HEAP32[$0 + 12 >> 2]) {
     case 0:
      $2 = HEAP32[$0 + 8 >> 2] - 1 | 0;
      break label$31;
     case 1:
      $2 = 8;
      break label$31;
     case 2:
      $2 = 9;
      break label$31;
     case 3:
      break label$32;
     default:
      break label$31;
     };
    }
    $2 = 10;
   }
   if (!FLAC__bitwriter_write_raw_uint32($1, $2, HEAP32[1677])) {
    break label$1
   }
   $3 = $1;
   $2 = __wasm_rotl_i32(HEAP32[$0 + 16 >> 2] - 8 | 0, 30);
   if ($2 >>> 0 <= 4) {
    $2 = HEAP32[($2 << 2) + 7872 >> 2]
   } else {
    $2 = 0
   }
   if (!FLAC__bitwriter_write_raw_uint32($3, $2, HEAP32[1678])) {
    break label$1
   }
   if (!FLAC__bitwriter_write_raw_uint32($1, 0, HEAP32[1679])) {
    break label$1
   }
   label$37 : {
    if (!HEAP32[$0 + 20 >> 2]) {
     $2 = $1;
     $3 = HEAP32[$0 + 24 >> 2];
     __inlined_func$FLAC__bitwriter_write_utf8_uint32 : {
      if (($3 | 0) >= 0) {
       if ($3 >>> 0 <= 127) {
        $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, $3, 8);
        break __inlined_func$FLAC__bitwriter_write_utf8_uint32;
       }
       if ($3 >>> 0 <= 2047) {
        $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 | 192, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
        break __inlined_func$FLAC__bitwriter_write_utf8_uint32;
       }
       if ($3 >>> 0 <= 65535) {
        $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 12 | 224, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
        break __inlined_func$FLAC__bitwriter_write_utf8_uint32;
       }
       if ($3 >>> 0 <= 2097151) {
        $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 18 | 240, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 12 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
        break __inlined_func$FLAC__bitwriter_write_utf8_uint32;
       }
       if ($3 >>> 0 <= 67108863) {
        $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 24 | 248, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 18 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 12 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
        break __inlined_func$FLAC__bitwriter_write_utf8_uint32;
       }
       $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 30 | 252, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 24 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 18 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 12 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
      } else {
       $2 = 0
      }
     }
     if ($2) {
      break label$37
     }
     break label$1;
    }
    $2 = $1;
    $3 = HEAP32[$0 + 24 >> 2];
    $4 = HEAP32[$0 + 28 >> 2];
    __inlined_func$FLAC__bitwriter_write_utf8_uint64 : {
     if ($4 >>> 0 <= 15) {
      if (!(!$4 & $3 >>> 0 > 127 | ($4 | 0) != 0)) {
       $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, $3, 8);
       break __inlined_func$FLAC__bitwriter_write_utf8_uint64;
      }
      if (!(!$4 & $3 >>> 0 > 2047 | ($4 | 0) != 0)) {
       $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, ($4 & 63) << 26 | $3 >>> 6 | 192, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
       break __inlined_func$FLAC__bitwriter_write_utf8_uint64;
      }
      if (!(!$4 & $3 >>> 0 > 65535 | ($4 | 0) != 0)) {
       $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, ($4 & 4095) << 20 | $3 >>> 12 | 224, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
       break __inlined_func$FLAC__bitwriter_write_utf8_uint64;
      }
      if (!(!$4 & $3 >>> 0 > 2097151 | ($4 | 0) != 0)) {
       $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, ($4 & 262143) << 14 | $3 >>> 18 | 240, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 12 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
       break __inlined_func$FLAC__bitwriter_write_utf8_uint64;
      }
      if (!(!$4 & $3 >>> 0 > 67108863 | ($4 | 0) != 0)) {
       $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, ($4 & 16777215) << 8 | $3 >>> 24 | 248, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 18 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 12 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
       break __inlined_func$FLAC__bitwriter_write_utf8_uint64;
      }
      if (!(!$4 & $3 >>> 0 > 2147483647 | ($4 | 0) != 0)) {
       $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, ($4 & 1073741823) << 2 | $3 >>> 30 | 252, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 24 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 18 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 12 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
       break __inlined_func$FLAC__bitwriter_write_utf8_uint64;
      }
      $2 = FLAC__bitwriter_write_raw_uint32_nocheck($2, 254, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, ($4 & 1073741823) << 2 | $3 >>> 30 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 24 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 18 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 12 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 >>> 6 & 63 | 128, 8) & FLAC__bitwriter_write_raw_uint32_nocheck($2, $3 & 63 | 128, 8) & 1;
     } else {
      $2 = 0
     }
    }
    if (!$2) {
     break label$1
    }
   }
   if (!$8) {
    if (!FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 >> 2] - 1 | 0, $7)) {
     break label$1
    }
   }
   label$40 : {
    label$41 : {
     switch ($6 - 12 | 0) {
     case 0:
      if (FLAC__bitwriter_write_raw_uint32($1, HEAPU32[$0 + 4 >> 2] / 1e3 | 0, 8)) {
       break label$40
      }
      break label$1;
     case 1:
      if (FLAC__bitwriter_write_raw_uint32($1, HEAP32[$0 + 4 >> 2], 16)) {
       break label$40
      }
      break label$1;
     case 2:
      break label$41;
     default:
      break label$40;
     };
    }
    if (!FLAC__bitwriter_write_raw_uint32($1, HEAPU32[$0 + 4 >> 2] / 10 | 0, 16)) {
     break label$1
    }
   }
   $2 = $5 + 15 | 0;
   $0 = __stack_pointer - 16 | 0;
   __stack_pointer = $0;
   if (FLAC__bitwriter_get_buffer($1, $0 + 12 | 0, $0 + 8 | 0)) {
    (wasm2js_i32$0 = $2, wasm2js_i32$1 = FLAC__crc8(HEAP32[$0 + 12 >> 2], HEAP32[$0 + 8 >> 2])), HEAP8[wasm2js_i32$0 | 0] = wasm2js_i32$1;
    $2 = 1;
   } else {
    $2 = 0
   }
   __stack_pointer = $0 + 16 | 0;
   if (!$2) {
    break label$1
   }
   $9 = (FLAC__bitwriter_write_raw_uint32($1, HEAPU8[$5 + 15 | 0], HEAP32[1680]) | 0) != 0;
  }
  __stack_pointer = $5 + 16 | 0;
  return $9;
 }
 
 function add_residual_partitioned_rice_($0, $1, $2, $3, $4, $5, $6, $7) {
  var $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0;
  $12 = HEAP32[($7 ? 6752 : 6748) >> 2];
  $9 = HEAP32[($7 ? 6740 : 6736) >> 2];
  label$1 : {
   label$2 : {
    if (!$6) {
     if (!HEAP32[$5 >> 2]) {
      if (!FLAC__bitwriter_write_raw_uint32($0, HEAP32[$4 >> 2], $9)) {
       break label$2
      }
      if (!FLAC__bitwriter_write_rice_signed_block($0, $1, $2, HEAP32[$4 >> 2])) {
       break label$2
      }
      break label$1;
     }
     if (!FLAC__bitwriter_write_raw_uint32($0, $12, $9)) {
      break label$2
     }
     if (!FLAC__bitwriter_write_raw_uint32($0, HEAP32[$5 >> 2], HEAP32[1686])) {
      break label$2
     }
     if (!$2) {
      break label$1
     }
     $7 = 0;
     while (1) {
      if (FLAC__bitwriter_write_raw_int32($0, HEAP32[($7 << 2) + $1 >> 2], HEAP32[$5 >> 2])) {
       $7 = $7 + 1 | 0;
       if (($2 | 0) != ($7 | 0)) {
        continue
       }
       break label$1;
      }
      break;
     };
     return 0;
    }
    $15 = $2 + $3 >>> $6 | 0;
    $16 = HEAP32[1686];
    $2 = 0;
    while (1) {
     $7 = $2;
     $13 = $15 - ($10 ? 0 : $3) | 0;
     $2 = $7 + $13 | 0;
     $14 = $10 << 2;
     $8 = $14 + $5 | 0;
     label$8 : {
      if (!HEAP32[$8 >> 2]) {
       $11 = 0;
       $8 = $4 + $14 | 0;
       if (!FLAC__bitwriter_write_raw_uint32($0, HEAP32[$8 >> 2], $9)) {
        break label$2
       }
       if (FLAC__bitwriter_write_rice_signed_block($0, ($7 << 2) + $1 | 0, $13, HEAP32[$8 >> 2])) {
        break label$8
       }
       break label$2;
      }
      $11 = 0;
      if (!FLAC__bitwriter_write_raw_uint32($0, $12, $9)) {
       break label$2
      }
      if (!FLAC__bitwriter_write_raw_uint32($0, HEAP32[$8 >> 2], $16)) {
       break label$2
      }
      if ($2 >>> 0 <= $7 >>> 0) {
       break label$8
      }
      while (1) {
       if (!FLAC__bitwriter_write_raw_int32($0, HEAP32[($7 << 2) + $1 >> 2], HEAP32[$8 >> 2])) {
        break label$2
       }
       $7 = $7 + 1 | 0;
       if (($7 | 0) != ($2 | 0)) {
        continue
       }
       break;
      };
     }
     $11 = 1;
     $10 = $10 + 1 | 0;
     if (!($10 >>> $6 | 0)) {
      continue
     }
     break;
    };
   }
   return $11;
  }
  return 1;
 }
 
 function strncmp($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0;
  if (!$2) {
   return 0
  }
  $3 = HEAPU8[$0 | 0];
  label$2 : {
   if (!$3) {
    break label$2
   }
   while (1) {
    label$3 : {
     $4 = HEAPU8[$1 | 0];
     if (!$4) {
      break label$3
     }
     $2 = $2 - 1 | 0;
     if (!$2 | ($3 | 0) != ($4 | 0)) {
      break label$3
     }
     $1 = $1 + 1 | 0;
     $3 = HEAPU8[$0 + 1 | 0];
     $0 = $0 + 1 | 0;
     if ($3) {
      continue
     }
     break label$2;
    }
    break;
   };
   $5 = $3;
  }
  return ($5 & 255) - HEAPU8[$1 | 0] | 0;
 }
 
 function __shlim($0) {
  var $1 = 0, $2 = 0;
  HEAP32[$0 + 112 >> 2] = 0;
  HEAP32[$0 + 116 >> 2] = 0;
  $1 = HEAP32[$0 + 8 >> 2];
  $2 = $1 - HEAP32[$0 + 4 >> 2] | 0;
  HEAP32[$0 + 120 >> 2] = $2;
  HEAP32[$0 + 124 >> 2] = $2 >> 31;
  HEAP32[$0 + 104 >> 2] = $1;
 }
 
 function __shgetc($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
  label$1 : {
   $1 = HEAP32[$0 + 112 >> 2];
   $3 = HEAP32[$0 + 116 >> 2];
   label$2 : {
    if ($1 | $3) {
     $5 = HEAP32[$0 + 124 >> 2];
     if (($3 | 0) <= ($5 | 0) & $1 >>> 0 <= HEAPU32[$0 + 120 >> 2] | ($3 | 0) < ($5 | 0)) {
      break label$2
     }
    }
    $5 = __stack_pointer - 16 | 0;
    __stack_pointer = $5;
    $4 = -1;
    $3 = $0;
    $1 = $0;
    $2 = HEAPU8[$0 + 74 | 0];
    HEAP8[$0 + 74 | 0] = $2 - 1 | $2;
    if (HEAPU32[$0 + 20 >> 2] > HEAPU32[$0 + 28 >> 2]) {
     FUNCTION_TABLE[HEAP32[$1 + 36 >> 2]]($1, 0, 0) | 0
    }
    HEAP32[$1 + 28 >> 2] = 0;
    HEAP32[$1 + 16 >> 2] = 0;
    HEAP32[$1 + 20 >> 2] = 0;
    $2 = HEAP32[$1 >> 2];
    __inlined_func$__toread : {
     if ($2 & 4) {
      HEAP32[$1 >> 2] = $2 | 32;
      $7 = -1;
      break __inlined_func$__toread;
     }
     $6 = HEAP32[$1 + 44 >> 2] + HEAP32[$1 + 48 >> 2] | 0;
     HEAP32[$1 + 8 >> 2] = $6;
     HEAP32[$1 + 4 >> 2] = $6;
     $7 = $2 << 27 >> 31;
    }
    label$10 : {
     if ($7) {
      break label$10
     }
     if ((FUNCTION_TABLE[HEAP32[$3 + 32 >> 2]]($3, $5 + 15 | 0, 1) | 0) != 1) {
      break label$10
     }
     $4 = HEAPU8[$5 + 15 | 0];
    }
    __stack_pointer = $5 + 16 | 0;
    $5 = $4;
    if (($4 | 0) > -1) {
     break label$1
    }
   }
   HEAP32[$0 + 104 >> 2] = 0;
   return -1;
  }
  $4 = HEAP32[$0 + 116 >> 2];
  $2 = $4;
  $9 = $0;
  $3 = HEAP32[$0 + 8 >> 2];
  $6 = HEAP32[$0 + 112 >> 2];
  $7 = $3;
  label$4 : {
   if (!($2 | $6)) {
    break label$4
   }
   $1 = HEAP32[$0 + 4 >> 2];
   $8 = $3 - $1 | 0;
   $4 = $6;
   $6 = HEAP32[$0 + 120 >> 2] ^ -1;
   $4 = $4 + $6 | 0;
   $2 = (HEAP32[$0 + 124 >> 2] ^ -1) + $2 | 0;
   $2 = $4 >>> 0 < $6 >>> 0 ? $2 + 1 | 0 : $2;
   $6 = $8 >> 31;
   $7 = $3;
   if ($8 >>> 0 <= $4 >>> 0 & ($2 | 0) >= ($6 | 0) | ($2 | 0) > ($6 | 0)) {
    break label$4
   }
   $7 = $1 + $4 | 0;
  }
  HEAP32[$9 + 104 >> 2] = $7;
  $1 = HEAP32[$0 + 4 >> 2];
  if ($3) {
   $4 = ($3 - $1 | 0) + 1 | 0;
   $2 = $4;
   $3 = $2 + HEAP32[$0 + 120 >> 2] | 0;
   $4 = HEAP32[$0 + 124 >> 2] + ($2 >> 31) | 0;
   HEAP32[$0 + 120 >> 2] = $3;
   HEAP32[$0 + 124 >> 2] = $3 >>> 0 < $2 >>> 0 ? $4 + 1 | 0 : $4;
  }
  $0 = $1 - 1 | 0;
  if (($5 | 0) != HEAPU8[$0 | 0]) {
   HEAP8[$0 | 0] = $5
  }
  return $5;
 }
 
 function __floatsitf($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
  $4 = __stack_pointer - 16 | 0;
  __stack_pointer = $4;
  $6 = $0;
  label$1 : {
   if (!$1) {
    $1 = 0;
    break label$1;
   }
   $2 = $1 >> 31;
   $3 = $2 + $1 ^ $2;
   $2 = Math_clz32($3);
   __ashlti3($4, $3, 0, 0, 0, $2 + 81 | 0);
   $3 = $4 + 8 | 0;
   $5 = HEAP32[$3 >> 2];
   $7 = HEAP32[$3 + 4 >> 2] ^ 65536;
   $3 = $5;
   $5 = 0;
   $3 = $3 + $5 | 0;
   $2 = (16414 - $2 << 16) + $7 | 0;
   $2 = $3 >>> 0 < $5 >>> 0 ? $2 + 1 | 0 : $2;
   $5 = $1 & -2147483648 | $2;
   $2 = HEAP32[$4 + 4 >> 2];
   $1 = HEAP32[$4 >> 2];
  }
  HEAP32[$6 >> 2] = $1;
  HEAP32[$0 + 4 >> 2] = $2;
  HEAP32[$0 + 8 >> 2] = $3;
  HEAP32[$0 + 12 >> 2] = $5;
  __stack_pointer = $4 + 16 | 0;
 }
 
 function __multf3($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  var $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
  $12 = __stack_pointer - 96 | 0;
  __stack_pointer = $12;
  $13 = $2;
  $19 = ($6 & 131071) << 15 | $5 >>> 17;
  $20 = $8 & 65535;
  $17 = $7;
  $9 = $7;
  $23 = $9 << 15 | $6 >>> 17;
  $16 = ($4 ^ $8) & -2147483648;
  $11 = $4 & 65535;
  $14 = $11;
  $15 = $3;
  $26 = $11;
  $11 = 0;
  $9 = $20;
  $27 = ($9 & 131071) << 15 | $7 >>> 17;
  $34 = $8 >>> 16 & 32767;
  $35 = $4 >>> 16 & 32767;
  label$1 : {
   label$2 : {
    if ($35 - 1 >>> 0 <= 32765) {
     if ($34 - 1 >>> 0 < 32766) {
      break label$2
     }
    }
    $18 = $4 & 2147483647;
    $10 = $18;
    $9 = $3;
    if (!(!$9 & ($10 | 0) == 2147418112 ? !($1 | $2) : $10 >>> 0 < 2147418112)) {
     $21 = $3;
     $16 = $4 | 32768;
     break label$1;
    }
    $18 = $8 & 2147483647;
    $4 = $18;
    $3 = $7;
    if (!(!$3 & ($4 | 0) == 2147418112 ? !($5 | $6) : $4 >>> 0 < 2147418112)) {
     $21 = $7;
     $16 = $8 | 32768;
     $1 = $5;
     $2 = $6;
     break label$1;
    }
    if (!(($1 | $9) != 0 | ($10 ^ 2147418112 | $2) != 0)) {
     if (!($3 | $5 | ($4 | $6))) {
      $16 = 2147450880;
      $1 = 0;
      $2 = 0;
      break label$1;
     }
     $16 = $16 | 2147418112;
     $1 = 0;
     $2 = 0;
     break label$1;
    }
    if (!(($3 | $5) != 0 | ($4 ^ 2147418112 | $6) != 0)) {
     $3 = $1 | $9;
     $4 = $2 | $10;
     $1 = 0;
     $2 = 0;
     if (!($3 | $4)) {
      $16 = 2147450880;
      break label$1;
     }
     $16 = $16 | 2147418112;
     break label$1;
    }
    if (!(($1 | $9) != 0 | ($2 | $10) != 0)) {
     $1 = 0;
     $2 = 0;
     break label$1;
    }
    if (!(($3 | $5) != 0 | ($4 | $6) != 0)) {
     $1 = 0;
     $2 = 0;
     break label$1;
    }
    if ($10 >>> 0 <= 65535) {
     $8 = $1;
     $3 = !($15 | $14);
     $7 = $3 << 6;
     $9 = Math_clz32($3 ? $1 : $15) + 32 | 0;
     $1 = Math_clz32($3 ? $2 : $14);
     $1 = $7 + (($1 | 0) == 32 ? $9 : $1) | 0;
     __ashlti3($12 + 80 | 0, $8, $2, $15, $14, $1 - 15 | 0);
     $22 = 16 - $1 | 0;
     $3 = $12 + 88 | 0;
     $14 = HEAP32[$3 + 4 >> 2];
     $15 = HEAP32[$3 >> 2];
     $13 = HEAP32[$12 + 84 >> 2];
     $26 = $14;
     $1 = HEAP32[$12 + 80 >> 2];
    }
    if ($4 >>> 0 > 65535) {
     break label$2
    }
    $2 = !($17 | $20);
    $3 = $2 << 6;
    $4 = Math_clz32($2 ? $5 : $17) + 32 | 0;
    $2 = Math_clz32($2 ? $6 : $20);
    $2 = $3 + (($2 | 0) == 32 ? $4 : $2) | 0;
    __ashlti3($12 - -64 | 0, $5, $6, $17, $20, $2 - 15 | 0);
    $22 = ($22 - $2 | 0) + 16 | 0;
    $2 = HEAP32[$12 + 68 >> 2];
    $6 = $2;
    $7 = $2 >>> 17 | 0;
    $2 = $12 + 72 | 0;
    $4 = HEAP32[$2 + 4 >> 2];
    $3 = HEAP32[$2 >> 2];
    $2 = $4;
    $23 = $3 << 15 | $7;
    $4 = $6;
    $5 = HEAP32[$12 + 64 >> 2];
    $19 = ($4 & 131071) << 15 | $5 >>> 17;
    $27 = ($2 & 131071) << 15 | $3 >>> 17;
   }
   $10 = $19;
   $2 = $1;
   $14 = 0;
   $28 = __wasm_i64_mul($10, 0, $1, $14);
   $1 = i64toi32_i32$HIGH_BITS;
   $24 = $1;
   $17 = $5 << 15 & -32768;
   $4 = __wasm_i64_mul($17, 0, $13, 0);
   $3 = $4 + $28 | 0;
   $9 = i64toi32_i32$HIGH_BITS + $1 | 0;
   $9 = $3 >>> 0 < $4 >>> 0 ? $9 + 1 | 0 : $9;
   $4 = $3;
   $1 = $9;
   $7 = 0;
   $6 = __wasm_i64_mul($17, $29, $2, $14);
   $3 = $7 + $6 | 0;
   $9 = $4;
   $5 = $9 + i64toi32_i32$HIGH_BITS | 0;
   $5 = $3 >>> 0 < $6 >>> 0 ? $5 + 1 | 0 : $5;
   $19 = $3;
   $6 = $5;
   $32 = ($9 | 0) == ($5 | 0) & $3 >>> 0 < $7 >>> 0 | $5 >>> 0 < $9 >>> 0;
   $37 = __wasm_i64_mul($10, $25, $13, $36);
   $33 = i64toi32_i32$HIGH_BITS;
   $18 = $15;
   $5 = __wasm_i64_mul($17, $29, $15, 0);
   $3 = $5 + $37 | 0;
   $9 = i64toi32_i32$HIGH_BITS + $33 | 0;
   $9 = $3 >>> 0 < $5 >>> 0 ? $9 + 1 | 0 : $9;
   $38 = $3;
   $7 = __wasm_i64_mul($23, 0, $2, $14);
   $5 = $3 + $7 | 0;
   $3 = $9;
   $9 = $9 + i64toi32_i32$HIGH_BITS | 0;
   $39 = $5;
   $9 = $5 >>> 0 < $7 >>> 0 ? $9 + 1 | 0 : $9;
   $20 = $9;
   $7 = $9;
   $8 = 0;
   $9 = ($1 | 0) == ($24 | 0) & $4 >>> 0 < $28 >>> 0 | $1 >>> 0 < $24 >>> 0;
   $4 = $1;
   $1 = $1 + $5 | 0;
   $5 = ($8 | $9) + $7 | 0;
   $28 = $1;
   $5 = $1 >>> 0 < $4 >>> 0 ? $5 + 1 | 0 : $5;
   $4 = $5;
   $41 = __wasm_i64_mul($10, $25, $18, $40);
   $24 = i64toi32_i32$HIGH_BITS;
   $30 = $26 | 65536;
   $9 = __wasm_i64_mul($17, $29, $30, $11);
   $8 = $9 + $41 | 0;
   $5 = i64toi32_i32$HIGH_BITS + $24 | 0;
   $5 = $8 >>> 0 < $9 >>> 0 ? $5 + 1 | 0 : $5;
   $42 = $8;
   $11 = __wasm_i64_mul($23, $43, $13, $36);
   $8 = $8 + $11 | 0;
   $15 = $5;
   $9 = $5 + i64toi32_i32$HIGH_BITS | 0;
   $44 = $8;
   $31 = $27 & 2147483647 | -2147483648;
   $5 = __wasm_i64_mul($31, 0, $2, $14);
   $2 = $8 + $5 | 0;
   $17 = $8 >>> 0 < $11 >>> 0 ? $9 + 1 | 0 : $9;
   $9 = $17 + i64toi32_i32$HIGH_BITS | 0;
   $26 = $2;
   $2 = $2 >>> 0 < $5 >>> 0 ? $9 + 1 | 0 : $9;
   $9 = $32;
   $8 = 0;
   $1 = $8 + $1 | 0;
   $5 = $4 + $26 | 0;
   $5 = $1 >>> 0 < $8 >>> 0 ? $5 + 1 | 0 : $5;
   $32 = $1;
   $7 = $1;
   $1 = $9 + $1 | 0;
   $27 = $5;
   $9 = $5;
   $9 = $1 >>> 0 < $7 >>> 0 ? $9 + 1 | 0 : $9;
   $7 = $1;
   $8 = $9;
   $14 = (($34 + $35 | 0) + $22 | 0) - 16383 | 0;
   $9 = __wasm_i64_mul($23, $43, $18, $40);
   $1 = i64toi32_i32$HIGH_BITS;
   $10 = __wasm_i64_mul($10, $25, $30, $29);
   $11 = $10 + $9 | 0;
   $5 = i64toi32_i32$HIGH_BITS + $1 | 0;
   $5 = $11 >>> 0 < $10 >>> 0 ? $5 + 1 | 0 : $5;
   $10 = $11;
   $11 = $5;
   $22 = ($1 | 0) == ($5 | 0) & $9 >>> 0 > $10 >>> 0 | $1 >>> 0 > $5 >>> 0;
   $13 = __wasm_i64_mul($31, $45, $13, $36);
   $1 = $13 + $10 | 0;
   $9 = i64toi32_i32$HIGH_BITS + $5 | 0;
   $9 = $1 >>> 0 < $13 >>> 0 ? $9 + 1 | 0 : $9;
   $13 = $1;
   $5 = $1;
   $1 = $9;
   $11 = ($11 | 0) == ($9 | 0) & $5 >>> 0 < $10 >>> 0 | $9 >>> 0 < $11 >>> 0;
   $5 = $22 + $11 | 0;
   $9 = 0;
   $9 = $5 >>> 0 < $11 >>> 0 ? 1 : $9;
   $11 = $9;
   $9 = $1;
   $25 = $5;
   $10 = ($3 | 0) == ($20 | 0) & $39 >>> 0 < $38 >>> 0 | $3 >>> 0 > $20 >>> 0;
   $3 = $10 + (($3 | 0) == ($33 | 0) & $37 >>> 0 > $38 >>> 0 | $3 >>> 0 < $33 >>> 0) | 0;
   $5 = 0;
   $5 = $3 >>> 0 < $10 >>> 0 ? 1 : $5;
   $10 = $3;
   $3 = $3 + $13 | 0;
   $9 = $5 + $9 | 0;
   $22 = $3;
   $5 = $3;
   $9 = $5 >>> 0 < $10 >>> 0 ? $9 + 1 | 0 : $9;
   $3 = $9;
   $5 = ($1 | 0) == ($9 | 0) & $5 >>> 0 < $13 >>> 0 | $1 >>> 0 > $9 >>> 0;
   $1 = $25 + $5 | 0;
   $9 = $11;
   $9 = $1 >>> 0 < $5 >>> 0 ? $9 + 1 | 0 : $9;
   $11 = __wasm_i64_mul($31, $45, $30, $29);
   $1 = $11 + $1 | 0;
   $5 = i64toi32_i32$HIGH_BITS + $9 | 0;
   $5 = $1 >>> 0 < $11 >>> 0 ? $5 + 1 | 0 : $5;
   $25 = $1;
   $10 = __wasm_i64_mul($31, $45, $18, $40);
   $11 = i64toi32_i32$HIGH_BITS;
   $13 = __wasm_i64_mul($23, $43, $30, $29);
   $1 = $13 + $10 | 0;
   $9 = i64toi32_i32$HIGH_BITS + $11 | 0;
   $9 = $1 >>> 0 < $13 >>> 0 ? $9 + 1 | 0 : $9;
   $13 = $1;
   $1 = $9;
   $9 = ($11 | 0) == ($9 | 0) & $10 >>> 0 > $13 >>> 0 | $9 >>> 0 < $11 >>> 0;
   $10 = $1 + $25 | 0;
   $9 = $5 + $9 | 0;
   $9 = $10 >>> 0 < $1 >>> 0 ? $9 + 1 | 0 : $9;
   $11 = $9;
   $18 = $10;
   $10 = 0;
   $1 = $10 + $22 | 0;
   $5 = $3 + $13 | 0;
   $5 = $1 >>> 0 < $10 >>> 0 ? $5 + 1 | 0 : $5;
   $10 = $1;
   $9 = $1;
   $1 = $5;
   $5 = ($3 | 0) == ($5 | 0) & $9 >>> 0 < $22 >>> 0 | $3 >>> 0 > $5 >>> 0;
   $3 = $18 + $5 | 0;
   $9 = $11;
   $18 = $3;
   $3 = $3 >>> 0 < $5 >>> 0 ? $9 + 1 | 0 : $9;
   $23 = $2;
   $13 = 0;
   $5 = ($15 | 0) == ($24 | 0) & $41 >>> 0 > $42 >>> 0 | $15 >>> 0 < $24 >>> 0;
   $15 = ($15 | 0) == ($17 | 0) & $42 >>> 0 > $44 >>> 0 | $15 >>> 0 > $17 >>> 0;
   $9 = $5 + $15 | 0;
   $5 = $9;
   $9 = ($2 | 0) == ($17 | 0) & $26 >>> 0 < $44 >>> 0 | $2 >>> 0 < $17 >>> 0;
   $2 = $5 + $9 | 0;
   $9 = $2;
   $5 = $23;
   $2 = $5 + $10 | 0;
   $9 = ($9 | $13) + $1 | 0;
   $9 = $2 >>> 0 < $5 >>> 0 ? $9 + 1 | 0 : $9;
   $15 = $2;
   $5 = $2;
   $2 = $9;
   $9 = ($1 | 0) == ($9 | 0) & $5 >>> 0 < $10 >>> 0 | $1 >>> 0 > $9 >>> 0;
   $1 = $9 + $18 | 0;
   $5 = $3;
   $5 = $1 >>> 0 < $9 >>> 0 ? $5 + 1 | 0 : $5;
   $9 = $1;
   $1 = $5;
   $3 = $2;
   $10 = $9;
   $9 = ($4 | 0) == ($27 | 0) & $28 >>> 0 > $32 >>> 0 | $4 >>> 0 > $27 >>> 0;
   $4 = $9 + (($4 | 0) == ($20 | 0) & $28 >>> 0 < $39 >>> 0 | $4 >>> 0 < $20 >>> 0) | 0;
   $5 = 0;
   $5 = $4 >>> 0 < $9 >>> 0 ? 1 : $5;
   $11 = $4;
   $4 = $4 + $15 | 0;
   $9 = $3 + $5 | 0;
   $3 = $4;
   $5 = $3;
   $9 = $5 >>> 0 < $11 >>> 0 ? $9 + 1 | 0 : $9;
   $4 = $9;
   $5 = ($2 | 0) == ($9 | 0) & $5 >>> 0 < $15 >>> 0 | $2 >>> 0 > $9 >>> 0;
   $2 = $10 + $5 | 0;
   $9 = $1;
   $1 = $2;
   $2 = $1 >>> 0 < $5 >>> 0 ? $9 + 1 | 0 : $9;
   label$13 : {
    if ($2 & 65536) {
     $14 = $14 + 1 | 0;
     break label$13;
    }
    $11 = $6 >>> 31 | 0;
    $15 = 0;
    $9 = $2 << 1 | $1 >>> 31;
    $1 = $1 << 1 | $4 >>> 31;
    $2 = $9;
    $9 = $4 << 1 | $3 >>> 31;
    $3 = $3 << 1 | $8 >>> 31;
    $4 = $9;
    $5 = $19;
    $9 = $6 << 1 | $5 >>> 31;
    $19 = $5 << 1;
    $6 = $9;
    $5 = $8 << 1 | $7 >>> 31;
    $7 = $7 << 1 | $11;
    $8 = $5 | $15;
   }
   if (($14 | 0) >= 32767) {
    $16 = $16 | 2147418112;
    $1 = 0;
    $2 = 0;
    break label$1;
   }
   label$16 : {
    if (($14 | 0) <= 0) {
     $5 = 1 - $14 | 0;
     if ($5 >>> 0 >= 128) {
      $1 = 0;
      $2 = 0;
      break label$1;
     }
     $11 = $12 + 48 | 0;
     $9 = $14 + 127 | 0;
     __ashlti3($11, $19, $6, $7, $8, $9);
     $10 = $12 + 32 | 0;
     __ashlti3($10, $3, $4, $1, $2, $9);
     $9 = $12 + 16 | 0;
     __lshrti3($9, $19, $6, $7, $8, $5);
     __lshrti3($12, $3, $4, $1, $2, $5);
     $1 = $11 + 8 | 0;
     $19 = HEAP32[$12 + 32 >> 2] | HEAP32[$12 + 16 >> 2] | ((HEAP32[$12 + 48 >> 2] | HEAP32[$1 >> 2]) != 0 | (HEAP32[$12 + 52 >> 2] | HEAP32[$1 + 4 >> 2]) != 0);
     $6 = HEAP32[$12 + 36 >> 2] | HEAP32[$12 + 20 >> 2];
     $1 = $10 + 8 | 0;
     $2 = $9 + 8 | 0;
     $7 = HEAP32[$1 >> 2] | HEAP32[$2 >> 2];
     $8 = HEAP32[$1 + 4 >> 2] | HEAP32[$2 + 4 >> 2];
     $2 = $12 + 8 | 0;
     $1 = HEAP32[$2 >> 2];
     $3 = HEAP32[$12 >> 2];
     $4 = HEAP32[$12 + 4 >> 2];
     $2 = HEAP32[$2 + 4 >> 2];
     break label$16;
    }
    $2 = $2 & 65535 | $14 << 16;
   }
   $21 = $1 | $21;
   $16 = $2 | $16;
   if (!(!$7 & ($8 | 0) == -2147483648 ? !($6 | $19) : ($8 | 0) > -1)) {
    $9 = $4;
    $1 = $3 + 1 | 0;
    $9 = $1 >>> 0 < 1 ? $9 + 1 | 0 : $9;
    $5 = $1;
    $2 = $9;
    $4 = ($4 | 0) == ($9 | 0) & $3 >>> 0 > $5 >>> 0 | $4 >>> 0 > $9 >>> 0;
    $3 = $4 + $21 | 0;
    $9 = $16;
    $21 = $3;
    $16 = $3 >>> 0 < $4 >>> 0 ? $9 + 1 | 0 : $9;
    break label$1;
   }
   if ($7 | $19 | ($8 ^ -2147483648 | $6)) {
    $1 = $3;
    $2 = $4;
    break label$1;
   }
   $2 = $3 & 1;
   $1 = $2 + $3 | 0;
   $9 = $4;
   $9 = $1 >>> 0 < $2 >>> 0 ? $9 + 1 | 0 : $9;
   $5 = $1;
   $2 = $9;
   $4 = ($4 | 0) == ($9 | 0) & $3 >>> 0 > $5 >>> 0 | $4 >>> 0 > $9 >>> 0;
   $3 = $4 + $21 | 0;
   $9 = $16;
   $21 = $3;
   $16 = $3 >>> 0 < $4 >>> 0 ? $9 + 1 | 0 : $9;
  }
  HEAP32[$0 >> 2] = $1;
  HEAP32[$0 + 4 >> 2] = $2;
  HEAP32[$0 + 8 >> 2] = $21;
  HEAP32[$0 + 12 >> 2] = $16;
  __stack_pointer = $12 + 96 | 0;
 }
 
 function __addtf3($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  var $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0;
  $12 = __stack_pointer - 112 | 0;
  __stack_pointer = $12;
  $9 = $7;
  $13 = $8 & 2147483647;
  $14 = $3;
  $11 = $2 - 1 | 0;
  $15 = $11 + 1 | 0;
  $10 = $11;
  $11 = $1 - 1 | 0;
  $10 = ($11 | 0) != -1 ? $15 : $10;
  $16 = ($10 | 0) == ($2 | 0) & $1 >>> 0 > $11 >>> 0 | $2 >>> 0 > $10 >>> 0;
  $17 = $3 + $16 | 0;
  $15 = $17 - 1 | 0;
  label$1 : {
   label$2 : {
    $18 = ($11 | 0) == -1 & ($10 | 0) == -1;
    $11 = $4 & 2147483647;
    $10 = $11;
    $10 = ($16 >>> 0 > $17 >>> 0 ? $10 + 1 | 0 : $10) - 1 | 0;
    $10 = ($15 | 0) != -1 ? $10 + 1 | 0 : $10;
    if (!(($15 | 0) == -1 & ($10 | 0) == 2147418111 ? $18 : $10 >>> 0 > 2147418111)) {
     $10 = $6 - 1 | 0;
     $15 = $5 - 1 | 0;
     $16 = ($15 | 0) != -1 ? $10 + 1 | 0 : $10;
     $17 = ($16 | 0) == ($6 | 0) & $5 >>> 0 > $15 >>> 0 | $6 >>> 0 > $16 >>> 0;
     $18 = $17 + $9 | 0;
     $10 = $18 - 1 | 0;
     $19 = ($15 | 0) != -1 | ($16 | 0) != -1;
     $15 = ($17 >>> 0 > $18 >>> 0 ? $13 + 1 | 0 : $13) - 1 | 0;
     $17 = ($10 | 0) != -1;
     $15 = $17 ? $15 + 1 | 0 : $15;
     $16 = ($15 | 0) == 2147418111;
     if ($16 & ($10 | 0) == -1 ? $19 : $16 & $17 | $15 >>> 0 < 2147418111) {
      break label$2
     }
    }
    if (!(!$14 & ($11 | 0) == 2147418112 ? !($1 | $2) : $11 >>> 0 < 2147418112)) {
     $7 = $3;
     $8 = $4 | 32768;
     $5 = $1;
     $6 = $2;
     break label$1;
    }
    if (!(!$9 & ($13 | 0) == 2147418112 ? !($5 | $6) : $13 >>> 0 < 2147418112)) {
     $8 = $8 | 32768;
     break label$1;
    }
    if (!(($1 | $14) != 0 | ($11 ^ 2147418112 | $2) != 0)) {
     $9 = $3;
     $3 = !($1 ^ $5 | $3 ^ $7 | ($2 ^ $6 | $4 ^ $8 ^ -2147483648));
     $7 = $3 ? 0 : $9;
     $8 = $3 ? 2147450880 : $4;
     $5 = $3 ? 0 : $1;
     $6 = $3 ? 0 : $2;
     break label$1;
    }
    if (!($5 | $9 | ($13 ^ 2147418112 | $6))) {
     break label$1
    }
    if (!(($1 | $14) != 0 | ($2 | $11) != 0)) {
     if ($5 | $9 | ($6 | $13)) {
      break label$1
     }
     $5 = $1 & $5;
     $6 = $2 & $6;
     $7 = $3 & $7;
     $8 = $4 & $8;
     break label$1;
    }
    if ($5 | $9 | ($6 | $13)) {
     break label$2
    }
    $5 = $1;
    $6 = $2;
    $7 = $3;
    $8 = $4;
    break label$1;
   }
   $10 = ($11 | 0) == ($13 | 0);
   $10 = $10 & ($9 | 0) == ($14 | 0) ? ($2 | 0) == ($6 | 0) & $1 >>> 0 < $5 >>> 0 | $2 >>> 0 < $6 >>> 0 : $10 & $9 >>> 0 > $14 >>> 0 | $11 >>> 0 < $13 >>> 0;
   $9 = $10;
   $14 = $9 ? $5 : $1;
   $13 = $9 ? $6 : $2;
   $11 = $9 ? $8 : $4;
   $15 = $11;
   $9 = $9 ? $7 : $3;
   $11 = $11 & 65535;
   $4 = $10 ? $4 : $8;
   $16 = $4;
   $7 = $10 ? $3 : $7;
   $4 = $4 >>> 16 & 32767;
   $3 = $15 >>> 16 & 32767;
   if (!$3) {
    $3 = !($9 | $11);
    $8 = $3 << 6;
    $17 = Math_clz32($3 ? $14 : $9) + 32 | 0;
    $3 = Math_clz32($3 ? $13 : $11);
    $3 = $8 + (($3 | 0) == 32 ? $17 : $3) | 0;
    __ashlti3($12 + 96 | 0, $14, $13, $9, $11, $3 - 15 | 0);
    $8 = $12 + 104 | 0;
    $9 = HEAP32[$8 >> 2];
    $11 = HEAP32[$8 + 4 >> 2];
    $14 = HEAP32[$12 + 96 >> 2];
    $13 = HEAP32[$12 + 100 >> 2];
    $3 = 16 - $3 | 0;
   }
   $5 = $10 ? $1 : $5;
   $6 = $10 ? $2 : $6;
   $8 = $16 & 65535;
   if (!$4) {
    $1 = !($7 | $8);
    $2 = $1 << 6;
    $4 = Math_clz32($1 ? $5 : $7) + 32 | 0;
    $1 = Math_clz32($1 ? $6 : $8);
    $1 = $2 + (($1 | 0) == 32 ? $4 : $1) | 0;
    __ashlti3($12 + 80 | 0, $5, $6, $7, $8, $1 - 15 | 0);
    $4 = 16 - $1 | 0;
    $1 = $12 + 88 | 0;
    $7 = HEAP32[$1 >> 2];
    $8 = HEAP32[$1 + 4 >> 2];
    $6 = HEAP32[$12 + 84 >> 2];
    $5 = HEAP32[$12 + 80 >> 2];
   }
   $1 = $8 << 3 | $7 >>> 29;
   $7 = $7 << 3 | $6 >>> 29;
   $8 = $1 | 524288;
   $2 = $9 << 3 | $13 >>> 29;
   $11 = $11 << 3 | $9 >>> 29;
   $1 = $6 << 3 | $5 >>> 29;
   $5 = $5 << 3;
   $6 = $15 ^ $16;
   $4 = $3 - $4 | 0;
   $9 = $1;
   label$10 : {
    if (!$4) {
     break label$10
    }
    if ($4 >>> 0 > 127) {
     $7 = 0;
     $8 = 0;
     $5 = 1;
     $9 = 0;
     break label$10;
    }
    $9 = $12 - -64 | 0;
    __ashlti3($9, $5, $1, $7, $8, 128 - $4 | 0);
    $10 = $12 + 48 | 0;
    __lshrti3($10, $5, $1, $7, $8, $4);
    $1 = $9 + 8 | 0;
    $5 = HEAP32[$12 + 48 >> 2] | ((HEAP32[$12 + 64 >> 2] | HEAP32[$1 >> 2]) != 0 | (HEAP32[$12 + 68 >> 2] | HEAP32[$1 + 4 >> 2]) != 0);
    $1 = $10 + 8 | 0;
    $7 = HEAP32[$1 >> 2];
    $8 = HEAP32[$1 + 4 >> 2];
    $9 = HEAP32[$12 + 52 >> 2];
   }
   $4 = $2;
   $11 = $11 | 524288;
   $2 = $14 << 3;
   $14 = $13 << 3 | $14 >>> 29;
   label$12 : {
    if (($6 | 0) <= -1) {
     $1 = $2 - $5 | 0;
     $6 = $7;
     $13 = $4 - $6 | 0;
     $2 = $2 >>> 0 < $5 >>> 0;
     $10 = $2 & ($9 | 0) == ($14 | 0) | $9 >>> 0 > $14 >>> 0;
     $7 = $13 - $10 | 0;
     $2 = $14 - ($2 + $9 | 0) | 0;
     $8 = ($11 - (($4 >>> 0 < $6 >>> 0) + $8 | 0) | 0) - ($10 >>> 0 > $13 >>> 0) | 0;
     if (!($1 | $7 | ($2 | $8))) {
      $5 = 0;
      $6 = 0;
      $7 = 0;
      $8 = 0;
      break label$1;
     }
     if ($8 >>> 0 > 524287) {
      break label$12
     }
     $6 = $1;
     $4 = !($7 | $8);
     $5 = $4 << 6;
     $9 = Math_clz32($4 ? $1 : $7) + 32 | 0;
     $1 = Math_clz32($4 ? $2 : $8);
     $1 = $5 + (($1 | 0) == 32 ? $9 : $1) | 0;
     $1 = $1 - 12 | 0;
     __ashlti3($12 + 32 | 0, $6, $2, $7, $8, $1);
     $3 = $3 - $1 | 0;
     $1 = $12 + 40 | 0;
     $7 = HEAP32[$1 >> 2];
     $8 = HEAP32[$1 + 4 >> 2];
     $1 = HEAP32[$12 + 32 >> 2];
     $2 = HEAP32[$12 + 36 >> 2];
     break label$12;
    }
    $1 = $8 + $11 | 0;
    $6 = $4 + $7 | 0;
    $4 = $6 >>> 0 < $4 >>> 0 ? $1 + 1 | 0 : $1;
    $1 = $9 + $14 | 0;
    $8 = $1 + 1 | 0;
    $7 = $1;
    $1 = $2 + $5 | 0;
    $2 = $1 >>> 0 < $2 >>> 0 ? $8 : $7;
    $5 = ($9 | 0) == ($2 | 0) & $1 >>> 0 < $5 >>> 0 | $2 >>> 0 < $9 >>> 0;
    $6 = $6 + $5 | 0;
    $7 = $6;
    $8 = $5 >>> 0 > $6 >>> 0 ? $4 + 1 | 0 : $4;
    if (!($8 & 1048576)) {
     break label$12
    }
    $1 = $1 & 1 | (($2 & 1) << 31 | $1 >>> 1);
    $2 = $7 << 31 | $2 >>> 1;
    $3 = $3 + 1 | 0;
    $7 = ($8 & 1) << 31 | $7 >>> 1;
    $8 = $8 >>> 1 | 0;
   }
   $9 = $15 & -2147483648;
   if (($3 | 0) >= 32767) {
    $7 = 0;
    $8 = $9 | 2147418112;
    $5 = 0;
    $6 = 0;
    break label$1;
   }
   $4 = 0;
   label$16 : {
    if (($3 | 0) > 0) {
     $4 = $3;
     break label$16;
    }
    $5 = $12 + 16 | 0;
    __ashlti3($5, $1, $2, $7, $8, $3 + 127 | 0);
    __lshrti3($12, $1, $2, $7, $8, 1 - $3 | 0);
    $1 = $5 + 8 | 0;
    $1 = HEAP32[$12 >> 2] | ((HEAP32[$12 + 16 >> 2] | HEAP32[$1 >> 2]) != 0 | (HEAP32[$12 + 20 >> 2] | HEAP32[$1 + 4 >> 2]) != 0);
    $2 = HEAP32[$12 + 4 >> 2];
    $3 = $12 + 8 | 0;
    $7 = HEAP32[$3 >> 2];
    $8 = HEAP32[$3 + 4 >> 2];
   }
   $3 = ($2 & 7) << 29 | $1 >>> 3;
   $1 = $1 & 7;
   $6 = $1 >>> 0 > 4;
   $5 = $3 + $6 | 0;
   $2 = $7 << 29 | $2 >>> 3;
   $14 = $5 >>> 0 < $6 >>> 0 ? $2 + 1 | 0 : $2;
   $6 = $14;
   $2 = ($6 | 0) == ($2 | 0) & $3 >>> 0 > $5 >>> 0 | $2 >>> 0 > $6 >>> 0;
   $3 = $2 + (($8 & 7) << 29 | $7 >>> 3) | 0;
   $7 = $3;
   $4 = $9 | ($8 >>> 3 & 65535 | $4 << 16);
   $8 = $2 >>> 0 > $3 >>> 0 ? $4 + 1 | 0 : $4;
   label$18 : {
    if (($1 | 0) == 4) {
     $1 = $6;
     $3 = $1 + 1 | 0;
     $2 = $5;
     $1 = $5 & 1;
     $5 = $5 + $1 | 0;
     $6 = $2 >>> 0 > $5 >>> 0 ? $3 : $6;
     $1 = !$6 & $1 >>> 0 > $5 >>> 0;
     $2 = $7 + $1 | 0;
     $7 = $2;
     $8 = $1 >>> 0 > $2 >>> 0 ? $8 + 1 | 0 : $8;
     break label$18;
    }
    if (!$1) {
     break label$1
    }
   }
  }
  HEAP32[$0 >> 2] = $5;
  HEAP32[$0 + 4 >> 2] = $6;
  HEAP32[$0 + 8 >> 2] = $7;
  HEAP32[$0 + 12 >> 2] = $8;
  __stack_pointer = $12 + 112 | 0;
 }
 
 function __extenddftf2($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
  $6 = __stack_pointer - 16 | 0;
  __stack_pointer = $6;
  wasm2js_scratch_store_f64(+$1);
  $7 = wasm2js_scratch_load_i32(1) | 0;
  $5 = wasm2js_scratch_load_i32(0) | 0;
  $3 = $7 & 2147483647;
  $2 = $3;
  $4 = $5;
  label$1 : {
   if ($2 + -1048576 >>> 0 <= 2145386495) {
    $3 = $4 << 28;
    $5 = $2 >>> 4 | 0;
    $2 = ($2 & 15) << 28 | $4 >>> 4;
    $4 = $5 + 1006632960 | 0;
    break label$1;
   }
   if ($2 >>> 0 >= 2146435072) {
    $3 = $5 << 28;
    $2 = $7;
    $5 = $2 >>> 4 | 0;
    $2 = ($2 & 15) << 28 | $4 >>> 4;
    $4 = $5 | 2147418112;
    break label$1;
   }
   if (!($2 | $4)) {
    $3 = 0;
    $2 = 0;
    $4 = 0;
    break label$1;
   }
   $3 = $2;
   $2 = $2 >>> 0 < 1 ? Math_clz32($5) + 32 | 0 : Math_clz32($2);
   __ashlti3($6, $4, $3, 0, 0, $2 + 49 | 0);
   $3 = $6 + 8 | 0;
   $4 = HEAP32[$3 >> 2];
   $5 = HEAP32[$3 + 4 >> 2] ^ 65536;
   $3 = 15372 - $2 << 16;
   $2 = $4;
   $4 = $5 | $3;
   $8 = HEAP32[$6 >> 2];
   $3 = HEAP32[$6 + 4 >> 2];
  }
  HEAP32[$0 >> 2] = $8;
  HEAP32[$0 + 4 >> 2] = $3;
  HEAP32[$0 + 8 >> 2] = $2;
  HEAP32[$0 + 12 >> 2] = $7 & -2147483648 | $4;
  __stack_pointer = $6 + 16 | 0;
 }
 
 function __letf2($0, $1, $2, $3, $4, $5, $6, $7) {
  var $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0;
  $10 = 1;
  $9 = $3 & 2147483647;
  $12 = $9;
  $8 = ($9 | 0) == 2147418112;
  $13 = $2;
  label$1 : {
   if ($8 & !$2 ? $0 | $1 : $8 & ($2 | 0) != 0 | $9 >>> 0 > 2147418112) {
    break label$1
   }
   $8 = $7 & 2147483647;
   $14 = $8;
   $11 = ($8 | 0) == 2147418112;
   $9 = $6;
   if ($11 & !$6 ? $4 | $5 : $11 & ($6 | 0) != 0 | $8 >>> 0 > 2147418112) {
    break label$1
   }
   if (!($0 | $4 | ($9 | $13) | ($1 | $5 | ($12 | $14)))) {
    return 0
   }
   if (($3 & $7) >= 0) {
    $10 = -1;
    if (($2 | 0) == ($6 | 0) & ($3 | 0) == ($7 | 0) ? ($1 | 0) == ($5 | 0) & $0 >>> 0 < $4 >>> 0 | $1 >>> 0 < $5 >>> 0 : $2 >>> 0 < $6 >>> 0 & ($3 | 0) <= ($7 | 0) | ($3 | 0) < ($7 | 0)) {
     break label$1
    }
    return ($0 ^ $4 | $2 ^ $6) != 0 | ($1 ^ $5 | $3 ^ $7) != 0;
   }
   $10 = -1;
   if (($2 | 0) == ($6 | 0) & ($3 | 0) == ($7 | 0) ? ($1 | 0) == ($5 | 0) & $0 >>> 0 > $4 >>> 0 | $1 >>> 0 > $5 >>> 0 : $2 >>> 0 > $6 >>> 0 & ($3 | 0) >= ($7 | 0) | ($3 | 0) > ($7 | 0)) {
    break label$1
   }
   $10 = ($0 ^ $4 | $2 ^ $6) != 0 | ($1 ^ $5 | $3 ^ $7) != 0;
  }
  return $10;
 }
 
 function __getf2($0, $1, $2, $3, $4) {
  var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0;
  $7 = -1;
  $5 = $3 & 2147483647;
  $9 = $5;
  $6 = ($5 | 0) == 2147418112;
  $10 = $2;
  label$1 : {
   if ($6 & !$2 ? $0 | $1 : $6 & ($2 | 0) != 0 | $5 >>> 0 > 2147418112) {
    break label$1
   }
   $5 = $4 & 2147483647;
   $6 = $5;
   $8 = ($5 | 0) == 2147418112;
   if ($8 ? 0 : $8 & 0 | $5 >>> 0 > 2147418112) {
    break label$1
   }
   if (!($0 | $10 | ($1 | ($6 | $9)))) {
    return 0
   }
   if (($3 & $4) >= 0) {
    if (!$2 & ($3 | 0) == ($4 | 0) ? 0 : ($3 | 0) < ($4 | 0)) {
     break label$1
    }
    return ($0 | $2) != 0 | ($1 | $3 ^ $4) != 0;
   }
   if (!$2 & ($3 | 0) == ($4 | 0) ? $1 | !$1 & ($0 | 0) != 0 : ($2 | 0) != 0 & ($3 | 0) >= ($4 | 0) | ($3 | 0) > ($4 | 0)) {
    break label$1
   }
   $7 = ($0 | $2) != 0 | ($1 | $3 ^ $4) != 0;
  }
  return $7;
 }
 
 function scalbn($0, $1) {
  label$1 : {
   if (($1 | 0) >= 1024) {
    $0 = $0 * 8988465674311579538646525.0e283;
    if (($1 | 0) < 2047) {
     $1 = $1 - 1023 | 0;
     break label$1;
    }
    $0 = $0 * 8988465674311579538646525.0e283;
    $1 = (($1 | 0) < 3069 ? $1 : 3069) - 2046 | 0;
    break label$1;
   }
   if (($1 | 0) > -1023) {
    break label$1
   }
   $0 = $0 * 2.2250738585072014e-308;
   if (($1 | 0) > -2045) {
    $1 = $1 + 1022 | 0;
    break label$1;
   }
   $0 = $0 * 2.2250738585072014e-308;
   $1 = (($1 | 0) > -3066 ? $1 : -3066) + 2044 | 0;
  }
  wasm2js_scratch_store_i32(0, 0);
  wasm2js_scratch_store_i32(1, $1 + 1023 << 20);
  return $0 * +wasm2js_scratch_load_f64();
 }
 
 function copysignl($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  HEAP32[$0 >> 2] = $1;
  HEAP32[$0 + 4 >> 2] = $2;
  HEAP32[$0 + 8 >> 2] = $3;
  HEAP32[$0 + 12 >> 2] = $4 & 65535 | ($8 >>> 16 & 32768 | $4 >>> 16 & 32767) << 16;
 }
 
 function __floatunsitf($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  $4 = __stack_pointer - 16 | 0;
  __stack_pointer = $4;
  $6 = $0;
  label$1 : {
   if (!$1) {
    $1 = 0;
    $2 = 0;
    break label$1;
   }
   $3 = $1;
   $1 = Math_clz32($1);
   __ashlti3($4, $3, 0, 0, 0, $1 + 81 | 0);
   $2 = $4 + 8 | 0;
   $3 = HEAP32[$2 >> 2];
   $5 = HEAP32[$2 + 4 >> 2] ^ 65536;
   $2 = $3;
   $3 = 0;
   $2 = $2 + $3 | 0;
   $1 = (16414 - $1 << 16) + $5 | 0;
   $1 = $3 >>> 0 > $2 >>> 0 ? $1 + 1 | 0 : $1;
   $5 = $2;
   $3 = HEAP32[$4 + 4 >> 2];
   $2 = HEAP32[$4 >> 2];
  }
  HEAP32[$6 >> 2] = $2;
  HEAP32[$0 + 4 >> 2] = $3;
  HEAP32[$0 + 8 >> 2] = $5;
  HEAP32[$0 + 12 >> 2] = $1;
  __stack_pointer = $4 + 16 | 0;
 }
 
 function __subtf3($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  var $9 = 0;
  $9 = __stack_pointer - 16 | 0;
  __stack_pointer = $9;
  __addtf3($9, $1, $2, $3, $4, $5, $6, $7, $8 ^ -2147483648);
  $1 = HEAP32[$9 >> 2];
  $2 = HEAP32[$9 + 4 >> 2];
  $3 = $9 + 8 | 0;
  $4 = HEAP32[$3 + 4 >> 2];
  HEAP32[$0 + 8 >> 2] = HEAP32[$3 >> 2];
  HEAP32[$0 + 12 >> 2] = $4;
  HEAP32[$0 >> 2] = $1;
  HEAP32[$0 + 4 >> 2] = $2;
  __stack_pointer = $9 + 16 | 0;
 }
 
 function scalbnl($0, $1, $2, $3, $4, $5) {
  var $6 = 0, $7 = 0;
  $6 = __stack_pointer - 80 | 0;
  __stack_pointer = $6;
  label$1 : {
   if (($5 | 0) >= 16384) {
    $7 = $6 + 32 | 0;
    __multf3($7, $1, $2, $3, $4, 0, 0, 0, 2147352576);
    $1 = $7 + 8 | 0;
    $3 = HEAP32[$1 >> 2];
    $4 = HEAP32[$1 + 4 >> 2];
    $1 = HEAP32[$6 + 32 >> 2];
    $2 = HEAP32[$6 + 36 >> 2];
    if (($5 | 0) < 32767) {
     $5 = $5 - 16383 | 0;
     break label$1;
    }
    $7 = $6 + 16 | 0;
    __multf3($7, $1, $2, $3, $4, 0, 0, 0, 2147352576);
    $5 = (($5 | 0) < 49149 ? $5 : 49149) - 32766 | 0;
    $1 = $7 + 8 | 0;
    $3 = HEAP32[$1 >> 2];
    $4 = HEAP32[$1 + 4 >> 2];
    $1 = HEAP32[$6 + 16 >> 2];
    $2 = HEAP32[$6 + 20 >> 2];
    break label$1;
   }
   if (($5 | 0) > -16383) {
    break label$1
   }
   $7 = $6 - -64 | 0;
   __multf3($7, $1, $2, $3, $4, 0, 0, 0, 65536);
   $1 = $7 + 8 | 0;
   $3 = HEAP32[$1 >> 2];
   $4 = HEAP32[$1 + 4 >> 2];
   $1 = HEAP32[$6 + 64 >> 2];
   $2 = HEAP32[$6 + 68 >> 2];
   if (($5 | 0) > -32765) {
    $5 = $5 + 16382 | 0;
    break label$1;
   }
   $7 = $6 + 48 | 0;
   __multf3($7, $1, $2, $3, $4, 0, 0, 0, 65536);
   $5 = (($5 | 0) > -49146 ? $5 : -49146) + 32764 | 0;
   $1 = $7 + 8 | 0;
   $3 = HEAP32[$1 >> 2];
   $4 = HEAP32[$1 + 4 >> 2];
   $1 = HEAP32[$6 + 48 >> 2];
   $2 = HEAP32[$6 + 52 >> 2];
  }
  __multf3($6, $1, $2, $3, $4, 0, 0, 0, $5 + 16383 << 16);
  $1 = $6 + 8 | 0;
  $2 = HEAP32[$1 + 4 >> 2];
  HEAP32[$0 + 8 >> 2] = HEAP32[$1 >> 2];
  HEAP32[$0 + 12 >> 2] = $2;
  $1 = HEAP32[$6 + 4 >> 2];
  HEAP32[$0 >> 2] = HEAP32[$6 >> 2];
  HEAP32[$0 + 4 >> 2] = $1;
  __stack_pointer = $6 + 80 | 0;
 }
 
 function __multi3($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  var $9 = 0, $10 = 0, $11 = 0, $12 = 0;
  $7 = __wasm_i64_mul($7, $8, $1, $2);
  $8 = i64toi32_i32$HIGH_BITS;
  $9 = $7;
  $7 = __wasm_i64_mul($3, $4, $5, $6);
  $3 = $9 + $7 | 0;
  $4 = i64toi32_i32$HIGH_BITS + $8 | 0;
  $4 = $3 >>> 0 < $7 >>> 0 ? $4 + 1 | 0 : $4;
  $7 = $3;
  $9 = $6;
  $3 = 0;
  $6 = $3;
  $10 = $2;
  $8 = __wasm_i64_mul($9, $3, $2, 0);
  $7 = $8 + $7 | 0;
  $2 = i64toi32_i32$HIGH_BITS + $4 | 0;
  $11 = $7;
  $4 = $7 >>> 0 < $8 >>> 0 ? $2 + 1 | 0 : $2;
  $7 = $5;
  $2 = 0;
  $8 = $1;
  $5 = __wasm_i64_mul($7, $2, $1, 0);
  $1 = i64toi32_i32$HIGH_BITS;
  $7 = __wasm_i64_mul($7, $2, $10, $3);
  $3 = $1 + $7 | 0;
  $1 = i64toi32_i32$HIGH_BITS;
  $1 = $3 >>> 0 < $7 >>> 0 ? $1 + 1 | 0 : $1;
  $7 = $1;
  $1 = $7 + $11 | 0;
  $4 = $1 >>> 0 < $7 >>> 0 ? $4 + 1 | 0 : $4;
  $7 = $1;
  $2 = $4;
  $4 = __wasm_i64_mul($9, $6, $8, $12);
  $1 = $4 + $3 | 0;
  $3 = i64toi32_i32$HIGH_BITS;
  $3 = $1 >>> 0 < $4 >>> 0 ? $3 + 1 | 0 : $3;
  $4 = $7;
  $7 = $3;
  $3 = $4 + $7 | 0;
  HEAP32[$0 + 8 >> 2] = $3;
  HEAP32[$0 + 12 >> 2] = $3 >>> 0 < $7 >>> 0 ? $2 + 1 | 0 : $2;
  HEAP32[$0 >> 2] = $5;
  HEAP32[$0 + 4 >> 2] = $1;
 }
 
 function __divtf3($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  var $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
  $13 = __stack_pointer - 336 | 0;
  __stack_pointer = $13;
  $12 = $7;
  $11 = $8 & 65535;
  $16 = $3;
  $14 = $4 & 65535;
  $18 = ($4 ^ $8) & -2147483648;
  $24 = $8 >>> 16 & 32767;
  $29 = $4 >>> 16 & 32767;
  label$1 : {
   label$2 : {
    if ($29 - 1 >>> 0 <= 32765) {
     if ($24 - 1 >>> 0 < 32766) {
      break label$2
     }
    }
    $19 = $4 & 2147483647;
    $10 = $19;
    $9 = $3;
    if (!(!$3 & ($10 | 0) == 2147418112 ? !($1 | $2) : $10 >>> 0 < 2147418112)) {
     $30 = $3;
     $18 = $4 | 32768;
     break label$1;
    }
    $19 = $8 & 2147483647;
    $4 = $19;
    $3 = $7;
    if (!(!$3 & ($4 | 0) == 2147418112 ? !($5 | $6) : $4 >>> 0 < 2147418112)) {
     $30 = $7;
     $18 = $8 | 32768;
     $1 = $5;
     $2 = $6;
     break label$1;
    }
    if (!(($1 | $9) != 0 | ($10 ^ 2147418112 | $2) != 0)) {
     if (!($3 | $5 | ($4 ^ 2147418112 | $6))) {
      $1 = 0;
      $2 = 0;
      $18 = 2147450880;
      break label$1;
     }
     $18 = $18 | 2147418112;
     $1 = 0;
     $2 = 0;
     break label$1;
    }
    if (!(($3 | $5) != 0 | ($4 ^ 2147418112 | $6) != 0)) {
     $1 = 0;
     $2 = 0;
     break label$1;
    }
    if (!(($1 | $9) != 0 | ($2 | $10) != 0)) {
     $1 = !($3 | $5 | ($4 | $6));
     $30 = $1 ? 0 : $30;
     $18 = $1 ? 2147450880 : $18;
     $1 = 0;
     $2 = 0;
     break label$1;
    }
    if (!(($3 | $5) != 0 | ($4 | $6) != 0)) {
     $18 = $18 | 2147418112;
     $1 = 0;
     $2 = 0;
     break label$1;
    }
    if ($10 >>> 0 <= 65535) {
     $8 = $1;
     $3 = !($14 | $16);
     $7 = $3 << 6;
     $9 = Math_clz32($3 ? $1 : $16) + 32 | 0;
     $1 = Math_clz32($3 ? $2 : $14);
     $1 = $7 + (($1 | 0) == 32 ? $9 : $1) | 0;
     __ashlti3($13 + 320 | 0, $8, $2, $16, $14, $1 - 15 | 0);
     $17 = 16 - $1 | 0;
     $1 = $13 + 328 | 0;
     $16 = HEAP32[$1 >> 2];
     $14 = HEAP32[$1 + 4 >> 2];
     $2 = HEAP32[$13 + 324 >> 2];
     $1 = HEAP32[$13 + 320 >> 2];
    }
    if ($4 >>> 0 > 65535) {
     break label$2
    }
    $3 = !($12 | $11);
    $4 = $3 << 6;
    $7 = Math_clz32($3 ? $5 : $12) + 32 | 0;
    $3 = Math_clz32($3 ? $6 : $11);
    $3 = $4 + (($3 | 0) == 32 ? $7 : $3) | 0;
    __ashlti3($13 + 304 | 0, $5, $6, $12, $11, $3 - 15 | 0);
    $17 = ($3 + $17 | 0) - 16 | 0;
    $3 = $13 + 312 | 0;
    $12 = HEAP32[$3 >> 2];
    $11 = HEAP32[$3 + 4 >> 2];
    $5 = HEAP32[$13 + 304 >> 2];
    $6 = HEAP32[$13 + 308 >> 2];
   }
   $4 = 0;
   $7 = $11 | 65536;
   $25 = $7;
   $19 = $12;
   $3 = $12;
   $9 = $7 << 15 | $3 >>> 17;
   $3 = $3 << 15 | $6 >>> 17;
   $7 = 0 - $3 | 0;
   $4 = $4 | $9;
   $9 = $4;
   $8 = 1963258675 - ($9 + (($3 | 0) != 0) | 0) | 0;
   $10 = $13 + 288 | 0;
   __multi3($10, $3, $9, 0, 0, $7, $8, 0, 0);
   $12 = $13 + 272 | 0;
   $9 = $10 + 8 | 0;
   $10 = HEAP32[$9 >> 2];
   __multi3($12, 0 - $10 | 0, 0 - (HEAP32[$9 + 4 >> 2] + (($10 | 0) != 0) | 0) | 0, 0, 0, $7, $8, 0, 0);
   $10 = HEAP32[$13 + 276 >> 2] >>> 31 | 0;
   $7 = 0;
   $11 = $13 + 256 | 0;
   $8 = $12 + 8 | 0;
   $9 = HEAP32[$8 + 4 >> 2];
   $8 = HEAP32[$8 >> 2];
   $9 = $9 << 1 | $8 >>> 31;
   $8 = $8 << 1 | $10;
   $7 = $7 | $9;
   __multi3($11, $8, $7, 0, 0, $3, $4, 0, 0);
   $9 = $13 + 240 | 0;
   $10 = $8;
   $12 = $7;
   $7 = $11 + 8 | 0;
   $8 = HEAP32[$7 >> 2];
   __multi3($9, $10, $12, 0, 0, 0 - $8 | 0, 0 - (HEAP32[$7 + 4 >> 2] + (($8 | 0) != 0) | 0) | 0, 0, 0);
   $10 = HEAP32[$13 + 244 >> 2] >>> 31 | 0;
   $7 = 0;
   $12 = $13 + 224 | 0;
   $8 = $9 + 8 | 0;
   $9 = HEAP32[$8 + 4 >> 2];
   $8 = HEAP32[$8 >> 2];
   $9 = $9 << 1 | $8 >>> 31;
   $8 = $8 << 1 | $10;
   $7 = $7 | $9;
   __multi3($12, $8, $7, 0, 0, $3, $4, 0, 0);
   $9 = $13 + 208 | 0;
   $10 = $8;
   $11 = $7;
   $7 = $12 + 8 | 0;
   $8 = HEAP32[$7 >> 2];
   __multi3($9, $10, $11, 0, 0, 0 - $8 | 0, 0 - (HEAP32[$7 + 4 >> 2] + (($8 | 0) != 0) | 0) | 0, 0, 0);
   $10 = HEAP32[$13 + 212 >> 2] >>> 31 | 0;
   $7 = 0;
   $12 = $13 + 192 | 0;
   $8 = $9 + 8 | 0;
   $9 = HEAP32[$8 + 4 >> 2];
   $8 = HEAP32[$8 >> 2];
   $9 = $9 << 1 | $8 >>> 31;
   $8 = $8 << 1 | $10;
   $7 = $7 | $9;
   __multi3($12, $8, $7, 0, 0, $3, $4, 0, 0);
   $9 = $13 + 176 | 0;
   $10 = $8;
   $11 = $7;
   $7 = $12 + 8 | 0;
   $8 = HEAP32[$7 >> 2];
   __multi3($9, $10, $11, 0, 0, 0 - $8 | 0, 0 - (HEAP32[$7 + 4 >> 2] + (($8 | 0) != 0) | 0) | 0, 0, 0);
   $10 = HEAP32[$13 + 180 >> 2] >>> 31 | 0;
   $7 = 0;
   $8 = $3;
   $11 = $4;
   $3 = $9 + 8 | 0;
   $4 = HEAP32[$3 + 4 >> 2];
   $3 = HEAP32[$3 >> 2];
   $9 = $4 << 1 | $3 >>> 31;
   $3 = ($3 << 1 | $10) - 1 | 0;
   $10 = ($7 | $9) - 1 | 0;
   $12 = $3;
   $4 = ($3 | 0) != -1 ? $10 + 1 | 0 : $10;
   __multi3($13 + 160 | 0, $8, $11, 0, 0, $3, $4, 0, 0);
   $8 = $13 + 144 | 0;
   $7 = $5;
   __multi3($8, $7 << 15, $6 << 15 | $7 >>> 17, 0, 0, $3, $4, 0, 0);
   $3 = $13 + 168 | 0;
   $7 = HEAP32[$3 >> 2];
   $9 = HEAP32[$3 + 4 >> 2];
   $15 = $7;
   $11 = HEAP32[$13 + 160 >> 2];
   $3 = $8 + 8 | 0;
   $8 = HEAP32[$3 >> 2];
   $7 = $11 + $8 | 0;
   $10 = HEAP32[$13 + 164 >> 2];
   $3 = $10 + HEAP32[$3 + 4 >> 2] | 0;
   $3 = $7 >>> 0 < $8 >>> 0 ? $3 + 1 | 0 : $3;
   $8 = $7;
   $7 = $3;
   $10 = ($10 | 0) == ($3 | 0) & $11 >>> 0 > $8 >>> 0 | $3 >>> 0 < $10 >>> 0;
   $3 = $15 + $10 | 0;
   $9 = $3 >>> 0 < $10 >>> 0 ? $9 + 1 | 0 : $9;
   $11 = !$7 & $8 >>> 0 > 1 | ($7 | 0) != 0;
   $3 = $11 + $3 | 0;
   $10 = $3 >>> 0 < $11 >>> 0 ? $9 + 1 | 0 : $9;
   __multi3($13 + 112 | 0, $12, $4, 0, 0, 0 - $3 | 0, 0 - ((($3 | 0) != 0) + $10 | 0) | 0, 0, 0);
   $15 = $13 + 128 | 0;
   __multi3($15, 1 - $8 | 0, 0 - (($8 >>> 0 > 1) + $7 | 0) | 0, 0, 0, $12, $4, 0, 0);
   $39 = ($29 - $24 | 0) + $17 | 0;
   $3 = HEAP32[$13 + 116 >> 2];
   $31 = $3;
   $4 = HEAP32[$13 + 112 >> 2];
   $3 = $3 << 1 | $4 >>> 31;
   $11 = $4 << 1;
   $20 = $3;
   $8 = $3;
   $10 = HEAP32[$13 + 132 >> 2] >>> 31 | 0;
   $9 = 0;
   $4 = $15 + 8 | 0;
   $3 = HEAP32[$4 + 4 >> 2];
   $26 = HEAP32[$4 >> 2];
   $4 = $3;
   $7 = $26;
   $3 = $3 << 1 | $7 >>> 31;
   $10 = $7 << 1 | $10;
   $7 = $10 + $11 | 0;
   $9 = ($3 | $9) + $8 | 0;
   $34 = $7;
   $9 = $7 >>> 0 < $10 >>> 0 ? $9 + 1 | 0 : $9;
   $12 = $9;
   $10 = $9 - 1 | 0;
   $3 = $7 - 13927 | 0;
   $10 = $3 >>> 0 < 4294953369 ? $10 + 1 | 0 : $10;
   $7 = $3;
   $21 = $10;
   $8 = 0;
   $17 = $8;
   $3 = $14 | 65536;
   $24 = $3;
   $32 = $10;
   $29 = $16;
   $22 = ($3 & 2147483647) << 1 | $16 >>> 31;
   $8 = __wasm_i64_mul($10, $8, $22, 0);
   $3 = i64toi32_i32$HIGH_BITS;
   $15 = $3;
   $3 = $2;
   $35 = ($3 & 2147483647) << 1 | $1 >>> 31;
   $23 = 0;
   $3 = $13 + 120 | 0;
   $9 = HEAP32[$3 + 4 >> 2];
   $3 = HEAP32[$3 >> 2];
   $10 = $9 << 1 | $3 >>> 31;
   $4 = $4 >>> 31 | 0;
   $3 = $4 + ($3 << 1 | $31 >>> 31) | 0;
   $9 = $10;
   $9 = $3 >>> 0 < $4 >>> 0 ? $9 + 1 | 0 : $9;
   $10 = ($12 | 0) == ($20 | 0) & $11 >>> 0 > $34 >>> 0 | $12 >>> 0 < $20 >>> 0;
   $4 = $10 + $3 | 0;
   $3 = $9;
   $3 = $4 >>> 0 < $10 >>> 0 ? $3 + 1 | 0 : $3;
   $10 = ($12 | 0) == ($21 | 0) & $7 >>> 0 < $34 >>> 0 | $12 >>> 0 > $21 >>> 0;
   $4 = $10 + $4 | 0;
   $9 = $3;
   $3 = $4 - 1 | 0;
   $9 = ($4 >>> 0 < $10 >>> 0 ? $9 + 1 | 0 : $9) - 1 | 0;
   $12 = $3;
   $27 = ($3 | 0) != -1 ? $9 + 1 | 0 : $9;
   $20 = 0;
   $9 = __wasm_i64_mul($35, $23, $27, $20);
   $4 = $9 + $8 | 0;
   $3 = i64toi32_i32$HIGH_BITS + $15 | 0;
   $3 = $4 >>> 0 < $9 >>> 0 ? $3 + 1 | 0 : $3;
   $9 = $4;
   $10 = $3;
   $31 = ($15 | 0) == ($3 | 0) & $8 >>> 0 > $9 >>> 0 | $3 >>> 0 < $15 >>> 0;
   $9 = 0;
   $26 = $9;
   $34 = 0;
   $8 = $16;
   $40 = $2 >>> 31 | 0;
   $36 = $40 | $8 << 1;
   $11 = __wasm_i64_mul($12, $9, $36, 0);
   $9 = $11 + $4 | 0;
   $8 = i64toi32_i32$HIGH_BITS + $3 | 0;
   $16 = $9;
   $3 = $9;
   $8 = $3 >>> 0 < $11 >>> 0 ? $8 + 1 | 0 : $8;
   $11 = $8;
   $4 = ($10 | 0) == ($8 | 0) & $3 >>> 0 < $4 >>> 0 | $8 >>> 0 < $10 >>> 0;
   $3 = $4 + $31 | 0;
   $9 = 0;
   $9 = $3 >>> 0 < $4 >>> 0 ? 1 : $9;
   $4 = __wasm_i64_mul($22, $33, $27, $20);
   $3 = $4 + $3 | 0;
   $10 = i64toi32_i32$HIGH_BITS + $9 | 0;
   $10 = $3 >>> 0 < $4 >>> 0 ? $10 + 1 | 0 : $10;
   $21 = $3;
   $9 = __wasm_i64_mul($12, $26, $22, $33);
   $3 = i64toi32_i32$HIGH_BITS;
   $14 = __wasm_i64_mul($36, $41, $27, $20);
   $4 = $14 + $9 | 0;
   $8 = i64toi32_i32$HIGH_BITS + $3 | 0;
   $8 = $4 >>> 0 < $14 >>> 0 ? $8 + 1 | 0 : $8;
   $14 = $4;
   $4 = $8;
   $8 = ($3 | 0) == ($8 | 0) & $9 >>> 0 > $14 >>> 0 | $3 >>> 0 > $8 >>> 0;
   $21 = $4 + $21 | 0;
   $9 = $8 + $10 | 0;
   $3 = $21;
   $8 = $3 >>> 0 < $4 >>> 0 ? $9 + 1 | 0 : $9;
   $10 = 0;
   $4 = $10 + $16 | 0;
   $9 = $11 + $14 | 0;
   $9 = $4 >>> 0 < $10 >>> 0 ? $9 + 1 | 0 : $9;
   $14 = $4;
   $3 = $9;
   $9 = ($11 | 0) == ($3 | 0) & $4 >>> 0 < $16 >>> 0 | $3 >>> 0 < $11 >>> 0;
   $4 = $21 + $9 | 0;
   $8 = $4 >>> 0 < $9 >>> 0 ? $8 + 1 | 0 : $8;
   $21 = $1 << 1;
   $16 = $2 << 1 | $1 >>> 31;
   $37 = $21 & -2;
   $28 = __wasm_i64_mul($12, $26, $37, 0);
   $9 = i64toi32_i32$HIGH_BITS;
   $11 = $4;
   $31 = $7;
   $7 = __wasm_i64_mul($7, 0, $36, $41);
   $4 = $7 + $28 | 0;
   $10 = i64toi32_i32$HIGH_BITS + $9 | 0;
   $10 = $4 >>> 0 < $7 >>> 0 ? $10 + 1 | 0 : $10;
   $15 = $4;
   $7 = $10;
   $38 = ($9 | 0) == ($10 | 0) & $4 >>> 0 < $28 >>> 0 | $9 >>> 0 > $10 >>> 0;
   $28 = __wasm_i64_mul($32, $17, $35, $23);
   $4 = $28 + $4 | 0;
   $9 = i64toi32_i32$HIGH_BITS + $10 | 0;
   $9 = $4 >>> 0 < $28 >>> 0 ? $9 + 1 | 0 : $9;
   $28 = $4;
   $10 = $4;
   $4 = $9;
   $10 = ($7 | 0) == ($9 | 0) & $10 >>> 0 < $15 >>> 0 | $7 >>> 0 > $9 >>> 0;
   $7 = $38 + $10 | 0;
   $9 = 0;
   $9 = $7 >>> 0 < $10 >>> 0 ? 1 : $9;
   $15 = $7;
   $7 = $7 + $14 | 0;
   $10 = $9 + $3 | 0;
   $10 = $7 >>> 0 < $15 >>> 0 ? $10 + 1 | 0 : $10;
   $15 = $7;
   $9 = $7;
   $7 = $10;
   $10 = ($3 | 0) == ($10 | 0) & $9 >>> 0 < $14 >>> 0 | $3 >>> 0 > $10 >>> 0;
   $3 = $11 + $10 | 0;
   $9 = $8;
   $38 = $3;
   $8 = $3 >>> 0 < $10 >>> 0 ? $9 + 1 | 0 : $9;
   $33 = __wasm_i64_mul($31, $42, $22, $33);
   $22 = i64toi32_i32$HIGH_BITS;
   $10 = __wasm_i64_mul($37, $43, $27, $20);
   $9 = $10 + $33 | 0;
   $3 = i64toi32_i32$HIGH_BITS + $22 | 0;
   $3 = $9 >>> 0 < $10 >>> 0 ? $3 + 1 | 0 : $3;
   $27 = $9;
   $11 = __wasm_i64_mul($12, $26, $35, $23);
   $9 = $9 + $11 | 0;
   $12 = $3;
   $10 = $3 + i64toi32_i32$HIGH_BITS | 0;
   $26 = $9;
   $14 = __wasm_i64_mul($32, $17, $36, $41);
   $3 = $9 + $14 | 0;
   $11 = $9 >>> 0 < $11 >>> 0 ? $10 + 1 | 0 : $10;
   $9 = $11 + i64toi32_i32$HIGH_BITS | 0;
   $9 = $3 >>> 0 < $14 >>> 0 ? $9 + 1 | 0 : $9;
   $14 = $3;
   $10 = $9;
   $3 = ($12 | 0) == ($22 | 0) & $33 >>> 0 > $27 >>> 0 | $12 >>> 0 < $22 >>> 0;
   $12 = ($12 | 0) == ($11 | 0) & $26 >>> 0 < $27 >>> 0 | $12 >>> 0 > $11 >>> 0;
   $3 = $3 + $12 | 0;
   $12 = ($10 | 0) == ($11 | 0) & $14 >>> 0 < $26 >>> 0 | $10 >>> 0 < $11 >>> 0;
   $3 = $12 + $3 | 0;
   $11 = $10 | 0;
   $12 = $11 + $15 | 0;
   $9 = ($3 | $20) + $7 | 0;
   $9 = $12 >>> 0 < $11 >>> 0 ? $9 + 1 | 0 : $9;
   $11 = $12;
   $3 = $12;
   $12 = $9;
   $7 = ($7 | 0) == ($9 | 0) & $3 >>> 0 < $15 >>> 0 | $7 >>> 0 > $9 >>> 0;
   $3 = $7 + $38 | 0;
   $9 = $8;
   $22 = $3;
   $7 = $3 >>> 0 < $7 >>> 0 ? $9 + 1 | 0 : $9;
   $15 = $28;
   $32 = __wasm_i64_mul($32, $17, $37, $43);
   $10 = i64toi32_i32$HIGH_BITS;
   $8 = __wasm_i64_mul($31, $42, $35, $23);
   $3 = $8 + $32 | 0;
   $9 = i64toi32_i32$HIGH_BITS + $10 | 0;
   $9 = $3 >>> 0 < $8 >>> 0 ? $9 + 1 | 0 : $9;
   $17 = $9;
   $9 = 0;
   $8 = ($17 | 0) == ($10 | 0) & $3 >>> 0 < $32 >>> 0 | $17 >>> 0 < $10 >>> 0;
   $3 = $17 + $15 | 0;
   $9 = ($8 | $9) + $4 | 0;
   $9 = $3 >>> 0 < $17 >>> 0 ? $9 + 1 | 0 : $9;
   $8 = $3;
   $3 = $9;
   $17 = ($4 | 0) == ($3 | 0) & $8 >>> 0 < $15 >>> 0 | $3 >>> 0 < $4 >>> 0;
   $15 = $17;
   $9 = $14;
   $17 = 0;
   $14 = $17 + $8 | 0;
   $10 = $3 + $9 | 0;
   $4 = $14;
   $10 = $4 >>> 0 < $17 >>> 0 ? $10 + 1 | 0 : $10;
   $4 = ($3 | 0) == ($10 | 0) & $4 >>> 0 < $8 >>> 0 | $3 >>> 0 > $10 >>> 0;
   $3 = $15 + $4 | 0;
   $9 = 0;
   $9 = $3 >>> 0 < $4 >>> 0 ? 1 : $9;
   $4 = $3;
   $3 = $3 + $11 | 0;
   $9 = $9 + $12 | 0;
   $9 = $3 >>> 0 < $4 >>> 0 ? $9 + 1 | 0 : $9;
   $4 = $9;
   $9 = ($12 | 0) == ($9 | 0) & $3 >>> 0 < $11 >>> 0 | $9 >>> 0 < $12 >>> 0;
   $8 = $9 + $22 | 0;
   $10 = $7;
   $7 = $8;
   $10 = $8 >>> 0 < $9 >>> 0 ? $10 + 1 | 0 : $10;
   $8 = $10;
   label$12 : {
    if ($8 >>> 0 <= 131071) {
     $9 = $29;
     $10 = $24 << 1 | $9 >>> 31;
     $29 = $40 | $9 << 1;
     $24 = $10 | $34;
     $2 = $13 + 80 | 0;
     __multi3($2, $3, $4, $7, $8, $5, $6, $19, $25);
     $10 = $1 << 17;
     $1 = 0;
     $2 = $2 + 8 | 0;
     $12 = HEAP32[$2 >> 2];
     $14 = $1 - $12 | 0;
     $9 = HEAP32[$13 + 80 >> 2];
     $15 = ($9 | 0) != 0;
     $11 = HEAP32[$13 + 84 >> 2];
     $23 = $15 | ($11 | 0) != 0;
     $17 = $14 - $23 | 0;
     $10 = ($10 - (HEAP32[$2 + 4 >> 2] + ($1 >>> 0 < $12 >>> 0) | 0) | 0) - ($14 >>> 0 < $23 >>> 0) | 0;
     $14 = $39 + 16382 | 0;
     $11 = 0 - ($11 + $15 | 0) | 0;
     $12 = 0 - $9 | 0;
     break label$12;
    }
    $3 = ($4 & 1) << 31 | $3 >>> 1;
    $4 = $4 >>> 1 | 0;
    $9 = $7 << 31;
    $9 = $4 | $9;
    $4 = $9;
    $10 = $13 + 96 | 0;
    $7 = ($8 & 1) << 31 | $7 >>> 1;
    $8 = $8 >>> 1 | 0;
    __multi3($10, $3, $9, $7, $8, $5, $6, $19, $25);
    $12 = 0;
    $16 = $10 + 8 | 0;
    $14 = HEAP32[$16 >> 2];
    $23 = $12 - $14 | 0;
    $9 = HEAP32[$13 + 96 >> 2];
    $15 = ($9 | 0) != 0;
    $11 = HEAP32[$13 + 100 >> 2];
    $20 = $15 | ($11 | 0) != 0;
    $17 = $23 - $20 | 0;
    $10 = (($1 << 16) - (HEAP32[$16 + 4 >> 2] + ($12 >>> 0 < $14 >>> 0) | 0) | 0) - ($20 >>> 0 > $23 >>> 0) | 0;
    $14 = $39 + 16383 | 0;
    $11 = 0 - ($11 + $15 | 0) | 0;
    $21 = $1;
    $16 = $2;
    $12 = 0 - $9 | 0;
   }
   if (($14 | 0) >= 32767) {
    $18 = $18 | 2147418112;
    $1 = 0;
    $2 = 0;
    break label$1;
   }
   label$15 : {
    if (($14 | 0) >= 1) {
     $1 = $17;
     $9 = $10 << 1 | $1 >>> 31;
     $2 = $1 << 1;
     $1 = $11;
     $17 = $2 | $1 >>> 31;
     $10 = $9;
     $16 = $7;
     $2 = $8 & 65535 | $14 << 16;
     $7 = $1 << 1;
     $1 = $12;
     $9 = $7 | $1 >>> 31;
     $7 = $1 << 1;
     $8 = $9;
     break label$15;
    }
    if (($14 | 0) <= -113) {
     $1 = 0;
     $2 = 0;
     break label$1;
    }
    $1 = $13 - -64 | 0;
    __lshrti3($1, $3, $4, $7, $8, 1 - $14 | 0);
    $7 = $13 + 48 | 0;
    __ashlti3($7, $21, $16, $29, $24, $14 + 112 | 0);
    $8 = $13 + 32 | 0;
    $3 = HEAP32[$13 + 64 >> 2];
    $4 = HEAP32[$13 + 68 >> 2];
    $1 = $1 + 8 | 0;
    $16 = HEAP32[$1 >> 2];
    $2 = HEAP32[$1 + 4 >> 2];
    __multi3($8, $5, $6, $19, $25, $3, $4, $16, $2);
    $7 = $7 + 8 | 0;
    $1 = HEAP32[$7 >> 2];
    $12 = HEAP32[$7 + 4 >> 2];
    $7 = $8 + 8 | 0;
    $8 = HEAP32[$7 + 4 >> 2];
    $7 = HEAP32[$7 >> 2];
    $10 = $7 << 1;
    $7 = $8 << 1 | $7 >>> 31;
    $11 = HEAP32[$13 + 36 >> 2];
    $8 = $11;
    $11 = $8 >>> 31 | $10;
    $10 = $1 - $11 | 0;
    $12 = $12 - (($1 >>> 0 < $11 >>> 0) + $7 | 0) | 0;
    $7 = HEAP32[$13 + 32 >> 2];
    $8 = $8 << 1 | $7 >>> 31;
    $7 = $7 << 1;
    $24 = HEAP32[$13 + 52 >> 2];
    $9 = $24;
    $1 = HEAP32[$13 + 48 >> 2];
    $9 = ($8 | 0) == ($9 | 0) & $7 >>> 0 > $1 >>> 0 | $8 >>> 0 > $9 >>> 0;
    $17 = $10 - $9 | 0;
    $10 = $12 - ($9 >>> 0 > $10 >>> 0) | 0;
    $9 = $7;
    $7 = $1 - $9 | 0;
    $8 = $24 - (($1 >>> 0 < $9 >>> 0) + $8 | 0) | 0;
   }
   __multi3($13 + 16 | 0, $5, $6, $19, $25, 3, 0, 0, 0);
   __multi3($13, $5, $6, $19, $25, 5, 0, 0, 0);
   $14 = $16;
   $11 = 0;
   $8 = $8 + $11 | 0;
   $16 = $3 & 1;
   $9 = $7 + $16 | 0;
   $8 = $9 >>> 0 < $7 >>> 0 ? $8 + 1 | 0 : $8;
   $12 = $9;
   $7 = $8;
   $1 = ($6 | 0) == ($8 | 0) & $5 >>> 0 < $9 >>> 0 | $6 >>> 0 < $8 >>> 0;
   $6 = ($8 | 0) == ($11 | 0) & $9 >>> 0 < $16 >>> 0 | $8 >>> 0 < $11 >>> 0;
   $5 = $6 + $17 | 0;
   $9 = $10;
   $9 = $5 >>> 0 < $6 >>> 0 ? $9 + 1 | 0 : $9;
   $6 = $5;
   $8 = $5;
   $5 = $9;
   $10 = ($8 | 0) == ($19 | 0) & ($9 | 0) == ($25 | 0) ? $1 : ($25 | 0) == ($9 | 0) & $8 >>> 0 > $19 >>> 0 | $9 >>> 0 > $25 >>> 0;
   $8 = $10 + $3 | 0;
   $9 = $4;
   $9 = $8 >>> 0 < $10 >>> 0 ? $9 + 1 | 0 : $9;
   $1 = $9;
   $4 = ($4 | 0) == ($9 | 0) & $3 >>> 0 > $8 >>> 0 | $4 >>> 0 > $9 >>> 0;
   $3 = $14 + $4 | 0;
   $9 = $2;
   $9 = $3 >>> 0 < $4 >>> 0 ? $9 + 1 | 0 : $9;
   $2 = $9;
   $16 = $3;
   $10 = $9 >>> 0 < 2147418112;
   $3 = HEAP32[$13 + 20 >> 2];
   $11 = ($3 | 0) == ($7 | 0) & HEAPU32[$13 + 16 >> 2] < $12 >>> 0 | $3 >>> 0 < $7 >>> 0;
   $3 = $13 + 24 | 0;
   $4 = HEAP32[$3 >> 2];
   $9 = $4;
   $3 = HEAP32[$3 + 4 >> 2];
   $9 = $10 & (($9 | 0) == ($6 | 0) & ($3 | 0) == ($5 | 0) ? $11 : ($3 | 0) == ($5 | 0) & $6 >>> 0 > $9 >>> 0 | $3 >>> 0 < $5 >>> 0);
   $4 = $9 + $8 | 0;
   $3 = $1;
   $3 = $4 >>> 0 < $9 >>> 0 ? $3 + 1 | 0 : $3;
   $10 = $4;
   $9 = $4;
   $4 = $3;
   $3 = ($1 | 0) == ($3 | 0) & $8 >>> 0 > $9 >>> 0 | $1 >>> 0 > $3 >>> 0;
   $1 = $16 + $3 | 0;
   $9 = $2;
   $9 = $1 >>> 0 < $3 >>> 0 ? $9 + 1 | 0 : $9;
   $8 = $1;
   $3 = $9;
   $1 = HEAP32[$13 + 4 >> 2];
   $9 = ($1 | 0) == ($7 | 0) & HEAPU32[$13 >> 2] < $12 >>> 0 | $1 >>> 0 < $7 >>> 0;
   $1 = $13 + 8 | 0;
   $2 = HEAP32[$1 >> 2];
   $7 = $2;
   $1 = HEAP32[$1 + 4 >> 2];
   $2 = $3 >>> 0 < 2147418112 & (($7 | 0) == ($6 | 0) & ($1 | 0) == ($5 | 0) ? $9 : ($1 | 0) == ($5 | 0) & $6 >>> 0 > $7 >>> 0 | $1 >>> 0 < $5 >>> 0);
   $1 = $2 + $10 | 0;
   $9 = $4;
   $9 = $1 >>> 0 < $2 >>> 0 ? $9 + 1 | 0 : $9;
   $2 = $9;
   $5 = ($4 | 0) == ($9 | 0) & $1 >>> 0 < $10 >>> 0 | $4 >>> 0 > $9 >>> 0;
   $4 = $8 + $5 | 0;
   $30 = $30 | $4;
   $18 = $18 | ($4 >>> 0 < $5 >>> 0 ? $3 + 1 | 0 : $3);
  }
  HEAP32[$0 >> 2] = $1;
  HEAP32[$0 + 4 >> 2] = $2;
  HEAP32[$0 + 8 >> 2] = $30;
  HEAP32[$0 + 12 >> 2] = $18;
  __stack_pointer = $13 + 336 | 0;
 }
 
 function fmodl($0, $1, $2, $3, $4, $5, $6, $7, $8) {
  var $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0;
  $10 = __stack_pointer - 128 | 0;
  __stack_pointer = $10;
  label$1 : {
   label$2 : {
    label$3 : {
     if (!__letf2($5, $6, $7, $8, 0, 0, 0, 0)) {
      break label$3
     }
     $13 = $5;
     $11 = $6;
     $9 = $7;
     $15 = $8 & 65535;
     $14 = $8 >>> 16 & 32767;
     __inlined_func$__fpclassifyl : {
      label$10 : {
       if (($14 | 0) != 32767) {
        $12 = 4;
        if ($14) {
         break label$10
        }
        $12 = $9 | $13 | ($11 | $15) ? 3 : 2;
        break __inlined_func$__fpclassifyl;
       }
       $12 = !($9 | $13 | ($11 | $15));
      }
     }
     if (!$12) {
      break label$3
     }
     $18 = $4 >>> 16 | 0;
     $12 = $18 & 32767;
     if (($12 | 0) != 32767) {
      break label$2
     }
    }
    $9 = $10 + 16 | 0;
    __multf3($9, $1, $2, $3, $4, $5, $6, $7, $8);
    $4 = HEAP32[$10 + 16 >> 2];
    $3 = HEAP32[$10 + 20 >> 2];
    $1 = $9 + 8 | 0;
    $2 = HEAP32[$1 >> 2];
    $1 = HEAP32[$1 + 4 >> 2];
    __divtf3($10, $4, $3, $2, $1, $4, $3, $2, $1);
    $1 = $10 + 8 | 0;
    $3 = HEAP32[$1 >> 2];
    $4 = HEAP32[$1 + 4 >> 2];
    $7 = HEAP32[$10 >> 2];
    $8 = HEAP32[$10 + 4 >> 2];
    break label$1;
   }
   $9 = $4 & 65535 | $12 << 16;
   $13 = $9;
   $14 = $3;
   $11 = $7;
   $15 = $8 >>> 16 & 32767;
   $9 = $8 & 65535 | $15 << 16;
   if ((__letf2($1, $2, $14, $13, $5, $6, $7, $9) | 0) <= 0) {
    if (__letf2($1, $2, $14, $13, $5, $6, $11, $9)) {
     $7 = $1;
     $8 = $2;
     break label$1;
    }
    __multf3($10 + 112 | 0, $1, $2, $3, $4, 0, 0, 0, 0);
    $1 = $10 + 120 | 0;
    $3 = HEAP32[$1 >> 2];
    $4 = HEAP32[$1 + 4 >> 2];
    $7 = HEAP32[$10 + 112 >> 2];
    $8 = HEAP32[$10 + 116 >> 2];
    break label$1;
   }
   label$6 : {
    if ($12) {
     $8 = $2;
     $7 = $1;
     break label$6;
    }
    __multf3($10 + 96 | 0, $1, $2, $14, $13, 0, 0, 0, 1081540608);
    $7 = $10 + 104 | 0;
    $13 = HEAP32[$7 + 4 >> 2];
    $14 = HEAP32[$7 >> 2];
    $12 = ($13 >>> 16 | 0) - 120 | 0;
    $8 = HEAP32[$10 + 100 >> 2];
    $7 = HEAP32[$10 + 96 >> 2];
   }
   if (!$15) {
    __multf3($10 + 80 | 0, $5, $6, $11, $9, 0, 0, 0, 1081540608);
    $5 = $10 + 88 | 0;
    $9 = HEAP32[$5 + 4 >> 2];
    $11 = HEAP32[$5 >> 2];
    $15 = ($9 >>> 16 | 0) - 120 | 0;
    $6 = HEAP32[$10 + 84 >> 2];
    $5 = HEAP32[$10 + 80 >> 2];
   }
   $19 = $9 & 65535 | 65536;
   $13 = $13 & 65535 | 65536;
   if (($12 | 0) > ($15 | 0)) {
    while (1) {
     $16 = $14 - $11 | 0;
     $9 = ($6 | 0) == ($8 | 0) & $5 >>> 0 > $7 >>> 0 | $6 >>> 0 > $8 >>> 0;
     $17 = ($13 - (($11 >>> 0 > $14 >>> 0) + $19 | 0) | 0) - ($16 >>> 0 < $9 >>> 0) | 0;
     $16 = $16 - $9 | 0;
     label$11 : {
      if (($17 | 0) >= 0) {
       $9 = $7;
       $7 = $9 - $5 | 0;
       $8 = $8 - (($5 >>> 0 > $9 >>> 0) + $6 | 0) | 0;
       if (!(($7 | $16) != 0 | ($8 | $17) != 0)) {
        __multf3($10 + 32 | 0, $1, $2, $3, $4, 0, 0, 0, 0);
        $1 = $10 + 40 | 0;
        $3 = HEAP32[$1 >> 2];
        $4 = HEAP32[$1 + 4 >> 2];
        $7 = HEAP32[$10 + 32 >> 2];
        $8 = HEAP32[$10 + 36 >> 2];
        break label$1;
       }
       $14 = $16 << 1 | $8 >>> 31;
       $9 = $17 << 1 | $16 >>> 31;
       break label$11;
      }
      $9 = $13 << 1 | $14 >>> 31;
      $14 = $14 << 1 | $8 >>> 31;
     }
     $13 = $9;
     $8 = $8 << 1 | $7 >>> 31;
     $7 = $7 << 1;
     $12 = $12 - 1 | 0;
     if (($15 | 0) < ($12 | 0)) {
      continue
     }
     break;
    };
    $12 = $15;
   }
   $9 = $13 - (($11 >>> 0 > $14 >>> 0) + $19 | 0) | 0;
   $15 = $14 - $11 | 0;
   $11 = ($6 | 0) == ($8 | 0) & $5 >>> 0 > $7 >>> 0 | $6 >>> 0 > $8 >>> 0;
   $9 = $9 - ($15 >>> 0 < $11 >>> 0) | 0;
   $11 = $15 - $11 | 0;
   label$14 : {
    if (!(($9 | 0) > 0 | ($9 | 0) >= 0)) {
     $11 = $14;
     $9 = $13;
     break label$14;
    }
    $13 = $7;
    $7 = $7 - $5 | 0;
    $8 = $8 - (($5 >>> 0 > $13 >>> 0) + $6 | 0) | 0;
    if ($7 | $11 | ($8 | $9)) {
     break label$14
    }
    __multf3($10 + 48 | 0, $1, $2, $3, $4, 0, 0, 0, 0);
    $1 = $10 + 56 | 0;
    $3 = HEAP32[$1 >> 2];
    $4 = HEAP32[$1 + 4 >> 2];
    $7 = HEAP32[$10 + 48 >> 2];
    $8 = HEAP32[$10 + 52 >> 2];
    break label$1;
   }
   if ($9 >>> 0 <= 65535) {
    while (1) {
     $1 = $8 >>> 31 | 0;
     $12 = $12 - 1 | 0;
     $8 = $8 << 1 | $7 >>> 31;
     $7 = $7 << 1;
     $9 = $9 << 1 | $11 >>> 31;
     $11 = $1 | $11 << 1;
     if ($9 >>> 0 < 65536) {
      continue
     }
     break;
    }
   }
   $1 = $18 & 32768;
   if (($12 | 0) <= 0) {
    __multf3($10 - -64 | 0, $7, $8, $11, $9 & 65535 | ($1 | $12 + 120) << 16, 0, 0, 0, 1065811968);
    $1 = $10 + 72 | 0;
    $3 = HEAP32[$1 >> 2];
    $4 = HEAP32[$1 + 4 >> 2];
    $7 = HEAP32[$10 + 64 >> 2];
    $8 = HEAP32[$10 + 68 >> 2];
    break label$1;
   }
   $3 = $11;
   $4 = $9 & 65535 | ($1 | $12) << 16;
  }
  HEAP32[$0 >> 2] = $7;
  HEAP32[$0 + 4 >> 2] = $8;
  HEAP32[$0 + 8 >> 2] = $3;
  HEAP32[$0 + 12 >> 2] = $4;
  __stack_pointer = $10 + 128 | 0;
 }
 
 function scanexp($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
  label$3 : {
   label$4 : {
    label$5 : {
     $2 = HEAP32[$0 + 4 >> 2];
     label$1 : {
      if ($2 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
       HEAP32[$0 + 4 >> 2] = $2 + 1;
       $1 = HEAPU8[$2 | 0];
       break label$1;
      }
      $1 = __shgetc($0);
     }
     switch ($1 - 43 | 0) {
     case 0:
     case 2:
      break label$4;
     default:
      break label$5;
     };
    }
    $4 = $1 - 48 | 0;
    break label$3;
   }
   $5 = ($1 | 0) == 45;
   $2 = HEAP32[$0 + 4 >> 2];
   label$6 : {
    if ($2 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
     HEAP32[$0 + 4 >> 2] = $2 + 1;
     $1 = HEAPU8[$2 | 0];
     break label$6;
    }
    $1 = __shgetc($0);
   }
   $4 = $1 - 48 | 0;
   if (!($4 >>> 0 < 10 | !HEAP32[$0 + 104 >> 2])) {
    HEAP32[$0 + 4 >> 2] = HEAP32[$0 + 4 >> 2] - 1
   }
  }
  label$9 : {
   if ($4 >>> 0 < 10) {
    while (1) {
     $3 = (Math_imul($3, 10) + $1 | 0) - 48 | 0;
     $6 = ($3 | 0) < 214748364;
     $2 = HEAP32[$0 + 4 >> 2];
     label$12 : {
      if ($2 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
       HEAP32[$0 + 4 >> 2] = $2 + 1;
       $1 = HEAPU8[$2 | 0];
       break label$12;
      }
      $1 = __shgetc($0);
     }
     $4 = $1 - 48 | 0;
     if ($6 & $4 >>> 0 <= 9) {
      continue
     }
     break;
    };
    $2 = $3;
    $3 = $2 >> 31;
    label$15 : {
     if ($4 >>> 0 >= 10) {
      break label$15
     }
     while (1) {
      $3 = __wasm_i64_mul($2, $3, 10, 0);
      $2 = $1 + $3 | 0;
      $1 = i64toi32_i32$HIGH_BITS;
      $3 = ($2 >>> 0 < $3 >>> 0 ? $1 + 1 | 0 : $1) - 1 | 0;
      $2 = $2 - 48 | 0;
      $3 = $2 >>> 0 < 4294967248 ? $3 + 1 | 0 : $3;
      $1 = HEAP32[$0 + 4 >> 2];
      label$17 : {
       if ($1 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
        HEAP32[$0 + 4 >> 2] = $1 + 1;
        $1 = HEAPU8[$1 | 0];
        break label$17;
       }
       $1 = __shgetc($0);
      }
      $4 = $1 - 48 | 0;
      if ($4 >>> 0 > 9) {
       break label$15
      }
      if ($2 >>> 0 < 2061584302 & ($3 | 0) <= 21474836 | ($3 | 0) < 21474836) {
       continue
      }
      break;
     };
    }
    if ($4 >>> 0 < 10) {
     while (1) {
      $1 = HEAP32[$0 + 4 >> 2];
      label$21 : {
       if ($1 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
        HEAP32[$0 + 4 >> 2] = $1 + 1;
        $1 = HEAPU8[$1 | 0];
        break label$21;
       }
       $1 = __shgetc($0);
      }
      if ($1 - 48 >>> 0 < 10) {
       continue
      }
      break;
     }
    }
    if (HEAP32[$0 + 104 >> 2]) {
     HEAP32[$0 + 4 >> 2] = HEAP32[$0 + 4 >> 2] - 1
    }
    $0 = $2;
    $2 = $5 ? 0 - $0 | 0 : $0;
    $3 = $5 ? 0 - ($3 + (($0 | 0) != 0) | 0) | 0 : $3;
    break label$9;
   }
   $2 = 0;
   $3 = -2147483648;
   if (!HEAP32[$0 + 104 >> 2]) {
    break label$9
   }
   HEAP32[$0 + 4 >> 2] = HEAP32[$0 + 4 >> 2] - 1;
   i64toi32_i32$HIGH_BITS = -2147483648;
   return 0;
  }
  i64toi32_i32$HIGH_BITS = $3;
  return $2;
 }
 
 function strtod($0) {
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0.0, $30 = 0;
  $24 = __stack_pointer - 16 | 0;
  __stack_pointer = $24;
  $23 = __stack_pointer - 160 | 0;
  __stack_pointer = $23;
  $1 = $23 + 16 | 0;
  memset($1, 144);
  HEAP32[$23 + 92 >> 2] = -1;
  HEAP32[$23 + 60 >> 2] = $0;
  HEAP32[$23 + 24 >> 2] = -1;
  HEAP32[$23 + 20 >> 2] = $0;
  __shlim($1);
  $28 = $23;
  $19 = __stack_pointer - 48 | 0;
  __stack_pointer = $19;
  $0 = $1;
  $4 = $0 + 4 | 0;
  $20 = HEAP32[1992];
  $16 = HEAP32[1989];
  while (1) {
   $1 = HEAP32[$0 + 4 >> 2];
   label$4 : {
    if ($1 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
     HEAP32[$4 >> 2] = $1 + 1;
     $1 = HEAPU8[$1 | 0];
     break label$4;
    }
    $1 = __shgetc($0);
   }
   if (($1 | 0) == 32 | $1 - 9 >>> 0 < 5) {
    continue
   }
   break;
  };
  $3 = 1;
  label$6 : {
   label$7 : {
    switch ($1 - 43 | 0) {
    case 0:
    case 2:
     break label$7;
    default:
     break label$6;
    };
   }
   $3 = ($1 | 0) == 45 ? -1 : 1;
   $1 = HEAP32[$0 + 4 >> 2];
   if ($1 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
    HEAP32[$4 >> 2] = $1 + 1;
    $1 = HEAPU8[$1 | 0];
    break label$6;
   }
   $1 = __shgetc($0);
  }
  label$1 : {
   label$9 : {
    label$10 : {
     while (1) {
      if (HEAP8[$6 + 5376 | 0] == ($1 | 32)) {
       label$13 : {
        if ($6 >>> 0 > 6) {
         break label$13
        }
        $1 = HEAP32[$0 + 4 >> 2];
        if ($1 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
         HEAP32[$4 >> 2] = $1 + 1;
         $1 = HEAPU8[$1 | 0];
         break label$13;
        }
        $1 = __shgetc($0);
       }
       $6 = $6 + 1 | 0;
       if (($6 | 0) != 8) {
        continue
       }
       break label$10;
      }
      break;
     };
     if (($6 | 0) != 3) {
      if (($6 | 0) == 8) {
       break label$10
      }
      if ($6 >>> 0 < 4) {
       break label$9
      }
      if (($6 | 0) == 8) {
       break label$10
      }
     }
     $0 = HEAP32[$0 + 104 >> 2];
     if ($0) {
      HEAP32[$4 >> 2] = HEAP32[$4 >> 2] - 1
     }
     if ($6 >>> 0 < 4) {
      break label$10
     }
     while (1) {
      if ($0) {
       HEAP32[$4 >> 2] = HEAP32[$4 >> 2] - 1
      }
      $6 = $6 - 1 | 0;
      if ($6 >>> 0 > 3) {
       continue
      }
      break;
     };
    }
    $6 = __stack_pointer - 16 | 0;
    __stack_pointer = $6;
    $0 = $19;
    $10 = $0;
    $3 = (wasm2js_scratch_store_f32(Math_fround(Math_fround($3 | 0) * Math_fround(infinity))), wasm2js_scratch_load_i32(2));
    $1 = $3 & 2147483647;
    label$11 : {
     if ($1 - 8388608 >>> 0 <= 2130706431) {
      $8 = $1 << 25;
      $1 = ($1 >>> 7 | 0) + 1065353216 | 0;
      $4 = 0;
      break label$11;
     }
     if ($1 >>> 0 >= 2139095040) {
      $8 = $3 << 25;
      $1 = $3 >>> 7 | 2147418112;
      $4 = 0;
      break label$11;
     }
     if (!$1) {
      $1 = 0;
      $4 = 0;
      break label$11;
     }
     $5 = $1;
     $1 = Math_clz32($1);
     __ashlti3($6, $5, 0, 0, 0, $1 + 81 | 0);
     $5 = $6 + 8 | 0;
     $8 = HEAP32[$5 >> 2];
     $1 = HEAP32[$5 + 4 >> 2] ^ 65536 | 16265 - $1 << 16;
     $5 = HEAP32[$6 + 4 >> 2];
     $4 = HEAP32[$6 >> 2];
    }
    HEAP32[$10 >> 2] = $4;
    HEAP32[$0 + 4 >> 2] = $5;
    HEAP32[$0 + 8 >> 2] = $8;
    HEAP32[$0 + 12 >> 2] = $3 & -2147483648 | $1;
    __stack_pointer = $6 + 16 | 0;
    $0 = $19 + 8 | 0;
    $3 = HEAP32[$0 >> 2];
    $1 = HEAP32[$0 + 4 >> 2];
    $15 = HEAP32[$19 >> 2];
    $5 = HEAP32[$19 + 4 >> 2];
    break label$1;
   }
   label$19 : {
    label$20 : {
     label$21 : {
      if ($6) {
       break label$21
      }
      $6 = 0;
      while (1) {
       if (HEAP8[$6 + 5826 | 0] != ($1 | 32)) {
        break label$21
       }
       label$23 : {
        if ($6 >>> 0 > 1) {
         break label$23
        }
        $1 = HEAP32[$0 + 4 >> 2];
        if ($1 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
         HEAP32[$4 >> 2] = $1 + 1;
         $1 = HEAPU8[$1 | 0];
         break label$23;
        }
        $1 = __shgetc($0);
       }
       $6 = $6 + 1 | 0;
       if (($6 | 0) != 3) {
        continue
       }
       break;
      };
      break label$20;
     }
     label$25 : {
      switch ($6 | 0) {
      case 0:
       label$27 : {
        if (($1 | 0) != 48) {
         break label$27
        }
        $5 = HEAP32[$0 + 4 >> 2];
        label$28 : {
         if ($5 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
          HEAP32[$4 >> 2] = $5 + 1;
          $5 = HEAPU8[$5 | 0];
          break label$28;
         }
         $5 = __shgetc($0);
        }
        if (($5 & -33) == 88) {
         $26 = $19 + 16 | 0;
         $1 = 0;
         $6 = 0;
         $5 = 0;
         $2 = __stack_pointer - 432 | 0;
         __stack_pointer = $2;
         $9 = $0;
         $4 = HEAP32[$0 + 4 >> 2];
         label$14 : {
          if ($4 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
           HEAP32[$9 + 4 >> 2] = $4 + 1;
           $10 = HEAPU8[$4 | 0];
           break label$14;
          }
          $10 = __shgetc($9);
         }
         label$35 : {
          label$46 : {
           while (1) {
            if (($10 | 0) != 48) {
             label$5 : {
              if (($10 | 0) != 46) {
               break label$35
              }
              $0 = HEAP32[$9 + 4 >> 2];
              if ($0 >>> 0 >= HEAPU32[$9 + 104 >> 2]) {
               break label$5
              }
              HEAP32[$9 + 4 >> 2] = $0 + 1;
              $10 = HEAPU8[$0 | 0];
              break label$46;
             }
            } else {
             $0 = HEAP32[$9 + 4 >> 2];
             if ($0 >>> 0 < HEAPU32[$9 + 104 >> 2]) {
              HEAP32[$9 + 4 >> 2] = $0 + 1;
              $10 = HEAPU8[$0 | 0];
             } else {
              $10 = __shgetc($9)
             }
             $7 = 1;
             continue;
            }
            break;
           };
           $10 = __shgetc($9);
          }
          $25 = 1;
          if (($10 | 0) != 48) {
           break label$35
          }
          while (1) {
           $0 = $5 - 1 | 0;
           $15 = $15 - 1 | 0;
           $5 = ($15 | 0) != -1 ? $0 + 1 | 0 : $0;
           $0 = HEAP32[$9 + 4 >> 2];
           label$109 : {
            if ($0 >>> 0 < HEAPU32[$9 + 104 >> 2]) {
             HEAP32[$9 + 4 >> 2] = $0 + 1;
             $10 = HEAPU8[$0 | 0];
             break label$109;
            }
            $10 = __shgetc($9);
           }
           if (($10 | 0) == 48) {
            continue
           }
           break;
          };
          $7 = 1;
         }
         $4 = 1073676288;
         $0 = 0;
         label$1210 : {
          while (1) {
           label$1312 : {
            $11 = $10 | 32;
            label$15 : {
             label$16 : {
              $27 = $10 - 48 | 0;
              if ($27 >>> 0 < 10) {
               break label$16
              }
              if (($10 | 0) != 46 & $11 - 97 >>> 0 >= 6) {
               break label$1210
              }
              if (($10 | 0) != 46) {
               break label$16
              }
              if ($25) {
               break label$1312
              }
              $25 = 1;
              $15 = $1;
              $5 = $0;
              break label$15;
             }
             $7 = ($10 | 0) > 57 ? $11 - 87 | 0 : $27;
             label$18 : {
              if (!($1 >>> 0 > 7 & ($0 | 0) >= 0 | ($0 | 0) > 0)) {
               $17 = $7 + ($17 << 4) | 0;
               break label$18;
              }
              if (!($1 >>> 0 > 28 & ($0 | 0) >= 0 | ($0 | 0) > 0)) {
               $11 = $2 + 48 | 0;
               __floatsitf($11, $7);
               $7 = $2 + 32 | 0;
               __multf3($7, $21, $22, $6, $4, 0, 0, 0, 1073414144);
               $10 = $2 + 16 | 0;
               $21 = HEAP32[$2 + 32 >> 2];
               $22 = HEAP32[$2 + 36 >> 2];
               $4 = $7 + 8 | 0;
               $6 = HEAP32[$4 >> 2];
               $4 = HEAP32[$4 + 4 >> 2];
               $7 = $11 + 8 | 0;
               __multf3($10, $21, $22, $6, $4, HEAP32[$2 + 48 >> 2], HEAP32[$2 + 52 >> 2], HEAP32[$7 >> 2], HEAP32[$7 + 4 >> 2]);
               $7 = $10 + 8 | 0;
               __addtf3($2, $13, $14, $12, $18, HEAP32[$2 + 16 >> 2], HEAP32[$2 + 20 >> 2], HEAP32[$7 >> 2], HEAP32[$7 + 4 >> 2]);
               $7 = $2 + 8 | 0;
               $12 = HEAP32[$7 >> 2];
               $18 = HEAP32[$7 + 4 >> 2];
               $13 = HEAP32[$2 >> 2];
               $14 = HEAP32[$2 + 4 >> 2];
               break label$18;
              }
              if ($8 | !$7) {
               break label$18
              }
              $8 = $2 + 80 | 0;
              __multf3($8, $21, $22, $6, $4, 0, 0, 0, 1073610752);
              $7 = $2 - -64 | 0;
              $8 = $8 + 8 | 0;
              __addtf3($7, $13, $14, $12, $18, HEAP32[$2 + 80 >> 2], HEAP32[$2 + 84 >> 2], HEAP32[$8 >> 2], HEAP32[$8 + 4 >> 2]);
              $8 = $7 + 8 | 0;
              $12 = HEAP32[$8 >> 2];
              $18 = HEAP32[$8 + 4 >> 2];
              $8 = 1;
              $13 = HEAP32[$2 + 64 >> 2];
              $14 = HEAP32[$2 + 68 >> 2];
             }
             $1 = $1 + 1 | 0;
             $0 = $1 >>> 0 < 1 ? $0 + 1 | 0 : $0;
             $7 = 1;
            }
            $11 = HEAP32[$9 + 4 >> 2];
            if ($11 >>> 0 < HEAPU32[$9 + 104 >> 2]) {
             HEAP32[$9 + 4 >> 2] = $11 + 1;
             $10 = HEAPU8[$11 | 0];
            } else {
             $10 = __shgetc($9)
            }
            continue;
           }
           break;
          };
          $10 = 46;
         }
         label$2213 : {
          label$2314 : {
           if (!$7) {
            if (!HEAP32[$9 + 104 >> 2]) {
             break label$2314
            }
            $0 = HEAP32[$9 + 4 >> 2];
            HEAP32[$9 + 4 >> 2] = $0 - 1;
            HEAP32[$9 + 4 >> 2] = $0 - 2;
            if (!$25) {
             break label$2314
            }
            HEAP32[$9 + 4 >> 2] = $0 - 3;
            break label$2314;
           }
           if (!($1 >>> 0 > 7 & ($0 | 0) >= 0 | ($0 | 0) > 0)) {
            $6 = $1;
            $4 = $0;
            while (1) {
             $17 = $17 << 4;
             $6 = $6 + 1 | 0;
             $4 = $6 >>> 0 < 1 ? $4 + 1 | 0 : $4;
             if ($4 | ($6 | 0) != 8) {
              continue
             }
             break;
            };
           }
           label$29 : {
            label$30 : {
             label$31 : {
              if (($10 & -33) == 80) {
               $6 = scanexp($9);
               $8 = i64toi32_i32$HIGH_BITS;
               $4 = $8;
               if ($6 | ($4 | 0) != -2147483648) {
                break label$29
               }
               if (HEAP32[$9 + 104 >> 2]) {
                break label$31
               }
               break label$30;
              }
              if (!HEAP32[$9 + 104 >> 2]) {
               break label$30
              }
             }
             HEAP32[$9 + 4 >> 2] = HEAP32[$9 + 4 >> 2] - 1;
            }
            $6 = 0;
            $4 = 0;
           }
           if (!$17) {
            __extenddftf2($2 + 112 | 0, +($3 | 0) * 0.0);
            $0 = $2 + 120 | 0;
            $1 = HEAP32[$0 >> 2];
            $13 = HEAP32[$2 + 112 >> 2];
            $14 = HEAP32[$2 + 116 >> 2];
            $0 = HEAP32[$0 + 4 >> 2];
            break label$2213;
           }
           $5 = ($25 ? $5 : $0) << 2;
           $0 = $25 ? $15 : $1;
           $5 = $5 | $0 >>> 30;
           $0 = $6 + ($0 << 2) | 0;
           $1 = $0 - 32 | 0;
           $5 = $4 + $5 | 0;
           $0 = ($0 >>> 0 < $6 >>> 0 ? $5 + 1 | 0 : $5) - 1 | 0;
           $0 = $1 >>> 0 < 4294967264 ? $0 + 1 | 0 : $0;
           if (!(($0 | 0) <= 0 & 0 - $20 >>> 0 >= $1 >>> 0 | ($0 | 0) < 0)) {
            HEAP32[2892] = 68;
            $0 = $2 + 160 | 0;
            __floatsitf($0, $3);
            $1 = $2 + 144 | 0;
            $0 = $0 + 8 | 0;
            __multf3($1, HEAP32[$2 + 160 >> 2], HEAP32[$2 + 164 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2], -1, -1, -1, 2147418111);
            $0 = $2 + 128 | 0;
            $1 = $1 + 8 | 0;
            __multf3($0, HEAP32[$2 + 144 >> 2], HEAP32[$2 + 148 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2], -1, -1, -1, 2147418111);
            $0 = $0 + 8 | 0;
            $1 = HEAP32[$0 >> 2];
            $13 = HEAP32[$2 + 128 >> 2];
            $14 = HEAP32[$2 + 132 >> 2];
            $0 = HEAP32[$0 + 4 >> 2];
            break label$2213;
           }
           $5 = $20 - 226 | 0;
           $10 = $5 >>> 0 > $1 >>> 0;
           $5 = $5 >> 31;
           if (!($10 & ($5 | 0) >= ($0 | 0) | ($0 | 0) < ($5 | 0))) {
            if (($17 | 0) > -1) {
             while (1) {
              $4 = $2 + 416 | 0;
              __addtf3($4, $13, $14, $12, $18, 0, 0, 0, -1073807360);
              $5 = __getf2($13, $14, $12, $18, 1073610752);
              $6 = ($5 | 0) < 0;
              $4 = $4 + 8 | 0;
              __addtf3($2 + 400 | 0, $13, $14, $12, $18, $6 ? $13 : HEAP32[$2 + 416 >> 2], $6 ? $14 : HEAP32[$2 + 420 >> 2], $6 ? $12 : HEAP32[$4 >> 2], $6 ? $18 : HEAP32[$4 + 4 >> 2]);
              $0 = $0 - 1 | 0;
              $1 = $1 - 1 | 0;
              $0 = ($1 | 0) != -1 ? $0 + 1 | 0 : $0;
              $6 = $2 + 408 | 0;
              $12 = HEAP32[$6 >> 2];
              $18 = HEAP32[$6 + 4 >> 2];
              $13 = HEAP32[$2 + 400 >> 2];
              $14 = HEAP32[$2 + 404 >> 2];
              $17 = $17 << 1 | ($5 | 0) > -1;
              if (($17 | 0) > -1) {
               continue
              }
              break;
             }
            }
            $5 = ($1 - $20 | 0) + 32 | 0;
            $6 = $5;
            $4 = $6;
            $0 = $0 - (($20 >> 31) + ($1 >>> 0 < $20 >>> 0) | 0) | 0;
            $0 = $4 >>> 0 < 32 ? $0 + 1 | 0 : $0;
            $0 = $4 >>> 0 < $16 >>> 0 & ($0 | 0) <= 0 | ($0 | 0) < 0 ? (($4 | 0) > 0 ? $4 : 0) : $16;
            label$39 : {
             if (($0 | 0) >= 113) {
              __floatsitf($2 + 384 | 0, $3);
              $3 = $2 + 392 | 0;
              $15 = HEAP32[$3 >> 2];
              $5 = HEAP32[$3 + 4 >> 2];
              $6 = 0;
              $4 = 0;
              $21 = HEAP32[$2 + 384 >> 2];
              $22 = HEAP32[$2 + 388 >> 2];
              $11 = 0;
              $3 = 0;
              break label$39;
             }
             $5 = $2 + 352 | 0;
             __extenddftf2($5, scalbn(1.0, 144 - $0 | 0));
             $6 = $2 + 336 | 0;
             __floatsitf($6, $3);
             $3 = $2 + 368 | 0;
             $5 = $5 + 8 | 0;
             $4 = HEAP32[$5 >> 2];
             $10 = HEAP32[$5 + 4 >> 2];
             $21 = HEAP32[$2 + 336 >> 2];
             $22 = HEAP32[$2 + 340 >> 2];
             $5 = $6 + 8 | 0;
             $15 = HEAP32[$5 >> 2];
             $5 = HEAP32[$5 + 4 >> 2];
             copysignl($3, HEAP32[$2 + 352 >> 2], HEAP32[$2 + 356 >> 2], $4, $10, $21, $22, $15, $5);
             $3 = $3 + 8 | 0;
             $11 = HEAP32[$3 >> 2];
             $6 = HEAP32[$2 + 368 >> 2];
             $4 = HEAP32[$2 + 372 >> 2];
             $3 = HEAP32[$3 + 4 >> 2];
            }
            $8 = $2 + 320 | 0;
            $0 = !($17 & 1) & ((__letf2($13, $14, $12, $18, 0, 0, 0, 0) | 0) != 0 & ($0 | 0) < 32);
            __floatunsitf($8, $0 + $17 | 0);
            $7 = $2 + 304 | 0;
            $8 = $8 + 8 | 0;
            __multf3($7, $21, $22, $15, $5, HEAP32[$2 + 320 >> 2], HEAP32[$2 + 324 >> 2], HEAP32[$8 >> 2], HEAP32[$8 + 4 >> 2]);
            $8 = $2 + 272 | 0;
            $7 = $7 + 8 | 0;
            __addtf3($8, HEAP32[$2 + 304 >> 2], HEAP32[$2 + 308 >> 2], HEAP32[$7 >> 2], HEAP32[$7 + 4 >> 2], $6, $4, $11, $3);
            $7 = $2 + 288 | 0;
            __multf3($7, $0 ? 0 : $13, $0 ? 0 : $14, $0 ? 0 : $12, $0 ? 0 : $18, $21, $22, $15, $5);
            $0 = $2 + 256 | 0;
            $5 = $7 + 8 | 0;
            $15 = HEAP32[$5 >> 2];
            $10 = HEAP32[$5 + 4 >> 2];
            $5 = $8 + 8 | 0;
            __addtf3($0, HEAP32[$2 + 288 >> 2], HEAP32[$2 + 292 >> 2], $15, $10, HEAP32[$2 + 272 >> 2], HEAP32[$2 + 276 >> 2], HEAP32[$5 >> 2], HEAP32[$5 + 4 >> 2]);
            $5 = $2 + 240 | 0;
            $0 = $0 + 8 | 0;
            __subtf3($5, HEAP32[$2 + 256 >> 2], HEAP32[$2 + 260 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2], $6, $4, $11, $3);
            $0 = HEAP32[$2 + 240 >> 2];
            $3 = HEAP32[$2 + 244 >> 2];
            $5 = $5 + 8 | 0;
            $6 = HEAP32[$5 >> 2];
            $5 = HEAP32[$5 + 4 >> 2];
            if (!__letf2($0, $3, $6, $5, 0, 0, 0, 0)) {
             HEAP32[2892] = 68
            }
            $4 = $2 + 224 | 0;
            scalbnl($4, $0, $3, $6, $5, $1);
            $0 = $4 + 8 | 0;
            $1 = HEAP32[$0 >> 2];
            $13 = HEAP32[$2 + 224 >> 2];
            $14 = HEAP32[$2 + 228 >> 2];
            $0 = HEAP32[$0 + 4 >> 2];
            break label$2213;
           }
           HEAP32[2892] = 68;
           $0 = $2 + 208 | 0;
           __floatsitf($0, $3);
           $1 = $2 + 192 | 0;
           $0 = $0 + 8 | 0;
           __multf3($1, HEAP32[$2 + 208 >> 2], HEAP32[$2 + 212 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2], 0, 0, 0, 65536);
           $0 = $2 + 176 | 0;
           $1 = $1 + 8 | 0;
           __multf3($0, HEAP32[$2 + 192 >> 2], HEAP32[$2 + 196 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2], 0, 0, 0, 65536);
           $0 = $0 + 8 | 0;
           $1 = HEAP32[$0 >> 2];
           $13 = HEAP32[$2 + 176 >> 2];
           $14 = HEAP32[$2 + 180 >> 2];
           $0 = HEAP32[$0 + 4 >> 2];
           break label$2213;
          }
          __extenddftf2($2 + 96 | 0, +($3 | 0) * 0.0);
          $0 = $2 + 104 | 0;
          $1 = HEAP32[$0 >> 2];
          $13 = HEAP32[$2 + 96 >> 2];
          $14 = HEAP32[$2 + 100 >> 2];
          $0 = HEAP32[$0 + 4 >> 2];
         }
         HEAP32[$26 >> 2] = $13;
         HEAP32[$26 + 4 >> 2] = $14;
         HEAP32[$26 + 8 >> 2] = $1;
         HEAP32[$26 + 12 >> 2] = $0;
         __stack_pointer = $2 + 432 | 0;
         $0 = $19 + 24 | 0;
         $3 = HEAP32[$0 >> 2];
         $1 = HEAP32[$0 + 4 >> 2];
         $15 = HEAP32[$19 + 16 >> 2];
         $5 = HEAP32[$19 + 20 >> 2];
         break label$1;
        }
        if (!HEAP32[$0 + 104 >> 2]) {
         break label$27
        }
        HEAP32[$4 >> 2] = HEAP32[$4 >> 2] - 1;
       }
       $18 = $19 + 32 | 0;
       $4 = $0;
       $15 = $3;
       $3 = 0;
       $5 = 0;
       $6 = 0;
       $2 = __stack_pointer - 8976 | 0;
       __stack_pointer = $2;
       $25 = $16 + $20 | 0;
       $26 = 0 - $25 | 0;
       label$116 : {
        label$2 : {
         while (1) {
          if (($1 | 0) != 48) {
           label$318 : {
            if (($1 | 0) != 46) {
             break label$116
            }
            $0 = HEAP32[$4 + 4 >> 2];
            if ($0 >>> 0 >= HEAPU32[$4 + 104 >> 2]) {
             break label$318
            }
            HEAP32[$4 + 4 >> 2] = $0 + 1;
            $1 = HEAPU8[$0 | 0];
            break label$2;
           }
          } else {
           $0 = HEAP32[$4 + 4 >> 2];
           if ($0 >>> 0 < HEAPU32[$4 + 104 >> 2]) {
            $5 = 1;
            HEAP32[$4 + 4 >> 2] = $0 + 1;
            $1 = HEAPU8[$0 | 0];
           } else {
            $5 = 1;
            $1 = __shgetc($4);
           }
           continue;
          }
          break;
         };
         $1 = __shgetc($4);
        }
        $11 = 1;
        if (($1 | 0) != 48) {
         break label$116
        }
        while (1) {
         $0 = $8 - 1 | 0;
         $3 = $3 - 1 | 0;
         $8 = ($3 | 0) != -1 ? $0 + 1 | 0 : $0;
         $0 = HEAP32[$4 + 4 >> 2];
         label$8 : {
          if ($0 >>> 0 < HEAPU32[$4 + 104 >> 2]) {
           HEAP32[$4 + 4 >> 2] = $0 + 1;
           $1 = HEAPU8[$0 | 0];
           break label$8;
          }
          $1 = __shgetc($4);
         }
         if (($1 | 0) == 48) {
          continue
         }
         break;
        };
        $5 = 1;
       }
       HEAP32[$2 + 784 >> 2] = 0;
       label$1020 : {
        label$1121 : {
         $0 = ($1 | 0) == 46;
         $12 = $1 - 48 | 0;
         label$1322 : {
          label$1423 : {
           label$1524 : {
            if (!(!$0 & $12 >>> 0 > 9)) {
             while (1) {
              label$2026 : {
               if ($0 & 1) {
                if (!$11) {
                 $3 = $9;
                 $8 = $7;
                 $11 = 1;
                 break label$2026;
                }
                $0 = !$5;
                break label$1524;
               }
               $9 = $9 + 1 | 0;
               $7 = $9 >>> 0 < 1 ? $7 + 1 | 0 : $7;
               if (($6 | 0) <= 2044) {
                $10 = ($1 | 0) == 48 ? $10 : $9;
                $0 = ($2 + 784 | 0) + ($6 << 2) | 0;
                HEAP32[$0 >> 2] = $13 ? (Math_imul(HEAP32[$0 >> 2], 10) + $1 | 0) - 48 | 0 : $12;
                $5 = 1;
                $1 = $13 + 1 | 0;
                $0 = ($1 | 0) == 9;
                $13 = $0 ? 0 : $1;
                $6 = $0 + $6 | 0;
                break label$2026;
               }
               if (($1 | 0) == 48) {
                break label$2026
               }
               HEAP32[$2 + 8960 >> 2] = HEAP32[$2 + 8960 >> 2] | 1;
               $10 = 18396;
              }
              $0 = HEAP32[$4 + 4 >> 2];
              label$2527 : {
               if ($0 >>> 0 < HEAPU32[$4 + 104 >> 2]) {
                HEAP32[$4 + 4 >> 2] = $0 + 1;
                $1 = HEAPU8[$0 | 0];
                break label$2527;
               }
               $1 = __shgetc($4);
              }
              $0 = ($1 | 0) == 46;
              $12 = $1 - 48 | 0;
              if ($0 | $12 >>> 0 < 10) {
               continue
              }
              break;
             }
            }
            $3 = $11 ? $3 : $9;
            $8 = $11 ? $8 : $7;
            if (!(!$5 | ($1 & -33) != 69)) {
             $0 = scanexp($4);
             $1 = i64toi32_i32$HIGH_BITS;
             $12 = $1;
             label$2828 : {
              if ($0 | ($1 | 0) != -2147483648) {
               break label$2828
              }
              $0 = 0;
              $12 = 0;
              if (!HEAP32[$4 + 104 >> 2]) {
               break label$2828
              }
              HEAP32[$4 + 4 >> 2] = HEAP32[$4 + 4 >> 2] - 1;
             }
             if (!$5) {
              break label$1322
             }
             $1 = $8 + $12 | 0;
             $5 = $3;
             $3 = $0 + $3 | 0;
             $8 = $5 >>> 0 > $3 >>> 0 ? $1 + 1 | 0 : $1;
             break label$1121;
            }
            $0 = !$5;
            if (($1 | 0) < 0) {
             break label$1423
            }
           }
           if (!HEAP32[$4 + 104 >> 2]) {
            break label$1423
           }
           HEAP32[$4 + 4 >> 2] = HEAP32[$4 + 4 >> 2] - 1;
          }
          if (!$0) {
           break label$1121
          }
         }
         HEAP32[2892] = 28;
         $9 = 0;
         $7 = 0;
         __shlim($4);
         $3 = 0;
         $0 = 0;
         break label$1020;
        }
        $0 = HEAP32[$2 + 784 >> 2];
        if (!$0) {
         __extenddftf2($2, +($15 | 0) * 0.0);
         $0 = $2 + 8 | 0;
         $3 = HEAP32[$0 >> 2];
         $9 = HEAP32[$2 >> 2];
         $7 = HEAP32[$2 + 4 >> 2];
         $0 = HEAP32[$0 + 4 >> 2];
         break label$1020;
        }
        if (!($9 >>> 0 > 9 & ($7 | 0) >= 0 | ($7 | 0) > 0 | (($3 | 0) != ($9 | 0) | ($8 | 0) != ($7 | 0)) | ($0 >>> $16 | 0 ? ($16 | 0) <= 30 : 0))) {
         $1 = $2 + 48 | 0;
         __floatsitf($1, $15);
         $3 = $2 + 32 | 0;
         __floatunsitf($3, $0);
         $0 = $2 + 16 | 0;
         $1 = $1 + 8 | 0;
         $10 = HEAP32[$1 >> 2];
         $5 = HEAP32[$1 + 4 >> 2];
         $1 = $3 + 8 | 0;
         __multf3($0, HEAP32[$2 + 48 >> 2], HEAP32[$2 + 52 >> 2], $10, $5, HEAP32[$2 + 32 >> 2], HEAP32[$2 + 36 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2]);
         $0 = $0 + 8 | 0;
         $3 = HEAP32[$0 >> 2];
         $9 = HEAP32[$2 + 16 >> 2];
         $7 = HEAP32[$2 + 20 >> 2];
         $0 = HEAP32[$0 + 4 >> 2];
         break label$1020;
        }
        if (!(($8 | 0) <= 0 & ($20 | 0) / -2 >>> 0 >= $3 >>> 0 | ($8 | 0) < 0)) {
         HEAP32[2892] = 68;
         $0 = $2 + 96 | 0;
         __floatsitf($0, $15);
         $1 = $2 + 80 | 0;
         $0 = $0 + 8 | 0;
         __multf3($1, HEAP32[$2 + 96 >> 2], HEAP32[$2 + 100 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2], -1, -1, -1, 2147418111);
         $0 = $2 - -64 | 0;
         $1 = $1 + 8 | 0;
         __multf3($0, HEAP32[$2 + 80 >> 2], HEAP32[$2 + 84 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2], -1, -1, -1, 2147418111);
         $0 = $0 + 8 | 0;
         $3 = HEAP32[$0 >> 2];
         $9 = HEAP32[$2 + 64 >> 2];
         $7 = HEAP32[$2 + 68 >> 2];
         $0 = HEAP32[$0 + 4 >> 2];
         break label$1020;
        }
        $0 = $20 - 226 | 0;
        $1 = $0;
        $0 = $0 >> 31;
        if (!(($0 | 0) <= ($8 | 0) & $1 >>> 0 <= $3 >>> 0 | ($0 | 0) < ($8 | 0))) {
         HEAP32[2892] = 68;
         $0 = $2 + 144 | 0;
         __floatsitf($0, $15);
         $1 = $2 + 128 | 0;
         $0 = $0 + 8 | 0;
         __multf3($1, HEAP32[$2 + 144 >> 2], HEAP32[$2 + 148 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2], 0, 0, 0, 65536);
         $0 = $2 + 112 | 0;
         $1 = $1 + 8 | 0;
         __multf3($0, HEAP32[$2 + 128 >> 2], HEAP32[$2 + 132 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2], 0, 0, 0, 65536);
         $0 = $0 + 8 | 0;
         $3 = HEAP32[$0 >> 2];
         $9 = HEAP32[$2 + 112 >> 2];
         $7 = HEAP32[$2 + 116 >> 2];
         $0 = HEAP32[$0 + 4 >> 2];
         break label$1020;
        }
        if ($13) {
         if (($13 | 0) <= 8) {
          $0 = ($2 + 784 | 0) + ($6 << 2) | 0;
          $4 = HEAP32[$0 >> 2];
          while (1) {
           $4 = Math_imul($4, 10);
           $13 = $13 + 1 | 0;
           if (($13 | 0) != 9) {
            continue
           }
           break;
          };
          HEAP32[$0 >> 2] = $4;
         }
         $6 = $6 + 1 | 0;
        }
        label$37 : {
         $11 = $3;
         if (($10 | 0) > ($3 | 0) | ($10 | 0) >= 9 | ($3 | 0) > 17) {
          break label$37
         }
         if (($11 | 0) == 9) {
          $0 = $2 + 192 | 0;
          __floatsitf($0, $15);
          $1 = $2 + 176 | 0;
          __floatunsitf($1, HEAP32[$2 + 784 >> 2]);
          $3 = $2 + 160 | 0;
          $0 = $0 + 8 | 0;
          $10 = HEAP32[$0 >> 2];
          $5 = HEAP32[$0 + 4 >> 2];
          $0 = $1 + 8 | 0;
          __multf3($3, HEAP32[$2 + 192 >> 2], HEAP32[$2 + 196 >> 2], $10, $5, HEAP32[$2 + 176 >> 2], HEAP32[$2 + 180 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2]);
          $0 = $3 + 8 | 0;
          $3 = HEAP32[$0 >> 2];
          $9 = HEAP32[$2 + 160 >> 2];
          $7 = HEAP32[$2 + 164 >> 2];
          $0 = HEAP32[$0 + 4 >> 2];
          break label$1020;
         }
         if (($11 | 0) <= 8) {
          $0 = $2 + 272 | 0;
          __floatsitf($0, $15);
          $1 = $2 + 256 | 0;
          __floatunsitf($1, HEAP32[$2 + 784 >> 2]);
          $3 = $2 + 240 | 0;
          $0 = $0 + 8 | 0;
          $10 = HEAP32[$0 >> 2];
          $5 = HEAP32[$0 + 4 >> 2];
          $0 = $1 + 8 | 0;
          __multf3($3, HEAP32[$2 + 272 >> 2], HEAP32[$2 + 276 >> 2], $10, $5, HEAP32[$2 + 256 >> 2], HEAP32[$2 + 260 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2]);
          $0 = $2 + 224 | 0;
          __floatsitf($0, HEAP32[(0 - $11 << 2) + 7952 >> 2]);
          $1 = $2 + 208 | 0;
          $3 = $3 + 8 | 0;
          $0 = $0 + 8 | 0;
          __divtf3($1, HEAP32[$2 + 240 >> 2], HEAP32[$2 + 244 >> 2], HEAP32[$3 >> 2], HEAP32[$3 + 4 >> 2], HEAP32[$2 + 224 >> 2], HEAP32[$2 + 228 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2]);
          $0 = $1 + 8 | 0;
          $3 = HEAP32[$0 >> 2];
          $9 = HEAP32[$2 + 208 >> 2];
          $7 = HEAP32[$2 + 212 >> 2];
          $0 = HEAP32[$0 + 4 >> 2];
          break label$1020;
         }
         $0 = (Math_imul($11, -3) + $16 | 0) + 27 | 0;
         $1 = HEAP32[$2 + 784 >> 2];
         if ($1 >>> $0 | 0 ? ($0 | 0) <= 30 : 0) {
          break label$37
         }
         $0 = $2 + 352 | 0;
         __floatsitf($0, $15);
         $3 = $2 + 336 | 0;
         __floatunsitf($3, $1);
         $1 = $2 + 320 | 0;
         $0 = $0 + 8 | 0;
         $10 = HEAP32[$0 >> 2];
         $5 = HEAP32[$0 + 4 >> 2];
         $0 = $3 + 8 | 0;
         __multf3($1, HEAP32[$2 + 352 >> 2], HEAP32[$2 + 356 >> 2], $10, $5, HEAP32[$2 + 336 >> 2], HEAP32[$2 + 340 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2]);
         $0 = $2 + 304 | 0;
         __floatsitf($0, HEAP32[($11 << 2) + 7880 >> 2]);
         $3 = $2 + 288 | 0;
         $1 = $1 + 8 | 0;
         $0 = $0 + 8 | 0;
         __multf3($3, HEAP32[$2 + 320 >> 2], HEAP32[$2 + 324 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2], HEAP32[$2 + 304 >> 2], HEAP32[$2 + 308 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2]);
         $0 = $3 + 8 | 0;
         $3 = HEAP32[$0 >> 2];
         $9 = HEAP32[$2 + 288 >> 2];
         $7 = HEAP32[$2 + 292 >> 2];
         $0 = HEAP32[$0 + 4 >> 2];
         break label$1020;
        }
        while (1) {
         $1 = $6;
         $6 = $1 - 1 | 0;
         if (!HEAP32[($2 + 784 | 0) + ($6 << 2) >> 2]) {
          continue
         }
         break;
        };
        $13 = 0;
        $0 = ($11 | 0) % 9 | 0;
        label$42 : {
         if (!$0) {
          $0 = 0;
          break label$42;
         }
         $3 = ($11 | 0) > -1 ? $0 : $0 + 9 | 0;
         label$44 : {
          if (!$1) {
           $0 = 0;
           $1 = 0;
           break label$44;
          }
          $5 = HEAP32[(0 - $3 << 2) + 7952 >> 2];
          $8 = 1e9 / ($5 | 0) | 0;
          $12 = 0;
          $4 = 0;
          $0 = 0;
          while (1) {
           $7 = ($2 + 784 | 0) + ($4 << 2) | 0;
           $9 = HEAP32[$7 >> 2];
           $10 = ($9 >>> 0) / ($5 >>> 0) | 0;
           $6 = $12 + $10 | 0;
           HEAP32[$7 >> 2] = $6;
           $6 = !$6 & ($0 | 0) == ($4 | 0);
           $0 = $6 ? $0 + 1 & 2047 : $0;
           $11 = $6 ? $11 - 9 | 0 : $11;
           $12 = Math_imul($8, $9 - Math_imul($5, $10) | 0);
           $4 = $4 + 1 | 0;
           if (($1 | 0) != ($4 | 0)) {
            continue
           }
           break;
          };
          if (!$12) {
           break label$44
          }
          HEAP32[($2 + 784 | 0) + ($1 << 2) >> 2] = $12;
          $1 = $1 + 1 | 0;
         }
         $11 = ($11 - $3 | 0) + 9 | 0;
        }
        while (1) {
         $4 = ($2 + 784 | 0) + ($0 << 2) | 0;
         label$48 : {
          while (1) {
           if ((($11 | 0) != 36 | HEAPU32[$4 >> 2] >= 10384593) & ($11 | 0) >= 36) {
            break label$48
           }
           $5 = $1 + 2047 | 0;
           $12 = 0;
           while (1) {
            $6 = $5 & 2047;
            $7 = ($2 + 784 | 0) + ($6 << 2) | 0;
            $3 = HEAP32[$7 >> 2];
            $8 = $3 >>> 3 | 0;
            $5 = $12 + ($3 << 29) | 0;
            if ($5 >>> 0 < $12 >>> 0) {
             $8 = $8 + 1 | 0
            }
            $3 = $5;
            label$52 : {
             if (!(!$8 & $3 >>> 0 >= 1000000001 | ($8 | 0) != 0)) {
              $12 = 0;
              break label$52;
             }
             $12 = __wasm_i64_udiv($5, $8, 1e9);
             $3 = $3 - __wasm_i64_mul($12, i64toi32_i32$HIGH_BITS, 1e9, 0) | 0;
            }
            HEAP32[$7 >> 2] = $3;
            $1 = ($6 | 0) != ($1 - 1 & 2047) ? $1 : ($0 | 0) == ($6 | 0) ? $1 : $3 ? $1 : $6;
            $5 = $6 - 1 | 0;
            if (($0 | 0) != ($6 | 0)) {
             continue
            }
            break;
           };
           $13 = $13 - 29 | 0;
           if (!$12) {
            continue
           }
           break;
          };
          $0 = $0 - 1 & 2047;
          if (($1 | 0) == ($0 | 0)) {
           $3 = $2 + 784 | 0;
           $5 = $3 + (($1 + 2046 & 2047) << 2) | 0;
           $1 = $1 - 1 & 2047;
           HEAP32[$5 >> 2] = HEAP32[$5 >> 2] | HEAP32[($1 << 2) + $3 >> 2];
          }
          $11 = $11 + 9 | 0;
          HEAP32[($2 + 784 | 0) + ($0 << 2) >> 2] = $12;
          continue;
         }
         break;
        };
        label$55 : {
         label$56 : while (1) {
          $3 = $1 + 1 & 2047;
          $8 = ($2 + 784 | 0) + (($1 - 1 & 2047) << 2) | 0;
          while (1) {
           $6 = ($11 | 0) > 45 ? 9 : 1;
           label$58 : {
            while (1) {
             $5 = $0;
             $4 = 0;
             label$60 : {
              while (1) {
               label$61 : {
                $0 = $4 + $5 & 2047;
                if (($0 | 0) == ($1 | 0)) {
                 break label$61
                }
                $0 = HEAP32[($2 + 784 | 0) + ($0 << 2) >> 2];
                $7 = HEAP32[($4 << 2) + 7904 >> 2];
                if ($0 >>> 0 < $7 >>> 0) {
                 break label$61
                }
                if ($0 >>> 0 > $7 >>> 0) {
                 break label$60
                }
                $4 = $4 + 1 | 0;
                if (($4 | 0) != 4) {
                 continue
                }
               }
               break;
              };
              if (($11 | 0) != 36) {
               break label$60
              }
              $3 = 0;
              $8 = 0;
              $4 = 0;
              $9 = 0;
              $7 = 0;
              while (1) {
               $0 = $4 + $5 & 2047;
               if (($1 | 0) == ($0 | 0)) {
                $1 = $1 + 1 & 2047;
                HEAP32[($2 + ($1 << 2) | 0) + 780 >> 2] = 0;
               }
               $6 = $2 + 768 | 0;
               __multf3($6, $3, $8, $9, $7, 0, 0, 1342177280, 1075633366);
               $3 = $2 + 752 | 0;
               __floatunsitf($3, HEAP32[($2 + 784 | 0) + ($0 << 2) >> 2]);
               $0 = $2 + 736 | 0;
               $6 = $6 + 8 | 0;
               $3 = $3 + 8 | 0;
               __addtf3($0, HEAP32[$2 + 768 >> 2], HEAP32[$2 + 772 >> 2], HEAP32[$6 >> 2], HEAP32[$6 + 4 >> 2], HEAP32[$2 + 752 >> 2], HEAP32[$2 + 756 >> 2], HEAP32[$3 >> 2], HEAP32[$3 + 4 >> 2]);
               $0 = $0 + 8 | 0;
               $9 = HEAP32[$0 >> 2];
               $7 = HEAP32[$0 + 4 >> 2];
               $3 = HEAP32[$2 + 736 >> 2];
               $8 = HEAP32[$2 + 740 >> 2];
               $4 = $4 + 1 | 0;
               if (($4 | 0) != 4) {
                continue
               }
               break;
              };
              $0 = $2 + 720 | 0;
              __floatsitf($0, $15);
              $6 = $2 + 704 | 0;
              $0 = $0 + 8 | 0;
              __multf3($6, $3, $8, $9, $7, HEAP32[$2 + 720 >> 2], HEAP32[$2 + 724 >> 2], HEAP32[$0 >> 2], HEAP32[$0 + 4 >> 2]);
              $0 = $6 + 8 | 0;
              $9 = HEAP32[$0 >> 2];
              $7 = HEAP32[$0 + 4 >> 2];
              $3 = 0;
              $8 = 0;
              $0 = HEAP32[$2 + 704 >> 2];
              $12 = HEAP32[$2 + 708 >> 2];
              $27 = $13 + 113 | 0;
              $20 = $27 - $20 | 0;
              $22 = ($20 | 0) < ($16 | 0);
              $11 = $22 ? (($20 | 0) > 0 ? $20 : 0) : $16;
              if (($11 | 0) <= 112) {
               break label$58
              }
              $4 = 0;
              $6 = 0;
              $10 = 0;
              break label$55;
             }
             $13 = $6 + $13 | 0;
             $0 = $1;
             if (($5 | 0) == ($0 | 0)) {
              continue
             }
             break;
            };
            $7 = 1e9 >>> $6 | 0;
            $9 = -1 << $6 ^ -1;
            $4 = 0;
            $0 = $5;
            while (1) {
             $12 = ($2 + 784 | 0) + ($5 << 2) | 0;
             $10 = HEAP32[$12 >> 2];
             $4 = $4 + ($10 >>> $6 | 0) | 0;
             HEAP32[$12 >> 2] = $4;
             $4 = !$4 & ($0 | 0) == ($5 | 0);
             $0 = $4 ? $0 + 1 & 2047 : $0;
             $11 = $4 ? $11 - 9 | 0 : $11;
             $4 = Math_imul($7, $9 & $10);
             $5 = $5 + 1 & 2047;
             if (($5 | 0) != ($1 | 0)) {
              continue
             }
             break;
            };
            if (!$4) {
             continue
            }
            if (($0 | 0) != ($3 | 0)) {
             HEAP32[($2 + 784 | 0) + ($1 << 2) >> 2] = $4;
             $1 = $3;
             continue label$56;
            }
            HEAP32[$8 >> 2] = HEAP32[$8 >> 2] | 1;
            $0 = $3;
            continue;
           }
           break;
          };
          break;
         };
         $3 = $2 + 656 | 0;
         __extenddftf2($3, scalbn(1.0, 225 - $11 | 0));
         $6 = $2 + 688 | 0;
         $3 = $3 + 8 | 0;
         copysignl($6, HEAP32[$2 + 656 >> 2], HEAP32[$2 + 660 >> 2], HEAP32[$3 >> 2], HEAP32[$3 + 4 >> 2], $0, $12, $9, $7);
         $3 = $6 + 8 | 0;
         $21 = HEAP32[$3 >> 2];
         $17 = HEAP32[$3 + 4 >> 2];
         $6 = HEAP32[$2 + 688 >> 2];
         $10 = HEAP32[$2 + 692 >> 2];
         $3 = $2 + 640 | 0;
         __extenddftf2($3, scalbn(1.0, 113 - $11 | 0));
         $4 = $2 + 672 | 0;
         $3 = $3 + 8 | 0;
         fmodl($4, $0, $12, $9, $7, HEAP32[$2 + 640 >> 2], HEAP32[$2 + 644 >> 2], HEAP32[$3 >> 2], HEAP32[$3 + 4 >> 2]);
         $16 = $2 + 624 | 0;
         $30 = $0;
         $3 = HEAP32[$2 + 672 >> 2];
         $8 = HEAP32[$2 + 676 >> 2];
         $0 = $4 + 8 | 0;
         $4 = HEAP32[$0 >> 2];
         $14 = HEAP32[$0 + 4 >> 2];
         __subtf3($16, $30, $12, $9, $7, $3, $8, $4, $14);
         $0 = $2 + 608 | 0;
         $7 = $16 + 8 | 0;
         __addtf3($0, $6, $10, $21, $17, HEAP32[$2 + 624 >> 2], HEAP32[$2 + 628 >> 2], HEAP32[$7 >> 2], HEAP32[$7 + 4 >> 2]);
         $0 = $0 + 8 | 0;
         $9 = HEAP32[$0 >> 2];
         $7 = HEAP32[$0 + 4 >> 2];
         $0 = HEAP32[$2 + 608 >> 2];
         $12 = HEAP32[$2 + 612 >> 2];
        }
        $16 = $5 + 4 & 2047;
        label$6730 : {
         if (($16 | 0) == ($1 | 0)) {
          break label$6730
         }
         $16 = HEAP32[($2 + 784 | 0) + ($16 << 2) >> 2];
         label$68 : {
          if ($16 >>> 0 <= 499999999) {
           if (!$16 & ($5 + 5 & 2047) == ($1 | 0)) {
            break label$68
           }
           $1 = $2 + 496 | 0;
           __extenddftf2($1, +($15 | 0) * .25);
           $5 = $2 + 480 | 0;
           $1 = $1 + 8 | 0;
           __addtf3($5, $3, $8, $4, $14, HEAP32[$2 + 496 >> 2], HEAP32[$2 + 500 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2]);
           $1 = $5 + 8 | 0;
           $4 = HEAP32[$1 >> 2];
           $14 = HEAP32[$1 + 4 >> 2];
           $3 = HEAP32[$2 + 480 >> 2];
           $8 = HEAP32[$2 + 484 >> 2];
           break label$68;
          }
          if (($16 | 0) != 5e8) {
           $1 = $2 + 592 | 0;
           __extenddftf2($1, +($15 | 0) * .75);
           $5 = $2 + 576 | 0;
           $1 = $1 + 8 | 0;
           __addtf3($5, $3, $8, $4, $14, HEAP32[$2 + 592 >> 2], HEAP32[$2 + 596 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2]);
           $1 = $5 + 8 | 0;
           $4 = HEAP32[$1 >> 2];
           $14 = HEAP32[$1 + 4 >> 2];
           $3 = HEAP32[$2 + 576 >> 2];
           $8 = HEAP32[$2 + 580 >> 2];
           break label$68;
          }
          $29 = +($15 | 0);
          if (($1 | 0) == ($5 + 5 & 2047)) {
           $1 = $2 + 528 | 0;
           __extenddftf2($1, $29 * .5);
           $5 = $2 + 512 | 0;
           $1 = $1 + 8 | 0;
           __addtf3($5, $3, $8, $4, $14, HEAP32[$2 + 528 >> 2], HEAP32[$2 + 532 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2]);
           $1 = $5 + 8 | 0;
           $4 = HEAP32[$1 >> 2];
           $14 = HEAP32[$1 + 4 >> 2];
           $3 = HEAP32[$2 + 512 >> 2];
           $8 = HEAP32[$2 + 516 >> 2];
           break label$68;
          }
          $1 = $2 + 560 | 0;
          __extenddftf2($1, $29 * .75);
          $5 = $2 + 544 | 0;
          $1 = $1 + 8 | 0;
          __addtf3($5, $3, $8, $4, $14, HEAP32[$2 + 560 >> 2], HEAP32[$2 + 564 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2]);
          $1 = $5 + 8 | 0;
          $4 = HEAP32[$1 >> 2];
          $14 = HEAP32[$1 + 4 >> 2];
          $3 = HEAP32[$2 + 544 >> 2];
          $8 = HEAP32[$2 + 548 >> 2];
         }
         if (($11 | 0) > 111) {
          break label$6730
         }
         $1 = $2 + 464 | 0;
         fmodl($1, $3, $8, $4, $14, 0, 0, 0, 1073676288);
         $1 = $1 + 8 | 0;
         if (__letf2(HEAP32[$2 + 464 >> 2], HEAP32[$2 + 468 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2], 0, 0, 0, 0)) {
          break label$6730
         }
         $1 = $2 + 448 | 0;
         __addtf3($1, $3, $8, $4, $14, 0, 0, 0, 1073676288);
         $1 = $1 + 8 | 0;
         $4 = HEAP32[$1 >> 2];
         $14 = HEAP32[$1 + 4 >> 2];
         $3 = HEAP32[$2 + 448 >> 2];
         $8 = HEAP32[$2 + 452 >> 2];
        }
        $1 = $2 + 432 | 0;
        __addtf3($1, $0, $12, $9, $7, $3, $8, $4, $14);
        $0 = $2 + 416 | 0;
        $1 = $1 + 8 | 0;
        __subtf3($0, HEAP32[$2 + 432 >> 2], HEAP32[$2 + 436 >> 2], HEAP32[$1 >> 2], HEAP32[$1 + 4 >> 2], $6, $10, $21, $17);
        $0 = $0 + 8 | 0;
        $9 = HEAP32[$0 >> 2];
        $7 = HEAP32[$0 + 4 >> 2];
        $0 = HEAP32[$2 + 416 >> 2];
        $12 = HEAP32[$2 + 420 >> 2];
        label$73 : {
         if ((-2 - $25 | 0) >= ($27 & 2147483647)) {
          break label$73
         }
         $5 = $2 + 400 | 0;
         $1 = $5;
         HEAP32[$1 + 8 >> 2] = $9;
         HEAP32[$1 + 12 >> 2] = $7 & 2147483647;
         HEAP32[$1 >> 2] = $0;
         HEAP32[$1 + 4 >> 2] = $12;
         $6 = $2 + 384 | 0;
         __multf3($6, $0, $12, $9, $7, 0, 0, 0, 1073610752);
         $15 = HEAP32[$2 + 400 >> 2];
         $10 = HEAP32[$2 + 404 >> 2];
         $1 = $1 + 8 | 0;
         $17 = HEAP32[$1 >> 2];
         $21 = HEAP32[$1 + 4 >> 2];
         $1 = __getf2($15, $10, $17, $21, 1081081856);
         $6 = $6 + 8 | 0;
         $5 = ($1 | 0) < 0;
         $9 = $5 ? $9 : HEAP32[$6 >> 2];
         $7 = $5 ? $7 : HEAP32[$6 + 4 >> 2];
         $0 = $5 ? $0 : HEAP32[$2 + 384 >> 2];
         $12 = $5 ? $12 : HEAP32[$2 + 388 >> 2];
         $13 = (($1 | 0) > -1) + $13 | 0;
         if (($26 | 0) >= ($13 + 110 | 0)) {
          if ((((__getf2($15, $10, $17, $21, 1081081856) | 0) < 0 ? $22 : $22 & ($11 | 0) != ($20 | 0)) | 0) != 1) {
           break label$73
          }
          if (!__letf2($3, $8, $4, $14, 0, 0, 0, 0)) {
           break label$73
          }
         }
         HEAP32[2892] = 68;
        }
        $1 = $2 + 368 | 0;
        scalbnl($1, $0, $12, $9, $7, $13);
        $0 = $1 + 8 | 0;
        $3 = HEAP32[$0 >> 2];
        $9 = HEAP32[$2 + 368 >> 2];
        $7 = HEAP32[$2 + 372 >> 2];
        $0 = HEAP32[$0 + 4 >> 2];
       }
       HEAP32[$18 >> 2] = $9;
       HEAP32[$18 + 4 >> 2] = $7;
       HEAP32[$18 + 8 >> 2] = $3;
       HEAP32[$18 + 12 >> 2] = $0;
       __stack_pointer = $2 + 8976 | 0;
       $0 = $19 + 40 | 0;
       $3 = HEAP32[$0 >> 2];
       $1 = HEAP32[$0 + 4 >> 2];
       $15 = HEAP32[$19 + 32 >> 2];
       $5 = HEAP32[$19 + 36 >> 2];
       break label$1;
      case 3:
       break label$20;
      default:
       break label$25;
      };
     }
     if (HEAP32[$0 + 104 >> 2]) {
      HEAP32[$4 >> 2] = HEAP32[$4 >> 2] - 1
     }
     break label$19;
    }
    label$34 : {
     $1 = HEAP32[$0 + 4 >> 2];
     label$32 : {
      if ($1 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
       HEAP32[$4 >> 2] = $1 + 1;
       $1 = HEAPU8[$1 | 0];
       break label$32;
      }
      $1 = __shgetc($0);
     }
     if (($1 | 0) == 40) {
      $6 = 1;
      break label$34;
     }
     $3 = 0;
     $1 = 2147450880;
     if (!HEAP32[$0 + 104 >> 2]) {
      break label$1
     }
     HEAP32[$4 >> 2] = HEAP32[$4 >> 2] - 1;
     break label$1;
    }
    while (1) {
     $1 = HEAP32[$0 + 4 >> 2];
     label$3732 : {
      if ($1 >>> 0 < HEAPU32[$0 + 104 >> 2]) {
       HEAP32[$4 >> 2] = $1 + 1;
       $8 = HEAPU8[$1 | 0];
       break label$3732;
      }
      $8 = __shgetc($0);
     }
     if (!(!($8 - 48 >>> 0 < 10 | $8 - 65 >>> 0 < 26 | ($8 | 0) == 95) & $8 - 97 >>> 0 >= 26)) {
      $6 = $6 + 1 | 0;
      continue;
     }
     break;
    };
    $3 = 0;
    $1 = 2147450880;
    if (($8 | 0) == 41) {
     break label$1
    }
    $0 = HEAP32[$0 + 104 >> 2];
    if ($0) {
     HEAP32[$4 >> 2] = HEAP32[$4 >> 2] - 1
    }
    if (!$6) {
     break label$1
    }
    while (1) {
     $6 = $6 - 1 | 0;
     if ($0) {
      HEAP32[$4 >> 2] = HEAP32[$4 >> 2] - 1
     }
     if ($6) {
      continue
     }
     break;
    };
    break label$1;
   }
   HEAP32[2892] = 28;
   __shlim($0);
   $3 = 0;
   $1 = 0;
  }
  HEAP32[$28 >> 2] = $15;
  HEAP32[$28 + 4 >> 2] = $5;
  HEAP32[$28 + 8 >> 2] = $3;
  HEAP32[$28 + 12 >> 2] = $1;
  __stack_pointer = $19 + 48 | 0;
  $0 = $23 + 8 | 0;
  $1 = HEAP32[$0 >> 2];
  $0 = HEAP32[$0 + 4 >> 2];
  $3 = HEAP32[$23 + 4 >> 2];
  HEAP32[$24 >> 2] = HEAP32[$23 >> 2];
  HEAP32[$24 + 4 >> 2] = $3;
  HEAP32[$24 + 8 >> 2] = $1;
  HEAP32[$24 + 12 >> 2] = $0;
  __stack_pointer = $23 + 160 | 0;
  $8 = HEAP32[$24 >> 2];
  $4 = HEAP32[$24 + 4 >> 2];
  $0 = $24 + 8 | 0;
  $1 = HEAP32[$0 >> 2];
  $6 = __stack_pointer - 32 | 0;
  __stack_pointer = $6;
  $7 = HEAP32[$0 + 4 >> 2];
  $0 = $7 & 2147483647;
  $3 = $0;
  $5 = $0 - 1006698496 | 0;
  $9 = $0 - 1140785152 | 0;
  $0 = $1;
  label$110 : {
   if (!(($5 | 0) == ($9 | 0) & $0 >>> 0 >= $0 >>> 0 | $5 >>> 0 > $9 >>> 0)) {
    $3 = $1 << 4 | $4 >>> 28;
    $1 = $7 << 4 | $1 >>> 28;
    $0 = $4 & 268435455;
    $4 = $0;
    if (!(($0 | 0) == 134217728 & $8 >>> 0 < 1 | $0 >>> 0 < 134217728)) {
     $0 = $1 + 1073741824 | 0;
     $5 = $0 + 1 | 0;
     $1 = $0;
     $0 = $3 + 1 | 0;
     $5 = $0 >>> 0 < 1 ? $5 : $1;
     break label$110;
    }
    $0 = $3;
    $5 = $1 + 1073741824 | 0;
    if ($8 | $4 ^ 134217728) {
     break label$110
    }
    $1 = $3 & 1;
    $0 = $1 + $0 | 0;
    $5 = $0 >>> 0 < $1 >>> 0 ? $5 + 1 | 0 : $5;
    break label$110;
   }
   if (!(!$0 & ($3 | 0) == 2147418112 ? !($4 | $8) : $3 >>> 0 < 2147418112)) {
    $0 = $1 << 4 | $4 >>> 28;
    $5 = ($7 << 4 | $1 >>> 28) & 524287 | 2146959360;
    break label$110;
   }
   $0 = 0;
   $5 = 2146435072;
   if ($3 >>> 0 > 1140785151) {
    break label$110
   }
   $5 = 0;
   $3 = $3 >>> 16 | 0;
   if ($3 >>> 0 < 15249) {
    break label$110
   }
   $9 = $6 + 16 | 0;
   $0 = $7 & 65535 | 65536;
   __ashlti3($9, $8, $4, $1, $0, $3 - 15233 | 0);
   __lshrti3($6, $8, $4, $1, $0, 15361 - $3 | 0);
   $0 = HEAP32[$6 + 4 >> 2];
   $1 = $0;
   $3 = $6 + 8 | 0;
   $5 = HEAP32[$3 + 4 >> 2];
   $3 = HEAP32[$3 >> 2];
   $0 = $3 << 4 | $0 >>> 28;
   $5 = $5 << 4 | $3 >>> 28;
   $1 = $1 & 268435455;
   $3 = $1;
   $4 = $9 + 8 | 0;
   $4 = HEAP32[$6 >> 2] | ((HEAP32[$6 + 16 >> 2] | HEAP32[$4 >> 2]) != 0 | (HEAP32[$6 + 20 >> 2] | HEAP32[$4 + 4 >> 2]) != 0);
   if (!(($1 | 0) == 134217728 & $4 >>> 0 < 1 | $1 >>> 0 < 134217728)) {
    $0 = $0 + 1 | 0;
    $5 = $0 >>> 0 < 1 ? $5 + 1 | 0 : $5;
    break label$110;
   }
   if ($4 | $3 ^ 134217728) {
    break label$110
   }
   $1 = $0;
   $0 = $0 + ($0 & 1) | 0;
   $5 = $1 >>> 0 > $0 >>> 0 ? $5 + 1 | 0 : $5;
  }
  __stack_pointer = $6 + 32 | 0;
  wasm2js_scratch_store_i32(0, $0 | 0);
  wasm2js_scratch_store_i32(1, $7 & -2147483648 | $5);
  $29 = +wasm2js_scratch_load_f64();
  __stack_pointer = $24 + 16 | 0;
  return $29;
 }
 
 function __cos($0, $1) {
  var $2 = 0.0, $3 = 0.0, $4 = 0.0, $5 = 0.0;
  $2 = $0 * $0;
  $3 = $2 * .5;
  $4 = 1.0 - $3;
  $5 = 1.0 - $4 - $3;
  $3 = $2 * $2;
  return $4 + ($5 + ($2 * ($2 * ($2 * ($2 * 2.480158728947673e-05 + -.001388888888887411) + .0416666666666666) + $3 * $3 * ($2 * ($2 * -1.1359647557788195e-11 + 2.087572321298175e-09) + -2.7557314351390663e-07)) - $0 * $1));
 }
 
 function __sin($0, $1) {
  var $2 = 0.0, $3 = 0.0;
  $2 = $0 * $0;
  $3 = $0;
  $0 = $2 * $0;
  return $3 - ($2 * ($1 * .5 - $0 * ($2 * ($2 * $2) * ($2 * 1.58969099521155e-10 + -2.5050760253406863e-08) + ($2 * ($2 * 2.7557313707070068e-06 + -1.984126982985795e-04) + .00833333333332249))) - $1 + $0 * .16666666666666632);
 }
 
 function cos($0) {
  var $1 = 0, $2 = 0, $3 = 0.0, $4 = 0, $5 = 0, $6 = 0, $7 = 0.0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0.0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
  $12 = __stack_pointer - 16 | 0;
  __stack_pointer = $12;
  wasm2js_scratch_store_f64(+$0);
  $2 = wasm2js_scratch_load_i32(1) | 0;
  wasm2js_scratch_load_i32(0) | 0;
  $2 = $2 & 2147483647;
  label$1 : {
   if ($2 >>> 0 <= 1072243195) {
    $7 = 1.0;
    if ($2 >>> 0 < 1044816030) {
     break label$1
    }
    $7 = __cos($0, 0.0);
    break label$1;
   }
   $7 = $0 - $0;
   if ($2 >>> 0 >= 2146435072) {
    break label$1
   }
   $8 = $12;
   $13 = __stack_pointer - 48 | 0;
   __stack_pointer = $13;
   wasm2js_scratch_store_f64(+$0);
   $2 = wasm2js_scratch_load_i32(1) | 0;
   $1 = wasm2js_scratch_load_i32(0) | 0;
   label$10 : {
    label$2 : {
     $18 = $2;
     $4 = $2 & 2147483647;
     label$3 : {
      if ($4 >>> 0 <= 1074752122) {
       if (($2 & 1048575) == 598523) {
        break label$3
       }
       if ($4 >>> 0 <= 1073928572) {
        if (($18 | 0) >= 0) {
         $0 = $0 + -1.5707963267341256;
         $3 = $0 + -6.077100506506192e-11;
         HEAPF64[$8 >> 3] = $3;
         HEAPF64[$8 + 8 >> 3] = $0 - $3 + -6.077100506506192e-11;
         $2 = 1;
         break label$10;
        }
        $0 = $0 + 1.5707963267341256;
        $3 = $0 + 6.077100506506192e-11;
        HEAPF64[$8 >> 3] = $3;
        HEAPF64[$8 + 8 >> 3] = $0 - $3 + 6.077100506506192e-11;
        $2 = -1;
        break label$10;
       }
       if (($18 | 0) >= 0) {
        $0 = $0 + -3.1415926534682512;
        $3 = $0 + -1.2154201013012384e-10;
        HEAPF64[$8 >> 3] = $3;
        HEAPF64[$8 + 8 >> 3] = $0 - $3 + -1.2154201013012384e-10;
        $2 = 2;
        break label$10;
       }
       $0 = $0 + 3.1415926534682512;
       $3 = $0 + 1.2154201013012384e-10;
       HEAPF64[$8 >> 3] = $3;
       HEAPF64[$8 + 8 >> 3] = $0 - $3 + 1.2154201013012384e-10;
       $2 = -2;
       break label$10;
      }
      if ($4 >>> 0 <= 1075594811) {
       if ($4 >>> 0 <= 1075183036) {
        if (($4 | 0) == 1074977148) {
         break label$3
        }
        if (($18 | 0) >= 0) {
         $0 = $0 + -4.712388980202377;
         $3 = $0 + -1.8231301519518578e-10;
         HEAPF64[$8 >> 3] = $3;
         HEAPF64[$8 + 8 >> 3] = $0 - $3 + -1.8231301519518578e-10;
         $2 = 3;
         break label$10;
        }
        $0 = $0 + 4.712388980202377;
        $3 = $0 + 1.8231301519518578e-10;
        HEAPF64[$8 >> 3] = $3;
        HEAPF64[$8 + 8 >> 3] = $0 - $3 + 1.8231301519518578e-10;
        $2 = -3;
        break label$10;
       }
       if (($4 | 0) == 1075388923) {
        break label$3
       }
       if (($18 | 0) >= 0) {
        $0 = $0 + -6.2831853069365025;
        $3 = $0 + -2.430840202602477e-10;
        HEAPF64[$8 >> 3] = $3;
        HEAPF64[$8 + 8 >> 3] = $0 - $3 + -2.430840202602477e-10;
        $2 = 4;
        break label$10;
       }
       $0 = $0 + 6.2831853069365025;
       $3 = $0 + 2.430840202602477e-10;
       HEAPF64[$8 >> 3] = $3;
       HEAPF64[$8 + 8 >> 3] = $0 - $3 + 2.430840202602477e-10;
       $2 = -4;
       break label$10;
      }
      if ($4 >>> 0 > 1094263290) {
       break label$2
      }
     }
     $15 = $0 * .6366197723675814 + 6755399441055744.0 + -6755399441055744.0;
     $7 = $0 + $15 * -1.5707963267341256;
     $0 = $15 * 6.077100506506192e-11;
     $3 = $7 - $0;
     HEAPF64[$8 >> 3] = $3;
     wasm2js_scratch_store_f64(+$3);
     $1 = wasm2js_scratch_load_i32(1) | 0;
     wasm2js_scratch_load_i32(0) | 0;
     $2 = Math_abs($15) < 2147483648.0 ? ~~$15 : -2147483648;
     $4 = $4 >>> 20 | 0;
     label$14 : {
      if (($4 - ($1 >>> 20 & 2047) | 0) < 17) {
       break label$14
      }
      $3 = $7;
      $0 = $15 * 6.077100506303966e-11;
      $7 = $7 - $0;
      $0 = $15 * 2.0222662487959506e-21 - ($3 - $7 - $0);
      $3 = $7 - $0;
      HEAPF64[$8 >> 3] = $3;
      wasm2js_scratch_store_f64(+$3);
      $1 = wasm2js_scratch_load_i32(1) | 0;
      wasm2js_scratch_load_i32(0) | 0;
      if (($4 - ($1 >>> 20 & 2047) | 0) < 50) {
       break label$14
      }
      $3 = $7;
      $0 = $15 * 2.0222662487111665e-21;
      $7 = $7 - $0;
      $0 = $15 * 8.4784276603689e-32 - ($3 - $7 - $0);
      $3 = $7 - $0;
      HEAPF64[$8 >> 3] = $3;
     }
     HEAPF64[$8 + 8 >> 3] = $7 - $3 - $0;
     break label$10;
    }
    if ($4 >>> 0 >= 2146435072) {
     $0 = $0 - $0;
     HEAPF64[$8 >> 3] = $0;
     HEAPF64[$8 + 8 >> 3] = $0;
     $2 = 0;
     break label$10;
    }
    wasm2js_scratch_store_i32(0, $1 | 0);
    wasm2js_scratch_store_i32(1, $18 & 1048575 | 1096810496);
    $3 = +wasm2js_scratch_load_f64();
    $2 = 0;
    $1 = 1;
    while (1) {
     $0 = +((Math_abs($3) < 2147483648.0 ? ~~$3 : -2147483648) | 0);
     HEAPF64[($13 + 16 | 0) + ($2 << 3) >> 3] = $0;
     $3 = ($3 - $0) * 16777216.0;
     $2 = 1;
     $11 = $1 & 1;
     $1 = 0;
     if ($11) {
      continue
     }
     break;
    };
    HEAPF64[$13 + 32 >> 3] = $3;
    label$20 : {
     if ($3 != 0.0) {
      $2 = 2;
      break label$20;
     }
     $1 = 1;
     while (1) {
      $2 = $1;
      $1 = $1 - 1 | 0;
      if (HEAPF64[($13 + 16 | 0) + ($2 << 3) >> 3] == 0.0) {
       continue
      }
      break;
     };
    }
    $21 = $13 + 16 | 0;
    $22 = $13;
    $6 = __stack_pointer - 560 | 0;
    __stack_pointer = $6;
    $1 = ($4 >>> 20 | 0) - 1046 | 0;
    $4 = ($1 - 3 | 0) / 24 | 0;
    $20 = ($4 | 0) > 0 ? $4 : 0;
    $4 = Math_imul($20, -24) + $1 | 0;
    $14 = HEAP32[1997];
    $17 = $2 + 1 | 0;
    $9 = $17 - 1 | 0;
    if (($14 + $9 | 0) >= 0) {
     $2 = $14 + $17 | 0;
     $1 = $20 - $9 | 0;
     while (1) {
      HEAPF64[($6 + 320 | 0) + ($5 << 3) >> 3] = ($1 | 0) < 0 ? 0.0 : +HEAP32[($1 << 2) + 8e3 >> 2];
      $1 = $1 + 1 | 0;
      $5 = $5 + 1 | 0;
      if (($2 | 0) != ($5 | 0)) {
       continue
      }
      break;
     };
    }
    $11 = $4 - 24 | 0;
    $5 = ($14 | 0) > 0 ? $14 : 0;
    $2 = 0;
    while (1) {
     $0 = 0.0;
     if (($17 | 0) > 0) {
      $10 = $2 + $9 | 0;
      $1 = 0;
      while (1) {
       $0 = $0 + HEAPF64[($1 << 3) + $21 >> 3] * HEAPF64[($6 + 320 | 0) + ($10 - $1 << 3) >> 3];
       $1 = $1 + 1 | 0;
       if (($17 | 0) != ($1 | 0)) {
        continue
       }
       break;
      };
     }
     HEAPF64[($2 << 3) + $6 >> 3] = $0;
     $1 = ($2 | 0) == ($5 | 0);
     $2 = $2 + 1 | 0;
     if (!$1) {
      continue
     }
     break;
    };
    $26 = 47 - $4 | 0;
    $23 = 48 - $4 | 0;
    $27 = $4 - 25 | 0;
    $2 = $14;
    label$8 : {
     while (1) {
      $0 = HEAPF64[($2 << 3) + $6 >> 3];
      $1 = 0;
      $5 = $2;
      $16 = ($2 | 0) < 1;
      if (!$16) {
       while (1) {
        $10 = ($6 + 480 | 0) + ($1 << 2) | 0;
        $7 = $0;
        $0 = $0 * 5.9604644775390625e-08;
        label$12 : {
         if (Math_abs($0) < 2147483648.0) {
          $9 = ~~$0;
          break label$12;
         }
         $9 = -2147483648;
        }
        $0 = +($9 | 0);
        $3 = $7 + $0 * -16777216.0;
        label$142 : {
         if (Math_abs($3) < 2147483648.0) {
          $9 = ~~$3;
          break label$142;
         }
         $9 = -2147483648;
        }
        HEAP32[$10 >> 2] = $9;
        $5 = $5 - 1 | 0;
        $0 = HEAPF64[($5 << 3) + $6 >> 3] + $0;
        $1 = $1 + 1 | 0;
        if (($2 | 0) != ($1 | 0)) {
         continue
        }
        break;
       }
      }
      $0 = scalbn($0, $11);
      $0 = $0 + Math_floor($0 * .125) * -8.0;
      label$16 : {
       if (Math_abs($0) < 2147483648.0) {
        $9 = ~~$0;
        break label$16;
       }
       $9 = -2147483648;
      }
      $0 = $0 - +($9 | 0);
      label$18 : {
       label$19 : {
        label$203 : {
         $24 = ($11 | 0) < 1;
         label$214 : {
          if (!$24) {
           $5 = ($6 + ($2 << 2) | 0) + 476 | 0;
           $10 = HEAP32[$5 >> 2];
           $1 = $10 >> $23;
           $19 = $5;
           $5 = $10 - ($1 << $23) | 0;
           HEAP32[$19 >> 2] = $5;
           $9 = $1 + $9 | 0;
           $10 = $5 >> $26;
           break label$214;
          }
          if ($11) {
           break label$203
          }
          $10 = HEAP32[($6 + ($2 << 2) | 0) + 476 >> 2] >> 23;
         }
         if (($10 | 0) < 1) {
          break label$18
         }
         break label$19;
        }
        $10 = 2;
        if ($0 >= .5) {
         break label$19
        }
        $10 = 0;
        break label$18;
       }
       $1 = 0;
       $5 = 0;
       if (!$16) {
        while (1) {
         $19 = ($6 + 480 | 0) + ($1 << 2) | 0;
         $16 = HEAP32[$19 >> 2];
         $25 = 16777215;
         label$25 : {
          label$26 : {
           if ($5) {
            break label$26
           }
           $25 = 16777216;
           if ($16) {
            break label$26
           }
           $5 = 0;
           break label$25;
          }
          HEAP32[$19 >> 2] = $25 - $16;
          $5 = 1;
         }
         $1 = $1 + 1 | 0;
         if (($2 | 0) != ($1 | 0)) {
          continue
         }
         break;
        }
       }
       label$27 : {
        if ($24) {
         break label$27
        }
        $1 = 8388607;
        label$28 : {
         switch ($27 | 0) {
         case 1:
          $1 = 4194303;
          break;
         case 0:
          break label$28;
         default:
          break label$27;
         };
        }
        $16 = ($6 + ($2 << 2) | 0) + 476 | 0;
        HEAP32[$16 >> 2] = HEAP32[$16 >> 2] & $1;
       }
       $9 = $9 + 1 | 0;
       if (($10 | 0) != 2) {
        break label$18
       }
       $0 = 1.0 - $0;
       $10 = 2;
       if (!$5) {
        break label$18
       }
       $0 = $0 - scalbn(1.0, $11);
      }
      if ($0 == 0.0) {
       $5 = 0;
       label$31 : {
        $1 = $2;
        if (($14 | 0) >= ($1 | 0)) {
         break label$31
        }
        while (1) {
         $1 = $1 - 1 | 0;
         $5 = HEAP32[($6 + 480 | 0) + ($1 << 2) >> 2] | $5;
         if (($1 | 0) > ($14 | 0)) {
          continue
         }
         break;
        };
        if (!$5) {
         break label$31
        }
        $4 = $11;
        while (1) {
         $4 = $4 - 24 | 0;
         $2 = $2 - 1 | 0;
         if (!HEAP32[($6 + 480 | 0) + ($2 << 2) >> 2]) {
          continue
         }
         break;
        };
        break label$8;
       }
       $1 = 1;
       while (1) {
        $5 = $1;
        $1 = $1 + 1 | 0;
        if (!HEAP32[($6 + 480 | 0) + ($14 - $5 << 2) >> 2]) {
         continue
        }
        break;
       };
       $5 = $2 + $5 | 0;
       while (1) {
        $9 = $2 + $17 | 0;
        $2 = $2 + 1 | 0;
        HEAPF64[($6 + 320 | 0) + ($9 << 3) >> 3] = HEAP32[($2 + $20 << 2) + 8e3 >> 2];
        $1 = 0;
        $0 = 0.0;
        if (($17 | 0) >= 1) {
         while (1) {
          $0 = $0 + HEAPF64[($1 << 3) + $21 >> 3] * HEAPF64[($6 + 320 | 0) + ($9 - $1 << 3) >> 3];
          $1 = $1 + 1 | 0;
          if (($17 | 0) != ($1 | 0)) {
           continue
          }
          break;
         }
        }
        HEAPF64[($2 << 3) + $6 >> 3] = $0;
        if (($2 | 0) < ($5 | 0)) {
         continue
        }
        break;
       };
       $2 = $5;
       continue;
      }
      break;
     };
     $0 = scalbn($0, 24 - $4 | 0);
     label$38 : {
      if ($0 >= 16777216.0) {
       $11 = ($6 + 480 | 0) + ($2 << 2) | 0;
       $7 = $0;
       $0 = $0 * 5.9604644775390625e-08;
       label$40 : {
        if (Math_abs($0) < 2147483648.0) {
         $1 = ~~$0;
         break label$40;
        }
        $1 = -2147483648;
       }
       $0 = $7 + +($1 | 0) * -16777216.0;
       label$42 : {
        if (Math_abs($0) < 2147483648.0) {
         $5 = ~~$0;
         break label$42;
        }
        $5 = -2147483648;
       }
       HEAP32[$11 >> 2] = $5;
       $2 = $2 + 1 | 0;
       break label$38;
      }
      $1 = Math_abs($0) < 2147483648.0 ? ~~$0 : -2147483648;
      $4 = $11;
     }
     HEAP32[($6 + 480 | 0) + ($2 << 2) >> 2] = $1;
    }
    $0 = scalbn(1.0, $4);
    label$46 : {
     if (($2 | 0) <= -1) {
      break label$46
     }
     $1 = $2;
     while (1) {
      HEAPF64[($1 << 3) + $6 >> 3] = $0 * +HEAP32[($6 + 480 | 0) + ($1 << 2) >> 2];
      $0 = $0 * 5.9604644775390625e-08;
      $4 = ($1 | 0) > 0;
      $1 = $1 - 1 | 0;
      if ($4) {
       continue
      }
      break;
     };
     if (($2 | 0) <= -1) {
      break label$46
     }
     $1 = $2;
     while (1) {
      $4 = $1;
      $11 = $2 - $1 | 0;
      $0 = 0.0;
      $1 = 0;
      while (1) {
       label$49 : {
        $0 = $0 + HEAPF64[($1 << 3) + 10768 >> 3] * HEAPF64[($1 + $4 << 3) + $6 >> 3];
        if (($1 | 0) >= ($14 | 0)) {
         break label$49
        }
        $5 = $1 >>> 0 < $11 >>> 0;
        $1 = $1 + 1 | 0;
        if ($5) {
         continue
        }
       }
       break;
      };
      HEAPF64[($6 + 160 | 0) + ($11 << 3) >> 3] = $0;
      $1 = $4 - 1 | 0;
      if (($4 | 0) > 0) {
       continue
      }
      break;
     };
    }
    $0 = 0.0;
    if (($2 | 0) >= 0) {
     $1 = $2;
     while (1) {
      $0 = $0 + HEAPF64[($6 + 160 | 0) + ($1 << 3) >> 3];
      $4 = ($1 | 0) > 0;
      $1 = $1 - 1 | 0;
      if ($4) {
       continue
      }
      break;
     };
    }
    HEAPF64[$22 >> 3] = $10 ? -$0 : $0;
    $0 = HEAPF64[$6 + 160 >> 3] - $0;
    $1 = 1;
    if (($2 | 0) >= 1) {
     while (1) {
      $0 = $0 + HEAPF64[($6 + 160 | 0) + ($1 << 3) >> 3];
      $4 = ($1 | 0) != ($2 | 0);
      $1 = $1 + 1 | 0;
      if ($4) {
       continue
      }
      break;
     }
    }
    HEAPF64[$22 + 8 >> 3] = $10 ? -$0 : $0;
    __stack_pointer = $6 + 560 | 0;
    $2 = $9 & 7;
    $0 = HEAPF64[$13 >> 3];
    if (($18 | 0) <= -1) {
     HEAPF64[$8 >> 3] = -$0;
     HEAPF64[$8 + 8 >> 3] = -HEAPF64[$13 + 8 >> 3];
     $2 = 0 - $2 | 0;
     break label$10;
    }
    HEAPF64[$8 >> 3] = $0;
    HEAPF64[$8 + 8 >> 3] = HEAPF64[$13 + 8 >> 3];
   }
   __stack_pointer = $13 + 48 | 0;
   label$4 : {
    switch ($2 & 3) {
    case 0:
     $7 = __cos(HEAPF64[$12 >> 3], HEAPF64[$12 + 8 >> 3]);
     break label$1;
    case 1:
     $7 = -__sin(HEAPF64[$12 >> 3], HEAPF64[$12 + 8 >> 3]);
     break label$1;
    case 2:
     $7 = -__cos(HEAPF64[$12 >> 3], HEAPF64[$12 + 8 >> 3]);
     break label$1;
    default:
     break label$4;
    };
   }
   $7 = __sin(HEAPF64[$12 >> 3], HEAPF64[$12 + 8 >> 3]);
  }
  $0 = $7;
  __stack_pointer = $12 + 16 | 0;
  return $0;
 }
 
 function exp($0) {
  var $1 = 0, $2 = 0.0, $3 = 0, $4 = 0.0, $5 = 0.0, $6 = 0;
  wasm2js_scratch_store_f64(+$0);
  $1 = wasm2js_scratch_load_i32(1) | 0;
  wasm2js_scratch_load_i32(0) | 0;
  $3 = $1 >>> 31 | 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      $4 = $0;
      label$5 : {
       label$6 : {
        $1 = $1 & 2147483647;
        label$7 : {
         if ($1 >>> 0 >= 1082532651) {
          wasm2js_scratch_store_f64(+$0);
          $1 = wasm2js_scratch_load_i32(1) | 0;
          $6 = wasm2js_scratch_load_i32(0) | 0;
          i64toi32_i32$HIGH_BITS = $1;
          $1 = i64toi32_i32$HIGH_BITS & 2147483647;
          if (!(!$6 & ($1 | 0) == 2146435072 | $1 >>> 0 < 2146435072)) {
           return $0
          }
          if ($0 > 709.782712893384) {
           return $0 * 8988465674311579538646525.0e283
          }
          if (!($0 < -708.3964185322641) | !($0 < -745.1332191019411)) {
           break label$7
          }
          break label$2;
         }
         if ($1 >>> 0 < 1071001155) {
          break label$4
         }
         if ($1 >>> 0 < 1072734898) {
          break label$6
         }
        }
        $0 = $0 * 1.4426950408889634 + HEAPF64[($3 << 3) + 10832 >> 3];
        if (Math_abs($0) < 2147483648.0) {
         $3 = ~~$0;
         break label$5;
        }
        $3 = -2147483648;
        break label$5;
       }
       $3 = !$3 - $3 | 0;
      }
      $2 = +($3 | 0);
      $0 = $4 + $2 * -.6931471803691238;
      $5 = $2 * 1.9082149292705877e-10;
      $2 = $0 - $5;
      break label$3;
     }
     if ($1 >>> 0 <= 1043333120) {
      break label$1
     }
     $3 = 0;
     $2 = $0;
    }
    $4 = $0;
    $0 = $2 * $2;
    $0 = $2 - $0 * ($0 * ($0 * ($0 * ($0 * 4.1381367970572385e-08 + -1.6533902205465252e-06) + 6.613756321437934e-05) + -2.7777777777015593e-03) + .16666666666666602);
    $2 = $4 + ($2 * $0 / (2.0 - $0) - $5) + 1.0;
    if (!$3) {
     break label$2
    }
    $2 = scalbn($2, $3);
   }
   return $2;
  }
  return $0 + 1.0;
 }
 
 function FLAC__window_hann($0, $1) {
  var $2 = 0, $3 = 0.0, $4 = 0, $5 = 0, wasm2js_i32$0 = 0, wasm2js_f32$0 = Math_fround(0);
  label$1 : {
   if (($1 | 0) < 1) {
    break label$1
   }
   $3 = +($1 - 1 | 0);
   $5 = $1 & 1;
   if (($1 | 0) != 1) {
    $1 = $1 & -2;
    while (1) {
     (wasm2js_i32$0 = ($2 << 2) + $0 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($2 | 0) * 6.283185307179586 / $3) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
     $4 = $2 | 1;
     (wasm2js_i32$0 = ($4 << 2) + $0 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($4 | 0) * 6.283185307179586 / $3) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
     $2 = $2 + 2 | 0;
     $1 = $1 - 2 | 0;
     if ($1) {
      continue
     }
     break;
    };
   }
   if (!$5) {
    break label$1
   }
   (wasm2js_i32$0 = ($2 << 2) + $0 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($2 | 0) * 6.283185307179586 / $3) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
  }
 }
 
 function FLAC__stream_encoder_new() {
  var $0 = 0, $1 = 0, $2 = 0, $3 = 0;
  $1 = dlcalloc(1, 8);
  if (!$1) {
   return 0
  }
  $0 = dlcalloc(1, 1032);
  HEAP32[$1 >> 2] = $0;
  label$2 : {
   if (!$0) {
    break label$2
   }
   $2 = dlcalloc(1, 11856);
   HEAP32[$1 + 4 >> 2] = $2;
   if (!$2) {
    dlfree($0);
    break label$2;
   }
   $0 = dlcalloc(1, 20);
   $2 = HEAP32[$1 + 4 >> 2];
   HEAP32[$2 + 6856 >> 2] = $0;
   if (!$0) {
    dlfree($2);
    dlfree(HEAP32[$1 >> 2]);
    break label$2;
   }
   HEAP32[$2 + 7296 >> 2] = 0;
   $0 = HEAP32[$1 >> 2];
   HEAP32[$0 + 44 >> 2] = 13;
   HEAP32[$0 + 48 >> 2] = 1056964608;
   HEAP32[$0 + 36 >> 2] = 0;
   HEAP32[$0 + 40 >> 2] = 1;
   HEAP32[$0 + 28 >> 2] = 16;
   HEAP32[$0 + 32 >> 2] = 44100;
   HEAP32[$0 + 20 >> 2] = 0;
   HEAP32[$0 + 24 >> 2] = 2;
   HEAP32[$0 + 12 >> 2] = 1;
   HEAP32[$0 + 16 >> 2] = 0;
   HEAP32[$0 + 4 >> 2] = 0;
   HEAP32[$0 + 8 >> 2] = 1;
   $0 = HEAP32[$1 >> 2];
   HEAP32[$0 + 592 >> 2] = 0;
   HEAP32[$0 + 596 >> 2] = 0;
   HEAP32[$0 + 556 >> 2] = 0;
   HEAP32[$0 + 560 >> 2] = 0;
   $2 = $0 + 564 | 0;
   HEAP32[$2 >> 2] = 0;
   HEAP32[$2 + 4 >> 2] = 0;
   $2 = $0 + 572 | 0;
   HEAP32[$2 >> 2] = 0;
   HEAP32[$2 + 4 >> 2] = 0;
   $2 = $0 + 580 | 0;
   HEAP32[$2 >> 2] = 0;
   HEAP32[$2 + 4 >> 2] = 0;
   $2 = $0 + 600 | 0;
   HEAP32[$2 >> 2] = 0;
   HEAP32[$2 + 4 >> 2] = 0;
   $2 = HEAP32[$1 + 4 >> 2];
   HEAP32[$2 + 7248 >> 2] = 0;
   HEAP32[$2 + 7252 >> 2] = 0;
   HEAP32[$2 + 7048 >> 2] = 0;
   $3 = $2 + 7256 | 0;
   HEAP32[$3 >> 2] = 0;
   HEAP32[$3 + 4 >> 2] = 0;
   $3 = $2 + 7264 | 0;
   HEAP32[$3 >> 2] = 0;
   HEAP32[$3 + 4 >> 2] = 0;
   $3 = $2 + 7272 | 0;
   HEAP32[$3 >> 2] = 0;
   HEAP32[$3 + 4 >> 2] = 0;
   $3 = $2 + 7280 | 0;
   HEAP32[$3 >> 2] = 0;
   HEAP32[$3 + 4 >> 2] = 0;
   HEAP32[$2 + 7288 >> 2] = 0;
   FLAC__ogg_encoder_aspect_set_defaults($0 + 632 | 0);
   $0 = HEAP32[$1 >> 2];
   label$5 : {
    if (HEAP32[$0 >> 2] != 1) {
     break label$5
    }
    HEAP32[$0 + 16 >> 2] = 1;
    HEAP32[$0 + 20 >> 2] = 0;
    FLAC__stream_encoder_set_apodization($1, 6467);
    $0 = HEAP32[$1 >> 2];
    if (HEAP32[$0 >> 2] != 1) {
     break label$5
    }
    HEAP32[$0 + 576 >> 2] = 0;
    HEAP32[$0 + 580 >> 2] = 5;
    HEAP32[$0 + 564 >> 2] = 0;
    HEAP32[$0 + 568 >> 2] = 0;
    HEAP32[$0 + 556 >> 2] = 8;
    HEAP32[$0 + 560 >> 2] = 0;
   }
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 11848 >> 2] = 0;
   HEAP32[$0 + 6176 >> 2] = $0 + 336;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6180 >> 2] = $0 + 628;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6184 >> 2] = $0 + 920;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6188 >> 2] = $0 + 1212;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6192 >> 2] = $0 + 1504;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6196 >> 2] = $0 + 1796;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6200 >> 2] = $0 + 2088;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6204 >> 2] = $0 + 2380;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6208 >> 2] = $0 + 2672;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6212 >> 2] = $0 + 2964;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6216 >> 2] = $0 + 3256;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6220 >> 2] = $0 + 3548;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6224 >> 2] = $0 + 3840;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6228 >> 2] = $0 + 4132;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6232 >> 2] = $0 + 4424;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6236 >> 2] = $0 + 4716;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6240 >> 2] = $0 + 5008;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6244 >> 2] = $0 + 5300;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6248 >> 2] = $0 + 5592;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6252 >> 2] = $0 + 5884;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6640 >> 2] = $0 + 6256;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6644 >> 2] = $0 + 6268;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6648 >> 2] = $0 + 6280;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6652 >> 2] = $0 + 6292;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6656 >> 2] = $0 + 6304;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6660 >> 2] = $0 + 6316;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6664 >> 2] = $0 + 6328;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6668 >> 2] = $0 + 6340;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6672 >> 2] = $0 + 6352;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6676 >> 2] = $0 + 6364;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6680 >> 2] = $0 + 6376;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6684 >> 2] = $0 + 6388;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6688 >> 2] = $0 + 6400;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6692 >> 2] = $0 + 6412;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6696 >> 2] = $0 + 6424;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6700 >> 2] = $0 + 6436;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6704 >> 2] = $0 + 6448;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6708 >> 2] = $0 + 6460;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6712 >> 2] = $0 + 6472;
   $0 = HEAP32[$1 + 4 >> 2];
   HEAP32[$0 + 6716 >> 2] = $0 + 6484;
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6256 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6268 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6280 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6292 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6304 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6316 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6328 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6340 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6352 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6364 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6376 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6388 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6400 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6412 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6424 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6436 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6448 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6460 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6472 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 6484 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 11724 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_init(HEAP32[$1 + 4 >> 2] + 11736 | 0);
   HEAP32[HEAP32[$1 >> 2] >> 2] = 1;
   return $1 | 0;
  }
  dlfree($1);
  return 0;
 }
 
 function FLAC__stream_encoder_set_apodization($0, $1) {
  var $2 = 0, $3 = 0, $4 = 0, $5 = Math_fround(0), $6 = 0, $7 = Math_fround(0), $8 = 0.0, $9 = Math_fround(0), $10 = 0, $11 = 0;
  $2 = HEAP32[$0 >> 2];
  label$1 : {
   if (HEAP32[$2 >> 2] != 1) {
    break label$1
   }
   HEAP32[$2 + 40 >> 2] = 0;
   while (1) {
    label$5 : {
     label$6 : {
      label$7 : {
       label$8 : {
        label$9 : {
         label$10 : {
          label$11 : {
           label$12 : {
            label$13 : {
             label$14 : {
              label$15 : {
               label$16 : {
                label$17 : {
                 label$18 : {
                  $10 = strchr($1, 59);
                  label$3 : {
                   if ($10) {
                    $4 = $10 - $1 | 0;
                    break label$3;
                   }
                   $4 = strlen($1);
                  }
                  $11 = ($4 | 0) != 8;
                  if (!$11) {
                   if (strncmp(5385, $1, 8)) {
                    break label$18
                   }
                   HEAP32[$2 + 40 >> 2] = $3 + 1;
                   HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 0;
                   break label$5;
                  }
                  label$20 : {
                   switch ($4 - 6 | 0) {
                   case 1:
                    break label$15;
                   case 0:
                    break label$16;
                   case 20:
                    break label$17;
                   case 7:
                    break label$20;
                   default:
                    break label$14;
                   };
                  }
                  $6 = 1;
                  if (strncmp(5812, $1, 13)) {
                   break label$13
                  }
                  HEAP32[$2 + 40 >> 2] = $3 + 1;
                  HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 1;
                  break label$5;
                 }
                 $6 = 0;
                 if (strncmp(5830, $1, 8)) {
                  break label$13
                 }
                 HEAP32[$2 + 40 >> 2] = $3 + 1;
                 HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 2;
                 break label$5;
                }
                $6 = 0;
                if (strncmp(5904, $1, 26)) {
                 break label$13
                }
                HEAP32[$2 + 40 >> 2] = $3 + 1;
                HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 3;
                break label$5;
               }
               if (strncmp(5445, $1, 6)) {
                break label$5
               }
               HEAP32[$2 + 40 >> 2] = $3 + 1;
               HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 4;
               break label$5;
              }
              if (strncmp(5804, $1, 7)) {
               break label$12
              }
              HEAP32[$2 + 40 >> 2] = $3 + 1;
              HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 5;
              break label$5;
             }
             $6 = 0;
             if ($4 >>> 0 < 8) {
              break label$11
             }
            }
            if (strncmp(6510, $1, 6)) {
             break label$10
            }
            $5 = Math_fround(strtod($1 + 6 | 0));
            if (!($5 > Math_fround(0.0)) | !($5 <= Math_fround(.5))) {
             break label$5
            }
            $1 = HEAP32[$0 >> 2];
            HEAPF32[((HEAP32[$1 + 40 >> 2] << 4) + $1 | 0) + 48 >> 2] = $5;
            $1 = HEAP32[$0 >> 2];
            $2 = HEAP32[$1 + 40 >> 2];
            HEAP32[$1 + 40 >> 2] = $2 + 1;
            HEAP32[($1 + ($2 << 4) | 0) + 44 >> 2] = 6;
            break label$5;
           }
           if (strncmp(5877, $1, 7)) {
            break label$9
           }
           HEAP32[$2 + 40 >> 2] = $3 + 1;
           HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 7;
           break label$5;
          }
          label$21 : {
           switch ($4 - 4 | 0) {
           case 0:
            break label$21;
           case 1:
            break label$7;
           default:
            break label$5;
           };
          }
          if (strncmp(5821, $1, 4)) {
           break label$5
          }
          HEAP32[$2 + 40 >> 2] = $3 + 1;
          HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 8;
          break label$5;
         }
         if (!$6) {
          break label$8
         }
         if (strncmp(5847, $1, 13)) {
          break label$8
         }
         HEAP32[$2 + 40 >> 2] = $3 + 1;
         HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 9;
         break label$5;
        }
        if (strncmp(5839, $1, 7)) {
         break label$5
        }
        HEAP32[$2 + 40 >> 2] = $3 + 1;
        HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 10;
        break label$5;
       }
       label$22 : {
        if (($4 | 0) != 9) {
         break label$22
        }
        if (strncmp(5885, $1, 9)) {
         break label$22
        }
        HEAP32[$2 + 40 >> 2] = $3 + 1;
        HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 11;
        break label$5;
       }
       if (!$11) {
        if (!strncmp(5895, $1, 8)) {
         HEAP32[$2 + 40 >> 2] = $3 + 1;
         HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 12;
         break label$5;
        }
        if (strncmp(6503, $1, 6)) {
         break label$5
        }
        break label$6;
       }
       if (!strncmp(6503, $1, 6)) {
        break label$6
       }
       if ($4 >>> 0 < 16) {
        break label$5
       }
       if (!strncmp(6495, $1, 14)) {
        $8 = strtod($1 + 14 | 0);
        label$26 : {
         if (Math_abs($8) < 2147483648.0) {
          $3 = ~~$8;
          break label$26;
         }
         $3 = -2147483648;
        }
        $2 = strchr($1, 47);
        $5 = Math_fround(.10000000149011612);
        label$28 : {
         if (!$2) {
          break label$28
         }
         $4 = $2 + 1 | 0;
         $5 = Math_fround(.9900000095367432);
         if (!(Math_fround(strtod($4)) < Math_fround(.9900000095367432))) {
          break label$28
         }
         $5 = Math_fround(strtod($4));
        }
        $1 = strchr($2 ? $2 + 1 | 0 : $1, 47);
        if ($1) {
         $7 = Math_fround(strtod($1 + 1 | 0))
        } else {
         $7 = Math_fround(.20000000298023224)
        }
        $1 = HEAP32[$0 >> 2];
        $2 = HEAP32[$1 + 40 >> 2];
        if (($3 | 0) <= 1) {
         HEAPF32[(($2 << 4) + $1 | 0) + 48 >> 2] = $7;
         $1 = HEAP32[$0 >> 2];
         $2 = HEAP32[$1 + 40 >> 2];
         HEAP32[$1 + 40 >> 2] = $2 + 1;
         HEAP32[($1 + ($2 << 4) | 0) + 44 >> 2] = 13;
         break label$5;
        }
        if ($2 + $3 >>> 0 > 31) {
         break label$5
        }
        $9 = Math_fround(Math_fround(Math_fround(1.0) / Math_fround(Math_fround(1.0) - $5)) + Math_fround(-1.0));
        $5 = Math_fround($9 + Math_fround($3 | 0));
        $4 = 0;
        while (1) {
         HEAPF32[(($2 << 4) + $1 | 0) + 48 >> 2] = $7;
         $1 = HEAP32[$0 >> 2];
         HEAPF32[((HEAP32[$1 + 40 >> 2] << 4) + $1 | 0) + 52 >> 2] = Math_fround($4 | 0) / $5;
         $1 = HEAP32[$0 >> 2];
         $4 = $4 + 1 | 0;
         HEAPF32[((HEAP32[$1 + 40 >> 2] << 4) + $1 | 0) + 56 >> 2] = Math_fround($9 + Math_fround($4 | 0)) / $5;
         $1 = HEAP32[$0 >> 2];
         $6 = HEAP32[$1 + 40 >> 2];
         $2 = $6 + 1 | 0;
         HEAP32[$1 + 40 >> 2] = $2;
         HEAP32[(($6 << 4) + $1 | 0) + 44 >> 2] = 14;
         if (($3 | 0) != ($4 | 0)) {
          continue
         }
         break;
        };
        break label$5;
       }
       if ($4 >>> 0 < 17) {
        break label$5
       }
       if (strncmp(6479, $1, 15)) {
        break label$5
       }
       $8 = strtod($1 + 15 | 0);
       label$34 : {
        if (Math_abs($8) < 2147483648.0) {
         $3 = ~~$8;
         break label$34;
        }
        $3 = -2147483648;
       }
       $7 = Math_fround(.20000000298023224);
       $2 = strchr($1, 47);
       $5 = Math_fround(.20000000298023224);
       label$36 : {
        if (!$2) {
         break label$36
        }
        $4 = $2 + 1 | 0;
        $5 = Math_fround(.9900000095367432);
        if (!(Math_fround(strtod($4)) < Math_fround(.9900000095367432))) {
         break label$36
        }
        $5 = Math_fround(strtod($4));
       }
       $1 = strchr($2 ? $2 + 1 | 0 : $1, 47);
       if ($1) {
        $7 = Math_fround(strtod($1 + 1 | 0))
       }
       $1 = HEAP32[$0 >> 2];
       $2 = HEAP32[$1 + 40 >> 2];
       if (($3 | 0) <= 1) {
        HEAPF32[(($2 << 4) + $1 | 0) + 48 >> 2] = $7;
        $1 = HEAP32[$0 >> 2];
        $2 = HEAP32[$1 + 40 >> 2];
        HEAP32[$1 + 40 >> 2] = $2 + 1;
        HEAP32[($1 + ($2 << 4) | 0) + 44 >> 2] = 13;
        break label$5;
       }
       if ($2 + $3 >>> 0 > 31) {
        break label$5
       }
       $9 = Math_fround(Math_fround(Math_fround(1.0) / Math_fround(Math_fround(1.0) - $5)) + Math_fround(-1.0));
       $5 = Math_fround($9 + Math_fround($3 | 0));
       $4 = 0;
       while (1) {
        HEAPF32[(($2 << 4) + $1 | 0) + 48 >> 2] = $7;
        $1 = HEAP32[$0 >> 2];
        HEAPF32[((HEAP32[$1 + 40 >> 2] << 4) + $1 | 0) + 52 >> 2] = Math_fround($4 | 0) / $5;
        $1 = HEAP32[$0 >> 2];
        $4 = $4 + 1 | 0;
        HEAPF32[((HEAP32[$1 + 40 >> 2] << 4) + $1 | 0) + 56 >> 2] = Math_fround($9 + Math_fround($4 | 0)) / $5;
        $1 = HEAP32[$0 >> 2];
        $6 = HEAP32[$1 + 40 >> 2];
        $2 = $6 + 1 | 0;
        HEAP32[$1 + 40 >> 2] = $2;
        HEAP32[(($6 << 4) + $1 | 0) + 44 >> 2] = 15;
        if (($3 | 0) != ($4 | 0)) {
         continue
        }
        break;
       };
       break label$5;
      }
      if (strncmp(5861, $1, 5)) {
       break label$5
      }
      HEAP32[$2 + 40 >> 2] = $3 + 1;
      HEAP32[(($3 << 4) + $2 | 0) + 44 >> 2] = 16;
      break label$5;
     }
     $5 = Math_fround(strtod($1 + 6 | 0));
     if (!($5 >= Math_fround(0.0)) | !($5 <= Math_fround(1.0))) {
      break label$5
     }
     $1 = HEAP32[$0 >> 2];
     HEAPF32[((HEAP32[$1 + 40 >> 2] << 4) + $1 | 0) + 48 >> 2] = $5;
     $1 = HEAP32[$0 >> 2];
     $2 = HEAP32[$1 + 40 >> 2];
     HEAP32[$1 + 40 >> 2] = $2 + 1;
     HEAP32[($1 + ($2 << 4) | 0) + 44 >> 2] = 13;
    }
    $2 = HEAP32[$0 >> 2];
    $3 = HEAP32[$2 + 40 >> 2];
    if (($3 | 0) != 32) {
     $1 = $10 + 1 | 0;
     if ($10) {
      continue
     }
    }
    break;
   };
   $4 = 1;
   if ($3) {
    break label$1
   }
   HEAP32[$2 + 40 >> 2] = 1;
   HEAP32[$2 + 44 >> 2] = 13;
   HEAP32[$2 + 48 >> 2] = 1056964608;
  }
  return $4;
 }
 
 function FLAC__stream_encoder_delete($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0;
  if ($0) {
   HEAP32[HEAP32[$0 + 4 >> 2] + 11848 >> 2] = 1;
   FLAC__stream_encoder_finish($0);
   $1 = HEAP32[$0 + 4 >> 2];
   $2 = HEAP32[$1 + 11752 >> 2];
   if ($2) {
    FLAC__stream_decoder_delete($2);
    $1 = HEAP32[$0 + 4 >> 2];
   }
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear($1 + 6256 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6268 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6280 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6292 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6304 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6316 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6328 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6340 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6352 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6364 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6376 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6388 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6400 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6412 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6424 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6436 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6448 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6460 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6472 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 6484 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 11724 | 0);
   FLAC__format_entropy_coding_method_partitioned_rice_contents_clear(HEAP32[$0 + 4 >> 2] + 11736 | 0);
   FLAC__bitreader_delete(HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2]);
   dlfree(HEAP32[$0 + 4 >> 2]);
   dlfree(HEAP32[$0 >> 2]);
   dlfree($0);
  }
 }
 
 function FLAC__stream_encoder_finish($0) {
  $0 = $0 | 0;
  var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0;
  $8 = __stack_pointer - 16 | 0;
  __stack_pointer = $8;
  label$1 : {
   if (!$0) {
    break label$1
   }
   label$3 : {
    label$4 : {
     $1 = HEAP32[$0 >> 2];
     $3 = HEAP32[$1 >> 2];
     switch ($3 | 0) {
     case 1:
      break label$1;
     case 0:
      break label$4;
     default:
      break label$3;
     };
    }
    $2 = HEAP32[$0 + 4 >> 2];
    if (HEAP32[$2 + 11848 >> 2]) {
     break label$3
    }
    $2 = HEAP32[$2 + 7052 >> 2];
    if (!$2) {
     break label$3
    }
    $4 = HEAP32[$1 + 36 >> 2];
    HEAP32[$1 + 36 >> 2] = $2;
    $4 = !process_frame_($0, ($2 | 0) != ($4 | 0), 1);
    $1 = HEAP32[$0 >> 2];
   }
   if (HEAP32[$1 + 12 >> 2]) {
    $2 = HEAP32[$0 + 4 >> 2];
    FLAC__MD5Final($2 + 6928 | 0, $2 + 7060 | 0);
   }
   $6 = $0 + 4 | 0;
   $1 = HEAP32[$0 + 4 >> 2];
   label$6 : {
    if (HEAP32[$1 + 11848 >> 2]) {
     $2 = $4;
     break label$6;
    }
    $5 = HEAP32[$0 >> 2];
    label$8 : {
     if (HEAP32[$5 >> 2]) {
      break label$8
     }
     $2 = HEAP32[$1 + 7268 >> 2];
     if ($2) {
      label$10 : {
       if (HEAP32[$1 + 7260 >> 2]) {
        $10 = HEAP32[$1 + 6900 >> 2];
        $11 = HEAP32[$1 + 6896 >> 2];
        $3 = $1 + 6920 | 0;
        $5 = HEAP32[$3 >> 2];
        $7 = HEAP32[$3 + 4 >> 2];
        if ((FUNCTION_TABLE[$2 | 0]($0, 0, 0, HEAP32[$1 + 7288 >> 2]) | 0) == 2) {
         break label$10
        }
        simple_ogg_page__init($8);
        $2 = HEAP32[$0 >> 2];
        $3 = HEAP32[$2 + 608 >> 2];
        $9 = HEAP32[$2 + 612 >> 2];
        $2 = HEAP32[$0 + 4 >> 2];
        label$12 : {
         if (!simple_ogg_page__get_at($0, $3, $9, $8, HEAP32[$2 + 7268 >> 2], HEAP32[$2 + 7264 >> 2], HEAP32[$2 + 7288 >> 2])) {
          break label$12
         }
         $12 = HEAP32[1634] + HEAP32[1633] | 0;
         $13 = HEAP32[1639] + (HEAP32[1638] + (HEAP32[1637] + (HEAP32[1636] + ($12 + HEAP32[1635] | 0) | 0) | 0) | 0) | 0;
         $3 = $13 + HEAP32[1640] >>> 3 | 0;
         if (HEAPU32[$8 + 12 >> 2] < $3 + 33 >>> 0) {
          HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
          simple_ogg_page__clear($8);
          break label$10;
         }
         $2 = $1 + 6936 | 0;
         $9 = HEAPU8[$2 + 4 | 0] | HEAPU8[$2 + 5 | 0] << 8 | (HEAPU8[$2 + 6 | 0] << 16 | HEAPU8[$2 + 7 | 0] << 24);
         $14 = $3 + HEAP32[$8 + 8 >> 2] | 0;
         $3 = $14 + 25 | 0;
         $2 = HEAPU8[$2 | 0] | HEAPU8[$2 + 1 | 0] << 8 | (HEAPU8[$2 + 2 | 0] << 16 | HEAPU8[$2 + 3 | 0] << 24);
         HEAP8[$3 | 0] = $2;
         HEAP8[$3 + 1 | 0] = $2 >>> 8;
         HEAP8[$3 + 2 | 0] = $2 >>> 16;
         HEAP8[$3 + 3 | 0] = $2 >>> 24;
         HEAP8[$3 + 4 | 0] = $9;
         HEAP8[$3 + 5 | 0] = $9 >>> 8;
         HEAP8[$3 + 6 | 0] = $9 >>> 16;
         HEAP8[$3 + 7 | 0] = $9 >>> 24;
         $2 = $1 + 6928 | 0;
         $3 = HEAPU8[$2 + 4 | 0] | HEAPU8[$2 + 5 | 0] << 8 | (HEAPU8[$2 + 6 | 0] << 16 | HEAPU8[$2 + 7 | 0] << 24);
         $1 = $14 + 17 | 0;
         $2 = HEAPU8[$2 | 0] | HEAPU8[$2 + 1 | 0] << 8 | (HEAPU8[$2 + 2 | 0] << 16 | HEAPU8[$2 + 3 | 0] << 24);
         HEAP8[$1 | 0] = $2;
         HEAP8[$1 + 1 | 0] = $2 >>> 8;
         HEAP8[$1 + 2 | 0] = $2 >>> 16;
         HEAP8[$1 + 3 | 0] = $2 >>> 24;
         HEAP8[$1 + 4 | 0] = $3;
         HEAP8[$1 + 5 | 0] = $3 >>> 8;
         HEAP8[$1 + 6 | 0] = $3 >>> 16;
         HEAP8[$1 + 7 | 0] = $3 >>> 24;
         $2 = $13 - 4 >>> 3 | 0;
         if (HEAPU32[$8 + 12 >> 2] < $2 + 22 >>> 0) {
          HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
          simple_ogg_page__clear($8);
          break label$10;
         }
         $2 = $2 + HEAP32[$8 + 8 >> 2] | 0;
         HEAP8[$2 + 21 | 0] = $5;
         HEAP8[$2 + 20 | 0] = ($7 & 255) << 24 | $5 >>> 8;
         HEAP8[$2 + 19 | 0] = ($7 & 65535) << 16 | $5 >>> 16;
         HEAP8[$2 + 18 | 0] = ($7 & 16777215) << 8 | $5 >>> 24;
         $2 = $2 + 17 | 0;
         HEAP8[$2 | 0] = HEAPU8[$2 | 0] & 240 | $7 & 15;
         $2 = $12 >>> 3 | 0;
         if (HEAPU32[$8 + 12 >> 2] < $2 + 23 >>> 0) {
          HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
          simple_ogg_page__clear($8);
          break label$10;
         }
         $2 = $2 + HEAP32[$8 + 8 >> 2] | 0;
         HEAP8[$2 + 22 | 0] = $10;
         HEAP8[$2 + 21 | 0] = $10 >>> 8;
         HEAP8[$2 + 20 | 0] = $10 >>> 16;
         HEAP8[$2 + 19 | 0] = $11;
         HEAP8[$2 + 18 | 0] = $11 >>> 8;
         HEAP8[$2 + 17 | 0] = $11 >>> 16;
         $2 = HEAP32[$0 >> 2];
         $1 = HEAP32[$2 + 608 >> 2];
         $3 = HEAP32[$2 + 612 >> 2];
         $2 = HEAP32[$0 + 4 >> 2];
         $2 = simple_ogg_page__set_at($0, $1, $3, $8, HEAP32[$2 + 7268 >> 2], HEAP32[$2 + 7276 >> 2], HEAP32[$2 + 7288 >> 2]);
         simple_ogg_page__clear($8);
         if (!$2) {
          break label$10
         }
         $2 = HEAP32[HEAP32[$6 >> 2] + 7048 >> 2];
         if (!$2 | !HEAP32[$2 >> 2]) {
          break label$10
         }
         $1 = HEAP32[$0 >> 2];
         if (!(HEAP32[$1 + 616 >> 2] | HEAP32[$1 + 620 >> 2])) {
          break label$10
         }
         FLAC__format_seektable_sort($2);
         simple_ogg_page__init($8);
         $2 = HEAP32[$0 >> 2];
         $1 = HEAP32[$2 + 616 >> 2];
         $3 = HEAP32[$2 + 620 >> 2];
         $2 = HEAP32[$0 + 4 >> 2];
         if (!simple_ogg_page__get_at($0, $1, $3, $8, HEAP32[$2 + 7268 >> 2], HEAP32[$2 + 7264 >> 2], HEAP32[$2 + 7288 >> 2])) {
          break label$12
         }
         $2 = HEAP32[$6 >> 2];
         $3 = HEAP32[$2 + 7048 >> 2];
         $1 = HEAP32[$3 >> 2];
         if (HEAP32[$8 + 12 >> 2] != (Math_imul($1, 18) + 4 | 0)) {
          HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
          simple_ogg_page__clear($8);
          break label$10;
         }
         if ($1) {
          $1 = HEAP32[$8 + 8 >> 2] + 4 | 0;
          $5 = 0;
          while (1) {
           $7 = HEAP32[$3 + 4 >> 2] + Math_imul($5, 24) | 0;
           $9 = HEAP32[$7 >> 2];
           $2 = HEAP32[$7 + 4 >> 2];
           $10 = HEAP32[$7 + 8 >> 2];
           $3 = HEAP32[$7 + 12 >> 2];
           $7 = HEAP32[$7 + 16 >> 2];
           HEAP8[$1 + 17 | 0] = $7;
           HEAP8[$1 + 15 | 0] = $10;
           HEAP8[$1 + 7 | 0] = $9;
           HEAP8[$1 + 16 | 0] = $7 >>> 8;
           HEAP8[$1 + 14 | 0] = ($3 & 255) << 24 | $10 >>> 8;
           HEAP8[$1 + 13 | 0] = ($3 & 65535) << 16 | $10 >>> 16;
           HEAP8[$1 + 12 | 0] = ($3 & 16777215) << 8 | $10 >>> 24;
           HEAP8[$1 + 11 | 0] = $3;
           HEAP8[$1 + 10 | 0] = $3 >>> 8;
           HEAP8[$1 + 9 | 0] = $3 >>> 16;
           HEAP8[$1 + 8 | 0] = $3 >>> 24;
           HEAP8[$1 + 6 | 0] = ($2 & 255) << 24 | $9 >>> 8;
           HEAP8[$1 + 5 | 0] = ($2 & 65535) << 16 | $9 >>> 16;
           HEAP8[$1 + 4 | 0] = ($2 & 16777215) << 8 | $9 >>> 24;
           HEAP8[$1 + 3 | 0] = $2;
           HEAP8[$1 + 2 | 0] = $2 >>> 8;
           HEAP8[$1 + 1 | 0] = $2 >>> 16;
           HEAP8[$1 | 0] = $2 >>> 24;
           $1 = $1 + 18 | 0;
           $5 = $5 + 1 | 0;
           $2 = HEAP32[$6 >> 2];
           $3 = HEAP32[$2 + 7048 >> 2];
           if ($5 >>> 0 < HEAPU32[$3 >> 2]) {
            continue
           }
           break;
          };
         }
         $1 = HEAP32[$0 >> 2];
         simple_ogg_page__set_at($0, HEAP32[$1 + 616 >> 2], HEAP32[$1 + 620 >> 2], $8, HEAP32[$2 + 7268 >> 2], HEAP32[$2 + 7276 >> 2], HEAP32[$2 + 7288 >> 2]);
        }
        simple_ogg_page__clear($8);
        break label$10;
       }
       $1 = __stack_pointer - 32 | 0;
       __stack_pointer = $1;
       $2 = $0;
       $3 = HEAP32[$2 + 4 >> 2];
       $11 = HEAP32[$3 + 6912 >> 2];
       $9 = HEAP32[$3 + 6900 >> 2];
       $10 = HEAP32[$3 + 6896 >> 2];
       $7 = $3 + 6920 | 0;
       $5 = HEAP32[$7 >> 2];
       $7 = HEAP32[$7 + 4 >> 2];
       label$11 : {
        label$2 : {
         label$32 : {
          $12 = HEAP32[1634] + HEAP32[1633] | 0;
          $13 = HEAP32[1639] + (HEAP32[1638] + (HEAP32[1637] + (HEAP32[1636] + ($12 + HEAP32[1635] | 0) | 0) | 0) | 0) | 0;
          $14 = ($13 + HEAP32[1640] >>> 3 | 0) + 4 | 0;
          $15 = HEAP32[$2 >> 2];
          $16 = $14 + HEAP32[$15 + 608 >> 2] | 0;
          $15 = HEAP32[$15 + 612 >> 2];
          switch (FUNCTION_TABLE[HEAP32[$3 + 7268 >> 2]]($2, $16, $14 >>> 0 > $16 >>> 0 ? $15 + 1 | 0 : $15, HEAP32[$3 + 7288 >> 2]) | 0) {
          case 1:
           break label$2;
          case 0:
           break label$32;
          default:
           break label$11;
          };
         }
         $14 = $3 + 6928 | 0;
         $3 = HEAP32[$2 + 4 >> 2];
         if (FUNCTION_TABLE[HEAP32[$3 + 7276 >> 2]]($2, $14, 16, 0, 0, HEAP32[$3 + 7288 >> 2]) | 0) {
          break label$2
         }
         HEAP8[$1 + 4 | 0] = $5;
         HEAP8[$1 + 3 | 0] = ($7 & 255) << 24 | $5 >>> 8;
         HEAP8[$1 + 2 | 0] = ($7 & 65535) << 16 | $5 >>> 16;
         HEAP8[$1 + 1 | 0] = ($7 & 16777215) << 8 | $5 >>> 24;
         HEAP8[$1 | 0] = ($7 & 15 | $11 << 4) + 240;
         label$43 : {
          $3 = ($13 - 4 >>> 3 | 0) + 4 | 0;
          $5 = HEAP32[$2 >> 2];
          $7 = $3 + HEAP32[$5 + 608 >> 2] | 0;
          $5 = HEAP32[$5 + 612 >> 2];
          $5 = $3 >>> 0 > $7 >>> 0 ? $5 + 1 | 0 : $5;
          $3 = HEAP32[$2 + 4 >> 2];
          switch (FUNCTION_TABLE[HEAP32[$3 + 7268 >> 2]]($2, $7, $5, HEAP32[$3 + 7288 >> 2]) | 0) {
          case 1:
           break label$2;
          case 0:
           break label$43;
          default:
           break label$11;
          };
         }
         $3 = HEAP32[$2 + 4 >> 2];
         if (FUNCTION_TABLE[HEAP32[$3 + 7276 >> 2]]($2, $1, 5, 0, 0, HEAP32[$3 + 7288 >> 2]) | 0) {
          break label$2
         }
         HEAP8[$1 + 5 | 0] = $9;
         HEAP8[$1 + 4 | 0] = $9 >>> 8;
         HEAP8[$1 + 3 | 0] = $9 >>> 16;
         HEAP8[$1 + 2 | 0] = $10;
         HEAP8[$1 + 1 | 0] = $10 >>> 8;
         HEAP8[$1 | 0] = $10 >>> 16;
         label$5 : {
          $3 = ($12 >>> 3 | 0) + 4 | 0;
          $5 = HEAP32[$2 >> 2];
          $7 = $3 + HEAP32[$5 + 608 >> 2] | 0;
          $5 = HEAP32[$5 + 612 >> 2];
          $5 = $3 >>> 0 > $7 >>> 0 ? $5 + 1 | 0 : $5;
          $3 = HEAP32[$2 + 4 >> 2];
          switch (FUNCTION_TABLE[HEAP32[$3 + 7268 >> 2]]($2, $7, $5, HEAP32[$3 + 7288 >> 2]) | 0) {
          case 1:
           break label$2;
          case 0:
           break label$5;
          default:
           break label$11;
          };
         }
         $3 = HEAP32[$2 + 4 >> 2];
         if (FUNCTION_TABLE[HEAP32[$3 + 7276 >> 2]]($2, $1, 6, 0, 0, HEAP32[$3 + 7288 >> 2]) | 0) {
          break label$2
         }
         $3 = HEAP32[HEAP32[$2 + 4 >> 2] + 7048 >> 2];
         if (!$3 | !HEAP32[$3 >> 2]) {
          break label$11
         }
         $5 = HEAP32[$2 >> 2];
         if (!(HEAP32[$5 + 616 >> 2] | HEAP32[$5 + 620 >> 2])) {
          break label$11
         }
         FLAC__format_seektable_sort($3);
         label$64 : {
          $3 = HEAP32[$2 >> 2];
          $5 = HEAP32[$3 + 616 >> 2] + 4 | 0;
          $3 = HEAP32[$3 + 620 >> 2];
          $7 = $5 >>> 0 < 4 ? $3 + 1 | 0 : $3;
          $3 = HEAP32[$2 + 4 >> 2];
          switch (FUNCTION_TABLE[HEAP32[$3 + 7268 >> 2]]($2, $5, $7, HEAP32[$3 + 7288 >> 2]) | 0) {
          case 1:
           break label$2;
          case 0:
           break label$64;
          default:
           break label$11;
          };
         }
         $9 = HEAP32[$2 + 4 >> 2];
         $7 = HEAP32[$9 + 7048 >> 2];
         if (!HEAP32[$7 >> 2]) {
          break label$11
         }
         $10 = 0;
         while (1) {
          $11 = Math_imul($10, 24);
          $5 = $11 + HEAP32[$7 + 4 >> 2] | 0;
          $3 = HEAP32[$5 + 4 >> 2];
          $5 = HEAP32[$5 >> 2];
          $12 = $5 << 24 | $5 << 8 & 16711680;
          $13 = $5 >>> 8 | 0;
          $5 = $5 >>> 24 | 0;
          HEAP32[$1 >> 2] = ($13 | ($3 & 255) << 24) & -16777216 | ($5 | ($3 & 16777215) << 8) & 16711680 | ($3 >>> 8 & 65280 | $3 >>> 24);
          HEAP32[$1 + 4 >> 2] = $12 | (($13 | $3 << 24) & 65280 | ($5 | $3 << 8) & 255);
          $5 = $11 + HEAP32[$7 + 4 >> 2] | 0;
          $3 = HEAP32[$5 + 12 >> 2];
          $5 = HEAP32[$5 + 8 >> 2];
          $12 = $5 << 24 | $5 << 8 & 16711680;
          HEAP32[$1 + 8 >> 2] = (($3 & 255) << 24 | $5 >>> 8) & -16777216 | (($3 & 16777215) << 8 | $5 >>> 24) & 16711680 | ($3 >>> 8 & 65280 | $3 >>> 24);
          HEAP32[$1 + 12 >> 2] = ($3 << 24 | $5 >>> 8) & 65280 | ($3 << 8 | $5 >>> 24) & 255 | $12;
          $3 = HEAPU16[($11 + HEAP32[$7 + 4 >> 2] | 0) + 16 >> 1];
          HEAP16[$1 + 16 >> 1] = $3 << 8 | $3 >>> 8;
          if (FUNCTION_TABLE[HEAP32[$9 + 7276 >> 2]]($2, $1, 18, 0, 0, HEAP32[$9 + 7288 >> 2]) | 0) {
           break label$2
          }
          $10 = $10 + 1 | 0;
          $9 = HEAP32[$2 + 4 >> 2];
          $7 = HEAP32[$9 + 7048 >> 2];
          if ($10 >>> 0 < HEAPU32[$7 >> 2]) {
           continue
          }
          break;
         };
         break label$11;
        }
        HEAP32[HEAP32[$2 >> 2] >> 2] = 5;
       }
       __stack_pointer = $1 + 32 | 0;
      }
      $1 = HEAP32[$0 + 4 >> 2];
      $5 = HEAP32[$0 >> 2];
      $4 = HEAP32[$5 >> 2] ? 1 : $4;
     }
     $2 = HEAP32[$1 + 7280 >> 2];
     if (!$2) {
      break label$8
     }
     FUNCTION_TABLE[$2 | 0]($0, $1 + 6872 | 0, HEAP32[$1 + 7288 >> 2]);
     $5 = HEAP32[$0 >> 2];
    }
    if (!HEAP32[$5 + 4 >> 2]) {
     $2 = $4;
     break label$6;
    }
    $2 = HEAP32[HEAP32[$6 >> 2] + 11752 >> 2];
    if (!$2) {
     $2 = $4;
     break label$6;
    }
    if (FLAC__stream_decoder_finish($2)) {
     $2 = $4;
     break label$6;
    }
    $2 = 1;
    if ($4) {
     break label$6
    }
    HEAP32[HEAP32[$0 >> 2] >> 2] = 4;
   }
   $1 = HEAP32[$6 >> 2];
   $4 = HEAP32[$1 + 7296 >> 2];
   if ($4) {
    if (HEAP32[1967] != ($4 | 0)) {
     fclose($4);
     $1 = HEAP32[$6 >> 2];
    }
    HEAP32[$1 + 7296 >> 2] = 0;
   }
   if (HEAP32[$1 + 7260 >> 2]) {
    ogg_stream_clear(HEAP32[$0 >> 2] + 640 | 0)
   }
   $1 = HEAP32[$0 >> 2];
   $4 = HEAP32[$1 + 600 >> 2];
   if ($4) {
    dlfree($4);
    $1 = HEAP32[$0 >> 2];
    HEAP32[$1 + 600 >> 2] = 0;
    HEAP32[$1 + 604 >> 2] = 0;
   }
   if (HEAP32[$1 + 24 >> 2]) {
    $4 = 0;
    while (1) {
     $3 = HEAP32[$6 >> 2];
     $1 = $4 << 2;
     $5 = HEAP32[($3 + $1 | 0) + 7328 >> 2];
     if ($5) {
      dlfree($5);
      HEAP32[($1 + HEAP32[$6 >> 2] | 0) + 7328 >> 2] = 0;
      $3 = HEAP32[$6 >> 2];
     }
     $3 = HEAP32[($3 + $1 | 0) + 7368 >> 2];
     if ($3) {
      dlfree($3);
      HEAP32[($1 + HEAP32[$6 >> 2] | 0) + 7368 >> 2] = 0;
     }
     $4 = $4 + 1 | 0;
     if ($4 >>> 0 < HEAPU32[HEAP32[$0 >> 2] + 24 >> 2]) {
      continue
     }
     break;
    };
   }
   $1 = HEAP32[$6 >> 2];
   $4 = HEAP32[$1 + 7360 >> 2];
   if ($4) {
    dlfree($4);
    HEAP32[HEAP32[$6 >> 2] + 7360 >> 2] = 0;
    $1 = HEAP32[$6 >> 2];
   }
   $4 = HEAP32[$1 + 7400 >> 2];
   if ($4) {
    dlfree($4);
    HEAP32[HEAP32[$6 >> 2] + 7400 >> 2] = 0;
    $1 = HEAP32[$6 >> 2];
   }
   $4 = HEAP32[$1 + 7364 >> 2];
   if ($4) {
    dlfree($4);
    HEAP32[HEAP32[$6 >> 2] + 7364 >> 2] = 0;
    $1 = HEAP32[$6 >> 2];
   }
   $4 = HEAP32[$1 + 7404 >> 2];
   if ($4) {
    dlfree($4);
    HEAP32[HEAP32[$6 >> 2] + 7404 >> 2] = 0;
   }
   $4 = HEAP32[$0 >> 2];
   if (HEAP32[$4 + 40 >> 2]) {
    $1 = 0;
    while (1) {
     $3 = $1 << 2;
     $5 = HEAP32[($3 + HEAP32[$6 >> 2] | 0) + 7408 >> 2];
     if ($5) {
      dlfree($5);
      HEAP32[($3 + HEAP32[$0 + 4 >> 2] | 0) + 7408 >> 2] = 0;
      $4 = HEAP32[$0 >> 2];
     }
     $1 = $1 + 1 | 0;
     if ($1 >>> 0 < HEAPU32[$4 + 40 >> 2]) {
      continue
     }
     break;
    };
   }
   $1 = HEAP32[$6 >> 2];
   $3 = HEAP32[$1 + 7536 >> 2];
   if ($3) {
    dlfree($3);
    $1 = HEAP32[$0 + 4 >> 2];
    HEAP32[$1 + 7536 >> 2] = 0;
    $4 = HEAP32[$0 >> 2];
   }
   if (HEAP32[$4 + 24 >> 2]) {
    $5 = 0;
    while (1) {
     $4 = $5 << 3;
     $3 = HEAP32[($4 + $1 | 0) + 7540 >> 2];
     if ($3) {
      dlfree($3);
      HEAP32[($4 + HEAP32[$6 >> 2] | 0) + 7540 >> 2] = 0;
      $1 = HEAP32[$6 >> 2];
     }
     $3 = HEAP32[($1 + $4 | 0) + 7544 >> 2];
     if ($3) {
      dlfree($3);
      HEAP32[($4 + HEAP32[$6 >> 2] | 0) + 7544 >> 2] = 0;
      $1 = HEAP32[$6 >> 2];
     }
     $5 = $5 + 1 | 0;
     if ($5 >>> 0 < HEAPU32[HEAP32[$0 >> 2] + 24 >> 2]) {
      continue
     }
     break;
    };
   }
   $4 = HEAP32[$1 + 7604 >> 2];
   if ($4) {
    dlfree($4);
    HEAP32[HEAP32[$6 >> 2] + 7604 >> 2] = 0;
    $1 = HEAP32[$6 >> 2];
   }
   $4 = HEAP32[$1 + 7608 >> 2];
   if ($4) {
    dlfree($4);
    HEAP32[HEAP32[$6 >> 2] + 7608 >> 2] = 0;
    $1 = HEAP32[$6 >> 2];
   }
   $4 = HEAP32[$1 + 7612 >> 2];
   if ($4) {
    dlfree($4);
    HEAP32[HEAP32[$6 >> 2] + 7612 >> 2] = 0;
    $1 = HEAP32[$6 >> 2];
   }
   $4 = HEAP32[$1 + 7616 >> 2];
   if ($4) {
    dlfree($4);
    HEAP32[HEAP32[$6 >> 2] + 7616 >> 2] = 0;
    $1 = HEAP32[$6 >> 2];
   }
   $4 = HEAP32[$1 + 7620 >> 2];
   if ($4) {
    dlfree($4);
    $1 = HEAP32[$6 >> 2];
    HEAP32[$1 + 7620 >> 2] = 0;
   }
   $4 = HEAP32[$1 + 7624 >> 2];
   if ($4) {
    dlfree($4);
    $1 = HEAP32[$6 >> 2];
    HEAP32[$1 + 7624 >> 2] = 0;
   }
   $4 = HEAP32[$0 >> 2];
   if (!(!HEAP32[$4 + 4 >> 2] | !HEAP32[$4 + 24 >> 2])) {
    $3 = 0;
    while (1) {
     $6 = $3 << 2;
     $5 = HEAP32[($6 + $1 | 0) + 11764 >> 2];
     if ($5) {
      dlfree($5);
      HEAP32[($6 + HEAP32[$0 + 4 >> 2] | 0) + 11764 >> 2] = 0;
      $1 = HEAP32[$0 + 4 >> 2];
      $4 = HEAP32[$0 >> 2];
     }
     $3 = $3 + 1 | 0;
     if ($3 >>> 0 < HEAPU32[$4 + 24 >> 2]) {
      continue
     }
     break;
    };
   }
   $4 = HEAP32[$1 + 6856 >> 2];
   $1 = HEAP32[$4 >> 2];
   if ($1) {
    dlfree($1)
   }
   HEAP32[$4 + 16 >> 2] = 0;
   HEAP32[$4 >> 2] = 0;
   HEAP32[$4 + 8 >> 2] = 0;
   HEAP32[$4 + 12 >> 2] = 0;
   $4 = HEAP32[$0 >> 2];
   HEAP32[$4 + 44 >> 2] = 13;
   HEAP32[$4 + 48 >> 2] = 1056964608;
   HEAP32[$4 + 36 >> 2] = 0;
   HEAP32[$4 + 40 >> 2] = 1;
   HEAP32[$4 + 28 >> 2] = 16;
   HEAP32[$4 + 32 >> 2] = 44100;
   HEAP32[$4 + 20 >> 2] = 0;
   HEAP32[$4 + 24 >> 2] = 2;
   HEAP32[$4 + 12 >> 2] = 1;
   HEAP32[$4 + 16 >> 2] = 0;
   HEAP32[$4 + 4 >> 2] = 0;
   HEAP32[$4 + 8 >> 2] = 1;
   $4 = HEAP32[$0 >> 2];
   $1 = $4;
   HEAP32[$1 + 592 >> 2] = 0;
   HEAP32[$1 + 596 >> 2] = 0;
   HEAP32[$1 + 556 >> 2] = 0;
   HEAP32[$1 + 560 >> 2] = 0;
   $1 = $1 + 564 | 0;
   HEAP32[$1 >> 2] = 0;
   HEAP32[$1 + 4 >> 2] = 0;
   $1 = $4 + 572 | 0;
   HEAP32[$1 >> 2] = 0;
   HEAP32[$1 + 4 >> 2] = 0;
   $1 = $4 + 580 | 0;
   HEAP32[$1 >> 2] = 0;
   HEAP32[$1 + 4 >> 2] = 0;
   $1 = $4 + 600 | 0;
   HEAP32[$1 >> 2] = 0;
   HEAP32[$1 + 4 >> 2] = 0;
   $1 = HEAP32[$0 + 4 >> 2];
   HEAP32[$1 + 7248 >> 2] = 0;
   HEAP32[$1 + 7252 >> 2] = 0;
   HEAP32[$1 + 7048 >> 2] = 0;
   $6 = $1 + 7256 | 0;
   HEAP32[$6 >> 2] = 0;
   HEAP32[$6 + 4 >> 2] = 0;
   $6 = $1 + 7264 | 0;
   HEAP32[$6 >> 2] = 0;
   HEAP32[$6 + 4 >> 2] = 0;
   $6 = $1 + 7272 | 0;
   HEAP32[$6 >> 2] = 0;
   HEAP32[$6 + 4 >> 2] = 0;
   $6 = $1 + 7280 | 0;
   HEAP32[$6 >> 2] = 0;
   HEAP32[$6 + 4 >> 2] = 0;
   HEAP32[$1 + 7288 >> 2] = 0;
   FLAC__ogg_encoder_aspect_set_defaults($4 + 632 | 0);
   $3 = HEAP32[$0 >> 2];
   label$51 : {
    if (HEAP32[$3 >> 2] != 1) {
     break label$51
    }
    HEAP32[$3 + 16 >> 2] = 1;
    HEAP32[$3 + 20 >> 2] = 0;
    FLAC__stream_encoder_set_apodization($0, 6467);
    $3 = HEAP32[$0 >> 2];
    if (HEAP32[$3 >> 2] != 1) {
     break label$51
    }
    HEAP32[$3 + 576 >> 2] = 0;
    HEAP32[$3 + 580 >> 2] = 5;
    HEAP32[$3 + 564 >> 2] = 0;
    HEAP32[$3 + 568 >> 2] = 0;
    HEAP32[$3 + 556 >> 2] = 8;
    HEAP32[$3 + 560 >> 2] = 0;
   }
   if (!$2) {
    HEAP32[$3 >> 2] = 1
   }
   $3 = !$2;
  }
  __stack_pointer = $8 + 16 | 0;
  return $3 | 0;
 }
 
 function process_frame_($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0;
  $11 = __stack_pointer - 48 | 0;
  __stack_pointer = $11;
  label$1 : {
   label$2 : {
    $9 = HEAP32[$0 >> 2];
    if (!HEAP32[$9 + 12 >> 2]) {
     break label$2
    }
    $4 = HEAP32[$0 + 4 >> 2];
    $4 = FLAC__MD5Accumulate($4 + 7060 | 0, $4 + 4 | 0, HEAP32[$9 + 24 >> 2], HEAP32[$9 + 36 >> 2], HEAP32[$9 + 28 >> 2] + 7 >>> 3 | 0);
    $9 = HEAP32[$0 >> 2];
    if ($4) {
     break label$2
    }
    HEAP32[$9 >> 2] = 8;
    $1 = 0;
    break label$1;
   }
   $16 = HEAP32[$9 + 576 >> 2];
   if ($1) {
    $14 = 0
   } else {
    $4 = HEAP32[$9 + 36 >> 2];
    label$10 : {
     if (!($4 & 1)) {
      while (1) {
       $3 = $3 + 1 | 0;
       $1 = $4 & 2;
       $4 = $4 >>> 1 | 0;
       if (!$1) {
        continue
       }
       break;
      };
      $4 = 15;
      if ($3 >>> 0 > 14) {
       break label$10
      }
     }
     $4 = $3;
    }
    $9 = HEAP32[$0 >> 2];
    $1 = HEAP32[$9 + 580 >> 2];
    $14 = $1 >>> 0 > $4 >>> 0 ? $4 : $1;
   }
   $8 = HEAP32[$9 + 36 >> 2];
   HEAP32[$11 + 8 >> 2] = $8;
   HEAP32[$11 + 12 >> 2] = HEAP32[$9 + 32 >> 2];
   $1 = HEAP32[$9 + 24 >> 2];
   HEAP32[$11 + 20 >> 2] = 0;
   HEAP32[$11 + 16 >> 2] = $1;
   $1 = HEAP32[$9 + 28 >> 2];
   HEAP32[$11 + 28 >> 2] = 0;
   HEAP32[$11 + 24 >> 2] = $1;
   $10 = HEAP32[$0 + 4 >> 2];
   HEAP32[$11 + 32 >> 2] = HEAP32[$10 + 7056 >> 2];
   label$5 : {
    label$6 : {
     if (!HEAP32[$9 + 16 >> 2]) {
      break label$6
     }
     $15 = 1;
     if (!HEAP32[$9 + 20 >> 2] | !HEAP32[$10 + 6864 >> 2]) {
      break label$6
     }
     $1 = HEAP32[$10 + 6868 >> 2];
     $15 = ($1 | 0) != 0;
     $3 = 1;
     if ($1) {
      break label$5
     }
    }
    $3 = 0;
    if (!HEAP32[$9 + 24 >> 2]) {
     break label$5
    }
    while (1) {
     $6 = ($13 << 2) + $10 | 0;
     $4 = 0;
     label$8 : {
      if (!$8) {
       break label$8
      }
      $12 = HEAP32[$6 + 4 >> 2];
      $1 = 0;
      $3 = 0;
      while (1) {
       label$9 : {
        $1 = HEAP32[$12 + ($3 << 2) >> 2] | $1;
        $5 = $1 & 1;
        $3 = $3 + 1 | 0;
        if ($8 >>> 0 <= $3 >>> 0) {
         break label$9
        }
        if (!$5) {
         continue
        }
       }
       break;
      };
      if (!$1) {
       break label$8
      }
      $3 = 0;
      if ($5) {
       break label$8
      }
      while (1) {
       $3 = $3 + 1 | 0;
       $5 = $1 & 2;
       $1 = $1 >> 1;
       if (!$5) {
        continue
       }
       break;
      };
      if (!$3) {
       break label$8
      }
      $4 = $8 & 3;
      $1 = 0;
      if ($8 - 1 >>> 0 >= 3) {
       $8 = $8 & -4;
       while (1) {
        $7 = $1 << 2;
        $5 = $7 + $12 | 0;
        HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
        $5 = $12 + ($7 | 4) | 0;
        HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
        $5 = $12 + ($7 | 8) | 0;
        HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
        $5 = $12 + ($7 | 12) | 0;
        HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
        $1 = $1 + 4 | 0;
        $8 = $8 - 4 | 0;
        if ($8) {
         continue
        }
        break;
       };
      }
      if ($4) {
       while (1) {
        $5 = $12 + ($1 << 2) | 0;
        HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
        $1 = $1 + 1 | 0;
        $4 = $4 - 1 | 0;
        if ($4) {
         continue
        }
        break;
       }
      }
      $4 = $3;
     }
     $1 = Math_imul($13, 584) + $10 | 0;
     $3 = HEAP32[$9 + 28 >> 2];
     $4 = $3 >>> 0 < $4 >>> 0 ? $3 : $4;
     HEAP32[$1 + 624 >> 2] = $4;
     HEAP32[$1 + 916 >> 2] = $4;
     HEAP32[$6 + 216 >> 2] = $3 - $4;
     $13 = $13 + 1 | 0;
     if ($13 >>> 0 >= HEAPU32[$9 + 24 >> 2]) {
      $3 = 0
     } else {
      $8 = HEAP32[$9 + 36 >> 2];
      continue;
     }
     break;
    };
   }
   $13 = $3;
   if ($15) {
    $1 = 0;
    $5 = 0;
    $7 = HEAP32[$9 + 36 >> 2];
    label$18 : {
     if (!$7) {
      break label$18
     }
     $8 = HEAP32[$10 + 36 >> 2];
     $3 = 0;
     $6 = 0;
     while (1) {
      label$19 : {
       $3 = HEAP32[$8 + ($6 << 2) >> 2] | $3;
       $4 = $3 & 1;
       $6 = $6 + 1 | 0;
       if ($7 >>> 0 <= $6 >>> 0) {
        break label$19
       }
       if (!$4) {
        continue
       }
      }
      break;
     };
     if ($4 | !$3) {
      break label$18
     }
     $6 = 0;
     while (1) {
      $6 = $6 + 1 | 0;
      $4 = $3 & 2;
      $3 = $3 >> 1;
      if (!$4) {
       continue
      }
      break;
     };
     if (!$6) {
      break label$18
     }
     $5 = $7 & 3;
     $3 = 0;
     if ($7 - 1 >>> 0 >= 3) {
      $4 = $7 & -4;
      while (1) {
       $12 = $3 << 2;
       $7 = $12 + $8 | 0;
       HEAP32[$7 >> 2] = HEAP32[$7 >> 2] >> $6;
       $7 = $8 + ($12 | 4) | 0;
       HEAP32[$7 >> 2] = HEAP32[$7 >> 2] >> $6;
       $7 = $8 + ($12 | 8) | 0;
       HEAP32[$7 >> 2] = HEAP32[$7 >> 2] >> $6;
       $7 = $8 + ($12 | 12) | 0;
       HEAP32[$7 >> 2] = HEAP32[$7 >> 2] >> $6;
       $3 = $3 + 4 | 0;
       $4 = $4 - 4 | 0;
       if ($4) {
        continue
       }
       break;
      };
     }
     if ($5) {
      while (1) {
       $4 = $8 + ($3 << 2) | 0;
       HEAP32[$4 >> 2] = HEAP32[$4 >> 2] >> $6;
       $3 = $3 + 1 | 0;
       $5 = $5 - 1 | 0;
       if ($5) {
        continue
       }
       break;
      }
     }
     $5 = $6;
    }
    $3 = HEAP32[$9 + 28 >> 2];
    $4 = $3 >>> 0 < $5 >>> 0 ? $3 : $5;
    HEAP32[$10 + 5296 >> 2] = $4;
    HEAP32[$10 + 5588 >> 2] = $4;
    HEAP32[$10 + 248 >> 2] = $3 - $4;
    $6 = HEAP32[$9 + 36 >> 2];
    label$26 : {
     if (!$6) {
      $4 = 0;
      break label$26;
     }
     $7 = HEAP32[$10 + 40 >> 2];
     $3 = 0;
     while (1) {
      label$28 : {
       $1 = HEAP32[$7 + ($3 << 2) >> 2] | $1;
       $5 = $1 & 1;
       $3 = $3 + 1 | 0;
       if ($6 >>> 0 <= $3 >>> 0) {
        break label$28
       }
       if (!$5) {
        continue
       }
      }
      break;
     };
     $4 = 0;
     if ($5 | !$1) {
      break label$26
     }
     $3 = 0;
     while (1) {
      $3 = $3 + 1 | 0;
      $5 = $1 & 2;
      $1 = $1 >> 1;
      if (!$5) {
       continue
      }
      break;
     };
     if (!$3) {
      break label$26
     }
     $4 = $6 & 3;
     $1 = 0;
     if ($6 - 1 >>> 0 >= 3) {
      $8 = $6 & -4;
      while (1) {
       $6 = $1 << 2;
       $5 = $6 + $7 | 0;
       HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
       $5 = $7 + ($6 | 4) | 0;
       HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
       $5 = $7 + ($6 | 8) | 0;
       HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
       $5 = $7 + ($6 | 12) | 0;
       HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
       $1 = $1 + 4 | 0;
       $8 = $8 - 4 | 0;
       if ($8) {
        continue
       }
       break;
      };
     }
     if ($4) {
      while (1) {
       $5 = $7 + ($1 << 2) | 0;
       HEAP32[$5 >> 2] = HEAP32[$5 >> 2] >> $3;
       $1 = $1 + 1 | 0;
       $4 = $4 - 1 | 0;
       if ($4) {
        continue
       }
       break;
      }
     }
     $4 = $3;
    }
    $3 = HEAP32[$9 + 28 >> 2];
    $1 = $3 >>> 0 < $4 >>> 0 ? $3 : $4;
    HEAP32[$10 + 5880 >> 2] = $1;
    HEAP32[$10 + 6172 >> 2] = $1;
    HEAP32[$10 + 252 >> 2] = ($3 - $1 | 0) + 1;
   }
   $5 = $14 >>> 0 > $16 >>> 0 ? $16 : $14;
   if (!(!HEAP32[$9 + 24 >> 2] | $13)) {
    $1 = 0;
    while (1) {
     $3 = ($1 << 2) + $10 | 0;
     $4 = ($1 << 3) + $10 | 0;
     process_subframe_($0, $5, $14, $11 + 8 | 0, HEAP32[$3 + 216 >> 2], HEAP32[$3 + 4 >> 2], $4 + 6176 | 0, $4 + 6640 | 0, $4 + 256 | 0, $3 + 6768 | 0, $3 + 6808 | 0);
     $10 = HEAP32[$0 + 4 >> 2];
     $1 = $1 + 1 | 0;
     if ($1 >>> 0 < HEAPU32[HEAP32[$0 >> 2] + 24 >> 2]) {
      continue
     }
     break;
    };
   }
   label$37 : {
    label$38 : {
     label$39 : {
      if ($15) {
       $1 = $11 + 8 | 0;
       process_subframe_($0, $5, $14, $1, HEAP32[$10 + 248 >> 2], HEAP32[$10 + 36 >> 2], $10 + 6240 | 0, $10 + 6704 | 0, $10 + 320 | 0, $10 + 6800 | 0, $10 + 6840 | 0);
       $3 = $1;
       $1 = HEAP32[$0 + 4 >> 2];
       process_subframe_($0, $5, $14, $3, HEAP32[$1 + 252 >> 2], HEAP32[$1 + 40 >> 2], $1 + 6248 | 0, $1 + 6712 | 0, $1 + 328 | 0, $1 + 6804 | 0, $1 + 6844 | 0);
       $13 = $11;
       $7 = HEAP32[$0 + 4 >> 2];
       label$41 : {
        if (!(!HEAP32[HEAP32[$0 >> 2] + 20 >> 2] | !HEAP32[$7 + 6864 >> 2])) {
         $1 = HEAP32[$7 + 6868 >> 2] ? 3 : 0;
         break label$41;
        }
        $6 = HEAP32[$7 + 6844 >> 2];
        $1 = HEAP32[$7 + 6808 >> 2];
        $5 = $6 + $1 | 0;
        $3 = HEAP32[$7 + 6812 >> 2];
        $4 = $3 + $1 | 0;
        $1 = $5 >>> 0 < $4 >>> 0;
        $14 = $1;
        $3 = $3 + $6 | 0;
        $4 = $1 ? $5 : $4;
        $1 = $3 >>> 0 < $4 >>> 0;
        $1 = $6 + HEAP32[$7 + 6840 >> 2] >>> 0 < ($1 ? $3 : $4) >>> 0 ? 3 : $1 ? 2 : $14;
       }
       HEAP32[$13 + 20 >> 2] = $1;
       if (!FLAC__frame_add_header($11 + 8 | 0, HEAP32[$7 + 6856 >> 2])) {
        $3 = HEAP32[$0 >> 2];
        break label$37;
       }
       label$44 : {
        label$45 : {
         switch ($1 - 1 | 0) {
         default:
          $1 = HEAP32[$0 + 4 >> 2];
          $4 = $1 + 336 | 0;
          $8 = ($4 + Math_imul(HEAP32[$1 + 6772 >> 2], 292) | 0) + 584 | 0;
          $6 = $1 + 220 | 0;
          $5 = $1 + 216 | 0;
          $3 = $4 + Math_imul(HEAP32[$1 + 6768 >> 2], 292) | 0;
          break label$44;
         case 0:
          $1 = HEAP32[$0 + 4 >> 2];
          $6 = $1 + 252 | 0;
          $5 = $1 + 216 | 0;
          $8 = (Math_imul(HEAP32[$1 + 6804 >> 2], 292) + $1 | 0) + 5592 | 0;
          $3 = (Math_imul(HEAP32[$1 + 6768 >> 2], 292) + $1 | 0) + 336 | 0;
          break label$44;
         case 1:
          $1 = HEAP32[$0 + 4 >> 2];
          $6 = $1 + 220 | 0;
          $5 = $1 + 252 | 0;
          $8 = (Math_imul(HEAP32[$1 + 6772 >> 2], 292) + $1 | 0) + 920 | 0;
          $3 = (Math_imul(HEAP32[$1 + 6804 >> 2], 292) + $1 | 0) + 5592 | 0;
          break label$44;
         case 2:
          break label$45;
         };
        }
        $1 = HEAP32[$0 + 4 >> 2];
        $4 = $1 + 5008 | 0;
        $8 = ($4 + Math_imul(HEAP32[$1 + 6804 >> 2], 292) | 0) + 584 | 0;
        $6 = $1 + 252 | 0;
        $5 = $1 + 248 | 0;
        $3 = $4 + Math_imul(HEAP32[$1 + 6800 >> 2], 292) | 0;
       }
       $4 = HEAP32[$6 >> 2];
       if (!add_subframe_($0, HEAP32[$11 + 8 >> 2], HEAP32[$5 >> 2], $3, HEAP32[$1 + 6856 >> 2])) {
        break label$39
       }
       if (!add_subframe_($0, HEAP32[$11 + 8 >> 2], $4, $8, HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2])) {
        break label$39
       }
       $3 = HEAP32[$0 >> 2];
       break label$38;
      }
      $1 = FLAC__frame_add_header($11 + 8 | 0, HEAP32[$10 + 6856 >> 2]);
      $3 = HEAP32[$0 >> 2];
      if (!$1) {
       break label$37
      }
      if (!HEAP32[$3 + 24 >> 2]) {
       break label$38
      }
      $1 = 0;
      while (1) {
       $3 = HEAP32[$0 + 4 >> 2];
       $4 = $3 + ($1 << 2) | 0;
       if (!add_subframe_($0, HEAP32[$11 + 8 >> 2], HEAP32[$4 + 216 >> 2], (($3 + Math_imul($1, 584) | 0) + Math_imul(HEAP32[$4 + 6768 >> 2], 292) | 0) + 336 | 0, HEAP32[$3 + 6856 >> 2])) {
        break label$39
       }
       $1 = $1 + 1 | 0;
       $3 = HEAP32[$0 >> 2];
       if ($1 >>> 0 < HEAPU32[$3 + 24 >> 2]) {
        continue
       }
       break;
      };
      break label$38;
     }
     $1 = 0;
     break label$1;
    }
    if (HEAP32[$3 + 20 >> 2]) {
     $4 = HEAP32[$0 + 4 >> 2];
     $1 = HEAP32[$4 + 6864 >> 2] + 1 | 0;
     HEAP32[$4 + 6864 >> 2] = $1 >>> 0 < HEAPU32[$4 + 6860 >> 2] ? $1 : 0;
    }
    $1 = HEAP32[$0 + 4 >> 2];
    HEAP32[$1 + 6868 >> 2] = HEAP32[$11 + 20 >> 2];
    $4 = HEAP32[$1 + 6856 >> 2];
    $1 = HEAP32[$4 + 16 >> 2] & 7;
    if ($1) {
     $1 = FLAC__bitwriter_write_zeroes($4, 8 - $1 | 0)
    } else {
     $1 = 1
    }
    if (!$1) {
     HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
     $1 = 0;
     break label$1;
    }
    label$52 : {
     $1 = $11 + 8 | 0;
     $5 = 0;
     $3 = __stack_pointer - 16 | 0;
     __stack_pointer = $3;
     if (FLAC__bitwriter_get_buffer(HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2], $3 + 12 | 0, $3 + 8 | 0)) {
      $13 = $1;
      $6 = HEAP32[$3 + 12 >> 2];
      $4 = HEAP32[$3 + 8 >> 2];
      if ($4 >>> 0 > 7) {
       while (1) {
        $1 = HEAPU8[$6 | 0] | HEAPU8[$6 + 1 | 0] << 8;
        $1 = ($1 << 8 | $1 >>> 8) ^ $5;
        $5 = HEAPU16[(HEAPU8[$6 + 7 | 0] << 1) + 1280 >> 1] ^ (HEAPU16[(HEAPU8[$6 + 6 | 0] << 1) + 1792 >> 1] ^ (HEAPU16[(HEAPU8[$6 + 5 | 0] << 1) + 2304 >> 1] ^ (HEAPU16[(HEAPU8[$6 + 4 | 0] << 1) + 2816 >> 1] ^ (HEAPU16[(HEAPU8[$6 + 3 | 0] << 1) + 3328 >> 1] ^ (HEAPU16[(HEAPU8[$6 + 2 | 0] << 1) + 3840 >> 1] ^ (HEAPU16[(($1 & 255) << 1) + 4352 >> 1] ^ HEAPU16[($1 >>> 7 & 510) + 4864 >> 1]))))));
        $6 = $6 + 8 | 0;
        $4 = $4 - 8 | 0;
        if ($4 >>> 0 > 7) {
         continue
        }
        break;
       }
      }
      label$33 : {
       if (!$4) {
        break label$33
       }
       if ($4 & 1) {
        $5 = HEAPU16[((HEAPU8[$6 | 0] ^ ($5 & 65280) >>> 8) << 1) + 1280 >> 1] ^ $5 << 8;
        $6 = $6 + 1 | 0;
        $1 = $4 - 1 | 0;
       } else {
        $1 = $4
       }
       if (($4 | 0) == 1) {
        break label$33
       }
       while (1) {
        $4 = HEAPU16[((HEAPU8[$6 | 0] ^ ($5 & 65280) >>> 8) << 1) + 1280 >> 1];
        $5 = HEAPU16[((HEAPU8[$6 + 1 | 0] ^ (($4 ^ $5 << 8) & 65280) >>> 8) << 1) + 1280 >> 1] ^ $4 << 8;
        $6 = $6 + 2 | 0;
        $1 = $1 - 2 | 0;
        if ($1) {
         continue
        }
        break;
       };
      }
      HEAP16[$13 >> 1] = $5;
      $1 = 1;
     } else {
      $1 = 0
     }
     __stack_pointer = $3 + 16 | 0;
     if ($1) {
      if (FLAC__bitwriter_write_raw_uint32(HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2], HEAPU16[$11 + 8 >> 1], HEAP32[1681])) {
       break label$52
      }
     }
     HEAP32[HEAP32[$0 >> 2] >> 2] = 8;
     $1 = 0;
     break label$1;
    }
    $1 = 0;
    if (!write_bitbuffer_($0, HEAP32[HEAP32[$0 >> 2] + 36 >> 2], $2)) {
     break label$1
    }
    $1 = HEAP32[$0 + 4 >> 2];
    HEAP32[$1 + 7052 >> 2] = 0;
    HEAP32[$1 + 7056 >> 2] = HEAP32[$1 + 7056 >> 2] + 1;
    $3 = $1 + 6920 | 0;
    $4 = HEAP32[$3 + 4 >> 2];
    $1 = HEAP32[HEAP32[$0 >> 2] + 36 >> 2];
    $0 = $1 + HEAP32[$3 >> 2] | 0;
    HEAP32[$3 >> 2] = $0;
    HEAP32[$3 + 4 >> 2] = $0 >>> 0 < $1 >>> 0 ? $4 + 1 | 0 : $4;
    $1 = 1;
    break label$1;
   }
   HEAP32[$3 >> 2] = 7;
   $1 = 0;
  }
  $0 = $1;
  __stack_pointer = $11 + 48 | 0;
  return $0;
 }
 
 function FLAC__stream_encoder_init_stream($0, $1, $2, $3, $4, $5) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  return init_stream_internal__1($0, 0, $1, $2, $3, $4, $5, 0) | 0;
 }
 
 function init_stream_internal__1($0, $1, $2, $3, $4, $5, $6, $7) {
  var $8 = 0, $9 = 0, $10 = 0, $11 = Math_fround(0), $12 = 0.0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = Math_fround(0), $19 = 0.0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0.0, $27 = 0, $28 = Math_fround(0), $29 = 0.0, $30 = 0.0, $31 = Math_fround(0), $32 = Math_fround(0), $33 = 0, $34 = Math_fround(0), wasm2js_i32$0 = 0, wasm2js_f32$0 = Math_fround(0);
  $24 = __stack_pointer - 176 | 0;
  __stack_pointer = $24;
  $17 = 13;
  $8 = HEAP32[$0 >> 2];
  label$1 : {
   if (HEAP32[$8 >> 2] != 1) {
    break label$1
   }
   $17 = 3;
   if (!$2 | ($4 ? 0 : $3)) {
    break label$1
   }
   $17 = 4;
   $9 = HEAP32[$8 + 24 >> 2];
   if ($9 - 1 >>> 0 > 7) {
    break label$1
   }
   label$3 : {
    label$4 : {
     if (($9 | 0) != 2) {
      HEAP32[$8 + 16 >> 2] = 0;
      break label$4;
     }
     if (HEAP32[$8 + 16 >> 2]) {
      break label$3
     }
    }
    HEAP32[$8 + 20 >> 2] = 0;
   }
   $9 = HEAP32[$8 + 28 >> 2];
   if ($9 >>> 0 >= 32) {
    HEAP32[$8 + 16 >> 2] = 0;
    $17 = 5;
    break label$1;
   }
   $17 = 5;
   if ($9 - 4 >>> 0 > 20) {
    break label$1
   }
   if (HEAP32[$8 + 32 >> 2] - 1 >>> 0 >= 655350) {
    $17 = 6;
    break label$1;
   }
   $8 = HEAP32[$0 >> 2];
   $13 = HEAP32[$8 + 36 >> 2];
   label$8 : {
    if (!$13) {
     $13 = HEAP32[$8 + 556 >> 2] ? 4096 : 1152;
     HEAP32[$8 + 36 >> 2] = $13;
     break label$8;
    }
    $17 = 7;
    if ($13 - 16 >>> 0 > 65519) {
     break label$1
    }
   }
   $17 = 8;
   $9 = HEAP32[$8 + 556 >> 2];
   if ($9 >>> 0 > 32) {
    break label$1
   }
   $17 = 10;
   if ($9 >>> 0 > $13 >>> 0) {
    break label$1
   }
   $9 = HEAP32[$8 + 560 >> 2];
   label$10 : {
    if (!$9) {
     $10 = $8;
     $9 = HEAP32[$8 + 28 >> 2];
     label$12 : {
      if ($9 >>> 0 <= 15) {
       $9 = $9 >>> 0 > 5 ? ($9 >>> 1 | 0) + 2 | 0 : 5;
       break label$12;
      }
      if (($9 | 0) == 16) {
       $9 = 7;
       if ($13 >>> 0 < 193) {
        break label$12
       }
       $9 = 8;
       if ($13 >>> 0 < 385) {
        break label$12
       }
       $9 = 9;
       if ($13 >>> 0 < 577) {
        break label$12
       }
       $9 = 10;
       if ($13 >>> 0 < 1153) {
        break label$12
       }
       $9 = 11;
       if ($13 >>> 0 < 2305) {
        break label$12
       }
       $9 = $13 >>> 0 < 4609 ? 12 : 13;
       break label$12;
      }
      $9 = 13;
      if ($13 >>> 0 < 385) {
       break label$12
      }
      $9 = $13 >>> 0 < 1153 ? 14 : 15;
     }
     HEAP32[$10 + 560 >> 2] = $9;
     break label$10;
    }
    $17 = 9;
    if ($9 - 5 >>> 0 > 10) {
     break label$1
    }
   }
   label$15 : {
    if (!HEAP32[$8 + 8 >> 2]) {
     $13 = HEAP32[$8 + 580 >> 2];
     break label$15;
    }
    $17 = 11;
    if (!(($13 >>> 0 < 4609 | HEAPU32[$8 + 32 >> 2] > 48e3) & $13 >>> 0 < 16385)) {
     break label$1
    }
    $9 = HEAP32[HEAP32[$0 >> 2] + 32 >> 2];
    if (!((!(($9 >>> 0) % 10 | 0) | (!(($9 >>> 0) % 1e3 | 0) | $9 >>> 0 < 65536)) & $9 - 1 >>> 0 <= 655349)) {
     break label$1
    }
    $8 = HEAP32[$0 >> 2];
    if (__wasm_rotl_i32(HEAP32[$8 + 28 >> 2] - 8 | 0, 30) >>> 0 > 4) {
     break label$1
    }
    $13 = HEAP32[$8 + 580 >> 2];
    if ($13 >>> 0 > 8) {
     break label$1
    }
    if (HEAPU32[$8 + 32 >> 2] > 48e3) {
     break label$15
    }
    if (HEAPU32[$8 + 36 >> 2] > 4608 | HEAPU32[$8 + 556 >> 2] > 12) {
     break label$1
    }
   }
   $9 = 1 << HEAP32[1683];
   if ($13 >>> 0 >= $9 >>> 0) {
    $13 = $9 - 1 | 0;
    HEAP32[$8 + 580 >> 2] = $13;
   }
   if ($13 >>> 0 <= HEAPU32[$8 + 576 >> 2]) {
    HEAP32[$8 + 576 >> 2] = $13
   }
   label$19 : {
    if (!$7) {
     break label$19
    }
    $13 = HEAP32[$8 + 600 >> 2];
    if (!$13) {
     break label$19
    }
    $9 = HEAP32[$8 + 604 >> 2];
    if ($9 >>> 0 < 2) {
     break label$19
    }
    $17 = 1;
    while (1) {
     $10 = HEAP32[($17 << 2) + $13 >> 2];
     if (!(!$10 | HEAP32[$10 >> 2] != 4)) {
      $9 = $17 - 1 | 0;
      $8 = $17 & 3;
      if ($8) {
       while (1) {
        $15 = ($17 << 2) + $13 | 0;
        $17 = $17 - 1 | 0;
        HEAP32[$15 >> 2] = HEAP32[($17 << 2) + $13 >> 2];
        $13 = HEAP32[HEAP32[$0 >> 2] + 600 >> 2];
        $8 = $8 - 1 | 0;
        if ($8) {
         continue
        }
        break;
       }
      }
      if ($9 >>> 0 >= 3) {
       while (1) {
        $15 = $17 << 2;
        $8 = $15 - 4 | 0;
        HEAP32[$13 + $15 >> 2] = HEAP32[$8 + $13 >> 2];
        $9 = HEAP32[HEAP32[$0 >> 2] + 600 >> 2];
        $13 = $8 + $9 | 0;
        $8 = $15 - 8 | 0;
        HEAP32[$13 >> 2] = HEAP32[$9 + $8 >> 2];
        $9 = HEAP32[HEAP32[$0 >> 2] + 600 >> 2];
        $13 = $8 + $9 | 0;
        $8 = $15 - 12 | 0;
        HEAP32[$13 >> 2] = HEAP32[$9 + $8 >> 2];
        $9 = HEAP32[HEAP32[$0 >> 2] + 600 >> 2];
        $17 = $17 - 4 | 0;
        HEAP32[$8 + $9 >> 2] = HEAP32[$9 + ($17 << 2) >> 2];
        $13 = HEAP32[HEAP32[$0 >> 2] + 600 >> 2];
        if ($17) {
         continue
        }
        break;
       }
      }
      HEAP32[$13 >> 2] = $10;
      $8 = HEAP32[$0 >> 2];
      break label$19;
     }
     $17 = $17 + 1 | 0;
     if (($9 | 0) != ($17 | 0)) {
      continue
     }
     break;
    };
   }
   $10 = HEAP32[$8 + 604 >> 2];
   label$26 : {
    label$27 : {
     $14 = HEAP32[$8 + 600 >> 2];
     if ($14) {
      $13 = 0;
      if (!$10) {
       break label$26
      }
      while (1) {
       $9 = HEAP32[($13 << 2) + $14 >> 2];
       if (!(!$9 | HEAP32[$9 >> 2] != 3)) {
        HEAP32[HEAP32[$0 + 4 >> 2] + 7048 >> 2] = $9 + 16;
        break label$27;
       }
       $13 = $13 + 1 | 0;
       if (($10 | 0) != ($13 | 0)) {
        continue
       }
       break;
      };
      break label$27;
     }
     $17 = 12;
     if ($10) {
      break label$1
     }
     $13 = 0;
     break label$26;
    }
    $8 = 0;
    $10 = 0;
    $13 = 0;
    $9 = 0;
    while (1) {
     $17 = 12;
     label$32 : {
      label$33 : {
       label$34 : {
        label$35 : {
         label$36 : {
          $21 = HEAP32[($25 << 2) + $14 >> 2];
          switch (HEAP32[$21 >> 2]) {
          case 0:
           break label$1;
          case 6:
           break label$33;
          case 5:
           break label$34;
          case 4:
           break label$35;
          case 3:
           break label$36;
          default:
           break label$32;
          };
         }
         if ($33) {
          break label$1
         }
         $33 = 1;
         $13 = $10;
         $9 = $8;
         $15 = 0;
         $14 = 0;
         $8 = $21 + 16 | 0;
         $22 = HEAP32[$8 >> 2];
         $27 = 1;
         __inlined_func$FLAC__format_seektable_is_legal : {
          if (!$22) {
           break __inlined_func$FLAC__format_seektable_is_legal
          }
          $23 = HEAP32[$8 + 4 >> 2];
          $20 = 0;
          $21 = 1;
          while (1) {
           $8 = $14;
           $10 = $15;
           $15 = Math_imul($20, 24) + $23 | 0;
           $14 = HEAP32[$15 >> 2];
           $15 = HEAP32[$15 + 4 >> 2];
           $27 = 0;
           if (!(($14 | 0) == -1 & ($15 | 0) == -1 | $21 | (($10 | 0) == ($15 | 0) & $8 >>> 0 < $14 >>> 0 | $10 >>> 0 < $15 >>> 0))) {
            break __inlined_func$FLAC__format_seektable_is_legal
           }
           $21 = 0;
           $20 = $20 + 1 | 0;
           if (($22 | 0) != ($20 | 0)) {
            continue
           }
           break;
          };
          $27 = 1;
         }
         if ($27) {
          break label$32
         }
         break label$1;
        }
        $13 = 1;
        $9 = $8;
        if (!$10) {
         break label$32
        }
        break label$1;
       }
       $13 = $10;
       $9 = $8;
       $22 = $21 + 16 | 0;
       __inlined_func$FLAC__format_cuesheet_is_legal : {
        label$11 : {
         label$82 : {
          label$9 : {
           if (HEAP32[$21 + 160 >> 2]) {
            $15 = HEAP32[$22 + 140 >> 2];
            $10 = $15;
            $8 = HEAP32[$22 + 136 >> 2];
            if (!(!$10 & $8 >>> 0 > 88199 | ($10 | 0) != 0)) {
             break label$11
            }
            if (__wasm_i64_urem($8, $10) | i64toi32_i32$HIGH_BITS) {
             break label$11
            }
            $14 = HEAP32[$22 + 148 >> 2];
            if (!$14) {
             break label$11
            }
            $15 = $14 - 1 | 0;
            if (HEAPU8[(HEAP32[$22 + 152 >> 2] + ($15 << 5) | 0) + 8 | 0] == 170) {
             break label$9
            }
            break label$11;
           }
           $23 = HEAP32[$22 + 148 >> 2];
           if (!$23) {
            break label$11
           }
           $14 = $23 - 1 | 0;
           $15 = HEAP32[$22 + 152 >> 2];
           $20 = 0;
           while (1) {
            $8 = $15 + ($20 << 5) | 0;
            if (!HEAPU8[$8 + 8 | 0]) {
             break label$11
            }
            $22 = HEAPU8[$8 + 23 | 0];
            label$14 : {
             label$153 : {
              if ($14 >>> 0 > $20 >>> 0) {
               if (!$22) {
                break label$11
               }
               if (HEAPU8[HEAP32[$8 + 24 >> 2] + 8 | 0] <= 1) {
                break label$153
               }
               break label$11;
              }
              if (!$22) {
               break label$14
              }
             }
             $10 = $8 + 24 | 0;
             $21 = 0;
             while (1) {
              if ($21) {
               $8 = HEAP32[$10 >> 2] + ($21 << 4) | 0;
               if ((HEAPU8[$8 - 8 | 0] + 1 | 0) != HEAPU8[$8 + 8 | 0]) {
                break label$11
               }
              }
              $21 = $21 + 1 | 0;
              if (($22 | 0) != ($21 | 0)) {
               continue
              }
              break;
             };
            }
            $20 = $20 + 1 | 0;
            if (($23 | 0) != ($20 | 0)) {
             continue
            }
            break;
           };
           break label$82;
          }
          $10 = HEAP32[$22 + 152 >> 2];
          $20 = 0;
          while (1) {
           $23 = $10 + ($20 << 5) | 0;
           $8 = HEAPU8[$23 + 8 | 0];
           if (!$8 | !(($8 | 0) == 170 | $8 >>> 0 < 100)) {
            break label$11
           }
           if (__wasm_i64_urem(HEAP32[$23 >> 2], HEAP32[$23 + 4 >> 2]) | i64toi32_i32$HIGH_BITS) {
            break label$11
           }
           $22 = HEAPU8[$23 + 23 | 0];
           label$22 : {
            label$235 : {
             if ($15 >>> 0 > $20 >>> 0) {
              if (!$22) {
               break label$11
              }
              if (HEAPU8[HEAP32[$23 + 24 >> 2] + 8 | 0] < 2) {
               break label$235
              }
              break label$11;
             }
             if (!$22) {
              break label$22
             }
            }
            $8 = HEAP32[$23 + 24 >> 2];
            $21 = 0;
            while (1) {
             $23 = $8 + ($21 << 4) | 0;
             if (__wasm_i64_urem(HEAP32[$23 >> 2], HEAP32[$23 + 4 >> 2]) | i64toi32_i32$HIGH_BITS | !!$21 & HEAPU8[$23 + 8 | 0] != (HEAPU8[$23 - 8 | 0] + 1 | 0)) {
              break label$11
             }
             $21 = $21 + 1 | 0;
             if (($22 | 0) != ($21 | 0)) {
              continue
             }
             break;
            };
           }
           $20 = $20 + 1 | 0;
           if (($14 | 0) != ($20 | 0)) {
            continue
           }
           break;
          };
         }
         $10 = 1;
         break __inlined_func$FLAC__format_cuesheet_is_legal;
        }
        $10 = 0;
       }
       if ($10) {
        break label$32
       }
       break label$1;
      }
      __inlined_func$FLAC__format_picture_is_legal : {
       label$16 : {
        label$37 : {
         $14 = $21 + 16 | 0;
         $13 = $14;
         $15 = HEAP32[$14 + 4 >> 2];
         $9 = HEAPU8[$15 | 0];
         if (!$9) {
          break label$37
         }
         while (1) {
          if (($9 - 32 & 255) >>> 0 < 95) {
           $15 = $15 + 1 | 0;
           $9 = HEAPU8[$15 | 0];
           if ($9) {
            continue
           }
           break label$37;
          }
          break;
         };
         break label$16;
        }
        $9 = HEAP32[$13 + 8 >> 2];
        if (HEAPU8[$9 | 0]) {
         while (1) {
          $22 = 1;
          $13 = $9;
          $20 = HEAPU8[$9 | 0];
          __inlined_func$utf8len_ : {
           label$108 : {
            if (!($20 & 128)) {
             break label$108
            }
            $15 = (($20 & 254) != 192) << 1;
            if (!(($20 & 224) != 192 | (HEAPU8[$13 + 1 | 0] & 192) != 128)) {
             break __inlined_func$utf8len_
            }
            label$319 : {
             if (($20 & 240) != 224) {
              break label$319
             }
             $23 = HEAPU8[$13 + 1 | 0];
             if (($23 & 192) != 128) {
              break label$319
             }
             $15 = HEAPU8[$13 + 2 | 0];
             if (($15 & 192) != 128) {
              break label$319
             }
             $22 = 0;
             if (($20 | 0) == 224 & ($23 & 224) == 128) {
              break label$108
             }
             label$52 : {
              label$6 : {
               switch ($20 - 237 | 0) {
               case 0:
                if (($23 & 224) != 160) {
                 break label$52
                }
                break label$108;
               case 2:
                break label$6;
               default:
                break label$52;
               };
              }
              if (($23 | 0) != 191) {
               break label$52
              }
              if (($15 & 254) == 190) {
               break label$108
              }
             }
             $15 = 3;
             break __inlined_func$utf8len_;
            }
            label$810 : {
             if (($20 & 248) != 240) {
              break label$810
             }
             $15 = HEAPU8[$13 + 1 | 0];
             if (($15 & 192) != 128 | (HEAPU8[$13 + 2 | 0] & 192) != 128 | (HEAPU8[$13 + 3 | 0] & 192) != 128) {
              break label$810
             }
             $15 = ($20 | 0) == 240 ? (($15 & 240) != 128) << 2 : 4;
             break __inlined_func$utf8len_;
            }
            label$911 : {
             if (($20 & 252) != 248) {
              break label$911
             }
             $15 = HEAPU8[$13 + 1 | 0];
             if (($15 & 192) != 128 | (HEAPU8[$13 + 2 | 0] & 192) != 128 | ((HEAPU8[$13 + 3 | 0] & 192) != 128 | (HEAPU8[$13 + 4 | 0] & 192) != 128)) {
              break label$911
             }
             $15 = ($20 | 0) == 248 ? (($15 & 248) == 128 ? 0 : 5) : 5;
             break __inlined_func$utf8len_;
            }
            $22 = 0;
            if (($20 & 254) != 252) {
             break label$108
            }
            $15 = HEAPU8[$13 + 1 | 0];
            if (($15 & 192) != 128 | (HEAPU8[$13 + 2 | 0] & 192) != 128 | ((HEAPU8[$13 + 3 | 0] & 192) != 128 | (HEAPU8[$13 + 4 | 0] & 192) != 128) | (HEAPU8[$13 + 5 | 0] & 192) != 128) {
             break label$108
            }
            $22 = ($20 | 0) == 252 ? (($15 & 252) == 128 ? 0 : 6) : 6;
           }
           $15 = $22;
          }
          $13 = $15;
          if (!$13) {
           break label$16
          }
          $9 = $9 + $13 | 0;
          if (HEAPU8[$9 | 0]) {
           continue
          }
          break;
         }
        }
        $13 = 1;
        break __inlined_func$FLAC__format_picture_is_legal;
       }
       $13 = 0;
      }
      if (!$13) {
       break label$1
      }
      $13 = $10;
      $9 = $8;
      label$3712 : {
       switch (HEAP32[$14 >> 2] - 1 | 0) {
       case 0:
        if ($16) {
         break label$1
        }
        $9 = HEAP32[$21 + 20 >> 2];
        if (strcmp($9, 5867)) {
         if (strcmp($9, 5936)) {
          break label$1
         }
        }
        if (HEAP32[$21 + 28 >> 2] != 32) {
         break label$1
        }
        $16 = 1;
        $13 = $10;
        $9 = $8;
        if (HEAP32[$21 + 32 >> 2] == 32) {
         break label$32
        }
        break label$1;
       case 1:
        break label$3712;
       default:
        break label$32;
       };
      }
      $9 = 1;
      if ($8) {
       break label$1
      }
     }
     $25 = $25 + 1 | 0;
     $8 = HEAP32[$0 >> 2];
     if ($25 >>> 0 >= HEAPU32[$8 + 604 >> 2]) {
      break label$26
     }
     $14 = HEAP32[$8 + 600 >> 2];
     $8 = $9;
     $10 = $13;
     continue;
    };
   }
   $14 = 0;
   $25 = HEAP32[$0 + 4 >> 2];
   HEAP32[$25 >> 2] = 0;
   if (HEAP32[$8 + 24 >> 2]) {
    while (1) {
     $9 = $14 << 2;
     HEAP32[($9 + $25 | 0) + 4 >> 2] = 0;
     HEAP32[($9 + HEAP32[$0 + 4 >> 2] | 0) + 7328 >> 2] = 0;
     HEAP32[($9 + HEAP32[$0 + 4 >> 2] | 0) + 44 >> 2] = 0;
     HEAP32[($9 + HEAP32[$0 + 4 >> 2] | 0) + 7368 >> 2] = 0;
     $25 = HEAP32[$0 + 4 >> 2];
     $14 = $14 + 1 | 0;
     if ($14 >>> 0 < HEAPU32[HEAP32[$0 >> 2] + 24 >> 2]) {
      continue
     }
     break;
    }
   }
   $17 = 0;
   HEAP32[$25 + 36 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 7360 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 76 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 7400 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 40 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 7364 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 80 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 7404 >> 2] = 0;
   $8 = HEAP32[$0 >> 2];
   if (HEAP32[$8 + 40 >> 2]) {
    while (1) {
     $9 = $17 << 2;
     HEAP32[($9 + HEAP32[$0 + 4 >> 2] | 0) + 84 >> 2] = 0;
     HEAP32[($9 + HEAP32[$0 + 4 >> 2] | 0) + 7408 >> 2] = 0;
     $17 = $17 + 1 | 0;
     $8 = HEAP32[$0 >> 2];
     if ($17 >>> 0 < HEAPU32[$8 + 40 >> 2]) {
      continue
     }
     break;
    }
   }
   $17 = 0;
   $14 = HEAP32[$0 + 4 >> 2];
   HEAP32[$14 + 7536 >> 2] = 0;
   HEAP32[$14 + 212 >> 2] = 0;
   if (HEAP32[$8 + 24 >> 2]) {
    while (1) {
     $9 = $17 << 3;
     HEAP32[($9 + $14 | 0) + 256 >> 2] = 0;
     HEAP32[($9 + HEAP32[$0 + 4 >> 2] | 0) + 7540 >> 2] = 0;
     HEAP32[($9 + HEAP32[$0 + 4 >> 2] | 0) + 260 >> 2] = 0;
     HEAP32[($9 + HEAP32[$0 + 4 >> 2] | 0) + 7544 >> 2] = 0;
     $14 = HEAP32[$0 + 4 >> 2];
     HEAP32[($14 + ($17 << 2) | 0) + 6768 >> 2] = 0;
     $17 = $17 + 1 | 0;
     if ($17 >>> 0 < HEAPU32[HEAP32[$0 >> 2] + 24 >> 2]) {
      continue
     }
     break;
    }
   }
   HEAP32[$14 + 320 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 7604 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 324 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 7608 >> 2] = 0;
   $9 = HEAP32[$0 + 4 >> 2];
   HEAP32[$9 + 6800 >> 2] = 0;
   HEAP32[$9 + 328 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 7612 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 332 >> 2] = 0;
   HEAP32[HEAP32[$0 + 4 >> 2] + 7616 >> 2] = 0;
   $10 = HEAP32[$0 + 4 >> 2];
   HEAP32[$10 + 7620 >> 2] = 0;
   HEAP32[$10 + 7624 >> 2] = 0;
   HEAP32[$10 + 6848 >> 2] = 0;
   HEAP32[$10 + 6852 >> 2] = 0;
   HEAP32[$10 + 6804 >> 2] = 0;
   $9 = HEAP32[$0 >> 2];
   $8 = HEAP32[$9 + 36 >> 2];
   $9 = HEAP32[$9 + 32 >> 2];
   HEAP32[$10 + 7052 >> 2] = 0;
   HEAP32[$10 + 7056 >> 2] = 0;
   HEAP32[$10 + 6864 >> 2] = 0;
   $17 = 1;
   $15 = $10;
   $12 = +($9 >>> 0) * .4 / +($8 >>> 0) + .5;
   label$46 : {
    if ($12 < 4294967296.0 & $12 >= 0.0) {
     $9 = ~~$12 >>> 0;
     break label$46;
    }
    $9 = 0;
   }
   HEAP32[$15 + 6860 >> 2] = $9 ? $9 : 1;
   FLAC__cpu_info($10 + 7156 | 0);
   $8 = HEAP32[$0 + 4 >> 2];
   HEAP32[$8 + 7244 >> 2] = 12;
   HEAP32[$8 + 7240 >> 2] = 13;
   HEAP32[$8 + 7236 >> 2] = 12;
   HEAP32[$8 + 7228 >> 2] = 14;
   HEAP32[$8 + 7224 >> 2] = 15;
   HEAP32[$8 + 7220 >> 2] = 16;
   HEAP32[$8 + 7232 >> 2] = 17;
   $14 = HEAP32[$0 >> 2];
   HEAP32[$14 >> 2] = 0;
   HEAP32[$8 + 7260 >> 2] = $7;
   label$48 : {
    label$49 : {
     if ($7) {
      $7 = $14 + 632 | 0;
      if (ogg_stream_init($7 + 8 | 0, HEAP32[$7 >> 2])) {
       $7 = 0
      } else {
       HEAP32[$7 + 392 >> 2] = 0;
       HEAP32[$7 + 396 >> 2] = 0;
       HEAP32[$7 + 384 >> 2] = 0;
       HEAP32[$7 + 388 >> 2] = 1;
       $7 = 1;
      }
      if (!$7) {
       break label$49
      }
      $14 = HEAP32[$0 >> 2];
      $8 = HEAP32[$0 + 4 >> 2];
     }
     HEAP32[$8 + 7276 >> 2] = $2;
     HEAP32[$8 + 7264 >> 2] = $1;
     HEAP32[$8 + 7288 >> 2] = $6;
     HEAP32[$8 + 7280 >> 2] = $5;
     HEAP32[$8 + 7272 >> 2] = $4;
     HEAP32[$8 + 7268 >> 2] = $3;
     $1 = HEAP32[$14 + 36 >> 2];
     $6 = $0;
     if ($1 >>> 0 > HEAPU32[HEAP32[$0 + 4 >> 2] >> 2]) {
      $14 = $6 + 4 | 0;
      $5 = $1 + 5 | 0;
      $9 = 0;
      __inlined_func$resize_buffers_ : {
       label$28 : {
        while (1) {
         label$311 : {
          if ($9 >>> 0 >= HEAPU32[HEAP32[$6 >> 2] + 24 >> 2]) {
           $2 = HEAP32[$14 >> 2];
           $3 = FLAC__memory_alloc_aligned_int32_array($5, $2 + 7360 | 0, $2 + 36 | 0);
           $2 = HEAP32[HEAP32[$14 >> 2] + 36 >> 2];
           HEAP32[$2 >> 2] = 0;
           HEAP32[$2 + 4 >> 2] = 0;
           $2 = $2 + 8 | 0;
           HEAP32[$2 >> 2] = 0;
           HEAP32[$2 + 4 >> 2] = 0;
           $2 = HEAP32[$14 >> 2];
           HEAP32[$2 + 36 >> 2] = HEAP32[$2 + 36 >> 2] + 16;
           if ($3) {
            $2 = HEAP32[$14 >> 2];
            $3 = FLAC__memory_alloc_aligned_int32_array($5, $2 + 7364 | 0, $2 + 40 | 0);
            $2 = HEAP32[HEAP32[$14 >> 2] + 40 >> 2];
            HEAP32[$2 >> 2] = 0;
            HEAP32[$2 + 4 >> 2] = 0;
            $2 = $2 + 8 | 0;
            HEAP32[$2 >> 2] = 0;
            HEAP32[$2 + 4 >> 2] = 0;
            $2 = HEAP32[$14 >> 2] + 40 | 0;
            HEAP32[$2 >> 2] = HEAP32[$2 >> 2] + 16;
           }
           if (!$3) {
            break label$311
           }
           $2 = HEAP32[$6 >> 2];
           if (HEAP32[$2 + 556 >> 2]) {
            $5 = HEAP32[$14 >> 2];
            if (HEAP32[$2 + 40 >> 2]) {
             $9 = 0;
             while (1) {
              $2 = ($9 << 2) + $5 | 0;
              if (!FLAC__memory_alloc_aligned_int32_array($1, $2 + 7408 | 0, $2 + 84 | 0)) {
               break label$311
              }
              $5 = HEAP32[$6 + 4 >> 2];
              $9 = $9 + 1 | 0;
              if ($9 >>> 0 < HEAPU32[HEAP32[$6 >> 2] + 40 >> 2]) {
               continue
              }
              break;
             };
            }
            if (!FLAC__memory_alloc_aligned_int32_array($1, $5 + 7536 | 0, $5 + 212 | 0)) {
             break label$311
            }
           }
           $5 = 0;
           $4 = 1;
           $9 = 0;
           while (1) {
            if ($9 >>> 0 >= HEAPU32[HEAP32[$6 >> 2] + 24 >> 2]) {
             while (1) {
              $3 = $5 << 3;
              $2 = $3 + HEAP32[$14 >> 2] | 0;
              $2 = FLAC__memory_alloc_aligned_int32_array($1, $2 + 7604 | 0, $2 + 320 | 0);
              label$1415 : {
               if (!$2) {
                $3 = ($2 | 0) != 0;
                break label$1415;
               }
               $2 = $3 + HEAP32[$14 >> 2] | 0;
               $3 = (FLAC__memory_alloc_aligned_int32_array($1, $2 + 7608 | 0, $2 + 324 | 0) | 0) != 0;
              }
              $2 = $4 & $3;
              $5 = 1;
              $4 = 0;
              if ($2) {
               continue
              }
              break;
             };
             if (!$3) {
              break label$311
             }
             $2 = HEAP32[$6 + 4 >> 2];
             $7 = $2 + 7620 | 0;
             $3 = $2 + 6848 | 0;
             $5 = 0;
             $2 = $1 << 1;
             label$113 : {
              if ($2 >>> 0 > 536870911) {
               break label$113
              }
              $4 = dlmalloc($2 ? $2 << 3 : 1);
              if (!$4) {
               break label$113
              }
              $2 = HEAP32[$7 >> 2];
              if ($2) {
               dlfree($2)
              }
              HEAP32[$7 >> 2] = $4;
              HEAP32[$3 >> 2] = $4;
              $5 = 1;
             }
             $3 = $5;
             $9 = HEAP32[$6 >> 2];
             $2 = HEAP32[$9 + 572 >> 2];
             label$1614 : {
              if (!(!$2 | !$3)) {
               $2 = HEAP32[$14 >> 2];
               if (FLAC__memory_alloc_aligned_int32_array($1 << 1, $2 + 7624 | 0, $2 + 6852 | 0)) {
                break label$1614
               }
               break label$311;
              }
              if (!$3 | $2) {
               break label$28
              }
             }
             $9 = HEAP32[$14 >> 2];
             label$18 : {
              if (HEAP32[$9 >> 2] == ($1 | 0)) {
               break label$18
              }
              $5 = HEAP32[$6 >> 2];
              if (!HEAP32[$5 + 556 >> 2] | !HEAP32[$5 + 40 >> 2]) {
               break label$18
              }
              $9 = 0;
              while (1) {
               label$2017 : {
                label$21 : {
                 label$2218 : {
                  label$2319 : {
                   label$24 : {
                    label$2520 : {
                     label$2621 : {
                      label$2722 : {
                       label$2823 : {
                        label$2924 : {
                         label$30 : {
                          label$3125 : {
                           label$3226 : {
                            label$3327 : {
                             label$3428 : {
                              label$3529 : {
                               label$3630 : {
                                label$3731 : {
                                 label$3832 : {
                                  $3 = ($9 << 4) + $5 | 0;
                                  switch (HEAP32[$3 + 44 >> 2]) {
                                  case 16:
                                   break label$2218;
                                  case 15:
                                   break label$2319;
                                  case 14:
                                   break label$24;
                                  case 13:
                                   break label$2520;
                                  case 12:
                                   break label$2621;
                                  case 11:
                                   break label$2722;
                                  case 10:
                                   break label$2823;
                                  case 9:
                                   break label$2924;
                                  case 8:
                                   break label$30;
                                  case 7:
                                   break label$3125;
                                  case 6:
                                   break label$3226;
                                  case 5:
                                   break label$3327;
                                  case 4:
                                   break label$3428;
                                  case 3:
                                   break label$3529;
                                  case 2:
                                   break label$3630;
                                  case 1:
                                   break label$3731;
                                  case 0:
                                   break label$3832;
                                  default:
                                   break label$21;
                                  };
                                 }
                                 $8 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                                 $10 = 0;
                                 $3 = $1;
                                 $4 = $3 - 1 | 0;
                                 label$115 : {
                                  if ($3 & 1) {
                                   $18 = Math_fround($4 | 0);
                                   label$316 : {
                                    if (($3 | 0) < 0) {
                                     break label$316
                                    }
                                    $10 = (($4 | 0) / 2 | 0) + 1 | 0;
                                    $5 = $10 & 1;
                                    $4 = 0;
                                    if ($3 >>> 0 >= 3) {
                                     $7 = $10 & -2;
                                     while (1) {
                                      $11 = Math_fround($4 | 0);
                                      HEAPF32[($4 << 2) + $8 >> 2] = Math_fround($11 + $11) / $18;
                                      $2 = $4 | 1;
                                      $11 = Math_fround($2 | 0);
                                      HEAPF32[($2 << 2) + $8 >> 2] = Math_fround($11 + $11) / $18;
                                      $4 = $4 + 2 | 0;
                                      $7 = $7 - 2 | 0;
                                      if ($7) {
                                       continue
                                      }
                                      break;
                                     };
                                    }
                                    if (!$5) {
                                     break label$316
                                    }
                                    $11 = Math_fround($4 | 0);
                                    HEAPF32[($4 << 2) + $8 >> 2] = Math_fround($11 + $11) / $18;
                                   }
                                   if (($3 | 0) <= ($10 | 0)) {
                                    break label$115
                                   }
                                   $2 = $10 ^ -1;
                                   if ($3 - $10 & 1) {
                                    $11 = Math_fround($10 | 0);
                                    HEAPF32[($10 << 2) + $8 >> 2] = Math_fround(2.0) - Math_fround(Math_fround($11 + $11) / $18);
                                    $10 = $10 + 1 | 0;
                                   }
                                   if (($2 | 0) == (0 - $3 | 0)) {
                                    break label$115
                                   }
                                   while (1) {
                                    $11 = Math_fround($10 | 0);
                                    HEAPF32[($10 << 2) + $8 >> 2] = Math_fround(2.0) - Math_fround(Math_fround($11 + $11) / $18);
                                    $2 = $10 + 1 | 0;
                                    $11 = Math_fround($2 | 0);
                                    HEAPF32[($2 << 2) + $8 >> 2] = Math_fround(2.0) - Math_fround(Math_fround($11 + $11) / $18);
                                    $10 = $10 + 2 | 0;
                                    if (($10 | 0) != ($3 | 0)) {
                                     continue
                                    }
                                    break;
                                   };
                                   break label$115;
                                  }
                                  $2 = ($3 | 0) / 2 | 0;
                                  $18 = Math_fround($4 | 0);
                                  $4 = 0;
                                  if (($3 | 0) >= 2) {
                                   if (($3 & -2) != 2) {
                                    $10 = $2 & -2;
                                    while (1) {
                                     $11 = Math_fround($4 | 0);
                                     HEAPF32[($4 << 2) + $8 >> 2] = Math_fround($11 + $11) / $18;
                                     $5 = $4 | 1;
                                     $11 = Math_fround($5 | 0);
                                     HEAPF32[($5 << 2) + $8 >> 2] = Math_fround($11 + $11) / $18;
                                     $4 = $4 + 2 | 0;
                                     $10 = $10 - 2 | 0;
                                     if ($10) {
                                      continue
                                     }
                                     break;
                                    };
                                   }
                                   if ($2 & 1) {
                                    $11 = Math_fround($4 | 0);
                                    HEAPF32[($4 << 2) + $8 >> 2] = Math_fround($11 + $11) / $18;
                                   }
                                   $4 = $2;
                                  }
                                  if (($3 | 0) <= ($4 | 0)) {
                                   break label$115
                                  }
                                  $2 = $4 ^ -1;
                                  if ($3 - $4 & 1) {
                                   $11 = Math_fround($4 | 0);
                                   HEAPF32[($4 << 2) + $8 >> 2] = Math_fround(2.0) - Math_fround(Math_fround($11 + $11) / $18);
                                   $4 = $4 + 1 | 0;
                                  }
                                  if (($2 | 0) == (0 - $3 | 0)) {
                                   break label$115
                                  }
                                  while (1) {
                                   $11 = Math_fround($4 | 0);
                                   HEAPF32[($4 << 2) + $8 >> 2] = Math_fround(2.0) - Math_fround(Math_fround($11 + $11) / $18);
                                   $2 = $4 + 1 | 0;
                                   $11 = Math_fround($2 | 0);
                                   HEAPF32[($2 << 2) + $8 >> 2] = Math_fround(2.0) - Math_fround(Math_fround($11 + $11) / $18);
                                   $4 = $4 + 2 | 0;
                                   if (($4 | 0) != ($3 | 0)) {
                                    continue
                                   }
                                   break;
                                  };
                                 }
                                 break label$2017;
                                }
                                $3 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                                $4 = 0;
                                $2 = $1;
                                if (($2 | 0) >= 1) {
                                 $18 = Math_fround($2 - 1 | 0);
                                 while (1) {
                                  $11 = Math_fround(Math_fround($4 | 0) / $18);
                                  (wasm2js_i32$0 = ($4 << 2) + $3 | 0, wasm2js_f32$0 = Math_fround(+Math_fround(Math_abs(Math_fround($11 + Math_fround(-.5)))) * -.47999998927116394 + .6200000047683716 + cos(+$11 * 6.283185307179586) * -.3799999952316284)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                                  $4 = $4 + 1 | 0;
                                  if (($4 | 0) != ($2 | 0)) {
                                   continue
                                  }
                                  break;
                                 };
                                }
                                break label$2017;
                               }
                               $3 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                               $4 = 0;
                               $2 = $1;
                               if (($2 | 0) >= 1) {
                                $19 = +($2 - 1 | 0);
                                while (1) {
                                 $12 = +($4 | 0);
                                 (wasm2js_i32$0 = ($4 << 2) + $3 | 0, wasm2js_f32$0 = Math_fround(cos($12 * 12.566370614359172 / $19) * .07999999821186066 + (cos($12 * 6.283185307179586 / $19) * -.5 + .41999998688697815))), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                                 $4 = $4 + 1 | 0;
                                 if (($4 | 0) != ($2 | 0)) {
                                  continue
                                 }
                                 break;
                                };
                               }
                               break label$2017;
                              }
                              $3 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                              $4 = 0;
                              $2 = $1;
                              if (($2 | 0) >= 1) {
                               $19 = +($2 - 1 | 0);
                               while (1) {
                                $12 = +($4 | 0);
                                (wasm2js_i32$0 = ($4 << 2) + $3 | 0, wasm2js_f32$0 = Math_fround(cos($12 * 12.566370614359172 / $19) * .14127999544143677 + (cos($12 * 6.283185307179586 / $19) * -.488290011882782 + .35874998569488525) + cos($12 * 18.84955592153876 / $19) * -.011680000461637974)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                                $4 = $4 + 1 | 0;
                                if (($4 | 0) != ($2 | 0)) {
                                 continue
                                }
                                break;
                               };
                              }
                              break label$2017;
                             }
                             $5 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                             $7 = 0;
                             $2 = $1;
                             label$124 : {
                              if (($2 | 0) < 1) {
                               break label$124
                              }
                              $19 = +($2 - 1 | 0) * .5;
                              if (($2 | 0) != 1) {
                               $4 = $2 & -2;
                               while (1) {
                                $12 = (+($7 | 0) - $19) / $19;
                                $12 = 1.0 - $12 * $12;
                                HEAPF32[($7 << 2) + $5 >> 2] = $12 * $12;
                                $3 = $7 | 1;
                                $12 = (+($3 | 0) - $19) / $19;
                                $12 = 1.0 - $12 * $12;
                                HEAPF32[($3 << 2) + $5 >> 2] = $12 * $12;
                                $7 = $7 + 2 | 0;
                                $4 = $4 - 2 | 0;
                                if ($4) {
                                 continue
                                }
                                break;
                               };
                              }
                              if (!($2 & 1)) {
                               break label$124
                              }
                              $12 = (+($7 | 0) - $19) / $19;
                              $12 = 1.0 - $12 * $12;
                              HEAPF32[($7 << 2) + $5 >> 2] = $12 * $12;
                             }
                             break label$2017;
                            }
                            $3 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                            $4 = 0;
                            $2 = $1;
                            if (($2 | 0) >= 1) {
                             $29 = +($2 - 1 | 0);
                             while (1) {
                              $30 = +($4 | 0);
                              $26 = cos($30 * 12.566370614359172 / $29);
                              $19 = cos($30 * 6.283185307179586 / $29);
                              $12 = cos($30 * 18.84955592153876 / $29);
                              (wasm2js_i32$0 = ($4 << 2) + $3 | 0, wasm2js_f32$0 = Math_fround(cos($30 * 25.132741228718345 / $29) * 6.9473679177463055e-03 + ($26 * .27726316452026367 + ($19 * -.4166315793991089 + .21557894349098206) + $12 * -.08357894420623779))), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                              $4 = $4 + 1 | 0;
                              if (($4 | 0) != ($2 | 0)) {
                               continue
                              }
                              break;
                             };
                            }
                            break label$2017;
                           }
                           $5 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                           $11 = HEAPF32[$3 + 48 >> 2];
                           $7 = 0;
                           $2 = $1;
                           label$127 : {
                            if (($2 | 0) < 1) {
                             break label$127
                            }
                            $26 = +($2 - 1 | 0) * .5;
                            $19 = $26 * +$11;
                            if (($2 | 0) != 1) {
                             $4 = $2 & -2;
                             while (1) {
                              $12 = (+($7 | 0) - $26) / $19;
                              (wasm2js_i32$0 = ($7 << 2) + $5 | 0, wasm2js_f32$0 = Math_fround(exp($12 * ($12 * -.5)))), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                              $3 = $7 | 1;
                              $12 = (+($3 | 0) - $26) / $19;
                              (wasm2js_i32$0 = ($3 << 2) + $5 | 0, wasm2js_f32$0 = Math_fround(exp($12 * ($12 * -.5)))), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                              $7 = $7 + 2 | 0;
                              $4 = $4 - 2 | 0;
                              if ($4) {
                               continue
                              }
                              break;
                             };
                            }
                            if (!($2 & 1)) {
                             break label$127
                            }
                            $12 = (+($7 | 0) - $26) / $19;
                            (wasm2js_i32$0 = ($7 << 2) + $5 | 0, wasm2js_f32$0 = Math_fround(exp($12 * ($12 * -.5)))), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                           }
                           break label$2017;
                          }
                          $5 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                          $7 = 0;
                          $2 = $1;
                          label$129 : {
                           if (($2 | 0) < 1) {
                            break label$129
                           }
                           $12 = +($2 - 1 | 0);
                           if (($2 | 0) != 1) {
                            $4 = $2 & -2;
                            while (1) {
                             (wasm2js_i32$0 = ($7 << 2) + $5 | 0, wasm2js_f32$0 = Math_fround(.5400000214576721 - cos(+($7 | 0) * 6.283185307179586 / $12) * .46000000834465027)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                             $3 = $7 | 1;
                             (wasm2js_i32$0 = ($3 << 2) + $5 | 0, wasm2js_f32$0 = Math_fround(.5400000214576721 - cos(+($3 | 0) * 6.283185307179586 / $12) * .46000000834465027)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                             $7 = $7 + 2 | 0;
                             $4 = $4 - 2 | 0;
                             if ($4) {
                              continue
                             }
                             break;
                            };
                           }
                           if (!($2 & 1)) {
                            break label$129
                           }
                           (wasm2js_i32$0 = ($7 << 2) + $5 | 0, wasm2js_f32$0 = Math_fround(cos(+($7 | 0) * 6.283185307179586 / $12) * -.46000000834465027 + .5400000214576721)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                          }
                          break label$2017;
                         }
                         FLAC__window_hann(HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2], $1);
                         break label$2017;
                        }
                        $3 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                        $4 = 0;
                        $2 = $1;
                        if (($2 | 0) >= 1) {
                         $19 = +($2 - 1 | 0);
                         while (1) {
                          $12 = +($4 | 0);
                          (wasm2js_i32$0 = ($4 << 2) + $3 | 0, wasm2js_f32$0 = Math_fround(cos($12 * 12.566370614359172 / $19) * .09799999743700027 + (cos($12 * 6.283185307179586 / $19) * -.49799999594688416 + .4020000100135803) + cos($12 * 18.84955592153876 / $19) * -1.0000000474974513e-03)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                          $4 = $4 + 1 | 0;
                          if (($4 | 0) != ($2 | 0)) {
                           continue
                          }
                          break;
                         };
                        }
                        break label$2017;
                       }
                       $3 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                       $4 = 0;
                       $2 = $1;
                       if (($2 | 0) >= 1) {
                        $19 = +($2 - 1 | 0);
                        while (1) {
                         $12 = +($4 | 0);
                         (wasm2js_i32$0 = ($4 << 2) + $3 | 0, wasm2js_f32$0 = Math_fround(cos($12 * 12.566370614359172 / $19) * .13659949600696564 + (cos($12 * 6.283185307179586 / $19) * -.48917749524116516 + .36358189582824707) + cos($12 * 18.84955592153876 / $19) * -.010641099885106087)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                         $4 = $4 + 1 | 0;
                         if (($4 | 0) != ($2 | 0)) {
                          continue
                         }
                         break;
                        };
                       }
                       break label$2017;
                      }
                      $7 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                      $4 = 0;
                      $2 = $1;
                      label$133 : {
                       if (($2 | 0) < 1) {
                        break label$133
                       }
                       $3 = $2 & 7;
                       if ($2 - 1 >>> 0 >= 7) {
                        $2 = $2 & -8;
                        while (1) {
                         $5 = $4 << 2;
                         HEAP32[$5 + $7 >> 2] = 1065353216;
                         HEAP32[($5 | 4) + $7 >> 2] = 1065353216;
                         HEAP32[($5 | 8) + $7 >> 2] = 1065353216;
                         HEAP32[($5 | 12) + $7 >> 2] = 1065353216;
                         HEAP32[($5 | 16) + $7 >> 2] = 1065353216;
                         HEAP32[($5 | 20) + $7 >> 2] = 1065353216;
                         HEAP32[($5 | 24) + $7 >> 2] = 1065353216;
                         HEAP32[($5 | 28) + $7 >> 2] = 1065353216;
                         $4 = $4 + 8 | 0;
                         $2 = $2 - 8 | 0;
                         if ($2) {
                          continue
                         }
                         break;
                        };
                       }
                       if (!$3) {
                        break label$133
                       }
                       while (1) {
                        HEAP32[($4 << 2) + $7 >> 2] = 1065353216;
                        $4 = $4 + 1 | 0;
                        $3 = $3 - 1 | 0;
                        if ($3) {
                         continue
                        }
                        break;
                       };
                      }
                      break label$2017;
                     }
                     $10 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                     $4 = $1;
                     $18 = Math_fround(Math_fround($4 | 0) + Math_fround(1.0));
                     $2 = 1;
                     label$136 : {
                      if ($4 & 1) {
                       label$337 : {
                        if (($4 | 0) < 1) {
                         break label$337
                        }
                        $5 = $4 + 1 | 0;
                        $2 = ($5 | 0) / 2 | 0;
                        $8 = ($2 | 0) > 1 ? $2 : 1;
                        $7 = $8 & 1;
                        $3 = 1;
                        if (($5 | 0) >= 4) {
                         $2 = $8 & 2147483646;
                         while (1) {
                          $5 = ($3 << 2) + $10 | 0;
                          $11 = Math_fround($3 | 0);
                          HEAPF32[$5 - 4 >> 2] = Math_fround($11 + $11) / $18;
                          $11 = Math_fround($3 + 1 | 0);
                          HEAPF32[$5 >> 2] = Math_fround($11 + $11) / $18;
                          $3 = $3 + 2 | 0;
                          $2 = $2 - 2 | 0;
                          if ($2) {
                           continue
                          }
                          break;
                         };
                        }
                        $2 = $8 + 1 | 0;
                        if (!$7) {
                         break label$337
                        }
                        $11 = Math_fround($3 | 0);
                        HEAPF32[(($3 << 2) + $10 | 0) - 4 >> 2] = Math_fround($11 + $11) / $18;
                       }
                       if (($2 | 0) > ($4 | 0)) {
                        break label$136
                       }
                       $3 = $2;
                       $5 = $4 - $2 | 0;
                       if ($5 + 1 & 1) {
                        HEAPF32[(($2 << 2) + $10 | 0) - 4 >> 2] = Math_fround(($5 << 1) + 2 | 0) / $18;
                        $3 = $2 + 1 | 0;
                       }
                       if (($2 | 0) == ($4 | 0)) {
                        break label$136
                       }
                       while (1) {
                        $2 = ($3 << 2) + $10 | 0;
                        HEAPF32[$2 - 4 >> 2] = Math_fround(($4 - $3 << 1) + 2 | 0) / $18;
                        $5 = $2;
                        $2 = $3 + 1 | 0;
                        HEAPF32[$5 >> 2] = Math_fround(($4 - $2 << 1) + 2 | 0) / $18;
                        $3 = $3 + 2 | 0;
                        if (($2 | 0) != ($4 | 0)) {
                         continue
                        }
                        break;
                       };
                       break label$136;
                      }
                      label$840 : {
                       if (($4 | 0) < 2) {
                        break label$840
                       }
                       $3 = 1;
                       $7 = $4 >>> 1 | 0;
                       if (($7 | 0) != 1) {
                        $2 = $7 & 2147483646;
                        while (1) {
                         $5 = ($3 << 2) + $10 | 0;
                         $11 = Math_fround($3 | 0);
                         HEAPF32[$5 - 4 >> 2] = Math_fround($11 + $11) / $18;
                         $11 = Math_fround($3 + 1 | 0);
                         HEAPF32[$5 >> 2] = Math_fround($11 + $11) / $18;
                         $3 = $3 + 2 | 0;
                         $2 = $2 - 2 | 0;
                         if ($2) {
                          continue
                         }
                         break;
                        };
                       }
                       $2 = $7 + 1 | 0;
                       if (!($4 & 2)) {
                        break label$840
                       }
                       $11 = Math_fround($3 | 0);
                       HEAPF32[(($3 << 2) + $10 | 0) - 4 >> 2] = Math_fround($11 + $11) / $18;
                      }
                      if (($2 | 0) > ($4 | 0)) {
                       break label$136
                      }
                      $3 = $2;
                      $5 = $4 - $2 | 0;
                      if ($5 + 1 & 1) {
                       HEAPF32[(($2 << 2) + $10 | 0) - 4 >> 2] = Math_fround(($5 << 1) + 2 | 0) / $18;
                       $3 = $2 + 1 | 0;
                      }
                      if (($2 | 0) == ($4 | 0)) {
                       break label$136
                      }
                      while (1) {
                       $2 = ($3 << 2) + $10 | 0;
                       HEAPF32[$2 - 4 >> 2] = Math_fround(($4 - $3 << 1) + 2 | 0) / $18;
                       $5 = $2;
                       $2 = $3 + 1 | 0;
                       HEAPF32[$5 >> 2] = Math_fround(($4 - $2 << 1) + 2 | 0) / $18;
                       $3 = $3 + 2 | 0;
                       if (($2 | 0) != ($4 | 0)) {
                        continue
                       }
                       break;
                      };
                     }
                     break label$2017;
                    }
                    $10 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                    $2 = $1;
                    $8 = 0;
                    $7 = 0;
                    $11 = HEAPF32[$3 + 48 >> 2];
                    __inlined_func$FLAC__window_tukey : {
                     if ($11 <= Math_fround(0.0)) {
                      if (($2 | 0) < 1) {
                       break __inlined_func$FLAC__window_tukey
                      }
                      $8 = $2 & 7;
                      if ($2 - 1 >>> 0 >= 7) {
                       $3 = $2 & -8;
                       while (1) {
                        $2 = $7 << 2;
                        HEAP32[$2 + $10 >> 2] = 1065353216;
                        HEAP32[($2 | 4) + $10 >> 2] = 1065353216;
                        HEAP32[($2 | 8) + $10 >> 2] = 1065353216;
                        HEAP32[($2 | 12) + $10 >> 2] = 1065353216;
                        HEAP32[($2 | 16) + $10 >> 2] = 1065353216;
                        HEAP32[($2 | 20) + $10 >> 2] = 1065353216;
                        HEAP32[($2 | 24) + $10 >> 2] = 1065353216;
                        HEAP32[($2 | 28) + $10 >> 2] = 1065353216;
                        $7 = $7 + 8 | 0;
                        $3 = $3 - 8 | 0;
                        if ($3) {
                         continue
                        }
                        break;
                       };
                      }
                      if (!$8) {
                       break __inlined_func$FLAC__window_tukey
                      }
                      while (1) {
                       HEAP32[($7 << 2) + $10 >> 2] = 1065353216;
                       $7 = $7 + 1 | 0;
                       $8 = $8 - 1 | 0;
                       if ($8) {
                        continue
                       }
                       break;
                      };
                      break __inlined_func$FLAC__window_tukey;
                     }
                     if ($11 >= Math_fround(1.0)) {
                      if (($2 | 0) < 1) {
                       break __inlined_func$FLAC__window_tukey
                      }
                      $12 = +($2 - 1 | 0);
                      if (($2 | 0) != 1) {
                       $7 = $2 & -2;
                       while (1) {
                        (wasm2js_i32$0 = ($8 << 2) + $10 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($8 | 0) * 6.283185307179586 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                        $3 = $8 | 1;
                        (wasm2js_i32$0 = ($3 << 2) + $10 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($3 | 0) * 6.283185307179586 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                        $8 = $8 + 2 | 0;
                        $7 = $7 - 2 | 0;
                        if ($7) {
                         continue
                        }
                        break;
                       };
                      }
                      if (!($2 & 1)) {
                       break __inlined_func$FLAC__window_tukey
                      }
                      (wasm2js_i32$0 = ($8 << 2) + $10 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($8 | 0) * 6.283185307179586 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                      break __inlined_func$FLAC__window_tukey;
                     }
                     $11 = Math_fround(Math_fround($11 * Math_fround(.5)) * Math_fround($2 | 0));
                     label$947 : {
                      if (Math_fround(Math_abs($11)) < Math_fround(2147483648.0)) {
                       $4 = ~~$11;
                       break label$947;
                      }
                      $4 = -2147483648;
                     }
                     label$1148 : {
                      if (($2 | 0) < 1) {
                       break label$1148
                      }
                      $8 = $2 & 7;
                      if ($2 - 1 >>> 0 >= 7) {
                       $3 = $2 & -8;
                       while (1) {
                        $5 = $7 << 2;
                        HEAP32[$5 + $10 >> 2] = 1065353216;
                        HEAP32[($5 | 4) + $10 >> 2] = 1065353216;
                        HEAP32[($5 | 8) + $10 >> 2] = 1065353216;
                        HEAP32[($5 | 12) + $10 >> 2] = 1065353216;
                        HEAP32[($5 | 16) + $10 >> 2] = 1065353216;
                        HEAP32[($5 | 20) + $10 >> 2] = 1065353216;
                        HEAP32[($5 | 24) + $10 >> 2] = 1065353216;
                        HEAP32[($5 | 28) + $10 >> 2] = 1065353216;
                        $7 = $7 + 8 | 0;
                        $3 = $3 - 8 | 0;
                        if ($3) {
                         continue
                        }
                        break;
                       };
                      }
                      if (!$8) {
                       break label$1148
                      }
                      while (1) {
                       HEAP32[($7 << 2) + $10 >> 2] = 1065353216;
                       $7 = $7 + 1 | 0;
                       $8 = $8 - 1 | 0;
                       if ($8) {
                        continue
                       }
                       break;
                      };
                     }
                     if (($4 | 0) < 2) {
                      break __inlined_func$FLAC__window_tukey
                     }
                     $3 = $2 - $4 | 0;
                     $2 = $4 - 1 | 0;
                     $12 = +($2 | 0);
                     $8 = 0;
                     while (1) {
                      (wasm2js_i32$0 = ($8 << 2) + $10 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($8 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                      (wasm2js_i32$0 = ($3 + $8 << 2) + $10 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($2 + $8 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                      $8 = $8 + 1 | 0;
                      if (($4 | 0) != ($8 | 0)) {
                       continue
                      }
                      break;
                     };
                    }
                    break label$2017;
                   }
                   $7 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                   $2 = $1;
                   $18 = HEAPF32[$3 + 48 >> 2];
                   $31 = HEAPF32[$3 + 52 >> 2];
                   $32 = HEAPF32[$3 + 56 >> 2];
                   $10 = 0;
                   while (1) {
                    $11 = $18;
                    $18 = Math_fround(.05000000074505806);
                    if ($11 <= Math_fround(0.0)) {
                     continue
                    }
                    $18 = Math_fround(.949999988079071);
                    if ($11 >= Math_fround(1.0)) {
                     continue
                    }
                    break;
                   };
                   $28 = Math_fround($2 | 0);
                   $18 = Math_fround($28 * $31);
                   label$253 : {
                    if (Math_fround(Math_abs($18)) < Math_fround(2147483648.0)) {
                     $3 = ~~$18;
                     break label$253;
                    }
                    $3 = -2147483648;
                   }
                   $18 = Math_fround($11 * Math_fround(.5));
                   $11 = Math_fround($28 * $32);
                   label$455 : {
                    if (Math_fround(Math_abs($11)) < Math_fround(2147483648.0)) {
                     $5 = ~~$11;
                     break label$455;
                    }
                    $5 = -2147483648;
                   }
                   $11 = Math_fround($18 * Math_fround($5 - $3 | 0));
                   label$654 : {
                    if (Math_fround(Math_abs($11)) < Math_fround(2147483648.0)) {
                     $8 = ~~$11;
                     break label$654;
                    }
                    $8 = -2147483648;
                   }
                   $4 = 1;
                   label$856 : {
                    if (($3 | 0) < 1 | ($2 | 0) <= 0) {
                     break label$856
                    }
                    while (1) {
                     HEAP32[($10 << 2) + $7 >> 2] = 0;
                     $10 = $10 + 1 | 0;
                     if (($10 | 0) >= ($3 | 0)) {
                      break label$856
                     }
                     if (($2 | 0) > ($10 | 0)) {
                      continue
                     }
                     break;
                    };
                   }
                   $12 = +($8 | 0);
                   $3 = $3 + $8 | 0;
                   label$1058 : {
                    if (($2 | 0) <= ($10 | 0) | ($3 | 0) <= ($10 | 0)) {
                     break label$1058
                    }
                    while (1) {
                     (wasm2js_i32$0 = ($10 << 2) + $7 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($4 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                     $10 = $10 + 1 | 0;
                     if (($3 | 0) <= ($10 | 0)) {
                      break label$1058
                     }
                     $4 = $4 + 1 | 0;
                     if (($2 | 0) > ($10 | 0)) {
                      continue
                     }
                     break;
                    };
                   }
                   $3 = $5 - $8 | 0;
                   label$1260 : {
                    if (($2 | 0) <= ($10 | 0) | ($3 | 0) <= ($10 | 0)) {
                     break label$1260
                    }
                    while (1) {
                     HEAP32[($10 << 2) + $7 >> 2] = 1065353216;
                     $10 = $10 + 1 | 0;
                     if (($3 | 0) <= ($10 | 0)) {
                      break label$1260
                     }
                     if (($2 | 0) > ($10 | 0)) {
                      continue
                     }
                     break;
                    };
                   }
                   label$1462 : {
                    if (($2 | 0) <= ($10 | 0) | ($5 | 0) <= ($10 | 0)) {
                     break label$1462
                    }
                    while (1) {
                     (wasm2js_i32$0 = ($10 << 2) + $7 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($8 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                     $10 = $10 + 1 | 0;
                     if (($10 | 0) >= ($5 | 0)) {
                      break label$1462
                     }
                     $8 = $8 - 1 | 0;
                     if (($2 | 0) > ($10 | 0)) {
                      continue
                     }
                     break;
                    };
                   }
                   if (($2 | 0) > ($10 | 0)) {
                    memset(($10 << 2) + $7 | 0, $2 - $10 << 2)
                   }
                   break label$2017;
                  }
                  $8 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                  $2 = $1;
                  $18 = HEAPF32[$3 + 48 >> 2];
                  $31 = HEAPF32[$3 + 52 >> 2];
                  $32 = HEAPF32[$3 + 56 >> 2];
                  $16 = 0;
                  while (1) {
                   $11 = $18;
                   $18 = Math_fround(.05000000074505806);
                   if ($11 <= Math_fround(0.0)) {
                    continue
                   }
                   $18 = Math_fround(.949999988079071);
                   if ($11 >= Math_fround(1.0)) {
                    continue
                   }
                   break;
                  };
                  $7 = 1;
                  $28 = Math_fround($11 * Math_fround(.5));
                  $34 = $28;
                  $18 = Math_fround($2 | 0);
                  $11 = Math_fround($18 * $31);
                  label$266 : {
                   if (Math_fround(Math_abs($11)) < Math_fround(2147483648.0)) {
                    $5 = ~~$11;
                    break label$266;
                   }
                   $5 = -2147483648;
                  }
                  $11 = Math_fround($34 * Math_fround($5 | 0));
                  label$465 : {
                   if (Math_fround(Math_abs($11)) < Math_fround(2147483648.0)) {
                    $15 = ~~$11;
                    break label$465;
                   }
                   $15 = -2147483648;
                  }
                  $3 = ($15 | 0) < 1;
                  $10 = $2;
                  $11 = Math_fround($18 * $32);
                  label$668 : {
                   if (Math_fround(Math_abs($11)) < Math_fround(2147483648.0)) {
                    $4 = ~~$11;
                    break label$668;
                   }
                   $4 = -2147483648;
                  }
                  $11 = Math_fround($28 * Math_fround($10 - $4 | 0));
                  label$867 : {
                   if (Math_fround(Math_abs($11)) < Math_fround(2147483648.0)) {
                    $10 = ~~$11;
                    break label$867;
                   }
                   $10 = -2147483648;
                  }
                  $12 = +($15 | 0);
                  label$1069 : {
                   if (($2 | 0) <= 0 | $3) {
                    break label$1069
                   }
                   while (1) {
                    (wasm2js_i32$0 = ($16 << 2) + $8 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($7 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                    $16 = $16 + 1 | 0;
                    if (($16 | 0) >= ($15 | 0)) {
                     break label$1069
                    }
                    $7 = $7 + 1 | 0;
                    if (($2 | 0) > ($16 | 0)) {
                     continue
                    }
                    break;
                   };
                  }
                  $3 = $5 - $15 | 0;
                  label$1271 : {
                   if (($2 | 0) <= ($16 | 0) | ($3 | 0) <= ($16 | 0)) {
                    break label$1271
                   }
                   while (1) {
                    HEAP32[($16 << 2) + $8 >> 2] = 1065353216;
                    $16 = $16 + 1 | 0;
                    if (($3 | 0) <= ($16 | 0)) {
                     break label$1271
                    }
                    if (($2 | 0) > ($16 | 0)) {
                     continue
                    }
                    break;
                   };
                  }
                  label$1473 : {
                   if (($2 | 0) <= ($16 | 0) | ($5 | 0) <= ($16 | 0)) {
                    break label$1473
                   }
                   while (1) {
                    (wasm2js_i32$0 = ($16 << 2) + $8 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($15 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                    $16 = $16 + 1 | 0;
                    if (($16 | 0) >= ($5 | 0)) {
                     break label$1473
                    }
                    $15 = $15 - 1 | 0;
                    if (($2 | 0) > ($16 | 0)) {
                     continue
                    }
                    break;
                   };
                  }
                  label$1675 : {
                   if (($2 | 0) <= ($16 | 0) | ($4 | 0) <= ($16 | 0)) {
                    break label$1675
                   }
                   while (1) {
                    HEAP32[($16 << 2) + $8 >> 2] = 0;
                    $16 = $16 + 1 | 0;
                    if (($16 | 0) >= ($4 | 0)) {
                     break label$1675
                    }
                    if (($2 | 0) > ($16 | 0)) {
                     continue
                    }
                    break;
                   };
                  }
                  $12 = +($10 | 0);
                  $3 = $4 + $10 | 0;
                  label$1877 : {
                   if (($2 | 0) <= ($16 | 0) | ($3 | 0) <= ($16 | 0)) {
                    break label$1877
                   }
                   $15 = 1;
                   while (1) {
                    (wasm2js_i32$0 = ($16 << 2) + $8 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($15 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                    $16 = $16 + 1 | 0;
                    if (($3 | 0) <= ($16 | 0)) {
                     break label$1877
                    }
                    $15 = $15 + 1 | 0;
                    if (($2 | 0) > ($16 | 0)) {
                     continue
                    }
                    break;
                   };
                  }
                  $3 = $2 - $10 | 0;
                  label$2079 : {
                   if (($2 | 0) <= ($16 | 0) | ($3 | 0) <= ($16 | 0)) {
                    break label$2079
                   }
                   while (1) {
                    HEAP32[($16 << 2) + $8 >> 2] = 1065353216;
                    $16 = $16 + 1 | 0;
                    if (($3 | 0) <= ($16 | 0)) {
                     break label$2079
                    }
                    if (($2 | 0) > ($16 | 0)) {
                     continue
                    }
                    break;
                   };
                  }
                  label$2281 : {
                   if (($2 | 0) <= ($16 | 0)) {
                    break label$2281
                   }
                   $3 = $16 ^ -1;
                   if ($2 - $16 & 1) {
                    (wasm2js_i32$0 = ($16 << 2) + $8 | 0, wasm2js_f32$0 = Math_fround(.5 - cos($12 * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                    $16 = $16 + 1 | 0;
                    $10 = $10 - 1 | 0;
                   }
                   if (($3 | 0) == (0 - $2 | 0)) {
                    break label$2281
                   }
                   while (1) {
                    $3 = ($16 << 2) + $8 | 0;
                    (wasm2js_i32$0 = $3, wasm2js_f32$0 = Math_fround(.5 - cos(+($10 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                    (wasm2js_i32$0 = $3 + 4 | 0, wasm2js_f32$0 = Math_fround(.5 - cos(+($10 - 1 | 0) * 3.141592653589793 / $12) * .5)), HEAPF32[wasm2js_i32$0 >> 2] = wasm2js_f32$0;
                    $10 = $10 - 2 | 0;
                    $16 = $16 + 2 | 0;
                    if (($16 | 0) != ($2 | 0)) {
                     continue
                    }
                    break;
                   };
                  }
                  break label$2017;
                 }
                 $5 = HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2];
                 $7 = 0;
                 $2 = $1;
                 label$183 : {
                  if (($2 | 0) < 1) {
                   break label$183
                  }
                  $19 = +($2 - 1 | 0) * .5;
                  if (($2 | 0) != 1) {
                   $4 = $2 & -2;
                   while (1) {
                    $12 = (+($7 | 0) - $19) / $19;
                    HEAPF32[($7 << 2) + $5 >> 2] = 1.0 - $12 * $12;
                    $3 = $7 | 1;
                    $12 = (+($3 | 0) - $19) / $19;
                    HEAPF32[($3 << 2) + $5 >> 2] = 1.0 - $12 * $12;
                    $7 = $7 + 2 | 0;
                    $4 = $4 - 2 | 0;
                    if ($4) {
                     continue
                    }
                    break;
                   };
                  }
                  if (!($2 & 1)) {
                   break label$183
                  }
                  $12 = (+($7 | 0) - $19) / $19;
                  HEAPF32[($7 << 2) + $5 >> 2] = 1.0 - $12 * $12;
                 }
                 break label$2017;
                }
                FLAC__window_hann(HEAP32[(HEAP32[$14 >> 2] + ($9 << 2) | 0) + 84 >> 2], $1);
               }
               $9 = $9 + 1 | 0;
               $5 = HEAP32[$6 >> 2];
               if ($9 >>> 0 < HEAPU32[$5 + 40 >> 2]) {
                continue
               }
               break;
              };
              $9 = HEAP32[$14 >> 2];
             }
             HEAP32[$9 >> 2] = $1;
             $1 = 1;
             break __inlined_func$resize_buffers_;
            }
            $3 = $9 << 3;
            $2 = $3 + HEAP32[$14 >> 2] | 0;
            $2 = FLAC__memory_alloc_aligned_int32_array($1, $2 + 7540 | 0, $2 + 256 | 0);
            label$39 : {
             if (!$2) {
              $2 = ($2 | 0) != 0;
              break label$39;
             }
             $2 = $3 + HEAP32[$14 >> 2] | 0;
             $2 = (FLAC__memory_alloc_aligned_int32_array($1, $2 + 7544 | 0, $2 + 260 | 0) | 0) != 0;
            }
            $9 = $9 + 1 | 0;
            if ($2) {
             continue
            }
            break;
           };
           break label$311;
          }
          $4 = $9 << 2;
          $2 = $4 + HEAP32[$14 >> 2] | 0;
          $3 = FLAC__memory_alloc_aligned_int32_array($5, $2 + 7328 | 0, $2 + 4 | 0);
          $2 = HEAP32[($4 + HEAP32[$14 >> 2] | 0) + 4 >> 2];
          HEAP32[$2 >> 2] = 0;
          HEAP32[$2 + 4 >> 2] = 0;
          $2 = $2 + 8 | 0;
          HEAP32[$2 >> 2] = 0;
          HEAP32[$2 + 4 >> 2] = 0;
          $2 = ($4 + HEAP32[$14 >> 2] | 0) + 4 | 0;
          HEAP32[$2 >> 2] = HEAP32[$2 >> 2] + 16;
          $9 = $9 + 1 | 0;
          if ($3) {
           continue
          }
         }
         break;
        };
        $9 = HEAP32[$6 >> 2];
       }
       HEAP32[$9 >> 2] = 8;
       $1 = 0;
      }
     } else {
      $1 = 1
     }
     if (!$1) {
      break label$1
     }
     $1 = HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2];
     HEAP32[$1 + 16 >> 2] = 0;
     HEAP32[$1 + 8 >> 2] = 8192;
     HEAP32[$1 + 12 >> 2] = 0;
     $2 = $1;
     $1 = dlmalloc(32768);
     HEAP32[$2 >> 2] = $1;
     $8 = HEAP32[$0 >> 2];
     if (!$1) {
      HEAP32[$8 >> 2] = 8;
      break label$1;
     }
     if (HEAP32[$8 + 4 >> 2]) {
      $2 = HEAP32[$0 + 4 >> 2];
      $1 = HEAP32[$8 + 36 >> 2] + 1 | 0;
      HEAP32[$2 + 11796 >> 2] = $1;
      label$54 : {
       if (!HEAP32[$8 + 24 >> 2]) {
        break label$54
       }
       $1 = safe_malloc_mul_2op_p(4, $1);
       HEAP32[HEAP32[$0 + 4 >> 2] + 11764 >> 2] = $1;
       $8 = HEAP32[$0 >> 2];
       if ($1) {
        while (1) {
         $2 = HEAP32[$0 + 4 >> 2];
         if (HEAPU32[$8 + 24 >> 2] <= $17 >>> 0) {
          break label$54
         }
         $1 = safe_malloc_mul_2op_p(4, HEAP32[$2 + 11796 >> 2]);
         HEAP32[(HEAP32[$0 + 4 >> 2] + ($17 << 2) | 0) + 11764 >> 2] = $1;
         $17 = $17 + 1 | 0;
         $8 = HEAP32[$0 >> 2];
         if ($1) {
          continue
         }
         break;
        }
       }
       HEAP32[$8 >> 2] = 8;
       $17 = 1;
       break label$1;
      }
      HEAP32[$2 + 11800 >> 2] = 0;
      label$57 : {
       $2 = HEAP32[$2 + 11752 >> 2];
       if ($2) {
        break label$57
       }
       $2 = FLAC__stream_decoder_new();
       HEAP32[HEAP32[$0 + 4 >> 2] + 11752 >> 2] = $2;
       if ($2) {
        break label$57
       }
       HEAP32[HEAP32[$0 >> 2] >> 2] = 3;
       $17 = 1;
       break label$1;
      }
      $1 = FLAC__stream_decoder_init_stream($2, 18, 0, 0, 0, 0, 19, 20, 21, $0);
      $8 = HEAP32[$0 >> 2];
      if ($1) {
       break label$48
      }
      $2 = !HEAP32[$8 + 4 >> 2];
     } else {
      $2 = 1
     }
     $3 = HEAP32[$0 + 4 >> 2];
     HEAP32[$3 + 7312 >> 2] = 0;
     HEAP32[$3 + 7316 >> 2] = 0;
     HEAP32[$3 + 7292 >> 2] = 0;
     $1 = $3 + 11816 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     $1 = $3 + 11824 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     $1 = $3 + 11832 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     HEAP32[$3 + 11840 >> 2] = 0;
     $1 = $8 + 624 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     $1 = $8 + 616 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     HEAP32[$8 + 608 >> 2] = 0;
     HEAP32[$8 + 612 >> 2] = 0;
     if (!$2) {
      HEAP32[$3 + 11756 >> 2] = 0
     }
     if (!FLAC__bitwriter_write_raw_uint32(HEAP32[$3 + 6856 >> 2], HEAP32[1631], HEAP32[1632])) {
      HEAP32[HEAP32[$0 >> 2] >> 2] = 7;
      $17 = 1;
      break label$1;
     }
     $17 = 1;
     if (!write_bitbuffer_($0, 0, 0)) {
      break label$1
     }
     $2 = HEAP32[$0 + 4 >> 2];
     $1 = HEAP32[$0 >> 2];
     if (HEAP32[$1 + 4 >> 2]) {
      HEAP32[$2 + 11756 >> 2] = 1
     }
     HEAP32[$2 + 6872 >> 2] = 0;
     HEAP32[$2 + 6876 >> 2] = 0;
     HEAP32[$2 + 6880 >> 2] = 34;
     HEAP32[$2 + 6888 >> 2] = HEAP32[$1 + 36 >> 2];
     HEAP32[HEAP32[$0 + 4 >> 2] + 6892 >> 2] = HEAP32[HEAP32[$0 >> 2] + 36 >> 2];
     HEAP32[HEAP32[$0 + 4 >> 2] + 6896 >> 2] = 0;
     HEAP32[HEAP32[$0 + 4 >> 2] + 6900 >> 2] = 0;
     HEAP32[HEAP32[$0 + 4 >> 2] + 6904 >> 2] = HEAP32[HEAP32[$0 >> 2] + 32 >> 2];
     HEAP32[HEAP32[$0 + 4 >> 2] + 6908 >> 2] = HEAP32[HEAP32[$0 >> 2] + 24 >> 2];
     HEAP32[HEAP32[$0 + 4 >> 2] + 6912 >> 2] = HEAP32[HEAP32[$0 >> 2] + 28 >> 2];
     $3 = HEAP32[$0 >> 2];
     $2 = HEAP32[$3 + 596 >> 2];
     $1 = HEAP32[$0 + 4 >> 2] + 6920 | 0;
     HEAP32[$1 >> 2] = HEAP32[$3 + 592 >> 2];
     HEAP32[$1 + 4 >> 2] = $2;
     $2 = HEAP32[$0 + 4 >> 2];
     $1 = $2 + 6936 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     $1 = $2 + 6928 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     if (HEAP32[HEAP32[$0 >> 2] + 12 >> 2]) {
      FLAC__MD5Init(HEAP32[$0 + 4 >> 2] + 7060 | 0)
     }
     $1 = HEAP32[$0 + 4 >> 2];
     if (!FLAC__add_metadata_block($1 + 6872 | 0, HEAP32[$1 + 6856 >> 2])) {
      HEAP32[HEAP32[$0 >> 2] >> 2] = 7;
      break label$1;
     }
     if (!write_bitbuffer_($0, 0, 0)) {
      break label$1
     }
     HEAP32[HEAP32[$0 + 4 >> 2] + 6896 >> 2] = -1 << HEAP32[1635] ^ -1;
     $1 = HEAP32[$0 + 4 >> 2] + 6920 | 0;
     HEAP32[$1 >> 2] = 0;
     HEAP32[$1 + 4 >> 2] = 0;
     if (!$13) {
      HEAP32[$24 >> 2] = 4;
      $2 = HEAP32[HEAP32[$0 >> 2] + 604 >> 2];
      $1 = $24 + 24 | 0;
      HEAP32[$1 >> 2] = 0;
      HEAP32[$1 + 4 >> 2] = 0;
      HEAP32[$24 + 16 >> 2] = 0;
      HEAP32[$24 + 20 >> 2] = 0;
      HEAP32[$24 + 8 >> 2] = 8;
      HEAP32[$24 + 4 >> 2] = !$2;
      if (!FLAC__add_metadata_block($24, HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2])) {
       HEAP32[HEAP32[$0 >> 2] >> 2] = 7;
       break label$1;
      }
      if (!write_bitbuffer_($0, 0, 0)) {
       break label$1
      }
     }
     label$65 : {
      $8 = HEAP32[$0 >> 2];
      $3 = HEAP32[$8 + 604 >> 2];
      if (!$3) {
       break label$65
      }
      $2 = 0;
      while (1) {
       $1 = HEAP32[HEAP32[$8 + 600 >> 2] + ($2 << 2) >> 2];
       HEAP32[$1 + 4 >> 2] = ($3 - 1 | 0) == ($2 | 0);
       if (!FLAC__add_metadata_block($1, HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2])) {
        HEAP32[HEAP32[$0 >> 2] >> 2] = 7;
        break label$1;
       }
       if (write_bitbuffer_($0, 0, 0)) {
        $2 = $2 + 1 | 0;
        $8 = HEAP32[$0 >> 2];
        $3 = HEAP32[$8 + 604 >> 2];
        if ($2 >>> 0 >= $3 >>> 0) {
         break label$65
        }
        continue;
       }
       break;
      };
      break label$1;
     }
     label$69 : {
      $2 = HEAP32[$0 + 4 >> 2];
      $1 = HEAP32[$2 + 7272 >> 2];
      if (!$1) {
       break label$69
      }
      $1 = FUNCTION_TABLE[$1 | 0]($0, $8 + 624 | 0, HEAP32[$2 + 7288 >> 2]) | 0;
      $8 = HEAP32[$0 >> 2];
      if (($1 | 0) != 1) {
       break label$69
      }
      HEAP32[$8 >> 2] = 5;
      break label$1;
     }
     $17 = 0;
     if (!HEAP32[$8 + 4 >> 2]) {
      break label$1
     }
     HEAP32[HEAP32[$0 + 4 >> 2] + 11756 >> 2] = 2;
     break label$1;
    }
    HEAP32[HEAP32[$0 >> 2] >> 2] = 2;
    break label$1;
   }
   HEAP32[$8 >> 2] = 3;
   $17 = 1;
  }
  __stack_pointer = $24 + 176 | 0;
  return $17;
 }
 
 function precompute_partition_info_sums_($0, $1, $2, $3, $4, $5, $6) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  var $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0;
  $16 = 0 - $3 | 0;
  $13 = 1 << $5;
  $8 = $2 + $3 >>> $5 | 0;
  $14 = $8 - $3 | 0;
  label$1 : {
   if ($6 + 4 >>> 0 >= (Math_clz32($8) ^ -32) + 33 >>> 0) {
    $18 = ($3 ^ -1) + $8 | 0;
    $9 = $14;
    while (1) {
     $10 = 0;
     $6 = 0;
     $16 = $8 + $16 | 0;
     label$4 : {
      if ($16 >>> 0 <= $7 >>> 0) {
       break label$4
      }
      $2 = Math_imul($11, $8);
      $3 = ($2 + $14 | 0) - $7 | 0;
      $19 = $3 & 1;
      label$5 : {
       if (($7 | 0) == ($2 + $18 | 0)) {
        $3 = $7;
        break label$5;
       }
       $2 = $3 & -2;
       $3 = $7;
       while (1) {
        $12 = ($3 << 2) + $0 | 0;
        $15 = HEAP32[$12 >> 2];
        $7 = $15 >> 31;
        $17 = HEAP32[$12 + 4 >> 2];
        $12 = $17 >> 31;
        $15 = $7 ^ $7 + $15;
        $10 = $15 + $10 | 0;
        $7 = $6;
        $7 = $10 >>> 0 < $15 >>> 0 ? $7 + 1 | 0 : $7;
        $12 = $12 ^ $12 + $17;
        $10 = $12 + $10 | 0;
        $6 = $10 >>> 0 < $12 >>> 0 ? $7 + 1 | 0 : $7;
        $3 = $3 + 2 | 0;
        $2 = $2 - 2 | 0;
        if ($2) {
         continue
        }
        break;
       };
      }
      $7 = $9;
      if (!$19) {
       break label$4
      }
      $3 = HEAP32[($3 << 2) + $0 >> 2];
      $2 = $3 >> 31;
      $3 = $2 ^ $2 + $3;
      $2 = $3 + $10 | 0;
      $6 = $2 >>> 0 < $3 >>> 0 ? $6 + 1 | 0 : $6;
      $10 = $2;
     }
     $2 = ($11 << 3) + $1 | 0;
     HEAP32[$2 >> 2] = $10;
     HEAP32[$2 + 4 >> 2] = $6;
     $9 = $9 + $8 | 0;
     $11 = $11 + 1 | 0;
     if (($11 | 0) != ($13 | 0)) {
      continue
     }
     break;
    };
    break label$1;
   }
   $15 = ($3 ^ -1) + $8 | 0;
   $9 = $14;
   while (1) {
    $16 = $8 + $16 | 0;
    label$9 : {
     if ($7 >>> 0 >= $16 >>> 0) {
      $2 = 0;
      break label$9;
     }
     $3 = Math_imul($10, $8);
     $11 = ($3 + $14 | 0) - $7 | 0;
     $6 = $11 & 3;
     $2 = 0;
     label$11 : {
      if (($3 + $15 | 0) - $7 >>> 0 < 3) {
       $3 = $7;
       break label$11;
      }
      $11 = $11 & -4;
      $3 = $7;
      while (1) {
       $7 = ($3 << 2) + $0 | 0;
       $17 = HEAP32[$7 + 12 >> 2];
       $12 = $17 >> 31;
       $20 = HEAP32[$7 + 8 >> 2];
       $18 = $20 >> 31;
       $21 = HEAP32[$7 + 4 >> 2];
       $19 = $21 >> 31;
       $22 = HEAP32[$7 >> 2];
       $7 = $22 >> 31;
       $2 = (((($7 ^ $7 + $22) + $2 | 0) + ($19 ^ $19 + $21) | 0) + ($18 ^ $18 + $20) | 0) + ($12 ^ $12 + $17) | 0;
       $3 = $3 + 4 | 0;
       $11 = $11 - 4 | 0;
       if ($11) {
        continue
       }
       break;
      };
     }
     $7 = $9;
     if (!$6) {
      break label$9
     }
     while (1) {
      $11 = HEAP32[($3 << 2) + $0 >> 2];
      $7 = $11 >> 31;
      $2 = ($7 ^ $7 + $11) + $2 | 0;
      $3 = $3 + 1 | 0;
      $6 = $6 - 1 | 0;
      if ($6) {
       continue
      }
      break;
     };
     $7 = $9;
    }
    $3 = ($10 << 3) + $1 | 0;
    HEAP32[$3 >> 2] = $2;
    HEAP32[$3 + 4 >> 2] = 0;
    $9 = $9 + $8 | 0;
    $10 = $10 + 1 | 0;
    if (($10 | 0) != ($13 | 0)) {
     continue
    }
    break;
   };
  }
  if (($4 | 0) < ($5 | 0)) {
   $2 = 0;
   $6 = $13;
   while (1) {
    $0 = $6;
    $6 = $0 >>> 1 | 0;
    $5 = $5 - 1 | 0;
    label$17 : {
     if ($0 >>> 0 < 2) {
      break label$17
     }
     $3 = $6 >>> 0 > 1 ? $6 : 1;
     $14 = $3 & 1;
     if ($0 >>> 0 >= 4) {
      $7 = $3 & 2147483646;
      while (1) {
       $0 = ($2 << 3) + $1 | 0;
       $3 = $0 + 8 | 0;
       $10 = HEAP32[$0 >> 2];
       $9 = HEAP32[$3 >> 2] + $10 | 0;
       $3 = HEAP32[$3 + 4 >> 2] + HEAP32[$0 + 4 >> 2] | 0;
       $8 = ($13 << 3) + $1 | 0;
       HEAP32[$8 >> 2] = $9;
       HEAP32[$8 + 4 >> 2] = $10 >>> 0 > $9 >>> 0 ? $3 + 1 | 0 : $3;
       $9 = $8 + 8 | 0;
       $8 = $0 + 24 | 0;
       $0 = $0 + 16 | 0;
       $11 = HEAP32[$0 >> 2];
       $3 = HEAP32[$8 >> 2] + $11 | 0;
       $0 = HEAP32[$8 + 4 >> 2] + HEAP32[$0 + 4 >> 2] | 0;
       HEAP32[$9 >> 2] = $3;
       HEAP32[$9 + 4 >> 2] = $3 >>> 0 < $11 >>> 0 ? $0 + 1 | 0 : $0;
       $2 = $2 + 4 | 0;
       $13 = $13 + 2 | 0;
       $7 = $7 - 2 | 0;
       if ($7) {
        continue
       }
       break;
      };
     }
     if (!$14) {
      break label$17
     }
     $0 = ($2 << 3) + $1 | 0;
     $7 = $0 + 8 | 0;
     $14 = HEAP32[$0 >> 2];
     $3 = HEAP32[$7 >> 2] + $14 | 0;
     $7 = HEAP32[$7 + 4 >> 2] + HEAP32[$0 + 4 >> 2] | 0;
     $9 = ($13 << 3) + $1 | 0;
     HEAP32[$9 >> 2] = $3;
     HEAP32[$9 + 4 >> 2] = $3 >>> 0 < $14 >>> 0 ? $7 + 1 | 0 : $7;
     $2 = $2 + 2 | 0;
     $13 = $13 + 1 | 0;
    }
    if (($4 | 0) < ($5 | 0)) {
     continue
    }
    break;
   };
  }
 }
 
 function verify_read_callback_($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0, $5 = 0;
  $5 = HEAP32[$3 + 4 >> 2];
  if (HEAP32[$5 + 11760 >> 2]) {
   HEAP32[$2 >> 2] = 4;
   $0 = HEAPU8[6517] | HEAPU8[6518] << 8 | (HEAPU8[6519] << 16 | HEAPU8[6520] << 24);
   HEAP8[$1 | 0] = $0;
   HEAP8[$1 + 1 | 0] = $0 >>> 8;
   HEAP8[$1 + 2 | 0] = $0 >>> 16;
   HEAP8[$1 + 3 | 0] = $0 >>> 24;
   HEAP32[HEAP32[$3 + 4 >> 2] + 11760 >> 2] = 0;
   return 0;
  }
  $0 = HEAP32[$5 + 11812 >> 2];
  if (!$0) {
   return 2
  }
  $4 = HEAP32[$2 >> 2];
  if ($0 >>> 0 < $4 >>> 0) {
   HEAP32[$2 >> 2] = $0;
   $4 = $0;
  }
  __memcpy($1, HEAP32[$5 + 11804 >> 2], $4);
  $0 = HEAP32[$3 + 4 >> 2];
  $1 = $0 + 11804 | 0;
  $3 = $1;
  $4 = HEAP32[$1 >> 2];
  $1 = HEAP32[$2 >> 2];
  HEAP32[$3 >> 2] = $4 + $1;
  $0 = $0 + 11812 | 0;
  HEAP32[$0 >> 2] = HEAP32[$0 >> 2] - $1;
  return 0;
 }
 
 function verify_write_callback_($0, $1, $2, $3) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, wasm2js_i32$0 = 0, wasm2js_i32$1 = 0;
  $6 = HEAP32[$1 >> 2];
  $5 = HEAP32[$3 + 4 >> 2];
  $0 = HEAP32[$1 + 8 >> 2];
  if ($0) {
   $4 = $6 << 2;
   while (1) {
    $8 = $7 << 2;
    $9 = HEAP32[$8 + $2 >> 2];
    $10 = HEAP32[($5 + $8 | 0) + 11764 >> 2];
    if (memcmp($9, $10, $4)) {
     $0 = 0;
     label$4 : {
      if ($6) {
       $4 = 0;
       while (1) {
        $2 = $4 << 2;
        $8 = HEAP32[$2 + $9 >> 2];
        $2 = HEAP32[$2 + $10 >> 2];
        if (($2 | 0) != ($8 | 0)) {
         $0 = $4;
         break label$4;
        }
        $4 = $4 + 1 | 0;
        if (($4 | 0) != ($6 | 0)) {
         continue
        }
        break;
       };
      }
      $2 = 0;
      $8 = 0;
     }
     $9 = HEAP32[$1 + 28 >> 2];
     $4 = $5 + 11816 | 0;
     $10 = HEAP32[$1 + 24 >> 2] + $0 | 0;
     HEAP32[$4 >> 2] = $10;
     HEAP32[$4 + 4 >> 2] = $0 >>> 0 > $10 >>> 0 ? $9 + 1 | 0 : $9;
     $4 = HEAP32[$1 + 28 >> 2];
     $1 = HEAP32[$1 + 24 >> 2];
     HEAP32[$5 + 11840 >> 2] = $8;
     HEAP32[$5 + 11836 >> 2] = $2;
     HEAP32[$5 + 11832 >> 2] = $0;
     HEAP32[$5 + 11828 >> 2] = $7;
     (wasm2js_i32$0 = $5 + 11824 | 0, wasm2js_i32$1 = __wasm_i64_udiv($1, $4, $6)), HEAP32[wasm2js_i32$0 >> 2] = wasm2js_i32$1;
     HEAP32[HEAP32[$3 >> 2] >> 2] = 4;
     return 1;
    }
    $7 = $7 + 1 | 0;
    if (($0 | 0) != ($7 | 0)) {
     continue
    }
    break;
   };
   $2 = $5 + 11800 | 0;
   $1 = HEAP32[$2 >> 2] - $6 | 0;
   HEAP32[$2 >> 2] = $1;
   label$8 : {
    if (!$0) {
     break label$8
    }
    $2 = HEAP32[$5 + 11764 >> 2];
    memmove($2, $2 + ($6 << 2) | 0, $1 << 2);
    $7 = 1;
    if (($0 | 0) == 1) {
     break label$8
    }
    $1 = $0 - 1 | 0;
    $2 = $1 & 1;
    if (($0 | 0) != 2) {
     $0 = $1 & -2;
     while (1) {
      $1 = HEAP32[$3 + 4 >> 2];
      $4 = $7 << 2;
      $5 = HEAP32[($1 + $4 | 0) + 11764 >> 2];
      $8 = $5;
      $5 = $6 << 2;
      memmove($8, $8 + $5 | 0, HEAP32[$1 + 11800 >> 2] << 2);
      $1 = HEAP32[$3 + 4 >> 2];
      $4 = HEAP32[($1 + $4 | 0) + 11768 >> 2];
      memmove($4, $5 + $4 | 0, HEAP32[$1 + 11800 >> 2] << 2);
      $7 = $7 + 2 | 0;
      $0 = $0 - 2 | 0;
      if ($0) {
       continue
      }
      break;
     };
    }
    if (!$2) {
     break label$8
    }
    $0 = HEAP32[$3 + 4 >> 2];
    $1 = HEAP32[($0 + ($7 << 2) | 0) + 11764 >> 2];
    memmove($1, $1 + ($6 << 2) | 0, HEAP32[$0 + 11800 >> 2] << 2);
   }
   return 0;
  }
  $0 = $5 + 11800 | 0;
  HEAP32[$0 >> 2] = HEAP32[$0 >> 2] - $6;
  return 0;
 }
 
 function verify_metadata_callback_($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
 }
 
 function verify_error_callback_($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  HEAP32[HEAP32[$2 >> 2] >> 2] = 3;
 }
 
 function write_bitbuffer_($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
  $16 = __stack_pointer - 16 | 0;
  __stack_pointer = $16;
  $20 = FLAC__bitwriter_get_buffer(HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2], $16 + 4 | 0, $16);
  $5 = HEAP32[$0 >> 2];
  label$1 : {
   if (!$20) {
    HEAP32[$5 >> 2] = 8;
    break label$1;
   }
   label$3 : {
    if (!HEAP32[$5 + 4 >> 2]) {
     break label$3
    }
    $5 = HEAP32[$0 + 4 >> 2];
    HEAP32[$5 + 11804 >> 2] = HEAP32[$16 + 4 >> 2];
    HEAP32[$5 + 11812 >> 2] = HEAP32[$16 >> 2];
    if (!HEAP32[$5 + 11756 >> 2]) {
     HEAP32[$5 + 11760 >> 2] = 1;
     break label$3;
    }
    if (FLAC__stream_decoder_process_single(HEAP32[$5 + 11752 >> 2])) {
     break label$3
    }
    FLAC__bitwriter_clear(HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2]);
    $0 = HEAP32[$0 >> 2];
    if (HEAP32[$0 >> 2] == 4) {
     break label$1
    }
    HEAP32[$0 >> 2] = 3;
    break label$1;
   }
   $20 = HEAP32[$16 >> 2];
   $5 = HEAP32[$16 + 4 >> 2];
   HEAP32[$16 + 8 >> 2] = 0;
   HEAP32[$16 + 12 >> 2] = 0;
   label$5 : {
    $8 = HEAP32[$0 + 4 >> 2];
    $9 = HEAP32[$8 + 7272 >> 2];
    label$6 : {
     if ($9) {
      if ((FUNCTION_TABLE[$9 | 0]($0, $16 + 8 | 0, HEAP32[$8 + 7288 >> 2]) | 0) == 1) {
       break label$6
      }
     }
     label$8 : {
      if ($1) {
       break label$8
      }
      label$9 : {
       switch (HEAPU8[$5 | 0] & 127) {
       case 0:
        $8 = HEAP32[$16 + 12 >> 2];
        $9 = HEAP32[$0 >> 2];
        HEAP32[$9 + 608 >> 2] = HEAP32[$16 + 8 >> 2];
        HEAP32[$9 + 612 >> 2] = $8;
        break label$8;
       case 3:
        break label$9;
       default:
        break label$8;
       };
      }
      $8 = HEAP32[$0 >> 2];
      if (HEAP32[$8 + 616 >> 2] | HEAP32[$8 + 620 >> 2]) {
       break label$8
      }
      $9 = HEAP32[$16 + 12 >> 2];
      HEAP32[$8 + 616 >> 2] = HEAP32[$16 + 8 >> 2];
      HEAP32[$8 + 620 >> 2] = $9;
     }
     $13 = HEAP32[$0 + 4 >> 2];
     $9 = HEAP32[$13 + 7048 >> 2];
     label$11 : {
      if (!$9) {
       break label$11
      }
      $3 = HEAP32[$0 >> 2];
      $6 = HEAP32[$3 + 628 >> 2];
      $10 = HEAP32[$3 + 624 >> 2];
      if (!($6 | $10)) {
       break label$11
      }
      $4 = HEAP32[$9 >> 2];
      if (!$4) {
       break label$11
      }
      $8 = HEAP32[$13 + 7292 >> 2];
      if ($4 >>> 0 <= $8 >>> 0) {
       break label$11
      }
      $21 = HEAP32[$3 + 36 >> 2];
      $7 = HEAP32[$13 + 7312 >> 2];
      $11 = $21 + $7 | 0;
      $17 = $11 - 1 | 0;
      $3 = HEAP32[$13 + 7316 >> 2];
      $14 = ($7 >>> 0 > $11 >>> 0 ? $3 + 1 | 0 : $3) - 1 | 0;
      $14 = ($17 | 0) != -1 ? $14 + 1 | 0 : $14;
      $15 = HEAP32[$9 + 4 >> 2];
      while (1) {
       $9 = $15 + Math_imul($8, 24) | 0;
       $18 = HEAP32[$9 >> 2];
       $11 = HEAP32[$9 + 4 >> 2];
       if (($14 | 0) == ($11 | 0) & $17 >>> 0 < $18 >>> 0 | $14 >>> 0 < $11 >>> 0) {
        break label$11
       }
       if (!(($3 | 0) == ($11 | 0) & $7 >>> 0 > $18 >>> 0 | $3 >>> 0 > $11 >>> 0)) {
        HEAP32[$9 >> 2] = $7;
        HEAP32[$9 + 4 >> 2] = $3;
        $11 = HEAP32[$16 + 8 >> 2];
        $18 = HEAP32[$16 + 12 >> 2];
        HEAP32[$9 + 16 >> 2] = $21;
        HEAP32[$9 + 8 >> 2] = $11 - $10;
        HEAP32[$9 + 12 >> 2] = $18 - ($6 + ($10 >>> 0 > $11 >>> 0) | 0);
       }
       $8 = $8 + 1 | 0;
       HEAP32[$13 + 7292 >> 2] = $8;
       if (($4 | 0) != ($8 | 0)) {
        continue
       }
       break;
      };
     }
     label$14 : {
      if (HEAP32[$13 + 7260 >> 2]) {
       $3 = $20;
       $8 = $1;
       $21 = HEAP32[$13 + 7056 >> 2];
       $18 = HEAP32[$13 + 7276 >> 2];
       $9 = $0;
       $24 = HEAP32[$13 + 7288 >> 2];
       $13 = 0;
       $6 = __stack_pointer - 96 | 0;
       __stack_pointer = $6;
       $10 = HEAP32[$0 >> 2] + 632 | 0;
       label$13 : {
        label$2 : {
         if (HEAP32[$10 + 384 >> 2]) {
          $13 = $6 + 72 | 0;
          HEAP32[$13 >> 2] = 0;
          HEAP32[$13 + 4 >> 2] = 0;
          $4 = $6 + 80 | 0;
          HEAP32[$4 >> 2] = 0;
          HEAP32[$4 + 4 >> 2] = 0;
          $13 = $6 + 88 | 0;
          HEAP32[$13 >> 2] = 0;
          HEAP32[$13 + 4 >> 2] = 0;
          HEAP32[$6 + 64 >> 2] = 0;
          HEAP32[$6 + 68 >> 2] = 0;
          $7 = HEAP32[$10 + 396 >> 2];
          $13 = $8;
          $17 = $8 + HEAP32[$10 + 392 >> 2] | 0;
          HEAP32[$4 >> 2] = $17;
          HEAP32[$4 + 4 >> 2] = $8 >>> 0 > $17 >>> 0 ? $7 + 1 | 0 : $7;
          label$4 : {
           label$54 : {
            if (HEAP32[$10 + 388 >> 2]) {
             if (($3 | 0) != 38) {
              break label$4
             }
             HEAP8[$6 | 0] = HEAPU8[7824];
             $3 = HEAP32[2714];
             $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
             HEAP8[$6 + 5 | 0] = 1;
             HEAP8[$6 + 6 | 0] = 0;
             HEAP8[$6 + 1 | 0] = $3;
             HEAP8[$6 + 2 | 0] = $3 >>> 8;
             HEAP8[$6 + 3 | 0] = $3 >>> 16;
             HEAP8[$6 + 4 | 0] = $3 >>> 24;
             $4 = HEAP32[$10 + 4 >> 2];
             $3 = HEAPU8[6517] | HEAPU8[6518] << 8 | (HEAPU8[6519] << 16 | HEAPU8[6520] << 24);
             HEAP8[$6 + 9 | 0] = $3;
             HEAP8[$6 + 10 | 0] = $3 >>> 8;
             HEAP8[$6 + 11 | 0] = $3 >>> 16;
             HEAP8[$6 + 12 | 0] = $3 >>> 24;
             HEAP8[$6 + 8 | 0] = $4;
             HEAP8[$6 + 7 | 0] = $4 >>> 8;
             $3 = $5 + 30 | 0;
             $7 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
             $4 = $6 + 43 | 0;
             $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
             HEAP8[$4 | 0] = $3;
             HEAP8[$4 + 1 | 0] = $3 >>> 8;
             HEAP8[$4 + 2 | 0] = $3 >>> 16;
             HEAP8[$4 + 3 | 0] = $3 >>> 24;
             HEAP8[$4 + 4 | 0] = $7;
             HEAP8[$4 + 5 | 0] = $7 >>> 8;
             HEAP8[$4 + 6 | 0] = $7 >>> 16;
             HEAP8[$4 + 7 | 0] = $7 >>> 24;
             $3 = $5 + 24 | 0;
             $7 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
             $4 = $6 + 37 | 0;
             $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
             HEAP8[$4 | 0] = $3;
             HEAP8[$4 + 1 | 0] = $3 >>> 8;
             HEAP8[$4 + 2 | 0] = $3 >>> 16;
             HEAP8[$4 + 3 | 0] = $3 >>> 24;
             HEAP8[$4 + 4 | 0] = $7;
             HEAP8[$4 + 5 | 0] = $7 >>> 8;
             HEAP8[$4 + 6 | 0] = $7 >>> 16;
             HEAP8[$4 + 7 | 0] = $7 >>> 24;
             $3 = $5 + 16 | 0;
             $7 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
             $4 = $6 + 29 | 0;
             $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
             HEAP8[$4 | 0] = $3;
             HEAP8[$4 + 1 | 0] = $3 >>> 8;
             HEAP8[$4 + 2 | 0] = $3 >>> 16;
             HEAP8[$4 + 3 | 0] = $3 >>> 24;
             HEAP8[$4 + 4 | 0] = $7;
             HEAP8[$4 + 5 | 0] = $7 >>> 8;
             HEAP8[$4 + 6 | 0] = $7 >>> 16;
             HEAP8[$4 + 7 | 0] = $7 >>> 24;
             $3 = $5 + 8 | 0;
             $7 = HEAPU8[$3 + 4 | 0] | HEAPU8[$3 + 5 | 0] << 8 | (HEAPU8[$3 + 6 | 0] << 16 | HEAPU8[$3 + 7 | 0] << 24);
             $4 = $6 + 21 | 0;
             $3 = HEAPU8[$3 | 0] | HEAPU8[$3 + 1 | 0] << 8 | (HEAPU8[$3 + 2 | 0] << 16 | HEAPU8[$3 + 3 | 0] << 24);
             HEAP8[$4 | 0] = $3;
             HEAP8[$4 + 1 | 0] = $3 >>> 8;
             HEAP8[$4 + 2 | 0] = $3 >>> 16;
             HEAP8[$4 + 3 | 0] = $3 >>> 24;
             HEAP8[$4 + 4 | 0] = $7;
             HEAP8[$4 + 5 | 0] = $7 >>> 8;
             HEAP8[$4 + 6 | 0] = $7 >>> 16;
             HEAP8[$4 + 7 | 0] = $7 >>> 24;
             $3 = HEAPU8[$5 + 4 | 0] | HEAPU8[$5 + 5 | 0] << 8 | (HEAPU8[$5 + 6 | 0] << 16 | HEAPU8[$5 + 7 | 0] << 24);
             $5 = HEAPU8[$5 | 0] | HEAPU8[$5 + 1 | 0] << 8 | (HEAPU8[$5 + 2 | 0] << 16 | HEAPU8[$5 + 3 | 0] << 24);
             HEAP8[$6 + 13 | 0] = $5;
             HEAP8[$6 + 14 | 0] = $5 >>> 8;
             HEAP8[$6 + 15 | 0] = $5 >>> 16;
             HEAP8[$6 + 16 | 0] = $5 >>> 24;
             HEAP8[$6 + 17 | 0] = $3;
             HEAP8[$6 + 18 | 0] = $3 >>> 8;
             HEAP8[$6 + 19 | 0] = $3 >>> 16;
             HEAP8[$6 + 20 | 0] = $3 >>> 24;
             HEAP32[$6 + 68 >> 2] = 51;
             HEAP32[$6 + 72 >> 2] = 1;
             HEAP32[$6 + 64 >> 2] = $6;
             HEAP32[$10 + 388 >> 2] = 0;
             break label$54;
            }
            HEAP32[$6 + 68 >> 2] = $3;
            HEAP32[$6 + 64 >> 2] = $5;
           }
           if ($2) {
            HEAP32[$6 + 76 >> 2] = 1
           }
           $7 = 0;
           $23 = __stack_pointer - 16 | 0;
           __stack_pointer = $23;
           $2 = $6 - -64 | 0;
           HEAP32[$23 + 8 >> 2] = HEAP32[$2 >> 2];
           HEAP32[$23 + 12 >> 2] = HEAP32[$2 + 4 >> 2];
           $17 = $23 + 8 | 0;
           $28 = HEAP32[$2 + 12 >> 2];
           $25 = HEAP32[$2 + 16 >> 2];
           $26 = HEAP32[$2 + 20 >> 2];
           $3 = 0;
           $11 = -1;
           $5 = $10 + 8 | 0;
           $2 = $5;
           __inlined_func$ogg_stream_iovecin : {
            label$105 : {
             if (!$2) {
              break label$105
             }
             $4 = HEAP32[$2 >> 2];
             if (!$4) {
              break label$105
             }
             $15 = 0;
             if (!$17) {
              break __inlined_func$ogg_stream_iovecin
             }
             while (1) {
              $14 = HEAP32[(($3 << 3) + $17 | 0) + 4 >> 2];
              if (($14 | 0) < 0 | (2147483647 - $14 | 0) < ($7 | 0)) {
               break label$105
              }
              $7 = $7 + $14 | 0;
              $3 = $3 + 1 | 0;
              if (($3 | 0) != 1) {
               continue
              }
              break;
             };
             $3 = HEAP32[$2 + 12 >> 2];
             if ($3) {
              $14 = HEAP32[$2 + 8 >> 2] - $3 | 0;
              HEAP32[$2 + 8 >> 2] = $14;
              if ($14) {
               memmove($4, $3 + $4 | 0, $14)
              }
              HEAP32[$2 + 12 >> 2] = 0;
             }
             $3 = HEAP32[$2 + 4 >> 2];
             if (HEAP32[$2 + 8 >> 2] >= ($3 - $7 | 0)) {
              if ((2147483647 - $7 | 0) < ($3 | 0)) {
               $3 = HEAP32[$2 >> 2];
               if ($3) {
                dlfree($3)
               }
               $3 = HEAP32[$2 + 16 >> 2];
               if ($3) {
                dlfree($3)
               }
               $3 = HEAP32[$2 + 20 >> 2];
               if ($3) {
                dlfree($3)
               }
               memset($2, 360);
               $15 = -1;
               break __inlined_func$ogg_stream_iovecin;
              }
              $3 = $3 + $7 | 0;
              $3 = ($3 | 0) < 2147482623 ? $3 + 1024 | 0 : $3;
              $4 = dlrealloc(HEAP32[$2 >> 2], $3);
              if (!$4) {
               ogg_stream_clear($2);
               $15 = -1;
               break __inlined_func$ogg_stream_iovecin;
              }
              HEAP32[$2 >> 2] = $4;
              HEAP32[$2 + 4 >> 2] = $3;
             }
             $15 = ($7 | 0) / 255 | 0;
             $27 = $15 + 1 | 0;
             if (_os_lacing_expand($2, $27)) {
              break label$105
             }
             $4 = HEAP32[$2 + 8 >> 2];
             $3 = 0;
             while (1) {
              $11 = HEAP32[$2 >> 2] + $4 | 0;
              $4 = ($3 << 3) + $17 | 0;
              __memcpy($11, HEAP32[$4 >> 2], HEAP32[$4 + 4 >> 2]);
              $4 = HEAP32[$2 + 8 >> 2] + HEAP32[$4 + 4 >> 2] | 0;
              HEAP32[$2 + 8 >> 2] = $4;
              $3 = $3 + 1 | 0;
              if (($3 | 0) != 1) {
               continue
              }
              break;
             };
             label$16 : {
              if (($7 | 0) <= 254) {
               $14 = HEAP32[$2 + 20 >> 2];
               $4 = HEAP32[$2 + 28 >> 2];
               $17 = HEAP32[$2 + 16 >> 2];
               $3 = 0;
               break label$16;
              }
              $11 = $15 & 3;
              $14 = HEAP32[$2 + 20 >> 2];
              $4 = HEAP32[$2 + 28 >> 2];
              $17 = HEAP32[$2 + 16 >> 2];
              $3 = 0;
              if ($15 - 1 >>> 0 >= 3) {
               $19 = $15 & -4;
               while (1) {
                $12 = $3 + $4 | 0;
                HEAP32[($12 << 2) + $17 >> 2] = 255;
                $22 = HEAP32[$2 + 356 >> 2];
                $12 = ($12 << 3) + $14 | 0;
                HEAP32[$12 >> 2] = HEAP32[$2 + 352 >> 2];
                HEAP32[$12 + 4 >> 2] = $22;
                $12 = ($3 | 1) + $4 | 0;
                HEAP32[($12 << 2) + $17 >> 2] = 255;
                $22 = HEAP32[$2 + 356 >> 2];
                $12 = ($12 << 3) + $14 | 0;
                HEAP32[$12 >> 2] = HEAP32[$2 + 352 >> 2];
                HEAP32[$12 + 4 >> 2] = $22;
                $12 = ($3 | 2) + $4 | 0;
                HEAP32[($12 << 2) + $17 >> 2] = 255;
                $22 = HEAP32[$2 + 356 >> 2];
                $12 = ($12 << 3) + $14 | 0;
                HEAP32[$12 >> 2] = HEAP32[$2 + 352 >> 2];
                HEAP32[$12 + 4 >> 2] = $22;
                $12 = ($3 | 3) + $4 | 0;
                HEAP32[($12 << 2) + $17 >> 2] = 255;
                $22 = HEAP32[$2 + 356 >> 2];
                $12 = ($12 << 3) + $14 | 0;
                HEAP32[$12 >> 2] = HEAP32[$2 + 352 >> 2];
                HEAP32[$12 + 4 >> 2] = $22;
                $3 = $3 + 4 | 0;
                $19 = $19 - 4 | 0;
                if ($19) {
                 continue
                }
                break;
               };
              }
              if ($11) {
               while (1) {
                $19 = $3 + $4 | 0;
                HEAP32[($19 << 2) + $17 >> 2] = 255;
                $12 = HEAP32[$2 + 356 >> 2];
                $19 = ($19 << 3) + $14 | 0;
                HEAP32[$19 >> 2] = HEAP32[$2 + 352 >> 2];
                HEAP32[$19 + 4 >> 2] = $12;
                $3 = $3 + 1 | 0;
                $11 = $11 - 1 | 0;
                if ($11) {
                 continue
                }
                break;
               }
              }
              $3 = $15;
             }
             $3 = $3 + $4 | 0;
             HEAP32[($3 << 2) + $17 >> 2] = $7 - Math_imul($15, 255);
             $3 = ($3 << 3) + $14 | 0;
             HEAP32[$3 >> 2] = $25;
             HEAP32[$3 + 4 >> 2] = $26;
             HEAP32[$2 + 352 >> 2] = $25;
             HEAP32[$2 + 356 >> 2] = $26;
             $3 = ($4 << 2) + $17 | 0;
             HEAP32[$3 >> 2] = HEAP32[$3 >> 2] | 256;
             HEAP32[$2 + 28 >> 2] = $4 + $27;
             $3 = HEAP32[$2 + 348 >> 2];
             $15 = $3 + 1 | 0;
             $11 = $3;
             $3 = HEAP32[$2 + 344 >> 2] + 1 | 0;
             $4 = $3 >>> 0 < 1 ? $15 : $11;
             HEAP32[$2 + 344 >> 2] = $3;
             HEAP32[$2 + 348 >> 2] = $4;
             $11 = 0;
             if (!$28) {
              break label$105
             }
             HEAP32[$2 + 328 >> 2] = 1;
            }
            $15 = $11;
           }
           $2 = $15;
           __stack_pointer = $23 + 16 | 0;
           if ($2) {
            break label$4
           }
           $3 = $10 + 368 | 0;
           if (!$8) {
            while (1) {
             if (!ogg_stream_flush_i($5, $3, 1)) {
              break label$2
             }
             if (FUNCTION_TABLE[$18 | 0]($9, HEAP32[$10 + 368 >> 2], HEAP32[$10 + 372 >> 2], 0, $21, $24) | 0) {
              break label$4
             }
             if (!(FUNCTION_TABLE[$18 | 0]($9, HEAP32[$10 + 376 >> 2], HEAP32[$10 + 380 >> 2], 0, $21, $24) | 0)) {
              continue
             }
             break label$4;
            }
           }
           while (1) {
            $8 = $3;
            $2 = $5;
            if (!$2 | !HEAP32[$2 >> 2]) {
             $2 = 0
            } else {
             $4 = HEAP32[$2 + 28 >> 2];
             $11 = $2;
             label$20 : {
              label$37 : {
               if (HEAP32[$2 + 328 >> 2]) {
                if ($4) {
                 break label$37
                }
                $15 = 0;
                break label$20;
               }
               $15 = 0;
               if (HEAP32[$2 + 332 >> 2] | !$4) {
                break label$20
               }
              }
              $15 = 1;
             }
             $2 = ogg_stream_flush_i($11, $8, $15);
            }
            if (!$2) {
             break label$2
            }
            if (FUNCTION_TABLE[$18 | 0]($9, HEAP32[$10 + 368 >> 2], HEAP32[$10 + 372 >> 2], 0, $21, $24) | 0) {
             break label$4
            }
            if (!(FUNCTION_TABLE[$18 | 0]($9, HEAP32[$10 + 376 >> 2], HEAP32[$10 + 380 >> 2], 0, $21, $24) | 0)) {
             continue
            }
            break;
           };
          }
          $2 = 1;
          break label$13;
         }
         $2 = 1;
         if ($8 | $21 | (($3 | 0) != 4 | (HEAPU8[$5 | 0] | HEAPU8[$5 + 1 | 0] << 8 | (HEAPU8[$5 + 2 | 0] << 16 | HEAPU8[$5 + 3 | 0] << 24)) != (HEAPU8[6517] | HEAPU8[6518] << 8 | (HEAPU8[6519] << 16 | HEAPU8[6520] << 24)))) {
          break label$13
         }
         HEAP32[$10 + 384 >> 2] = 1;
        }
        $2 = HEAP32[$10 + 396 >> 2];
        $8 = $13 + HEAP32[$10 + 392 >> 2] | 0;
        HEAP32[$10 + 392 >> 2] = $8;
        HEAP32[$10 + 396 >> 2] = $8 >>> 0 < $13 >>> 0 ? $2 + 1 | 0 : $2;
        $2 = 0;
       }
       __stack_pointer = $6 + 96 | 0;
       break label$14;
      }
      $2 = FUNCTION_TABLE[HEAP32[$13 + 7276 >> 2]]($0, $5, $20, $1, HEAP32[$13 + 7056 >> 2], HEAP32[$13 + 7288 >> 2]) | 0;
     }
     if (!$2) {
      break label$5
     }
    }
    HEAP32[HEAP32[$0 >> 2] >> 2] = 5;
    FLAC__bitwriter_clear(HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2]);
    HEAP32[HEAP32[$0 >> 2] >> 2] = 5;
    $8 = 0;
    break label$1;
   }
   $2 = HEAP32[$0 + 4 >> 2];
   $5 = HEAP32[$2 + 7308 >> 2];
   $3 = $5 + 1 | 0;
   $8 = $5;
   $5 = $20 + HEAP32[$2 + 7304 >> 2] | 0;
   $20 = $5 >>> 0 < $20 >>> 0 ? $3 : $8;
   HEAP32[$2 + 7304 >> 2] = $5;
   HEAP32[$2 + 7308 >> 2] = $20;
   $8 = HEAP32[$2 + 7316 >> 2];
   $5 = HEAP32[$2 + 7312 >> 2] + $1 | 0;
   HEAP32[$2 + 7312 >> 2] = $5;
   HEAP32[$2 + 7316 >> 2] = $1 >>> 0 > $5 >>> 0 ? $8 + 1 | 0 : $8;
   $8 = 1;
   $3 = $2;
   $5 = HEAP32[$2 + 7320 >> 2];
   $2 = HEAP32[$2 + 7056 >> 2] + 1 | 0;
   HEAP32[$3 + 7320 >> 2] = $2 >>> 0 < $5 >>> 0 ? $5 : $2;
   FLAC__bitwriter_clear(HEAP32[HEAP32[$0 + 4 >> 2] + 6856 >> 2]);
   if (!$1) {
    break label$1
   }
   $1 = HEAP32[$0 + 4 >> 2] + 6896 | 0;
   $2 = HEAP32[$1 >> 2];
   $3 = $1;
   $1 = HEAP32[$16 >> 2];
   HEAP32[$3 >> 2] = $1 >>> 0 < $2 >>> 0 ? $1 : $2;
   $2 = HEAP32[$0 + 4 >> 2] + 6900 | 0;
   $0 = HEAP32[$2 >> 2];
   HEAP32[$2 >> 2] = $0 >>> 0 < $1 >>> 0 ? $1 : $0;
  }
  __stack_pointer = $16 + 16 | 0;
  return $8;
 }
 
 function FLAC__stream_encoder_init_ogg_stream($0, $1, $2, $3, $4, $5, $6) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $5 = $5 | 0;
  $6 = $6 | 0;
  return init_stream_internal__1($0, $1, $2, $3, $4, $5, $6, 1) | 0;
 }
 
 function process_subframe_($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10) {
  var $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0.0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0.0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0.0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = Math_fround(0), $39 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0.0, $47 = 0.0, $48 = 0, $49 = Math_fround(0), $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0.0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0;
  $23 = __stack_pointer - 576 | 0;
  __stack_pointer = $23;
  $34 = HEAP32[(HEAPU32[HEAP32[$0 >> 2] + 28 >> 2] > 16 ? 6752 : 6748) >> 2];
  $12 = HEAP32[$3 >> 2];
  label$1 : {
   label$2 : {
    if (HEAP32[HEAP32[$0 + 4 >> 2] + 7256 >> 2]) {
     $11 = -1;
     if ($12 >>> 0 > 3) {
      break label$2
     }
    }
    $11 = HEAP32[$6 >> 2];
    HEAP32[$11 + 4 >> 2] = $5;
    HEAP32[$11 >> 2] = 1;
    $11 = HEAP32[$11 + 288 >> 2] + (HEAP32[1693] + (HEAP32[1692] + (HEAP32[1691] + Math_imul($4, $12) | 0) | 0) | 0) | 0;
    $12 = HEAP32[$3 >> 2];
    if ($12 >>> 0 < 4) {
     break label$1
    }
   }
   $26 = $12 - 4 | 0;
   $16 = FUNCTION_TABLE[HEAP32[HEAP32[$0 + 4 >> 2] + (((Math_clz32($26 | 1) ^ 31) + $4 | 0) + 4 >>> 0 < 33 ? 7224 : 7228) >> 2]]($5 + 16 | 0, $26, $23 + 416 | 0) | 0;
   label$4 : {
    label$5 : {
     label$6 : {
      label$7 : {
       $13 = HEAP32[$0 + 4 >> 2];
       if (HEAP32[$13 + 7248 >> 2] | HEAPF32[$23 + 420 >> 2] != Math_fround(0.0)) {
        break label$7
       }
       $12 = 1;
       $26 = HEAP32[$5 >> 2];
       $18 = HEAP32[$3 >> 2];
       if ($18 >>> 0 <= 1) {
        break label$6
       }
       while (1) {
        if (($26 | 0) != HEAP32[($12 << 2) + $5 >> 2]) {
         break label$7
        }
        $12 = $12 + 1 | 0;
        if (($12 | 0) != ($18 | 0)) {
         continue
        }
        break;
       };
       break label$6;
      }
      $12 = HEAP32[$0 >> 2];
      if (!HEAP32[$13 + 7252 >> 2]) {
       $26 = $11;
       break label$5;
      }
      if (HEAP32[$12 + 556 >> 2]) {
       $26 = $11;
       break label$4;
      }
      $26 = -1;
      if (($11 | 0) == -1) {
       break label$5
      }
      $26 = $11;
      break label$4;
     }
     $0 = HEAP32[$6 + 4 >> 2];
     HEAP32[$0 + 4 >> 2] = $26;
     HEAP32[$0 >> 2] = 0;
     $0 = HEAP32[$0 + 288 >> 2] + (HEAP32[1693] + (HEAP32[1692] + (HEAP32[1691] + $4 | 0) | 0) | 0) | 0;
     $19 = $0 >>> 0 < $11 >>> 0;
     $11 = $19 ? $0 : $11;
     break label$1;
    }
    $11 = HEAP32[$12 + 568 >> 2];
    $13 = $11 ? 0 : $16;
    $11 = $11 ? 4 : $16;
    $16 = HEAP32[$3 >> 2];
    $31 = $11 >>> 0 < $16 >>> 0 ? $11 : $16 - 1 | 0;
    if ($13 >>> 0 > $31 >>> 0) {
     break label$4
    }
    $27 = $34 - 1 | 0;
    $37 = HEAP32[1693];
    $35 = HEAP32[1692];
    $36 = HEAP32[1691];
    $49 = Math_fround($4 >>> 0);
    $32 = $13 - 1 | 0;
    $18 = $13;
    while (1) {
     $12 = $18 << 2;
     $38 = HEAPF32[$12 + ($23 + 416 | 0) >> 2];
     if (!($38 >= $49)) {
      $39 = !$19;
      $11 = $39 << 2;
      $40 = HEAP32[$11 + $7 >> 2];
      $21 = HEAP32[$6 + $11 >> 2];
      $41 = HEAP32[HEAP32[$0 >> 2] + 572 >> 2];
      $16 = HEAP32[$0 + 4 >> 2];
      $33 = HEAP32[$16 + 6852 >> 2];
      $43 = HEAP32[$16 + 6848 >> 2];
      $16 = $5 + $12 | 0;
      $42 = HEAP32[$3 >> 2] - $18 | 0;
      $12 = $42;
      $24 = HEAP32[$8 + $11 >> 2];
      $14 = $24;
      __inlined_func$FLAC__fixed_compute_residual : {
       label$10 : {
        switch ($18 | 0) {
        case 4:
         $11 = 0;
         if (($12 | 0) <= 0) {
          break __inlined_func$FLAC__fixed_compute_residual
         }
         while (1) {
          $20 = $11 << 2;
          $17 = $20 + $16 | 0;
          HEAP32[$14 + $20 >> 2] = (HEAP32[$17 - 16 >> 2] + (HEAP32[$17 >> 2] + Math_imul(HEAP32[$17 - 8 >> 2], 6) | 0) | 0) - (HEAP32[$17 - 12 >> 2] + HEAP32[$17 - 4 >> 2] << 2);
          $11 = $11 + 1 | 0;
          if (($11 | 0) != ($12 | 0)) {
           continue
          }
          break;
         };
         break __inlined_func$FLAC__fixed_compute_residual;
        case 3:
         $11 = 0;
         if (($12 | 0) <= 0) {
          break __inlined_func$FLAC__fixed_compute_residual
         }
         while (1) {
          $20 = $11 << 2;
          $17 = $20 + $16 | 0;
          HEAP32[$14 + $20 >> 2] = (HEAP32[$17 >> 2] - HEAP32[$17 - 12 >> 2] | 0) + Math_imul(HEAP32[$17 - 8 >> 2] - HEAP32[$17 - 4 >> 2] | 0, 3);
          $11 = $11 + 1 | 0;
          if (($11 | 0) != ($12 | 0)) {
           continue
          }
          break;
         };
         break __inlined_func$FLAC__fixed_compute_residual;
        case 2:
         if (($12 | 0) < 1) {
          break __inlined_func$FLAC__fixed_compute_residual
         }
         $11 = 0;
         if (($12 | 0) != 1) {
          $17 = $12 & -2;
          while (1) {
           $25 = $11 << 2;
           $20 = $25 + $16 | 0;
           $28 = $20 - 4 | 0;
           HEAP32[$14 + $25 >> 2] = HEAP32[$20 - 8 >> 2] + (HEAP32[$20 >> 2] - (HEAP32[$28 >> 2] << 1) | 0);
           $25 = $25 | 4;
           HEAP32[$25 + $14 >> 2] = HEAP32[$28 >> 2] + (HEAP32[$16 + $25 >> 2] - (HEAP32[$20 >> 2] << 1) | 0);
           $11 = $11 + 2 | 0;
           $17 = $17 - 2 | 0;
           if ($17) {
            continue
           }
           break;
          };
         }
         if (!($12 & 1)) {
          break __inlined_func$FLAC__fixed_compute_residual
         }
         $12 = $11 << 2;
         $11 = $12 + $16 | 0;
         HEAP32[$12 + $14 >> 2] = HEAP32[$11 - 8 >> 2] + (HEAP32[$11 >> 2] - (HEAP32[$11 - 4 >> 2] << 1) | 0);
         break __inlined_func$FLAC__fixed_compute_residual;
        case 1:
         if (($12 | 0) < 1) {
          break __inlined_func$FLAC__fixed_compute_residual
         }
         $11 = 0;
         if (($12 | 0) != 1) {
          $17 = $12 & -2;
          while (1) {
           $25 = $11 << 2;
           $20 = $25 + $16 | 0;
           HEAP32[$14 + $25 >> 2] = HEAP32[$20 >> 2] - HEAP32[$20 - 4 >> 2];
           $25 = $25 | 4;
           HEAP32[$25 + $14 >> 2] = HEAP32[$16 + $25 >> 2] - HEAP32[$20 >> 2];
           $11 = $11 + 2 | 0;
           $17 = $17 - 2 | 0;
           if ($17) {
            continue
           }
           break;
          };
         }
         if (!($12 & 1)) {
          break __inlined_func$FLAC__fixed_compute_residual
         }
         $12 = $11 << 2;
         $11 = $12 + $16 | 0;
         HEAP32[$12 + $14 >> 2] = HEAP32[$11 >> 2] - HEAP32[$11 - 4 >> 2];
         break __inlined_func$FLAC__fixed_compute_residual;
        case 0:
         break label$10;
        default:
         break __inlined_func$FLAC__fixed_compute_residual;
        };
       }
       __memcpy($14, $16, $12 << 2);
      }
      HEAP32[$21 + 36 >> 2] = $24;
      HEAP32[$21 + 12 >> 2] = $40;
      HEAP32[$21 >> 2] = 2;
      HEAP32[$21 + 4 >> 2] = 0;
      $11 = $38 > Math_fround(0.0);
      $17 = HEAP32[$0 + 4 >> 2];
      $12 = $18;
      $15 = +$38 + .5;
      label$13 : {
       if ($15 < 4294967296.0 & $15 >= 0.0) {
        $14 = ~~$15 >>> 0;
        break label$13;
       }
       $14 = 0;
      }
      $11 = $11 ? $14 + 1 | 0 : 1;
      $20 = find_best_partition_order_($17, $24, $43, $33, $42, $12, $11 >>> 0 < $34 >>> 0 ? $11 : $27, $34, $1, $2, $4, $41, $21 + 4 | 0);
      HEAP32[$21 + 16 >> 2] = $18;
      label$15 : {
       if (!$18) {
        break label$15
       }
       $16 = $21 + 20 | 0;
       $12 = $13 + $29 | 0;
       $17 = $12 & 3;
       $11 = 0;
       if ($29 + $32 >>> 0 >= 3) {
        $12 = $12 & -4;
        while (1) {
         $14 = $11 << 2;
         HEAP32[$14 + $16 >> 2] = HEAP32[$5 + $14 >> 2];
         $24 = $14 | 4;
         HEAP32[$24 + $16 >> 2] = HEAP32[$5 + $24 >> 2];
         $24 = $14 | 8;
         HEAP32[$24 + $16 >> 2] = HEAP32[$5 + $24 >> 2];
         $14 = $14 | 12;
         HEAP32[$14 + $16 >> 2] = HEAP32[$5 + $14 >> 2];
         $11 = $11 + 4 | 0;
         $12 = $12 - 4 | 0;
         if ($12) {
          continue
         }
         break;
        };
       }
       if (!$17) {
        break label$15
       }
       while (1) {
        $12 = $11 << 2;
        HEAP32[$12 + $16 >> 2] = HEAP32[$5 + $12 >> 2];
        $11 = $11 + 1 | 0;
        $17 = $17 - 1 | 0;
        if ($17) {
         continue
        }
        break;
       };
      }
      $11 = HEAP32[$21 + 288 >> 2] + ($37 + ($35 + ($36 + ($20 + Math_imul($4, $18) | 0) | 0) | 0) | 0) | 0;
      $12 = $11 >>> 0 < $26 >>> 0;
      $19 = $12 ? $39 : $19;
      $26 = $12 ? $11 : $26;
     }
     $29 = $29 + 1 | 0;
     $18 = $18 + 1 | 0;
     if ($31 >>> 0 >= $18 >>> 0) {
      continue
     }
     break;
    };
    $12 = HEAP32[$0 >> 2];
   }
   $13 = HEAP32[$12 + 556 >> 2];
   if (!$13) {
    $11 = $26;
    break label$1;
   }
   $11 = HEAP32[$3 >> 2];
   $13 = $11 >>> 0 > $13 >>> 0 ? $13 : $11 - 1 | 0;
   HEAP32[$23 + 12 >> 2] = $13;
   if (!$13) {
    $11 = $26;
    break label$1;
   }
   if (!HEAP32[$12 + 40 >> 2]) {
    $11 = $26;
    break label$1;
   }
   $43 = $34 - 1 | 0;
   $42 = HEAP32[1690];
   $50 = HEAP32[1689];
   $51 = HEAP32[1693];
   $52 = HEAP32[1692];
   $53 = HEAP32[1691];
   $54 = +($4 >>> 0);
   $55 = $4 >>> 0 < 18;
   $56 = $4 >>> 0 > 16;
   $57 = $4 >>> 0 > 17;
   while (1) {
    $12 = $5;
    $13 = HEAP32[$0 + 4 >> 2];
    $16 = HEAP32[($13 + ($44 << 2) | 0) + 84 >> 2];
    $18 = HEAP32[$13 + 212 >> 2];
    $13 = 0;
    label$19 : {
     if (!$11) {
      break label$19
     }
     if (($11 | 0) != 1) {
      $21 = $11 & -2;
      while (1) {
       $14 = $13 << 2;
       HEAPF32[$14 + $18 >> 2] = HEAPF32[$16 + $14 >> 2] * Math_fround(HEAP32[$12 + $14 >> 2]);
       $14 = $14 | 4;
       HEAPF32[$14 + $18 >> 2] = HEAPF32[$16 + $14 >> 2] * Math_fround(HEAP32[$12 + $14 >> 2]);
       $13 = $13 + 2 | 0;
       $21 = $21 - 2 | 0;
       if ($21) {
        continue
       }
       break;
      };
     }
     if (!($11 & 1)) {
      break label$19
     }
     $11 = $13 << 2;
     HEAPF32[$18 + $11 >> 2] = HEAPF32[$11 + $16 >> 2] * Math_fround(HEAP32[$11 + $12 >> 2]);
    }
    $11 = HEAP32[$0 + 4 >> 2];
    FUNCTION_TABLE[HEAP32[$11 + 7232 >> 2]](HEAP32[$11 + 212 >> 2], HEAP32[$3 >> 2], HEAP32[$23 + 12 >> 2] + 1 | 0, $23 + 272 | 0);
    label$23 : {
     if (HEAPF32[$23 + 272 >> 2] == Math_fround(0.0)) {
      break label$23
     }
     $20 = HEAP32[$0 + 4 >> 2] + 7628 | 0;
     $29 = $23 + 16 | 0;
     $11 = 0;
     $16 = __stack_pointer - 256 | 0;
     __stack_pointer = $16;
     $24 = $23 + 12 | 0;
     $25 = HEAP32[$24 >> 2];
     $14 = $23 + 272 | 0;
     $22 = +HEAPF32[$14 >> 2];
     label$111 : {
      while (1) {
       if (($11 | 0) == ($25 | 0)) {
        break label$111
       }
       $12 = $11 + 1 | 0;
       $15 = +Math_fround(-HEAPF32[($12 << 2) + $14 >> 2]);
       label$313 : {
        if ($11) {
         $13 = 0;
         if (($11 | 0) != 1) {
          $18 = $11 & -2;
          while (1) {
           $21 = $13 | 1;
           $15 = $15 - HEAPF64[($13 << 3) + $16 >> 3] * +HEAPF32[($11 - $13 << 2) + $14 >> 2] - HEAPF64[($21 << 3) + $16 >> 3] * +HEAPF32[($11 - $21 << 2) + $14 >> 2];
           $13 = $13 + 2 | 0;
           $18 = $18 - 2 | 0;
           if ($18) {
            continue
           }
           break;
          };
         }
         $28 = $11 & 1;
         $15 = ($28 ? $15 - HEAPF64[($13 << 3) + $16 >> 3] * +HEAPF32[($11 - $13 << 2) + $14 >> 2] : $15) / $22;
         HEAPF64[($11 << 3) + $16 >> 3] = $15;
         $18 = 0;
         label$815 : {
          if ($11 >>> 0 < 2) {
           break label$815
          }
          $13 = $11 >>> 1 | 0;
          $18 = $13 >>> 0 > 1 ? $13 : 1;
          $31 = $18 & 1;
          $13 = 0;
          if ($11 >>> 0 >= 4) {
           $21 = $18 & 2147483646;
           while (1) {
            $27 = $13 << 3;
            $17 = $27 + $16 | 0;
            $30 = HEAPF64[$17 >> 3];
            $33 = $17;
            $17 = (($13 ^ -1) + $11 << 3) + $16 | 0;
            HEAPF64[$33 >> 3] = $30 + $15 * HEAPF64[$17 >> 3];
            HEAPF64[$17 >> 3] = $15 * $30 + HEAPF64[$17 >> 3];
            $17 = ($27 | 8) + $16 | 0;
            $30 = HEAPF64[$17 >> 3];
            $33 = $17;
            $17 = (($11 - $13 << 3) + $16 | 0) - 16 | 0;
            HEAPF64[$33 >> 3] = $30 + $15 * HEAPF64[$17 >> 3];
            HEAPF64[$17 >> 3] = $15 * $30 + HEAPF64[$17 >> 3];
            $13 = $13 + 2 | 0;
            $21 = $21 - 2 | 0;
            if ($21) {
             continue
            }
            break;
           };
          }
          if (!$31) {
           break label$815
          }
          $21 = ($13 << 3) + $16 | 0;
          $30 = HEAPF64[$21 >> 3];
          $13 = (($13 ^ -1) + $11 << 3) + $16 | 0;
          HEAPF64[$21 >> 3] = $30 + $15 * HEAPF64[$13 >> 3];
          HEAPF64[$13 >> 3] = $15 * $30 + HEAPF64[$13 >> 3];
         }
         if (!$28) {
          break label$313
         }
         $13 = ($18 << 3) + $16 | 0;
         $30 = HEAPF64[$13 >> 3];
         HEAPF64[$13 >> 3] = $30 + $15 * $30;
         break label$313;
        }
        $15 = $15 / $22;
        HEAPF64[($11 << 3) + $16 >> 3] = $15;
       }
       $15 = 1.0 - $15 * $15;
       $13 = 0;
       while (1) {
        HEAPF32[(($11 << 7) + $20 | 0) + ($13 << 2) >> 2] = -Math_fround(HEAPF64[($13 << 3) + $16 >> 3]);
        $13 = $13 + 1 | 0;
        if ($13 >>> 0 <= $11 >>> 0) {
         continue
        }
        break;
       };
       $22 = $22 * $15;
       HEAPF64[($11 << 3) + $29 >> 3] = $22;
       $11 = $12;
       if ($22 != 0.0) {
        continue
       }
       break;
      };
      HEAP32[$24 >> 2] = $12;
     }
     __stack_pointer = $16 + 256 | 0;
     $16 = 1;
     $12 = HEAP32[$23 + 12 >> 2];
     $11 = HEAP32[$0 >> 2];
     if (!HEAP32[$11 + 568 >> 2]) {
      $21 = $23 + 16 | 0;
      $18 = HEAP32[$3 >> 2];
      $17 = (HEAP32[$11 + 564 >> 2] ? 5 : HEAP32[$11 + 560 >> 2]) + $4 | 0;
      $11 = 0;
      $16 = 0;
      $13 = 1;
      $24 = $23;
      if ($12) {
       $30 = .5 / +($18 >>> 0);
       $15 = 4294967295.0;
       while (1) {
        $22 = HEAPF64[($11 << 3) + $21 >> 3];
        label$319 : {
         if ($22 > 0.0) {
          $22 = log($30 * $22) * .5 / .6931471805599453;
          $22 = $22 >= 0.0 ? $22 : 0.0;
          break label$319;
         }
         $22 = $22 < 0.0 ? 1.e+32 : 0.0;
        }
        $22 = $22 * +($18 - $13 >>> 0) + +(Math_imul($13, $17) >>> 0);
        $14 = $22 < $15;
        $15 = $14 ? $22 : $15;
        $16 = $14 ? $11 : $16;
        $13 = $13 + 1 | 0;
        $11 = $11 + 1 | 0;
        if (($11 | 0) != ($12 | 0)) {
         continue
        }
        break;
       };
       $12 = $16 + 1 | 0;
      } else {
       $12 = 1
      }
      HEAP32[$24 + 12 >> 2] = $12;
      $16 = $12;
     }
     $11 = HEAP32[$3 >> 2];
     if ($11 >>> 0 <= $12 >>> 0) {
      $12 = $11 - 1 | 0;
      HEAP32[$23 + 12 >> 2] = $12;
     }
     if ($12 >>> 0 < $16 >>> 0) {
      break label$23
     }
     $58 = $16 - 1 | 0;
     $25 = 0;
     $13 = $16;
     while (1) {
      label$28 : {
       $11 = $11 - $13 | 0;
       $45 = $13 - 1 | 0;
       $15 = HEAPF64[($23 + 16 | 0) + ($45 << 3) >> 3];
       __inlined_func$FLAC__lpc_compute_expected_bits_per_residual_sample : {
        if ($15 > 0.0) {
         $15 = log(.5 / +($11 >>> 0) * $15) * .5 / .6931471805599453;
         $15 = $15 >= 0.0 ? $15 : 0.0;
         break __inlined_func$FLAC__lpc_compute_expected_bits_per_residual_sample;
        }
        $15 = $15 < 0.0 ? 1.e+32 : 0.0;
       }
       if ($15 >= $54) {
        break label$28
       }
       $22 = $15 + .5;
       label$29 : {
        if ($22 < 4294967296.0 & $22 >= 0.0) {
         $21 = ~~$22 >>> 0;
         break label$29;
        }
        $21 = 0;
       }
       $12 = HEAP32[$0 >> 2];
       label$31 : {
        if (HEAP32[$12 + 564 >> 2]) {
         $18 = 5;
         $14 = 15;
         if ($57) {
          break label$31
         }
         $11 = 15;
         $14 = ((Math_clz32($13) ^ -32) - $4 | 0) + 33 | 0;
         if ($14 >>> 0 <= 14) {
          $11 = $14;
          $14 = 5;
          if ($11 >>> 0 < 6) {
           break label$31
          }
         }
         $14 = $11;
         break label$31;
        }
        $18 = HEAP32[$12 + 560 >> 2];
        $14 = $18;
       }
       $39 = $14;
       if ($18 >>> 0 > $39 >>> 0) {
        break label$28
       }
       $59 = $25 + $58 | 0;
       $11 = $15 > 0.0 ? $21 + 1 | 0 : 1;
       $60 = $11 >>> 0 < $34 >>> 0 ? $11 : $43;
       $37 = ($13 << 2) + $5 | 0;
       $11 = Math_clz32($13);
       $61 = $11 ^ 31;
       $40 = (($11 ^ -32) - $4 | 0) + 33 | 0;
       $11 = $16 + $25 | 0;
       $21 = $11 & -4;
       $17 = $11 & 3;
       while (1) {
        $62 = HEAP32[$3 >> 2];
        $14 = !$19;
        $11 = $14 << 2;
        $63 = HEAP32[$11 + $7 >> 2];
        $20 = HEAP32[$6 + $11 >> 2];
        $24 = HEAP32[$8 + $11 >> 2];
        $64 = HEAP32[$12 + 572 >> 2];
        $12 = HEAP32[$0 + 4 >> 2];
        $65 = HEAP32[$12 + 6852 >> 2];
        $66 = HEAP32[$12 + 6848 >> 2];
        $11 = 0;
        $67 = $14;
        $68 = $19;
        $29 = ($12 + ($45 << 7) | 0) + 7628 | 0;
        $35 = $55 ? ($18 >>> 0 < $40 >>> 0 ? $18 : $40) : $18;
        $33 = $35;
        $41 = $23 + 448 | 0;
        $28 = $23 + 444 | 0;
        $15 = 0.0;
        $19 = 0;
        $36 = __stack_pointer - 16 | 0;
        __stack_pointer = $36;
        $31 = 2;
        $14 = $13;
        label$120 : {
         if (!$13) {
          break label$120
         }
         $12 = $14 & 3;
         if ($14 - 1 >>> 0 >= 3) {
          $32 = $14 & -4;
          while (1) {
           $27 = $19 << 2;
           $22 = +Math_fround(Math_abs(HEAPF32[($27 | 12) + $29 >> 2]));
           $30 = +Math_fround(Math_abs(HEAPF32[($27 | 8) + $29 >> 2]));
           $46 = +Math_fround(Math_abs(HEAPF32[($27 | 4) + $29 >> 2]));
           $47 = +Math_fround(Math_abs(HEAPF32[$29 + $27 >> 2]));
           $15 = $15 < $47 ? $47 : $15;
           $15 = $15 < $46 ? $46 : $15;
           $15 = $15 < $30 ? $30 : $15;
           $15 = $15 < $22 ? $22 : $15;
           $19 = $19 + 4 | 0;
           $32 = $32 - 4 | 0;
           if ($32) {
            continue
           }
           break;
          };
         }
         if ($12) {
          while (1) {
           $22 = +Math_fround(Math_abs(HEAPF32[($19 << 2) + $29 >> 2]));
           $15 = $15 < $22 ? $22 : $15;
           $19 = $19 + 1 | 0;
           $12 = $12 - 1 | 0;
           if ($12) {
            continue
           }
           break;
          }
         }
         if ($15 <= 0.0) {
          break label$120
         }
         frexp($15, $36 + 12 | 0);
         $31 = $33 - 1 | 0;
         $12 = $31 - HEAP32[$36 + 12 >> 2] | 0;
         HEAP32[$28 >> 2] = $12;
         label$724 : {
          $27 = -1 << HEAP32[1690] - 1;
          $19 = $27 ^ -1;
          if (($12 | 0) > ($19 | 0)) {
           HEAP32[$28 >> 2] = $19;
           $12 = $19;
           break label$724;
          }
          if (($12 | 0) >= ($27 | 0)) {
           break label$724
          }
          $31 = 1;
          break label$120;
         }
         $32 = 1 << $31;
         $33 = $32 - 1 | 0;
         $27 = 0 - $32 | 0;
         $19 = 0;
         if (($12 | 0) >= 0) {
          $31 = 0;
          if (!$14) {
           break label$120
          }
          $15 = 0.0;
          while (1) {
           $48 = $19 << 2;
           $15 = $15 + +Math_fround(HEAPF32[$48 + $29 >> 2] * Math_fround(1 << $12));
           $12 = lround($15);
           $12 = ($12 | 0) < ($32 | 0) ? (($12 | 0) < ($27 | 0) ? $27 : $12) : $33;
           HEAP32[$41 + $48 >> 2] = $12;
           $19 = $19 + 1 | 0;
           if (($19 | 0) == ($14 | 0)) {
            break label$120
           }
           $15 = $15 - +($12 | 0);
           $12 = HEAP32[$28 >> 2];
           continue;
          };
         }
         if ($14) {
          $38 = Math_fround(1 << 0 - $12);
          $15 = 0.0;
          while (1) {
           $31 = $19 << 2;
           $15 = $15 + +Math_fround(HEAPF32[$31 + $29 >> 2] / $38);
           $12 = lround($15);
           $12 = ($12 | 0) < ($32 | 0) ? (($12 | 0) < ($27 | 0) ? $27 : $12) : $33;
           HEAP32[$31 + $41 >> 2] = $12;
           $15 = $15 - +($12 | 0);
           $19 = $19 + 1 | 0;
           if (($19 | 0) != ($14 | 0)) {
            continue
           }
           break;
          };
         }
         $31 = 0;
         HEAP32[$28 >> 2] = 0;
        }
        __stack_pointer = $36 + 16 | 0;
        if (!$31) {
         $11 = $62 - $13 | 0;
         $29 = $4 + $35 | 0;
         label$36 : {
          if ($29 + $61 >>> 0 <= 32) {
           $12 = HEAP32[$0 + 4 >> 2];
           if (!($35 >>> 0 > 16 | $56)) {
            FUNCTION_TABLE[HEAP32[$12 + 7244 >> 2]]($37, $11, $23 + 448 | 0, $13, HEAP32[$23 + 444 >> 2], $24);
            break label$36;
           }
           FUNCTION_TABLE[HEAP32[$12 + 7236 >> 2]]($37, $11, $23 + 448 | 0, $13, HEAP32[$23 + 444 >> 2], $24);
           break label$36;
          }
          FUNCTION_TABLE[HEAP32[HEAP32[$0 + 4 >> 2] + 7240 >> 2]]($37, $11, $23 + 448 | 0, $13, HEAP32[$23 + 444 >> 2], $24);
         }
         HEAP32[$20 >> 2] = 3;
         HEAP32[$20 + 4 >> 2] = 0;
         HEAP32[$20 + 284 >> 2] = $24;
         HEAP32[$20 + 12 >> 2] = $63;
         $24 = find_best_partition_order_(HEAP32[$0 + 4 >> 2], $24, $66, $65, $11, $13, $60, $34, $1, $2, $4, $64, $20 + 4 | 0);
         HEAP32[$20 + 20 >> 2] = $35;
         HEAP32[$20 + 16 >> 2] = $13;
         HEAP32[$20 + 24 >> 2] = HEAP32[$23 + 444 >> 2];
         __memcpy($20 + 28 | 0, $23 + 448 | 0, 128);
         label$39 : {
          if (!$13) {
           break label$39
          }
          $11 = 0;
          $12 = $21;
          if ($59 >>> 0 >= 3) {
           while (1) {
            $19 = $20 + 156 | 0;
            $14 = $11 << 2;
            HEAP32[$19 + $14 >> 2] = HEAP32[$5 + $14 >> 2];
            $28 = $14 | 4;
            HEAP32[$28 + $19 >> 2] = HEAP32[$5 + $28 >> 2];
            $28 = $14 | 8;
            HEAP32[$28 + $19 >> 2] = HEAP32[$5 + $28 >> 2];
            $14 = $14 | 12;
            HEAP32[$14 + $19 >> 2] = HEAP32[$5 + $14 >> 2];
            $11 = $11 + 4 | 0;
            $12 = $12 - 4 | 0;
            if ($12) {
             continue
            }
            break;
           }
          }
          $12 = $17;
          if (!$12) {
           break label$39
          }
          while (1) {
           $14 = $11 << 2;
           HEAP32[($14 + $20 | 0) + 156 >> 2] = HEAP32[$5 + $14 >> 2];
           $11 = $11 + 1 | 0;
           $12 = $12 - 1 | 0;
           if ($12) {
            continue
           }
           break;
          };
         }
         $11 = ((HEAP32[$20 + 288 >> 2] + (((($24 + Math_imul($13, $29) | 0) + $53 | 0) + $52 | 0) + $51 | 0) | 0) + $50 | 0) + $42 | 0;
        }
        $12 = ($11 | 0) != 0 & $11 >>> 0 < $26 >>> 0;
        $19 = $12 ? $67 : $68;
        $26 = $12 ? $11 : $26;
        $18 = $18 + 1 | 0;
        if ($39 >>> 0 < $18 >>> 0) {
         break label$28
        }
        $12 = HEAP32[$0 >> 2];
        continue;
       };
      }
      $13 = $13 + 1 | 0;
      if ($13 >>> 0 > HEAPU32[$23 + 12 >> 2]) {
       break label$23
      }
      $25 = $25 + 1 | 0;
      $11 = HEAP32[$3 >> 2];
      continue;
     };
    }
    $44 = $44 + 1 | 0;
    if ($44 >>> 0 >= HEAPU32[HEAP32[$0 >> 2] + 40 >> 2]) {
     $11 = $26
    } else {
     $11 = HEAP32[$3 >> 2];
     continue;
    }
    break;
   };
  }
  if (($11 | 0) == -1) {
   $1 = HEAP32[$3 >> 2];
   $0 = HEAP32[($19 << 2) + $6 >> 2];
   HEAP32[$0 + 4 >> 2] = $5;
   HEAP32[$0 >> 2] = 1;
   $11 = HEAP32[$0 + 288 >> 2] + (HEAP32[1693] + (HEAP32[1692] + (HEAP32[1691] + Math_imul($1, $4) | 0) | 0) | 0) | 0;
  }
  HEAP32[$9 >> 2] = $19;
  HEAP32[$10 >> 2] = $11;
  __stack_pointer = $23 + 576 | 0;
 }
 
 function add_subframe_($0, $1, $2, $3, $4) {
  var $5 = 0, $6 = 0, $7 = 0, $8 = 0;
  $7 = 1;
  label$1 : {
   label$2 : {
    label$3 : {
     switch (HEAP32[$3 >> 2]) {
     case 0:
      $5 = $3 + 4 | 0;
      $1 = 0;
      $3 = HEAP32[$3 + 288 >> 2];
      label$10 : {
       if (!FLAC__bitwriter_write_raw_uint32($4, HEAP32[1694] | ($3 | 0) != 0, HEAP32[1693] + (HEAP32[1692] + HEAP32[1691] | 0) | 0)) {
        break label$10
       }
       if ($3) {
        if (!FLAC__bitwriter_write_unary_unsigned($4, $3 - 1 | 0)) {
         break label$10
        }
       }
       $1 = (FLAC__bitwriter_write_raw_int32($4, HEAP32[$5 >> 2], $2) | 0) != 0;
      }
      if (!$1) {
       break label$2
      }
      break label$1;
     case 2:
      $8 = $1 - HEAP32[$3 + 16 >> 2] | 0;
      $6 = HEAP32[$3 + 288 >> 2];
      $1 = $3 + 4 | 0;
      __inlined_func$FLAC__subframe_add_fixed : {
       label$11 : {
        if (!FLAC__bitwriter_write_raw_uint32($4, HEAP32[1696] | ($6 | 0) != 0 | HEAP32[$1 + 12 >> 2] << 1, HEAP32[1693] + (HEAP32[1692] + HEAP32[1691] | 0) | 0)) {
         break label$11
        }
        if ($6) {
         if (!FLAC__bitwriter_write_unary_unsigned($4, $6 - 1 | 0)) {
          break label$11
         }
        }
        label$32 : {
         if (!HEAP32[$1 + 12 >> 2]) {
          break label$32
         }
         $3 = 0;
         while (1) {
          if (FLAC__bitwriter_write_raw_int32($4, HEAP32[(($3 << 2) + $1 | 0) + 16 >> 2], $2)) {
           $3 = $3 + 1 | 0;
           if ($3 >>> 0 < HEAPU32[$1 + 12 >> 2]) {
            continue
           }
           break label$32;
          }
          break;
         };
         $5 = 0;
         break __inlined_func$FLAC__subframe_add_fixed;
        }
        if (!FLAC__bitwriter_write_raw_uint32($4, HEAP32[$1 >> 2], HEAP32[1682])) {
         break label$11
        }
        label$64 : {
         if (HEAPU32[$1 >> 2] > 1) {
          break label$64
         }
         if (!FLAC__bitwriter_write_raw_uint32($4, HEAP32[$1 + 4 >> 2], HEAP32[1683])) {
          break label$11
         }
         $2 = HEAP32[$1 >> 2];
         if ($2 >>> 0 > 1) {
          break label$64
         }
         $3 = HEAP32[$1 + 8 >> 2];
         if (!add_residual_partitioned_rice_($4, HEAP32[$1 + 32 >> 2], $8, HEAP32[$1 + 12 >> 2], HEAP32[$3 >> 2], HEAP32[$3 + 4 >> 2], HEAP32[$1 + 4 >> 2], ($2 | 0) == 1)) {
          break label$11
         }
        }
        $5 = 1;
       }
      }
      if (!$5) {
       break label$2
      }
      break label$1;
     case 3:
      $6 = $1 - HEAP32[$3 + 16 >> 2] | 0;
      $1 = $3 + 4 | 0;
      $3 = HEAP32[$3 + 288 >> 2];
      __inlined_func$FLAC__subframe_add_lpc : {
       label$15 : {
        if (!FLAC__bitwriter_write_raw_uint32($4, (HEAP32[$1 + 12 >> 2] << 1) - 2 | (HEAP32[1697] | ($3 | 0) != 0), HEAP32[1693] + (HEAP32[1692] + HEAP32[1691] | 0) | 0)) {
         break label$15
        }
        if ($3) {
         if (!FLAC__bitwriter_write_unary_unsigned($4, $3 - 1 | 0)) {
          break label$15
         }
        }
        label$36 : {
         if (!HEAP32[$1 + 12 >> 2]) {
          break label$36
         }
         $3 = 0;
         while (1) {
          if (FLAC__bitwriter_write_raw_int32($4, HEAP32[(($3 << 2) + $1 | 0) + 152 >> 2], $2)) {
           $3 = $3 + 1 | 0;
           if ($3 >>> 0 < HEAPU32[$1 + 12 >> 2]) {
            continue
           }
           break label$36;
          }
          break;
         };
         $5 = 0;
         break __inlined_func$FLAC__subframe_add_lpc;
        }
        if (!FLAC__bitwriter_write_raw_uint32($4, HEAP32[$1 + 16 >> 2] - 1 | 0, HEAP32[1689])) {
         break label$15
        }
        if (!FLAC__bitwriter_write_raw_int32($4, HEAP32[$1 + 20 >> 2], HEAP32[1690])) {
         break label$15
        }
        label$68 : {
         if (!HEAP32[$1 + 12 >> 2]) {
          break label$68
         }
         $3 = 0;
         while (1) {
          if (FLAC__bitwriter_write_raw_int32($4, HEAP32[(($3 << 2) + $1 | 0) + 24 >> 2], HEAP32[$1 + 16 >> 2])) {
           $3 = $3 + 1 | 0;
           if ($3 >>> 0 < HEAPU32[$1 + 12 >> 2]) {
            continue
           }
           break label$68;
          }
          break;
         };
         $5 = 0;
         break __inlined_func$FLAC__subframe_add_lpc;
        }
        if (!FLAC__bitwriter_write_raw_uint32($4, HEAP32[$1 >> 2], HEAP32[1682])) {
         break label$15
        }
        label$9 : {
         if (HEAPU32[$1 >> 2] > 1) {
          break label$9
         }
         if (!FLAC__bitwriter_write_raw_uint32($4, HEAP32[$1 + 4 >> 2], HEAP32[1683])) {
          break label$15
         }
         $2 = HEAP32[$1 >> 2];
         if ($2 >>> 0 > 1) {
          break label$9
         }
         $3 = HEAP32[$1 + 8 >> 2];
         if (!add_residual_partitioned_rice_($4, HEAP32[$1 + 280 >> 2], $6, HEAP32[$1 + 12 >> 2], HEAP32[$3 >> 2], HEAP32[$3 + 4 >> 2], HEAP32[$1 + 4 >> 2], ($2 | 0) == 1)) {
          break label$15
         }
        }
        $5 = 1;
       }
      }
      if (!$5) {
       break label$2
      }
      break label$1;
     case 1:
      break label$3;
     default:
      break label$1;
     };
    }
    $5 = HEAP32[$3 + 4 >> 2];
    $3 = HEAP32[$3 + 288 >> 2];
    __inlined_func$FLAC__subframe_add_verbatim : {
     label$19 : {
      if (!FLAC__bitwriter_write_raw_uint32($4, HEAP32[1695] | ($3 | 0) != 0, HEAP32[1693] + (HEAP32[1692] + HEAP32[1691] | 0) | 0)) {
       break label$19
      }
      if ($3) {
       if (!FLAC__bitwriter_write_unary_unsigned($4, $3 - 1 | 0)) {
        break label$19
       }
      }
      $3 = 1;
      if (!$1) {
       break __inlined_func$FLAC__subframe_add_verbatim
      }
      $3 = 0;
      label$410 : {
       while (1) {
        if (!FLAC__bitwriter_write_raw_int32($4, HEAP32[$5 + ($3 << 2) >> 2], $2)) {
         break label$410
        }
        $3 = $3 + 1 | 0;
        if (($3 | 0) != ($1 | 0)) {
         continue
        }
        break;
       };
       $3 = 1;
       break __inlined_func$FLAC__subframe_add_verbatim;
      }
     }
     $3 = 0;
    }
    if ($3) {
     break label$1
    }
   }
   HEAP32[HEAP32[$0 >> 2] >> 2] = 7;
   $7 = 0;
  }
  return $7;
 }
 
 function FLAC__stream_encoder_set_ogg_serial_number($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $0 = HEAP32[$0 >> 2];
  if (HEAP32[$0 >> 2] == 1) {
   HEAP32[$0 + 632 >> 2] = $1;
   $0 = 1;
  } else {
   $0 = 0
  }
  return $0 | 0;
 }
 
 function FLAC__stream_encoder_set_verify($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $0 = HEAP32[$0 >> 2];
  if (HEAP32[$0 >> 2] == 1) {
   HEAP32[$0 + 4 >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_encoder_set_channels($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $0 = HEAP32[$0 >> 2];
  if (HEAP32[$0 >> 2] == 1) {
   HEAP32[$0 + 24 >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_encoder_set_bits_per_sample($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $0 = HEAP32[$0 >> 2];
  if (HEAP32[$0 >> 2] == 1) {
   HEAP32[$0 + 28 >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_encoder_set_sample_rate($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $0 = HEAP32[$0 >> 2];
  if (HEAP32[$0 >> 2] == 1) {
   HEAP32[$0 + 32 >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_encoder_set_compression_level($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0, $3 = 0, $4 = 0;
  $3 = HEAP32[$0 >> 2];
  if (HEAP32[$3 >> 2] == 1) {
   $4 = Math_imul($1 >>> 0 < 8 ? $1 : 8, 44);
   $1 = $4 + 11168 | 0;
   $2 = HEAP32[$1 + 4 >> 2];
   HEAP32[$3 + 16 >> 2] = HEAP32[$1 >> 2];
   HEAP32[$3 + 20 >> 2] = $2;
   $3 = FLAC__stream_encoder_set_apodization($0, HEAP32[$1 + 40 >> 2]);
   $2 = 0;
   $1 = 0;
   $0 = HEAP32[$0 >> 2];
   if (HEAP32[$0 >> 2] == 1) {
    $1 = $4 + 11168 | 0;
    $2 = HEAP32[$1 + 32 >> 2];
    HEAP32[$0 + 576 >> 2] = HEAP32[$1 + 28 >> 2];
    HEAP32[$0 + 580 >> 2] = $2;
    HEAP32[$0 + 568 >> 2] = HEAP32[$1 + 24 >> 2];
    HEAP32[$0 + 564 >> 2] = HEAP32[$1 + 16 >> 2];
    $2 = HEAP32[$1 + 12 >> 2];
    HEAP32[$0 + 556 >> 2] = HEAP32[$1 + 8 >> 2];
    HEAP32[$0 + 560 >> 2] = $2;
    $2 = $3 & 1;
    $1 = 1;
   }
   $2 = $1 & $2;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_encoder_set_blocksize($0, $1) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  var $2 = 0;
  $0 = HEAP32[$0 >> 2];
  if (HEAP32[$0 >> 2] == 1) {
   HEAP32[$0 + 36 >> 2] = $1;
   $2 = 1;
  }
  return $2 | 0;
 }
 
 function FLAC__stream_encoder_set_metadata($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0;
  $3 = HEAP32[$0 >> 2];
  if (HEAP32[$3 >> 2] == 1) {
   $4 = HEAP32[$3 + 600 >> 2];
   if ($4) {
    dlfree($4);
    $3 = HEAP32[$0 >> 2];
    HEAP32[$3 + 600 >> 2] = 0;
    HEAP32[$3 + 604 >> 2] = 0;
   }
   $2 = $1 ? $2 : 0;
   if ($2) {
    $3 = safe_malloc_mul_2op_p(4, $2);
    if (!$3) {
     return 0
    }
    $1 = __memcpy($3, $1, $2 << 2);
    $3 = HEAP32[$0 >> 2];
    HEAP32[$3 + 604 >> 2] = $2;
    HEAP32[$3 + 600 >> 2] = $1;
   }
   $0 = $3 + 632 | 0;
   if ($2 >>> HEAP32[1957] | 0) {
    $0 = 0
   } else {
    HEAP32[$0 + 4 >> 2] = $2;
    $0 = 1;
   }
   $0 = ($0 | 0) != 0;
  } else {
   $0 = 0
  }
  return $0 | 0;
 }
 
 function FLAC__stream_encoder_get_verify_decoder_state($0) {
  $0 = $0 | 0;
  if (!HEAP32[HEAP32[$0 >> 2] + 4 >> 2]) {
   return 9
  }
  return FLAC__stream_decoder_get_state(HEAP32[HEAP32[$0 + 4 >> 2] + 11752 >> 2]) | 0;
 }
 
 function FLAC__stream_encoder_get_verify($0) {
  $0 = $0 | 0;
  return HEAP32[HEAP32[$0 >> 2] + 4 >> 2];
 }
 
 function FLAC__stream_encoder_process($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0;
  $5 = HEAP32[$0 >> 2];
  $11 = HEAP32[$5 + 24 >> 2];
  $18 = $11 & -4;
  $19 = $11 & 3;
  $20 = $11 & -2;
  $21 = $11 & 1;
  $15 = $11 - 1 | 0;
  $12 = HEAP32[$5 + 36 >> 2];
  $22 = $12 + 1 | 0;
  $4 = HEAP32[$0 + 4 >> 2];
  label$1 : {
   while (1) {
    $3 = $22 - HEAP32[$4 + 7052 >> 2] | 0;
    $7 = $2 - $10 | 0;
    $7 = $3 >>> 0 < $7 >>> 0 ? $3 : $7;
    label$3 : {
     if (!HEAP32[$5 + 4 >> 2]) {
      $3 = $7 << 2;
      break label$3;
     }
     $3 = $7 << 2;
     label$5 : {
      if (!$11) {
       break label$5
      }
      $6 = 0;
      $5 = $20;
      if ($15) {
       while (1) {
        $8 = $4 + 11764 | 0;
        $9 = $6 << 2;
        $14 = $10 << 2;
        __memcpy(HEAP32[$8 + $9 >> 2] + (HEAP32[$4 + 11800 >> 2] << 2) | 0, $14 + HEAP32[$1 + $9 >> 2] | 0, $3);
        $9 = $9 | 4;
        __memcpy(HEAP32[$9 + $8 >> 2] + (HEAP32[$4 + 11800 >> 2] << 2) | 0, $14 + HEAP32[$1 + $9 >> 2] | 0, $3);
        $6 = $6 + 2 | 0;
        $5 = $5 - 2 | 0;
        if ($5) {
         continue
        }
        break;
       }
      }
      if (!$21) {
       break label$5
      }
      $5 = $6 << 2;
      __memcpy(HEAP32[($5 + $4 | 0) + 11764 >> 2] + (HEAP32[$4 + 11800 >> 2] << 2) | 0, HEAP32[$1 + $5 >> 2] + ($10 << 2) | 0, $3);
     }
     HEAP32[$4 + 11800 >> 2] = HEAP32[$4 + 11800 >> 2] + $7;
    }
    $5 = 0;
    $4 = 0;
    if ($11) {
     while (1) {
      $6 = $4 << 2;
      $9 = HEAP32[$6 + $1 >> 2];
      if (!$9) {
       break label$1
      }
      $8 = $6;
      $6 = HEAP32[$0 + 4 >> 2];
      __memcpy(HEAP32[($8 + $6 | 0) + 4 >> 2] + (HEAP32[$6 + 7052 >> 2] << 2) | 0, $9 + ($10 << 2) | 0, $3);
      $4 = $4 + 1 | 0;
      if (($4 | 0) != ($11 | 0)) {
       continue
      }
      break;
     }
    }
    $5 = HEAP32[$0 >> 2];
    label$10 : {
     if (HEAP32[$5 + 16 >> 2]) {
      $4 = HEAP32[$0 + 4 >> 2];
      $3 = HEAP32[$4 + 7052 >> 2];
      if ($2 >>> 0 <= $10 >>> 0 | $3 >>> 0 > $12 >>> 0) {
       break label$10
      }
      $6 = HEAP32[$4 + 40 >> 2];
      $9 = HEAP32[$4 + 36 >> 2];
      $8 = HEAP32[$1 + 4 >> 2];
      $14 = HEAP32[$1 >> 2];
      while (1) {
       $16 = $3 << 2;
       $13 = $10 << 2;
       $17 = $13 + $14 | 0;
       $13 = $8 + $13 | 0;
       HEAP32[$16 + $6 >> 2] = HEAP32[$17 >> 2] - HEAP32[$13 >> 2];
       HEAP32[$9 + $16 >> 2] = HEAP32[$13 >> 2] + HEAP32[$17 >> 2] >> 1;
       $10 = $10 + 1 | 0;
       $3 = $3 + 1 | 0;
       if ($3 >>> 0 > $12 >>> 0) {
        break label$10
       }
       if ($2 >>> 0 > $10 >>> 0) {
        continue
       }
       break;
      };
      break label$10;
     }
     $10 = $7 + $10 | 0;
     $4 = HEAP32[$0 + 4 >> 2];
    }
    $3 = HEAP32[$4 + 7052 >> 2] + $7 | 0;
    HEAP32[$4 + 7052 >> 2] = $3;
    if ($3 >>> 0 > $12 >>> 0) {
     $5 = 0;
     if (!process_frame_($0, 0, 0)) {
      break label$1
     }
     label$14 : {
      if (!$11) {
       break label$14
      }
      $9 = HEAP32[$0 + 4 >> 2];
      $4 = 0;
      $5 = $18;
      if ($15 >>> 0 >= 3) {
       while (1) {
        $3 = $9 + 4 | 0;
        $7 = $4 << 2;
        $6 = HEAP32[$3 + $7 >> 2];
        $8 = $6;
        $6 = $12 << 2;
        HEAP32[$8 >> 2] = HEAP32[$8 + $6 >> 2];
        $8 = HEAP32[$3 + ($7 | 4) >> 2];
        HEAP32[$8 >> 2] = HEAP32[$6 + $8 >> 2];
        $8 = HEAP32[$3 + ($7 | 8) >> 2];
        HEAP32[$8 >> 2] = HEAP32[$6 + $8 >> 2];
        $3 = HEAP32[$3 + ($7 | 12) >> 2];
        HEAP32[$3 >> 2] = HEAP32[$3 + $6 >> 2];
        $4 = $4 + 4 | 0;
        $5 = $5 - 4 | 0;
        if ($5) {
         continue
        }
        break;
       }
      }
      $3 = $19;
      if (!$3) {
       break label$14
      }
      while (1) {
       $5 = HEAP32[($9 + ($4 << 2) | 0) + 4 >> 2];
       HEAP32[$5 >> 2] = HEAP32[$5 + ($12 << 2) >> 2];
       $4 = $4 + 1 | 0;
       $3 = $3 - 1 | 0;
       if ($3) {
        continue
       }
       break;
      };
     }
     $4 = HEAP32[$0 + 4 >> 2];
     $5 = HEAP32[$0 >> 2];
     if (HEAP32[$5 + 16 >> 2]) {
      $3 = HEAP32[$4 + 36 >> 2];
      $6 = $3;
      $3 = $12 << 2;
      HEAP32[$6 >> 2] = HEAP32[$6 + $3 >> 2];
      $7 = HEAP32[$4 + 40 >> 2];
      HEAP32[$7 >> 2] = HEAP32[$3 + $7 >> 2];
     }
     HEAP32[$4 + 7052 >> 2] = 1;
    }
    if ($2 >>> 0 > $10 >>> 0) {
     continue
    }
    break;
   };
   $5 = 1;
  }
  return $5 | 0;
 }
 
 function FLAC__stream_encoder_process_interleaved($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0;
  $3 = HEAP32[$0 >> 2];
  $16 = HEAP32[$3 + 36 >> 2];
  $19 = $16 + 1 | 0;
  label$1 : {
   label$2 : {
    $14 = HEAP32[$3 + 24 >> 2];
    if (!(!HEAP32[$3 + 16 >> 2] | ($14 | 0) != 2)) {
     while (1) {
      $8 = HEAP32[$0 + 4 >> 2];
      if (HEAP32[$3 + 4 >> 2]) {
       $9 = HEAP32[$8 + 11800 >> 2];
       $10 = $19 - HEAP32[$8 + 7052 >> 2] | 0;
       $7 = $2 - $4 | 0;
       $7 = $10 >>> 0 < $7 >>> 0 ? $10 : $7;
       if ($7) {
        $3 = $4 << 1;
        $14 = HEAP32[$8 + 11768 >> 2];
        $13 = HEAP32[$8 + 11764 >> 2];
        $10 = 0;
        while (1) {
         $5 = $9 << 2;
         $11 = $3 << 2;
         HEAP32[$5 + $13 >> 2] = HEAP32[$11 + $1 >> 2];
         HEAP32[$5 + $14 >> 2] = HEAP32[($11 | 4) + $1 >> 2];
         $9 = $9 + 1 | 0;
         $3 = $3 + 2 | 0;
         $10 = $10 + 1 | 0;
         if (($7 | 0) != ($10 | 0)) {
          continue
         }
         break;
        };
       }
       HEAP32[$8 + 11800 >> 2] = $9;
      }
      $9 = $2 >>> 0 > $4 >>> 0;
      $3 = HEAP32[$8 + 7052 >> 2];
      label$8 : {
       if ($16 >>> 0 < $3 >>> 0 | $2 >>> 0 <= $4 >>> 0) {
        break label$8
       }
       $14 = HEAP32[$8 + 40 >> 2];
       $13 = HEAP32[$8 + 8 >> 2];
       $5 = HEAP32[$8 + 36 >> 2];
       $11 = HEAP32[$8 + 4 >> 2];
       while (1) {
        $10 = $3 << 2;
        $9 = ($6 << 2) + $1 | 0;
        $7 = HEAP32[$9 >> 2];
        HEAP32[$10 + $11 >> 2] = $7;
        $9 = HEAP32[$9 + 4 >> 2];
        HEAP32[$10 + $13 >> 2] = $9;
        HEAP32[$10 + $14 >> 2] = $7 - $9;
        HEAP32[$5 + $10 >> 2] = $9 + $7 >> 1;
        $6 = $6 + 2 | 0;
        $4 = $4 + 1 | 0;
        $9 = $4 >>> 0 < $2 >>> 0;
        $3 = $3 + 1 | 0;
        if ($16 >>> 0 < $3 >>> 0) {
         break label$8
        }
        if ($2 >>> 0 > $4 >>> 0) {
         continue
        }
        break;
       };
      }
      HEAP32[$8 + 7052 >> 2] = $3;
      if ($3 >>> 0 > $16 >>> 0) {
       $12 = 0;
       if (!process_frame_($0, 0, 0)) {
        break label$1
       }
       $8 = HEAP32[$0 + 4 >> 2];
       $10 = HEAP32[$8 + 4 >> 2];
       $7 = $10;
       $10 = $16 << 2;
       HEAP32[$7 >> 2] = HEAP32[$7 + $10 >> 2];
       $7 = HEAP32[$8 + 8 >> 2];
       HEAP32[$7 >> 2] = HEAP32[$10 + $7 >> 2];
       $7 = HEAP32[$8 + 36 >> 2];
       HEAP32[$7 >> 2] = HEAP32[$10 + $7 >> 2];
       $7 = HEAP32[$8 + 40 >> 2];
       HEAP32[$7 >> 2] = HEAP32[$10 + $7 >> 2];
       HEAP32[$8 + 7052 >> 2] = 1;
      }
      if (!$9) {
       break label$2
      }
      $3 = HEAP32[$0 >> 2];
      continue;
     }
    }
    $10 = $14 & -4;
    $7 = $14 & 3;
    $8 = $14 & -2;
    $20 = $14 & 1;
    $18 = $14 - 1 | 0;
    while (1) {
     $5 = HEAP32[$0 + 4 >> 2];
     if (HEAP32[$3 + 4 >> 2]) {
      $11 = HEAP32[$5 + 11800 >> 2];
      $4 = $19 - HEAP32[$5 + 7052 >> 2] | 0;
      $6 = $2 - $13 | 0;
      $17 = $4 >>> 0 < $6 >>> 0 ? $4 : $6;
      label$13 : {
       if (!$17) {
        break label$13
       }
       if ($14) {
        $3 = Math_imul($13, $14);
        $12 = 0;
        while (1) {
         $4 = 0;
         $6 = $8;
         if ($18) {
          while (1) {
           $21 = $11 << 2;
           $15 = $5 + 11764 | 0;
           $22 = $4 << 2;
           $23 = ($3 << 2) + $1 | 0;
           HEAP32[$21 + HEAP32[$15 + $22 >> 2] >> 2] = HEAP32[$23 >> 2];
           HEAP32[$21 + HEAP32[$15 + ($22 | 4) >> 2] >> 2] = HEAP32[$23 + 4 >> 2];
           $4 = $4 + 2 | 0;
           $3 = $3 + 2 | 0;
           $6 = $6 - 2 | 0;
           if ($6) {
            continue
           }
           break;
          }
         }
         if ($20) {
          HEAP32[HEAP32[($5 + ($4 << 2) | 0) + 11764 >> 2] + ($11 << 2) >> 2] = HEAP32[($3 << 2) + $1 >> 2];
          $3 = $3 + 1 | 0;
         }
         $11 = $11 + 1 | 0;
         $12 = $12 + 1 | 0;
         if (($12 | 0) != ($17 | 0)) {
          continue
         }
         break;
        };
        break label$13;
       }
       $11 = $11 + $17 | 0;
      }
      HEAP32[$5 + 11800 >> 2] = $11;
     }
     $11 = $2 >>> 0 > $13 >>> 0;
     $6 = HEAP32[$5 + 7052 >> 2];
     label$19 : {
      if ($2 >>> 0 <= $13 >>> 0 | $6 >>> 0 > $16 >>> 0) {
       break label$19
      }
      if ($14) {
       while (1) {
        $3 = 0;
        $4 = $8;
        if ($18) {
         while (1) {
          $12 = $6 << 2;
          $11 = $5 + 4 | 0;
          $17 = $3 << 2;
          $15 = ($9 << 2) + $1 | 0;
          HEAP32[$12 + HEAP32[$11 + $17 >> 2] >> 2] = HEAP32[$15 >> 2];
          HEAP32[$12 + HEAP32[$11 + ($17 | 4) >> 2] >> 2] = HEAP32[$15 + 4 >> 2];
          $3 = $3 + 2 | 0;
          $9 = $9 + 2 | 0;
          $4 = $4 - 2 | 0;
          if ($4) {
           continue
          }
          break;
         }
        }
        if ($20) {
         HEAP32[HEAP32[($5 + ($3 << 2) | 0) + 4 >> 2] + ($6 << 2) >> 2] = HEAP32[($9 << 2) + $1 >> 2];
         $9 = $9 + 1 | 0;
        }
        $13 = $13 + 1 | 0;
        $11 = $13 >>> 0 < $2 >>> 0;
        $6 = $6 + 1 | 0;
        if ($6 >>> 0 > $16 >>> 0) {
         break label$19
        }
        if ($2 >>> 0 > $13 >>> 0) {
         continue
        }
        break label$19;
       }
      }
      while (1) {
       $13 = $13 + 1 | 0;
       $11 = $13 >>> 0 < $2 >>> 0;
       $6 = $6 + 1 | 0;
       if ($6 >>> 0 > $16 >>> 0) {
        break label$19
       }
       if ($2 >>> 0 > $13 >>> 0) {
        continue
       }
       break;
      };
     }
     HEAP32[$5 + 7052 >> 2] = $6;
     if ($6 >>> 0 > $16 >>> 0) {
      $12 = 0;
      if (!process_frame_($0, 0, 0)) {
       break label$1
      }
      $6 = HEAP32[$0 + 4 >> 2];
      label$27 : {
       if (!$14) {
        break label$27
       }
       $3 = 0;
       $4 = $10;
       if ($18 >>> 0 >= 3) {
        while (1) {
         $5 = $6 + 4 | 0;
         $17 = $3 << 2;
         $12 = HEAP32[$5 + $17 >> 2];
         $15 = $12;
         $12 = $16 << 2;
         HEAP32[$15 >> 2] = HEAP32[$15 + $12 >> 2];
         $15 = HEAP32[$5 + ($17 | 4) >> 2];
         HEAP32[$15 >> 2] = HEAP32[$12 + $15 >> 2];
         $15 = HEAP32[$5 + ($17 | 8) >> 2];
         HEAP32[$15 >> 2] = HEAP32[$12 + $15 >> 2];
         $5 = HEAP32[$5 + ($17 | 12) >> 2];
         HEAP32[$5 >> 2] = HEAP32[$5 + $12 >> 2];
         $3 = $3 + 4 | 0;
         $4 = $4 - 4 | 0;
         if ($4) {
          continue
         }
         break;
        }
       }
       $4 = $7;
       if (!$4) {
        break label$27
       }
       while (1) {
        $5 = HEAP32[($6 + ($3 << 2) | 0) + 4 >> 2];
        HEAP32[$5 >> 2] = HEAP32[$5 + ($16 << 2) >> 2];
        $3 = $3 + 1 | 0;
        $4 = $4 - 1 | 0;
        if ($4) {
         continue
        }
        break;
       };
      }
      HEAP32[$6 + 7052 >> 2] = 1;
     }
     if (!$11) {
      break label$2
     }
     $3 = HEAP32[$0 >> 2];
     continue;
    };
   }
   $12 = 1;
  }
  return $12 | 0;
 }
 
 function find_best_partition_order_($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12) {
  var $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0;
  $24 = $1;
  $23 = $2;
  $16 = $4;
  $21 = $5;
  $22 = $8;
  $29 = $4 + $5 | 0;
  $17 = $29;
  $15 = $5;
  while (1) {
   $14 = $9;
   if ($9) {
    $9 = $14 - 1 | 0;
    if ($17 >>> $14 >>> 0 <= $15 >>> 0) {
     continue
    }
   }
   break;
  };
  $15 = $14;
  $25 = $8 >>> 0 < $15 >>> 0 ? $22 : $15;
  FUNCTION_TABLE[HEAP32[$0 + 7220 >> 2]]($24, $23, $16, $21, $25, $15, $10);
  label$1 : {
   if (!$11) {
    break label$1
   }
   $10 = 0;
   $8 = 0;
   if (($15 | 0) >= 0) {
    $22 = $29 >>> $15 | 0;
    $8 = 1 << $15;
    while (1) {
     $27 = ($13 << 2) + $3 | 0;
     label$4 : {
      label$5 : {
       $18 = $13 ? 0 : $5;
       $17 = $22 - $18 | 0;
       if (!$17) {
        break label$5
       }
       $14 = $17 & 3;
       $16 = 0;
       $9 = $20;
       if ($22 + ($18 ^ -1) >>> 0 >= 3) {
        $17 = $17 & -4;
        while (1) {
         $21 = ($9 << 2) + $1 | 0;
         $19 = HEAP32[$21 + 12 >> 2];
         $24 = $19 >> 31 ^ $19;
         $19 = HEAP32[$21 >> 2];
         $23 = $16 | $19 >> 31 ^ $19;
         $16 = HEAP32[$21 + 4 >> 2];
         $23 = $23 | $16 >> 31 ^ $16;
         $16 = HEAP32[$21 + 8 >> 2];
         $16 = $24 | ($23 | $16 >> 31 ^ $16);
         $9 = $9 + 4 | 0;
         $17 = $17 - 4 | 0;
         if ($17) {
          continue
         }
         break;
        };
       }
       if ($14) {
        while (1) {
         $17 = HEAP32[($9 << 2) + $1 >> 2];
         $16 = $16 | $17 >> 31 ^ $17;
         $9 = $9 + 1 | 0;
         $14 = $14 - 1 | 0;
         if ($14) {
          continue
         }
         break;
        }
       }
       $20 = ($20 + $22 | 0) - $18 | 0;
       if (!$16) {
        break label$5
       }
       $9 = (Math_clz32($16) ^ 31) + 2 | 0;
       break label$4;
      }
      $9 = 1;
     }
     HEAP32[$27 >> 2] = $9;
     $13 = $13 + 1 | 0;
     if (($13 | 0) != ($8 | 0)) {
      continue
     }
     break;
    };
   }
   if (($15 | 0) <= ($25 | 0)) {
    break label$1
   }
   $14 = $15;
   while (1) {
    $14 = $14 - 1 | 0;
    $9 = 0;
    while (1) {
     $1 = ($10 << 2) + $3 | 0;
     $13 = HEAP32[$1 >> 2];
     $1 = HEAP32[$1 + 4 >> 2];
     HEAP32[($8 << 2) + $3 >> 2] = $1 >>> 0 < $13 >>> 0 ? $13 : $1;
     $8 = $8 + 1 | 0;
     $10 = $10 + 2 | 0;
     $9 = $9 + 1 | 0;
     if (!($9 >>> $14 | 0)) {
      continue
     }
     break;
    };
    if (($14 | 0) > ($25 | 0)) {
     continue
    }
    break;
   };
  }
  label$12 : {
   if (($15 | 0) >= ($25 | 0)) {
    $33 = HEAP32[1684];
    $24 = $33 + (Math_imul($6 + 1 | 0, $4) - ($4 >>> 1 | 0) | 0) | 0;
    $23 = $7 - 1 | 0;
    $34 = HEAP32[1686] + HEAP32[1685] | 0;
    $22 = HEAP32[1683] + HEAP32[1682] | 0;
    $35 = $6 - 1 | 0;
    while (1) {
     label$14 : {
      $36 = !$30;
      $1 = Math_imul($36, 12) + $0 | 0;
      $8 = $1 + 11724 | 0;
      FLAC__format_entropy_coding_method_partitioned_rice_contents_ensure_size($8, $15 >>> 0 > 6 ? $15 : 6);
      $37 = ($31 << 2) + $3 | 0;
      $32 = ($31 << 3) + $2 | 0;
      $38 = HEAP32[$1 + 11728 >> 2];
      $39 = HEAP32[$8 >> 2];
      label$16 : {
       if ($15) {
        $40 = $29 >>> $15 | 0;
        $19 = 0;
        $1 = 0;
        $17 = $22;
        while (1) {
         if (!$19 & $5 >>> 0 >= $40 >>> 0) {
          break label$14
         }
         $14 = $40 - ($19 ? 0 : $5) | 0;
         label$20 : {
          label$21 : {
           label$22 : {
            $8 = $32 + ($19 << 3) | 0;
            $18 = HEAP32[$8 + 4 >> 2];
            $20 = HEAP32[$8 >> 2];
            if (!(!$18 & $20 >>> 0 > 268435456 | ($18 | 0) != 0)) {
             $8 = 0;
             $9 = $20;
             $10 = $14;
             if ($9 >>> 0 > $10 << 3 >>> 0) {
              break label$22
             }
             break label$21;
            }
            $9 = $14;
            $16 = 0;
            $8 = 0;
            label$24 : {
             if (!(!$20 & ($18 | 0) == 16777216 | $18 >>> 0 < 16777216)) {
              $13 = $9;
              $10 = 0;
              break label$24;
             }
             $13 = $9;
             $10 = 0;
             $21 = $9 >>> 25 | 0;
             if (($21 | 0) == ($18 | 0) & $9 << 7 >>> 0 >= $20 >>> 0 | $18 >>> 0 < $21 >>> 0) {
              break label$24
             }
             while (1) {
              $8 = $8 + 8 | 0;
              $21 = $9;
              $27 = $16 << 15 | $9 >>> 17;
              $10 = $16 << 8 | $9 >>> 24;
              $13 = $9 << 8;
              $9 = $13;
              $16 = $10;
              if (($18 | 0) == ($27 | 0) & $21 << 15 >>> 0 < $20 >>> 0 | $18 >>> 0 > $27 >>> 0) {
               continue
              }
              break;
             };
            }
            if (($10 | 0) == ($18 | 0) & $13 >>> 0 >= $20 >>> 0 | $10 >>> 0 > $18 >>> 0) {
             break label$20
            }
            while (1) {
             $8 = $8 + 1 | 0;
             $10 = $10 << 1 | $13 >>> 31;
             $13 = $13 << 1;
             if (($18 | 0) == ($10 | 0) & $13 >>> 0 < $20 >>> 0 | $10 >>> 0 < $18 >>> 0) {
              continue
             }
             break;
            };
            break label$20;
           }
           while (1) {
            $8 = $8 + 4 | 0;
            $13 = $10 << 7;
            $10 = $10 << 4;
            if ($9 >>> 0 > $13 >>> 0) {
             continue
            }
            break;
           };
          }
          if ($9 >>> 0 <= $10 >>> 0) {
           break label$20
          }
          while (1) {
           $8 = $8 + 1 | 0;
           $10 = $10 << 1;
           if ($9 >>> 0 > $10 >>> 0) {
            continue
           }
           break;
          };
         }
         $10 = $1;
         $1 = $7 >>> 0 > $8 >>> 0 ? $8 : $23;
         $9 = $1 - 1 | 0;
         $8 = $9 & 31;
         $8 = (($33 - ($14 >>> 1 | 0) | 0) + Math_imul($14, $1 + 1 | 0) | 0) + ($1 ? (($9 & 63) >>> 0 >= 32 ? $18 >>> $8 | 0 : ((1 << $8) - 1 & $18) << 32 - $8 | $20 >>> $8) : $20 << 1) | 0;
         $1 = ($8 | 0) == -1 ? $10 : $1;
         if ($11) {
          $10 = $19 << 2;
          $13 = HEAP32[$10 + $37 >> 2];
          $14 = Math_imul($13, $14) + $34 | 0;
          $9 = $14 >>> 0 > $8 >>> 0;
          HEAP32[$10 + $38 >> 2] = $9 ? 0 : $13;
          $8 = $9 ? $8 : $14;
          $1 = $9 ? $1 : 0;
         }
         HEAP32[$39 + ($19 << 2) >> 2] = $1;
         $17 = $8 + $17 | 0;
         $19 = $19 + 1 | 0;
         if (!($19 >>> $15 | 0)) {
          continue
         }
         break;
        };
        break label$16;
       }
       $8 = HEAP32[$32 + 4 >> 2];
       $1 = $35 & 31;
       $10 = $8 >>> $1 | 0;
       $9 = ((1 << $1) - 1 & $8) << 32 - $1;
       $8 = HEAP32[$32 >> 2];
       $8 = ($6 ? (($35 & 63) >>> 0 >= 32 ? $10 : $9 | $8 >>> $1) : $8 << 1) + $24 | 0;
       $10 = ($8 | 0) == -1 ? 0 : $6;
       if ($11) {
        $9 = HEAP32[$37 >> 2];
        $13 = Math_imul($9, $4) + $34 | 0;
        $1 = $13 >>> 0 > $8 >>> 0;
        HEAP32[$38 >> 2] = $1 ? 0 : $9;
        $10 = $1 ? $10 : 0;
        $8 = $1 ? $8 : $13;
       }
       HEAP32[$39 >> 2] = $10;
       $17 = $8 + $22 | 0;
      }
      $1 = !$28 | $17 >>> 0 < $28 >>> 0;
      $26 = $1 ? $15 : $26;
      $30 = $1 ? $36 : $30;
      $28 = $1 ? $17 : $28;
      $31 = (1 << $15) + $31 | 0;
      $1 = ($15 | 0) > ($25 | 0);
      $15 = $15 - 1 | 0;
      if ($1) {
       continue
      }
     }
     break;
    };
    HEAP32[$12 + 4 >> 2] = $26;
    $2 = $26 >>> 0 > 6 ? $26 : 6;
    break label$12;
   }
   HEAP32[$12 + 4 >> 2] = 0;
   $2 = 6;
  }
  $1 = HEAP32[$12 + 8 >> 2];
  FLAC__format_entropy_coding_method_partitioned_rice_contents_ensure_size($1, $2);
  $0 = Math_imul($30, 12) + $0 | 0;
  $2 = 1 << $26;
  $3 = $2 << 2;
  __memcpy(HEAP32[$1 >> 2], HEAP32[$0 + 11724 >> 2], $3);
  if ($11) {
   __memcpy(HEAP32[$1 + 4 >> 2], HEAP32[$0 + 11728 >> 2], $3)
  }
  $0 = HEAP32[1687];
  $1 = HEAP32[$1 >> 2];
  $8 = 0;
  label$33 : {
   while (1) {
    if (HEAPU32[$1 + ($8 << 2) >> 2] < $0 >>> 0) {
     $8 = $8 + 1 | 0;
     if (($8 | 0) != ($2 | 0)) {
      continue
     }
     break label$33;
    }
    break;
   };
   HEAP32[$12 >> 2] = 1;
  }
  return $28;
 }
 
 function legalstub$FLAC__stream_encoder_set_total_samples_estimate($0, $1, $2) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0;
  $5 = HEAP32[$0 >> 2];
  if (HEAP32[$5 >> 2] == 1) {
   $0 = $2;
   $6 = $5;
   $7 = $1;
   $4 = HEAP32[1640];
   $3 = $4 & 31;
   if (($4 & 63) >>> 0 >= 32) {
    $3 = -1 << $3;
    $4 = 0;
   } else {
    $4 = -1 << $3;
    $3 = $4 | (1 << $3) - 1 & -1 >>> 32 - $3;
   }
   $4 = $4 ^ -1;
   $3 = $3 ^ -1;
   $1 = ($2 | 0) == ($3 | 0) & $1 >>> 0 < $4 >>> 0 | $2 >>> 0 < $3 >>> 0;
   HEAP32[$6 + 592 >> 2] = $1 ? $7 : $4;
   HEAP32[$5 + 596 >> 2] = $1 ? $0 : $3;
   $0 = 1;
  } else {
   $0 = 0
  }
  return $0 | 0;
 }
 
 function legalstub$dynCall_jiji($0, $1, $2, $3, $4) {
  $0 = $0 | 0;
  $1 = $1 | 0;
  $2 = $2 | 0;
  $3 = $3 | 0;
  $4 = $4 | 0;
  $0 = FUNCTION_TABLE[$0 | 0]($1, $2, $3, $4) | 0;
  setTempRet0(i64toi32_i32$HIGH_BITS | 0);
  return $0 | 0;
 }
 
 function _ZN17compiler_builtins3int4udiv10divmod_u6417h6026910b5ed08e40E($0, $1, $2) {
  var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $10 = 0, $11 = 0;
  label$1 : {
   label$2 : {
    label$3 : {
     label$4 : {
      label$5 : {
       label$6 : {
        label$7 : {
         label$9 : {
          label$11 : {
           $3 = $1;
           if ($3) {
            $4 = $2;
            if (!$4) {
             break label$11
            }
            break label$9;
           }
           $1 = $0;
           $0 = ($0 >>> 0) / ($2 >>> 0) | 0;
           __wasm_intrinsics_temp_i64 = $1 - Math_imul($0, $2) | 0;
           __wasm_intrinsics_temp_i64$hi = 0;
           i64toi32_i32$HIGH_BITS = 0;
           return $0;
          }
          if (!$0) {
           break label$7
          }
          break label$6;
         }
         $6 = $4 - 1 | 0;
         if (!($6 & $4)) {
          break label$5
         }
         $6 = (Math_clz32($4) + 33 | 0) - Math_clz32($3) | 0;
         $8 = 0 - $6 | 0;
         break label$3;
        }
        __wasm_intrinsics_temp_i64 = 0;
        $0 = ($3 >>> 0) / 0 | 0;
        __wasm_intrinsics_temp_i64$hi = $3 - Math_imul($0, 0) | 0;
        i64toi32_i32$HIGH_BITS = 0;
        return $0;
       }
       $3 = 32 - Math_clz32($3) | 0;
       if ($3 >>> 0 < 31) {
        break label$4
       }
       break label$2;
      }
      __wasm_intrinsics_temp_i64 = $0 & $6;
      __wasm_intrinsics_temp_i64$hi = 0;
      if (($4 | 0) == 1) {
       break label$1
      }
      $3 = __wasm_ctz_i32($4);
      $2 = $3 & 31;
      if (($3 & 63) >>> 0 >= 32) {
       $4 = 0;
       $0 = $1 >>> $2 | 0;
      } else {
       $4 = $1 >>> $2 | 0;
       $0 = ((1 << $2) - 1 & $1) << 32 - $2 | $0 >>> $2;
      }
      i64toi32_i32$HIGH_BITS = $4;
      return $0;
     }
     $6 = $3 + 1 | 0;
     $8 = 63 - $3 | 0;
    }
    $3 = $1;
    $4 = $6 & 63;
    $5 = $4 & 31;
    if ($4 >>> 0 >= 32) {
     $4 = 0;
     $5 = $3 >>> $5 | 0;
    } else {
     $4 = $3 >>> $5 | 0;
     $5 = ((1 << $5) - 1 & $3) << 32 - $5 | $0 >>> $5;
    }
    $8 = $8 & 63;
    $3 = $8 & 31;
    if ($8 >>> 0 >= 32) {
     $1 = $0 << $3;
     $0 = 0;
    } else {
     $1 = (1 << $3) - 1 & $0 >>> 32 - $3 | $1 << $3;
     $0 = $0 << $3;
    }
    if ($6) {
     $3 = $2 - 1 | 0;
     $8 = ($3 | 0) != -1 ? 0 : -1;
     while (1) {
      $7 = $5 << 1 | $1 >>> 31;
      $9 = $7;
      $4 = $4 << 1 | $5 >>> 31;
      $7 = $8 - ($4 + ($3 >>> 0 < $7 >>> 0) | 0) >> 31;
      $10 = $2 & $7;
      $5 = $9 - $10 | 0;
      $4 = $4 - ($9 >>> 0 < $10 >>> 0) | 0;
      $1 = $1 << 1 | $0 >>> 31;
      $0 = $11 | $0 << 1;
      $7 = $7 & 1;
      $11 = $7;
      $6 = $6 - 1 | 0;
      if ($6) {
       continue
      }
      break;
     };
    }
    __wasm_intrinsics_temp_i64 = $5;
    __wasm_intrinsics_temp_i64$hi = $4;
    i64toi32_i32$HIGH_BITS = $1 << 1 | $0 >>> 31;
    return $7 | $0 << 1;
   }
   __wasm_intrinsics_temp_i64 = $0;
   __wasm_intrinsics_temp_i64$hi = $1;
   $0 = 0;
   $1 = 0;
  }
  i64toi32_i32$HIGH_BITS = $1;
  return $0;
 }
 
 function __wasm_ctz_i32($0) {
  if ($0) {
   return 31 - Math_clz32($0 - 1 ^ $0) | 0
  }
  return 32;
 }
 
 function __wasm_i64_mul($0, $1, $2, $3) {
  var $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
  $4 = $2 >>> 16 | 0;
  $5 = $0 >>> 16 | 0;
  $9 = Math_imul($4, $5);
  $6 = $2 & 65535;
  $7 = $0 & 65535;
  $8 = Math_imul($6, $7);
  $5 = ($8 >>> 16 | 0) + Math_imul($5, $6) | 0;
  $4 = ($5 & 65535) + Math_imul($4, $7) | 0;
  i64toi32_i32$HIGH_BITS = (Math_imul($1, $2) + $9 | 0) + Math_imul($0, $3) + ($5 >>> 16) + ($4 >>> 16) | 0;
  return $8 & 65535 | $4 << 16;
 }
 
 function __wasm_i64_udiv($0, $1, $2) {
  return _ZN17compiler_builtins3int4udiv10divmod_u6417h6026910b5ed08e40E($0, $1, $2);
 }
 
 function __wasm_i64_urem($0, $1) {
  _ZN17compiler_builtins3int4udiv10divmod_u6417h6026910b5ed08e40E($0, $1, 588);
  i64toi32_i32$HIGH_BITS = __wasm_intrinsics_temp_i64$hi;
  return __wasm_intrinsics_temp_i64;
 }
 
 function __wasm_rotl_i32($0, $1) {
  var $2 = 0, $3 = 0;
  $2 = $1 & 31;
  $3 = (-1 >>> $2 & $0) << $2;
  $2 = $0;
  $0 = 0 - $1 & 31;
  return $3 | ($2 & -1 << $0) >>> $0;
 }
 
 // EMSCRIPTEN_END_FUNCS
;
 bufferView = HEAPU8;
 initActiveSegments(env);
 var FUNCTION_TABLE = Table([null, seekpoint_compare_, __stdio_close, __stdio_read, __stdio_seek, FLAC__lpc_restore_signal, FLAC__lpc_restore_signal_wide, read_callback_, read_callback_proxy_, __emscripten_stdout_close, __stdio_write, __emscripten_stdout_seek, FLAC__lpc_compute_residual_from_qlp_coefficients, FLAC__lpc_compute_residual_from_qlp_coefficients_wide, FLAC__fixed_compute_best_predictor_wide, FLAC__fixed_compute_best_predictor, precompute_partition_info_sums_, FLAC__lpc_compute_autocorrelation, verify_read_callback_, verify_write_callback_, verify_metadata_callback_, verify_error_callback_]);
 function __wasm_memory_size() {
  return buffer.byteLength / 65536 | 0;
 }
 
 function __wasm_memory_grow(pagesToAdd) {
  pagesToAdd = pagesToAdd | 0;
  var oldPages = __wasm_memory_size() | 0;
  var newPages = oldPages + pagesToAdd | 0;
  if ((oldPages < newPages) && (newPages < 65536)) {
   var newBuffer = new ArrayBuffer(Math_imul(newPages, 65536));
   var newHEAP8 = new Int8Array(newBuffer);
   newHEAP8.set(HEAP8);
   HEAP8 = new Int8Array(newBuffer);
   HEAP16 = new Int16Array(newBuffer);
   HEAP32 = new Int32Array(newBuffer);
   HEAPU8 = new Uint8Array(newBuffer);
   HEAPU16 = new Uint16Array(newBuffer);
   HEAPU32 = new Uint32Array(newBuffer);
   HEAPF32 = new Float32Array(newBuffer);
   HEAPF64 = new Float64Array(newBuffer);
   buffer = newBuffer;
   memory.buffer = buffer;
   bufferView = HEAPU8;
  }
  return oldPages;
 }
 
 return {
  "__wasm_call_ctors": __wasm_call_ctors, 
  "FLAC__stream_decoder_new": FLAC__stream_decoder_new, 
  "FLAC__stream_decoder_delete": FLAC__stream_decoder_delete, 
  "FLAC__stream_decoder_finish": FLAC__stream_decoder_finish, 
  "FLAC__stream_decoder_init_stream": FLAC__stream_decoder_init_stream, 
  "FLAC__stream_decoder_reset": FLAC__stream_decoder_reset, 
  "FLAC__stream_decoder_init_ogg_stream": FLAC__stream_decoder_init_ogg_stream, 
  "FLAC__stream_decoder_set_ogg_serial_number": FLAC__stream_decoder_set_ogg_serial_number, 
  "FLAC__stream_decoder_set_md5_checking": FLAC__stream_decoder_set_md5_checking, 
  "FLAC__stream_decoder_set_metadata_respond": FLAC__stream_decoder_set_metadata_respond, 
  "FLAC__stream_decoder_set_metadata_respond_application": FLAC__stream_decoder_set_metadata_respond_application, 
  "FLAC__stream_decoder_set_metadata_respond_all": FLAC__stream_decoder_set_metadata_respond_all, 
  "FLAC__stream_decoder_set_metadata_ignore": FLAC__stream_decoder_set_metadata_ignore, 
  "FLAC__stream_decoder_set_metadata_ignore_application": FLAC__stream_decoder_set_metadata_ignore_application, 
  "FLAC__stream_decoder_set_metadata_ignore_all": FLAC__stream_decoder_set_metadata_ignore_all, 
  "FLAC__stream_decoder_get_state": FLAC__stream_decoder_get_state, 
  "FLAC__stream_decoder_get_md5_checking": FLAC__stream_decoder_get_md5_checking, 
  "FLAC__stream_decoder_process_single": FLAC__stream_decoder_process_single, 
  "FLAC__stream_decoder_process_until_end_of_metadata": FLAC__stream_decoder_process_until_end_of_metadata, 
  "FLAC__stream_decoder_process_until_end_of_stream": FLAC__stream_decoder_process_until_end_of_stream, 
  "FLAC__stream_encoder_new": FLAC__stream_encoder_new, 
  "FLAC__stream_encoder_delete": FLAC__stream_encoder_delete, 
  "FLAC__stream_encoder_finish": FLAC__stream_encoder_finish, 
  "FLAC__stream_encoder_init_stream": FLAC__stream_encoder_init_stream, 
  "FLAC__stream_encoder_init_ogg_stream": FLAC__stream_encoder_init_ogg_stream, 
  "FLAC__stream_encoder_set_ogg_serial_number": FLAC__stream_encoder_set_ogg_serial_number, 
  "FLAC__stream_encoder_set_verify": FLAC__stream_encoder_set_verify, 
  "FLAC__stream_encoder_set_channels": FLAC__stream_encoder_set_channels, 
  "FLAC__stream_encoder_set_bits_per_sample": FLAC__stream_encoder_set_bits_per_sample, 
  "FLAC__stream_encoder_set_sample_rate": FLAC__stream_encoder_set_sample_rate, 
  "FLAC__stream_encoder_set_compression_level": FLAC__stream_encoder_set_compression_level, 
  "FLAC__stream_encoder_set_blocksize": FLAC__stream_encoder_set_blocksize, 
  "FLAC__stream_encoder_set_total_samples_estimate": legalstub$FLAC__stream_encoder_set_total_samples_estimate, 
  "FLAC__stream_encoder_set_metadata": FLAC__stream_encoder_set_metadata, 
  "FLAC__stream_encoder_get_state": FLAC__stream_decoder_get_state, 
  "FLAC__stream_encoder_get_verify_decoder_state": FLAC__stream_encoder_get_verify_decoder_state, 
  "FLAC__stream_encoder_get_verify": FLAC__stream_encoder_get_verify, 
  "FLAC__stream_encoder_process": FLAC__stream_encoder_process, 
  "FLAC__stream_encoder_process_interleaved": FLAC__stream_encoder_process_interleaved, 
  "__errno_location": __errno_location, 
  "stackSave": stackSave, 
  "stackRestore": stackRestore, 
  "stackAlloc": stackAlloc, 
  "__indirect_function_table": FUNCTION_TABLE, 
  "dynCall_jiji": legalstub$dynCall_jiji
 };
}

  return asmFunc(asmLibraryArg);
}

)(asmLibraryArg);
  },

  instantiate: /** @suppress{checkTypes} */ function(binary, info) {
    return {
      then: function(ok) {
        var module = new WebAssembly.Module(binary);
        ok({
          'instance': new WebAssembly.Instance(module)
        });
      }
    };
  },

  RuntimeError: Error
};

// We don't need to actually download a wasm binary, mark it as present but empty.
wasmBinary = [];

// end include: wasm2js.js
if (typeof WebAssembly !== 'object') {
  abort('no native wasm support detected');
}

// include: runtime_safe_heap.js


// In MINIMAL_RUNTIME, setValue() and getValue() are only available when building with safe heap enabled, for heap safety checking.
// In traditional runtime, setValue() and getValue() are always available (although their use is highly discouraged due to perf penalties)

/** @param {number} ptr
    @param {number} value
    @param {string} type
    @param {number|boolean=} noSafe */
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch (type) {
      case 'i1': HEAP8[((ptr)>>0)] = value; break;
      case 'i8': HEAP8[((ptr)>>0)] = value; break;
      case 'i16': HEAP16[((ptr)>>1)] = value; break;
      case 'i32': HEAP32[((ptr)>>2)] = value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math.abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math.min((+(Math.floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((ptr)>>2)] = tempI64[0],HEAP32[(((ptr)+(4))>>2)] = tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)] = value; break;
      case 'double': HEAPF64[((ptr)>>3)] = value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}

/** @param {number} ptr
    @param {string} type
    @param {number|boolean=} noSafe */
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch (type) {
      case 'i1': return HEAP8[((ptr)>>0)];
      case 'i8': return HEAP8[((ptr)>>0)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for getValue: ' + type);
    }
  return null;
}

// end include: runtime_safe_heap.js
// Wasm globals

var wasmMemory;

//========================================
// Runtime essentials
//========================================

// whether we are quitting the application. no code should run after this.
// set in exit() and abort()
var ABORT = false;

// set by exit() and abort().  Passed to 'onExit' handler.
// NOTE: This is also used as the process return code code in shell environments
// but only when noExitRuntime is false.
var EXITSTATUS;

/** @type {function(*, string=)} */
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  var func = Module['_' + ident]; // closure exported function
  assert(func, 'Cannot call unknown function ' + ident + ', make sure it is exported');
  return func;
}

// C calling interface.
/** @param {string|null=} returnType
    @param {Array=} argTypes
    @param {Arguments|Array=} args
    @param {Object=} opts */
function ccall(ident, returnType, argTypes, args, opts) {
  // For fast lookup of conversion functions
  var toC = {
    'string': function(str) {
      var ret = 0;
      if (str !== null && str !== undefined && str !== 0) { // null string
        // at most 4 bytes per UTF-8 code point, +1 for the trailing '\0'
        var len = (str.length << 2) + 1;
        ret = stackAlloc(len);
        stringToUTF8(str, ret, len);
      }
      return ret;
    },
    'array': function(arr) {
      var ret = stackAlloc(arr.length);
      writeArrayToMemory(arr, ret);
      return ret;
    }
  };

  function convertReturnValue(ret) {
    if (returnType === 'string') return UTF8ToString(ret);
    if (returnType === 'boolean') return Boolean(ret);
    return ret;
  }

  var func = getCFunc(ident);
  var cArgs = [];
  var stack = 0;
  if (args) {
    for (var i = 0; i < args.length; i++) {
      var converter = toC[argTypes[i]];
      if (converter) {
        if (stack === 0) stack = stackSave();
        cArgs[i] = converter(args[i]);
      } else {
        cArgs[i] = args[i];
      }
    }
  }
  var ret = func.apply(null, cArgs);
  function onDone(ret) {
    if (stack !== 0) stackRestore(stack);
    return convertReturnValue(ret);
  }

  ret = onDone(ret);
  return ret;
}

/** @param {string=} returnType
    @param {Array=} argTypes
    @param {Object=} opts */
function cwrap(ident, returnType, argTypes, opts) {
  argTypes = argTypes || [];
  // When the function takes numbers and returns a number, we can just return
  // the original function
  var numericArgs = argTypes.every(function(type){ return type === 'number'});
  var numericRet = returnType !== 'string';
  if (numericRet && numericArgs && !opts) {
    return getCFunc(ident);
  }
  return function() {
    return ccall(ident, returnType, argTypes, arguments, opts);
  }
}

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data.
// @allocator: How to allocate memory, see ALLOC_*
/** @type {function((Uint8Array|Array<number>), number)} */
function allocate(slab, allocator) {
  var ret;

  if (allocator == ALLOC_STACK) {
    ret = stackAlloc(slab.length);
  } else {
    ret = abort();;
  }

  if (slab.subarray || slab.slice) {
    HEAPU8.set(/** @type {!Uint8Array} */(slab), ret);
  } else {
    HEAPU8.set(new Uint8Array(slab), ret);
  }
  return ret;
}

// include: runtime_strings.js


// runtime_strings.js: Strings related runtime functions that are part of both MINIMAL_RUNTIME and regular runtime.

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the given array that contains uint8 values, returns
// a copy of that string as a Javascript String object.

var UTF8Decoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf8') : undefined;

/**
 * @param {number} idx
 * @param {number=} maxBytesToRead
 * @return {string}
 */
function UTF8ArrayToString(heap, idx, maxBytesToRead) {
  var endIdx = idx + maxBytesToRead;
  var endPtr = idx;
  // TextDecoder needs to know the byte length in advance, it doesn't stop on null terminator by itself.
  // Also, use the length info to avoid running tiny strings through TextDecoder, since .subarray() allocates garbage.
  // (As a tiny code save trick, compare endPtr against endIdx using a negation, so that undefined means Infinity)
  while (heap[endPtr] && !(endPtr >= endIdx)) ++endPtr;

  if (endPtr - idx > 16 && heap.subarray && UTF8Decoder) {
    return UTF8Decoder.decode(heap.subarray(idx, endPtr));
  } else {
    var str = '';
    // If building with TextDecoder, we have already computed the string length above, so test loop end condition against that
    while (idx < endPtr) {
      // For UTF8 byte structure, see:
      // http://en.wikipedia.org/wiki/UTF-8#Description
      // https://www.ietf.org/rfc/rfc2279.txt
      // https://tools.ietf.org/html/rfc3629
      var u0 = heap[idx++];
      if (!(u0 & 0x80)) { str += String.fromCharCode(u0); continue; }
      var u1 = heap[idx++] & 63;
      if ((u0 & 0xE0) == 0xC0) { str += String.fromCharCode(((u0 & 31) << 6) | u1); continue; }
      var u2 = heap[idx++] & 63;
      if ((u0 & 0xF0) == 0xE0) {
        u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
      } else {
        u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | (heap[idx++] & 63);
      }

      if (u0 < 0x10000) {
        str += String.fromCharCode(u0);
      } else {
        var ch = u0 - 0x10000;
        str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
      }
    }
  }
  return str;
}

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the emscripten HEAP, returns a
// copy of that string as a Javascript String object.
// maxBytesToRead: an optional length that specifies the maximum number of bytes to read. You can omit
//                 this parameter to scan the string until the first \0 byte. If maxBytesToRead is
//                 passed, and the string at [ptr, ptr+maxBytesToReadr[ contains a null byte in the
//                 middle, then the string will cut short at that byte index (i.e. maxBytesToRead will
//                 not produce a string of exact length [ptr, ptr+maxBytesToRead[)
//                 N.B. mixing frequent uses of UTF8ToString() with and without maxBytesToRead may
//                 throw JS JIT optimizations off, so it is worth to consider consistently using one
//                 style or the other.
/**
 * @param {number} ptr
 * @param {number=} maxBytesToRead
 * @return {string}
 */
function UTF8ToString(ptr, maxBytesToRead) {
  return ptr ? UTF8ArrayToString(HEAPU8, ptr, maxBytesToRead) : '';
}

// Copies the given Javascript String object 'str' to the given byte array at address 'outIdx',
// encoded in UTF8 form and null-terminated. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8 to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   heap: the array to copy to. Each index in this array is assumed to be one 8-byte element.
//   outIdx: The starting offset in the array to begin the copying.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array.
//                    This count should include the null terminator,
//                    i.e. if maxBytesToWrite=1, only the null terminator will be written and nothing else.
//                    maxBytesToWrite=0 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8Array(str, heap, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) // Parameter maxBytesToWrite is not optional. Negative values, 0, null, undefined and false each don't write out any bytes.
    return 0;

  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1; // -1 for string null terminator.
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) {
      var u1 = str.charCodeAt(++i);
      u = 0x10000 + ((u & 0x3FF) << 10) | (u1 & 0x3FF);
    }
    if (u <= 0x7F) {
      if (outIdx >= endIdx) break;
      heap[outIdx++] = u;
    } else if (u <= 0x7FF) {
      if (outIdx + 1 >= endIdx) break;
      heap[outIdx++] = 0xC0 | (u >> 6);
      heap[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0xFFFF) {
      if (outIdx + 2 >= endIdx) break;
      heap[outIdx++] = 0xE0 | (u >> 12);
      heap[outIdx++] = 0x80 | ((u >> 6) & 63);
      heap[outIdx++] = 0x80 | (u & 63);
    } else {
      if (outIdx + 3 >= endIdx) break;
      heap[outIdx++] = 0xF0 | (u >> 18);
      heap[outIdx++] = 0x80 | ((u >> 12) & 63);
      heap[outIdx++] = 0x80 | ((u >> 6) & 63);
      heap[outIdx++] = 0x80 | (u & 63);
    }
  }
  // Null-terminate the pointer to the buffer.
  heap[outIdx] = 0;
  return outIdx - startIdx;
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF8 form. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8 to compute the exact number of bytes (excluding null terminator) that this function will write.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8(str, outPtr, maxBytesToWrite) {
  return stringToUTF8Array(str, HEAPU8,outPtr, maxBytesToWrite);
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF8 byte array, EXCLUDING the null terminator byte.
function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) ++len;
    else if (u <= 0x7FF) len += 2;
    else if (u <= 0xFFFF) len += 3;
    else len += 4;
  }
  return len;
}

// end include: runtime_strings.js
// include: runtime_strings_extra.js


// runtime_strings_extra.js: Strings related runtime functions that are available only in regular runtime.

// Given a pointer 'ptr' to a null-terminated ASCII-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function AsciiToString(ptr) {
  var str = '';
  while (1) {
    var ch = HEAPU8[((ptr++)>>0)];
    if (!ch) return str;
    str += String.fromCharCode(ch);
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in ASCII form. The copy will require at most str.length+1 bytes of space in the HEAP.

function stringToAscii(str, outPtr) {
  return writeAsciiToMemory(str, outPtr, false);
}

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

var UTF16Decoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf-16le') : undefined;

function UTF16ToString(ptr, maxBytesToRead) {
  var endPtr = ptr;
  // TextDecoder needs to know the byte length in advance, it doesn't stop on null terminator by itself.
  // Also, use the length info to avoid running tiny strings through TextDecoder, since .subarray() allocates garbage.
  var idx = endPtr >> 1;
  var maxIdx = idx + maxBytesToRead / 2;
  // If maxBytesToRead is not passed explicitly, it will be undefined, and this
  // will always evaluate to true. This saves on code size.
  while (!(idx >= maxIdx) && HEAPU16[idx]) ++idx;
  endPtr = idx << 1;

  if (endPtr - ptr > 32 && UTF16Decoder) {
    return UTF16Decoder.decode(HEAPU8.subarray(ptr, endPtr));
  } else {
    var str = '';

    // If maxBytesToRead is not passed explicitly, it will be undefined, and the for-loop's condition
    // will always evaluate to true. The loop is then terminated on the first null char.
    for (var i = 0; !(i >= maxBytesToRead / 2); ++i) {
      var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
      if (codeUnit == 0) break;
      // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
      str += String.fromCharCode(codeUnit);
    }

    return str;
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16 form. The copy will require at most str.length*4+2 bytes of space in the HEAP.
// Use the function lengthBytesUTF16() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=2, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<2 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF16(str, outPtr, maxBytesToWrite) {
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 2) return 0;
  maxBytesToWrite -= 2; // Null terminator.
  var startPtr = outPtr;
  var numCharsToWrite = (maxBytesToWrite < str.length*2) ? (maxBytesToWrite / 2) : str.length;
  for (var i = 0; i < numCharsToWrite; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[((outPtr)>>1)] = codeUnit;
    outPtr += 2;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[((outPtr)>>1)] = 0;
  return outPtr - startPtr;
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF16(str) {
  return str.length*2;
}

function UTF32ToString(ptr, maxBytesToRead) {
  var i = 0;

  var str = '';
  // If maxBytesToRead is not passed explicitly, it will be undefined, and this
  // will always evaluate to true. This saves on code size.
  while (!(i >= maxBytesToRead / 4)) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0) break;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
  return str;
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32 form. The copy will require at most str.length*4+4 bytes of space in the HEAP.
// Use the function lengthBytesUTF32() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=4, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<4 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF32(str, outPtr, maxBytesToWrite) {
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 4) return 0;
  var startPtr = outPtr;
  var endPtr = startPtr + maxBytesToWrite - 4;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++i);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[((outPtr)>>2)] = codeUnit;
    outPtr += 4;
    if (outPtr + 4 > endPtr) break;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[((outPtr)>>2)] = 0;
  return outPtr - startPtr;
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF32(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i);
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) ++i; // possibly a lead surrogate, so skip over the tail surrogate.
    len += 4;
  }

  return len;
}

// Allocate heap space for a JS string, and write it there.
// It is the responsibility of the caller to free() that memory.
function allocateUTF8(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = abort();;
  if (ret) stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}

// Allocate stack space for a JS string, and write it there.
function allocateUTF8OnStack(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = stackAlloc(size);
  stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}

// Deprecated: This function should not be called because it is unsafe and does not provide
// a maximum length limit of how many bytes it is allowed to write. Prefer calling the
// function stringToUTF8Array() instead, which takes in a maximum length that can be used
// to be secure from out of bounds writes.
/** @deprecated
    @param {boolean=} dontAddNull */
function writeStringToMemory(string, buffer, dontAddNull) {
  warnOnce('writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!');

  var /** @type {number} */ lastChar, /** @type {number} */ end;
  if (dontAddNull) {
    // stringToUTF8Array always appends null. If we don't want to do that, remember the
    // character that existed at the location where the null will be placed, and restore
    // that after the write (below).
    end = buffer + lengthBytesUTF8(string);
    lastChar = HEAP8[end];
  }
  stringToUTF8(string, buffer, Infinity);
  if (dontAddNull) HEAP8[end] = lastChar; // Restore the value under the null character.
}

function writeArrayToMemory(array, buffer) {
  HEAP8.set(array, buffer);
}

/** @param {boolean=} dontAddNull */
function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; ++i) {
    HEAP8[((buffer++)>>0)] = str.charCodeAt(i);
  }
  // Null-terminate the pointer to the HEAP.
  if (!dontAddNull) HEAP8[((buffer)>>0)] = 0;
}

// end include: runtime_strings_extra.js
// Memory management

function alignUp(x, multiple) {
  if (x % multiple > 0) {
    x += multiple - (x % multiple);
  }
  return x;
}

var HEAP,
/** @type {ArrayBuffer} */
  buffer,
/** @type {Int8Array} */
  HEAP8,
/** @type {Uint8Array} */
  HEAPU8,
/** @type {Int16Array} */
  HEAP16,
/** @type {Uint16Array} */
  HEAPU16,
/** @type {Int32Array} */
  HEAP32,
/** @type {Uint32Array} */
  HEAPU32,
/** @type {Float32Array} */
  HEAPF32,
/** @type {Float64Array} */
  HEAPF64;

function updateGlobalBufferAndViews(buf) {
  buffer = buf;
  Module['HEAP8'] = HEAP8 = new Int8Array(buf);
  Module['HEAP16'] = HEAP16 = new Int16Array(buf);
  Module['HEAP32'] = HEAP32 = new Int32Array(buf);
  Module['HEAPU8'] = HEAPU8 = new Uint8Array(buf);
  Module['HEAPU16'] = HEAPU16 = new Uint16Array(buf);
  Module['HEAPU32'] = HEAPU32 = new Uint32Array(buf);
  Module['HEAPF32'] = HEAPF32 = new Float32Array(buf);
  Module['HEAPF64'] = HEAPF64 = new Float64Array(buf);
}

var TOTAL_STACK = 5242880;

var INITIAL_MEMORY = Module['INITIAL_MEMORY'] || 16777216;

// In non-standalone/normal mode, we create the memory here.
// include: runtime_init_memory.js


// Create the wasm memory. (Note: this only applies if IMPORTED_MEMORY is defined)

  if (Module['wasmMemory']) {
    wasmMemory = Module['wasmMemory'];
  } else
  {
    wasmMemory = new WebAssembly.Memory({
      'initial': INITIAL_MEMORY / 65536,
      // In theory we should not need to emit the maximum if we want "unlimited"
      // or 4GB of memory, but VMs error on that atm, see
      // https://github.com/emscripten-core/emscripten/issues/14130
      // And in the pthreads case we definitely need to emit a maximum. So
      // always emit one.
      'maximum': 2147483648 / 65536
    });
  }

if (wasmMemory) {
  buffer = wasmMemory.buffer;
}

// If the user provides an incorrect length, just use that length instead rather than providing the user to
// specifically provide the memory length with Module['INITIAL_MEMORY'].
INITIAL_MEMORY = buffer.byteLength;
updateGlobalBufferAndViews(buffer);

// end include: runtime_init_memory.js

// include: runtime_init_table.js
// In regular non-RELOCATABLE mode the table is exported
// from the wasm module and this will be assigned once
// the exports are available.
var wasmTable;

// end include: runtime_init_table.js
// include: runtime_stack_check.js


// end include: runtime_stack_check.js
// include: runtime_assertions.js


// end include: runtime_assertions.js
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the main() is called

var runtimeInitialized = false;
var runtimeExited = false;
var runtimeKeepaliveCounter = 0;

function keepRuntimeAlive() {
  return noExitRuntime || runtimeKeepaliveCounter > 0;
}

function preRun() {

  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }

  callRuntimeCallbacks(__ATPRERUN__);
}

function initRuntime() {
  runtimeInitialized = true;

  
if (!Module["noFSInit"] && !FS.init.initialized)
  FS.init();
FS.ignorePermissions = false;

TTY.init();
  callRuntimeCallbacks(__ATINIT__);
}

function exitRuntime() {
  runtimeExited = true;
}

function postRun() {

  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }

  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}

function addOnExit(cb) {
}

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}

// include: runtime_math.js


// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/imul

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/fround

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/clz32

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/trunc

// end include: runtime_math.js
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// Module.preRun (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled

function getUniqueRunDependency(id) {
  return id;
}

function addRunDependency(id) {
  runDependencies++;

  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }

}

function removeRunDependency(id) {
  runDependencies--;

  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }

  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data

/** @param {string|number=} what */
function abort(what) {
  {
    if (Module['onAbort']) {
      Module['onAbort'](what);
    }
  }

  what += '';
  err(what);

  ABORT = true;
  EXITSTATUS = 1;

  what = 'abort(' + what + '). Build with -s ASSERTIONS=1 for more info.';

  // Use a wasm runtime error, because a JS error might be seen as a foreign
  // exception, which means we'd run destructors on it. We need the error to
  // simply make the program stop.
  var e = new WebAssembly.RuntimeError(what);

  // Throw the error whether or not MODULARIZE is set because abort is used
  // in code paths apart from instantiation where an exception is expected
  // to be thrown when abort is called.
  throw e;
}

// {{MEM_INITIALIZER}}

// include: memoryprofiler.js


// end include: memoryprofiler.js
// include: URIUtils.js


// Prefix of data URIs emitted by SINGLE_FILE and related options.
var dataURIPrefix = 'data:application/octet-stream;base64,';

// Indicates whether filename is a base64 data URI.
function isDataURI(filename) {
  // Prefix of data URIs emitted by SINGLE_FILE and related options.
  return filename.startsWith(dataURIPrefix);
}

// Indicates whether filename is delivered via file protocol (as opposed to http/https)
function isFileURI(filename) {
  return filename.startsWith('file://');
}

// end include: URIUtils.js
var wasmBinaryFile;
  wasmBinaryFile = 'libflac.wasm';
  if (!isDataURI(wasmBinaryFile)) {
    wasmBinaryFile = locateFile(wasmBinaryFile);
  }

function getBinary(file) {
  try {
    if (file == wasmBinaryFile && wasmBinary) {
      return new Uint8Array(wasmBinary);
    }
    var binary = tryParseAsDataURI(file);
    if (binary) {
      return binary;
    }
    if (readBinary) {
      return readBinary(file);
    } else {
      throw "both async and sync fetching of the wasm failed";
    }
  }
  catch (err) {
    abort(err);
  }
}

function getBinaryPromise() {
  // If we don't have the binary yet, try to to load it asynchronously.
  // Fetch has some additional restrictions over XHR, like it can't be used on a file:// url.
  // See https://github.com/github/fetch/pull/92#issuecomment-140665932
  // Cordova or Electron apps are typically loaded from a file:// url.
  // So use fetch if it is available and the url is not a file, otherwise fall back to XHR.
  if (!wasmBinary && (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER)) {
    if (typeof fetch === 'function'
      && !isFileURI(wasmBinaryFile)
    ) {
      return fetch(wasmBinaryFile, { credentials: 'same-origin' }).then(function(response) {
        if (!response['ok']) {
          throw "failed to load wasm binary file at '" + wasmBinaryFile + "'";
        }
        return response['arrayBuffer']();
      }).catch(function () {
          return getBinary(wasmBinaryFile);
      });
    }
    else {
      if (readAsync) {
        // fetch is not available or url is file => try XHR (readAsync uses XHR internally)
        return new Promise(function(resolve, reject) {
          readAsync(wasmBinaryFile, function(response) { resolve(new Uint8Array(/** @type{!ArrayBuffer} */(response))) }, reject)
        });
      }
    }
  }

  // Otherwise, getBinary should be able to get it synchronously
  return Promise.resolve().then(function() { return getBinary(wasmBinaryFile); });
}

// Create the wasm instance.
// Receives the wasm imports, returns the exports.
function createWasm() {
  // prepare imports
  var info = {
    'env': asmLibraryArg,
    'wasi_snapshot_preview1': asmLibraryArg,
  };
  // Load the wasm module and create an instance of using native support in the JS engine.
  // handle a generated wasm instance, receiving its exports and
  // performing other necessary setup
  /** @param {WebAssembly.Module=} module*/
  function receiveInstance(instance, module) {
    var exports = instance.exports;

    Module['asm'] = exports;

    wasmTable = Module['asm']['__indirect_function_table'];

    addOnInit(Module['asm']['__wasm_call_ctors']);

    removeRunDependency('wasm-instantiate');
  }
  // we can't run yet (except in a pthread, where we have a custom sync instantiator)
  addRunDependency('wasm-instantiate');

  // Prefer streaming instantiation if available.
  function receiveInstantiationResult(result) {
    // 'result' is a ResultObject object which has both the module and instance.
    // receiveInstance() will swap in the exports (to Module.asm) so they can be called
    // TODO: Due to Closure regression https://github.com/google/closure-compiler/issues/3193, the above line no longer optimizes out down to the following line.
    // When the regression is fixed, can restore the above USE_PTHREADS-enabled path.
    receiveInstance(result['instance']);
  }

  function instantiateArrayBuffer(receiver) {
    return getBinaryPromise().then(function(binary) {
      return WebAssembly.instantiate(binary, info);
    }).then(function (instance) {
      return instance;
    }).then(receiver, function(reason) {
      err('failed to asynchronously prepare wasm: ' + reason);

      abort(reason);
    });
  }

  function instantiateAsync() {
    if (!wasmBinary &&
        typeof WebAssembly.instantiateStreaming === 'function' &&
        !isDataURI(wasmBinaryFile) &&
        // Don't use streaming for file:// delivered objects in a webview, fetch them synchronously.
        !isFileURI(wasmBinaryFile) &&
        typeof fetch === 'function') {
      return fetch(wasmBinaryFile, { credentials: 'same-origin' }).then(function (response) {
        var result = WebAssembly.instantiateStreaming(response, info);

        return result.then(
          receiveInstantiationResult,
          function(reason) {
            // We expect the most common failure cause to be a bad MIME type for the binary,
            // in which case falling back to ArrayBuffer instantiation should work.
            err('wasm streaming compile failed: ' + reason);
            err('falling back to ArrayBuffer instantiation');
            return instantiateArrayBuffer(receiveInstantiationResult);
          });
      });
    } else {
      return instantiateArrayBuffer(receiveInstantiationResult);
    }
  }

  // User shell pages can write their own Module.instantiateWasm = function(imports, successCallback) callback
  // to manually instantiate the Wasm module themselves. This allows pages to run the instantiation parallel
  // to any other async startup actions they are performing.
  if (Module['instantiateWasm']) {
    try {
      var exports = Module['instantiateWasm'](info, receiveInstance);
      return exports;
    } catch(e) {
      err('Module.instantiateWasm callback failed with error: ' + e);
      return false;
    }
  }

  instantiateAsync();
  return {}; // no exports yet; we'll fill them in later
}

// Globals used by JS i64 conversions (see makeSetValue)
var tempDouble;
var tempI64;

// === Body ===

var ASM_CONSTS = {
  
};






  function callRuntimeCallbacks(callbacks) {
      while (callbacks.length > 0) {
        var callback = callbacks.shift();
        if (typeof callback == 'function') {
          callback(Module); // Pass the module as the first argument.
          continue;
        }
        var func = callback.func;
        if (typeof func === 'number') {
          if (callback.arg === undefined) {
            wasmTable.get(func)();
          } else {
            wasmTable.get(func)(callback.arg);
          }
        } else {
          func(callback.arg === undefined ? null : callback.arg);
        }
      }
    }

  function demangle(func) {
      return func;
    }

  function demangleAll(text) {
      var regex =
        /\b_Z[\w\d_]+/g;
      return text.replace(regex,
        function(x) {
          var y = demangle(x);
          return x === y ? x : (y + ' [' + x + ']');
        });
    }

  function handleException(e) {
      // Certain exception types we do not treat as errors since they are used for
      // internal control flow.
      // 1. ExitStatus, which is thrown by exit()
      // 2. "unwind", which is thrown by emscripten_unwind_to_js_event_loop() and others
      //    that wish to return to JS event loop.
      if (e instanceof ExitStatus || e == 'unwind') {
        return EXITSTATUS;
      }
      // Anything else is an unexpected exception and we treat it as hard error.
      var toLog = e;
      err('exception thrown: ' + toLog);
      quit_(1, e);
    }

  function jsStackTrace() {
      var error = new Error();
      if (!error.stack) {
        // IE10+ special cases: It does have callstack info, but it is only populated if an Error object is thrown,
        // so try that as a special-case.
        try {
          throw new Error();
        } catch(e) {
          error = e;
        }
        if (!error.stack) {
          return '(no stack trace available)';
        }
      }
      return error.stack.toString();
    }

  function stackTrace() {
      var js = jsStackTrace();
      if (Module['extraStackTrace']) js += '\n' + Module['extraStackTrace']();
      return demangleAll(js);
    }

  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.copyWithin(dest, src, src + num);
    }

  function emscripten_realloc_buffer(size) {
      try {
        // round size grow request up to wasm page size (fixed 64KB per spec)
        wasmMemory.grow((size - buffer.byteLength + 65535) >>> 16); // .grow() takes a delta compared to the previous size
        updateGlobalBufferAndViews(wasmMemory.buffer);
        return 1 /*success*/;
      } catch(e) {
      }
      // implicit 0 return to save code size (caller will cast "undefined" into 0
      // anyhow)
    }
  function _emscripten_resize_heap(requestedSize) {
      var oldSize = HEAPU8.length;
      requestedSize = requestedSize >>> 0;
      // With pthreads, races can happen (another thread might increase the size in between), so return a failure, and let the caller retry.
  
      // Memory resize rules:
      // 1. Always increase heap size to at least the requested size, rounded up to next page multiple.
      // 2a. If MEMORY_GROWTH_LINEAR_STEP == -1, excessively resize the heap geometrically: increase the heap size according to 
      //                                         MEMORY_GROWTH_GEOMETRIC_STEP factor (default +20%),
      //                                         At most overreserve by MEMORY_GROWTH_GEOMETRIC_CAP bytes (default 96MB).
      // 2b. If MEMORY_GROWTH_LINEAR_STEP != -1, excessively resize the heap linearly: increase the heap size by at least MEMORY_GROWTH_LINEAR_STEP bytes.
      // 3. Max size for the heap is capped at 2048MB-WASM_PAGE_SIZE, or by MAXIMUM_MEMORY, or by ASAN limit, depending on which is smallest
      // 4. If we were unable to allocate as much memory, it may be due to over-eager decision to excessively reserve due to (3) above.
      //    Hence if an allocation fails, cut down on the amount of excess growth, in an attempt to succeed to perform a smaller allocation.
  
      // A limit is set for how much we can grow. We should not exceed that
      // (the wasm binary specifies it, so if we tried, we'd fail anyhow).
      // In CAN_ADDRESS_2GB mode, stay one Wasm page short of 4GB: while e.g. Chrome is able to allocate full 4GB Wasm memories, the size will wrap
      // back to 0 bytes in Wasm side for any code that deals with heap sizes, which would require special casing all heap size related code to treat
      // 0 specially.
      var maxHeapSize = 2147483648;
      if (requestedSize > maxHeapSize) {
        return false;
      }
  
      // Loop through potential heap size increases. If we attempt a too eager reservation that fails, cut down on the
      // attempted size and reserve a smaller bump instead. (max 3 times, chosen somewhat arbitrarily)
      for (var cutDown = 1; cutDown <= 4; cutDown *= 2) {
        var overGrownHeapSize = oldSize * (1 + 0.2 / cutDown); // ensure geometric growth
        // but limit overreserving (default to capping at +96MB overgrowth at most)
        overGrownHeapSize = Math.min(overGrownHeapSize, requestedSize + 100663296 );
  
        var newSize = Math.min(maxHeapSize, alignUp(Math.max(requestedSize, overGrownHeapSize), 65536));
  
        var replacement = emscripten_realloc_buffer(newSize);
        if (replacement) {
  
          return true;
        }
      }
      return false;
    }

  var PATH = {splitPath:function(filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function(parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up; up--) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function(path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function(path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function(path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        path = PATH.normalize(path);
        path = path.replace(/\/$/, "");
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function(path) {
        return PATH.splitPath(path)[3];
      },join:function() {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function(l, r) {
        return PATH.normalize(l + '/' + r);
      }};
  
  function getRandomDevice() {
      if (typeof crypto === 'object' && typeof crypto['getRandomValues'] === 'function') {
        // for modern web browsers
        var randomBuffer = new Uint8Array(1);
        return function() { crypto.getRandomValues(randomBuffer); return randomBuffer[0]; };
      } else
      if (ENVIRONMENT_IS_NODE) {
        // for nodejs with or without crypto support included
        try {
          var crypto_module = require('crypto');
          // nodejs has crypto support
          return function() { return crypto_module['randomBytes'](1)[0]; };
        } catch (e) {
          // nodejs doesn't have crypto support
        }
      }
      // we couldn't find a proper implementation, as Math.random() is not suitable for /dev/random, see emscripten-core/emscripten/pull/7096
      return function() { abort("randomDevice"); };
    }
  
  var PATH_FS = {resolve:function() {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            return ''; // an invalid portion invalidates the whole thing
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function(from, to) {
        from = PATH_FS.resolve(from).substr(1);
        to = PATH_FS.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  
  var TTY = {ttys:[],init:function () {
        // https://github.com/emscripten-core/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function() {
        // https://github.com/emscripten-core/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function(dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function(stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(43);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function(stream) {
          // flush any pending line data
          stream.tty.ops.flush(stream.tty);
        },flush:function(stream) {
          stream.tty.ops.flush(stream.tty);
        },read:function(stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(60);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(29);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(6);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function(stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(60);
          }
          try {
            for (var i = 0; i < length; i++) {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            }
          } catch (e) {
            throw new FS.ErrnoError(29);
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function(tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              // we will read data by chunks of BUFSIZE
              var BUFSIZE = 256;
              var buf = Buffer.alloc(BUFSIZE);
              var bytesRead = 0;
  
              try {
                bytesRead = nodeFS.readSync(process.stdin.fd, buf, 0, BUFSIZE, null);
              } catch(e) {
                // Cross-platform differences: on Windows, reading EOF throws an exception, but on other OSes,
                // reading EOF returns 0. Uniformize behavior by treating the EOF exception to return 0.
                if (e.toString().includes('EOF')) bytesRead = 0;
                else throw e;
              }
  
              if (bytesRead > 0) {
                result = buf.slice(0, bytesRead).toString('utf-8');
              } else {
                result = null;
              }
            } else
            if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function(tty, val) {
          if (val === null || val === 10) {
            out(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val); // val == 0 would cut text output off in the middle.
          }
        },flush:function(tty) {
          if (tty.output && tty.output.length > 0) {
            out(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }},default_tty1_ops:{put_char:function(tty, val) {
          if (val === null || val === 10) {
            err(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val);
          }
        },flush:function(tty) {
          if (tty.output && tty.output.length > 0) {
            err(UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }}};
  
  function zeroMemory(address, size) {
      HEAPU8.fill(0, address, address + size);
    }
  
  function alignMemory(size, alignment) {
      return Math.ceil(size / alignment) * alignment;
    }
  function mmapAlloc(size) {
      abort();
    }
  var MEMFS = {ops_table:null,mount:function(mount) {
        return MEMFS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createNode:function(parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(63);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap,
                msync: MEMFS.stream_ops.msync
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            }
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.usedBytes = 0; // The actual number of bytes used in the typed array, as opposed to contents.length which gives the whole capacity.
          // When the byte data of the file is populated, this will point to either a typed array, or a normal JS array. Typed arrays are preferred
          // for performance, and used by default. However, typed arrays are not resizable like normal JS arrays are, so there is a small disk size
          // penalty involved for appending file writes that continuously grow a file similar to std::vector capacity vs used -scheme.
          node.contents = null; 
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
          parent.timestamp = node.timestamp;
        }
        return node;
      },getFileDataAsTypedArray:function(node) {
        if (!node.contents) return new Uint8Array(0);
        if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes); // Make sure to not return excess unused bytes.
        return new Uint8Array(node.contents);
      },expandFileStorage:function(node, newCapacity) {
        var prevCapacity = node.contents ? node.contents.length : 0;
        if (prevCapacity >= newCapacity) return; // No need to expand, the storage was already large enough.
        // Don't expand strictly to the given requested limit if it's only a very small increase, but instead geometrically grow capacity.
        // For small filesizes (<1MB), perform size*2 geometric increase, but for large sizes, do a much more conservative size*1.125 increase to
        // avoid overshooting the allocation cap by a very large margin.
        var CAPACITY_DOUBLING_MAX = 1024 * 1024;
        newCapacity = Math.max(newCapacity, (prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2.0 : 1.125)) >>> 0);
        if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256); // At minimum allocate 256b for each file when expanding.
        var oldContents = node.contents;
        node.contents = new Uint8Array(newCapacity); // Allocate new storage.
        if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0); // Copy old data over to the new storage.
      },resizeFileStorage:function(node, newSize) {
        if (node.usedBytes == newSize) return;
        if (newSize == 0) {
          node.contents = null; // Fully decommit when requesting a resize to zero.
          node.usedBytes = 0;
        } else {
          var oldContents = node.contents;
          node.contents = new Uint8Array(newSize); // Allocate new storage.
          if (oldContents) {
            node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes))); // Copy old data over to the new storage.
          }
          node.usedBytes = newSize;
        }
      },node_ops:{getattr:function(node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function(node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.resizeFileStorage(node, attr.size);
          }
        },lookup:function(parent, name) {
          throw FS.genericErrors[44];
        },mknod:function(parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function(old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(55);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.parent.timestamp = Date.now()
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          new_dir.timestamp = old_node.parent.timestamp;
          old_node.parent = new_dir;
        },unlink:function(parent, name) {
          delete parent.contents[name];
          parent.timestamp = Date.now();
        },rmdir:function(parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(55);
          }
          delete parent.contents[name];
          parent.timestamp = Date.now();
        },readdir:function(node) {
          var entries = ['.', '..'];
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function(parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 /* 0777 */ | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function(node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(28);
          }
          return node.link;
        }},stream_ops:{read:function(stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= stream.node.usedBytes) return 0;
          var size = Math.min(stream.node.usedBytes - position, length);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else {
            for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i];
          }
          return size;
        },write:function(stream, buffer, offset, length, position, canOwn) {
          // If the buffer is located in main memory (HEAP), and if
          // memory can grow, we can't hold on to references of the
          // memory buffer, as they may get invalidated. That means we
          // need to do copy its contents.
          if (buffer.buffer === HEAP8.buffer) {
            canOwn = false;
          }
  
          if (!length) return 0;
          var node = stream.node;
          node.timestamp = Date.now();
  
          if (buffer.subarray && (!node.contents || node.contents.subarray)) { // This write is from a typed array to a typed array?
            if (canOwn) {
              node.contents = buffer.subarray(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (node.usedBytes === 0 && position === 0) { // If this is a simple first write to an empty file, do a fast set since we don't need to care about old data.
              node.contents = buffer.slice(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (position + length <= node.usedBytes) { // Writing to an already allocated and used subrange of the file?
              node.contents.set(buffer.subarray(offset, offset + length), position);
              return length;
            }
          }
  
          // Appending to an existing file and we need to reallocate, or source data did not come as a typed array.
          MEMFS.expandFileStorage(node, position+length);
          if (node.contents.subarray && buffer.subarray) {
            // Use typed array write which is available.
            node.contents.set(buffer.subarray(offset, offset + length), position);
          } else {
            for (var i = 0; i < length; i++) {
             node.contents[position + i] = buffer[offset + i]; // Or fall back to manual write if not.
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position + length);
          return length;
        },llseek:function(stream, offset, whence) {
          var position = offset;
          if (whence === 1) {
            position += stream.position;
          } else if (whence === 2) {
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(28);
          }
          return position;
        },allocate:function(stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length);
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
        },mmap:function(stream, address, length, position, prot, flags) {
          if (address !== 0) {
            // We don't currently support location hints for the address of the mapping
            throw new FS.ErrnoError(28);
          }
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(43);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if (!(flags & 2) && contents.buffer === buffer) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = mmapAlloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(48);
            }
            HEAP8.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        },msync:function(stream, buffer, offset, length, mmapFlags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(43);
          }
          if (mmapFlags & 2) {
            // MAP_PRIVATE calls need not to be synced back to underlying fs
            return 0;
          }
  
          var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
          // should we check if bytesWritten and length are the same?
          return 0;
        }}};
  
  function asyncLoad(url, onload, onerror, noRunDep) {
      var dep = !noRunDep ? getUniqueRunDependency('al ' + url) : '';
      readAsync(url, function(arrayBuffer) {
        assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
        onload(new Uint8Array(arrayBuffer));
        if (dep) removeRunDependency(dep);
      }, function(event) {
        if (onerror) {
          onerror();
        } else {
          throw 'Loading data file "' + url + '" failed.';
        }
      });
      if (dep) addRunDependency(dep);
    }
  var FS = {root:null,mounts:[],devices:{},streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,ErrnoError:null,genericErrors:{},filesystems:null,syncFSRequests:0,lookupPath:function(path, opts) {
        path = PATH_FS.resolve(FS.cwd(), path);
        opts = opts || {};
  
        if (!path) return { path: '', node: null };
  
        var defaults = {
          follow_mount: true,
          recurse_count: 0
        };
        for (var key in defaults) {
          if (opts[key] === undefined) {
            opts[key] = defaults[key];
          }
        }
  
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(32);
        }
  
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
  
        // start at the root
        var current = FS.root;
        var current_path = '/';
  
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
  
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
  
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            if (!islast || (islast && opts.follow_mount)) {
              current = current.mounted.root;
            }
          }
  
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH_FS.resolve(PATH.dirname(current_path), link);
  
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
  
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(32);
              }
            }
          }
        }
  
        return { path: current_path, node: current };
      },getPath:function(node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function(parentid, name) {
        var hash = 0;
  
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function(node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function(node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function(parent, name) {
        var errCode = FS.mayLookup(parent);
        if (errCode) {
          throw new FS.ErrnoError(errCode, parent);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function(parent, name, mode, rdev) {
        var node = new FS.FSNode(parent, name, mode, rdev);
  
        FS.hashAddNode(node);
  
        return node;
      },destroyNode:function(node) {
        FS.hashRemoveNode(node);
      },isRoot:function(node) {
        return node === node.parent;
      },isMountpoint:function(node) {
        return !!node.mounted;
      },isFile:function(mode) {
        return (mode & 61440) === 32768;
      },isDir:function(mode) {
        return (mode & 61440) === 16384;
      },isLink:function(mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function(mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function(mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function(mode) {
        return (mode & 61440) === 4096;
      },isSocket:function(mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"r+":2,"w":577,"w+":578,"a":1089,"a+":1090},modeStringToFlags:function(str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function(flag) {
        var perms = ['r', 'w', 'rw'][flag & 3];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function(node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.includes('r') && !(node.mode & 292)) {
          return 2;
        } else if (perms.includes('w') && !(node.mode & 146)) {
          return 2;
        } else if (perms.includes('x') && !(node.mode & 73)) {
          return 2;
        }
        return 0;
      },mayLookup:function(dir) {
        var errCode = FS.nodePermissions(dir, 'x');
        if (errCode) return errCode;
        if (!dir.node_ops.lookup) return 2;
        return 0;
      },mayCreate:function(dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return 20;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function(dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var errCode = FS.nodePermissions(dir, 'wx');
        if (errCode) {
          return errCode;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return 54;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return 10;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return 31;
          }
        }
        return 0;
      },mayOpen:function(node, flags) {
        if (!node) {
          return 44;
        }
        if (FS.isLink(node.mode)) {
          return 32;
        } else if (FS.isDir(node.mode)) {
          if (FS.flagsToPermissionString(flags) !== 'r' || // opening for write
              (flags & 512)) { // TODO: check for O_SEARCH? (== search for dir only)
            return 31;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function(fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(33);
      },getStream:function(fd) {
        return FS.streams[fd];
      },createStream:function(stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = /** @constructor */ function(){};
          FS.FSStream.prototype = {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          };
        }
        // clone it, so we can return an instance of FSStream
        var newStream = new FS.FSStream();
        for (var p in stream) {
          newStream[p] = stream[p];
        }
        stream = newStream;
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function(fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function(stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function() {
          throw new FS.ErrnoError(70);
        }},major:function(dev) {
        return ((dev) >> 8);
      },minor:function(dev) {
        return ((dev) & 0xff);
      },makedev:function(ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function(dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function(dev) {
        return FS.devices[dev];
      },getMounts:function(mount) {
        var mounts = [];
        var check = [mount];
  
        while (check.length) {
          var m = check.pop();
  
          mounts.push(m);
  
          check.push.apply(check, m.mounts);
        }
  
        return mounts;
      },syncfs:function(populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
  
        FS.syncFSRequests++;
  
        if (FS.syncFSRequests > 1) {
          err('warning: ' + FS.syncFSRequests + ' FS.syncfs operations in flight at once, probably just doing extra work');
        }
  
        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;
  
        function doCallback(errCode) {
          FS.syncFSRequests--;
          return callback(errCode);
        }
  
        function done(errCode) {
          if (errCode) {
            if (!done.errored) {
              done.errored = true;
              return doCallback(errCode);
            }
            return;
          }
          if (++completed >= mounts.length) {
            doCallback(null);
          }
        };
  
        // sync all mounts
        mounts.forEach(function (mount) {
          if (!mount.type.syncfs) {
            return done(null);
          }
          mount.type.syncfs(mount, populate, done);
        });
      },mount:function(type, opts, mountpoint) {
        var root = mountpoint === '/';
        var pseudo = !mountpoint;
        var node;
  
        if (root && FS.root) {
          throw new FS.ErrnoError(10);
        } else if (!root && !pseudo) {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
          mountpoint = lookup.path;  // use the absolute path
          node = lookup.node;
  
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(10);
          }
  
          if (!FS.isDir(node.mode)) {
            throw new FS.ErrnoError(54);
          }
        }
  
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          mounts: []
        };
  
        // create a root node for the fs
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;
  
        if (root) {
          FS.root = mountRoot;
        } else if (node) {
          // set as a mountpoint
          node.mounted = mount;
  
          // add the new mount to the current mount's children
          if (node.mount) {
            node.mount.mounts.push(mount);
          }
        }
  
        return mountRoot;
      },unmount:function (mountpoint) {
        var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
        if (!FS.isMountpoint(lookup.node)) {
          throw new FS.ErrnoError(28);
        }
  
        // destroy the nodes for this mount, and all its child mounts
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);
  
        Object.keys(FS.nameTable).forEach(function (hash) {
          var current = FS.nameTable[hash];
  
          while (current) {
            var next = current.name_next;
  
            if (mounts.includes(current.mount)) {
              FS.destroyNode(current);
            }
  
            current = next;
          }
        });
  
        // no longer a mountpoint
        node.mounted = null;
  
        // remove this mount from the child mounts
        var idx = node.mount.mounts.indexOf(mount);
        node.mount.mounts.splice(idx, 1);
      },lookup:function(parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function(path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        if (!name || name === '.' || name === '..') {
          throw new FS.ErrnoError(28);
        }
        var errCode = FS.mayCreate(parent, name);
        if (errCode) {
          throw new FS.ErrnoError(errCode);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(63);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function(path, mode) {
        mode = mode !== undefined ? mode : 438 /* 0666 */;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function(path, mode) {
        mode = mode !== undefined ? mode : 511 /* 0777 */;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdirTree:function(path, mode) {
        var dirs = path.split('/');
        var d = '';
        for (var i = 0; i < dirs.length; ++i) {
          if (!dirs[i]) continue;
          d += '/' + dirs[i];
          try {
            FS.mkdir(d, mode);
          } catch(e) {
            if (e.errno != 20) throw e;
          }
        }
      },mkdev:function(path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 438 /* 0666 */;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function(oldpath, newpath) {
        if (!PATH_FS.resolve(oldpath)) {
          throw new FS.ErrnoError(44);
        }
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        if (!parent) {
          throw new FS.ErrnoError(44);
        }
        var newname = PATH.basename(newpath);
        var errCode = FS.mayCreate(parent, newname);
        if (errCode) {
          throw new FS.ErrnoError(errCode);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(63);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function(old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
  
        // let the errors from non existant directories percolate up
        lookup = FS.lookupPath(old_path, { parent: true });
        old_dir = lookup.node;
        lookup = FS.lookupPath(new_path, { parent: true });
        new_dir = lookup.node;
  
        if (!old_dir || !new_dir) throw new FS.ErrnoError(44);
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(75);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH_FS.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(28);
        }
        // new path should not be an ancestor of the old path
        relative = PATH_FS.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(55);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var errCode = FS.mayDelete(old_dir, old_name, isdir);
        if (errCode) {
          throw new FS.ErrnoError(errCode);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        errCode = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (errCode) {
          throw new FS.ErrnoError(errCode);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(63);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(10);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          errCode = FS.nodePermissions(old_dir, 'w');
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
      },rmdir:function(path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var errCode = FS.mayDelete(parent, name, true);
        if (errCode) {
          throw new FS.ErrnoError(errCode);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(63);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(10);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
      },readdir:function(path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(54);
        }
        return node.node_ops.readdir(node);
      },unlink:function(path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var errCode = FS.mayDelete(parent, name, false);
        if (errCode) {
          // According to POSIX, we should map EISDIR to EPERM, but
          // we instead do what Linux does (and we must, as we use
          // the musl linux libc).
          throw new FS.ErrnoError(errCode);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(63);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(10);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
      },readlink:function(path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link) {
          throw new FS.ErrnoError(44);
        }
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(28);
        }
        return PATH_FS.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
      },stat:function(path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node) {
          throw new FS.ErrnoError(44);
        }
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(63);
        }
        return node.node_ops.getattr(node);
      },lstat:function(path) {
        return FS.stat(path, true);
      },chmod:function(path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(63);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function(path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function(fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(8);
        }
        FS.chmod(stream.node, mode);
      },chown:function(path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(63);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function(path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function(fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(8);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function(path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(28);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(63);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(31);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(28);
        }
        var errCode = FS.nodePermissions(node, 'w');
        if (errCode) {
          throw new FS.ErrnoError(errCode);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function(fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(8);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(28);
        }
        FS.truncate(stream.node, len);
      },utime:function(path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function(path, flags, mode, fd_start, fd_end) {
        if (path === "") {
          throw new FS.ErrnoError(44);
        }
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 438 /* 0666 */ : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        var created = false;
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(20);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
            created = true;
          }
        }
        if (!node) {
          throw new FS.ErrnoError(44);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // if asked only for a directory, then this must be one
        if ((flags & 65536) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(54);
        }
        // check permissions, if this is not a file we just created now (it is ok to
        // create and write to a file with read-only permissions; it is read-only
        // for later use)
        if (!created) {
          var errCode = FS.mayOpen(node, flags);
          if (errCode) {
            throw new FS.ErrnoError(errCode);
          }
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512 | 131072);
  
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
          }
        }
        return stream;
      },close:function(stream) {
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(8);
        }
        if (stream.getdents) stream.getdents = null; // free readdir state
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
        stream.fd = null;
      },isClosed:function(stream) {
        return stream.fd === null;
      },llseek:function(stream, offset, whence) {
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(8);
        }
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(70);
        }
        if (whence != 0 && whence != 1 && whence != 2) {
          throw new FS.ErrnoError(28);
        }
        stream.position = stream.stream_ops.llseek(stream, offset, whence);
        stream.ungotten = [];
        return stream.position;
      },read:function(stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(28);
        }
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(8);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(8);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(31);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(28);
        }
        var seeking = typeof position !== 'undefined';
        if (!seeking) {
          position = stream.position;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(70);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function(stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(28);
        }
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(8);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(8);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(31);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(28);
        }
        if (stream.seekable && stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var seeking = typeof position !== 'undefined';
        if (!seeking) {
          position = stream.position;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(70);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        return bytesWritten;
      },allocate:function(stream, offset, length) {
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(8);
        }
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(28);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(8);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(43);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(138);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function(stream, address, length, position, prot, flags) {
        // User requests writing to file (prot & PROT_WRITE != 0).
        // Checking if we have permissions to write to the file unless
        // MAP_PRIVATE flag is set. According to POSIX spec it is possible
        // to write to file opened in read-only mode with MAP_PRIVATE flag,
        // as all modifications will be visible only in the memory of
        // the current process.
        if ((prot & 2) !== 0
            && (flags & 2) === 0
            && (stream.flags & 2097155) !== 2) {
          throw new FS.ErrnoError(2);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(2);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.ErrnoError(43);
        }
        return stream.stream_ops.mmap(stream, address, length, position, prot, flags);
      },msync:function(stream, buffer, offset, length, mmapFlags) {
        if (!stream || !stream.stream_ops.msync) {
          return 0;
        }
        return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
      },munmap:function(stream) {
        return 0;
      },ioctl:function(stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(59);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function(path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 0;
        opts.encoding = opts.encoding || 'binary';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = UTF8ArrayToString(buf, 0);
        } else if (opts.encoding === 'binary') {
          ret = buf;
        }
        FS.close(stream);
        return ret;
      },writeFile:function(path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 577;
        var stream = FS.open(path, opts.flags, opts.mode);
        if (typeof data === 'string') {
          var buf = new Uint8Array(lengthBytesUTF8(data)+1);
          var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
          FS.write(stream, buf, 0, actualNumBytes, undefined, opts.canOwn);
        } else if (ArrayBuffer.isView(data)) {
          FS.write(stream, data, 0, data.byteLength, undefined, opts.canOwn);
        } else {
          throw new Error('Unsupported data type');
        }
        FS.close(stream);
      },cwd:function() {
        return FS.currentPath;
      },chdir:function(path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (lookup.node === null) {
          throw new FS.ErrnoError(44);
        }
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(54);
        }
        var errCode = FS.nodePermissions(lookup.node, 'x');
        if (errCode) {
          throw new FS.ErrnoError(errCode);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function() {
        FS.mkdir('/tmp');
        FS.mkdir('/home');
        FS.mkdir('/home/web_user');
      },createDefaultDevices:function() {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function(stream, buffer, offset, length, pos) { return length; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using err() rather than out()
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // setup /dev/[u]random
        var random_device = getRandomDevice();
        FS.createDevice('/dev', 'random', random_device);
        FS.createDevice('/dev', 'urandom', random_device);
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createSpecialDirectories:function() {
        // create /proc/self/fd which allows /proc/self/fd/6 => readlink gives the
        // name of the stream for fd 6 (see test_unistd_ttyname)
        FS.mkdir('/proc');
        var proc_self = FS.mkdir('/proc/self');
        FS.mkdir('/proc/self/fd');
        FS.mount({
          mount: function() {
            var node = FS.createNode(proc_self, 'fd', 16384 | 511 /* 0777 */, 73);
            node.node_ops = {
              lookup: function(parent, name) {
                var fd = +name;
                var stream = FS.getStream(fd);
                if (!stream) throw new FS.ErrnoError(8);
                var ret = {
                  parent: null,
                  mount: { mountpoint: 'fake' },
                  node_ops: { readlink: function() { return stream.path } }
                };
                ret.parent = ret; // make it look like a simple root node
                return ret;
              }
            };
            return node;
          }
        }, {}, '/proc/self/fd');
      },createStandardStreams:function() {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
  
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
  
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 0);
        var stdout = FS.open('/dev/stdout', 1);
        var stderr = FS.open('/dev/stderr', 1);
      },ensureErrnoError:function() {
        if (FS.ErrnoError) return;
        FS.ErrnoError = /** @this{Object} */ function ErrnoError(errno, node) {
          this.node = node;
          this.setErrno = /** @this{Object} */ function(errno) {
            this.errno = errno;
          };
          this.setErrno(errno);
          this.message = 'FS error';
  
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [44].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function() {
        FS.ensureErrnoError();
  
        FS.nameTable = new Array(4096);
  
        FS.mount(MEMFS, {}, '/');
  
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
        FS.createSpecialDirectories();
  
        FS.filesystems = {
          'MEMFS': MEMFS,
        };
      },init:function(input, output, error) {
        FS.init.initialized = true;
  
        FS.ensureErrnoError();
  
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
  
        FS.createStandardStreams();
      },quit:function() {
        FS.init.initialized = false;
        // force-flush all streams, so we get musl std streams printed out
        var fflush = Module['_fflush'];
        if (fflush) fflush(0);
        // close all of our streams
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function(canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },findObject:function(path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          return null;
        }
      },analyzePath:function(path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createPath:function(parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function(parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function(parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 577);
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function(parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(29);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(6);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(29);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },forceLoadFile:function(obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (read_) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(read_(obj.url), true);
            obj.usedBytes = obj.contents.length;
          } catch (e) {
            throw new FS.ErrnoError(29);
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
      },createLazyFile:function(parent, name, url, canRead, canWrite) {
        // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
        /** @constructor */
        function LazyUint8Array() {
          this.lengthKnown = false;
          this.chunks = []; // Loaded chunks. Index is the chunk number
        }
        LazyUint8Array.prototype.get = /** @this{Object} */ function LazyUint8Array_get(idx) {
          if (idx > this.length-1 || idx < 0) {
            return undefined;
          }
          var chunkOffset = idx % this.chunkSize;
          var chunkNum = (idx / this.chunkSize)|0;
          return this.getter(chunkNum)[chunkOffset];
        };
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
          this.getter = getter;
        };
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
          // Find length
          var xhr = new XMLHttpRequest();
          xhr.open('HEAD', url, false);
          xhr.send(null);
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
          var datalength = Number(xhr.getResponseHeader("Content-length"));
          var header;
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
          var usesGzip = (header = xhr.getResponseHeader("Content-Encoding")) && header === "gzip";
  
          var chunkSize = 1024*1024; // Chunk size in bytes
  
          if (!hasByteServing) chunkSize = datalength;
  
          // Function to get a range from the remote URL.
          var doXHR = (function(from, to) {
            if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
            if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
  
            // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, false);
            if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
  
            // Some hints to the browser that we want binary data.
            if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType('text/plain; charset=x-user-defined');
            }
  
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            if (xhr.response !== undefined) {
              return new Uint8Array(/** @type{Array<number>} */(xhr.response || []));
            } else {
              return intArrayFromString(xhr.responseText || '', true);
            }
          });
          var lazyArray = this;
          lazyArray.setDataGetter(function(chunkNum) {
            var start = chunkNum * chunkSize;
            var end = (chunkNum+1) * chunkSize - 1; // including this byte
            end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end);
            }
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
            return lazyArray.chunks[chunkNum];
          });
  
          if (usesGzip || !datalength) {
            // if the server uses gzip or doesn't supply the length, we have to download the whole file to get the (uncompressed) length
            chunkSize = datalength = 1; // this will force getter(0)/doXHR do download the whole file
            datalength = this.getter(0).length;
            chunkSize = datalength;
            out("LazyFiles on gzip forces download of the whole file when length is accessed");
          }
  
          this._length = datalength;
          this._chunkSize = chunkSize;
          this.lengthKnown = true;
        };
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          var lazyArray = new LazyUint8Array();
          Object.defineProperties(lazyArray, {
            length: {
              get: /** @this{Object} */ function() {
                if (!this.lengthKnown) {
                  this.cacheLength();
                }
                return this._length;
              }
            },
            chunkSize: {
              get: /** @this{Object} */ function() {
                if (!this.lengthKnown) {
                  this.cacheLength();
                }
                return this._chunkSize;
              }
            }
          });
  
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
  
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // Add a function that defers querying the file size until it is asked the first time.
        Object.defineProperties(node, {
          usedBytes: {
            get: /** @this {FSNode} */ function() { return this.contents.length; }
          }
        });
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            FS.forceLoadFile(node);
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          FS.forceLoadFile(node);
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function(parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
        Browser.init(); // XXX perhaps this method should move onto Browser?
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH_FS.resolve(PATH.join2(parent, name)) : parent;
        var dep = getUniqueRunDependency('cp ' + fullname); // might have several active requests for the same fullname
        function processData(byteArray) {
          function finish(byteArray) {
            if (preFinish) preFinish();
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency(dep);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency(dep);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency(dep);
        if (typeof url == 'string') {
          asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function() {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function() {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function(paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          out('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function(paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};
  var SYSCALLS = {mappings:{},DEFAULT_POLLMASK:5,umask:511,calculateAt:function(dirfd, path, allowEmpty) {
        if (path[0] === '/') {
          return path;
        }
        // relative path
        var dir;
        if (dirfd === -100) {
          dir = FS.cwd();
        } else {
          var dirstream = FS.getStream(dirfd);
          if (!dirstream) throw new FS.ErrnoError(8);
          dir = dirstream.path;
        }
        if (path.length == 0) {
          if (!allowEmpty) {
            throw new FS.ErrnoError(44);;
          }
          return dir;
        }
        return PATH.join2(dir, path);
      },doStat:function(func, path, buf) {
        try {
          var stat = func(path);
        } catch (e) {
          if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
            // an error occurred while trying to look up the path; we should just report ENOTDIR
            return -54;
          }
          throw e;
        }
        HEAP32[((buf)>>2)] = stat.dev;
        HEAP32[(((buf)+(4))>>2)] = 0;
        HEAP32[(((buf)+(8))>>2)] = stat.ino;
        HEAP32[(((buf)+(12))>>2)] = stat.mode;
        HEAP32[(((buf)+(16))>>2)] = stat.nlink;
        HEAP32[(((buf)+(20))>>2)] = stat.uid;
        HEAP32[(((buf)+(24))>>2)] = stat.gid;
        HEAP32[(((buf)+(28))>>2)] = stat.rdev;
        HEAP32[(((buf)+(32))>>2)] = 0;
        (tempI64 = [stat.size>>>0,(tempDouble=stat.size,(+(Math.abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math.min((+(Math.floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[(((buf)+(40))>>2)] = tempI64[0],HEAP32[(((buf)+(44))>>2)] = tempI64[1]);
        HEAP32[(((buf)+(48))>>2)] = 4096;
        HEAP32[(((buf)+(52))>>2)] = stat.blocks;
        HEAP32[(((buf)+(56))>>2)] = (stat.atime.getTime() / 1000)|0;
        HEAP32[(((buf)+(60))>>2)] = 0;
        HEAP32[(((buf)+(64))>>2)] = (stat.mtime.getTime() / 1000)|0;
        HEAP32[(((buf)+(68))>>2)] = 0;
        HEAP32[(((buf)+(72))>>2)] = (stat.ctime.getTime() / 1000)|0;
        HEAP32[(((buf)+(76))>>2)] = 0;
        (tempI64 = [stat.ino>>>0,(tempDouble=stat.ino,(+(Math.abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math.min((+(Math.floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[(((buf)+(80))>>2)] = tempI64[0],HEAP32[(((buf)+(84))>>2)] = tempI64[1]);
        return 0;
      },doMsync:function(addr, stream, len, flags, offset) {
        var buffer = HEAPU8.slice(addr, addr + len);
        FS.msync(stream, buffer, offset, len, flags);
      },doMkdir:function(path, mode) {
        // remove a trailing slash, if one - /a/b/ has basename of '', but
        // we want to create b in the context of this function
        path = PATH.normalize(path);
        if (path[path.length-1] === '/') path = path.substr(0, path.length-1);
        FS.mkdir(path, mode, 0);
        return 0;
      },doMknod:function(path, mode, dev) {
        // we don't want this in the JS API as it uses mknod to create all nodes.
        switch (mode & 61440) {
          case 32768:
          case 8192:
          case 24576:
          case 4096:
          case 49152:
            break;
          default: return -28;
        }
        FS.mknod(path, mode, dev);
        return 0;
      },doReadlink:function(path, buf, bufsize) {
        if (bufsize <= 0) return -28;
        var ret = FS.readlink(path);
  
        var len = Math.min(bufsize, lengthBytesUTF8(ret));
        var endChar = HEAP8[buf+len];
        stringToUTF8(ret, buf, bufsize+1);
        // readlink is one of the rare functions that write out a C string, but does never append a null to the output buffer(!)
        // stringToUTF8() always appends a null byte, so restore the character under the null byte after the write.
        HEAP8[buf+len] = endChar;
  
        return len;
      },doAccess:function(path, amode) {
        if (amode & ~7) {
          // need a valid mode
          return -28;
        }
        var node;
        var lookup = FS.lookupPath(path, { follow: true });
        node = lookup.node;
        if (!node) {
          return -44;
        }
        var perms = '';
        if (amode & 4) perms += 'r';
        if (amode & 2) perms += 'w';
        if (amode & 1) perms += 'x';
        if (perms /* otherwise, they've just passed F_OK */ && FS.nodePermissions(node, perms)) {
          return -2;
        }
        return 0;
      },doDup:function(path, flags, suggestFD) {
        var suggest = FS.getStream(suggestFD);
        if (suggest) FS.close(suggest);
        return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
      },doReadv:function(stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.read(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
          if (curr < len) break; // nothing more to read
        }
        return ret;
      },doWritev:function(stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.write(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
        }
        return ret;
      },varargs:undefined,get:function() {
        SYSCALLS.varargs += 4;
        var ret = HEAP32[(((SYSCALLS.varargs)-(4))>>2)];
        return ret;
      },getStr:function(ptr) {
        var ret = UTF8ToString(ptr);
        return ret;
      },getStreamFromFD:function(fd) {
        var stream = FS.getStream(fd);
        if (!stream) throw new FS.ErrnoError(8);
        return stream;
      },get64:function(low, high) {
        return low;
      }};
  function _fd_close(fd) {try {
  
      var stream = SYSCALLS.getStreamFromFD(fd);
      FS.close(stream);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
  }

  function _fd_read(fd, iov, iovcnt, pnum) {try {
  
      var stream = SYSCALLS.getStreamFromFD(fd);
      var num = SYSCALLS.doReadv(stream, iov, iovcnt);
      HEAP32[((pnum)>>2)] = num
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
  }

  function _fd_seek(fd, offset_low, offset_high, whence, newOffset) {try {
  
      
      var stream = SYSCALLS.getStreamFromFD(fd);
      var HIGH_OFFSET = 0x100000000; // 2^32
      // use an unsigned operator on low and shift high by 32-bits
      var offset = offset_high * HIGH_OFFSET + (offset_low >>> 0);
  
      var DOUBLE_LIMIT = 0x20000000000000; // 2^53
      // we also check for equality since DOUBLE_LIMIT + 1 == DOUBLE_LIMIT
      if (offset <= -DOUBLE_LIMIT || offset >= DOUBLE_LIMIT) {
        return -61;
      }
  
      FS.llseek(stream, offset, whence);
      (tempI64 = [stream.position>>>0,(tempDouble=stream.position,(+(Math.abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math.min((+(Math.floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((newOffset)>>2)] = tempI64[0],HEAP32[(((newOffset)+(4))>>2)] = tempI64[1]);
      if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null; // reset readdir state
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
  }

  function _fd_write(fd, iov, iovcnt, pnum) {try {
  
      var stream = SYSCALLS.getStreamFromFD(fd);
      var num = SYSCALLS.doWritev(stream, iov, iovcnt);
      HEAP32[((pnum)>>2)] = num
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return e.errno;
  }
  }

  function _setTempRet0(val) {
      setTempRet0(val);
    }

  var FSNode = /** @constructor */ function(parent, name, mode, rdev) {
    if (!parent) {
      parent = this;  // root node sets parent to itself
    }
    this.parent = parent;
    this.mount = parent.mount;
    this.mounted = null;
    this.id = FS.nextInode++;
    this.name = name;
    this.mode = mode;
    this.node_ops = {};
    this.stream_ops = {};
    this.rdev = rdev;
  };
  var readMode = 292/*292*/ | 73/*73*/;
  var writeMode = 146/*146*/;
  Object.defineProperties(FSNode.prototype, {
   read: {
    get: /** @this{FSNode} */function() {
     return (this.mode & readMode) === readMode;
    },
    set: /** @this{FSNode} */function(val) {
     val ? this.mode |= readMode : this.mode &= ~readMode;
    }
   },
   write: {
    get: /** @this{FSNode} */function() {
     return (this.mode & writeMode) === writeMode;
    },
    set: /** @this{FSNode} */function(val) {
     val ? this.mode |= writeMode : this.mode &= ~writeMode;
    }
   },
   isFolder: {
    get: /** @this{FSNode} */function() {
     return FS.isDir(this.mode);
    }
   },
   isDevice: {
    get: /** @this{FSNode} */function() {
     return FS.isChrdev(this.mode);
    }
   }
  });
  FS.FSNode = FSNode;
  FS.staticInit();;
var ASSERTIONS = false;



/** @type {function(string, boolean=, number=)} */
function intArrayFromString(stringy, dontAddNull, length) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy)+1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      if (ASSERTIONS) {
        assert(false, 'Character code ' + chr + ' (' + String.fromCharCode(chr) + ')  at offset ' + i + ' not in 0x00-0xFF.');
      }
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}


// Copied from https://github.com/strophe/strophejs/blob/e06d027/src/polyfills.js#L149

// This code was written by Tyler Akins and has been placed in the
// public domain.  It would be nice if you left this header intact.
// Base64 code from Tyler Akins -- http://rumkin.com

/**
 * Decodes a base64 string.
 * @param {string} input The string to decode.
 */
var decodeBase64 = typeof atob === 'function' ? atob : function (input) {
  var keyStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

  var output = '';
  var chr1, chr2, chr3;
  var enc1, enc2, enc3, enc4;
  var i = 0;
  // remove all characters that are not A-Z, a-z, 0-9, +, /, or =
  input = input.replace(/[^A-Za-z0-9\+\/\=]/g, '');
  do {
    enc1 = keyStr.indexOf(input.charAt(i++));
    enc2 = keyStr.indexOf(input.charAt(i++));
    enc3 = keyStr.indexOf(input.charAt(i++));
    enc4 = keyStr.indexOf(input.charAt(i++));

    chr1 = (enc1 << 2) | (enc2 >> 4);
    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
    chr3 = ((enc3 & 3) << 6) | enc4;

    output = output + String.fromCharCode(chr1);

    if (enc3 !== 64) {
      output = output + String.fromCharCode(chr2);
    }
    if (enc4 !== 64) {
      output = output + String.fromCharCode(chr3);
    }
  } while (i < input.length);
  return output;
};

// Converts a string of base64 into a byte array.
// Throws error on invalid input.
function intArrayFromBase64(s) {
  if (typeof ENVIRONMENT_IS_NODE === 'boolean' && ENVIRONMENT_IS_NODE) {
    var buf = Buffer.from(s, 'base64');
    return new Uint8Array(buf['buffer'], buf['byteOffset'], buf['byteLength']);
  }

  try {
    var decoded = decodeBase64(s);
    var bytes = new Uint8Array(decoded.length);
    for (var i = 0 ; i < decoded.length ; ++i) {
      bytes[i] = decoded.charCodeAt(i);
    }
    return bytes;
  } catch (_) {
    throw new Error('Converti